/*------------------------------------------------------------------------------*
 *	File Name: 	okThemeID.h   													*
 *	Purpose:	Theme IDs														*
 *																				*
 *	Author:		RVD																*
 *  Creation:	10/29/2002 														*
 *  	Copyright (c) Microcal Software Inc. 1996-2002							*
 *																				*
 *	Modification log:                                                        	*
 *	RVD 10/29/2002 QA70-3094 v7.0406 IMPLEMENT_THEME							*
 *	RVD 2/7/2003 ADD_SURFACE													*
 *	RVD 2/10/2003 ADD_XY_DROPLINES												*
 *	RVD 2/11/2003 ADD_SURFACE_NUMERICFORMAT_AND_PROJECTIONS						*
 *	RVD 2/11/2003 ADD_LAYER_LINK												*
 *	RVD 2/24/2003 GROUP_PLOT_NESTER												*
 *	RVD 2/24/2003 ADD_COLORMAP													*
 *	RVD 4/2/2003 QA70-4197 v7.0551 GLOBALIZE_INCREMENTOR						*
 *	RVD 4/21/2003 QA70-4280 v7.0566 NEW_TEXT_BACKGROUND							*
 *	RVD 5/13/2003 QA70-4445 v7.0583 PAGE_EXPORT_SETTINGS						*
 *	RVD 6/30/2003 QA70-4739 v7.0613 THEME_SUPPORT_TEXT_POSITION					*
 *	RVD 7/23/2003 QA70-3745 v7.0631 THEME_ADDITIONAL_WORK						*
 *	RVD 8/7/2003 QA70-4971 v7.0649 MULTI_LEGEND_AUTOUPDATE						*
 *	TD 9-28-03 QA70-5248 CONTOUR_LINES_SHOW_HIDE								*
 *	RVD 10/16/2003 QA70-5367 v7.5721 NEW_WORKBOOK								*
 *	RVD 10/5/2004 QA70-6985 v8.0143 THEME_AXIS_TITLE_OFFSET						*
 *	YuI 11/29/04 v7.5169 QA70-7199 THEME_ACCESS_TO_BOXCHART						*
 *	RVD 1/19/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT							*
 *	RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS							*
 *	RVD 3/29/2005 QA70-7551 v8.0204 POLYLINE_SPAN_LAYER							*
 *	RVD 5/6/2005 v8.0231 WKS_MERGE_FLOAT_CELLS_THEME_ACCESS						*
 *	RVD 5/24/2005 QA70-7759 v8.0240 GRID_BORDER									*
 *	RVD 6/10/2005 v8.0249 REPEATITIVE_STYLES_IN_GRID_THEMES						*
 *	RVD 6/23/2005 v8.0256 QA70-7798 SPAN_RECT_TO_LAYER							*
 *	RVD 7/26/2005 QA70-7714 v8.0275 GRID_VALUE_FORMAT							*
 *	RVD 7/28/2005 QA70-7939 v8.0277 COLUMN_THEME_ACCESS							*
 *	CPY 7/30/05 SHARE_THEME_ID_TO_OC											*
 *	RVD 8/17/2005 v8.0290 THEME_ACCESS_WRAP_TEXT								*
 *	RVD 9/1/2005 QA70-8009 v8.0299 THEME_COMMON_COLORMAP						*
 *	RVD 9/29/2005 v8.0312 THEME_COLORMAP_RESCALE								*
 *	RVD 11/21/2005 QA80-8337 v8.0340 ANCHOR_DELETE_PARENT						*
 *	RVD 1/13/2005 QA80-5356 v8.0356 PLOT_LABELS									*
 *	RVD 2/17/2006 QA70-8359 TABLE_FOOTNOTE										*
 *	RVD 2/24/2006 v8.0369 QA70-7754 ANNOTATIONS									*
 *	CPY 3/3/2006 QA70-6759 v8.0372 PAGE_LEGNED_TAB_OPTIONS_CONSOLIDATE_TO_ENUM	*
 *	RVD 6/6/2006 QA70-8723 CREATE_LINK_TABLE									*
 *	RVD 6/13/2006 QA70-8615 TABLE_HEADER										*
 *	RVD 7/5/2006 EXPAND_SERIES_FILL												*
 *	RVD 7/10/2006 GRID_CNTRL_THEME												*
 *	RVD 7/11/2006 GRID_LABELS_THEME												*
 *	RVD 7/25/2006 QA70-8856 v8.0450 PASTE_TABLE_INTERMEDIATE_WKS				*
 *	RVD 8/8/2006 QA80-8893 v8.0459 COLORMAP_SHOW_ABOVE_LINE_LABEL				*
 *	RVD 8/11/2006 QA80-8896 v8.0461 THEME_ACCESS_GR_SCRIPT						*
 *	CPY 8/14/06 QA80-8896 ADD_KEEPINSIDE_TO_THEME								*
 *	RVD 10/4/2006 QA70-9021 v8.0493 INCREMENT_LIST_STRETCH						*
 *	RVD 10/9/2006 QA80-9020 v8.0494 GLOBAL_RANGE_THEME							*
 *	EJP 2006-10-20 v8.0498 QA70-8741 THEME_ACCESS_COL_CUSTOM_DATE_FORMAT		*
 *	SY 2006-10-19 QA70-9062 v8.0498 NEW_SCALER_GROBJ							*
 *	RVD 11/1/2006 QA70-9092 v8.0504 SPECIAL_POINT_THEME							*
 *	RVD 11/10/2006 QA70-9114 v8.0510 AXIS_STATES								*
 *	CPY 11/17/2006 AXIS_RESCALE_MARGIN											*
 *	RVD 11/22/2006 QA70-9148 v8.0515 IMPLEMENT_RECTINFO							*
 *	RVD 4/4/2007 QA70-9574 GRID_PRINT_SETTINGS									*
 *	RVD 7/6/2007 v8.0656 WKS_ELLIPSIS											*
 *	RVD 7/23/2007 qa70-10093 v8.0666 WKS_READONLY								*
 *	RVD 7/24/2007 qa70-10089 v8.0667 ACCESS_DEFAULT_ROW_HEIGHT_COL_WIDTH		*
 *	RVD 8/9/2007 USER_DEFINED_LABELS											*
 *	AW 08/13/07 QA80-10204 THEME_ACCESS_TO_PAGE_AUTO_LEGEND_AXIS_ITEMS			*
 *	RVD 2/6/2008 qa70-11067 CLEANUP_INCORRECT_MERGED_CELLS						*
 *	RVD 2/26/2008 qa70-11177 THEME_ACCESS_COVER_CELLS							*
 *	RVD 4/4/2008 QA70-11311 v8.0838 WKS_ZOOM									*
 *	RVD 1/23/2009 QA80-13011 PA_MARKER_ACTIVATION								*
 *	RVD 2/17/2009 QA70-13131 ANCHOR_KEY_EVENTS									*
 *	RVD 2/18/2009 qa70-13143 THEME_COLORMAP_FILLCHECK							*
 *	RVD 3/20/2009 qa70-13324 STRING_TICK_LABELS									*
 *	RVD 3/27/2009 QA70-13357 THEME_CUSTOM_TICK_LABELS							*
 *	RVD 3/31/2009 QA70-13368 THEME_CONTOUR_BOUNDARY								*
 *	RVD 4/6/2009 QA70-13417 THEME_SHOW_LAYER_FRAME								*
 *	RVD 6/5/2009 qa70-3745-17 THEME_ADD_TEXT_WHITEOUT							*
 *	EJP 2009-06-16 QA80-13778 THEME_ACCESS_TO_STACK_LINE_PLOTS					*
 *	RVD 7/9/2009 QA70-13828 RECESS_BARS_DRAW_THEME								*
 *	RVD 7/17/2009 QA70-13837 FULL_SCREEN_VIEW_KEEP_ASPECT_RATIO_OPTION			*
 *	RVD 8/20/2009 QA70-14152 SCALER_TEXT_FONT_ATTR_THEME_GUI					*
 *	Kyle 09/07/2009 QA80-14261 COLORMAP_THEME_IMPROVEMENTS						*
 *	Kenny 10/28/2009 QA80-14025 TWO_COLOR_SHADING_2D_3D_BAR_PLOTS				*
 *	Kenny 12/16/2009 QA80-14594-S2 LAYER_BACKGROUND_SHOULD_USE_NEW_GRADIENT_FILL*
 *	Kyle 02/01/2010 QA80-15044 SPEED_MODE_APPLY_TO_GRAPHIC_EXPORT_NEEDS_TO_BE_ACCESSIBLE_FROM_GRAPH_THEME
 *	Kenny 03/02/2010 QA81-15154 IMPLEMENT_THEME_TREE_ACCESS_FOR_LAYER_DATA_DRAWING_OPTIONS*
 *	Kenny 03/02/2010 QA81-15155 IMPLEMENT_THEME_TREE_ACCESS_FOR_SURFACE_SKIPPING_GRID_LINES*
 *	Kenny 03/16/2010 QA81-14570 ADD_NEW_GUI_TO_ADD_XY_VALUES_AS_LABELS_TO_PLOT	*
 *	Kyle 03/17/2010 QA81-14570 THEME_ACCESS_FOR_PLOT_LABEL						*
 *	Kenny 04/14/2010 QA85-14450 3D_PLOT_TRANSPARENCY_SUPPORT					*
 *	Kenny 06/24/2010 ORG-62 TRANSPARENCY_THEME_SUPPORT_FOR_2D_SYMBOL_LINE		*
 *	Kenny 06/24/2010 ORG-63 TRANSPARENCY_THEME_SUPPORT_FOR_2D_COLUMN_BAR_AREA	*
 *	Kenny 06/28/2010 ORG-38 ADD_THEME_ACCESS_SUPPORT_FOR_CURVE_PATTERN_GRADIENT_PROPERTIES*
 *	Kenny 06/29/2010 ORG-43 ADD_THEME_ACCESS_SUPPORT_FOR_PAGE_GRADIENT_PROPERTIES*
 *	Kenny 07/01/2010 ORG-38-P4 ADD_THEME_ACCESS_SUPPORT_FOR_PIE_PATTERN_GRADIENT_PROPERTIES*
 *	Kenny 07/01/2010 ORG-63-P6 TRANSPARENCY_THEME_SUPPORT_FOR_2D_PIE_CHART		*
 *	Kenny 07/02/2010 ORG-463-P1 THEME_ACCESS_FOR_2D_ERROR_BAR					*
 *	Kenny 07/09/2010 ORG-398-P1 THEME_ACCESS_TO_XYY_3D_BAR_FACES_IS_MISSING		*
 *	Kyle 07/14/2010 ORG-571-S1 NO_SELECT_EFFECT_FOR_GRAPH_OBJECT				*
 *	RVD 07/16/2010 ORG-398-P1 PROPER_THEME_ACCESS_TO_XYY_3D_BAR_FACES			*
 *	Kyle 07/16/2010 ORG-584-S2 PREVENT_DB_CLICK_ON_GRAPH_OBJECT					*
 *	Kenny 07/30/2010 ORG-688-P1 THEME_ACCESS_FOR_3D_SIDE_WALLS_TRANSPARENCY		*
 *  Bill 08/03/2010 ORG-688-P3 TRANSPARENCY_THEME_SUPPORT_FOR_CONTOUR_PLOT      *
 *	Kenny 08/09/2010 ORG-688-P4 THEME_ACCESS_FOR_3D_ERROR_BAR					*
 *	Folger 08/10/10 ORG-679-P6 FAILED_TO_COPY_FORMAT_FROM_3DSCATTER_PLOT_COLORMAP
 *	Kenny 08/10/2010 ORG-688-P2 THEME_ACCESS_3DLAYER_PLANES						*
 *	Folger 08/11/10 ORG-705-P4 COLORMAP_FIRST_TICK_IN_THEME						*
 *	Kenny 08/18/2010 ORG-688-P6 THEME_ACCESS_FOR_LAYER_MISCELLANEOUS_TAB		*
 *	Kenny 08/18/2010 ORG-688-P7 THEME_ACCESS_FOR_LAYER_AXIS_TAB					*
 *	Kenny 08/19/2010 ORG-396-P1 THEME_ACCESS_FOR_3D_SCATTER_PROJECTIONS			*
 *	RVD 10/20/2010 org-1224-s2 MODIFY_SKIP_GRIDLINES_ALLOW_MAX					*
 *	Kit 10/22/2010 ORG-1072-P2 ADD_Z_IN_CLIPPING_GROUP							*
 *	Kyle 11/30/2010 ORG-1591-P2 OC_APPLY_PALETTE_SUPPORT_UNDO					*
 *	RVD 1/6/2011 ORG-1853 ADD_LABELS_TO_MARKER									*
 *	Folger 01/17/2011 ORG-1866-S4 MEAN_LINE_STYLE_IN_BOXCHART_SHOULD_BE_CONTROLLED_IN_GROUP_TAB
 *	Hong 1/26/2011 ORG-2124 MARKER_OBJ_CUSTOM_LABEL								*
 *	Kenny 02/22/2011 ORG-2281 DATA_LABELS_IN_3D_SCATTER_PLOTS					*
 *	RVD 2/25/2011 FIX_THEME_DUPLICATE_IDS										*
 *	RVD 2/25/2011 ORG-2245 PRESELECT_LINE_ANCHOR_VERTICAL_TRANSLATE_XF			*
 *	Kenny 03/05/2011 ORG-939-P1 OPTIONS_ON_DATA_TAB_FOR_HISTOGRAM_IS_MISSING_IN_THEME_FORMAT*
 *	Kenny 03/23/2011 ORG-939-P3 OPTIONS_ON_BOX_TAB_FOR_BOX_CHART_IS_MISSING_IN_THEME_FORMAT*
 *	Kit 03/23/2011 ORG-2489-P1 COPY_ERROR_BAR_FORMAT_FAILED						*
 *	Kenny 03/29/2011 ORG-2537-P1 WATERFALL_OFFSET_THEME_ACCESS_MISSING			*
 *	Folger 04/29/2011 ORG-2542-P1 AXIS_CUSTOMIZED_TICKS_THEME_ACCESS			*
 *	Kenny 04/29/2011 ORG-196 THEME_ACCESS_FOR_AXIS_BREAK						*
 *	Kyle 05/09/2011 ORG-2687 THEME_ACCESS_TO_O3DGL_LAYER						*
 *	Kenny 05/20/2011 ORG-2686-S1 IMPLEMENT_3DGL_LINE_OBJECT						*
 *	Kenny 05/25/2011 ORG-2686-S1 IMPLEMENT_3DGL_TEXT_OBJECT						*
 *	RVD 6/1/2011 RENAMED_AXIS_BREAK_KENNY_INTRODUCED							*
 *	Kit 06/09/2011 ORG-2686-S2 IMPLEMENT_3DGROBJ_CONNECT						*
 *	Kit 06/20/2011 ORG-2686-S2 AUTO_POS_ANNOTATION_TEXT_OBJ						*
 *	Kenny 06/24/2011 ORG-2281-P2 O3DGL_DATA_LABEL_THEME_ACCESS					*
 *	Kenny 06/27/2011 ORG-3127 O3DGL_BAR_PLOT_GUI_ACCESS							*
 *	RVD 6/29/2011 ORG-1540 SPIDER_PLOT											*
 *	Folger 08/31/2011 ORG-3685-P1 THEME_ACCESS_FOR_TICK_LABEL_DATASET			*
 *	Folger 09/15/2011 ORG-3297-S6 AXIS_TICK_LABEL_DECIMAL_DIGITS_THEME_ACCESS	*
 *	RVD 9/19/2011 ORG-3747-s1 TICK_LABEL_OPPOSITE								*
 *	RVD 9/21/2011 ORG-3685-p1 FIX_OLD_AXIS_UpdateThemeIDs						*
 *	Kyle 09/27/2011 ORG-3905-P1 AXES_OFFSET_IN_DATA								*
 *	RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE							*
 *	Kenny 11/01/2011 ORG-396-P3 IMPLEMENT_SHOW_PROPERTY_FOR_3D_SCATTER_PROJECTIONS*
 *	RVD 10/28/2011 ORG-3743-s1 SPIDER_SPECIAL_TICKS								*
 *	Folger 11/10/2011 ORG-3962-S1 AXIS_LABEL_CUSTOM_FORMAT_THEME_ACCESS			*
 *	Kenny 12/07/2011 ORG-4543-P1 TRANSPARENCY_PROPERTIES_FOR_SPECIAL_POINT_THEME_ACCESS*
 *	RVD 11/15/2011 ORG-1795 NEW_POLAR_AXES										*
 *	Hong 03/21/2012 ORG-286 OGL_3D_ERR_BAR_SUPPORT_CAP_WIDTH					*
 *	Kyle 04/18/2012 THEME_ACCESS_FOR_AXIS_IN_OPENGL_GRAPH						*
 *	Kyle 04/23/2012 ORG-2638-P9 AXIS_AUTO_SHOW_HIDE_CONTROL						*
 *	Kenny 04/25/2012 ORG-2686-P5 OGL_POLYLINE_THEME_ACCESS						*
 *	RVD 5/4/2012 THEME_AXIS_SHOW_MINOR_LABEL									*
 *	Kyle 05/10/2012 ORG-3115-P1 CONTEXT_MENU_CONTROL_FOR_OPENGL_GRAPH_OBJ		*
 *	Folger 05/14/2012 ORG-4218-P5 AXES_LABEL_DATE_TIME_CUSTOM_DISPLAY			*
 *	RVD 5/14/2012 ORG-5693 THEME_SUPPORT_ASPECT_RATIO_OLD_WKS_PLOT_OBJ			*
 *	Kenny 05/15/2012 ORG-5573-S1 OGL_TEXT_OBJ_COORDINATES_REWORK				*
 *	Kenny 05/28/2012 ORG-5796-P1 THEME_ACCESS_FOR_OPENGL_PLOT					*
 *	Kyle 06/11/2012 ORG-5528-P7 IMPLEMENT_AXIS_LABEL_ALIGNMENT_AND_NEXT_TO_TICKS*
 *	Kyle 06/14/2012 ORG-3116-P7 THEME_ACCESS_TO_DROP_LINE_TO_SURFACE			*
 *	Zech 06/14/2012 ORG-5956-S1 2D_GROBJ_SUPPORT_TRANSPARENCY					*
 *	Kenny 06/18/2012 ORG-5973-P1 OGL_CONTOUR_SMOOTH_FILL_COLOR_THEME_ACCESS		*
 *	Kenny 07/24/2012 ORG-6234-P2 OGL_SURFACE_MISSING_THEME_ACCESS_FOR_ERRBAR_WALL*
 *	Kenny 08/06/2012 ORG-6442-S1 OGL_THEME_ACCESS_FOR_3DBARS					*
 *	Kyle 08/13/2012 ORG-6464-S1 SHOW_ONE_AXIS_SETTINGS_IN_OPENGL_GRAPH			*
 *	Kyle 09/04/2012 ORG-6284 AXIS_PLANES_FRAME_CONTROL_WANTED					*
 *	Kenny 09/11/2012 ORG-6744-P1 OGL_THEME_ACCESS_FOR_MATRIX_XYZ_3D_BARS_PLOT	*
 *------------------------------------------------------------------------------*/

#ifndef	__OKTHEMEID_H__
#define	__OKTHEMEID_H__


typedef enum
{
	OTC_ALL				= 0x10,	// all objects in collection
	OTC_INDEX			= 0x20,	// index field is used
	OTC_COLLECTION		= 0x40,	// node is a collection
	OTC_AXIS			= 0x01,	// node includes axis direction in index byte as well as index
	OTC_GLOBAL			= 0x02,	// node is global
	/// RVD 1/19/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT
	OTC_INDEX1			= 0x04,	// index ex bit 1
	OTC_INDEX2			= 0x08,	// index ex bit 2
	OTC_INDEX_EX		= OTC_INDEX1|OTC_INDEX2,
	/// end WKS_THEME_SUPPORT
	OTC_DO_NOT_USE_IT	= 0x80,	// do not use this bit for storing as INT, as it is a SIGN bit
}	OTHEMECNTRL;

/// RVD 1/19/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT
// increases maximum collection member count to 0x03FF
typedef enum
{
	OTI_OLD_MASK	= 0x00FF,
	OTI_1			= 0x0100,
	OTI_2			= 0x0200,
}	OTHEMEINDEX;

#define	THEME_INDEX_EX1(_index)		(((_index) & OTI_1) ? OTC_INDEX1 : 0)
#define	THEME_INDEX_EX2(_index)		(((_index) & OTI_2) ? OTC_INDEX2 : 0)
#define	THEME_INDEX_EX(_index)		(THEME_INDEX_EX1(_index)|THEME_INDEX_EX2(_index))
/// end WKS_THEME_SUPPORT


#ifdef __AFX_H__	   //----------- CPY 7/30/05 SHARE_THEME_ID_TO_OC

typedef union
{
	DWORD	dw;					// access as a single DWORD
	struct
	{
		WORD	wID;			// IDs, upto 64k, see OTHEMEID
		BYTE	byIndex;		// index, upto 256
		BYTE	byCntrl;		// see OTHEMECNTRL
	}		otk;
}	OTHEMEKEY;


/// RVD 1/19/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT
#define	SET_THEMEKEY_INDEX(_key, _index) \
				(_key).otk.byIndex = OTI_OLD_MASK & (_index), \
				(_key).otk.byCntrl &= ~OTC_INDEX_EX, \
				(_key).otk.byCntrl |= THEME_INDEX_EX1(_index), \
				(_key).otk.byCntrl |= THEME_INDEX_EX2(_index)

#define	GET_THEMEKEY_INDEX(_key) \
				((int) (_key).otk.byIndex | \
				(((_key).otk.byCntrl & OTC_INDEX1) ? OTI_1 : 0) | \
				(((_key).otk.byCntrl & OTC_INDEX2) ? OTI_2 : 0))
/// end WKS_THEME_SUPPORT

#endif //#ifdef __AFX_H__	   //----------- CPY 7/30/05 SHARE_THEME_ID_TO_OC

//////////////////////////////////////////////////////////////////////
// Theme id macros:
#define		THEME_COLLECTION_MEMBERS_HIWORD_MASK				0x00FF

#define		THEME_COLL_BRANCH(_wId)								MAKEDWORD((_wId), MAKEWORD(0, OTC_COLLECTION))
#define		THEME_ALL_BRANCH(_wId)								MAKEDWORD((_wId), MAKEWORD(0, OTC_ALL))
#define		THEME_COLL_MEMBER_BRANCH(_wId, _index)				MAKEDWORD((_wId), MAKEWORD(((BYTE)(_index)), OTC_INDEX|THEME_INDEX_EX(_index)))
#define		THEME_AXIS_MEMBER_BRANCH(_id, _direction, _index)	MAKEDWORD(_id, MAKEWORD(((0x0F & (_direction)) << 4) | (0x0F & (_index)), OTC_INDEX|OTC_AXIS))
#define		THEME_COLL_MEMBER_BRANCH_DEF(_wId)					THEME_COLL_MEMBER_BRANCH((_wId), 0)
#define		THEME_GLOBAL_NODE(_wId)								MAKEDWORD((_wId), MAKEWORD(0, OTC_GLOBAL))

// these are fixed indecies which are small
#define		THEME_FIRST_COLL_MEMBER_BRANCH						1
#define		THEME_SECOND_COLL_MEMBER_BRANCH						2
#define		THEME_THIRD_COLL_MEMBER_BRANCH						3
/// RVD 5/24/2005 QA70-7759 v8.0240 GRID_BORDER
#define		THEME_4th_COLL_MEMBER_BRANCH						4
#define		THEME_5th_COLL_MEMBER_BRANCH						5
#define		THEME_6th_COLL_MEMBER_BRANCH						6
#define		THEME_7th_COLL_MEMBER_BRANCH						7
#define		THEME_8th_COLL_MEMBER_BRANCH						8
/// end GRID_BORDER

#define		THEME_INVALID_COLL_MEMBER_BRANCH					10

#define		IS_THEME_COLL_BRANCH(_dwId)							(((_dwId) & MAKEDWORD_FROM_HIGHEST_BYTE(OTC_COLLECTION)) ? TRUE : FALSE)
#define		IS_THEME_ALL_BRANCH(_dwId)							(((_dwId) & MAKEDWORD_FROM_HIGHEST_BYTE(OTC_ALL)) ? TRUE : FALSE)
#define		IS_THEME_COLL_MEMBER(_dwId)							(((_dwId) & MAKEDWORD_FROM_HIGHEST_BYTE(OTC_INDEX)) ? TRUE : FALSE)
#define		IS_THEME_GLOBAL_NODE(_dwId)							(((_dwId) & MAKEDWORD_FROM_HIGHEST_BYTE(OTC_GLOBAL)) ? TRUE : FALSE)
//  END Theme id macros
////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////////////////////////
//	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//	!!!!!	must increase this by 1 for each new entry in the OTHEMEID	!!!!!
//	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
///////////////////////////////////////////////////////////////////////////////////////////////
//#define		LAST_THEME_ID	0x011b
//#define		LAST_THEME_ID	0x012f		/// RVD 2/7/2003 ADD_SURFACE
//#define		LAST_THEME_ID	0x0135		/// RVD 2/10/2003 ADD_XY_DROPLINES
//#define		LAST_THEME_ID	0x0153		/// RVD 2/11/2003 ADD_SURFACE_NUMERICFORMAT_AND_PROJECTIONS
//#define		LAST_THEME_ID	0x015c		/// RVD 2/11/2003 ADD_LAYER_LINK
//#define		LAST_THEME_ID	0x0160		/// RVD 2/24/2003 GROUP_PLOT_NESTER
//#define		LAST_THEME_ID	0x0208		/// RVD 2/24/2003 ADD_COLORMAP
//#define		LAST_THEME_ID	0x020d		/// RVD 4/2/2003 QA70-4197 v7.0551 GLOBALIZE_INCREMENTOR
//#define		LAST_THEME_ID	0x0248		/// RVD 4/21/2003 QA70-4280 v7.0566 NEW_TEXT_BACKGROUND
//#define		LAST_THEME_ID	0x0255		/// RVD 5/13/2003 QA70-4445 v7.0583 PAGE_EXPORT_SETTINGS
//#define		LAST_THEME_ID	0x026b		/// RVD 6/30/2003 QA70-4739 v7.0613 THEME_SUPPORT_TEXT_POSITION
//#define		LAST_THEME_ID	0x027c		/// RVD 7/23/2003 QA70-3745 v7.0631 THEME_ADDITIONAL_WORK
//#define		LAST_THEME_ID	0x0282		/// RVD 8/7/2003 QA70-4971 v7.0649 MULTI_LEGEND_AUTOUPDATE
//#define		LAST_THEME_ID	0x0284		/// TD 9-28-03 QA70-5248 CONTOUR_LINES_SHOW_HIDE
//#define		LAST_THEME_ID	0x0302		/// RVD 10/16/2003 QA70-5367 v7.5721 NEW_WORKBOOK
//#define		LAST_THEME_ID	0x0304		/// RVD 10/5/2004 QA70-6985 v8.0143 THEME_AXIS_TITLE_OFFSET
//#define		LAST_THEME_ID	0x0330		/// YuI 11/29/04 v7.5169 QA70-7199 THEME_ACCESS_TO_BOXCHART
//#define		LAST_THEME_ID	0x0345		/// RVD 1/19/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT
//#define		LAST_THEME_ID	0x034d		/// RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS
//#define		LAST_THEME_ID	0x034f		/// RVD 3/29/2005 QA70-7551 v8.0204 POLYLINE_SPAN_LAYER
//#define		LAST_THEME_ID	0x0355		/// RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS
//#define		LAST_THEME_ID	0x0366		/// RVD 5/6/2005 v8.0231 WKS_MERGE_FLOAT_CELLS_THEME_ACCESS
//#define		LAST_THEME_ID	0x036c		/// RVD 5/24/2005 QA70-7759 v8.0240 GRID_BORDER
//#define		LAST_THEME_ID	0x0371		/// RVD 6/10/2005 v8.0249 REPEATITIVE_STYLES_IN_GRID_THEMES
//#define		LAST_THEME_ID	0x0372		/// RVD 7/26/2005 QA70-7714 v8.0275 GRID_VALUE_FORMAT
//#define		LAST_THEME_ID	0x037e		/// RVD 7/28/2005 QA70-7939 v8.0277 COLUMN_THEME_ACCESS
//#define		LAST_THEME_ID	0x037f		/// RVD 8/17/2005 v8.0290 THEME_ACCESS_WRAP_TEXT
//#define		LAST_THEME_ID	0x03b9		/// RVD 9/1/2005 QA70-8009 v8.0299 THEME_COMMON_COLORMAP
//#define		LAST_THEME_ID	0x03bd		/// RVD 9/29/2005 v8.0312 THEME_COLORMAP_RESCALE
//#define		LAST_THEME_ID	0x03be		/// RVD 11/21/2005 QA80-8337 v8.0340 ANCHOR_DELETE_PARENT
//#define		LAST_THEME_ID	0x03c3		/// RVD 1/13/2005 QA80-5356 v8.0356 PLOT_LABELS
//#define		LAST_THEME_ID	0x03c8		/// RVD 2/17/2006 QA70-8359 TABLE_FOOTNOTE
//#define		LAST_THEME_ID	0x03cf		/// RVD 2/24/2006 v8.0369 QA70-7754 ANNOTATIONS
//#define		LAST_THEME_ID	0x03d0		/// RVD 5/10/2006 ACCESS_ALLOW_ENTER
//#define		LAST_THEME_ID	0x03d3		/// RVD 6/6/2006 QA70-8723 CREATE_LINK_TABLE
//#define		LAST_THEME_ID	0x03d7		/// RVD 6/13/2006 QA70-8615 TABLE_HEADER
//#define		LAST_THEME_ID	0x03d8		/// RVD 7/5/2006 EXPAND_SERIES_FILL
//#define		LAST_THEME_ID	0x03d9		/// RVD 7/10/2006 GRID_CNTRL_THEME
//#define		LAST_THEME_ID	0x03df		/// RVD 7/11/2006 GRID_LABELS_THEME
//#define		LAST_THEME_ID	0x03e0		/// RVD 7/21/2006 STYLE_CHOICE_LIST
//#define		LAST_THEME_ID	0x03e1		/// RVD 7/25/2006 QA70-8856 v8.0450 PASTE_TABLE_INTERMEDIATE_WKS
//#define		LAST_THEME_ID	0x03e7		/// RVD 8/8/2006 QA80-8893 v8.0459 COLORMAP_SHOW_ABOVE_LINE_LABEL
//#define		LAST_THEME_ID	0x03e9		/// RVD 8/11/2006 QA80-8896 v8.0461 THEME_ACCESS_GR_SCRIPT
//#define		LAST_THEME_ID	0x03ec		///CPY 8/14/06 QA80-8896 ADD_KEEPINSIDE_TO_THEME
//#define		LAST_THEME_ID	0x03ed		/// RVD 10/4/2006 QA70-9021 v8.0493 INCREMENT_LIST_STRETCH
//#define		LAST_THEME_ID	0x03ef			/// RVD 10/9/2006 QA80-9020 v8.0494 GLOBAL_RANGE_THEME
//#define		LAST_THEME_ID	0x03f0			/// EJP 2006-10-20 v8.0498 QA70-8741 THEME_ACCESS_COL_CUSTOM_DATE_FORMAT
//#define		LAST_THEME_ID	0x040a			/// SY 2006-10-19 QA70-9062 v8.0498 NEW_SCALER_GROBJ
//#define		LAST_THEME_ID	0x040d			/// RVD 11/1/2006 QA70-9092 v8.0504 SPECIAL_POINT_THEME
//#define		LAST_THEME_ID	0x040e			/// RVD 11/10/2006 QA70-9114 v8.0510 AXIS_STATES
//#define		LAST_THEME_ID	0x040f				//CPY 11/17/2006 AXIS_RESCALE_MARGIN
//#define		LAST_THEME_ID	0x0416				/// RVD 11/22/2006 QA70-9148 v8.0515 IMPLEMENT_RECTINFO
//#define		LAST_THEME_ID	0x0418				/// RVD 4/4/2007 QA70-9574 GRID_PRINT_SETTINGS
//#define		LAST_THEME_ID	0x0419				/// RVD 7/6/2007 v8.0656 WKS_ELLIPSIS
//#define		LAST_THEME_ID	0x041b				/// RVD 7/23/2007 qa70-10093 v8.0666 WKS_READONLY
//#define		LAST_THEME_ID	0x041d				/// RVD 7/24/2007 qa70-10089 v8.0667 ACCESS_DEFAULT_ROW_HEIGHT_COL_WIDTH
//#define		LAST_THEME_ID	0x041e				//--- CPY 7/31/07 QA70-10134 ROMAN_FOUND_CP_REUSED_ID_ALREADY_USED_LEAD_TO_HONG_REPORTED_SCRIPT_DUMP_ON_THEME_ACCESS
//#define		LAST_THEME_ID	0x041f				/// RVD 8/9/2007 USER_DEFINED_LABELS
//#define		LAST_THEME_ID	0x0421					///AW 08/13/07 QA80-10204 THEME_ACCESS_TO_PAGE_AUTO_LEGEND_AXIS_ITEMS
//#define		LAST_THEME_ID	0x0422					/// RVD 2/6/2008 qa70-11067 CLEANUP_INCORRECT_MERGED_CELLS
//#define		LAST_THEME_ID	0x0428					/// RVD 2/26/2008 qa70-11177 THEME_ACCESS_COVER_CELLS
//#define		LAST_THEME_ID	0x0429					/// RVD 4/4/2008 QA70-11311 v8.0838 WKS_ZOOM
//#define		LAST_THEME_ID	0x042a					/// RVD 1/23/2009 QA80-13011 PA_MARKER_ACTIVATION
//#define		LAST_THEME_ID	0x042c					/// RVD 2/17/2009 QA70-13131 ANCHOR_KEY_EVENTS
//#define		LAST_THEME_ID	0x042f					/// RVD 2/18/2009 qa70-13143 THEME_COLORMAP_FILLCHECK
//#define		LAST_THEME_ID	0x0431					/// RVD 3/20/2009 qa70-13324 STRING_TICK_LABELS
//#define		LAST_THEME_ID	0x043d					/// RVD 3/27/2009 QA70-13357 THEME_CUSTOM_TICK_LABELS
//#define		LAST_THEME_ID	0x0445					/// RVD 3/31/2009 QA70-13368 THEME_CONTOUR_BOUNDARY
//#define		LAST_THEME_ID	0x0446					/// RVD 4/6/2009 QA70-13417 THEME_SHOW_LAYER_FRAME
//#define		LAST_THEME_ID	0x0447					/// RVD 6/5/2009 qa70-3745-17 THEME_ADD_TEXT_WHITEOUT
//#define LAST_THEME_ID	0x044D /// EJP 2009-06-16 QA80-13778 THEME_ACCESS_TO_STACK_LINE_PLOTS
//#define LAST_THEME_ID	0x045a /// RVD 7/9/2009 QA70-13828 RECESS_BARS_DRAW_THEME
//#define LAST_THEME_ID	0x045b /// RVD 7/17/2009 QA70-13837 FULL_SCREEN_VIEW_KEEP_ASPECT_RATIO_OPTION
//#define LAST_THEME_ID	0x044e //---- CPY 7/24/09 MOVE_RECESSION_BAR_TO_82
//#define LAST_THEME_ID	0x0456	/// RVD 8/20/2009 QA70-14152 SCALER_TEXT_FONT_ATTR_THEME_GUI
//#define LAST_THEME_ID	0x0480	///Kyle 09/07/2009 QA80-14261 COLORMAP_THEME_IMPROVEMENTS
//#define LAST_THEME_ID	0x0486	/// Kenny 10/28/2009 QA80-14025 TWO_COLOR_SHADING_2D_3D_BAR_PLOTS
//#define LAST_THEME_ID	0x048a	/// Kenny 12/16/2009 QA80-14594-S2 LAYER_BACKGROUND_SHOULD_USE_NEW_GRADIENT_FILL
//#define LAST_THEME_ID	0x048b	///Kyle 02/01/2010 QA80-15044 SPEED_MODE_APPLY_TO_GRAPHIC_EXPORT_NEEDS_TO_BE_ACCESSIBLE_FROM_GRAPH_THEME
//#define LAST_THEME_ID	0x0491	/// Kenny 03/02/2010 QA81-15154 IMPLEMENT_THEME_TREE_ACCESS_FOR_LAYER_DATA_DRAWING_OPTIONS
//#define LAST_THEME_ID	0x0493	/// Kenny 03/02/2010 QA81-15155 IMPLEMENT_THEME_TREE_ACCESS_FOR_SURFACE_SKIPPING_GRID_LINES
//#define LAST_THEME_ID	0x04a5	/// Kenny 03/16/2010 QA81-14570 ADD_NEW_GUI_TO_ADD_XY_VALUES_AS_LABELS_TO_PLOT
//#define LAST_THEME_ID	0x04a6	/// Kenny 04/14/2010 QA85-14450 3D_PLOT_TRANSPARENCY_SUPPORT
//#define LAST_THEME_ID	0x04c7	///Sophy 5/27/2010 ORG-186 VECTOR_3DVECTOR_3DERROR_THEME_SUPPORT
//#define LAST_THEME_ID	0x04ce	/// Hong 06/03/10 ORG-217 MATRIX_DLG_USE_THEME_ACCESS
//#define LAST_THEME_ID	0x04d4	/// Kenny 06/24/2010 ORG-62 TRANSPARENCY_THEME_SUPPORT_FOR_2D_SYMBOL_LINE
//#define LAST_THEME_ID 0x04d8	/// Kenny 06/28/2010 ORG-38 ADD_THEME_ACCESS_SUPPORT_FOR_CURVE_PATTERN_GRADIENT_PROPERTIES
//#define LAST_THEME_ID 0x04db	/// Kenny 06/29/2010 ORG-43 ADD_THEME_ACCESS_SUPPORT_FOR_PAGE_GRADIENT_PROPERTIES
//#define LAST_THEME_ID 0x04e0	/// Kenny 07/01/2010 ORG-63-P6 TRANSPARENCY_THEME_SUPPORT_FOR_2D_PIE_CHART
//#define LAST_THEME_ID	0x04eb	/// Kenny 07/02/2010 ORG-463-P1 THEME_ACCESS_FOR_2D_ERROR_BAR
//#define LAST_THEME_ID	0x04ee	/// Kenny 07/09/2010 ORG-398-P1 THEME_ACCESS_TO_XYY_3D_BAR_FACES_IS_MISSING
//#define LAST_THEME_ID	0x04f0	/// Kyle 07/14/2010 ORG-571-S1 NO_SELECT_EFFECT_FOR_GRAPH_OBJECT
//#define LAST_THEME_ID	0x04f1	///Kyle 07/16/2010 ORG-584-S2 PREVENT_DB_CLICK_ON_GRAPH_OBJECT
//#define LAST_THEME_ID	0x04f2	/// Kenny 07/30/2010 ORG-688-P1 THEME_ACCESS_FOR_3D_SIDE_WALLS_TRANSPARENCY
//#define LAST_THEME_ID	0x04f3	/// Bill 08/03/2010 ORG-688-P3 TRANSPARENCY_THEME_SUPPORT_FOR_CONTOUR_PLOT
//#define LAST_THEME_ID	0x04fB	/// Kenny 08/09/2010 ORG-688-P4 THEME_ACCESS_FOR_3D_ERROR_BAR
//#define	LAST_THEME_ID 0x0511	///------ Folger 08/10/10 ORG-679-P6 FAILED_TO_COPY_FORMAT_FROM_3DSCATTER_PLOT_COLORMAP
//#define	LAST_THEME_ID 0x0520	/// Kenny 08/10/2010 ORG-688-P2 THEME_ACCESS_3DLAYER_PLANES
//#define	LAST_THEME_ID 0x0526		///------ Folger 08/11/10 ORG-705-P4 COLORMAP_FIRST_TICK_IN_THEME
//#define LAST_THEME_ID	0x052D		/// Kenny 08/18/2010 ORG-688-P6 THEME_ACCESS_FOR_LAYER_MISCELLANEOUS_TAB
//#define LAST_THEME_ID	0x0536		/// Kenny 08/18/2010 ORG-688-P7 THEME_ACCESS_FOR_LAYER_AXIS_TAB
//#define LAST_THEME_ID	0x0538		/// Kenny 08/19/2010 ORG-396-P1 THEME_ACCESS_FOR_3D_SCATTER_PROJECTIONS
//#define LAST_THEME_ID	0x053b		/// ML 8/26/2010 ORG-112-P1 MORE_OLECONTAINER_OBJECT_THEME_WORK
//#define LAST_THEME_ID	0x053c		/// RVD 10/20/2010 org-1224-s2 MODIFY_SKIP_GRIDLINES_ALLOW_MAX
//#define LAST_THEME_ID	0x0546		///Kyle 11/30/2010 ORG-1591-P2 OC_APPLY_PALETTE_SUPPORT_UNDO
//#define LAST_THEME_ID	0x055a		/// RVD 1/6/2011 ORG-1853 ADD_LABELS_TO_MARKER
//#define LAST_THEME_ID	0x055c		///------ Folger 01/17/2011 ORG-1866-S4 MEAN_LINE_STYLE_IN_BOXCHART_SHOULD_BE_CONTROLLED_IN_GROUP_TAB
//#define LAST_THEME_ID	0x055e	/// Kenny 02/22/2011 ORG-2281 DATA_LABELS_IN_3D_SCATTER_PLOTS
//#define LAST_THEME_ID	0x0562	/// RVD 2/25/2011 FIX_THEME_DUPLICATE_IDS
//#define LAST_THEME_ID	0x0563		/// RVD 2/25/2011 ORG-2245 PRESELECT_LINE_ANCHOR_VERTICAL_TRANSLATE_XF
//#define LAST_THEME_ID	0x0569		/// Kenny 03/05/2011 ORG-939-P1 OPTIONS_ON_DATA_TAB_FOR_HISTOGRAM_IS_MISSING_IN_THEME_FORMAT
//#define LAST_THEME_ID	0x0570		/// Kenny 03/23/2011 ORG-939-P3 OPTIONS_ON_BOX_TAB_FOR_BOX_CHART_IS_MISSING_IN_THEME_FORMAT
//#define LAST_THEME_ID 0x0575///-----Kit 03/23/2011 ORG-2489-P1 COPY_ERROR_BAR_FORMAT_FAILED
//#define LAST_THEME_ID	0x0578		/// Kenny 03/29/2011 ORG-2537-P1 WATERFALL_OFFSET_THEME_ACCESS_MISSING
//#define LAST_THEME_ID	0x057a		///------ Folger 04/29/2011 ORG-2542-P1 AXIS_CUSTOMIZED_TICKS_THEME_ACCESS
//#define LAST_THEME_ID	0x0584		/// Kenny 04/29/2011 ORG-196 THEME_ACCESS_FOR_AXIS_BREAK
//#define LAST_THEME_ID	0x0594		///Kyle 05/09/2011 ORG-2687 THEME_ACCESS_TO_O3DGL_LAYER
//#define LAST_THEME_ID	0x0595		/// Kenny 05/20/2011 ORG-2686-S1 IMPLEMENT_3DGL_LINE_OBJECT
//#define LAST_THEME_ID	0x05a1		/// Kenny 05/25/2011 ORG-2686-S1 IMPLEMENT_3DGL_TEXT_OBJECT
//#define LAST_THEME_ID	0x05a2		///-----Kit 06/09/2011 ORG-2686-S2 IMPLEMENT_3DGROBJ_CONNECT
//#define LAST_THEME_ID	0x05a3		///-----Kit 06/20/2011 ORG-2686-S2 AUTO_POS_ANNOTATION_TEXT_OBJ
//#define LAST_THEME_ID	0x05a7		/// Kenny 06/24/2011 ORG-2281-P2 O3DGL_DATA_LABEL_THEME_ACCESS
//#define LAST_THEME_ID	0x05a9		/// Kenny 06/27/2011 ORG-3127 O3DGL_BAR_PLOT_GUI_ACCESS
//#define LAST_THEME_ID	0x05ad		/// RVD 4/20/2011 ORG-1540 SPIDER_PLOT
//#define LAST_THEME_ID	0x05ae		///------ Folger 08/31/2011 ORG-3685-P1 THEME_ACCESS_FOR_TICK_LABEL_DATASET
//#define LAST_THEME_ID	0x05b0		///------ Folger 09/15/2011 ORG-3297-S6 AXIS_TICK_LABEL_DECIMAL_DIGITS_THEME_ACCESS
//#define LAST_THEME_ID	0x05b1		/// RVD 9/19/2011 ORG-3747-s1 TICK_LABEL_OPPOSITE
//#define LAST_THEME_ID	0x05b3		/// RVD 9/21/2011 ORG-3685-p1 FIX_OLD_AXIS_UpdateThemeIDs
//#define LAST_THEME_ID	0x05b4		/// Kyle 09/27/2011 ORG-3905-P1 AXES_OFFSET_IN_DATA
//#define LAST_THEME_ID	0x05b5		/// RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE
//#define LAST_THEME_ID	0x05b6		/// Kenny 11/01/2011 ORG-396-P3 IMPLEMENT_SHOW_PROPERTY_FOR_3D_SCATTER_PROJECTIONS
//#define LAST_THEME_ID	0x05ba		/// RVD 10/28/2011 ORG-3743-s1 SPIDER_SPECIAL_TICKS
//#define LAST_THEME_ID	0x05bb		///------ Folger 11/10/2011 ORG-3962-S1 AXIS_LABEL_CUSTOM_FORMAT_THEME_ACCESS
//#define LAST_THEME_ID	0x05bd		/// Kenny 12/07/2011 ORG-4543-P1 TRANSPARENCY_PROPERTIES_FOR_SPECIAL_POINT_THEME_ACCESS
//#define LAST_THEME_ID	0x05c4		/// RVD 11/15/2011 ORG-1795 NEW_POLAR_AXES
//#define LAST_THEME_ID	0x05c5		/// Hong 03/21/2012 ORG-286 OGL_3D_ERR_BAR_SUPPORT_CAP_WIDTH
//#define LAST_THEME_ID	0x05c7		/// Kyle 04/18/2012 THEME_ACCESS_FOR_AXIS_IN_OPENGL_GRAPH
//#define LAST_THEME_ID	0x05c8		///Kyle 04/23/2012 ORG-2638-P9 AXIS_AUTO_SHOW_HIDE_CONTROL
//#define LAST_THEME_ID	0x05d0		/// Kenny 04/25/2012 ORG-2686-P5 OGL_POLYLINE_THEME_ACCESS
//#define LAST_THEME_ID	0x05d5		/// RVD 5/4/2012 THEME_AXIS_SHOW_MINOR_LABEL
//#define LAST_THEME_ID	0x05d6		///Kyle 05/10/2012 ORG-3115-P1 CONTEXT_MENU_CONTROL_FOR_OPENGL_GRAPH_OBJ
//#define LAST_THEME_ID	0x05d8		///------ Folger 05/14/2012 ORG-4218-P5 AXES_LABEL_DATE_TIME_CUSTOM_DISPLAY
//#define LAST_THEME_ID	0x05d9		/// RVD 5/14/2012 ORG-5693 THEME_SUPPORT_ASPECT_RATIO_OLD_WKS_PLOT_OBJ
//#define LAST_THEME_ID	0x05f4		/// Kenny 05/15/2012 ORG-5573-S1 OGL_TEXT_OBJ_COORDINATES_REWORK
//#define LAST_THEME_ID	0x0603		/// Kenny 05/28/2012 ORG-5796-P1 THEME_ACCESS_FOR_OPENGL_PLOT
//#define LAST_THEME_ID	0x0604		///Kyle 06/11/2012 ORG-5528-P7 IMPLEMENT_AXIS_LABEL_ALIGNMENT_AND_NEXT_TO_TICKS
//#define LAST_THEME_ID	0x0605		///Kyle 06/14/2012 ORG-5528-S8 THEME_ACCESS_TO_MINOR_TICK_LENGTH
//#define LAST_THEME_ID	0x0606		///Kyle 06/14/2012 ORG-3116-P7 THEME_ACCESS_TO_DROP_LINE_TO_SURFACE
//#define LAST_THEME_ID	0x0607		/// Zech 06/14/2012 ORG-5956-S1 2D_GROBJ_SUPPORT_TRANSPARENCY
//#define LAST_THEME_ID	0x060a		/// Kenny 06/18/2012 ORG-5973-P1 OGL_CONTOUR_SMOOTH_FILL_COLOR_THEME_ACCESS
//#define LAST_THEME_ID	0x060c		/// Kenny 07/24/2012 ORG-6234-P2 OGL_SURFACE_MISSING_THEME_ACCESS_FOR_ERRBAR_WALL
//#define LAST_THEME_ID	0x061b		/// Kenny 08/06/2012 ORG-6442-S1 OGL_THEME_ACCESS_FOR_3DBARS
//#define LAST_THEME_ID	0x061c		///Kyle 08/13/2012 ORG-6464-S1 SHOW_ONE_AXIS_SETTINGS_IN_OPENGL_GRAPH
//#define LAST_THEME_ID	0x061d		/// Kenny 08/30/2012 ORG-6393-S1 OGL_OPTION_TO_PUT_LABELS_AT_THE_ENDS_OF_VECTOR_ARROWS
//#define LAST_THEME_ID	0x0622		///Kyle 09/04/2012 ORG-6284 AXIS_PLANES_FRAME_CONTROL_WANTED
#define LAST_THEME_ID	0x0624		/// Kenny 09/11/2012 ORG-6744-P1 OGL_THEME_ACCESS_FOR_MATRIX_XYZ_3D_BARS_PLOT


typedef enum
{
	OTID_INVALID								= 0x0000,		// invalid ID
	OTID_FIRST									= 0x0001,		// first valid ID
	OTID_LAST									= 0xFFF0,		// last valid ID
	OTID_UNKNOWN								= 0xFFFF,		// unknown ID

	//////////////////////////////////////////////////////
	// NO BITS HERE, CONSTANTS SHOULD REALLY BE ENUMERATED
	//////////////////////////////////////////////////////

	OTID_ROOT									= 0x0001,
	OTID_PROJECT								= 0x0002,
	
	OTID_PAGES									= 0x0003,
	OTID_PAGE									= 0x0004,
	OTID_PAGE_SHOW								= 0x0005,
	OTID_PAGE_BACKGROUND						= 0x0006,
	OTID_PAGE_BACKGROUND_BASECOLOR				= 0x0007,
	OTID_PAGE_BACKGROUND_GRADCOLOR				= 0x0008,
	OTID_PAGE_BACKGROUND_GRADCNTRL				= 0x0009,

	/// Kenny 06/29/2010 ORG-43 ADD_THEME_ACCESS_SUPPORT_FOR_PAGE_GRADIENT_PROPERTIES
	OTID_PAGE_BACKGROUND_SHADING_MODE			= 0x04d9,
	OTID_PAGE_BACKGROUND_LIGHTNESS				= 0x04da,
	OTID_PAGE_BACKGROUND_GRADIENT_TYPE			= 0x04db,
	/// End ORG-43 ADD_THEME_ACCESS_SUPPORT_FOR_PAGE_GRADIENT_PROPERTIES

	OTID_PAGE_DIMENSION							= 0x000a,
	OTID_PAGE_DIMENSION_UNITS					= 0x000b,
	OTID_PAGE_DIMENSION_WIDTH					= 0x000c,
	OTID_PAGE_DIMENSION_HEIGHT					= 0x000d,
	OTID_PAGE_DISPLAY							= 0x000e,
	OTID_PAGE_DISPLAY_DATA						= 0x000f,
	OTID_PAGE_DISPLAY_LABELS					= 0x0010,
	OTID_PAGE_DISPLAY_MASTERITEMS				= 0x0011,
	OTID_PAGE_DISPLAY_CONNECTBREAK				= 0x0012,
	OTID_PAGE_DISPLAY_CONNECTDATA				= 0x0013,
	OTID_PAGE_DISPLAY_VIEW						= 0x026c,	/// RVD 7/23/2003 QA70-3745 v7.0631 THEME_ADDITIONAL_WORK
	OTID_PAGE_DISPLAY_SPEED_MODE_FOR_EXPORT		= 0x048b,	///Kyle 02/01/2010 QA80-15044 SPEED_MODE_APPLY_TO_GRAPHIC_EXPORT_NEEDS_TO_BE_ACCESSIBLE_FROM_GRAPH_THEME
	//---- CPY 7/24/09 MOVE_RECESSION_BAR_TO_82
	//OTID_PAGE_FULL_SCREEN_KEEP_ASPECT			= 0x045b,	/// RVD 7/17/2009 QA70-13837 FULL_SCREEN_VIEW_KEEP_ASPECT_RATIO_OPTION
	OTID_PAGE_FULL_SCREEN_KEEP_ASPECT			= 0x044e,
	//----
	/// RVD 5/13/2003 QA70-4445 v7.0583 PAGE_EXPORT_SETTINGS
	OTID_PAGE_PRINTING							= 0x0249,
	OTID_PAGE_PRINTING_PRINTERNAME				= 0x024a,
	OTID_PAGE_PRINTING_DPI						= 0x024b,
	OTID_PAGE_PRINTING_NUMBEROFCOPIES			= 0x024c,
	OTID_PAGE_PRINTING_PAPERSOURCE				= 0x024d,
	OTID_PAGE_EXPORT							= 0x024e,
	OTID_PAGE_EXPORT_AUTO						= 0x024f,
	OTID_PAGE_EXPORT_RATIO						= 0x0250,
	OTID_PAGE_EXPORT_MARGIN						= 0x0251,
	OTID_PAGE_EXPORT_CLIP						= 0x0252,
	OTID_PAGE_EXPORT_ADVANCED					= 0x0253,
	OTID_PAGE_EXPORT_CHANGERESOLUTION			= 0x0254,
	OTID_PAGE_EXPORT_RESOLUTION					= 0x0255,
	/// end PAGE_EXPORT_SETTINGS

	/// RVD 8/7/2003 QA70-4971 v7.0649 MULTI_LEGEND_AUTOUPDATE
	OTID_PAGE_LEGENDS							= 0x027d,
	//----- CPY 3/3/2006 QA70-6759 v8.0372 PAGE_LEGNED_TAB_OPTIONS_CONSOLIDATE_TO_ENUM
//	OTID_PAGE_LEGENDS_FULLDATASETNAME			= 0x027e,
	OTID_PAGE_LEGENDS_TYPE						= 0x027e,
	//-----
	OTID_PAGE_LEGENDS_AUTOUPDATE				= 0x027f,
	OTID_PAGE_LEGENDS_MULTILAYER				= 0x0280,
	OTID_PAGE_LEGENDS_INDICATE					= 0x0281,
	OTID_PAGE_LEGENDS_SYMBOLWIDTH				= 0x0282,
	/// end MULTI_LEGEND_AUTOUPDATE
	//--- CPY 7/31/07 QA70-10134 ROMAN_FOUND_CP_REUSED_ID_ALREADY_USED_LEAD_TO_HONG_REPORTED_SCRIPT_DUMP_ON_THEME_ACCESS
	//OTID_PAGE_LEGENDS_CUSTOMFORMAT				= 0x0283,	 //----- CPY 7/14/2007 QA70-10059 LEGEND_CUSTOM_FORMAT_IN_PAGE
	OTID_PAGE_LEGENDS_CUSTOMFORMAT				= 0x041e,
	//---
	///AW 08/13/07 QA80-10204 THEME_ACCESS_TO_PAGE_AUTO_LEGEND_AXIS_ITEMS
	OTID_PAGE_LEGENDS_SHOW_UNITS				=0x0420,
	OTID_PAGE_LEGENDS_DATA_PLOT_INDEX			=0x0421,
	///END THEME_ACCESS_TO_PAGE_AUTO_LEGEND_AXIS_ITEMS
	///Kyle 09/07/2009 QA80-14261 COLORMAP_THEME_IMPROVEMENTS
	OTID_PAGE_COLORSCALE						= 0x0473,
	OTID_PAGE_COLORSCALE_TEXT_FONT_FACE			= 0x0474,
	OTID_PAGE_COLORSCALE_TEXT_COLOR				= 0x0475,
	OTID_PAGE_COLORSCALE_TEXT_FONT_SIZE			= 0x0476,
	OTID_PAGE_COLORSCALE_TEXT_BOLD				= 0x0477,
	OTID_PAGE_COLORSCALE_TEXT_ITALIC			= 0x0478,
	OTID_PAGE_COLORSCALE_TEXT_UNDERLINE			= 0x0479,
	OTID_PAGE_COLORSCALE_BACKGROUND				= 0x047a,
	OTID_PAGE_COLORSCALE_THICKNESS				= 0x047b,
	OTID_PAGE_COLORSCALE_LABEL_GAP				= 0x047c,
	OTID_PAGE_COLORSCALE_LABEL_SIDE_OFFSET		= 0x047d,
	OTID_PAGE_COLORSCALE_REVERSE_ORDER			= 0x047e,
	OTID_PAGE_COLORSCALE_LABELS_ON_MAJOR		= 0x047f,
	OTID_PAGE_COLORSCALE_INCREMENT				= 0x0480,
	///End COLORMAP_THEME_IMPROVEMENTS
	OTID_LAYERS									= 0x0014,
	OTID_LAYER									= 0x0015,
	OTID_LAYER_SHOW								= 0x0016,
	OTID_LAYER_BACKGROUND						= 0x0017,
	OTID_LAYER_BACKGROUND_COLOR					= 0x0018,

	/// Kenny 12/16/2009 QA80-14594-S2 LAYER_BACKGROUND_SHOULD_USE_NEW_GRADIENT_FILL
	OTID_LAYER_BACKGROUND_SHADING_MODE			= 0x0487,
	OTID_LAYER_BACKGROUND_COLOR2				= 0x0488,
	OTID_LAYER_BACKGROUND_LIGHTNESS				= 0x0489,
	OTID_LAYER_BACKGROUND_GRADIENT_TYPE			= 0x048a,
	/// End QA80-14594-S2 LAYER_BACKGROUND_SHOULD_USE_NEW_GRADIENT_FILL

	OTID_LAYER_BACKGROUND_STYLE					= 0x0019,
	/// RVD 4/21/2003 QA70-4280 v7.0566 NEW_TEXT_BACKGROUND
	OTID_LAYER_BACKGROUND_BOUNDS				= 0x020e,
	OTID_LAYER_BACKGROUND_BOUNDS_LEFT			= 0x020f,
	OTID_LAYER_BACKGROUND_BOUNDS_TOP			= 0x0210,
	OTID_LAYER_BACKGROUND_BOUNDS_RIGHT			= 0x0211,
	OTID_LAYER_BACKGROUND_BOUNDS_BOTTOM			= 0x0212,
	OTID_LAYER_BACKGROUND_BORDER				= 0x0213,
	OTID_LAYER_BACKGROUND_BORDER_COLOR			= 0x0214,
	OTID_LAYER_BACKGROUND_BORDER_WIDTH			= 0x0215,
	OTID_LAYER_BACKGROUND_BORDER_STYLE			= 0x0216,
	OTID_LAYER_BACKGROUND_FILL					= 0x0217,
	OTID_LAYER_BACKGROUND_FILL_COLOR			= 0x0218,
	OTID_LAYER_BACKGROUND_FILL_PATTERN			= 0x0219,
	OTID_LAYER_BACKGROUND_FILL_PATTERN_COLOR	= 0x021a,
	OTID_LAYER_BACKGROUND_FILL_PATTERN_STYLE	= 0x021b,
	OTID_LAYER_BACKGROUND_FILL_PATTERN_WIDTH	= 0x021c,
	OTID_LAYER_BACKGROUND_SHADOW				= 0x021d,
	OTID_LAYER_BACKGROUND_SHADOW_STYLE			= 0x021e,
	OTID_LAYER_BACKGROUND_SHADOW_WIDTH			= 0x021f,
	OTID_LAYER_BACKGROUND_SHADOW_COLOR			= 0x0220,
	/// end NEW_TEXT_BACKGROUND
	OTID_LAYER_DIMENSION						= 0x001a,
	OTID_LAYER_DIMENSION_UNITS					= 0x001b,
	OTID_LAYER_DIMENSION_UNITS_AND_LINK			= 0x015c,
	OTID_LAYER_DIMENSION_LEFT					= 0x001c,
	OTID_LAYER_DIMENSION_TOP					= 0x001d,
	OTID_LAYER_DIMENSION_WIDTH					= 0x001e,
	OTID_LAYER_DIMENSION_HEIGHT					= 0x001f,
	OTID_LAYER_DISPLAY							= 0x0020,
	OTID_LAYER_DISPLAY_FRAME					= 0x0446,	/// RVD 4/6/2009 QA70-13417 THEME_SHOW_LAYER_FRAME
	OTID_LAYER_DISPLAY_DATA						= 0x0021,
	OTID_LAYER_DISPLAY_LABELS					= 0x0022,
	OTID_LAYER_DISPLAY_AXIS_X					= 0x0023,
	OTID_LAYER_DISPLAY_AXIS_Y					= 0x0024,
	OTID_LAYER_DISPLAY_AXIS_Z					= 0x0025,
	/// RVD 7/23/2003 QA70-3745 v7.0631 THEME_ADDITIONAL_WORK
	OTID_LAYER_DISPLAY_SCALE					= 0x026d,
	OTID_LAYER_DISPLAY_FIXED_FACTOR				= 0x026e,
	OTID_LAYER_SPEED							= 0x026f,
	OTID_LAYER_SPEED_WORKSHEET					= 0x0270,
	OTID_LAYER_SPEED_WORKSHEET_MAX				= 0x0271,
	OTID_LAYER_SPEED_MATRIX						= 0x0272,
	OTID_LAYER_SPEED_MATRIX_XMAX				= 0x0273,
	OTID_LAYER_SPEED_MATRIX_YMAX				= 0x0274,
	/// end THEME_ADDITIONAL_WORK

	/// Kenny 03/02/2010 QA81-15154 IMPLEMENT_THEME_TREE_ACCESS_FOR_LAYER_DATA_DRAWING_OPTIONS
	OTID_LAYER_DISPLAY_CLIP_DATA_TO_FRAME				= 0x048c,
	OTID_LAYER_DISPLAY_DATA_ON_TOP_OF_AXES				= 0x048d,
	OTID_LAYER_DISPLAY_GRID_ON_TOP_OF_DATA				= 0x048e,
	OTID_LAYER_DISPLAY_SHOW_POINTS_OUTSIDE_TRIANGLE		= 0x048f,
	OTID_LAYER_DISPLAY_HORIZONTAL_CLIPPING_MARGIN		= 0x0490,
	OTID_LAYER_DISPLAY_VERTICAL_CLIPPING_MARGIN			= 0x0491,
	/// End QA81-15154 IMPLEMENT_THEME_TREE_ACCESS_FOR_LAYER_DATA_DRAWING_OPTIONS

	/// EJP 2009-06-16 QA80-13778 THEME_ACCESS_TO_STACK_LINE_PLOTS
	OTID_LAYER_STACK							= 0x0448,
	OTID_LAYER_STACK_OFFSET_MODE				= 0x0449,
	OTID_LAYER_STACK_OFFSET_CONSTANT			= 0x044A,
	OTID_LAYER_STACK_OFFSET_GAP					= 0x044B,
	OTID_LAYER_STACK_OFFSET_X					= 0x044C,
	OTID_LAYER_STACK_OFFSET_Y					= 0x044D,
	/// end THEME_ACCESS_TO_STACK_LINE_PLOTS

	OTID_LAYER_LINK								= 0x0154,
	OTID_LAYER_LINK_TO							= 0x0155,
	OTID_LAYER_LINK_TO_X						= 0x0156,
	OTID_LAYER_LINK_TO_X_1						= 0x0157,
	OTID_LAYER_LINK_TO_X_2						= 0x0158,
	OTID_LAYER_LINK_TO_Y						= 0x0159,
	OTID_LAYER_LINK_TO_Y_1						= 0x015a,
	OTID_LAYER_LINK_TO_Y_2						= 0x015b,
	/// RVD 1/13/2005 QA80-5356 v8.0356 PLOT_LABELS
	OTID_LAYER_WATERFALL						= 0x03bf,
	OTID_LAYER_WATERFALL_DROPLINE				= 0x03c1,
	OTID_LAYER_WATERFALL_SHOWHIDDEN				= 0x03c2,
	OTID_LAYER_PARAMETER_INDEX					= 0x03c3,
	/// end PLOT_LABELS

	/// Kenny 03/29/2011 ORG-2537-P1 WATERFALL_OFFSET_THEME_ACCESS_MISSING
	OTID_LAYER_WATERFALL_OFFSET_X				= 0x0576,
	OTID_LAYER_WATERFALL_OFFSET_Y				= 0x0577,
	OTID_LAYER_WATERFALL_IN_PLANE_Z_AXIS_TITLE	= 0x0578,
	/// End WATERFALL_OFFSET_THEME_ACCESS_MISSING

	/// RVD 4/4/2007 QA70-9574 GRID_PRINT_SETTINGS
	OTID_LAYER_PRINT							= 0x0417,
	OTID_LAYER_PRINT_CNTRL						= 0x0418,
	/// end GRID_PRINT_SETTINGS

	/// Kenny 08/10/2010 ORG-688-P2 THEME_ACCESS_3DLAYER_PLANES
	OTID_LAYER_PLANES							= 0x0512,
	OTID_LAYER_XY_PLANE_SHOWN					= 0x0513,
	OTID_LAYER_YZ_PLANE_SHOWN					= 0x0514,
	OTID_LAYER_ZX_PLANE_SHOWN					= 0x0515,
	OTID_LAYER_XY_COLOR							= 0x0516,
	OTID_LAYER_YZ_COLOR							= 0x0517,
	OTID_LAYER_ZX_COLOR							= 0x0518,
	OTID_LAYER_XY_POSITION						= 0x0519,
	OTID_LAYER_YZ_POSITION						= 0x051A,
	OTID_LAYER_ZX_POSITION						= 0x051B,
	OTID_LAYER_AUTO_POSITION					= 0x051C,
	OTID_LAYER_ENABLE_CUBE_OUTLINE				= 0x051D,
	OTID_LAYER_CUBE_OUTLINE_TYPE				= 0x061e,		///Kyle 09/04/2012 ORG-6284 AXIS_PLANES_FRAME_CONTROL_WANTED
	OTID_LAYER_CUBE_OUTLINE_COLOR				= 0x051E,
	OTID_LAYER_CUBE_OUTLINE_WIDTH				= 0x051F,
	OTID_LAYER_CUBE_OUTLINE_STYLE				= 0x0520,
	/// End ORG-688-P2 THEME_ACCESS_3DLAYER_PLANES

	///Kyle 09/04/2012 ORG-6284 AXIS_PLANES_FRAME_CONTROL_WANTED
	OTID_LAYER_ENABLE_PLANE_BORDER				= 0x061f,
	OTID_LAYER_PLANE_BORDER_COLOR				= 0x0620,
	OTID_LAYER_PLANE_BORDER_STYLE				= 0x0621,
	OTID_LAYER_PLANE_BORDER_WIDTH				= 0x0622,
	///End AXIS_PLANES_FRAME_CONTROL_WANTED

	///Kyle 05/09/2011 ORG-2687 THEME_ACCESS_TO_O3DGL_LAYER
	OTID_LAYER_XY_PLANE_POS_TYPE				= 0x0589,
	OTID_LAYER_YZ_PLANE_POS_TYPE				= 0x058A,
	OTID_LAYER_ZX_PLANE_POS_TYPE				= 0x058B,

	OTID_LAYER_LIGHTING							= 0x058C,
	OTID_LAYER_LIGHTING_MODE					= 0x058D,
	OTID_LAYER_LIGHTING_DIRECTION_HOR			= 0x058E,
	OTID_LAYER_LIGHTING_DIRECTION_VER			= 0x058F,
	OTID_LAYER_LIGHTING_DYNAMIC_SOURCE			= 0x0590,
	OTID_LAYER_LIGHTING_AMBIENT_COLOR			= 0x0591,
	OTID_LAYER_LIGHTING_DIFFUSE_COLOR			= 0x0592,
	OTID_LAYER_LIGHTING_SPECULAR_COLOR			= 0x0593,
	OTID_LAYER_LIGHTING_SHININESS				= 0x0594,
	///End THEME_ACCESS_TO_O3DGL_LAYER

	/// Kenny 08/18/2010 ORG-688-P6 THEME_ACCESS_FOR_LAYER_MISCELLANEOUS_TAB
	OTID_LAYER_MISC								= 0x0527,
	OTID_LAYER_MISC_X_FROM						= 0x0528,
	OTID_LAYER_MISC_Y_FROM						= 0x0529,
	OTID_LAYER_MISC_X_TO						= 0x052A,
	OTID_LAYER_MISC_Y_TO						= 0x052B,
	OTID_LAYER_MISC_PROJECTION_PERSPECTIVE		= 0x052C,
	OTID_LAYER_MISC_X_Y_CLIPPING				= 0x052D,
	/// End ORG-688-P6 THEME_ACCESS_FOR_LAYER_MISCELLANEOUS_TAB

	/// Kenny 08/18/2010 ORG-688-P7 THEME_ACCESS_FOR_LAYER_AXIS_TAB
	OTID_LAYER_AXIS								= 0x052E,
	OTID_LAYER_AXIS_X_AXIS_LENGTH				= 0x052F,
	OTID_LAYER_AXIS_Y_AXIS_LENGTH				= 0x0530,
	OTID_LAYER_AXIS_Z_AXIS_LENGTH				= 0x0531,
	OTID_LAYER_AXIS_X_ROTATION					= 0x0532,
	OTID_LAYER_AXIS_Y_ROTATION					= 0x0533,
	OTID_LAYER_AXIS_Z_ROTATION					= 0x0534,
	OTID_LAYER_AXIS_PERSPECTIVE_ANGLE			= 0x0535,
	OTID_LAYER_AXIS_ROTATE_LABELS				= 0x0536,
	/// End ORG-688-P7 THEME_ACCESS_FOR_LAYER_AXIS_TAB

	///Kyle 05/09/2011 ORG-2687 THEME_ACCESS_TO_O3DGL_LAYER
	OTID_LAYER_AXIS_AZIMUTH						= 0x0585,
	OTID_LAYER_AXIS_INCLINATION					= 0x0586,
	OTID_LAYER_AXIS_ROLL						= 0x0587,
	OTID_LAYER_AXIS_CAMERA_DISTANCE				= 0x0588,
	///End THEME_ACCESS_TO_O3DGL_LAYER

	///-----Kit 10/22/2010 ORG-1072-P2 ADD_Z_IN_CLIPPING_GROUP
	OTID_LAYER_MISC_Z_FROM						= 0x0537,
	OTID_LAYER_MISC_Z_TO						= 0x0538,
	///-----End ADD_Z_IN_CLIPPING_GROUP

	/// Hong 06/03/10 ORG-217 MATRIX_DLG_USE_THEME_ACCESS
	OTID_MATRIX_AXES_DIMS						= 0x04c7,
	OTID_MATRIX_AXES_DIM						= 0x04c8,
	OTID_MATRIX_AXIS_SIZE						= 0x04c9,
	OTID_MATRIX_AXIS_FIRST						= 0x04ca,
	OTID_MATRIX_AXIS_LAST						= 0x04cb,
	OTID_MATRIX_AXIS_LONGNAME					= 0x04cc,
	OTID_MATRIX_AXIS_UNIT						= 0x04cd,
	OTID_MATRIX_AXIS_COMMENT					= 0x04ce,
	/// end MATRIX_DLG_USE_THEME_ACCESS

	OTID_AXES									= 0x0026,
	OTID_AXIS									= 0x0027,
	//OTID_AXIS_BREAK								= 0x0028,	/// RVD 6/1/2011 RENAMED_AXIS_BREAK_KENNY_INTRODUCED
	OTID_AXIS_LINE								= 0x0028,	/// RVD 6/29/2011 ORG-1540 SPIDER_PLOT
	OTID_AXIS_SCALE								= 0x0029,
	OTID_AXIS_SCALE_FROM						= 0x002a,
	OTID_AXIS_SCALE_TO							= 0x002b,
	OTID_AXIS_SCALE_TYPE						= 0x002c,
	OTID_AXIS_SCALE_RESCALE						= 0x002d,
	OTID_AXIS_SCALE_INCBY						= 0x002e,
	OTID_AXIS_SCALE_INC_VALUE					= 0x002f,
	OTID_AXIS_SCALE_MAJOR_COUNT					= 0x0030,
	OTID_AXIS_SCALE_MINOR_COUNT					= 0x0031,
	OTID_AXIS_SCALE_FIRST_TICK					= 0x0032,
	OTID_AXIS_SCALE_RESCALE_MARGIN				= 0x040f,	///CPY 11/17/2006 AXIS_RESCALE_MARGIN
	///------ Folger 04/29/2011 ORG-2542-P1 AXIS_CUSTOMIZED_TICKS_THEME_ACCESS
	OTID_AXIS_SCALE_USER_MAJOR_TICKS			= 0x0579,
	OTID_AXIS_SCALE_USER_MINOR_TICKS			= 0x057a,
	///------ End AXIS_CUSTOMIZED_TICKS_THEME_ACCESS

	/// RVD 4/20/2011 ORG-1540 SPIDER_PLOT
	OTID_AXES_OFFSET							= 0x05b4,	/// Kyle 09/27/2011 ORG-3905-P1 AXES_OFFSET_IN_DATA
	OTID_AXES_COUNT								= 0x05aa,
	OTID_AXES_CCW								= 0x05ab,
	OTID_AXIS_ANGLE								= 0x05ac,
	OTID_AXIS_TICK_TYPE							= 0x05ad,
	OTID_AXES_INDIVIDUALSCALE					= 0x05b5,	/// RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE
	/// end SPIDER_PLOT

	/// RVD 11/15/2011 ORG-1795 NEW_POLAR_AXES
	OTID_AXIS_POS								= 0x05be,
	OTID_AXIS_CROP_UNITS						= 0x05bf,
	OTID_AXIS_CROP_LEFT							= 0x05c0,
	OTID_AXIS_CROP_TOP							= 0x05c1,
	OTID_AXIS_CROP_WIDTH						= 0x05c2,
	OTID_AXIS_CROP_HEIGHT						= 0x05c3,
	OTID_AXIS_CROP								= 0x05c4,
	/// end NEW_POLAR_AXES

	/// RVD 10/28/2011 ORG-3743-s1 SPIDER_SPECIAL_TICKS
	OTID_AXIS_SPECIALTICKS						= 0x05b7,
	OTID_AXIS_SPECIALTICKS_TYPES				= 0x05b8,
	OTID_AXIS_SPECIALTICKS_VALUES				= 0x05b9,
	OTID_AXIS_SPECIALTICKS_LABELS				= 0x05ba,
	/// end SPIDER_SPECIAL_TICKS

	///Kyle 04/18/2012 THEME_ACCESS_FOR_AXIS_IN_OPENGL_GRAPH
	OTID_AXIS_MAJOR_MINOR						= 0x05c6,
	OTID_AXIS_MAJOR_MINOR_COLL					= 0x05c7,
	///End THEME_ACCESS_FOR_AXIS_IN_OPENGL_GRAPH

	OTID_AXIS_ADDITIONAL						= 0x0033,
	OTID_AXIS_ADDITIONAL_OPPOSITE_LINE			= 0x0034,
	OTID_AXIS_ADDITIONAL_ZERO_LINE				= 0x0035,
	OTID_AXIS_STATES							= 0x040e,	/// RVD 11/10/2006 QA70-9114 v8.0510 AXIS_STATES
	OTID_AXIS_AUTO_HIDE							= 0x05c8,	///Kyle 04/23/2012 ORG-2638-P9 AXIS_AUTO_SHOW_HIDE_CONTROL
	OTID_AXIS_SHARE_FIRST_AXIS					= 0x061c,	///Kyle 08/13/2012 ORG-6464-S1 SHOW_ONE_AXIS_SETTINGS_IN_OPENGL_GRAPH
	OTID_AXIS_TICKS								= 0x0036,
	OTID_AXIS_TICK								= 0x0037,
	OTID_AXIS_TICK_SHOW							= 0x0038,
	OTID_AXIS_TICK_MINOR						= 0x0039,
	OTID_AXIS_TICK_MAJOR						= 0x003a,
	OTID_AXIS_TICK_COLOR						= 0x003b,
	OTID_AXIS_TICK_STYLE						= 0x003c,
	OTID_AXIS_TICK_WIDTH						= 0x003d,
	OTID_AXIS_TICK_LENGTH						= 0x003e,
	OTID_AXIS_TICK_MINOR_LENGTH					= 0x0605,	///Kyle 06/14/2012 ORG-5528-S8 THEME_ACCESS_TO_MINOR_TICK_LENGTH
	/// RVD 7/23/2003 QA70-3745 v7.0631 THEME_ADDITIONAL_WORK
	OTID_AXIS_TICK_POSITION						= 0x0275,
	OTID_AXIS_TICK_OFFSET						= 0x0276,
	/// end THEME_ADDITIONAL_WORK
	OTID_AXIS_GRIDS								= 0x003f,
	OTID_AXIS_GRID								= 0x0040,
	OTID_AXIS_GRID_SHOW							= 0x0041,
	OTID_AXIS_GRID_COLOR						= 0x0042,
	OTID_AXIS_GRID_STYLE						= 0x0043,
	OTID_AXIS_GRID_WIDTH						= 0x0044,
	OTID_AXIS_LABELS							= 0x0045,
	OTID_AXIS_LABEL								= 0x0046,
	OTID_AXIS_LABEL_SHOW						= 0x0047,
	/// RVD 5/4/2012 THEME_AXIS_SHOW_MINOR_LABEL
	OTID_AXIS_LABEL_SHOW_MINOR					= 0x05d1,
	OTID_AXIS_LABEL_MINOR_ON_MAJOR				= 0x05d2,
	OTID_AXIS_LABEL_SHOW_PLUS					= 0x05d3,
	OTID_AXIS_LABEL_SHOW_MINUS					= 0x05d4,
	OTID_AXIS_LABEL_MAJOR_OFFSET				= 0x05d5,
	/// end THEME_AXIS_SHOW_MINOR_LABEL
	OTID_AXIS_LABEL_COLOR						= 0x0048,
	/// RVD 3/20/2009 qa70-13324 STRING_TICK_LABELS
	OTID_AXIS_LABEL_STRING						= 0x0430,
	OTID_AXIS_LABEL_FORMULA						= 0x0431,
	/// end STRING_TICK_LABELS
	OTID_AXIS_LABEL_DIVIDE_BY_FACTOR			= 0x0049,
	OTID_AXIS_LABEL_PREFIX						= 0x004a,
	OTID_AXIS_LABEL_SUFFIX						= 0x004b,
	OTID_AXIS_LABEL_TYPE						= 0x0115,
	OTID_AXIS_LABEL_NUMERIC						= 0x0116,
	OTID_AXIS_LABEL_MONTH						= 0x0117,
	OTID_AXIS_LABEL_DAY							= 0x0118,
	OTID_AXIS_LABEL_TIME						= 0x0119,
	OTID_AXIS_LABEL_DATE						= 0x011a,
	/// RVD 7/23/2003 QA70-3745 v7.0631 THEME_ADDITIONAL_WORK
	OTID_AXIS_LABEL_ANGLE						= 0x0277,
	OTID_AXIS_LABEL_XOFFSET						= 0x0278,
	OTID_AXIS_LABEL_YOFFSET						= 0x0279,
	/// end THEME_ADDITIONAL_WORK
	OTID_AXIS_LABEL_FONT						= 0x004c,
	OTID_AXIS_LABEL_FONT_FACE					= 0x004d,
	OTID_AXIS_LABEL_FONT_SIZE					= 0x004e,
	OTID_AXIS_LABEL_FONT_BOLD					= 0x004f,
	OTID_AXIS_LABEL_FONT_ITALIC					= 0x0050,
	OTID_AXIS_LABEL_FONT_UNDERLINE				= 0x0051,
	/// RVD 3/27/2009 QA70-13357 THEME_CUSTOM_TICK_LABELS
	OTID_AXIS_LABEL_ALIGN						= 0x0432,
	OTID_AXIS_LABEL_STAY_WITH_TICKS				= 0x0604,	///Kyle 06/11/2012 ORG-5528-P7 IMPLEMENT_AXIS_LABEL_ALIGNMENT_AND_NEXT_TO_TICKS
	OTID_AXIS_LABEL_CUSTOM						= 0x0433,
	OTID_AXIS_LABEL_CUSTOM_BEGIN				= 0x0434,
	OTID_AXIS_LABEL_CUSTOM_BEGIN_TYPE			= 0x0435,
	OTID_AXIS_LABEL_CUSTOM_BEGIN_LABEL			= 0x0436,
	OTID_AXIS_LABEL_CUSTOM_END					= 0x0437,
	OTID_AXIS_LABEL_CUSTOM_END_TYPE				= 0x0438,
	OTID_AXIS_LABEL_CUSTOM_END_LABEL			= 0x0439,
	OTID_AXIS_LABEL_CUSTOM_SPECIAL				= 0x043a,
	OTID_AXIS_LABEL_CUSTOM_SPECIAL_TYPE			= 0x043b,
	OTID_AXIS_LABEL_CUSTOM_SPECIAL_LABEL		= 0x043c,
	OTID_AXIS_LABEL_CUSTOM_SPECIAL_VALUE		= 0x043d,
	/// end THEME_CUSTOM_TICK_LABELS
	///------ Folger 08/31/2011 ORG-3685-P1 THEME_ACCESS_FOR_TICK_LABEL_DATASET
	OTID_AXIS_LABEL_DATASET_NAME				= 0x05ae,
	///------ End THEME_ACCESS_FOR_TICK_LABEL_DATASET
	///------ Folger 09/15/2011 ORG-3297-S6 AXIS_TICK_LABEL_DECIMAL_DIGITS_THEME_ACCESS
	OTID_AXIS_LABEL_MANUAL_DEC					= 0x05af,
	OTID_AXIS_LABEL_DEC_DIGITS					= 0x05b0,
	///------ End AXIS_TICK_LABEL_DECIMAL_DIGITS_THEME_ACCESS
	OTID_AXIS_LABEL_SHOWLABEL					= 0x05b1,	/// RVD 9/19/2011 ORG-3747-s1 TICK_LABEL_OPPOSITE
	OTID_AXIS_LABEL_CUSTOM_FORMAT				= 0x05bb,	///------ Folger 11/10/2011 ORG-3962-S1 AXIS_LABEL_CUSTOM_FORMAT_THEME_ACCESS
	///------ Folger 05/14/2012 ORG-4218-P5 AXES_LABEL_DATE_TIME_CUSTOM_DISPLAY
	OTID_AXIS_LABEL_DATE_CUSTOM_DISPLAY			= 0x05d7,
	OTID_AXIS_LABEL_TIME_CUSTOM_DISPLAY			= 0x05d8,
	///------ End AXES_LABEL_DATE_TIME_CUSTOM_DISPLAY
	
	OTID_AXIS_TITLES							= 0x0052,
	OTID_AXIS_TITLE								= 0x0053,
	/// RVD 10/5/2004 QA70-6985 v8.0143 THEME_AXIS_TITLE_OFFSET
	OTID_AXIS_TITLE_DIMENSION_XOFFSET			= 0x0303,
	OTID_AXIS_TITLE_DIMENSION_YOFFSET			= 0x0304,
	/// end THEME_AXIS_TITLE_OFFSET

	OTID_AXIS_TITLE_DIMENSION_ZOFFSET			= 0x05a2,	///-----Kit 06/09/2011 ORG-2686-S2 IMPLEMENT_3DGROBJ_CONNECT

	/// Kenny 04/29/2011 ORG-196 THEME_ACCESS_FOR_AXIS_BREAK
	OTID_AXIS_BREAK								= 0x057b,
	OTID_AXIS_BREAK_ENABLE						= 0x057c,
	OTID_AXIS_BREAK_REGION_FROM					= 0x057d,
	OTID_AXIS_BREAK_REGION_TO					= 0x057e,
	OTID_AXIS_BREAK_LOG_SCALE_AFTER				= 0x057f,
	OTID_AXIS_BREAK_SCALE_INC_BEFORE			= 0x0580,
	OTID_AXIS_BREAK_SCALE_INC_AFTER				= 0x0581,
	OTID_AXIS_BREAK_POSITION					= 0x0582,
	OTID_AXIS_BREAK_NUM_TICKS_BEFORE			= 0x0583,
	OTID_AXIS_BREAK_NUM_TICKS_AFTER				= 0x0584,
	/// End THEME_ACCESS_FOR_AXIS_BREAK

	/// RVD 9/21/2011 ORG-3685-p1 FIX_OLD_AXIS_UpdateThemeIDs
	OTID_NEWAXES								= 0x05b2,
	OTID_NEWAXIS								= 0x05b3,
	/// end FIX_OLD_AXIS_UpdateThemeIDs

	OTID_LINES									= 0x0054,
	OTID_LINE									= 0x0055,
	OTID_LINE_SHOW								= 0x0056,
	OTID_LINE_COLOR								= 0x0057,
	OTID_LINE_STYLE								= 0x0058,
	OTID_LINE_WIDTH								= 0x0059,
	OTID_LINE_ARROW								= 0x005a,
	OTID_LINE_ARROW_BEGIN						= 0x005b,
	OTID_LINE_ARROW_BEGIN_STYLE					= 0x005c,
	OTID_LINE_ARROW_BEGIN_WIDTH					= 0x005d,
	OTID_LINE_ARROW_BEGIN_LENGTH				= 0x005e,
	OTID_LINE_ARROW_BEGIN_EACHSEGMENT			= 0x005f,
	OTID_LINE_ARROW_END							= 0x0060,
	OTID_LINE_ARROW_END_STYLE					= 0x0061,
	OTID_LINE_ARROW_END_WIDTH					= 0x0062,
	OTID_LINE_ARROW_END_LENGTH					= 0x0063,
	OTID_LINE_ARROW_END_EACHSEGMENT				= 0x0064,
	/// RVD 6/30/2003 QA70-4739 v7.0613 THEME_SUPPORT_TEXT_POSITION
	OTID_LINE_DIMENSION							= 0x0256,
	OTID_LINE_DIMENSION_UNITS					= 0x0257,
	OTID_LINE_DIMENSION_LEFT					= 0x0258,
	OTID_LINE_DIMENSION_TOP						= 0x0259,
	OTID_LINE_DIMENSION_WIDTH					= 0x025a,
	OTID_LINE_DIMENSION_HEIGHT					= 0x025b,
	OTID_LINE_DIMENSION_ATTACHMENT				= 0x025c,
	/// end THEME_SUPPORT_TEXT_POSITION
	/// RVD 3/29/2005 QA70-7551 v8.0204 POLYLINE_SPAN_LAYER
	/// RVD 6/23/2005 v8.0256 QA70-7798 SPAN_RECT_TO_LAYER
	//OTID_LINE_DIRECTION							= 0x034e,
	//OTID_LINE_SPAN								= 0x034f,
	/// end SPAN_RECT_TO_LAYER
	/// end POLYLINE_SPAN_LAYER

	/// Kenny 04/25/2012 ORG-2686-P5 OGL_POLYLINE_THEME_ACCESS
	OTID_3DLINE_DIMENSION						= 0x05c9,
	OTID_3DLINE_DIMENSION_POSITION_UNITS		= 0x05ca,
	OTID_3DLINE_DIMENSION_XMIN					= 0x05cb,
	OTID_3DLINE_DIMENSION_YMIN					= 0x05cc,
	OTID_3DLINE_DIMENSION_ZMIN					= 0x05cd,
	OTID_3DLINE_DIMENSION_LENGTH				= 0x05ce,
	OTID_3DLINE_DIMENSION_WIDTH					= 0x05cf,
	OTID_3DLINE_DIMENSION_HEIGHT				= 0x05d0,
	/// End OGL_POLYLINE_THEME_ACCESS

	OTID_SHAPES									= 0x0065,
	OTID_SHAPE									= 0x0066,
	OTID_SHAPE_SHOW								= 0x0067,
	OTID_SHAPE_BORDER							= 0x0068,
	OTID_SHAPE_BORDER_COLOR						= 0x0069,
	OTID_SHAPE_BORDER_STYLE						= 0x006a,
	OTID_SHAPE_BORDER_WIDTH						= 0x006b,
	OTID_SHAPE_FILL								= 0x006c,
	OTID_SHAPE_FILL_COLOR						= 0x006d,
	OTID_SHAPE_FILL_PATTERN						= 0x006e,
	OTID_SHAPE_FILL_PATTERN_COLOR				= 0x006f,
	OTID_SHAPE_FILL_PATTERN_STYLE				= 0x0070,
	OTID_SHAPE_FILL_PATTERN_WIDTH				= 0x0071,
	OTID_SHAPE_FILL_PATTERN_USE_BORDER_COLOR	= 0x011b,
	/// RVD 6/30/2003 QA70-4739 v7.0613 THEME_SUPPORT_TEXT_POSITION
	OTID_SHAPE_DIMENSION						= 0x025d,
	OTID_SHAPE_DIMENSION_UNITS					= 0x025e,
	OTID_SHAPE_DIMENSION_LEFT					= 0x025f,
	OTID_SHAPE_DIMENSION_TOP					= 0x0260,
	OTID_SHAPE_DIMENSION_WIDTH					= 0x0261,
	OTID_SHAPE_DIMENSION_HEIGHT					= 0x0262,
	OTID_SHAPE_DIMENSION_ATTACHMENT				= 0x0263,
	/// end THEME_SUPPORT_TEXT_POSITION
	/// RVD 11/22/2006 QA70-9148 v8.0515 IMPLEMENT_RECTINFO
	OTID_SHAPE_DIMENSION_XFORM					= 0x0410,
	OTID_SHAPE_DIMENSION_XFORM_M11				= 0x0411,
	OTID_SHAPE_DIMENSION_XFORM_M12				= 0x0412,
	OTID_SHAPE_DIMENSION_XFORM_M21				= 0x0413,
	OTID_SHAPE_DIMENSION_XFORM_M22				= 0x0414,
	OTID_SHAPE_DIMENSION_XFORM_DX				= 0x0415,
	OTID_SHAPE_DIMENSION_XFORM_DY				= 0x0416,
	/// end IMPLEMENT_RECTINFO

	OTID_LABELS									= 0x0072,
	OTID_LABEL									= 0x0073,
	OTID_LABEL_SHOW								= 0x0074,
	OTID_LABEL_COLOR							= 0x0075,
	OTID_LABEL_BACKGROUND						= 0x0076,
	/// RVD 4/21/2003 QA70-4280 v7.0566 NEW_TEXT_BACKGROUND
	OTID_LABEL_BKGND							= 0x0221,
	OTID_LABEL_BKGND_BOUNDS						= 0x0222,
	OTID_LABEL_BKGND_BOUNDS_LEFT				= 0x0223,
	OTID_LABEL_BKGND_BOUNDS_TOP					= 0x0224,
	OTID_LABEL_BKGND_BOUNDS_RIGHT				= 0x0225,
	OTID_LABEL_BKGND_BOUNDS_BOTTOM				= 0x0226,
	OTID_LABEL_BKGND_BORDER						= 0x0227,
	OTID_LABEL_BKGND_BORDER_COLOR				= 0x0228,
	OTID_LABEL_BKGND_BORDER_WIDTH				= 0x0229,
	OTID_LABEL_BKGND_BORDER_STYLE				= 0x022a,
	OTID_LABEL_BKGND_FILL						= 0x022b,
	OTID_LABEL_BKGND_FILL_COLOR					= 0x022c,
	OTID_LABEL_BKGND_FILL_PATTERN				= 0x022d,
	OTID_LABEL_BKGND_FILL_PATTERN_COLOR			= 0x022e,
	OTID_LABEL_BKGND_FILL_PATTERN_STYLE			= 0x022f,
	OTID_LABEL_BKGND_FILL_PATTERN_WIDTH			= 0x0230,
	OTID_LABEL_BKGND_SHADOW						= 0x0231,
	OTID_LABEL_BKGND_SHADOW_STYLE				= 0x0232,
	OTID_LABEL_BKGND_SHADOW_WIDTH				= 0x0233,
	OTID_LABEL_BKGND_SHADOW_COLOR				= 0x0234,
	/// end NEW_TEXT_BACKGROUND
	OTID_LABEL_FONT								= 0x0077,
	OTID_LABEL_FONT_FACE						= 0x0078,
	OTID_LABEL_FONT_SIZE						= 0x0079,
	/// RVD 8/20/2009 QA70-14152 SCALER_TEXT_FONT_ATTR_THEME_GUI
	OTID_LABEL_FONT_BOLD						= 0x044f,
	OTID_LABEL_FONT_ITALIC						= 0x0450,
	OTID_LABEL_FONT_UNDERLINE					= 0x0451,
	OTID_LABEL_FONT_STRIKEOUT					= 0x0452,
	/// end SCALER_TEXT_FONT_ATTR_THEME_GUI
	OTID_LABEL_VERBATIM							= 0x007a,
	OTID_LABEL_SYSTEM							= 0x007b,
	OTID_LABEL_LINKTOVAR						= 0x007c,
	OTID_LABEL_ALIGNMENT						= 0x007d,
	/// RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS
	OTID_LABEL_ALIGNMENT_VERT					= 0x034c,
	OTID_LABEL_ALIGNMENT_HORZ					= 0x034d,
	/// end XFUNCTION_ANCHORS
	OTID_LABEL_TABSIZE							= 0x007e,
	OTID_LABEL_ANGLE							= 0x007f,
	/// RVD 6/30/2003 QA70-4739 v7.0613 THEME_SUPPORT_TEXT_POSITION
	OTID_LABEL_DIMENSION						= 0x0264,
	OTID_LABEL_DIMENSION_UNITS					= 0x0265,
	OTID_LABEL_DIMENSION_LEFT					= 0x0266,
	OTID_LABEL_DIMENSION_TOP					= 0x0267,
	OTID_LABEL_DIMENSION_WIDTH					= 0x0268,
	OTID_LABEL_DIMENSION_HEIGHT					= 0x0269,
	OTID_LABEL_DIMENSION_ATTACHMENT				= 0x026a,
	OTID_LABEL_TEXT								= 0x026b,
	/// end THEME_SUPPORT_TEXT_POSITION

	/// Kenny 05/25/2011 ORG-2686-S1 IMPLEMENT_3DGL_TEXT_OBJECT
	OTID_3DLABEL_DIMENSION							= 0x0596,
	OTID_3DLABEL_DIMENSION_CENTER_X					= 0x0597,
	OTID_3DLABEL_DIMENSION_CENTER_Y					= 0x0598,
	OTID_3DLABEL_DIMENSION_CENTER_Z					= 0x0599,
	OTID_3DLABEL_DIMENSION_LONGITUDINAL_X			= 0x059a,
	OTID_3DLABEL_DIMENSION_LONGITUDINAL_Y			= 0x059b,
	OTID_3DLABEL_DIMENSION_LONGITUDINAL_Z			= 0x059c,
	OTID_3DLABEL_DIMENSION_TRANSVERSE_X				= 0x059d,
	OTID_3DLABEL_DIMENSION_TRANSVERSE_Y				= 0x059e,
	OTID_3DLABEL_DIMENSION_TRANSVERSE_Z				= 0x059f,
	OTID_3DLABEL_DIMENSION_CENTER_UNITS				= 0x05a0,
	OTID_3DLABEL_DIMENSION_L_T_VECTOR_UNITS			= 0x05a1,
	/// End IMPLEMENT_3DGL_TEXT_OBJECT

	/// Kenny 05/15/2012 ORG-5573-S1 OGL_TEXT_OBJ_COORDINATES_REWORK
	OTID_3DLABEL_DIMENSION_ATTACHMENT_TYPE								= 0x05da,
	OTID_3DLABEL_DIMENSION_ORIENTATION_MODE								= 0x05db,
	OTID_3DLABEL_DIMENSION_ATTACH_PLANE_TYPE							= 0x05dc,
	OTID_3DLABEL_DIMENSION_ATTACH_AXIS_PLANE							= 0x05dd,
	OTID_3DLABEL_DIMENSION_ATTACH_PLANE_PERPENDICULAR_TO_AXIS			= 0x05de,
	OTID_3DLABEL_DIMENSION_ATTACH_PLANE_POINT1_X						= 0x05df,
	OTID_3DLABEL_DIMENSION_ATTACH_PLANE_POINT1_Y						= 0x05e0,
	OTID_3DLABEL_DIMENSION_ATTACH_PLANE_POINT1_Z						= 0x05e1,
	OTID_3DLABEL_DIMENSION_ATTACH_PLANE_POINT2_X						= 0x05e2,
	OTID_3DLABEL_DIMENSION_ATTACH_PLANE_POINT2_Y						= 0x05e3,
	OTID_3DLABEL_DIMENSION_ATTACH_PLANE_POINT2_Z						= 0x05e4,
	OTID_3DLABEL_DIMENSION_ATTACH_PLANE_POINT3_X						= 0x05e5,
	OTID_3DLABEL_DIMENSION_ATTACH_PLANE_POINT3_Y						= 0x05e6,
	OTID_3DLABEL_DIMENSION_ATTACH_PLANE_POINT3_Z						= 0x05e7,
	OTID_3DLABEL_DIMENSION_CENTER_U_IN_ATTACH_PLANE						= 0x05e8,
	OTID_3DLABEL_DIMENSION_CENTER_V_IN_ATTACH_PLANE						= 0x05e9,
	OTID_3DLABEL_DIMENSION_VECTOR_LU_IN_ATTACH_PLANE					= 0x05ea,
	OTID_3DLABEL_DIMENSION_VECTOR_LV_IN_ATTACH_PLANE					= 0x05eb,
	OTID_3DLABEL_DIMENSION_VECTOR_TU_IN_ATTACH_PLANE					= 0x05ec,
	OTID_3DLABEL_DIMENSION_VECTOR_TV_IN_ATTACH_PLANE					= 0x05ed,
	OTID_3DLABEL_DIMENSION_ATTACH_LINE_POINT1_X							= 0x05ee,
	OTID_3DLABEL_DIMENSION_ATTACH_LINE_POINT1_Y							= 0x05ef,
	OTID_3DLABEL_DIMENSION_ATTACH_LINE_POINT1_Z							= 0x05f0,
	OTID_3DLABEL_DIMENSION_ATTACH_LINE_POINT2_X							= 0x05f1,
	OTID_3DLABEL_DIMENSION_ATTACH_LINE_POINT2_Y							= 0x05f2,
	OTID_3DLABEL_DIMENSION_ATTACH_LINE_POINT2_Z							= 0x05f3,
	OTID_3DLABEL_DIMENSION_POSITION_IN_ATTACH_LINE						= 0x05f4,
	/// End OGL_TEXT_OBJ_COORDINATES_REWORK

	OTID_LABEL_WHITEOUT							= 0x0447,	/// RVD 6/5/2009 qa70-3745-17 THEME_ADD_TEXT_WHITEOUT

	/// ML 8/26/2010 ORG-112-P1 MORE_OLECONTAINER_OBJECT_THEME_WORK
	OTID_OLECONTAINERS							= 0x0539,
	OTID_OLECONTAINER							= 0x053a,
	OTID_OLECONTAINER_SHOW						= 0x053b,
	/// end MORE_OLECONTAINER_OBJECT_THEME_WORK

	/// SY 2006-10-19 QA70-9062 v8.0498 NEW_SCALER_GROBJ
	OTID_SCALERS								= 0x03f1,
	OTID_SCALER									= 0x03f2,
	OTID_SCALER_SHOW							= 0x03f3,
	
	OTID_SCALER_AXES							= 0x03f4,
	OTID_SCALER_AXIS							= 0x03f5,
	OTID_SCALER_AXIS_DIMENSION					= 0x03f6,
	OTID_SCALER_AXIS_DIMENSION_UNITS			= 0x03f7,
	OTID_SCALER_AXIS_DIMENSION_WIDTH			= 0x03f8,
	OTID_SCALER_AXIS_DIMENSION_POSITION			= 0x03f9,
	OTID_SCALER_AXIS_DIMENSION_OFFSET			= 0x03fa,

	OTID_SCALER_AXIS_TITLES						= 0x03fb,
	OTID_SCALER_AXIS_TITLE						= 0x03fc,
	OTID_TITLE_SHOW								= 0x03fd,
	OTID_TITLE_TEXT								= 0x03fe,
	OTID_TITLE_COLOR							= 0x03ff,
	OTID_TITLE_ANGLE							= 0x0400,
	OTID_TITLE_ALIGNMENT						= 0x0401,
	OTID_TITLE_ALIGNMENT_HORZ					= 0x0402,
	OTID_TITLE_ALIGNMENT_VERT					= 0x0403,
	OTID_TITLE_DIMENSION						= 0x0404,
	OTID_TITLE_DIMENSION_UNITS					= 0x0405,
	OTID_TITLE_DIMENSION_XOFFSET				= 0x0406,
	OTID_TITLE_DIMENSION_YOFFSET				= 0x0407,
	OTID_TITLE_FONT								= 0x0408,
	OTID_TITLE_FONT_FACE						= 0x0409,
	OTID_TITLE_FONT_SIZE						= 0x040a,
	/// end NEW_SCALER_GROBJ
	/// RVD 8/20/2009 QA70-14152 SCALER_TEXT_FONT_ATTR_THEME_GUI
	OTID_TITLE_FONT_BOLD						= 0x0453,
	OTID_TITLE_FONT_ITALIC						= 0x0454,
	OTID_TITLE_FONT_UNDERLINE					= 0x0455,
	OTID_TITLE_FONT_STRIKEOUT					= 0x0456,
	/// end SCALER_TEXT_FONT_ATTR_THEME_GUI

	OTID_TITLE									= 0x0080,
	OTID_LEGEND									= 0x0081,

	/// RVD 1/6/2011 ORG-1853 ADD_LABELS_TO_MARKER
	OTID_MARKER_LABEL							= 0x0547,
	OTID_MARKER_LABEL_DATA						= 0x0548,
	OTID_MARKER_LABEL_CNTRL						= 0x0549,
	OTID_MARKER_LABEL_COLOR						= 0x054a,
	OTID_MARKER_LABEL_ANGLE						= 0x054b,
	OTID_MARKER_LABEL_DIMENSION					= 0x054c,
	OTID_MARKER_LABEL_DIMENSION_XOFFSET			= 0x054d,
	OTID_MARKER_LABEL_DIMENSION_YOFFSET			= 0x054e,
	OTID_MARKER_LABEL_FONT						= 0x054f,
	OTID_MARKER_LABEL_FONT_FACE					= 0x0550,
	OTID_MARKER_LABEL_FONT_SIZE					= 0x0551,
	OTID_MARKER_LABEL_FONT_WHITEOUT				= 0x0552,
	OTID_MARKER_LABEL_FONT_BOLD					= 0x0553,
	OTID_MARKER_LABEL_FONT_ITALIC				= 0x0554,
	OTID_MARKER_LABEL_FONT_UNDERLINE			= 0x0555,
	OTID_MARKER_LABEL_ALIGNMENT					= 0x0556,
	OTID_MARKER_LABEL_ALIGNMENT_HORZ			= 0x0557,
	OTID_MARKER_LABEL_ALIGNMENT_VERT			= 0x0558,
	OTID_MARKER_LABEL_ALT						= 0x0559,
	OTID_MARKER_LABEL_ALT_COLOR					= 0x055a,
	/// end ADD_LABELS_TO_MARKER
	/// Hong 1/26/2011 ORG-2124 MARKER_OBJ_CUSTOM_LABEL
	/// RVD 2/25/2011 FIX_THEME_DUPLICATE_IDS
	//OTID_MARKER_LABEL_CUSTOMS					= 0x055b,
	//OTID_MARKER_LABEL_CUSTOM					= 0x055c,
	//OTID_MARKER_LABEL_CUSTOM_INDEX				= 0x055d,
	//OTID_MARKER_LABEL_CUSTOM_MIRROR				= 0x055e,
	OTID_MARKER_LABEL_CUSTOMS					= 0x055d,
	OTID_MARKER_LABEL_CUSTOM					= 0x055e,
	OTID_MARKER_LABEL_CUSTOM_INDEX				= 0x055f,
	OTID_MARKER_LABEL_CUSTOM_MIRROR				= 0x0560,
	/// end FIX_THEME_DUPLICATE_IDS
	/// end MARKER_OBJ_CUSTOM_LABEL

	OTID_CURVES									= 0x0082,
	OTID_CURVE									= 0x0083,
	OTID_CURVE_SHOW								= 0x0084,
	OTID_CURVE_LINE								= 0x0085,
	OTID_CURVE_LINE_CONNECT						= 0x0086,
	OTID_CURVE_LINE_CONNECT_SYMBOLS				= 0x010e,
	OTID_CURVE_LINE_STYLE						= 0x0087,
	OTID_CURVE_LINE_WIDTH						= 0x0088,
	OTID_CURVE_LINE_COLOR						= 0x0089,
	OTID_CURVE_LINE_GAP							= 0x008a,
	OTID_CURVE_LINE_ORDER						= 0x008b,
	OTID_CURVE_LINE_FILLAREA					= 0x008c,
	OTID_CURVE_SYMBOL							= 0x008d,
	OTID_CURVE_SYMBOL_TYPE						= 0x008e,
	OTID_CURVE_SYMBOL_SHAPE						= 0x008f,
	OTID_CURVE_SYMBOL_INTERIOR					= 0x0090,
	OTID_CURVE_SYMBOL_SIZE						= 0x0091,
	OTID_CURVE_SYMBOL_SCALE						= 0x0092,
	OTID_CURVE_SYMBOL_COLOR						= 0x0093,
	OTID_CURVE_SYMBOL_EDGE_WIDTH				= 0x0094,
	OTID_CURVE_SYMBOL_EDGE_COLOR				= 0x0095,
	OTID_CURVE_SYMBOL_FILL_COLOR				= 0x0096,
	OTID_CURVE_SYMBOL_CHARACTER					= 0x0097,
	OTID_CURVE_SYMBOL_OUTLINE					= 0x0098,
	OTID_CURVE_SYMBOL_OVERLAP					= 0x0099,
	OTID_CURVE_SYMBOL_USER						= 0x009a,
	OTID_CURVE_SYMBOL_FONT						= 0x009b,
	OTID_CURVE_SYMBOL_FONT_FACE					= 0x009c,
	OTID_CURVE_SYMBOL_FONT_BOLD					= 0x009d,
	OTID_CURVE_SYMBOL_FONT_ITALIC				= 0x009e,
	OTID_CURVE_SYMBOL_FONT_UNDERLINE			= 0x009f,
	OTID_CURVE_PATTERN							= 0x00a0,
	OTID_CURVE_PATTERN_BORDER					= 0x00a1,
	OTID_CURVE_PATTERN_BORDER_COLOR				= 0x00a2,
	OTID_CURVE_PATTERN_BORDER_STYLE				= 0x00a3,
	OTID_CURVE_PATTERN_BORDER_WIDTH				= 0x00a4,
	OTID_CURVE_PATTERN_FILL						= 0x00a5,
	OTID_CURVE_PATTERN_FILL_COLOR				= 0x00a6,
	OTID_CURVE_PATTERN_FILL_PATTERN				= 0x00a7,
	OTID_CURVE_PATTERN_FILL_PATTERN_COLOR		= 0x00a8,
	OTID_CURVE_PATTERN_FILL_PATTERN_STYLE		= 0x00a9,
	OTID_CURVE_PATTERN_FILL_PATTERN_WIDTH		= 0x00aa,
	OTID_CURVE_DROPLINES						= 0x00ab,
	OTID_CURVE_DROPLINES_HORIZONTAL				= 0x00ac,
	OTID_CURVE_DROPLINES_HORIZONTAL_COLOR		= 0x00ad,
	OTID_CURVE_DROPLINES_HORIZONTAL_STYLE		= 0x00ae,
	OTID_CURVE_DROPLINES_HORIZONTAL_WIDTH		= 0x00af,
	OTID_CURVE_DROPLINES_VERTICAL				= 0x00b0,
	OTID_CURVE_DROPLINES_VERTICAL_COLOR			= 0x00b1,
	OTID_CURVE_DROPLINES_VERTICAL_STYLE			= 0x00b2,
	OTID_CURVE_DROPLINES_VERTICAL_WIDTH			= 0x00b3,
	OTID_CURVE_DROPLINES_X						= 0x010f,
	OTID_CURVE_DROPLINES_X_COLOR				= 0x0130,
	OTID_CURVE_DROPLINES_X_STYLE				= 0x0131,
	OTID_CURVE_DROPLINES_X_WIDTH				= 0x0132,
	OTID_CURVE_DROPLINES_Y						= 0x0110,
	OTID_CURVE_DROPLINES_Y_COLOR				= 0x0133,
	OTID_CURVE_DROPLINES_Y_STYLE				= 0x0134,
	OTID_CURVE_DROPLINES_Y_WIDTH				= 0x0135,
	OTID_CURVE_DROPLINES_Z						= 0x0111,
	OTID_CURVE_DROPLINES_Z_COLOR				= 0x0112,
	OTID_CURVE_DROPLINES_Z_STYLE				= 0x0113,
	OTID_CURVE_DROPLINES_Z_WIDTH				= 0x0114,
	OTID_CURVE_DROPLINES_Z_TO_SURFACE			= 0x0606,	///Kyle 06/14/2012 ORG-3116-P7 THEME_ACCESS_TO_DROP_LINE_TO_SURFACE
	///Sophy 5/27/2010 ORG-186 VECTOR_3DVECTOR_3DERROR_THEME_SUPPORT
	OTID_CURVE_VECTOR							= 0x04a7,
	OTID_CURVE_VECTOR_COLOR						= 0x04a8,
	OTID_CURVE_VECTOR_WIDTH						= 0x04a9,
	OTID_CURVE_VECTOR_ARROWHEAD_LENGTH			= 0x04aa,
	OTID_CURVE_VECTOR_ARROWHEAD_ANGLE			= 0x04ab,
	OTID_CURVE_VECTOR_ARROWHEAD_OPEN_CLOSE		= 0x04ac,
	OTID_CURVE_VECTOR_POSITION					= 0x04ad,
	OTID_CURVE_VECTOR_VECTORDATA_ANGLE			= 0x04ae,
	OTID_CURVE_VECTOR_VECTORDATA_MAGNITUDE		= 0x04af,
	OTID_CURVE_VECTOR_VECTORDATA_MULTIPLIER		= 0x04b0,
	OTID_CURVE_VECTOR_VECTORDATA_REAL_SPACE		= 0x04b1,
	OTID_CURVE_VECTOR_ANGLE_UNITS				= 0x04b2,
	OTID_CURVE_3DVECTOR							= 0x04b3,
	OTID_CURVE_3DVECTOR_ENABLE					= 0x04b4,
	OTID_CURVE_3DVECTOR_COLOR					= 0x04b5,
	OTID_CURVE_3DVECTOR_WIDTH					= 0x04b6,
	OTID_CURVE_3DVECTOR_ARROWHEAD_SCALE_FACTOR	= 0x04b7,
	OTID_CURVE_3DVECTOR_ARROWHEAD_LENGTH		= 0x04b8,
	OTID_CURVE_3DVECTOR_ARROWHEAD_ANGLE			= 0x04b9,
	OTID_CURVE_3DVECTOR_ARROWHEAD_OPEN_CLOSE	= 0x04ba,
	OTID_CURVE_3DVECTOR_ENDPOINT_VECTOR_TYPE	= 0x04bb,
	OTID_CURVE_3DVECTOR_ENDPOINT_DX				= 0x04bc,
	OTID_CURVE_3DVECTOR_ENDPOINT_DY				= 0x04bd,
	OTID_CURVE_3DVECTOR_ENDPOINT_DZ				= 0x04be,
	OTID_CURVE_3DVECTOR_ENDPOINT_SCALE_FACTOR	= 0x04bf,
	OTID_CURVE_3DERRORBAR						= 0x04c0,
	OTID_CURVE_3DERRORBAR_ENABLE				= 0x04c1,
	OTID_CURVE_3DERRORBAR_COLOR					= 0x04c2,
	OTID_CURVE_3DERRORBAR_WIDTH					= 0x04c3,
	OTID_CURVE_3DERRORBAR_TRANSPARENCY			= 0x04c4,
	OTID_CURVE_3DERRORBAR_ERRORDATA				= 0x04c5,
	OTID_CURVE_3DERRORBAR_PLUS					= 0x04c6,
	OTID_CURVE_3DERRORBAR_MINUS					= 0x04c7,
	///end VECTOR_3DVECTOR_3DERROR_THEME_SUPPORT

	/// Kenny 06/24/2010 ORG-62 TRANSPARENCY_THEME_SUPPORT_FOR_2D_SYMBOL_LINE
	OTID_CURVE_LINE_TRANSPARENCY				= 0x04cf,
	OTID_CURVE_SYMBOL_TRANSPARENCY				= 0x04d0,
	OTID_CURVE_SYMBOL_TRANSPARENCY_AUTO			= 0x04d1,
	/// End ORG-62 TRANSPARENCY_THEME_SUPPORT_FOR_2D_SYMBOL_LINE

	/// Kenny 06/24/2010 ORG-63 TRANSPARENCY_THEME_SUPPORT_FOR_2D_COLUMN_BAR_AREA
	OTID_CURVE_PATTERN_TRANSPARENCY				= 0x04d2,
	OTID_CURVE_PATTERN_TRANSPARENCY_AUTO		= 0x04d3,
	/// End ORG-63 TRANSPARENCY_THEME_SUPPORT_FOR_2D_COLUMN_BAR_AREA

	/// Kenny 06/28/2010 ORG-38 ADD_THEME_ACCESS_SUPPORT_FOR_CURVE_PATTERN_GRADIENT_PROPERTIES
	OTID_CURVE_PATTERN_SHADING_MODE				= 0x04d5,
	OTID_CURVE_PATTERN_FILL_COLOR2				= 0x04d6,
	OTID_CURVE_PATTERN_FILL_LIGHTNESS			= 0x04d7,
	OTID_CURVE_PATTERN_GRADIENT_TYPE			= 0x04d8,
	/// End ORG-38 ADD_THEME_ACCESS_SUPPORT_FOR_CURVE_PATTERN_GRADIENT_PROPERTIES

	/// Kenny 07/02/2010 ORG-463-P1 THEME_ACCESS_FOR_2D_ERROR_BAR
	OTID_CURVE_2DERRORBAR						= 0x04E1,
	OTID_CURVE_2DERRORBAR_THROUGH_SYMBOL		= 0x04E2,
	OTID_CURVE_2DERRORBAR_DIRECTION_PLUS		= 0x04E3,
	OTID_CURVE_2DERRORBAR_DIRECTION_MINUS		= 0x04E4,
	OTID_CURVE_2DERRORBAR_DIRECTION_X			= 0x04E5,
	OTID_CURVE_2DERRORBAR_DIRECTION_RELATIVE	= 0x04E6,
	OTID_CURVE_2DERRORBAR_CAP_WIDTH				= 0x04E7,
	OTID_CURVE_2DERRORBAR_SKIP_POINTS_OPTION	= 0x04E8,
	OTID_CURVE_2DERRORBAR_APPLY_TO_LAYER		= 0x04E9,
	OTID_CURVE_2DERRORBAR_TRANSPARENCY			= 0x04EA,
	OTID_CURVE_2DERRORBAR_TRANSPARENCY_AUTO		= 0x04EB,
	///-----Kit 03/23/2011 ORG-2489-P1 COPY_ERROR_BAR_FORMAT_FAILED
	OTID_CURVE_2DERRORBAR_CONNECT_LINE_MODE		= 0x0571,
	OTID_CURVE_2DERRORBAR_CONNECT_LINE_STYLE	= 0x0572,
	OTID_CURVE_2DERRORBAR_CONNECT_LINE_COLOR	= 0x0573,
	OTID_CURVE_2DERRORBAR_CONNECT_LINE_WIDTH	= 0x0574,
	OTID_CURVE_2DERRORBAR_CONNECT_LINE_FILL_AREA_UNDER_CURVE = 0x0575,
	///-----End COPY_ERROR_BAR_FORMAT_FAILED
	/// End ORG-463-P1 THEME_ACCESS_FOR_2D_ERROR_BAR

	/// Kenny 08/19/2010 ORG-396-P1 THEME_ACCESS_FOR_3D_SCATTER_PROJECTIONS
	OTID_PROJECTIONS							= 0x0537,
	OTID_PROJECTION								= 0x0538,
	/// End ORG-396-P1 THEME_ACCESS_FOR_3D_SCATTER_PROJECTIONS

	/// Kenny 11/01/2011 ORG-396-P3 IMPLEMENT_SHOW_PROPERTY_FOR_3D_SCATTER_PROJECTIONS
	OTID_PROJECTION_SHOW						= 0x05b6,
	/// End IMPLEMENT_SHOW_PROPERTY_FOR_3D_SCATTER_PROJECTIONS

	///------ Folger 08/10/10 ORG-679-P6 FAILED_TO_COPY_FORMAT_FROM_3DSCATTER_PLOT_COLORMAP
	OTID_3DSCATTER_COLORMAP						= 0x04fc,
	OTID_3DSCATTER_COLORMAP_LEVELS				= 0x04fd,
	OTID_3DSCATTER_COLORMAP_COLORS				= 0x04fe,
	OTID_3DSCATTER_COLORMAP_RESCALE_MODE		= 0x04ff,
	OTID_3DSCATTER_COLORMAP_MIXING_COLORS		= 0x0500,
	OTID_3DSCATTER_COLORMAP_LOG_SCALE			= 0x0501,
	OTID_3DSCATTER_COLORMAP_COUNT				= 0x0502,
	OTID_3DSCATTER_COLORMAP_MIN					= 0x0503,
	OTID_3DSCATTER_COLORMAP_MAX					= 0x0504,
	OTID_3DSCATTER_COLORMAP_MAJOR_LEVELS		= 0x0505,
	OTID_3DSCATTER_COLORMAP_MINOR_LEVELS		= 0x0506,
	OTID_3DSCATTER_COLORMAP_INCREMENT			= 0x0507,
	OTID_3DSCATTER_COLORMAP_SET_LEVELS_BY		= 0x0508,
	///------ Folger 08/11/10 ORG-705-P4 COLORMAP_FIRST_TICK_IN_THEME
	OTID_3DSCATTER_COLORMAP_FIRST_LEVEL			= 0x0522,
	///------ End COLORMAP_FIRST_TICK_IN_THEME
	OTID_3DSCATTER_COLORMAP_LINK_TO_PALETTE		= 0x0509,
	///Kyle 11/30/2010 ORG-1591-P2 OC_APPLY_PALETTE_SUPPORT_UNDO
	OTID_3DSCATTER_COLORMAP_FLIP_PAL			= 0x053d,
	OTID_3DSCATTER_COLORMAP_STRETCH_PAL			= 0x053e,
	///End OC_APPLY_PALETTE_SUPPORT_UNDO
	OTID_3DSCATTER_COLORMAP_PALETTE				= 0x050a,
	OTID_3DSCATTER_COLORMAP_DETAILS				= 0x050b,
	OTID_3DSCATTER_COLORMAP_BELOW				= 0x050c,
	OTID_3DSCATTER_COLORMAP_BELOW_VALUE			= 0x050d,
	OTID_3DSCATTER_COLORMAP_BELOW_COLOR			= 0x050e,
	OTID_3DSCATTER_COLORMAP_ABOVE				= 0x050f,
	OTID_3DSCATTER_COLORMAP_ABOVE_VALUE			= 0x0510,
	OTID_3DSCATTER_COLORMAP_ABOVE_COLOR			= 0x0511,
	///------ End FAILED_TO_COPY_FORMAT_FROM_3DSCATTER_PLOT_COLORMAP

	OTID_PIES									= 0x00b4,
	OTID_PIE									= 0x00b5,
	OTID_PIE_SHOW								= 0x00b6,
	OTID_PIE_PATTERN							= 0x00b7,
	OTID_PIE_PATTERN_BORDER						= 0x00b8,
	OTID_PIE_PATTERN_BORDER_COLOR				= 0x00b9,
	OTID_PIE_PATTERN_BORDER_STYLE				= 0x00ba,
	OTID_PIE_PATTERN_BORDER_WIDTH				= 0x00bb,
	OTID_PIE_PATTERN_FILL						= 0x00bc,
	OTID_PIE_PATTERN_FILL_COLOR					= 0x00bd,

	/// Kenny 07/01/2010 ORG-38-P4 ADD_THEME_ACCESS_SUPPORT_FOR_PIE_PATTERN_GRADIENT_PROPERTIES
	OTID_PIE_PATTERN_SHADING_MODE				= 0x04dc,
	OTID_PIE_PATTERN_FILL_COLOR2				= 0x04dd,
	OTID_PIE_PATTERN_FILL_LIGHTNESS				= 0x04de,
	OTID_PIE_PATTERN_GRADIENT_TYPE				= 0x04df,
	/// End ORG-38-P4 ADD_THEME_ACCESS_SUPPORT_FOR_PIE_PATTERN_GRADIENT_PROPERTIES

	/// Kenny 07/01/2010 ORG-63-P6 TRANSPARENCY_THEME_SUPPORT_FOR_2D_PIE_CHART
	OTID_PIE_PATTERN_TRANSPARENCY				= 0x04e0,
	OTID_PIE_PATTERN_TRANSPARENCY_AUTO			= 0x05bc,		/// Kenny 12/07/2011 ORG-4543-P1 TRANSPARENCY_PROPERTIES_FOR_SPECIAL_POINT_THEME_ACCESS
	/// End ORG-63-P6 TRANSPARENCY_THEME_SUPPORT_FOR_2D_PIE_CHART

	OTID_PIE_PATTERN_FILL_PATTERN				= 0x00be,
	OTID_PIE_PATTERN_FILL_PATTERN_COLOR			= 0x00bf,
	OTID_PIE_PATTERN_FILL_PATTERN_STYLE			= 0x00c0,
	OTID_PIE_PATTERN_FILL_PATTERN_WIDTH			= 0x00c1,
	OTID_PIE_GEOMETRY							= 0x00c2,
	OTID_PIE_GEOMETRY_ANGLE						= 0x00c3,
	OTID_PIE_GEOMETRY_THICKNESS					= 0x00c4,
	OTID_PIE_GEOMETRY_AZIMUTH					= 0x00c5,
	OTID_PIE_GEOMETRY_CCW						= 0x00c6,
	OTID_PIE_GEOMETRY_RESCALE					= 0x00c7,
	OTID_PIE_GEOMETRY_OFFSET					= 0x00c8,
	OTID_PIE_GEOMETRY_DISPLACEMENT				= 0x00c9,
	OTID_PIE_GEOMETRY_EXPLODE					= 0x00ca,
	OTID_PIE_LABELS								= 0x00cb,
	OTID_PIE_LABELS_AUTOMATIC					= 0x00cc,
	OTID_PIE_LABELS_VALUES						= 0x00cd,
	OTID_PIE_LABELS_PERCENTAGES					= 0x00ce,
	OTID_PIE_LABELS_CATEGORIES					= 0x00cf,
	OTID_PIE_LABELS_WEDGE						= 0x00d0,
	OTID_PIE_LABELS_DISTANCE					= 0x00d1,
	OTID_PIE_LABELS_HIDE						= 0x00d2,
	OTID_PIE_LABELS_DRAW_ARROWS					= 0x00d3,

	OTID_DATALABELS								= 0x00d4,
	OTID_DATALABEL								= 0x00d5,
	OTID_DATALABEL_SHOW							= 0x00d6,
	OTID_DATALABEL_COLOR						= 0x00d7,
	OTID_DATALABEL_FACE							= 0x00d8,
	OTID_DATALABEL_SIZE							= 0x00d9,
	OTID_DATALABEL_ALIGNMENT					= 0x00da,
	OTID_DATALABEL_WHITEOUT						= 0x00db,
	OTID_DATALABEL_BOLD							= 0x00dc,
	OTID_DATALABEL_ITALIC						= 0x00dd,
	OTID_DATALABEL_UNDERLINE					= 0x00de,
	/// RVD 7/23/2003 QA70-3745 v7.0631 THEME_ADDITIONAL_WORK
	OTID_DATALABEL_ANGLE						= 0x027a,
	OTID_DATALABEL_XOFFSET						= 0x027b,
	OTID_DATALABEL_YOFFSET						= 0x027c,
	/// end THEME_ADDITIONAL_WORK

	/// RVD 9/1/2005 QA70-8009 v8.0299 THEME_COMMON_COLORMAP
	OTID_PLOTS									= 0x0380,
	OTID_PLOT									= 0x0381,
	OTID_PLOT_SHOW								= 0x0382,
	OTID_PLOT_COLORMAP							= 0x0383,
	OTID_PLOT_COLORMAP_LEVELS					= 0x0384,
	OTID_PLOT_COLORMAP_LINE_SHOW				= 0x0385,
	OTID_PLOT_COLORMAP_COLORS					= 0x0386,
	OTID_PLOT_COLORMAP_LABELS					= 0x0387,
	OTID_PLOT_COLORMAP_LINECOLORS				= 0x0388,
	OTID_PLOT_COLORMAP_LINESTYLES				= 0x0389,
	OTID_PLOT_COLORMAP_LINEWIDTHS				= 0x038a,
	OTID_PLOT_COLORMAP_PATTERNS					= 0x038b,
	OTID_PLOT_COLORMAP_PATTERNCOLORS			= 0x038c,
	OTID_PLOT_COLORMAP_PATTERNWIDTHS			= 0x038d,
	OTID_PLOT_COLORMAP_FILLCNTRL				= 0x038e,
	OTID_PLOT_COLORMAP_MIXING_COLORS			= 0x038f,
	OTID_PLOT_COLORMAP_LOG_SCALE				= 0x0390,
	OTID_PLOT_COLORMAP_USE_MISSING				= 0x0391,
	OTID_PLOT_COLORMAP_COUNT					= 0x0392,
	OTID_PLOT_COLORMAP_MIN						= 0x0393,
	OTID_PLOT_COLORMAP_MAX						= 0x0394,
	OTID_PLOT_COLORMAP_DETAILS					= 0x0395,
	OTID_PLOT_COLORMAP_MISSING					= 0x0396,
	OTID_PLOT_COLORMAP_MISSING_VALUE			= 0x0397,
	OTID_PLOT_COLORMAP_MISSING_COLOR			= 0x0398,
	OTID_PLOT_COLORMAP_MISSING_PATTERN			= 0x0399,
	OTID_PLOT_COLORMAP_MISSING_PATTERNCOLOR		= 0x039a,
	OTID_PLOT_COLORMAP_MISSING_PATTERNWIDTH		= 0x039b,
	OTID_PLOT_COLORMAP_MISSING_LINECOLOR		= 0x039c,
	OTID_PLOT_COLORMAP_MISSING_LINESTYLE		= 0x039d,
	OTID_PLOT_COLORMAP_MISSING_LINEWIDTH		= 0x039e,
	OTID_PLOT_COLORMAP_BELOW					= 0x039f,
	OTID_PLOT_COLORMAP_BELOW_VALUE				= 0x03a0,
	OTID_PLOT_COLORMAP_BELOW_COLOR				= 0x03a1,
	OTID_PLOT_COLORMAP_BELOW_PATTERN			= 0x03a2,
	OTID_PLOT_COLORMAP_BELOW_PATTERNCOLOR		= 0x03a3,
	OTID_PLOT_COLORMAP_BELOW_PATTERNWIDTH		= 0x03a4,
	OTID_PLOT_COLORMAP_BELOW_LINECOLOR			= 0x03a5,
	OTID_PLOT_COLORMAP_BELOW_LINESTYLE			= 0x03a6,
	OTID_PLOT_COLORMAP_BELOW_LINEWIDTH			= 0x03a7,
	OTID_PLOT_COLORMAP_ABOVE					= 0x03a8,
	OTID_PLOT_COLORMAP_ABOVE_VALUE				= 0x03a9,
	OTID_PLOT_COLORMAP_ABOVE_COLOR				= 0x03aa,
	OTID_PLOT_COLORMAP_ABOVE_PATTERN			= 0x03ab,
	OTID_PLOT_COLORMAP_ABOVE_PATTERNCOLOR		= 0x03ac,
	OTID_PLOT_COLORMAP_ABOVE_PATTERNWIDTH		= 0x03ad,
	OTID_PLOT_COLORMAP_ABOVE_LINECOLOR			= 0x03ae,
	OTID_PLOT_COLORMAP_ABOVE_LINESTYLE			= 0x03af,
	OTID_PLOT_COLORMAP_ABOVE_LINEWIDTH			= 0x03b0,
	/// RVD 8/8/2006 QA80-8893 v8.0459 COLORMAP_SHOW_ABOVE_LINE_LABEL
	OTID_PLOT_COLORMAP_ABOVE_LINE				= 0x03e2,
	OTID_PLOT_COLORMAP_ABOVE_LABEL				= 0x03e3,
	/// end COLORMAP_SHOW_ABOVE_LINE_LABEL
	OTID_PLOT_NUMERICFORMAT						= 0x03b1,
	OTID_PLOT_NUMERICFORMAT_FORMAT				= 0x03b2,
	OTID_PLOT_NUMERICFORMAT_DIVBYFACTOR			= 0x03b3,
	OTID_PLOT_NUMERICFORMAT_DIGITCNTRL			= 0x03b4,
	OTID_PLOT_NUMERICFORMAT_DECDIGITS			= 0x03b5,
	OTID_PLOT_NUMERICFORMAT_SIGDIGITS			= 0x03b6,
	OTID_PLOT_NUMERICFORMAT_PREFIX				= 0x03b7,
	OTID_PLOT_NUMERICFORMAT_SUFFIX				= 0x03b8,
	OTID_PLOT_NUMERICFORMAT_MINAREA				= 0x03b9,
	/// end THEME_COMMON_COLORMAP

	OTID_COLUMNS								= 0x00df,
	OTID_COLUMN									= 0x00e0,
	OTID_COLUMN_SHOW							= 0x00e1,
	OTID_COLUMN_PATTERN							= 0x00e2,
	OTID_COLUMN_PATTERN_BORDER					= 0x00e3,
	OTID_COLUMN_PATTERN_BORDER_COLOR			= 0x00e4,
	OTID_COLUMN_PATTERN_BORDER_STYLE			= 0x00e5,
	OTID_COLUMN_PATTERN_BORDER_WIDTH			= 0x00e6,
	OTID_COLUMN_PATTERN_FILL					= 0x00e7,
	OTID_COLUMN_PATTERN_FILL_COLOR				= 0x00e8,
	OTID_COLUMN_PATTERN_FILL_PATTERN			= 0x00e9,
	OTID_COLUMN_PATTERN_FILL_PATTERN_COLOR		= 0x00ea,
	OTID_COLUMN_PATTERN_FILL_PATTERN_STYLE		= 0x00eb,
	OTID_COLUMN_PATTERN_FILL_PATTERN_WIDTH		= 0x00ec,
	OTID_COLUMN_SPACING							= 0x00ed,
	OTID_COLUMN_SPACING_GAP						= 0x00ee,
	OTID_COLUMN_SPACING_OVERLAP					= 0x00ef,
	OTID_COLUMN_SPACING_THICKNESS				= 0x00f0,

	/// Kenny 08/06/2012 ORG-6442-S1 OGL_THEME_ACCESS_FOR_3DBARS
	OTID_COLUMN_SPACING_KEEP_SHAPE				= 0x060d,
	OTID_COLUMN_SPACING_WIDTH_X					= 0x060e,
	OTID_COLUMN_SPACING_WIDTH_Y					= 0x060f,

	OTID_COLUMN_3DERRORBAR						= 0x0611,
	OTID_COLUMN_3DERRORBAR_ENABLE				= 0x0612,
	OTID_COLUMN_3DERRORBAR_Y_COLOR				= 0x0613,
	OTID_COLUMN_3DERRORBAR_Y_WIDTH				= 0x0614,
	OTID_COLUMN_3DERRORBAR_Y_COL				= 0x0615,
	OTID_COLUMN_3DERRORBAR_SHOW_Y_PLUS			= 0x0616,
	OTID_COLUMN_3DERRORBAR_SHOW_Y_MINUS			= 0x0617,
	OTID_COLUMN_3DERRORBAR_TRANSPARENCY			= 0x0618,
	OTID_COLUMN_3DERRORBAR_AUTO_TRANSPARENCY	= 0x0619,
	OTID_COLUMN_3DERRORBAR_Y_CAP_WIDTH			= 0x061a,
	OTID_COLUMN_3DERRORBAR_Y_CAP_DIRECTION		= 0x061b,
	/// End OGL_THEME_ACCESS_FOR_3DBARS

	/// Kenny 10/29/2009 QA80-14025 TWO_COLOR_SHADING_2D_3D_BAR_PLOTS
	OTID_COLUMN_PATTERN_SHADING_MODE			= 0x0481,
	OTID_COLUMN_PATTERN_FILL_COLOR2				= 0x0482,
	OTID_COLUMN_PATTERN_FILL_LIGHTNESS			= 0x0483,
	OTID_COLUMN_PATTERN_GRADIENT_TYPE			= 0x0484,
	/// End QA80-14025 TWO_COLOR_SHADING_2D_3D_BAR_PLOTS

	/// Kenny 07/09/2010 ORG-398-P1 THEME_ACCESS_TO_XYY_3D_BAR_FACES_IS_MISSING
	/// RVD 07/16/2010 ORG-398-P1 PROPER_THEME_ACCESS_TO_XYY_3D_BAR_FACES
	//OTID_COLUMN_PATTERN_COLL					= 0x04ec,
	//OTID_COLUMN_PATTERNS						= 0x04ed,
	OTID_FACES									= 0x04ec,
	OTID_FACE									= 0x04ed,
	/// end PROPER_THEME_ACCESS_TO_XYY_3D_BAR_FACES
	OTID_COLUMN_PATTERN_TYPE					= 0x04ee,
	/// End ORG-398-P1 THEME_ACCESS_TO_XYY_3D_BAR_FACES_IS_MISSING

	/// Kenny 06/24/2010 ORG-63 TRANSPARENCY_THEME_SUPPORT_FOR_2D_COLUMN_BAR_AREA
	OTID_COLUMN_PATTERN_TRANSPARENCY			= 0x04d4,
	OTID_COLUMN_PATTERN_TRANSPARENCY_AUTO		= 0x05bd,		/// Kenny 12/07/2011 ORG-4543-P1 TRANSPARENCY_PROPERTIES_FOR_SPECIAL_POINT_THEME_ACCESS
	/// End ORG-63 TRANSPARENCY_THEME_SUPPORT_FOR_2D_COLUMN_BAR_AREA

	/// Kenny 03/16/2010 QA81-14570 ADD_NEW_GUI_TO_ADD_XY_VALUES_AS_LABELS_TO_PLOT
	OTID_PLOT_LABEL								= 0x0495,
	OTID_PLOT_LABEL_ENABLE						= 0x0496,
	OTID_PLOT_LABEL_FACE						= 0x0497,
	OTID_PLOT_LABEL_COLOR						= 0x0498,
	OTID_PLOT_LABEL_SIZE						= 0x0499,
	OTID_PLOT_LABEL_WHITEOUT					= 0x049a,
	OTID_PLOT_LABEL_BOLD						= 0x049b,
	OTID_PLOT_LABEL_ITALIC						= 0x049c,
	OTID_PLOT_LABEL_UNDERLINE					= 0x049d,
	OTID_PLOT_LABEL_FORM						= 0x049e,
	OTID_PLOT_LABEL_CUSTOM_FORMAT_STRING		= 0x049f,
	OTID_PLOT_LABEL_ROTATION					= 0x04a0,
	OTID_PLOT_LABEL_X_OFFSET					= 0x04a1,
	OTID_PLOT_LABEL_Y_OFFSET					= 0x04a2,

	/// Kenny 02/22/2011 ORG-2281 DATA_LABELS_IN_3D_SCATTER_PLOTS
	/// RVD 2/25/2011 FIX_THEME_DUPLICATE_IDS
	//OTID_PLOT_LABEL_Z_OFFSET					= 0x055D,
	//OTID_PLOT_LABEL_FORM_3D						= 0x055E,
	OTID_PLOT_LABEL_Z_OFFSET					= 0x0561,
	OTID_PLOT_LABEL_FORM_3D						= 0x0562,
	/// end FIX_THEME_DUPLICATE_IDS
	/// End ORG-2281 DATA_LABELS_IN_3D_SCATTER_PLOTS

	///Kyle 03/17/2010 QA81-14570 THEME_ACCESS_FOR_PLOT_LABEL, 3 different ids for Position with different values and meaning
	OTID_PLOT_LABEL_POSITION_SCATTER			= 0x04a3,
	OTID_PLOT_LABEL_POSITION_COLUMN				= 0x04a4,
	OTID_PLOT_LABEL_POSITION_COLUMN_SHORT		= 0x04a5,
	///End THEME_ACCESS_FOR_PLOT_LABEL
	/// End QA81-14570 ADD_NEW_GUI_TO_ADD_XY_VALUES_AS_LABELS_TO_PLOT

	/// Kenny 06/24/2011 ORG-2281-P2 O3DGL_DATA_LABEL_THEME_ACCESS
	OTID_PLOT_LABEL_AUTO_ROTATE					= 0x05a4,
	OTID_PLOT_LABEL_PLANE_NORMAL_X				= 0x05a5,
	OTID_PLOT_LABEL_PLANE_NORMAL_Y				= 0x05a6,
	OTID_PLOT_LABEL_PLANE_NORMAL_Z				= 0x05a7,
	/// End O3DGL_DATA_LABEL_THEME_ACCESS

	/// Kenny 08/30/2012 ORG-6393-S1 OGL_OPTION_TO_PUT_LABELS_AT_THE_ENDS_OF_VECTOR_ARROWS
	OTID_PLOT_LABEL_ATTACH_TO_POS				= 0x061d,
	/// End OGL_OPTION_TO_PUT_LABELS_AT_THE_ENDS_OF_VECTOR_ARROWS

	OTID_3DMESHPLOT_TRANSPARENCY_IN_PERCENT		= 0x04a6,	/// Kenny 04/14/2010 QA85-14450 3D_PLOT_TRANSPARENCY_SUPPORT

	OTID_SURFACES								= 0x00f1,
	OTID_SURFACE								= 0x00f2,
	OTID_SURFACE_SHOW							= 0x00f3,

	/// Kenny 05/28/2012 ORG-5796-P1 THEME_ACCESS_FOR_OPENGL_PLOT
	OTID_SURFACE_FLATTEN											= 0x05f5,
	OTID_SURFACE_OFFSET_Z											= 0x05f6,
	OTID_SURFACE_X_PARAMETRIC										= 0x05f7,
	OTID_SURFACE_Y_PARAMETRIC										= 0x05f8,

	/// Kenny 06/18/2012 ORG-5973-P1 OGL_CONTOUR_SMOOTH_FILL_COLOR_THEME_ACCESS
	OTID_SURFACE_SHOW_CONTOUR_LINES_LABELS							= 0x0609,
	/// End OGL_CONTOUR_SMOOTH_FILL_COLOR_THEME_ACCESS

	OTID_SURFACE_COLORFILLS											= 0x05f9,
	OTID_SURFACE_COLORFILLS_FILL_COLOR_TYPE							= 0x05fa,
	OTID_SURFACE_COLORFILLS_COLORMAP_DATASET_NAME					= 0x05fb,
	OTID_SURFACE_COLORFILLS_FRONT_FILL_COLOR						= 0x05fc,
	OTID_SURFACE_COLORFILLS_FRONT_FILL_COLOR_COL_INDEX				= 0x05fd,
	OTID_SURFACE_COLORFILLS_BACK_COLOR_ENABLE						= 0x05fe,
	OTID_SURFACE_COLORFILLS_BACK_COLOR								= 0x05ff,
	OTID_SURFACE_COLORFILLS_TRANSPARENCY_IN_PERCENT					= 0x0600,
	OTID_SURFACE_COLORFILLS_TRANSPARENCY_AUTO						= 0x0601,
	/// End THEME_ACCESS_FOR_OPENGL_PLOT

	OTID_SURFACE_GRIDS							= 0x011c,
	OTID_SURFACE_GRIDS_ENABLE					= 0x011d,
	OTID_SURFACE_GRIDS_WIDTH					= 0x011e,
	OTID_SURFACE_GRIDS_COLOR					= 0x011f,
	OTID_SURFACE_GRIDS_COLOR_CNTRL				= 0x0136,
	OTID_SURFACE_GRIDS_FRONTCOLOR				= 0x0120,
	OTID_SURFACE_GRIDS_ENABLEBACKCOLOR			= 0x0137,
	OTID_SURFACE_GRIDS_LINES					= 0x0138,
	OTID_SURFACE_GRIDS_BACKCOLOR				= 0x0121,

	/// Kenny 03/02/2010 QA81-15155 IMPLEMENT_THEME_TREE_ACCESS_FOR_SURFACE_SKIPPING_GRID_LINES
	OTID_SURFACE_GRIDS_SKIPPING_GRIDLINES_X		= 0x0492,
	OTID_SURFACE_GRIDS_SKIPPING_GRIDLINES_Y		= 0x0493,
	/// End QA81-15155 IMPLEMENT_THEME_TREE_ACCESS_FOR_SURFACE_SKIPPING_GRID_LINES
	OTID_SURFACE_GRIDS_MAX_GRIDLINES			= 0x053c,	/// RVD 10/20/2010 org-1224-s2 MODIFY_SKIP_GRIDLINES_ALLOW_MAX

	/// Kenny 05/28/2012 ORG-5796-P1 THEME_ACCESS_FOR_OPENGL_PLOT
	OTID_SURFACE_GRIDS_TRANSPARENCY_IN_PERCENT	= 0x0602,
	OTID_SURFACE_GRIDS_TRANSPARENCY_AUTO		= 0x0603,
	/// End THEME_ACCESS_FOR_OPENGL_PLOT

	OTID_SURFACE_WALLS							= 0x0122,
	OTID_SURFACE_WALLS_ENABLE					= 0x0123,
	OTID_SURFACE_WALLS_XCOLOR					= 0x0124,
	OTID_SURFACE_WALLS_YCOLOR					= 0x0125,

	/// Kenny 07/30/2010 ORG-688-P1 THEME_ACCESS_FOR_3D_SIDE_WALLS_TRANSPARENCY
	OTID_SURFACE_WALLS_TRANSPARENCY				= 0x04f2,
	/// End ORG-688-P1 THEME_ACCESS_FOR_3D_SIDE_WALLS_TRANSPARENCY

	OTID_SURFACE_WALLS_AUTO_TRANSPARENCY		= 0x060b,	/// Kenny 07/24/2012 ORG-6234-P2 OGL_SURFACE_MISSING_THEME_ACCESS_FOR_ERRBAR_WALL

	OTID_SURFACE_BARS							= 0x0126,
	OTID_SURFACE_BARS_BORDER					= 0x0127,
	OTID_SURFACE_BARS_BORDER_COLOR				= 0x0128,
	OTID_SURFACE_BARS_BORDER_WIDTH				= 0x0129,
	OTID_SURFACE_BARS_FILL						= 0x012a,
	OTID_SURFACE_BARS_FILL_COLOR				= 0x012b,
	OTID_SURFACE_BARS_FILL_APPLY				= 0x012c,
	OTID_SURFACE_BARS_WIDTH						= 0x012d,
	OTID_SURFACE_BARS_WIDTH_X					= 0x012e,
	OTID_SURFACE_BARS_WIDTH_Y					= 0x012f,

	/// Kenny 06/27/2011 ORG-3127 O3DGL_BAR_PLOT_GUI_ACCESS
	OTID_SURFACE_BARS_KEEP_SHAPE				= 0x05a8,
	OTID_SURFACE_BARS_SHAPE						= 0x05a9,
	/// End O3DGL_BAR_PLOT_GUI_ACCESS

	/// Kenny 09/11/2012 ORG-6744-P1 OGL_THEME_ACCESS_FOR_MATRIX_XYZ_3D_BARS_PLOT
	OTID_SURFACE_BARS_AUTO_DARKER_FACECOLOR		= 0x0623,
	OTID_SURFACE_BARS_START_POSITION			= 0x0624,
	/// End OGL_THEME_ACCESS_FOR_MATRIX_XYZ_3D_BARS_PLOT

	/// Kenny 08/06/2012 ORG-6442-S1 OGL_THEME_ACCESS_FOR_3DBARS
	OTID_SURFACE_BARS_OFFSET_Z					= 0x0610,
	/// End OGL_THEME_ACCESS_FOR_3DBARS

	OTID_SURFACE_NUMERICFORMAT					= 0x0139,
	OTID_SURFACE_NUMERICFORMAT_FORMAT			= 0x013a,
	OTID_SURFACE_NUMERICFORMAT_DIVBYFACTOR		= 0x013b,
	OTID_SURFACE_NUMERICFORMAT_DIGITCNTRL		= 0x013c,
	OTID_SURFACE_NUMERICFORMAT_DECDIGITS		= 0x013d,
	OTID_SURFACE_NUMERICFORMAT_SIGDIGITS		= 0x013e,
	OTID_SURFACE_NUMERICFORMAT_PREFIX			= 0x013f,
	OTID_SURFACE_NUMERICFORMAT_SUFFIX			= 0x0140,
	OTID_SURFACE_PROJECTIONS					= 0x0141,
	OTID_SURFACE_PROJECTIONS_SURFACE			= 0x0142,
	OTID_SURFACE_PROJECTIONS_SURFACE_FILL		= 0x0143,
	OTID_SURFACE_PROJECTIONS_SURFACE_LINE		= 0x0144,
	OTID_SURFACE_PROJECTIONS_SURFACE_COLOR		= 0x0145,
	OTID_SURFACE_PROJECTIONS_SURFACE_WIDTH		= 0x0146,
	OTID_SURFACE_PROJECTIONS_TOPCONTOUR			= 0x0147,
	OTID_SURFACE_PROJECTIONS_TOPCONTOUR_FILL	= 0x0148,
	OTID_SURFACE_PROJECTIONS_TOPCONTOUR_LINE	= 0x0149,
	OTID_SURFACE_PROJECTIONS_TOPCONTOUR_COLOR	= 0x014a,
	OTID_SURFACE_PROJECTIONS_TOPCONTOUR_WIDTH	= 0x014b,
	OTID_SURFACE_PROJECTIONS_BOTTOMCONTOUR		= 0x014c,
	OTID_SURFACE_PROJECTIONS_BOTTOMCONTOUR_FILL		= 0x014d,
	OTID_SURFACE_PROJECTIONS_BOTTOMCONTOUR_LINE		= 0x014e,
	OTID_SURFACE_PROJECTIONS_BOTTOMCONTOUR_COLOR	= 0x014f,
	OTID_SURFACE_PROJECTIONS_BOTTOMCONTOUR_WIDTH	= 0x0150,
	OTID_SURFACE_PROJECTIONS_ZCLIP				= 0x0151,
	OTID_SURFACE_PROJECTIONS_ZCLIP_LOW			= 0x0152,
	OTID_SURFACE_PROJECTIONS_ZCLIP_HIGH			= 0x0153,
	OTID_SURFACE_COLORMAP						= 0x01c0,
	OTID_SURFACE_COLORMAP_LEVELS				= 0x01c1,
	OTID_SURFACE_COLORMAP_COLORS				= 0x01c2,
	OTID_SURFACE_COLORMAP_ENABLEFILL			= 0x01c3,
	/// RVD 9/29/2005 v8.0312 THEME_COLORMAP_RESCALE
	OTID_SURFACE_COLORMAP_RESCALE_MODE			= 0x03ba,
	/// end THEME_COLORMAP_RESCALE
	OTID_SURFACE_COLORMAP_MIXING_COLORS			= 0x01c4,
	OTID_SURFACE_COLORMAP_LOG_SCALE				= 0x01c5,
	OTID_SURFACE_COLORMAP_COUNT					= 0x01c6,
	OTID_SURFACE_COLORMAP_MIN					= 0x01d6,
	OTID_SURFACE_COLORMAP_MAX					= 0x01d7,
	///Kyle 09/07/2009 QA80-14261 COLORMAP_THEME_IMPROVEMENTS
	OTID_SURFACE_COLORMAP_MAJOR_LEVELS			= 0x045f,
	OTID_SURFACE_COLORMAP_MINOR_LEVELS			= 0x0460,
	OTID_SURFACE_COLORMAP_INCREMENT				= 0x0461,
	OTID_SURFACE_COLORMAP_SET_LEVELS_BY			= 0x0462,
	///------ Folger 08/11/10 ORG-705-P4 COLORMAP_FIRST_TICK_IN_THEME
	OTID_SURFACE_COLORMAP_FIRST_LEVEL			= 0x0523,
	///------ End COLORMAP_FIRST_TICK_IN_THEME
	OTID_SURFACE_COLORMAP_LINK_TO_PALETTE		= 0x0463,
	///Kyle 11/30/2010 ORG-1591-P2 OC_APPLY_PALETTE_SUPPORT_UNDO
	OTID_SURFACE_COLORMAP_FLIP_PAL				= 0x053f,
	OTID_SURFACE_COLORMAP_STRETCH_PAL			= 0x0540,
	///End OC_APPLY_PALETTE_SUPPORT_UNDO
	OTID_SURFACE_COLORMAP_PALETTE				= 0x0464,
	///End COLORMAP_THEME_IMPROVEMENTS
	OTID_SURFACE_COLORMAP_FILLCHECK				= 0x042f,	/// RVD 2/18/2009 qa70-13143 THEME_COLORMAP_FILLCHECK
	OTID_SURFACE_COLORMAP_DETAILS				= 0x01c7,
	OTID_SURFACE_COLORMAP_BELOW					= 0x01c8,
	OTID_SURFACE_COLORMAP_BELOW_VALUE			= 0x01c9,
	OTID_SURFACE_COLORMAP_BELOW_COLOR			= 0x01ca,
	OTID_SURFACE_COLORMAP_ABOVE					= 0x01cb,
	OTID_SURFACE_COLORMAP_ABOVE_VALUE			= 0x01cc,
	OTID_SURFACE_COLORMAP_ABOVE_COLOR			= 0x01cd,
	OTID_SURFACE_LABELS							= 0x01ce,
	OTID_SURFACE_LABELS_COLOR					= 0x01cf,
	OTID_SURFACE_LABELS_FACE					= 0x01d0,
	OTID_SURFACE_LABELS_SIZE					= 0x01d1,
	OTID_SURFACE_LABELS_WHITEOUT				= 0x01d2,
	OTID_SURFACE_LABELS_BOLD					= 0x01d3,
	OTID_SURFACE_LABELS_ITALIC					= 0x01d4,
	OTID_SURFACE_LABELS_UNDERLINE				= 0x01d5,

	/// Kenny 08/09/2010 ORG-688-P4 THEME_ACCESS_FOR_3D_ERROR_BAR
	OTID_SURFACE_3DERRORBAR						= 0x04F4,
	OTID_SURFACE_3DERRORBAR_ENABLE				= 0x04F5,
	OTID_SURFACE_3DERRORBAR_Z_COLOR				= 0x04F6,
	OTID_SURFACE_3DERRORBAR_Z_WIDTH				= 0x04F7,
	OTID_SURFACE_3DERRORBAR_Z_COL				= 0x04F8,
	OTID_SURFACE_3DERRORBAR_SHOW_Z_PLUS			= 0x04F9,
	OTID_SURFACE_3DERRORBAR_SHOW_Z_MINUS		= 0x04FA,
	OTID_SURFACE_3DERRORBAR_TRANSPARENCY		= 0x04FB,
	/// End ORG-688-P4 THEME_ACCESS_FOR_3D_ERROR_BAR

	OTID_SURFACE_3DERRORBAR_AUTO_TRANSPARENCY	= 0x060c,	/// Kenny 07/24/2012 ORG-6234-P2 OGL_SURFACE_MISSING_THEME_ACCESS_FOR_ERRBAR_WALL

	OTID_SURFACE_3DERRORBAR_Z_CAP_WIDTH			= 0x05c5, /// Hong 03/21/2012 ORG-286 OGL_3D_ERR_BAR_SUPPORT_CAP_WIDTH

	OTID_CONTOURS								= 0x0161,
	OTID_CONTOUR								= 0x0162,
	OTID_CONTOUR_SHOW							= 0x0163,
	OTID_CONTOUR_COLORMAP						= 0x0164,
	OTID_CONTOUR_COLORMAP_LEVELS				= 0x0165,
	/// TD 9-28-03 QA70-5248 CONTOUR_LINES_SHOW_HIDE
	OTID_CONTOUR_COLORMAP_LINE_SHOW				= 0x0283,
	/// end CONTOUR_LINES_SHOW_HIDE
	OTID_CONTOUR_COLORMAP_COLORS				= 0x0166,
	OTID_CONTOUR_COLORMAP_LABELS				= 0x0167,
	/// RVD 9/29/2005 v8.0312 THEME_COLORMAP_RESCALE
	OTID_CONTOUR_COLORMAP_RESCALE_MODE			= 0x03bb,
	/// end THEME_COLORMAP_RESCALE

	/// Kenny 06/18/2012 ORG-5973-P1 OGL_CONTOUR_SMOOTH_FILL_COLOR_THEME_ACCESS
	OTID_CONTOUR_COLORMAP_SMOOTH_FILL_COLOR			= 0x0608,
	/// End OGL_CONTOUR_SMOOTH_FILL_COLOR_THEME_ACCESS

	OTID_CONTOUR_COLORMAP_LINECOLORS			= 0x0168,
	OTID_CONTOUR_COLORMAP_LINESTYLES			= 0x0169,
	OTID_CONTOUR_COLORMAP_LINEWIDTHS			= 0x016a,
	OTID_CONTOUR_COLORMAP_PATTERNS				= 0x016b,
	OTID_CONTOUR_COLORMAP_PATTERNCOLORS			= 0x016c,
	OTID_CONTOUR_COLORMAP_PATTERNWIDTHS			= 0x016d,
	OTID_CONTOUR_COLORMAP_FILLCNTRL				= 0x016e,
	OTID_CONTOUR_COLORMAP_FILLCHECK				= 0x042d,	/// RVD 2/18/2009 qa70-13143 THEME_COLORMAP_FILLCHECK
	OTID_CONTOUR_COLORMAP_MIXING_COLORS			= 0x016f,
	OTID_CONTOUR_COLORMAP_LOG_SCALE				= 0x0170,
	OTID_CONTOUR_COLORMAP_USE_MISSING			= 0x0171,
	OTID_CONTOUR_COLORMAP_COUNT					= 0x0172,
	OTID_CONTOUR_COLORMAP_MIN					= 0x01d8,
	OTID_CONTOUR_COLORMAP_MAX					= 0x01d9,
	///Kyle 09/07/2009 QA80-14261 COLORMAP_THEME_IMPROVEMENTS
	OTID_CONTOUR_COLORMAP_MAJOR_LEVELS			= 0x0465,
	OTID_CONTOUR_COLORMAP_MINOR_LEVELS			= 0x0466,
	OTID_CONTOUR_COLORMAP_INCREMENT				= 0x0467,
	OTID_CONTOUR_COLORMAP_SET_LEVELS_BY			= 0x0468,
	///------ Folger 08/11/10 ORG-705-P4 COLORMAP_FIRST_TICK_IN_THEME
	OTID_CONTOUR_COLORMAP_FIRST_LEVEL			= 0x0525,
	///------ End COLORMAP_FIRST_TICK_IN_THEME
	OTID_CONTOUR_COLORMAP_LINK_TO_PALETTE		= 0x0469,
	///Kyle 11/30/2010 ORG-1591-P2 OC_APPLY_PALETTE_SUPPORT_UNDO
	OTID_CONTOUR_COLORMAP_FLIP_PAL				= 0x0541,
	OTID_CONTOUR_COLORMAP_STRETCH_PAL			= 0x0542,
	///End OC_APPLY_PALETTE_SUPPORT_UNDO
	OTID_CONTOUR_COLORMAP_PALETTE				= 0x046a,
	OTID_CONTOUR_COLORMAP_LABELS_ON_MAAJOR		= 0x046b,
	OTID_CONTOUR_COLORMAP_LINES_ON_MAAJOR		= 0x046c,
	///End COLORMAP_THEME_IMPROVEMENTS
	OTID_CONTOUR_COLORMAP_DETAILS				= 0x0173,
	OTID_CONTOUR_COLORMAP_MISSING				= 0x0174,
	OTID_CONTOUR_COLORMAP_MISSING_VALUE			= 0x0175,
	OTID_CONTOUR_COLORMAP_MISSING_COLOR			= 0x0176,
	OTID_CONTOUR_COLORMAP_MISSING_PATTERN		= 0x0177,
	OTID_CONTOUR_COLORMAP_MISSING_PATTERNCOLOR	= 0x0178,
	OTID_CONTOUR_COLORMAP_MISSING_PATTERNWIDTH	= 0x0179,
	OTID_CONTOUR_COLORMAP_MISSING_LINECOLOR		= 0x017a,
	OTID_CONTOUR_COLORMAP_MISSING_LINESTYLE		= 0x017b,
	OTID_CONTOUR_COLORMAP_MISSING_LINEWIDTH		= 0x017c,
	OTID_CONTOUR_COLORMAP_BELOW					= 0x017d,
	OTID_CONTOUR_COLORMAP_BELOW_VALUE			= 0x017e,
	OTID_CONTOUR_COLORMAP_BELOW_COLOR			= 0x017f,
	OTID_CONTOUR_COLORMAP_BELOW_PATTERN			= 0x0180,
	OTID_CONTOUR_COLORMAP_BELOW_PATTERNCOLOR	= 0x0181,
	OTID_CONTOUR_COLORMAP_BELOW_PATTERNWIDTH	= 0x0182,
	OTID_CONTOUR_COLORMAP_BELOW_LINECOLOR		= 0x0183,
	OTID_CONTOUR_COLORMAP_BELOW_LINESTYLE		= 0x0184,
	OTID_CONTOUR_COLORMAP_BELOW_LINEWIDTH		= 0x0185,
	OTID_CONTOUR_COLORMAP_ABOVE					= 0x0186,
	OTID_CONTOUR_COLORMAP_ABOVE_VALUE			= 0x0187,
	OTID_CONTOUR_COLORMAP_ABOVE_COLOR			= 0x0188,
	OTID_CONTOUR_COLORMAP_ABOVE_PATTERN			= 0x0189,
	OTID_CONTOUR_COLORMAP_ABOVE_PATTERNCOLOR	= 0x018a,
	OTID_CONTOUR_COLORMAP_ABOVE_PATTERNWIDTH	= 0x018b,
	OTID_CONTOUR_COLORMAP_ABOVE_LINECOLOR		= 0x018c,
	OTID_CONTOUR_COLORMAP_ABOVE_LINESTYLE		= 0x018d,
	OTID_CONTOUR_COLORMAP_ABOVE_LINEWIDTH		= 0x018e,
	/// RVD 8/8/2006 QA80-8893 v8.0459 COLORMAP_SHOW_ABOVE_LINE_LABEL
	OTID_CONTOUR_COLORMAP_ABOVE_LINE			= 0x03e4,
	OTID_CONTOUR_COLORMAP_ABOVE_LABEL			= 0x03e5,
	/// end COLORMAP_SHOW_ABOVE_LINE_LABEL
	OTID_CONTOUR_NUMERICFORMAT					= 0x018f,
	OTID_CONTOUR_NUMERICFORMAT_FORMAT			= 0x0190,
	OTID_CONTOUR_NUMERICFORMAT_DIVBYFACTOR		= 0x0191,
	OTID_CONTOUR_NUMERICFORMAT_DIGITCNTRL		= 0x0192,
	OTID_CONTOUR_NUMERICFORMAT_DECDIGITS		= 0x0193,
	OTID_CONTOUR_NUMERICFORMAT_SIGDIGITS		= 0x0194,
	OTID_CONTOUR_NUMERICFORMAT_PREFIX			= 0x0195,
	OTID_CONTOUR_NUMERICFORMAT_SUFFIX			= 0x0196,
	OTID_CONTOUR_NUMERICFORMAT_MINAREA			= 0x0197,
	OTID_CONTOUR_LABELS							= 0x0198,
	OTID_CONTOUR_LABELS_COLOR					= 0x0199,
	OTID_CONTOUR_LABELS_FACE					= 0x019a,
	OTID_CONTOUR_LABELS_SIZE					= 0x019b,
	OTID_CONTOUR_LABELS_WHITEOUT				= 0x019c,
	OTID_CONTOUR_LABELS_BOLD					= 0x019d,
	OTID_CONTOUR_LABELS_ITALIC					= 0x019e,
	OTID_CONTOUR_LABELS_UNDERLINE				= 0x019f,
	/// RVD 3/31/2009 QA70-13368 THEME_CONTOUR_BOUNDARY
	OTID_CONTOUR_INFO							= 0x043e,
	OTID_CONTOUR_INFO_BOUNDARY					= 0x043f,
	OTID_CONTOUR_INFO_BOUNDARY_X				= 0x0440,
	OTID_CONTOUR_INFO_BOUNDARY_Y				= 0x0441,
	OTID_CONTOUR_INFO_SMOOTHING					= 0x0442,
	OTID_CONTOUR_INFO_SMOOTHING_FACTOR			= 0x0443,
	OTID_CONTOUR_INFO_SMOOTHING_PARAMETER		= 0x0444,
	OTID_CONTOUR_INFO_INTERPOLATE_POLAR			= 0x0445,
	/// end THEME_CONTOUR_BOUNDARY

	/// Bill 08/03/2010 ORG-688-P3 TRANSPARENCY_THEME_SUPPORT_FOR_CONTOUR_PLOT
	OTID_CONTOUR_TRANSPARENCY					= 0x04f3,
	/// End TRANSPARENCY_THEME_SUPPORT_FOR_CONTOUR_PLOT 

	OTID_IMAGES									= 0x01a0,
	OTID_IMAGE									= 0x01a1,
	OTID_IMAGE_NUMERICFORMAT					= 0x01a2,
	OTID_IMAGE_NUMERICFORMAT_FORMAT				= 0x01a3,
	OTID_IMAGE_NUMERICFORMAT_DIVBYFACTOR		= 0x01a4,
	OTID_IMAGE_NUMERICFORMAT_DIGITCNTRL			= 0x01a5,
	OTID_IMAGE_NUMERICFORMAT_DECDIGITS			= 0x01a6,
	OTID_IMAGE_NUMERICFORMAT_SIGDIGITS			= 0x01a7,
	OTID_IMAGE_NUMERICFORMAT_PREFIX				= 0x01a8,
	OTID_IMAGE_NUMERICFORMAT_SUFFIX				= 0x01a9,
	OTID_IMAGE_COLORMAP							= 0x01aa,
	OTID_IMAGE_COLORMAP_LEVELS					= 0x01ab,
	OTID_IMAGE_COLORMAP_COLORS					= 0x01ac,
	/// RVD 9/29/2005 v8.0312 THEME_COLORMAP_RESCALE
	OTID_IMAGE_COLORMAP_RESCALE_MODE			= 0x03bc,
	/// end THEME_COLORMAP_RESCALE
	OTID_IMAGE_COLORMAP_TRANSPARENT				= 0x01ad,
	OTID_IMAGE_COLORMAP_MIXING_COLORS			= 0x01ae,
	OTID_IMAGE_COLORMAP_LOG_SCALE				= 0x01af,
	OTID_IMAGE_COLORMAP_COUNT					= 0x01b0,
	OTID_IMAGE_COLORMAP_MIN						= 0x01da,
	OTID_IMAGE_COLORMAP_MAX						= 0x01db,
	///Kyle 09/07/2009 QA80-14261 COLORMAP_THEME_IMPROVEMENTS
	OTID_IMAGE_COLORMAP_MAJOR_LEVELS			= 0x046d,
	OTID_IMAGE_COLORMAP_MINOR_LEVELS			= 0x046e,
	OTID_IMAGE_COLORMAP_INCREMENT				= 0x046f,
	OTID_IMAGE_COLORMAP_SET_LEVELS_BY			= 0x0470,
	///------ Folger 08/11/10 ORG-705-P4 COLORMAP_FIRST_TICK_IN_THEME
	OTID_IMAGE_COLORMAP_FIRST_LEVEL				= 0x0526,
	///------ End COLORMAP_FIRST_TICK_IN_THEME
	OTID_IMAGE_COLORMAP_LINK_TO_PALETTE			= 0x0471,
	///Kyle 11/30/2010 ORG-1591-P2 OC_APPLY_PALETTE_SUPPORT_UNDO
	OTID_IMAGE_COLORMAP_FLIP_PAL				= 0x0543,
	OTID_IMAGE_COLORMAP_STRETCH_PAL				= 0x0544,
	///End OC_APPLY_PALETTE_SUPPORT_UNDO
	OTID_IMAGE_COLORMAP_PALETTE					= 0x0472,
	///End COLORMAP_THEME_IMPROVEMENTS
	OTID_IMAGE_COLORMAP_DETAILS					= 0x01b1,
	OTID_IMAGE_COLORMAP_BELOW					= 0x01b2,
	OTID_IMAGE_COLORMAP_BELOW_VALUE				= 0x01b3,
	OTID_IMAGE_COLORMAP_BELOW_COLOR				= 0x01b4,
	OTID_IMAGE_COLORMAP_ABOVE					= 0x01b5,
	OTID_IMAGE_COLORMAP_ABOVE_VALUE				= 0x01b6,
	OTID_IMAGE_COLORMAP_ABOVE_COLOR				= 0x01b7,
	OTID_IMAGE_LABELS							= 0x01b8,
	OTID_IMAGE_LABELS_COLOR						= 0x01b9,
	OTID_IMAGE_LABELS_FACE						= 0x01ba,
	OTID_IMAGE_LABELS_SIZE						= 0x01bb,
	OTID_IMAGE_LABELS_WHITEOUT					= 0x01bc,
	OTID_IMAGE_LABELS_BOLD						= 0x01bd,
	OTID_IMAGE_LABELS_ITALIC					= 0x01be,
	OTID_IMAGE_LABELS_UNDERLINE					= 0x01bf,

	OTID_GROUPS									= 0x00f4,
	OTID_GROUP									= 0x00f5,
	OTID_GROUP_SHOW								= 0x00f6,
	OTID_GROUP_INC								= 0x00f7,
	OTID_GROUP_INC_LINE_STYLE					= 0x00f8,
	OTID_GROUP_INC_LINE_COLOR					= 0x00f9,
	OTID_GROUP_INC_SYMBOL_SHAPE					= 0x00fa,
	OTID_GROUP_INC_SYMBOL_EDGECOLOR				= 0x00fb,
	OTID_GROUP_INC_SYMBOL_FILLCOLOR				= 0x00fc,
	OTID_GROUP_INC_PATTERN_STYLE				= 0x00fd,
	OTID_GROUP_INC_PATTERN_COLOR				= 0x00fe,
	OTID_GROUP_INC_BK_COLOR						= 0x00ff,
	OTID_GROUP_INC_NESTER						= 0x015d,
	OTID_GROUP_INC_NESTED						= 0x015e,
	OTID_GROUP_INC_INTERIOR						= 0x015f,
	OTID_GROUP_INC_CHARACTER					= 0x0160,
	OTID_GROUP_INC_STRETCH						= 0x03ed,	/// RVD 10/4/2006 QA70-9021 v8.0493 INCREMENT_LIST_STRETCH

/// Kenny 10/28/2009 QA80-14025 TWO_COLOR_SHADING_2D_3D_BAR_PLOTS
	OTID_GROUP_INC_BK_COLOR2					= 0x0485,
	OTID_GROUP_INC_GRADIENT_TYPE				= 0x0486,
/// End QA80-14025 TWO_COLOR_SHADING_2D_3D_BAR_PLOTS

	///------ Folger 01/17/2011 ORG-1866-S4 MEAN_LINE_STYLE_IN_BOXCHART_SHOULD_BE_CONTROLLED_IN_GROUP_TAB
	OTID_GROUP_INC_LINE_STYLE2					= 0x055b,
	OTID_GROUP_INC_LINE_COLOR2					= 0x055c,
	///------ End MEAN_LINE_STYLE_IN_BOXCHART_SHOULD_BE_CONTROLLED_IN_GROUP_TAB

	OTID_GLOBAL									= 0x0100,
	OTID_GLOBAL_COLOR							= 0x0101,
	OTID_GLOBAL_FILL_COLOR						= 0x0102,
	OTID_GLOBAL_PATTERN_COLOR					= 0x0103,
	OTID_GLOBAL_SIZE							= 0x0104,
	OTID_GLOBAL_BORDER							= 0x0105,
	OTID_GLOBAL_FONT_FACE						= 0x0106,
	OTID_GLOBAL_FONT_BOLD						= 0x0107,
	OTID_GLOBAL_FONT_ITALIC						= 0x0108,
	OTID_GLOBAL_FONT_UNDERLINE					= 0x0109,
	OTID_GLOBAL_LINE_TYPE						= 0x010a,
	OTID_GLOBAL_LINE_WIDTH						= 0x010b,
	OTID_GLOBAL_FILL_TYPE						= 0x010c,
	OTID_GLOBAL_FILL_WIDTH						= 0x010d,
	
	/// RVD 4/2/2003 QA70-4197 v7.0551 GLOBALIZE_INCREMENTOR
	OTID_GLOBAL_COLOR_LIST						= 0x0209,
	OTID_GLOBAL_LINETYPE_LIST					= 0x020a,
	OTID_GLOBAL_SHAPE_LIST						= 0x020b,
	OTID_GLOBAL_INTERIOR_LIST					= 0x020c,
	OTID_GLOBAL_FILLTYPE_LIST					= 0x020d,
	/// end GLOBALIZE_INCREMENTOR

	OTID_GLOBAL_COLORMAP						= 0x01dc,
	OTID_GLOBAL_COLORMAP_LEVELS					= 0x01dd,
	OTID_GLOBAL_COLORMAP_COLORS					= 0x01de,
	OTID_GLOBAL_COLORMAP_LABELS					= 0x01df,
	/// TD 9-28-03 QA70-5248 CONTOUR_LINES_SHOW_HIDE
	OTID_GLOBAL_COLORMAP_LINE_SHOW				= 0x0284,
	/// end CONTOUR_LINES_SHOW_HIDE
	OTID_GLOBAL_COLORMAP_LINECOLORS				= 0x01e0,
	OTID_GLOBAL_COLORMAP_LINESTYLES				= 0x01e1,
	OTID_GLOBAL_COLORMAP_LINEWIDTHS				= 0x01e2,
	OTID_GLOBAL_COLORMAP_PATTERNS				= 0x01e3,
	OTID_GLOBAL_COLORMAP_PATTERNCOLORS			= 0x01e4,
	OTID_GLOBAL_COLORMAP_PATTERNWIDTHS			= 0x01e5,
	OTID_GLOBAL_COLORMAP_FILLCNTRL				= 0x01e6,
	OTID_GLOBAL_COLORMAP_FILLCHECK				= 0x042e,	/// RVD 2/18/2009 qa70-13143 THEME_COLORMAP_FILLCHECK
	OTID_GLOBAL_COLORMAP_MIXING_COLORS			= 0x01e7,
	OTID_GLOBAL_COLORMAP_LOG_SCALE				= 0x01e8,
	OTID_GLOBAL_COLORMAP_USE_MISSING			= 0x01e9,
	OTID_GLOBAL_COLORMAP_COUNT					= 0x01ea,
	OTID_GLOBAL_COLORMAP_MIN					= 0x01eb,
	OTID_GLOBAL_COLORMAP_MAX					= 0x01ec,
	///Kyle 09/07/2009 QA80-14261 COLORMAP_THEME_IMPROVEMENTS
	OTID_GLOBAL_COLORMAP_MAJOR_LEVELS			= 0x0457,
	OTID_GLOBAL_COLORMAP_MINOR_LEVELS			= 0x0458,
 	OTID_GLOBAL_COLORMAP_INCREMENT				= 0x0459,
	OTID_GLOBAL_COLORMAP_SET_LEVELS_BY			= 0x045a,
	///------ Folger 08/11/10 ORG-705-P4 COLORMAP_FIRST_TICK_IN_THEME
	OTID_GLOBAL_COLORMAP_FIRST_LEVEL			= 0x0521,
	///------ End COLORMAP_FIRST_TICK_IN_THEME
	OTID_GLOBAL_COLORMAP_LINK_TO_PALETTE		= 0x045b,
	///Kyle 11/30/2010 ORG-1591-P2 OC_APPLY_PALETTE_SUPPORT_UNDO
	OTID_GLOBAL_COLORMAP_FLIP_PAL				= 0x0545,
	OTID_GLOBAL_COLORMAP_STRETCH_PAL			= 0x0546,
	///End OC_APPLY_PALETTE_SUPPORT_UNDO
	OTID_GLOBAL_COLORMAP_PALETTE				= 0x045c,
	OTID_GLOBAL_COLORMAP_LABELS_ON_MAAJOR		= 0x045d,
	OTID_GLOBAL_COLORMAP_LINES_ON_MAAJOR		= 0x045e,
	///End COLORMAP_THEME_IMPROVEMENTS
	/// RVD 9/29/2005 v8.0312 THEME_COLORMAP_RESCALE
	OTID_GLOBAL_COLORMAP_RESCALE				= 0x03bd,
	/// end THEME_COLORMAP_RESCALE
	/// Kenny 06/18/2012 ORG-5973-P1 OGL_CONTOUR_SMOOTH_FILL_COLOR_THEME_ACCESS
	OTID_GLOBAL_COLORMAP_SMOOTH_FILL_COLOR		= 0x060a,
	/// End OGL_CONTOUR_SMOOTH_FILL_COLOR_THEME_ACCESS
	OTID_GLOBAL_COLORMAP_DETAILS				= 0x01ed,
	OTID_GLOBAL_COLORMAP_MISSING				= 0x01ee,
	OTID_GLOBAL_COLORMAP_MISSING_VALUE			= 0x01ef,
	OTID_GLOBAL_COLORMAP_MISSING_COLOR			= 0x01f0,
	OTID_GLOBAL_COLORMAP_MISSING_PATTERN		= 0x01f1,
	OTID_GLOBAL_COLORMAP_MISSING_PATTERNCOLOR	= 0x01f2,
	OTID_GLOBAL_COLORMAP_MISSING_PATTERNWIDTH	= 0x01f3,
	OTID_GLOBAL_COLORMAP_MISSING_LINECOLOR		= 0x01f4,
	OTID_GLOBAL_COLORMAP_MISSING_LINESTYLE		= 0x01f5,
	OTID_GLOBAL_COLORMAP_MISSING_LINEWIDTH		= 0x01f6,
	OTID_GLOBAL_COLORMAP_BELOW					= 0x01f7,
	OTID_GLOBAL_COLORMAP_BELOW_VALUE			= 0x01f8,
	OTID_GLOBAL_COLORMAP_BELOW_COLOR			= 0x01f9,
	OTID_GLOBAL_COLORMAP_BELOW_PATTERN			= 0x01fa,
	OTID_GLOBAL_COLORMAP_BELOW_PATTERNCOLOR		= 0x01fb,
	OTID_GLOBAL_COLORMAP_BELOW_PATTERNWIDTH		= 0x01fc,
	OTID_GLOBAL_COLORMAP_BELOW_LINECOLOR		= 0x01fd,
	OTID_GLOBAL_COLORMAP_BELOW_LINESTYLE		= 0x01fe,
	OTID_GLOBAL_COLORMAP_BELOW_LINEWIDTH		= 0x01ff,
	OTID_GLOBAL_COLORMAP_ABOVE					= 0x0200,
	OTID_GLOBAL_COLORMAP_ABOVE_VALUE			= 0x0201,
	OTID_GLOBAL_COLORMAP_ABOVE_COLOR			= 0x0202,
	OTID_GLOBAL_COLORMAP_ABOVE_PATTERN			= 0x0203,
	OTID_GLOBAL_COLORMAP_ABOVE_PATTERNCOLOR		= 0x0204,
	OTID_GLOBAL_COLORMAP_ABOVE_PATTERNWIDTH		= 0x0205,
	OTID_GLOBAL_COLORMAP_ABOVE_LINECOLOR		= 0x0206,
	OTID_GLOBAL_COLORMAP_ABOVE_LINESTYLE		= 0x0207,
	OTID_GLOBAL_COLORMAP_ABOVE_LINEWIDTH		= 0x0208,
	/// RVD 8/8/2006 QA80-8893 v8.0459 COLORMAP_SHOW_ABOVE_LINE_LABEL
	OTID_GLOBAL_COLORMAP_ABOVE_LINE				= 0x03e6,
	OTID_GLOBAL_COLORMAP_ABOVE_LABEL			= 0x03e7,
	/// end COLORMAP_SHOW_ABOVE_LINE_LABEL

	/// RVD 4/21/2003 QA70-4280 v7.0566 NEW_TEXT_BACKGROUND
	OTID_GLOBAL_BKGND							= 0x0235,
	OTID_GLOBAL_BKGND_BOUNDS					= 0x0236,
	OTID_GLOBAL_BKGND_BOUNDS_LEFT				= 0x0237,
	OTID_GLOBAL_BKGND_BOUNDS_TOP				= 0x0238,
	OTID_GLOBAL_BKGND_BOUNDS_RIGHT				= 0x0239,
	OTID_GLOBAL_BKGND_BOUNDS_BOTTOM				= 0x023a,
	OTID_GLOBAL_BKGND_BORDER					= 0x023b,
	OTID_GLOBAL_BKGND_BORDER_COLOR				= 0x023c,
	OTID_GLOBAL_BKGND_BORDER_WIDTH				= 0x023d,
	OTID_GLOBAL_BKGND_BORDER_STYLE				= 0x023e,
	OTID_GLOBAL_BKGND_FILL						= 0x023f,
	OTID_GLOBAL_BKGND_FILL_COLOR				= 0x0240,
	OTID_GLOBAL_BKGND_FILL_PATTERN				= 0x0241,
	OTID_GLOBAL_BKGND_FILL_PATTERN_COLOR		= 0x0242,
	OTID_GLOBAL_BKGND_FILL_PATTERN_STYLE		= 0x0243,
	OTID_GLOBAL_BKGND_FILL_PATTERN_WIDTH		= 0x0244,
	OTID_GLOBAL_BKGND_SHADOW					= 0x0245,
	OTID_GLOBAL_BKGND_SHADOW_STYLE				= 0x0246,
	OTID_GLOBAL_BKGND_SHADOW_WIDTH				= 0x0247,
	OTID_GLOBAL_BKGND_SHADOW_COLOR				= 0x0248,
	/// end NEW_TEXT_BACKGROUND

	/// RVD 10/16/2003 QA70-5367 v7.5721 NEW_WORKBOOK
	OTID_WORKBOOK								= 0x0285,
	OTID_SHEETS									= 0x0286,
	OTID_SHEET									= 0x0287,
	
	OTID_NAMESTYLES								= 0x0288,
	OTID_NAMESTYLE								= 0x0289,
	OTID_NAMESTYLE_NAME							= 0x028a,
	
	OTID_RANGESTYLES							= 0x028b,
	OTID_RANGESTYLE								= 0x028c,
	OTID_RANGESTYLE_LEFT						= 0x028d,
	OTID_RANGESTYLE_RIGHT						= 0x028e,
	OTID_RANGESTYLE_TOP							= 0x028f,
	OTID_RANGESTYLE_BOTTOM						= 0x0290,

	/// RVD 10/9/2006 QA80-9020 v8.0494 GLOBAL_RANGE_THEME
	OTID_COMMONSTYLE							= 0x03ef,
	/// end GLOBAL_RANGE_THEME

	OTID_STYLE									= 0x0291,
	OTID_STYLE_COLOR							= 0x0292,
	OTID_STYLE_FILL								= 0x0293,
	OTID_STYLE_FILL_COLOR						= 0x0294,
	/// RVD 2/16/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT
	OTID_STYLE_FILL_PATTERN						= 0x0340,
	OTID_STYLE_FILL_PATTERN_COLOR				= 0x0341,
	OTID_STYLE_FILL_PATTERN_STYLE				= 0x0342,
	OTID_STYLE_FILL_PATTERN_WIDTH				= 0x0343,
	OTID_STYLE_BASE								= 0x0344,
	OTID_STYLE_CONTROL							= 0x0345,
	OTID_STYLE_CHOICELIST						= 0x03e0,
	/// end WKS_THEME_SUPPORT
	/// RVD 5/6/2005 v8.0231 WKS_MERGE_FLOAT_CELLS_THEME_ACCESS
	OTID_STYLE_FLOAT							= 0x0356,
	OTID_STYLE_FLOOD							= 0x0357,
	OTID_STYLE_MERGE							= 0x0358,
	/// end WKS_MERGE_FLOAT_CELLS_THEME_ACCESS
	/// RVD 7/26/2005 QA70-7714 v8.0275 GRID_VALUE_FORMAT
	OTID_STYLE_FORMAT							= 0x0372,
	/// end GRID_VALUE_FORMAT
	/// RVD 6/6/2006 QA70-8723 CREATE_LINK_TABLE
	OTID_STYLE_SHOWMISSINGBLANK					= 0x03d3,
	/// end CREATE_LINK_TABLE
	/// RVD 2/6/2008 qa70-11067 CLEANUP_INCORRECT_MERGED_CELLS
	OTID_STYLE_MERGEEMPTY						= 0x0422,
	/// end CLEANUP_INCORRECT_MERGED_CELLS
	/// RVD 8/17/2005 v8.0290 THEME_ACCESS_WRAP_TEXT
	OTID_STYLE_WRAP								= 0x037f,
	/// end THEME_ACCESS_WRAP_TEXT
	/// RVD 7/6/2007 v8.0656 WKS_ELLIPSIS
	OTID_STYLE_ELLIPSIS							= 0x0419,
	/// end WKS_ELLIPSIS
	/// RVD 7/23/2007 qa70-10093 v8.0666 WKS_READONLY
	OTID_STYLE_READONLY							= 0x041a,
	/// end WKS_READONLY
	OTID_STYLE_ALLOW_ENTER						= 0x03d0,
	OTID_STYLE_ALIGNMENT						= 0x0295,
	OTID_STYLE_ALIGNMENT_HORIZONTAL				= 0x0296,
	OTID_STYLE_ALIGNMENT_VERTICAL				= 0x0297,
	OTID_STYLE_FONT								= 0x0298,
	OTID_STYLE_FONT_FACE						= 0x0299,
	OTID_STYLE_FONT_SIZE						= 0x029a,
	OTID_STYLE_FONT_BOLD						= 0x029b,
	OTID_STYLE_FONT_ITALIC						= 0x029c,
	OTID_STYLE_FONT_UNDERLINE					= 0x029d,
	OTID_STYLE_FONT_STRIKEOUT					= 0x029e,

	OTID_GRIDS									= 0x029f,
	OTID_GRID									= 0x0300,

	OTID_TABLES									= 0x0301,
	OTID_TABLE									= 0x0302,
	/// end NEW_WORKBOOK

	/// YuI 11/29/04 v7.5169 QA70-7199 THEME_ACCESS_TO_BOXCHART
	OTID_BOXCHART_INFO							= 0x0305,
	OTID_BOXCHART_INFO_BIN						= 0x0306,
	OTID_BOXCHART_INFO_BIN_AUTO					= 0x0307,
	OTID_BOXCHART_INFO_BIN_BEGIN				= 0x0308,
	OTID_BOXCHART_INFO_BIN_END					= 0x0309,
	OTID_BOXCHART_INFO_BIN_SIZE					= 0x030a,
	
	OTID_BOXCHART_INFO_BOX						= 0x030b,
	OTID_BOXCHART_INFO_BOX_TYPE					= 0x030c,
	OTID_BOXCHART_INFO_BOX_RANGE				= 0x030d,
	OTID_BOXCHART_INFO_BOX_WHISKER_RANGE		= 0x030e,
	OTID_BOXCHART_INFO_BOX_BIN_HEIGHT			= 0x030f,
	OTID_BOXCHART_INFO_BOX_BIN_ALIGN			= 0x0310,

	OTID_BOXCHART_INFO_BOX_BOX_COEFF			= 0x0311,
	OTID_BOXCHART_INFO_BOX_WHISKER_COEFF		= 0x0312,
	
	OTID_BOXCHART_INFO_BOX_SYMBOL_SHAPE_1		= 0x0313,
	OTID_BOXCHART_INFO_BOX_SYMBOL_SHAPE_99		= 0x0314,
	OTID_BOXCHART_INFO_BOX_SYMBOL_SHAPE_MEAN	= 0x0315,
	OTID_BOXCHART_INFO_BOX_SYMBOL_SHAPE_MIN		= 0x0316,
	OTID_BOXCHART_INFO_BOX_SYMBOL_SHAPE_MAX		= 0x0317,

	OTID_BOXCHART_INFO_BOX_SYMBOL_INTERIOR_1	= 0x0318,
	OTID_BOXCHART_INFO_BOX_SYMBOL_INTERIOR_99	= 0x0319,
	OTID_BOXCHART_INFO_BOX_SYMBOL_INTERIOR_MEAN	= 0x031a,
	OTID_BOXCHART_INFO_BOX_SYMBOL_INTERIOR_MIN	= 0x031b,
	OTID_BOXCHART_INFO_BOX_SYMBOL_INTERIOR_MAX	= 0x031c,

	OTID_BOXCHART_INFO_BOX_CHAR_INDEX_1			= 0x031d,
	OTID_BOXCHART_INFO_BOX_CHAR_INDEX_99		= 0x031e,
	OTID_BOXCHART_INFO_BOX_CHAR_INDEX_MEAN		= 0x031f,
	OTID_BOXCHART_INFO_BOX_CHAR_INDEX_MIN		= 0x0320,
	OTID_BOXCHART_INFO_BOX_CHAR_INDEX_MAX		= 0x0321,

	OTID_BOXCHART_INFO_BOX_CHAR_FONT_1			= 0x0322,
	OTID_BOXCHART_INFO_BOX_CHAR_FONT_99			= 0x0323,
	OTID_BOXCHART_INFO_BOX_CHAR_FONT_MEAN		= 0x0324,
	OTID_BOXCHART_INFO_BOX_CHAR_FONT_MIN		= 0x0325,
	OTID_BOXCHART_INFO_BOX_CHAR_FONT_MAX		= 0x0326,

	OTID_BOXCHART_INFO_BOX_CHAR_STYLE_1			= 0x0327,
	OTID_BOXCHART_INFO_BOX_CHAR_STYLE_99		= 0x0328,
	OTID_BOXCHART_INFO_BOX_CHAR_STYLE_MEAN		= 0x0329,
	OTID_BOXCHART_INFO_BOX_CHAR_STYLE_MIN		= 0x032a,
	OTID_BOXCHART_INFO_BOX_CHAR_STYLE_MAX		= 0x032b,

	OTID_BOXCHART_INFO_BOX_SYMBOL_SIZE			= 0x032c,
	OTID_BOXCHART_INFO_BOX_SYMBOL_FILL_COLOR	= 0x032d,
	OTID_BOXCHART_INFO_BOX_SYMBOL_EDGE_COLOR	= 0x032e,

	OTID_BOXCHART_INFO_BOX_CURVE_TYPE			= 0x032f,
	OTID_BOXCHART_INFO_BOX_CURVE_SCALE			= 0x0330,
	/// end THEME_ACCESS_TO_BOXCHART

	/// Kenny 03/23/2011 ORG-939-P3 OPTIONS_ON_BOX_TAB_FOR_BOX_CHART_IS_MISSING_IN_THEME_FORMAT
	OTID_BOXCHART_INFO_BOX_HAS_OUTLIERS			= 0x056a,
	OTID_BOXCHART_INFO_BOX_HAS_DIAMOND_BOX		= 0x056b,
	OTID_BOXCHART_INFO_BOX_HAS_BOX_LABEL		= 0x056c,
	OTID_BOXCHART_INFO_BOX_HAS_WHISKER_LABEL	= 0x056d,
	OTID_BOXCHART_INFO_BOX_HAS_MEAN_LINE		= 0x056e,

	OTID_BOXCHART_BOX							= 0x056f,	// branch
	OTID_BOXCHART_BOX_WIDTH						= 0x0570,
	/// End OPTIONS_ON_BOX_TAB_FOR_BOX_CHART_IS_MISSING_IN_THEME_FORMAT

	/// Kenny 03/05/2011 ORG-939-P1 OPTIONS_ON_DATA_TAB_FOR_HISTOGRAM_IS_MISSING_IN_THEME_FORMAT
	OTID_BOXCHART_INFO_PERCENTILE				= 0x0564,	// branch
	OTID_BOXCHART_INFO_DOT_PLOT_TYPE			= 0x0565,
	OTID_BOXCHART_INFO_SINGLE_BLOCK				= 0x0566,
	OTID_BOXCHART_INFO_SNAP_DATA				= 0x0567,
	OTID_BOXCHART_INFO_BY_INTERVALS				= 0x0568,
	OTID_BOXCHART_INFO_INTERVALS				= 0x0569,
	/// End ORG-939-P1 OPTIONS_ON_DATA_TAB_FOR_HISTOGRAM_IS_MISSING_IN_THEME_FORMAT

	/// RVD 1/19/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT
	OTID_WKSCOLUMNS								= 0x0331,
	OTID_WKSCOLUMN								= 0x0332,
	OTID_WKSCOLUMN_DATA							= 0x0333,
	/// RVD 7/28/2005 QA70-7939 v8.0277 COLUMN_THEME_ACCESS
	OTID_WKSCOLUMN_SHORTNAME					= 0x0373,
	OTID_WKSCOLUMN_LONGNAME						= 0x0374,
	OTID_WKSCOLUMN_COMMENT						= 0x0375,
	OTID_WKSCOLUMN_UNIT							= 0x0376,
	OTID_WKSCOLUMN_TYPE							= 0x0377,
	OTID_WKSCOLUMN_FORMAT						= 0x0378,
	OTID_WKSCOLUMN_WIDTH						= 0x0379,
	OTID_WKSCOLUMN_FORMULA						= 0x037a,
	OTID_WKSCOLUMN_DISPLAY						= 0x037b,
	OTID_WKSCOLUMN_NUMDISPLAY					= 0x037c,
	OTID_WKSCOLUMN_DIGITS						= 0x037d,
	OTID_WKSCOLUMN_INTDATA						= 0x037e,
	/// end COLUMN_THEME_ACCESS
	/// EJP 2006-10-20 v8.0498 QA70-8741 THEME_ACCESS_COL_CUSTOM_DATE_FORMAT
	OTID_WKSCOLUMN_CUSTOMFORMAT					= 0x03f0,
	/// end THEME_ACCESS_COL_CUSTOM_DATE_FORMAT

	OTID_LINKSTYLES								= 0x0334,
	OTID_LINKSTYLE								= 0x0335,
	OTID_LINKSTYLE_NAME							= 0x0336,
	OTID_VECTORS								= 0x0337,
	OTID_VECTOR									= 0x0338,
	OTID_VECTOR_DATA							= 0x0339,

	OTID_GRID_DIMS								= 0x033a,
	OTID_GRID_DIM								= 0x033b,
	OTID_GRID_DIM_LINES							= 0x033c,
	OTID_GRID_DIM_HEADER						= 0x033d,
	OTID_GRID_DIM_LABELTYPES					= 0x033e,
	/// RVD 7/11/2006 GRID_LABELS_THEME
	OTID_GRID_DIM_LABELS						= 0x03da,
	OTID_GRID_DIM_LABEL							= 0x03db,
	OTID_GRID_DIM_LABEL_TYPE					= 0x03dc,
	OTID_GRID_DIM_LABEL_DATA					= 0x03dd,
	OTID_GRID_DIM_HIDES							= 0x03de,
	OTID_GRID_DIM_SIZES							= 0x03df,
	/// end GRID_LABELS_THEME
	OTID_GRID_DIM_UDLS							= 0x041f,	/// RVD 8/9/2007 USER_DEFINED_LABELS

	/// RVD 2/26/2008 qa70-11177 THEME_ACCESS_COVER_CELLS
	OTID_GRID_COVER_RANGES						= 0x0423,
	OTID_GRID_COVER_RANGE						= 0x0424,
	OTID_GRID_COVER_RANGE_LEFT					= 0x0425,
	OTID_GRID_COVER_RANGE_TOP					= 0x0426,
	OTID_GRID_COVER_RANGE_RIGHT					= 0x0427,
	OTID_GRID_COVER_RANGE_BOTTOM				= 0x0428,
	/// end THEME_ACCESS_COVER_CELLS

	OTID_GRID_BKCOLOR							= 0x033f,
	/// end WKS_THEME_SUPPORT
	/// RVD 5/6/2005 v8.0231 WKS_MERGE_FLOAT_CELLS_THEME_ACCESS
	OTID_GRID_FLOATMODE							= 0x0359,
	OTID_GRID_MERGEMODE							= 0x035a,
	/// end WKS_MERGE_FLOAT_CELLS_THEME_ACCESS
	/// RVD 6/6/2006 QA70-8723 CREATE_LINK_TABLE
	OTID_GRID_GAPFROMTOP						= 0x03d1,
	OTID_GRID_AUTOROWS							= 0x03d2,
	/// end CREATE_LINK_TABLE
	/// RVD 7/5/2006 EXPAND_SERIES_FILL
	OTID_GRID_EXPANDDATAFILL					= 0x03d8,
	/// end EXPAND_SERIES_FILL
	/// RVD 6/13/2006 QA70-8615 TABLE_HEADER
	OTID_GRID_HEADER							= 0x03d4,
	OTID_GRID_HEADER_TYPE						= 0x03d5,
	OTID_GRID_FOOTNOTE							= 0x03d6,
	OTID_GRID_FOOTNOTE_TYPE						= 0x03d7,
	/// end TABLE_HEADER
	/// RVD 7/10/2006 GRID_CNTRL_THEME
	OTID_GRID_CNTRL								= 0x03d9,
	/// end GRID_CNTRL_THEME
	/// RVD 7/25/2006 QA70-8856 v8.0450 PASTE_TABLE_INTERMEDIATE_WKS
	OTID_GRID_REPORTUID							= 0x03e1,
	/// end PASTE_TABLE_INTERMEDIATE_WKS
	/// RVD 7/23/2007 qa70-10093 v8.0666 WKS_READONLY
	OTID_GRID_READONLY							= 0x041b,
	/// end WKS_READONLY
	/// RVD 7/24/2007 qa70-10089 v8.0667 ACCESS_DEFAULT_ROW_HEIGHT_COL_WIDTH
	OTID_GRID_DEFAULT_COL_WIDTH					= 0x041c,
	OTID_GRID_DEFAULT_ROW_HEIGHT				= 0x041d,
	/// end ACCESS_DEFAULT_ROW_HEIGHT_COL_WIDTH
	OTID_GRID_ZOOM								= 0x0429,	/// RVD 4/4/2008 QA70-11311 v8.0838 WKS_ZOOM

	/// RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS
	OTID_ANCHORS								= 0x0346,
	OTID_ANCHOR									= 0x0347,
	OTID_ANCHOR_DATA							= 0x0348,
	OTID_ANCHOR_DATA_X							= 0x0349,
	OTID_ANCHOR_DATA_Y							= 0x034a,

	/// Kenny 05/20/2011 ORG-2686-S1 IMPLEMENT_3DGL_LINE_OBJECT
	OTID_ANCHOR_DATA_Z							= 0x0595,
	/// End IMPLEMENT_3DGL_LINE_OBJECT

	OTID_ANCHOR_ID								= 0x034b,
	OTID_ANCHOR_FOLLOW							= 0x0350,
	OTID_ANCHOR_USERDATA						= 0x0351,
	OTID_ANCHOR_EVENTID							= 0x0352,
	OTID_ANCHOR_SENDERID						= 0x0353,
	OTID_ANCHOR_SENDERPARAM						= 0x0355,
	OTID_ANCHOR_NOTIFY							= 0x035b,
	OTID_ANCHOR_DELETEPARENT					= 0x03be,	/// RVD 11/21/2005 QA80-8337 v8.0340 ANCHOR_DELETE_PARENT
	OTID_ANCHOR_ACTIVE_HANDLE					= 0x042a,	/// RVD 1/23/2009 QA80-13011 PA_MARKER_ACTIVATION
	/// RVD 2/17/2009 QA70-13131 ANCHOR_KEY_EVENTS
	OTID_ANCHOR_WPARAM							= 0x042b,
	OTID_ANCHOR_LPARAM							= 0x042c,
	/// end ANCHOR_KEY_EVENTS
	OTID_ANCHOR_SELECT							= 0x0563,	/// RVD 2/25/2011 ORG-2245 PRESELECT_LINE_ANCHOR_VERTICAL_TRANSLATE_XF

	OTID_ANCHOR_TRANSIENT						= 0x035c,
	OTID_ANCHOR_TRANSIENT_XFORM					= 0x035d,
	OTID_ANCHOR_TRANSIENT_XFORM_M11				= 0x035e,
	OTID_ANCHOR_TRANSIENT_XFORM_M12				= 0x035f,
	OTID_ANCHOR_TRANSIENT_XFORM_M21				= 0x0360,
	OTID_ANCHOR_TRANSIENT_XFORM_M22				= 0x0361,
	OTID_ANCHOR_TRANSIENT_XFORM_DX				= 0x0362,
	OTID_ANCHOR_TRANSIENT_XFORM_DY				= 0x0363,
	OTID_ANCHOR_TRANSIENT_DATA					= 0x0364,
	OTID_ANCHOR_TRANSIENT_DATA_X				= 0x0365,
	OTID_ANCHOR_TRANSIENT_DATA_Y				= 0x0366,

	OTID_GROBJ_BEHINDDATA						= 0x0354,
	/// RVD 6/23/2005 v8.0256 QA70-7798 SPAN_RECT_TO_LAYER
	OTID_GROBJ_DIRECTION						= 0x034e,
	OTID_GROBJ_SPAN								= 0x034f,
	/// end SPAN_RECT_TO_LAYER
	/// end XFUNCTION_ANCHORS
	/// RVD 8/11/2006 QA80-8896 v8.0461 THEME_ACCESS_GR_SCRIPT
	OTID_GROBJ_CMD								= 0x03e8,
	OTID_GROBJ_CMDTYPE							= 0x03e9,
	/// end THEME_ACCESS_GR_SCRIPT
	//---- CPY 8/14/06 QA80-8896 ADD_KEEPINSIDE_TO_THEME
	OTID_GROBJ_KEEPINSIDE						= 0x03ea, 
	OTID_GROBJ_ALLOW_CONTEXT_MENU				= 0x05d6,		///Kyle 05/10/2012 ORG-3115-P1 CONTEXT_MENU_CONTROL_FOR_OPENGL_GRAPH_OBJ
	OTID_GROBJ_STATES							= 0x03eb,
	OTID_GROBJ_SELECTABLE						= 0x03ec,
	//----
	///Kyle 07/14/2010 ORG-571-S1 NO_SELECT_EFFECT_FOR_GRAPH_OBJECT
	OTID_GROBJ_REVVIDEO							= 0x04ef,
	OTID_GROBJ_SELECTEFFECT						= 0x04f0,
	///End NO_SELECT_EFFECT_FOR_GRAPH_OBJECT

	OTID_GROBJ_ALLOW_DBCLICK					= 0x04f1,		///Kyle 07/16/2010 ORG-584-S2 PREVENT_DB_CLICK_ON_GRAPH_OBJECT
	OTID_GROBJ_KEEP_ASPECT_RATIO				= 0x05d9,		/// RVD 5/14/2012 ORG-5693 THEME_SUPPORT_ASPECT_RATIO_OLD_WKS_PLOT_OBJ

	OTID_GROBJ_TRANSPARENCY						= 0x0607,		/// Zech 06/14/2012 ORG-5956-S1 2D_GROBJ_SUPPORT_TRANSPARENCY
	
	/// RVD 7/9/2009 QA70-13828 RECESS_BARS_DRAW_THEME
	/* CPY 7/24/09 MOVE_RECESSION_BAR_TO_82, turn off until #ifdef _RECESSION_BARS_
	// recession bars
	OTID_RECESSIONS								= 0x044e,
	OTID_RECESSION								= 0x044f,
	OTID_RECESSION_SHOW							= 0x0450,
	OTID_RECESSION_DATA							= 0x0451,
	OTID_RECESSION_DATA_START					= 0x0452,
	OTID_RECESSION_DATA_END						= 0x0453,
	OTID_RECESSION_LINE							= 0x0454,
	OTID_RECESSION_LINE_COLOR					= 0x0455,
	OTID_RECESSION_LINE_STYLE					= 0x0456,
	OTID_RECESSION_LINE_WIDTH					= 0x0457,
	OTID_RECESSION_FILL							= 0x0458,
	OTID_RECESSION_FILL_COLOR					= 0x0459,
	OTID_RECESSION_FILL_PATTERN					= 0x045a,
	*/
	/// end RECESS_BARS_DRAW_THEME

	/// RVD 5/24/2005 QA70-7759 v8.0240 GRID_BORDER
	OTID_BORDERS								= 0x0367,
	OTID_BORDER									= 0x0368,
	OTID_BORDER_SHOW							= 0x0369,
	OTID_BORDER_COLOR							= 0x036a,
	OTID_BORDER_STYLE							= 0x036b,
	OTID_BORDER_WIDTH							= 0x036c,
	/// end GRID_BORDER

	/// RVD 6/10/2005 v8.0249 REPEATITIVE_STYLES_IN_GRID_THEMES
	OTID_REPEATINFOS							= 0x036d,
	OTID_REPEATINFO								= 0x036e,
	OTID_REPEATINFO_PERIOD						= 0x036f,
	OTID_REPEATINFO_COUNT						= 0x0370,
	OTID_REPEATINFO_OFFSET						= 0x0371,
	/// end REPEATITIVE_STYLES_IN_GRID_THEMES

	/// RVD 2/17/2006 QA70-8359 TABLE_FOOTNOTE
	OTID_MARGIN									= 0x03c4,
	OTID_MARGIN_LEFT							= 0x03c5,
	OTID_MARGIN_RIGHT							= 0x03c6,
	OTID_MARGIN_TOP								= 0x03c7,
	OTID_MARGIN_BOTTOM							= 0x03c8,
	/// end TABLE_FOOTNOTE

	/// RVD 2/24/2006 v8.0369 QA70-7754 ANNOTATIONS
	OTID_ANNOTATIONS							= 0x03c9,
	OTID_ANNOTATION								= 0x03ca,
	OTID_ANNOTATION_LABEL						= 0x03cb,
	OTID_ANNOTATION_TETHER						= 0x03cc,
	OTID_ANNOTATION_REFERENCE					= 0x03cd,
	OTID_ANNOTATION_XOFFSET						= 0x03ce,
	OTID_ANNOTATION_YOFFSET						= 0x03cf,
	/// end ANNOTATIONS

	/// RVD 11/1/2006 QA70-9092 v8.0504 SPECIAL_POINT_THEME
	OTID_SPECIALPOINTS							= 0x040b,
	OTID_SPECIALPOINT							= 0x040c,
	OTID_SPECIALPOINT_INDEX						= 0x040d,
	/// end SPECIAL_POINT_THEME

	//--- CPY 7/31/07 QA70-10134 ROMAN_FOUND_CP_REUSED_ID_ALREADY_USED_LEAD_TO_HONG_REPORTED_SCRIPT_DUMP_ON_THEME_ACCESS
	// 0x041e is used instead
	//---
}	OTHEMEID;

#endif	//!__OKTHEMEID_H__
