/*------------------------------------------------------------------------------*
 * File Name: matdata_utils.c 													*
 * Creation: 2006-12-11															*
 * Purpose: matrix data functions, ROI tec										*
 * Copyright (c) OriginLab Corp. 2006											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _MAT_DATA_UTILS_H
#define _MAT_DATA_UTILS_H

#include <ocImgLT.h>
#include <oImgLTex.h>
//#include <image_utils.h>

///Sandy 2006-12-19 MOVE_TO_IMAGE_LPROFLIE_DATA
/*
///---Sim 12-11-2006 GET_IMAGE_LINE_PROFILE
bool get_matrix_line_profile(GraphObject& go, MatrixObject& mo, vector& vxPoints, vector& vyPoints, vector& vIntensity);
///---END GET_IMAGE_LINE_PROFILE
*/


//Sandy 2006-12-9 PALLETE_NEED_WHEN_8BITS
/**$
	Remarks:
		convert numeric matrix object to gray scale image
	Parameters:
		moSource = [input] matrix object to be convert.
		moLBitmap = [output] matrix object contained the Image converted.
		dMin = [input] the value as the black.
		dMax = [input] the value as the white.
		nBits = [input] Destination bits. Support 8, 12, 16 bits grayscale.		
		hPalette = [input] palette handle to apply to the destination Image
	Return: 
		return zero if successful
	SeeAlso:
		image_duplicate_palette
*/


//int image_convert_from_data(const MatrixObject& moSource, MatrixObject& moLBitmap, double dMin, double dMax, int nBits = 16);
int image_convert_from_data(const MatrixObject& moSource, MatrixObject& moLBitmap, 
						double dMin, double dMax, int nBits = 16, const HPALETTE hPalette = NULL);
						
						
//Comments last updated by Stacy on 7/23/2009						
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:image_to_gray_(global_function)
*/
int image_to_gray(MatrixObject& mo, int nbits);

//Comments last updated by Stacy on 7/23/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:image_to_gray_(global_function)
*/
int image_to_gray(BITMAPHANDLE* pLBmp, int nbits);

//Comments last updated by Stacy on 7/23/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_image_grayscale_(global_function)
*/
bool is_image_grayscale(MatrixObject& mo);
	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_image_grayscale_(global_function)
*/
bool is_image_grayscale(BITMAPHANDLE* pLBmp);

						
/**$
	Remarks:
		Split a matrix object into three matrix objects representing the red, green, and blue intensity values.
	Parameters:
		moSource = [input] matrix object to be split.
		moRed = [output] matrix object representing the red intensity values.
		moGreen = [output] matrix object representing the green intensity values.
		moBlue = [output] matrix object representing the blue intensity values.
		bRenameAccordingToChannel = [input] if TRUE default names "Red" "Green" and "Blue" are assigned to output matrix objects
			
	Return: 
		SUCCESS or a LeadTools error number less than zero.
	SeeAlso:
		image_merge_rgb
*/
int image_split_rgb(const MatrixObject& moSource, MatrixObject& moRed, MatrixObject& moGreen, MatrixObject& moBlue, BOOL bRenameAccordingToChannel = TRUE);

/**$
	Remarks:
		Split an Image into three Images representing the red, green, and blue intensity values.
	Parameters:
		imgSource = [input] Image to be split.
		imgRed = [output] Image representing the red intensity values.
		imgGreen = [output] Image representing the green intensity values.
		imgBlue = [output] Image representing the blue intensity values.
					
	Return: 
		SUCCESS or a LeadTools error number less than zero.
	SeeAlso:
		image_merge_rgb
*/
int image_split_rgb(const Image& imgSource, Image& imgRed, Image& imgGreen, Image& imgBlue);

/**$
	Remarks:
		Merge three matrix objects into a single matrix object.
	Parameters:
		moTarget = [output] matrix object to recieve the merge.
		moRed = [input] matrix object representing the red intensity values.
		moGreen = [input] matrix object representing the green intensity values.
		moBlue = [input] matrix object representing the blue intensity values.

	Return: 
		SUCCESS or a LeadTools error number less than zero.
	SeeAlso:
		image_split_rgb
*/
int image_merge_rgb(MatrixObject& moTarget, const MatrixObject& moRed, const MatrixObject& moGreen, const MatrixObject& moBlue);

/**$
	Remarks:
		Merge three Images into a single Image.
	Parameters:
		imgTarget = [output] matrix object to recieve the merge.
		imgRed = [input] matrix object representing the red intensity values.
		imgGreen = [input] matrix object representing the green intensity values.
		imgBlue = [input] matrix object representing the blue intensity values.

	Return: 
		SUCCESS or a LeadTools error number less than zero.
	SeeAlso:
		image_split_rgb
*/
int image_merge_rgb(Image& imgTarget, const Image& imgRed, const Image& imgGreen, const Image& imgBlue);


//------Sandy 10/9/2005, for get image data range from color bit
//no support ROMM order(will return 0)
/**$
*/
int get_image_data_max_val(pBITMAPHANDLE BmpHdl);


///Sandy 2006-12-9 add	
/**$
	Remarks:
		duplicate palette from an Image which contained in MatrixObject
	Parameters:
		mo = [output] matrix object of the Image.
		hPalette = [input] palette handle 
	Keywords:
		palette
	Return: 
		SUCCESS or a LeadTools error number less than zero.
	SeeAlso:
*/					
int image_duplicate_palette(const MatrixObject& mo, HPALETTE& hPalette);

/**$
	Remarks:
		subtract background from source image which contained in MatrixObject moSrcImg by defined channel and color level
	Parameters:
		moImg = [modify] input the background image, and output the result after subtracting the source image.
		moSrcImg = [input] input the souce image.
		uChannel = [input] subtract channel
		bIsHiBG  = [input] is background higher light than the foreground
	Keywords:
		subtract background

	Return: 
		SUCCESS or a LeadTools error number less than zero.
	SeeAlso:
*/
int gray_image_subtract_background(MatrixObject& moImg, MatrixObject& moSrcImg, UINT uChannel, bool bIsHiBG);

/**$
	Remarks:
		subtract background from source image which contained in MatrixObject moSrcImg by defined channel and color level
	Parameters:
		pTargetLBmp = [modify] input the background image handler, and output the result after subtracting the source image.
		pSrcLBmp = [input] input the souce image handler.
		uChannel = [input] subtract channel
		bIsHiBG  = [input] is background higher light than the foreground
	Keywords:
		subtract background

	Return: 
		SUCCESS or a LeadTools error number less than zero.
	SeeAlso:
*/
int gray_image_subtract_background(BITMAPHANDLE* pTargetLBmp, BITMAPHANDLE* pSrcLBmp, UINT uChannel, bool bIsHiBG);

//Comments last updated by Stacy on 7/23/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:adjust_image_brightness_(global_function)
*/
int adjust_image_brightness(MatrixObject& mo, int adjust );

///Sandy 2006-12-4 add
//Comments last updated by Stacy on 7/23/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:adjust_image_brightness_(global_function)
*/
int adjust_image_brightness(BITMAPHANDLE* pLBmp, int adjust );

/**$
	Remarks:
		apply auto level to Image which contained in MatrixObject
	Parameters:
		mo = [modify] the image need to adjust.
		uOptions = [input] 0 means apply auto level, 1 means apply auto contrast, 2 means apply auto intensity.
		pCL = [output] pointer to a LVLCLR structure that specifies input level values for all channels.

	Return: 
		SUCCESS or a LeadTools error number less than zero.
	SeeAlso:
*/
int auto_level_image(MatrixObject& mo, uint uOptions, LVLCLR* pCL = NULL);


/**$
	Remarks:
		apply auto level to Image which contained in MatrixObject
	Parameters:
		pLBmp = [modify] the image handler need to adjust.
		uOptions = [input] 0 means apply auto level, 1 means apply auto contrast, 2 means apply auto intensity.
		pCL = [output] pointer to a LVLCLR structure that specifies input level values for all channels.

	Return: 
		SUCCESS or a LeadTools error number less than zero.
	SeeAlso:
*/
int auto_level_image(BITMAPHANDLE* pLBmp, uint uOptions, LVLCLR* pCL = NULL);

//Sandy 2006-10-31 add 
//Comments last updated by Stcay on 7/23/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:apply_pal_to_image_(global_function)
*/
int apply_pal_to_image(Image& img, string strPalFile);

//Comments last updated by Stcay on 7/23/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:apply_pal_to_LT_bmp_(global_function)
*/
int apply_pal_to_LT_bmp(pBITMAPHANDLE pLBmp, string strPalFile);

///Sandy 2006-11-29 add
/**$
	Remarks:
		get histogram of Image
	Parameters:
		pLBmp    = [input] the image handler need to apply palette.
		pHist    = [input] the pointer of the array for output histogram 
		uLen     = [input] the length of the histogram
		uChannel = [input] the channel of histogram. default = MASTER_CHANNEL;
		                   and RED_CHANNEL, GREED_CHANNEL, BLUE_CHANNEL and RGB_CHANNELS;


	Return: 
		SUCCESS or a LeadTools error number less than zero.
	SeeAlso:
*/

int histogram_image(BITMAPHANDLE* pLBmp, int* pHist,UINT uLen, UINT uChannel);



//enum{
	//IMG_MORPH_DILATION,
	//IMG_MORPH_EROSION,
	//IMG_MORPH_OPEN,
	//IMG_MORPH_CLOSE,
//};

//int image_morphlogical_filter(BITMAPHANDLE* pLBmp,UINT uFltDim, UINT uOperation);



///Sandy 2006-6-27 initialize LVLCLR struct 
/**$
*/
void color_level_initialize(int nMaxV, LVLCLR& lc);

///Sandy 2006-6-27 set LVLCLR struct with certain channel
/**$
*/
int set_color_level_to_LVLCLR(int nMaxLevel, int nChannel, double dBlack, double dWhite, double dGamma, LVLCLR& lc);
/**$
*/
///Sandy 2006-6-27 get color level value with certain channel from LVLCLR struct
void get_color_level_from_LVLCLR(int nMaxLevel, int nChannel, LVLCLR& lc, double& dBlack, double& dWhite, double& dGamma);

///Sandy 2006-6-26 show LVLCLR struct to a vector
#define  GET_COLOR_LEVEL(_channel, vcl, xcl)  ( vcl[0] = xcl._channel.uMinInput;\
									    vcl[1] = xcl._channel.uMaxInput;\
									    vcl[2] = xcl._channel.uMinOutput;\
									    vcl[3] = xcl._channel.uMaxOutput;\
									    vcl[4] = xcl._channel.uGamma/100.0;)

#define  SET_COLOR_LEVEL(_channel, vcl, xcl)  ( xcl._channel.uMinInput = vcl[0] ;\
									  xcl._channel.uMaxInput = vcl[1];\
									  xcl._channel.uMinOutput = vcl[2];\
									  xcl._channel.uMaxOutput = vcl[3];\
									  xcl._channel.uGamma =  vcl[4]*100.0;)
//end
/**$
*/
///Sandy 2006-7-26 show LVLCLR info to a report
void show_color_level_info(ReportData& outData, LVLCLR& lc);


/**$
	Remarks:
		get horizontal or vertical line profile from data Matrix
	Parameters:
		mo = [input] the data matrix to get line profile .
		dLeft = [input] the minimum of X coordinate of the line 
		dTop = [input] the minimum of Y coordinate of the line 
		dRight = [input] the maximum of X coordinate of the line 
		dBottom = [input] the maximum of Y coordinate of the line 
		vxPoints = [output] the X coordinate array of points of line 
		vyPoints = [output] the Y coordinate array of points of line 
		vIntensity = [output] the intensity value array of points of line 
	Keywords:
		line profile
	Return: 
		SUCCESS or a LeadTools error number less than zero.
	SeeAlso:
*/
///Sandy 2006-12-22 add
int get_matrix_upright_line_profile(MatrixObject& mo,  double dLeft, double dTop, double dRight, double dBottom,
						 vector& vxPoints, vector& vyPoints, vector& vIntensity);

						 
///Sandy 2007-5-29 ADD						 
/**$
	Remarks:
		set numeric matrix data to gray scale image
	Parameters:
		mbData = [input] numeric matrix data .
		moLBitmap = [output] matrix object contained the Image.
		dMin = [input] the value as the black.
		dMax = [input] the value as the white.
		nBits = [input] Destination bits. Support 8, 12, 16 bits grayscale.
		hPalette = [input] palette handle to apply to the destination Image

	Keywords:
		palette
	Return: 
		return zero if successful
	SeeAlso:
		image_duplicate_palette
*/
			 
int set_image_data(matrixbase& mbData, MatrixObject& moLBitmap, 
						double dMin, double dMax, int nBits = 16, const HPALETTE hPalette = NULL);

#endif //!_MAT_DATA_UTILS_H

