/*------------------------------------------------------------------------------*
 * File Name:	IWUser.cpp	 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sim 06-19-2007 NOT_CREATE_LAYER_FOR_USER_DEFINED_IF_TARGET_TYPE_IS_NODE		*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include "iwbase.h"// Hong 8/21/06 CLEAN_HEADER_FILE
#include "impwiz.h"//Hong 8/07/06 MOVE_TO_IMPWIZ_H
#include "fu_utils.h" /// Hong 8/18/06 REMOVE_TO_FU_UTILS

///---Sim 08-17-2006 REMOVE_TO_FU_UTILS
/*
typedef int (*PFNIMPLAYERFUNC)(Layer &lyTarget, TreeNode &trFilter, LPCSTR strFileName, int iFile);
typedef int (*PFNIMPORTFUNC)(Page &pgTarget, TreeNode &trFilter, LPCSTR strFileName, int iFile);
static PFNIMPLAYERFUNC fuGetImportToLayerFunctionPtr(TreeNode &trFilter)
{
	string strOCFunc = trFilter.Common.OCFunction.strVal;
	string strOCFile = trFilter.Common.OCFile.strVal;
	if( strOCFunc.IsEmpty() || strOCFile.IsEmpty() )
		return NULL;

	PFNIMPLAYERFUNC pfn = Project.FindFunction(strOCFunc, strOCFile, TRUE);
	return pfn;
}

static PFNIMPORTFUNC fuGetImportFunctionPtr(TreeNode &trFilter)
{
	string strOCFunc = trFilter.Common.OCFunction.strVal;
	string strOCFile = trFilter.Common.OCFile.strVal;
	if( strOCFunc.IsEmpty() || strOCFile.IsEmpty() )
		return NULL;

	PFNIMPORTFUNC pfn = Project.FindFunction(strOCFunc, strOCFile, TRUE);
	return pfn;
}
*/
///---END REMOVE_TO_FU_UTILS

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
//class OC_REGISTERED IWUser : public IWBase
class OC_REGISTERED IWUser : public ImpWiz//Hong 8/07/06 MOVE_TO_IMPWIZ_H
{
public:
	IWUser():ImpWiz() {m_iFilterType = FILTER_TYPE_USERDEFINED} 
	~IWUser() {}
protected:
	///---Sim 06-27-2007 USER_DEFINED_NOT_NEED_PREPARE_WKS
	virtual int PrepareWksColsForImport(Layer &lyTarget, TreeNode &trFilter)
	{
		// nothing to do.
		return IMPERR_NONE;
	}
	///---END USER_DEFINED_NOT_NEED_PREPARE_WKS
	virtual int ImportFile(Layer& lyTarget, int nFile, string& strFileName, TreeNode& trFilter, TreeNode& tnInfo, int nImportMode) 
	{
		Page pgTarget;
		if ( lyTarget )
			lyTarget.GetParent(pgTarget);
		
		bool bTryOldFunc = false;
		PFNIMPLAYERFUNC pfnImpLayer = fuGetImportToLayerFunctionPtr(trFilter);
		if( !pfnImpLayer || pfnImpLayer(lyTarget, trFilter, strFileName, nFile) )
			bTryOldFunc = true;
		
		if( bTryOldFunc )
		{
			PFNIMPORTFUNC pfn = fuGetImportFunctionPtr(trFilter);
			if( !pfn )
				return IMPERR_GET_IMPORT_FUNC; // no import function
			if( pfn(pgTarget, trFilter, strFileName, nFile) )
				return IMPERR_IMPORT_FUNC_ERR; // import function error
			
			///---Sim 06-19-2007 NOT_CREATE_LAYER_FOR_USER_DEFINED_IF_TARGET_TYPE_IS_NODE
			if ( pgTarget )
				lyTarget = pgTarget.Layers();
			///---END NOT_CREATE_LAYER_FOR_USER_DEFINED_IF_TARGET_TYPE_IS_NODE
		}
		return IMPERR_NONE; // success
	}
};

