/*------------------------------------------------------------------------------*
 * File Name: impFilterID.h	 													*
 * Creation: Sim 09-14-2006														*
 * Purpose:  Data ID for filter of import file									*
 * Copyright (c) OriginLab Corp. 2006											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD									*
 * Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE					*
 * Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF					*
 * Hong 03/05/07 FIX_DUPLICATE_DATAID_IN_FILTER_MAKE_COPY_DATA_BY_ID_FAIL		*
 * Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE							*
 * Sim 03-19-2007 ADD_OPTION_TO_PARTIAL_COLUMN									*
 *	Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST				*
 * AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT				*
 * Sim 05-08-2007 ADD_OPTIONS_FOR_IMPORT_MODE_OF_1ST_FILE						*
 * Sim 05-22-2007 ADDITIONAL_OPTIONS_ID											*
 * Sim 08-06-2007 SUPPORT_SMART_SPARKLINE										*
 * Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME		*
 * Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION					*
 * Bill 12/17/2010 ORG-1737-S1 ADD_OPTION_TO_SPECIFY_WHEN_TO_RUN_SCRIPT			*
 *	Sim 12-28-2010 ORG-1832 SUPPORT_DRAG_AND_DROP_DAT_EXTENSION_EXCLUSION_FOR_PCLAMP_MDF_ETC
 *	Sim 2011-03-21 ORG-2642 IMPORT_FILE_STRUCTURE_ONLY_SUPPORT					*
 * Bill 08/25/2011 ORG-3437-S1 ADD_OPTION_TO_SAVE_FILE_INFO_FOR_IMPORT_XF		*
 *------------------------------------------------------------------------------*/
 
#ifndef _IMP_FILTER_ID_
#define _IMP_FILTER_ID_

#include <origin.h>
// filter structure
//-------------------Display Structure------------------------
///---Sim 08-28-2006 ADD_ID_TO_DISP_IMP
typedef enum {
	IDE_DISP_IMP_ORIGINVER			= 0x00000350,
	IDE_DISP_IMP_TYPE				= 0x00000351,
	IDE_DISP_IMP_RANGETOGRAPH		= 0x00000352,
	IDE_DISP_IMP_LINKWKS			= 0x00000353,
	IDE_DISP_IMP_COLDESIGN			= 0x00000354,
	IDE_DISP_IMP_COLDESIGNREP		= 0x00000355,
	IDE_DISP_IMP_COLFORMATS			= 0x00000356,
	IDE_DISP_IMP_PLOTTYPE			= 0x00000357,
	IDE_DISP_IMP_PLOTTEMPLATE		= 0x00000358,
	IDE_DISP_IMP_PAGETYPE			= 0x00000359,
	IDE_DISP_IMP_PAGETEMPLATE		= 0x00000360,
	IDE_DISP_IMP_FNAMETOWKSLAB		= 0x00000361,
	IDE_DISP_IMP_FILESPEC			= 0x00000362,
	IDE_DISP_IMP_DESCRIPTION		= 0x00000363,
	IDE_DISP_IMP_SPARKLINES			= 0x00000364,	// Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD
	IDE_DISP_IMP_AUTO_RENAME		= 0x00000365,	///---Sim 01-31-2007 ADD_AUTO_RENAME_TO_IMPORT_OPTIONS
	///---Sim 02-27-2007 QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS remove
	///// AW 02/26/07 QA80-9391 SKIP_POINTS_IN_XF_IMPORT_FILE
	//IDE_DISP_IMP_X_START_POINT		= 0x00000366,	
	//IDE_DISP_IMP_X_INCREASEMENT		= 0x00000367,	
	//IDE_DISP_IMP_X_END_POINT		= 0x00000368,	
	///// END SKIP_POINTS_IN_XF_IMPORT_FILE
	///---END QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS
	/// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM	= 0x00000366,
	IDE_DISPIMP_RENAMEWKSTRIMFNAMETO	= 0x00000367,
	/// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	///---Sim 03/06/07 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM	= 0x00000368,
	IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO	= 0x00000369,
	///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	IDE_DISPIMP_SHOWFILTERINOPENLIST	= 0x00000370, // Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST
	IDE_DISPIMP_1STMODE					= 0x00000371, ///---Sim 05-08-2007 ADD_OPTIONS_FOR_IMPORT_MODE_OF_1ST_FILE
	IDE_DISP_IMP_AUTOSIZE				= 0x00000372, ///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	IDE_DISPIMP_RUNALLFILEIMPORTED		= 0x00000373, /// Bill 12/17/2010 ORG-1737-S1 ADD_OPTION_TO_SPECIFY_WHEN_TO_RUN_SCRIPT
	IDE_DISP_IMP_FILE_EXCLUSION			= 0x00000374, ///---Sim 12-28-2010 ORG-1832 SUPPORT_DRAG_AND_DROP_DAT_EXTENSION_EXCLUSION_FOR_PCLAMP_MDF_ETC
	IDE_DISPIMP_SAVEFILEINFO			= 0x00000375, /// Bill 08/25/2011 ORG-3437-S1 ADD_OPTION_TO_SAVE_FILE_INFO_FOR_IMPORT_XF
}IDE_DISP_IMP_ID;
///---END ADD_ID_TO_DISP_IMP

///---Sim 08-29-2006 ADD_DISP_STRUCTURE
#define MAX_SIZE_COL_DESIGN		200
#define MAX_SIZE_COL_FORMATS	200
#define MAX_SIZE_PLOT_TEMPL		80
#define MAX_SIZE_PAGE_TEMPL		80
#define MAX_SIZE_FILE_SPEC		80
#define MAX_SIZE_DESCRIPTION	100

/// Hong 03/05/07 FIX_DUPLICATE_DATAID_IN_FILTER_MAKE_COPY_DATA_BY_ID_FAIL
/*
/// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_FOR_XF
#define IDE_DISPIMP_RENAMEWKS				IDE_IMP_RENAMEWKS
#define	IDE_DISPIMP_FILENAME2WKBK			IDE_IMP_FILENAME2WKBK
#define IDE_DISPIMP_ADDPATH4WKBK			IDE_IMP_ADDPATH4WKBK
#define IDE_DISPIMP_FILENAME2WKBKCOMMENT	IDE_IMP_FILENAME2WKBKCOMMENT
#define IDE_DISPIMP_FILENAME2COLCOMMENT		IDE_IMP_FILENAME2COLCOMMENT
#define IDE_DISPIMP_ADDPATH					IDE_IMP_ADDPATH
#define IDE_DISPIMP_REMOVE_QUOTES			IDE_IMP_REMOVE_QUOTES
/// end MORE_RENAME_WKS_FOR_XF
*/
/// end FIX_DUPLICATE_DATAID_IN_FILTER_MAKE_COPY_DATA_BY_ID_FAIL

typedef struct tagDISPIMP {
	//double _id(IDE_DISP_IMP_ORIGINVER)		dOriginVer;// Hong 9/01/06 MOVE_TO_FIRST_LEVEL 
	//int _id(IDE_DISP_IMP_TYPE)				iType;// Hong 9/01/06 MOVE_TO_FIRST_LEVEL
	int _id(IDE_DISP_IMP_RANGETOGRAPH)		iApplyRangeToGraph;
	int _id(IDE_DISP_IMP_LINKWKS)			iLinkWks;
	//char _id(IDE_DISP_IMP_COLDESIGN)		ColDesignations[MAX_SIZE_COL_DESIGN];
	string _id(IDE_DISP_IMP_COLDESIGN)		strColDesignations;//Hong 8/31/06 CONVERT_CHAR_ARRAY_TO_STRING
	int _id(IDE_DISP_IMP_COLDESIGNREP)		iColDesignationsRepetitive;
	//char _id(IDE_DISP_IMP_COLFORMATS)		ColFormats[MAX_SIZE_COL_FORMATS];
	string _id(IDE_DISP_IMP_COLFORMATS)		strColFormats;//Hong 8/31/06 CONVERT_CHAR_ARRAY_TO_STRING
	int _id(IDE_DISP_IMP_PLOTTYPE)			iPlotType;
	//char _id(IDE_DISP_IMP_PLOTTEMPLATE)	PlotTemplate[MAX_SIZE_PLOT_TEMPL];
	string _id(IDE_DISP_IMP_PLOTTEMPLATE)	strPlotTemplate;//Hong 8/31/06 CONVERT_CHAR_ARRAY_TO_STRING
	int _id(IDE_DISP_IMP_PAGETYPE)			iTargetWindowType;
	//char _id(IDE_DISP_IMP_PAGETEMPLATE)	TargetWindowTemplate[MAX_SIZE_PAGE_TEMPL];
	string _id(IDE_DISP_IMP_PAGETEMPLATE)	strTargetWindowTemplate;//Hong 8/31/06 CONVERT_CHAR_ARRAY_TO_STRING
	int _id(IDE_DISP_IMP_FNAMETOWKSLAB)		strFilenameToWksLabel;
	//char _id(IDE_DISP_IMP_FILESPEC)		FileSpec[MAX_SIZE_FILE_SPEC];
	string _id(IDE_DISP_IMP_FILESPEC)		strFileSpec;//Hong 8/31/06 CONVERT_CHAR_ARRAY_TO_STRING
	string _id(IDE_DISP_IMP_FILE_EXCLUSION)	strFileExclusion; ///---Sim 12-28-2010 ORG-1832 SUPPORT_DRAG_AND_DROP_DAT_EXTENSION_EXCLUSION_FOR_PCLAMP_MDF_ETC
	//char _id(IDE_DISP_IMP_DESCRIPTION)	Description[MAX_SIZE_DESCRIPTION];
	string _id(IDE_DISP_IMP_DESCRIPTION)	strDescription;//Hong 8/31/06 CONVERT_CHAR_ARRAY_TO_STRING
	///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
	//bool 	_id(IDE_DISP_IMP_SPARKLINES) 	bSparklines; // Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD
	int _id(IDE_DISP_IMP_SPARKLINES) 		nSparklines; // Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD
	///---END SUPPORT_SMART_SPARKLINE
	bool	_id(IDE_DISP_IMP_AUTO_RENAME)	bAutoRename; ///---Sim 01-31-2007 ADD_AUTO_RENAME_TO_IMPORT_OPTIONS
	///---Sim 02-27-2007 QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS remove
	///// AW 02/26/07 QA80-9391 SKIP_POINTS_IN_XF_IMPORT_FILE
	//int _id(IDE_DISP_IMP_X_START_POINT), 	iX0;	
	//int _id(IDE_DISP_IMP_X_INCREASEMENT),	iInc;	
	//int _id(IDE_DISP_IMP_X_END_POINT),		iX1;	
	///// END SKIP_POINTS_IN_XF_IMPORT_FILE
	///---END QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS
	/// Hong 03/05/07 FIX_DUPLICATE_DATAID_IN_FILTER_MAKE_COPY_DATA_BY_ID_FAIL
	// roll back remove rename to display structure as ID conflict with ascii struture
	///// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	//int 	_id(IDE_DISPIMP_RENAMEWKS)		iRenameWks;		//if rename worksheet name to the file name
	int		_id(IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM)		iWksTrimFNameFrom; // start index of trim file name when rename worksheet name, 1 offset
	int		_id(IDE_DISPIMP_RENAMEWKSTRIMFNAMETO)		iWksTrimFNameTo; // end index if trim file name when rename worksheet name, 1 offset
	//int 	_id(IDE_DISPIMP_FILENAME2WKBK)		iRenameWkBk;	//=1 to rename workbook, =0 to keep current name
	//int 	_id(IDE_DISPIMP_ADDPATH4WKBK)			iIncludePathForWkBk;	//=1 to rename workbook include file path, =0 to exclude file path
	//int 	_id(IDE_DISPIMP_FILENAME2WKBKCOMMENT)	iAppendWkBkComm;	//=1 to rename workbook comment, =0 to keep current name
	//int 	_id(IDE_DISPIMP_FILENAME2COLCOMMENT)	iAppendColComm;	//=1 to rename column, =0 to keep current name
	//int 	_id(IDE_DISPIMP_ADDPATH)				iIncludePath;	//=1 to append file name include file path, =0 to exclude file path
	//int		_id(IDE_DISPIMP_REMOVE_QUOTES)		iRemoveQuotes;	//=1 to remove quotes when rename, =0 to no remove quotes
	///// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	/// end FIX_DUPLICATE_DATAID_IN_FILTER_MAKE_COPY_DATA_BY_ID_FAIL
	///---Sim 03/06/07 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	int		_id(IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM)	iWkBkTrimFNameFrom; // start index of trim file name when rename workbook name, 1 offset
	int		_id(IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO)		iWkBkTrimFNameTo; // end index if trim file name when rename workbook name, 1 offset
	///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	bool	_id(IDE_DISPIMP_SHOWFILTERINOPENLIST)	bAddToFileOpen; // Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST
	int		_id(IDE_DISPIMP_1STMODE)	i1stMode; ///---Sim 05-08-2007 ADD_OPTIONS_FOR_IMPORT_MODE_OF_1ST_FILE
	int		_id(IDE_DISP_IMP_AUTOSIZE)	nAutoSize; ///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	int		_id(IDE_DISPIMP_RUNALLFILEIMPORTED) bRunAfterAllFileImported; /// Bill 12/17/2010 ORG-1737-S1 ADD_OPTION_TO_SPECIFY_WHEN_TO_RUN_SCRIPT
	int		_id(IDE_DISPIMP_SAVEFILEINFO)	bSaveFileInfo; /// Bill 08/25/2011 ORG-3437-S1 ADD_OPTION_TO_SAVE_FILE_INFO_FOR_IMPORT_XF
} DISPIMP;
///---END ADD_DISP_STRUCTURE

//-------------------Binary Structure------------------------
#define IDE_BINIMP_AUTOCOLTYPES		IDE_IMP_AUTOCOLTYPES
#define IDE_BINIMP_MODE				IDE_IMP_IMPORTMODE
#define IDE_BINIMP_NUMCOLUMNS		IDE_IMP_NUMCOLUMNS
#define IDE_BINIMP_PARTIAL			IDE_IMP_PARTIAL
#define IDE_BINIMP_PARTIALC1		IDE_IMP_PARTIALC1
#define IDE_BINIMP_PARTIALC2		IDE_IMP_PARTIALC2
#define IDE_BINIMP_PARTIALR1		IDE_IMP_PARTIALR1
#define IDE_BINIMP_PARTIALR2		IDE_IMP_PARTIALR2
#define IDE_BINIMP_RENAMEWKS		IDE_IMP_RENAMEWKS
#define IDE_BINIMP_APPLYRANGE		IDE_IMP_APPLYRANGE
#define IDE_BINIMP_SKIPROWS			IDE_IMP_SKIPROWS
#define IDE_BINIMP_READROWS			IDE_IMP_READROWS
#define IDE_BINIMP_FLAGS			IDE_IMP_FLAGS

typedef enum {
	IDE_BINIMP_HEADERBYTES		= 0x00000200,	
//	IDE_BINIMP_AUTOCOLTYPES		= 0x00000201,	
//	IDE_BINIMP_NUMCOLUMNS		= 0x00000202,	
//	IDE_BINIMP_PARTIAL			= 0x00000203,	
//	IDE_BINIMP_PARTIALC1		= 0x00000204,	
//	IDE_BINIMP_PARTIALC2		= 0x00000205,	
//	IDE_BINIMP_PARTIALR1		= 0x00000206,	
//	IDE_BINIMP_PARTIALR2		= 0x00000207,	
//	IDE_BINIMP_RENAMEWKS		= 0x00000208,	
	IDE_BINIMP_BIGENDIAN		= 0x00000209,	
//	IDE_BINIMP_APPLYRANGE		= 0x00000210,	
//	IDE_BINIMP_MODE				= 0x00000211,	
//	IDE_BINIMP_SKIPROWS			= 0x00000212,	
//	IDE_BINIMP_READROWS			= 0x00000213,
	IDE_BINIMP_PARAMTYPE		= 0x00000214,
	IDE_BINIMP_PARAMSIZE		= 0x00000215,
	IDE_BINIMP_PARAMCOUNT		= 0x00000216,
//	IDE_BINIMP_FLAGS			= 0x00000217,
} IDE_BINIMP_ID;

///---Sim 08-29-2006 ADD_BINARY_STRUCTURE
typedef struct tagBINIMP {
	int _id(IDE_BINIMP_HEADERBYTES)		iHeaderBytes;				//number of bytes for header
	int _id(IDE_BINIMP_AUTOCOLTYPES)	iAutoColTypes;				//indicate if set col type explicitly
	int _id(IDE_BINIMP_NUMCOLUMNS)		iNumColumns;				//number of columns
	int _id(IDE_BINIMP_PARTIAL)			iPartial;					//indicate partial data will be read from the file
	int _id(IDE_BINIMP_PARTIALC1)		iPartialC1;					//partial reading start column number, 0 based, include this column
	int _id(IDE_BINIMP_PARTIALC2)		iPartialC2;					//partial reading end column number, this column will not be included
	int _id(IDE_BINIMP_PARTIALR1)		iPartialR1;					//partial reading start row number, 0 based, this row will be included
	int _id(IDE_BINIMP_PARTIALR2)		iPartialR2;					//partial reading end row number, this row will not be included
	int _id(IDE_BINIMP_RENAMEWKS)		iRenameWks;					//if rename worksheet name to the file name
	int _id(IDE_BINIMP_BIGENDIAN)		iBigEndian;					//numeric value byte order, use big endian if TRUE
	int _id(IDE_BINIMP_APPLYRANGE)		iApplyRange;				//
	int _id(IDE_BINIMP_MODE)			iMode;						// Data destination in worksheet. See ASCIMP_MODE_* constants in OC_Types.h
	int _id(IDE_BINIMP_SKIPROWS)		iSkipRows;					// number of data rows to skip for each row of data read
	int _id(IDE_BINIMP_READROWS)		iReadRows;
	vector<BYTE> _id(IDE_BINIMP_PARAMTYPE)	vParamType;		//data type for each column
	vector<WORD> _id(IDE_BINIMP_PARAMSIZE)	vParamSize;		//size of the data type for each column, bytes
	vector<WORD> _id(IDE_BINIMP_PARAMCOUNT)	vParamCount;		//number of consective columns with same data type
	DWORD _id(IDE_BINIMP_FLAGS)			flags; /// EJP 07-21-2004 QA70-6555 SUPPORT_WKBK_IN_IMPWIZ
} BINIMP;
///---END ADD_BINARY_STRUCTURE

//-------------------XFunction Structure------------------------
///Hong 8/29/06 ADD_XF_STRUCTURE
typedef enum {
	IDE_XFIMP_NAME				= 0x00000400,
	IDE_XFIMP_OPENSETTING		= 0x00000401,
	IDE_XFIMP_OPSHOWTIME		= 0x00000402,			/// AW 09/20/06 QA80-8988 MORE_ON_XF
	/// Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD
	// move to Display struture as a common one
	//IDE_XFIMP_OPSPARKLINES		= 0x00000403,			/// AW 09/20/06 QA80-8988 MORE_ON_XF
	/// end ADD_SPARKLINE_TO_IMPORT_WIZARD
	///---Sim 02-27-2007 QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS
	IDE_XFIMP_START_POINT		= 0x00000404,
	IDE_XFIMP_END_POINT			= 0x00000405,
	IDE_XFIMP_READ_POINT		= 0x00000406,
	IDE_XFIMP_SKIP_POINT		= 0x00000407,
	IDE_XFIMP_PARTIAL_IMPORT	= 0x00000408, ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
	//IDE_XFIMP_SUB_RANGE			= 0x00000409, ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
	///---Sim 03-19-2007 ADD_OPTION_TO_PARTIAL_COLUMN
	IDE_XFIMP_COL_START_POINT	= 0x00000410,
	IDE_XFIMP_COL_END_POINT		= 0x00000411,
	///---END ADD_OPTION_TO_PARTIAL_COLUMN
	
	/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
	IDE_XFIMP_START_TIME		= 0x00000412,
	IDE_XFIMP_END_TIME			= 0x00000413,
	/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT

	///---END QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS
	
	///---Sim 2011-03-21 ORG-2642 IMPORT_FILE_STRUCTURE_ONLY_SUPPORT	
	//IDE_XFIMP_END_TIME			= 0x00000413,
	IDE_XFIMP_STRUCTURE_ONLY	= 0x00000414,
	///---END ORG-2642 IMPORT_FILE_STRUCTURE_ONLY_SUPPORT	
}IDE_XFIMP_ID;

///---Sim 01-29-2006 RENAME_BOOK_AND_SHEET_IS_COMMON_OPTION
#define	IDE_XFIMP_FILENAME2WKBK			IDE_IMP_FILENAME2WKBK
#define IDE_XFIMP_WKBKLNONLY			IDE_IMP_WKBKLNONLY ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
#define IDE_XFIMP_ADDPATH4WKBK			IDE_IMP_ADDPATH4WKBK
#define IDE_XFIMP_FILENAME2WKBKCOMMENT	IDE_IMP_FILENAME2WKBKCOMMENT
#define IDE_XFIMP_FILENAME2COLCOMMENT	IDE_IMP_FILENAME2COLCOMMENT
#define IDE_XFIMP_ADDPATH				IDE_IMP_ADDPATH
#define IDE_XFIMP_REMOVE_QUOTES			IDE_IMP_REMOVE_QUOTES
///---END RENAME_BOOK_AND_SHEET_IS_COMMON_OPTION

#define IDE_XFIMP_IMPORTMODE		IDE_IMP_IMPORTMODE
/// Hong 9/11/06 MORE_FOR_XF_FILTER
#define IDE_XFIMP_RENAMEWKS			IDE_IMP_RENAMEWKS
#define IDE_XFIMP_FLAGS				IDE_IMP_FLAGS
/// end MORE_FOR_XF_FILTER
typedef struct tagXFIMP {
	/// Hong 03/05/07 FIX_DUPLICATE_DATAID_IN_FILTER_MAKE_COPY_DATA_BY_ID_FAIL
	// roll back remove rename to display structure as ID conflict with ascii struture
	///// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	//// remove to display structure as rename is a general issue
	///*
	/// Hong 9/11/06 MORE_FOR_XF_FILTER
	int 	_id(IDE_XFIMP_RENAMEWKS)		iRenameWks;		//if rename worksheet name to the file name
	///---Sim 01-29-2006 RENAME_BOOK_AND_SHEET_IS_COMMON_OPTION
	int 	_id(IDE_XFIMP_FILENAME2WKBK)		iRenameWkBk;	//=1 to rename workbook, =0 to keep current name
	///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	int 	_id(IDE_XFIMP_WKBKLNONLY)			iRenameWkBkLongNameOnly; //=1 to rename workbook long name, not short name, =0 both long name and short name
	///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	int 	_id(IDE_XFIMP_ADDPATH4WKBK)			iIncludePathForWkBk;	//=1 to rename workbook include file path, =0 to exclude file path
	int 	_id(IDE_XFIMP_FILENAME2WKBKCOMMENT)	iAppendWkBkComm;	//=1 to rename workbook comment, =0 to keep current name
	int 	_id(IDE_XFIMP_FILENAME2COLCOMMENT)	iAppendColComm;	//=1 to rename column, =0 to keep current name
	int 	_id(IDE_XFIMP_ADDPATH)				iIncludePath;	//=1 to append file name include file path, =0 to exclude file path
	int		_id(IDE_XFIMP_REMOVE_QUOTES)		iRemoveQuotes;	//=1 to remove quotes when rename, =0 to no remove quotes
	///---END RENAME_BOOK_AND_SHEET_IS_COMMON_OPTION
	//*/
	///// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	/// end FIX_DUPLICATE_DATAID_IN_FILTER_MAKE_COPY_DATA_BY_ID_FAIL
	DWORD 	_id(IDE_XFIMP_FLAGS)			flags; 			/// EJP 07-21-2004 QA70-6555 SUPPORT_WKBK_IN_IMPWIZ
	/// end MORE_FOR_XF_FILTER
	string 	_id(IDE_XFIMP_NAME)		 		strName;
	bool   	_id(IDE_XFIMP_OPENSETTING) 		bOpenSetting;
	int 	_id(IDE_XFIMP_IMPORTMODE) 		iMode;
	bool 	_id(IDE_XFIMP_OPSHOWTIME) 		bShowTime;		/// AW 09/20/06 QA80-8988 MORE_ON_XF
	/// Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD
	// move to Display struture as a common one
	//bool 	_id(IDE_XFIMP_OPSPARKLINES) 		sparklines;		/// AW 09/20/06 QA80-8988 MORE_ON_XF
	/// end ADD_SPARKLINE_TO_IMPORT_WIZARD
	///---Sim 02-27-2007 QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS
	int 	_id(IDE_XFIMP_PARTIAL_IMPORT)	iPartialImport; ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
	int 	_id(IDE_XFIMP_READ_POINT)		iReadPoint;
	int 	_id(IDE_XFIMP_SKIP_POINT)		iSkipPoint;
	//int 	_id(IDE_XFIMP_SUB_RANGE)		iSubRange; ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
	int 	_id(IDE_XFIMP_START_POINT)		iStartPoint;
	int 	_id(IDE_XFIMP_END_POINT)		iEndPoint;
	

	///---Sim 03-19-2007 ADD_OPTION_TO_PARTIAL_COLUMN
	int 	_id(IDE_XFIMP_COL_START_POINT)		iColStartPoint;
	int 	_id(IDE_XFIMP_COL_END_POINT)		iColEndPoint;
	///---END ADD_OPTION_TO_PARTIAL_COLUMN
	///---END QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS
	
	/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
	double 	_id(IDE_XFIMP_START_TIME)		iStartTime;
	double 	_id(IDE_XFIMP_END_TIME)			iEndTime;
	/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
	
	///---Sim 2011-03-21 ORG-2642 IMPORT_FILE_STRUCTURE_ONLY_SUPPORT
	bool 	_id(IDE_XFIMP_STRUCTURE_ONLY) 	bStructureOnly;
	///---END ORG-2642 IMPORT_FILE_STRUCTURE_ONLY_SUPPORT	
} XFIMP;
///end ADD_XF_STRUCTURE

//-------------------User Define Structure------------------------
///---Sim 08-30-2006 ADD_USERDEFINE_STRUCTURE
typedef enum {
}IDE_USERDEFIMP_ID;

#define IDE_USERDEFIMP_POSTIMPSCRIPT	IDE_IMP_POSTIMPSCRIPT
#define IDE_USERDEFIMP_FILE				IDE_IMP_FILE
#define IDE_USERDEFIMP_FUNCTION			IDE_IMP_FUNCTION
#define IDE_USERDEFIMP_CLASS			IDE_IMP_CLASS

#define MAX_SIZE_POSTIMPSCRIPT		200
#define MAX_SIZE_FILE				80
#define MAX_SIZE_FUNCTION			80
#define MAX_SIZE_CLASS				80

typedef struct tagUSERDEFIMP {
	char 	_id(IDE_USERDEFIMP_POSTIMPSCRIPT) 	PostImportScript[MAX_SIZE_POSTIMPSCRIPT];
	char 	_id(IDE_USERDEFIMP_FILE) 			OCFile[MAX_SIZE_FILE];
	char 	_id(IDE_USERDEFIMP_FUNCTION) 		OCFunction[MAX_SIZE_FUNCTION];
	char 	_id(IDE_USERDEFIMP_CLASS) 			OCClass[MAX_SIZE_CLASS];
} USERDEFIMP;
///---END ADD_USERDEFINE_STRUCTURE

//-------------------Variable Structure------------------------
///---Sim 08-29-2006 ADD_VAR_STRUCTURE
typedef enum {
	IDE_VARIMP_VARIABLES_NODE	= 0x00000450,
	IDE_VARIMP_VARS_NODE		= 0x00000451,
	IDE_VARIMP_EXTVARBYSCAN		= 0x00000452,
	IDE_VARIMP_PAGEINFO			= 0x00000453,
	IDE_VARIMP_EXTBYDELIMITER	= 0x00000454,
	IDE_VARIMP_EXTBYPOSITION	= 0x00000455,
	IDE_VARIMP_EXTBYOCFUNC		= 0x00000456,
	IDE_VARIMP_OCFILENAME		= 0x00000457,
	IDE_VARIMP_OCFUNCNAME		= 0x00000458,
	IDE_VARIMP_USERDEFINEDPARAM	= 0x00000459, /// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
}IDE_VARIMP_ID;
typedef struct tagVARIMP {
	int 	_id(IDE_VARIMP_EXTVARBYSCAN) 		ExtractByScanning;
	int 	_id(IDE_VARIMP_PAGEINFO) 			PageInfo;
	int 	_id(IDE_VARIMP_EXTBYDELIMITER)		ExtractByDelimiter;
	int 	_id(IDE_VARIMP_EXTBYPOSITION)		ExtractByPosition;
	int 	_id(IDE_VARIMP_EXTBYOCFUNC)			ExtractByOCFunction;
	int 	_id(IDE_VARIMP_OCFILENAME)			OCFileName;
	int 	_id(IDE_VARIMP_OCFUNCNAME)			OCFunctionName;
	/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	int 	_id(IDE_VARIMP_USERDEFINEDPARAM)	UserDefinedParameters;
	/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
} VARIMP;
///---END ADD_VAR_STRUCTURE

//-------------------Drag & Drop Structure------------------------
///---Sim 08-30-2006 ADD_DRAGNDROP_STRUCTURE
typedef enum {
	IDE_DNDIMP_NODE			= 0x00000500,
	IDE_DNDIMP_GRAPH		= 0x00000501,
	IDE_DNDIMP_WORKSPACE	= 0x00000502,
}IDE_DNDIMP_ID;
typedef struct tagDNDIMP {
	int 	_id(IDE_DNDIMP_GRAPH) 		Graph;
	int 	_id(IDE_DNDIMP_WORKSPACE)	Workspace;
} DNDIMP;
///---END ADD_DRAGNDROP_STRUCTURE

//-------------------Parameter Structure------------------------
/// Hong 9/01/06 ADD_DATAID_FOR-PARAMS
typedef enum{
	IDE_PARAMSIMP_HEADERPARAMETERS_NODE	= 0x00000550,
///---Sim 09-05-2006 MORE_ADDITION
	IDE_PARAMSIMP_FIRSTLINE				= 0x00000551,
	IDE_PARAMSIMP_LASTLINE				= 0x00000552,
	IDE_PARAMSIMP_SEPARATOR				= 0x00000553,
	IDE_PARAMSIMP_NAME					= 0x00000554,
	IDE_PARAMSIMP_TYPE					= 0x00000555,
	IDE_PARAMSIMP_LINE					= 0x00000556,
	IDE_PARAMSIMP_POS					= 0x00000557,
	IDE_PARAMSIMP_END					= 0x00000558,
	IDE_PARAMSIMP_OFFSET				= 0x00000559,
	IDE_PARAMSIMP_SIZE					= 0x00000560,
	IDE_PARAMSIMP_FILTER				= 0x00000561, ///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
///---END MORE_ADDITION
}IDE_PARAMSIMP_ID;
///---Sim 09-05-2006 MORE_ADDITION
typedef struct tagPARAMSIMPRoot {
	int 	_id(IDE_PARAMSIMP_FIRSTLINE)	FirstLine;
	int 	_id(IDE_PARAMSIMP_LASTLINE)		LastLine;
	int 	_id(IDE_PARAMSIMP_SEPARATOR)	Separator;
} PARAMSIMPRoot;

typedef struct tagPARAMSIMP {
	string 	_id(IDE_PARAMSIMP_NAME) 		Name;
	int 	_id(IDE_PARAMSIMP_TYPE)			Type;
	int 	_id(IDE_PARAMSIMP_LINE)			Line;
	int 	_id(IDE_PARAMSIMP_POS)			Pos;
	int 	_id(IDE_PARAMSIMP_END)			End;
	int 	_id(IDE_PARAMSIMP_OFFSET)		Offset;
	int 	_id(IDE_PARAMSIMP_SIZE)			Size;
} PARAMSIMP;
///---END MORE_ADDITION
/// end ADD_DATAID_FOR-PARAMS

//-------------------Header Structure------------------------
///---Sim 09-04-2006 ADD_HEADER_STRUCTURE
typedef enum{
	IDE_HEADERIMP_HEADER_NODE		= 0x00000600,
	IDE_HEADERIMP_SAVEFIRSTLINE 	= 0x00000601,
	IDE_HEADERIMP_SAVENUMLINES		= 0x00000602,
}IDE_HEADERIMP_ID;
///---END ADD_HEADER_STRUCTURE

/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
// this structure is created to contain additional infomation in filter, which is optional
typedef enum {
	IDE_ADDIMP_ADDITIONAL_NODE		= 0x00000650,
	IDE_ADDIMP_RENAMEWKSVARNAME		= 0x00000651,
	IDE_ADDIMP_RENAMEWKBKVARNAME	= 0x00000652, ///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
}IDE_ADDIMP_ID;

typedef struct tagADDIMP {
	string 	_id(IDE_ADDIMP_RENAMEWKSVARNAME) 		strRenameWksVarName;
	string 	_id(IDE_ADDIMP_RENAMEWKBKVARNAME) 		strRenameWkbkVarName; ///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
} ADDIMP;
/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE

///---Sim 05-22-2007 ADDITIONAL_OPTIONS_ID
/*$
void testFilterUserDataID()
{
	int nID = 1;
	ASSERT(nID < FILTER_USER_ID_COUNT);
	int n1 = GET_FILTER_USER_DATAID(nID);
	out_int("ID1: ", n1);
	
	nID = 1000;
	ASSERT(nID < FILTER_USER_ID_COUNT);
	int n2 = GET_FILTER_USER_DATAID(nID);
	out_int("ID2: ", n2);
	
	nID = 10001;
	ASSERT(nID < FILTER_USER_ID_COUNT);
	int n3 = GET_FILTER_USER_DATAID(nID);
	out_int("ID3: ", n3);
}
**/

#define DATAID_FILTER_USER_BASE		0x01000
#define FILTER_USER_ID_COUNT		1000

#define GET_FILTER_USER_DATAID(_INDEX) (DATAID_FILTER_USER_BASE + (_INDEX))
///---END ADDITIONAL_OPTIONS_ID

#endif //_IMP_FILTER_ID_
