/*------------------------------------------------------------------------------*
 * File Name: HPFFile.c		 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp.	2006, 2007, 2008, 2009, 2010				*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Cheney 2007-1-25 ADD_A_IMPORT_FUNCTION_TO_GET_INFO_AND_DATA					* 
 *------------------------------------------------------------------------------*/
 
#ifndef _HPF_FILE_H
#define _HPF_FILE_H

typedef struct tagDTChannelDescriptor {
	int offset;
	int length;
} DTChannelDescriptor, *PDTChannelDescriptor;

typedef enum {
	HPF_NO_ERRER						= 0, 
	HPF_ERR_INVLAID_FILE 				= -1,
	HPF_ERR_NO_CHANNEL_INFO 			= -2,
	HPF_ERR_ALLOCATE_MEMORY_FAILED 		= -3,
	HPF_ERR_INVALID_DATA_CHUNK 			= -4,
} HPF_ERROR_ID;

/// Hong 07/17/08 v8.0903 FIX_SOME_IMPORT_HAVE_DUPLICATE_SHEET_NAME_NO_AUTO_ENUM
enum
{
	HPF_RENAME_SHEET_BY_FILENAME		= 0x00000001,
};
/// end FIX_SOME_IMPORT_HAVE_DUPLICATE_SHEET_NAME_NO_AUTO_ENUM

////////////////////////////////////////////////////////////
/////////   class HPFFile class 
///////// 	handle HPF(data translation) file import
class HPFFile : public file
{
public:
	HPFFile();
	~HPFFile();
public:
//	int ReadData(LPCSTR lpcszFileName, TreeNode& trInfo, BOOL bReadFileStruct);
//	int Import(Worksheet& ds, LPCSTR lpcszFileName, TreeNode& trInfo);
	int ReadHeader(LPCSTR lpcszFileName, TreeNode& trInfo);
//	int readData(WorksheetPage& pg, TreeNode& trInfo, DWORD dwOption);
	int ReadData(Worksheet& wks, TreeNode& trInfo, int nC1 = 0);  
	///Cheney 2007-1-25 ADD_A_IMPORT_FUNCTION_TO_GET_INFO_AND_DATA	
	/// Hong 07/17/08 v8.0903 FIX_SOME_IMPORT_HAVE_DUPLICATE_SHEET_NAME_NO_AUTO_ENUM
	//int Import(LPCSTR lpcszFileName, Worksheet& wks, TreeNode& trInfo, int nC1 = 0);
	int Import(LPCSTR lpcszFileName, Worksheet& wks, TreeNode& trInfo, int nC1 = 0, DWORD dwOptions = HPF_RENAME_SHEET_BY_FILENAME);
	/// end FIX_SOME_IMPORT_HAVE_DUPLICATE_SHEET_NAME_NO_AUTO_ENUM
	///end ADD_A_IMPORT_FUNCTION_TO_GET_INFO_AND_DATA
protected:
	int read_chunk_xml(Tree& trXML, int nBufferLength);
//	int readDataChunk(TreeNode& trInfo);
//	int readOneChannel(int nCol, TreeNode& trnCh, PDTChannelDescriptor pDTCD, int nDataChunkBegin);
	
	
	int readChannelInfo(int nFileOffset, TreeNode& trInfo );
	int readdataInfo(TreeNode& trData, int fileOffset, int nStartIndex);
	///Cheney 2007-1-25 ADD_A_IMPORT_FUNCTION_TO_GET_INFO_AND_DATA
	//int	initWorksheet(Worksheet& wks, TreeNode& trChInfoChunk);
	int	prepareWorksheet(Worksheet& wks, TreeNode& trChInfoChunk, int& nTotalCols, int nColIndex);
	///end ADD_A_IMPORT_FUNCTION_TO_GET_INFO_AND_DATA
	
	int readIndexChunk(int nFileOffset, TreeNode& trInfo, DWORD dwOption);
	///Cheney 2007-1-25 ADD_A_IMPORT_FUNCTION_TO_GET_INFO_AND_DATA	
	//int readOneDataChunk(Worksheet& wks, int nFileOffset, int nStartIndex);
	int readOneDataChunk(Worksheet& wks, int nFileOffset, int nStartIndex, TreeNode& trChInfoChunk, int& nMaxRows, int& nColIndex);
	bool handelColumnProperty(Column& col, TreeNode& trChInfo);
	///end ADD_A_IMPORT_FUNCTION_TO_GET_INFO_AND_DATA

protected:
	//BOOL				m_bValid;
	//Worksheet 			m_wks;
	//vector<int>			vnGroupID;   // Data translation said they only support one group
	Tree 				m_trDataInfo;
	int 				m_nGroupID;
	int 				m_nDataSize;
	LPCSTR				m_lpcszFileName;	
};

#endif ///_HPF_FILE_H