/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sim 07-10-2006 v8.0440 GENERAL_WAVFILE_IMPORT								*
 * Sim 07-17-2006 ADD_FILE_NAME_TO_COL_AS_LONG_NAME								*
 * Sim 2011-03-21 ORG-2642 IMPORT_FILE_STRUCTURE_ONLY_SUPPORT					*
 *------------------------------------------------------------------------------*/
 
#include <origin.h>

#include "file_utils.h"

/// before call this function, you need set right siz first 
int file_read_data(file& ff, DataObject& dd, int nInternalType, UINT nBufferSize)
{
	dd.SetInternalDataType(nInternalType, 0);
	int nElementSize;				
	UINT nNumElements;				
	LPVOID lpData = dd.GetInternalDataBuffer(&nElementSize, &nNumElements);
	if ( nNumElements * nElementSize < nBufferSize )
		return -2;
	if( ff.Read(lpData, nBufferSize) != nBufferSize )
	{
		ff.Close();
		return -1;
	}
	dd.ReleaseBuffer();
	return 0; 
}

///---Sim 07-10-2006 v8.0440 GENERAL_WAVFILE_IMPORT
BinFile::BinFile(BOOL bImport) 
{
	m_bImport = bImport;
	m_strFileName = ""; ///---Sim 07-17-2006 ADD_FILE_NAME_TO_COL_AS_LONG_NAME
}

BinFile::BinFile(LPCSTR lpcszFileName, BOOL bImport) 
{
	m_bImport = bImport;
	Open(lpcszFileName); 
}

BinFile::~BinFile() 
{ 
	if (IsOpen())
		Close();
}
///---Sim 2011-03-21 ORG-2642 IMPORT_FILE_STRUCTURE_ONLY_SUPPORT
//bool BinFile::Open(LPCSTR lpcszFileName)
//{
	//m_strFileName = lpcszFileName; ///---Sim 07-17-2006 ADD_FILE_NAME_TO_COL_AS_LONG_NAME
	//if (m_bImport)
	//{
		//return file::Open(lpcszFileName, file::shareDenyNone | file::typeBinary);
	//}
	//return false;
//}
bool BinFile::Open(LPCSTR lpcszFileName)
{
	m_strFileName = lpcszFileName; ///---Sim 07-17-2006 ADD_FILE_NAME_TO_COL_AS_LONG_NAME
	return Open();
}
// virtual
bool BinFile::Open()
{
	if (m_bImport)
	{
		return file::Open(m_strFileName, file::shareDenyNone | file::typeBinary);
	}
	return false;
}
// virtual
bool BinFile::Close()
{
	return file::Close();
}
// virtual
bool BinFile::IsOpen()
{
	return file::IsOpen();
}
bool BinFile::CheckOpen(LPCSTR lpcszFileName)
{
	if ( IsOpen() )
		Close();
	return Open(lpcszFileName);
}
///---END ORG-2642 IMPORT_FILE_STRUCTURE_ONLY_SUPPORT	
///---end GENERAL_WAVFILE_IMPORT

///---Sim 2011-03-21 ORG-2642 IMPORT_FILE_STRUCTURE_ONLY_SUPPORT	
bool MultiMetaFile::ImportMetaData(DataRange& dr)
{
	if ( !dr || !dr.IsValid() )
		return false;
		
	int nNumRangs = dr.GetNumRanges();
	for ( int nRange = 0; nRange < nNumRangs; nRange++ )
	{
		Datasheet ds;
		int nC1, nC2;
		if ( dr.GetRange(ds, nC1, nC2, nRange) )
		{
			if ( !ImportMetaData(ds, nC1, nC2) )
				return false;			
		}
	}
	
	return true;
}
// virtual
bool MultiMetaFile::ImportMetaData(Datasheet ds, int nC1, int nC2)
{
	return false;
}

#define STR_IMPORT_META_DATA_INFO "FileImportMetaDataInfo"
bool set_import_meta_data_info(OriginObject &obj, TreeNode &tr)
{
	return obj.PutBinaryStorage(STR_IMPORT_META_DATA_INFO, tr); 
}
bool get_import_meta_data_info(OriginObject &obj, TreeNode &tr)
{
	return obj.GetBinaryStorage(STR_IMPORT_META_DATA_INFO, tr); 
}
///---END ORG-2642 IMPORT_FILE_STRUCTURE_ONLY_SUPPORT	
