/*------------------------------------------------------------------------------*
 *	File Name: 	fft.h								 							*
 *	Purpose:	C math functions, mostly general purpose					   	*
 *				This header is used in VC ocMath DLL as well as in OC files		*
 *  Creation:	12/20/2003, Dr. C. P. Yang										* 
 *  	Copyright Originlab Corp. 2003, 2004,									*
 *	Modification log	                                                        *
 *		Leo 04/28/05 ADD_FFT_WIENER_FILTER										*
 *		Soapy 07/09/05 QA70-7865 ADD_2D_CORRELATION								*
 *		Sandy/Leo 2006-3-31 QA70-6980 ADD_HERMITIAN_TO_COMPLEX					*
 *		Raine 2006-04-06 ADD_STFT_COMPLEX										*
 *		Raine 2006-04-13 CHANGE_STFT_COMPLEX_PARA								*
 *		Raine 2006-04-13 ADD_FFT_APPLY_WINDOW_COMPLEX							*
 *      Sandy 2006-5-22 ADD_RESULTSIZE_TO_APPLY_WINDOW                          *
 *      Sandy 2006-5-22 CHANGE_TO_D_COMPLEX_FOR_APPLY_WINDOW                    *
 *		Arvin 2006-5-23 CHANGE_NAME_TO_RECTWIN									*
 *		Arvin 2006-5-23 CHANGE_NAME_TO_TRIWIN									*
 *		Arvin 2006-5-23 CHANGE_NAME_TO_BARTLETTWIN								*
 *		Arvin 2006-5-23 CHANGE_NAME_TO_HANNINGWIN								*
 *		Arvin 2006-5-23 CHANGE_NAME_TO_HAMMINGWIN								*
 *		Arvin 2006-5-23 CHANGE_NAME_TO_BLACKMANWIN								*
 *		Arvin 2006-5-23 CHANGE_NAME_TO_COSINEWIN								*
 *		Arvin 2006-5-23 CHANGE_NAME_TO_GAUSSWIN									*
 *		Arvin 2006-5-23 CHANGE_NAME_TO_KAISERWIN								*
 *		Arvin 2006-5-23 CHANGE_NAME_TO_WELCHWIN									*
 *		Arvin 2006-5-23 ADD_CREAT_WINDOW_DATA									*
 *		Arvin 2006-5-23 ADD_UNWRAP_PHASE										*
 *		Cheney 2006-7-14 FFT_FFT_COHERENCE										*
 *		Cheney 2006-7-18 FFT_FFT_LOWPASS_FILTERING								*
 *		Cheney 2006-7-18 FFT_FFT_HIGHPASS_FILTERING								*
 *		Cheney 2006-7-18 FFT_FFT_BANDPASS_FILTERING								*
 *		Cheney 2006-7-18 FFT_FFT_BANDBLOCK_FILTERING							*
 *		Cheney 2006-8-4 ADD_PARZENWIN											*
 *		Cheney 2006-8-4 CREATE_RESPONSE_DATA									*
 *		Cheney 2006-8-4 CREATE_LOWPASS_DATA										*
 *		Cheney 2006-8-4 CREATE_HIGHPASS_DATA									*
 *		Cheney 2006-8-4 CREATE_BANDPASS_DATA									*
 *		Cheney 2006-8-4 CREATE_BANDBLOCK_DATA									*
 *		Justin 2006-11-20 ADD_ONE_SIDE_SPECTRUM									*
 *		Justin 2007-06-01 SUPPORT_RADIAN_FOR_UNWRAP_PHASE						*
 *		Fisher 2008-07-10 QA80-11828 NEW_OPTIONS_FOR_FFT_SMOOTH					*
 *      Sandy  2008-9-27  CHANGE_CATEGORY_FOR_CHM								*
 *      Derek  2010-6-25  ADD_2D_FFT_FILTER                                     *
 *------------------------------------------------------------------------------*/      


#ifndef _OC_fft_H
#define _OC_fft_H

//---- CPY 11/11/2007 OCMSP_DLL_CREATION
//typedef double d_complex[2];	///Raine/Leo 2006-3-16 REWRITE_FFT_FFT_COMPLEX
#ifndef _OC_MATH_H
	typedef double d_complex[2];	///Raine/Leo 2006-3-16 REWRITE_FFT_FFT_COMPLEX
#endif
//----

enum FFT_SIGN 
{  
	FFT_FORWARD, 
	FFT_BACKWARD 
};

///Justin 2007-06-01 SUPPORT_RADIAN_FOR_UNWRAP_PHASE
enum ANGLE_UNIT 
{  
	ANGLE_RAD, 
	ANGLE_GRAD 
};
///End SUPPORT_RADIAN_FOR_UNWRAP_PHASE

enum
{
	//0 for success
	UNKNOWN_ERROR = 1,		// more error codes added from here;
	INVALID_SIZE,			// the value of iSize is invalid;
	DATA_SIZE_ERROR,		// the size of data is not same as iSize provided;
	INVALID_DATA,			// data value invalid
	INVALID_INTERVAL,		// invalid interval -- the interval is less than 1e-20, used in fft_sampling_resolution
	UNEVENLY_SPACE,			// unevenly spaced values, used in fft_sampling_resolution
	MEMORY_ALLOCATE_ERROR,	// not enough memory allocated to a pointer, used by calloc()
	INVALID_INCREMENT,		// invalid increment -- the increment is less than 1e-20, used in OC_Data
	INVALID_ARGUMENT,		// invalid argument, such as cutoff frequency etc
	MEMORY_DUPLICATE		// use the same pointer to represent different data
};

enum WINDOW_FILTER_TYPE  // this is used in fft_fft_filter 
{
	LOW_PASS_FILTERING,		//	low-pass filtering;
	HIGH_PASS_FILTERING,	//	high-pass filtering;
	BAND_PASS_FILTERING,	//	band-pass filtering;
	BAND_BLOCK_FILTERING,	//	band-block filtering;
	LOW_PASS_PARABOLIC_FILTERING, //low-pass parabolic filtering
	LOW_PASS_PARABOLIC_FILTERING_75	 //low-pass parabolic filtering used in 75 and eariler (QA80-11828 NEW_OPTIONS_FOR_FFT_SMOOTH)
};

enum FFT_WINDOW_METHOD		// this is used in fftw_create_window_data
{     					// FFT Window method
	RECTANGLE_WIN = 0,
	WELCH_WIN,
	TRIANGULAR_EIN,
	BARTLETT_WIN,
	HANNING_WIN,
	HAMMING_WIN,
	BLACKMAN_WIN,
	GAUSSIAN_WIN,
	KAISER_WIN,
	PARZEN_WIN,			//Cheney 2006-8-4 ADD_FOR_PARZEN_WINDOW
};

// Fisher 2008-07-10 QA80-11828 NEW_OPTIONS_FOR_FFT_SMOOTH
enum FFT_SMOOTH_BASELINE
{
	BASELINE_TWO_ENDS = 0,
	BASELINE_TWO_ENDS_1_PERCENT,
	BASELINE_TWO_ENDS_20_PERCENT,
	BASELINE_NONE,
};
// end QA80-11828 NEW_OPTIONS_FOR_FFT_SMOOTH


enum FIR_FILTER_TYPE  // this is used in fft_fft_filter 
{
	FIR_MOVING_AVERAGE_FILTERING,	//	moving average filter
	FIR_LOW_PASS_FILTERING,			//	low-pass filter;
	FIR_HIGH_PASS_FILTERING,		//	high-pass filter;
	FIR_BANG_PASS_FILTERING,		//	band-pass filter;
};


/// Derek  2010-6-25  ADD_2D_FFT_FILTER
enum FFT_FILTER_2D_WINDOW_TYPE
{	
	FFT_FILTER_2D_ILPF = 0,		// Ideal low-pass filter	
	FFT_FILTER_2D_GLPF,	        // Gaussian low-pass filter
	FFT_FILTER_2D_BLPF,			// Butterworth low-pass filter
	FFT_FILTER_2D_IHPF, 		// Ideal high-pass filter	
	FFT_FILTER_2D_GHPF,	        // Gaussian high-pass filter
	FFT_FILTER_2D_BHPF,			// Butterworth high-pass filter
	FFT_FILTER_2D_IBPF, 		// Ideal band-pass filter	
	FFT_FILTER_2D_GBPF,	        // Gaussian band-pass filter
	FFT_FILTER_2D_BBPF,			// Butterworth band-pass filter
};
///end ADD_2D_FFT_FILTER

#ifdef __AFX_H__
	#ifdef FFTW_EXPORTS
		#define OCDLL_API __declspec(dllexport)
	#else
		#define OCDLL_API __declspec(dllimport)
	#endif
	extern "C" {
#else
	#define OCDLL_API
	#pragma dll(OFFT)	// Assoicate all functions below to OFFT.dll which must be in the Origin EXE folder
#endif	//__AFX_H__



// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_real_(global_function)
*/
OCDLL_API int fft_fft_real(int iSize, double *vSig, FFT_SIGN iSign = FFT_FORWARD);

// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_complex_(global_function)
*/
OCDLL_API int fft_fft_complex(int iSize, double *vSigReal, double *vSigImag, FFT_SIGN iSign = FFT_FORWARD);

///Raine/Leo 2006-3-16 REWRITE_FFT_FFT_COMPLEX
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fftw_fft_complex_(global_function)
*/
OCDLL_API int fftw_fft_complex(int iSize, d_complex* vSig, FFT_SIGN iSign = FFT_FORWARD);

// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_2d_complex_(global_function)
*/
OCDLL_API int fft_fft_2d_complex(int iSizeX, int iSizeY, double *vSigReal, double *vSigImag, FFT_SIGN iSign = FFT_FORWARD);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fftw_fft_2d_complex_(global_function)
*/
OCDLL_API int fftw_fft_2d_complex(int iSizeX, int iSizeY, d_complex* vSig, FFT_SIGN iSign = FFT_FORWARD);

// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_sine_(global_function)
*/
OCDLL_API int fft_fft_sine(int iSize, double *vSig); 


// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_cosine_(global_function)
*/
OCDLL_API int fft_fft_cosine(int iSize, double *vSig); 

/// Sandy 2006-5-23 MOVE_COMMENT_FROM_OC_LEVEL
/* STFT 's window size and FFT points

|============================|
       Win Size    |============================|
       	          Overlap            |============================|

|==================================|
       FFT Size           |=========|
                            Padding

*/

// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_multiple_real_(global_function)
*/
OCDLL_API int fft_fft_multiple_real(int iSequences,int iSize, double *vSig, FFT_SIGN iSign = FFT_FORWARD);


// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_multiple_complex_(global_function)
*/
OCDLL_API int fft_fft_multiple_complex(int iSequences,int iSize, double *vSigReal, double *vSigImag, FFT_SIGN iSign = FFT_FORWARD);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fftw_fft_multiple_complex_(global_function)
*/
OCDLL_API int fftw_fft_multiple_complex(int iSequences,int iSize, d_complex* vSig, FFT_SIGN iSign = FFT_FORWARD);

// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_correlation_(global_function)
*/
OCDLL_API int fft_fft_correlation(int iSize, double *vSig1, double *vSig2);

// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_convolution_(global_function)
*/
OCDLL_API int fft_fft_convolution(int iSize, double *vSig1, double *vSig2);


// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_deconvolution_(global_function)
*/
OCDLL_API int fft_fft_deconvolution(int iSize, double *vSig1, double *vSig2);

// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_filter_(global_function)
*/

OCDLL_API int fft_fft_filter(int iSize, double *vSig, double *vWindow);

// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_filter_window_(global_function)
*/

OCDLL_API int fft_filter_window(int iSize, int iType, double *vWindow, double dFc1, 
					   double dFc2, double dFreqStep, BOOL bAddOffset); 


// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_threshold_filtering_(global_function)
*/
OCDLL_API int fft_threshold_filtering(int iSize, double* vSignal, double dThreshold);


// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_sampling_resolution_(global_function)
*/
OCDLL_API int fft_sampling_resolution(int iSize, double *vFreq, double* dTimeInterval);

// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_apply_window_(global_function)
*/
//OCDLL_API int fft_apply_window(int iSigSize, double *vSig, int iWinSize, double *vWindow, int iShift, double* vResult, int iPadding, int iStep);
/// Sandy 2006-5-22 ADD_RESULTSIZE_TO_APPLY_WINDOW
OCDLL_API int fft_apply_window(int iSigSize, double *vSig, int iWinSize, double *vWindow, 
							   int iShift, int iResultSize, double* vResult, int iPadding, int iStep);

/// Raine 2006-04-13 ADD_FFT_APPLY_WINDOW_COMPLEX
//OCDLL_API int fft_apply_window_complex(int iSigSize, double *vReal, double *vImag, int iWinSize, double *vWindow, 
//									   int iShift, int iResultSize, d_complex* vResult, int iPadding, int iStep);
/// Sandy 2006-5-22 CHANGE_TO_D_COMPLEX_FOR_APPLY_WINDOW
OCDLL_API int fft_apply_window_complex(int iSigSize, d_complex* vSig, int iWinSize, double *vWindow,  
									   int iShift, int iResultSize, d_complex* vResult, int iPadding, int iStep);

// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_get_power_hermitian_(global_function)
*/
OCDLL_API int fft_get_power_hermitian(int iSeqSize, int iNumSeq, double* vSig, double* vResult);

// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_stft_(global_function)
*/
//OCDLL_API int fft_stft(double *vSig, int iSigSize, double *vWindow, int iWinSize, int iShiftPts, int iPadding, int iSteps, double* vAmplitude);
/// sandy 2006-5-23 CHANGE_PROTOTYPE_TO_INCLUDE_MORE_INFOR_OF_STFT
OCDLL_API int fft_stft(double *vSig, int iSigSize, double *vWindow, int iWinSize, double dSFeq, int iShiftPts, 
					   int iFftLen, int iSteps, double* vAmplitude, double* dScaleX, double* dScaleY );

// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_stft_complex_(global_function)
*/
///Sandy 2006-7-19 CHANGE_STFT_WITH_COMPLEX_OUTPUT
///// sandy 2006-5-23 CHANGE_PROTOTYPE_TO_INCLUDE_MORE_INFOR_OF_STFT
////OCDLL_API int fft_stft_complex(d_complex* vSig, int iSigSize, double *vWindow, int iWinSize, int iShiftPts, int iPadding, int iSteps, double* vAmplitude);
//OCDLL_API int fft_stft_complex(d_complex* vSig, int iSigSize,double *vWindow, int iWinSize, double dSFeq, int iShiftPts, 
//						int iFftLen, int iSteps, double* vAmplitude, double* dScaleX, double* dScaleY );
OCDLL_API int fft_stft_complex(d_complex* vSig, int iSigSize,double *vWindow, int iWinSize, double dSFeq, int iShiftPts, 
						int iFftLen, int iSteps, d_complex* pOutComplex, double* pAmp, double* dScaleTime, double* dScaleFreq );

// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_2d_real_(global_function)
*/
OCDLL_API int fft_fft_2d_real(int iSizeX, int iSizeY, double *vSigReal, double *vSigImag, FFT_SIGN iSign = FFT_FORWARD);

///Arvin 2006-5-23 CHANGE_NAME_TO_RECTWIN
/**$ >Signal Processing>Fourier Transform>FFT
		Create a Rectangle Window.
	Parameters:
		vWindow:contains the nSize-point Rectangle window.
		nSize:	size of the window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//OCDLL_API int stft_RectWin(double *vWindow, int nSize);
OCDLL_API int RectWin(double *vWindow, int nSize);

///Arvin 2006-5-23 CHANGE_NAME_TO_TRIWIN
/**$ >Signal Processing>Fourier Transform>FFT
		Create a Triangular Window.
	Parameters:
		vWindow:contains the nSize-point Triangular window.
		nSize:	size of the window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//OCDLL_API int stft_TriWin(double *vWindow, int nSize);
OCDLL_API int TriWin(double *vWindow, int nSize);

///Arvin 2006-5-23 CHANGE_NAME_TO_BARTLETTWIN
/**$ >Signal Processing>Fourier Transform>FFT
		Create a Bartlett Window.
	Parameters:
		vWindow:contains the nSize-point Bartlett window.
		nSize:	size of the window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//OCDLL_API int stft_BartlettWin(double *vWindow, int nSize);
OCDLL_API int BartlettWin(double *vWindow, int nSize);

///Arvin 2006-5-23 CHANGE_NAME_TO_HANNINGWIN
/**$ >Signal Processing>Fourier Transform>FFT
		Create a Hanning Window.
	Parameters:
		vWindow:contains the nSize-point Hanning window.
		nSize:	size of the window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//OCDLL_API int stft_HanningWin(double *vWindow, int nSize);
OCDLL_API int HanningWin(double *vWindow, int nSize);

///Arvin 2006-5-23 CHANGE_NAME_TO_HAMMINGWIN
/**$ >Signal Processing>Fourier Transform>FFT
		Create a Hamming Window.
	Parameters:
		vWindow:contains the nSize-point Hanning window.
		nSize:	size of the window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//OCDLL_API int stft_HammingWin(double *vWindow, int nSize);
OCDLL_API int HammingWin(double *vWindow, int nSize);

///Arvin 2006-5-23 CHANGE_NAME_TO_BLACKMANWIN
/**$ >Signal Processing>Fourier Transform>FFT
		Create a Blackman Window.
	Parameters:
		vWindow:contains the nSize-point Blackman window.
		nSize:	size of the window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//OCDLL_API int stft_BlackmanWin(double *vWindow, int nSize);
OCDLL_API int BlackmanWin(double *vWindow, int nSize);

///Arvin 2006-5-23 CHANGE_NAME_TO_COSINEWIN
/**$ >Signal Processing>Fourier Transform>FFT
		Create a Cosine Window.
	Parameters:
		vWindow:contains the nSize-point Gaussian window.
		nSize:	size of the window.
		dA, dB, dC:	parameters of Cosine Window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//OCDLL_API int stft_CosineWin(double *vWindow, int nSize, double dA, double dB, double dC);

OCDLL_API int CosineWin(double *vWindow, int nSize, double dA, double dB, double dC);

///Arvin 2006-5-23 CHANGE_NAME_TO_GAUSSWIN
/**$ >Signal Processing>Fourier Transform>FFT
		Create a Gaussian Window.
	Parameters:
		vWindow:contains the nSize-point Gaussian window.
		nSize:	size of the window.
		dAlpha:	Alpha parameter of Gaussian window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//OCDLL_API int stft_GaussWin(double *vWindow, int nSize, double dAlpha);

OCDLL_API int GaussWin(double *vWindow, int nSize, double dAlpha);

///Arvin 2006-5-23 CHANGE_NAME_TO_KAISERWIN
/**$ >Signal Processing>Fourier Transform>FFT
		Create a Kaiser Window.
	Parameters:
		vWindow:contains the nSize-point Kaiser window.
		nSize:	size of the window.
		dBeta:	Beta parameter of Kaiser window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//OCDLL_API int stft_KaiserWin(double *vWindow, int nSize, double dBeta);

OCDLL_API int KaiserWin(double *vWindow, int nSize, double dBeta);

///Arvin 2006-5-23 CHANGE_NAME_TO_WELCHWIN
/**$ >Signal Processing>Fourier Transform>FFT
		Create a Welch Window.
	Parameters:
		vWindow:contains the nSize-point Welch window.
		nSize:	size of the window.	
	Return:	
		Returns 0 for success or error codes for failure.
*/
//OCDLL_API int stft_WelchWin(double *vWindow, int nSize);

OCDLL_API int WelchWin(double *vWindow, int nSize);

///Cheney 2006-8-4 ADD_PARZENWIN
/**$ >Signal Processing>Fourier Transform>FFT
		Create a Parzen Window.
	Parameters:
		nSize:	size of the window.	
		pWindow:contains the nSize-point Parzen window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
OCDLL_API int ParzenWin(int nSize, double *pWindow);
///end ADD_PARZENWIN

///Cheney 2006-8-4 ADD_OPTION_FOR_FILTER
///Arvin 2006-5-23 ADD_CREAT_WINDOW_DATA
// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fftw_create_window_data_(global_function)
*/
OCDLL_API int fftw_create_window_data(int nSize, double *vWindow, int nWindowMethod = RECTANGLE_WIN, double dAlpha = 0, double dBeta = 0);  
///end ADD_CREAT_WINDOW_DATA
///end ADD_OPTION_FOR_FILTER

///Cheney 2006-8-4 CREATE_RESPONSE_DATA
// Category last updated by Cloud on 06/06/2008
/**$ >Signal Processing>Fourier Transform>FFT
	Remarks:
		Generate Responses data.
	Example1:
		void create_response_data_ex1()
		{
			vector vRes(8);
			create_response_data(8, vRes, 0.1, 0.3, BAND_PASS_FILTERING);
		}
	Parameters:
		nSize =		number of points of the Responses data
		pResponse = [output]		the result of Responses data
		dFc1 = the lower bound of the frequency.
		dFc2 = the upper bound of the frequency.
		responseType = 	the response type, now it can be one of the following,
			LOW_PASS_FILTERING,		//	low-pass filtering;
			HIGH_PASS_FILTERING,	//	high-pass filtering;
			BAND_PASS_FILTERING,	//	band-pass filtering;
			BAND_BLOCK_FILTERING,	//	band-block filtering;
	return:
		Returns 0 for success or error codes for failure.
*/
OCDLL_API int create_response_data(int nSize, double *pResponse, double dFc1, double dFc2, int responseType = LOW_PASS_FILTERING);
///end CREATE_RESPONSE_DATA

///Cheney 2006-8-4 CREATE_LOWPASS_DATA
// Category last updated by Cloud on 06/06/2008
/**$ >Signal Processing>Fourier Transform>FFT
	Remarks:
		Generate lowpass Responses data.
	Example1:
		void create_lowpass_data_ex1()
		{
			vector vRes(8);
			create_lowpass_data(8, vRes, 0.3);
		}
	Parameters:
		nSize =		number of points of the lowpass Responses data
		pResponse = [output]		the result of lowpass Responses data
		dFc1 = the lower bound of the frequency(has been normalized, so 0<dFc1<0.5).
	return:
		Returns 0 for success or error codes for failure.
*/
OCDLL_API int create_lowpass_data(int nSize, double* pResponse, double dFc1);
///end CREATE_LOWPASS_DATA

///Cheney 2006-8-4 CREATE_HIGHPASS_DATA
// Category last updated by Cloud on 06/06/2008
/**$ >Signal Processing>Fourier Transform>FFT
	Remarks:
		Generate highpass Responses data.
	Example1:
		void create_highpass_data_ex1()
		{
			vector vRes(8);
			create_highpass_data(8, vRes, 0.3);
		}
	Parameters:
		nSize =		number of points of the highpass Responses data
		pResponse = [output]		the result of highpass Responses data
		dFc1 = the lower bound of the frequency(has been normalized, so 0<dFc1<0.5).
	return:
		Returns 0 for success or error codes for failure.
*/
OCDLL_API int create_highpass_data(int nSize, double* pResponse, double dFc1);
///end CREATE_HIGHPASS_DATA

///Cheney 2006-8-4 CREATE_BANDPASS_DATA
// Category last updated by Cloud on 06/06/2008
/**$ >Signal Processing>Fourier Transform>FFT
	Remarks:
		Generate bandpass Responses data.
	Example1:
		void create_bandpass_data_ex1()
		{
			vector vRes(8);
			create_bandpass_data(8, vRes, 0.1, 0.3);
		}
	Parameters:
		nSize =		number of points of the bandpass Responses data
		pResponse = [output]		the result of bandpass Responses data
		dFc1 = the lower bound of the frequency(has been normalized, so 0<dFc1<dFc2<0.5).
		dFc2 = the upper bound of the frequency(has been normalized, so 0<dFc1<dFc2<0.5).
	return:
		Returns 0 for success or error codes for failure.
*/
OCDLL_API int create_bandpass_data(int nSize, double* pResponse, double dFc1, double dFc2);
///end CREATE_BANDPASS_DATA

///Cheney 2006-8-4 CREATE_BANDBLOCK_DATA
// Category last updated by Cloud on 06/06/2008
/**$ >Signal Processing>Fourier Transform>FFT
	Remarks:
		Generate bandblock Responses data.
	Example1:
		void create_bandblock_data_ex1()
		{
			vector vRes(8);
			create_bandblock_data(8, vRes, 0.1, 0.3);
		}
	Parameters:
		nSize =		number of points of the bandblock Responses data
		pResponse = [output]		the result of bandblock Responses data
		dFc1 = the lower bound of the frequency(has been normalized, so 0<dFc1<dFc2<0.5).
		dFc2 = the upper bound of the frequency(has been normalized, so 0<dFc1<dFc2<0.5).
	return:
		Returns 0 for success or error codes for failure.
*/
OCDLL_API int create_bandblock_data(int nSize, double* pResponse, double dFc1, double dFc2);
///end CREATE_BANDBLOCK_DATA

///Leo 2006-02-06 see comments in function body.
///Leo 04/28/05 ADD_FFT_WIENER_FILTER
///** >Signal Processing>Fourier Transform>FFT
//	Optimal (Wiener) filter with the FFT.
//Parameters:
//	iSize=[in] Size of the input and output data values.
//	pY=[in] Input data array.
//	pYs=[out] Filtered (smoothed) data array.
//	sigma=[in] Standard deviation of the input array.
//	alpah=[in] When alpha = 1, it is the Wiener filter. It is also called Regularized inverse filter.
//Return:
//	Retrun true for success or false for failure.
//*/
//OCDLL_API bool fft_wiener_filter(int iSize, const double* pY, double* pYs, double sigma, double alpha=1);
/////END ADD_FFT_WIENER_FILTER

///Soapy 07/09/05 QA70-7865 ADD_2D_CORRELATION
// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_2d_correlation_(global_function)
*/
OCDLL_API int fft_fft_2d_correlation(int iRows, int iCols, double *mSig1, double *mSig2);
///END ADD_2D_CORRELATION

///Sandy/Leo 2006-3-31 QA70-6980 ADD_HERMITIAN_TO_COMPLEX
// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_hermitian_to_complex_(global_function)
*/
OCDLL_API int fft_hermitian_to_complex(int iSize, double* vHermitian, d_complex* vComplex);
///end ADD_HERMITIAN_TO_COMPLEX

///Arvin 2006-5-23 ADD_UNWRAP_PHASE
// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fftw_fft_unwrap_phase_(global_function)
*/
///Justin 2007-06-01 SUPPORT_RADIAN_FOR_UNWRAP_PHASE
//OCDLL_API int fftw_fft_unwrap_phase(int nSize, double* vPhase);
OCDLL_API int fftw_fft_unwrap_phase(int nSize, double* vPhase, int nAngleUnit = ANGLE_GRAD);
///END ADD_UNWRAP_PHASE

///Cheney 2006-7-14 FFT_FFT_COHERENCE
// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_fft_coherence_(global_function)
*/
OCDLL_API int fft_fft_coherence(int nSize, const double* pSignal1, const double* pSignal2, int nSelect, double* pCoherence,
									int nWinSize, const double* pWindow, int iFftLen, int nOverlap = 0);
///end FFT_FFT_COHERENCE

///Cheney 2006-7-18 FFT_FFT_LOWPASS_FILTERING
// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_lowpass_filtering_(global_function)
*/
OCDLL_API int fft_lowpass_filtering(int nSize, double* pSignal, double dTimeStep, double dFc);
///end FFT_FFT_LOWPASS_FILTERING

///Cheney 2006-7-18 FFT_FFT_HIGHPASS_FILTERING
// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_highpass_filtering_(global_function)
*/
OCDLL_API int fft_highpass_filtering(int nSize, double* pSignal, double dTimeStep, double dFc, bool bAddOffset = true);
///end FFT_FFT_HIGHPASS_FILTERING

///Cheney 2006-7-18 FFT_FFT_BANDPASS_FILTERING
// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_bandpass_filtering_(global_function)
*/
OCDLL_API int fft_bandpass_filtering(int nSize, double* pSignal, double dTimeStep, double dFLow, double dFHigh, bool bAddOffset = true);
///end FFT_FFT_BANDPASS_FILTERING

///Cheney 2006-7-18 FFT_FFT_BANDBLOCK_FILTERING
// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_bandblock_filtering_(global_function)
*/
OCDLL_API int fft_bandblock_filtering(int nSize, double* pSignal, double dTimeStep, double dFLow, double dFHigh, bool bAddOffset = true);
///end FFT_FFT_BANDBLOCK_FILTERING


///Sandy 2007-8-22 Add comment
// Category last updated by Cloud on 06/06/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_one_side_spectrum_(global_function)
*/
///justin 11/20/2006 ADD_ONE_SIDE_SPECTRUM
OCDLL_API int fft_one_side_spectrum(int nSize, double* pSpectrum, bool bShifted = false );
///end ADD_ONE_SIDE_SPECTRUM

//Fisher 2008-07-10 QA80-11828 NEW_OPTIONS_FOR_FFT_SMOOTH
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_smooth_(global_function)
*/
OCDLL_API int fft_smooth(int nSize, int npts, double cutoff, double *vInputX, double *vInputY, double *vSmooth, int pad = 0, int filter = LOW_PASS_PARABOLIC_FILTERING, int baseline = BASELINE_TWO_ENDS_1_PERCENT);







OCDLL_API int fir_filter(int nOrder, int nType, double *pFilter, double dFc1, double dFc2, double dFreqStep, int nWindow=RECTANGLE_WIN);



/// Derek  2010-6-25  ADD_2D_FFT_FILTER
/// Comments last updated by Derek on 06/12/2010
/**# >
	Remarks:
		This function performs 2D filtering in the frequency-domain, which is based on the 2D FFT	

	Keywords:		
	Example1:
		void fft_fft_filter_2d_ex1()
		{
			
		}
	Parameters:
		iRows = [input] row number of the image
		iCols = [input] column number of the image
		vSrc = [modified] the image to be filtered
		vWindow = [input] the frequency-domain filtering window, with the same size as vSrc
		vDst = [output] optional, the output image, if NULL, vSrc will be overwritten by the output		
	Return:
		Return 0 on success and error code < 0 on failure				
	SeeAlso:		
*/
OCDLL_API int fft_fft_filter_2d(int iRows, int iCols, double *vSrc, const double *vWindow, double *vDst = NULL);


/// Comments last updated by Derek on 06/25/2010
/**# >
	Remarks:
		This function makes a frequency-domain filtering window according to the given filter type
	Keywords:		
	Example1:
		void fft_filter_window_2d_ex1()
		{


		}	
	Parameters:
		iSize1, iSize2 = [input] size of the window
		vWindow = [output] the obtained window data
		dFreqStep = [input] the frequency uint (??)
		dDc1 = [input] the cutoff distance
		dDc2 = [input] optional, another cutoff distance,  only applicable to band-pass filters
		iOrder = [input] optional, order of the filter, only applicable to Butterworth filters
		
	Return:
		Return 0 on success and error code < 0 on failure						
	SeeAlso:		
*/
OCDLL_API int fft_filter_window_2d(int iSize1, int iSize2, int iType, double *vWindow, double dFreqStep,double dDc1, double dDc2 = -1,int iOrder = -1); 

///end ADD_2D_FFT_FILTER



#ifdef __AFX_H__
	}
#endif	//__AFX_H__

#endif // _OC_fft_H
