/*------------------------------------------------------------------------------*
 * File Name: event_utils.c	 													*
 * Creation: Echo 6/23/06														*
 * Purpose: OriginC Source C file for events and event-related fucntions used	*
 			in X-functions and operations										*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:	 														*
 * Jasmine 01/09/07 CHECK_ENTIRE_COLUMN_SELECTED								*
 * Jasmine 01/26/07 CHECK_1_CELL_MODIFICATION									*
 *	ML 2/15/2007 GETTING_REPORT_TREE_WITH_ESCAPED_STRINGS_TRANSLATION			*
 *	ML 2/27/2007 FITCOMPARISON_SHOULD_USE_RANGE_TYPES_FOR_INPUT_REPORTS_SO_THAT_AUTOUPDATE_WORKS
 *  Justin 2007-3-22 v8.0587 CHECK_USER_INPUTED_INTERVAL 						*
 *  Justin 2007-3-23 v8.0588 MOVE_BACK_FFTUTILIS_BECAUSE_COMPILE_ERROR			*
 *	Cloud 04/19/2007 ADD_INTERPOLATION_PREPROCESS								*
 *	Jake 05/10/07 ADD_GET_NUMBER_FROM_STRING									*
 *	Echo 7/25/07 QA70-7191-P6 v8.0667 NO_CENSOR_SHOULD_BE_SUPPORTED				*
 *	Echo 8/8/07 QA-9897 v8.0677 FREQ_COUNT_TO_BE_CONSISTANT_WITH_HISTOGRAM		*
 *	Jasmine 08/14/07 QA80-10207 REPORT_SHEET_CHECK_CONFLICT						*
 *	Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
 *	Cheney QA70-10315 IF_SOURCE_DATA_FROM_EXCEL_SHOULD_NOT_ADD_FIT_CURVE_TO_SOURCE
 *	Jasmine 11/02/07 CHANGE_TO_PREDEFINED_TYPE_TO_COMPARE						*
 *	Sim 11-05-2007 CLEAN_LOCALIZATION_CODE										*
 *	CPY 11/12/2007 DESC_STATS_ON_ROWS_AUTO_SHOULD_SET_PROPER_SHEET				*
 *	Max 12/19/07 AVOID_CALCULATION_WITH_TREENODE_VARIABLE_TO_FIX_DIFF_RESULTS_BETEWEEN_XP_AND_VISTA
 *	ML 12/27/2007 LPCSTR_BY_DEFAULT_SHOULD_BE_NULL_ONLY							*
 *	Max 3/7/08 SHOULD_PASS_WHOLE_STRING_OF_LPCSZRDLABEL_FOR_LOCALIZATION		*
 *	Max 3/19/08 REWRITE_AND_RENAME_GET_SMOOTH_FACTOR							*
 *	Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS				*
 *	Max 4/7/08 v8.0838 MUST_CHECK_VALID_INPUT									*
 *	Echo 05/28/08 v8.0871 DETECT_BALANCE_DESIGN									*
 *	Echo 7/25/08 v8.0909 ERROR_IN_CHECK_INTEGER									*
 *	Kyle 10/31/08 QA80-12452  SUPPORT_INPUT_DATA_FORM_OPTION_FOR_NPH_TESTS		*
 *	Iris 11/20/2008 v8.0975d QA80-12591-P4 REMOVE_LOG_DATA_TYPE_WHEN_DATA_FROM_MATRIX
 *	Sophy 11/21/2008 v8.976 QA80-12591-P3 ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT
 *	Sophy 11/24/2008 v8.978c CHECK_SET_XDATATYPE_VALUE_ON_APPLY_THEME			*
 *	Max 11/25/08 QA70-12615 v8.0975d SHARE_SAME_FUNC_FOR_NORMALIZE_AND_VNORMALIZE
 *	Kyle 11/25/2008 QA80-12051 GET_XYRANGE_DATA_BASE_ON_RULES					*
 *	Folger 11/27/08 QA80-12356 v8.0980 MORE_TOOLS_NEED_TO_HANDLE_INPUTS_WITH_MISSING_VALUE
 *	Kyle 12/12/2008 NUMBER_OF_INTERVALS_NOT_INCLUDE_OUTLEFT_AND_OUTRIGHT		*
 *	TD 12-15-2008 QA80-12786  DYNACONTROL_DOUBLES_TO_SUPPORT_DATE_TIME_INCR_FMTS*
 *	Folger 12/26/08 QA80-12856 v8.0991 IMRPOVE_ocmath_xy_remove_duplicates		*
 *	Sophy 1/12/2009 v8.995c QA80-12591-P6 CHECK_ERROR_SHOULD_ONLY_CHECK_ALL_X_DATA_ARE_POSITIVE
 *	Kyle 01/19/2009 QA70-12862 ANOVA2_RAW_DATA_NOT_REQUIRE_BALANCE_DESIGNED		*
 *	Sophy 2/4/2009 v8.0971b FIX_NLSF_GIVE_WRONG_MESSAGE_FOR_SAMPLE_INTERVAL_CASE*
 *	Folger 02/09/09 QA80-12786 DATE_TIME_FORMAT_SUPPORT_IN_XF_GETN				*
 *	Folger 02/20/09 FITTING_COMPARE_SHOULD_CHECK_REQUESTED_OUTPUT_IN_RESOURCE_TREE
 *	Kyle 02/20/2009 QA80-13149 FREQUENCY_COUNT_SHOULD_UPDATE_MIN_MAX_ACCORDING_TO_INCREMENT_CHANGES
 *	Kyle 02/20/2009 QA80-13149 TEMPORARY_HIDE_INTERVALS_SINCE_ROUND_LIMITS_DOES_NOT_SUPPORT_FIXED_STEPS
 *	Kyle 03/03/2009 QA80-13149 RoundBinningRange_SUPPORT_SPECIFYING_INCREMENT	*
 *	Folger 03/12/09 QA80-13261 AUTO_SUPPORT_FOR_NUMBER_OF_POINTS_IN_INTERPOLATE_TOOLS
 *	Kyle 03/12/2009 QA80-13251 ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END		*
 *	Folger 03/13/09 QA80-13262 CONVERT_OBJECT_VARIABLE_OPTIOANL_TO_NEW_IN_XF_DIALOG
 *	Kyle 03/25/2009 QA80-13251-P4 SKIP_OR_EXTEND_THE_LAST_BIN_IF_IT_IS_NOT_A_FULL_BIN
 *	Kyle 06/01/2009 CHECK_DELIMITER_SHOULD_HANDLE_DIFF_DELIMITER_IN_DIFF_OS		*
 *	Jasmine 07/02/09 QA80-12786 Y_DATA_TYPE_NEED_UPDATE_DATA_FORMAT				*
 *	Sophy 7/8/2009 v8.1060 CLEAN_CODE_SUPPORT_UPDATE_Y_DATATYPE_BRANCH			*
 *  Iris 7/14/2009 QA80-13941 SUPPORT_MORE_OPTIONS_FOR_WREPLACE_AND_MREPLACE_XF	*
 *	Kyle 07/20/2009 WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP		*
 *	Sophy 7/22/2009 v8.1073 NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA			*
 *	Kenny 07/23/2009 QA80-13992 NEW_XF_FOR_GENERAL_MULTI_AXES_PLOTTING			*
 *  Iris 7/29/2009 WREPLACE_AND_MREPLACE_XF_FIX_ALWAYS_ASSUME_REPLACE_RANGE_IS_ACTIVE_PAGE
 *  Iris 8/07/2009 FIX_NORMALIZE_RUNTIME_ERROR_WHEN_NUM_POINTS_LESS_EQUAL_1		*
 *	Hong 08/10/09 QA-13673 ADD_COMMENT_FOR_NEW_METHOD							*
 *	Hong 08/10/09 QA-13673 ADD_COMMENT_FOR_USE_REFERENCE_COLUMN_METHOD			*
 *  Iris 08/12/09 QA-13673 RNORMALIZE_XF_ADD_USE_REFERENCE_CELL_METHOD			*
 *	Sophy 8/20/2009 QA80-14087-S2 BETTER_NAME_FOR_RESULT_COLUMNS_WHEN_WITH_REFERENCE
 *	YuI 08/19/09 QA70-14173 BRANCHED_RANGES_MAY_BE_INPROPERLY_INITIALIZED_IF_EMPTY_STRING*
 *	Sophy 9/2/2009 IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS				*
 *	Sophy 9/10/2009 QA80-14087-P15 SHOW_SUM_IN_DATA_INFO_BRANCH_FOR_NORMALIZE_TOOLS
 *	Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS			*
 *	Sophy 9/15/2009 SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE			*
 *	Sophy 9/18/2009 SMART_PAGE_FAIL_TO_SOLVE_RANGE_WHEN_SHEETNAME_HAS_WHITE_SPACE_AND_COLUMN_HAS_LONGNAME
 *  Iris 10/20/2009 ADD_FFT_PREVIEW_FOR_DECIMATE_XF								*
 *  Iris 10/21/2009 NEED_KEEP_TEMPLATE_LAYER_BORDER_AFTER_ARRANGE_LAYER			*
 *	Sophy 10/28/2009 QA80-14087-P20 CAREFULLY_UPDATE_COMMENTS_FIELD_OF_RESULT_COLUMN_WHEN_ONLY_OGG_EXIST
 *	Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES						*
 *	Folger 10/16/09 QA81-14489-P2 OPTIONAL_VECTOR_OUTPUT_BECAME_WRONG_IN_CHANGE_PARAM
 *	Jasmine 11/04/09 QA81-14845-P1 EVENT_UTILS_SHOULD_NOT_DEPEND_ON_SPECIAL_FILE_LIKE_FFT 
 *	Hong 05/17/10 ORG-131 MATRIX_ADD_GENERAL_LABEL_SUPPORT_AS_WKSHEET			*
 *	Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT			*
 *  Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL                      *
 *	Folger 08/25/10 ORG-897-P2 FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
 *	Folger 08/26/2010 ORG-920-P1 ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA
 *	Kyle 01/07/2011 ORG-1940 FREQ_COUNT_SUPPORT_SPECIFY_BY_INTERVALS			*
 *	Sim 02-09-2011 ORG-2182 NLFIT_MOVE_SETTINGS_FIND_XY							*
 *	Sim 2011-2-24 ORG-2294-S1 SUPPORT_OUTPUT_VIRTUAL_MATRIX						*
 *	Kyle 05/11/2011 ORG-2704-S1 FREQ_COUNT_ALLOW_ONE_OR_NO_DATA					*
 *  Iris 8/17/2011 ORG-3553-P1 FIX_STATS_ON_COL_THEME_BUG						*
 *  Iris 9/23/2011 ORG-3727-P1 FIX_2WAYANOVARM_FAIL_TO_GENERATE_REPORT_WHEN_INPUT_DATA_CONTAINS_EMPTY_COLUMN
 *	Folger 12/21/2011 ORG-4653-P1 AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
 *	Folger 01/05/2012 ORG-4773-P1 CLEANUP_ERR_MSG_FOR_INVALID_INDEX_OF_ORIGIN_OBJECT
 *	Folger 02/02/2012 ORG-4964-P1 DATE_TBALE_CONTROL_SHOW_ON_NORMAL_DYNA_NUMERIC_EDIT_BOX
 *	Folger 04/27/2012 ORG-5566-P1 FAILED_TO_INSERT_ROW_RANGE_FROM_COLUMN_BROWSER_IF_INSERT_MODE_AS_COLUMN_INDEX
 *  Iris 4/28/2012 ORG-5481-P4 TO_FIX_SURFACE_PLOT_TYPE_IS_EMPTY_WHEN_INPUT_DATA_FROM_CONTOUR_GRAPH
 *	Sophy 5/28/2012 ORG-5807-P1 OC_ROUND_DOUBLE_TO_INTEGER_OVERFLOW				*
 *  Philip 07/05/2012 ORG-6114 ADD_NORMALIZE_0_TO_100_OPTION_FOR_NORMALIZE_TOOL *
 *	Junon 10/08/2012 ORG-6359 PROBLEMS_WHEN_SHRINKING_MATRIX_SHEET_WITH_MULTIPLE_OBJECTS_AND_OUTPUT_IS_<INPUT>
 *	Folger 08/14/2012 ORG-6076-P14 COL_GET_RANGE_STRING_FOR_LN_SHOULD_BE_QUOTED	*
 *  Philip 08/15/2012 ORG-6114-S1 ADD_NORMALIZE2_0_100_OPTION_FOR_NORMALIZE_TOOL*
 *  Philip 08/28/2012 ORG-6114-S2 ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS	*
 *	Tony 09/17/2012 ORG-6816-P1 TRIM_COLUMN_LONG_NAME_BUT_ROWS					*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include <xfutils.h>

#include <event_utils.h>		// Prototypes for event-related functions
#include <OCTreeUtils.h>   ///Justin 2007-3-22 v8.0587 CHECK_USER_INPUTED_INTERVAL
///Jasmine 11/04/09 QA81-14845-P1 EVENT_UTILS_SHOULD_NOT_DEPEND_ON_SPECIAL_FILE_LIKE_FFT 
//#include <fft_utils.h>    /// Justin 2007-3-22 v8.0587 CHECK_USER_INPUTED_INTERVAL 
//#include <..\OriginLab\nlsf_utils.h> /// Cloud 04/24/2007 ADD_FUNCTION_TO_PROCESS_PARAMS_LIST
///End EVENT_UTILS_SHOULD_NOT_DEPEND_ON_SPECIAL_FILE_LIKE_FFT
///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
#include <..\OriginLab\Xftree.h> 
#include <..\OriginLab\Xfunction.h>
///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
//////////     	  	 Events and event related fucntions	 	  //////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

///Philip 08/28/2012 ORG-6114-S2 ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS
enum NormalizeMethod
{
	method_specify = 0,
	method_range,
	method_snd,
	method_max,
	method_min,
	method_mean,
	method_median,
	method_sd,
	method_norm,
	method_mode,
	method_sum,
	method_ref,
	method_cell,
	method_range100
};
///end ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS

string ht_set_hypot_type(const string strName, const string strValue)
{
	vector<string> vHypotType(3);
	string strOut;
	vHypotType[0] = strName + " <> " + strValue;
	vHypotType[1] = strName + " > " + strValue;
	vHypotType[2] = strName + " < " + strValue;
	strOut = vHypotType[0] + "|" + vHypotType[1] + "|" + vHypotType[2];
	
	return strOut;	
}

///Echo 6/20/06 QA70-7074-P9 ADD_DELIMITER_CHECK
bool check_delimiter_space(const string str)
{
	///Kyle 06/01/2009 CHECK_DELIMITER_SHOULD_HANDLE_DIFF_DELIMITER_IN_DIFF_OS
	//for (int ii = 0; ii < str.GetLength(); ii++)
	//{
		////only "." or " " or numeric value is enabled in string
		//string strTmp = str.GetAt(ii);
		//if (!is_numeric(strTmp))
		//{
			//if (-1 == strTmp.FindOneOf(". ")) 
				//return false
		//}			
	//}
	//
	//return true;
	// the convert_str_vector_to_num_vector will return some NANUMs if the string isn't well defined numeric string and it will take care the delimiter in diff os
	vector<string> vs;
	vector vd;
	str.GetTokens(vs, ' ');
	convert_str_vector_to_num_vector(vs, vd);
	vector<uint> vnIndices;
	return (vd.Find(vnIndices, NANUM) <= 0);
	///End CHECK_DELIMITER_SHOULD_HANDLE_DIFF_DELIMITER_IN_DIFF_OS
	
}

string ht_set_null_type(const int nTail, const string strHypoVal, const string strTest)
{
	string strNullHypot;
	switch (nTail) 
	{
	default:
	case 0:
		strNullHypot = strTest+ " = " + strHypoVal;
		break;
	case 1:
		strNullHypot = strTest+ " <= " + strHypoVal;
		break;
	case 2:
		strNullHypot = strTest+ " >= " + strHypoVal;
		break;
	}
	
	return strNullHypot;
}
int hyt_check_input(TreeNode& trGetN)
{
	
	if (trGetN.var && trGetN.var.dVal <= 0)
	{
		return CER_VAR_LS_0;
	}
	
	if ( trGetN.level && trGetN.level.Enable && !check_conf_level(trGetN.level.strVal) )
	{
		return CER_CONF_LEVS;
	}
	
	if ( trGetN.siglevel && trGetN.siglevel.Enable && !check_sig_level(trGetN.siglevel.dVal) )
	{
		return CER_INVALID_SIG_LEV;
	}
	//--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
	if(trGetN.alpha && !check_sig_level(trGetN.alpha.dVal))
	{
		return CER_INVALID_SIG_LEV;
	}
	//--- end USER_CAN_SET_SIGNIFICANCE_LEVEL
	if ( trGetN.hypotsize && trGetN.hypotsize.Enable && !check_sample_size(trGetN.hypotsize.strVal) )
	{
		return CER_SAMP_SIZES;
	}
	
	return CER_NO_ERROR;	
}

bool hyt_set_gui(TreeNode& trGetN, LPCSTR lpsczTest)
{
	if (!trGetN)
		return false;
		
	//Define Combo value of alternate hypothesis	
	string strHypoVal;
	if (trGetN.mean)
		strHypoVal = ftoa(trGetN.mean.dVal);
	else if (trGetN.var)
		strHypoVal = ftoa(trGetN.var.dVal);
	else
		strHypoVal = ftoa(1);
		
	string strHypType = ht_set_hypot_type(lpsczTest, strHypoVal);
	trGetN.tail.SetAttribute(STR_COMBO_ATTRIB, strHypType);
	
	//Null hypothesis is always disabled.
	if (trGetN.null)	trGetN.null.Enable = false;
	
	//Null hypothetival type of mean changes according to the alternate hypothetical types
	if (trGetN.null)	trGetN.null.strVal = ht_set_null_type(trGetN.tail.nVal, strHypoVal, lpsczTest);
	
	//confidence levels only enable if confidence interval check box is selected
	if (trGetN.null && trGetN.conf)	trGetN.level.Enable = trGetN.conf.nVal;	

	if (trGetN.hypotsize && trGetN.hypotpower)
		trGetN.hypotsize.Enable  = trGetN.hypotpower.nVal;

	if (trGetN.siglevel && trGetN.hypotpower && trGetN.hypotpower)
		trGetN.siglevel.Enable = trGetN.actpower.nVal || trGetN.hypotpower.nVal;
	
	return true;
}


bool ttest_event(TreeNode& trGetN,  bool& bOKEnable, string& strErrMsg, LPCSTR lpsczTest)
{
	hyt_set_gui(trGetN, lpsczTest);
	int nErr = hyt_check_input(trGetN);
	if (nErr != CER_NO_ERROR)
	{
		bOKEnable = false;
		strErrMsg = nErr;
	}

	return true;
}

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//For NLFit event trGUI is opGUI node of m_trNFO, or else trGUI is GUI node of operation tree
/// ML 12/27/2007 LPCSTR_BY_DEFAULT_SHOULD_BE_NULL_ONLY
//static TreeNode _get_node_by_tagname(TreeNode& trGUI, bool bIsNLFitOutputEvent = false, LPCSTR lpcszTagName = "Output")
static TreeNode _get_node_by_tagname(TreeNode& trGUI, bool bIsNLFitOutputEvent = false, LPCSTR lpcszTagName = NULL)
/// end LPCSTR_BY_DEFAULT_SHOULD_BE_NULL_ONLY
{
	/// ML 12/27/2007 LPCSTR_BY_DEFAULT_SHOULD_BE_NULL_ONLY
	string			strTagName = lpcszTagName;
	if ( strTagName.IsEmpty() )
		strTagName = "Output";
	/// end LPCSTR_BY_DEFAULT_SHOULD_BE_NULL_ONLY
	TreeNode trRootNode;
	if(bIsNLFitOutputEvent)
		trRootNode = trGUI.Parent();
	else
		trRootNode = trGUI;
	
	/// ML 12/27/2007 LPCSTR_BY_DEFAULT_SHOULD_BE_NULL_ONLY
	//return tree_get_node_by_tagname(trRootNode, lpcszTagName, true);
	return tree_get_node_by_tagname(trRootNode, strTagName, true);
	/// end LPCSTR_BY_DEFAULT_SHOULD_BE_NULL_ONLY
}
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL

/*
static bool _pss_check_sample_size(TreeNode& tr, WndContainer& DynaCntrlContainer)
{
	//if error specified hypothetical sample size, return error
	if (tr.CalcType.nVal == CAL_POWER)
	{
		if (!check_sample_size(tr.HypotSizes.strVal))
		{
			DynaCntrlContainer.PostMessage(WM_USER_MSG_BOX, CER_SAMP_SIZES);
			return false;
		}

	}//if Power computation is selected
	return true;	
}

static bool _pss_check_power(TreeNode& tr, WndContainer& DynaCntrlContainer)
{
	if (tr.CalcType.nVal == CAL_SAMPLE_SIZE)
	{
		if (!check_power(tr.Power.strVal))
		{
			DynaCntrlContainer.PostMessage(WM_USER_MSG_BOX, CER_POW_VALS);
			return false;
		}
	}//if Sample Size computation is selected
	return true;
	
}

static bool _pss_check_sd(TreeNode& tr, WndContainer& DynaCntrlContainer)
{
	if ( tr.SD.dVal <= 0 )
	{
		DynaCntrlContainer.PostMessage(WM_USER_MSG_BOX, CER_INVALID_SD);
		return false;
	}
	return true;
	
}
*/
bool pss_general_event(TreeNode& tr, bool& bOKEnable, string& strErrMsg)
{
	if (!tr)
		return false;

	bool bPower = (0 == tr.CalcType.nVal) ? true : false;
	
	//Hypotheical sample size related items should not be shown if CalcType = Sample Size
	tr.HypotSizes.Show = bPower;
	tr.MoreSize.Show = bPower;
	tr.SizeCol.Show = bPower;
	if (!bPower || !(tr.MoreSize.nVal)) tr.SizeCol.strVal = STR_OPTIONAL;
	
	//Hypotheical power related items should not be shown if CalcType = Power
	tr.power.Show = !bPower;
	tr.MorePower.Show =!bPower;
	tr.PowerCol.Show = !bPower;
	if (bPower || !(tr.MorePower.nVal)) tr.PowerCol.strVal = STR_OPTIONAL;
	
	int nCalcType = tr.CalcType.nVal ;
	if (nCalcType == CAL_POWER)
		tr.MorePower.nVal = 0;
	else
		tr.MoreSize.nVal = 0;
	
	//if "more sample size(s)" is checked, column specifying item should be shown and data entering item should be unabled. 
	tr.SizeCol.Enable = tr.MoreSize.nVal;
	tr.HypotSizes.Enable = 1 - tr.MoreSize.nVal;
	
	//if "more power(s)" is checked, column specifying item should be shown and data entering item should be unabled. 	tr.PowerCol.Show = tr.MorePower.nVal;
	tr.PowerCol.Enable = tr.MorePower.nVal;
	tr.Power.Enable = 1 - tr.MorePower.nVal;

	int nErr = CER_NO_ERROR;
	
	double dSD = tr.SD.dVal;
	double dAlpha = tr.Alpha.dVal;
	string strData = (nCalcType == CAL_POWER) ? tr.HypotSizes.strVal : tr.Power.strVal;
	int nMoreData = (nCalcType == CAL_POWER) ? tr.MoreSize.nVal : tr.MorePower.nVal;
	TreeNode trData = (nCalcType == CAL_POWER) ? tr.SizeCol : tr.PowerCol;
	vector vData, vSizePow;
	okxf_resolve_tree_get_data_into_vector(&trData, &vData);
	nErr = pss_check_indata(dSD, dAlpha, nCalcType, strData, nMoreData, vData);	
	
	//if no input for pss tools
	///For PSS_TTEST2 AND PSS_TTESTPAIR
	if(tr.Mean1 && tr.Mean2 && tr.SD)
	{
		if (!lstrcmp(tr.Mean1.strVal,"") || !lstrcmp(tr.Mean2.strVal,"") || !lstrcmp(tr.SD.strVal,""))
		{
			nErr = CER_PSS_TTEST2;
		}
	}

	///For PSS_TTEST1
	if(tr.HypotMean && tr.AlterMean && tr.SD)
	{
		if (!lstrcmp(tr.HypotMean.strVal,"") || !lstrcmp(tr.AlterMean.strVal,"") || !lstrcmp(tr.SD.strVal,""))
		{
			nErr = CER_PSS_TTEST1;
		}
	}
	
	///For PSS_ANOVA1
	//css of mean should be greater than 0
	if (tr.CSS)
	{
		if (tr.CSS.dVal <= 0)
		{
			nErr = CER_INVALID_CSS_MEAN;		
		}
	}
	//treatment numbers should be intergers greater than 1
	if (tr.Treatments)
	{
		if (tr.Treatments.nVal < 2 || ((tr.Treatments.dVal - (int)tr.Treatments.dVal) != 0))
		{
			nErr = CER_INVALID_TREATMENT_NUM
		}
	}
	
	if (CER_NO_ERROR != nErr)
	{
		bOKEnable = false;
		strErrMsg = nErr;
	}
	
	return true;
}

int pss_check_indata(const double dSD, const double dAlpha, const int nCalcType, const string strData, const int nMoreData, const vector& vDataCol, vector& vSizePow)
{
	if ( dSD <= 0)
		return CER_INVALID_SD;
	
	//if (dAlpha >= 0.5 || dAlpha <= 0)
	if (dAlpha >= 1 || dAlpha <= 0)
		return CER_INVALID_ALPHA;

	////Get input sample size/power
	bool bErr;
	int nErr;
	if ( 0 == nMoreData )
	{
		bErr = (nCalcType == CAL_POWER) ? check_sample_size(strData) : check_power(strData);
		if (!bErr)
		{
			nErr = (nCalcType == CAL_POWER) ? CER_SAMP_SIZES : CER_POW_VALS;
			return nErr;
		}
		///Kyle 07/20/2009 WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP
		//if (vSizePow)	strData.GetTokens(vSizePow);
		if (vSizePow)
			_check_convert_str_to_vector_double(strData, vSizePow);
		///End WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP
	}
	else
	{
		vDataCol.Trim();
		if (0 == vDataCol.GetSize())
			return CER_COL_NUM_NOT_ONE;
		
		bErr = (nCalcType == CAL_POWER) ? check_sample_size(vDataCol) : check_power(vDataCol);
		if (!bErr)
		{
			nErr = (nCalcType == CAL_POWER) ? CER_SAMP_SIZE : CER_POW_VAL;
			return nErr;
		}
		if (vDataCol && vSizePow)
		{
			vSizePow = vDataCol;
		}
	}
	
	return CER_NO_ERROR;
	
}

//void samplesize_check_error_setting(const int nTail, const double dSD, const string strData, const int nMoreData, const vector vDataCol, const int nCalcType, const Worksheet wout, vector& vSizePow)
//{
	//if ( nTail < 0 || nTail > 2 )
	//{
		//error_report(TAIL_ERROR_MSG);
		//wout.Delete(OCD_DEL_PARENT_IF_LAST);
		//return;
	//}
	//
	//if ( dSD <= 0)
	//{
		//error_report(SD_ERROR_MSG);
		//wout.Delete(OCD_DEL_PARENT_IF_LAST);
		//return;
	//}
	////Get input sample size/power
	//char chSep  = ' ';
	//int nSizePow;
	//
	//int nMissing = 0;
			//
	//if ( 0 == nMoreData )
		//nSizePow = strData.GetTokens(vSizePow, chSep);
	//else
	//{
		//vSizePow = vDataCol;
		//vSizePow.Trim();
		//nSizePow = vSizePow.GetSize();
	//}
	//
	////Should be at least 1 data in input sample size/power	
	//if(vSizePow.GetSize() == 0)
	//{
		//if (nCalcType == CAL_POWER)
			//error_report(SAMP_SIZE_TOO_FEW_MSG);
		//else
			//error_report(POW_TOO_FEW_MSG);
		//wout.Delete(OCD_DEL_PARENT_IF_LAST);
		//return;
	//}
	//
	////check bad sample size/power when input data are in column
	//if (nMoreData == 1)
	//{
		//bool bRet = ( CAL_POWER == nCalcType) ? check_bad_samplesize(vSizePow) : check_bad_power(vSizePow);
		//if ( !bRet )
			//wout.Delete(OCD_DEL_PARENT_IF_LAST);			
	//}//if hypothetical sample sizes in worksheet is selected
	//
	//
//}
//

string get_combo_value(const vector& vTokens, const bool bEditable)
{
	string strOut;

	int nSize = vTokens.GetSize();
	if (nSize != 0)
	{
		if (bEditable) strOut = "|";
		for (int ii = 0; ii < nSize - 1; ii++)
			strOut += ftoa(vTokens[ii]) + "|";
		strOut += ftoa(vTokens[ii]);
	}
	
	return strOut;
	
}


bool set_censor_list(const TreeNode& trRange, TreeNode& trCensor)
{
	Range rCensor;
	okxf_resolve_tree_construct_range(&trRange, &rCensor);
	if( rCensor )
	{
		vector vCensor,vCensorList;
		rCensor.GetData(vCensor, 1);
		string strCombo;
		if (vCensor.GetSize() > 0)
		{
			trim_duplicated_value(vCensor, vCensorList);
			strCombo = get_combo_value(vCensorList, true);
		}else
		{
			strCombo = "|.|.";
		}			
		trCensor.SetAttribute(STR_COMBO_ATTRIB, strCombo);
		
		return true;
	}
	
	return false;
		
}

///Kyle 07/20/2009 WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP, String::GetTokens won't handle delimiter(',') in GXP, which should be fixed, but in 81
static bool _check_convert_str_to_vector_double(LPCSTR lpcsz, vector& vd)
{
	string str(lpcsz);
	vector<string> vs;
	int nn = str.GetTokens(vs);
	convert_str_vector_to_num_vector(vs, vd);
	vector<uint> vnIndices;
	if(vd.Find(vnIndices, NANUM) > 0)			// some NANUM, string format error
		return false;
	return true;
}
///End WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP


bool check_conf_level(const string strConfLevel)
{
	vector vLevels;
	///Kyle 07/20/2009 WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP, String::GetTokens won't handle delimiter(',') in GXP, which should be fixed, but in 81
	//int nLevels = strConfLevel.GetTokens(vLevels);//put the confidence levels in vector
	if(!_check_convert_str_to_vector_double(strConfLevel, vLevels))
		return false;
	int nLevels = vLevels.GetSize();
	///End WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP
	
	if ( 0 == nLevels ) 
		return false;
	
	for (int ii = 0; ii < nLevels; ii++)
	{
		///Kyle 07/20/2009 WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP
		//bool bSpace = check_delimiter_space(strConfLevel);
		//if (!bSpace || vLevels[ii] <= 0 || vLevels[ii] >= 100)
		if (vLevels[ii] <= 0 || vLevels[ii] >= 100)
		///End WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP
		{
			return false;		
		}//if the confidence levels does not fit constraints, return error
	}//loop all confidence levels
	
	return true;
	
}

bool check_conf_level(const double dConfLev)
{
	if (dConfLev <= 0 || dConfLev >= 100)
	{
		return false;
	}
	
	return true;
}

bool check_conf_level(const TreeNode& trConfLevel)
{
	return check_conf_level(trConfLevel.strVal);	
}
/*
bool check_conf_level(TreeNode& trConfLevel, WndContainer& DynaCntrlContainer)
{
	if ( trConfLevel.Enable )
	{
		if (!check_conf_level(trConfLevel.strVal))
		{
			DynaCntrlContainer.PostMessage(WM_USER_MSG_ON_DLG, CER_CONF_LEVS);
			return false;
		}		
	}
	
	return true;	
}
*/

bool check_sample_size(const string strSampleSize)
{ 
	vector vSampleSize;
	///Kyle 07/20/2009 WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP, String::GetTokens won't handle delimiter(',') in GXP, which should be fixed, but in 81
	//int nSampleSize = strSampleSize.GetTokens(vSampleSize);//put the sample size in vector
	//if ( !check_delimiter_space(strSampleSize) )
		//return false;
	if(!_check_convert_str_to_vector_double(strSampleSize, vSampleSize))
		return false;
	///End WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP

	return check_sample_size(vSampleSize);
	
}

bool check_sample_size(const vector& vSampleSize)
{
	int nSampleSize = vSampleSize.GetSize();
	
	if (0 == nSampleSize)
		return false;
	
	for (int ii = 0; ii < nSampleSize; ii++)
	{
		//if (vSampleSize[ii] <= 1 || ((vSampleSize[ii] - (int)vSampleSize[ii]) != 0))///Echo 7/25/08 v8.0909 ERROR_IN_CHECK_INTEGER
		if (vSampleSize[ii] <= 1 || ((vSampleSize[ii] - ceil(vSampleSize[ii])) != 0))
		{
			return false;
		}//if the sample size does not fit constraints, return error
	}//loop all sample sizes
	
	return true;
}


bool check_power(const string strPower)
{
	vector vPower;
	///Kyle 07/20/2009 WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP, String::GetTokens won't handle delimiter(',') in GXP, which should be fixed, but in 81
	//int nPower = strPower.GetTokens(vPower);//put the powers in vector
	//if ( !check_delimiter_space(strPower) )
		//return false;
	if(!_check_convert_str_to_vector_double(strPower, vPower))
		return false;
	///End WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP
	
	return check_power(vPower);	
}

bool check_power(const vector& vPower)
{
	int nPower = vPower.GetSize();
	if (0 == nPower)
		return false;
	
	for (int ii = 0; ii < nPower; ii++)
	{
		if (vPower[ii] <= 0 || vPower[ii] >= 1)
		{
			return false;
		}//if the powers does not fit constraints, return error
	}//loop all powers
	
	return true;
}

int sa_check_data(const DataRange rData, int nThirdRange)
{
	vector vTime, vCensor, vData3;
	rData.GetData(vTime, 0);
	rData.GetData(vCensor, 1);
	rData.GetData(vData3, 2);

	vTime.Trim();
	vCensor.Trim();
	vData3.Trim();
	int nTime = vTime.GetSize();
	int nCensor = vCensor.GetSize();
	int nData3 = vData3.GetSize();
	
	int nErrCode;
	if (0 == nTime || 0 == nCensor)	
	{
		nErrCode = (SA_COVARIATE == nThirdRange) ? CER_NOT_COX_DATA : CER_NOT_SA_DATA;
		return nErrCode;
	}
	
	if (0 == nData3 && SA_COVARIATE == nThirdRange)
	{
		return CER_NOT_COVARIATE;
	}
	if ((2 > nTime || 2 > nCensor) && (SA_COVARIATE == nThirdRange))	
	{
		return CER_DATA_TOO_FEW;
	}	
	if (dr_get_col_percent_text(rData, 1, true))
	{
		return CER_NOT_VALID_CENSORING;
	}
	//if (nTime != nCensor)
		//return CER_TIME_CENSOR_DIFF_SIZE;
	////if (nData3 > 0)
		//if (mod(nData3, nTime) != 0)
		//{
			//int nErr = bGroup ? CER_TIME_GROUP_DIFF_SIZE : CER_TIME_COVAR_DIFF_SIZE;
			//return nErr;
		//}	
	
	return CER_NO_ERROR;
}

int sa_check_data(const TreeNode trRange, int nThirdRange)
{
	if (!trRange)
		return CER_INVALID_TREENODE;
	
	/// YuI 08/19/09 QA70-14173 BRANCHED_RANGES_MAY_BE_INPROPERLY_INITIALIZED_IF_EMPTY_STRING
	string strVal = trRange.strVal;
	if( !sa_check_range_string(strVal) )
		return CER_NOT_SA_DATA;
	/// end BRANCHED_RANGES_MAY_BE_INPROPERLY_INITIALIZED_IF_EMPTY_STRING
	
	Range rData;
	okxf_resolve_tree_construct_range(&trRange, &rData);
	if( rData )
	{
		return sa_check_data(rData, nThirdRange);
	}
}

/// YuI 08/19/09 QA70-14173 BRANCHED_RANGES_MAY_BE_INPROPERLY_INITIALIZED_IF_EMPTY_STRING
/**$
	Check whether input range string for Survival Analysis(s) is correct. 
	Return:
		TRUE if correct, FALSE otherwise
*/
BOOL	sa_check_range_string(LPCSTR lpsszRange)
{
	StringArray arr;
	if( okutil_parse_complex_generic_range_string(lpsszRange, &arr, PRS_SINGLEWORD_KEYWORD_OBJECT | PRS_SINGLEWORD_BOOK) )
	{
		if( arr.GetSize() < 2 || arr[0].IsEmpty() || arr[1].IsEmpty() )
			return FALSE;
		
		return TRUE;
	}
	
	return FALSE;
}
/// end BRANCHED_RANGES_MAY_BE_INPROPERLY_INITIALIZED_IF_EMPTY_STRING

int check_valid_censoring(const vector& vCensoring, const vector& vCensor)
{
	int nCensoring = vCensoring.GetSize();
	if (0 == nCensoring)
		return CER_NO_CENSORING;
	
	///Echo 7/25/07 QA70-7191-P6 v8.0667 NO_CENSOR_SHOULD_BE_SUPPORTED
	/*
	vector<uint> vecIndex;
	for (int ii = 0; ii < nCensoring; ii++)
	{
		if (1 > vCensor.Find(vecIndex, vCensoring[ii]))
			return CER_NOT_VALID_CENSORING;				
	}
	*/
	///end NO_CENSOR_SHOULD_BE_SUPPORTED
	
	return CER_NO_ERROR;
}

int km_get_data(const DataRange& dr, vector& vTime, vector& vCensor, vector& vGroup, vector& vNumInGroup, vector<string>& vstrGroup)
{
	DWORD dwRules = DRR_NO_WEIGHTS|DRR_GET_MISSING;
	int nNumData = dr.GetNumData(dwRules);
	if (mod(nNumData,2))
		return CER_NOT_SA_DATA;
	
	if (dr.GetNumRanges() > 3)
	{
		int r1, c1, r2, c2;
		Worksheet wksTemp;
		string strRange;
		dr.GetRange(2, r1, c1, r2, c2, wksTemp, &strRange);
		if ((c2-c1)> 0)
			return CER_COL_NUM_NOT_ONE_EX;
	}
	
	int nErr, nMissing;
	nNumData /= 2;
	for (int ii = 0; ii < nNumData; ii++)
	{
		vector vSubTime, vSubCensor, vW, vSubGroup;
		vector<string> vstrFactor;
		dr.GetData(dwRules, ii, NULL, NULL, &vSubTime, NULL, NULL, &vstrFactor, &vW);	
		dr.GetData(dwRules, nNumData+ii, NULL, NULL, &vSubCensor, NULL, NULL, &vstrFactor, &vW);	
		nErr = trim_nanum_sa(&nMissing, vSubTime, vSubCensor);
		if (nErr != OE_NOERROR)
			continue;
		
		if (0 == vSubTime.GetSize() || 0 == vSubCensor.GetSize())	
		{
			return CER_NOT_SA_DATA;
		}
		vTime.Append(vSubTime);
		vCensor.Append(vSubCensor);
		vNumInGroup.Add((double)vSubTime.GetSize());
		
		vSubGroup.SetSize(vSubTime.GetSize());
		vSubGroup = ii+1;
		vGroup.Append(vSubGroup);
		if (nNumData == 1)
			vstrGroup.Add(" ");
		else
			vstrGroup.Add(vstrFactor[0]);
	}
	
	return CER_NO_ERROR;
}

int check_valid_censoring(const TreeNode& trGetN)
{
	if (!trGetN)
		return CER_INVALID_TREENODE;
	
	string strCensoring = trGetN.censor.strVal;
	vector vCensoring;
	///Kyle 07/20/2009 WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP
	//strCensoring.GetTokens(vCensoring);
	_check_convert_str_to_vector_double(strCensoring, vCensoring);
	///End WALK_AROUND_STRING_GETTOKENS_TO_CHECK_DELIMITER_IN_GXP

	
	vector vCensor;	
	TreeNode trRange = trGetN.irng;
	Range rCensor;
	okxf_resolve_tree_construct_range(&trRange, &rCensor);
	if( rCensor )
	{
		if (dr_get_col_percent_text(rCensor, 1, true))
		{
			return CER_NOT_VALID_CENSORING;
		}
		
		vector vCensor;
		rCensor.GetData(vCensor, 1);
		return 	check_valid_censoring(vCensoring, vCensor);
		

	}
	
	return CER_NOT_VALID_CENSORING;
	
}

bool check_sig_level(const double dSigLevel)
{
	if (dSigLevel <= 0 || dSigLevel >= 1)
	{
		return false;
	}
	
	return true;
	
}
/*
bool check_sig_level(const TreeNode& trSigLevel, WndContainer& DynaCntrlContainer)
{	
	if (trSigLevel.Enable)
	{
		if (!check_sig_level(trSigLevel.dVal) )
		{		
			DynaCntrlContainer.PostMessage(WM_USER_MSG_BOX, CER_INVALID_SIG_LEV);
			return false;
		}
	}
	return true;
}
*/
int check_2_data_in_group(const TreeNode& trRange, const bool bPair)
{
	if ( !trRange )
		return CER_INVALID_TREENODE;
	
	Range rData;
	okxf_resolve_tree_construct_range(&trRange, &rData);
	if (rData)
	{
		vector vData1, vData2;
		vector<string> vstrLab;
		int nMissing;
		return get_2_data_in_group(rData, vData1, vData2, vstrLab, nMissing, bPair);
	}
	
}

int check_2_data_in_var(const TreeNode& trRange, const bool bPair)
{
	if ( !trRange )
		return CER_INVALID_TREENODE;
	
	Range rData;
	okxf_resolve_tree_construct_range(&trRange, &rData);
	if (rData)
	{
		vector<string> vstrLab;
		vector vData1, vData2;
		int nMissing;
		return get_2_data_in_var(rData, vData1, vData2, vstrLab, nMissing, bPair);
	}
	
}
///Jasmine 01/09/07 CHECK_ENTIRE_COLUMN_SELECTED, must select one or more entire columns/rows
int check_1_column(const Range& rData, const bool bMultiCol, const bool bCol)
{
	int nNumRanges = rData.GetNumRanges(), r1, r2, c1, c2;
	int nErrFew = bCol? CER_COL_NUM_TOO_FEW_EX : CER_ROW_NUM_TOO_FEW_EX;
	int nErrOne = bCol? CER_COL_NUM_NOT_ONE : CER_ROW_NUM_NOT_ONE;
	int nErrEntire = bCol? CER_SELECT_ENTIRE_COL : CER_SELECT_ENTIRE_ROW;
	Worksheet wksTemp;
	if(1 > nNumRanges)
	{
		int nErrCode = bMultiCol ? nErrFew : nErrOne;
		return nErrCode;		
	}
	if(!bMultiCol)
	{
		if(1 < nNumRanges)
			return nErrOne;	
		rData.GetRange(0, r1, c1, r2, c2, wksTemp);
		bool bOne = bCol? (c1 == c2) : (r1 == r2);
		if(!bOne)
			return nErrOne;
		bool bEntire = bCol? (!r1 && r2 < 0) : (!c1 && c2 < 0);
		if(!bEntire)
			return nErrEntire;
		return CER_NO_ERROR;
	}	
	for(int ii = 0; ii < nNumRanges; ii++)
	{
		rData.GetRange(ii, r1, c1, r2, c2, wksTemp);
		bool bEntire = bCol? (!r1 && r2 < 0) : (!c1 && c2 < 0);
		if(!bEntire)
			return nErrEntire;
	}//end judge nNumRanges
	return CER_NO_ERROR;
}
int check_1_column(const TreeNode& trRange, const bool bMultiCol, const bool bCol)
{
	if ( !trRange )
		return CER_INVALID_TREENODE;	
	Range rData;
	okxf_resolve_tree_construct_range(&trRange, &rData);
	if ( rData )
	{
		return check_1_column(rData, bMultiCol, bCol);
	}	
}
///End CHECK_ENTIRE_COLUMN_SELECTED

int check_1_data(const Range& rData, const bool bMultiCol, const bool bText, int* nMinSize, int* nMaxSize)
{
	
	DWORD dwRules = DRR_NO_WEIGHTS;
	if (bText) dwRules = dwRules|DRR_GET_MISSING;
	DWORD dwPlotID;
	
	int nNumRanges = rData.GetNumData(dwRules);	
	if (!bMultiCol && 1 != nNumRanges)
		return CER_COL_NUM_NOT_ONE;
	
	if (bMultiCol && 1 > nNumRanges)
		return CER_COL_NUM_TOO_FEW_EX;
		
	vector vData;
	vector<string> vstrData;
	int nSize = 0, nMinTmp = 0, nMaxTmp = 0, nColSize = 0;
	for (int ii = 0; ii < nNumRanges; ii++)
	{
		if (bText)
		{
			rData.GetData(dwRules, ii, &dwPlotID, NULL, &vstrData, NULL, NULL, NULL);
			nColSize = vstrData.GetSize();			
		}
		else
		{
			rData.GetData(dwRules, ii, &dwPlotID, NULL, &vData, NULL, NULL, NULL);
			nColSize = vData.GetSize();
		}
		nSize += nColSize;
		
		nMinTmp = (ii == 0) ? nColSize : min(nMinTmp, nColSize);
		nMaxTmp = (ii == 0) ? nColSize : max(nMaxTmp, nColSize)
	}

	if (0 == nSize)
		return CER_NO_DATA;	
	
		
	if (nMinSize)	*nMinSize = nMinTmp;
	if (nMaxSize)	*nMaxSize = nMaxTmp;

	return CER_NO_ERROR;
}

int check_1_data(const TreeNode& trRange, const bool bMultiCol, const bool bText, int* nMinSize, int* nMaxSize)
{
	if ( !trRange )
		return CER_INVALID_TREENODE;
	
	Range rData;
	okxf_resolve_tree_construct_range(&trRange, &rData);
	if ( rData )
	{
		double dMinSize;
		int nErr = check_1_data(rData, bMultiCol, bText, nMinSize, nMaxSize);
		//if (dSize)	*dSize = dMinSize;
		//
		return nErr;
	}
	
}

//int check_data_in_var(DataRange& rData, int nLevels)	///Echo 05/28/08 v8.0871 DETECT_BALANCE_DESIGN
int check_data_in_var(DataRange& rData, int nLevels, bool bBalance)
{
	if ( !rData )
		return CER_INVALID_TREENODE;

	if ( nLevels > rData.GetNumData() )
		return CER_NOT_ANOVA_RAW_DATA;
	
	int nSumSize = 0, nSize = 0;
	DWORD dwRules = DRR_NO_WEIGHTS | DRR_NO_FACTORS	;
	for (int ii = 0; ii < rData.GetNumData(dwRules); ii++)
	{
		vector vData;
		DWORD dwPlotID;
		rData.GetData(dwRules, ii, &dwPlotID, NULL, &vData);
		///Echo 05/28/08 v8.0871 DETECT_BALANCE_DESIGN
		if (ii != 0 && nSize != vData.GetSize() && bBalance)
			return CER_NOT_1_DATA_PER_CELL;
		nSize = vData.GetSize();	
		///end DETECT_BALANCE_DESIGN
		
		/// Iris 9/23/2011 ORG-3727-P1 FIX_2WAYANOVARM_FAIL_TO_GENERATE_REPORT_WHEN_INPUT_DATA_CONTAINS_EMPTY_COLUMN
		if( 0 == nSize )
			///Sophy 1/11/2012 ORG-4822-S1 BETTER_ERR_MSG_FOR_ANALYSIS_ON_NO_NUMERIC_DATA
			//return CER_EMPTY_COLUMN;
			return CER_NO_DATA;
			///end BETTER_ERR_MSG_FOR_ANALYSIS_ON_NO_NUMERIC_DATA
		///End FIX_2WAYANOVARM_FAIL_TO_GENERATE_REPORT_WHEN_INPUT_DATA_CONTAINS_EMPTY_COLUMN
		nSumSize += nSize;
	}
	
	if ( nSumSize == 0 )
		return CER_NO_DATA;
		
	return CER_NO_ERROR;	
	
}
int check_data_in_group(DataRange& rData)
{
	vector vData, vNumInGroup;
	vector<string> vstrLab;
	return get_data_in_group(rData, vData, vNumInGroup, vstrLab);
}

int check_data_in_group(TreeNode& trRange)
{
	if ( !trRange )
		return CER_INVALID_TREENODE;
	
	Range rData;
	okxf_resolve_tree_construct_range(&trRange, &rData);
	if ( rData )
	{
		vector vData, vNumInGroup;
		vector<string> vstrLab;
		return get_data_in_group(rData, vData, vNumInGroup, vstrLab);
	}	
}
int anova2_check_data(Range& rRange)
{
	vector vData, vFactor1, vFactor2;
	vector<string> vstrFactor1;
	
	return anova2_check_data(rRange, vData, vFactor1, vFactor2, vstrFactor1);
}

int anova2_check_data(Range& rRange, vector& vData, vector& vFactor1, vector& vFactor2, vector<string>& vstrFactor1)
{
	if ( !rRange )
		return CER_INVALID_RANGE;

	vector<string> vstrFactor2;
	int nErr = get_anova2_data(rRange, vData, vFactor1, vFactor2, vstrFactor1,vstrFactor2);
	int nData = vData.GetSize();
	double dMin, dMax;
	vFactor1.GetMinMax(dMin, dMax);
	int nFactor1 = (int)dMax;
	vFactor2.GetMinMax(dMin, dMax);
	int nFactor2 = (int)dMax;
	
	if (nData < 1)
		return CER_NOT_ANOVA2_DATA;
	
	if (nData < ANOVA2_MIN_DATA_SIZE) 
		return CER_DATA_TOO_FEW;
			
	if (nFactor1 < ANOVA2_MIN_FACTOR_SUBJECT || nFactor2 < ANOVA2_MIN_FACTOR_SUBJECT)
		return CER_TO_FEW_FACTOR;

	///Kyle 01/19/2009 QA70-12862 ANOVA2_RAW_DATA_NOT_REQUIRE_BALANCE_DESIGNED
	//vector<int> vnFactor1, vnFactor2;
	//vnFactor1 = vFactor1;
	//vnFactor2 = vFactor2;
	//if (CER_NO_ERROR != ocmath_anova2_count_values_per_cell(vData.GetSize(), vnFactor1, vnFactor2))
		//return CER_NOT_1_DATA_PER_CELL;
	///End ANOVA2_RAW_DATA_NOT_REQUIRE_BALANCE_DESIGNED
		
	return 	CER_NO_ERROR;
	
}

//-- Iris 10/26/06 CHECK_IF_ONE_CELL_FOR_INSERTGRAPH_XF
///Jasmine 01/26/07 CHECK_1_CELL_MODIFICATION, we should get range derectly from TreeNode
int check_1_cell(const TreeNode& trRange)
{
	if(!trRange)
		return CER_INVALID_TREENODE;	
	Range rData;
	okxf_resolve_tree_construct_range(&trRange, &rData);
	if(rData)
	{
		return check_1_cell(rData);
	}	
}
int check_1_cell(const Range& dr)//LPCSTR lpcszRange)
{
	//DataRange dr;
	//dr.Add("Range1", lpcszRange);
	if(!dr || 1 > dr.GetNumRanges())
///End CHECK_1_CELL_MODIFICATION
		return CER_NO_DATA;
	
	if (1 == dr.GetNumRanges())
	{
		int r1, r2, c1, c2;
		Worksheet wksTemp;
		dr.GetRange(0, r1, c1, r2, c2, wksTemp);
		if(wksTemp && c1 == c2 && r2 == r1)
			return CER_NO_ERROR;
	}
	return CER_NOT_ONE_CELL;
}
//--

//Alex 08/02/06
bool nph_add_null_event(TreeNode& trGetN)
{
	trGetN.null.Enable = false;
	//Null hypothetival type of mean changes according to the alternate hypothetical types
	switch(trGetN.tail.nVal)
	{
	case 1:
			trGetN.null.strVal = "F(x) <= G(x) " ;
		break;
	case 2:
			trGetN.null.strVal = "F(x) >= G(x) " ;
		break;
	default:
		trGetN.null.strVal = "F(x) = G(x) " ;
	}
	return true;
}

///------ Folger 08/26/2010 ORG-920-P1 ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA
//bool tr_set_optional(const int nEventID, LPCSTR lpcszNodeName, TreeNode& trReportData, const bool bEnabled, LPCSTR lpcszRDLabel)
bool tr_set_optional(const int nEventID, LPCSTR lpcszNodeName, TreeNode& trReportData, const bool bEnabled, LPCSTR lpcszRDLabel, LPCSTR lpcszDisableLabel/* = NULL*/)
///------ End ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA
{
	///------ Folger 08/26/2010 ORG-920-P1 ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA
	string		strOptional = STR_OPTIONAL;
	if ( NULL == lpcszDisableLabel )
		lpcszDisableLabel = strOptional;
	///------ End ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA
	
	if (!trReportData)
		return false;
	
	string strTagName = trReportData.tagName;
	trReportData.Enable = bEnabled;

	/// Max 4/7/08 v8.0838 MUST_CHECK_VALID_INPUT
	if(lpcszNodeName == NULL)	// may come from theme
	{
		return false;
	}
	/// END MUST_CHECK_VALID_INPUT
	
	bool bIsChangingRD = lstrcmpi(lpcszNodeName, strTagName) == 0 ? true:false;
	
	//string strLabel;
	//strLabel.Format("[<input>]<new name:=%s>", lpcszRDLabel);
	//if ( !bIsChangingRD && GETNE_ON_OK != nEventID && GETNE_ON_INIT != nEventID)
	
	/// YuI 11/20/06 TEMP_SOLUTION_TO_AVOID_REPLACING_VALUE_WITH_DEFAULT
	//	if ( !bIsChangingRD && nEventID >= 0)
	//		trReportData.strVal = ( bEnbled ) ? strLabel : "<optional>";
	if ( !bIsChangingRD && nEventID >= 0)
	{
		if( !bEnabled )
		{
			///------ Folger 08/26/2010 ORG-920-P1 ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA
			//trReportData.strVal = STR_OPTIONAL;
			trReportData.strVal = lpcszDisableLabel;
			///------ End ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA
		}
		///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
		//else if( trReportData.strVal.IsEmpty() || trReportData.strVal.Compare(STR_OPTIONAL) == 0 )
		///Sohy 4/25/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
		//else if( trReportData.strVal.IsEmpty() || PDS_OPTIONAL == cvt_str_to_predefined_type(trReportData.strVal) )
		else if( trReportData.strVal.IsEmpty() || PDS_OPTIONAL == str_to_predefined_type(trReportData.strVal) )		
		///end ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
			///---END CLEAN_LOCALIZATION_CODE
		{
			trReportData.strVal = lpcszRDLabel;
		}
	}
	
	return true;
	
}

///------ Folger 08/26/2010 ORG-920-P1 ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA
#define		STR_REPORTDATA_OLD_VALUE		"RDOldVal"
bool tr_set_optional_ex(int nEventID, LPCSTR lpcszNodeName, TreeNode& trReportData, bool bChangeParam, bool bAnyPlot, LPCSTR lpcszRDLabel/* = STR_DEFAULT_TEXT_FOR_REPORT_DATA_NODE*/)
{
	string		strRDvalue = lpcszRDLabel;
	if ( !trReportData.strVal.IsEmpty() && okutil_cvt_str_to_predefined_type(trReportData.strVal) != PDS_OPTIONAL )
	{
		strRDvalue = trReportData.strVal;
		trReportData.SetAttribute(STR_REPORTDATA_OLD_VALUE, strRDvalue);
	}
	else if ( trReportData.GetAttribute(STR_REPORTDATA_OLD_VALUE, strRDvalue) )
		;
	else
	{
		okutil_convert_localized_PDS(&strRDvalue);
	}
	LPCSTR	lpcszDisableLabel = NULL;
	if ( bChangeParam && bAnyPlot )
		lpcszDisableLabel = strRDvalue;
	
	return tr_set_optional(nEventID, lpcszNodeName, trReportData, !bChangeParam && bAnyPlot, strRDvalue, lpcszDisableLabel);
}
///------ End ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA

/// Max 3/7/08 SHOULD_PASS_WHOLE_STRING_OF_LPCSZRDLABEL_FOR_LOCALIZATION
// So we use tr_set_optional() directly instead
/*
bool rd_set_optional(const int nEventID, const bool& bOKEnable, LPCSTR lpcszNodeName, TreeNode& trReportData, const bool bEnbled, LPCSTR lpcszRDLabel)
{
	string strLabel;
	strLabel.Format("[<input>]<new name:=%s>", lpcszRDLabel);
	
	return tr_set_optional(nEventID, lpcszNodeName, trReportData, bEnbled, strLabel);
	
}
*/
/// END SHOULD_PASS_WHOLE_STRING_OF_LPCSZRDLABEL_FOR_LOCALIZATION

int check_input_range(Range& rData, int nExcludeMissing)
{
	matrix mData;
	
	if (0 >= rData.GetNumData())
		return CER_COL_NUM_TOO_FEW;
	
	if(!get_data_from_dr_to_mat(rData, mData))
		return CER_COL_NUM_TOO_FEW;
	
	if (CORR_EXCLUDE_MISSING_LISTWISE == nExcludeMissing)
	{
		mData.RemoveEmptyRows(false);
	}
	
	if (2 > mData.GetNumCols())
		return CER_COL_NUM_TOO_FEW;
	
	if (2 > mData.GetNumRows())
		return CER_DATA_TOO_FEW;	
		
	return CER_NO_ERROR;	

}

int check_input_range(TreeNode& trRange, int nExcludeMissing)
{
	if ( !trRange )
		return CER_NO_DATA;
	
	Range rData;
	okxf_resolve_tree_construct_range(&trRange, &rData);
	if ( rData )
		return check_input_range(rData, nExcludeMissing);
}

/// Max 10/06/06 move from minterp2.oxf
int get_variable_type(TreeNode& trParam)
{
	string strParam = trParam.strVal;
	if(strParam.IsEmpty())	
		return PDS_UNASSIGNED;
	
	return okutil_cvt_str_to_predefined_type(strParam);
}

bool set_value_for_auto_and_unassigned(TreeNode& trParam, double dVal, bool bIsChangingData)
{
	if(!trParam)	
		return false;
	int nType = get_variable_type(trParam);
	if(PDS_AUTO == nType || PDS_UNASSIGNED == nType || bIsChangingData)
	{
		trParam.dVal = dVal;	
		return true;
	}
}

bool set_value_for_auto_and_unassigned(TreeNode& trParam, int nVal, bool bIsChangingData)
{
	if(!trParam)	
		return false;
	int nType = get_variable_type(trParam);
	if(PDS_AUTO == nType || PDS_UNASSIGNED == nType || bIsChangingData)
	{
		trParam.nVal = nVal;	
		return true;
	}	
}

/// Hong 05/17/10 ORG-131 MATRIX_ADD_GENERAL_LABEL_SUPPORT_AS_WKSHEET
bool set_value_for_auto_and_unassigned(TreeNode& trParam, LPCSTR lpcszVal, bool bIsChangingData/* = false*/)
{
	if(!trParam)	
		return false;
	int nType = get_variable_type(trParam);
	if(PDS_AUTO == nType || PDS_UNASSIGNED == nType || bIsChangingData)
	{
		trParam.strVal = lpcszVal;	
		return true;
	}	
	return false;
}
/// end MATRIX_ADD_GENERAL_LABEL_SUPPORT_AS_WKSHEET

/*
bool update_xminmax_show(TreeNode& trGetN, bool bIsChangingData)
{
	XYRange xyTemp;
	bool bOK = xy_range_from_GetN_data_node(trGetN.yi, xyTemp);
	
	if(bOK && xyTemp.IsValid())
	{
		vector vx, vy;
		xyTemp.GetData(vy, vx);
			
		double dxMin, dxMax;
		vx.GetMinMax(dxMin, dxMax);
		set_value_for_auto_and_unassigned(trGetN.xmin, dxMin, bIsChangingData);
		set_value_for_auto_and_unassigned(trGetN.xmax, dxMax, bIsChangingData);
		return true;
	}
	return false;
}

bool update_xyminmax_show(TreeNode& trGetN, bool bIsChangingData)
{
	MatrixObject mi;
	bool bOK = okxf_resolve_string_get_origin_object(trGetN.mi.strVal, &mi);
	
	if(bOK && mi.IsValid())
	{
		double dxMin, dyMin, dxMax, dyMax;
		mi.GetXY(dxMin, dyMin, dxMax, dyMax);
		set_value_for_auto_and_unassigned(trGetN.xmin, dxMin, bIsChangingData);
		set_value_for_auto_and_unassigned(trGetN.ymin, dyMin, bIsChangingData);
		set_value_for_auto_and_unassigned(trGetN.xmax, dxMax, bIsChangingData);
		set_value_for_auto_and_unassigned(trGetN.ymax, dyMax, bIsChangingData);
		return true;
	}
	return false;
}
*/
/// TD 12-15-2008 QA80-12786  DYNACONTROL_DOUBLES_TO_SUPPORT_DATE_TIME_INCR_FMTS
///Sophy 1/12/2012 ORG-2878 FREQ_COUNT_SUPPORT_DATETIME_DISPLAY_IN_GUI
//int get_col_data_format(const TreeNode& tnRange, int nAxisType/*= OKDATAOBJ_DESIGNATION_X*/)
///Sophy 4/5/2012 ORG-4611-P1 BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
//int get_col_data_format(const TreeNode& tnRange, int nAxisType/*= OKDATAOBJ_DESIGNATION_X*/, string* pstrDateTimeFmt/* = NULL*/)
int get_col_data_format(const TreeNode& tnRange, int nAxisType/*= OKDATAOBJ_DESIGNATION_X*/, ColFmtInfoPtr pColFmtInfo/* = NULL*/)
///end BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
///end FREQ_COUNT_SUPPORT_DATETIME_DISPLAY_IN_GUI
{
	XYRange xyTemp;
	if(xy_range_from_GetN_data_node(tnRange, xyTemp) && xyTemp.IsValid())
	{
		Column  col;
		switch(nAxisType)
		{
		case OKDATAOBJ_DESIGNATION_X:
			xyTemp.GetXColumn(col);
			break;
		case OKDATAOBJ_DESIGNATION_Y:
			xyTemp.GetYColumn(col);
			break;
		case OKDATAOBJ_DESIGNATION_ERROR:
			xyTemp.GetErrColumn(col);
			break;
		}
		if(col.IsValid())
		{
			///Sophy 1/12/2012 ORG-2878 FREQ_COUNT_SUPPORT_DATETIME_DISPLAY_IN_GUI
			bool bForDateTimePicker = true;
			string strFmt;
			int nLtFmt = get_lt_datetime_display_format(col, strFmt, bForDateTimePicker);
			///end FREQ_COUNT_SUPPORT_DATETIME_DISPLAY_IN_GUI
			///Sophy 4/5/2012 ORG-4611-P1 BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
			if ( NULL != pColFmtInfo )
			{
				pColFmtInfo->m_nLTFormat = nLtFmt;
				pColFmtInfo->m_strDispFmt = strFmt;
				pColFmtInfo->m_bForDateTimePicker = bForDateTimePicker;
			}
			///end BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
			return col.GetFormat();
		}
	}
	return -1;
}

//void set_node_appropriate_numeric_format(const TreeNode& tnNumericData, int nDataFormat, BOOL bInterval) //=FALSE
void set_node_appropriate_numeric_format(const TreeNode& tnNumericData, int nDataFormat, BOOL bInterval
										 ///------ Folger 08/25/10 ORG-897-P2 FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
										 , LPCSTR pFormatDate/* = "D10"*/
										 , LPCSTR  pFormatTime/* = "T2"*/
										 ///------ End FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
										 , bool bForDateTimePicker = /* = false*/	///Sophy 4/5/2012 ORG-4611-P1 BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
										 )
{
	if(nDataFormat < 0)
		return;
	//-----------------------------------
	///------ Folger 08/25/10 ORG-897-P2 FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
	//LPCSTR  pFormatDate = "D10";
	//LPCSTR  pFormatTime = "T2";
	///------ End FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
	LPCSTR  pFormatInterval = "D4096";
	//-----------------------------------
	string strFormat = "*";
	if(OKCOLTYPE_DATE == nDataFormat)
	{
		strFormat = bInterval ? pFormatInterval : pFormatDate;
		///Sophy 3/12/2012 ORG-2189-P1 PROPER_SET_TREENODE_DATETIME_PICKER_CONTROL
		//tnNumericData.SetAttribute(STR_ID_ATTRIB, TRGP_DATE);		///------ Folger 02/02/2012 ORG-4964-P1 DATE_TBALE_CONTROL_SHOW_ON_NORMAL_DYNA_NUMERIC_EDIT_BOX
		///Sophy 4/16/2012 ORG-2189-P9 PROPER_SET_FORMAT_FOR_INTERVAL_NODE
		//set_node_datetime_picker(tnNumericData, strFormat, true, bForDateTimePicker);
		set_node_datetime_picker(tnNumericData, strFormat, true, !bInterval && bForDateTimePicker);
		///end PROPER_SET_FORMAT_FOR_INTERVAL_NODE
		///end PROPER_SET_TREENODE_DATETIME_PICKER_CONTROL
	}
	else if(OKCOLTYPE_TIME == nDataFormat)
	{
		strFormat = bInterval ? pFormatInterval : pFormatTime;
		///Sophy 3/12/2012 ORG-2189-P1 PROPER_SET_TREENODE_DATETIME_PICKER_CONTROL
		//tnNumericData.SetAttribute(STR_ID_ATTRIB, TRGP_TIME);		///------ Folger 02/02/2012 ORG-4964-P1 DATE_TBALE_CONTROL_SHOW_ON_NORMAL_DYNA_NUMERIC_EDIT_BOX
		///Sophy 4/16/2012 ORG-2189-P9 PROPER_SET_FORMAT_FOR_INTERVAL_NODE
		//set_node_datetime_picker(tnNumericData, strFormat, false, bForDateTimePicker);
		set_node_datetime_picker(tnNumericData, strFormat, false, !bInterval && bForDateTimePicker);
		///end PROPER_SET_FORMAT_FOR_INTERVAL_NODE
		///end PROPER_SET_TREENODE_DATETIME_PICKER_CONTROL
	}
	///------ Folger 02/02/2012 ORG-4964-P1 DATE_TBALE_CONTROL_SHOW_ON_NORMAL_DYNA_NUMERIC_EDIT_BOX
	//tnNumericData.SetAttribute(STR_ID_ATTRIB, TRGP_DATE);	///Sophy 1/20/2011 ORG-2189-S1 DATETIME_PICK_CONTROL_FOR_GETN_BOX_SUPPORT
	///------ End DATE_TBALE_CONTROL_SHOW_ON_NORMAL_DYNA_NUMERIC_EDIT_BOX
	tnNumericData.SetAttribute(STR_ATTRIB_NUMFMT, strFormat);
}

/// end DYNACONTROL_DOUBLES_TO_SUPPORT_DATE_TIME_INCR_FMTS

///------ Folger 02/09/09 QA80-12786 DATE_TIME_FORMAT_SUPPORT_IN_XF_GETN
void update_dataformat_start_end_interval(const TreeNode& trRange, TreeNode& tr, 
										LPCSTR lpcszStartNode, LPCSTR lpcszEndNode, LPCSTR lpcszIntervalNode/* = NULL*/,
										int nAxisType/*= OKDATAOBJ_DESIGNATION_X*/	///Jasmine 07/02/09 QA80-12786 Y_DATA_TYPE_NEED_UPDATE_DATA_FORMAT
										///------ Folger 08/25/10 ORG-897-P2 FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
										, LPCSTR pFormatDate/* = "D10"*/
										, LPCSTR  pFormatTime/* = "T2"*/
										///------ End FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
										)
{
	///Sophy 1/12/2012 ORG-2878 FREQ_COUNT_SUPPORT_DATETIME_DISPLAY_IN_GUI
	//int nColFormat = get_col_data_format(trRange, nAxisType);
	ColFmtInfo stColFmtInfo;
	int nColFormat = get_col_data_format(trRange, nAxisType, &stColFmtInfo);
	pFormatDate = stColFmtInfo.m_strDispFmt;;
	pFormatTime = stColFmtInfo.m_strDispFmt;
	///Sophy 4/5/2012 ORG-4611-P1 BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
	bool bForDateTimePicker = stColFmtInfo.m_bForDateTimePicker;
	if ( LT_FORMAT_DATE == stColFmtInfo.m_nLTFormat )
		nColFormat = OKCOLTYPE_DATE;
	else if ( LT_FORMAT_TIME == stColFmtInfo.m_nLTFormat )
		nColFormat = OKCOLTYPE_TIME;
	///end BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
	///end FREQ_COUNT_SUPPORT_DATETIME_DISPLAY_IN_GUI
	
	if ( lpcszStartNode )
	{
		TreeNode trStart = tr.GetNode(lpcszStartNode);
		if ( trStart )
			///------ Folger 08/25/10 ORG-897-P2 FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
			//set_node_appropriate_numeric_format(trStart, nColFormat);
			set_node_appropriate_numeric_format(trStart, nColFormat, FALSE, pFormatDate, pFormatTime, bForDateTimePicker);
			///------ End FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
		else
			ASSERT(false);
	}
	
	if ( lpcszEndNode )
	{
		TreeNode trEnd = tr.GetNode(lpcszEndNode);
		if ( trEnd )
			///------ Folger 08/25/10 ORG-897-P2 FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
			//set_node_appropriate_numeric_format(trEnd, nColFormat);
			set_node_appropriate_numeric_format(trEnd, nColFormat, FALSE, pFormatDate, pFormatTime, bForDateTimePicker);
			///------ End FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
		else
			ASSERT(false);
	}
	
	if ( lpcszIntervalNode )
	{
		TreeNode trInterval = tr.GetNode(lpcszIntervalNode);
		if ( trInterval )
			///------ Folger 08/25/10 ORG-897-P2 FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
			//set_node_appropriate_numeric_format(trInterval, nColFormat, TRUE);
			set_node_appropriate_numeric_format(trInterval, nColFormat, TRUE, pFormatDate, pFormatTime, bForDateTimePicker);
			///------ End FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
		else
			ASSERT(false);
	}
}
///------ End DATE_TIME_FORMAT_SUPPORT_IN_XF_GETN

bool get_data_x_scale(const TreeNode& trGetN, double& xmin, double& xmax)
{
	XYRange xyTemp;
//----------- CPY 4/11/07 QA70-9562 BETTER_NOT_ASSUME_YI_AS_INPUT_DATA_NODE
//	bool bOK = xy_range_from_GetN_data_node(trGetN.iy, xyTemp);
	bool bOK = false;
	if(trGetN.iy)
		bOK = xy_range_from_GetN_data_node(trGetN.iy, xyTemp);
	else
		out_str("get_data_x_scale found trGetN.iy missing");
//----------
		
	if(bOK && xyTemp.IsValid())
	{
		vector vx, vy;
		xyTemp.GetData(vy, vx);
			
		vx.GetMinMax(xmin, xmax);

		return true;
	}
	return false;
}

bool get_data_xy_scale(const TreeNode& trGetN, double& xmin, double& ymin, double& xmax, double& ymax)
{
	MatrixObject mi;
	bool bOK = okxf_resolve_string_get_origin_object(trGetN.mi.strVal, &mi);
		
	if(bOK && mi.IsValid())
	{
		mi.GetXY(xmin, ymin, xmax, ymax);

		return true;
	}
	return false;
}

bool update_xminmax_show(TreeNode& trGetN)
{
	TreeNode trxmin = trGetN.xmin;
	TreeNode trxmax = trGetN.xmax;
	bool bAutoXmin = octree_get_auto_support(&trxmin)==1?true:false;
	bool bAutoXmax = octree_get_auto_support(&trxmax)==1?true:false;

	//----------- CPY 4/11/07 QA70-9562 BETTER_NOT_ASSUME_YI_AS_INPUT_DATA_NODE
	//double dxMin, dxMax
	double dxMin = 0.1, dxMax = 4.9;// some special value to indicate we dont have the yi node and also I can use these for my QA70-9562 testing
	bool bRet = true;
	//-----------
	if(bAutoXmin || bAutoXmax)
	{
		if(!get_data_x_scale(trGetN, dxMin, dxMax))
			bRet = false;
		if(bAutoXmin)
			trGetN.xmin.dVal = dxMin;
		if(bAutoXmax)
			trGetN.xmax.dVal = dxMax;
	}
	
	update_dataformat_start_end_interval(trGetN.iy, trGetN, "xmin", "xmax");	///------ Folger 02/09/09 QA80-12786 DATE_TIME_FORMAT_SUPPORT_IN_XF_GETN
	
	return bRet;
}

bool update_xyminmax_show(TreeNode& trGetN)
{
	TreeNode trxmin = trGetN.xmin;
	TreeNode trymin = trGetN.ymin;	
	TreeNode trxmax = trGetN.xmax;
	TreeNode trymax = trGetN.ymax;
	bool bAutoXmin = octree_get_auto_support(&trxmin)==1?true:false;
	bool bAutoYmin = octree_get_auto_support(&trymin)==1?true:false;
	bool bAutoXmax = octree_get_auto_support(&trxmax)==1?true:false;
	bool bAutoYmax = octree_get_auto_support(&trymax)==1?true:false;	

	double dxMin, dyMin, dxMax, dyMax;
	if(bAutoXmin || bAutoYmin || bAutoXmax || bAutoYmax)
	{
		if(get_data_xy_scale(trGetN, dxMin, dyMin, dxMax, dyMax))
		{
			if(bAutoXmin)
				trGetN.xmin.dVal = dxMin;
			if(bAutoYmin)
				trGetN.ymin.dVal = dyMin;
			if(bAutoXmax)
				trGetN.xmax.dVal = dxMax;
			if(bAutoYmax)
				trGetN.ymax.dVal = dyMax;
		}
		else 
			return false;
	}
	return true;
}
///

///------ Folger 03/12/09 QA80-13261 AUTO_SUPPORT_FOR_NUMBER_OF_POINTS_IN_INTERPOLATE_TOOLS
bool update_interp_number_points(TreeNode& trNpts, TreeNode& trInput)
{
	if ( octree_get_auto_support(&trNpts) == 1 )
	{
		int	nSize = get_input_xyrange_data_size(trInput);
		if ( nSize < 0 )
			return false;
		
		trNpts.nVal = min(nSize * 5, 1000);
	}
		
	return true;
}
///------ End AUTO_SUPPORT_FOR_NUMBER_OF_POINTS_IN_INTERPOLATE_TOOLS

bool check_min_max(const double dMin, const double dMax)
{
	if (dMin >= dMax)
		return false;
	
	return true;
}


///Kyle 01/07/2011 ORG-1940 FREQ_COUNT_SUPPORT_SPECIFY_BY_INTERVALS
static double _round_in_range(double dLeft, double dRight)
{
	if( dLeft > dRight )
		return NANUM;

	if( dLeft == dRight )		// no rounding
		return dLeft;
	if(dLeft <= 0 && dRight >= 0 )
	{
		double dVal = 0.5 * (dLeft + dRight);

		int nVal = nint(dVal);
		if( nVal != 0 )			// should be a integer
			return nVal;
		return round(dVal, 1);	// 0.X
	}

	bool bReverse = false;
	if( dLeft < 0 )
	{
		double dTemp = fabs(dLeft);
		dLeft = fabs(dRight);
		dRight = dTemp;
		
		bReverse = true;
	}
	double dMidd = 0.5 * (dLeft + dRight);

	int nDig = (int)floor(log10(dRight - dLeft));
	double dPow = pow(10, -nDig);

	dLeft *= dPow;
	dRight *= dPow;
	ASSERT( dLeft < dRight );
	///Sophy 5/28/2012 ORG-5807-P1 OC_ROUND_DOUBLE_TO_INTEGER_OVERFLOW
	//int nX2 = dRight;
	double dX2 = floor(dRight);
	///end OC_ROUND_DOUBLE_TO_INTEGER_OVERFLOW
	while( true )
	{
		double dX1 = dLeft / 10;
		///Sophy 5/28/2012 ORG-5807-P1 OC_ROUND_DOUBLE_TO_INTEGER_OVERFLOW
		//nX2 = dRight/10;
		dX2 = floor(dRight / 10);
		///end OC_ROUND_DOUBLE_TO_INTEGER_OVERFLOW

		if( dX1 > dX2 )
			break;

		dLeft = dX1;
		///Sophy 5/28/2012 ORG-5807-P1 OC_ROUND_DOUBLE_TO_INTEGER_OVERFLOW
		//dRight = nX2;
		dRight = dX2;
		///end OC_ROUND_DOUBLE_TO_INTEGER_OVERFLOW
		dPow *= 0.1;
	}
	///Sophy 5/28/2012 ORG-5807-P1 OC_ROUND_DOUBLE_TO_INTEGER_OVERFLOW
	//int nLeft = ((int)ceil(dLeft)) % 10;
	//int nRight = dRight - 10 * nX2;
	double dLeftMargin = rmod(ceil(dLeft), 10);
	double dRightMargin = dRight - 10 * dX2;
	///end OC_ROUND_DOUBLE_TO_INTEGER_OVERFLOW
	ASSERT(dLeftMargin <= dRightMargin);

	///Sophy 5/28/2012 ORG-5807-P1 OC_ROUND_DOUBLE_TO_INTEGER_OVERFLOW
	//double dVal = ((nLeft + nRight) / 2 + nX2 * 10) / dPow;
	//if( (nLeft + nRight) & 1 )
	double dTemp = dLeftMargin + dRightMargin;
	double dVal = (floor(dTemp / 2) + dX2 * 10) / dPow;
	if ( rmod(dTemp, 2) == 1 )
	///end OC_ROUND_DOUBLE_TO_INTEGER_OVERFLOW
	{
		///Sophy 5/28/2012 ORG-5807-P1 OC_ROUND_DOUBLE_TO_INTEGER_OVERFLOW
		//double dVal2 = ((nLeft + nRight + 1)/2 + dX2 * 10) / dPow;
		double dVal2 = ((dTemp + 1)/2 + dX2 * 10) / dPow;
		///end OC_ROUND_DOUBLE_TO_INTEGER_OVERFLOW
		if( fabs(dVal2 - dMidd) < fabs(dVal - dMidd) )
			dVal = dVal2;
	}

	return bReverse ? - dVal : dVal;
}

int oc_round_range(double& dMin, double& dMax, double& dInc, int nSteps)
{
	bool bReverse = false;

	if( dMin == dMax )
	{
		if( dMin == 0.0)
		{
			dMin = -1;
			dMax = +1;
		}
		else
		{
			dInc = 0.1*abs(dMin);
			dMin -= dInc;
			dMax += dInc;
		}
	}
	else if( dMin > dMax )
	{
		bReverse = true;
	}

	if (nSteps <= 0)
		nSteps = 8;

	dInc = abs((dMax - dMin)/nSteps);

	double exponent;
	exponent = (int) floor(log(dInc)/log(10));
	dInc *= pow(10., -exponent);
	dInc = ceil(dInc);
	dInc *= pow(10., exponent);

	double dMaxRound = dInc * nSteps - fabs(dMax - dMin);
	ASSERT(dMaxRound >= 0);

	if( bReverse )
	{
		dInc = -dInc;
		dMin = _round_in_range(dMin, dMin + dMaxRound);
	}
	else
	{
		dMin = _round_in_range(dMin - dMaxRound, dMin);
	}
	dMax = dMin + nSteps * dInc;

	return (dMax - dMin) / dInc;
}
///End FREQ_COUNT_SUPPORT_SPECIFY_BY_INTERVALS

///Kyle 03/12/2009 QA80-13251 ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
//void set_round_limits(const vector& vData, TreeNode& trMin, TreeNode& trMax, TreeNode& trInc, TreeNode& trInterval, int nType)
void set_round_limits(const vector& vData, TreeNode& trMin, TreeNode& trMax, TreeNode& trInc, TreeNode& trInterval, int nType, bool bByBinCenter)
///End ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
{
	//if ( 0 != vData.GetSize() )		///Kyle 05/11/2011 ORG-2704-S1 FREQ_COUNT_ALLOW_ONE_OR_NO_DATA
	{
		double 	dMin, dMax, dInc;
		///Kyle 05/11/2011 ORG-2704-S1 FREQ_COUNT_ALLOW_ONE_OR_NO_DATA
		//vData.GetMinMax(dMin, dMax);
		int nSize = vData.GetSize();
		if( 0 == nSize || 0 == vData.GetMinMax(dMin, dMax) )
		{
			nSize = 10;
			dMin = 1;
			dMax = 10;
		}
		///End FREQ_COUNT_ALLOW_ONE_OR_NO_DATA
		///Echo 8/8/07 QA-9897 v8.0677 FREQ_COUNT_TO_BE_CONSISTANT_WITH_HISTOGRAM
		///Kyle 02/20/2009 QA80-13149 FREQUENCY_COUNT_SHOULD_UPDATE_MIN_MAX_ACCORDING_TO_INCREMENT_CHANGES
		//int nSpace;
		//bool bRoundToMinorTick;
		//RoundBinningRange(&dMin, &dMax, vData.GetSize(), nSpace, &dInc, bRoundToMinorTick);
		//int nSteps = (int)((dMax - dMin)/dInc);
		if(trMin && 1 != octree_get_auto_support(&trMin))
			///Kyle 03/12/2009 QA80-13251 ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
			//dMin = trMin.dVal;
			dMin = trMin.dVal - (bByBinCenter ? trInc.dVal / 2 : 0);
			///End ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
		if(trMax && 1 != octree_get_auto_support(&trMax))
			///Kyle 03/12/2009 QA80-13251 ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
			//dMax = trMax.dVal;
			dMax = trMax.dVal + (bByBinCenter ? trInc.dVal / 2 : 0);
			///End ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
		DWORD dwSpecify = 0;		///Kyle 03/03/2009 QA80-13149 RoundBinningRange_SUPPORT_SPECIFYING_INCREMENT
		int nSteps;
		///Kyle 01/07/2011 ORG-1940 FREQ_COUNT_SUPPORT_SPECIFY_BY_INTERVALS
		/*
		if( nType == 0 && trInc && 1 != octree_get_auto_support(&trInc) ||
			nType == 1 && trInterval && 1 != octree_get_auto_support(&trInterval))
		{
			if(nType == 0)
			{
				dInc = trInc.dVal;
				nSteps = 0;
				dwSpecify = RBR_SPECIFY_WIDTH;		///Kyle 03/03/2009 QA80-13149 RoundBinningRange_SUPPORT_SPECIFYING_INCREMENT
			}
			else
			{
				dInc = trInc.dVal;
				nSteps = trInterval.dVal;
			}
			///Kyle 03/03/2009 QA80-13149 RoundBinningRange_SUPPORT_SPECIFYING_INCREMENT
			//RoundLimits(&dMin, &dMax, &dInc, nSteps);
			//if(nType == 0)
				//nSteps = (int)((dMax - dMin)/dInc);
			///End RoundBinningRange_SUPPORT_SPECIFYING_INCREMENT
		}
		///Kyle 03/03/2009 QA80-13149 RoundBinningRange_SUPPORT_SPECIFYING_INCREMENT
		//else
		//{
			//RoundBinningRange(&dMin, &dMax, vData.GetSize(), 0, &dInc, false);
			//nSteps = (int)((dMax - dMin)/dInc);
		//}
		RoundBinningRange(&dMin, &dMax, vData.GetSize(), LINEAR_SPACE, &dInc, dwSpecify);
		nSteps = (int)((dMax - dMin)/dInc);
		*/
		if( nType == 1 && trInterval && 1 != octree_get_auto_support(&trInterval) )
		{
			nSteps = trInterval.nVal;
			oc_round_range(dMin, dMax, dInc, nSteps);
		}
		else
		{
			if( nType == 0 && trInc && 1 != octree_get_auto_support(&trInc) )
			{
				dInc = trInc.dVal;
				nSteps = 0;
				dwSpecify = RBR_SPECIFY_WIDTH;
			}

			///Kyle 05/11/2011 ORG-2704-S1 FREQ_COUNT_ALLOW_ONE_OR_NO_DATA
			//RoundBinningRange(&dMin, &dMax, vData.GetSize(), LINEAR_SPACE, &dInc, dwSpecify);
			RoundBinningRange(&dMin, &dMax, nSize, LINEAR_SPACE, &dInc, dwSpecify);
			///End FREQ_COUNT_ALLOW_ONE_OR_NO_DATA
			nSteps = (int)((dMax - dMin)/dInc);
		}
		///End FREQ_COUNT_SUPPORT_SPECIFY_BY_INTERVALS
		///End RoundBinningRange_SUPPORT_SPECIFYING_INCREMENT
		///End FREQUENCY_COUNT_SHOULD_UPDATE_MIN_MAX_ACCORDING_TO_INCREMENT_CHANGES
		/*
		double dDataMax = dMax;
		int	nSteps = RoundLimits(&dMin, &dMax, &dInc);
		if(dMax == dDataMax)             // If true max==rounded max go up one more bin to include true max
			dMax += dInc;	
		*/	
		///end FREQ_COUNT_TO_BE_CONSISTANT_WITH_HISTOGRAM

		if (trMin && 1==octree_get_auto_support(&trMin))
		{
			///Kyle 03/12/2009 QA80-13251 ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
			//trMin.dVal = dMin;
			trMin.dVal = dMin + (bByBinCenter ? dInc / 2 : 0);
			///End ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
		}
		if (trMax && 1==octree_get_auto_support(&trMax))
		{
			///Kyle 03/12/2009 QA80-13251 ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
			//trMax.dVal = dMax;
			trMax.dVal = dMax - (bByBinCenter ? dInc / 2 : 0);
			///End ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
		}
		if (trInc && 1==octree_get_auto_support(&trInc)&&(nType==0||nType==2))
		{
			trInc.dVal = dInc;
		}
		if (trInterval && 1==octree_get_auto_support(&trInterval)&&(nType==1||nType==2))
		{
			trInterval.dVal = (double)nSteps;
		}
	}
}

void get_min_max(const vector& vData,TreeNode& trMin, TreeNode& trMax)
{
	if ( 0 != vData.GetSize() )
	{
		double 	dMin, dMax, dInc;
		vData.GetMinMax(dMin, dMax);
		
		if (trMin && 1==octree_get_auto_support(&trMin))
		{
			trMin.dVal = dMin;
		}
		if (trMax && 1==octree_get_auto_support(&trMax))
		{
			trMax.dVal = dMax;
		}
		
	}	
}

///Kyle 03/12/2009 QA80-13251 ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
//void freq_update_inc(const double dMin, const double dMax, const int nStepBy, const int nOutLeft, const int nOutRight, TreeNode& trInc, TreeNode& trIntervals)
void freq_update_inc(const double dMin, const double dMax, const int nStepBy, const int nOutLeft, const int nOutRight, TreeNode& trInc, TreeNode& trIntervals, bool bByBinCenter)
///End ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
{
	if (0 == nStepBy)
	{
		//if (PDS_UNASSIGNED != get_variable_type(trGetN.Intervals) )
		//---- CPY 4/21/07 SET_AUTO_SHOULD_USE_DEFAULT
		//octree_set_auto_support(&trIntervals, PDS_UNASSIGNED);
		///Kyle 02/20/2009 QA80-13149 TEMPORARY_HIDE_INTERVALS_SINCE_ROUND_LIMITS_DOES_NOT_SUPPORT_FIXED_STEPS
		//octree_set_auto_support(&trIntervals);
		///End TEMPORARY_HIDE_INTERVALS_SINCE_ROUND_LIMITS_DOES_NOT_SUPPORT_FIXED_STEPS
		//----
		trIntervals.Enable = false;
		trInc.Enable = true;
		///Kyle 12/12/2008 NUMBER_OF_INTERVALS_NOT_INCLUDE_OUTLEFT_AND_OUTRIGHT
		//trIntervals.dVal = ceil((dMax - dMin) / trInc.dVal) + nOutLeft + nOutRight;
		///Kyle 03/12/2009 QA80-13251 ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
		//trIntervals.dVal = ceil((dMax - dMin) / trInc.dVal);
		///Kyle 03/25/2009 QA80-13251-P4 SKIP_OR_EXTEND_THE_LAST_BIN_IF_IT_IS_NOT_A_FULL_BIN
		//trIntervals.dVal = ceil((dMax - dMin) / trInc.dVal) + (bByBinCenter ? 1 : 0);			// if min, max are bin centers, should plus one here
		if(trInc.dVal <= 0 || dMax < dMin)
			return;
		trIntervals.dVal = (int)((dMax - dMin) / trInc.dVal + 0.5) + (bByBinCenter ? 1 : 0);
		///End SKIP_OR_EXTEND_THE_LAST_BIN_IF_IT_IS_NOT_A_FULL_BIN
		///End ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
		///End NUMBER_OF_INTERVALS_NOT_INCLUDE_OUTLEFT_AND_OUTRIGHT
	}else
	{
		//if (PDS_UNASSIGNED != get_variable_type(trGetN.Inc) )
		//---- CPY 4/21/07 SET_AUTO_SHOULD_USE_DEFAULT
		//octree_set_auto_support(&trInc, PDS_UNASSIGNED);
		///Kyle 01/07/2011 ORG-1940 FREQ_COUNT_SUPPORT_SPECIFY_BY_INTERVALS, per Max, should keep the auto setting here
		//octree_set_auto_support(&trInc);
		///End FREQ_COUNT_SUPPORT_SPECIFY_BY_INTERVALS
		//----
		trInc.Enable = false;
		trIntervals.Enable = true;
		///Kyle 12/12/2008 NUMBER_OF_INTERVALS_NOT_INCLUDE_OUTLEFT_AND_OUTRIGHT
		//trInc.dVal = (dMax - dMin) / (trIntervals.dVal - nOutLeft - nOutRight);
		///Kyle 03/12/2009 QA80-13251 ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
		//trInc.dVal = (dMax - dMin) / trIntervals.dVal;
		trInc.dVal = (dMax - dMin) / (trIntervals.dVal - (bByBinCenter ? 1 : 0));				// if min, max are bin centers, one bin is exclude
		///End ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
		///End NUMBER_OF_INTERVALS_NOT_INCLUDE_OUTLEFT_AND_OUTRIGHT
	}
}

void freq_update_inc(TreeNode& trGetN)
{
	if ( !trGetN )
		return;
	
	///Kyle 03/12/2009 QA80-13251 ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
	//freq_update_inc(trGetN.Min.dVal, trGetN.Max.dVal, trGetN.StepBy.nVal, trGetN.OutLeft.nVal, trGetN.OutRight.nVal, trGetN.Inc, trGetN.Intervals);
	freq_update_inc(trGetN.Min.dVal, trGetN.Max.dVal, trGetN.StepBy.nVal, trGetN.OutLeft.nVal, trGetN.OutRight.nVal, trGetN.Inc, trGetN.Intervals, trGetN.bin.nVal == 0);
	///End ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
	//if (0 == trGetN.StepBy.nVal)
	//{
		////if (PDS_UNASSIGNED != get_variable_type(trGetN.Intervals) ) 
		//TreeNode trIntervals = trGetN.Intervals;
		//octree_set_auto_support(&trIntervals, true);
		//trGetN.Intervals.Enable = false;
		//trGetN.Inc.Enable = true;
		//trGetN.Intervals.dVal = ceil((trGetN.Max.dVal - trGetN.Min.dVal) / trGetN.Inc.dVal) + trGetN.OutLeft.nVal + trGetN.OutRight.nVal;
	//}else
	//{
		////if (PDS_UNASSIGNED != get_variable_type(trGetN.Inc) ) 
		//TreeNode trInc = trGetN.Inc;
		//octree_set_auto_support(&trInc, true);		
		//trGetN.Inc.Enable = false;
		//trGetN.Intervals.Enable = true;
		//trGetN.Inc.dVal = (trGetN.Max.dVal - trGetN.Min.dVal) / (trGetN.Intervals.dVal - trGetN.OutLeft.nVal - trGetN.OutRight.nVal);
	//}
}

bool check_intervals(const double dIntervals)
{
	if (dIntervals <=0 || 0 != (dIntervals - (int)dIntervals))
		return false;
	
	return true;
}

bool check_intervals(TreeNode& trIntervals)
{
	if (!trIntervals)
		return false;
	
	double dIntervals = trIntervals.dVal;
	return check_intervals(dIntervals);
}

bool check_step_size(const double dInc, const double dMin, const double dMax)
{
	if ( dInc <= 0 || dInc >= (dMax - dMin) / 2)
		return false;

	return true;
	
}
bool check_step_size(TreeNode& tr)
{
	if (!tr)
		return false;
	
	return check_step_size(tr.Inc.dVal, tr.Min.dVal, tr.Max.dVal);
	
}

int check_numeric_matrix(string& strMSheet)
{
	MatrixLayer mlay;
	bool bOKEnable = okxf_resolve_string_get_origin_object(strMSheet, &mlay);
	if (bOKEnable && mlay.IsValid() )
	{
		if ( is_sheet_empty(mlay) )
			return CER_NO_DATA;
		if ( has_image(mlay) )
			return CER_INPUT_IMG;
		
		return CER_NO_ERROR;
	}
	return CER_NO_DATA
}

///justin 11/03/2006
/**$
*/
static int _get_error_of_data_by_comparing_size(int nDataSize, int nMissValue, bool bPermitMissValue = false, int nPermitMinSize = -1, int nPermitMaxSize = -1)
{
	if(nDataSize == 0)
		return CER_NO_DATA;
	
	if(nMissValue == nDataSize)
		return CER_ALL_IS_MISSING_VALUE;
	
	if( !bPermitMissValue && nMissValue >0)
		return CER_HAS_MISSING_VALUE;
	
	if(nPermitMinSize != -1 && nDataSize < nPermitMinSize)
		return CER_DATA_TOO_FEW;
	
	if(nPermitMaxSize != -1 && nDataSize > nPermitMaxSize)
		return CER_DATA_TOO_MANY;
	
	return CER_NO_ERROR;	
}
int check_input_double_vector(const TreeNode& trInput, int nNeedMinimumSize, bool bPermitMissValue, vector<double>& vdData)
{
	vector vx1;
	if(trInput) 
	{
		if(okxf_resolve_tree_get_data_into_vector(&trInput, &vx1))
		{
			int nSize = vx1.GetSize();
			int nMissing = ocmath_count(NANUM, nSize, vx1);
			///justin 11/15/2006 RETURN_MORE_ERROR
			//if(nSize >= nNeedMinimumSize && nSize > nMsVlue && (bPermitMissValue || nMsVlue == 0) )
			//{
				//if(vdData)
					//vdData = vx1;
				//return OE_NOERROR; 
			//} 
			//return CER_INVALID_DATA;
			int nRet = _get_error_of_data_by_comparing_size(nSize, nMissing, bPermitMissValue, nNeedMinimumSize);
			if(nRet == CER_NO_ERROR && vdData)
				vdData = vx1;
			return nRet;
			///end RETURN_MORE_ERROR

		}
		return CER_FFT_GET_INPUT_FAIL; //return XFERR_GET_DATA_FAILED; ///justin 11/20/2006 
	}
	return CER_INVALID_TREENODE;	
}
int check_input_complex_vector(const TreeNode& trInput, int nNeedMinimumSize, bool bPermitMissValue, vector<complex>& vData)
{
	vector<complex> vx1;
	if(trInput)
	{
		if(okxf_resolve_tree_get_data_into_vector(&trInput, &vx1))
		{
			///justin 11/06/2006 CHECK_MISSING_VALUE
			vector vRe, vIm;
			int nSize = vx1.GetSize();
			vx1.GetImaginary(vIm);
			vx1.GetReal(vRe);
			int nMissing = ocmath_count(NANUM, nSize, vRe);
			nMissing = max(ocmath_count(NANUM, nSize, vIm), nMissing); //nMsVlue = max(ocmath_count(NANUM, nSize, vRe), nMsVlue); ///justin 11/10/2006 
			///end CHECK_MISSING_VALUE
			///jusitn 11/15/2006 RETURN_MORE_ERRORS
			//if(nSize >= nNeedMinimumSize && nSize > nMsVlue && (bPermitMissValue || nMsVlue == 0) )
			//{
				//if(vData)
					//vData = vx1;
				//return OE_NOERROR; 
			//} 
			//return CER_INVALID_DATA;
			int nRet = _get_error_of_data_by_comparing_size(nSize, nMissing, bPermitMissValue, nNeedMinimumSize);
			if(nRet == CER_NO_ERROR && vData)
				vData = vx1;
			return nRet;
		}
		return CER_FFT_GET_INPUT_FAIL; //return XFERR_GET_DATA_FAILED; ///justin 11/20/2006 
	}
	return CER_INVALID_TREENODE;	
}

bool get_error_for_input_complex_vector(const TreeNode& trX, string& strErrMsg)
{
	/// Max 11/25/06 CORRECT_STRERRMSG_USAGE
	/*
	int nRet = check_input_complex_vector(trX);
	string strErrNodeLabel;
	if(nRet)
	{
		trX.GetAttribute("Label", strErrNodeLabel);
		strErrMsg = nRet;
		strErrMsg += ": ";
		strErrMsg += strErrNodeLabel;
		return false;
	}
	*/
	int nRet = check_input_complex_vector(trX);
	if(nRet)
	{
		strErrMsg = nRet;
		return false;
	}
	/// END CORRECT_STRERRMSG_USAGE
	return true;
}
bool get_error_for_input_double_vector(const TreeNode& trX, string& strErrMsg)
{
	/// Max 11/25/06 CORRECT_STRERRMSG_USAGE
	/*
	int nRet = check_input_double_vector(trX);
	string strErrNodeLabel;
	if(nRet)
	{
		trX.GetAttribute("Label", strErrNodeLabel);
		strErrMsg = nRet;
		strErrMsg += ": ";
		strErrMsg += strErrNodeLabel;
		return false;
	}
	*/
	int nRet = check_input_double_vector(trX);
	if(nRet)
	{
		strErrMsg = nRet;
		return false;
	}
	/// END CORRECT_STRERRMSG_USAGE
	return true;
}

///justin 11/03/2006 UPDATE_ERROR_MESSAGE
bool get_error_for_2_input_double_vector(const TreeNode& trX, const TreeNode& trH, string& strErrMsg)
{
	bool bOk = get_error_for_input_double_vector(trX, strErrMsg);
	if(bOk)
		bOk = get_error_for_input_double_vector(trH, strErrMsg); 
	return bOk;
}
///end UPDATE_ERROR_MESSAGE


//end 

///Justin 2007-3-22 v8.0587 CHECK_USER_INPUTED_INTERVAL
/**$
*/
///Justin 2007-3-23 v8.0588 MOVE_BACK_FFTUTILIS_BECAUSE_COMPILE_ERROR
/*
int auto_compute_sampling_interval_from_InputData(const TreeNode& trInput, TreeNode& trInterval)
{
	if(trInput == NULL || trInterval == NULL)
		return CER_INVALID_TREENODE;

	double dInterval = 1.0;
	int nRet = OE_NOERROR;
	
	if( 1 == octree_get_auto_support(&trInterval) )
	{
		nRet = get_fft_interval_by_x_input(trInput, &dInterval);
		if( dInterval <= 0 || dInterval == NANUM)
		{
			dInterval = 1; 
			nRet = FFT_AUTO_INTERVAL_NOT_SUITABLE; //nRet = CER_INVALID_SIGNAL_INTERVAL;
		}
		else if(nRet == OE_NOT_SPACED_EQUALLY)
			nRet = CER_FFT_UNEVENLY_SPACE;
	
		trInterval.dVal = dInterval;
	}
	
	return nRet;	
}
*/
///END  MOVE_BACK_FFTUTILIS_BECAUSE_COMPILE_ERROR
int check_interval(TreeNode& trInterval, bool bFailToSetOne) // = false
{
	if(1 == octree_get_auto_support(&trInterval))
		return OE_NOERROR;
	if(0 >= trInterval.dVal || NANUM == trInterval.dVal)
	{
		if(bFailToSetOne)
			trInterval.dVal = 1.0;
		return CER_INVALID_SIGNAL_INTERVAL;
	}
}
///end CHECK_USER_INPUTED_INTERVAL

//---- CPY 6/2/2007 QA70-9827 SUBTRACT_LINE_FROM_PLOT
// return 0 if no error
int get_graph_input_xyrange(const TreeNode& trXY, DataPlot& dp, XYRange& xy)
{
	if(!trXY.IsValid() || !okxf_resolve_tree_construct_range(&trXY, &xy) || !xy.IsValid())
		return CER_INVALID_XYRANGE;
	
	vector<uint> vn;
	xy.GetPlots(vn);
	if(vn.GetSize() > 0)
		dp = Project.GetObject(vn[0]);
	
	return 0;
}
//----
	
///Sandy 11/06/2006
/**$
*/

//bool get_error_for_input_xyrange(const TreeNode& trXY, string& strErrMsg,  int& nSize, XYRange& xy ) //---CPY 5/6/09 QA70-13568 STATCK_PLOT_FAILED_FOR_X_COL_OF_ALL_TEXT, added bAllowMissing
bool get_error_for_input_xyrange(const TreeNode& trXY, string& strErrMsg,  int& nSize, XYRange& xy, bool bAllowMissing )
{

	if(!trXY.IsValid()|| !okxf_resolve_tree_construct_range(&trXY, &xy))
	{
		strErrMsg = CER_INVALID_XYRANGE; //strErrMsg = CER_INVALID_TREENODE; ///justin
		return false;
	}
	vector vx, vy;
	//---CPY 5/6/09 QA70-13568 STATCK_PLOT_FAILED_FOR_X_COL_OF_ALL_TEXT
	//if(!xy.GetData(vy, vx) || vy.GetSize() < 1)
	DWORD dwRule = DRR_BAD_WEIGHT_TREATMENT;
	if(bAllowMissing) dwRule |= DRR_GET_MISSING;
	if(!xy.GetData(vy, vx, NULL, 0, dwRule) || vy.GetSize() < 1)
	//---
	{
		strErrMsg = XFERR_GET_DATA_FAILED;	
		return false;
	}
	
	nSize = vy.GetSize();
	return true;
}


//---- CPY 12/12/06
// return false if trXY is not valid
bool get_output_xyrange_err_info(const TreeNode& trXY, string& strErrMsg, XYRange& xy )
{
	//int nType = get_variable_type(trXY); //zachary 12/13/06 this function does not support a XYRange treenode type,   
	int nType = get_xyrange_type(trXY);
	XYRange* pXY;
	XYRange xyLocal;
	if(NULL == xy)
		pXY = &xyLocal;
	else
		pXY = & xy;
	
	if(PDS_UNASSIGNED == nType || PDS_OPTIONAL == nType || !okxf_resolve_tree_construct_range(&trXY, pXY))
	{
		strErrMsg = CER_INVALID_XYRANGE;
		return false;
	}
	return true;
}
//-----------------


/// zachary 12/13/06 GET_SINGLE_XYRANGE_TYPE
int get_xyrange_type(TreeNode& trXYRange)
{
	if( !trXYRange.IsValid() ) 
		return PDS_INVALID;
	
	if( is_optional_by_dyna_use_checkbox(trXYRange) )
		return PDS_OPTIONAL;
	
	XYRange xy;
	bool bConstructed = okxf_resolve_tree_construct_range(&trXYRange, &xy);
	if(!bConstructed)
	{
		TreeNode trX = tree_get_node_by_tagname(trXYRange, "X", true);
		TreeNode trY = tree_get_node_by_tagname(trXYRange, "Y", true);
		if( !trX.IsValid() || !trY.IsValid() )
			return PDS_INVALID;
		int nXType = get_variable_type(trX);
		int nYType = get_variable_type(trY);

		if(nXType == nYType)
			return nXType;		
		return PDS_INVALID;
	}
	return PDS_USER;
}
///End GET_SINGLE_XYRANGE_TYPE

/// YuI 12/17/06
BOOL	is_optional_by_dyna_use_checkbox(TreeNode& tr)
{
	int nCheck = 1;
	if( tr.IsValid() && tr.GetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nCheck) && 0 == nCheck )
		return TRUE;
	
	return FALSE;
}
/// end YuI
///---Sim 2011-2-24 ORG-2294-S1 SUPPORT_OUTPUT_VIRTUAL_MATRIX
//BOOL 	has_dyna_use_checkbox(TreeNode& tr)
BOOL 	has_dyna_use_checkbox(TreeNode& tr, int *pnCheck)// = NULL)
///---END ORG-2294-S1 SUPPORT_OUTPUT_VIRTUAL_MATRIX
{
	int nCheck;
	if( tr.IsValid() && tr.GetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nCheck))
	{
		///---Sim 2011-2-24 ORG-2294-S1 SUPPORT_OUTPUT_VIRTUAL_MATRIX
		if ( pnCheck )
			*pnCheck = nCheck;
		///---END ORG-2294-S1 SUPPORT_OUTPUT_VIRTUAL_MATRIX
		return TRUE;
	}
	return FALSE;
}
///---Sim 2011-2-24 ORG-2294-S1 SUPPORT_OUTPUT_VIRTUAL_MATRIX
BOOL	set_dyna_use_checkbox(TreeNode& tr, int nCheck)
{
	if ( has_dyna_use_checkbox(tr) )
	{
		return tr.SetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nCheck)
	}
	
	return FALSE;
}
///---END ORG-2294-S1 SUPPORT_OUTPUT_VIRTUAL_MATRIX

///Echo 1/18/06 FIT_COMP
/*
int _is_comparable(const Worksheet& wks1, const Worksheet& wks2)
{
	vector<string> vsEquations;
	uint uid;
	Tree tr;
	for(int ii = 0; ii < 2; ii++)
	{
		if(ii)
			wks2.GetReportTree(tr, &uid);	
		else
			wks1.GetReportTree(tr, &uid);	
		TreeNode trNotes = tr.Notes;
		if(trNotes.IsValid() && trNotes.Equation)
			vsEquations.Add(trNotes.Equation.strVal);
	}
	if(2 == vsEquations.GetSize() && !vsEquations[0].CompareNoCase(vsEquations[1]))
		return SAME_MODEL;
	
	Tree		trGUI1, trGUI2;
	wks1.GetReportTree(trGUI1, &uid, 0, GRT_TYPE_GUI);	
	wks2.GetReportTree(trGUI2, &uid, 0, GRT_TYPE_GUI);	
	
	string		strInput1, strInput2;
	if( _get_input_data_str(trGUI1, trGUI2, strInput1, strInput2) )
	{
		if( !strInput1.IsEmpty() && !strInput2.IsEmpty() && 0 == strInput1.CompareNoCase(strInput2) )
			return SAME_DATA;
	}
	
	return 0;
}
*/
static bool _at_least_1_output(const TreeNode& trGetN)
{
	if (trGetN.ftest.nVal || trGetN.aic.nVal || trGetN.param.nVal || trGetN.statics.nVal)
		return true;
	else
		return false;
}

/// ML 2/27/2007 FITCOMPARISON_SHOULD_USE_RANGE_TYPES_FOR_INPUT_REPORTS_SO_THAT_AUTOUPDATE_WORKS
static	bool	fitcmp_get_rt(Worksheet &wks, Tree& trRes, Tree& trGUI)
{
	if(!wks)
		return false;	//fail to get report tree
	
	if(!wks.GetReportTree(trRes, NULL, 0, GRT_TYPE_RESULTS, TRUE))
		return false;	//fail to get report tree
	
	uint 	uid;
	if( !wks.GetReportTree(trGUI, &uid, 0, GRT_TYPE_GUI) )
		return false;	//fail to get GUI tree	
	
	return true;
}

bool fitcmp_get_rt(Range &rngRT, Tree& trRes, Tree& trGUI)
{
	Worksheet		wks;
	if ( !get_source_worksheet(rngRT, wks) )
		return false;
	
	return fitcmp_get_rt(wks, trRes, trGUI);
}

/// end FITCOMPARISON_SHOULD_USE_RANGE_TYPES_FOR_INPUT_REPORTS_SO_THAT_AUTOUPDATE_WORKS


bool fitcmp_get_rt(const string strRT, Tree& trRes, Tree& trGUI)
{
		
	Worksheet wks(strRT);
	if(!wks)
		return false;	//fail to get report tree
	
	/// ML 2/27/2007 FITCOMPARISON_SHOULD_USE_RANGE_TYPES_FOR_INPUT_REPORTS_SO_THAT_AUTOUPDATE_WORKS
	/*
	/// ML 2/15/2007 GETTING_REPORT_TREE_WITH_ESCAPED_STRINGS_TRANSLATION
	//if(!wks.GetReportTree(trRes))
	//	return false;	//fail to get report tree
	if(!wks.GetReportTree(trRes, NULL, 0, GRT_TYPE_RESULTS, TRUE))
		return false;	//fail to get report tree
	/// end GETTING_REPORT_TREE_WITH_ESCAPED_STRINGS_TRANSLATION
	
	uint 	uid;
	if( !wks.GetReportTree(trGUI, &uid, 0, GRT_TYPE_GUI) )
		return false;	//fail to get GUI tree	
	
	return true;
	*/
	return fitcmp_get_rt(wks, trRes, trGUI);
	/// end FITCOMPARISON_SHOULD_USE_RANGE_TYPES_FOR_INPUT_REPORTS_SO_THAT_AUTOUPDATE_WORKS
}

static int  _fitcmp_set_rt(TreeNode& trRes1, string strRes2, bool bSameModel)
{
	int nErr = bSameModel ? CER_FITCMP_DATA_INVALID_RT : CER_FITCMP_MODEL_INVALID_RT;
	trRes1.SetAttribute(STR_DATA_ATTRIB, 1);
	string strModel = (bSameModel) ? ":1" : ":2";
	if ( strRes2.IsEmpty() )
		strRes2 = "[None]";
	string strFilter = strRes2 + strModel;
	trRes1.SetAttribute(STR_FILTER_ATTRIB, strFilter);
	
	string strRes1 = trRes1.strVal;
	if (!strRes1.IsEmpty())
	{
		Tree trRes;
		Tree	trGUI;
		if (!fitcmp_get_rt(strRes1, trRes, trGUI))
			return nErr;
		else
			return CER_NO_ERROR;
	}
	
	return nErr;
}

int fitcmp_event(TreeNode trGetN, bool bSameModel)
{
	string stresult1 = trGetN.result1.strVal;
	string stresult2 = trGetN.result2.strVal;
	int nErr = _fitcmp_set_rt(trGetN.result1, stresult2, bSameModel);
	nErr |= _fitcmp_set_rt(trGetN.result2, stresult1, bSameModel);
	if (CER_NO_ERROR != nErr)
		return nErr;
		
	if (!bSameModel && !_at_least_1_output(trGetN))
	{
		return CER_SUPPRESS_ALL_OUTPUT;
	}
	
	///------ Folger 02/20/09 FITTING_COMPARE_SHOULD_CHECK_REQUESTED_OUTPUT_IN_RESOURCE_TREE
	if ( 0 != trGetN.statics.nVal || 0 != trGetN.param.nVal )
	{
		Tree trRes1, trRes2;
		Tree trGUI1, trGUI2;
		fitcmp_get_rt(stresult1, trRes1, trGUI1);
		fitcmp_get_rt(stresult2, trRes2, trGUI2);
		
		if ( 0 != trGetN.statics.nVal )
		{
			if ( !tree_get_node_by_tagname(trRes1, "RegStats", true) || !tree_get_node_by_tagname(trRes2, "RegStats", true) )
				return XFERR_FIT_COMPARE_FAILS_TO_OUTPUT;
		}
		
		if ( 0 != trGetN.param.nVal )
		{
			if ( !tree_get_node_by_tagname(trRes1, "Parameters", true) || !tree_get_node_by_tagname(trRes2, "Parameters", true) )
				return XFERR_FIT_COMPARE_FAILS_TO_OUTPUT;
		}
	}
	///------ End FITTING_COMPARE_SHOULD_CHECK_REQUESTED_OUTPUT_IN_RESOURCE_TREE
	
	return CER_NO_ERROR;
}

///Joseph 04/02/07 ADD_NLSF_ERR_MSG_EVENT
bool check_is_positive_integer(const TreeNode& trInterval)
{
	double dInterval = trInterval.dVal;

	if (dInterval <1 || 0 != (dInterval - (int)dInterval))
		return false;
	
	return true;
}

bool check_margin_value(const TreeNode& trMarginVal)
{
	double dMarginVal = trMarginVal.dVal;
	///Cheney 2007-7-26 MARGIN_COULD_GREATER_THAN_100_AS_MAX_SAID
	//if(dMarginVal < 0 || dMarginVal > 100)
	if(dMarginVal < 0. )
	///end MARGIN_COULD_GREATER_THAN_100_AS_MAX_SAID
		return false;
	
	return true;
}
///End ADD_NLSF_ERR_MSG_EVENT

///End FIND_BUILTIN_LABEL

/// Cloud 04/19/2007 ADD_INTERPOLATION_PREPROCESS
/*	/// no need
bool update_xvector_show(TreeNode& trGetN)
{
	vector vx;
	TreeNode trxi = trGetN.xi;
	if (okxf_resolve_tree_get_data_into_vector(&trxi, &vx))
	{
		if (vx.GetSize()>0)
			return true;
	}
	return false;
}
*/
///Kyle 11/25/2008 QA80-12051 GET_XYRANGE_DATA_BASE_ON_RULES
//int interpolation_preprocess(const vector& xi, const XYRange& yi, vector& vxIn, vector& vyIn, int& npts, vector& vyOut, int method, vector& vcof)
//------ Folger 11/27/08 QA80-12356 v8.0980 MORE_TOOLS_NEED_TO_HANDLE_INPUTS_WITH_MISSING_VALUE
//int interpolation_preprocess(const vector& xi, const XYRange& yi, vector& vxIn, vector& vyIn, int& npts, vector& vyOut, int method, vector& vcof, DWORD dwRules)
int interpolation_preprocess(const vector& xi, const XYRange& yi, vector& vxIn, vector& vyIn, int& npts, vector& vyOut, int method, vector& vcof, DWORD dwRules, vector<int> *pvnMissingValsIndices, bool bSortAndRemoveDuplicates
							 ///------ Folger 12/21/2011 ORG-4653-P1 AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
							 , BOOL bGetData/* = TRUE*/
							 ///------ End AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
							 )
//------
///End GET_XYRANGE_DATA_BASE_ON_RULES
{
	///------ Folger 12/21/2011 ORG-4653-P1 AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
	if ( bGetData )
	{
		///------ End AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
		///Kyle 11/25/2008 QA80-12051 GET_XYRANGE_DATA_BASE_ON_RULES
		//if(!yi.IsValid() || yi.GetNumData(DRR_GET_DEPENDENT) != 1 || !yi.GetData(vyIn, vxIn))
		//------ Folger 11/27/08 QA80-12356 v8.0980 MORE_TOOLS_NEED_TO_HANDLE_INPUTS_WITH_MISSING_VALUE
		//if(!yi.IsValid() || yi.GetNumData(DRR_GET_DEPENDENT) != 1 || !yi.GetData(vyIn, vxIn, NULL, 0, dwRules))
		if(!yi.IsValid() || yi.GetNumData(DRR_GET_DEPENDENT) != 1 || !yi.GetData(vyIn, vxIn, NULL, 0, dwRules, pvnMissingValsIndices))
		//------
		///End GET_XYRANGE_DATA_BASE_ON_RULES
			XF_THROW(CER_NOT_ONE_XYRANGE)
		if(!xi)
			XF_THROW(CER_FFT_GET_INPUT_FAIL);
	}

	int nSize;
	if((nSize=vyIn.GetSize()) <= 0)
		XF_THROW(CER_NO_DATA);

	npts = xi.GetSize();
	vyOut.SetSize(npts);

	//	REMOVE_XY_DUPLICATES_BEFORE_INTERPOLATION
	///------ Folger 12/26/08 QA80-12856 v8.0991 IMRPOVE_ocmath_xy_remove_duplicates
	//ocmath_xy_remove_duplicates(&nSize, vxIn, vyIn);
	if( bSortAndRemoveDuplicates )
		nSize = ocmath_xy_remove_duplicates(vxIn, vyIn, nSize);
	///------ End IMRPOVE_ocmath_xy_remove_duplicates

	int nMinPoints;
	switch(method)
	{
	case 0:
		nMinPoints = MIN_LINEAR_PTS;
		break;
	case 1:
		nMinPoints = MIN_SPLINE_PTS;
		break;
	case 2:
		nMinPoints = MIN_BSPLINE_PTS;
		break;
	default:
		break;
	}
	if (nSize<nMinPoints)
		XF_THROW(XFERR_UNDUPLICATED_DATA_TOO_FEW);


	vxIn.SetSize(nSize);
	vyIn.SetSize(nSize);

	if (vcof!=NULL)
		vcof.SetSize(nSize);
	
	return nSize;
}
/// End ADD_INTERPOLATION_PREPROCESS


//----Jake 05/10/07 ADD_GET_NUMBER_FROM_STRING
static void _trim_string(string& strString)
{
	int ii = 0;
	while(ii < strString.GetLength())
	{
		if(strString.GetAt(ii)==' ' || strString.GetAt(ii)==',' || strString.GetAt(ii)==':')
		{
			int jj = ii+1;
			while(jj<strString.GetLength() && strString.GetAt(jj)==strString.GetAt(ii)) jj++;
			strString.Delete(ii+1, jj-ii-1);
		}
		
		ii++;		
	}
}

static  bool _is_numeric_char(char ch)
{
	return (ch >= '0' && ch <= '9');
}


static bool _is_linker_for_index_range_string(char ch)
{
	return (ch==' ' || ch==',' || ch==':');
}

//bool is_right_string_format(const string& strString)///Jake 06/12/07 v8.0639b CHANGE_GLOBAL_FUNCTION_NAME
bool is_correct_origin_object_index_range(const string& strString)
{
	if(strString.IsEmpty())
		return false;
	
	_trim_string(strString);
	
	///Jake 06/07/07 v8.0635 DEBUG_FOR_STRING_CHECKING
	/*
	for(int ii = 0; ii < strString.GetLength()-1; ii++)
	{
		if(strString.GetAt(ii)<'0' && strString.GetAt(ii)>'9' && strString.GetAt(ii)!=' ' 
			&& strString.GetAt(ii)!=',' && strString.GetAt(ii)!=':')
			return false;

		if( (strString.GetAt(ii)==' ' || strString.GetAt(ii)==',' || strString.GetAt(ii)==':') 
			&&(strString.GetAt(ii+1)==' ' || strString.GetAt(ii+1)==',' || strString.GetAt(ii+1)==':'))
			
			return false;
	}
	
	if(strString.GetAt(ii)<'0' && strString.GetAt(ii)>'9' && strString.GetAt(ii)!=' ' 
			&& strString.GetAt(ii)!=',' && strString.GetAt(ii)!=':')
			return false;
	*/		
	/*	
	for(int ii = 0; ii < strString.GetLength()-1; ii++)
	{
		char c1 = strString.GetAt(ii);
		char c2 = strString.GetAt(ii+1);
		if((c1<'0' || c1>'9') && c1!=' ' && c1!=',' && c1!=':')
			return false;

		if( (c1==' ' || c1==',' || c1==':') &&(c2==' ' || c2==',' || c2==':'))	
			return false;
	}
	
	char c1 = strString.GetAt(ii);
	if(c1<'0' && c1>'9' && c1!=' ' && c1!=',' && c1!=':')
		return false;
	*/
	
	for(int ii = 0; ii < strString.GetLength()-1; ii++)
	{
		char c1 = strString.GetAt(ii);
		char c2 = strString.GetAt(ii+1);
		if((!_is_numeric_char(c1)) && (! _is_linker_for_index_range_string(c1)))
			return false;

		if(_is_linker_for_index_range_string(c1) && _is_linker_for_index_range_string(c2))
			return false;
	}
	
	char c1 = strString.GetAt(ii);
	bool b = _is_linker_for_index_range_string(c1);
	if((!_is_numeric_char(c1)) && (! _is_linker_for_index_range_string(c1)))
			return false;
	///end DEBUG_FOR_STRING_CHECKING
	
	return true;
}

//int get_number_from_string(const string& strString, vector<int>& vNums, int nMax)///Jake 06/12/07 v8.0639b CHANGE_GLOBAL_FUNCTION_NAME
///------ Folger 01/05/2012 ORG-4773-P1 CLEANUP_ERR_MSG_FOR_INVALID_INDEX_OF_ORIGIN_OBJECT
//int get_indices_from_origin_object_index_range_string(const string& strString, vector<int>& vNums, int nMax)
static	int		_format_invalid_index_err_msg(string* pstrErrMsg, int nInvalidIndexErrMsg, int nMax)
{
	if ( pstrErrMsg )
		ocu_load_msg_str(nInvalidIndexErrMsg, pstrErrMsg, NULL, &nMax);
	return nInvalidIndexErrMsg;
}

int get_indices_from_origin_object_index_range_string(const string& strString, vector<int>& vNums, int nMax, string* pstrErrMsg/* = NULL*/, int nInvalidIndexErrMsg/* = XFERR_INVALID_DEST_LAYER*/)
///------ End CLEANUP_ERR_MSG_FOR_INVALID_INDEX_OF_ORIGIN_OBJECT
{
	//if(!is_right_string_format(strString))///Jake 06/12/07 v8.0639b CHANGE_GLOBAL_FUNCTION_NAME
	if(!is_correct_origin_object_index_range(strString))
		return XFERR_WRONG_STRING_FORMAT;
	
	StringArray strTokens;
	int nTokens = strString.GetTokens(strTokens, ',');
	if(nTokens == 0)
		return XFERR_WRONG_STRING_FORMAT;
	
	int mm = 0;
	for(int ii = 0; ii < nTokens; ii++)
	{
		StringArray strTempNums;
		int nTempNums = strTokens[ii].GetTokens(strTempNums, ' ');
		for(int jj = 0; jj < nTempNums; jj++)
		{
			vector vNumsTemp;
			strTempNums[jj].GetTokens(vNumsTemp, ':');
			int nSize = vNumsTemp.GetSize();
			if(nSize == 1)
			{
				int nNum = vNumsTemp[0];
				if(nNum<1 || nNum>nMax)
					///------ Folger 01/05/2012 ORG-4773-P1 CLEANUP_ERR_MSG_FOR_INVALID_INDEX_OF_ORIGIN_OBJECT
					//return XFERR_INVALID_DEST_LAYER;///Jake 06/07/07 MODIFY_ERROR_MSG
					return _format_invalid_index_err_msg(pstrErrMsg, nInvalidIndexErrMsg, nMax);
					///------ End CLEANUP_ERR_MSG_FOR_INVALID_INDEX_OF_ORIGIN_OBJECT
				
				vNums.InsertAt(mm, nNum);
				mm++;
			}
			else
			{
				for(int nn = 0; nn < vNumsTemp.GetSize()-1; nn++)
				{
					if(vNumsTemp[nn] > vNumsTemp[nn+1] && vNumsTemp[nn+1]!= 0)
						return XFERR_WRONG_STRING_FORMAT;
					else if(0 == vNumsTemp[nn+1]) vNumsTemp[nn+1] = nMax;
					for(int xx = vNumsTemp[nn]; xx <= vNumsTemp[nn+1]; xx++)
					{
						if(xx<1 || xx>nMax)
							///------ Folger 01/05/2012 ORG-4773-P1 CLEANUP_ERR_MSG_FOR_INVALID_INDEX_OF_ORIGIN_OBJECT
							//return XFERR_INVALID_DEST_LAYER;
							return _format_invalid_index_err_msg(pstrErrMsg, nInvalidIndexErrMsg, nMax);
							///------ End CLEANUP_ERR_MSG_FOR_INVALID_INDEX_OF_ORIGIN_OBJECT
						
						vNums.InsertAt(mm, xx);
						mm++;
					}						
				}
			}
		}
	}
	
	if(0 == vNums.GetSize())
		///------ Folger 01/05/2012 ORG-4773-P1 CLEANUP_ERR_MSG_FOR_INVALID_INDEX_OF_ORIGIN_OBJECT
		//return XFERR_INVALID_DEST_LAYER;
		return _format_invalid_index_err_msg(pstrErrMsg, nInvalidIndexErrMsg, nMax);
		///------ End CLEANUP_ERR_MSG_FOR_INVALID_INDEX_OF_ORIGIN_OBJECT
	
	return CER_NO_ERROR;
}

//----end ADD_GET_NUMBER_FROM_STRING

/// Max 3/19/08 REWRITE_AND_RENAME_GET_SMOOTH_FACTOR
// access treenode variable directly in utility function is dangerous and limited for use
/*
/// Cloud 07/25/2007 CALCULATE_SMOOTH_FACTOR
bool get_smooth_factor(TreeNode trGetN)
{
	TreeNode tryi = trGetN.iy;
	if (!tryi)
		return false;

	XYRange iy;
	vector vx, vy;
	if (okxf_resolve_tree_construct_range(&tryi, &iy) && iy.GetData(vy, vx))
	{
		/// Max 12/19/07 AVOID_CALCULATION_WITH_TREENODE_VARIABLE_TO_FIX_DIFF_RESULTS_BETEWEEN_XP_AND_VISTA
		//trGetN.sf.dVal = ocmath_get_noise_level(vy.GetSize(), vy, vx);
		//trGetN.sf.dVal *= trGetN.sf.dVal;
		double dfactor = NANUM;
		dfactor = ocmath_get_noise_level(vy.GetSize(), vy, vx);
		dfactor *= dfactor;
		trGetN.sf.dVal = dfactor;
		/// END AVOID_CALCULATION_WITH_TREENODE_VARIABLE_TO_FIX_DIFF_RESULTS_BETEWEEN_XP_AND_VISTA
	}
	else
	{
		trGetN.sf.dVal = 0;
	}
	return true;
}
///End CALCULATE_SMOOTH_FACTOR
*/
double get_smooth_factor_for_bspline(const TreeNode trInputData)
{
	double dfactor = NANUM;
	XYRange xyTemp;
	bool bOK = xy_range_from_GetN_data_node(trInputData, xyTemp);
	if(bOK && xyTemp.IsValid())
	{
		vector vx, vy;
		if(xyTemp.GetData(vy, vx))
		{
			dfactor = ocmath_get_noise_level(vy.GetSize(), vy, vx);
			dfactor *= dfactor;
		}
	}
	return dfactor;
}
/// END REWRITE_AND_RENAME_GET_SMOOTH_FACTOR

///Jasmine 08/14/07 QA80-10207 REPORT_SHEET_CHECK_CONFLICT
static BOOL _is_uncheck_dyna_use_checkbox(TreeNode tr)
{
	return (has_dyna_use_checkbox(tr) && is_optional_by_dyna_use_checkbox(tr));
}
bool is_same_sheet(TreeNode trRd, TreeNode trRt)
{
	if(_is_uncheck_dyna_use_checkbox(trRd) || _is_uncheck_dyna_use_checkbox(trRt))
		return false;	
	string strRd = trRd.strVal;
	string strRt = trRt.strVal;
	///Jasmine 11/02/07 CHANGE_TO_PREDEFINED_TYPE_TO_COMPARE
	//if(0 == strRd.CompareNoCase(strRt) && -1 == strRd.Find(STR_NEW) && strRd.CompareNoCase(STR_OPTIONAL) && strRd.CompareNoCase(STR_NONE))
	if(0 == strRd.CompareNoCase(strRt))
	{
		int nRdType = okutil_cvt_str_to_predefined_type(strRd);
		string strBook, strSheet;
		okutil_get_book_sheet_names(strRd, &strBook, &strSheet);
		if(!strSheet.IsEmpty())//if strRd = [input]<new> or something like that
			nRdType = okutil_cvt_str_to_predefined_type(strSheet);
		//it's ok if strRd is one of <new>, <optional> and <none>
		if(	nRdType != okutil_cvt_str_to_predefined_type(STR_NEW) && 
			nRdType != okutil_cvt_str_to_predefined_type(STR_OPTIONAL) &&
			nRdType != okutil_cvt_str_to_predefined_type(STR_NONE)
			)
			return true;
	}
	///End CHANGE_TO_PREDEFINED_TYPE_TO_COMPARE
	Worksheet wksRd, wksRt;
	wks_from_book_sheet_name(wksRd, strRd);
	wks_from_book_sheet_name(wksRt, strRt);
	if(wksRd && wksRt && is_same_layer(wksRd, wksRt))
		return true;
	return false;
}
///End REPORT_SHEET_CHECK_CONFLICT

#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
#define STR_ATTRIB_OLD_COMBO_VAL "old_combo_val"

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//bool update_output_curve_book_setting(TreeNode& trRootNode, TreeNode& trData, int& nCurveBookType, string& str2ndPart, LPCSTR lpcszBook)
bool update_output_curve_book_setting(TreeNode& trRootNode, TreeNode& trData, int& nCurveBookType, string& str2ndPart, LPCSTR lpcszBook, bool bIsNLFitOutputEvent)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	/*
	if(!trRootNode || !trData)
		return false;
	
	string strCurveBook = trData.Book.strVal;
	
	nCurveBookType = str_to_predefined_type(strCurveBook, str2ndPart);		

	bool	bSheetEnable = true;
	switch(nCurveBookType)
	{
	case PDS_NONE:
		bSheetEnable = false;
		break;
	case PDS_REPORT:
	case PDS_NEW:
		trData.Sheet.strVal = STR_NEW;
		bSheetEnable = false;
		break;
	case PDS_CUSTOM: ///Iris 11/12/04 QA70-7139 ADD_CUSTOM_OPTION_TO_REPORT	
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//check_ask_custom_book_sheet_name(trRootNode, trData.Book, str2ndPart, strCurveBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESULT_CURVE_BOOK);
		check_ask_custom_book_sheet_name(trRootNode, trData.Book, str2ndPart, strCurveBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESULT_CURVE_BOOK, bIsNLFitOutputEvent);
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		Page pg( trData.Book.strVal.GetToken(1,'>') );
		if(!pg)
		{//select default value
			trData.Book.strVal = STR_NEW;
			trData.Sheet.strVal = STR_NEW;
			bSheetEnable = false;
		}
		break;
	case PDS_SOURCE: //if lpcszBook != NULL, should update trData.Book.strVal, means src data change
		if(lpcszBook)
		{
			string strBook(lpcszBook);
			trData.Book.strVal = STR_SOURCE_BOOK + " " + strBook;
		}
		break;
	///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
	case PDS_AUTO:
		trData.Sheet.strVal = STR_NEW;
		bSheetEnable = false;
		break;
	///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
	default:
		break;
	}	
	if(trData.Book.Enable)
		trData.Sheet.Enable = bSheetEnable;
	*/
	//of no use
	ASSERT(FALSE);
	///end CLEAN_OUTPUT_WND_TYPE_CODE
	return true;
}

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//bool update_output_curve_book_option(TreeNode& trGUI, string& str2ndPart, int nCurveBookType, LPCSTR lpcszBook)
bool update_output_curve_book_option(TreeNode& trGUI, string& str2ndPart, int nCurveBookType, LPCSTR lpcszBook, bool bIsNLFitOutputEvent)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	/*
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trBook = trGUI.Output.Report.Book;
	TreeNode trOutput = _get_node_by_tagname(trGUI, bIsNLFitOutputEvent);
	if(!trOutput)
		return error_report("update_output_curve_book_option failed to get output node.");
	TreeNode trBook = trOutput.Report.Book;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	if(!trBook)
		return false;
	
	int nReportBookType = str_to_predefined_type(trBook.strVal, str2ndPart);
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//build_output_book_sheet_option(trGUI, nReportBookType, nCurveBookType, false, true, lpcszBook);
	build_output_book_sheet_option(trGUI, nReportBookType, nCurveBookType, false, true, lpcszBook, bIsNLFitOutputEvent);
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	*/
	//of no use
	ASSERT(FALSE);
	///end CLEAN_OUTPUT_WND_TYPE_CODE
	return true;
}

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//bool output_curve_book_event(TreeNode& trGUI, LPCSTR lpcszBook)
bool output_curve_book_event(TreeNode& trGUI, LPCSTR lpcszBook, bool bIsNLFitOutputEvent)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	/*
	int nCurveBookType;
	string str2ndPart;
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//update_output_curve_book_setting(trGUI, trGUI.OutPut.Data, nCurveBookType, str2ndPart, lpcszBook);
	//update_output_curve_book_option(trGUI, str2ndPart, nCurveBookType, lpcszBook);
	TreeNode trOutput = _get_node_by_tagname(trGUI, bIsNLFitOutputEvent);
	if(!trOutput)
		return error_report("output_curve_book_event failed to get output node.");
	update_output_curve_book_setting(trGUI, trOutput.Data, nCurveBookType, str2ndPart, lpcszBook, bIsNLFitOutputEvent);
	update_output_curve_book_option(trGUI, str2ndPart, nCurveBookType, lpcszBook, bIsNLFitOutputEvent);
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	*/
	//of no use
	ASSERT(FALSE);
	///end CLEAN_OUTPUT_WND_TYPE_CODE
	return true;
}
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS


///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
/////Cheney 2007-8-30 QA70-10290-sug4 FIX_STH_ABOUT_OUTPUT_SETTING_FOR_3D_FIT
//static void _update_residual_and_findxy_setting_if_no_report(TreeNode& tr)
//{
	//if(!tr)
	//{
		//error_report("tree node is missing when in _update_residual_and_findxy_setting_if_no_report");
		//return;
	//}
		//
	//tr.Book.strVal = STR_NEW;
	//tr.Sheet.strVal = STR_NEW;
	//tr.Sheet.Enable = false;
//}
/////end FIX_STH_ABOUT_OUTPUT_SETTING_FOR_3D_FIT


#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
//bool update_output_book_sheet_destination(TreeNode& trOutput, LPCSTR lpcszBookList, LPCSTR lpcszBookDefault, LPCSTR lpcszSheetList, LPCSTR lpcszSheetDefault)
bool update_output_book_sheet_destination(TreeNode& trOutput, LPCSTR lpcszBookList, LPCSTR lpcszBookDefault, LPCSTR lpcszSheetList, LPCSTR lpcszSheetDefault, int nOutputType, int nBookSheetType, int nOPType)
///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
{
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	/*
	if(!trOutput)
		return error_report("_update_output_book_sheet_destination found trOutput invalid");
	
	if(trOutput.Book)
	{
		if(lpcszBookList)
		{
			trOutput.Book.RemoveAttribute(STR_COMBO_ATTRIB);
			trOutput.Book.SetAttribute(STR_COMBO_ATTRIB, lpcszBookList);
		}
		if(lpcszBookDefault)
			trOutput.Book.strVal = lpcszBookDefault;
		///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		//if theme has existd info, should insert in combo
		string strSelectedBookName;
		///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
		//get_selected_book_sheet_name(trOutput.Book, NULL, strSelectedBookName);
		get_selected_book_sheet_name(trOutput.Book, NULL, nOutputType, nBookSheetType, strSelectedBookName);
		///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME		
		if(!strSelectedBookName.IsEmpty())
			set_str_insert_combo(trOutput.Book, strSelectedBookName, STR_CUSTOM + STR_THREE_DOTS); 	
		///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
		///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
		//else if(trOutput.Book.strVal.Find( STR_CUSTOM) > -1) 
		else if( find_string_localization(trOutput.Book.strVal, STR_CUSTOM_E) > -1 ) 
		///---END CLEAN_LOCALIZATION_CODE
			trOutput.Book.strVal = get_output_destination_default_setting(nBookSheetType, nOPType);
		///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
	}
	if(trOutput.Sheet)
	{
		if(lpcszSheetList)
		{
			trOutput.Sheet.RemoveAttribute(STR_COMBO_ATTRIB);
			trOutput.Sheet.SetAttribute(STR_COMBO_ATTRIB, lpcszSheetList);
		}
		if(lpcszSheetDefault)
			trOutput.Sheet.strVal = lpcszSheetDefault;
		///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		//if theme has existd info, should insert in combo
		string strSelectedSheetName;
		///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
		//get_selected_book_sheet_name(NULL, trOutput.Sheet, NULL, strSelectedSheetName);
		get_selected_book_sheet_name(trOutput.Book, trOutput.Sheet, nOutputType, nBookSheetType, NULL, strSelectedSheetName);
		///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
		if(!strSelectedSheetName.IsEmpty())
			set_str_insert_combo(trOutput.Sheet, strSelectedSheetName, STR_CUSTOM + STR_THREE_DOTS); 	
		///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
		///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
		//else if(trOutput.Sheet.strVal.Find( STR_CUSTOM) > -1) 
		else if( find_string_localization(trOutput.Sheet.strVal, STR_CUSTOM_E) > -1 ) 
		///---END CLEAN_LOCALIZATION_CODE
			trOutput.Sheet.strVal = get_output_destination_default_setting(nBookSheetType + 1, nOPType);
		///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME	
	}
	*/
	//of no use code
	ASSERT(FALSE);
	///end CLEAN_OUTPUT_WND_TYPE_CODE
	return true;
}
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS


#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
//NLFIT use m_trNFO, it is different from trOp
///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//static TreeNode _get_input_data_branch(const TreeNode& trGUI)
static TreeNode _get_input_data_branch(const TreeNode& trGUI)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	TreeNode trInput = trGUI.InputData;
	if(trInput)
		return trInput;
	
	//else maybe is NLFit, should try
	return trGUI.Parent().DataSelection.InputData;
}
///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
/*
///Cheney 2007-10-31 QA70-10536-p10 FIND_Z_SHOULD_ALSO_HIDE_REPORT
static void _update_xyzfitting_residual_or_findz_setting(TreeNode& tr, int nOutputType, int nBookSheetType)
{
	string strCombo;
	if(!tr.Book.GetAttribute(STR_COMBO_ATTRIB, strCombo))
		return;
	
	remove_str_from_str_list(STR_REPORT, strCombo);
	///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
	//if(tr.Book.strVal.Compare(STR_REPORT) == 0)
	///Sohy 4/25/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
	//if ( PDS_REPORT == cvt_str_to_predefined_type(tr.Book.strVal) )
	if ( PDS_REPORT == str_to_predefined_type(tr.Book.strVal) )	
	///end ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
	///---END CLEAN_LOCALIZATION_CODE
		update_output_book_sheet_destination(tr, strCombo, STR_NEW, NULL, NULL, nOutputType, nBookSheetType);
	else
		update_output_book_sheet_destination(tr, strCombo, NULL, NULL, NULL, nOutputType, nBookSheetType);
	
	tr.Sheet.Enable = false;
}
///end FIND_Z_SHOULD_ALSO_HIDE_REPORT
*/
// not in use anymore
///end CLEAN_OUTPUT_WND_TYPE_CODE
//------ CPY 11/12/2007 DESC_STATS_ON_ROWS_AUTO_SHOULD_SET_PROPER_SHEET
static bool _is_stats_on_rows(TreeNode& trGUI)
{
	return (trGUI.StatsOnRows && trGUI.StatsOnRows.nVal)? true:false;
}
//-----

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//bool output_report_book_event(TreeNode& trGUI, LPCSTR lpcszBook)
bool output_report_book_event(TreeNode& trGUI, LPCSTR lpcszBook, bool bIsNLFitOutputEvent)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	/*
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trReport = trGUI.Output.Report;
	TreeNode trOutput = _get_node_by_tagname(trGUI, bIsNLFitOutputEvent);
	if(!trOutput)
		return error_report("output_report_book_event failed to get output node.");
	TreeNode trReport = trOutput.Report;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	if(!trReport)
		return error_report("trGUI.Output.Report missing");

	string strReportBook = trReport.Book.strVal;
	
	int 	nReportBookType;
	string 	str2ndPart;
	if( !strReportBook.IsEmpty() )
		nReportBookType = str_to_predefined_type(strReportBook, str2ndPart);
	
	if( !str2ndPart.IsEmpty() && PDS_THREE_DOTS != str_to_predefined_type(str2ndPart) ) //Iris 01/26/2007 v8.0548 ONLY to check when specified page name with <Source> or Existing...
	{
		Page 	pg(str2ndPart);
		bool	bInvalidPage = false;
		if(	PDS_SOURCE == nReportBookType || PDS_EXISTING == nReportBookType)
			bInvalidPage = !pg.IsValid();
		if( PDS_INVALID == nReportBookType || bInvalidPage)
		{
			string 	strOldVal;
			if( trReport.Book.GetAttribute(STR_ATTRIB_OLD_COMBO_VAL, strOldVal) )
			{
				strReportBook = strOldVal;
				nReportBookType = str_to_predefined_type(strReportBook, str2ndPart);
			}
			else
			{
				strReportBook = STR_SOURCE_BOOK;
				nReportBookType = PDS_SOURCE;
			}
		}
		trReport.Book.strVal = strReportBook;
	}
	
	///Cheney 2007-11-7 10536 p14-p16 FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
	int nOutputType = 0;
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trFittedCurve = trGUI.Output.Data;
	TreeNode trFittedCurve = trOutput.Data;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	if(trFittedCurve)
		trFittedCurve.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType);
	
	string strSheetList = STR_NEW; // for updatting sheet combo
	///end FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
	
	bool 	bNoReport = false;
	bool	bSheetEnable = true;
	switch(nReportBookType)
	{
	case PDS_NONE:
		bSheetEnable = false;
		bNoReport = true;
		///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		/////Cheney 2007-8-30 QA70-10290-sug4 FIX_STH_ABOUT_OUTPUT_SETTING_FOR_3D_FIT
		//_update_residual_and_findxy_setting_if_no_report(trGUI.Output.Residual);
		//_update_residual_and_findxy_setting_if_no_report(trGUI.Output.FindXY);
		/////end FIX_STH_ABOUT_OUTPUT_SETTING_FOR_3D_FIT
		///Cheney 2007-11-7 10536 p14-p16 FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
		//int nOutputType = 0;
		//TreeNode trFittedCurve = trGUI.Output.Data;
		//if( trFittedCurve.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType) && nOutputType == OPERATION_OUTPUT_XYZ_FITTING )
		if( nOutputType == OPERATION_OUTPUT_XYZ_FITTING )
		///end FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
		{
			///Cheney 2007-10-31 QA70-10536-p10 FIND_Z_SHOULD_ALSO_HIDE_REPORT
			//TreeNode trResidual = trGUI.Output.Residual;
			/////Cheney 2007-10-24 QA70-10536 FIX_SOME_NEW_PROBLEMS_REPORT_BY_MAX
			////update_output_book_sheet_destination(trResidual, NULL, STR_NEW, NULL, STR_NEW);
			//string strResidualCombo;
			//if(trResidual.Book.GetAttribute(STR_COMBO_ATTRIB, strResidualCombo))
			//{
				//remove_str_from_str_list(STR_REPORT, strResidualCombo);
				//if(trResidual.Book.strVal.Compare(STR_REPORT) == 0)
					/////Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
					////update_output_book_sheet_destination(trResidual, strResidualCombo, STR_NEW, NULL, NULL);
					//update_output_book_sheet_destination(trResidual, strResidualCombo, STR_NEW, NULL, NULL, nOutputType, IDE_REOPRT_BOOK);
					/////end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
				//else
					/////Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
					////update_output_book_sheet_destination(trResidual, strResidualCombo, NULL, NULL, NULL);
					//update_output_book_sheet_destination(trResidual, strResidualCombo, NULL, NULL, NULL, nOutputType, IDE_REOPRT_BOOK);
					/////end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			//}
			/////FIX_SOME_NEW_PROBLEMS_REPORT_BY_MAX
			//trResidual.Sheet.Enable = false;
			 ///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
			 //_update_xyzfitting_residual_or_findz_setting(trGUI.Output.Residual, nOutputType, IDE_REOPRT_BOOK);
			 //_update_xyzfitting_residual_or_findz_setting(trGUI.Output.FindXY, nOutputType, IDE_FIND_XY_BOOK);
			 _update_xyzfitting_residual_or_findz_setting(trOutput.Residual, nOutputType, IDE_REOPRT_BOOK);
			 _update_xyzfitting_residual_or_findz_setting(trOutput.FindXY, nOutputType, IDE_FIND_XY_BOOK);
			///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
			 ///end FIND_Z_SHOULD_ALSO_HIDE_REPORT

		}
		///Cheney 2007-11-7 10536 p14-p16 FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
		if(!trFittedCurve)
			break;
		///end FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
		///Cheney 2007-10-24 QA70-10536 FIX_SOME_NEW_PROBLEMS_REPORT_BY_MAX
		///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
		//if( trFittedCurve.Book.strVal.Compare(STR_REPORT) != 0 )
		///Sohy 4/25/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
		//if ( PDS_REPORT != cvt_str_to_predefined_type(trFittedCurve.Book.strVal) )
		if ( PDS_REPORT != str_to_predefined_type(trFittedCurve.Book.strVal) )
		///end ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
		///---END CLEAN_LOCALIZATION_CODE
			break;
		///FIX_SOME_NEW_PROBLEMS_REPORT_BY_MAX
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//if(nOutputType == OPERATION_OUTPUT_XYZ_FITTING || !is_range_from_normal_book( _get_input_data_branch(trGUI) ) )
		if(nOutputType == OPERATION_OUTPUT_XYZ_FITTING || !is_range_from_normal_book( _get_input_data_branch(trGUI) ) )
		///end 	MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		{
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
			//update_output_book_sheet_destination(trFittedCurve, NULL, STR_NEW, NULL, STR_NEW);
			update_output_book_sheet_destination(trFittedCurve, NULL, STR_NEW, NULL, STR_NEW, nOutputType, IDE_REOPRT_BOOK);
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
		}
		else
		{
			string strCombo;
			if(trFittedCurve.Book.GetAttribute(STR_COMBO_ATTRIB, strCombo))
				trFittedCurve.Book.strVal = strCombo.GetToken(1,'|');
		}
		///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		break;
	case PDS_SOURCE:
		if(lpcszBook)
		{
			string strBook(lpcszBook);
			trReport.Book.strVal = STR_SOURCE_BOOK + " " + strBook;
		}
		///Cheney 2007-11-7 10536 p14-p16 FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
		//------ CPY 11/12/2007 DESC_STATS_ON_ROWS_AUTO_SHOULD_SET_PROPER_SHEET
		//if(trGUI.StatsOnRows && trGUI.StatsOnRows.nVal)// stats on rows
		if(_is_stats_on_rows(trGUI))
		//------
		{
			insert_str_to_str_list(STR_SOURCE_BOOK, strSheetList);
		}
		///end FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
		break;
	case PDS_NEW:
		trReport.Sheet.strVal = STR_NEW;
		bSheetEnable = false;
		break;
	case PDS_CUSTOM:
		bool bIsCustom = (PDS_CUSTOM == str_to_predefined_type(strReportBook, str2ndPart))? true:false;
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//check_ask_custom_book_sheet_name(trGUI, trReport.Book, str2ndPart, strReportBook, false);
		check_ask_custom_book_sheet_name(trGUI, trReport.Book, str2ndPart, strReportBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, 0, bIsNLFitOutputEvent);
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		Page pg( trReport.Book.strVal.GetToken(1,'>') );
		if(!pg)
		{//select default value
			Page pgSource(get_source_page_name(trGUI));
			if(!pgSource)
				return false;
			pg = pgSource;
		}
		//------ CPY 11/12/2007 DESC_STATS_ON_ROWS_AUTO_SHOULD_SET_PROPER_SHEET
		//if(trGUI.StatsOnRows && trGUI.StatsOnRows.nVal)// stats on rows
		if(_is_stats_on_rows(trGUI))
		//------
		{
			if(!lstrlen( get_sheets_in_book(pg, WKS_DATA_SHEET) ))
			{
				trReport.Sheet.strVal = STR_NEW;
				bSheetEnable = false;
			}
			else
			{
				bSheetEnable = true;
			}
		}
		else
		{
			if(!lstrlen( get_sheets_in_book(pg, WKS_REPORT_TABLE) ))
			{
				trReport.Sheet.strVal = STR_NEW;
			}
			bSheetEnable = false; 
		}
		break;
	///Cheney 2007-11-7 10536 p14-p16 FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
	case PDS_AUTO:
		//------ CPY 11/12/2007 DESC_STATS_ON_ROWS_AUTO_SHOULD_SET_PROPER_SHEET
		if(_is_stats_on_rows(trGUI))
		{
			insert_str_to_str_list(STR_SOURCE_BOOK, strSheetList);
			trGUI.Output.Report.Sheet.strVal = STR_INSERT_SOURCE_SHEET;
		}
		else
		//-----
		trReport.Sheet.strVal = STR_NEW;
		bSheetEnable = false;
		break;
	///end FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
	default:
		break;
	}
	trReport.Sheet.Enable = bSheetEnable;
	int nCurveBookType = PDS_USER;
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//if(trGUI.Output.Data)
	//	nCurveBookType = str_to_predefined_type(trGUI.Output.Data.Book.strVal, str2ndPart);
	if(trOutput.Data)
		nCurveBookType = str_to_predefined_type(trOutput.Data.Book.strVal, str2ndPart);
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	bool bAllowReportToSrcSheet = false;
	int nn;
	if(trGUI.GetAttribute(STR_ALLOW_REPORT_TO_SOURCE_SHEET_ATTRIB, nn) && nn > 0)
		bAllowReportToSrcSheet = true;
	
	int nAllowToSourceBook = 0;
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trBook = trGUI.OutPut.Report.Book;
	TreeNode trBook = trOutput.Report.Book;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	trBook.GetAttribute( STR_ALLOW_REPORT_TO_SOURCE_BOOK_ATTRIB, nAllowToSourceBook);
	build_report_book_option(trBook, nAllowToSourceBook, lpcszBook);
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//build_output_book_sheet_option(trGUI, nReportBookType, nCurveBookType, bAllowReportToSrcSheet, true, lpcszBook);
	build_output_book_sheet_option(trGUI, nReportBookType, nCurveBookType, bAllowReportToSrcSheet, true, lpcszBook, bIsNLFitOutputEvent);
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	if(PDS_SOURCE == nReportBookType)
		bSheetEnable = bAllowReportToSrcSheet ? true:false;
	
	trReport.Sheet.Enable = bSheetEnable;
	
	trReport.Book.SetAttribute(STR_ATTRIB_OLD_COMBO_VAL, trReport.Book.strVal);
	
	update_output_book_sheet_destination(trReport, NULL, NULL, strSheetList, NULL, nOutputType, IDE_REOPRT_BOOK, nOutputType);	///Cheney 2007-11-7 10536 p14-p16 FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//show_report_column_option(trGUI);
	show_report_column_option(trGUI, bIsNLFitOutputEvent);
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	*/
	ASSERT(FALSE);
	///end CLEAN_OUTPUT_WND_TYPE_CODE
	return true;
}
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS

//----- CPY 10/15/07 QA70-10536 SR0_725_OUTPUT_LOCATION_NOT_REMEMBER_IN_LAST_USED
/*
bool build_report_book_option(TreeNode& trBook, bool bAllowToSource, LPCSTR lpcszBook)
{
	bool bSourceBook = false;
	string strOldVal = trBook.strVal;
	if(strOldVal.IsEmpty())
		bSourceBook = true;
	else
	{
		int nType;
		page_short_name_from_display_name(strOldVal, nType);
		bSourceBook = nType == PDS_SOURCE? true: false;
	}
	
	if(lpcszBook == NULL)
		return bSourceBook;
	
	string strBook(lpcszBook);
	///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
	//string strCombo;
	string strCombo(STR_AUTO);
	trBook.strVal = STR_AUTO;
	///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
	
	///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
	//if(bSourceBook)
	//{
		//strCombo = STR_SOURCE_BOOK;
		//if(!strBook.IsEmpty())
			//strCombo += " " + strBook;
		//trBook.strVal = strCombo;
		//strCombo = strCombo;
		
	//}
	//else
		//strCombo = STR_SOURCE_BOOK;
	string strtemp = STR_SOURCE_BOOK;
	if(!strBook.IsEmpty())
		strtemp += " " + strBook;
	strCombo += STR_TOKEN_SEP + strtemp;
	///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
	
	if(!bAllowToSource)
	{
		///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
		//strCombo = STR_NEW;
		//trBook.strVal = strCombo;
		strCombo += STR_TOKEN_SEP + STR_NEW;
		///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
	}
	else
		strCombo += STR_TOKEN_SEP + STR_NEW;
	
	strCombo += STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
	strCombo = STR_NONE + STR_TOKEN_SEP + strCombo;
	
	trBook.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	trBook.SetAttribute(STR_ATTRIB_OLD_COMBO_VAL, trBook.strVal);
	return bSourceBook;
}
*/

#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
//CPY 10/15/07 QA70-10536 POST_SR0_725_OUTPUT_LOCATION_CLEANUP
//need to be properly cleaned up to support both Auto and Theme
// based on bAllowToSource, properly reset trBook.strVal and the combo list
// it not yet initialized, then init to Auto
bool build_report_book_option(TreeNode& trBook, bool bAllowToSource, LPCSTR lpcszBook)
{
	bool bSourceBook = false;
	bool bWasEmpty = false;
	string strOldVal = trBook.strVal;
	if(strOldVal.IsEmpty())
		bWasEmpty = true;
	else
	{
		int nType;
		page_short_name_from_display_name(strOldVal, nType);
		bSourceBook = nType == PDS_SOURCE? true: false;
	}
	
	///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	//according to old logic
	if(lpcszBook == NULL)
		return bSourceBook;
	///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	
	string strBook(lpcszBook);
	
	string strCombo = STR_NONE + STR_TOKEN_SEP + STR_AUTO;
	string strBookEntry = STR_SOURCE_BOOK;
	if(!strBook.IsEmpty())
		///Cheney 2007-11-9 QA70-10536 FIX_SOME_NEW_BUGS_OF_OUTPUT_DESTNATION
		//strBookEntry += " " + strBook;
		strBookEntry += strBook;
		///end FIX_SOME_NEW_BUGS_OF_OUTPUT_DESTNATION
		
	if(bAllowToSource)
	{
		strCombo += STR_TOKEN_SEP + strBookEntry;
	}
	if(bWasEmpty)
		trBook.strVal = STR_AUTO;
	else if(bSourceBook)
	{
		///Cheney 2007-11-9 QA70-10536 FIX_SOME_NEW_BUGS_OF_OUTPUT_DESTNATION
		//trBook.strVal = STR_AUTO;
		trBook.strVal = strBookEntry;
		///end FIX_SOME_NEW_BUGS_OF_OUTPUT_DESTNATION
		bSourceBook = false;
	}
	strCombo += STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;	
	trBook.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	trBook.SetAttribute(STR_ATTRIB_OLD_COMBO_VAL, trBook.strVal);
	return bSourceBook;
}
//---- end SR0_725_OUTPUT_LOCATION_NOT_REMEMBER_IN_LAST_USED


///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void build_output_book_sheet_option(TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSourceSheet, bool bAllowReportToSrcBook, LPCSTR lpcszBook)
void build_output_book_sheet_option(TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSourceSheet, bool bAllowReportToSrcBook, LPCSTR lpcszBook, bool bIsNLFitOutputEvent)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	/*
	string strBook, strSheet;
	
	bool bNoReport = PDS_NONE == nReportBookType? true:false;
	bool bReportSource = PDS_SOURCE == nReportBookType? true:false;
	bool bCurveSource = PDS_SOURCE == nCurveBookType? true:false;

	if(!bAllowReportToSourceSheet)
		bReportSource = false;
	//--------- CPY 10/15/07 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING_BROKE_STATS_ON_ROWS
	else if(!bReportSource && PDS_AUTO == nReportBookType)
		bReportSource = true; // can add code later to <new> if does not really make sense to do so, but at this point, we should allow
	//---------
	///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
	//string strReportBook = STR_SOURCE_BOOK;
	string strReportBook = STR_AUTO + STR_TOKEN_SEP + STR_SOURCE_BOOK;
	///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
	if(lpcszBook)
	{
		string strBook(lpcszBook);
		strReportBook += " " + strBook;
	}
	
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trCurves = trGUI.Output.Data;
	TreeNode trOutput = _get_node_by_tagname(trGUI, bIsNLFitOutputEvent);
	if(!trOutput)
	{
		error_report("build_output_book_sheet_option failed to get output node.");
		return;
	}
	TreeNode trCurves = trOutput.Data;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	if(trCurves)
	{
		trCurves.Book.GetAttribute(STR_COMBO_ATTRIB, strBook); 
		trCurves.Sheet.GetAttribute(STR_COMBO_ATTRIB, strSheet);
		
		if(strBook.IsEmpty() || lpcszBook) //need update combo list
			strBook = strReportBook + STR_TOKEN_SEP + STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		
		if(strSheet.IsEmpty())
			strSheet = STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		
		if(bNoReport)
		{
			remove_str_from_str_list(STR_REPORT, strBook);
			remove_str_from_str_list(STR_REPORT, strSheet);		
		}
		else 
		{
			insert_str_to_str_list(STR_REPORT, strBook, STR_NEW);
		}
		
		if(bCurveSource)
		{
			insert_str_to_str_list(STR_SOURCE_BOOK, strSheet, STR_NEW);
		}
		else
		{
			remove_str_from_str_list(STR_SOURCE_BOOK, strSheet);
		}
		
		///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		//int		nOutputToMatrix = 0;
		//if( trCurves.GetAttribute(STR_REPORT_MATRIX_DATA, nOutputToMatrix))
		//{
		//	if(nOutputToMatrix == 1) //surface fitting, = 2 matrix Fitting
		int nOutputType = 0;
		if( trCurves.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType) )
		{
			if(nOutputType == OPERATION_OUTPUT_XYZ_FITTING) 
		///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			{
				remove_str_from_str_list(STR_SOURCE_BOOK, strBook);
			}
			remove_str_from_str_list(STR_REPORT, strBook);
			remove_str_from_str_list(STR_REPORT, strSheet);
			remove_str_from_str_list(STR_SOURCE_BOOK, strSheet);
			remove_str_from_str_list(STR_CUSTOM, strSheet);
			if(trCurves.Book.strVal.IsEmpty())
			{
				///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
				//if(nOutputToMatrix == 1)
				if(nOutputType == OPERATION_OUTPUT_XYZ_FITTING)
				///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
					trCurves.Book.strVal = STR_NEW;
				else
					trCurves.Book.strVal = STR_SOURCE_BOOK;
			}
				
			if(trCurves.Sheet.strVal.IsEmpty())
				trCurves.Sheet.strVal = STR_NEW;
		}
		
		if(!bAllowReportToSrcBook)
		{
			///Cheney QA70-10315 IF_SOURCE_DATA_FROM_EXCEL_SHOULD_NOT_ADD_FIT_CURVE_TO_SOURCE
			//remove_str_from_str_list(STR_SOURCE_BOOK, strBook);
			//remove_str_from_str_list(STR_SOURCE_BOOK, strSheet);
			string strSourceBook = STR_SOURCE_BOOK;
			if(lpcszBook)
			{
				string strtemp(lpcszBook);
				strSourceBook += " " + strtemp;
			}
			remove_str_from_str_list(strSourceBook, strBook);
			remove_str_from_str_list(strSourceBook, strSheet);
			///end IF_SOURCE_DATA_FROM_EXCEL_SHOULD_NOT_ADD_FIT_CURVE_TO_SOURCE
		}
		
		/////Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		//if theme has existd info, should insert in combo
		string strSelectedBookName, strSelectedSheetName;
		///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
		//get_selected_book_sheet_name(trCurves.Book, trCurves.Sheet, strSelectedBookName, strSelectedSheetName);
		get_selected_book_sheet_name(trCurves.Book, trCurves.Sheet, nOutputType, IDE_RESULT_CURVE_BOOK, strSelectedBookName, strSelectedSheetName);
		///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
		///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		
		trCurves.Book.SetAttribute(STR_COMBO_ATTRIB, strBook);  	
		_check_correct_output_option(trCurves.Book, STR_NEW);
		///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		if(!strSelectedBookName.IsEmpty())
			set_str_insert_combo(trCurves.Book, strSelectedBookName, STR_CUSTOM + STR_THREE_DOTS); 
		///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		trCurves.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);			
		_check_correct_output_option(trCurves.Sheet, STR_NEW);
		///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		if(!strSelectedSheetName.IsEmpty())
			set_str_insert_combo(trCurves.Sheet, strSelectedSheetName, STR_CUSTOM + STR_THREE_DOTS); 	
		///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
	}
	else // if no Curve output, then only update Sheet from Book
	{
		strSheet = STR_NEW + STR_TOKEN_SEP;
		if(bReportSource)
			strSheet += STR_SOURCE_BOOK;
	
		// should include <existing...> option for Sheet for Stats on Rows when Book is <existing...>
		//------ CPY 11/12/2007 DESC_STATS_ON_ROWS_AUTO_SHOULD_SET_PROPER_SHEET
		//if(trGUI.StatsOnRows && trGUI.StatsOnRows.nVal && PDS_CUSTOM == nReportBookType && trGUI.Output.Report.Sheet.Enable)// stats on rows
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//if(_is_stats_on_rows(trGUI) && PDS_CUSTOM == nReportBookType && trGUI.Output.Report.Sheet.Enable)
		if(_is_stats_on_rows(trGUI) && PDS_CUSTOM == nReportBookType && trOutput.Report.Sheet.Enable)
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL 
		//------
		{
			strSheet = STR_NEW + "|" + STR_CUSTOM + STR_THREE_DOTS; ///Arvin 08/31/07 PDS_CUSTOM_CAN_NOT_WORK_IN_STATS_ON_ROWS
		}
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//trGUI.Output.Report.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);
		trOutput.Report.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		
		string strDefault = bReportSource? STR_SOURCE_BOOK : STR_NEW;
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//_check_correct_output_option(trGUI.Output.Report.Sheet, strDefault);
		_check_correct_output_option(trOutput.Report.Sheet, strDefault);
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	}
	*/
	//of no use code
	ASSERT(FALSE);
	///end CLEAN_OUTPUT_WND_TYPE_CODE

}

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void show_report_column_option(TreeNode& trGUI)
void show_report_column_option(TreeNode& trGUI, bool bIsNLFitOutputEvent)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	//------ CPY 11/12/2007 DESC_STATS_ON_ROWS_AUTO_SHOULD_SET_PROPER_SHEET
	//bool 		bStatsOnRows = (trGUI.StatsOnRows && trGUI.StatsOnRows.nVal)? true : false;
	bool 		bStatsOnRows = _is_stats_on_rows(trGUI);
	//------
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode 	trReport = trGUI.Output.Report;
	//TreeNode	trCol = trReport.Column;
	TreeNode trOutput = _get_node_by_tagname(trGUI, bIsNLFitOutputEvent);
	if(!trOutput)
		error_report("show_report_column_option failed to get output node.");
	
	TreeNode trReport = trOutput.Report;
	TreeNode trCol  = trReport.Column;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	
	if(bStatsOnRows && trCol)
	{		
		int		nReportBookType = str_to_predefined_type(trReport.Book.strVal);
		int		nReportSheetType = str_to_predefined_type(trReport.Sheet.strVal);
		bool	bShowColumnOption = false;
		if(PDS_SOURCE == nReportBookType && PDS_SOURCE == nReportSheetType ||
			PDS_CUSTOM == nReportBookType && PDS_CUSTOM == nReportSheetType )
			bShowColumnOption = true;
			
		trCol.Show = bShowColumnOption;
	}
}

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void check_ask_custom_book_sheet_name(TreeNode& trGUI, TreeNode& trReport, const string& str2ndPart, const string& strReportBook, bool bSheet, int nDBTY, int nSheetType, int nBookSheetType)
void check_ask_custom_book_sheet_name(TreeNode& trGUI, TreeNode& trReport, const string& str2ndPart, const string& strReportBook, bool bSheet, int nDBTY, int nSheetType, int nBookSheetType, bool bIsNLFitOutputEvent)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	/*
	if(str2ndPart.Compare(STR_THREE_DOTS))
		return;
	
	string strOutput;
	if (!bSheet) 
	{
		///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		//int		nReportMatrix = 0;
		//if(trGUI.Output.Data)
		//	trGUI.Output.Data.GetAttribute(STR_REPORT_MATRIX_DATA, nReportMatrix);
		int		nOutputType = 0;
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//if(trGUI.Output.Data)
		//	trGUI.Output.Data.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType);
		TreeNode trOutput = _get_node_by_tagname(trGUI, bIsNLFitOutputEvent);
		if(!trOutput)
			error_report("check_ask_custom_book_sheet_name failed to get output node.");
		if(trOutput.Data)
			trOutput.Data.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType);
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		
		bool bWks;
		///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		//_check_wks_or_matrix_book_sheet(nReportMatrix, nBookSheetType, bWks);
		_check_wks_or_matrix_book_sheet(nOutputType, nBookSheetType, bWks);
		///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		
		string 	strPath = "Originlab\\ProjectBrowser.c";
		FUNC_STR_DWORD_HWND_BOOL pfn;
		pfn = Project.FindFunction("ProjectBrowseBook", strPath);

		string 	strSelectedName;
		if( pfn && pfn(strSelectedName, 0, GetWindow(), bWks) && !strSelectedName.IsEmpty())
		{
			strSelectedName = STR_CUSTOM + strSelectedName;
			set_str_insert_combo(trReport, strSelectedName, STR_CUSTOM + STR_THREE_DOTS);
		}
		else
		{
			string strOldComboVal;
			trReport.GetAttribute(STR_ATTRIB_OLD_COMBO_VAL, strOldComboVal);
			trReport.strVal = strOldComboVal;
		}
	}	
	else
	{	
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//if(_open_custom_input_box(trGUI, strReportBook, strOutput, bSheet, nDBTY, nSheetType))
		if(_open_custom_input_box(trGUI, strReportBook, strOutput, bSheet, nDBTY, nSheetType, bIsNLFitOutputEvent))
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL	
		{
			trReport.strVal = strOutput;
			//insert custom string to drop down string list
			string strAttri;
			trReport.GetAttribute(STR_COMBO_ATTRIB, strAttri);
			insert_str_to_str_list(strOutput, strAttri, STR_CUSTOM + STR_THREE_DOTS, STR_TOKEN_SEP);
			trReport.SetAttribute(STR_COMBO_ATTRIB, strAttri);		
		}
		else
			trReport.strVal = STR_NEW;
	}
	*/
	//of no use code
	ASSERT(FALSE);
	///end CLEAN_OUTPUT_WND_TYPE_CODE
}

void get_project_pages_name(vector<string> &vsPagesName, uint nPageType)
{
	vsPagesName.RemoveAll();
	foreach(PageBase pg in Project.Pages)
	{
		if(pg.GetType() == nPageType)
			vsPagesName.Add(pg.GetName());

	}	
}
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS

/// Iris 4/01/2008 v8.0834 MOVE_GET_SOURCE_PAGE_NAME_TO_PAGE_UTILS, move to page_utils since many xfunction fail to find get_source_page_name after operation.h included OutputGUIManager.h.
/*
///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//string get_source_page_name(TreeNode& trOperation, string *pstrLayerName)
/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
//string get_source_page_name(TreeNode& trOperation, string *pstrLayerName, bool bIsNLFitOutputEvent)
#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
string get_source_page_name(TreeNode& trGUI, string *pstrLayerName, bool bIsNLFitOutputEvent)
#else
string get_source_page_name(TreeNode& trGUI, string *pstrLayerName, TreeNode& trInput)
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS
///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{	
	string	strName;
	
#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
	//if(trOperation.InputData)
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//if(trOperation.GUI.InputData)
	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME correct the first parameter to trGUI
	//TreeNode trInputData = _get_node_by_tagname(trOperation, bIsNLFitOutputEvent, "InputData");
	TreeNode trInputData = _get_node_by_tagname(trGUI, bIsNLFitOutputEvent, "InputData");
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
#else
	TreeNode trInputData = trInput;
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS

	if(trInputData)
	///end 	MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
	{
		///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
		//TreeNode trFirstNode;
		//TreeNode trRange1 = trOperation.InputData.Range1;
		//if(trRange1)
			//trFirstNode = trRange1.FirstNode;
		//else
			//trFirstNode = trOperation.InputData.FirstNode;
		//string strVal = trFirstNode.strVal;
		//strVal.Delete(0);
		//strName = strVal.GetToken(0, ']');
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//is_range_from_normal_book(trOperation.GUI.InputData, &strName, pstrLayerName);
		is_range_from_normal_book(trInputData, &strName, pstrLayerName);
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
	}
	else  //is XF variable
	{
		XFunction xf;//(trOperation, false);
		string strBookName, strSheetName;
		if( xf.GetSourceBookSheet(strBookName, strSheetName) )
			strName = strBookName;
		
		if( pstrLayerName != NULL)
			*pstrLayerName = strSheetName;
	}
	return strName;	
}
*/

string xf_get_source_page_name(TreeNode& trGUI, string *pstrLayerName)
{
	string strName;
	XFunction xf;//(trOperation, false);
	string strBookName, strSheetName;
	if( xf.GetSourceBookSheet(strBookName, strSheetName) )
		strName = strBookName;
	
	if( pstrLayerName != NULL)
		*pstrLayerName = strSheetName;
	return strName;
}
///end MOVE_GET_SOURCE_PAGE_NAME_TO_PAGE_UTILS

///Jasmine 10/15/07 MOVE_TO_PAGE_UTILS
/*
///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
string get_source_page_name(const DataRange& drInput, string *pstrLayerName)
{	
	string strName;
	is_range_from_normal_book(drInput, &strName, pstrLayerName);
	return strName;	
}
///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
*/
///End MOVE_TO_PAGE_UTILS

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
// move to page_utils
/*
string get_sheets_in_book(const Page& pg, int nSheetType )
{
	if(!pg)
		return "";
	string strNameList, strRpsheetList;
	if(WKS_REPORT_TABLE != nSheetType)
		strNameList = page_get_layer_names(pg, false);
	if(WKS_ALL != nSheetType)
		strRpsheetList = _get_report_sheets_in_book(pg, 0);
	switch(nSheetType)
	{
	case WKS_REPORT_TABLE:
		return strRpsheetList;
	case WKS_DATA_SHEET:
		if(lstrlen(strNameList) && lstrlen(strRpsheetList))
		{
			vector<string> vsLayers, vsRpsheets;
			strNameList.GetTokens(vsLayers, '|');
			strRpsheetList.GetTokens(vsRpsheets, '|');
			remove_if_in_list(vsLayers, vsRpsheets);
			strNameList.SetTokens(vsLayers, '|');
		}
	}
	return strNameList;	
}

static string _get_report_sheets_in_book(const Page& pg, int& iActiveSheet)
{
	string strName, strList, strActiveLayer;
	int ii = 0;
	iActiveSheet = -1;
	if( pg )
	{
		strActiveLayer = pg.Layers(-1).GetName();
		foreach( Layer ly in pg.Layers )
		{
			strName = ly.GetName();
			
			if(strName.IsEmpty() ) // cannot output to sheet with no name
				continue;

			if(!(ly.GetSystemParam(0) & WP_SHEET_HIERARCHY))
				continue;
			
			strList += strName;
			strList += STR_TOKEN_SEP;  
			if( strActiveLayer == strName )
				iActiveSheet = ii;
			ii++;
		}
	}
	return strList;
}
*/
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
//static string _get_fitcurve_page_name(TreeNode& trOperation)
///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
static string _get_fitcurve_page_name(TreeNode& trGUI, bool bIsNLFitOutputEvent = false)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	string strName;
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trGUI = tree_get_node_by_tagname(trOperation, "GUI", true);
	//TreeNode trBook = trGUI.Output.Data.Book;
	TreeNode trOutput = _get_node_by_tagname(trGUI, bIsNLFitOutputEvent);
	if(!trOutput)
		return error_report("_get_fitcurve_page_name failed to get output node.");
	TreeNode trBook = trOutput.Data.Book;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	if(trBook)
	{
		int nType;
		string str2ndPart;
		nType = str_to_predefined_type(trBook.strVal, str2ndPart);
		if(!str2ndPart.IsEmpty())
		{
			if(str2ndPart.Compare(STR_THREE_DOTS))
				strName = str2ndPart;
		}
		if(PDS_REPORT == nType)
			///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
			//strName = _get_report_page_name(trGUI);
			strName = _get_report_page_name(trGUI, bIsNLFitOutputEvent);
			///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		if(PDS_SOURCE == nType)
			///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
			//strName = get_source_page_name(trGUI);
			strName = get_source_page_name(trGUI, NULL, bIsNLFitOutputEvent);
			///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	}	
	return strName;
}

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//static string _get_report_page_name(TreeNode& trOperation)
static string _get_report_page_name(TreeNode& trGUI, bool bIsNLFitOutputEvent = false)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	string strName;
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trReportBook = trOperation.Output.Report.Book;
	TreeNode trOutput = _get_node_by_tagname(trGUI, bIsNLFitOutputEvent);
	if(!trOutput)
		return error_report("_get_report_page_name failed to get output node.");
	TreeNode trReportBook = trOutput.Report.Book;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	if(trReportBook)
	{
		int nType;
		string str2ndPart;
		nType = str_to_predefined_type(trReportBook.strVal, str2ndPart);
		if(!str2ndPart.IsEmpty())
		{
			if(str2ndPart.Compare(STR_THREE_DOTS))
				strName = str2ndPart;
		}
		else if(PDS_SOURCE == nType)
			///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
			//strName = get_source_page_name(trOperation);
			strName = get_source_page_name(trGUI, NULL, bIsNLFitOutputEvent);
			///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	}	
	return strName;
}


static void _check_correct_output_option(TreeNode& trOutput, LPCSTR lpcszCorrect = NULL)
{
	if(!trOutput)
		return;
	
	string strOptions;
	trOutput.GetAttribute(STR_COMBO_ATTRIB, strOptions);
	
	string strVal = trOutput.strVal;
	string str2ndPart;
	int nType = str_to_predefined_type(strVal, str2ndPart);
	if( 0 != str2ndPart.Compare(strVal) && !str2ndPart.IsEmpty())
		return;
	if(-1 == strOptions.Find(strVal))
		trOutput.strVal = (NULL == lpcszCorrect)? strOptions.GetToken(0) : lpcszCorrect;
}


///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
//static void _check_wks_or_matrix_book_sheet(int nReportMatrix, int nID, bool& bWks = true)
static void _check_wks_or_matrix_book_sheet(int nOutputType, int nID, bool& bWks = true)
///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
{
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	/*
	///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	//if(nReportMatrix == 0)
	if(nOutputType == OPERATION_OUTPUT_GENERAL)
	///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	{
		bWks = true;
		return;
	}
	
	switch(nID)
	{
	case IDE_RESIDUAL_CURVE_BOOK:
	case IDE_RESIDUAL_CURVE_SHEET:
		///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		//if(nReportMatrix == 1) //Surface fitting
		if(nOutputType == OPERATION_OUTPUT_XYZ_FITTING) //Surface fitting
		///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			bWks = true;
		else
			bWks = false; //Matrix fitting
		break;
		
	case IDE_RESULT_CURVE_BOOK:
	case IDE_RESULT_CURVE_SHEET:
		bWks = false;
		break;
			
	default:
		bWks = true;
		break;
	}	
	*/
	//of no use code
	ASSERT(FALSE);
	///end CLEAN_OUTPUT_WND_TYPE_CODE
}

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//static bool _open_custom_input_box(TreeNode& trGUI, string strBook, string& strOutput, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL)  ///Iris 11/23/04 CHANGED_RETURN_VAL
static bool _open_custom_input_box(TreeNode& trGUI, string strBook, string& strOutput, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL, bool bIsNLFitOutputEvent = false)  ///Iris 11/23/04 CHANGED_RETURN_VAL
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{	
	string 	strPageName;
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//string 	strRealSourcePage = get_source_page_name(trGUI);
	string 	strRealSourcePage = get_source_page_name(trGUI, NULL, bIsNLFitOutputEvent);
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	
	//when selection of Report Book is "<Source>  book1" or "<custom> book1", need convert to real page name
	//else if it is "<custom>...", the default of input box should be empty
	int nType;
	string str2ndPart;	
	str2ndPart = page_short_name_from_display_name(strBook, nType);

	switch(nType)
	{
	case PDS_USER:
		strPageName = str2ndPart;
		break;
	case PDS_SOURCE:
	case PDS_CUSTOM:
		if(str2ndPart.IsEmpty())
			strPageName = strRealSourcePage;
		else
			if(str2ndPart.Compare(STR_THREE_DOTS))
				strPageName = str2ndPart;
		break;
	case PDS_FIT_CURVE:
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//strPageName = _get_fitcurve_page_name(trGUI);
		strPageName = _get_fitcurve_page_name(trGUI, bIsNLFitOutputEvent);
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
			break;
	case PDS_REPORT:
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//strPageName = _get_report_page_name(trGUI);
		strPageName = _get_report_page_name(trGUI, bIsNLFitOutputEvent);
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
			break;
	default:
		break;
	}
	
	string strNameList;
	if(!bSheet)
	{
		vector<string> vsPages;
		char chToken = '|';
		get_project_pages_name(vsPages);
		strNameList.SetTokens(vsPages, chToken);
	}
	else
	{			
		int nSheet=0;
		Page pg(strPageName);
		if(!pg)
			return false;

		strNameList = get_sheets_in_book(pg, nSheetType);
	}	

	if(!lstrlen(strNameList))
		return false;
	GETN_TREE(tr)
	GETN_LIST(list, "Existing name", 0, strNameList)
	if(GetNBox(tr, _L("Select Name..."), "  " ))
	{
		strOutput = get_selected_string_from_combolist(tr.list);
	}
	
	if(!strOutput.IsEmpty())
	{
		///Cheney 2007-11-9 QA70-10536 FIX_SOME_NEW_BUGS_OF_OUTPUT_DESTNATION
		//strOutput = STR_CUSTOM + " " + strOutput;   ///Iris 11/23/04 
		strOutput = STR_CUSTOM + strOutput;   ///Iris 11/23/04 
		///end FIX_SOME_NEW_BUGS_OF_OUTPUT_DESTNATION
		return true;	
	}
	return false;
}
///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS
/*
///Cheney 2007-10-12 IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
#ifdef NLFIT_CHECK_LOOSE_DATASET
bool	is_loose_dataset(const TreeNode& trRange)
{
	if(!trRange)
		return false;
	
	int nPlotUID = 0;
	if(!trRange.GetAttribute( STR_PLOTOBJ_UID_ATTRIB, nPlotUID))
		return false;
	
	DataPlot dp;
	dp = (DataPlot)Project.GetObject(nPlotUID);
	if(!dp)
		return false;
	
	string strName = dp.GetName();
	foreach( string strNametemp in Project.LooseDatasetNames)
	{
		if(strNametemp.Compare(strName) == 0)
			return true;
	}
	return false;
}
#endif //NLFIT_CHECK_LOOSE_DATASET
///end IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
*/
///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
//void	_get_selected_name(const TreeNode& tr, string& strSelectedName)
//{
	//if(!tr)
		//return;
	//
	//string strtemp = tr.strVal;
	//if( strtemp.Find( STR_CUSTOM) > -1)
		//strSelectedName = strtemp;
//}
//void	get_selected_book_sheet_name(const TreeNode& trBook, const TreeNode& trSheet, string& strSelectedBookName, string& strSelectedSheetName)
//{
	//if(strSelectedBookName)
		//_get_selected_name(trBook, strSelectedBookName);
	//if(strSelectedSheetName)
		//_get_selected_name(trSheet, strSelectedSheetName);
//}
/////end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX

#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
string get_output_destination_default_setting(int nBookSheetType, int nOPType)
{
	string strDefault;
	switch(nBookSheetType)
	{
	case IDE_REOPRT_BOOK:
		strDefault = STR_AUTO;
		break;
	case IDE_RESULT_CURVE_BOOK:
		strDefault = STR_AUTO;
		break;
	case IDE_RESIDUAL_CURVE_BOOK:
		strDefault = STR_FIT_CURVE;
		if(nOPType == OP_XYZ_FITTING_TOOL)
			strDefault = STR_REPORT;
		break;	
	case IDE_FIND_XY_BOOK:
		strDefault = STR_FIT_CURVE;
		if(nOPType == OP_XYZ_FITTING_TOOL || nOPType == OP_MAT_FITTING_TOOL)
			strDefault = STR_REPORT;
		break;
	case IDE_REPORT_SHEET:
		strDefault = STR_NEW;
		break;
	case IDE_RESULT_CURVE_SHEET:
		strDefault = STR_NEW;
		break;
	case IDE_RESIDUAL_CURVE_SHEET:
		strDefault = STR_FIT_CURVE;
		if(nOPType == OP_XYZ_FITTING_TOOL || nOPType == OP_MAT_FITTING_TOOL)
			strDefault = STR_NEW;
		break;	
	case IDE_FIND_XY_SHEET:
		strDefault = STR_NEW;
		break;
	default:
	}
	return strDefault;
}

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS, incorrect codes should use str_to_predefined_type to get second part name
/*
void	_get_custom_book_or_sheet_name(string& strName)
{
	string strTemp = strName;
	///Chenye 2007-11-2 QA70-10536-p13 OUTPUT_DEST_NOT_WORK_IN_J_VER
	//if( strTemp.Find( STR_CUSTOM) > -1)	
	//{
		//strTemp.TrimLeft(STR_CUSTOM);
		//strName = strTemp;
	//}
	//else
		//strName.Empty();
	if( PDS_CUSTOM == str_to_predefined_type(strTemp) )
		strName = strTemp.GetToken(1,'>');
	else
		strName.Empty();
	///end OUTPUT_DEST_NOT_WORK_IN_J_VER
}
*/
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

void	get_selected_book_sheet_name(const TreeNode& trBook, const TreeNode& trSheet, int nOutputType, int nBookSheetType, string& strSelectedBookName, string& strSelectedSheetName)
{
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	//string strBook = trBook.strVal;
	//string strSheet;
	//if(trSheet)
		//strSheet = trSheet.strVal;
	//_get_custom_book_or_sheet_name(strBook);
	//_get_custom_book_or_sheet_name(strSheet);
	string 	strBook, strSheet;
	if(trBook)
		str_to_predefined_type(trBook.strVal, strBook);
	if(trSheet)
		str_to_predefined_type(trSheet.strVal, strSheet);
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	
	bool bWks = false;
	_check_wks_or_matrix_book_sheet(nOutputType, nBookSheetType, bWks);
	Page pg;
	if(bWks)
	{
		WorksheetPage wp(strBook);
		pg = wp;
	}
	else
	{
		MatrixPage mp(strBook);
		pg = mp;
	}
	
	if(!pg)
		return;
	
	if(strSelectedBookName)
		strSelectedBookName = trBook.strVal;
	
	Layer ly = pg.Layers(strSheet);
	if(ly && strSelectedSheetName && trSheet)
		strSelectedSheetName = trSheet.strVal;
}
///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME

///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void	update_output_report_and_curve_setting(TreeNode& trGUI, LPCSTR lpcszSrcPageName)
void	update_output_report_and_curve_setting(TreeNode& trGUI, LPCSTR lpcszSrcPageName, bool bIsNLFitOutputEvent)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	/*
	string strSrcPageName(lpcszSrcPageName);
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//if( !strSrcPageName.IsEmpty() )			
	//{
		//output_curve_book_event(trGUI, strSrcPageName);
		//output_report_book_event(trGUI, strSrcPageName);
	//}
	//else
	//{
		//output_curve_book_event(trGUI, NULL);
		//output_report_book_event(trGUI, NULL);
	//}
	output_curve_book_event(trGUI, strSrcPageName, bIsNLFitOutputEvent);
	output_report_book_event(trGUI, strSrcPageName, bIsNLFitOutputEvent);
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	*/
	ASSERT(FALSE);
	///end CLEAN_OUTPUT_WND_TYPE_CODE
}
///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING

///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
void get_residual_combo(int nFitType, bool bPlotFitCurve, string& strResidualBookCombo, string& strResidualSheetCombo)
{
	switch(nFitType)
	{
	case NLFIT_XYZ_FITTING:
		strResidualBookCombo = STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO;
		strResidualSheetCombo = STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO;
		break;
	case NLFIT_MATRIX_FITTING:
		strResidualBookCombo = STR_MATFITTING_RESIDUALOUT_BOOK_COMBO;
		strResidualSheetCombo = STR_MATFITTING_RESIDUALOUT_SHEET_COMBO;
		break;
	case NLFIT_GENERAL_XY_FITTING:
		strResidualBookCombo = STR_XYFITTING_RESIDUALOUT_BOOK_COMBO;
		strResidualSheetCombo = STR_XYFITTING_RESIDUALOUT_SHEET_COMBO;
		break;
	default:
	}
	
	if(!bPlotFitCurve)
	{
		remove_str_from_str_list(STR_FIT_CURVE, strResidualBookCombo);
		remove_str_from_str_list(STR_FIT_CURVE, strResidualSheetCombo);
	}
}

void get_findxy_combo(int nFitType, bool bPlotFitCurve, string& strFindXYBookCombo, string& strFindXYSheetCombo)
{
	switch(nFitType)
	{
	case NLFIT_XYZ_FITTING:
		strFindXYBookCombo = STR_XYZFITTING_FINDZOUT_BOOK_COMBO;
		strFindXYSheetCombo = STR_XYZFITTING_FINDZOUT_SHEET_COMBO;
		break;
	case NLFIT_MATRIX_FITTING:
		strFindXYBookCombo = STR_MATFITTING_FINDZOUT_BOOK_COMBO;
		strFindXYSheetCombo = STR_MATFITTING_FINDZOUT_SHEET_COMBO;
		break;
	case NLFIT_GENERAL_XY_FITTING:
		strFindXYBookCombo = STR_XYFITTING_FINDXYOUT_BOOK_COMBO;
		strFindXYSheetCombo = STR_XYFITTING_FINDXYOUT_SHEET_COMBO;
		break;
	default:
	}
	
	if(!bPlotFitCurve)
	{
		remove_str_from_str_list(STR_FIT_CURVE, strFindXYBookCombo);
		remove_str_from_str_list(STR_FIT_CURVE, strFindXYSheetCombo);
	}
}
///end IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS

///Echo 9/12/07
int dr_get_col_percent_text(const DataRange& dr, const int nIndex, bool bSkipMissing)
{
	Column cc;
	int r1 = 0, r2 = -1;
	if (!range_get_col(dr, nIndex, cc, &r1, &r2))
		return -1;
		
	if (!cc)
		return -1;
	
	DatasetObject dobj(cc);
	int nn = dobj.PercentText(bSkipMissing, r1, r2);
    
    return nn;

}

#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
static string	_get_report_book_name_by_type(const TreeNode& trGUI, const TreeNode& trOutput, int nReportBookType, LPCSTR lpcszReport2ndPart, bool* pbReportBookNameEnable)
{	
	string  strReport2ndPart(lpcszReport2ndPart);
	string	strReportBookName = "";
	bool	bReportBookNameEnable = false;
	switch(nReportBookType)
	{
	case PDS_SOURCE:
	case PDS_CUSTOM:
		strReportBookName = strReport2ndPart;
		break;
	case PDS_NEW:		
		TreeNode 	trReportBookName = trOutput.Report.BookName;
		if(trReportBookName)
			trReportBookName.GetAttribute(STR_DEFAULT_ATTRIB, strReportBookName);
		
		bReportBookNameEnable = true;
		break;
	case PDS_AUTO:
		// No way to set STR_REPORT_DESTINATION_TYPE_ATTRIB attribute now, so keep this control empty for Auto
		//// convert book type from auto to real book type
		////nReportBookType = GetReportOutPutDestination(trGUI.InputData);
		//TreeNode 	trReportBook = trOutput.Report.Book;
		//if( trReportBook && trReportBook.GetAttribute(STR_REPORT_DESTINATION_TYPE_ATTRIB, nReportBookType) )
		//{
			//strReportBookName = get_report_book_name_by_type(trGUI, trOutput, nReportBookType, lpcszReport2ndPart, &bReportBookNameEnable);
		//}
		strReportBookName = "";
		break;
	case PDS_NONE:
	default:
		break;
	}
	
	if( strReportBookName.IsEmpty() && nReportBookType == PDS_SOURCE)
		strReportBookName = get_source_page_name(trGUI.Parent());
	
	// Need to uncomment when above Auto case works.
	//if( strReportBookName.IsEmpty() && nReportBookType != PDS_NONE )
	//	error_report( "get_report_book_name_by_type() found empty strReportBookName for !PDS_NONE type");

	if(pbReportBookNameEnable)
		*pbReportBookNameEnable = bReportBookNameEnable;
	
	return strReportBookName;
}

static string	_get_report_sheet_name_by_type(TreeNode& trGUI, int nReportSheetType, LPCSTR lpcszReport2ndPart, bool* pbReportSheetNameEnable)
{
	string  strReport2ndPart(lpcszReport2ndPart);
	string	strReportSheetName = "";
	bool	bReportSheetNameEnable = false;
	switch(nReportSheetType)
	{
	// <source>	 and <existing>... cases for stats on row
	case PDS_SOURCE:
	case PDS_CUSTOM:
		if( !strReport2ndPart.IsEmpty() )
			strReportSheetName = strReport2ndPart;
		else
			error_report("_get_report_sheet_name_by_type() found empty 2nd report part for Source or Existing type");
		break;
	case PDS_NEW:
		TreeNode 	trReportSheetName = trGUI.Output.Report.SheetName;
		if(trReportSheetName)
			trReportSheetName.GetAttribute(STR_DEFAULT_ATTRIB, strReportSheetName);
		
		bReportSheetNameEnable = true;
		break;
	case PDS_NONE:
	default:
		break;
	}
	
	if(pbReportSheetNameEnable)
		*pbReportSheetNameEnable = bReportSheetNameEnable;
	
	return strReportSheetName;	
}

// set report book name control with real book name
void 	set_report_output_book_name_by_type(TreeNode& trGUI, bool bIsNLFitOutputEvent)
{
	TreeNode trOutput = _get_node_by_tagname(trGUI, bIsNLFitOutputEvent, "Output");
	if(!trOutput)
	{
		error_report("set_report_output_book_name_by_type failed to get output node.");
		return;
	}
	
	TreeNode trOutputBook = trOutput.Report.Book;
	TreeNode trOutputBookName = trOutput.Report.BookName;
	if( trOutputBook && trOutputBookName )
	{
		if( !trOutputBook.IsEmpty() )
		{
			string	str2ndPart;
			int 	nReportType = str_to_predefined_type(trOutputBook.strVal, str2ndPart);
			
			bool	bReportBookNameEnable;
			trOutputBookName.strVal = _get_report_book_name_by_type(trGUI, trOutput, nReportType, str2ndPart, &bReportBookNameEnable);			
			trOutputBookName.Enable = bReportBookNameEnable;
		}
	}
	else
	{
		error_report( "set_report_output_book_name_by_type() found invalud .Report.Book and .Report.BookName nodes" );
		return;
	}	
}

// set report sheet name control with real sheet name
void 	set_report_output_sheet_name_by_type(TreeNode& trGUI)
{
	TreeNode trOutputSheet = trGUI.Output.Report.Sheet;
	TreeNode trOutputSheetName = trGUI.Output.Report.SheetName;
	if( trOutputSheet && trOutputSheetName )
	{
			string	str2ndPart;
			int 	nReportType = str_to_predefined_type(trOutputSheet.strVal, str2ndPart);
			
			bool	bReportSheetNameEnable;
			trOutputSheetName.strVal = _get_report_sheet_name_by_type(trGUI, nReportType, str2ndPart, &bReportSheetNameEnable);			
			trOutputSheetName.Enable = bReportSheetNameEnable;
		
	}	
}

void	set_report_output_book_sheet_name_by_type(TreeNode& trGUI)
{
	set_report_output_book_name_by_type(trGUI);
	
	set_report_output_sheet_name_by_type(trGUI);	
}
///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS 

/// Sophy 4/11/2008 QA v8.0840 CHECK_REPORT_DATA_BOOK_NAME_DIFFERENT
/**
check whether two node have same book name and sheet name,if yes return true,else return false
input: two treenodes
output: none
return: the result of comparation,boolean,true if the same,else false;
*/
static bool _is_book_sheet_name_the_same(TreeNode& trReport, TreeNode& trOther)
{
	bool bRet = false;
	if( !trReport || !trOther )
	{
		return bRet; //NULL pointer, no need to compare any more
	}
	string strReportBookName = trReport.BookName.strVal;
	string strOtherBookName = trOther.BookName.strVal;
	string strReportSheetName = trReport.SheetName.strVal;
	string strOtherSheetName =trOther.SheetName.strVal;
	if( ( 0 == strReportBookName.CompareNoCase( strOtherBookName ) ) && ( 0 == strReportSheetName.CompareNoCase( strOtherSheetName )) )
	{
		bRet = true;
	}
	return bRet;
}
int check_report_book_curve_book(TreeNode& trGUI, string& strRet)
{
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = tree_get_node_by_tagname(trGUI,"Output",true);
	ASSERT(trOutput);   //assert node not empty
	int nErr = CER_NO_ERROR; //assume there is no error
	///Sophy 4/14/2008 CHECK_REPORT_DATA_BOOK_NAME_DIFFERENT
	//string strReportBookName = trOutput.Report.BookName.strVal;
	//string strTempBookName = trOutput.Data.BookName.strVal;
	//string strReportSheetName = trOutput.Report.SheetName.strVal;
	//string strTempSheetName ;
	//
	////Check Report & Data node's book/sheet name are different
	//if(0 == strReportBookName.CompareNoCase( strTempBookName )) //bookname the same ,need to check sheetname
	//{
		//strTempSheetName = trOutput.Data.SheetName.strVal;
		//if(0 == strReportSheetName.CompareNoCase( strTempSheetName )) //sheetname is the same,not allowed
		//{
			/////Sophy 4/14/2008 ADD_OUTPUT_ERR_STRING;
			////nErr = CER_SAME_REPORT_DATA_BOOKNAME + ":Data";
			//nErr = CER_SAME_REPORT_DATA_BOOKNAME;
			//strRet="Data";
			/////end ADD_OUTPUT_ERR_STRING
			//return nErr;
		//}
	//}
	//
	////Check Report & Residual node's book/sheet name are different
	//strTempBookName = trOutput.Residual.BookName.strVal;
	//if(0 == strReportBookName.CompareNoCase( strTempBookName )) //bookname the same, need to check sheetname
	//{
		//strTempSheetName = trOutput.Residual.SheetName.strVal;
		//if(0 == strReportSheetName.CompareNoCase( strTempSheetName ))//sheetname is the same too,not allowed
		//{
			/////Sophy 4/14/2008 ADD_OUTPUT_ERR_STRING;
			////nErr = CER_SAME_REPORT_DATA_BOOKNAME + ":Residual";
			//nErr = CER_SAME_REPORT_DATA_BOOKNAME;
			//strRet = "Residual";
			/////end ADD_OUTPUT_ERR_STRING
			//return nErr;
		//}
	//}
	//
	////Check Report & FindXY node's book/sheet name are different
	//strTempBookName = trOutput.FindXY.BookName.strVal;
	//if(0 == strReportBookName.CompareNoCase( strTempBookName )) //bookname the same, need to check 
	//{
		//strTempSheetName = trOutput.FindXY.SheetName.strVal;
		//if(0 == strReportSheetName.CompareNoCase( strTempSheetName))//sheetname is also the same,not allowed
		//{
			/////Sophy 4/14/2008 ADD_OUTPUT_ERR_STRING;
			////nErr = CER_SAME_REPORT_DATA_BOOKNAME + ":FindXY";
			//nErr = CER_SAME_REPORT_DATA_BOOKNAME;
			//strRet = "FindXY";
			/////end ADD_OUTPUT_ERR_STRING
			//return nErr;
		//}
	//}
	if( _is_book_sheet_name_the_same( trOutput.Report, trOutput.Data ) )
	{
		nErr = CER_SAME_REPORT_DATA_BOOKNAME;
		strRet = "Data";
		return nErr;
	}
	if( _is_book_sheet_name_the_same( trOutput.Report, trOutput.Residual ) )
	{
		nErr = CER_SAME_REPORT_DATA_BOOKNAME;
		strRet = "Residual";
		return nErr;
	}
	if( _is_book_sheet_name_the_same( trOutput.Report, trOutput.FindXY ) )
	{
		nErr = CER_SAME_REPORT_DATA_BOOKNAME;
		strRet = "FindXY";
		return nErr;
	}
	///end CHECK_REPORT_DATA_BOOK_NAME_DIFFERENT
	///Sophy 4/22/2008 CHECK_OUTPUT_BOOK_SHEET_NAME_DIFFERENT use in PA output
	if( _is_book_sheet_name_the_same( trOutput.PeakCharacter, trOutput.Data ) )
	{
		nErr = CER_SAME_REPORT_DATA_BOOKNAME;
		strRet = "Data";
		return nErr;
	}
	if( _is_book_sheet_name_the_same( trOutput.PeakCharacter, trOutput.Residual ) )
	{
		nErr = CER_SAME_REPORT_DATA_BOOKNAME;
		strRet = "Residual";
		return nErr;
	}
	///end CHECK_OUTPUT_BOOK_SHEET_NAME_DIFFERENT
	return nErr; //no error
}
/// end CHECK_REPORT_DATA_BOOK_NAME_DIFFERENT

///Kyle 10/31/08 QA80-12452  SUPPORT_INPUT_DATA_FORM_OPTION_FOR_NPH_TESTS
int check_input_range_indexed_raw(const TreeNode & trRng, int type, string & strErrMsg)
{
	Range rng;
	okxf_resolve_tree_construct_range(&trRng, &rng);
	return check_input_range_indexed_raw( rng, type, strErrMsg);
}

int check_input_range_indexed_raw(const Range& irng, int type, string &strErrMsg)
{
	int nErrCode;
	if(type == SIDT_INVAR)
	{
		nErrCode = check_1_data( irng, true, true);
		if (nErrCode != CER_NO_ERROR)
		{
			strErrMsg = nErrCode;
			if (nErrCode == CER_COL_NUM_TOO_FEW_EX)
				strErrMsg += ":" + 2;
		}
		return nErrCode;
	}
	else
	{
		if(!irng || irng.GetNumRanges()<2)
		{
			strErrMsg = CER_NOT_INDEX_DATA;
			return CER_NOT_INDEX_DATA;
		}

		int r1, c1, r2, c2;
		Worksheet wksTemp;
		string strRange;
		int nErrCode;
		
		// group
		irng.GetRange(0, r1, c1, r2, c2, wksTemp, &strRange);
		//if(!wksTemp || c1!=c2)
			//nErrCode = CER_COL_NUM_NOT_ONE;

		DataRange rGroup;
		rGroup.Add("X", wksTemp, r1, c1, r2, c2);
		nErrCode = check_1_data(rGroup, false, true);
		if (nErrCode != CER_NO_ERROR)
		{
			strErrMsg = CER_COL_NUM_NOT_ONE_EX;
			strErrMsg += ":" + "for Group Range";
			return nErrCode;
		}
		
		// data
		irng.GetRange(1, r1, c1, r2, c2, wksTemp, &strRange);
		//if(!wksTemp)
			//nErrCode = CER_COL_NUM_TOO_FEW_EX;
		DataRange rData;
		rData.Add("X", wksTemp, r1, c1, r2, c2 );
		nErrCode = check_1_data( rData, true, true);
		if(nErrCode != CER_NO_ERROR)
		{
			strErrMsg = nErrCode;
			if (nErrCode == CER_COL_NUM_TOO_FEW_EX)
				strErrMsg += ":" + 1;
			return nErrCode;
		}

		return nErrCode;
	}

}
///End SUPPORT_INPUT_DATA_FORM_OPTION_FOR_NPH_TESTS

//----------- Iris 11/20/2008 v8.0975d QA80-12591-P4 REMOVE_LOG_DATA_TYPE_WHEN_DATA_FROM_MATRIX
///Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
//static void _change_indep_data_type_combo_on_source_page_type(TreeNode& trDataType, bool bFromMatrix, bool bFromGraph)
static void _change_indep_data_type_combo_on_source_page_type(TreeNode& trDataType, bool bEnableLog, bool bFromGraph)
///End ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
{
	if(!trDataType)
		return;	
	
	string strCombo;
	if(trDataType.GetAttribute(STR_ATTRIB_BRANCH_COMBO, strCombo))
	{
		/////Sophy, about bFromMatrix, actually, this logic is surplus here, for No linear fitting, after calling this functions, NLFitSession::UpdateDataTypeBranch
		////will be call, in which we will check whether it is from 3D fitting(XYZ and Matrix fitting) and whether allow Log type; for other fitting tools, data
		////can't be from Matrix. Now we won't remove this code in case broke some other tools, and should be cleaned after 80SR6.
		//if(bFromMatrix)
		if(!bEnableLog)///Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
			remove_str_from_str_list(STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LOG, strCombo);
		else
			insert_str_to_str_list(STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LOG, strCombo, STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT);
			
		if(bFromGraph)
			insert_str_to_str_list(STR_FITTED_CURVE_DATA_TYPE_SAME_SOURCE_GRAPH, strCombo);			
		else
			remove_str_from_str_list(STR_FITTED_CURVE_DATA_TYPE_SAME_SOURCE_GRAPH, strCombo);
			
		trDataType.SetAttribute(STR_ATTRIB_BRANCH_COMBO, strCombo);
	}				

}


static int _get_source_page_type(TreeNode& trInput)
{
	if(trInput)
	{
		DataRange rngInput;
		rngInput.Create(trInput, FALSE);	
		if(rngInput)
		{
			vector<uint> vUIDs;
			if(rngInput.GetPlots(vUIDs) > 0)
			{
				DataPlot dp;
				dp = Project.GetObject(vUIDs[0]);
				if(dp)
				{
					GraphLayer gl;
					dp.GetParent(gl);
					if(gl)
						return EXIST_PLOT;
				}
			}		
		}
	}
	
	return -1;
}

///Sophy 7/8/2009 v8.1060 CLEAN_CODE_SUPPORT_UPDATE_Y_DATATYPE_BRANCH

///Sophy 7/22/2009 v8.1073 NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
//void _check_set_datatype_on_source_graph(TreeNode& trGUI, bool bX = true)
void _check_set_datatype_on_source_graph(TreeNode& trGUI, TreeNode& trInput, bool bX = true)
///end NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
{
	///Sophy 7/22/2009 v8.1073 NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
	//pass input data node from outside
	//TreeNode trInput = tree_get_node_by_dataid(trGUI, IDST_INPUT_DATA_OPTIONS, true);
	//if ( !trInput )
		//trInput = tree_get_node_by_tagname(trGUI, "InputData", true);
	///end NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
	DataRange drInput;
	drInput.Create();
	drInput.SetTree(trInput);
	
	vector<uint> vPlotUIDs;
	drInput.GetPlots(vPlotUIDs);
	if( vPlotUIDs.GetSize() < 1 )
		return;
	
	DataPlot dp;
	dp = (DataPlot)Project.GetObject((int)vPlotUIDs[0]);
	if ( !dp )
		return;
	
	GraphLayer gl;
	dp.GetParent(gl);
	if ( !gl )
		return;
	
	TreeNode trSrcSetting = gl.GetFormat(FPB_SCALE, FOB_SCALE, true, true);
	
	TreeNode trType;
	if ( bX )
		trType = trSrcSetting.Root.Axes.X.Scale.Type;
	else
		trType = trSrcSetting.Root.Axes.Y.Scale.Type;
	
	if ( !trType )
		return;
	
	if( SCALE_TYPE_LINEAR != trType.nVal )
	{
		TreeNode trDataType;
		if ( bX )
			trDataType = tree_get_node_by_tagname(trGUI, "XDataType", true);
		else
			trDataType = tree_get_node_by_tagname(trGUI, "YDataType", true);
		
		if ( trDataType )
		{
			trDataType.SetAttribute(STR_USE_ATTRIB, FIT_CURVE_SAME_AS_SOURCE_GRAPH);
		}
	}
	return;
}

///Sophy 7/22/2009 v8.1073 NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
//void check_set_datatype(TreeNode& trGUI, bool bCheckX/* = true*/)
///Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
//void check_set_datatype(TreeNode& trGUI, TreeNode& trInput, bool bCheckX/* = true*/)
void check_set_datatype(TreeNode& trGUI, TreeNode& trInput, int nFitType, bool bCheckX/* = true*/)
///End ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
///end NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
{
	///Sophy 7/22/2009 v8.1073 NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
	//change_indep_data_type_combo_on_source_page_type(trGUI); 
	///Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
	//change_indep_data_type_combo_on_source_page_type(trGUI, trInput); 
	change_indep_data_type_combo_on_source_page_type(trGUI, trInput, nFitType); 
	///End ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
	///end NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
	
	string strDataType = bCheckX ? "XDataType" : "YDataType";
	TreeNode trDataType = tree_get_node_by_tagname(trGUI, strDataType, true);
	_check_set_datatype_value(trDataType);
	
	///Sophy 7/22/2009 v8.1073 NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
	//_check_set_datatype_on_source_graph(trGUI, bCheckX);
	_check_set_datatype_on_source_graph(trGUI, trInput, bCheckX);
	///end NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA

}
///end CLEAN_CODE_SUPPORT_UPDATE_Y_DATATYPE_BRANCH

///Sophy 11/24/2008 v8.978c CHECK_SET_XDATATYPE_VALUE_ON_APPLY_THEME
//void change_indep_data_type_combo_on_source_page_type(TreeNode& tr)
///Sophy 7/22/2009 v8.1073 NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
//void change_indep_data_type_combo_on_source_page_type(TreeNode& tr, bool& bSourceFromGraph) //NULL
///Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
//void change_indep_data_type_combo_on_source_page_type(TreeNode& tr, TreeNode& trInput, bool& bSourceFromGraph) //NULL
void change_indep_data_type_combo_on_source_page_type(TreeNode& tr, TreeNode& trInput, int nFitType, bool& bSourceFromGraph/*=NULL*/)
///End ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
///end NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
///end CHECK_SET_XDATATYPE_VALUE_ON_APPLY_THEME
{	
	//TreeNode trInput = tree_get_node_by_tagname(tr, "InputData", true);	///Sophy 7/22/2009 v8.1073 NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA

	///Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
	bool bEnableLog;
	if(nFitType == -1)//for other operation
	{
		///Sophy 11/21/2008 v8.976 QA80-12591-P3 ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT
		//bool bFromMatrix = EXIST_MATRIX == _get_source_data_sheet_type(trInput)? true : false;
		bool bFromMatrix = EXIST_MATRIX == get_source_data_sheet_type(trInput)? true : false;
		///end ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT
		
		bEnableLog = !bFromMatrix;
	}
	else//for matrix fit and surface fit
	{
		bEnableLog = ( NLFIT_GENERAL_XY_FITTING == nFitType );
	}
	///End ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
	
	///Sophy 11/24/2008 v8.978c CHECK_SET_XDATATYPE_VALUE_ON_APPLY_THEME
	//bool bFromGraph = EXIST_PLOT == _get_source_page_type(trInput)? true : false;
	bool bFromGraph = ( bSourceFromGraph != NULL ) ? bSourceFromGraph : (EXIST_PLOT == _get_source_page_type(trInput)? true : false);
	///end CHECK_SET_XDATATYPE_VALUE_ON_APPLY_THEME
	
	TreeNode trXDataType = tree_get_node_by_tagname(tr, "XDataType", true);
	TreeNode trYDataType = tree_get_node_by_tagname(tr, "YDataType", true);
	///Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
	//_change_indep_data_type_combo_on_source_page_type(trXDataType, bFromMatrix, bFromGraph);
	//_change_indep_data_type_combo_on_source_page_type(trYDataType, bFromMatrix, bFromGraph);
	_change_indep_data_type_combo_on_source_page_type(trXDataType, bEnableLog, bFromGraph);
	_change_indep_data_type_combo_on_source_page_type(trYDataType, bEnableLog, bFromGraph);
	///End ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
}
//-----------
///Sophy 11/24/2008 v8.978c CHECK_SET_XDATATYPE_VALUE_ON_APPLY_THEME
static void _check_set_datatype_value(TreeNode& trDataType)
{
	if( !trDataType )
		return;
	
	string	strCombo;
	int		nUse;
	if( trDataType.GetAttribute(STR_ATTRIB_BRANCH_COMBO, strCombo) && trDataType.GetAttribute(STR_USE_ATTRIB, nUse) )
	{
		int nNumItems = strCombo.GetNumTokens('|');
		if( nUse >= nNumItems )
			trDataType.SetAttribute(STR_USE_ATTRIB, FIT_CURVE_UNIFORM_LINEAR); //default, set uniform linear as active
	}
}


void check_set_xdatatype_value(TreeNode& tr)
{
	TreeNode trXDataType = tree_get_node_by_tagname(tr, "XDataType", true);
	if ( !trXDataType )
		return;
	
	_check_set_datatype_value(trXDataType);
}

///end CHECK_SET_XDATATYPE_VALUE_ON_APPLY_THEME
///Sophy 1/12/2009 v8.995c QA80-12591-P6 CHECK_ERROR_SHOULD_ONLY_CHECK_ALL_X_DATA_ARE_POSITIVE
static bool _get_all_x_min_max(DataRange& drInput, double& dMin, double& dMax)
{
	if ( !drInput )
		return false;
	///Sophy 2/4/2009 v8.0971b FIX_NLSF_GIVE_WRONG_MESSAGE_FOR_SAMPLE_INTERVAL_CASE
	//int nNumRanges = drInput.GetNumRanges();
	//Worksheet wks;
	//string strName;
	//DataRange drSub;
	//vector vAllXData, vOneData;
	//int r1, c1, r2, c2;
	//for(int index = 0; index < nNumRanges; index++)
	//{
		//drInput.GetRange(index, r1, c1, r2, c2, wks, &strName);
		//if ( strName.CompareNoCase("X") == 0 )
		//{
			//vOneData.SetSize(0);//empty in case it contains data
			//if ( drInput.GetData(&vOneData, index) )
				//vAllXData.Append(vOneData);
		//}
	//}
	//return vAllXData.GetMinMax(dMin, dMax);
	XYRange xyRange(drInput);
	vector vX, vY;
	vector vAllXData;
	///Sophy 2/5/2009 v8.0972c FIX_RUNTIME_WHEN_DO_3D_FITTING
	if ( !xyRange )
		return false;
	///end FIX_RUNTIME_WHEN_DO_3D_FITTING
	int nNumData = xyRange.GetNumData(DRR_GET_DEPENDENT);
	for(int index = 0; index < nNumData; index++)
	{
		if ( xyRange.GetData(vY, vX, NULL, index) )
			vAllXData.Append(vX);
	}
	ASSERT(vAllXData.GetSize() > 0);
	return vAllXData.GetMinMax(dMin, dMax);
	///end FIX_NLSF_GIVE_WRONG_MESSAGE_FOR_SAMPLE_INTERVAL_CASE
}
///end CHECK_ERROR_SHOULD_ONLY_CHECK_ALL_X_DATA_ARE_POSITIVE
///Sophy 11/21/2008 v8.976 QA80-12591-P3 ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT copy from nlfcurves.h need to centralize

int	check_input_logx_datatype(TreeNode& trInput, TreeNode& trDataType)
{
	DataRange dr;
	dr.Create(trInput, false);
	if( dr )//check error only when datarange is valid 
	{
		///Sophy 1/12/2009 v8.995c QA80-12591-P6 CHECK_ERROR_SHOULD_ONLY_CHECK_ALL_X_DATA_ARE_POSITIVE
		//vector vData;
		//dr.GetData( &vData, -1 ); //get all data
		//double dMin, dMax;
		//vData.GetMinMax(dMin, dMax);
		//if( dMin < 0 && FIT_CURVE_UNIFORM_LOG == get_fitted_curve_data_type(trDataType) )
			//return CER_LOG_X_DATATYPE_NOT_ALLOWED;
		///Sophy 2/5/2009 v8.0972c FIX_RUNTIME_WHEN_DO_3D_FITTING
		//double dMin, dMax;
		//_get_all_x_min_max(dr, dMin, dMax);
		//if( dMin <= 0 && FIT_CURVE_UNIFORM_LOG == get_fitted_curve_data_type(trDataType) )
			//return CER_LOG_X_DATATYPE_NOT_ALLOWED;
		if ( FIT_CURVE_UNIFORM_LOG == get_fitted_curve_data_type(trDataType) ) //since 3D fitting only support Uniform Linear, so no need to run following lines
		{
			double dMin, dMax;			
			if ( _get_all_x_min_max(dr, dMin, dMax) && dMin <= 0 )
				return CER_LOG_X_DATATYPE_NOT_ALLOWED;
		}
		///end FIX_RUNTIME_WHEN_DO_3D_FITTING
		///end CHECK_ERROR_SHOULD_ONLY_CHECK_ALL_X_DATA_ARE_POSITIVE
	}
	return CER_NO_ERROR; //skip other error
}

int check_logx_customize_x_range(TreeNode& trDataType)
{
	if( !trDataType )
		return CER_NO_ERROR;
	
	int nCurSel = trDataType.Range.nVal;
	ASSERT(nCurSel >=0);
	string strTypes;
	if( trDataType.Range.GetAttribute(STR_COMBO_ATTRIB, strTypes) )
	{
		string strCurSel = strTypes.GetToken(nCurSel, '|');
		if( strCurSel.CompareNoCase("Custom") != 0 )
			return CER_NO_ERROR;
		
		if( FIT_CURVE_UNIFORM_LOG == get_fitted_curve_data_type(trDataType) && (trDataType.Min.dVal <= 0 || trDataType.Max.dVal <= 0) )
			return CER_INVALID_X_DATARANGE_FOR_LOG_TYPE;
	}
	return CER_NO_ERROR;
}
///end ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT

/// Max 11/25/08 QA70-12615 v8.0975d SHARE_SAME_FUNC_FOR_NORMALIZE_AND_VNORMALIZE
bool normalize_make_datainfo_tree(TreeNode& tr, LPCSTR lpcszVarName)
{
	if ( 0 == lstrcmp(lpcszVarName, "datainfo") )
	{
		GETN_USE(tr)
		GETN_NUM(number, _L("Number of Points"), 0)
		GETN_READ_ONLY_EX(2)
		
		GETN_NUM(missing, _L("Number of Missing Values"), 0)
		GETN_READ_ONLY_EX(2)
		
		///Sophy 9/10/2009 QA80-14087-P15 SHOW_SUM_IN_DATA_INFO_BRANCH_FOR_NORMALIZE_TOOLS
		GETN_NUM(sum, _L("Sum"), 0)
		GETN_READ_ONLY_EX(2)
		///end SHOW_SUM_IN_DATA_INFO_BRANCH_FOR_NORMALIZE_TOOLS
		
		GETN_NUM(max, _L("Maximum"), 0)
		GETN_READ_ONLY_EX(2)
		
		GETN_NUM(min, _L("Minimum"), 0)		
		GETN_READ_ONLY_EX(2)
		
		GETN_NUM(mean, _L("Mean"), 0)		
		GETN_READ_ONLY_EX(2)
		
		GETN_NUM(sd, _L("Standard Deviation"), 0)		
		GETN_READ_ONLY_EX(2)
		
		GETN_NUM(median, _L("Median"), 0)		
		GETN_READ_ONLY_EX(2)
		
		GETN_NUM(norm, _L("Norm"), 0)		
		GETN_READ_ONLY_EX(2)
		
		//GETN_NUM(mode, _L("Mode"), 0)	  ///it's slow to find mode, so comment it	
		//GETN_READ_ONLY_EX(2)
		return false;	// it seeems that 0 means success
	}	
	
	return -1;
}

bool normalize_set_datainfo(const vector& vData, TreeNode& trDataInfo)
{
	int nSize =0, nNonMissing = 0;
	double dMean = NANUM, dSD = NANUM, dMedian = NANUM, dMax = NANUM, dMin = NANUM, dNorm = NANUM, dSum = NANUM;

	nSize = vData.GetSize();
	vData.GetMinMax(dMin, dMax);
	///Sophy 9/10/2009 QA80-14087-P15 SHOW_SUM_IN_DATA_INFO_BRANCH_FOR_NORMALIZE_TOOLS
	//ocmath_basic_summary_stats(nSize, vData, &nNonMissing, &dMean, &dSD);
	ocmath_basic_summary_stats(nSize, vData, &nNonMissing, &dMean, &dSD, NULL, NULL, &dSum);
	///end SHOW_SUM_IN_DATA_INFO_BRANCH_FOR_NORMALIZE_TOOLS
	
	if( nSize >= 2 ) /// Iris 8/07/2009 FIX_NORMALIZE_RUNTIME_ERROR_WHEN_NUM_POINTS_LESS_EQUAL_1
	{
		/// Max 11/5/07 SORT_BEFORE_CALCULATE_MEDIAN
		//dMedian = (nSize%2) ? vyIn[nSize/2] : 0.5* ( vyIn[nSize/2] + vyIn[nSize/2-1]);
		vector vySort;
		vySort = vData;
		vySort.Sort();
		dMedian = (vySort.GetSize() == 1) ? vySort[0] : ((nSize%2) ? vySort[nSize/2] : 0.5* ( vySort[nSize/2] + vySort[nSize/2-1]));
		/// END SORT_BEFORE_CALCULATE_MEDIAN
	}
	/// Iris 8/07/2009 FIX_NORMALIZE_RUNTIME_ERROR_WHEN_NUM_POINTS_LESS_EQUAL_1
	else if( 1 == nSize)
	{
		dMedian = vData[0];
	}
	///end FIX_NORMALIZE_RUNTIME_ERROR_WHEN_NUM_POINTS_LESS_EQUAL_1
		
	
	vector vTmp;
	vTmp = vData * vData;
	vTmp.Sum(dNorm);
	dNorm = (dNorm <0) ? NANUM : sqrt(dNorm);
	
	trDataInfo.number.nVal = nSize;
	trDataInfo.missing.nVal = nSize - nNonMissing;	
	trDataInfo.sum.dVal = dSum;	///Sophy 9/10/2009 QA80-14087-P15 SHOW_SUM_IN_DATA_INFO_BRANCH_FOR_NORMALIZE_TOOLS
	trDataInfo.max.dVal = dMax;
	trDataInfo.min.dVal = dMin;
	trDataInfo.mean.dVal = dMean;
	trDataInfo.sd.dVal = dSD;
	trDataInfo.median.dVal = dMedian;
	trDataInfo.norm.dVal = dNorm;
	
	return true;
}

/// Hong 08/10/09 QA-13673 ADD_COMMENT_FOR_USE_REFERENCE_COLUMN_METHOD
//string normalize_get_method_string(const int nMethod, const double dValue)
///Sophy 9/2/2009 IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS
//string normalize_get_method_string(const int nMethod, const double dValue, int nSubMethod/* = 0*/)
string normalize_get_method_string(LPCSTR lpcszSrc, const int nMethod, const double dValue, int nSubMethod/* = 0*/, const Column& colRef/* = NULL*/, int nNormXF = /* = XF_NORMALIZE*/)
///end IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS
/// end ADD_COMMENT_FOR_USE_REFERENCE_COLUMN_METHOD
{
	// use to set comment row of output and no need to localize for now
	// Hong 08/10/09, order below should be maintained carefully
	vector<string>		vsMethods = {
		"Divided by ",
		"Normalize to [0, 1]",
		"Transfer to N(0, 1)",
		"Divided by Max",
		"Divided by Min",
		"Divided by Mean",
		"Divided by Median",
		"Divided by SD",
		"Divided by Norm",
		"Divided by Mode",
		/// Hong 08/10/09 QA-13673 ADD_COMMENT_FOR_NEW_METHOD
		"Divided by Sum"
		/// end ADD_COMMENT_FOR_NEW_METHOD
		///Sophy 8/20/2009 QA80-14087-S2 BETTER_NAME_FOR_RESULT_COLUMNS_WHEN_WITH_REFERENCE
		///// Hong 08/10/09 QA-13673 ADD_COMMENT_FOR_USE_REFERENCE_COLUMN_METHOD
		//"Divided by %s of Reference Column",
		///// end ADD_COMMENT_FOR_USE_REFERENCE_COLUMN_METHOD
		//"Divided by value in Reference Cell" /// Iris 08/12/09 QA-13673 RNORMALIZE_XF_ADD_USE_REFERENCE_CELL_METHOD
		///Sophy 9/2/2009 IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS
		//"Normalize to %s of Reference Column",
		//"Divided by Reference Data"
		//"Normalize to %s of Reference Column %s",
		///end IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS
		///end BETTER_NAME_FOR_RESULT_COLUMNS_WHEN_WITH_REFERENCE
	};
	
	///Sophy 9/2/2009 IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS
	///Philip 08/28/2012 ORG-6114-S2 ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS
	//if ( XF_RNORMALIZE == nNormXF )
	if ( XF_RNORMALIZE == nNormXF || XF_NORMALIZE == nNormXF )
	///end ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS
	{
		vsMethods.Add("Normalize %s to %s of Reference Column %s");
		vsMethods.Add("Divided %s by Reference Cell");
	}
	else if ( XF_CNORMALIZE == nNormXF )
	{
		vsMethods.Add("Normalize %s to %s of Reference Plot %s");
		vsMethods.Add("Normalize %s to Reference Point");
	}
	
	/// Philip 07/05/2012 ORG-6114 ADD_NORMALIZE_0_TO_100_OPTION_FOR_NORMALIZE_TOOL
	vsMethods.Add("Normalize to [0, 100]");//should always append new method at the end(as well as in XF Builder)
	/// end ORG-6114
	
	///end IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS
	/// Iris 08/12/09 QA-13673 RNORMALIZE_XF_ADD_USE_REFERENCE_CELL_METHOD
	//ASSERT(0 <= nMethod &&  nMethod <= 9);
	ASSERT(0 <= nMethod &&  nMethod < vsMethods.GetSize());
	///end RNORMALIZE_XF_ADD_USE_REFERENCE_CELL_METHOD
	string strMethod = vsMethods[nMethod];
	///Philip 08/28/2012 ORG-6114-S2 ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS
	//if ( nMethod == 0 )
	if ( nMethod == method_specify )
	///end ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS
		strMethod += ftoa(dValue);
	/// Hong 08/10/09 QA-13673 ADD_COMMENT_FOR_USE_REFERENCE_COLUMN_METHOD
	///Philip 08/28/2012 ORG-6114-S2 ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS
	/////Philip 08/16/2012 ORG-6114-S1 ADD_NORMALIZE2_0_100_OPTION_FOR_NORMALIZE_TOOL , bug fixed
	//if ( (XF_RNORMALIZE == nNormXF || XF_CNORMALIZE == nNormXF) && 11 == nMethod )	
	/////end ADD_NORMALIZE2_0_100_OPTION_FOR_NORMALIZE_TOOL
	if ( method_ref == nMethod )
	///end ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS
	{
		vector<string>		vsSubMethods = {"Min", "Max", "Mean", "Median", "Sum"};
		ASSERT(0 <= nSubMethod && nSubMethod < vsSubMethods.GetSize());
		string	strFmt = strMethod;
		///Sophy 9/2/2009 IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS
		//strMethod.Format(strFmt, vsSubMethods[nSubMethod]);
		ASSERT( NULL != colRef );//when reference to column, colRef is valid. Make sure used correctly
		string strRefColName = "";
		///Sophy 10/28/2009 QA80-14087-P20 CAREFULLY_UPDATE_COMMENTS_FIELD_OF_RESULT_COLUMN_WHEN_ONLY_OGG_EXIST
		if ( NULL != colRef && colRef.IsValid() )
		{
			strRefColName = get_column_name(colRef, true, true);
			DataRange drRef;
			string strRefRngStr;
			colRef.GetRangeString(strRefRngStr);
			drRef.Add("Range1", strRefRngStr);
			strMethod.Format(strFmt, lpcszSrc, vsSubMethods[nSubMethod], get_input_data_range_string(drRef));
		}
		else
		{
			strMethod.Format(strFmt, lpcszSrc, vsSubMethods[nSubMethod], "");
		}
		///end CAREFULLY_UPDATE_COMMENTS_FIELD_OF_RESULT_COLUMN_WHEN_ONLY_OGG_EXIST
		///end IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS
	}
	//Sophy 9/15/2009 IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS
	///Philip 08/28/2012 ORG-6114-S2 ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS
	/////Philip 08/16/2012 ORG-6114-S1 ADD_NORMALIZE2_0_100_OPTION_FOR_NORMALIZE_TOOL
	//else if ( (XF_RNORMALIZE == nNormXF || XF_CNORMALIZE == nNormXF) && 12 == nMethod )
	/////end ADD_NORMALIZE2_0_100_OPTION_FOR_NORMALIZE_TOOL
	else if ( method_cell == nMethod )
	///end ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS
	{
		string strFmt = strMethod;
		strMethod.Format(strFmt, lpcszSrc); 
	}
	else //common method for all normalize tool, centralize from outside
	{
		strMethod.Format("%s of %s", strMethod, lpcszSrc);
	}
	///end IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS
	/// end ADD_COMMENT_FOR_USE_REFERENCE_COLUMN_METHOD
	return 	strMethod;
}
/// END SHARE_SAME_FUNC_FOR_NORMALIZE_AND_VNORMALIZE

///------ Folger 03/13/09 QA80-13262 CONVERT_OBJECT_VARIABLE_OPTIOANL_TO_NEW_IN_XF_DIALOG
void	check_convert_optional_outputs_to_new(TreeNode& trGetN)
{
	foreach ( TreeNode trNode in trGetN.Children )
	{
		///------ Folger 10/16/09 QA81-14489-P2 OPTIONAL_VECTOR_OUTPUT_BECAME_WRONG_IN_CHANGE_PARAM
		if ( DISABLE == trNode.Enable )
			continue;
		///------ End OPTIONAL_VECTOR_OUTPUT_BECAME_WRONG_IN_CHANGE_PARAM
		int		nIO = -1;
		if ( !trNode.GetAttribute(STR_XF_VAR_IO_ATTRIB, nIO) || IO_OUTPUT != nIO )
			continue;
		
		int		nUseCheck = -1;
		if ( !trNode.GetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nUseCheck) )
			continue;
		
		int		nVariableType = -1;
		if ( !trNode.GetAttribute(STR_XF_VAR_TYPE, nVariableType) 
			|| XVT_DOUBLE == nVariableType
			|| XVT_STRING == nVariableType
			|| XVT_INT == nVariableType
			)
			continue;
		
		/// must be output with DynaUseCheck
		
		if ( trNode.FirstNode )		/// composite range
		{
			string strData;
			if ( trNode.GetAttribute(STR_DATA_ATTRIB, strData) )
			{
				if ( PDS_OPTIONAL == okutil_cvt_str_to_predefined_type(strData)
					|| PDS_NONE == okutil_cvt_str_to_predefined_type(strData) )
				{
					trNode.SetAttribute(STR_DATA_ATTRIB, STR_NEW);
					okutil_getn_update_ranges(&trNode);
				}
			}
		}
		else
		{
			if ( PDS_OPTIONAL == okutil_cvt_str_to_predefined_type(trNode.strVal)
				|| PDS_NONE == okutil_cvt_str_to_predefined_type(trNode.strVal) )
			{
				trNode.strVal = STR_NEW;
			}
		}
	}
}
///------ End CONVERT_OBJECT_VARIABLE_OPTIOANL_TO_NEW_IN_XF_DIALOG

/// Iris 7/14/2009 QA80-13941 SUPPORT_MORE_OPTIONS_FOR_WREPLACE_AND_MREPLACE_XF
#define GUI_LOOK_IN_MATRIX_BASE	1

enum
{
	GUI_LOOK_IN_ACTIVE_MATRIX_OBJECT = -1,
	GUI_LOOK_IN_ACTIVE_SHEET,
	GUI_LOOK_IN_ACTIVE_PAGE,
	GUI_LOOK_IN_ACTIVE_FOLDER,
	GUI_LOOK_IN_ACTIVE_FOLDER_RECURSIVE,
	GUI_LOOK_IN_ACTIVE_FOLDER_OPEN,
	GUI_LOOK_IN_PROJECT
};

int get_lookin_options(int nSel, int nPageType)
{
	const bool bIsActivePageMatrix = EXIST_MATRIX == nPageType;
	const int nBase = bIsActivePageMatrix ? GUI_LOOK_IN_MATRIX_BASE : 0;
	nSel -= nBase;
	
	switch(nSel)
	{
	case GUI_LOOK_IN_ACTIVE_MATRIX_OBJECT:
		return OPTION_ACTIVE_MATRIX_OBJECT;
	case GUI_LOOK_IN_ACTIVE_SHEET:
		return OPTION_ACTIVE_SHEET;
	case GUI_LOOK_IN_ACTIVE_PAGE:
		return OPTION_ACTIVE_PAGE;
	case GUI_LOOK_IN_ACTIVE_FOLDER:
		return OPTION_ALL_IN_ACTIVE_FOLDER;
	case GUI_LOOK_IN_ACTIVE_FOLDER_RECURSIVE:
		return OPTION_ALL_RECURSIVE_IN_ACTIVE_FOLDER;
	case GUI_LOOK_IN_ACTIVE_FOLDER_OPEN:
		return OPTION_ALL_OPEN_IN_ACTIVE_FOLDER;
	case GUI_LOOK_IN_PROJECT:
		return OPTION_ALL_IN_OPJ;
	default:
		ASSERT(0);
	}
	return OPTION_LOOK_IN_INVALID;
}

/// Kenny 07/23/2009 QA80-13992 NEW_XF_FOR_GENERAL_MULTI_AXES_PLOTTING
int convert_gui_plot_type( const int nPlot )
{
	vector<int> vnPlots = {IDM_PLOT_LINE, IDM_PLOT_SCATTER, IDM_PLOT_LINESYMB, IDM_PLOT_COLUMN};
	if(0 <= nPlot && nPlot < vnPlots.GetSize())
		return vnPlots[nPlot];
	return IDM_PLOT_LINE;
}
/// End QA80-13992 NEW_XF_FOR_GENERAL_MULTI_AXES_PLOTTING

///end SUPPORT_MORE_OPTIONS_FOR_WREPLACE_AND_MREPLACE_XF

/// Iris 7/29/2009 WREPLACE_AND_MREPLACE_XF_FIX_ALWAYS_ASSUME_REPLACE_RANGE_IS_ACTIVE_PAGE
bool get_page_datasheet_from_range(Range& rng, Page* ppage/* = NULL*/, Datasheet* psheet/* = NULL*/)
{
	if( !rng || rng.GetNumRanges() <= 0 )
		return false;
	
	int			c1, c2;
	Datasheet	sheet;
	if( rng.GetRange(sheet, c1, c2) && sheet ) // DataRange::GetRange shows runtime error when range is invalid
	{
		if( NULL != ppage )
			*ppage = sheet.GetPage();
		if( NULL != psheet )
			*psheet = sheet;
		return true;
	}
	return false;
}
///end WREPLACE_AND_MREPLACE_XF_FIX_ALWAYS_ASSUME_REPLACE_RANGE_IS_ACTIVE_PAGE

/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS

///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
//bool get_worksheet_obj_by_col_uid(const UINT nColUID, WorksheetPage& wkp, Worksheet& wks, Column& col)
bool get_worksheet_obj_by_col_uid(const UINT nObjUID, Page& pg, Datasheet& ds, DataObject& obj)
///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
{
	///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
	/*
	col = (Column)Project.GetObject(nColUID);
	if ( col )
	{
		col.GetParent(wks);
		if ( wks )
			wks.GetParent(wkp);
		return true;
	}
	*/
	obj = Project.GetObject(nObjUID);
	if ( obj )
	{
		obj.GetParent(ds);
		if ( ds )
			pg = ds.GetPage();
		return true;
	}
	///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
	return false;
}

bool smart_update_obj_range( string& strObjName, ObjNameInfo& info )
{
	if ( INSERT_MODE_INDEX == info.nInsertMode )
	{
		///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
		/*
		OriginObject obj;
		switch (info.nObjLevel)
		{
		case PTL_PAGE:
			obj = info.wkp;
			break;
		case PTL_LAYER:
			obj = info.wks;
			break;
		case PTL_OBJ:
			obj = info.col;
			break;
		}
		obj.GetRangeString(strObjName, NTYPE_INDEX);
		*/
		OriginObject objTmp;
		switch (info.nObjLevel)
		{
		case PTL_PAGE:
			objTmp = info.pg;
			break;
		case PTL_LAYER:
			//objTmp = info.ds;
			if(info.layer)
				info.layer.GetRangeString(strObjName, NTYPE_INDEX);
			break;
		case PTL_OBJ:
			objTmp = info.obj;
			break;
		}
		if( objTmp )
		{
			///------ Folger 04/27/2012 ORG-5566-P1 FAILED_TO_INSERT_ROW_RANGE_FROM_COLUMN_BROWSER_IF_INSERT_MODE_AS_COLUMN_INDEX
			string strRowRange;
			if ( ']' == strObjName[strObjName.GetLength()-1] )
			{
				int nn = strObjName.ReverseFind('[');
				if ( nn > 0 )
				{
					strRowRange = strObjName.Mid(nn);
				}
				else
				{
					ASSERT(false);
				}
			}
			///------ End FAILED_TO_INSERT_ROW_RANGE_FROM_COLUMN_BROWSER_IF_INSERT_MODE_AS_COLUMN_INDEX
			objTmp.GetRangeString(strObjName, NTYPE_INDEX);
			strObjName += strRowRange; ///------ Folger 04/27/2012 ORG-5566-P1 FAILED_TO_INSERT_ROW_RANGE_FROM_COLUMN_BROWSER_IF_INSERT_MODE_AS_COLUMN_INDEX
		}
		///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
	}
	///Sophy 9/15/2009 SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE
	//if ( info.bFullRange || PTL_PAGE == info.nObjLevel )
	//{
		//return true;
	//}
	if ( info.bFullRange )
		return true;
	///end SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE
	// In brief, remove the book name if the two book are the same, remove the book & sheet name if the two sheet are the same.
	///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
	/*
	WorksheetPage wkpSelected;
	Worksheet wksSelected;
	Column colSelected;
	if ( !get_worksheet_obj_by_col_uid(info.nSelectedColUID, wkpSelected, wksSelected, colSelected) )
	{
		return false;
	}
	if ( info.wkp && wkpSelected && 0 == info.wkp.GetName().CompareNoCase(wkpSelected.GetName()) )
	*/
	Page pgSelected;
	Datasheet dsSelected;
	DataObject objSelected;
	if ( !get_worksheet_obj_by_col_uid(info.nSelectedObjUID, pgSelected, dsSelected, objSelected) )
	{
		return false;
	}
	if ( info.pg && pgSelected && 0 == info.pg.GetName().CompareNoCase(pgSelected.GetName()) )
	///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
	{
		// The user selected the same book with the target book
		///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
		//bool bSameSheet = is_same_layer(info.wks, wksSelected);
		bool bSameSheet = is_same_layer(info.layer, dsSelected);
		///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
		// Trim the obj name, depends on whether we have the same book/sheet
		int nNameEnd = -1;
		if ( bSameSheet )
		{
			// Remove book and sheet name
			///Sophy 9/15/2009 SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE
			//nNameEnd = strObjName.Find('!');
			if ( info.dwSmartCtrl & SMART_INFO_VAR )
				strObjName = "%H";
			else
				nNameEnd = strObjName.Find('!');
			///end SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE
		}
		else
		{
			// Remove the book name
			///Sophy 9/15/2009 SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE
			if ( info.dwSmartCtrl & SMART_RANGE_VAR )
			{
				///Sophy 9/18/2009 SMART_PAGE_FAIL_TO_SOLVE_RANGE_WHEN_SHEETNAME_HAS_WHITE_SPACE_AND_COLUMN_HAS_LONGNAME
				//trim column long name
				if ( info.dwSmartCtrl & SMART_TRIM_CLN )
				{
					///------ Folger 08/14/2012 ORG-6076-P14 COL_GET_RANGE_STRING_FOR_LN_SHOULD_BE_QUOTED
					//int nSheetEnd = strObjName.Find('!');
					int nSheetEnd = find_exposed_char_pos(strObjName, '!');
					///------ End COL_GET_RANGE_STRING_FOR_LN_SHOULD_BE_QUOTED
					if ( nSheetEnd > 0 )
					{
						///------ Folger 08/14/2012 ORG-6076-P14 COL_GET_RANGE_STRING_FOR_LN_SHOULD_BE_QUOTED
						//int nBeginLN = strObjName.Find('\"', nSheetEnd + 1);
						int nBeginLN = find_exposed_char_pos((LPCSTR)strObjName + nSheetEnd + 1, '\"');
						///------ End  COL_GET_RANGE_STRING_FOR_LN_SHOULD_BE_QUOTED
						if ( nBeginLN > 0 )
						{
							///------ Folger 08/14/2012 ORG-6076-P14 COL_GET_RANGE_STRING_FOR_LN_SHOULD_BE_QUOTED
							//strObjName = strObjName.Left(nBeginLN);
							///------ Tony 09/17/2012 ORG-6816-P1 TRIM_COLUMN_LONG_NAME_BUT_ROWS
							string strObjNameEnd;
							int nEndLN = find_exposed_char_pos((LPCSTR)strObjName + nSheetEnd + 1 + nBeginLN + 1, '\"');
							strObjNameEnd = strObjName.Right(strObjName.GetLength() - nSheetEnd - 1 - nBeginLN - 1 - nEndLN - 1);
							///------ End TRIM_COLUMN_LONG_NAME_BUT_ROWS
							strObjName = strObjName.Left(nSheetEnd + nBeginLN + 1);
							strObjName += strObjNameEnd;		///------ Tony 09/17/2012 ORG-6816-P1 TRIM_COLUMN_LONG_NAME_BUT_ROWS
							///------ End COL_GET_RANGE_STRING_FOR_LN_SHOULD_BE_QUOTED
						}
					}
				}
				///end SMART_PAGE_FAIL_TO_SOLVE_RANGE_WHEN_SHEETNAME_HAS_WHITE_SPACE_AND_COLUMN_HAS_LONGNAME
				nNameEnd = strObjName.Find(']');
			}
			else
			{
				int nRightBrc = strObjName.Find(']');
				strObjName = "[%H]" + strObjName.Right(strObjName.GetLength() - nRightBrc - 1);
			}
			///end SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE
		}
		if ( nNameEnd >= 0 )
		{
			strObjName = strObjName.Right(strObjName.GetLength() - nNameEnd - 1);
		}
	}
	return true;
}
/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS

///---Sim 02-09-2011 ORG-2182 NLFIT_MOVE_SETTINGS_FIND_XY
bool check_calibration_findxy_branch(TreeNode trCalibration, TreeNode trFindXYOutput)
{
	if ( !trCalibration || !trCalibration.IsValid() )
		return false;
	if ( !trFindXYOutput || !trFindXYOutput.IsValid() )
		return false;
	
	TreeNode trBranch1 = trCalibration.Custom2;
	TreeNode trBranch2 = trCalibration.Custom3;
	
	if ( (trBranch1 && trBranch1.Use) || (trBranch2 && trBranch2.Use) )
	{
		trFindXYOutput.Enable = true;
		trFindXYOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
	}
	else
	{
		trFindXYOutput.Enable = false;
		trFindXYOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_KEEP_SIZE_ON_COLLAPSE);
	}
	
	return true;
}
///---END ORG-2182 NLFIT_MOVE_SETTINGS_FIND_XY

/// Iris 2/15/2011 ORG-402 PLOT_SURFACE_FIT_DATA_FROM_VIRTUAL_MATRIX
int get_surface_plot_id(const TreeNode& trSurfacePlotType)
{
	/// Iris 8/24/2012 ORG-5481-P3 CHANGE_SURFACE_PLOT_TYPE_LIST_FOR_GL
	//if( trSurfacePlotType )
	if( trSurfacePlotType && -1 != trSurfacePlotType.nVal )
	///End CHANGE_SURFACE_PLOT_TYPE_LIST_FOR_GL
	{
		ASSERT( trSurfacePlotType.DataID == IDE_XYZ_FIT_PLOT_TYPE_IDS );	
		string strPlotIDs;
		if( trSurfacePlotType.GetAttribute(STR_SURFACE_PLOT_TYPE_IDS_ATTRIB, strPlotIDs) )
		{				
			string strPlotID = strPlotIDs.GetToken( trSurfacePlotType.nVal, '|' );
			ASSERT( !strPlotID.IsEmpty() );
			
			if( !strPlotID.IsEmpty() )
				return atoi( strPlotID );
		}	
	}	
	return IDM_PLOT_TRI_CONTOUR; // original plot type - xyz contour
}

/// Iris 3/04/2011 ORG-402-S7 NEED_SHOW_SURFACE_PLOT_TYPE_COMBO_IN_OLD_OPJ
bool set_surface_plot_id(TreeNode& trSurfacePlotType, int nPlotID)
{
	if( trSurfacePlotType )
	{
		string strPlotIDs;
		if( trSurfacePlotType.GetAttribute(STR_SURFACE_PLOT_TYPE_IDS_ATTRIB, strPlotIDs) )
		{
			vector vPlotIDs;
			strPlotIDs.GetTokens(vPlotIDs, '|');
			
			vector<uint> vn;
			if( vPlotIDs.Find(MATREPL_TEST_EQUAL, nPlotID, vn) > 0 )			
			{
				trSurfacePlotType.nVal = vn[0];
				return true;
			}	
			/// Iris 8/24/2012 ORG-5481-P3 CHANGE_SURFACE_PLOT_TYPE_LIST_FOR_GL
			else if( IDM_PLOT_TRI_CONTOUR == nPlotID || IDM_PLOT_CONTOUR == nPlotID )
			{
				trSurfacePlotType.nVal = vPlotIDs.GetSize() - 1;
				return true;
			}	
			///End CHANGE_SURFACE_PLOT_TYPE_LIST_FOR_GL
		}		
	}	
	return false;
}
///End NEED_SHOW_SURFACE_PLOT_TYPE_COMBO_IN_OLD_OPJ

/// Iris 3/30/2011 ORG-2539-P1 FIX_NLBEGINZ_BAD_FITCURVE_IN_REPORT_GRAPH
void init_surface_plot_id(const TreeNode& trSurfacePlotType, DataRange& drSource)
{	
	if( trSurfacePlotType && trSurfacePlotType.nVal == -1 ) // to init Surface Plot Type wht the plot type of source graph	
	{		
		vector<uint> vUID;
		if( drSource.GetPlots(vUID) > 0 ) 
		{
			DataPlot dpSource;
			dpSource = Project.GetObject(vUID[0]);
			if( dpSource && (IDM_PLOT_CONTOUR == dpSource.GetPlotType() || IDM_PLOT_TRI_CONTOUR == dpSource.GetPlotType()) )
			{
				/// Iris 4/28/2012 ORG-5481-P4 TO_FIX_SURFACE_PLOT_TYPE_IS_EMPTY_WHEN_INPUT_DATA_FROM_CONTOUR_GRAPH
				//set_surface_plot_id(trSurfacePlotType, IDM_PLOT_CONTOUR);
				set_surface_plot_id(trSurfacePlotType, dpSource.GetPlotType());
				///End TO_FIX_SURFACE_PLOT_TYPE_IS_EMPTY_WHEN_INPUT_DATA_FROM_CONTOUR_GRAPH
			}
			else
			{
				trSurfacePlotType.nVal = 0;
			}
		}	
	}
}
///End FIX_NLBEGINZ_BAD_FITCURVE_IN_REPORT_GRAPH

///End PLOT_SURFACE_FIT_DATA_FROM_VIRTUAL_MATRIX
static void _enable_control_with_value(TreeNode& trGUI, const vector<int>& vnNodeIDs, const vector<int>& vnDefaultValues, bool bEnable)
{
	for(int nn = 0; nn < vnNodeIDs.GetSize(); nn++)
	{
		TreeNode trN = tree_get_node_by_dataid(trGUI, vnNodeIDs[nn], true);
		ASSERT(trN.IsValid());
		
		if( trN.IsValid() )
		{
			trN.Enable = bEnable;
			if( !bEnable )
			{
				trN.SetAttribute(STR_CHANGED_ATTRIB, tree_is_true(trN));				
				tree_set_value(trN, 0); 
			}
			else
			{
				int nOldVal;				
				tree_set_value(trN, trN.GetAttribute(STR_CHANGED_ATTRIB, nOldVal) ? nOldVal : vnDefaultValues[nn]);
			}
		}
	}
}

bool is_change_parameter(TreeNode& trGUI)
{
	if( trGUI )
	{
		int nExecMode = -1;
		if( trGUI.GetAttribute(STR_EXEC_MODE_ATTRIB, nExecMode) )
			return OEXEM_ON_CHANGEPARAM == nExecMode;
	}
	return false;
}

bool report_to_flat_sheet_check_event(TreeNode& trGUI, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	/// Iris 8/17/2011 ORG-3553-P1 FIX_STATS_ON_COL_THEME_BUG
	/*
	int nExecMode = -1;
	trGUI.GetAttribute(STR_EXEC_MODE_ATTRIB, nExecMode);	
	trNode.Enable = OEXEM_ON_CHANGEPARAM != nExecMode;
	
	TreeNode trGraphArrangement = trGUI.Output.PlotSettings;
	TreeNode trCreate = trGUI.Output.Create;
	TreeNode trPlots = trGUI.Plots;
	TreeNode trExVal = trGUI.Quantities.ExVal;
	
	bool bFlatReport = trNode.nVal;
	
	trGraphArrangement.GraphNumCols.Enable = !bFlatReport;
	*/	
	bool bIsChangeParam = is_change_parameter(trGUI);
	trNode.Enable = !bIsChangeParam;
	if( bIsChangeParam )
		return true;	

	bool bFlatReport = trNode.nVal;
	
	TreeNode trGraphArrangement = trGUI.Output.PlotSettings;
	TreeNode trGraphNumCols = trGraphArrangement.GraphNumCols;
	bool bOldIsFlatReport = !trGraphNumCols.Enable;
	
	if( bOldIsFlatReport != bFlatReport )
	{	
		trGraphNumCols.Enable = !bFlatReport;
	///End FIX_STATS_ON_COL_THEME_BUG
		trGraphArrangement.PlotInOneGraph.Enable = !bFlatReport;
		
		vector<int> vnNodeIDs = {IDE_EXTREME_VALUES, 
								IDE_REPORT_NOTES, IDE_REPORT_INPUT_TABLE, IDE_REPORT_MASKED_DATA_TABLE, IDE_REPORT_MISSING_DATA_TABLE,							
								IDE_RESULT_GRAPHS};// keep this as the end
		vnNodeIDs.Add(IDE_RESULT_GRAPHS+1);		
		
		vector<int> vnDefaultValues = {0, 
								1, 1, 0, 0,
								0, 0};
		_enable_control_with_value(trGUI, vnNodeIDs, vnDefaultValues, !bFlatReport);
	} /// Iris 8/17/2011 ORG-3553-P1 FIX_STATS_ON_COL_THEME_BUG
	
	return true;
}
///Junon 10/08/2012 ORG-6359 PROBLEMS_WHEN_SHRINKING_MATRIX_SHEET_WITH_MULTIPLE_OBJECTS_AND_OUTPUT_IS_<INPUT>
BOOL xf_is_matrix_obj_output_allowed(TreeNode& trInput, TreeNode& trOutput)
{
	if(!trInput&&!trOutput)
		return true;
	int nType = okutil_cvt_str_to_predefined_type(trOutput.strVal);
	if( PDS_NEW == nType )
		return true;
	
	MatrixObject moInput;
	okxf_resolve_string_get_origin_object(trInput.strVal, &moInput);
	MatrixLayer mlInput;
	ASSERT( moInput );
	moInput.GetParent(mlInput);
	
	int nNumMatrixObjects = mlInput.MatrixObjects.Count();
	if(PDS_INPUT == nType )
		return nNumMatrixObjects <= 1;
	
	if ( PDS_USER == nType )
	{	
		MatrixObject moOupt;
		okxf_resolve_string_get_origin_object(trOutput.strVal, &moOupt);
	
		string strPage,strLayer,strObject;
		okutil_parse_complete_range_string(trOutput.strVal, &strPage, &strLayer, &strObject);
		
		if ( strPage.IsEmpty() && strLayer.IsEmpty() )
		{
			return moInput == moOupt && nNumMatrixObjects <= 1;
		}
		
		MatrixLayer mlOupt;
		okxf_resolve_string_get_origin_object(okutil_make_book_sheet_string(strPage, strLayer), &mlOupt);
		
		if ( !mlOupt )
			return true;
		
		if ( mlInput == mlOupt )
		{
			return moInput == moOupt && nNumMatrixObjects <= 1;
		}
		
		return moOupt && mlOupt.MatrixObjects.Count() <= 1;
	}
	
	return true;
}
///End PROBLEMS_WHEN_SHRINKING_MATRIX_SHEET_WITH_MULTIPLE_OBJECTS_AND_OUTPUT_IS_<INPUT>

///Philip 08/15/2012 ORG-6114-S1 ADD_NORMALIZE2_0_100_OPTION_FOR_NORMALIZE_TOOL
bool update_method_int_map(const vector<string>& vsNewIntMap, TreeNode& trGetN)
{
	TreeNode trMethod = trGetN.method;
	if(!trMethod)
		return false;
	
	//update method-int map
	string strIntMap;
	strIntMap.SetTokens(vsNewIntMap, '|');
	
	trMethod.SetAttribute(STR_INTMAP_ATTRIB, strIntMap);

	//update method name order in combo box
	string strComboAttr;
	trMethod.GetAttribute(STR_COMBO_ATTRIB, strComboAttr);
	vector<string> vsMethod;
	strComboAttr.GetTokens(vsMethod, '|');
	
	vector<uint> vuNewOrder;
	convert_string_vector_to_uint_vector(vsNewIntMap, vuNewOrder);
	vsMethod.Reorder(vuNewOrder);
	strComboAttr.Empty();
	strComboAttr.SetTokens(vsMethod, '|');
	
	trMethod.SetAttribute(STR_COMBO_ATTRIB, strComboAttr);
	
	return true;
}
///end ADD_NORMALIZE2_0_100_OPTION_FOR_NORMALIZE_TOOL


///Philip 08/28/2012 ORG-6114-S2 ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS
//--- moved from rnomalize.oxf
int normalize_check_err_condition(TreeNode& trGetN, int nNormXF, int method_specify, int method_ref, int method_cell)
{
	if(XF_RNORMALIZE == nNormXF)
	{
		TreeNode	trInput = trGetN.irng;
		Range 		drInput;
		if ( !okxf_resolve_tree_construct_range(&trInput, &drInput) )
			return CER_FFT_GET_INPUT_FAIL;
		vector		vv;
		if ( 0 == drInput.GetNumData() || !drInput.GetData(vv, 0) || 0 == vv.GetSize() )
			return CER_NO_DATA;
	}
	
	int nErr = CER_NO_ERROR;
	if(method_specify == trGetN.method.nVal && trGetN.val.dVal == 0)
		nErr = XFERR_DIVIDED_BY_ZERO;
	
	if ( CER_NO_ERROR == nErr && method_ref == trGetN.method.nVal )
	{
		Column			ccRef;
		if ( !okxf_resolve_string_get_origin_object(trGetN.refcol.strVal, &ccRef) || !ccRef )
			nErr = XFERR_INVALID_COL_RANGE;
	}
	
	if ( CER_NO_ERROR == nErr && method_cell == trGetN.method.nVal )
	{
		DataRange drCell;
		TreeNode trCell = trGetN.cell;
		Worksheet wks;
		int r1, c1, r2, c2;
		if( !okxf_resolve_tree_construct_range(&trCell, &drCell) || !drCell.GetRange(0, r1, c1, r2, c2, wks) )
		{
			nErr = XFERR_INVALID_RANGE;
		}
		if( CER_NO_ERROR == nErr && (r1 != r2 || c1 != c2) )
		{
			nErr = CER_NOT_ONE_CELL;
		}
	}
	
	if(CER_NO_ERROR == nErr && XF_RNORMALIZE == nNormXF)
	{
		string strOutRng = trGetN.orng.strVal;
		if ( strOutRng.GetLength() < 5 )
			nErr = CER_INVALID_OUT_RANGE;
	}

	return nErr;
}

double normalize_get_ref_cell_value(const DataRange& drCell, const int nRowIndex/*= -1*/)
{
	if ( !drCell || drCell.IsEmpty() )
		return NANUM;
	
	int c1, c2, r2;
	Datasheet ds;
	drCell.GetRange(0, nRowIndex, c1, r2, c2, ds);
	vector vec;
	drCell.GetData(&vec, 0);
	return vec.GetSize() > 0 ? vec[0] : NANUM;
}

void normalize_check_reset_ref_range(TreeNode& trRange, int nCurrentMethod, int nCheckMethod, LPCSTR lpcszOldValAttribte)
{
	if( nCurrentMethod == nCheckMethod )
	{
		string str;
		if( trRange.GetAttribute(lpcszOldValAttribte, str) )
			trRange.strVal = str;
	}
	else
		trRange.strVal = STR_OPTIONAL;
}

void normalize_check_update_old_ref_range_attrib(TreeNode& trGetN)
{
	if ( PDS_OPTIONAL != okutil_cvt_str_to_predefined_type(trGetN.refcol.strVal) )
		trGetN.refcol.SetAttribute(STR_REF_COL_OLD_VAL, trGetN.refcol.strVal);
	if ( PDS_OPTIONAL != okutil_cvt_str_to_predefined_type(trGetN.cell.strVal) )
		trGetN.cell.SetAttribute(STR_REF_CELL_OLD_VAL, trGetN.cell.strVal);
}
///end ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS