/*----------------------------------------------------------------------------------*
 * File Name: digitizer_utils.h														*
 * Creation: 																		*
 * Purpose: OriginC Header file														*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011	*
 * All Rights Reserved																*
 * 																					*
 * Modification Log:																*
 *	Rex 10/18/2011 RSRCH-72 DIGITIZER_AUTO_TRACE_LINE_FUNCTIONS						*
 *	Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE						*
 *	Rex 2/1/2012 ORG-4794-S4 IMPROVE_DIGITIZER_CURVE_DETECT							*
 *	Rex 2012/4/9 ORG-5112-P2 ROTATE_IMAGE_WITH_OPENCV 								*
 *	Rex 2012/4/13 ORG-5112 FIX_UPDATE_IMAGE_TO_GRAPHOBJECT							*
 *	Rex 2012/7/11 ORG-5112-P5 FIND_BETTER_TRACE_START_POINT_IN_NEIGHBORHOOD			*
 *----------------------------------------------------------------------------------*/
 
#ifndef _DIGITIZER_UTILS_H
#define _DIGITIZER_UTILS_H

#include <image_utils.h>	///----- Rex 2012/4/9 ORG-5112-P2 ROTATE_IMAGE_WITH_OPENCV
#include <..\Originlab\GraphObjTools.h>

#define		STR_IMAGE_NAME				"Digitize"
#define		STR_SETTINGS_STORAGE		STR_IMAGE_NAME
/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
#define		NUM_VERTEXS					3 
///End SUPPORT_TERNARY_IN_DIGITIZER

#define		ID_DIGITIZER_MSG_UPDATE_INFO					0x1000
#define		ID_DIGITIZER_MSG_UPDATE_INFO_SELECTION			0x1001
#define		ID_DIGITIZER_MSG_UPDATE_FROM_POINTS				0x1004
#define		ID_DIGITIZER_MSG_CHECK_ENABLE_DIGITIZE			0x1007
#define 	ID_DIGITIZER_MSG_UPDATE_PLOT_SELECTION			0x1008 /// Iris 12/20/2011 ORG-1614-S3 SUPPORT_PLOT_SELECTION_BY_OBJ_AND_ROW_IN_DATA_GRID
#define		ID_DIGITIZER_MSG_CHECK_SET_ACTIVE_PLOT			0x1009 /// Iris 12/29/2011 ORG-4685-P2 FIX_REOPEN_DLG_DATA_PLOT_SELECTION_PROBLEM
#define		ID_DIGITIZER_MSG_DO_DIGITIZE_AREA_CALA			0x100A /// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
#define		ID_DIGITIZER_MSG_DO_DELETE_POINTS				0x100B /// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
#define 	ID_DIGITIZER_MSG_VERTEX_UPDATE					0x100C /// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER

struct CurveInfo
{
	vector<string> 		vsDataPoints;
	vector<string> 		vsColor;
	vector<string>		vsShow;
};

struct	DigitizerCoordinates
{
	double		value;
	int			nx;
	int			ny;
	int			color;
};

/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
struct 	DigitizerTernaryCoordinates
{
	int			nx;
	int			ny;
	int 		nColor;
	
	double		dValX;
	double		dValY;
	double		dValZ;	
};
///End SUPPORT_TERNARY_IN_DIGITIZER

struct DigitizerAxisData
{
	int					nScaleType;
	int					nColor;

	int					nFormat;
	int					nSubFormat;
	string				strCustomDisplay;
};

enum IMPLDATA
{
	IMPLDATA_INVALID	= -1,

	IMPLDATA_X1			= 0,
	IMPLDATA_X2,
	IMPLDATA_Y1,
	IMPLDATA_Y2,
	IMPLDATA_XREF,
	IMPLDATA_YREF,
	
	IMPLDATA_TOTAL,
};

struct DigiROIGridInfo
{
	bool	bGrid;
	bool	bVertical;
	int 	nStep;		
};
/*------------------------------------------------------------------------------*
 * DigitizerImplData	 														*
 *------------------------------------------------------------------------------*/

struct	DigitizerImplData
{
public:
	DigitizerImplData();

	void	Init(BOOL bKeppGeneralSettings = FALSE);
	BOOL	Size();
	
	int		GetPointHalfSize();

	BOOL	IsReady();
	BOOL	IsXReady();
	BOOL	IsYReady();
	BOOL	IsCoornianteReady(DigitizerCoordinates& coor);	

	string	MakeObjName(LPCSTR lpcsz);
	BOOL	UpdateDataNameByImageFileName(LPCSTR lpcszFile);
	BOOL	UpdateDataNameForClipboardImage();		///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	
	BOOL	UpdateDataNameByNewSheetName(string& strName);		//Tony 8/29/2012 In case too long image name
	BOOL	UpdateDataName(string& strName);

	string	GetValue(DigitizerCoordinates& coor, DigitizerAxisData* pAxisData = NULL);
	string	GetValue(double rValue, DigitizerAxisData* pAxisData = NULL);
	double	GetValue(LPCSTR lpcsz, DigitizerAxisData* pAxisData = NULL);

	BOOL	UpdateX1X2FromY1();
	BOOL	UpdateY1Y2FromX1();

	DWORD	ConvertTabIndex(UINT nTabIndex);
	
	void	PrepareAxesTreeIDs(TreeNode& tr);
	
public:
	DigitizerAxisData		axisX;
	DigitizerAxisData		axisY;

	DigitizerCoordinates	x1;
	DigitizerCoordinates	x2;
	DigitizerCoordinates	y1;
	DigitizerCoordinates	y2;

	/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
	int					nCoordinatesType;
	///End SUPPORT_TERNARY_IN_DIGITIZER
	
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	bool				bDigitizing;	
	bool 				OptimizePoint;	
	int					OptimizeError;
	
	string				strImageMatrixObj;
	string				strImageFile;			
	///End OPTIMIZE_PICKED_POINT
	
	/// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
	bool				bDigitizingArea;
	DigiROIGridInfo		stROIGridInfo;	
	///End MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
	
	/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
	bool				bDeletingPoints;
	///End IMPROVE_DELETE_POINTS
	
	///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE	
	/// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
	//string 				strSrcMatrix;	
	string				strImageMatrix;
	bool				bSrcImageUpdateFlag;
	///End IMPROVE_IMAGE_PROCESS_MATRIX
	//string 			strTraceLineMatrix;
	int					nProcessingBtnID;
	///End DIGITIZER_AUTO_TRACE_LINE
	
	bool				bUndoEnable; /// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
	
	string				strImageName;
	int					nImageWidth, nImageHeight;

	double				rAngleRotated;
	double				rAngleInc;

	vector				PtsScrX;
	vector				PtsScrY;
	vector				PtsX;
	vector				PtsY;
	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	vector<string>		PtsLabel;
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	
	vector				PtsVertexX;
	vector				PtsVertexY;
	
private:
	vector<string>		vsDataPlots;
	vector<string>		vsDataNames;
	vector<OUID>		vsDataUIDs;

	int			nActiveData;
	int			nDataColor;

public:
	int		NewData();	// return data index of the newly added
	void	ClearData();	
	/// Iris 9/03/2012 ORG-5112-P3 FIX_NOT_REMOVE_ALL_DATAPLOTS_WHEN_CLICKED_DELETE_WKS_GRAPH
	//void	ClearAllData();
	void	ClearAllData(bool bClearDataPlot = true);
	///End FIX_NOT_REMOVE_ALL_DATAPLOTS_WHEN_CLICKED_DELETE_WKS_GRAPH
	
	void	PrepareDataForCalculate(BOOL bFromScreenToData = TRUE);
	
	BOOL	AddOneScreenPoint(double x, double y);
	BOOL	AddScreenPoints(const vector& vx, const vector& vy);		///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
	/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
	BOOL	AddOneVertex(double x, double y); 
	BOOL 	IsVertexsReady();
	///End SUPPORT_TERNARY_IN_DIGITIZER
	
	int		GetActiveData();
	BOOL	SetActiveData(int nData);
	BOOL	ActivatePlot();
	int		GetNumData();
	/// Iris 12/29/2011 ORG-4685-S5 SUPPORT_DELETE_LINE
	BOOL	RemoveDataCols(int nData);
	///End SUPPORT_DELETE_LINE
	BOOL	RemoveActiveData(); 
	
	void 	GetAllPlotNames(vector<string>& vsNames); /// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	string	GetPlotName();
	string	GetDataName();
	void	SetDataName(LPCSTR lpcsz);
	void	SetDataName(LPCSTR lpcszBookSheet, LPCSTR lpcszCol);
	
	OUID	GetDataUID();
	void	SetDataUID(OUID uid);
	
	int		GetPlotColor();
	BOOL	SetPlotColor(int nColor);	
	
	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL	GetPlotData(TreeNode& tr);
	BOOL	SetPlotData(TreeNode& tr);
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

public:
	BOOL	IsAxisEditing();
	void	SetAxisEditing(BOOL bOn);

	BOOL	IsX1FromYAxis();
	void	SetX1FromYAxis(BOOL bOn);
	BOOL	IsY1FromXAxis();
	void	SetY1FromXAxis(BOOL bOn);

	BOOL 	IsXRefLineShow();
	void	SetXRefLineShow(BOOL bShow);
	BOOL 	IsYRefLineShow();
	void	SetYRefLineShow(BOOL bShow);
	
	BOOL	IsDlgOpen();
	void	SetDlgOpen(BOOL bOn);

	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	//BOOL	IsRotationMode();
	//void	SetRotationMode(BOOL bOn);
	/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	///End FIX_ROTATE_GETN_DLG_ISSUE

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL	IsLabelEditing();
	void	SetLabelEditing(BOOL bOn);
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	BOOL	IsAxisEditingByOther(DWORD dwBit);
	void	SetAxisEditingByOther(DWORD dwBit, BOOL bOn);
	
	/// Iris 12/26/2011 ORG-4685-S4 CLICKED_NEW_LINE_NEED_START_PICK_POINTS
	//BOOL 	IsActivatePlotByObjectEvent() { return !m_bActivatePlotNotByObjectEvent; }
	BOOL	IsReadyForPlotSelectionEvent() { return m_bIsReadyForPlotSelectionEvent; }
	void 	SetReadyForPlotSelectionEvent(bool bReady) { m_bIsReadyForPlotSelectionEvent = bReady; }
	///End CLICKED_NEW_LINE_NEED_START_PICK_POINTS
	
	void 	SetDeletePointsStatus(bool bDeleting) { bDeletingPoints = bDeleting; }
	bool	IsDeletePointsStatus() { return bDeletingPoints; }

private:
	DWORD					dwCntrls;
	/// Iris 12/26/2011 ORG-4685-S4 CLICKED_NEW_LINE_NEED_START_PICK_POINTS
	//bool					m_bActivatePlotNotByObjectEvent;
	bool					m_bIsReadyForPlotSelectionEvent;
	///End CLICKED_NEW_LINE_NEED_START_PICK_POINTS

private:
	string	EnumName(LPCSTR lpcszName);

	string	DataTimeStr(DigitizerAxisData* pAxisData);
};
/*------------------------------------------------------------------------------*
 * DigitizerImplData End 														*
 *------------------------------------------------------------------------------*/
 
/*------------------------------------------------------------------------------*
 * DigitizerObjsHolder	 														*
 *------------------------------------------------------------------------------*/

class DigitizerObjsHolder
{
public:
	GraphPage	GetDigitizePage();	
	GraphLayer	GetDigitizeLayer();
	void		SetDigitizeLayer(GraphLayer& gl);	
	
	GraphObject	GetDigitizeImage();
	GraphObject	GetDigitizeImageBackup();
	GraphObject GetDigitizeVertex(); /// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER

	BOOL		Refresh();

	BOOL		SetupUndoEvent(GraphObject& go);
	BOOL		SetupDeleteUndoable(GraphObject& go, BOOL bUndo);

	BOOL		SetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double rVal, BOOL bDelay = FALSE);
	BOOL		GetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double& rValue);
	
	GraphPage	PrepareDigitizePage();
	
	BOOL	IsPageValidToDigitize(GraphPage& gp);
	
private:
	string		Template();

private:
	GraphLayer		m_gl;
};
/*------------------------------------------------------------------------------*
 * DigitizerObjsHolder End 														*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 * DigitizerLayerTempChange														*
 *------------------------------------------------------------------------------*/
class DigitizerLayerTempChange
{
public:
	DigitizerLayerTempChange(DigitizerObjsHolder* pObjsHolder, GraphLayer& gl)
	{
		m_pObjsHolder = pObjsHolder;
		m_pObjsHolder->SetDigitizeLayer(gl);
	}
	~DigitizerLayerTempChange()
	{
		GraphLayer	glJunk;
		m_pObjsHolder->SetDigitizeLayer(glJunk);
	}
	
private:
	DigitizerObjsHolder*	m_pObjsHolder;
};

/*------------------------------------------------------------------------------*
 * DigitizerLayerTempChange	End													*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 * ObjsUpdateEventHelper 														*
 *------------------------------------------------------------------------------*/

class ObjsUpdateEventHelper
{
public:
	ObjsUpdateEventHelper();
	~ObjsUpdateEventHelper();

	BOOL	IsDuringUpdate();

private:
	BOOL	m_bOldVal;
};

/*------------------------------------------------------------------------------*
 * ObjsUpdateEventHelper End 													*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 * DigitizerDataPlot		 													*
 *------------------------------------------------------------------------------*/

enum
{
	OBJUPDATE_NONE				= 0,
	OBJUPDATE_RECREATE,
	OBJUPDATE_EXISTING,
};

class DigitizerDataPlot
{
public:
	DigitizerDataPlot(DigitizerImplData* pData, DigitizerObjsHolder* pObjsHolder);
	~DigitizerDataPlot();

	BOOL	NewData();
	BOOL	Delete(int nIndex); /// Iris 12/29/2011 ORG-4685-S5 SUPPORT_DELETE_LINE
	
	BOOL	Clear(BOOL bGrOnly = FALSE);
	
	BOOL	Update(int nUpdate, BOOL bRefresh);

	BOOL	Show(BOOL bShow);
	/// Iris 12/13/2011 IMPROVE_MULTI_LINES_DISPLAY_ALL_AND_WITH_DIFF_COLOR
	BOOL	Activate();
	///End IMPROVE_MULTI_LINES_DISPLAY_ALL_AND_WITH_DIFF_COLOR

	BOOL	AddOnePoint(double x,  double y);
	BOOL	AddPoints(const vector& vx, const vector& vy);		///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
	BOOL	HasDataPoint();
	/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
	//BOOL	DeletePoint(int nIndex);
	BOOL 	DeletePoints(const vector<uint>& vnIndices);
	///End IMPROVE_DELETE_POINTS
	BOOL 	ReorderPoints();
	///End IMPROVE_MULTIPLE_CURVES
	
	BOOL	UpdateStates();
	int		UpdateFromEvents(int nEvent, LPCSTR lpcszName);	
	BOOL	Update(int nEvent);

	BOOL	GetFormat(TreeNode& tr, DWORD dwPropertiesFilter);
	BOOL	ApplyFormat(TreeNode& tr);

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL	Edit(int nIndex);
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	///------ Folger 01/12/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL		UpdateData();
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

private:
	GraphLayer	GetDigitizeLayer();

	BOOL		Refresh();

	GraphObject	Plot(int nUpdate = OBJUPDATE_NONE);

	BOOL		IsAxesEditing();
	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL		IsLabelEditing();
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	DWORD		GetUpdateStates();

	BOOL		IsPlot(LPCSTR lpcszName);
	
private:
	DigitizerImplData*		m_pData;
	DigitizerObjsHolder*	m_pObjsHolder;
};

/*------------------------------------------------------------------------------*
 * DigitizerDataPlot End	 													*
 *------------------------------------------------------------------------------*/
 
 
/*------------------------------------------------------------------------------*
 * DigitizerAxes			 													*
 *------------------------------------------------------------------------------*/

class DigitizerAxes
{
public:
	DigitizerAxes(DigitizerImplData* pData, DigitizerObjsHolder* pObjsHolder);
	~DigitizerAxes();

	BOOL	Update(int nUpdate, LPCSTR lpcszName = NULL, BOOL bRefresh = FALSE);

	int		UpdateFromEvents(int nEvent, LPCSTR lpcszName);

	BOOL	SetPixel(IMPLDATA type, int nValue);

	void	GetNames(vector<string>& vs);
	void	GetColors(vector<uint>& vn);
	void	GetPixels(vector<string>& vs);
	BOOL	GetX0Y0(double& x, double& y);

	BOOL	SetAxisSelection(IMPLDATA type);
	IMPLDATA	GetAxisSelection();

	BOOL	ShowXRefLine(BOOL bShow);
	BOOL	ShowYRefLine(BOOL bShow);
	
	BOOL	ShowAxes(BOOL bShow);
	
private:
	GraphLayer	GetDigitizeLayer();
	
	BOOL		Refresh();

	BOOL		SetupUndoEvent(GraphObject& go);

	BOOL		SetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double rVal);
	BOOL		GetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double& rVal);

	string		MakeObjName(LPCSTR lpcsz);

	BOOL		IsAxesEditing();

	DWORD		GetUpdateStates(int nTabIndex = 0);

	BOOL	CreateCrossLine(GraphObject& line, DigitizerCoordinates& coor, int nColor, LPCSTR lpcszName, BOOL bVertical);

	int		GetPointHalfSize();

	GraphObject		Axis(int nUpdate, LPCSTR lpcszName, DigitizerCoordinates& from, DigitizerCoordinates& to, int nColor, BOOL bVertical, BOOL bSuppress, UINT nTabIndex);

	GraphObject		X(int nUpdate = OBJUPDATE_NONE);	
	GraphObject		Y(int nUpdate = OBJUPDATE_NONE);
	
	BOOL	IsAxis(LPCSTR lpcszName);
	
	BOOL	UpdateFromAxis(int nEvent, LPCSTR lpcszName);
	BOOL	UpdateFromX(int nEvent, LPCSTR lpcszName);
	BOOL	UpdateFromY(int nEvent, LPCSTR lpcszName);
		
	void	GetCoorsFromAxis(DigitizerCoordinates& from, DigitizerCoordinates& to, GraphObject& axis, BOOL bVertical);

	void	GetEndPointsFromLine(double& x0, double& y0, double& x1, double& y1, GraphObject& line);

	GraphObject		AxisEnd(int nUpdate, LPCSTR lpcszName, DigitizerCoordinates& coor, BOOL bVerticalCrossLine, GraphObject* pCrossLine, UINT nTabIndex);

	void	CheckShowAxisEnd(GraphObject& end);

	BOOL	IsAxisEndCrossLine(LPCSTR lpcszName);
	GraphObject		CreateAxisEndCrossLine(int nUpdate, BOOL bVertical, LPCSTR lpcszName, DigitizerCoordinates& coor, UINT nTabIndex);
	BOOL	UpdateFromAxisEndCrossLine(int nEvent, LPCSTR lpcszName);
	BOOL	UpdateFromXFromCrossLine(int nEvent, LPCSTR lpcszName);
	BOOL	UpdateFromXToCrossLine(int nEvent, LPCSTR lpcszName);
	BOOL	UpdateFromYFromCrossLine(int nEvent, LPCSTR lpcszName);
	BOOL	UpdateFromYToCrossLine(int nEvent, LPCSTR lpcszName);
	BOOL	GetCoorsFromCrossLine(DigitizerCoordinates& coor, GraphObject& line, BOOL bVertical);
	
	GraphObject		XFrom(int nUpdate = OBJUPDATE_NONE, LPCSTR lpcszNameToCheck = NULL, GraphObject* pCrossLine = NULL);
	GraphObject		XTo(int nUpdate = OBJUPDATE_NONE, LPCSTR lpcszNameToCheck = NULL, GraphObject* pCrossLine = NULL);
	GraphObject		YFrom(int nUpdate = OBJUPDATE_NONE, LPCSTR lpcszNameToCheck = NULL, GraphObject* pCrossLine = NULL);
	GraphObject		YTo(int nUpdate = OBJUPDATE_NONE, LPCSTR lpcszNameToCheck = NULL, GraphObject* pCrossLine = NULL);
	GraphObject		XFromCrossLine();
	GraphObject		XToCrossLine();
	GraphObject		YFromCrossLine();
	GraphObject		YToCrossLine();
	
	BOOL	UpdateFromAxisEnd(DigitizerCoordinates& coor, GraphObject& end);
	BOOL	UpdateFromXFrom();
	BOOL	UpdateFromXTo();
	BOOL	UpdateFromYFrom();
	BOOL	UpdateFromYTo();
	BOOL	UpdateFromAxesEnd(int nEvent, LPCSTR lpcszName);

	GraphObject		GetAxisObj(IMPLDATA type);
	IMPLDATA		GetAxisType(GraphObject& go);

	///------ Folger 01/06/2011 ORG-1512-S6 DIGITIZER_ADD_LINE_END_SYMBOL_TO_INDICATE_SELECTION
	BOOL			UpdateAxisLineStyle(GraphObject& line, BOOL bSelect);
	///------ End DIGITIZER_ADD_LINE_END_SYMBOL_TO_INDICATE_SELECTION

private:
	DigitizerImplData*		m_pData;
	DigitizerObjsHolder*	m_pObjsHolder;
};

/*------------------------------------------------------------------------------*
 * DigitizerAxes End		 													*
 *------------------------------------------------------------------------------*/
 
 /// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
//class DigitizerTernaryAxes 
//{
//private:
	//DigitizerImplData*		m_pData;
	//DigitizerObjsHolder*	m_pObjsHolder;	
//};

#define STR_VERTEXS_DATA_PLOT_NAME		"DigiVertexs"
class DigitizerTernaryVertexsPoints
{
public:
	DigitizerTernaryVertexsPoints(DigitizerImplData& data, DigitizerObjsHolder& objsHolder) 
	{
		m_pData = &data;
		m_pObjsHolder = &objsHolder;
	}
	~DigitizerTernaryVertexsPoints() {}	
	bool	AddOneVertex(double x, double y);
	bool	UpdateVertexs();
	
private:
	DigitizerImplData*			m_pData;
	DigitizerObjsHolder*		m_pObjsHolder;	
};
///End SUPPORT_TERNARY_IN_DIGITIZER

/*------------------------------------------------------------------------------*
 * DigitizerVisualizer		 													*
 *------------------------------------------------------------------------------*/
class DigitizerVisualizer
{
public:
	DigitizerVisualizer(DigitizerImplData& data, DigitizerObjsHolder& objsHolder);
	~DigitizerVisualizer();
	
	BOOL	IsReadyToDigitize();

	BOOL	UpdateAxes(BOOL bRefresh = FALSE);
	BOOL	UpdateDataPlot(BOOL bRefresh = FALSE);

	BOOL	AddOnePoint(double x,  double y);
	BOOL	AddPoints(const vector& vx, const vector& vy);		///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
	BOOL	HasDataPoint();
	/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
	//BOOL	DeletePoint(int nIndex);
	BOOL	DeletePoints(const vector<uint>& vnIndices);
	///End IMPROVE_DELETE_POINTS
	BOOL	ReorderPoints();
	///End IMPROVE_MULTIPLE_CURVES

	int		UpdateFromEvents(int nEvent, LPCSTR lpcszName);
	BOOL	UpdateFromPlot(int nEvent);
	
	BOOL	NewData();
	BOOL	RemoveActiveData(); /// Iris 12/29/2011 ORG-4685-S5 SUPPORT_DELETE_LINE
	BOOL	ClearDataPlot(); 
	BOOL	ClearAllDataPlots(); /// Iris 9/03/2012 ORG-5112-P3 FIX_NOT_REMOVE_ALL_DATAPLOTS_WHEN_CLICKED_DELETE_WKS_GRAPH

	BOOL	SetAxesEditing(BOOL bOn);
	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL	SetLabelEditing(BOOL bOn);
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	BOOL	UpdateStates();

	BOOL	SetAxisSelection(IMPLDATA type);
	IMPLDATA	GetAxisSelection();

	BOOL	SetAxisPixel(IMPLDATA type, int nValue);
	void	GetAxesNames(vector<string>& vs);
	void	GetAxesColors(vector<uint>& vn);
	void	GetAxesPixels(vector<string>& vs);
	BOOL	GetX0Y0(double& x, double& y);

	BOOL	ShowXRefLine(BOOL bShow);
	BOOL	ShowYRefLine(BOOL bShow);

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL	DataPlotEdit(int nIndex);
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	BOOL	UpdatePlotData();
	///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

	/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
	BOOL	ShowAxes(BOOL bShow);
	BOOL	ShowVertexs(BOOL bShow);
	///End SUPPORT_TERNARY_IN_DIGITIZER
	
private:
	DigitizerDataPlot*			Plot();
	DigitizerAxes*				Axes();
	
private:
	DigitizerImplData*			m_pData;
	DigitizerObjsHolder*		m_pObjsHolder;
	
	DigitizerDataPlot*			m_pPlot;
	DigitizerAxes*				m_pAxes;
};
/*------------------------------------------------------------------------------*
 * DigitizerVisualizer End	 													*
 *------------------------------------------------------------------------------*/
 
/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
///*------------------------------------------------------------------------------*
 //* DigitizerRotationHelper  													*
 //*------------------------------------------------------------------------------*/
//class DigitizerRotationHelper
//{
//public:
	//DigitizerRotationHelper(DigitizerImplData& data, HWND hWnd);
	//~DigitizerRotationHelper();
	//
	//BOOL	Update(BOOL bOn);
//
//private:
	//BOOL	OpenDlg(TreeNode& tr);
//
	//void	GetSettings(TreeNode& tr);
	//void	SetSettings(TreeNode& tr);
//
//private:
	//DigitizerImplData*		m_pData;
	//HWND					m_hWnd;
//};
///*------------------------------------------------------------------------------*
 //* DigitizerRotationHelper End 													*
 //*------------------------------------------------------------------------------*/
///End FIX_ROTATE_GETN_DLG_ISSUE

/*------------------------------------------------------------------------------*
 * DigitizerOptionsHelper	 													*
 *------------------------------------------------------------------------------*/
class DigitizerOptionsHelper
{
public:
	DigitizerOptionsHelper(DigitizerImplData& data, HWND hWnd);
	~DigitizerOptionsHelper();
	
	BOOL	Update();
	BOOL	Update(TreeNode& tr, DWORD dwCntrl = 0);

private:
	void	SetSettings(TreeNode& tr, DWORD dwCntrl);	
	void	GetSettings(TreeNode& tr);

	string	DataList();

	///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
	string	GetDataName();
	///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
	
private:
	DigitizerImplData*		m_pData;
	HWND					m_hWnd;

	///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
	string					m_strCol;
	///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
};
/*------------------------------------------------------------------------------*
 * DigitizerOptionsHelper End 													*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* LocatePoints				 													*
 *------------------------------------------------------------------------------*/
class LocatePoints
{
public:
	LocatePoints(WndContainer& Dlg, BOOL bHideParent = FALSE);
	~LocatePoints();

	BOOL	GetOne(TreeNode& trNode);
	BOOL	GetVertexs(vector& vx, vector& vy, int nNumPoints = NUM_VERTEXS);
	BOOL	GetMultiple(vector& vx, vector& vy);
	
	BOOL	GetTraceLine(vector& vx, vector& vy);			///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
	BOOL	GetDigitizeAreaStartPoint(vector& vx, vector& vy); /// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	
private:
	BOOL	Refresh();

private:
	Window			m_wnd;
	WndContainer*	m_pDlg;
	Window			m_wndParent;
	BOOL			m_bWndOldEnable;
	LTVarTempChange*	m_pDRP;
};
/*------------------------------------------------------------------------------*
* LocatePoints End			 													*
 *------------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------*
* DigitizerImageHelper		 													*
 *------------------------------------------------------------------------------*/ 

class DigitizerImageHelper
{
public:
	DigitizerImageHelper(DigitizerImplData& data, DigitizerObjsHolder& objsHolder);
	~DigitizerImageHelper();

	BOOL	Import();
	BOOL	ImportFromClipboard();		///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	bool 	GetImageROI(pBITMAPHANDLE &pLBROI, int x, int y, int nROIPercent); /// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	BOOL	SaveImageBITMAPHANDLE(bool bImageChanged = false);
	bool	ResetImage(GraphObject& goImage);
	///End FIX_ROTATE_GETN_DLG_ISSUE
	
private:
	string	GetImageFile();
	
	GraphPage	GetDigitizePage();
	GraphLayer	GetDigitizeLayer();
	GraphObject	GetDigitizeImage();

	BOOL		SetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double rVal, BOOL bDelay = FALSE);
	
	BOOL	ImportImage(LPCSTR lpcszFileName);
	
	BOOL	SetupImage();

	BOOL	FitLayerToPage();
	BOOL	FitImageToPage();
	
	BOOL	SetImageNoSelect();

	BOOL	UpdateDataNameByImageFileName(LPCSTR lpcszFile);
	///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	BOOL	UpdateDataNameForClipboardImage();		
	//BOOL	UpdatePageLongName(LPCSTR lpcszFile);
	BOOL	UpdatePageLongName();
	///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	BOOL	UpdateAxesDefault();
	
	BOOL	PrepareImageBackup(LPCSTR lpcszFileName);
	
	BOOL	PrepareImageBackup();		///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	
	BOOL	ImportImageIntoActiveLayer(LPCSTR lpcszFileName);
	
	BOOL	SetupImageExecScript();
	
	///------ Folger 08/03/2011 ORG-3412-P1 DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO
	BOOL	UpdateImageSize();
	///------ End DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO
	
	bool	addDataMarker(pBITMAPHANDLE pLBROI, int nMarkerSize, int x, int y); /// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	//BOOL	getImageBITMAPHANDLE(bool bImageChanged); /// Iris 12/27/2011 ORG-4685-S3 NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE
	///End FIX_ROTATE_GETN_DLG_ISSUE
	
private:
	DigitizerImplData*		m_pData;
	DigitizerObjsHolder*	m_pObjsHolder;	
	BITMAPHANDLE 			m_LBImage; /// Iris 12/27/2011 ORG-4685-S3 NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE
};
/*------------------------------------------------------------------------------*
* DigitizerImageHelper End	 													*
 *------------------------------------------------------------------------------*/ 


/*------------------------------------------------------------------------------*
* DigitizerRunner			 													*
 *------------------------------------------------------------------------------*/ 

class DigitizerRunner
{
public:
	DigitizerRunner(DigitizerImplData& data);

	int		Run(Dialog& dlg);
	
	BOOL	Calculate();
	BOOL	CalculateOnePoint(double& x, double& y);
	///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	BOOL	AntiCalculate();
	///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	bool 	PrepareImageMatrix();
	void 	DestroyImageMatrix();
	bool 	OptimizePoint(double& x,  double& y);
	///End OPTIMIZE_PICKED_POINT
	
	///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
	/// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED
	//bool	GetImageProcessMatrix(MatrixObject& mobjSrcImage, bool bCreate = true);
	/// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
	//bool	GetImageProcessMatrix(MatrixObject& mobjSrcImage, bool bRefreshImage = false);
	bool	GetImageProcessMatrix(MatrixObject& moImage);
	bool 	CheckGetMatrixObject(const MatrixObject& moCurrent, MatrixObject& mo, LPCSTR lpcszName);
	///End IMPROVE_IMAGE_PROCESS_MATRIX
	///End IMPROVE_DIGITIZER_AREA_SPEED	
	
	bool	BackupImageMatrix();
	bool	Undo(GraphObject& goImage);
	
	bool 	PrepareMatrixForTraceLine();
	void 	DestroyTraceLineMatrix();	
	int		RunTraceLine(Dialog& dlg);	
	bool	BeforeAutoTraceLine(double& x,  double& y); /// Iris 9/03/2012 ORG-5112-P5 TO_FIND_GOOD_START_POINT_FOR_AUTO_TRACE_LINE
	bool 	AutoTraceLine(double& x,  double& y, vector& vx, vector& vy);			
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	//BOOL	DigitizeArea(vector& vx, vector& vy);
	BOOL	DigitizeArea(double x, double y, double width, double height, int angle, int step, vector& vx, vector& vy);	
	bool	PrepareMatrixForDigitizeArea();
	void 	DestroyDigitizeAreaMatrix();
	
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	BOOL	ClearBackground(GraphObject& goImage);
	BOOL	RemoveGridLine(GraphObject& goImage);
	bool	UpdateImage(GraphObject& goImage, const MatrixObject& mobj);	
	///End DIGITIZER_AUTO_TRACE_LINE
	bool	UpdateCurrent(GraphObject& goImage); /// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
	
private:
	BOOL	Calculate(vector& vx, vector& vy, BOOL bReverse = FALSE);
	
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT		
	bool convertXYToColRow(const MatrixObject& mobj, double x, double y, int& nCol, int& nRow);
	///End OPTIMIZE_PICKED_POINT
	
private:
	DigitizerImplData*		m_pData;
};
/*------------------------------------------------------------------------------*
* DigitizerRunner End		 													*
 *------------------------------------------------------------------------------*/
 

/*------------------------------------------------------------------------------*
* DigitizerDataDumpingHelper 													*
*------------------------------------------------------------------------------*/
class DigitizerDataDumpingHelper
{
public:
	DigitizerDataDumpingHelper(DigitizerImplData& data, HWND hWnd);
	~DigitizerDataDumpingHelper();

	BOOL	Dump(BOOL bPlot = FALSE);

	BOOL	Go();

	BOOL	GoToGraph();

	BOOL	Clear();

	///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	BOOL	CheckUpdateDataFromOutput(DatasetObject& dsObj);
	///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	
	/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
	//BOOL	DeletePoint(int nIndex);
	BOOL	DeletePoints(const vector<uint>& vnIndices);
	///End IMPROVE_DELETE_POINTS
	BOOL	ReorderPoints();
	
	BOOL	UpdateActiveData(); /// Iris 2/20/2012 FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
	
private:
	BOOL	PrepareAll(BOOL bCreate = TRUE);
	
	BOOL	ParseRange(string& strBook, string& strSheet, string& strCol);

	BOOL	PrepareWorksheet(LPCSTR lpcszBook, LPCSTR lpcszSheet, BOOL bCreate = TRUE);
	BOOL	PrepareColumns(LPCSTR lpcszCol);
	void	PrepareColumnFormat(Column& col, DigitizerAxisData* pAxisData);

	BOOL	DumpImpl(BOOL bPlot);

	int		CheckGetLabelRow();
	
	BOOL	MakePlot();

	XYRange	PlotRange();
	
	GraphLayer	GetDigitizerPlotLayer(XYRange& xy, BOOL bCreate = TRUE);
	
	BOOL	UpdateLayerScaleType(GraphLayer& gl);

	BOOL	UpdateDataNameByNewSheetName(string &strNewSheetName);		//Tony 8/29/2012 In case too long image name
	///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	BOOL	UpdateLabels();
	
	BOOL	Rescale(GraphLayer& gl);
	
	string		GetDataName();
	DWORD		GetPageCreateOptions();

	///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	void		GetLabelColumn();
	///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
	void		GetYColumn(LPCSTR lpcszCol);
	///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID

	///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	BOOL	IsOutput(DatasetObject& dsObj);
	///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

	BOOL	ReorderCurrentLine(); /// Iris 2/20/2012 FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
	
private:
	DigitizerImplData*		m_pData;
	Worksheet				m_wks;
	Column					m_colX, m_colY;
	///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	Column					m_colLabel;
	///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	HWND					m_hWnd;
};
/*------------------------------------------------------------------------------*
* DigitizerDataDumpingHelper End												*
*------------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------*
* DigitizerPickPointHelper														*
*------------------------------------------------------------------------------*/

class DigitizerPickPointHelper
{
public:
	DigitizerPickPointHelper(DigitizerImplData& data);
	~DigitizerPickPointHelper();

	BOOL	IsDataBackup(TreeNode* ptrSettings = NULL);

	BOOL	HasPickedPoint();

	BOOL	CheckRestore();

	BOOL	ClearBackup();
	BOOL	CheckBackupData();

private:
	DigitizerImplData*		m_pData;
	Layer					m_glOriginal;
};
/*------------------------------------------------------------------------------*
* DigitizerPickPointHelper End													*
*------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* PreviewDataPlot																*
*------------------------------------------------------------------------------*/
#define STR_PREVIEW_PLOT_NAME		"PreviewDPObj"
class PreviewDataPlot
{	
public:
	PreviewDataPlot();	
	~PreviewDataPlot() {}	
	bool Plot(const vector& vx, const vector& vy);	
	bool SetColor(int nColor);
	
private:
	bool checkGetPlotObj(GraphObject& grPlot);	
	bool applyFormat(Tree& tr);	
	
private:
	GraphLayer		m_gl;
	int				m_nColor;
};
/*------------------------------------------------------------------------------*
* PreviewDataPlot End															*
*------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* DigitizerImpl																	*
*------------------------------------------------------------------------------*/
class DigitizerImpl
{
public:
	DigitizerImpl();
	~DigitizerImpl();

	void	SetHwnd(HWND hWnd);
	HWND	GetHwnd();

	BOOL	Save();
	BOOL	Load();
	
	GraphLayer	GetDigitizeLayer();
	GraphPage	GetDigitizePage();
	
	BOOL	IsCoorReady(IMPLDATA type);

	BOOL	SetData(IMPLDATA type, LPCSTR lpcsz);
	BOOL	SetScaleType(IMPLDATA type, int nValue);
	BOOL	SetAxisPixel(IMPLDATA type, int nValue);
	BOOL	SetAxisColor(IMPLDATA type);

	BOOL	SetAxisSelection(IMPLDATA type);
	IMPLDATA	GetAxisSelection();
	
	void	GetInfoNames(vector<string>& vs);
	void	GetInfoColors(vector<uint>& vn);
	void	GetInfoScales(vector<string>& vs);
	void	GetInfoPixels(vector<string>& vs);
	void	GetInfoScaleTypes(vector<string>& vs);

	/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	///// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	//void	GetLineInfoNumPoints(vector<string>& vs);
	//void	GetLineInfoColor(vector<string>& vs);
	/////End DIGITIZER_SUPPORT_MAGNIFIER
	/// Iris 01/18/2012 ORG-4894-P1 FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
	//void	GetCurveInfo(CurveInfo& info);
	bool	GetCurveInfo(CurveInfo& info);
	///End FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
	void 	ShowDataPlot(int nIndex, bool bShow);
	void	SetPlotColor(int nColor);
	BOOL 	ActivatePlot();
	BOOL 	SetActiveData(int nData);
	int		GetActiveData();
	BOOL	CheckGetActivePlot(int& nActiveData);
	///End IMPROVE_MULTIPLE_CURVES
	
	BOOL	GetX0Y0(string& x, string& y);

	string	GetAxisScaleHint(IMPLDATA type);

	BOOL	SaveAxesSettings(TreeNode& tr);
	BOOL	LoadAxesSettings(TreeNode& tr);

	BOOL	IsX1FromYAxis();
	BOOL	IsY1FromXAxis();

	BOOL 	IsXRefLineShow();
	BOOL 	IsYRefLineShow();

	BOOL	ImportImage();
	BOOL	ImportImageFromClipboard();		///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER

	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	//BOOL	Rotate(BOOL bOn);
	//BOOL	SetRotationMode(BOOL bOn);
	//BOOL	IsRotationMode();
	/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	///End FIX_ROTATE_GETN_DLG_ISSUE

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL	SetLabelEditing(BOOL bOn);
	BOOL	IsLabelEditing();
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	
	BOOL	ChangeOptions();
	
	BOOL	Digitize();

	BOOL	TraceLine();		///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
	
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	BOOL	IsImageDigitizing();
	///End OPTIMIZE_PICKED_POINT
	
	BOOL	NewData();
	/// Iris 12/29/2011 ORG-4685-S5 SUPPORT_DELETE_LINE
	BOOL    RemoveActiveData(); 
	BOOL	IsDeleteLineEnable();
	///End SUPPORT_DELETE_LINE
	BOOL	GotoData();
	BOOL	GotoGraph();
	BOOL	DelWksGraph();	

	BOOL	HasValidDigitizeImage();
	BOOL	HasDataPoint();

	BOOL	Update(BOOL bLoadSettingsOnly = FALSE);

	BOOL	UpdateOptions(TreeNode& tr, DWORD dwCntrl);

	double	GetRotateInc();
	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	//BOOL	RotateImage(LPDOUBLE prAngle = NULL, LPDOUBLE prAngleInc = NULL);
	BOOL	RotateImage(LPDOUBLE prAngle = NULL, LPDOUBLE prAngleInc = NULL, bool bUpdateImageBitmap = false);
	bool	ResetImage();
	void	BackupImage();
	///End FIX_ROTATE_GETN_DLG_ISSUE

	BOOL	IsReadyToDigitize();

	BOOL	UpdateFromEvents(int nEvent, LPCSTR lpcszName);
	BOOL	UpdateFromPlot(int nEvent);

	string	GetDataName();

	BOOL	SetAxesEditing(BOOL bOn);
	BOOL	ShowXRefLine(BOOL bShow);
	BOOL	ShowYRefLine(BOOL bShow);
	BOOL	IsAxesEditing();

	BOOL	GetOnePoint(string& str, double x, double y);
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	//BOOL	AddOnePoint(double x,  double y)
	BOOL	AddOnePoint(double& x,  double& y);	

	bool 	IsOptimizePoint();
	bool 	OptimizePoint(double& x,  double& y);
	void	DestroyTempMatrix();//void 	DestroyImageMatrix();		///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
	///End OPTIMIZE_PICKED_POINT
	
	BOOL	BeforeAutoTraceLine(double& x,  double& y); /// Iris 9/03/2012 ORG-5112-P5 TO_FIND_GOOD_START_POINT_FOR_AUTO_TRACE_LINE
	BOOL	TraceLineAndAddPoints(double& x,  double& y);			///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	//BOOL	DigitizeArea();		
	BOOL 	IsDigitizingArea();	
	void	GetDigitizeROIGridInfo(DigiROIGridInfo& stAreaInfo);
	/// Iris 2/02/2012 ORG-4797-S5 TO_ADD_DIGITIZE_SETTINGS_MENU
	//void	SaveDigitizingAreaStatus(bool bOn, DigiROIGridInfo *pstAreaInfo = NULL);
	void	SaveDigitizingAreaStatus(bool *pbOn, DigiROIGridInfo *pstAreaInfo = NULL);
	///End TO_ADD_DIGITIZE_SETTINGS_MENU
	void	UpdateROIGirdStatus(bool bReset = false);	
	BOOL	DigitizeAreaAndAddPoints(double x, double y, double width, double height, int angle, int step);
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	BOOL	ClearBackground();
	BOOL	RemoveGridLine();
	
	BOOL	Undo();
	BOOL	IsUndoEnable();
	
	string	GetHint();
	string	GetTitle();

	BOOL	CheckUpdateOnDlgShow(BOOL bShow);

	///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	BOOL	DataPlotEdit(int nIndex);
	///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH

	///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	BOOL	UpdatePlotFromOutput(DatasetObject& dsObj, GraphLayer& gl);
	///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

	bool	 GetImageROI(pBITMAPHANDLE &pLBROI, int x, int y, int nROIPercent); /// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER

	/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
	//BOOL	DeletePoint();
	//BOOL 	DeletePoints(const vector<uint>& vnIndices);	
	BOOL 	DeletePoints(double x, double y, double width, double height);	
	void 	SaveDeletePointsStatus(bool bOn);
	bool	IsDeletingPoints();
	///End IMPROVE_DELETE_POINTS
	BOOL	ReorderPoints();
	
	/// Iris 7/16/2012 ORG-6216-S1 SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT
	BOOL	SetFocusOnGraph();
	///End SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT
	
	/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
	int		GetCoordinatesType();
	void	SetCoordinatesType(int nType);
	bool 	AddOneVertex(double x, double y);
	bool	ShowAxes(bool bShow);
	bool  	ShowVertexs(bool bShow);
	bool	IsVertexsReady();
	int		GetVertexs(vector& vx, vector& vy);
	bool	UpdateVertexs();
	///End SUPPORT_TERNARY_IN_DIGITIZER
	
private:
	DigitizerVisualizer*		Visualizer();
	DigitizerImageHelper*		ImageHelper();
	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	//DigitizerRotationHelper*	RotateHelper();
	///End FIX_ROTATE_GETN_DLG_ISSUE
	DigitizerOptionsHelper*		OptionsHelper();
	DigitizerRunner*			Runner();
	DigitizerDataDumpingHelper*	DumpingHelper();
	DigitizerTernaryVertexsPoints*	VertexPoints();

	GraphObject	GetDigitizeImage();

	void		InitData();

	BOOL	SaveSettings();
	BOOL	LoadSettings();
	
	BOOL	UpdateAxes(BOOL bRefresh = FALSE);
	BOOL	UpdateDataPlot(BOOL bRefresh = FALSE);
	BOOL	UpdatePlotFromEvent(int nEvent);
	BOOL	UpdateInfo();
	BOOL	UpdateInfoSelection();
	BOOL	UpdateDataPlotSelectionFromEvent(); /// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	BOOL	EnableDigitize();
	BOOL	UpdateVertexInfo(); /// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER

	BOOL	NotifyDigitizer(int nMsg, BOOL bPost = FALSE, UINT wParam = 0, UINT lParam = 0);
	BOOL	NotifyAxesPanel(int nMsg, BOOL bPost = FALSE, UINT wParam = 0, UINT lParam = 0); /// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER

	BOOL	RecalculateAndDump(BOOL bDumpEvenNotCalculate = FALSE);
	BOOL	DumpAndSave(BOOL bPlot = FALSE);

	BOOL	IsDlgOpen();

	BOOL	CheckShowOpenDlgObj();
	BOOL	CheckUpdateObjsStates();
	BOOL	CheckRestorePickPoints(BOOL bDlgShow);
	
	void	PrepareAxesSettings(TreeNode& tr);

	BOOL	OnAfterAxesChange();

	BOOL	Digitizing();
	
	BOOL	TracingLine();		///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE

	BOOL	GetX0Y0(double& x, double& y);

	BOOL	SetAxisEditingByOther(BOOL bOn, BOOL bNot, DWORD dwBit, BOOL bAlways = FALSE);
	void	SetAxisEditingByOther(DWORD dwBit, BOOL bOn);

	BOOL	UpdateRotation();
	
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	void	beforeRunDigitizing(int nCmdID);
	BOOL	afterRunDigitizing(int nReturn, DigitizerPickPointHelper* pclHelper = NULL);	
	BOOL	DigitizingArea(double x, double y, double width, double height, int angle, int step, vector& vx, vector& vy);
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	
	/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
	bool 	getPointsInsideRect(double x, double y, double width, double height, vector<uint>& vnIndices);
	///End IMPROVE_DELETE_POINTS
	
public:	
	///Jasmine 03/11/11 ORG-2286 KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP
	void CleanRelativeData(LPCSTR lpczAttachPage);
	///End KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP
	
private:
	HWND							m_hWnd;
	//BOOL							m_bDigitizing; // Iris: this member seems repeat since m_data.bDigitizing also save this status, so commented out.

	DigitizerImplData				m_data;
	DigitizerObjsHolder				m_objsHolder;

	DigitizerVisualizer*			m_pVisualizer;
	DigitizerImageHelper*			m_pImage;
	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	//DigitizerRotationHelper*		m_pRotate;
	///End FIX_ROTATE_GETN_DLG_ISSUE
	DigitizerOptionsHelper*			m_pOptions;
	DigitizerRunner*				m_pRunner;
	DigitizerDataDumpingHelper*		m_pDumping;	
	DigitizerTernaryVertexsPoints*	m_pVertexs;
};
/*------------------------------------------------------------------------------*
* DigitizerImpl	End																*
*------------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------*
* DigitizerInfoList																*
*------------------------------------------------------------------------------*/
class DigitizerInfoList : public GridListControl
{
public:
	DigitizerInfoList(DigitizerImpl* pImpl);
	~DigitizerInfoList();
	void Init(int nID, Dialog& dlg);

	BOOL	Update(DWORD dwCntrls = 0);
	BOOL	UpdateSelectable(BOOL bResetRowSelection = FALSE);

	void	OnBeforeEdit(long nRow, long nCol, BOOL* pCancel);
	void	OnAfterEdit(int nRow, int nCol);
	void 	OnAfterSelectionChange(int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel);
	void	OnMouseMove(short nButton, short nShift, float X, float Y);
	
	BOOL	ShowMenu(int nx, int ny);
	BOOL	OnSetAxisColor(IMPLDATA type);

	int		GetHeight();
	
private:
	void	UpdateNames();
	void	UpdateColors();
	void	UpdateScales();
	void	UpdatePixels();

	void	InitScaleTypes();		

	void	UpdateScaleTypes();
	void	SetupScaleTypeNoCombo();

	void	SelectRow(int nRow, BOOL bUpdate = TRUE, int nCol = -1);

	void	UpdateX0Y0();

	BOOL	UpdateSelection();
	
	BOOL	CheckShowRows(BOOL bShow);
	
	BOOL	IsDuringUpdate();
	BOOL	IsAxesEditing();

	void	FillColumnBkColor(int nCol, vector<uint>& vnColors);
	void	SetColumnForeColor(int nCol, vector<uint>& vnColors);
	BOOL	UpdateCellsColor();

	void	UpdateAfterSelect(int nRowNew, int nRowOld);
	
	void	UpdateColorCol(int nRow);

	void	UpdateRows();	

	void	SetAxisColor(IMPLDATA type);
	
	void	CheckEnableDigitize();

private:
	DigitizerImpl*		m_pImpl;
	int					m_nDuringUpdate;
};
/*------------------------------------------------------------------------------*
* DigitizerInfoList End															*
*------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* DigitizerLineInfoList															*
*------------------------------------------------------------------------------*/
/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
class DigitizerLineInfoList : public GridListControl
{
public:
	DigitizerLineInfoList(DigitizerImpl* pImpl);
	~DigitizerLineInfoList();
	void Init(int nID, Dialog& dlg);
	bool UpdateRows(int nLine = -1, bool bAllowRowSelEvent = false);
	void OnBeforeEdit(int nRow, int nCol, BOOL* pCancel); /// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	
private:
	DigitizerImpl*		m_pImpl;	
};
///End DIGITIZER_SUPPORT_MAGNIFIER
/*------------------------------------------------------------------------------*
* DigitizerLineInfoList End														*
*------------------------------------------------------------------------------*/

class DisableToolbarButtonTemp
{
public:
	DisableToolbarButtonTemp(Dialog& dlg, const vector<int>& vnIDs)
	{
		m_pDlg = &dlg;
		m_vnIDs = vnIDs;		
		
		m_vbEnables.SetSize(vnIDs.GetSize());		
		for(int nn = 0; nn < vnIDs.GetSize(); nn++)
		{
			Control ctrl = dlg.GetItem(vnIDs[nn]);
			if( ctrl )
			{
				m_vbEnables[nn] = ctrl.Enable;
				ctrl.Enable = false;
			}
		}
	}
	
	~DisableToolbarButtonTemp()
	{
		for(int nn = 0; nn < m_vnIDs.GetSize(); nn++)
		{
			Control ctrl = m_pDlg->GetItem(m_vnIDs[nn]);
			if( ctrl )
				ctrl.Enable = m_vbEnables[nn];
		}	
	}
	
private:
	Dialog*			m_pDlg;
	vector<int>		m_vnIDs;
	vector<bool>	m_vbEnables;
};


/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
enum
{
	AXES_INFO_DLG_ON_TAB_CHANGE = 0,
};

class AxesInfoDlg : public Dialog
{
public:
	AxesInfoDlg(int nDlgID, DigitizerImpl* pImpl) : Dialog(nDlgID, "ODlg8") { m_pImpl = pImpl; }
	~AxesInfoDlg() {}
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_SIZE(OnDlgResize)	
EVENTS_END		
	virtual BOOL OnInitDialog() { return TRUE; }
	virtual bool OnDlgResize(int nType, int cx, int cy) { return true; }
	
public:	
	virtual BOOL Update(DWORD dwCntrls) { return FALSE; }
	virtual BOOL UpdateGridSelectable(bool bResetRowSelection) { return FALSE; }
	virtual BOOL OnBeforeTabChange(int nOldType) { return false; }
	virtual BOOL OnAfterTabChange() { return false; }
	
protected:
	DigitizerImpl* 			m_pImpl;
};

enum
{
	COORDINATES_TYPE_NONE = -1,
	COORDINATES_TYPE_NORMAL_XY = 0,
	COORDINATES_TYPE_POLAR,
	COORDINATES_TYPE_TERNARY,	
};

class XYAxesInfoDlg : public AxesInfoDlg
{
public:
	XYAxesInfoDlg(DigitizerImpl* pImpl = NULL) : AxesInfoDlg(IDD_DIGI_XY_AXES_INFO_DLG, pImpl)
	{		
		if(NULL != pImpl )
			m_pInfo = new DigitizerInfoList(pImpl);
	}
	~XYAxesInfoDlg()
	{
		NICE_SAFE_REMOVAL(m_pInfo);
	}	
	BOOL Create(HWND hWndParent = NULL, bool bVisible = true);

protected:
EVENTS_BEGIN_DERIV(AxesInfoDlg)
	ON_GRID_BEFORE_EDIT(IDC_DIGITIZER_INFO, 		OnBeforeEditInfo)
	ON_GRID_AFTER_EDIT(IDC_DIGITIZER_INFO, 			OnAfterEditInfo)
	ON_GRID_KEY(IDC_DIGITIZER_INFO, 				OnKeyInfo) /// Iris 7/16/2012 ORG-6216-S1 SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT	
	ON_GRID_AFTER_SEL_CHANGE(IDC_DIGITIZER_INFO, 	OnAfterInfoSelectionChange)
	ON_GRID_MOUSE_MOVE(IDC_DIGITIZER_INFO, 			OnMouseMoveOnInfo)
EVENTS_END_DERIV
	
	void	OnBeforeEditInfo(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	void	OnAfterEditInfo(Control flxControl, int nRow, int nCol);
	BOOL 	OnKeyInfo(Control oCntrl, UINT msg, UINT wParam, UINT lParam); /// Iris 7/16/2012 ORG-6216-S1 SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT
	void 	OnAfterInfoSelectionChange(Control cntrl, int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel);
	void	OnMouseMoveOnInfo(Control cntrl, short nButton, short nShift, float X, float Y);
	
	// virtual
	BOOL 	OnInitDialog();
	//virtual
	bool 	OnDlgResize(int nType, int cx, int cy);
	
public:		
	//virtual
	BOOL Update(DWORD dwCntrls);
	//virtual
	BOOL UpdateGridSelectable(bool bResetRowSelection);	
	//virtual 
	BOOL OnBeforeTabChange(int nOldType);
	//virtual 
	BOOL OnAfterTabChange();
	
private:	
	DigitizerInfoList*	m_pInfo;	
};



class PolarAxesInfoDlg : public AxesInfoDlg
{
public:
	PolarAxesInfoDlg(DigitizerImpl* pImpl = NULL) : AxesInfoDlg(IDD_DIGI_POLAR_AXES_INFO_DLG, pImpl)
	{
	}
	~PolarAxesInfoDlg()
	{
	}
	BOOL Create(HWND hWndParent = NULL, bool bVisible = true);
	
protected:
	// virtual
	BOOL 	OnInitDialog();	
	
private:	
};

class TernaryVariablesList : public GridListControl
{
public:
	TernaryVariablesList(DigitizerImpl* pImpl) { m_pImpl = pImpl; }
	~TernaryVariablesList() {}
	
	void Init(int nID, Dialog& dlg);
	bool Update();
	
private:
	DigitizerImpl* 			m_pImpl;
};

class TernaryAxesInfoDlg : public AxesInfoDlg
{
public:
	TernaryAxesInfoDlg(DigitizerImpl* pImpl = NULL) : AxesInfoDlg(IDD_DIGI_TERNARY_AXES_INFO_DLG, pImpl)
	{
		m_pVarList = new TernaryVariablesList(pImpl);
	}
	~TernaryAxesInfoDlg()
	{
		NICE_SAFE_REMOVAL(m_pVarList);
	}
	BOOL Create(HWND hWndParent = NULL, bool bVisible = true);
	//virtual 
	BOOL OnBeforeTabChange(int nOldType);
	//virtual 
	BOOL OnAfterTabChange();	
	
protected:
EVENTS_BEGIN_DERIV(AxesInfoDlg)	
	ON_USER_MSG(ID_DIGITIZER_MSG_VERTEX_UPDATE,			OnVertexUpdated) /// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
EVENTS_END_DERIV	

	// virtual
	BOOL 	OnInitDialog();	
	
	BOOL	OnVertexUpdated(WPARAM wParam, LPARAM lParam);
	
private:
	TernaryVariablesList*				m_pVarList;
};

class DataInfoDlg : public Dialog
{
public:
	DataInfoDlg(DigitizerImpl* pImpl) : Dialog(IDD_DIGI_DATA_INFO_DLG, "ODlg8")
	{
		m_pLineList = new DigitizerLineInfoList(pImpl);
		m_pImpl = pImpl;
	}
	
	~DataInfoDlg()
	{
		NICE_SAFE_REMOVAL(m_pLineList);
	}
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_SIZE(OnDlgResize)
	
	ON_GRID_AFTER_EDIT(IDC_DIGITIZER_LINE_INFO, 	OnLineInfoGridAfterEdit)
	ON_GRID_BEFORE_EDIT(IDC_DIGITIZER_LINE_INFO, 	OnLineInfoGridBeforeEdit)
	ON_GRID_SEL_CHANGE(IDC_DIGITIZER_LINE_INFO, 	OnLineInfoGridSelRowChange)
EVENTS_END

	BOOL 	OnInitDialog();
	bool 	OnDlgResize(int nType, int cx, int cy);
	
	void	OnLineInfoGridAfterEdit(Control ctrl, int nRow, int nCol);
	void 	OnLineInfoGridBeforeEdit(Control ctrl, int iRow, int iCol, BOOL *pCancel);
	void 	OnLineInfoGridSelRowChange(Control ctrl);
	
public:
	BOOL	Create(HWND hWndParent = NULL);
	bool	UpdateMagnifier(pBITMAPHANDLE pBitmap);
	int		GetMagnifierFactor();
	
	void	UpdateGrid(int nLine = -1, bool bAllowRowSelEvent = false);
	void	SelData(int nDataIndex);		
	
private:
	PictureControl 				m_picControl;
	Slider						m_sld;
	
	DigitizerLineInfoList*		m_pLineList;
	DigitizerImpl* 				m_pImpl;
};
///End SUPPORT_TERNARY_IN_DIGITIZER


/*------------------------------------------------------------------------------*
* Digitizer																		*
*------------------------------------------------------------------------------*/
enum{
	DIGITIZER_XY_AXIS_TAB = 0,
	DIGITIZER_POLAR_AXIS_TAB,
	DIGITIZER_TERNARY_AXIS_TAB,
	DIGITIZER_DATA_TAB,
	
	DIGITIZER_TAB_TOTAL
};

#define 	STR_TAB_TITLE_AXES								_L("Axes")
#define 	STR_TAB_TITLE_DATA								_L("Data")

#define		LT_VAR_PAGE_MOUSE_MOVE							"@PMM"
/// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
#define     LT_VAR_DIGI_AREA_GRID_SWITCH					"@DFG"
#define 	LT_VAR_DIGI_AREA_GRID_INTERVAL					"@FGI"
///End MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA

class Digitizer : public ResizeDialog
{
public:
	Digitizer() : ResizeDialog(IDD_DIGITIZER90, "ODlg8")
	{
		//m_pInfo = new DigitizerInfoList(&m_Impl);
		/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
		//m_pLineList = new DigitizerLineInfoList(&m_Impl);
		m_pLBROI = ol_new_bitmap();
		m_dPreviewPointX = m_dPreviewPointY = -1;
		///End DIGITIZER_SUPPORT_MAGNIFIER
	}
	~Digitizer()
	{
		LT_set_var(LT_VAR_PAGE_MOUSE_MOVE, 0); /// Iris 12/27/2011 ORG-4685-S3 NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE
		//NICE_SAFE_REMOVAL(m_pInfo);
		/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
		//NICE_SAFE_REMOVAL(m_pLineList);
		if( m_pLBROI )
		{
			ol_delete_bitmap(m_pLBROI);
			m_pLBROI = NULL;
		}
		///End DIGITIZER_SUPPORT_MAGNIFIER
		NICE_SAFE_REMOVAL(m_pXYAxesInfoDlg);
		NICE_SAFE_REMOVAL(m_pPolarAxesInfoDlg);
		NICE_SAFE_REMOVAL(m_pTernaryAxesInfoDlg);
	}
	
	int	DoModalEx(HWND hParent)
	{
		InitMsgMap();
		return DoModal(hParent);
	}
	
	BOOL	Create(HWND hWndParent = NULL)
	{
		InitMsgMap();		
		BOOL	bReturn = ResizeDialog::Create(hWndParent, 0);
		Visible = TRUE;
		return TRUE;
	}
	
	BOOL	UpdateMagnifier(double* px = NULL, double* py = NULL); /// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER

	BOOL	NotifyAxesPanel(int nMsg, bool bPost = FALSE, UINT wParam = 0, UINT lParam = 0); /// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
	
protected:	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_DESTROY(OnDestroy)
	ON_CANCEL(OnCancel)
	ON_SIZE(OnDlgResize)	
	ON_SYSCOMMAND(OnSystemCommand)
	
	ON_TAB_SEL_CHANGE(IDC_DIGITIZER_TAB, OnTabChange)
	
	ON_CHANGE_PAGE(OnChangePage)
	
	ON_VSLIDE(IDC_SLIDER1,						OnMagnifierSliderClick) /// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	
	// Toolbar buttons
	ON_BN_CLICKED(IDC_DIGITIZER_IMPORT,			OnImportImage)
	///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	ON_BN_CLICKED(IDC_DIGITIZER_IMPORT_FROM_CLIPBOARD, OnImportImageFromClipboard)
	///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	//ON_BN_CLICKED(IDC_DIGITIZER_ROTATE, 		OnRotate) 
	ON_BN_CLICKED(IDC_DIGITIZER_EDIT, 			OnToggleAxesEdit)
	ON_BN_CLICKED(IDC_DIGITIZER_NEW_LINE, 		OnNewLine)
	ON_BN_CLICKED(IDC_DIGITIZER_REMOVE_GRIDLINE, OnRemoveGridLines)
	ON_BN_CLICKED(IDC_DIGITIZER_TRACE_LINE, 	OnTraceLine)
	ON_BN_CLICKED(IDC_DIGITIZER_AREA, 			OnDigitizeArea)
	ON_BN_CLICKED(IDC_DIGITIZER_GO, 			OnDigitize)
	ON_BN_CLICKED(IDC_DIGITIZER_DELETE_POINT, 	OnDeletePoint)
	ON_BN_CLICKED(IDC_DIGITIZER_REORDER_POINT, 	OnReorderPoints)
	ON_BN_CLICKED(IDC_DIGITIZER_UNDO, 			OnUndo)	
	
	// Menu
	ON_MENU_CMD(IDC_DIGITIZER_MENU_IMPORT,			OnMenuImportImage)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_CLOSE, 			OnMenuClose)
	
	ON_MENU_CMD(IDC_DIGITIZER_MENU_ROTATE,				OnMenuRotate)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_COLOR_REPLACE, 		OnMenuReplaceColor)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_ERASER,				OnMenuEraser)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_CLEAR_BACKGROUND,	OnMenuClearBackground)
	
	ON_MENU_CMD(IDC_DIGITIZER_MENU_EDIT_AXES, 		OnMenuEditAxes)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_RECTANGULAR_COORDINATE,	OnMenuRectangularCoordinates)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_POLAR_COORDINATE,	OnMenuPolarCoordinates)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_TERNARY_COORDINATE,	OnMenuTernaryCoordinates)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_SHOW_XREF, 		OnMenuToggleXRefLineShow)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_SHOW_YREF, 		OnMenuToggleYRefLineShow)	
	
	ON_MENU_CMD(IDC_DIGITIZER_MENU_NEW_LINE, 			OnMenuNewLine)	
	ON_MENU_CMD(IDC_DIGITIZER_MENU_DELETE_LINE,			OnMenuDeleteLine) /// Iris 12/29/2011 ORG-4685-S5 SUPPORT_DELETE_LINE
	ON_MENU_CMD(IDC_DIGITIZER_MENU_REMOVE_GRIDLINE, 	OnMenuRemoveGridline)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_TRACE_LINE,   	OnMenuTraceLine)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_AREA,         	OnMenuArea)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_DIGITIZE_SETTINGS, 	OnMenuDigitizeSettings)	 /// Iris 2/02/2012 ORG-4797-S5 TO_ADD_DIGITIZE_SETTINGS_MENU
	ON_MENU_CMD(IDC_DIGITIZER_MENU_GO,           	OnMenuGo)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_DELETE_POINT, 	OnMenuDeletePoint)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_REORDER_POINT, 	OnMenuReorderPoint)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_SET_LABEL,    	OnMenuToggleLabelEdit)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_UNDO,         	OnMenuOndo)	
	
	ON_MENU_CMD(IDC_DIGITIZER_MENU_GO_TO_DATA,		OnMenuGoToData)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_GO_TO_IMAGE,		OnMenuGoToImage)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_GO_TO_GRAPH,		OnMenuGoToGraph)
	ON_MENU_CMD(IDC_DIGITIZER_MENU_REMOVE_WKS_GRAPH,	OnMenuDelWksGraph)	
	
	
	/// Iris 2/13/2012 ORG-5009-P1 IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
	//ON_CMD_UI_UPDATE_RANGE(IDC_DIGITIZER_MENU_IMPORT, IDC_DIGITIZER_MENU_DELETE_LINE, OnUIUpdateMenuEnable) /// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	ON_CMD_UI_UPDATE_RANGE(IDC_DIGITIZER_MENU_IMPORT, IDC_DIGITIZER_MENU_DIGITIZE_SETTINGS, OnUIUpdateMenuEnable)
	///End IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
	
	//ON_CMD_UI_UPDATE(IDC_DIGITIZER_MENU_SET_LABEL, 			OnUiUpdateMenu)
	//ON_CMD_UI_UPDATE(IDC_DIGITIZER_MENU_ROTATE, 			OnUiUpdateMenu)
	//ON_CMD_UI_UPDATE(IDC_DIGITIZER_MENU_GO_TO_IMAGE, 		OnUiUpdateMenu)
	//ON_CMD_UI_UPDATE(IDC_DIGITIZER_MENU_GO_TO_DATA, 		OnUiUpdateMenu)
	//ON_CMD_UI_UPDATE(IDC_DIGITIZER_MENU_GO_TO_GRAPH, 		OnUiUpdateMenu)
	//ON_CMD_UI_UPDATE(IDC_DIGITIZER_MENU_REMOVE_WKS_GRAPH, 	OnUiUpdateMenu)
	
	// InfoList
	//ON_GRID_BEFORE_EDIT(IDC_DIGITIZER_INFO, 		OnBeforeEditInfo)
	//ON_GRID_AFTER_EDIT(IDC_DIGITIZER_INFO, 			OnAfterEditInfo)
	//ON_GRID_KEY(IDC_DIGITIZER_INFO, 				OnKeyInfo) /// Iris 7/16/2012 ORG-6216-S1 SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT	
	//ON_GRID_AFTER_SEL_CHANGE(IDC_DIGITIZER_INFO, 	OnAfterInfoSelectionChange)
	//ON_GRID_MOUSE_MOVE(IDC_DIGITIZER_INFO, 			OnMouseMoveOnInfo)
	
	// List info
	/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	//ON_GRID_AFTER_EDIT(IDC_DIGITIZER_LINE_INFO, 	OnLineInfoGridAfterEdit)
	//ON_GRID_BEFORE_EDIT(IDC_DIGITIZER_LINE_INFO, 	OnLineInfoGridBeforeEdit)
	//ON_GRID_SEL_CHANGE(IDC_DIGITIZER_LINE_INFO, 	OnLineInfoGridSelRowChange)
	///End IMPROVE_MULTIPLE_CURVES
	
	// User message
	ON_USER_MSG(ID_DIGITIZER_MSG_UPDATE_INFO, 			OnUpdateInfo)
	ON_USER_MSG(ID_DIGITIZER_MSG_UPDATE_INFO_SELECTION, OnUpdateInfoSelection)
	ON_USER_MSG(ID_DIGITIZER_MSG_UPDATE_PLOT_SELECTION, OnUpdatePlotSelection) /// Iris 12/20/2011 ORG-1614-S3 SUPPORT_PLOT_SELECTION_BY_OBJ_AND_ROW_IN_DATA_GRID
	ON_USER_MSG(ID_DIGITIZER_MSG_UPDATE_FROM_POINTS, OnUpdateFromPlot)
	ON_USER_MSG(ID_DIGITIZER_MSG_CHECK_ENABLE_DIGITIZE, OnCheckEnableDigitize)
	ON_USER_MSG(ID_DIGITIZER_MSG_CHECK_SET_ACTIVE_PLOT, OnCheckSetActivePlot) /// Iris 12/29/2011 ORG-4685-P2 FIX_REOPEN_DLG_DATA_PLOT_SELECTION_PROBLEM
	ON_USER_MSG(ID_DIGITIZER_MSG_DO_DIGITIZE_AREA_CALA,	OnDoDigitizeAreaCalc) /// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
	ON_USER_MSG(ID_DIGITIZER_MSG_DO_DELETE_POINTS,		OnDoDeletePoints) /// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS			
		
	///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	ON_MARKEROBJ_EDIT(OnDataPlotEdit)
	///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	
	ON_PAGE_MOUSE_MOVE(OnPageMouseMove) /// Iris 12/27/2011 ORG-4685-S3 NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE
	ON_PAGE_LBUTTONDOWN(OnPageMouseLButtonDown)
	ON_PAGE_LBUTTONUP(OnPageMouseLButtonUp)
		
EVENTS_END

	BOOL 	OnInitDialog();
	BOOL 	OnDestroy();
	BOOL	OnCancel();
	BOOL 	OnDlgResize(int nType, int cx, int cy);
	
	BOOL 	OnTabChange(Control ctrl);
	
	BOOL	OnChangePage();
	
	BOOL	OnImportImage(Control ctrl);
	BOOL	OnImportImageFromClipboard(Control ctrl);		///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	BOOL	OnRotate(Control ctrl);
	BOOL	OnToggleAxesEdit(Control ctrl);
	BOOL 	OnNewLine(Control ctrl);
	BOOL	OnRemoveGridLines(Control ctrl);
	BOOL 	OnTraceLine(Control ctrl);
	BOOL 	OnDigitizeArea(Control ctrl);
	BOOL	OnDigitize(Control ctrl);
	BOOL	OnDeletePoint(Control ctrl);
	BOOL	OnReorderPoints(Control ctrl);
	BOOL 	OnUndo(Control ctrl);
	BOOL	OnMagnifierSliderClick(Control ctrl, UINT nCode, UINT nPos); /// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	
	BOOL	OnMenuImportImage();
	BOOL	OnMenuClose();
	
	BOOL	OnMenuRotate();
	BOOL	OnMenuReplaceColor();
	BOOL	OnMenuEraser();
	BOOL	OnMenuClearBackground();
	
	BOOL	OnMenuEditAxes();
	BOOL	OnMenuRectangularCoordinates();
	BOOL	OnMenuPolarCoordinates();
	BOOL	OnMenuTernaryCoordinates();
	BOOL	OnMenuToggleXRefLineShow();
	BOOL	OnMenuToggleYRefLineShow();	
	
	BOOL 	OnMenuNewLine();
	BOOL	OnMenuDeleteLine(); /// Iris 12/29/2011 ORG-4685-S5 SUPPORT_DELETE_LINE
	BOOL	OnMenuRemoveGridline();
	BOOL	OnMenuTraceLine();
	BOOL	OnMenuArea();
	BOOL	OnMenuDigitizeSettings(); /// Iris 2/02/2012 ORG-4797-S5 TO_ADD_DIGITIZE_SETTINGS_MENU
	BOOL	OnMenuGo();
	BOOL	OnMenuDeletePoint();
	BOOL	OnMenuReorderPoint();
	BOOL	OnMenuToggleLabelEdit();
	BOOL	OnMenuOndo();	
	
	BOOL	OnMenuGoToData();
	BOOL	OnMenuGoToImage();
	BOOL	OnMenuGoToGraph();
	BOOL	OnMenuDelWksGraph();
	
	BOOL 	OnUIUpdateMenuEnable(CmdUI cmd); /// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	BOOL	OnUiUpdateMenu(CmdUI cmdUI);
	
	void 	EnableMenuItem(int nMenuItemID, bool bEnable = true, bool bCheck = false);
	
	//void	OnBeforeEditInfo(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	//void	OnAfterEditInfo(Control flxControl, int nRow, int nCol);
	//BOOL 	OnKeyInfo(Control oCntrl, UINT msg, UINT wParam, UINT lParam); /// Iris 7/16/2012 ORG-6216-S1 SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT
	//void 	OnAfterInfoSelectionChange(Control cntrl, int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel);
	//void	OnMouseMoveOnInfo(Control cntrl, short nButton, short nShift, float X, float Y);
	BOOL	OnUpdateInfo(WPARAM wParam, LPARAM lParam);
	BOOL	OnUpdateInfoSelection(WPARAM wParam, LPARAM lParam);
	BOOL	OnUpdatePlotSelection(WPARAM wParam, LPARAM lParam); /// Iris 12/20/2011 ORG-1614-S3 SUPPORT_PLOT_SELECTION_BY_OBJ_AND_ROW_IN_DATA_GRID
	BOOL	OnUpdateFromPlot(WPARAM wParam, LPARAM lParam);
	BOOL	OnCheckEnableDigitize(WPARAM wParam, LPARAM lParam);
	BOOL	OnCheckSetActivePlot(WPARAM wParam, LPARAM lParam); /// Iris 12/29/2011 ORG-4685-P2 FIX_REOPEN_DLG_DATA_PLOT_SELECTION_PROBLEM
	BOOL	OnDoDigitizeAreaCalc(WPARAM wParam, LPARAM lParam); /// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
	BOOL	OnDoDeletePoints(WPARAM wParam, LPARAM lParam); /// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
	
	
	/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	//void	OnLineInfoGridAfterEdit(Control ctrl, int nRow, int nCol);
	//void 	OnLineInfoGridBeforeEdit(Control ctrl, int iRow, int iCol, BOOL *pCancel);
	//void 	OnLineInfoGridSelRowChange(Control ctrl);
	///End IMPROVE_MULTIPLE_CURVES
	
	BOOL	OnDataPlotEdit(GraphObject go, int nIndex);
	BOOL	OnPageMouseMove(Page pg, LPVOID lpst); /// Iris 12/27/2011 ORG-4685-S3 NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE
	BOOL	OnPageMouseLButtonDown(Page pg, LPVOID lpst);
	BOOL	OnPageMouseLButtonUp(Page pg, LPVOID lpst);
	
	/// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
	void 	EnableUndoButton(bool bEnable = true) { GetItem(IDC_DIGITIZER_UNDO).Enable = bEnable; }
	//End SUPPORT_UNDO_FOR_IMAGE_PROCESS
	
private:
	BOOL	InitRadioBitmapButtons();	
	int		getToolbarButtonIDs(vector<int>& vnBtnIDs); /// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	
	BOOL	CheckUpdateOnDlgShow(BOOL bShow);
	
	BOOL	UpdateStates();
	BOOL	UpdateInfo(DWORD dwCntrls = 0);
	BOOL	UpdateDlgTitle();
	BOOL	UpdateAxesEditing();
	BOOL	UpdateShowXYRefLine();
	///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	BOOL	UpdateLabelEditing();
	BOOL	CheckEnableRotation();
	///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	
	BOOL	CheckEnableGotoImage();
	BOOL	CheckEnableGotoData();

	BOOL	UpdateInfoSelectable(BOOL bResetRowSelection = FALSE);
	
	BOOL	CheckEnableDigitize();
	BOOL	IsButtonsEnable();	
	
	void	initControlPosition();
	
	//int		getMagnifierFactor(); /// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	
	BOOL	doDigitize();  /// Iris 12/26/2011 ORG-4685-S4 CLICKED_NEW_LINE_NEED_START_PICK_POINTS
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	void	beforeDigitize();
	void	afterDigitize();	
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	bool	isBitmapButtonDown(int nID); /// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
	void	updateDigitizeGridStatus();	
	bool	getMouseDragRect(double& x, double& y, double& width, double& height);
	int		getSelectedDataPoints(vector<uint>& vnIndices); /// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
	void	turnOffPressedButton();
	
	/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
	AxesInfoDlg* getAxesInfoDlgPointer();
	int		getCoordinatesType();
	
	void    setMenuCheckStatus(int nMenuItemID, bool bCheck);	
	BOOL    setMenuCoordinatesType(int nType, bool bInit);
	BOOL    onMenuCoordinatesTypeCmd(int nType, bool bInit);
	///End SUPPORT_TERNARY_IN_DIGITIZER
	
private:
	DigitizerImpl				m_Impl;
	//DigitizerInfoList*			m_pInfo;
	//DigitizerLineInfoList*		m_pLineList; /// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER

	Menu						m_menu;
	/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
//	PictureControl 				m_picControl;	
	pBITMAPHANDLE				m_pLBROI;
//	Slider						m_sld;
	double 						m_dPreviewPointX;
	double 						m_dPreviewPointY;
	///End DIGITIZER_SUPPORT_MAGNIFIER

	GraphLayer					m_glImage;
	
	DWORD 						m_dwOptions;
	
	/// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
	PageMouseEventMsg			m_stMouseDownPos;
	PageMouseEventMsg			m_stMouseUpPos;		
	///End MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
	
	TabCtrlEx					m_tab;	
	XYAxesInfoDlg*				m_pXYAxesInfoDlg;
	PolarAxesInfoDlg*			m_pPolarAxesInfoDlg;
	TernaryAxesInfoDlg*			m_pTernaryAxesInfoDlg;	
	DataInfoDlg*				m_pDataInfoDlg;
};
/*------------------------------------------------------------------------------*
* Digitizer End																	*
*------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 * utilities function	 														*
 *------------------------------------------------------------------------------*/
///Rex 2/1/2012 ORG-4794-S4 IMPROVE_DIGITIZER_CURVE_DETECT
//comments last updated by Rex 2/1/2012
/**$
		Convert an image to gray.
	Parameters:
		moSrcImg=[input]source image, 8bit gray or 32 bit color
		moDstImg=[output]gray image, 8bit gray
	Result:
		Returns 0 on successful exit and negative error code on failure.		
*/
int digitizer_convert_to_gray(const MatrixObject& moSrcImg, MatrixObject& moDstImg);
///End IMPROVE_DIGITIZER_CURVE_DETECT
 
///Rex 10/18/2011 RSRCH-72 DIGITIZER_AUTO_TRACE_LINE_FUNCTIONS
 
//comments last updated by Rex 2/1/2012
//comments last updated by Rex 12/09/2011
/**$ 
		Curve detection according to paper: C. Steger, "An unbiased detector of curvilinear structures,"
		IEEE Transactions on Pattern Analysis and Machine Intelligence, Feb. 1998.
	Parameters:
		moImage=[input]source image, 8 bit gray or 32 bit color
		moSalient=[output]salient image, 32 bit floating. The element value indicates the salient extent of
				a point being a curve
		moAngle=[output]orientation image, 32 bit floating
		moMask=[output]flag image 8 bit gray. Flag value OCV_CURVE_BACKGD means a background point, 
				OCV_CURVE_SALIENT means a salient point(>threshould), and OCV_CURVE_LOCALMAX means a curve 
				center(salient point being local maxima along its orientation), it's a candidate point for
				later tracing.		
		dSigma=[input][optional]scale space parameter, default is 2.0
	Return:
		Returns 0 on successful exit and a negative error code on failure.
*/
///Rex 2/1/2012 ORG-4794-S4 IMPROVE_DIGITIZER_CURVE_DETECT
//int digitizer_curve_detect(const MatrixObject& moImage, MatrixObject& moSalient, MatrixObject& moAngle,
//						   MatrixObject& moMask, double dSigma = 2.0);
int digitizer_curve_detect(const MatrixObject& moImage, const MatrixObject& moMask, 
						   MatrixObject& moSalient, MatrixObject& moAngle, MatrixObject& moCurveMask, 
						   double dSigma=2.0);
///End IMPROVE_DIGITIZER_CURVE_DETECT
				
///Rex 2012/7/11 ORG-5112-P5 FIND_BETTER_TRACE_START_POINT_IN_NEIGHBORHOOD
/**$
		Check if there is any better start point to trace curve
	Parameters:
		mask=[input]curve mask, 8 bit gray. Candidate curve point have value OCV_CURVE_LOCALMAX
		x=[modify]found start point x
		y=[modify]found start point y
		radius=[input]radius of neighborhood region to search
	Return:
		Returns 0 if not found, and 1 if found, negative error code on failure
*/
int digitizer_find_trace_start(const MatrixObject& moMask, int& x, int& y, int radius=3);
///End FIND_BETTER_TRACE_START_POINT_IN_NEIGHBORHOOD

//comments last updated by Rex 12/09/2011
/**$
		Curve tracing according to paper: C. Steger, "An unbiased detector of curvilinear structures,"
		IEEE Transactions on Pattern Analysis and Machine Intelligence, Feb. 1998.
	Parameters:
		moSalient=[input]salient image, 32 bit floating. The pixel value indicates the salient extent of
				a point being a curve
		moAngle=[modify]orientation image, with same type and size as moSalient. Curve tracing will 
				continue reversely when reaching an end, and finish when reaching another.
		moMask=[modify]flag image 8 bit gray. Flag value OCV_CURVE_BACKGD means a background, 
				OCV_CURVE_SALIENT means a salient point(>threshould), and OCV_CURVE_LOCALMAX means a 
				curve center(salient point being local maxima along its orientation), it's candidate
				point for tracing. After tracing, the curve center's value will set to OCV_CURVE_TRACED
		x0=[input]x value of start point
		y0=[input]y value of start point
		vX=[output]x of returned curve points
		vY=[output]y of returned curve points
	Return:
		Returns 0 on successful exit and a negative error code on failure.
*/
int digitizer_curve_trace(const MatrixObject& moSalient, MatrixObject& moAngle, MatrixObject& moMask, 
						  int x0, int y0, vector<int>& vX, vector<int>& vY);

						  
//comments last updated by Rex 12/09/2011
/**$ 
		Find the area of a symbol and get its bounding rectangle
	Parameters:
		moImage=[input]source gray image
		rect=[output]returned bounding box
		x0=[input]start point x
		y0=[input]start point y
		nSymSize=[input][optional]maxmuml allowed symbol size, default 20
		dLowDiff=[input][optional]maximal lower difference between the symbol pixel and its neighbors,
				default 20.0
		dUpDiff=[input][optional]maximal upper difference between the symbol pixel and its neighbors,
				default 20.0
	Return:
		Returns 0 on successful exit and a negative error code on failure.
*/						  
int digitizer_get_symbol_rect(const MatrixObject& moImage, RECT& rect, int x0, int y0, int nSymSize = 20, 
						  double dLowDiff = 20.0, double dUpDiff = 20.0);

						  
//comments last updated by Rex 12/09/2011
/**$ 
		Clean the bacakground automatically
	Parameters:
		moSrcImg=[input]source gray(8 bit) or color(32 bit) image
		moDstImg=[output]destination image with same size and type as source image. The background pixels 
				are set to white color(255), and others kept the same as moSrcImg
		moMaskImg=[output]destination mask image with same size as source image and 8 bit data type. The 
				background pixels are set to zero while others set to 1
	Return:
		Returns 0 on successful exit and a negative error code on failure.
*/
///Rex 2/1/2012 ORG-4794-S4 IMPROVE_DIGITIZER_CURVE_DETECT
//int digitizer_clean_background(const MatrixObject& moSrcImg, MatrixObject& moDstImg, MatrixObject& moMaskImg);
int digitizer_clean_background(MatrixObject& moImage, const MatrixObject& moMaskImg, int bkValue=255);

int digitizer_auto_threshold(const MatrixObject& moImage, MatrixObject& moMaskImg);
///End IMPROVE_DIGITIZER_CURVE_DETECT

//comments last updated by Rex 12/09/2011
/**$ 
		Compares a template against overlapped image regions
	Parameters:
		moSrcImg=[input]source gray(8 bit) or color(32 bit) image
		moTmplImg=[input]template gray(8 bit) or color(32 bit) image, it must not be greater than source
				image and have same data type
		moDstImg=[output]comparison results, with same size as source image and 32 bit floating type 
		threshold=[input][optional]comparison result less than threshold are set to zero, default 0.8
	Return:
		Returns 0 on successful exit and a negative error code on failure.
*/
int digitizer_match_template(const MatrixObject& moSrcImg, const MatrixObject& moTmplImg, 
							 MatrixObject& moDstImg, double threshold = 0.8);

							 
//comments last updated by Rex 12/09/2011
/**$
		Find symbol in an image
	Parameters:
		moSrcImg=[input]source gray(8 bit) or color(32 bit) image
		moTmplImg=[input]gray(8 bit) or color(32 bit) image, it must not be greater than source image and
				have same data type
		moMaskImg=[input]8-bit birany image, operation mask, it must have same size as moSrcImg
		moDstImg=[output]destination 8 bit image, has non-zero values at found symbol locations
		moResImg=[output]destination 32 bit float image, the similarity results
		vX=[output]x of returned symbol locations
		vY=[output]y of returned symbol locations
		vS=[output]similarity value of returned symbol locations
		threshold=[input][optional]minmial similarity value, default 0.75
	Return:
		Returns 0 on successful exit and a negative error code on failure.
		
*/
int digitizer_symbol_finding(const MatrixObject& moSrcImg, const MatrixObject& moSymImg, const MatrixObject& moMaskImg,
							 MatrixObject& moDstImg, MatrixObject& moResImg, vector<int>& vX, vector<int>& vY,
							 vector<float>& vS, double threshold = 0.75);
		
							 
//comments last updated by Rex 12/09/2011
/**$
		Remove the gridlines in a binary image
	Parameters:
		moSrcImg=[input]source gray(8 bit) or color(32 bit) image
		moSrcMask=[input]8-bit birany image, operation mask. it must have same size as moSrcImg
		moDstImg=[output]destination gray(8 bit) or color(32 bit) image
		moDstMask=[output]8-bit birany image
		threshold=[input][optional]accumulator threshold, parameter for probabilistic Hough transform to detect
				the gridlines. Default is 20
		minLen=[input][optional]minmum gridline length, parameter for probabilistic Hough transform to detect
				the gridlines. Default is 20
		maxGap=[input][optional]maximum allowed gap between points on the same line to link them, parameter for 
				probabilistic Hough transform to detect the gridlines. Default is 5
		angleTol=[input][optional]angle tolenrace of the gridlines, default is 1.0
	Return:
		Returns 0 on successful exit and a negative error code on failure.		
*/
int digitizer_remove_gridlines(const MatrixObject& moSrcImg, const MatrixObject& moSrcMask,  MatrixObject& moDstImg, 
							   MatrixObject& moDstMask, double threshold=20, double minLen=20, double maxGap = 5, 
							   double angleTol=1);							   

							   
//comments last updated by Rex 12/09/2011
/**$
		Gridmesh settings used for digitizing an area		
*/
typedef struct
{
	int x, y, width, height, step;
	int minlen, maxgap;	
	float theta;
} DigitizeAreaSettings;


//comments last updated by Rex 12/09/2011
/**$
		Digitize an area specified by a gridmesh setting
	Paramters:
		moBwImg=[input]input 8bit binray image
		dasSettings=[input]gridmesh settings
		vX=[input]x of returned points
		vY=[input]y of returned points
	Return:
		Returns 0 on successful exit and a negative error code on failure.		
*/
int digitizer_digitize_area(const MatrixObject& moBwImg, const DigitizeAreaSettings& dasSettings, 
							vector<int>& vX, vector<int>& vY);
///End DIGITIZER_AUTO_TRACE_LINE_FUNCTIONS

///Rex 2012/4/9 ORG-5112-P2 ROTATE_IMAGE_WITH_OPENCV 
int digitizer_rotate(const MatrixObject& moSrcImg, MatrixObject& moDstImg, double angle, 
					 int flags/*=CV_INTER_LINEAR+CV_WARP_FILL_OUTLIERS*/, COLORREF fillColor/*=COLOR_WHITE*/);
///End ROTATE_IMAGE_WITH_OPENCV 

///Rex 2012/4/13 ORG-5112 FIX_UPDATE_IMAGE_TO_GRAPHOBJECT
HDIB digitizer_convert2DIB(const MatrixObject& mo);
///End FIX_UPDATE_IMAGE_TO_GRAPHOBJECT

//BOOL	OpenDigitizer();

//BOOL	import_image_and_open_digitizer90();

//void	digitizer_events(int nEvent, string strName);

///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
//BOOL	digitizer_calculate_one_point(double x, double y, string* pstr = NULL)
BOOL	digitizer_calculate_one_point(double& x, double& y, string* pstr = NULL);
///End OPTIMIZE_PICKED_POINT

///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
//BOOL	digitizer_add_one_point(double x, double y, string* pstr = NULL)
BOOL	digitizer_add_one_point(double& x, double& y, string* pstr = NULL);
///End OPTIMIZE_PICKED_POINT

//BOOL	digitizer_check_update_on_dlg_show();

///Jasmine 03/11/11 ORG-2286 KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP
//BOOL	digitizer_clean_page_relative_data(string strAttachPage);
///End KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP

/*------------------------------------------------------------------------------*
 * utilities function end 														*
 *------------------------------------------------------------------------------*/
#endif//_DIGITIZER_UTILS_H
