/*------------------------------------------------------------------------------*
 * File Name:	digitizer_utiles.cpp											*
 * Creation: 	Folger 10/26/2010												*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp.	2010, 2011, 2012,2013						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH				*
 *	Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID	*
 *	Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION	*
 *	Folger 01/06/2011 ORG-1512-S6 DIGITIZER_ADD_LINE_END_SYMBOL_TO_INDICATE_SELECTION
 *	Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH	*
 *	Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT				*
 *	Folger 02/22/2011 ORG-2309-P1 NEVER_RENAME_PAGE_SHORT_NAME_BY_LONG_NAME_IN_DIGITIZER
 *	Folger 04/19/2011 ORG-2684-P1 DIGITIZER_RUNTIME_ERRO_AFTER_DELETE_AXIS_SCALE_VALUE
 *	Folger 08/03/2011 ORG-3412-P1 DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO
 *	Folger 08/24/2011 ORG-3608-P1 DIGITZER_FAILED_TO_LOAD_AXIS_SCALE_TYPE_FROM_THEME
 *	Folger 08/31/2011 ORG-3667-S1 ADD_ESC_HINT_FOR_DIGITIZER_GET_POINTS			*
 *	Rex 10/18/2011 RSRCH-72 DIGITIZER_AUTO_TRACE_LINE_FUNCTIONS 				*
 *	Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE					*
 *  Iris 10/25/2011 FIX_NO_OPENDLG_BUTTON_SHOW_AFTER_DIALOG_CLOSE				*
 *  Iris 12/22/2011 ORG-4685-S1 HIDE_LINE_OF_DATAPLOT							*
 *  Iris 01/18/2012 ORG-4894-P1 FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
 *	Rex 2/1/2012 ORG-4794-S4 IMPROVE_DIGITIZER_CURVE_DETECT						*
 *	Rex 2012/4/9 ORG-5112-P2 ROTATE_IMAGE_WITH_OPENCV 							*
 *	Rex 2012/4/11 ORG-5112-P9 FIX_MEMORY_LEAK_IN_MANIFIER						*
 *	Rex 2012/4/11 ORG-5112-P4 FIX_BLACK_BORDER_OF_MANIFIER						*
 *	Rex 2012/4/13 ORG-5112 FIX_UPDATE_IMAGE_TO_GRAPHOBJECT						*
 *	Folger 05/04/2012 ORG-5616-P1 DIGITIZER_BETTER_PAGE_LAYER_SIZE				*
 *  Rex 2012/7/11 ORG-5112-P5 FIND_BETTER_TRACE_START_POINT_IN_NEIGHBORHOOD		*
 *  Iris 7/25/2012 ORG-6310 SET_DATA_PLOT_WITH_DIFFERENT_COLOR					*
 *	Tony 08/20/2012 ORG-6511-P1 IMPORT_SAME_NAME_GRAPH_USING_DIFFERENT_NAME		*
 *	Folger 08/28/2012 ORG-3412-P1 SHOW_ACUTAL_IMAGE_PIXELS_IN_DIGITIZER_PIXEL_LIST
 *  Iris 9/06/2012 ORG-5112-P7 FIX_UNCHECK_SHOW_CHECKBOX_SELECTION_STILL_KEEP	*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <image_utils.h>
#include <opencv.h>
#include <xfutils.h>
#include <ocGDI.h>
#include <Profiler.h>


#include <..\Originlab\DialogEx.h>
#include <..\Originlab\grobj_utils.h>
#include <..\Originlab\graph_utils.h>
#include <..\Originlab\WksColLabels.h>

#include <..\Originlab\GraphObjTools.h>
#include <..\Originlab\digitizer_utils.h>

#include <..\Originlab\matdata_utils.h>


#define		STR_IMAGE_BACKUP_NAME	STR_IMAGE_NAME "Backup"
#define		STR_OBJ_NAME_PREFIX		STR_IMAGE_NAME
#define		STR_CLIPBOARD_IMAGE_NAME	"ClipboardImage"		///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER

#define		MULTIPLE_CURVES
//---move to digitizer_utilsh
//struct	DigitizerCoordinates
//{
	//double		value;
	//int			nx;
	//int			ny;
	//int			color;
//};
//
//struct DigitizerAxisData
//{
	//int					nScaleType;
	//int					nColor;
//
	//int					nFormat;
	//int					nSubFormat;
	//string				strCustomDisplay;
//};
//
//enum IMPLDATA
//{
	//IMPLDATA_INVALID	= -1,
//
	//IMPLDATA_X1			= 0,
	//IMPLDATA_X2,
	//IMPLDATA_Y1,
	//IMPLDATA_Y2,
	//IMPLDATA_XREF,
	//IMPLDATA_YREF,
	//
	//IMPLDATA_TOTAL,
//};
//---end

#define		PLOT_COLOR(nn)						SYSCOLOR_RED + nn

enum
{
	IMPLDATACNTRL_AXIS_EDITING					= 0x00000001,
	IMPLDATACNTRL_X1_FROM_YAXIS					= 0x00000002,
	IMPLDATACNTRL_Y1_FROM_XAXIS					= 0x00000004,
	IMPLDATACNTRL_DLG_OPEN						= 0x00000008,
	///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	IMPLDATACNTRL_ROTATION_MODE					= 0x00000010,
	///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	IMPLDATACNTRL_LABEL_EDITING					= 0x00000020,
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	IMPLDATACNTRL_AXIS_EDITING_BY_ROTATE		= 0x00000040,
	IMPLDATACNTRL_AXIS_EDITING_BY_LABEL_EDITING	= 0x00000080,
	
	IMPLDATACNTRL_X_REF_LINE_SHOW				= 0x00000100,
	IMPLDATACNTRL_Y_REF_LINE_SHOW				= 0x00000200,
};

#define		MAKE_DIGITIZER_DATA_PLOT(_plot)		DigitizerObjsHolder	objs; DigitizerDataPlot	_plot(this, &objs)
	
#define		GENERIC_UPDATE_EVENT		-1
#define		STR_DEFAULT_DATA_NAME				"[DigiData]Result!PickedY1"
#define		STR_DIGITIZER_DATA_PLOT_NAME		"DigiPlot"

#define		ID_DIGITIZER_MSG_UPDATE_INFO					0x1000
#define		ID_DIGITIZER_MSG_UPDATE_INFO_SELECTION			0x1001
#define		ID_DIGITIZER_MSG_ENABLE_DIGITIZE				0x1002
#define		ID_DIGITIZER_MSG_SET_AXIS_COLOR					0x1003
#define		ID_DIGITIZER_MSG_UPDATE_FROM_POINTS				0x1004
///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
#define		ID_DIGITIZER_MSG_UPDATE_DYNACTRL				0x1005
///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
#define		ID_DIGITIZER_MSG_SAVE_SETTINGS					0x1006

#define 	NUM_MAGNIFIER_MARKER_SIZE_PERCENT				20.0

/// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED
// set size and set data type cost to much times, if equal, no need set again
#define _SET_MAT_SIZE(mo, nRows, nCols) 									\
	if( mo.GetNumRows() != nRows || mo.GetNumCols() != nCols )				\
		mo.SetSize(nRows, nCols, 0);	
	
#define _SET_MAT_DATA_TYPE(mo, type)				\
	if( mo.GetInternalDataType() != type )			\
		mo.SetInternalDataType(type);				
///End IMPROVE_DIGITIZER_AREA_SPEED

/*------------------------------------------------------------------------------*
 * DigitizerImplData	 														*
 *------------------------------------------------------------------------------*/
//struct	DigitizerImplData
//public:
DigitizerImplData::DigitizerImplData()
{
	Init();
}

void	DigitizerImplData::Init(BOOL bKeppGeneralSettings/* = FALSE*/)
{
	x1.value = y1.value = 1;
	x2.value = y2.value = 10;

	x1.nx = x1.ny =
	x2.nx = x2.ny =
	y1.nx = y1.ny =
	y2.nx = y2.ny = -1;

	ClearAllData();

	SetDataName(STR_DEFAULT_DATA_NAME);

	/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	//nDataColor = SYSCOLOR_RED;
	nDataColor = PLOT_COLOR(0);
	///End IMPROVE_MULTIPLE_CURVES

	strImageName.Empty();
	nImageWidth = nImageHeight = 0;
	
	/// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
	//strSrcMatrix.Empty();				///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE	
	strImageMatrix.Empty();
	///End IMPROVE_IMAGE_PROCESS_MATRIX
	
	rAngleRotated = 0;

	///------ Folger 01/12/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	SetLabelEditing(FALSE);
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	if ( !bKeppGeneralSettings )
	{
		axisX.nScaleType = axisY.nScaleType = LINEAR_SPACE;
		axisX.nColor = SYSCOLOR_DKGRAY;
		axisY.nColor = SYSCOLOR_NAVY;

		axisX.nFormat = axisY.nFormat = OKCOLTYPE_NUMERIC;
		axisX.nSubFormat = axisY.nSubFormat = 0;

		x1.color = y1.color = SYSCOLOR_BLUE;
		x2.color = y2.color = SYSCOLOR_RED;

		rAngleInc = 0.5;

		dwCntrls = 0;
		SetAxisEditing(TRUE);
		SetX1FromYAxis(TRUE);
		SetY1FromXAxis(TRUE);
	}
	
	/// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA		
	stROIGridInfo.bVertical = true;
	stROIGridInfo.nStep = 10;
	bDigitizingArea = false;
	bDeletingPoints = false;
	///End MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
	
	/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
	nCoordinatesType = COORDINATES_TYPE_NORMAL_XY;
	///End SUPPORT_TERNARY_IN_DIGITIZER
}

BOOL	DigitizerImplData::Size()
{
	return PtsScrX.GetSize();
}

int		DigitizerImplData::GetPointHalfSize()
{
	///------ Folger 08/10/2011 ORG-3412-P1 DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO
	//return 13;
	return max(nImageWidth, nImageHeight) / 150;
	///------ End DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO
}

BOOL	DigitizerImplData::IsReady()
{
	return IsXReady() && IsYReady();
}

BOOL	DigitizerImplData::IsXReady()
{
	return IsCoornianteReady(x1) && IsCoornianteReady(x2);
}

BOOL	DigitizerImplData::IsYReady()
{
	return IsCoornianteReady(y1) && IsCoornianteReady(y2);
}

BOOL	DigitizerImplData::IsCoornianteReady(DigitizerCoordinates& coor)
{
	return !is_missing_value(coor.value) && -1 != coor.nx && -1 != coor.ny;
}

string	DigitizerImplData::MakeObjName(LPCSTR lpcsz)
{
	string		strName;
	strName.Format("%s%s", STR_OBJ_NAME_PREFIX, lpcsz);
	return strName;
}

BOOL	DigitizerImplData::UpdateDataNameByImageFileName(LPCSTR lpcszFile)
{
	string	strBook, strSheet, strCol;
	if ( !okutil_parse_complete_range_string(GetDataName(), &strBook, &strSheet, &strCol) )
		return FALSE;
	
	strImageFile = lpcszFile;			///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	
	strImageName = GetFileName(lpcszFile);
	///------ Tony 08/20/2012 ORG-6511-P1 IMPORT_SAME_NAME_GRAPH_USING_DIFFERENT_NAME
	for(int ii = 0; ii < MAXLINE; ii++)
	{
		bool bFlag = true;
		string strImageNewName;
		string strNameEnd;
		if(ii != 0)
		{
			strNameEnd.Format("-%d", ii);
			strImageNewName = strImageName + strNameEnd;
		}
		else
		{
			strImageNewName = strImageName;
		}
		foreach(GraphPage gp in Project.GraphPages)
		{
			
			string strName;
			strName = gp.GetLongName();
			if(!strImageNewName.CompareNoCase(strName))
			{
				bFlag = false;
				break;
			}
		}
		if(bFlag)
		{
			strImageName = strImageNewName;
			break;
		}
	}
	///------ End IMPORT_SAME_NAME_GRAPH_USING_DIFFERENT_NAME
	string		strDataName;
	///------ Tony 08/20/2012 ORG-6511-P1 IMPORT_SAME_NAME_GRAPH_USING_DIFFERENT_NAME
	//okutil_create_complete_range_string_obj(&strDataName, strBook, GetFileName(strImageName, TRUE), strCol);
	okutil_create_complete_range_string_obj(&strDataName, strBook, strImageName, strCol);
	///------ End IMPORT_SAME_NAME_GRAPH_USING_DIFFERENT_NAME
	SetDataName(strDataName);
	return TRUE;
}

///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
BOOL	DigitizerImplData::UpdateDataNameForClipboardImage()
{
	string	strBook, strSheet, strCol;
	if ( !okutil_parse_complete_range_string(GetDataName(), &strBook, &strSheet, &strCol) )
		return FALSE;
	strImageName = STR_CLIPBOARD_IMAGE_NAME;
	char snBuffer[MAXLINE];
	int  nn = 0;
	// to name the Clipboard Image
	while(0 == nn)
	{
		nn = string_to_prefix_end_number( snBuffer, strImageName );
		strImageName.Format("%s%d",snBuffer,++nn);
		nn = 1;
		foreach(GraphPage gp in Project.GraphPages)
		{
			string strLN = gp.GetLongName();
			// to check if name is existed in current gp
			if( strImageName == strLN )
			{
				nn = 0;
				break;
			}
		}
	}

	string		strDataName;
	okutil_create_complete_range_string_obj(&strDataName, strBook, strImageName, strCol);
	SetDataName(strDataName);
	return TRUE;
}
///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER

//Tony 8/29/2012 In case too long image name
BOOL	DigitizerImplData::UpdateDataNameByNewSheetName(string &strNewSheetName)
{
	string	strBook, strSheet, strCol;
	if ( !okutil_parse_complete_range_string(GetDataName(), &strBook, &strSheet, &strCol) )
		return FALSE;

	string strNewDataName;
	okutil_create_complete_range_string_obj(strNewDataName, strBook, strNewSheetName, strCol);
	SetDataName(strNewDataName);
	return TRUE;
}
//end

BOOL	DigitizerImplData::UpdateDataName(string& strName)
{
	string	strBook, strSheet, strCol;
	if ( okutil_parse_complete_range_string(strName, &strBook, &strSheet, &strCol) && !strBook.IsEmpty() && !strSheet.IsEmpty() && !strCol.IsEmpty() )
		return TRUE;
	
	if ( !strBook.IsEmpty() && strSheet.IsEmpty() && strCol.IsEmpty() )
	{
		strCol = strBook;
		strBook.Empty();
	}
	
	string	strBook2, strSheet2, strCol2;
	okutil_parse_complete_range_string(GetDataName(), &strBook2, &strSheet2, &strCol2);
	if ( strBook.IsEmpty() )
		strBook = strBook2;		
	if ( strSheet.IsEmpty() )
		strSheet = strSheet2;
	
	okutil_create_complete_range_string_obj(strName, strBook, strSheet, strCol);
	return TRUE;
}

#define		STR_NUM_FORMAT			"*"
string		DigitizerImplData::GetValue(DigitizerCoordinates& coor, DigitizerAxisData* pAxisData/* = NULL*/)
{
	return GetValue(coor.value, pAxisData);
}

string		DigitizerImplData::GetValue(double rValue, DigitizerAxisData* pAxisData/* = NULL*/)
{
	if ( NULL == pAxisData || OKCOLTYPE_NUMERIC == pAxisData->nFormat )
		return ftoa(rValue, STR_NUM_FORMAT);

	JulianDateTimeConverter			convert;
	string							str = ftoa(rValue);
	convert.DateTimeToStr(str, DataTimeStr(pAxisData), pAxisData->strCustomDisplay);
	return str;
}

double		DigitizerImplData::GetValue(LPCSTR lpcsz, DigitizerAxisData* pAxisData/* = NULL*/)
{
	if ( NULL == pAxisData || OKCOLTYPE_NUMERIC == pAxisData->nFormat )
		return atof(lpcsz);

	JulianDateTimeConverter			convert;
	string							str = lpcsz;
	convert.StrToDateTime(str, DataTimeStr(pAxisData), pAxisData->strCustomDisplay);
	return atof(str);
}

BOOL	DigitizerImplData::UpdateX1X2FromY1()
{
	//if ( IsY1FromXAxis() )
	//{
		//x1.ny = x2.ny = y1.ny;
	//}
	return TRUE;
}

BOOL	DigitizerImplData::UpdateY1Y2FromX1()
{
	//if ( IsX1FromYAxis() )
	//{
		//y1.nx = y2.nx = x1.nx;
	//}
	return TRUE;
}

DWORD	DigitizerImplData::ConvertTabIndex(UINT nTabIndex)
{
	return nTabIndex << 24;
}

#define		ID_DATA_XSCALE_TYPE		0x0001
#define		ID_DATA_YSCALE_TYPE		0x0002

#define		ID_DATA_X1_VALUE		0x0003
#define		ID_DATA_X1_COLOR		0x0004
#define		ID_DATA_X1_NX			0x0005
#define		ID_DATA_X1_NY			0x0006
#define		ID_DATA_X2_VALUE		0x0007
#define		ID_DATA_X2_COLOR		0x0008
#define		ID_DATA_X2_NX			0x0009
#define		ID_DATA_X2_NY			0x000a
#define		ID_DATA_Y1_VALUE		0x000b
#define		ID_DATA_Y1_COLOR		0x000c
#define		ID_DATA_Y1_NX			0x000d
#define		ID_DATA_Y1_NY			0x000e
#define		ID_DATA_Y2_VALUE		0x000f
#define		ID_DATA_Y2_COLOR		0x0010
#define		ID_DATA_Y2_NX			0x0011
#define		ID_DATA_Y2_NY			0x0012

#define		ID_DATA_XAXIS_COLOR		0x0013
#define		ID_DATA_YAXIS_COLOR		0x0014

#define		ID_DATA_ANGLE_ROTATED	0x0015
#define		ID_DATA_ANGLE_INC		0x0016

void	DigitizerImplData::PrepareAxesTreeIDs(TreeNode& tr)
{
	///------ Folger 08/24/2011 ORG-3608-P1 DIGITZER_FAILED_TO_LOAD_AXIS_SCALE_TYPE_FROM_THEME
	//tr.nXScaleType.DataID = ID_DATA_XSCALE_TYPE;
	//tr.nYScaleType.DataID = ID_DATA_YSCALE_TYPE;
	//tr.nXAxisColor.DataID = ID_DATA_XAXIS_COLOR;
	//tr.nYAxisColor.DataID = ID_DATA_YAXIS_COLOR;
	tr.axisX.nScaleType.DataID = ID_DATA_XSCALE_TYPE;
	tr.axisY.nScaleType.DataID = ID_DATA_YSCALE_TYPE;
	tr.axisX.nColor.DataID = ID_DATA_XAXIS_COLOR;
	tr.axisY.nColor.DataID = ID_DATA_YAXIS_COLOR;
	///------ End DIGITZER_FAILED_TO_LOAD_AXIS_SCALE_TYPE_FROM_THEME

	tr.x1.value.DataID = ID_DATA_X1_VALUE;
	tr.x1.color.DataID = ID_DATA_X1_COLOR;
	tr.x1.nx.DataID = ID_DATA_X1_NX;
	tr.x1.ny.DataID = ID_DATA_X1_NY;

	tr.x2.value.DataID = ID_DATA_X2_VALUE;
	tr.x2.color.DataID = ID_DATA_X2_COLOR;
	tr.x2.nx.DataID = ID_DATA_X2_NX;
	tr.x2.ny.DataID = ID_DATA_X2_NY;

	tr.y1.value.DataID = ID_DATA_Y1_VALUE;
	tr.y1.color.DataID = ID_DATA_Y1_COLOR;
	tr.y1.nx.DataID = ID_DATA_Y1_NX;
	tr.y1.ny.DataID = ID_DATA_Y1_NY;
	
	tr.y2.value.DataID = ID_DATA_Y2_VALUE;
	tr.y2.color.DataID = ID_DATA_Y2_COLOR;
	tr.y2.nx.DataID = ID_DATA_Y2_NX;
	tr.y2.ny.DataID = ID_DATA_Y2_NY;

	tr.rAngleRotated.DataID = ID_DATA_ANGLE_ROTATED;
	tr.rAngleInc.DataID = ID_DATA_ANGLE_INC;
}

//public:
int	DigitizerImplData::NewData()
{
	MAKE_DIGITIZER_DATA_PLOT(plot);
	
#ifdef		MULTIPLE_CURVES
	/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	//plot.Show(FALSE); 
	///End IMPROVE_MULTIPLE_CURVES
	ClearData();
	
	int		nLast = GetNumData() - 1;
	string	strPlotName = vsDataPlots[nLast];
	string	strDataName = vsDataNames[nLast];
	
	vsDataPlots.Add(EnumName(strPlotName));
	vsDataNames.Add(EnumName(strDataName));
	vsDataUIDs.Add(0);
	nActiveData = nLast + 1;
	return nActiveData;
#else		/// MULTIPLE_CURVES
	SetDataName(EnumName(vsDataNames[nActiveData]));
	vsDataUIDs[nActiveData] = 0;
	plot.Clear();
	return 0;
#endif		/// MULTIPLE_CURVES	
}

void	DigitizerImplData::ClearData()
{
	PtsScrX.RemoveAll();
	PtsScrY.RemoveAll();
	PtsX.RemoveAll();
	PtsY.RemoveAll();
	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	PtsLabel.RemoveAll();
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH	
	/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
	PtsVertexX.RemoveAll();
	PtsVertexY.RemoveAll();
	///End SUPPORT_TERNARY_IN_DIGITIZER
}

/// Iris 9/03/2012 ORG-5112-P3 FIX_NOT_REMOVE_ALL_DATAPLOTS_WHEN_CLICKED_DELETE_WKS_GRAPH
//void	DigitizerImplData::ClearAllData()
void	DigitizerImplData::ClearAllData(bool bClearDataPlot/* = true*/)
///End FIX_NOT_REMOVE_ALL_DATAPLOTS_WHEN_CLICKED_DELETE_WKS_GRAPH
{
	ClearData();
	
	/// Iris 9/03/2012 ORG-5112-P3 FIX_NOT_REMOVE_ALL_DATAPLOTS_WHEN_CLICKED_DELETE_WKS_GRAPH
	if( bClearDataPlot )
	///End FIX_NOT_REMOVE_ALL_DATAPLOTS_WHEN_CLICKED_DELETE_WKS_GRAPH
	{
		MAKE_DIGITIZER_DATA_PLOT(plot);
		int					nData = GetNumData();
		for ( nActiveData=0; nActiveData<nData; ++nActiveData )
		{
			plot.Clear(TRUE);
		}
	}	
	
	vsDataPlots.SetSize(1);
	vsDataPlots[0] = STR_DIGITIZER_DATA_PLOT_NAME;
	vsDataNames.SetSize(1);
	vsDataUIDs.SetSize(1);
	nActiveData = 0;
}

void	DigitizerImplData::PrepareDataForCalculate(BOOL bFromScreenToData/* = TRUE*/)
{
	if ( bFromScreenToData )
	{
		PtsX = PtsScrX;
		PtsY = PtsScrY;
	}
	else
	{
		PtsScrX = PtsX;
		PtsScrY = PtsY;
	}
}

BOOL	DigitizerImplData::AddOneScreenPoint(double x, double y)
{
	PtsScrX.Add(x);
	PtsScrY.Add(y);
	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	PtsLabel.Add("");
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	return TRUE;
}

/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
BOOL	DigitizerImplData::AddOneVertex(double x, double y)
{
	PtsVertexX.Add(x);
	PtsVertexY.Add(y);
	return TRUE;
}

BOOL 	DigitizerImplData::IsVertexsReady()
{	
	return NUM_VERTEXS == PtsVertexX.GetSize();
}
///End SUPPORT_TERNARY_IN_DIGITIZER

///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
BOOL	DigitizerImplData::AddScreenPoints(const vector& vx, const vector& vy)
{
	PtsScrX.Append(vx);
	PtsScrY.Append(vy);
	
	vector<string> vs( vx.GetSize() );
	PtsLabel.Append(vs);
	return TRUE;
}
///End DIGITIZER_AUTO_TRACE_LINE

int		DigitizerImplData::GetActiveData()
{
	return nActiveData;
}

BOOL	DigitizerImplData::SetActiveData(int nData)
{	
	/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	if( nData < 0 || nData == nActiveData )
		return FALSE;
	///End IMPROVE_MULTIPLE_CURVES	
	
	ERR_MSG("DigitizerImplData::SetActiveData");
	
	ClearData(); // Iris, to clear the current data settings
	nActiveData = nData;	
	return TRUE;
}

BOOL	DigitizerImplData::ActivatePlot()
{	
	MAKE_DIGITIZER_DATA_PLOT(plot);	
	m_bIsReadyForPlotSelectionEvent = false;
	bool bRet = plot.Activate();
	m_bIsReadyForPlotSelectionEvent = true;
	
	if( bRet )
	{
		plot.Update(GENERIC_UPDATE_EVENT);		
	}
	return bRet;
}

int		DigitizerImplData::GetNumData()
{
	return vsDataPlots.GetSize();
}

/// Iris 12/29/2011 ORG-4685-S5 SUPPORT_DELETE_LINE
BOOL	DigitizerImplData::RemoveDataCols(int nData)
{
	if( 1 == GetNumData() || nData >= GetNumData() )
		return FALSE;
	
	// copy Y column LongName 
	Worksheet wks;
	int c1, c2;
	for(int nCopyTo = GetNumData() - 1, nCopyFrom = nCopyTo - 1; nCopyTo >= 0 && nCopyFrom >= 0 && nCopyFrom >= nData; --nCopyFrom, --nCopyTo)
	{
		DataRange drFrom;
		Column colFrom;
		if( okxf_init_range_from_string(&drFrom, vsDataNames[nCopyFrom]) )
		{		
			drFrom.GetRange(wks, c1, c2);
			colFrom.Attach(wks, c1);
		}
		
		if( colFrom )
		{
			DataRange drTo;
			Column colTo;
			if( okxf_init_range_from_string(&drTo, vsDataNames[nCopyTo]) )
			{
				drTo.GetRange(wks, c1, c2);	
				colTo.Attach(wks, c1);
			}	
			
			if( colTo )
			{
				colTo.SetLongName(colFrom.GetLongName());
				vsDataNames[nCopyTo] = vsDataNames[nCopyFrom];
			}
		}		
	}
	
	// delete the current data range columns
	DataRange dr;
	if( okxf_init_range_from_string(&dr, vsDataNames[nData]) )
	{
		dr.GetRange(wks, c1, c2);
		
		Column colX(wks, c1 - 1);
		Column colY(wks, c1);
		Column colL(wks, c1 + 1);
		if( colX && colY && colL )
		{
			colX.Destroy();
			colY.Destroy();
			colL.Destroy();
		}
	}		
	
	vsDataNames.RemoveAt(nData);
	return TRUE;
}
///End SUPPORT_DELETE_LINE

BOOL	DigitizerImplData::RemoveActiveData()
{
	/// Iris 12/29/2011 ORG-4685-S5 SUPPORT_DELETE_LINE
	/*
	if ( vsDataPlots.GetSize() == 1 )
	{
		ClearData();
		return FALSE;
	}

	vsDataPlots.RemoveAt(nActiveData);
	vsDataNames.RemoveAt(nActiveData);
	vsDataUIDs.RemoveAt(nActiveData);
	*/
	MAKE_DIGITIZER_DATA_PLOT(plot);
	if( GetNumData() == 1 )
	{
		vsDataUIDs[nActiveData] = 0;
		plot.Clear();
	}
	else
	{
		int nNextData = nActiveData != GetNumData() - 1 ? nActiveData : nActiveData - 1;		
		plot.Delete(nActiveData);// remove data plot object		
		
		RemoveDataCols(nActiveData);
		vsDataPlots.RemoveAt(nActiveData);		
		vsDataUIDs.RemoveAt(nActiveData);	
		
		// set the next data as active data	
		if( nNextData >= 0 )
		{
			SetActiveData(nNextData);
			plot.Activate();
		}
	}
	///End SUPPORT_DELETE_LINE
	return TRUE;
}

/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
void 	DigitizerImplData::GetAllPlotNames(vector<string>& vsNames)
{
	vsNames = vsDataPlots;
}
///End IMPROVE_MULTIPLE_CURVES

string	DigitizerImplData::GetPlotName()
{
	/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	if( nActiveData < vsDataPlots.GetSize() ) 
	///End IMPROVE_MULTIPLE_CURVES
		return vsDataPlots[nActiveData];
	
	ASSERT(false);
	return "";
}
	
string	DigitizerImplData::GetDataName()
{
	return vsDataNames[nActiveData];
}
void	DigitizerImplData::SetDataName(LPCSTR lpcsz)
{
	vsDataNames[nActiveData] = lpcsz;
}
void	DigitizerImplData::SetDataName(LPCSTR lpcszBookSheet, LPCSTR lpcszCol)
{
	vsDataNames[nActiveData].Format("%s%c%s", lpcszBookSheet, AREA_SHEETNAME_NAME_END_CHAR, lpcszCol);
}

OUID	DigitizerImplData::GetDataUID()
{
	return vsDataUIDs[nActiveData];
}
void	DigitizerImplData::SetDataUID(OUID uid)
{
	vsDataUIDs[nActiveData] = uid;
}

int		DigitizerImplData::GetPlotColor()
{
	MAKE_DIGITIZER_DATA_PLOT(plot);
	Tree	tr;
	if( plot.GetFormat(tr, FPB_STYLE_COLOR) )
	{	
		TreeNode	trEdgeColor = tr.Root.Symbol.EdgeColor;
		if ( trEdgeColor )
			nDataColor = trEdgeColor.nVal;
		return nDataColor;
	}
	return -1;
}

BOOL	DigitizerImplData::SetPlotColor(int nColor)
{
	if ( nColor >= 0 )
		nDataColor = nColor;
	/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	else
		nDataColor = PLOT_COLOR(nActiveData);
	///End IMPROVE_MULTIPLE_CURVES

	Tree	tr;
	tr.Root.Color.nVal = tr.Root.Symbol.EdgeColor.nVal = nDataColor;	
	/// Iris 12/22/2011 ORG-4685-S1 HIDE_LINE_OF_DATAPLOT
	//tr.Root.Symbol.Shape.nVal = 1;
	tr.Root.Symbol.Shape.nVal = 2; // circle
	tr.Root.Symbol.FillColor.nVal = nDataColor; 
	///End HIDE_LINE_OF_DATAPLOT
	
	MAKE_DIGITIZER_DATA_PLOT(plot);
	return plot.ApplyFormat(tr);
}

///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
BOOL	DigitizerImplData::GetPlotData(TreeNode& tr)
{
	tr.Root.Data.X.dVals = PtsScrX;
	tr.Root.Data.Y.dVals = PtsScrY;

	tr.Root.Label.Data.strVals = PtsLabel;
	tr.Root.Label.Cntrl.nVal = (IsLabelEditing() ? MLC_SHOW : MLC_TOOLTIP) | MLC_ALT_NONEMPTY;
	tr.Root.Label.Color.nVal = SYSCOLOR_BLUE;
	tr.Root.Label.Alt.Color.nVal = SYSCOLOR_GREEN;
	tr.Root.Label.Font.Size.nVal = 10;

	return TRUE;
}

BOOL	DigitizerImplData::SetPlotData(TreeNode& tr)
{
	PtsScrX = tr.Root.Data.X.dVals;
	PtsScrY = tr.Root.Data.Y.dVals;

	TreeNode	trLabel = tr.Root.Label.Data;
	if ( trLabel )
		PtsLabel = trLabel.strVals;
	else
		PtsLabel.SetSize(Size());

	return TRUE;
}
///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH


//public:
BOOL	DigitizerImplData::IsAxisEditing()
{
	return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_AXIS_EDITING);
}
void	DigitizerImplData::SetAxisEditing(BOOL bOn)
{
	O_SET_BIT(dwCntrls, IMPLDATACNTRL_AXIS_EDITING, bOn);
}

BOOL	DigitizerImplData::IsX1FromYAxis()
{
	return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_X1_FROM_YAXIS);
}
void	DigitizerImplData::SetX1FromYAxis(BOOL bOn)
{
	O_SET_BIT(dwCntrls, IMPLDATACNTRL_X1_FROM_YAXIS, bOn);
}

BOOL	DigitizerImplData::IsY1FromXAxis()
{
	return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_Y1_FROM_XAXIS);
}
void	DigitizerImplData::SetY1FromXAxis(BOOL bOn)
{
	O_SET_BIT(dwCntrls, IMPLDATACNTRL_Y1_FROM_XAXIS, bOn);
}

BOOL	DigitizerImplData::IsXRefLineShow()
{
	return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_X_REF_LINE_SHOW);
}

void	DigitizerImplData::SetXRefLineShow(BOOL bShow)
{
	O_SET_BIT(dwCntrls, IMPLDATACNTRL_X_REF_LINE_SHOW, bShow);
}		

BOOL	DigitizerImplData::IsYRefLineShow()
{
	return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_Y_REF_LINE_SHOW);
}

void	DigitizerImplData::SetYRefLineShow(BOOL bShow)
{
	O_SET_BIT(dwCntrls, IMPLDATACNTRL_Y_REF_LINE_SHOW, bShow);
}	

BOOL	DigitizerImplData::IsDlgOpen()
{
	return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_DLG_OPEN);
}
void	DigitizerImplData::SetDlgOpen(BOOL bOn)
{
	O_SET_BIT(dwCntrls, IMPLDATACNTRL_DLG_OPEN, bOn);
}

/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
//BOOL	DigitizerImplData::IsRotationMode()
//{
	//return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_ROTATION_MODE);
//}
//void	DigitizerImplData::SetRotationMode(BOOL bOn)
//{
	//O_SET_BIT(dwCntrls, IMPLDATACNTRL_ROTATION_MODE, bOn);
//}
/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
//End FIX_ROTATE_GETN_DLG_ISSUE

///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
BOOL	DigitizerImplData::IsLabelEditing()
{
	return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_LABEL_EDITING);
}
void	DigitizerImplData::SetLabelEditing(BOOL bOn)
{
	O_SET_BIT(dwCntrls, IMPLDATACNTRL_LABEL_EDITING, bOn);
}
///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

BOOL	DigitizerImplData::IsAxisEditingByOther(DWORD dwBit)
{
	return O_QUERY_BOOL(dwCntrls, dwBit);
}
void	DigitizerImplData::SetAxisEditingByOther(DWORD dwBit, BOOL bOn)
{
	O_SET_BIT(dwCntrls, dwBit, bOn);
}

//private:
string	DigitizerImplData::EnumName(LPCSTR lpcszName)
{
	char	szBuffer[MAXLINE];
	string	strDataName	= lpcszName;
	int		nn = string_to_prefix_end_number(szBuffer, strDataName);
	if ( nn == 0 )
	{
		strDataName += "1";
	}
	else
	{
		strDataName.Format("%s%d", szBuffer, nn + 1);
		
	}
	return strDataName;
}

string	DigitizerImplData::DataTimeStr(DigitizerAxisData* pAxisData)
{
	if ( OKCOLTYPE_NUMERIC == pAxisData->nFormat )
		return "";

	CurrentDateTimeDisplayHelper	dtHelper;
	string	strFormat;
	dtHelper.MakeStringByFormat(strFormat, pAxisData->nFormat, pAxisData->nSubFormat);
	return strFormat;
}

/*------------------------------------------------------------------------------*
 * DigitizerImplData End 														*
 *------------------------------------------------------------------------------*/
 
/*------------------------------------------------------------------------------*
 * DigitizerObjsHolder	 														*
 *------------------------------------------------------------------------------*/

#define		DISABLE_LT_UNDO		LTVarTempChange		undoLT("@UL,", 0)

//class DigitizerObjsHolder
//public:
GraphPage	DigitizerObjsHolder::GetDigitizePage()
{
	return Project.Pages();
}

GraphLayer	DigitizerObjsHolder::GetDigitizeLayer()
{
	if ( m_gl )
		return m_gl;

	return Project.ActiveLayer();
}

void		DigitizerObjsHolder::SetDigitizeLayer(GraphLayer& gl)
{
	m_gl = gl; 
}

GraphObject	DigitizerObjsHolder::GetDigitizeImage()
{
	/// Iris 12/27/2011 ORG-4685-S3 NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE
	//return GetDigitizeLayer().GraphObjects(STR_IMAGE_NAME);
	GraphLayer gl = GetDigitizeLayer();
	if( gl )
	{
		return gl.GraphObjects(STR_IMAGE_NAME);
	}
	
	GraphObject junk;
	return junk;
	///End NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE
}

GraphObject	DigitizerObjsHolder::GetDigitizeImageBackup()
{
	return GetDigitizeLayer().GraphObjects(STR_IMAGE_BACKUP_NAME);
}

GraphObject	DigitizerObjsHolder::GetDigitizeVertex()
{	
	GraphObject go;
	GraphLayer gl = GetDigitizeLayer();
	if( gl )
	{
		go = gl.GraphObjects(STR_VERTEXS_DATA_PLOT_NAME);
	}	
	return go;
}

BOOL		DigitizerObjsHolder::Refresh()
{
	GetDigitizePage().Refresh();
	return TRUE;
}

BOOL		DigitizerObjsHolder::SetupUndoEvent(GraphObject& go)
{
	return go && SetObjProperty(go.GetName(), "UndoEvent", 1);
}

BOOL		DigitizerObjsHolder::SetupDeleteUndoable(GraphObject& go, BOOL bUndo)
{
	return go && SetObjProperty(go.GetName(), "DelUndoable", bUndo);
}

BOOL		DigitizerObjsHolder::SetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double rVal, BOOL bDelay/* = FALSE*/)
{
	DISABLE_LT_UNDO;
	string	strScript;
	strScript.Format("%s%s.%s=%g;", bDelay ? ";" : "", lpcszName, lpcszProp, rVal);
	return LT_execute(strScript);
}

BOOL		DigitizerObjsHolder::GetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double& rValue)
{
	string	strScript;
	strScript.Format("%s.%s", lpcszName, lpcszProp);
	return LT_get_var(strScript, &rValue);
}

#define		STR_PAGE_NAME		STR_IMAGE_NAME "1"
GraphPage	DigitizerObjsHolder::PrepareDigitizePage()
{
	GraphPage	gp;
	string		strTempl = Template();
	gp.Create(strTempl);
	gp.SetName(STR_PAGE_NAME, OCD_ENUM_NEXT);
	LT_set_var("page.noClick", NOCLICK_DATA_PLOT | NOCLICK_TICKLABEL | NOCLICK_LAYER | NOCLICK_LAYERICON | NOCLICK_AXES);
	return gp;
}

BOOL		DigitizerObjsHolder::IsPageValidToDigitize(GraphPage& gp)
{
	/// Iris 12/30/2011 ORG-1614-P1 FIX_REOPEN_SAVED_DIGITIZER_GRAPH_WINDOW_DIGITIZER_DLG_NOT_WORK
	//return GetFileName(page_get_template_name(gp)).CompareNoCase(Template()) == 0;
	char szTemplatePrefix[MAXLINE], strPageTemplatePrefix[MAXLINE];
	string_to_prefix_end_number(szTemplatePrefix, GetFileName(Template(), true)); 
	string_to_prefix_end_number(strPageTemplatePrefix, GetFileName(page_get_template_name(gp), true)); 
	return _stricmp(szTemplatePrefix, szTemplatePrefix) == 0;
	///End FIX_REOPEN_SAVED_DIGITIZER_GRAPH_WINDOW_DIGITIZER_DLG_NOT_WORK
}

//private:
string		DigitizerObjsHolder::Template()
{
	return "Digitizer90.otp";
}

/*------------------------------------------------------------------------------*
 * DigitizerObjsHolder End 														*
 *------------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------*
 * ObjsUpdateEventHelper 														*
 *------------------------------------------------------------------------------*/
static	BOOL	g_bDuringUpdate = FALSE;
//class ObjsUpdateEventHelper
//public:
ObjsUpdateEventHelper::ObjsUpdateEventHelper()
{
	m_bOldVal = g_bDuringUpdate;
	if ( !g_bDuringUpdate )
		g_bDuringUpdate = TRUE;
}
ObjsUpdateEventHelper::~ObjsUpdateEventHelper()
{
	g_bDuringUpdate = m_bOldVal;
}

BOOL	ObjsUpdateEventHelper::IsDuringUpdate()
{
	return m_bOldVal;
}
/*------------------------------------------------------------------------------*
 * ObjsUpdateEventHelper End 													*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 * DigitizerDataPlot		 													*
 *------------------------------------------------------------------------------*/
#define			OBJ_INTERNAL_LABTALK_SCRIPT		"run.section(graph_controls.ogs, Digitizer90, %1 this.name$);"
///Jasmine 03/11/11 ORG-2286 KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP
//#define			OBJ_MAIN_LABTALK_SCRIPT			"run.section(graph_controls.ogs, DigitizerMain);"
#define			OBJ_MAIN_LABTALK_SCRIPT			"run.section(graph_controls.ogs, DigitizerMain90, %1 this.attach$);"
///End KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP
#define			OBJ_COMMON_STATE				GOC_NO_RESIZE | GOC_NO_ROTATE | GOC_NO_SKEW | GOC_NO_EDIT

enum
{
	UPDATEFROMEVENTS_NOT_HANDLE = -1,
	UPDATEFROMEVENTS_NONE		= 0,
	UPDATEFROMEVENTS_PLOT,
	UPDATEFROMEVENTS_AXIS,
	UPDATEFROMEVENTS_VERTEX,
};

//class DigitizerDataPlot
//public:
DigitizerDataPlot::DigitizerDataPlot(DigitizerImplData* pData, DigitizerObjsHolder* pObjsHolder)
{
	m_pData = pData;
	m_pObjsHolder = pObjsHolder;
}
DigitizerDataPlot::~DigitizerDataPlot()
{
}

int	DigitizerDataPlot::NewData()
{
	return m_pData->NewData();
}

BOOL	DigitizerDataPlot::Clear(BOOL bGrOnly/* = FALSE*/)
{
	GraphObject		plot = Plot();
	if ( !bGrOnly )
		m_pData->ClearData();
	if ( plot )
		plot.Destroy();
	return TRUE;
}

BOOL	DigitizerDataPlot::Update(int nUpdate, BOOL bRefresh)
{
	ERR_MSG("DigitizerDataPlot::Update");
	Plot(nUpdate);
	
	if ( bRefresh )
		Refresh();
	return TRUE;
}

BOOL	DigitizerDataPlot::Show(BOOL bShow)
{
	GraphObject		plot = Plot();
	if ( !plot )
		return FALSE;

	plot.Show = bShow;
	
	/// Iris 9/06/2012 ORG-5112-P7 FIX_UNCHECK_SHOW_CHECKBOX_SELECTION_STILL_KEEP
	Selection sel;
	if( sel.IsSelected(plot) )
		sel.Remove(plot);
	///End FIX_UNCHECK_SHOW_CHECKBOX_SELECTION_STILL_KEEP
	
	/// Iris 12/23/2011 ORG-4685-P1 FIX_AFTER_CLOSE_DLG_SOME_DIGIPLOT_OBJS_STILL_CAN_BE_SELECTED
	// to clear up all called UpdateStates places, show or hide no need to update obj states, just keep the current states.
	//return UpdateStates();
	return true;
	///End FIX_AFTER_CLOSE_DLG_SOME_DIGIPLOT_OBJS_STILL_CAN_BE_SELECTED
}

/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
BOOL	DigitizerDataPlot::Activate()
{	
	GraphObject		plot = Plot();
	if ( !plot )
		return FALSE;
	/// Iris 9/06/2012 ORG-5112-P7 FIX_UNCHECK_SHOW_CHECKBOX_SELECTION_STILL_KEEP
	if( !plot.Show )
		return FALSE;
	///End FIX_UNCHECK_SHOW_CHECKBOX_SELECTION_STILL_KEEP

	Selection.Reset(false);
	Selection.Add(plot);	
	return TRUE;
}
///End IMPROVE_MULTIPLE_CURVES

BOOL	DigitizerDataPlot::AddOnePoint(double x,  double y)
{
	return m_pData->AddOneScreenPoint(x, y) && Update(OBJUPDATE_EXISTING, FALSE);
}

///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
BOOL	DigitizerDataPlot::AddPoints(const vector& vx, const vector& vy) 
{
	return m_pData->AddScreenPoints(vx, vy) && Update(OBJUPDATE_EXISTING, FALSE);
}
///End DIGITIZER_AUTO_TRACE_LINE

BOOL	DigitizerDataPlot::HasDataPoint()
{
	return m_pData->Size() > 0;
}

/// Iris 12/29/2011 ORG-4685-S5 SUPPORT_DELETE_LINE
BOOL 	DigitizerDataPlot::Delete(int nIndex)
{
	GraphObject		plot = Plot();
	if ( !plot )
		return FALSE;
		
	plot.Destroy();
	return TRUE;	
}
///End SUPPORT_DELETE_LINE

/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
//BOOL 	DigitizerDataPlot::DeletePoint(int nIndex)
BOOL 	DigitizerDataPlot::DeletePoints(const vector<uint>& vnIndices)
///End IMPROVE_DELETE_POINTS
{
	if( 0 == vnIndices.GetSize() )
		return FALSE;
	
	Tree tr;
	m_pData->GetPlotData(tr);
	
	vector vx, vy;
	vector<string> vsLabels;
	vx = tr.Root.Data.X.dVals;
	vy = tr.Root.Data.Y.dVals;		
	
	TreeNode trLabelData = tr.Root.Label.Data;
	bool bHasLabel = false;
	if( trLabelData && !trLabelData.IsEmpty() )
	{
		vsLabels = trLabelData.strVals;
		if( vsLabels.GetSize() > 0 )
			bHasLabel = true;
	}
	
	/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
	/*
	if( nIndex < vx.GetSize() && nIndex < vy.GetSize() )
	{
		vx.RemoveAt(nIndex);
		vy.RemoveAt(nIndex);
		if( nIndex < vsLabels.GetSize() )
			vsLabels.RemoveAt(nIndex);
	*/
	vector<int> vnIndicesTmp;
	vnIndicesTmp = vnIndices;
	vx.RemoveAt(vnIndicesTmp);
	vy.RemoveAt(vnIndicesTmp);
	if( bHasLabel )
		vsLabels.RemoveAt(vnIndicesTmp);
	///End IMPROVE_DELETE_POINTS	
	
		Tree trNew;
		trNew.Root.Data.X.dVals = vx;
		trNew.Root.Data.Y.dVals = vy;
		if( bHasLabel )
			trNew.Root.Label.Data.strVals = vsLabels;
			
		m_pData->SetPlotData(trNew);	
		UpdateData();
		Refresh();
		return TRUE;
	/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS	 
	//}	 
	//return FALSE;
	///End IMPROVE_DELETE_POINTS
}

BOOL	DigitizerDataPlot::ReorderPoints()
{		
	Tree tr;
	m_pData->GetPlotData(tr);
	
	vector vx, vy;
	vx = tr.Root.Data.X.dVals;
	vy = tr.Root.Data.Y.dVals;
	
	vector<uint> vnOrder;
	vx.Sort(SORT_ASCENDING, TRUE, vnOrder);
	vy.Reorder(vnOrder);
	
	Tree trNew;
	trNew.Root.Data.X.dVals = vx;
	trNew.Root.Data.Y.dVals = vy;
	m_pData->SetPlotData(trNew);	
	return UpdateData();	
}
///End IMPROVE_MULTIPLE_CURVES

BOOL	DigitizerDataPlot::UpdateStates()
{
	/// Iris 12/23/2011 ORG-4685-P1 FIX_AFTER_CLOSE_DLG_SOME_DIGIPLOT_OBJS_STILL_CAN_BE_SELECTED
	/*
	GraphObject		plot = Plot();
	if ( plot )
	{
		update_go_states(plot, GetUpdateStates(), -1);
	}	
	*/
	vector<string> vsPlotNames;
	m_pData->GetAllPlotNames(vsPlotNames);
	
	GraphLayer		gl = GetDigitizeLayer();		
	for(int index = 0; index < vsPlotNames.GetSize(); index++)
	{
		GraphObject		plot = gl.GraphObjects(vsPlotNames[index]);
		if( plot )
		{
			update_go_states(plot, GetUpdateStates(), -1);
		}
	}
	///End FIX_AFTER_CLOSE_DLG_SOME_DIGIPLOT_OBJS_STILL_CAN_BE_SELECTED
	
	return TRUE;
}

int		DigitizerDataPlot::UpdateFromEvents(int nEvent, LPCSTR lpcszName)
{
	if ( !IsPlot(lpcszName) )
		return UPDATEFROMEVENTS_NOT_HANDLE;

	return IsLabelEditing() && OE_DELETE_PART != nEvent ? UPDATEFROMEVENTS_NONE : UPDATEFROMEVENTS_PLOT;
}

BOOL	DigitizerDataPlot::Update(int nEvent)
{
	///------ Folger 01/12/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	if ( IsLabelEditing() && OE_DELETE_PART == nEvent )
	{
		int		nIndex = Selection.GetHandle() - 1;
		if ( nIndex >= 0 )
		{
			m_pData->PtsLabel[nIndex].Empty();					
			return UpdateData();
		}
		return TRUE;
	}
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	GraphObject		plot = Plot();
	if ( !plot )
	{
		if ( GENERIC_UPDATE_EVENT == nEvent )
			return TRUE;

		if ( !m_pData->RemoveActiveData() )
			return TRUE;

		/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
		// if no data point for currect line, no need to do these actions
		//return Show(TRUE) && Update(GENERIC_UPDATE_EVENT);
		///End IMPROVE_MULTIPLE_CURVES
	}

	Tree			tr;
	if( GetFormat(tr, FPB_DATA) )
		m_pData->SetPlotData(tr);
	
	return TRUE;
}

BOOL	DigitizerDataPlot::GetFormat(TreeNode& tr, DWORD dwPropertiesFilter)
{
	GraphObject		plot = Plot();
	if ( !plot )
		return FALSE;
	tr = plot.GetFormat(dwPropertiesFilter, FOB_ALL, true, true);
	return TRUE;
}

BOOL	DigitizerDataPlot::ApplyFormat(TreeNode& tr)
{
	GraphObject		plot = Plot();
	return plot && 0 == plot.UpdateThemeIDs(tr.Root) && plot.ApplyFormat(tr, TRUE, TRUE);
}

///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
BOOL	DigitizerDataPlot::Edit(int nIndex)
{
	if ( !IsLabelEditing() )
		return FALSE;
	
	vector<string>&		vs =  m_pData->PtsLabel;
	if ( nIndex >= vs.GetSize() )
		return FALSE;
	
	GETN_TREE(tr)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	GETN_STR(Label, "", vs[nIndex])
	
	if ( GetNBox(tr, _L("Set Label"), NULL, NULL, NULL, m_pObjsHolder->GetDigitizePage().GetWindow().GetSafeHwnd()) )
	{
		vs[nIndex] = tr.Label.strVal;
		UpdateData();
	}
	return Refresh();
}
///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

///------ Folger 01/12/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
BOOL		DigitizerDataPlot::UpdateData()
{
	Tree tr;
	m_pData->GetPlotData(tr);
	return ApplyFormat(tr);
}
///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

//private:
GraphLayer	DigitizerDataPlot::GetDigitizeLayer()
{
	return m_pObjsHolder->GetDigitizeLayer();
}

BOOL		DigitizerDataPlot::Refresh()
{
	return m_pObjsHolder->Refresh();
}
	
// private:
GraphObject	DigitizerDataPlot::Plot(int nUpdate/* = OBJUPDATE_NONE*/)
{
	//ERR_MSG("DigitizerDataPlot::Plot");
	
	string			strName = m_pData->GetPlotName();
	GraphLayer		gl = GetDigitizeLayer();
	/// Iris 01/18/2012 ORG4894-P1 FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
	//GraphObject		plot = gl.GraphObjects(strName);
	GraphObject 	plot;
	if( !gl )
		return plot;
	plot = gl.GraphObjects(strName);
	///End FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
	
	if ( OBJUPDATE_NONE != nUpdate )
	{
		if ( !plot )
		{
			ERR_MSG(strName);
			plot = gl.CreateGraphObject(GROBJ_TN_MARKER, strName);
			plot.Attach = ATTACH_TO_SCALE;
			/// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
			// let data plot obj looks better
			plot.SetSelectEffect(FALSE);
			plot.SetReverseVideo(FALSE);
			///End MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
			
			set_LT_script(plot, OBJ_INTERNAL_LABTALK_SCRIPT, GRCT_ANY_EVENT, 1);
			m_pObjsHolder->SetupUndoEvent(plot);
			m_pObjsHolder->SetupDeleteUndoable(plot, FALSE);
			
			/// Iris 12/22/2011 ORG-4685-S1 HIDE_LINE_OF_DATAPLOT
			Tree tr;
			tr.Root.Width.dVal = 0;		
			if( 0 == plot.UpdateThemeIDs( tr.Root ) )
				plot.ApplyFormat(tr, true, true);
			///End HIDE_LINE_OF_DATAPLOT			
		}

		update_go_states(plot, GetUpdateStates(), -1);		
		m_pData->SetPlotColor(-1);
		
		if ( m_pData->Size() > 0 )
		{
			UpdateData();
		}
		else
		{
			/// Iris 12/26/2011 ORG-4685-S4 CLICKED_NEW_LINE_NEED_START_PICK_POINTS
			if( plot ) 
			///End CLICKED_NEW_LINE_NEED_START_PICK_POINTS
				plot.Destroy();
		}
	}

	return plot;
}

BOOL		DigitizerDataPlot::IsAxesEditing()
{
	return m_pData->IsAxisEditing();
}

///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
BOOL		DigitizerDataPlot::IsLabelEditing()
{
	return m_pData->IsLabelEditing();
}
///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

DWORD		DigitizerDataPlot::GetUpdateStates()
{
	return m_pData->IsDlgOpen() && !IsAxesEditing() ? (IsLabelEditing() ? GOC_LABEL_EDITING : GOC_REV_USER_DEL) : GOC_NO_SELECT;
}

BOOL		DigitizerDataPlot::IsPlot(LPCSTR lpcszName)
{
	/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
	/*
	GraphObject		plot = Plot();
	if ( !plot )
		return FALSE;

	return plot.GetName().Compare(lpcszName) == 0;
	*/
	vector<string> vsNames;
	m_pData->GetAllPlotNames(vsNames);
	if( vsNames.Find(lpcszName) < 0 )
		return FALSE;
	return TRUE;
	///End IMPROVE_MULTIPLE_CURVES
}

/*------------------------------------------------------------------------------*
 * DigitizerDataPlot End	 													*
 *------------------------------------------------------------------------------*/
 
/*------------------------------------------------------------------------------*
 * DigitizerAxes			 													*
 *------------------------------------------------------------------------------*/
#define			STR_AXIS_XFROM		"X1"
#define			STR_AXIS_XTO		"X2"
#define			STR_AXIS_YFROM		"Y1"
#define			STR_AXIS_YTO		"Y2"

//class DigitizerAxes
//public:
DigitizerAxes::DigitizerAxes(DigitizerImplData* pData, DigitizerObjsHolder* pObjsHolder)
{
	m_pData = pData;
	m_pObjsHolder = pObjsHolder;
}
DigitizerAxes::~DigitizerAxes()
{
}

BOOL	DigitizerAxes::Update(int nUpdate, LPCSTR lpcszName/* = NULL*/, BOOL bRefresh/* = FALSE*/)
{
	ERR_MSG("DigitizerAxes::Update");
	X(nUpdate), Y(nUpdate);
	XFrom(nUpdate, lpcszName), XTo(nUpdate, lpcszName), YFrom(nUpdate, lpcszName), YTo(nUpdate, lpcszName);

	if ( bRefresh )
		Refresh();
	return TRUE;
}

int		DigitizerAxes::UpdateFromEvents(int nEvent, LPCSTR lpcszName)
{
	if ( IsAxis(lpcszName) && UpdateFromAxis(nEvent, lpcszName) || UpdateFromAxesEnd(nEvent, lpcszName) )
		return UPDATEFROMEVENTS_AXIS;

	return UPDATEFROMEVENTS_NOT_HANDLE;
}

BOOL	DigitizerAxes::SetPixel(IMPLDATA type, int nValue)
{
	switch ( type )
	{
	case IMPLDATA_X1:
		m_pData->x1.nx = nValue;
		break;
		
	case IMPLDATA_X2:
		m_pData->x2.nx = nValue;
		break;
		
	case IMPLDATA_Y1:
		m_pData->y1.ny = nValue;
		break;
		
	case IMPLDATA_Y2:
		m_pData->y2.ny = nValue;
		break;
		
	case IMPLDATA_XREF:
		m_pData->y1.nx = m_pData->y2.nx = nValue;
		break;
		
	case IMPLDATA_YREF:
		m_pData->x1.ny = m_pData->x2.ny = nValue;
		break;
		
	default:
		O_A_FAIL;
		return FALSE;
	}
	return TRUE;
}

void	DigitizerAxes::GetNames(vector<string>& vs)
{
	static	vector<string>	vsLocal = {STR_AXIS_XFROM, STR_AXIS_XTO, STR_AXIS_YFROM, STR_AXIS_YTO};
	vs = vsLocal;
	vs.Add(_L("X Reference Line"));
	vs.Add(_L("Y Reference Line"));
}

void	DigitizerAxes::GetColors(vector<uint>& vn)
{
	vn.SetSize(IMPLDATA_TOTAL);
	vn[IMPLDATA_X1] = color_index_to_rgb(m_pData->x1.color);
	vn[IMPLDATA_X2] = color_index_to_rgb(m_pData->x2.color);
	vn[IMPLDATA_Y1] = color_index_to_rgb(m_pData->y1.color);
	vn[IMPLDATA_Y2] = color_index_to_rgb(m_pData->y2.color);
	vn[IMPLDATA_XREF] = color_index_to_rgb(m_pData->axisY.nColor);
	vn[IMPLDATA_YREF] = color_index_to_rgb(m_pData->axisX.nColor);
}

void	DigitizerAxes::GetPixels(vector<string>& vs)
{
	vs.SetSize(IMPLDATA_TOTAL);
	vs[IMPLDATA_X1] = m_pData->GetValue(m_pData->x1.nx);
	vs[IMPLDATA_X2] = m_pData->GetValue(m_pData->x2.nx);
	vs[IMPLDATA_Y1] = m_pData->GetValue(m_pData->y1.ny);
	vs[IMPLDATA_Y2] = m_pData->GetValue(m_pData->y2.ny);
	vs[IMPLDATA_XREF] = m_pData->GetValue(m_pData->y1.nx);
	vs[IMPLDATA_YREF] = m_pData->GetValue(m_pData->x1.ny);
}

BOOL	DigitizerAxes::GetX0Y0(double& x, double& y)
{
	x = m_pData->y1.nx;
	y = m_pData->x1.ny;
	return TRUE;
}

BOOL	DigitizerAxes::SetAxisSelection(IMPLDATA type)
{
	GraphObject		go = GetAxisObj(type);

	Selection.Reset();
	if ( go )
		Selection.Add(go);
	return TRUE;
}

IMPLDATA	DigitizerAxes::GetAxisSelection()
{
	foreach ( OriginObject obj in Selection.Objects )
	{
		GraphObject		go;
		go = obj;
		if ( !go )
			continue;
		
		IMPLDATA	type = GetAxisType(go);
		if ( IMPLDATA_INVALID != type )
			return type;
	}
	return IMPLDATA_INVALID;
}

BOOL	DigitizerAxes::ShowXRefLine(BOOL bShow)
{
	m_pData->SetX1FromYAxis(!bShow); // Iris: asked Folger, this is an old logic, may be can be removed.
	m_pData->SetXRefLineShow(bShow);
	Y(OBJUPDATE_RECREATE);
	return TRUE;
}

BOOL	DigitizerAxes::ShowYRefLine(BOOL bShow)
{
	m_pData->SetY1FromXAxis(!bShow); // Iris: asked Folger, this is an old logic, may be can be removed.
	m_pData->SetYRefLineShow(bShow);
	X(OBJUPDATE_RECREATE);
	return TRUE;
}

BOOL	DigitizerAxes::ShowAxes(BOOL bShow)
{
	for ( IMPLDATA type = IMPLDATA_X1; type <= IMPLDATA_Y2; ++type )
	{
		GraphObject		axis = GetAxisObj(type);
		if( axis )
		{
			axis.Show = bShow;
		}
	}
	return TRUE;
}

//private:
GraphLayer	DigitizerAxes::GetDigitizeLayer()
{
	return m_pObjsHolder->GetDigitizeLayer();
}

BOOL		DigitizerAxes::Refresh()
{
	return m_pObjsHolder->Refresh();
}

BOOL		DigitizerAxes::SetupUndoEvent(GraphObject& go)
{
	return m_pObjsHolder->SetupUndoEvent(go);
}

BOOL		DigitizerAxes::SetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double rVal)
{
	return m_pObjsHolder->SetObjProperty(lpcszName, lpcszProp, rVal);
}

BOOL		DigitizerAxes::GetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double& rVal)
{
	return m_pObjsHolder->GetObjProperty(lpcszName, lpcszProp, rVal);
}

string		DigitizerAxes::MakeObjName(LPCSTR lpcsz)
{
	return m_pData->MakeObjName(lpcsz);
}

BOOL		DigitizerAxes::IsAxesEditing()
{
	return m_pData->IsAxisEditing();
}

DWORD		DigitizerAxes::GetUpdateStates(int nTabIndex/* = 0*/)
{
	return m_pData->IsDlgOpen() && IsAxesEditing() ? OBJ_COMMON_STATE | m_pData->ConvertTabIndex(nTabIndex) : GOC_NO_SELECT;
}

BOOL	DigitizerAxes::CreateCrossLine(GraphObject& line, DigitizerCoordinates& coor, int nColor, LPCSTR lpcszName, BOOL bVertical)
{
	GraphLayer	gl = GetDigitizeLayer();
	int			nWidth = gl.X.To;
	int			nHeight = gl.Y.From;

	int		x0, y0, x1, y1;
	if ( bVertical )
	{
		x0 = x1 = coor.nx;
		y0 = 0, y1 = nHeight;
	}
	else
	{
		x0 = 0, x1 = nWidth;
		y0 = y1 = coor.ny;
	}
	
	return add_line(gl, line, x0, y0, ATTACH_TO_SCALE, LN_FREE, false, false, x1, y1, nColor, lpcszName)
		&& SetObjProperty(lpcszName, "ArrowEndShape", 1);
}

int		DigitizerAxes::GetPointHalfSize()
{
	return m_pData->GetPointHalfSize();
}

GraphObject		DigitizerAxes::Axis(int nUpdate, LPCSTR lpcszName, DigitizerCoordinates& from, DigitizerCoordinates& to, int nColor, BOOL bVertical, BOOL bSuppress, UINT nTabIndex)
{
	string		strName = MakeObjName(lpcszName);
	GraphObject	axis = GetDigitizeLayer().GraphObjects(strName);

	DWORD		dwStates = GetUpdateStates(nTabIndex) | (bVertical ? GOC_NO_VMOVE : GOC_NO_HMOVE);
	if ( OBJUPDATE_NONE != nUpdate )
	{
		if ( axis )
		{
			if ( OBJUPDATE_EXISTING == nUpdate )
			{
				if ( !IsAxesEditing() )
					Selection.Remove(axis);
				update_go_states(axis, dwStates, -1);
				return axis;
			}
		
			axis.Destroy();
		}

		if ( bSuppress )
			return axis;
		
		if ( !m_pData->IsCoornianteReady(from) || !m_pData->IsCoornianteReady(to) )
			return axis;
		
		if ( CreateCrossLine(axis, from, nColor, strName, bVertical) )
		{
			SetupUndoEvent(axis);
			update_go_states(axis, dwStates);
			set_LT_script(axis, OBJ_INTERNAL_LABTALK_SCRIPT, GRCT_ANY_EVENT);
		}
	}
	return axis;
}

GraphObject		DigitizerAxes::X(int nUpdate/* = OBJUPDATE_NONE*/)
{
	return Axis(nUpdate, "X", m_pData->x1, m_pData->x2, m_pData->axisX.nColor, FALSE, m_pData->IsY1FromXAxis(), 6);
}

GraphObject		DigitizerAxes::Y(int nUpdate/* = OBJUPDATE_NONE*/)
{
	return Axis(nUpdate, "Y", m_pData->y1, m_pData->y2, m_pData->axisY.nColor, TRUE, m_pData->IsX1FromYAxis(), 5);
}

BOOL	DigitizerAxes::IsAxis(LPCSTR lpcszName)
{
	GraphObject		axisX = X();
	GraphObject		axisY = Y();
	return axisX.IsValid() && axisX.GetName().Compare(lpcszName) == 0 || axisY.IsValid() && axisY.GetName().Compare(lpcszName) == 0;
}

BOOL	DigitizerAxes::UpdateFromAxis(int nEvent, LPCSTR lpcszName)
{
	return UpdateFromX(nEvent, lpcszName) || UpdateFromY(nEvent, lpcszName);
}

#define		UPDATE_FROM_AXIS(_AXIS, _DATA1, _DATA2, _FROM, _TO, _VERTICAL) \
			GraphObject		axis = _AXIS(); \
			if ( !axis || axis.GetName().Compare(lpcszName) != 0 ) \
				return FALSE; \
			if ( OE_SELECT == nEvent || OE_UNSELECT == nEvent ) \
				return UpdateAxisLineStyle(axis, OE_SELECT == nEvent); \
			GetCoorsFromAxis(m_pData->_DATA1, m_pData->_DATA2, axis, _VERTICAL); \
			_FROM(OBJUPDATE_RECREATE), _TO(OBJUPDATE_RECREATE); \
			return TRUE;

BOOL	DigitizerAxes::UpdateFromX(int nEvent, LPCSTR lpcszName)
{
	UPDATE_FROM_AXIS(X, x1, x2, XFrom, XTo, FALSE);
}

BOOL	DigitizerAxes::UpdateFromY(int nEvent, LPCSTR lpcszName)
{
	UPDATE_FROM_AXIS(Y, y1, y2, YFrom, YTo, TRUE);
}

void	DigitizerAxes::GetCoorsFromAxis(DigitizerCoordinates& from, DigitizerCoordinates& to, GraphObject& axis, BOOL bVertical)
{
	double	x0, y0, x1, y1;
	GetEndPointsFromLine(x0, y0, x1, y1, axis);

	if ( bVertical )
	{
		from.nx = x0;
		to.nx = x1;
	}
	else
	{
		from.ny = y0;
		to.ny = y1;
	}
}

void	DigitizerAxes::GetEndPointsFromLine(double& x0, double& y0, double& x1, double& y1, GraphObject& line)
{
	vector		vx, vy;
	Tree		tr;
	tr = line.GetFormat(FPB_DATA, FOB_ALL, true, true);
	vx = tr.Root.Data.X.dVals;
	vy = tr.Root.Data.Y.dVals;

	x0 = vx[0], x1 = vx[1], y0 = vy[0], y1 = vy[1];
}

GraphObject		DigitizerAxes::AxisEnd(int nUpdate, LPCSTR lpcszName, DigitizerCoordinates& coor, BOOL bVerticalCrossLine, GraphObject* pCrossLine, UINT nTabIndex)
{
	string		strName = MakeObjName(lpcszName);
	string		strTextName = strName + "_Text";

	GraphLayer	gl = GetDigitizeLayer();
	GraphObject	end = gl.GraphObjects(strName);
	GraphObject	endText = gl.GraphObjects(strTextName);

	GraphObject	endCrossLine;
	endCrossLine = CreateAxisEndCrossLine(nUpdate, bVerticalCrossLine, strName, coor, nTabIndex);
	if ( pCrossLine )
		*pCrossLine = endCrossLine;

	if ( OBJUPDATE_NONE != nUpdate )
	{
		if ( end )
		{
			if ( OBJUPDATE_EXISTING == nUpdate )
			{
				CheckShowAxisEnd(end);
				ObjsUpdateEventHelper	clHelper;
				end.X = coor.nx;
				end.Y = coor.ny;
				return end;
			}
			end.Destroy();
			if  ( endText )
				endText.Destroy();
		}

		if ( !m_pData->IsCoornianteReady(coor) )
			return end;

		int		nHalfSize = GetPointHalfSize();
		add_rect(gl, end, coor.nx - nHalfSize, coor.ny - nHalfSize, coor.nx + nHalfSize, coor.ny + nHalfSize, coor.color, ATTACH_TO_SCALE, LN_FREE, false, false);
		end.SetName(strName);
		update_go_states(end, GOC_NO_SELECT);
		end.ConnectTo(endCrossLine, -1, -1, FALSE);
		CheckShowAxisEnd(end);
	}

	return end;
}

void	DigitizerAxes::CheckShowAxisEnd(GraphObject& end)
{
	end.Show = !IsAxesEditing();
}

#define	STR_CROSS_LINE_POSTFIX		"_Cross"
BOOL	DigitizerAxes::IsAxisEndCrossLine(LPCSTR lpcszName)
{
	return strstr(lpcszName, STR_CROSS_LINE_POSTFIX) != NULL;
}

GraphObject		DigitizerAxes::CreateAxisEndCrossLine(int nUpdate, BOOL bVertical, LPCSTR lpcszName, DigitizerCoordinates& coor, UINT nTabIndex)
{
	string		strCrossLineName;
	strCrossLineName.Format("%s%s", lpcszName, STR_CROSS_LINE_POSTFIX);
	GraphObject	line = GetDigitizeLayer().GraphObjects(strCrossLineName);

	if ( OBJUPDATE_NONE != nUpdate )
	{
		if ( line )
		{
			line.Destroy();
		}

		if ( !m_pData->IsCoornianteReady(coor) )
			return line;
		
		if ( CreateCrossLine(line, coor, IsAxesEditing() ? coor.color : SYSCOLOR_BLACK, strCrossLineName, bVertical) )
		{
			update_go_states(line, GetUpdateStates(nTabIndex) | (bVertical ? GOC_NO_VMOVE : GOC_NO_HMOVE));
			SetupUndoEvent(line);
			set_LT_script(line, OBJ_INTERNAL_LABTALK_SCRIPT, GRCT_ANY_EVENT);
			
			if ( !IsAxesEditing() )
			{
				SetObjProperty(strCrossLineName, "LineType", 2);
			}
		}
		
	}
	return line;
}

BOOL	DigitizerAxes::UpdateFromAxisEndCrossLine(int nEvent, LPCSTR lpcszName)
{
	return UpdateFromXFromCrossLine(nEvent, lpcszName) || UpdateFromXToCrossLine(nEvent, lpcszName) || UpdateFromYFromCrossLine(nEvent, lpcszName) || UpdateFromYToCrossLine(nEvent, lpcszName);
}

#define		UPDATE_FROM_AXIS_END_CROSS_LINE(_ENDCROSSLINE, _COOR, _VERTICAL, _MORE) \
			GraphObject		crossLine = _ENDCROSSLINE(); \
			/*///------ Folger 04/19/2011 ORG-2684-P1 DIGITIZER_RUNTIME_ERRO_AFTER_DELETE_AXIS_SCALE_VALUE*/ \
			/*if ( crossLine.GetName().CompareNoCase(lpcszName) != 0 ) \*/ \
			if ( !crossLine || crossLine.GetName().CompareNoCase(lpcszName) != 0 ) \
			/*///------ End DIGITIZER_RUNTIME_ERRO_AFTER_DELETE_AXIS_SCALE_VALUE*/ \
				return FALSE; \
			if ( OE_SELECT == nEvent || OE_UNSELECT == nEvent ) \
				return UpdateAxisLineStyle(crossLine, OE_SELECT == nEvent); \
			return GetCoorsFromCrossLine(m_pData->_COOR, crossLine, _VERTICAL) && _MORE;

BOOL	DigitizerAxes::UpdateFromXFromCrossLine(int nEvent, LPCSTR lpcszName)
{
	UPDATE_FROM_AXIS_END_CROSS_LINE(XFromCrossLine, x1, TRUE, m_pData->UpdateY1Y2FromX1());
}

BOOL	DigitizerAxes::UpdateFromXToCrossLine(int nEvent, LPCSTR lpcszName)
{
	UPDATE_FROM_AXIS_END_CROSS_LINE(XToCrossLine, x2, TRUE, TRUE);
}

BOOL	DigitizerAxes::UpdateFromYFromCrossLine(int nEvent, LPCSTR lpcszName)
{
	UPDATE_FROM_AXIS_END_CROSS_LINE(YFromCrossLine, y1, FALSE, m_pData->UpdateX1X2FromY1());
}

BOOL	DigitizerAxes::UpdateFromYToCrossLine(int nEvent, LPCSTR lpcszName)
{
	UPDATE_FROM_AXIS_END_CROSS_LINE(YToCrossLine, y2, FALSE, TRUE);
}

BOOL	DigitizerAxes::GetCoorsFromCrossLine(DigitizerCoordinates& coor, GraphObject& line, BOOL bVertical)
{
	double	x0, y0, x1, y1;
	GetEndPointsFromLine(x0, y0, x1, y1, line);
	
	if ( bVertical )
	{
		coor.nx = x0;
	}
	else
	{
		coor.ny = y0;
	}
	return TRUE;
}

#define			CHECK_OBJ_NAME_RETURN_DUMMY \
				if ( OBJUPDATE_NONE != nUpdate && lpcszNameToCheck && MakeObjName(lpcszName).CompareNoCase(lpcszNameToCheck) != 0 ) { GraphObject dummy; return dummy; }

GraphObject		DigitizerAxes::XFrom(int nUpdate/* = OBJUPDATE_NONE*/, LPCSTR lpcszNameToCheck/* = NULL*/, GraphObject* pCrossLine/* = NULL*/)
{
	LPCSTR		lpcszName = STR_AXIS_XFROM;
	CHECK_OBJ_NAME_RETURN_DUMMY;

	return AxisEnd(nUpdate, lpcszName, m_pData->x1, TRUE, pCrossLine, 1);
}

GraphObject		DigitizerAxes::XTo(int nUpdate/* = OBJUPDATE_NONE*/, LPCSTR lpcszNameToCheck/* = NULL*/, GraphObject* pCrossLine/* = NULL*/)
{
	LPCSTR		lpcszName = STR_AXIS_XTO;
	CHECK_OBJ_NAME_RETURN_DUMMY;

	return AxisEnd(nUpdate, lpcszName, m_pData->x2, TRUE, pCrossLine, 2);
}

GraphObject		DigitizerAxes::YFrom(int nUpdate/* = OBJUPDATE_NONE*/, LPCSTR lpcszNameToCheck/* = NULL*/, GraphObject* pCrossLine/* = NULL*/)
{
	LPCSTR		lpcszName = STR_AXIS_YFROM;
	CHECK_OBJ_NAME_RETURN_DUMMY;

	return AxisEnd(nUpdate, lpcszName, m_pData->y1, FALSE, pCrossLine, 3);
}

GraphObject		DigitizerAxes::YTo(int nUpdate/* = OBJUPDATE_NONE*/, LPCSTR lpcszNameToCheck/* = NULL*/, GraphObject* pCrossLine/* = NULL*/)
{
	LPCSTR		lpcszName = STR_AXIS_YTO;
	CHECK_OBJ_NAME_RETURN_DUMMY;
	return AxisEnd(nUpdate, lpcszName, m_pData->y2, FALSE, pCrossLine, 4);
}

#define			END_CROSS_LINE(_END) \
				GraphObject		line; \
				_END(OBJUPDATE_NONE, NULL, &line); \
				return line;

GraphObject		DigitizerAxes::XFromCrossLine()
{
	END_CROSS_LINE(XFrom);
}

GraphObject		DigitizerAxes::XToCrossLine()
{
	END_CROSS_LINE(XTo);
}

GraphObject		DigitizerAxes::YFromCrossLine()
{
	END_CROSS_LINE(YFrom);
}

GraphObject		DigitizerAxes::YToCrossLine()
{
	END_CROSS_LINE(YTo);
}

BOOL	DigitizerAxes::UpdateFromAxisEnd(DigitizerCoordinates& coor, GraphObject& end)
{
	if ( !end )
		return FALSE;

	coor.nx = end.X;
	coor.ny = end.Y;
	return TRUE;
}

BOOL	DigitizerAxes::UpdateFromXFrom()
{
	return UpdateFromAxisEnd(m_pData->x1, XFrom()) && m_pData->UpdateY1Y2FromX1();
}

BOOL	DigitizerAxes::UpdateFromXTo()
{
	return UpdateFromAxisEnd(m_pData->x2, XTo());
}

BOOL	DigitizerAxes::UpdateFromYFrom()
{
	return UpdateFromAxisEnd(m_pData->y1, YFrom()) && m_pData->UpdateX1X2FromY1();
}

BOOL	DigitizerAxes::UpdateFromYTo()
{
	return UpdateFromAxisEnd(m_pData->y2, YTo());
}

BOOL	DigitizerAxes::UpdateFromAxesEnd(int nEvent, LPCSTR lpcszName)
{
	if ( IsAxisEndCrossLine(lpcszName) )
		return UpdateFromAxisEndCrossLine(nEvent, lpcszName);

	O_A(nEvent == OE_MOVE);
	UpdateFromXFrom(), UpdateFromXTo(), UpdateFromYFrom(), UpdateFromYTo();
	return Update(OBJUPDATE_EXISTING, lpcszName, FALSE);
}

GraphObject		DigitizerAxes::GetAxisObj(IMPLDATA type)
{
	switch ( type )
	{
	case IMPLDATA_X1:
		return XFromCrossLine();

	case IMPLDATA_X2:
		return XToCrossLine()

	case IMPLDATA_Y1:
		return YFromCrossLine();

	case IMPLDATA_Y2:
		return YToCrossLine()

	case IMPLDATA_XREF:
		return Y();

	case IMPLDATA_YREF:
		return X();

	default:
		break;
	}

	GraphObject		dummy;
	return dummy;
}

IMPLDATA		DigitizerAxes::GetAxisType(GraphObject& go)
{
	string		strName = go.GetName();
	for ( IMPLDATA type = IMPLDATA_X1; type<IMPLDATA_TOTAL; ++type )
	{
		GraphObject		axis = GetAxisObj(type);
		if ( !axis )
			continue;
		if ( strName.Compare(axis.GetName()) == 0 )
			return type;
	}
	return IMPLDATA_INVALID;
}

///------ Folger 01/06/2011 ORG-1512-S6 DIGITIZER_ADD_LINE_END_SYMBOL_TO_INDICATE_SELECTION
BOOL			DigitizerAxes::UpdateAxisLineStyle(GraphObject& line, BOOL bSelect)
{
	int		nStyle = bSelect ? 4 : 0;
	int		nWidth = 10;
	int		nHeight = 8.66;

	Tree	tr;
	tr.Root.Arrow.Begin.Style.nVal = nStyle;
	tr.Root.Arrow.Begin.Width.dVal = nWidth;
	tr.Root.Arrow.Begin.Length.dVal = nHeight;
	tr.Root.Arrow.End.Style.nVal = nStyle;
	tr.Root.Arrow.End.Width.dVal = nWidth;
	tr.Root.Arrow.End.Length.dVal = nHeight;
	return 0 == line.UpdateThemeIDs(tr.Root) && line.ApplyFormat(tr, TRUE, TRUE);
}
///------ End DIGITIZER_ADD_LINE_END_SYMBOL_TO_INDICATE_SELECTION

/*------------------------------------------------------------------------------*
 * DigitizerAxes End		 													*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 * DigitizerVisualizer		 													*
 *------------------------------------------------------------------------------*/
//class DigitizerVisualizer
//public:
DigitizerVisualizer::DigitizerVisualizer(DigitizerImplData& data, DigitizerObjsHolder& objsHolder)
{
	m_pData = &data;
	m_pObjsHolder = &objsHolder;
	m_pPlot = NULL;
	m_pAxes = NULL;
}
DigitizerVisualizer::~DigitizerVisualizer()
{
	NICE_SAFE_REMOVAL(m_pPlot);
	NICE_SAFE_REMOVAL(m_pAxes);
}

BOOL	DigitizerVisualizer::IsReadyToDigitize()
{
	return m_pData->IsReady();
}

BOOL	DigitizerVisualizer::UpdateAxes(BOOL bRefresh/* = FALSE*/)
{
	return Axes()->Update(OBJUPDATE_RECREATE, NULL, bRefresh);
}

BOOL	DigitizerVisualizer::UpdateDataPlot(BOOL bRefresh/* = FALSE*/)
{
	return Plot()->Update(OBJUPDATE_EXISTING, bRefresh);
}

BOOL	DigitizerVisualizer::AddOnePoint(double x,  double y)
{
	return Plot()->AddOnePoint(x, y);
}

///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
BOOL	DigitizerVisualizer::AddPoints(const vector& vx, const vector& vy)
{
	return Plot()->AddPoints(vx, vy);
}
///End DIGITIZER_AUTO_TRACE_LINE

BOOL	DigitizerVisualizer::HasDataPoint()
{
	return Plot()->HasDataPoint();
}

/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
/*
BOOL	DigitizerVisualizer::DeletePoint(int nIndex)
{
	return Plot()->DeletePoint(nIndex);
}
*/
BOOL	DigitizerVisualizer::DeletePoints(const vector<uint>& vnIndices)
{
	return Plot()->DeletePoints(vnIndices);
}
///End IMPROVE_DELETE_POINTS

BOOL	DigitizerVisualizer::ReorderPoints()
{
	return Plot()->ReorderPoints();
}
///End IMPROVE_MULTIPLE_CURVES

int		DigitizerVisualizer::UpdateFromEvents(int nEvent, LPCSTR lpcszName)
{
	int		nReturn = UPDATEFROMEVENTS_NOT_HANDLE;
	if( 0 == strcmp(lpcszName, STR_VERTEXS_DATA_PLOT_NAME) )
	{		
		return UPDATEFROMEVENTS_VERTEX;
	}
	
	if ( UPDATEFROMEVENTS_NOT_HANDLE != (nReturn = Plot()->UpdateFromEvents(nEvent, lpcszName)) )
		return nReturn;

	if ( UPDATEFROMEVENTS_NOT_HANDLE != (nReturn = Axes()->UpdateFromEvents(nEvent, lpcszName)) )
		return nReturn;		

	return UPDATEFROMEVENTS_NONE;
}

BOOL	DigitizerVisualizer::UpdateFromPlot(int nEvent)
{
	return Plot()->Update(nEvent);
}

int	DigitizerVisualizer::NewData()
{
	return Plot()->NewData();
}

/// Iris 12/29/2011 ORG-4685-S5 SUPPORT_DELETE_LINE
BOOL DigitizerVisualizer::RemoveActiveData()
{
	return m_pData->RemoveActiveData();
}
///End SUPPORT_DELETE_LINE

BOOL	DigitizerVisualizer::ClearDataPlot()
{
	return Plot()->Clear();
}

/// Iris 9/03/2012 ORG-5112-P3 FIX_NOT_REMOVE_ALL_DATAPLOTS_WHEN_CLICKED_DELETE_WKS_GRAPH
BOOL	DigitizerVisualizer::ClearAllDataPlots()
{
	vector<string> vsNames;
	m_pData->GetAllPlotNames(vsNames);
	if( 0 == vsNames.GetSize() )
		return FALSE;
	
	GraphLayer		gl = m_pObjsHolder->GetDigitizeLayer();
	if( !gl )
		return FALSE;
	
	for(int index = 0; index < vsNames.GetSize(); ++index)
	{
		GraphObject 	plot;
		plot = gl.GraphObjects(vsNames[index]);
		ASSERT( plot );
		
		if( plot )
		{
			plot.Destroy();
		}
	}	
	return TRUE;
}
///End FIX_NOT_REMOVE_ALL_DATAPLOTS_WHEN_CLICKED_DELETE_WKS_GRAPH

BOOL	DigitizerVisualizer::SetAxesEditing(BOOL bOn)
{
	Selection.Reset();
	m_pData->SetAxisEditing(bOn);
	return UpdateStates();
}

///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
BOOL	DigitizerVisualizer::SetLabelEditing(BOOL bOn)
{
	m_pData->SetLabelEditing(bOn);
	return Plot()->UpdateStates() && Plot()->UpdateData();
}
///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

BOOL	DigitizerVisualizer::UpdateStates()
{
	return Axes()->Update(OBJUPDATE_EXISTING) && Plot()->UpdateStates();
}

BOOL	DigitizerVisualizer::SetAxisSelection(IMPLDATA type)
{
	return Axes()->SetAxisSelection(type);
}

IMPLDATA	DigitizerVisualizer::GetAxisSelection()
{
	return Axes()->GetAxisSelection();
}

BOOL	DigitizerVisualizer::SetAxisPixel(IMPLDATA type, int nValue)
{
	return Axes()->SetPixel(type, nValue);
}

void	DigitizerVisualizer::GetAxesNames(vector<string>& vs)
{
	Axes()->GetNames(vs);
}

void	DigitizerVisualizer::GetAxesColors(vector<uint>& vn)
{
	Axes()->GetColors(vn);
}

void	DigitizerVisualizer::GetAxesPixels(vector<string>& vs)
{
	Axes()->GetPixels(vs);
}

BOOL	DigitizerVisualizer::GetX0Y0(double& x, double& y)
{
	return Axes()->GetX0Y0(x, y);
}

BOOL	DigitizerVisualizer::ShowXRefLine(BOOL bShow)
{
	return Axes()->ShowXRefLine(bShow);
}

BOOL	DigitizerVisualizer::ShowYRefLine(BOOL bShow)
{
	return Axes()->ShowYRefLine(bShow);
}

///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
BOOL	DigitizerVisualizer::DataPlotEdit(int nIndex)
{
	return Plot()->Edit(nIndex);
}
///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
BOOL	DigitizerVisualizer::UpdatePlotData()
{
	return Plot()->UpdateData();
}
///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

BOOL	DigitizerVisualizer::ShowAxes(BOOL bShow)
{
	return Axes()->ShowAxes(bShow);
}

BOOL	DigitizerVisualizer::ShowVertexs(BOOL bShow)
{
	GraphObject goVertex = m_pObjsHolder->GetDigitizeVertex();
	if( goVertex )
	{
		goVertex.Show = bShow;
		return TRUE;
	}
	return FALSE;
}
//private:
DigitizerDataPlot*			DigitizerVisualizer::Plot()
{
	if ( NULL == m_pPlot )
		m_pPlot = new DigitizerDataPlot(m_pData, m_pObjsHolder);
	return m_pPlot;
}

DigitizerAxes*					DigitizerVisualizer::Axes()
{
	if ( NULL == m_pAxes )
		m_pAxes = new DigitizerAxes(m_pData, m_pObjsHolder);
	return m_pAxes;
}

/*------------------------------------------------------------------------------*
 * DigitizerVisualizer End	 													*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 * DigitizerRotationHelper	 													*
 *------------------------------------------------------------------------------*/

//class DigitizerImpl;

enum
{
	ROTATE_COUNTERCLOCKWISE		= 0,
	ROTATE_CLOCKWISE,
};

static bool s_bImageRotated = false; /// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE

static bool _rotate_image(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	GetNOptionEventHelper	eventHelper(dwCntrl);
	if ( !eventHelper.IsInit() )
	{
		DigitizerImpl	digitizerImpl;
		if ( trNode.tagName.Compare("Direction") == 0 )
		{
			myTree.Angle.dVal += myTree.Inc.dVal * (ROTATE_CLOCKWISE == trNode.nVal ? 1 : -1);
		}
		else if ( trNode.tagName.Compare("Inc") == 0 )
		{
			if ( myTree.Inc.dVal <= 0 )
			{
				myTree.Inc.dVal = digitizerImpl.GetRotateInc();
				warning_msg_box(CER_MUST_LARGE_THAN_0, _L("Increment"), true);
			}
			myTree.Inc.dVal = rmod(myTree.Inc.dVal, 360.0);
			return true;
		}

		s_bImageRotated = true; /// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
		myTree.Angle.dVal = rmod(myTree.Angle.dVal, 360.0);
		double	rAngle = myTree.Angle.dVal;
		double	rAngleInc = myTree.Inc.dVal;
		return digitizerImpl.RotateImage(&rAngle, &rAngleInc);
	}	
	return true;
}

/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
////class DigitizerRotationHelper
////public:
//DigitizerRotationHelper::DigitizerRotationHelper(DigitizerImplData& data, HWND hWnd)
//{
	//m_pData = &data;
	//m_hWnd = hWnd;
//}
//DigitizerRotationHelper::~DigitizerRotationHelper()
//{
//}
//
//BOOL	DigitizerRotationHelper::Update(BOOL bOn)
//{
	/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	//m_pData->SetRotationMode(bOn);
	/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
//
	//GETN_TREE(tr)
	//GETN_STR(Hint, _L("Click Rotate button again to get out of Rotation mode"), "")		GETN_HINT_EX(FALSE, FALSE)
	//GETN_CUSTOM_BUTTON("OK=Close|Cancel=")
	//GETN_NUM(Angle, _L("Rotation Angle from Source Image (degree)"), 0)		GETN_OPTION_EVENT_EX(_rotate_image)
	//GETN_BUTTON_GROUP(Direction, _L(""), 0, "<<|>>")						GETN_OPTION_EVENT_EX(_rotate_image)		_tmpSubNode.SetAttribute(STR_ATTRIB_DISPFMT, DISPLAY_EDITOR_HORZ);
	//GETN_NUM(Inc, _L("<<    >> Increment (degree)"), 0)						GETN_OPTION_EVENT_EX(_rotate_image)
	//return OpenDlg(tr);
//}
//
////private:
//#define		STR_ROTATE_IMAGE		_L("Rotate Image")
//BOOL	DigitizerRotationHelper::OpenDlg(TreeNode& tr)
//{
	//GetSettings(tr);
	//
	//Window		wnd(m_hWnd);
	/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	///*
	//wnd.Visible = FALSE;
	//GetNBox(tr, STR_ROTATE_IMAGE, NULL, NULL, NULL, hWnd);
	//wnd.Visible = TRUE;
//
	//SetSettings(tr);
	//return TRUE;
	//*/
	//return wnd.SendMessage(ID_DIGITIZER_MSG_UPDATE_DYNACTRL, (WPARAM)(&tr), m_pData->IsRotationMode());
	/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
//}
//
//void	DigitizerRotationHelper::GetSettings(TreeNode& tr)
//{
	//tr.Angle.dVal = m_pData->rAngleRotated;
	//tr.Inc.dVal = m_pData->rAngleInc;
//}
//
//void	DigitizerRotationHelper::SetSettings(TreeNode& tr)
//{
	//m_pData->rAngleRotated = tr.Angle.dVal;
	//m_pData->rAngleInc = tr.Inc.dVal;
//}
///End FIX_ROTATE_GETN_DLG_ISSUE
/*------------------------------------------------------------------------------*
 * DigitizerRotationHelper End 													*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* DigitizerOptionsHelper	 													*
*------------------------------------------------------------------------------*/
#define		STR_SCREEN_X		"ScreenX"
#define		STR_SCREEN_Y		"ScreenY"

#define		STR_OPTION			_L("Options")
//class DigitizerOptionsHelper
//public:
DigitizerOptionsHelper::DigitizerOptionsHelper(DigitizerImplData& data, HWND hWnd)
{
	m_pData = &data;
	m_hWnd = hWnd;
	///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
	GetDataName();
	///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
}
DigitizerOptionsHelper::~DigitizerOptionsHelper()
{
}

BOOL	DigitizerOptionsHelper::Update()
{
	GETN_TREE(tr)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	GETN_CUSTOM_BUTTON("OK=Close|Cancel=")

	GETN_BEGIN_BRANCH(SelectData, _L("Curves"))					SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)
	#ifdef		MULTIPLE_CURVES
	GETN_LIST(ActiveData, _L("Active Curve"), 0, DataList())	GETN_EDIT_DISPLAY_WIDTH_RANGE("20-20")		GETN_OPTION_EVENT_EX(_update_curves)
	#endif		/// MULTIPLE_CURVES
	GETN_STR(DataName, _L("Result Worksheet Name"), "")			GETN_EDIT_DISPLAY_WIDTH_RANGE("20-20")		GETN_OPTION_EVENT_EX(_update_curves)
	GETN_COLOR(Color, _L("Color"), 0)							GETN_OPTION_EVENT_EX(_update_curves)
	GETN_END_BRANCH(SelectData)

	GETN_BEGIN_BRANCH(XAxisType, _L("X Axis Tick Labels Type"))			SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)
	getn_construct_display_format(_tmpSubNode, 0, 0, "");
	GETN_END_BRANCH(XAxisType)

	GETN_BEGIN_BRANCH(YAxisType, _L("Y Axis Tick Labels Type"))			SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)
	getn_construct_display_format(_tmpSubNode, 0, 0, "");
	GETN_END_BRANCH(YAxisType)

	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	GETN_BEGIN_BRANCH(AutoFindType, _L("Optimize clicked points"))			SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)
	GETN_LIST(AdjustType, _L("Type"), 0, _L("None|Solid Symbols"))
	GETN_END_BRANCH(AutoFindType)
	tr.AutoFindType.Show = false;	///Jasminie 03/11/11 ORG-2286 HIDE_FOR_851_RELEASE
	///End OPTIMIZE_PICKED_POINT
	
	GetSettings(tr);		
	GetNBox(tr, STR_OPTION, NULL, NULL, NULL, m_hWnd);
	return Update(tr);
}

BOOL	DigitizerOptionsHelper::Update(TreeNode& tr, DWORD dwCntrl/* = 0*/)
{
	SetSettings(tr, dwCntrl);
	return TRUE; 
}

//private:
void	DigitizerOptionsHelper::SetSettings(TreeNode& tr, DWORD dwCntrl)
{
	if ( O_QUERY_BOOL(dwCntrl, UPDATEOPTIONSFROM_DATANAME) )
	{
		string	str = tr.SelectData.DataName.strVal;
		m_pData->UpdateDataName(str);
		tr.SelectData.DataName.strVal = str;
	}

	#ifdef		MULTIPLE_CURVES
	m_pData->SetActiveData(tr.SelectData.ActiveData.nVal);
	#endif		/// MULTIPLE_CURVES

	if ( O_QUERY_BOOL(dwCntrl, UPDATEOPTIONSFROM_DATA) )
	{
		tr.SelectData.DataName.strVal = GetDataName();
		tr.SelectData.Color.nVal = m_pData->GetPlotColor();
	}
	else
	{
		m_pData->SetDataName(tr.SelectData.DataName.strVal, m_strCol);
		m_pData->SetPlotColor(tr.SelectData.Color.nVal);
	}

	m_pData->axisX.nFormat = tr.XAxisType.Format.nVal;
	m_pData->axisX.nSubFormat = tr.XAxisType.SubFormat.nVal;
	m_pData->axisX.strCustomDisplay = tr.XAxisType.CustomDisplay.strVal;

	m_pData->axisY.nFormat = tr.YAxisType.Format.nVal;
	m_pData->axisY.nSubFormat = tr.YAxisType.SubFormat.nVal;
	m_pData->axisY.strCustomDisplay = tr.YAxisType.CustomDisplay.strVal;
	
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	m_pData->OptimizePoint = tr.AutoFindType.AdjustType.nVal;
	///End OPTIMIZE_PICKED_POINT
}

void	DigitizerOptionsHelper::GetSettings(TreeNode& tr)
{
	#ifdef		MULTIPLE_CURVES
	tr.SelectData.ActiveData.nVal = m_pData->GetActiveData();
	#endif		/// MULTIPLE_CURVES
	tr.SelectData.DataName.strVal = GetDataName();
	tr.SelectData.Color.nVal = m_pData->GetPlotColor();

	tr.XAxisType.Format.nVal = m_pData->axisX.nFormat;
	tr.XAxisType.SubFormat.nVal = m_pData->axisX.nSubFormat;
	tr.XAxisType.CustomDisplay.strVal = m_pData->axisX.strCustomDisplay;
	
	tr.YAxisType.Format.nVal = m_pData->axisY.nFormat;
	tr.YAxisType.SubFormat.nVal = m_pData->axisY.nSubFormat;
	tr.YAxisType.CustomDisplay.strVal = m_pData->axisY.strCustomDisplay;
	
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	tr.AutoFindType.AdjustType.nVal = m_pData->OptimizePoint;
	///End OPTIMIZE_PICKED_POINT
}

string	DigitizerOptionsHelper::DataList()
{
	int		nNumPlots = m_pData->GetNumData();
	vector<string>		vs(nNumPlots);
	for ( int ii=0; ii<nNumPlots; ++ii )
	{
		vs[ii].Format("Line #%d", ii + 1);
	}
	string	strCombo;
	strCombo.SetTokens(vs, '|');
	return strCombo;
}

///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
string	DigitizerOptionsHelper::GetDataName()
{
	string	strBook, strSheet;
	okutil_parse_complete_range_string(m_pData->GetDataName(), &strBook, &strSheet, &m_strCol);
	return okutil_make_book_sheet_string(strBook, strSheet);
}
///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID

/*------------------------------------------------------------------------------*
* DigitizerOptionsHelper End 													*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* LocatePoints				 													*
 *------------------------------------------------------------------------------*/
#define		STR_HINT_DCLICK_TO_PICK_POINTS		_L("Double click or press Enter to pick points.")
#define		STR_HINT_ZOOM_AND_PAN				_L("Press Z to zoom and pan.")
///------ Folger 08/31/2011 ORG-3667-S1 ADD_ESC_HINT_FOR_DIGITIZER_GET_POINTS
#define		STR_HINT_ESC_CANCEL_ALL_ENTRIES		_L("Press ESC to cancel all entries.")
///------ End ADD_ESC_HINT_FOR_DIGITIZER_GET_POINTS

//class LocatePoints
//public:
LocatePoints::LocatePoints(WndContainer& Dlg, BOOL bHideParent/* = FALSE*/)
{
	m_pDRP = new LTVarTempChange("@DRP", 0);
	m_pDlg = &Dlg;
	/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	/*
	if ( bHideParent )
		m_wndParent = m_pDlg->GetParent();

	Window	wndTemp(GetWindow());
	m_wnd.Attach(wndTemp);
	if( m_wnd )
	{
		m_pDlg->ShowWindow(SW_HIDE);
		if ( m_wndParent )
		{
			m_wndParent.ShowWindow(SW_HIDE);
		}
		m_bWndOldEnable = m_wnd.Enable;
		m_wnd.Enable = TRUE;
	}
	else
	{
		m_bWndOldEnable = FALSE;
	}
	*/
	///End DIGITIZER_SUPPORT_MAGNIFIER
}
LocatePoints::~LocatePoints()
{
	NICE_SAFE_REMOVAL(m_pDRP);
	/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	/*
	m_wnd.Enable = m_bWndOldEnable;
	if ( m_wndParent )
	{
		m_wndParent.ShowWindow(SW_SHOW);
		m_wndParent.Enable = FALSE;
	}
	m_pDlg->ShowWindow(SW_SHOW);
	m_pDlg->Enable = TRUE;
	*/
	///End DIGITIZER_SUPPORT_MAGNIFIER
	
	Refresh();
}

BOOL	LocatePoints::GetOne(TreeNode& trNode)
{
	vector		vx, vy;
	if ( graph_get_points(vx, vy, NULL, NULL, NULL, NULL, 1, -1, NULL, false) != 1 )
		return FALSE;

	trNode.SetAttribute(STR_SCREEN_X, vx[0]);
	trNode.SetAttribute(STR_SCREEN_Y, vy[0]);
	return TRUE;
}

/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
BOOL	LocatePoints::GetVertexs(vector& vx, vector& vy, int nNumPoints)
{
	string	strMsg;	
	strMsg.Format("%s\n%s\n%s", STR_HINT_DCLICK_TO_PICK_POINTS, STR_HINT_ZOOM_AND_PAN, STR_HINT_ESC_CANCEL_ALL_ENTRIES);
	
	if ( graph_get_points(vx, vy, strMsg, STR_GRAPH_ADD_PTS_MSG2, NULL, NULL, nNumPoints, CURSOR_NONE, NULL, true, NULL, digitizer_display_one_point, digitizer_add_one_vertex) != nNumPoints )
		return FALSE;
	return TRUE;
}
///End SUPPORT_TERNARY_IN_DIGITIZER

BOOL	LocatePoints::GetMultiple(vector& vx, vector& vy)
{
	string	strMsg;
	///------ Folger 08/31/2011 ORG-3667-S1 ADD_ESC_HINT_FOR_DIGITIZER_GET_POINTS
	//strMsg.Format("%s\n%s", STR_HINT_DCLICK_TO_PICK_POINTS, STR_HINT_ZOOM_AND_PAN);
	strMsg.Format("%s\n%s\n%s", STR_HINT_DCLICK_TO_PICK_POINTS, STR_HINT_ZOOM_AND_PAN, STR_HINT_ESC_CANCEL_ALL_ENTRIES);
	///------ End ADD_ESC_HINT_FOR_DIGITIZER_GET_POINTS
	return graph_get_points(vx, vy, strMsg, STR_GRAPH_ADD_PTS_MSG2, NULL, NULL, -1, CURSOR_NONE, NULL, true, NULL, digitizer_calculate_one_point, digitizer_add_one_point);
}

///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
BOOL	LocatePoints::GetTraceLine(vector& vx, vector& vy)
{
	string	strMsg1, strMsg2;
	strMsg1.Format("%s\n%s\n%s", _L("Double click or press Enter to pick a point to start auto-trace"), STR_HINT_ZOOM_AND_PAN, STR_HINT_ESC_CANCEL_ALL_ENTRIES);
	strMsg2 = _L("Click DONE or press Ctrl+Enter to finish");
	return graph_get_points(vx, vy, strMsg1, strMsg2, NULL, _L("Auto Trace Line"), -1, CURSOR_NONE, NULL, true, NULL, digitizer_calculate_one_point, digitizer_trace_line);
}
///End DIGITIZER_AUTO_TRACE_LINE

//private:
BOOL	LocatePoints::Refresh()
{
	return LT_execute(";doc -uw;");
}

/*------------------------------------------------------------------------------*
* LocatePoints End			 													*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* DigitizerImageHelper		 													*
*------------------------------------------------------------------------------*/ 

#define		STR_IMAGE_OBJ_DEFAULT_NAME		"BMP"		///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER

enum
{
	UPDATEOPTIONSFROM_DATA			= 0x00000001,
	UPDATEOPTIONSFROM_DATANAME		= 0x00000002,
};

static bool _update_curves(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	GetNOptionEventHelper	eventHelper(dwCntrl);
	if ( !eventHelper.IsInit() )
	{
		DigitizerImpl	digitizerImpl;
		DWORD			dwCntrl = 0;
		O_SET_BIT(dwCntrl, UPDATEOPTIONSFROM_DATA, trNode.tagName.Compare("ActiveData") == 0);
		O_SET_BIT(dwCntrl, UPDATEOPTIONSFROM_DATANAME, trNode.tagName.Compare("DataName") == 0);
		return digitizerImpl.UpdateOptions(myTree, dwCntrl);
	}	
	return true;
}

//class DigitizerImageHelper
//public:
DigitizerImageHelper::DigitizerImageHelper(DigitizerImplData& data, DigitizerObjsHolder& objsHolder)
{
	m_pData = &data;
	m_pObjsHolder = &objsHolder;
	/// Iris 01/18/2012 ORG-4894-P1 FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	//getImageBITMAPHANDLE(false); /// Iris 12/27/2011 ORG-4685-S3 NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE
	SaveImageBITMAPHANDLE();
	///End FIX_ROTATE_GETN_DLG_ISSUE
	///End FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
}
DigitizerImageHelper::~DigitizerImageHelper()
{
}

BOOL	DigitizerImageHelper::Import()
{	
	return ImportImage(GetImageFile());	
}

///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
BOOL	DigitizerImageHelper::ImportFromClipboard()
{
	m_pObjsHolder->PrepareDigitizePage();
	GraphObject	image = GetDigitizeImage();
	if ( image )
	{
		image.Destroy();
	}
	
	GraphObject goImage = m_pObjsHolder->GetDigitizeLayer().PasteImage(0, 0, PASTEIMAGE_CONVERT_TO_DIB);
	if( !goImage )
	   return false;
	goImage.SetName(STR_IMAGE_OBJ_DEFAULT_NAME);		///------change the name as same as STR_IMAGE_OBJ_DEFAULT_NAME
	
	m_pData->Init(TRUE);
	return UpdateDataNameForClipboardImage()
		&& UpdatePageLongName()
		&& FitLayerToPage()
		&& SetupImage()
		&& PrepareImageBackup()
		&& UpdateAxesDefault();
}
///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER

//private:
string	DigitizerImageHelper::GetImageFile()
{
	string	strFileName;
	int		nFiles = get_open_box_by_file_group(strFileName, "ImageImp", "Images", false);
	return strFileName;
}

GraphPage	DigitizerImageHelper::GetDigitizePage()
{
	return m_pObjsHolder->GetDigitizePage();
}

GraphLayer	DigitizerImageHelper::GetDigitizeLayer()
{
	return m_pObjsHolder->GetDigitizeLayer();
}

GraphObject	DigitizerImageHelper::GetDigitizeImage()
{
	return m_pObjsHolder->GetDigitizeImage();
}

BOOL		DigitizerImageHelper::SetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double rVal, BOOL bDelay/* = FALSE*/)
{
	return m_pObjsHolder->SetObjProperty(lpcszName, lpcszProp, rVal, bDelay);
}

BOOL	DigitizerImageHelper::ImportImage(LPCSTR lpcszFileName)
{
	if ( NULL == lpcszFileName || '\0' == *lpcszFileName )
		return FALSE;
	
	m_pObjsHolder->PrepareDigitizePage();
	GraphObject	image = GetDigitizeImage();
	if ( image )
	{
		image.Destroy();
	}
	
	DISABLE_LT_UNDO;
	if ( !ImportImageIntoActiveLayer(lpcszFileName) )
		return FALSE;
	
	m_pData->Init(TRUE);
	return UpdateDataNameByImageFileName(lpcszFileName)
	///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	//	&& UpdatePageLongName(lpcszFileName)
		&& UpdatePageLongName()
	///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER	
		&& FitLayerToPage()
		&& SetupImage()
		&& PrepareImageBackup(lpcszFileName)
		&& UpdateAxesDefault()
		/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
		//&& getImageBITMAPHANDLE(true); /// Iris 01/18/2012 ORG-4894-P1 FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
		&& SaveImageBITMAPHANDLE(true);
		///End FIX_ROTATE_GETN_DLG_ISSUE
}

/// Iris 12/27/2011 ORG-4685-S3 NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE
/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
//BOOL	DigitizerImageHelper::getImageBITMAPHANDLE(bool bImageChanged)
BOOL	DigitizerImageHelper::SaveImageBITMAPHANDLE(bool bImageChanged)
///End FIX_ROTATE_GETN_DLG_ISSUE
{
	// if not import other image file, and m_LBImage is not empty, no need to copy again.
	if( 0 == m_LBImage.Width || bImageChanged )
	{	
		GraphObject obj = GetDigitizeImage();
		if( obj )
		{			
			LPVOID pSourceDIB = obj.GetDIBHandle();	
			copy_DIB_to_LeadBitmap(&m_LBImage, pSourceDIB);			
			return TRUE;
		}
	}
	return FALSE;
}
///End NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE

bool	DigitizerImageHelper::ResetImage(GraphObject& goImage)
{
	HDIB hDIB = L_ConvertToDIB(&m_LBImage, DIB_BITMAPINFOHEADER);
	///Rex 2012/4/11 ORG-5112-P9 FIX_MEMORY_LEAK_IN_MANIFIER
	//return goImage.SetDIBHandle(hDIB);	
	bool bRet = goImage.SetDIBHandle(hDIB);
	GlobalFree(hDIB);
	return bRet;
	///End FIX_MEMORY_LEAK_IN_MANIFIER
}

//#define		STR_IMAGE_OBJ_DEFAULT_NAME		"BMP"		///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
BOOL	DigitizerImageHelper::SetupImage()
{
	GraphObject		image = GetDigitizeLayer().GraphObjects(STR_IMAGE_OBJ_DEFAULT_NAME);
	image.SetName(STR_IMAGE_NAME);
	
	image.Attach = ATTACH_TO_PAGE;
	return SetupImageExecScript()
		&& SetImageNoSelect()
		&& FitImageToPage();
}

BOOL	DigitizerImageHelper::FitLayerToPage()
{
	int			nWidth, nHeight;
	if ( !page_get_width_height(GetDigitizePage(), &nWidth, &nHeight) )
		return FALSE;
	
	string		strLT;
	strLT.Format("layer.width=%d;layer.Height=%d;", nWidth, nHeight);
	return GetDigitizeLayer().LT_execute(strLT);
}

BOOL	DigitizerImageHelper::FitImageToPage()
{
	///------ Folger 08/03/2011 ORG-3412-P1 DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO
	if ( !UpdateImageSize() )
		return FALSE;
	///------ End DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO

	int			nWidth, nHeight;
	if ( !page_get_width_height(GetDigitizePage(), &nWidth, &nHeight) )
		return FALSE;
	
	double		rRatio = max((double)(m_pData->nImageWidth) / nWidth, (double)(m_pData->nImageHeight) / nHeight);

	///------ Folger 05/04/2012 ORG-5616-P1 DIGITIZER_BETTER_PAGE_LAYER_SIZE
	//GraphLayer		gl = GetDigitizeLayer();
	//gl.X.To = (int)(nWidth * rRatio);
	//gl.Y.From = (int)(nHeight * rRatio);
	///------ End DIGITIZER_BETTER_PAGE_LAYER_SIZE

	GraphObject	image = GetDigitizeImage();
	image.Width = m_pData->nImageWidth / rRatio;
	image.Height = m_pData->nImageHeight / rRatio;

	///------ Folger 05/04/2012 ORG-5616-P1 DIGITIZER_BETTER_PAGE_LAYER_SIZE
	GraphLayer		gl = GetDigitizeLayer();
	///------ Folger 08/28/2012 ORG-3412-P1 SHOW_ACUTAL_IMAGE_PIXELS_IN_DIGITIZER_PIXEL_LIST
	//gl.X.To = m_pData->nImageWidth / rRatio;
	//gl.Y.From = m_pData->nImageHeight / rRatio;
	gl.X.To = m_pData->nImageWidth;
	gl.Y.From = m_pData->nImageHeight;
	///------ End SHOW_ACUTAL_IMAGE_PIXELS_IN_DIGITIZER_PIXEL_LIST

	string		strLT;
	strLT.Format("layer.width=%d;page.width=%d;page.height=%d;layer.Height=%d;", image.Width, image.Width, image.Height, image.Height);
	gl.LT_execute(strLT);
	///------ End DIGITIZER_BETTER_PAGE_LAYER_SIZE
	
	return TRUE;
}

BOOL	DigitizerImageHelper::SetImageNoSelect()
{
	return SetObjProperty(STR_IMAGE_NAME, "states", GOC_NO_SELECT);
}

BOOL	DigitizerImageHelper::UpdateDataNameByImageFileName(LPCSTR lpcszFile)
{
	return m_pData->UpdateDataNameByImageFileName(lpcszFile);
}

///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
BOOL	DigitizerImageHelper::UpdateDataNameForClipboardImage()
{
	return m_pData->UpdateDataNameForClipboardImage();
}
///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER

///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
//BOOL	UpdatePageLongName(LPCSTR lpcszFile)
BOOL	DigitizerImageHelper::UpdatePageLongName()
///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
{
	///------ Folger 02/22/2011 ORG-2309-P1 NEVER_RENAME_PAGE_SHORT_NAME_BY_LONG_NAME_IN_DIGITIZER
	//return GetDigitizePage().SetLongName(m_pData->strImageName);
	return GetDigitizePage().SetLongName(m_pData->strImageName, FALSE);
	///------ End NEVER_RENAME_PAGE_SHORT_NAME_BY_LONG_NAME_IN_DIGITIZER
}

BOOL	DigitizerImageHelper::UpdateAxesDefault()
{
	GraphLayer	gl = GetDigitizeLayer();
	
	int		nWidth = gl.X.To;
	int		nHeight = gl.Y.From;
	double	rPercent1 = 0.1, rPercent2 = 0.2;
	m_pData->x1.ny = m_pData->x2.ny = (1 - rPercent1) * nHeight;
	m_pData->y1.nx = m_pData->y2.nx = rPercent1 * nWidth;
	m_pData->x1.nx = rPercent2 * nWidth;
	m_pData->x2.nx = (1 - rPercent2) * nWidth;
	m_pData->y1.ny = (1 - rPercent2) * nHeight;
	m_pData->y2.ny = rPercent2 * nHeight;

	return TRUE;
}

BOOL	DigitizerImageHelper::PrepareImageBackup(LPCSTR lpcszFileName)
{
	if ( !ImportImageIntoActiveLayer(lpcszFileName) )
		return FALSE;

	GraphObject		image = GetDigitizeLayer().GraphObjects(STR_IMAGE_OBJ_DEFAULT_NAME);
	image.Show = FALSE;
	return image.SetName(STR_IMAGE_BACKUP_NAME);
}

///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
BOOL	DigitizerImageHelper::PrepareImageBackup()
{
	GraphObject goImage = m_pObjsHolder->GetDigitizeLayer().PasteImage(0, 0, PASTEIMAGE_CONVERT_TO_DIB);
	if( !goImage )
	   return false;
	goImage.Show = FALSE;
	return goImage.SetName(STR_IMAGE_BACKUP_NAME);
}
///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER

BOOL	DigitizerImageHelper::ImportImageIntoActiveLayer(LPCSTR lpcszFileName)
{
	return image_import_to_active_graph_layer(lpcszFileName, 0, 0);
}

/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
bool DigitizerImageHelper::addDataMarker(pBITMAPHANDLE pLBROI, int nMarkerSize, int x, int y)
{
	if( nMarkerSize > pLBROI->Width || nMarkerSize > pLBROI->Height)
	{
		nMarkerSize = min(pLBROI->Width, pLBROI->Height);
	}	
	int nOldMarkerSize = nMarkerSize;
	if( is_equal(0, nMarkerSize % 2) ) // convert odd to even to make the cross looks better
		nMarkerSize++;	
	if( nMarkerSize < 2 )
		nMarkerSize = 2;
	//printf("nOldMarkerSize = %d, nMarkerSize=%d, x=%d, y=%d\n", nOldMarkerSize, nMarkerSize, x, y);
	
	int nRet;
	bool bRet = true;
	
	//------------ to add vertical line
	BITMAPHANDLE LTMarkV; 
	nRet = L_CreateBitmap(&LTMarkV, sizeof(BITMAPHANDLE), 
			TYPE_CONV, 
			1,
			nMarkerSize,
			pLBROI->BitsPerPixel,
			pLBROI->Order,
			pLBROI->pPalette,
			pLBROI->ViewPerspective, NULL, 0);
	if( nRet != SUCCESS)
	{			
		bRet = error_report("L_CreateBitmap failed to create vertical line of data mark, nRet = " + (string)nRet);
	}
	
	if( bRet ) // if create bitmap successfully
	{
		nRet = L_FillBitmap(&LTMarkV, RGB(255, 0, 0)); // fill with red color
		if( nRet != SUCCESS)
		{			
			bRet = error_report("L_FillBitmap failed to fill red color to data mark, nRet = " + (string)nRet);
		}
	}
	
	
	if( bRet ) // if fill color successfully
	{		
		int nNumOfBytes = LTMarkV.BitsPerPixel*LTMarkV.Width/8;
		if ((LTMarkV.BitsPerPixel*LTMarkV.Width) % 8)
			++nNumOfBytes;
		//out_int("nNumOfBytes of V = ", nNumOfBytes);
		
		L_UCHAR        *pVBuf; 
		HGLOBAL        hVBuf;		
		hVBuf = GlobalAlloc(GMEM_MOVEABLE, nNumOfBytes);
		pVBuf = (L_UCHAR *)GlobalLock( hVBuf ); 
		
		int nColOffset = x;
		ASSERT(nColOffset >= 0);
		if( nColOffset < 0 )
			nColOffset = 0;
		for(int nRow = 0; nRow < LTMarkV.Height; nRow++)
		{
			nRet = L_GetBitmapRow(&LTMarkV, pVBuf, nRow, nNumOfBytes);
			if(nRet < 1)
			{			
				bRet = error_report("L_GetBitmapRow failed to get row from data mark bitmap, nRet = " + (string)nRet);
			}
			
			int nPutRow = y - nMarkerSize / 2 + nRow;
			if( nPutRow < 0 )
				nPutRow = 0;
			if( nPutRow >= pLBROI->Height )
				nPutRow = pLBROI->Height - 1;
			//printf("V%d, Col=%d, Row=%d\n", nRow+1, nColOffset, nPutRow);
			nRet = L_PutBitmapRowCol(pLBROI, pVBuf, nPutRow, nColOffset, nNumOfBytes);
			//printf("V: nNumOfBytes = %d, nRet = %d\n", nNumOfBytes, nRet);			
			
			if(nRet < 1) // if put 0 byte
			{			
				bRet = error_report("L_PutBitmapRowCol failed to put row to ROI bitmap, nRet = " + (string)nRet);
			}
		} 
		GlobalUnlock(hVBuf);
		GlobalFree(hVBuf); 
	}
	L_FreeBitmap(&LTMarkV);
	
	//------------ to add horizontal line
	BITMAPHANDLE LTMarkH; 
	nRet = L_CreateBitmap(&LTMarkH, sizeof(BITMAPHANDLE), 
			TYPE_CONV, 
			nMarkerSize,
			1,
			pLBROI->BitsPerPixel,
			pLBROI->Order,
			pLBROI->pPalette,
			pLBROI->ViewPerspective, NULL, 0);
	if( nRet != SUCCESS)
	{			
		bRet = error_report("L_CreateBitmap failed to create horizontal line of data mark, nRet = " + (string)nRet);
	}
	
	if( bRet ) // if create bitmap successfully
	{
		nRet = L_FillBitmap(&LTMarkH, RGB(255, 0, 0)); // fill with red color
		if( nRet != SUCCESS)
		{			
			bRet = error_report("L_FillBitmap failed to fill red color to data mark, nRet = " + (string)nRet);
		}
	}
	
	if( bRet ) // if fill color successfully
	{
		L_UCHAR        *pHBuf; 
		HGLOBAL        hHBuf;		
		hHBuf = GlobalAlloc(GMEM_MOVEABLE, LTMarkH.BytesPerLine);
		pHBuf = (L_UCHAR *)GlobalLock( hHBuf );
		
		int nColOffset = x - nMarkerSize / 2;
		if( nColOffset < 0 )
			nColOffset = 0;
		int nNumOfBytes = LTMarkH.BitsPerPixel*LTMarkH.Width/8;//LTMarkH.BytesPerLine;
		if ((LTMarkH.BitsPerPixel*LTMarkH.Width) % 8)
			++nNumOfBytes;
		//out_int("nNumOfBytes of H = ", nNumOfBytes);
		
		ASSERT(1 == LTMarkH.Height);
		for(int nRow = 0; nRow < LTMarkH.Height; nRow++)
		{
			nRet = L_GetBitmapRow(&LTMarkH, pHBuf, nRow, nNumOfBytes);
			if(nRet < 1)
			{			
				bRet = error_report("L_GetBitmapRow failed to get row from data mark bitmap, nRet = " + (string)nRet);
			}
			
			int nPutRow = y;
			//printf("H%d, Col=%d, Row=%d\n", nRow+1, nColOffset, nPutRow);
			nRet = L_PutBitmapRowCol(pLBROI, pHBuf, nPutRow, nColOffset, nNumOfBytes);
			ASSERT(nNumOfBytes == nRet);
			
			if(nRet < 1 )
			{			
				bRet = error_report("L_PutBitmapRowCol failed to put row to ROI bitmap, nRet = " + (string)nRet);
			}
		}	
		GlobalUnlock(hHBuf);
		GlobalFree(hHBuf); 
	}
	L_FreeBitmap(&LTMarkH);

	return bRet;
}
		
bool DigitizerImageHelper::GetImageROI(pBITMAPHANDLE &pLBROI, int xPixels, int yPixels, int nROIPercent)
{	
	bool bRet = true;	
	if( pLBROI )
	{
		if( xPixels > m_LBImage.Width || yPixels > m_LBImage.Height )
		{
			//string strErr; // for debug use
			//strErr.Format("GetImageROI, out of image. \nImage.Width = %d, Image.Height = %d, xPixels = %d, yPixels = %d.", m_LBImage.Width, m_LBImage.Height, xPixels, yPixels);
			//return error_report(strErr);
			return false;
		}
		
		int nMaxWidthOfPreview = nint(m_LBImage.Width / 2.0);
		int nMaxHeightOfPreview = nint(m_LBImage.Height / 2.0);
		int cx 	= nint(nMaxWidthOfPreview * nROIPercent / 100.0);
		int cy 	= nint(nMaxHeightOfPreview * nROIPercent / 100.0);		
		int nMinSizeOfPreview = 2;
		if( cx < nMinSizeOfPreview )
			cx = nMinSizeOfPreview;
		if( cy < nMinSizeOfPreview )
			cy = nMinSizeOfPreview;
		
		int x	= xPixels - nint(cx / 2.0);
		if( x < 0 )		
			x = 0;
		int y 	= (m_LBImage.Height - yPixels) - nint(cy / 2.0);
		if( y < 0 )
			y = 0;		

		///Rex 2012/4/11 ORG-5112-P4 FIX_BLACK_BORDER_OF_MANIFIER
		x = min(x, m_LBImage.Width-cx); 
		y = min(y, m_LBImage.Height-cy);
		///End FIX_BLACK_BORDER_OF_MANIFIER
		
		///Rex 2012/4/11 ORG-5112-P9 FIX_MEMORY_LEAK_IN_MANIFIER
		if(pLBROI->Flags.Allocated) 		
			L_FreeBitmap(pLBROI);	
		///End FIX_MEMORY_LEAK_IN_MANIFIER
		
		int nRet;
		if( SUCCESS != (nRet = L_COPY_BITMAP_RECT(pLBROI, &m_LBImage, x, y, cx, cy) ) )	
		{			
			bRet = error_report("L_COPY_BITMAP_RECT copy from source failed, nRet = " + (string)nRet);
		}
		else
		{			
			// add data marker
			int nMarkerSize = cx * NUM_MAGNIFIER_MARKER_SIZE_PERCENT / 100.0; 
			int xMarker = xPixels - x;
			if( xMarker < 0 )
				xMarker = 0;
			int yMarker = (m_LBImage.Height - yPixels) - y;
			if( yMarker < 0 )
				yMarker = 0;		
			
			addDataMarker(pLBROI, nMarkerSize, xMarker, yMarker);		
		}
	}	

	return bRet;
}
///End DIGITIZER_SUPPORT_MAGNIFIER	

BOOL	DigitizerImageHelper::SetupImageExecScript()
{
	return LT_execute(STR_IMAGE_NAME ".script$=" OBJ_MAIN_LABTALK_SCRIPT) && SetObjProperty(STR_IMAGE_NAME, "script", GRCT_ANY_EVENT);
}

///------ Folger 08/03/2011 ORG-3412-P1 DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO
BOOL	DigitizerImageHelper::UpdateImageSize()
{
	matrix<BYTE>	mm;
	if ( !GetDigitizeLayer().GetImageData(STR_IMAGE_NAME, mm) )
		return FALSE;

	m_pData->nImageWidth = mm.GetNumCols();
	m_pData->nImageHeight = mm.GetNumRows();
	return TRUE;
}
///------ End DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO

/*------------------------------------------------------------------------------*
* DigitizerImageHelper End	 													*
*------------------------------------------------------------------------------*/ 

/*------------------------------------------------------------------------------*
* DigitizerRunner			 													*
*------------------------------------------------------------------------------*/ 
///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
typedef int (*FUNC_IMAGE_SPLIT_RGB)(const Image& imgSource, Image& imgRed, Image& imgGreen, Image& imgBlue);
typedef int (*FUNC_MATRIX_FIND_PEAK_CENTER)(const matrix& mi, int nCtrRow0, int nCtrCol0, int& nCtrRow, int& nCtrCol);
///End OPTIMIZE_PICKED_POINT
//class DigitizerRunner
//public:
DigitizerRunner::DigitizerRunner(DigitizerImplData& data)
{
	m_pData = &data;
}

int		DigitizerRunner::Run(Dialog& dlg)
{
	LocatePoints	pts(dlg);
	vector			vx, vy;
	vx = m_pData->PtsScrX;
	vy = m_pData->PtsScrY;
	return pts.GetMultiple(vx, vy);
}

BOOL	DigitizerRunner::Calculate()
{
	m_pData->PrepareDataForCalculate();
	if ( m_pData->Size() <= 0 )
		return FALSE;

	return Calculate(m_pData->PtsX, m_pData->PtsY);
}

BOOL	DigitizerRunner::CalculateOnePoint(double& x, double& y)
{
	vector		vx(1), vy(1);
	vx[0] = x, vy[0] = y;

	Calculate(vx, vy);
	x = vx[0], y = vy[0];
	return TRUE;
}

///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
BOOL	DigitizerRunner::AntiCalculate()
{
	m_pData->PrepareDataForCalculate(FALSE);
	if ( m_pData->Size() <= 0 )
		return FALSE;

	return Calculate(m_pData->PtsScrX, m_pData->PtsScrY, TRUE);
}
///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
bool 	DigitizerRunner::PrepareImageMatrix()
{		
	MatrixObject mobjExist;
	okxf_resolve_string_get_origin_object(m_pData->strImageMatrixObj, &mobjExist);
	if(mobjExist)
		return true;
	
	MatrixPage mp;
	mp.Create("origin", CREATE_HIDDEN|CREATE_SET_MISSING_IN_MANAGER);
	
	MatrixLayer ml = mp.Layers(0);
	MatrixObject moImage = ml.MatrixObjects(0);
	image_import_to_matrix(moImage, m_pData->strImageFile);		
	int nRows 		= moImage.GetNumRows();
	int nCols 		= moImage.GetNumCols();		
	int nNewLayer 	= ml.GetPage().AddLayer();
	if(nNewLayer <= 0)
		return false;
	
	//split RGB
	MatrixLayer mlNew = ml.GetPage().Layers(nNewLayer);	
	mlNew.SetSize(3, nRows, nCols);
	MatrixObject mRed(mlNew, 0);
	MatrixObject mGreen(mlNew, 1);
	MatrixObject mBlue(mlNew, 2);
	Image imgRGB(moImage);
	Image imgR(mRed);
	Image imgG(mGreen);
	Image imgB(mBlue);
	FUNC_IMAGE_SPLIT_RGB pfn = Project.FindFunction("image_split_rgb", "Originlab\\matdata_utils.c", TRUE);
	if(!pfn)
		return false;		
	pfn(imgRGB, imgR, imgG, imgB);
	imgR.CopyTo(mRed, true);
	imgG.CopyTo(mGreen, true);
	imgB.CopyTo(mBlue, true);
	mRed.SetInternalData(FSI_DOUBLE);	
	mGreen.SetInternalData(FSI_DOUBLE);	
	mBlue.SetInternalData(FSI_DOUBLE);	
	
	//get the biggest contrast one
	bool 	bByRow 	= false;
	double 	dSDMax 	= 0;
	int		nMat 	= -1;
	foreach(MatrixObject mat in mlNew.MatrixObjects)
	{
		vector vv;
		mat.GetDataObject().GetAsVector(vv, bByRow);
		
		int nN;
		double dMean, dSD;
		ocmath_basic_summary_stats(vv.GetSize(), vv, &nN, &dMean, &dSD);
		if(dSDMax < dSD)
		{
			dSDMax = dSD;
			nMat = mat.GetIndex();
		}
	}
	if(dSDMax <= 0)
		return false;	
	MatrixObject mobj = mlNew.MatrixObjects(nMat);
	mobj.GetRangeString(m_pData->strImageMatrixObj, NTYPE_SHORT_NAME_ONLY);
	
	//normalize
	vector vZ;
	Matrix& Mat = mobj.GetDataObject();	
	Mat.GetAsVector(vZ, bByRow);
	vZ = 255 - vZ;//assumw the data points' value is samll and the background is big
	double dMin, dMax;
	vZ.GetMinMax(dMin, dMax);
	double dSub 		= dMin;
	double dNormalizeVal= dMax - dMin;		
	double dFactor 		= (is_equal(0.0, dNormalizeVal)) ? NANUM : 1.0 / dNormalizeVal;	
	vZ -= dSub;
	vZ *= dFactor;		
	Mat.SetByVector(vZ, bByRow);
	
	Mat.SetXMin(0);
	Mat.SetXMax(m_pData->nImageWidth);
	Mat.SetYMin(0);
	Mat.SetYMax(m_pData->nImageHeight);

	return true;
}

void 	DigitizerRunner::DestroyImageMatrix()
{
	MatrixObject mobj;
	okxf_resolve_string_get_origin_object(m_pData->strImageMatrixObj, &mobj);
	if(mobj)
	{
		MatrixLayer ml;
		mobj.GetParent(ml);
		ml.GetPage().Destroy();
	}
}

///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
/// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
//#define STR_DIGITIZE_IMG_PROCESS_SOURCE_MATRIX 					"Source"
///End IMPROVE_IMAGE_PROCESS_MATRIX
#define STR_DIGITIZE_IMG_PROCESS_GRAY_MATRIX					"Gray"
#define STR_DIGITIZE_IMG_PROCESS_SALIENT_MATRIX 				"Salient"
#define STR_DIGITIZE_IMG_PROCESS_ORIENT_MATRIX 					"Orient"
#define STR_DIGITIZE_IMG_PROCESS_MASK_MATRIX 					"Mask"
#define STR_DIGITIZE_IMG_PROCESS_ANGLE_MATRIX 					"Angle"
#define STR_DIGITIZE_IMG_PROCESS_CURRENT_MATRIX 				"Current"
#define STR_DIGITIZE_IMG_PROCESS_PREVIOURS_MATRIX				"Previous"
#define STR_DIGITIZE_IMG_PROCESS_PREV_MASK_MATRIX 				"PreMask"
/// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
//#define STR_DIGITIZE_IMG_PROCESS_DIB_MATRIX		 				"DIB"
#define STR_DIGITIZE_IMG_PROCESS_TRACE_MASK_MATRIX				"TraceMask" 
///End IMPROVE_IMAGE_PROCESS_MATRIX
  

//#define  _CHECK_GET_MATRIX_LAYOBJ(_MLOBJ, _STRNAME)	\
		//MatrixObject _MLOBJ;						\
		//ml = mp.Layers(_STRNAME);					\
		//if(!ml)										\
		//{											\
			//int nLayer = mp.AddLayer(_STRNAME);		\
			//if(nLayer < 0)							\
				//return false;						\
			//ml = mp.Layers(nLayer);					\
			//if(!ml)									\
			//return false;							\
		//}											\
		//_MLOBJ = ml.MatrixObjects();
//
//#define	_BACKUP_IMAGE_PROCESS_MATRIX(moSrc, moCurrent, moPrevious, maskImg, maskPrevious)	\
		//MatrixObject moSrc;																	\
		//if( !GetImageProcessMatrix(moSrc, true) )											\
			//return false;																	\		
		//MatrixLayer ml;																		\
		//moSrc.GetParent(ml);																\
		//MatrixPage mp = ml.GetPage();														\
		//_CHECK_GET_MATRIX_LAYOBJ(moCurrent, 	STR_DIGITIZE_IMG_PROCESS_CURRENT_MATRIX)	\
		//_CHECK_GET_MATRIX_LAYOBJ(moPrevious, 	STR_DIGITIZE_IMG_PROCESS_PREVIOURS_MATRIX)	\
	    //_CHECK_GET_MATRIX_LAYOBJ(maskImg, 		STR_DIGITIZE_IMG_PROCESS_MASK_MATRIX)		\
		//_CHECK_GET_MATRIX_LAYOBJ(maskPrevious, STR_DIGITIZE_IMG_PROCESS_PREV_MASK_MATRIX)	\
																							//\
		//bool bRet = matobj_copy(moPrevious, moCurrent, false, NULL, true, false);			\
		//bRet = matobj_copy(maskPrevious, maskImg, false, NULL, true, false);
		//
///// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED
//#define _REFRESH_GET_IMAGE_PROCESS_MATRIX(bRefresh)											\
		//MatrixObject moSrc;																	\
		//GetImageProcessMatrix(moSrc, bRefresh);												\
		//if( !moSrc )																		\
			//return false;																	\
		//MatrixLayer ml;																		\
		//moSrc.GetParent(ml);																\
		//MatrixPage mp = ml.GetPage();
//
//#define _REFRESH_IMAGE_PROCESS_MATRIX	_REFRESH_GET_IMAGE_PROCESS_MATRIX(true)
//#define _GET_IMAGE_PROCESS_MATRIX		_REFRESH_GET_IMAGE_PROCESS_MATRIX(false)
/////End 	IMPROVE_DIGITIZER_AREA_SPEED
//
///// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED
////bool	DigitizerRunner::GetImageProcessMatrix(MatrixObject& mobjSrcImage, bool bCreate/* = true*/)
//// bCreate not needed since if not exist always need create a new one.
//bool	DigitizerRunner::GetImageProcessMatrix(MatrixObject& mobjSrcImage, bool bRefreshImage/* = false*/)
/////End IMPROVE_DIGITIZER_AREA_SPEED
//{
	//okxf_resolve_string_get_origin_object(m_pData->strSrcMatrix, &mobjSrcImage);
	///// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED
	///*
	//if(mobjSrcImage)
		//return true;
	//
	//if(!bCreate)
		//return false;	
	//
	//MatrixPage mp;	
	//mp.Create("origin", CREATE_EMPTY|CREATE_HIDDEN|CREATE_SET_MISSING_IN_MANAGER);
	//*/	
	//bool bNewCreated = false;
	//MatrixPage mp;
	//MatrixLayer ml;
	//if( !mobjSrcImage )
	//{		
		//mp.Create("origin", CREATE_EMPTY|CREATE_HIDDEN/*|CREATE_SET_MISSING_IN_MANAGER*/);
		//bNewCreated = true;
	//}
	//else
	//{
		//mobjSrcImage.GetParent(ml);
		//mp = ml.GetPage();
	//}
		//
	//_CHECK_GET_MATRIX_LAYOBJ(moImage, 	STR_DIGITIZE_IMG_PROCESS_SOURCE_MATRIX)	
    //_CHECK_GET_MATRIX_LAYOBJ(maskImg, 	STR_DIGITIZE_IMG_PROCESS_MASK_MATRIX)	
    //_CHECK_GET_MATRIX_LAYOBJ(moCurrent, STR_DIGITIZE_IMG_PROCESS_CURRENT_MATRIX)
     //
    ///// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED    
    //if( bNewCreated )
    /////End IMPROVE_DIGITIZER_AREA_SPEED
    //{
		//image_import_to_matrix(moImage, m_pData->strImageFile);		
		//bool bRet = matobj_copy(moCurrent, moImage, false, NULL, true, false);
		//moImage.GetRangeString(m_pData->strSrcMatrix, NTYPE_SHORT_NAME_ONLY);	
//
		//int nRows = moCurrent.GetNumRows(), nCols = moCurrent.GetNumCols();
		//_SET_MAT_SIZE(maskImg, nRows, nCols)
		//_SET_MAT_DATA_TYPE(maskImg, FSI_BYTE)
	//
	///// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED
	//// after do image analysis, for example rotate, should get the current image (after rotate) to do digitize.
	//}
	//else if( bRefreshImage )
	//{
		//GraphLayer gl = Project.ActiveLayer();
		//if( gl )
		//{
			//GraphObject goImage = gl.GraphObjects(m_pData->strImageName);
			//if( goImage )
			//{
				//LPVOID pCurrentDIB = goImage.GetDIBHandle();
				//if( NULL != pCurrentDIB )
				//{
					//moCurrent.SetDIB(pCurrentDIB);
				//}
			//}
		//}
	//}	
	/////End IMPROVE_DIGITIZER_AREA_SPEED	
	//mobjSrcImage = moImage;		
	//return true;
//}

#define	_CHECK_GET_IMAGE_PROCESS_MATRIX								\
		MatrixObject moCurrent;										\
		if( !GetImageProcessMatrix(moCurrent) )						\
			return false;											

// before call this define need to call _CHECK_GET_IMAGE_PROCESS_MATRIX first
#define  _CHECK_GET_MATRIX_LAYOBJ(_MLOBJ, _STRNAME)					\		
		MatrixObject _MLOBJ;										\
		if( !CheckGetMatrixObject(moCurrent, _MLOBJ, _STRNAME) )	\
			return false;	
			
// before call this define need to call _CHECK_GET_IMAGE_PROCESS_MATRIX first			
#define	_BACKUP_IMAGE_PROCESS_MATRIX(moCurrent, moPrevious, maskImg, maskPrevious)			\
		_CHECK_GET_MATRIX_LAYOBJ(moPrevious, 	STR_DIGITIZE_IMG_PROCESS_PREVIOURS_MATRIX)	\
	    _CHECK_GET_MATRIX_LAYOBJ(maskImg, 		STR_DIGITIZE_IMG_PROCESS_MASK_MATRIX)		\
		_CHECK_GET_MATRIX_LAYOBJ(maskPrevious,  STR_DIGITIZE_IMG_PROCESS_PREV_MASK_MATRIX)	\
																							\
		bool bRet = matobj_copy(moPrevious, moCurrent, false, NULL, true, false);			\
		bRet = matobj_copy(maskPrevious, maskImg, false, NULL, true, false);

bool	DigitizerRunner::GetImageProcessMatrix(MatrixObject& moCurrent)
{	
	okxf_resolve_string_get_origin_object(m_pData->strImageMatrix, &moCurrent);	
		
	if( !moCurrent )
	{
		MatrixPage mp;		
		mp.Create("origin", CREATE_EMPTY|CREATE_HIDDEN/*|CREATE_SET_MISSING_IN_MANAGER*/);
		
		MatrixLayer ml;
		int nLayer = mp.AddLayer(STR_DIGITIZE_IMG_PROCESS_CURRENT_MATRIX);		
		ml = mp.Layers(nLayer);
		moCurrent = ml.MatrixObjects();		
		moCurrent.GetRangeString(m_pData->strImageMatrix, NTYPE_SHORT_NAME_ONLY);
		
		// copy image from graph to init Current matrix		
		GraphLayer gl = Project.ActiveLayer();
		ASSERT( gl );
		if( gl )
		{
			GraphObject goImage = gl.GraphObjects(STR_IMAGE_NAME);
			ASSERT( goImage );
			if( goImage )
			{
				LPVOID pDIB = goImage.GetDIBHandle();
				
				pBITMAPHANDLE 	pLBImage;
				BITMAPHANDLE 	LBImage, LBImageTmp;
				copy_DIB_to_LeadBitmap(&LBImage, pDIB);
				
				if( TOP_LEFT != LBImage.ViewPerspective )
				{					
					if( SUCCESS == L_CHANGE_VIEW_PERSPECTIVE(&LBImageTmp, &LBImage, TOP_LEFT) )
					{
						pLBImage = &LBImageTmp;
					}					
				}	
				else
				{
					pLBImage = &LBImage;
				}				
				moCurrent.SetLeadBitmap(pLBImage);				
				
				//----- Iris 7/11/2012 to fix got incorrect xy when pick point from image 
				// the xy settings of this backup matrix is not setup correctly, the xy range should be same as image graph object. 
				//--------- Iris 8/30/2012 to fix digitizer area picked points outsize of image
				//moCurrent.SetXY(0, 0, goImage.Width, goImage.Height);
				moCurrent.SetXY(0, 0, m_pData->nImageWidth, m_pData->nImageHeight);
				//---------
				//-----
			}
		}						
	} 	
	return true;
}

/// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
bool	DigitizerRunner::BackupImageMatrix()
{
	_CHECK_GET_IMAGE_PROCESS_MATRIX
	_BACKUP_IMAGE_PROCESS_MATRIX(moCurrent, moPrevious, maskImg, maskPrevious)
	
	return true;
}

bool	DigitizerRunner::Undo(GraphObject& goImage)
{
	_CHECK_GET_IMAGE_PROCESS_MATRIX
	_CHECK_GET_MATRIX_LAYOBJ(moPrevious, 	STR_DIGITIZE_IMG_PROCESS_PREVIOURS_MATRIX)
	_CHECK_GET_MATRIX_LAYOBJ(maskImg, 		STR_DIGITIZE_IMG_PROCESS_MASK_MATRIX)
	_CHECK_GET_MATRIX_LAYOBJ(maskPrevious,  STR_DIGITIZE_IMG_PROCESS_PREV_MASK_MATRIX)
	
	bool bRet = matobj_copy(moCurrent, moPrevious, false, NULL, true, false);
	bRet = matobj_copy(maskImg, maskPrevious, false, NULL, true, false);
	
	UpdateImage(goImage, moCurrent);
	return true;
}
///End SUPPORT_UNDO_FOR_IMAGE_PROCESS

static void _check_recreate_matrix_layer(MatrixPage& mp, LPCSTR lpcsz, MatrixObject& mo)
{
	MatrixLayer ml;
	ml = mp.Layers(lpcsz);
	
	if( ml )
	{
		ml.Destroy();	
	}
	if( !ml )
	{	
		int nLayer = mp.AddLayer(lpcsz);
		ml = mp.Layers(nLayer);	
	}	
	if( ml )
	{
		mo = ml.MatrixObjects();
	}
}

bool 	DigitizerRunner::CheckGetMatrixObject(const MatrixObject& moCurrent, MatrixObject& mo, LPCSTR lpcszName)
{
	if( !moCurrent )
		return false;
	int nRows = moCurrent.GetNumRows(), nCols = moCurrent.GetNumCols();
	int nType = moCurrent.GetInternalDataType();
	
	MatrixLayer ml;
	moCurrent.GetParent(ml);
	MatrixPage mp;
	mp = ml.GetPage();
	
	MatrixLayer mlDest;
	mlDest = mp.Layers(lpcszName);
	if( !mlDest || mlDest && m_pData->bSrcImageUpdateFlag )
	{			
		//if is auto trace image matrix
		if( 0 == lstrcmp(lpcszName, STR_DIGITIZE_IMG_PROCESS_SALIENT_MATRIX)
		|| 0 == lstrcmp(lpcszName, STR_DIGITIZE_IMG_PROCESS_ANGLE_MATRIX)
		|| 0 == lstrcmp(lpcszName, STR_DIGITIZE_IMG_PROCESS_TRACE_MASK_MATRIX)  )
		{	
			MatrixObject moSalient, moAngle, moTrace;
			_check_recreate_matrix_layer(mp, STR_DIGITIZE_IMG_PROCESS_SALIENT_MATRIX, moSalient);
			_check_recreate_matrix_layer(mp, STR_DIGITIZE_IMG_PROCESS_ANGLE_MATRIX, moAngle);
			_check_recreate_matrix_layer(mp, STR_DIGITIZE_IMG_PROCESS_TRACE_MASK_MATRIX, moTrace);	
			mlDest = mp.Layers(lpcszName);
			
			_CHECK_GET_MATRIX_LAYOBJ(moMask, 	STR_DIGITIZE_IMG_PROCESS_MASK_MATRIX)			
			digitizer_curve_detect(moCurrent, moMask, moSalient, moAngle, moTrace);
		}
		else // need to refresh this image matrix according to current image since m_pData->bSrcImageUpdateFlag is true
		{
			if( !mlDest )
			{
				int nLayer = mp.AddLayer(lpcszName);
				mlDest = mp.Layers(nLayer);
			}
			mo = mlDest.MatrixObjects();
			
			if( 0 == lstrcmp(lpcszName, STR_DIGITIZE_IMG_PROCESS_GRAY_MATRIX) )
			{
				_SET_MAT_SIZE(mo, nRows, nCols)
				_SET_MAT_DATA_TYPE(mo, FSI_BYTE)	
				digitizer_convert_to_gray(moCurrent, mo);			
			}
			else if( 0 == lstrcmp(lpcszName, STR_DIGITIZE_IMG_PROCESS_MASK_MATRIX) )
			{
				_SET_MAT_SIZE(mo, nRows, nCols)
				_SET_MAT_DATA_TYPE(mo, FSI_BYTE)				
				_CHECK_GET_MATRIX_LAYOBJ(moGray, 	STR_DIGITIZE_IMG_PROCESS_GRAY_MATRIX)
				digitizer_auto_threshold(moGray, mo);
			}			
		}
	}	
	
	ASSERT(mlDest);
	if( mlDest)
	{
		mo = mlDest.MatrixObjects();			
	}	
	return mo.IsValid();
}

bool 	DigitizerRunner::PrepareMatrixForTraceLine()
{
	/// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
	/*
	_BACKUP_IMAGE_PROCESS_MATRIX(mobjSrcImage, moCurrent, moPrevious, maskImg, maskPrevious)
	
    _CHECK_GET_MATRIX_LAYOBJ(salientImg, 	STR_DIGITIZE_IMG_PROCESS_SALIENT_MATRIX)
    _CHECK_GET_MATRIX_LAYOBJ(angleImg, 		STR_DIGITIZE_IMG_PROCESS_ANGLE_MATRIX)
		
    //detect curve
    float 	sigma = 2.0;
    bool 	bReDetectCurve = true;
    if( bReDetectCurve && digitizer_curve_detect(moCurrent, salientImg, angleImg, maskImg, sigma) < 0)
    {
    	ml.GetPage().Destroy(); 		
    	return error_report("digitizer_curve_detect failed!");
    }
    */
    _CHECK_GET_IMAGE_PROCESS_MATRIX // the above logic should all be put into this define
    ///End IMPROVE_IMAGE_PROCESS_MATRIX
	return true;
}

void 	DigitizerRunner::DestroyTraceLineMatrix()
{
	MatrixObject mobj;
	/// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
	//okxf_resolve_string_get_origin_object(m_pData->strSrcMatrix, &mobj);
	okxf_resolve_string_get_origin_object(m_pData->strImageMatrix, &mobj);
	//End IMPROVE_IMAGE_PROCESS_MATRIX
	if(mobj)
	{
		MatrixLayer ml;
		mobj.GetParent(ml);
		if( ml )
			ml.GetPage().Destroy();
	}
}

/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
bool 	DigitizerRunner::PrepareMatrixForDigitizeArea()
{
	/// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
	/*
	_REFRESH_IMAGE_PROCESS_MATRIX // refresh Current layer with the current image obj

	_CHECK_GET_MATRIX_LAYOBJ(moCurrent, STR_DIGITIZE_IMG_PROCESS_CURRENT_MATRIX);	
	_CHECK_GET_MATRIX_LAYOBJ(maskImg, STR_DIGITIZE_IMG_PROCESS_MASK_MATRIX);	
	_CHECK_GET_MATRIX_LAYOBJ(grayImage, STR_DIGITIZE_IMG_PROCESS_GRAY_MATRIX);	
	
	// before do digitize area, need prepare a gray image and do clean background on it.	
	int nRows = moCurrent.GetNumRows();
	int nCols = moCurrent.GetNumCols();	
	_SET_MAT_SIZE(grayImage, nRows, nCols)
	_SET_MAT_DATA_TYPE(grayImage, FSI_BYTE);	
	
	bool bRGB = moCurrent.GetInternalData() == FSI_BYTE ? false : true; 
	
	CvMat matSrc, matGray;
	matSrc = cvMat(nRows, nCols, bRGB ? CV_8UC4 : CV_8UC1, moCurrent.GetDataObject());
	matGray = cvMat(nRows, nCols, CV_8UC1, grayImage.GetDataObject());
	if(bRGB)
		cvCvtColor(&matSrc, &matGray, CV_RGBA2GRAY);
	else
		cvCopy(&matSrc, &matGray);

	if(digitizer_clean_background(grayImage, grayImage, maskImg) < 0)
		return error_report("digitizer_clean_background fail");
	
	return grayImage.IsValid();
	*/
	_CHECK_GET_IMAGE_PROCESS_MATRIX // prepare the image matrix
	return true;
	///End IMPROVE_IMAGE_PROCESS_MATRIX
}

void	DigitizerRunner::DestroyDigitizeAreaMatrix()
{
	DestroyTraceLineMatrix();
}
///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE

int		DigitizerRunner::RunTraceLine(Dialog& dlg)
{
	LocatePoints	pts(dlg);
	vector			vx, vy;
	vx = m_pData->PtsScrX;
	vy = m_pData->PtsScrY;
	return pts.GetTraceLine(vx, vy);
}

/// Iris 9/03/2012 ORG-5112-P5 TO_FIND_GOOD_START_POINT_FOR_AUTO_TRACE_LINE
bool 	DigitizerRunner::BeforeAutoTraceLine(double& x, double& y)
{
	_CHECK_GET_IMAGE_PROCESS_MATRIX
	_CHECK_GET_MATRIX_LAYOBJ(moMask, 		STR_DIGITIZE_IMG_PROCESS_TRACE_MASK_MATRIX)	
			
	int xx = x, yy = y;	
	int nRet = digitizer_find_trace_start(moMask, xx, yy, 3);
	string strResult;
	switch(nRet)
	{
	case 0:
		strResult = "Not found";
		break;
	case 1:
		strResult = "Found";
		break;
	default:
		strResult = "Error, nRet = " + nRet;
		break;
	}
	
	string strTest;
	strTest.Format("%s, dTraceX = %d, dTraceY = %d", strResult, xx, yy);
	SetStatusBarText(strTest);
	return true;
}
///End TO_FIND_GOOD_START_POINT_FOR_AUTO_TRACE_LINE

bool 	DigitizerRunner::AutoTraceLine(double& x, double& y, vector& vx, vector& vy)
{	
	int nCtrCol0, nCtrRow0;
	MatrixObject mobj;
	/// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
	//okxf_resolve_string_get_origin_object(m_pData->strSrcMatrix, &mobj);
	okxf_resolve_string_get_origin_object(m_pData->strImageMatrix, &mobj);
	////End IMPROVE_IMAGE_PROCESS_MATRIX
	if( !mobj || !convertXYToColRow(mobj, x, y, nCtrCol0, nCtrRow0) )
		return false;
	
	MatrixLayer ml;
	mobj.GetParent(ml);	
	MatrixPage mp = ml.GetPage();	
	
	_CHECK_GET_IMAGE_PROCESS_MATRIX /// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
	
    _CHECK_GET_MATRIX_LAYOBJ(salientImg, 	STR_DIGITIZE_IMG_PROCESS_SALIENT_MATRIX)
    /// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
    //_CHECK_GET_MATRIX_LAYOBJ(maskImg, 		STR_DIGITIZE_IMG_PROCESS_MASK_MATRIX)
    _CHECK_GET_MATRIX_LAYOBJ(maskImg, 		STR_DIGITIZE_IMG_PROCESS_TRACE_MASK_MATRIX)
    ///End IMPROVE_IMAGE_PROCESS_MATRIX
    _CHECK_GET_MATRIX_LAYOBJ(angleImg, 		STR_DIGITIZE_IMG_PROCESS_ANGLE_MATRIX)    
	
	vector<int> vX, vY;
    if( digitizer_curve_trace(salientImg, angleImg, maskImg, nCtrCol0, nCtrRow0, vX, vY) < 0)
    {
    	return error_report("digitizer_curve_trace failed!");
    }  
    
    
	double dXMin, dYMin, dXMax, dYMax;	
	mobj.GetXY(dXMin, dYMin, dXMax, dYMax);	
	
	double dXStep = (double)(dXMax - dXMin) / (double)(mobj.GetNumCols() - 1);
	double dYStep = (double)(dYMax - dYMin) / (double)(mobj.GetNumRows() - 1);
	
	vx = dXMin + vX * dXStep;
	vy = dYMin + vY * dYStep;	
    
    return true;
}

/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
//BOOL	DigitizerRunner::DigitizeArea(vector& vx, vector& vy)
BOOL	DigitizerRunner::DigitizeArea(double x, double y, double width, double height, int angle, int step, vector& vx, vector& vy)
///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
{
	if( width <= 0 || height <= 0 )
		return false;
	
	/// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
	/*
	//_BACKUP_IMAGE_PROCESS_MATRIX(mobjSrcImage, moCurrent, moPrevious, maskImg, maskPrevious)	
	_GET_IMAGE_PROCESS_MATRIX
	_CHECK_GET_MATRIX_LAYOBJ(moCurrent,		STR_DIGITIZE_IMG_PROCESS_CURRENT_MATRIX)
	*/
	_CHECK_GET_IMAGE_PROCESS_MATRIX	
	///End IMPROVE_IMAGE_PROCESS_MATRIX
	_CHECK_GET_MATRIX_LAYOBJ(maskImg, 		STR_DIGITIZE_IMG_PROCESS_MASK_MATRIX)
	
    DigitizeAreaSettings dasSettings;
    /// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
    /*
    dasSettings.x = 200;
    dasSettings.y = 100;
    dasSettings.width = 100;
    dasSettings.height = 50;
    dasSettings.step = 10;
    dasSettings.theta = 10/180.0*pi;
    */
    dasSettings.x = x;
    dasSettings.y = y;     
    dasSettings.width = width;
    dasSettings.height = height;
    dasSettings.step = step;        
    dasSettings.theta = angle/180.0*pi;
    ///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
    dasSettings.minlen = 1;
    dasSettings.maxgap = 10;
    vector<int> vX, vY;
    if(digitizer_digitize_area(maskImg, dasSettings, vX, vY) < 0)    
    	return error_report("digitizer_digitize_area fail");  
    
    double dXMin, dYMin, dXMax, dYMax;
	moCurrent.GetXY(dXMin, dYMin, dXMax, dYMax);
	
	double dXStep = (double)(dXMax - dXMin) / (double)(moCurrent.GetNumCols() - 1);
	double dYStep = (double)(dYMax - dYMin) / (double)(moCurrent.GetNumRows() - 1);
	
	vx = dXMin + vX * dXStep;
	vy = dYMin + vY * dYStep;	
 
    return true;
}

BOOL	DigitizerRunner::ClearBackground(GraphObject& goImage)
{
	/// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
	/*
	_BACKUP_IMAGE_PROCESS_MATRIX(mobjSrcImage, moCurrent, moPrevious, maskImg, maskPrevious)	
	
	moCurrent.SetInternalDataType(FSI_ULONG);
	if(digitizer_clean_background(moPrevious, moCurrent, maskImg) < 0)	
		return error_report("digitizer_clean_background fail");
	*/
	_CHECK_GET_IMAGE_PROCESS_MATRIX	
	_BACKUP_IMAGE_PROCESS_MATRIX(moCurrent, moPrevious, maskImg, maskPrevious)	
	_CHECK_GET_MATRIX_LAYOBJ(moGray, STR_DIGITIZE_IMG_PROCESS_GRAY_MATRIX)
	
	if(	digitizer_clean_background(moCurrent, maskImg) < 0 ||
    	digitizer_clean_background(moGray, maskImg) < 0 )    
    {
    	return error_report("digitizer_clean_background fail");
    }
	///End IMPROVE_IMAGE_PROCESS_MATRIX
	
	UpdateImage(goImage, moCurrent);
	return true;
}

BOOL	DigitizerRunner::RemoveGridLine(GraphObject& goImage)
{
	/// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
	//_BACKUP_IMAGE_PROCESS_MATRIX(mobjSrcImage, moCurrent, moPrevious, maskImg, maskPrevious)
	_CHECK_GET_IMAGE_PROCESS_MATRIX
	_BACKUP_IMAGE_PROCESS_MATRIX(moCurrent, moPrevious, maskImg, maskPrevious)
	///End IMPROVE_IMAGE_PROCESS_MATRIX
	
	vector vv;
	matrix<byte>& mat = maskPrevious.GetDataObject();	
	mat.GetAsVector(vv, true);
	
	double dSum = 0;
	vv.Sum(dSum);
	if( is_equal(0.0, dSum) )
	{
		mat = 1;
	}
	
	moCurrent.SetInternalDataType(FSI_ULONG);
	if(digitizer_remove_gridlines(moPrevious, maskPrevious, moCurrent, maskImg) < 0)
		return error_report("digitizer_remove_gridlines fail");

	UpdateImage(goImage, moCurrent);
	return true;
}

bool	DigitizerRunner::UpdateImage(GraphObject& goImage, const MatrixObject& mobj)
{
	/// Iris 2/01/2012 ORG-4794-S4 IMPROVE_IMAGE_PROCESS_MATRIX
	/*
	matrixbase& mat = mobj.GetDataObject();
	
	MatrixLayer ml;
	mobj.GetParent(ml);	
	MatrixPage mp = ml.GetPage();	
	_CHECK_GET_MATRIX_LAYOBJ(moDIB, STR_DIGITIZE_IMG_PROCESS_DIB_MATRIX)	
	
	if(moDIB.SetInternalDataType(FSI_BYTE, OCD_RESET_VIEW))
	{
		int nRet = image_convert_from_data(mobj, moDIB, mat.GetMin(), mat.GetMax(), 8);
	
		Image img(moDIB);
		BITMAPHANDLE* pLBmp = img.GetLBmp();
		HDIB hDIB = L_ConvertToDIB(pLBmp, DIB_BITMAPINFOHEADER);
		goImage.SetDIBHandle(hDIB);
		
		return true;
	}	
	
	return false;
	*/	
	///Rex 2012/4/13 ORG-5112 FIX_UPDATE_IMAGE_TO_GRAPHOBJECT
	/*
	BITMAPHANDLE* pLBmp = (pBITMAPHANDLE)mobj.GetLeadBitmap();
	if( NULL != pLBmp )
	{
		HDIB hDIB = L_ConvertToDIB(pLBmp, DIB_BITMAPINFOHEADER);
		goImage.SetDIBHandle(hDIB);		
		return true;
	}
	*/
	HDIB hDIB = digitizer_convert2DIB(mobj);
	if (hDIB)
	{
		bool bRet = goImage.SetDIBHandle(hDIB);
		GlobalFree(hDIB);
		return bRet;
	}
	///End FIX_UPDATE_IMAGE_TO_GRAPHOBJECT
	return false;
	///End IMPROVE_IMAGE_PROCESS_MATRIX
}
//End DIGITIZER_AUTO_TRACE_LINE
bool 	DigitizerRunner::OptimizePoint(double& x,  double& y)
{		
	int nCtrCol0, nCtrRow0;
	MatrixObject mobj;
	okxf_resolve_string_get_origin_object(m_pData->strImageMatrixObj, &mobj);
	if( !mobj || !convertXYToColRow(mobj, x, y, nCtrCol0, nCtrRow0) )
		return false;
	
    MatrixLayer ml;
    mobj.GetParent(ml);
    Matrix MatSource( ml, mobj.GetIndex() );
    int nCol, nRow;
    FUNC_MATRIX_FIND_PEAK_CENTER pfn = Project.FindFunction("matrix_find_peak_center", "Originlab\\nlsf_utils.c", TRUE);
	if(!pfn)
		return false;		
	if( 0 != pfn(MatSource, nCtrRow0, nCtrCol0, nRow, nCol) )
		return false;
	x = MatSource.GetXValue(nCol);
	y = MatSource.GetYValue(nRow);
	
	return true;
}
///End OPTIMIZE_PICKED_POINT
//private:
BOOL	DigitizerRunner::Calculate(vector& vx, vector& vy, BOOL bReverse/* = FALSE*/)
{
	DigitizerCoordinates&		x1 = m_pData->x1;
	DigitizerCoordinates&		x2 = m_pData->x2;
	DigitizerCoordinates&		y1 = m_pData->y1;
	DigitizerCoordinates&		y2 = m_pData->y2;

	double		aa, bb;
	if ( LINEAR_SPACE == m_pData->axisX.nScaleType )
	{
		aa = (x1.value - x2.value) / (x1.nx - x2.nx);
		bb = x1.value - aa * x1.nx;
		if ( bReverse )
		{
			if ( aa != 0 )
				vx = (vx - bb) / aa;
		}
		else
		{
			vx = aa * vx + bb;
		}
	}
	else if ( LOG10_SPACE == m_pData->axisX.nScaleType )
	{
		aa = (log10(x1.value) - log10(x2.value)) / (x1.nx - x2.nx);
		bb = log10(x1.value) - aa * x1.nx;
		if ( bReverse )
		{
			if ( aa != 0 )
				vx = (log10(vx) - bb) / aa;
		}
		else
		{
			vx = 10 ^ (aa * vx + bb);
		}
	}

	if ( LINEAR_SPACE == m_pData->axisY.nScaleType )
	{
		aa = (y1.value - y2.value) / (y1.ny - y2.ny);
		bb = y1.value - aa * y1.ny;
		if ( bReverse )
		{
			if ( aa != 0 )
				vy = (vy - bb) / aa;
		}
		else
		{
			vy = aa * vy + bb;
		}
	}
	else if ( LOG10_SPACE == m_pData->axisY.nScaleType )
	{
		aa = (log10(y1.value) - log10(y2.value)) / (y1.ny - y2.ny);
		bb = log10(y1.value) - aa * y1.ny;
		if ( bReverse )
		{
			if ( aa != 0 )
				vy = (log10(vy) - bb) / aa;
		}
		else
		{
			vy = 10 ^ (aa * vy + bb);
		}
	}

	return TRUE;
}

///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT		
bool 	DigitizerRunner::convertXYToColRow(const MatrixObject& mobj, double x, double y, int& nCol, int& nRow)
{
	double dXMin, dYMin, dXMax, dYMax;
	mobj.GetXY(dXMin, dYMin, dXMax, dYMax);
	vector vX, vY;
	vX.Data(dXMin, dXMax, (dXMax - dXMin)/(mobj.GetNumCols() - 1));
	vY.Data(dYMin, dYMax, (dYMax - dYMin)/(mobj.GetNumRows() - 1));
	vector<uint> vnX, vnY;
	if(	0 >= vX.Find(MATREPL_TEST_EQUAL|MATREPL_TEST_GREATER, x, vnX) ||
		0 >= vY.Find(MATREPL_TEST_EQUAL|MATREPL_TEST_GREATER, y, vnY) )
	{
		return error_report("x\y is out of range");
	}	
	
	nRow = vnY[0];
	nCol = vnX[0];
	return true;
}
///End OPTIMIZE_PICKED_POINT

/*------------------------------------------------------------------------------*
* DigitizerRunner End		 													*
*------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* DigitizerDataDumpingHelper 													*
*------------------------------------------------------------------------------*/
//public:
DigitizerDataDumpingHelper::DigitizerDataDumpingHelper(DigitizerImplData& data, HWND hWnd)
{
	m_pData = &data;
	m_hWnd = hWnd;
}
DigitizerDataDumpingHelper::~DigitizerDataDumpingHelper()
{
}

BOOL	DigitizerDataDumpingHelper::Dump(BOOL bPlot/* = FALSE*/)
{
	return PrepareAll() && DumpImpl(bPlot);
}

BOOL	DigitizerDataDumpingHelper::Go()
{
	return PrepareAll() && m_wks.CheckShowActivate();
}

BOOL	DigitizerDataDumpingHelper::GoToGraph()
{
	if ( !PrepareAll(FALSE) )
		return FALSE;

	GraphLayer		gl = GetDigitizerPlotLayer(PlotRange(), FALSE);
	if ( !gl )
		return FALSE;
	return gl.CheckShowActivate();
}

BOOL	DigitizerDataDumpingHelper::Clear()
{
	if ( !PrepareAll(FALSE) )
		return FALSE;

	GraphLayer		gl = GetDigitizerPlotLayer(PlotRange(), FALSE);
	if ( gl )
		gl.Destroy();
	
	return m_wks.Destroy();
}

///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
BOOL	DigitizerDataDumpingHelper::CheckUpdateDataFromOutput(DatasetObject& dsObj)
{
	if ( !PrepareAll(FALSE) )
		return FALSE;

	if ( !IsOutput(dsObj) )
		return FALSE;

	ERR_MSG(dsObj.GetName());
	m_pData->PtsX = m_colX.GetDataObject();
	m_pData->PtsY = m_colY.GetDataObject();
	m_colLabel.GetStringArray(m_pData->PtsLabel);
	return TRUE;
}
///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
//BOOL 	DigitizerDataDumpingHelper::DeletePoint(int nIndex)
BOOL 	DigitizerDataDumpingHelper::DeletePoints(const vector<uint>& vnIndices)
///End IMPROVE_DELETE_POINTS
{
	string	strBook, strSheet, strCol;
	/// Iris 2/20/2012 FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
	//if( ParseRange(strBook, strSheet, strCol) && PrepareWorksheet(strBook, strSheet, false) )
	if( UpdateActiveData() )
	///End FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
	{
		/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
		//return m_wks.DeleteRow(nIndex);
		/// Iris 2/20/2012 FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
		//return (m_wks.DeleteRows(vnIndices) >= 0 );
		vector<int> vn;
		vn = vnIndices;
		vector& vx = m_colX.GetDataObject();
		vector& vy = m_colY.GetDataObject();
		StringArray saLabels;
		m_colLabel.GetStringArray(saLabels);
		
		vx.RemoveAt(vn);
		vy.RemoveAt(vn);
		saLabels.RemoveAt(vn);
		m_colLabel.PutStringArray(saLabels);
		///End FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
		///End IMPROVE_DELETE_POINTS
	}
	return FALSE;
}

BOOL	DigitizerDataDumpingHelper::ReorderPoints()
{
	/// Iris 2/20/2012 FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
	//return PrepareAll(FALSE) && m_wks.Sort(m_colX.GetIndex());	
	return UpdateActiveData() && ReorderCurrentLine();
	///End FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
}

BOOL	DigitizerDataDumpingHelper::UpdateActiveData()
{
	string strBook, strSheet, strCol;
	okutil_parse_complete_range_string(GetDataName(), &strBook, &strSheet, &strCol);
	PrepareWorksheet(strBook, strSheet, false);
	if( !m_wks )
		return error_report("SetActiveData in DataDumpHelper class fail to get Worksheet");
	
	GetYColumn(strCol);
	if( !m_colY )
		return error_report("SetActiveData in DataDumpHelper class fail to get Y col");
	
	m_colX.Attach(m_wks, m_colY.GetIndex() - 1);
	m_colLabel.Attach(m_wks, m_colY.GetIndex() + 1);
	
	return m_colX.IsValid() && m_colLabel.IsValid();
}

/// Iris 2/20/2012 FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
BOOL	DigitizerDataDumpingHelper::ReorderCurrentLine()
{
	vector& vx = m_colX.GetDataObject();
	vector& vy = m_colY.GetDataObject();
	StringArray saLabels;
	m_colLabel.GetStringArray(saLabels);
	
	vector<uint> vnIndeces;
	vx.Sort(SORT_ASCENDING, TRUE, vnIndeces);
	vy.Reorder(vnIndeces);
	saLabels.Reorder(vnIndeces);
	m_colLabel.PutStringArray(saLabels);
	
	return TRUE;
}
///End FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
	
//private:
BOOL	DigitizerDataDumpingHelper::PrepareAll(BOOL bCreate/* = TRUE*/)
{
	string	strBook, strSheet, strCol;
	return ParseRange(strBook, strSheet, strCol) && PrepareWorksheet(strBook, strSheet, bCreate) && PrepareColumns(strCol);
}

BOOL	DigitizerDataDumpingHelper::ParseRange(string& strBook, string& strSheet, string& strCol)
{
	return okutil_parse_complete_range_string(GetDataName(), &strBook, &strSheet, &strCol)
		&& !strBook.IsEmpty() 
		&& !strSheet.IsEmpty() 
		&& !strCol.IsEmpty();
}

BOOL	DigitizerDataDumpingHelper::PrepareWorksheet(LPCSTR lpcszBook, LPCSTR lpcszSheet, BOOL bCreate/* = TRUE*/)
{
	if ( !bCreate )
		return m_wks.Attach(okutil_make_book_sheet_string(lpcszBook, lpcszSheet));
	
	BOOL	bIsNewCreated = FALSE;
	attach_or_create_sheet(m_wks, okutil_make_book_sheet_string(lpcszBook, lpcszSheet), GetPageCreateOptions(), false, &bIsNewCreated);
	if ( m_wks && bIsNewCreated )
	{
		m_wks.SetSize(-1, 0);
		UpdateDataNameByNewSheetName(m_wks.GetName());		//Tony 8/29/2012 In case too long image name
	}
	return m_wks.IsValid();
}

BOOL	DigitizerDataDumpingHelper::PrepareColumns(LPCSTR lpcszCol)
{
	///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
	//m_colY = m_wks.FindCol(lpcszCol);
	GetYColumn(lpcszCol);
	///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID

	if ( m_colY )
	{
		///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
		string		strLongName = m_colY.GetLongName();
		if ( strLongName.Compare(lpcszCol) != 0 )
		{
			m_pData->SetDataName(m_wks.m_strBookSheet, strLongName);
		}
		///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID

		int		nXIndex = m_wks.FindColIndex(m_colY.GetIndex(), OKDATAOBJ_DESIGNATION_X, FCI_DEPENDENT);
		if ( nXIndex >= 0 )
		{
			m_colX = m_wks.Columns(nXIndex);
		}
		else
		{
			string	strX;
			m_wks.InsertCol(m_colY.GetIndex(), NULL, strX);
			m_colX = m_wks.Columns(strX);
		}
	}
	else
	{
		m_colX = m_wks.Columns(m_wks.AddCol());
		m_colX.SetType(OKDATAOBJ_DESIGNATION_X);
		m_colY = m_wks.Columns(m_wks.AddCol());
		m_colY.SetLongName(lpcszCol);
	}
	///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
	m_pData->SetDataUID(m_colY.GetUID(TRUE));
	///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID

	if ( m_hWnd )
	{
		Window	wnd(m_hWnd);
		wnd.SendMessage(ID_DIGITIZER_MSG_SAVE_SETTINGS);
	}

	///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	GetLabelColumn();
	///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH

	PrepareColumnFormat(m_colX, &m_pData->axisX);
	PrepareColumnFormat(m_colY, &m_pData->axisY);
	return m_colX && m_colY;
}

void	DigitizerDataDumpingHelper::PrepareColumnFormat(Column& col, DigitizerAxisData* pAxisData)
{
	if ( OKCOLTYPE_NUMERIC != pAxisData->nFormat )
	{
		col.SetFormat(pAxisData->nFormat, pAxisData->nSubFormat);
		if ( OKCOLTYPE_DATE == pAxisData->nFormat && LDF_OBJ_CUSTOM == pAxisData->nSubFormat || OKCOLTYPE_TIME == pAxisData->nFormat && LTF_OBJ_CUSTOM == pAxisData->nSubFormat )
			col.SetCustomDisplay(pAxisData->strCustomDisplay);
	}
}

#define			STR_LINEAR_SCALE		_L("Linear Scale")
#define			STR_LOG10_SCALE			_L("Log10 Scale")
BOOL	DigitizerDataDumpingHelper::DumpImpl(BOOL bPlot)
{
	ERR_MSG("DigitizerDataDumpingHelper::DumpImpl");
	if ( !m_colX || !m_colY )
		return FALSE;

	string	strLinear = STR_LINEAR_SCALE;
	string	strLog10 = STR_LOG10_SCALE;

	int		nLabel = CheckGetLabelRow();
	m_colX.SetExtendedLabel(LINEAR_SPACE == m_pData->axisX.nScaleType ? strLinear : strLog10, nLabel);
	m_colY.SetExtendedLabel(LINEAR_SPACE == m_pData->axisY.nScaleType ? strLinear : strLog10, nLabel);

	vectorbase&	vx = m_colX.GetDataObject();
	vectorbase&	vy = m_colY.GetDataObject();
	vx = m_pData->PtsX;
	vy = m_pData->PtsY;
	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	m_colLabel.SetUpperBound(-1);
	m_colLabel.PutStringArray(m_pData->PtsLabel);
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	return bPlot ? MakePlot() : TRUE;
}

int		DigitizerDataDumpingHelper::CheckGetLabelRow()
{
	return check_get_user_defined_label(m_wks, _L("Scale Type"));
}

BOOL	DigitizerDataDumpingHelper::MakePlot()
{
	XYRange			xy = PlotRange();
	GraphLayer		gl = GetDigitizerPlotLayer(xy);
	/// Iris 7/25/2012 ORG-6310 SET_DATA_PLOT_WITH_DIFFERENT_COLOR
	//return plot_xyr_to_graph(xy, gl, IDM_PLOT_LINESYMB) && UpdateLayerScaleType(gl) && UpdateLabels() && Rescale(gl);
	DataPlot dp;
	if( !plot_xyr_to_graph(xy, gl, IDM_PLOT_LINESYMB, SYSCOLOR_BLACK, dp) )
		return FALSE;		
	// there are data plots for each picked points, one is picked data, another is the lable plot
	dp.SetColor( SYSCOLOR_RED + ( dp.GetIndex() / 2 ) ); 
	
	return UpdateLayerScaleType(gl) && UpdateLabels() && Rescale(gl);		
	///End SET_DATA_PLOT_WITH_DIFFERENT_COLOR
}

XYRange	DigitizerDataDumpingHelper::PlotRange()
{
	XYRange	xy;
	xy.Add(m_wks, m_colX.GetIndex(), "X");
	xy.Add(m_wks, m_colY.GetIndex(), "Y");
	///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	xy.Add(m_wks, m_colLabel.GetIndex(), "L");
	///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	xy.Add("S", NULL);
	return xy;
}

#define		STR_SOURCE_IMAGE			"sourceimage"
#define		STR_DIGITIZER_PLOT_PAGE		STR_DIGITIZER_DATA_PLOT_NAME
#define		STR_DIGITIZER_PLOT_PAGE_LN	STR_SOURCE_IMAGE " : %s"
GraphLayer	DigitizerDataDumpingHelper::GetDigitizerPlotLayer(XYRange& xy, BOOL bCreate/* = TRUE*/)
{
	string		strLongName;
	strLongName.Format(STR_DIGITIZER_PLOT_PAGE_LN, m_pData->strImageName);
	foreach ( PageBase pg in Project.Pages )
	{
		GraphPage	gp(pg);
		if ( !gp )
			continue;

		if ( gp.GetName().Find(STR_DIGITIZER_PLOT_PAGE) == 0 )
		{
			if ( strLongName.Compare(gp.GetLongName()) == 0 )
				return gp.Layers();
		}
	}
	if ( !bCreate )
	{
		GraphLayer	glDummy;
		return glDummy;
	}
	
	GraphPage		gp;
	gp.Create("Origin", GetPageCreateOptions());
	gp.SetName(STR_DIGITIZER_PLOT_PAGE, OCD_ENUM_NEXT);
	///------ Folger 02/22/2011 ORG-2309-P1 NEVER_RENAME_PAGE_SHORT_NAME_BY_LONG_NAME_IN_DIGITIZER
	//gp.SetLongName(strLongName);
	gp.SetLongName(strLongName, FALSE);
	///------ End NEVER_RENAME_PAGE_SHORT_NAME_BY_LONG_NAME_IN_DIGITIZER
	return gp.Layers();
}

BOOL	DigitizerDataDumpingHelper::UpdateLayerScaleType(GraphLayer& gl)
{
	LT_execute("sec -p 0.05");
	
	string		strScaleType;
	strScaleType.Format("layer.X.Type=%d;layer.Y.Type=%d;", m_pData->axisX.nScaleType + 1, m_pData->axisY.nScaleType + 1);
	return gl.LT_execute(strScaleType);
}

//Tony 8/29/2012 In case too long image name
BOOL	DigitizerDataDumpingHelper::UpdateDataNameByNewSheetName(string &strNewSheetName)
{
	return m_pData->UpdateDataNameByNewSheetName(strNewSheetName);
}
//end

///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
BOOL	DigitizerDataDumpingHelper::UpdateLabels()
{
	GraphLayer		gl = GetDigitizerPlotLayer(PlotRange(), FALSE);
	if ( gl )
	{
		string		strScript;
		strScript.Format("set %s -tx 50;", m_colLabel.GetDatasetName());
		gl.LT_execute(strScript);
	}
	return TRUE;
}
///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH

BOOL	DigitizerDataDumpingHelper::Rescale(GraphLayer& gl)
{
	BOOL	bReturn = gl.Rescale();
	if ( !bReturn )
		return FALSE;

	double	rTemp;
	if ( m_pData->x1.value > m_pData->x2.value && gl.X.From < gl.X.To )
	{
		SWAP(gl.X.From, gl.X.To, rTemp);
	}
	if ( m_pData->y1.value > m_pData->y2.value && gl.Y.From < gl.Y.To )
	{
		SWAP(gl.Y.From, gl.Y.To, rTemp);
	}
	return bReturn;
}

string		DigitizerDataDumpingHelper::GetDataName()
{
	return m_pData->GetDataName();
}

DWORD		DigitizerDataDumpingHelper::GetPageCreateOptions()
{
	/// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED
	//return CREATE_NACTIVE | CREATE_LOAD_1ST_LAYER_ONLY;
	return CREATE_LOAD_1ST_LAYER_ONLY | CREATE_HIDDEN;
	///eND IMPROVE_DIGITIZER_AREA_SPEED
}

///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
void		DigitizerDataDumpingHelper::GetLabelColumn()
{
	int		nLabelcolIndex = m_colY.GetIndex() + 1;
	if ( !m_colLabel.Attach(m_wks, nLabelcolIndex) || !m_colLabel || OKDATAOBJ_DESIGNATION_L != m_colLabel.GetType() )
	{
		string		strName;
		m_wks.InsertCol(nLabelcolIndex, NULL, strName);
		m_colLabel.Attach(m_wks, nLabelcolIndex);
		m_colLabel.SetType(OKDATAOBJ_DESIGNATION_L);
	}
}
///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH

///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
void		DigitizerDataDumpingHelper::GetYColumn(LPCSTR lpcszCol)
{
	m_colY = m_wks.FindCol(lpcszCol);
	if ( m_colY )
		return;

	m_colY = Project.GetObject(m_pData->GetDataUID());
	if ( !m_colY )
		return;

	Worksheet	wks;
	m_colY.GetParent(wks);
	if ( !is_same_layer(wks, m_wks) )
	{
		Column	colJunk;
		m_colY = colJunk;
	}
}
///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID

///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
BOOL	DigitizerDataDumpingHelper::IsOutput(DatasetObject& dsObj)
{
	if ( !PrepareAll(FALSE) )
		return FALSE;
	
	string		str = dsObj.GetName();
	if ( m_colX.GetDatasetName().CompareNoCase(str) == 0 )
		return TRUE;
	
	if ( m_colY.GetDatasetName().CompareNoCase(str) == 0 )
		return TRUE;
	
	if ( m_colLabel.GetDatasetName().CompareNoCase(str) == 0 )
		return TRUE;
	
	return FALSE;
}
///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

/*------------------------------------------------------------------------------*
* DigitizerDataDumpingHelper End												*
*------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* DigitizerPickPointHelper														*
*------------------------------------------------------------------------------*/
#define		STR_SETTINGS_STORAGE_BACKUP		STR_IMAGE_NAME "Backup"

//public:
DigitizerPickPointHelper::DigitizerPickPointHelper(DigitizerImplData& data)
{
	m_pData = &data;
	m_glOriginal = Project.ActiveLayer();
}
DigitizerPickPointHelper::~DigitizerPickPointHelper()
{
}

BOOL	DigitizerPickPointHelper::IsDataBackup(TreeNode* ptrSettings/* = NULL*/)
{
	Tree	tr;
	BOOL	bReturn = m_glOriginal.GetBinaryStorage(STR_SETTINGS_STORAGE_BACKUP, tr);
	if ( ptrSettings )
		*ptrSettings = tr;
	return bReturn;
}

BOOL	DigitizerPickPointHelper::HasPickedPoint()
{
	Tree	tr;
	if ( !IsDataBackup(&tr) )
		return FALSE;

	DigitizerImplData	data;
	data = tr;
	return data.Size() != m_pData->Size();
}

BOOL	DigitizerPickPointHelper::CheckRestore()
{
	Tree	tr;
	if ( !IsDataBackup(&tr) )
		return FALSE;

	*m_pData = tr;
	return ClearBackup();
}

BOOL	DigitizerPickPointHelper::ClearBackup()
{
	return m_glOriginal.SetMemory(STR_SETTINGS_STORAGE_BACKUP, NULL);
}

BOOL	DigitizerPickPointHelper::CheckBackupData()
{
	Layer	lay = Project.ActiveLayer();
	if ( is_same_layer(m_glOriginal, lay) )
	{
		CheckRestore();
		return FALSE;
	}

	if ( IsDataBackup() )
		return TRUE;

	Tree	tr;
	tr = *m_pData;
	return m_glOriginal.PutBinaryStorage(STR_SETTINGS_STORAGE_BACKUP, tr);
}

/*------------------------------------------------------------------------------*
* DigitizerPickPointHelper End													*
*------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------*
* PreviewDataPlot																*
*------------------------------------------------------------------------------*/
PreviewDataPlot::PreviewDataPlot() 
{
	m_gl = Project.ActiveLayer();
	m_nColor = -1;
}	
	
bool PreviewDataPlot::Plot(const vector& vx, const vector& vy)
{			
	Tree tr;
	tr.Root.Data.X.dVals = vx;
	tr.Root.Data.Y.dVals = vy;
	return applyFormat(tr);		
}
	
bool PreviewDataPlot::SetColor(int nColor)
{	
	if( nColor != m_nColor )	
	{
		Tree	tr;
		tr.Root.Color.nVal = tr.Root.Symbol.EdgeColor.nVal = nColor;
		tr.Root.Symbol.FillColor.nVal = nColor;
		m_nColor = nColor;
		return applyFormat(tr);
	}
	return true;	
}
	

bool PreviewDataPlot::checkGetPlotObj(GraphObject& grPlot)
{
	ASSERT(m_gl);
	if( m_gl )
	{
		grPlot = m_gl.GraphObjects(STR_PREVIEW_PLOT_NAME);
		if( !grPlot )
		{
			grPlot = m_gl.CreateGraphObject(GROBJ_TN_MARKER, STR_PREVIEW_PLOT_NAME);	
			grPlot.Attach = ATTACH_TO_SCALE;
			SetColor(SYSCOLOR_ORANGE);
		}
		return grPlot.IsValid();
	}
	return false;
}	

bool PreviewDataPlot::applyFormat(Tree& tr)
{
	GraphObject grPlot;
	if( !checkGetPlotObj(grPlot) )
		return false;
	
	if( 0 == grPlot.UpdateThemeIDs(tr.Root) )
	{
		bool bRet = grPlot.ApplyFormat(tr, true, true);
		ASSERT(bRet);
		
		if( bRet )
		{
			GraphPage gp;
			gp = m_gl.GetPage();
			gp.Refresh(TRUE);
		}
		return bRet;
	}		
	return false;
}
/*------------------------------------------------------------------------------*
* PreviewDataPlot End															*
*------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* DigitizerImpl																	*
*------------------------------------------------------------------------------*/
static bool _update_color(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	GetNOptionEventHelper	eventHelper(dwCntrl);
	if ( !eventHelper.IsInit() )
	{
		theDlg.PostMessage(WM_COMMAND, MAKELONG(IDOK, BN_CLICKED));
	}	
	return true;
}

#define		STR_DLG_NAME		"Digitizer"
#define		STR_DLG_NAME_L		_L("Digitizer")
#define		STR_DUMP_DATA_NAME	"DumpData"

//class	Digitizer;
static Digitizer*	g_pDigitizer = NULL;

//class DigitizerImpl
//public:
DigitizerImpl::DigitizerImpl()
{
	m_hWnd = NULL;
	//m_bDigitizing = FALSE; // Iris: this member seems repeat since m_data.bDigitizing also save this status, so commented out.

	m_pVisualizer = NULL;
	m_pImage = NULL;
	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	//m_pRotate = NULL;
	///End FIX_ROTATE_GETN_DLG_ISSUE
	m_pOptions = NULL;
	m_pRunner = NULL;
	m_pDumping = NULL;
}
DigitizerImpl::~DigitizerImpl()
{
	NICE_SAFE_REMOVAL(m_pVisualizer);
	NICE_SAFE_REMOVAL(m_pImage);
	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	//NICE_SAFE_REMOVAL(m_pRotate);
	///End FIX_ROTATE_GETN_DLG_ISSUE
	NICE_SAFE_REMOVAL(m_pOptions);
	NICE_SAFE_REMOVAL(m_pRunner);
	NICE_SAFE_REMOVAL(m_pDumping);
}

void	DigitizerImpl::SetHwnd(HWND hWnd)
{
	m_hWnd = hWnd;
}

HWND	DigitizerImpl::GetHwnd()
{
	return m_hWnd;
}

BOOL	DigitizerImpl::Save()
{
	if ( !HasValidDigitizeImage() )
		return FALSE;

	return SaveSettings();
}

BOOL	DigitizerImpl::Load()
{
	if ( !HasValidDigitizeImage() )
		return FALSE;

	return LoadSettings();
}

GraphLayer	DigitizerImpl::GetDigitizeLayer()
{
	return m_objsHolder.GetDigitizeLayer();
}

BOOL	DigitizerImpl::IsCoorReady(IMPLDATA type)
{
	switch ( type )
	{
	case IMPLDATA_X1:
		return m_data.IsCoornianteReady(m_data.x1);
		
	case IMPLDATA_X2:
		return m_data.IsCoornianteReady(m_data.x2);
		
	case IMPLDATA_Y1:
		return m_data.IsCoornianteReady(m_data.y1);
		
	case IMPLDATA_Y2:
		return m_data.IsCoornianteReady(m_data.y2);
		
	case IMPLDATA_XREF:
		return m_data.IsCoornianteReady(m_data.x1) && m_data.IsCoornianteReady(m_data.x2);
		
	case IMPLDATA_YREF:
		return m_data.IsCoornianteReady(m_data.y1) && m_data.IsCoornianteReady(m_data.y2);
		
	default:
		O_A_FAIL;
		break;
	}

	return FALSE;
}

BOOL	DigitizerImpl::SetData(IMPLDATA type, LPCSTR lpcsz)
{
	LoadSettings();
	
	double*					prVal = NULL;
	DigitizerAxisData*		pAxisData = NULL;
	switch ( type )
	{
	case IMPLDATA_X1:
		prVal = &m_data.x1.value;
		pAxisData = &m_data.axisX;
		break;

	case IMPLDATA_X2:
		prVal = &m_data.x2.value;
		pAxisData = &m_data.axisX;
		break;

	case IMPLDATA_Y1:
		prVal = &m_data.y1.value;
		pAxisData = &m_data.axisY;
		break;

	case IMPLDATA_Y2:
		prVal = &m_data.y2.value;
		pAxisData = &m_data.axisY;
		break;

	default:
		O_A_FAIL;
		return FALSE;
	}

	*prVal = m_data.GetValue(lpcsz, pAxisData);
	return UpdateAxes() && RecalculateAndDump();
}

BOOL	DigitizerImpl::SetScaleType(IMPLDATA type, int nValue)
{
	LoadSettings();
	switch ( type )
	{
	case IMPLDATA_X1:
	case IMPLDATA_X2:
		m_data.axisX.nScaleType = nValue;
		break;
		
	case IMPLDATA_Y1:
	case IMPLDATA_Y2:
		m_data.axisY.nScaleType = nValue;
		break;
		
	default:
		O_A_FAIL;
		return FALSE;
	}
	return RecalculateAndDump() && UpdateInfo();
}

BOOL	DigitizerImpl::SetAxisPixel(IMPLDATA type, int nValue)
{
	LoadSettings();
	return Visualizer()->SetAxisPixel(type, nValue) && OnAfterAxesChange();
}

BOOL	DigitizerImpl::SetAxisColor(IMPLDATA type)
{
	LoadSettings();
	int*	pnColor = NULL;
	switch ( type )
	{
	case IMPLDATA_X1:
		pnColor = &m_data.x1.color;
		break;
		
	case IMPLDATA_X2:
		pnColor = &m_data.x2.color;
		break;
		
	case IMPLDATA_Y1:
		pnColor = &m_data.y1.color;
		break;
		
	case IMPLDATA_Y2:
		pnColor = &m_data.y2.color;
		break;

	case IMPLDATA_XREF:
		pnColor = &m_data.axisY.nColor;
		break;

	case IMPLDATA_YREF:
		pnColor = &m_data.axisX.nColor;
		break;
		
	default:
		O_A_FAIL;
		return FALSE;
	}

	GETN_TREE(tr)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	GETN_CUSTOM_BUTTON("OK=|Cancel=")
	GETN_COLOR(Color, "", *pnColor)						GETN_OPTION_EVENT_EX(_update_color)
	if ( !GetNBox(tr, _L("Color"), NULL, NULL, NULL, GetHwnd()) )
		return FALSE;

	*pnColor = tr.Color.nVal;
	return UpdateAxes() && SaveSettings();
}

BOOL	DigitizerImpl::SetAxisSelection(IMPLDATA type)
{
	return Visualizer()->SetAxisSelection(type);
}

IMPLDATA	DigitizerImpl::GetAxisSelection()
{
	return Visualizer()->GetAxisSelection();
}

void	DigitizerImpl::GetInfoNames(vector<string>& vs)
{
	Visualizer()->GetAxesNames(vs);
}

void	DigitizerImpl::GetInfoColors(vector<uint>& vn)
{
	LoadSettings();
	Visualizer()->GetAxesColors(vn);
}

void	DigitizerImpl::GetInfoScales(vector<string>& vs)
{
	LoadSettings();
	vs.SetSize(IMPLDATA_TOTAL);
	vs[IMPLDATA_X1] = m_data.GetValue(m_data.x1, &m_data.axisX);
	vs[IMPLDATA_X2] = m_data.GetValue(m_data.x2, &m_data.axisX);
	vs[IMPLDATA_Y1] = m_data.GetValue(m_data.y1, &m_data.axisY);
	vs[IMPLDATA_Y2] = m_data.GetValue(m_data.y2, &m_data.axisY);

	GetX0Y0(vs[IMPLDATA_XREF], vs[IMPLDATA_YREF]);
}

void	DigitizerImpl::GetInfoPixels(vector<string>& vs)
{
	LoadSettings();
	Visualizer()->GetAxesPixels(vs);
}

void	DigitizerImpl::GetInfoScaleTypes(vector<string>& vs)
{
	LoadSettings();
	vs.SetSize(IMPLDATA_TOTAL);
	vs[IMPLDATA_X1] = m_data.axisX.nScaleType;
	vs[IMPLDATA_Y1] = m_data.axisY.nScaleType;
}

/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
/*
/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
void	DigitizerImpl::GetLineInfoNumPoints(vector<string>& vs)
{
	Tree tr;
	m_data.GetPlotData(tr);
	
	vector vx;
	vx = tr.Root.Data.X.dVals;
	
	vs.RemoveAll();
	vs.Add((string)vx.GetSize());	
}

void	DigitizerImpl::GetLineInfoColor(vector<string>& vs)
{
	vs.RemoveAll();
	
	char chName[100];
	color_index_to_name(m_data.GetPlotColor(), chName, 100);
	
	vs.Add(chName);
}
///End DIGITIZER_SUPPORT_MAGNIFIER
*/
/// Iris 01/18/2012 ORG-4894-P1 FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
//void	DigitizerImpl::GetCurveInfo(CurveInfo& info)
bool 	DigitizerImpl::GetCurveInfo(CurveInfo& info)
///End FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
{
	/// Iris 01/18/2012 ORG-4894-P1 FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
	GraphLayer gl = m_objsHolder.GetDigitizeLayer();	
	if( !gl )
		return false;
	///End FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
	
	vector<string> vsCurveNames;
	m_data.GetAllPlotNames(vsCurveNames);	
	
	info.vsDataPoints.RemoveAll();
	info.vsColor.RemoveAll();
	info.vsShow.RemoveAll();	
	
	/// Iris 01/18/2012 ORG-4894-P1 FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
	//GraphLayer gl = m_objsHolder.GetDigitizeLayer();
	///End FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
	for(int index = 0; index < vsCurveNames.GetSize(); index++)
	{
		string strPoints, strColor, strShow;
		GraphObject goDigi = gl.GraphObjects(vsCurveNames[index]);		
		if( goDigi )
		{
			Tree tr;
			tr = goDigi.GetFormat(FPB_STYLE_COLOR | FPB_DATA, FOB_ALL, true, true);
			
			vector vx;
			vx = tr.Root.Data.X.dVals;			
			strPoints = vx.GetSize();
			
			char chName[100];
			color_index_to_name(tr.Root.Color.nVal, chName, 100);
			strColor = chName;	
			
			strShow = goDigi.Show;
		}
		else // not pick points yet
		{
			strPoints = "0";
			char chName[100];
			color_index_to_name(PLOT_COLOR(index), chName, 100);
			strColor = chName;
			strShow = "1";
		}	
		
		info.vsDataPoints.Add(strPoints);
		info.vsColor.Add(strColor);
		info.vsShow.Add(strShow);
	}
	/// Iris 01/18/2012 ORG-4894-P1 FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
	return true;
	///End FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
}

void	DigitizerImpl::ShowDataPlot(int nLineIndex, bool bShow)
{
	vector<string> vsCurveNames;
	m_data.GetAllPlotNames(vsCurveNames);
	if( nLineIndex >= vsCurveNames.GetSize() )
	{
		error_report("nLineIndex large than name list vector.");
		return;
	}
	
	GraphLayer gl = m_objsHolder.GetDigitizeLayer();
	GraphObject goDigi = gl.GraphObjects(vsCurveNames[nLineIndex]);		
	if( goDigi )
	{
		goDigi.Show = bShow;
	}
}

void	DigitizerImpl::SetPlotColor(int nColor)
{
	m_data.SetPlotColor(nColor);
}

BOOL	DigitizerImpl::ActivatePlot()
{
	return m_data.ActivatePlot();
}

BOOL	DigitizerImpl::SetActiveData(int nData)
{
	/// Iris 2/20/2012 FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
	//return m_data.SetActiveData(nData) && SaveSettings();
	m_data.SetActiveData(nData) && SaveSettings();
	DumpingHelper()->UpdateActiveData();
	///End FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
	return TRUE;
}

int		DigitizerImpl::GetActiveData()
{
	return m_data.GetActiveData();
}
///End IMPROVE_MULTIPLE_CURVES

/// Iris 12/20/2011 ORG-1614-S3 SUPPORT_PLOT_SELECTION_BY_OBJ_AND_ROW_IN_DATA_GRID
BOOL	DigitizerImpl::CheckGetActivePlot(int& nActivePlot)
{
	vector<string> vsCurveNames;
	m_data.GetAllPlotNames(vsCurveNames);	
	
	bool bRet = false;
	foreach(OriginObject obj in Selection.Objects)
	{
		string strObjectName = obj.GetName();
		//ERR_MSG(strObjectName);
		if( (nActivePlot = vsCurveNames.Find(strObjectName)) >= 0 )
		{
			bRet = true;
			break;
		}
	}	
	return bRet;
}
///End SUPPORT_PLOT_SELECTION_BY_OBJ_AND_ROW_IN_DATA_GRID

BOOL	DigitizerImpl::GetX0Y0(string& x, string& y)
{
	LoadSettings();
	double		xx, yy;
	GetX0Y0(xx, yy);
	x = m_data.GetValue(xx, &m_data.axisX);
	y = m_data.GetValue(yy, &m_data.axisY);
	return TRUE;
}

string	DigitizerImpl::GetAxisScaleHint(IMPLDATA type)
{
	LoadSettings();
	int		nSpace = 0;
	switch ( type )
	{
	case IMPLDATA_X1:
	case IMPLDATA_X2:
		nSpace = m_data.axisX.nScaleType;
		break;
		
	case IMPLDATA_Y1:
	case IMPLDATA_Y2:
		nSpace = m_data.axisY.nScaleType;
		break;
		
	default:
		O_A_FAIL;
		break;
	}

	switch ( nSpace )
	{
	case LINEAR_SPACE:
		return STR_LINEAR_SCALE;

	case LOG10_SPACE:
		return STR_LOG10_SCALE;

	default:
		break;
	}
	return "";
}

BOOL	DigitizerImpl::SaveAxesSettings(TreeNode& tr)
{
	Tree	trSettings;
	PrepareAxesSettings(trSettings);

	vector<int>		vnIDs;
	vector<string>	vsValues;
	vector<string>	vsLabels;
	return octree_get_values_with_ids(&trSettings, &vnIDs, &vsValues, &vsLabels) > 0 && octree_save_values_with_ids(&tr, &vnIDs, &vsValues, "", &vsLabels);
}

BOOL	DigitizerImpl::LoadAxesSettings(TreeNode& tr)
{
	Tree	trSettings;
	PrepareAxesSettings(trSettings);

	vector<int>		vnIDs;
	vector<string>	vsValues;
	string			str;
	if ( !octree_get_theme(&tr, &vnIDs, &vsValues, &str) || !tree_set_values_by_ids(trSettings, vnIDs, vsValues) )
		return FALSE;
	
	m_data = trSettings;
	return OnAfterAxesChange();
}

BOOL	DigitizerImpl::IsX1FromYAxis()
{
	return m_data.IsX1FromYAxis();
}

BOOL	DigitizerImpl::IsY1FromXAxis()
{
	return m_data.IsY1FromXAxis();
}

BOOL	DigitizerImpl::ImportImage()
{
	return ImageHelper()->Import()
		&& UpdateAxes()
		&& SaveSettings();
}

///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
BOOL	DigitizerImpl::ImportImageFromClipboard()
{
	return ImageHelper()->ImportFromClipboard()
		&& UpdateAxes()
		&& SaveSettings();
}
///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER

/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
//BOOL	DigitizerImpl::Rotate(BOOL bOn)
//{
	//LoadSettings();
	//RotateHelper()->Update(bOn);
	//if ( SetAxisEditingByOther(bOn, FALSE, IMPLDATACNTRL_AXIS_EDITING_BY_ROTATE, TRUE) )
		//return TRUE;
	//
	//return SaveSettings();
//}
//
//BOOL	DigitizerImpl::SetRotationMode(BOOL bOn)
//{
	//LoadSettings();
	//m_data.SetRotationMode(bOn);
	//return SaveSettings();
//}
//
//BOOL	DigitizerImpl::IsRotationMode()
//{
	//LoadSettings();
	//return m_data.IsRotationMode();
//}
/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
///End FIX_ROTATE_GETN_DLG_ISSUE

///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
BOOL	DigitizerImpl::SetLabelEditing(BOOL bOn)
{
	LoadSettings();
	Visualizer()->SetLabelEditing(bOn);
	
	if ( SetAxisEditingByOther(bOn, TRUE, IMPLDATACNTRL_AXIS_EDITING_BY_LABEL_EDITING) )
		return TRUE;
	return SaveSettings();
}

BOOL	DigitizerImpl::IsLabelEditing()
{
	LoadSettings();
	return m_data.IsLabelEditing();
}
///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

BOOL	DigitizerImpl::ChangeOptions()
{
	LoadSettings();
	return OptionsHelper()->Update() && RecalculateAndDump();
}

/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
#define BEFORE_DIGITIZING(m_data.bDigitizing)					\
	LoadSettings(); 											\
	if ( m_data.bDigitizing ) 									\
		return FALSE;  											\
	m_data.bDigitizing = TRUE; 									\
	SaveSettings(); 
	
#define AFTER_DIGITIZING(m_data.bDigitizing)  					\
	m_data.bDigitizing = FALSE; 								\
	SaveSettings(); 											\
		return bReturn;
///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE

BOOL	DigitizerImpl::Digitize()
{
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	/*
	if ( m_bDigitizing )
		return FALSE;

	m_bDigitizing = TRUE;
	
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	m_data.bDigitizing = m_bDigitizing;
	SaveSettings();
	///End OPTIMIZE_PICKED_POINT
	*/
	BEFORE_DIGITIZING(m_data.bDigitizing)
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	
	BOOL	bReturn = Digitizing();
	
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	/*
	m_bDigitizing = FALSE;
	
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	m_data.bDigitizing = m_bDigitizing;
	if ( HasValidDigitizeImage() )
		SaveSettings();
	///End OPTIMIZE_PICKED_POINT
	return bReturn;	
	*/
	AFTER_DIGITIZING(m_data.bDigitizing)
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE

}

///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
BOOL	DigitizerImpl::TraceLine()
{
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	/*
	if ( m_bDigitizing )
		return FALSE;

	m_bDigitizing = TRUE;
	
	m_data.bDigitizing = m_bDigitizing;
	SaveSettings();
	*/
	BEFORE_DIGITIZING(m_data.bDigitizing)
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	
	BOOL	bReturn = TracingLine();
	
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	/*
	m_bDigitizing = FALSE;	
	
	m_data.bDigitizing = m_bDigitizing;
	SaveSettings();
	
	return bReturn;
	*/
	AFTER_DIGITIZING(m_data.bDigitizing)	
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
}
///End DIGITIZER_AUTO_TRACE_LINE

///// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
BOOL	DigitizerImpl::DigitizeAreaAndAddPoints(double x, double y, double width, double height, int angle, int step)
{
	LoadSettings();
	Runner()->PrepareMatrixForDigitizeArea();
	SaveSettings();	// to save matrix object name and source image update status to m_data
	
	vector vx, vy;
	BOOL	bReturn = DigitizingArea(x, y, width, height, angle, step, vx, vy);			
	if( bReturn )
	{
		Visualizer()->AddPoints(vx, vy);
		SaveSettings();
	}
	
	afterRunDigitizing(vx.GetSize());
	return bReturn;
}
/////End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE

///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
BOOL	DigitizerImpl::IsImageDigitizing(){return m_data.bDigitizing;}
///End OPTIMIZE_PICKED_POINT

/// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
BOOL	DigitizerImpl::IsDigitizingArea()
{ 
	LoadSettings();
	return m_data.bDigitizingArea; 
}

void 	DigitizerImpl::GetDigitizeROIGridInfo(DigiROIGridInfo &stROIGridInfo)
{
	LoadSettings();	
	stROIGridInfo = m_data.stROIGridInfo;
}

/// Iris 2/02/2012 ORG-4797-S5 TO_ADD_DIGITIZE_SETTINGS_MENU
//void 	DigitizerImpl::SaveDigitizingAreaStatus(bool bOn, DigiROIGridInfo *pstROIGridInfo)
void 	DigitizerImpl::SaveDigitizingAreaStatus(bool *pbOn, DigiROIGridInfo *pstROIGridInfo)
///End TO_ADD_DIGITIZE_SETTINGS_MENU
{
	/// Iris 2/02/2012 ORG-4797-S5 TO_ADD_DIGITIZE_SETTINGS_MENU
	if( NULL == pbOn && NULL == pstROIGridInfo )
		return;
	///End TO_ADD_DIGITIZE_SETTINGS_MENU
	
	LoadSettings();
	/// Iris 2/02/2012 ORG-4797-S5 TO_ADD_DIGITIZE_SETTINGS_MENU
	//m_data.bDigitizingArea = bOn;
	if( NULL != pbOn )
		m_data.bDigitizingArea = *pbOn;
	///End TO_ADD_DIGITIZE_SETTINGS_MENU
	
	if( NULL != pstROIGridInfo )
		m_data.stROIGridInfo = *pstROIGridInfo;	
	SaveSettings();
}

void	DigitizerImpl::UpdateROIGirdStatus(bool bReset/* = false*/)
{
	LoadSettings();
	
	// setup LT variables to trun on digitize area rectangle
	int nStatus;
	if( bReset || !m_data.bDigitizingArea && !m_data.bDeletingPoints )
	{
		nStatus = DRAWFOCUSGRID_NONE;
	}
	else
	{
		if( !m_data.stROIGridInfo.bGrid )
		{
			nStatus = DRAWFOCUSGRID_RECT_ONLY;
		}
		else
		{
			if( m_data.stROIGridInfo.bVertical )
			{
				nStatus = DRAWFOCUSGRID_VERTICAL;
			}
			else
			{
				nStatus = DRAWFOCUSGRID_HORIZONTAL;
			}
		}
	}	
	bool bRet = _set_LT_var(LT_VAR_DIGI_AREA_GRID_SWITCH, nStatus);
	ASSERT(bRet);
	
	bRet = _set_LT_var(LT_VAR_DIGI_AREA_GRID_INTERVAL, m_data.stROIGridInfo.nStep);
	ASSERT(bRet);
}
///End MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA

int	DigitizerImpl::NewData()
{
	int nData = Visualizer()->NewData();
	if( nData >= 0 )
		SaveSettings();
	return nData;
}

/// Iris 12/29/2011 ORG-4685-S5 SUPPORT_DELETE_LINE
BOOL	DigitizerImpl::RemoveActiveData()
{
	return Visualizer()->RemoveActiveData() && SaveSettings();
}

BOOL	DigitizerImpl::IsDeleteLineEnable()
{
	return m_data.GetNumData() > 1;
}
///End SUPPORT_DELETE_LINE

BOOL	DigitizerImpl::GotoData()
{
	return  DumpingHelper()->Go();
}

BOOL	DigitizerImpl::GotoGraph()
{
	return  DumpingHelper()->GoToGraph();
}

BOOL	DigitizerImpl::DelWksGraph()
{
	if ( IDNO == MessageBox(GetHwnd(), _L("The digitized points, worksheet and graph will be deleted.\r\nAre you sure ?"), ERROR_TITLE, MB_YESNO | MB_ICONEXCLAMATION) )
		return FALSE;

	/// Iris 9/03/2012 ORG-5112-P3 FIX_NOT_REMOVE_ALL_DATAPLOTS_WHEN_CLICKED_DELETE_WKS_GRAPH
	//return DumpingHelper()->Clear() && Visualizer()->ClearDataPlot() && SaveSettings();
	bool bRet = DumpingHelper()->Clear() && Visualizer()->ClearAllDataPlots();
	m_data.ClearAllData(false);
	SaveSettings();
	return bRet;
	///End FIX_NOT_REMOVE_ALL_DATAPLOTS_WHEN_CLICKED_DELETE_WKS_GRAPH
}

BOOL	DigitizerImpl::HasValidDigitizeImage()
{
	GraphPage	gp = GetDigitizePage();
	if ( !gp || !m_objsHolder.IsPageValidToDigitize(gp) )
		return FALSE;

	return GetDigitizeImage().IsValid();
}

BOOL	DigitizerImpl::HasDataPoint()
{
	return Visualizer()->HasDataPoint();
}

BOOL	DigitizerImpl::Update(BOOL bLoadSettingsOnly/* = FALSE*/)
{
	LoadSettings();
	if ( bLoadSettingsOnly )
		return TRUE;
	return UpdateAxes() && UpdateDataPlot();
}

BOOL	DigitizerImpl::UpdateOptions(TreeNode& tr, DWORD dwCntrl)
{
	LoadSettings();
	BOOL	bReturn = OptionsHelper()->Update(tr, dwCntrl);
	if ( !bReturn )
		return FALSE;
	
	if ( O_QUERY_BOOL(dwCntrl, UPDATEOPTIONSFROM_DATA) )
		;
	else if ( O_QUERY_BOOL(dwCntrl, UPDATEOPTIONSFROM_DATANAME) )
		;
	else
		UpdateAxes();
	return SaveSettings();
}

double	DigitizerImpl::GetRotateInc()
{
	LoadSettings();
	return m_data.rAngleInc;
}

/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
//BOOL	DigitizerImpl::RotateImage(LPDOUBLE prAngle/* = NULL*/, LPDOUBLE prAngleInc/* = NULL*/)
BOOL	DigitizerImpl::RotateImage(LPDOUBLE prAngle/* = NULL*/, LPDOUBLE prAngleInc/* = NULL*/, bool bRefershImageHandle/* = false*/)
///End FIX_ROTATE_GETN_DLG_ISSUE
{
	LoadSettings();

	/// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
	Runner()->BackupImageMatrix();
	m_data.bUndoEnable = true;
	///End SUPPORT_UNDO_FOR_IMAGE_PROCESS
	
	GetDigitizeImage().SetDIBHandle(m_objsHolder.GetDigitizeImageBackup().GetDIBHandle());
	if ( prAngle )
		m_data.rAngleRotated = *prAngle;
	if ( prAngleInc )
		m_data.rAngleInc = *prAngleInc;
	
	ImageObjTransformHelper		clHelper(GetDigitizeImage());
	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	//return clHelper.Rotate(m_data.rAngleRotated, COLOR_WHITE) == 1 && SaveSettings();
	bool bRet = clHelper.Rotate(m_data.rAngleRotated, COLOR_WHITE) == 1 && SaveSettings();;
	if( bRet && bRefershImageHandle )
	{
		ImageHelper()->SaveImageBITMAPHANDLE(true);
	}
	return bRet;
	///End FIX_ROTATE_GETN_DLG_ISSUE
}

/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
bool	DigitizerImpl::ResetImage()
{
	return ImageHelper()->ResetImage(GetDigitizeImage());
}

void 	DigitizerImpl::BackupImage()
{
	ImageHelper()->SaveImageBITMAPHANDLE(true);
}
///End FIX_ROTATE_GETN_DLG_ISSUE

/// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
BOOL	DigitizerImpl::Undo()
{
	LoadSettings();	
	if( m_data.bUndoEnable )
	{
		Runner()->Undo( GetDigitizeImage() );	
		m_data.bUndoEnable = false;
		SaveSettings();
		return true;
	}
	return false;	
}

BOOL	DigitizerImpl::IsUndoEnable()
{
	LoadSettings();
	return m_data.bUndoEnable;
}
///End SUPPORT_UNDO_FOR_IMAGE_PROCESS

/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
/*
BOOL	DigitizerImpl::DigitizeArea()
{
	LoadSettings();
	DigitizerPickPointHelper clHelper(m_data);
	
	vector vx, vy;
	bool bRet = Runner()->DigitizeArea(vx, vy);
	if(bRet)
		bRet = Visualizer()->AddPoints(vx, vy) && SaveSettings();
	
	if (  bRet || clHelper.HasPickedPoint() ) 
	{
		clHelper.ClearBackup();
		LoadSettings();
		Runner()->Calculate();
		return DumpAndSave(TRUE);
	}
	
	return false;
}
*/
///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE

BOOL	DigitizerImpl::ClearBackground()
{	
	LoadSettings();
	if( Runner()->ClearBackground( GetDigitizeImage() ) )
	{
		m_data.bUndoEnable = true; /// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
		SaveSettings();
		return TRUE;
	}
	return FALSE;
}

BOOL	DigitizerImpl::RemoveGridLine()
{	
	LoadSettings();
	if( Runner()->RemoveGridLine( GetDigitizeImage() ) )
	{
		m_data.bUndoEnable = true; /// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
		SaveSettings();
		return TRUE;
	}
	return FALSE;
}

BOOL	DigitizerImpl::IsReadyToDigitize()
{
	return Visualizer()->IsReadyToDigitize();
}

BOOL	DigitizerImpl::UpdateFromEvents(int nEvent, LPCSTR lpcszName)
{
	ObjsUpdateEventHelper	clHelper;
	if ( clHelper.IsDuringUpdate() )
		return FALSE;

	ERR_MSG("DigitizerImpl::UpdateFromEvents");
	LoadSettings();
	int		nUpdate = Visualizer()->UpdateFromEvents(nEvent, lpcszName);
	if ( UPDATEFROMEVENTS_NONE == nUpdate )
		return FALSE;

	/// Iris 12/20/2011 ORG-1614-S3 SUPPORT_PLOT_SELECTION_BY_OBJ_AND_ROW_IN_DATA_GRID
	/*
	return OE_SELECT == nEvent || OE_UNSELECT == nEvent ?
		UpdateInfoSelection() : (UPDATEFROMEVENTS_AXIS == nUpdate ? RecalculateAndDump() && UpdateInfo() : UpdatePlotFromEvent(nEvent)) && EnableDigitize();
	*/
	if( UPDATEFROMEVENTS_PLOT == nUpdate )
	{		
		if( (OE_SELECT == nEvent || OE_UNSELECT == nEvent) ) 
		{
			/// Iris 2/20/2012 FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
			//if( m_data.IsReadyForPlotSelectionEvent() ) // select/unselect plot according to row select in Data grid, no need enter if.
			if( m_data.IsReadyForPlotSelectionEvent() // select/unselect plot according to row select in Data grid, no need enter if.
				&& !m_data.bDigitizing
				&& !m_data.bDigitizingArea
				&& !m_data.bDeletingPoints
			) 
			///End FIX_REORDER_AND_DELETE_POINTS_FOR_ONE_LINE_ALWAYS_EFFECTED_ON_ALL_LINES
				return UpdateDataPlotSelectionFromEvent(); // activate data plot from graph, to update the row selection in Data gird
		}
		else
		{
			return UpdatePlotFromEvent(nEvent) && EnableDigitize();
		}
	}
	
	if( UPDATEFROMEVENTS_AXIS == nUpdate )
	{
		if( OE_SELECT == nEvent || OE_UNSELECT == nEvent )
			return UpdateInfoSelection();
		else
			return RecalculateAndDump() && UpdateInfo() && EnableDigitize();		
	}
	///End SUPPORT_PLOT_SELECTION_BY_OBJ_AND_ROW_IN_DATA_GRID	
	
	if( UPDATEFROMEVENTS_VERTEX == nUpdate )
	{
		if( IsVertexsReady() && OE_GRAPHOBJ_EDIT == nEvent )
		{
			return UpdateVertexs();
		}
	}
}

BOOL	DigitizerImpl::UpdateFromPlot(int nEvent)
{
	LoadSettings();	
	return Visualizer()->UpdateFromPlot(nEvent) && RecalculateAndDump(OE_DELETE == nEvent);
}

string	DigitizerImpl::GetDataName()
{
	return m_data.GetDataName();
}

BOOL	DigitizerImpl::SetAxesEditing(BOOL bOn)
{
	LoadSettings();
	return Visualizer()->SetAxesEditing(bOn) && SaveSettings();
}

BOOL	DigitizerImpl::ShowXRefLine(BOOL bShow)
{
	LoadSettings();
	return Visualizer()->ShowXRefLine(bShow) && SaveSettings();
}

BOOL	DigitizerImpl::ShowYRefLine(BOOL bShow)
{
	LoadSettings();
	return Visualizer()->ShowYRefLine(bShow) && SaveSettings();
}

BOOL	DigitizerImpl::IsAxesEditing()
{
	return m_data.IsAxisEditing();
}

BOOL	DigitizerImpl::IsXRefLineShow()
{
	return m_data.IsXRefLineShow();
}

BOOL	DigitizerImpl::IsYRefLineShow()
{
	return m_data.IsYRefLineShow();
}

BOOL	DigitizerImpl::GetOnePoint(string& str, double x, double y)
{
	LoadSettings();
	Runner()->CalculateOnePoint(x, y);
	str.Format("X = %s, Y = %s", m_data.GetValue(x), m_data.GetValue(y));
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	if(m_data.OptimizeError != 0)
	{
		str += "\n" + _L("Optimization fails!");
		return FALSE;
	}
	///End OPTIMIZE_PICKED_POINT
	return TRUE;
}
///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
//BOOL	AddOnePoint(double x,  double y)
BOOL	DigitizerImpl::AddOnePoint(double& x,  double& y)
{
	LoadSettings();
	
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	m_data.OptimizeError = 0;
	if( IsOptimizePoint() )
	{
		if( !OptimizePoint(x, y) )
		{
			m_data.OptimizeError = -1;
			SaveSettings();
			return false;
		}
	}
	///End OPTIMIZE_PICKED_POINT
	
	return Visualizer()->AddOnePoint(x, y) && SaveSettings();
}

///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
bool DigitizerImpl::IsOptimizePoint(){return m_data.OptimizePoint;}
bool DigitizerImpl::OptimizePoint(double& x,  double& y)
{
	return Runner()->OptimizePoint(x, y);
}

///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE 
//void DigitizerImpl::DestroyImageMatrix()
void DigitizerImpl::DestroyTempMatrix()
///End DIGITIZER_AUTO_TRACE_LINE
{
	if( !IsImageDigitizing() )
	{
		Runner()->DestroyImageMatrix();
		//out_str("DestroyImageMatrix="+GetDataName());
		Runner()->DestroyTraceLineMatrix();					///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE 		
		Runner()->DestroyDigitizeAreaMatrix(); /// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
		
	}
	else
		;//out_str("no DestroyImageMatrix="+GetDataName());
}
///End OPTIMIZE_PICKED_POINT

/// Iris 9/03/2012 ORG-5112-P5 TO_FIND_GOOD_START_POINT_FOR_AUTO_TRACE_LINE
BOOL	DigitizerImpl::BeforeAutoTraceLine(double& x,  double& y)
{
	return Runner()->BeforeAutoTraceLine(x, y);
}
///End TO_FIND_GOOD_START_POINT_FOR_AUTO_TRACE_LINE

///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
BOOL	DigitizerImpl::TraceLineAndAddPoints(double& x,  double& y)
{
	LoadSettings();
	
	vector vx, vy;
	Runner()->AutoTraceLine(x, y, vx, vy);
	
	return Visualizer()->AddPoints(vx, vy) && SaveSettings();
}
///End DIGITIZER_AUTO_TRACE_LINE
	
string	DigitizerImpl::GetHint()
{
	string		str;
	if ( HasValidDigitizeImage() )
	{
		LoadSettings();
		if ( IsAxesEditing() )
		{
			str = _L("Click Rotate button to rotate Image.\r\n\
				Drag the lines to known coordinates on image.\r\n\
				Enter those values in Axis Scale column.\r\n\
				Press s to select the X1 line, press tab to switch the selected line.\r\n\
				Click Pick New Points.");
		}
		///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		else if ( IsLabelEditing() )
		{
			str = _L("Click : Select a point\r\n\
					Arrow Keys : Move the selected point\r\n\
					Double Click / Enter Key: Set Label for the point.\r\n\
					Del Key: Delete the label of the point.\r\n\
					Esc Key: De-select.");
		}
		///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		else
		{
			str = Visualizer()->HasDataPoint() ? _L("Click : Select a point\r\n\
												Arrow Keys : Move the selected point\r\n\
												Tab Key : Switch to Next point (Shift-Tab = Previous)\r\n\
												Del Key : Delete selected\r\n\
												Esc Key: De-select")
												: _L("Click \"Pick New Points\" button to start digitize.");
		}
	}
	else
	{
		str = _L("Click \"Import\" button to import an image.");
	}
	return str;
}

#define		STR_DIGITIZER_TITLE		"%s - %s(%dx%d)"
string	DigitizerImpl::GetTitle()
{
	string	str;
	str.Format(STR_DIGITIZER_TITLE, STR_DLG_NAME_L, m_data.strImageName, m_data.nImageWidth, m_data.nImageHeight);
	return str;
}

BOOL	DigitizerImpl::CheckUpdateOnDlgShow(BOOL bShow)
{
	if ( !HasValidDigitizeImage() )
		return FALSE;

	LoadSettings();
	CheckRestorePickPoints(bShow);
	
	if ( bShow == IsDlgOpen() )
		return TRUE;		

	ERR_MSG("CheckUpdateOnDlgShow");		
	m_data.SetDlgOpen(bShow);	
	return CheckShowOpenDlgObj()
		&& CheckUpdateObjsStates()
		&& SaveSettings();
}

///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
BOOL	DigitizerImpl::DataPlotEdit(int nIndex)
{
	LoadSettings();
	return Visualizer()->DataPlotEdit(nIndex) && DumpAndSave();
}
///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH

///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
BOOL	DigitizerImpl::UpdatePlotFromOutput(DatasetObject& dsObj, GraphLayer& gl)
{
	if ( HasValidDigitizeImage() || !gl )
		return FALSE;

	DigitizerLayerTempChange	tempChange(&m_objsHolder, gl);

	if ( !LoadSettings() )
		return FALSE;

	if ( !DumpingHelper()->CheckUpdateDataFromOutput(dsObj) )
		return FALSE;

	if ( !Runner()->AntiCalculate() )
		return FALSE;

	return Visualizer()->UpdatePlotData() && SaveSettings();
}
///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
bool DigitizerImpl::GetImageROI(pBITMAPHANDLE &pLBROI, int xPixels, int yPixels, int nROIPercent)
{
	return ImageHelper()->GetImageROI(pLBROI, xPixels, yPixels, nROIPercent);
}
///End DIGITIZER_SUPPORT_MAGNIFIER

/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
//BOOL DigitizerImpl::DeletePoint()
BOOL DigitizerImpl::DeletePoints(double x, double y, double width, double height)
///End IMPROVE_DELETE_POINTS
{
	/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
	/*
	int		nIndex = Selection.GetHandle() - 1;
	if ( nIndex >= 0 )
	{		
		// delete the data in worksheet		
		DumpingHelper()->DeletePoint(nIndex);
		
		Visualizer()->DeletePoint(nIndex);	
		return TRUE;
	}	
	return FALSE;
	*/
	vector<uint> vnIndices;
	getPointsInsideRect(x, y, width, height, vnIndices);
	if( vnIndices.GetSize() == 0 )
		return false;	
	
	// delete the data in worksheet		
	DumpingHelper()->DeletePoints(vnIndices);
	
	// delete the data points (graph objects) from graph
	Visualizer()->DeletePoints(vnIndices);	
	return TRUE;
	///End IMPROVE_DELETE_POINTS	
}

/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
bool DigitizerImpl::getPointsInsideRect(double x, double y, double width, double height, vector<uint>& vnIndices)
{	
	Tree tr;
	m_data.GetPlotData(tr);
	
	vector vx, vy;	
	vx = tr.Root.Data.X.dVals;
	vy = tr.Root.Data.Y.dVals;
	
	vnIndices.RemoveAll();	
	for(int index = 0; index < vx.GetSize(); ++index)
	{
		if( vx[index] >= x && vx[index] <= x + width && vy[index] >= y && vy[index] <= y + height )
			vnIndices.Add(index);
	}	
	return vnIndices.GetSize()>0;	
}

void DigitizerImpl::SaveDeletePointsStatus(bool bOn)
{
	LoadSettings();
	m_data.bDeletingPoints = bOn;
	m_data.stROIGridInfo.bGrid = false; 
	SaveSettings();
}

bool DigitizerImpl::IsDeletingPoints()
{
	return m_data.bDeletingPoints;
}
///End IMPROVE_DELETE_POINTS

BOOL DigitizerImpl::ReorderPoints()
{
	// sort the data in worksheet
	DumpingHelper()->ReorderPoints();
	
	// sort the data - graph objects on graph
	Visualizer()->ReorderPoints();
	return TRUE;
}

/// Iris 7/16/2012 ORG-6216-S1 SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT
BOOL DigitizerImpl::SetFocusOnGraph()
{
	GraphLayer gl = GetDigitizeLayer();
	if( gl )
	{
		Page pg = gl.GetPage();
		Window wndPage = pg.GetWindow();
		HWND hwnd = wndPage.GetSafeHwnd();
		return NULL != SetFocus(hwnd);
	}
	return FALSE;	
}
///End SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT

/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
int	DigitizerImpl::GetCoordinatesType()
{
	LoadSettings();
	return m_data.nCoordinatesType;
}

void DigitizerImpl::SetCoordinatesType(int nType)
{
	LoadSettings();
	m_data.nCoordinatesType = nType;
	SaveSettings();
}

bool DigitizerImpl::AddOneVertex(double x, double y)
{
	LoadSettings();
	return m_data.AddOneVertex(x, y) && VertexPoints()->AddOneVertex(x, y) && SaveSettings() && UpdateVertexInfo();		
}

DigitizerTernaryVertexsPoints*	DigitizerImpl::VertexPoints()
{
	if ( NULL == m_pVertexs )
		m_pVertexs = new DigitizerTernaryVertexsPoints(m_data, m_objsHolder);
	return m_pVertexs;
}

bool DigitizerImpl::ShowAxes(bool bShow)
{
	return Visualizer()->ShowAxes(bShow);
}

bool DigitizerImpl::ShowVertexs(bool bShow)
{
	return Visualizer()->ShowVertexs(bShow);
}

bool DigitizerImpl::IsVertexsReady()
{
	LoadSettings();
	return m_data.IsVertexsReady();
}

int	DigitizerImpl::GetVertexs(vector& vx, vector& vy)
{
	LoadSettings();
	vx = m_data.PtsVertexX;
	vy = m_data.PtsVertexY;
	ASSERT(vx.GetSize() == vy.GetSize());
	return vx.GetSize();
}

bool DigitizerImpl::UpdateVertexs()
{
	return LoadSettings() && VertexPoints()->UpdateVertexs() && SaveSettings() && UpdateVertexInfo();
}
///End SUPPORT_TERNARY_IN_DIGITIZER
	
//private:
DigitizerVisualizer*		DigitizerImpl::Visualizer()
{
	if ( NULL == m_pVisualizer )
		m_pVisualizer = new DigitizerVisualizer(m_data, m_objsHolder);
	return m_pVisualizer;
}

DigitizerImageHelper*		DigitizerImpl::ImageHelper()
{
	if ( NULL == m_pImage )
		m_pImage = new DigitizerImageHelper(m_data, m_objsHolder);
	return m_pImage;
}

/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
//DigitizerRotationHelper*	DigitizerImpl::RotateHelper()
//{
	//if ( NULL == m_pRotate )
		//m_pRotate = new DigitizerRotationHelper(m_data, GetHwnd());
	//return m_pRotate;
//}
///End FIX_ROTATE_GETN_DLG_ISSUE

DigitizerOptionsHelper*		DigitizerImpl::OptionsHelper()
{
	if ( NULL == m_pOptions )
		m_pOptions = new DigitizerOptionsHelper(m_data, GetHwnd());
	return m_pOptions;
}

DigitizerRunner*			DigitizerImpl::Runner()
{
	if ( NULL == m_pRunner )
		m_pRunner = new DigitizerRunner(m_data);
	return m_pRunner;
}

DigitizerDataDumpingHelper*	DigitizerImpl::DumpingHelper()
{
	if ( NULL == m_pDumping )
		m_pDumping = new DigitizerDataDumpingHelper(m_data, GetHwnd());
	return m_pDumping;
}

GraphPage	DigitizerImpl::GetDigitizePage()
{
	return m_objsHolder.GetDigitizePage();
}

GraphObject	DigitizerImpl::GetDigitizeImage()
{
	return m_objsHolder.GetDigitizeImage();
}

void		DigitizerImpl::InitData()
{
	m_data.Init();
}

BOOL	DigitizerImpl::SaveSettings()
{
	Tree			tr;
	tr = m_data;
	return GetDigitizeImage().PutBinaryStorage(STR_SETTINGS_STORAGE, tr);
}

BOOL	DigitizerImpl::LoadSettings()
{
	Tree			tr;
	if ( !GetDigitizeImage().GetBinaryStorage(STR_SETTINGS_STORAGE, tr) )
	{
		InitData();
		return FALSE;
	}

	m_data = tr;
	return Visualizer()->UpdateFromPlot(GENERIC_UPDATE_EVENT);
}

BOOL	DigitizerImpl::UpdateAxes(BOOL bRefresh/* = FALSE*/)
{
	return Visualizer()->UpdateAxes(bRefresh);
}

BOOL	DigitizerImpl::UpdateDataPlot(BOOL bRefresh/* = FALSE*/)
{
	return Visualizer()->UpdateDataPlot(bRefresh);
}

BOOL	DigitizerImpl::UpdatePlotFromEvent(int nEvent)
{
	return NotifyDigitizer(ID_DIGITIZER_MSG_UPDATE_FROM_POINTS, TRUE, nEvent);
}

BOOL	DigitizerImpl::UpdateInfo()
{
	return NotifyDigitizer(ID_DIGITIZER_MSG_UPDATE_INFO);
}

BOOL	DigitizerImpl::UpdateInfoSelection()
{
	return NotifyDigitizer(ID_DIGITIZER_MSG_UPDATE_INFO_SELECTION, TRUE);
}

/// Iris 12/20/2011 ORG-1614-S3 SUPPORT_PLOT_SELECTION_BY_OBJ_AND_ROW_IN_DATA_GRID
BOOL	DigitizerImpl::UpdateDataPlotSelectionFromEvent()
{
	return NotifyDigitizer(ID_DIGITIZER_MSG_UPDATE_PLOT_SELECTION, TRUE);
}
///End SUPPORT_PLOT_SELECTION_BY_OBJ_AND_ROW_IN_DATA_GRID

BOOL	DigitizerImpl::EnableDigitize()
{
	return NotifyDigitizer(ID_DIGITIZER_MSG_ENABLE_DIGITIZE, TRUE);
}

/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
BOOL	DigitizerImpl::UpdateVertexInfo()
{
	return NotifyAxesPanel(ID_DIGITIZER_MSG_VERTEX_UPDATE, TRUE);
}

BOOL	DigitizerImpl::NotifyAxesPanel(int nMsg, BOOL bPost/* = FALSE*/, UINT wParam/* = 0*/, UINT lParam/* = 0*/)
{
	if ( g_pDigitizer )
	{		
		g_pDigitizer->NotifyAxesPanel(nMsg, bPost, wParam, lParam);
		return TRUE;
	}
	return FALSE;
}
///End SUPPORT_TERNARY_IN_DIGITIZER

BOOL	DigitizerImpl::NotifyDigitizer(int nMsg, BOOL bPost/* = FALSE*/, UINT wParam/* = 0*/, UINT lParam/* = 0*/)
{
	if ( g_pDigitizer )
	{
		if ( bPost )
			g_pDigitizer->PostMessage(nMsg, wParam, lParam);
		else
			g_pDigitizer->SendMessage(nMsg, wParam, lParam);
	}

	return TRUE;
}

BOOL	DigitizerImpl::RecalculateAndDump(BOOL bDumpEvenNotCalculate/* = FALSE*/)
{
	if ( IsReadyToDigitize() )
	{
		if ( Runner()->Calculate() || bDumpEvenNotCalculate )
			return DumpAndSave();
	}
	
	return SaveSettings();
}

BOOL	DigitizerImpl::DumpAndSave(BOOL bPlot/* = FALSE*/)
{
	return DumpingHelper()->Dump(bPlot) && SaveSettings();
}

BOOL	DigitizerImpl::IsDlgOpen()
{
	return m_data.IsDlgOpen();
}

BOOL	DigitizerImpl::CheckShowOpenDlgObj()
{
	return m_objsHolder.SetObjProperty("OpenDlg", "Show", !IsDlgOpen());
}

BOOL	DigitizerImpl::CheckUpdateObjsStates()
{
	if ( !IsDlgOpen() )
		Selection.Reset();

	return Visualizer()->UpdateStates();
}

BOOL	DigitizerImpl::CheckRestorePickPoints(BOOL bDlgShow)
{
	DigitizerPickPointHelper	clHelper(m_data);
	if ( !clHelper.IsDataBackup() )
		return TRUE;

	if ( bDlgShow )
	///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
		//return NotifyDigitizer(WM_COMMAND, TRUE, MAKELONG(IDC_DIGITIZER_GO, BN_CLICKED), 0);
	{
		int nBtnID = IDC_DIGITIZER_TRACE_LINE != m_data.nProcessingBtnID? IDC_DIGITIZER_GO : m_data.nProcessingBtnID;
		return NotifyDigitizer(WM_COMMAND, TRUE, MAKELONG(nBtnID, BN_CLICKED), 0);
	}
	///End DIGITIZER_AUTO_TRACE_LINE
	
	return clHelper.CheckRestore() && UpdateDataPlot() && SaveSettings();
}

void	DigitizerImpl::PrepareAxesSettings(TreeNode& tr)
{
	LoadSettings();
	tr = m_data;
	octree_remove_attribute(&tr, STR_DATAID_ATTRIB);
	m_data.PrepareAxesTreeIDs(tr);
}

BOOL	DigitizerImpl::OnAfterAxesChange()
{
	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	//return UpdateAxes() && RecalculateAndDump() && UpdateInfo() && UpdateRotation() && RotateImage();
	return UpdateAxes() && RecalculateAndDump() && UpdateInfo();
	///End FIX_ROTATE_GETN_DLG_ISSUE
}

/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
void	DigitizerImpl::beforeRunDigitizing(int nCmdID)
{
	LoadSettings();
	m_data.nProcessingBtnID = nCmdID;				///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
}

BOOL	DigitizerImpl::afterRunDigitizing(int nReturn, DigitizerPickPointHelper* pclHelper)
{
	if ( nReturn > 0 || (0 == nReturn && pclHelper && pclHelper->HasPickedPoint()) )
	{
		if( pclHelper )
			pclHelper->ClearBackup();
		LoadSettings();
		Runner()->Calculate();
		return DumpAndSave(TRUE);
	}
	
	if ( pclHelper && pclHelper->CheckBackupData() )
		return TRUE;
	return UpdateDataPlot() && SaveSettings();
}

///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE

BOOL	DigitizerImpl::Digitizing()
{
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	/*
	LoadSettings();

	m_data.nProcessingBtnID = IDC_DIGITIZER_GO;				///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
	*/
	beforeRunDigitizing(IDC_DIGITIZER_GO);
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	if( IsOptimizePoint() )
	{
		Runner()->PrepareImageMatrix();
		SaveSettings();
	}
	///End OPTIMIZE_PICKED_POINT
	
	DigitizerPickPointHelper		clHelper(m_data);
	int			nReturn = Runner()->Run(*g_pDigitizer);
	
	/////Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	//if( IsOptimizePoint() )
		//Runner()->DestroyImageMatrix();
	/////End OPTIMIZE_PICKED_POINT
	
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	/*
	if ( nReturn > 0 || (0 == nReturn && clHelper.HasPickedPoint()) )
	{
		clHelper.ClearBackup();
		LoadSettings();
		Runner()->Calculate();
		return DumpAndSave(TRUE);
	}
	
	if ( clHelper.CheckBackupData() )
		return TRUE;
	return UpdateDataPlot() && SaveSettings();
	*/
	return afterRunDigitizing(nReturn, &clHelper);
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
}

///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
BOOL	DigitizerImpl::TracingLine()
{
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	/*
	LoadSettings();

	m_data.nProcessingBtnID = IDC_DIGITIZER_TRACE_LINE;
	*/
	beforeRunDigitizing(IDC_DIGITIZER_TRACE_LINE);
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	
	Runner()->PrepareMatrixForTraceLine();		
	SaveSettings();
		
	DigitizerPickPointHelper  		clHelper(m_data);
	int nReturn = Runner()->RunTraceLine(*g_pDigitizer);
	
	//Runner()->DestroyTraceLineMatrix();
	
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	/*
	if ( nReturn > 0 || (0 == nReturn && clHelper.HasPickedPoint()) )
	{
		clHelper.ClearBackup();
		LoadSettings();
		Runner()->Calculate();
		return DumpAndSave(TRUE);
	}
	
	if ( clHelper.CheckBackupData() )
		return TRUE;
	return UpdateDataPlot() && SaveSettings();
	*/
	return afterRunDigitizing(nReturn, &clHelper);
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
}
///End DIGITIZER_AUTO_TRACE_LINE


/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
BOOL	DigitizerImpl::DigitizingArea(double x, double y, double width, double height, int angle, int step, vector& vx, vector& vy)
{
	return Runner()->DigitizeArea(x, y, width, height, angle, step, vx, vy); 
}
///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE


BOOL	DigitizerImpl::GetX0Y0(double& x, double& y)
{
	return Visualizer()->GetX0Y0(x, y) && Runner()->CalculateOnePoint(x, y);
}

BOOL	DigitizerImpl::SetAxisEditingByOther(BOOL bOn, BOOL bNot, DWORD dwBit, BOOL bAlways/* = FALSE*/)
{
	if ( bOn && (bAlways || !XOR(IsAxesEditing(), bNot)) )
	{
		SetAxisEditingByOther(dwBit, TRUE);
		return SetAxesEditing(!bNot);
	}
	
	if ( !bOn && m_data.IsAxisEditingByOther(dwBit) )
	{
		SetAxisEditingByOther(dwBit, FALSE);
		return SetAxesEditing(bNot);
	}
	return FALSE;
}

void	DigitizerImpl::SetAxisEditingByOther(DWORD dwBit, BOOL bOn)
{
	m_data.SetAxisEditingByOther(dwBit, bOn);
	SaveSettings();
}

/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
//BOOL	DigitizerImpl::UpdateRotation()
//{
	//if ( IsRotationMode() )
		//return Rotate(TRUE);
	//
	//SetAxisEditingByOther(FALSE, FALSE, IMPLDATACNTRL_AXIS_EDITING_BY_ROTATE);
	//return TRUE;
//}
///End FIX_ROTATE_GETN_DLG_ISSUE

//public:	
///Jasmine 03/11/11 ORG-2286 KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP
void 	DigitizerImpl::CleanRelativeData(LPCSTR lpczAttachPage)
{
	GraphPage gp(lpczAttachPage);
	if(!gp)
		return;
	GraphLayer gl	= gp.Layers();
	GraphObject go 	= gl.GraphObjects(STR_IMAGE_NAME);
	Tree tr;
	go.GetBinaryStorage(STR_SETTINGS_STORAGE, tr);
	m_data = tr;
	
	///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE 
	//DestroyImageMatrix();
	DestroyTempMatrix();
	///End DIGITIZER_AUTO_TRACE_LINE
}
///End KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP

/*------------------------------------------------------------------------------*
* DigitizerImpl	End																*
*------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* DigitizerInfoList																*
*------------------------------------------------------------------------------*/
#define		STR_AXES_LIST_COL_HEADING			_L("Name|Color|Axis Value|Image Pixel|Scale Type")
enum
{
	INFOLISTCOL_NAME		= 0,
	INFOLISTCOL_COLOR,
	INFOLISTCOL_SCALE,
	INFOLISTCOL_PIXEL,
	INFOLISTCOL_SCALETYPE,
};

#define		INFOLISTROW_OFFSET		1

enum
{
	INFOLISTROW_X1			= INFOLISTROW_OFFSET + IMPLDATA_X1,
	INFOLISTROW_X2,
	INFOLISTROW_Y1,
	INFOLISTROW_Y2,
	INFOLISTROW_XREF,
	INFOLISTROW_YREF,

	INFOLISTROW_TOTAL
};

enum
{
	INFOLISTUPDATE_SELECTION_ONLY			= 0x00000001,
	INFOLISTUPDATE_RESET_ROWS				= 0x00000002,
};

//class DigitizerInfoList
//public:
DigitizerInfoList::DigitizerInfoList(DigitizerImpl* pImpl)
{
	m_pImpl = pImpl;
	m_nDuringUpdate = 0;
}
DigitizerInfoList::~DigitizerInfoList()
{
}

void DigitizerInfoList::Init(int nID, Dialog& dlg)
{
	++m_nDuringUpdate;
	GridListControl::Init(nID, dlg);
		
	SetupRowsCols();
	
	SetExtendLastCol(false);
	SetEditable(flexEDKbdMouse);
	
	SetColHeader(STR_AXES_LIST_COL_HEADING);
	SetColAlignment(-1, flexAlignCenterCenter);
	
	SetColHighlight(INFOLISTCOL_COLOR, FALSE);

	InitScaleTypes();

	UpdateRows();

	--m_nDuringUpdate;
}

BOOL	DigitizerInfoList::Update(DWORD dwCntrls/* = 0*/)
{
	UpdateSelection();
	if ( O_QUERY_BOOL(dwCntrls, INFOLISTUPDATE_SELECTION_ONLY) )
		return TRUE;

	int		nSelectedRow = GetSelectedRow();		
	BOOL	bValidToDigitize = m_pImpl->HasValidDigitizeImage();
	BOOL	bResetRows = O_QUERY_BOOL(dwCntrls, INFOLISTUPDATE_RESET_ROWS);

	CheckShowRows(bValidToDigitize);
	if ( bValidToDigitize )
	{
		UpdateNames();
		UpdateColors();
		UpdateScales();
		UpdatePixels();
		UpdateScaleTypes();
	}
	
	if ( bResetRows )
	{
		ResizeCols();
	}
	SelectRow(nSelectedRow);
	return UpdateCellsColor();
}

BOOL	DigitizerInfoList::UpdateSelectable(BOOL bResetRowSelection/* = FALSE*/)
{
	BOOL	bIsAxesEditing = IsAxesEditing();
	if ( bResetRowSelection)
		SelectRow(0, !bIsAxesEditing);

	if ( bIsAxesEditing)
	{
		SetSelection(flexSelectionByRow);
	}
	else
	{
		SetSelection(flexSelectionFree);
	}
	return UpdateCellsColor();
}

void	DigitizerInfoList::OnBeforeEdit(long nRow, long nCol, BOOL* pCancel)
{
	*pCancel = FALSE;
	switch ( nCol )
	{
	case INFOLISTCOL_NAME:
		*pCancel = TRUE;
		break;

	case INFOLISTCOL_COLOR:
		*pCancel = TRUE;
		SetAxisColor(nRow - INFOLISTROW_OFFSET);
		break;
		
	case INFOLISTCOL_SCALE:
		*pCancel = INFOLISTROW_XREF == nRow || INFOLISTROW_YREF == nRow;
		break;

	case INFOLISTCOL_SCALETYPE:
		*pCancel = !(INFOLISTROW_X1 == nRow || INFOLISTROW_Y1 == nRow);
		break;

	case INFOLISTCOL_PIXEL:
		*pCancel = !IsAxesEditing() || !m_pImpl->IsCoorReady(nRow - INFOLISTROW_OFFSET);
		break;
		
	default:
		break;
	}
}

void	DigitizerInfoList::OnAfterEdit(int nRow, int nCol)
{
	string		str = GetCell(nRow, nCol);
	int			nType = nRow - INFOLISTROW_OFFSET;
	switch ( nCol )
	{
	case INFOLISTCOL_SCALE:
		switch ( nRow )
		{
		case INFOLISTROW_X1:
		case INFOLISTROW_X2:
		case INFOLISTROW_Y1:
		case INFOLISTROW_Y2:
			m_pImpl->SetData(nType, str);
			break;

		default:
			break;
		}
		UpdateX0Y0();
		UpdateCellsColor();
		CheckEnableDigitize();
		break;

	case INFOLISTCOL_PIXEL:
		m_pImpl->SetAxisPixel(nType, atoi(str));
		break;

	case INFOLISTCOL_SCALETYPE:
		m_pImpl->SetScaleType(nType, atoi(str));
		break;
		
	default:
		break;
	}

	GridListControl::OnAfterEdit(nRow, nCol);
}

void 	DigitizerInfoList::OnAfterSelectionChange(int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel)
{
	if ( IsDuringUpdate() || !IsAxesEditing() || nNewRowSel < INFOLISTROW_OFFSET || nOldRowSel == nNewRowSel )
		return;

	ERR_MSG("OnAfterSelectionChange");
	m_pImpl->SetAxisSelection(nNewRowSel - INFOLISTROW_OFFSET);
	UpdateAfterSelect(nNewRowSel, nOldRowSel);
}

void	DigitizerInfoList::OnMouseMove(short nButton, short nShift, float X, float Y)
{
	int		nRow, nCol;
	if ( !GetMouseCell(nRow, nCol) || nRow < 0 || nCol < 0 )
		return;

	string		str;
	if ( INFOLISTCOL_SCALE == nCol && nRow >= INFOLISTROW_X1 && nRow <= INFOLISTROW_Y2 )
	{
		str = m_pImpl->GetAxisScaleHint(nRow - INFOLISTROW_OFFSET);
	}
	SetToolTipsText(str);
}

#define		ID_INFOLIST_MENU_SAVE_SETTINGS		0x0001
#define		ID_INFOLIST_MENU_LOAD_SETTINGS		0x0002

#define		STR_THEME_FILE_EXT					ANALYSIS_THEME_FILE_EXT
BOOL	DigitizerInfoList::ShowMenu(int nx, int ny)
{
	int		nRow, nCol;
	GetMouseCell(nRow, nCol);
	if ( nRow < 0 )
		return FALSE;

	Menu	myMenu;
	myMenu.Add(_L("Save Axes Settings..."), ID_INFOLIST_MENU_SAVE_SETTINGS);
	myMenu.Add(_L("Load Axes Settings..."), ID_INFOLIST_MENU_LOAD_SETTINGS);

	int		nCmd = 0;
	HWND	hWnd = m_pImpl->GetHwnd();
	myMenu.TrackPopupMenu(0, nx, ny, hWnd, &nCmd);
	switch ( nCmd )
	{
	case ID_INFOLIST_MENU_SAVE_SETTINGS:
	case ID_INFOLIST_MENU_LOAD_SETTINGS:
		{
			BOOL			bSave = ID_INFOLIST_MENU_SAVE_SETTINGS == nCmd;

			string			strFileName;
			vector<string>	vsFileTypes(1);
			vsFileTypes[0] = "[Axes Settings File(*." STR_THEME_FILE_EXT ")]*." STR_THEME_FILE_EXT;
			if ( !okutil_FileDialog(&strFileName, bSave, &vsFileTypes, okutil_get_origin_path(ORIGIN_PATH_USER), 0, hWnd) )
				return FALSE;

			Tree	tr;
			if ( bSave )
			{
				m_pImpl->SaveAxesSettings(tr);
				tr.Save(strFileName);
			}
			else
			{
				tr.Load(strFileName);
				m_pImpl->LoadAxesSettings(tr);
			}
		}
		break;
	}

	return TRUE;
}

BOOL	DigitizerInfoList::OnSetAxisColor(IMPLDATA type)
{
	SelectRow(0, IsAxesEditing(), INFOLISTCOL_SCALETYPE);

	HWND	hWnd = GetFocus();
	if ( m_pImpl->SetAxisColor(type) )
		Update();
	
	return SetFocus(hWnd);
}

int		DigitizerInfoList::GetHeight()
{
	return YTwipsToPixels(GetRowHeight(0) * 1.05 * (INFOLISTROW_TOTAL - m_pImpl->IsX1FromYAxis() - m_pImpl->IsY1FromXAxis() + 0.2));
}

//private:
void	DigitizerInfoList::UpdateNames()
{
	vector<string>	vs;
	m_pImpl->GetInfoNames(vs);
	SetCells(vs, INFOLISTCOL_NAME);
}

void	DigitizerInfoList::UpdateColors()
{
	vector<uint>	vn;
	m_pImpl->GetInfoColors(vn);

	FillColumnBkColor(INFOLISTCOL_COLOR, vn);
	int		nSelectedRow = GetSelectedRow();
	if ( nSelectedRow >= INFOLISTROW_OFFSET )
		UpdateColorCol(nSelectedRow);
}

void	DigitizerInfoList::UpdateScales()
{
	vector<string>	vs;
	m_pImpl->GetInfoScales(vs);
	SetCells(vs, INFOLISTCOL_SCALE);
}

void	DigitizerInfoList::UpdatePixels()
{
	vector<string>	vs;
	m_pImpl->GetInfoPixels(vs);
	SetCells(vs, INFOLISTCOL_PIXEL);
}

void	DigitizerInfoList::InitScaleTypes()
{
	vector<string>	vs;
	vs.Add(_L("Linear"));
	vs.Add(_L("Log10"));
	
	vector<string>	vsLists(vs.GetSize());
	for ( int ii=0; ii<vs.GetSize(); ++ii )
	{
		vsLists[ii].Format("#%d;%s", ii, vs[ii]);
	}

	string		strCombo;
	strCombo.SetTokens(vsLists, '|');
	SetColComboList(INFOLISTCOL_SCALETYPE, strCombo);
}

void	DigitizerInfoList::UpdateScaleTypes()
{
	vector<string>	vs;
	m_pImpl->GetInfoScaleTypes(vs);
	SetCells(vs, INFOLISTCOL_SCALETYPE);
}

#define		EMPTY_CELL_COMBO(_row)		SetCellComboList(_row, INFOLISTCOL_SCALETYPE, "")
void	DigitizerInfoList::SetupScaleTypeNoCombo()
{
	++m_nDuringUpdate;

	EMPTY_CELL_COMBO(INFOLISTROW_X2);
	EMPTY_CELL_COMBO(INFOLISTROW_Y2);
	EMPTY_CELL_COMBO(INFOLISTROW_XREF);
	EMPTY_CELL_COMBO(INFOLISTROW_YREF);

	--m_nDuringUpdate;
}

void	DigitizerInfoList::SelectRow(int nRow, BOOL bUpdate/* = TRUE*/, int nCol/* = -1*/)
{
	int		nRowSelected = GetSelectedRow();
	if ( nRow == nRowSelected )
		return;
	
	++m_nDuringUpdate;
	if ( nCol >= 0 )
		SelCell(nRow, nCol);
	else
		SelRow(nRow);
	if ( bUpdate )
		UpdateAfterSelect(nRow, nRowSelected);
	--m_nDuringUpdate;
}

void	DigitizerInfoList::UpdateX0Y0()
{
	string		x, y;
	m_pImpl->GetX0Y0(x, y);
	SetCell(INFOLISTROW_XREF, INFOLISTCOL_SCALE, x);
	SetCell(INFOLISTROW_YREF, INFOLISTCOL_SCALE, y);
}

BOOL	DigitizerInfoList::UpdateSelection()
{
	IMPLDATA	type = m_pImpl->GetAxisSelection();
	SelectRow(IMPLDATA_INVALID == type ? 0 : type + INFOLISTROW_OFFSET);
	return TRUE;
}

BOOL	DigitizerInfoList::CheckShowRows(BOOL bShow)
{
	vector<bool>	vbShow(INFOLISTROW_TOTAL - INFOLISTROW_OFFSET);
	vbShow = bShow;

	BOOL	bValidToDigitize = m_pImpl->HasValidDigitizeImage();
	vbShow[INFOLISTROW_XREF - INFOLISTROW_OFFSET] = bValidToDigitize && !m_pImpl->IsX1FromYAxis();
	vbShow[INFOLISTROW_YREF - INFOLISTROW_OFFSET] = bValidToDigitize && !m_pImpl->IsY1FromXAxis();
	
	return ShowRows(vbShow);
}

BOOL	DigitizerInfoList::IsDuringUpdate()
{
	return m_nDuringUpdate != 0;
}

BOOL	DigitizerInfoList::IsAxesEditing()
{
	return m_pImpl->IsAxesEditing();
}

void	DigitizerInfoList::FillColumnBkColor(int nCol, vector<uint>& vnColors)
{
	SetCellColor(INFOLISTROW_X1, nCol, 0, vnColors[IMPLDATA_X1]);
	SetCellColor(INFOLISTROW_X2, nCol, 0, vnColors[IMPLDATA_X2]);
	SetCellColor(INFOLISTROW_Y1, nCol, 0, vnColors[IMPLDATA_Y1]);
	SetCellColor(INFOLISTROW_Y2, nCol, 0, vnColors[IMPLDATA_Y2]);
	SetCellColor(INFOLISTROW_XREF, nCol, 0, vnColors[IMPLDATA_XREF]);
	SetCellColor(INFOLISTROW_YREF, nCol, 0, vnColors[IMPLDATA_YREF]);
}

void	DigitizerInfoList::SetColumnForeColor(int nCol, vector<uint>& vnColors)
{
	SetCellColor(INFOLISTROW_X1, nCol, vnColors[IMPLDATA_X1]);
	SetCellColor(INFOLISTROW_X2, nCol, vnColors[IMPLDATA_X2]);
	SetCellColor(INFOLISTROW_Y1, nCol, vnColors[IMPLDATA_Y1]);
	SetCellColor(INFOLISTROW_Y2, nCol, vnColors[IMPLDATA_Y2]);
	SetCellColor(INFOLISTROW_XREF, nCol, vnColors[IMPLDATA_XREF]);
	SetCellColor(INFOLISTROW_YREF, nCol, vnColors[IMPLDATA_YREF]);
}

#define		CHECK_UPDATE_PIXEL_FORECOLOR(_TYPE) \
			if ( m_pImpl->IsCoorReady(_TYPE) ) \
				vnColors[_TYPE] = COLOR_BLACK

BOOL	DigitizerInfoList::UpdateCellsColor()
{
	vector<uint>	vnColors(IMPLDATA_TOTAL);
	uint			nGray = color_index_to_rgb(SYSCOLOR_GRAY);
	vnColors = nGray;

	SetColumnForeColor(INFOLISTCOL_NAME, vnColors);

	SetCellColor(INFOLISTROW_XREF, INFOLISTCOL_SCALE, nGray);
	SetCellColor(INFOLISTROW_YREF, INFOLISTCOL_SCALE, nGray);

	if ( IsAxesEditing() )
	{
		CHECK_UPDATE_PIXEL_FORECOLOR(IMPLDATA_X1);
		CHECK_UPDATE_PIXEL_FORECOLOR(IMPLDATA_X2);
		CHECK_UPDATE_PIXEL_FORECOLOR(IMPLDATA_Y1);
		CHECK_UPDATE_PIXEL_FORECOLOR(IMPLDATA_Y2);
		CHECK_UPDATE_PIXEL_FORECOLOR(IMPLDATA_XREF);
		CHECK_UPDATE_PIXEL_FORECOLOR(IMPLDATA_YREF);
	}
	SetColumnForeColor(INFOLISTCOL_PIXEL, vnColors);
	return TRUE;
}

void	DigitizerInfoList::UpdateAfterSelect(int nRowNew, int nRowOld)
{
	if ( nRowOld >= INFOLISTROW_OFFSET )
	{
		UpdateColorCol(nRowOld);
	}
	if ( nRowNew >= INFOLISTROW_OFFSET )
	{
		UpdateColorCol(nRowNew);
	}
}

void	DigitizerInfoList::UpdateColorCol(int nRow)
{
	uint	color;
	GetCellColor(nRow, INFOLISTCOL_COLOR, NULL, &color);
	SetCellColor(nRow, INFOLISTCOL_COLOR, 0, go_color_no_reverse_video(color));
}

void	DigitizerInfoList::UpdateRows()
{
	SetRows(INFOLISTROW_TOTAL, false);
	SetupScaleTypeNoCombo();
	
	const	int		nRowHeight = 300;
	for ( int row=INFOLISTROW_OFFSET; row<INFOLISTROW_TOTAL; ++row )
	{
		SetRowHeight(row, nRowHeight);
	}
}

void	DigitizerInfoList::SetAxisColor(IMPLDATA type)
{
	if ( g_pDigitizer )
		g_pDigitizer->PostMessage(ID_DIGITIZER_MSG_SET_AXIS_COLOR, (DWORD)type);
}

void	DigitizerInfoList::CheckEnableDigitize()
{
	if ( g_pDigitizer )
		g_pDigitizer->SendMessage(ID_DIGITIZER_MSG_CHECK_ENABLE_DIGITIZE);
}

/*------------------------------------------------------------------------------*
* DigitizerInfoList End															*
*------------------------------------------------------------------------------*/

/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
#define		STR_LINEINFO_LIST_COL_HEADING			_L("Line|Number of Points|Color|Show")

enum
{
	LINEINFO_COL_INDEX,
	LINEINFO_COL_POINTS,
	LINEINFO_COL_COLOR,
	LINEINFO_COL_SHOW
};

DigitizerLineInfoList::DigitizerLineInfoList(DigitizerImpl* pImpl)
{
	m_pImpl = pImpl;
}

DigitizerLineInfoList::~DigitizerLineInfoList()
{
}

void DigitizerLineInfoList::Init(int nID, Dialog& dlg)
{
	GridListControl::Init(nID, dlg);
	
	SetupRowsCols();	
	SetExtendLastCol(false);
	SetEditable(flexEDKbdMouse);
	SetAlternateRowColors();
	m_flx.SelectionMode = flexSelectionListBox;	
	SetColHeader(STR_LINEINFO_LIST_COL_HEADING);
	SetColAlignment(-1, flexAlignCenterCenter);		
	SetColDataType(LINEINFO_COL_SHOW, flexDTBoolean); // display as checkbox	
	
	int nActiveData = m_pImpl->GetActiveData();
	UpdateRows(nActiveData, false);	
	ResizeCols();
	
	SetReady(true);
}
	
bool DigitizerLineInfoList::UpdateRows(int nLine, bool bAllowRowSelEvent) // -1
{
	CurveInfo stInfo;
	/// Iris 01/18/2012 ORG-4894-P1 FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
	//m_pImpl->GetCurveInfo(stInfo);
	if( !m_pImpl->GetCurveInfo(stInfo) )
		return false;
	///End FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
	
	vector<string> vsTableText;
	int nNumCurve = stInfo.vsDataPoints.GetSize();
	for(int index = 0; index < nNumCurve; index++)
	{
		vsTableText.Add( index+1 );
		vsTableText.Add( stInfo.vsDataPoints[index] );
		vsTableText.Add( stInfo.vsColor[index] );
		vsTableText.Add( stInfo.vsShow[index] );
	}
		
	if( !bAllowRowSelEvent )
		SetReadyFlag(false); // Iris: to avoid enter data plot selection event
	
	int nOldSel = GetSelectedRow();
	ClearAll();
	
	if( nNumCurve > 0 )
	{
		if( GetNumRows() != nNumCurve )
			SetRows(nNumCurve);
		m_flx.SetTableValue(&vsTableText, nNumCurve, m_flx.Cols, m_flx.FixedRows, m_flx.FixedCols, true);
		
		if( nLine >= 0 )
			SelRow(nLine + GetRowOffset());
		else
			SelRow(nOldSel);		
	}
	
	if( !bAllowRowSelEvent )
		SetReadyFlag(true); // Iris: to avoid enter data plot selection event
	return true;	
}
///End DIGITIZER_SUPPORT_MAGNIFIER

/// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
void DigitizerLineInfoList::OnBeforeEdit(int nRow, int nCol, BOOL* pCancel)
{	
	if( LINEINFO_COL_SHOW != nCol )
		*pCancel = true;
}
///End IMPROVE_MULTIPLE_CURVES

//class	DynamicResizeHelper
//{
//public:
	//DynamicResizeHelper(BOOL bResizeBefore, Digitizer& digitizer)
	//{
		//m_bResizeBefore = bResizeBefore;
		//m_pDigitizer = &digitizer;
		//if ( m_bResizeBefore )
			//m_pDigitizer->Resize();
	//}
	//~DynamicResizeHelper()
	//{
		//if ( !m_bResizeBefore )
			//m_pDigitizer->Resize();
	//}
	//
//private:
	//BOOL		m_bResizeBefore;
	//Digitizer*	m_pDigitizer;
//};

/*------------------------------------------------------------------------------*
 * OldDigitizer 		 														*
 *------------------------------------------------------------------------------*/
//#define		BASE_WINDOW		MultiPaneDlg
//#include "dynadlg.h"
//class	Digitizer : public DynaDlg
//{	
//public:
	//Digitizer() : DynaDlg(IDD_DIGITIZER, NULL, "ODlg8")
	//{
		//m_pInfo = new DigitizerInfoList(&m_Impl);
	//}
	//~Digitizer()
	//{
		//NICE_SAFE_REMOVAL(m_pInfo);
	//}
	//
	//BOOL	Create(HWND hWndParent = NULL)
	//{
		//InitMsgMap();		
		//BOOL	bReturn = DynaDlg::Create(hWndParent, 0);
		//Visible = TRUE;
		//return TRUE;
	//}
	//
	//BOOL	Resize()
	//{
		//int		nGap = GetControlGap();
//
		//RECT	rrShowBottom;
		//GetControlClientRect(IDC_SHOW_BOTTOM, rrShowBottom);
//
		//RECT	rrInfoHint;
		//GetControlClientRect(IDC_DIGITIZER_INFO_HINT, rrInfoHint);
//
		//RECT	rrInfoList;
		//GetControlClientRect(IDC_DIGITIZER_INFO, rrInfoList);
		//rrInfoList.bottom = rrInfoList.top + m_pInfo->GetHeight();
		//m_pInfo->MoveWindow(rrInfoList);
//
		//RECT	rrHint;
		//GetClientRect(m_ctrlHint, rrHint);
		//int		nHeight = GetHintHeight(RECT_WIDTH(rrHint));
		//if ( nHeight > 0 )
			//rrHint.bottom = rrHint.top + nHeight;
		//
		//nHeight = RECT_HEIGHT(rrHint);
		//rrHint.top = rrInfoList.bottom + nGap;
		//rrHint.bottom = rrHint.top + nHeight;
		//MoveControl(m_ctrlHint, rrHint);
		//MoveControl(TREE_CTRL_VAR, rrHint);
		//
		//nHeight = 0;
		//if ( IsBottomPaneShown() )
		//{
			//nHeight = RECT_HEIGHT(rrInfoHint) + nGap + RECT_HEIGHT(rrInfoList) + nGap + RECT_HEIGHT(rrHint) + 3 * nGap;
		//}
		//
		//RECT	rr;
		//m_wndDlg.GetWindowRect(&rr);
		//m_wndDlg.ClientToScreen(&rrShowBottom);
		//rr.bottom = rrShowBottom.bottom + nGap + nHeight;
//
		//m_wndDlg.MoveWindow(&rr);
		//return TRUE;
	//}
//
	//int		GetHintHeight(int nWidth)
	//{
		//if ( !m_Impl.HasValidDigitizeImage() )
			//return -1;
		//
		//if ( m_Impl.IsRotationMode() )
		//{
			//SIZE	sz;
			//TREE_CTRL_VAR.GetOptimalSize(sz);
			//return sz.cy;
		//}
//
		//string		str = m_Impl.GetHint();
		//return m_ctrlHint.Measure(str, &nWidth) + GetControlGap();
	//}
//
//protected:
//
//EVENTS_BEGIN
	//ON_INIT(OnInitDialog) 
	//ON_DESTROY(OnDestroy)
	//
	//ON_BN_CLICKED(IDC_DIGITIZER_IMPORT, OnImportImage)
	//ON_BN_CLICKED(IDC_DIGITIZER_ROTATE, OnRotate)
	//ON_BN_CLICKED(IDC_DIGITIZER_ADJUST_SCALE, OnOptionsChange)
	//ON_BN_CLICKED(IDC_DIGITIZER_GO, OnDigitize)
	//ON_BN_CLICKED(IDC_DIGITIZER_EDIT, OnToggleAxesEdit)
	/////------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	//ON_BN_CLICKED(IDC_DIGITIZER_SET_LABEL, OnToggleLabelEdit)
	/////------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	//ON_BN_CLICKED(IDC_DIGITIZER_SHOW_XREF, OnShowXRefLine)
	//ON_BN_CLICKED(IDC_DIGITIZER_SHOW_YREF, OnShowYRefLine)
	//ON_BN_CLICKED(IDC_DIGITIZER_RESET, OnNewData)
	//ON_BN_CLICKED(IDC_DIGITIZER_GO_TO_DATA, OnGotoData)
	//ON_BN_CLICKED(IDC_DIGITIZER_GO_TO_GRAPH, OnGotoGraph)
	//ON_BN_CLICKED(IDC_DIGITIZER_REMOVE_WKS_GRAPH, OnDelWksGraph)
	//ON_BN_CLICKED(IDC_DIGITIZER_GO_TO_IMAGE, OnGotoImage)
	//ON_BN_CLICKED(IDC_SHOW_BOTTOM, OnShowBottomPane)
//
	//ON_GRID_BEFORE_EDIT(IDC_DIGITIZER_INFO, OnBeforeEditInfo)
	//ON_GRID_AFTER_EDIT(IDC_DIGITIZER_INFO, OnAfterEditInfo)
	//ON_GRID_AFTER_SEL_CHANGE(IDC_DIGITIZER_INFO, OnAfterInfoSelectionChange)
	//ON_GRID_MOUSE_MOVE(IDC_DIGITIZER_INFO, OnMouseMoveOnInfo)
//
	//ON_CONTEXTMENU(OnShowMenu)
//
	/////------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	//ON_MARKEROBJ_EDIT(OnDataPlotEdit)
	/////------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
//
	/////------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	//ON_OBJECT_MODIFY(OnOriginModify)
	/////------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
//
	/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	//ON_GETNDLG_MSGS(IDC_DIGITIZER_DYNA)
	/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
//
	//ON_USER_MSG(ID_DIGITIZER_MSG_UPDATE_INFO, OnUpdateInfo)
	//ON_USER_MSG(ID_DIGITIZER_MSG_UPDATE_INFO_SELECTION, OnUpdateInfoSelection)
	//ON_USER_MSG(ID_DIGITIZER_MSG_ENABLE_DIGITIZE, OnEnableDigitize)
	//ON_USER_MSG(ID_DIGITIZER_MSG_SET_AXIS_COLOR, OnSetAxisColor)
	//ON_USER_MSG(ID_DIGITIZER_MSG_UPDATE_FROM_POINTS, OnUpdateFromPlot)
	/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	//ON_USER_MSG(ID_DIGITIZER_MSG_UPDATE_DYNACTRL, OnUpdateDynaCtrl)
	/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	//ON_USER_MSG(ID_DIGITIZER_MSG_SAVE_SETTINGS, OnSaveSettings)
	//ON_USER_MSG(ID_DIGITIZER_MSG_CHECK_ENABLE_DIGITIZE, OnCheckEnableDigitize)
//EVENTS_END
//
	//BOOL	OnInitDialog()
	//{
		//vector<string>  vsUpDownTips;
		//GetUpDownTips(vsUpDownTips);
		//if ( !DynaDlg::OnInitDialog(0, IDC_SHOW_BOTTOM, IDC_DIGITIZER_INFO, vsUpDownTips, STR_DLG_NAME) )
			//return FALSE;
		//
		/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
		//m_ctrlHint = GetItem(IDC_DIGITIZER_HINT);
		//m_Impl.SetHwnd(GetSafeHwnd());
		//
		//InitDynaControl(IDC_DIGITIZER_DYNA);
		/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
		//CheckUpdateOnDlgShow(TRUE);
		//m_pInfo->Init(IDC_DIGITIZER_INFO, *this);
		//return InitRadioBitmapButtons()
			//&& UpdateStates()
			//&& Resize();
	//}
//
	//BOOL	OnDestroy()
	//{
		//DynaDlg::OnDestroy();
//
		//CheckUpdateOnDlgShow(FALSE);
		//NICE_SAFE_REMOVAL(g_pDigitizer);
		//return TRUE;
	//}
//
	//BOOL	OnImportImage(Control ctrl)
	//{
		//return m_Impl.ImportImage() && UpdateStates();
	//}
//
	//BOOL	OnOptionsChange(Control ctrl)
	//{
		//return m_Impl.ChangeOptions() && CheckEnableDigitize() && CheckEnableGotoData() && UpdateInfo();
	//}
//
	//#define		ON_BUTTON_PRESSED(_bPressedDown) \
				//BitmapRadioButton	btn = ctrl; \
				//BOOL				_bPressedDown = btn.PressedDown; \
				//btn.PressedDown = !_bPressedDown
//
	/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	//BOOL	OnRotate(Control ctrl)
	//{
		//ON_BUTTON_PRESSED(bPressedDown);
		//if ( !bPressedDown && !IsBottomPaneShown() )
			//ShowBottomPane(TRUE);
		//return m_Impl.SetRotationMode(!bPressedDown) && UpdateStates();
	//}
	/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
//
	//BOOL	OnToggleAxesEdit(Control ctrl)
	//{
		//ON_BUTTON_PRESSED(bPressedDown);
		//m_Impl.SetAxesEditing(!bPressedDown);
		//return UpdateHint() && UpdateInfoSelectable(TRUE);
	//}
//
	//BOOL	OnShowXRefLine(Control ctrl)
	//{
		//ON_BUTTON_PRESSED(bPressedDown);
		//m_Impl.ShowXRefLine(!bPressedDown);
		//DynamicResizeHelper	clHelper(!bPressedDown, *this);
		//return UpdateInfo();
	//}
//
	//BOOL	OnShowYRefLine(Control ctrl)
	//{
		//ON_BUTTON_PRESSED(bPressedDown);
		//m_Impl.ShowYRefLine(!bPressedDown);
		//DynamicResizeHelper	clHelper(!bPressedDown, *this);
		//return UpdateInfo();
	//}
//
	/////------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	//BOOL	OnToggleLabelEdit(Control ctrl)
	//{
		//ON_BUTTON_PRESSED(bPressedDown);
		//return m_Impl.SetLabelEditing(!bPressedDown) && UpdateHint() && UpdateStates();
	//}
	/////------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
//
	//BOOL	OnDigitize(Control ctrl)
	//{
		//if ( m_Impl.IsAxesEditing() )
		//{
			//m_Impl.SetAxesEditing(FALSE);
			//UpdateAxesEditing();
		//}
		//return m_Impl.Digitize() && CheckEnableDigitize() && UpdateHint();
	//}
//
	//BOOL	OnNewData(Control ctrl)
	//{
		//return m_Impl.NewData() && UpdateStates();
	//}
//
	//BOOL	OnGotoData(Control ctrl)
	//{
		//return m_Impl.GotoData();
	//}
//
	//BOOL	OnGotoGraph(Control ctrl)
	//{
		//return m_Impl.GotoGraph();
	//}
//
	//BOOL	OnDelWksGraph(Control ctrl)
	//{
		//return m_Impl.DelWksGraph() && UpdateStates();
	//}
//
	//BOOL	OnGotoImage(Control ctrl)
	//{
		//if ( m_glImage )
			//return m_glImage.CheckShowActivate();
//
		//return FALSE;
	//}
//
	//BOOL	OnShowBottomPane(Control ctrl)
	//{
		//DynaDlg::OnShowBottomPane(ctrl);
		//return Resize();
	//}
//
	//virtual	BOOL	OnChangePage()
	//{
		//return UpdateStates() && DynaDlg::OnChangePage();
	//}
//
	/////------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	//BOOL	OnDataPlotEdit(GraphObject go, int nIndex)
	//{
		//return m_Impl.DataPlotEdit(nIndex);
	//}
	/////------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
//
	/////------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	//BOOL	OnOriginModify(OriginObject obj, int nKind)
	//{
		//DatasetObject dsObj;
		//dsObj = obj;
		//if ( !dsObj )
			//return FALSE;
		//
		//return m_Impl.UpdatePlotFromOutput(dsObj, m_glImage);
	//}
	/////------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
//
	//BOOL	OnUpdateInfo(WPARAM wParam, LPARAM lParam)
	//{
		//return UpdateInfo();
	//}
//
	//BOOL	OnUpdateInfoSelection(WPARAM wParam, LPARAM lParam)
	//{
		//return UpdateInfo(INFOLISTUPDATE_SELECTION_ONLY);
	//}
//
	//BOOL	OnEnableDigitize(WPARAM wParam, LPARAM lParam)
	//{
		//return CheckEnableDigitize();
	//}
//
	//BOOL	OnSetAxisColor(WPARAM wParam, LPARAM lParam)
	//{
		//return m_pInfo->OnSetAxisColor(wParam);
	//}
//
	//BOOL	OnUpdateFromPlot(WPARAM wParam, LPARAM lParam)
	//{
		//return m_Impl.UpdateFromPlot(wParam);
	//}
//
	/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	//BOOL	OnUpdateDynaCtrl(WPARAM wParam, LPARAM lParam)
	//{
		//BOOL	bOn = lParam;
		//TREE_CTRL_VAR.Visible = bOn;
		//m_ctrlHint.Visible = !bOn;
//
		//if ( !bOn )
			//return TRUE;
		//
		//TreeNode*	ptr = (TreeNode*)wParam;
		//SetInputTree(*ptr);
		//
		//TREE_CTRL_VAR.SendMessage(WM_REDRAW, FALSE);
		//return UpdateDynaControl(true, GETNEVENT_ON_INIT, true, 0, true) && TREE_CTRL_VAR.SendMessage(WM_REDRAW, TRUE);
	//}
	/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
//
	//BOOL	OnSaveSettings(WPARAM wParam, LPARAM lParam)
	//{
		//return m_Impl.Save();
	//}
	//
	//BOOL	OnCheckEnableDigitize(WPARAM wParam, LPARAM lParam)
	//{
		//return CheckEnableDigitize();
	//}
//
	//void	OnBeforeEditInfo(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	//{
		//m_pInfo->OnBeforeEdit(nRow, nCol, pCancel);
	//}
	//
	//void	OnAfterEditInfo(Control flxControl, int nRow, int nCol)
	//{
		//m_pInfo->OnAfterEdit(nRow, nCol);
	//}
//
	//void 	OnAfterInfoSelectionChange(Control cntrl, int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel)
	//{
		//m_pInfo->OnAfterSelectionChange(nOldRowSel, nOldColSel, nNewRowSel, nNewColSel);
	//}
//
	//void	OnMouseMoveOnInfo(Control cntrl, short nButton, short nShift, float X, float Y)
	//{
		//m_pInfo->OnMouseMove(nButton, nShift, X, Y);
	//}
//
	//BOOL	OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	//{
		//return m_pInfo->ShowMenu(nx, ny);
	//}
//
//private:
	//BOOL	InitRadioBitmapButtons()
	//{
		//vector<int>		vnBtnIDs = { IDC_DIGITIZER_IMPORT
			//, IDC_DIGITIZER_ROTATE
			//, IDC_DIGITIZER_ADJUST_SCALE
			//, IDC_DIGITIZER_EDIT
			//, IDC_DIGITIZER_SHOW_XREF
			//, IDC_DIGITIZER_SHOW_YREF
			//, IDC_DIGITIZER_GO
			//, IDC_DIGITIZER_RESET
			//, IDC_DIGITIZER_GO_TO_DATA
			//, IDC_DIGITIZER_GO_TO_GRAPH
			//, IDC_DIGITIZER_REMOVE_WKS_GRAPH
			//, IDC_DIGITIZER_GO_TO_IMAGE
			/////------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
			//, IDC_DIGITIZER_SET_LABEL
			/////------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		//};
//
		//vector<int>		vnBmpIDs = { IDB_IMPORT_IMAGE
			//, IDB_ROTATE
			//, IDB_ADJUST_SCALE
			//, IDB_AXES_EDIT
			//, IDB_SHOW_XREF
			//, IDB_SHOW_YREF
			//, IDB_DIGITIZE
			//, IDB_RESET_POINTS
			//, IDB_GOTO_DATA
			//, IDB_GOTO_GRAPH
			//, IDB_DEL_WKS_GRAPH
			//, IDB_GOTO_IMAGE
			/////------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
			//, IDB_SET_LABEL
			/////------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		//};
//
		//vector<string>	vsTips;
		//vsTips.Add(_L("Import"));
		//vsTips.Add(STR_ROTATE_IMAGE);
		//vsTips.Add(STR_OPTION);
		//vsTips.Add(_L("Edit Axes"));
		//vsTips.Add(_L("Show X Reference Line"));
		//vsTips.Add(_L("Show Y Reference Line"));
		//vsTips.Add(_L("Pick New Points"));
		//vsTips.Add(_L("Start New Data"));
		//vsTips.Add(_L("Go to Data"));
		//vsTips.Add(_L("Go to Graph"));
		//vsTips.Add(_L("Delete Worksheet/Graph"));
		//vsTips.Add(_L("Go to Image"));
		/////------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		//vsTips.Add(_L("Set Label"));
		/////------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
//
		//int		nSize = vnBtnIDs.GetSize();
		//O_A(nSize == vnBmpIDs.GetSize());
		//O_A(nSize == vsTips.GetSize());
		//for ( int ii=0; ii<nSize; ++ii )
		//{
			//vector<string>	vs;
			//vs.Add(vsTips[ii]);
			//InitRadioBitmapButton(vnBtnIDs[ii], vnBmpIDs[ii], 1, &vs);
		//}
		//return TRUE;
	//}
//
	//BOOL	UpdateAxesEditing()
	//{
		//BitmapRadioButton	btn = GetItem(IDC_DIGITIZER_EDIT);
		//btn.PressedDown = m_Impl.IsAxesEditing();
		//return UpdateInfoSelectable();
	//}
//
	/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	//BOOL	UpdateRotationMode()
	//{
		//BitmapRadioButton	btn = GetItem(IDC_DIGITIZER_ROTATE);
		//btn.PressedDown = m_Impl.IsRotationMode();
		//return m_Impl.Rotate(btn.PressedDown);
	//}
	/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
//
	/////------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	//BOOL	UpdateLabelEditing()
	//{
		//BitmapRadioButton	btn = GetItem(IDC_DIGITIZER_SET_LABEL);
		//btn.PressedDown = m_Impl.IsLabelEditing();
		//return TRUE;
	//}
	/////------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
//
	//BOOL	UpdateShowXYRefLine()
	//{
		//BitmapRadioButton	btnShowXRef = GetItem(IDC_DIGITIZER_SHOW_XREF);
		//BitmapRadioButton	btnShowYRef = GetItem(IDC_DIGITIZER_SHOW_YREF);
		//btnShowXRef.PressedDown = !m_Impl.IsX1FromYAxis();
		//btnShowYRef.PressedDown = !m_Impl.IsY1FromXAxis();
		//return TRUE;
	//}
//
	//BOOL	UpdateHint()
	//{
		//m_ctrlHint.Text = m_Impl.GetHint();
		//return Resize();
	//}
//
	//BOOL	UpdateInfo(DWORD dwCntrls = 0)
	//{
		//return m_pInfo->Update(dwCntrls);
	//}
//
	//BOOL	UpdateInfoSelectable(BOOL bResetRowSelection = FALSE)
	//{
		//return m_pInfo->UpdateSelectable(bResetRowSelection);
	//}
	//
	//BOOL	UpdateStates()
	//{
		//BOOL	bValid = m_Impl.HasValidDigitizeImage();
		/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
		//TREE_CTRL_VAR.Visible = bValid;
		//m_ctrlHint.Visible = TRUE;
		/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
//
		//if ( bValid )
		//{
			//m_Impl.Update(TRUE);
			/////------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
			//UpdateRotationMode();
			/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
			//UpdateAxesEditing();
			//UpdateShowXYRefLine();
			/////------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
			//UpdateLabelEditing();
			/////------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
//
			//m_glImage = m_Impl.GetDigitizeLayer();
		//}
//
		//UpdateHint();
		//UpdateInfo(INFOLISTUPDATE_RESET_ROWS);
//
		//vector<int>		vnCntrlIDs = { IDC_DIGITIZER_ADJUST_SCALE
			//, IDC_DIGITIZER_EDIT
			//, IDC_DIGITIZER_SHOW_XREF
			//, IDC_DIGITIZER_SHOW_YREF
		//};
		//BOOL	bEnable = IsButtonsEnable();
		//for ( int ii=0; ii<vnCntrlIDs.GetSize(); ++ii )
		//{
			//GetItem(vnCntrlIDs[ii]).Enable = bEnable;
		//}
//
		//return UpdateDlgTitle()
			//&& CheckEnableDigitize()
			//&& CheckEnableGotoImage()
			/////------ Folger 12/30/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
			//&& CheckEnableRotation()
			/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
			//&& CheckEnableGotoData()
			//;
	//}
//
	//BOOL	CheckEnableDigitize()
	//{
		//BOOL	bReadyToDigitize = m_Impl.HasValidDigitizeImage() && m_Impl.IsReadyToDigitize() && IsButtonsEnable();
		//GetItem(IDC_DIGITIZER_GO).Enable = bReadyToDigitize;
		//GetItem(IDC_DIGITIZER_RESET).Enable = bReadyToDigitize && m_Impl.HasDataPoint();
		//
		/////------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		//GetItem(IDC_DIGITIZER_SET_LABEL).Enable = m_Impl.HasValidDigitizeImage() && !m_Impl.IsRotationMode() && m_Impl.HasDataPoint();
		/////------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		//return TRUE;
	//}
//
	//BOOL	CheckEnableGotoImage()
	//{
		//GetItem(IDC_DIGITIZER_GO_TO_IMAGE).Enable = m_glImage && !m_Impl.HasValidDigitizeImage();
		//return TRUE;
	//}
//
	//BOOL	CheckEnableGotoData()
	//{
		//GetItem(IDC_DIGITIZER_GO_TO_DATA).Enable = GetItem(IDC_DIGITIZER_GO_TO_GRAPH).Enable = GetItem(IDC_DIGITIZER_REMOVE_WKS_GRAPH).Enable = !m_Impl.GetDataName().IsEmpty() && IsButtonsEnable();
		//return TRUE;
	//}
//
	//void	GetUpDownTips(vector<string>& vs)
	//{
		//vs.SetSize(2);
		//vs[0] = _L("Show");
		//vs[1] = _L("Hide");
	//}
//
	//BOOL	UpdateDlgTitle()
	//{
		//Text = m_Impl.HasValidDigitizeImage() ? m_Impl.GetTitle() : STR_DLG_NAME_L;
		//return TRUE;
	//}
//
	//BOOL	CheckUpdateOnDlgShow(BOOL bShow)
	//{
		//return m_Impl.CheckUpdateOnDlgShow(bShow);
	//}
//
	/////------ Folger 12/30/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	//BOOL	CheckEnableRotation()
	//{
		//GetItem(IDC_DIGITIZER_ROTATE).Enable = m_Impl.HasValidDigitizeImage() && !m_Impl.IsLabelEditing();
		//return TRUE;
	//}
	/////------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
//
	/////------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	//BOOL		IsButtonsEnable()
	//{
		//return m_Impl.HasValidDigitizeImage() && !m_Impl.IsRotationMode() && !m_Impl.IsLabelEditing();
	//}
	/////------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
//
	//virtual void  resizeDlgToFit(int cx = 0, int cy = 0)
	//{
		//Resize();
	//}
//
//private:
	//DigitizerImpl		m_Impl;
	//DigitizerInfoList*	m_pInfo;
//
	//GraphLayer			m_glImage;
	//Control				m_ctrlHint;
//};
/*------------------------------------------------------------------------------*
 * OldDigitizer End		 														*
 *------------------------------------------------------------------------------*/
 
/*------------------------------------------------------------------------------*
* XYAxesInfoDlg																	*
//*------------------------------------------------------------------------------*/
 BOOL	XYAxesInfoDlg::Create(HWND hWndParent, bool bVisible)
 {
 	InitMsgMap();		
	BOOL	bReturn = Dialog::Create(hWndParent, 0);	
	Visible = bVisible;
	return TRUE;	
 }
 
//virtual 
BOOL XYAxesInfoDlg::OnInitDialog()
{
	m_pInfo->Init(IDC_DIGITIZER_INFO, *this);
	return TRUE;
}

//virtual 
bool XYAxesInfoDlg::OnDlgResize(int nType, int cx, int cy)
{
	const int nGap = 4;
	RECT rrInfo;
	rrInfo.left = nGap;
	rrInfo.top = nGap;
	rrInfo.bottom = cy;
	rrInfo.right = cx;	
	
	Control ccInfo = GetItem(IDC_DIGITIZER_INFO);	
	ccInfo.MoveWindow(&rrInfo);
	return true;
}

//virtual 
BOOL XYAxesInfoDlg::Update(DWORD dwCntrls)
{
	return m_pInfo->Update(dwCntrls);
}

//virtual 
BOOL XYAxesInfoDlg::UpdateGridSelectable(bool bResetRowSelection)
{
	return m_pInfo->UpdateSelectable(bResetRowSelection);
}

//virtual 
BOOL 	XYAxesInfoDlg::OnBeforeTabChange(int nOldType)
{
	m_pImpl->ShowAxes(false);
	return TRUE;
}

//virtual 
BOOL 	XYAxesInfoDlg::OnAfterTabChange()
{
	m_pImpl->ShowAxes(true);
	return TRUE;
}

void	XYAxesInfoDlg::OnBeforeEditInfo(Control flxControl, long nRow, long nCol, BOOL* pCancel)
{
	m_pInfo->OnBeforeEdit(nRow, nCol, pCancel);		
}

void	XYAxesInfoDlg::OnAfterEditInfo(Control flxControl, int nRow, int nCol)
{
	m_pInfo->OnAfterEdit(nRow, nCol);	
}

/// Iris 7/16/2012 ORG-6216-S1 SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT
BOOL 	XYAxesInfoDlg::OnKeyInfo(Control oCntrl, UINT msg, UINT wParam, UINT lParam)
{
	if( WM_KEYDOWN == msg && ('a' == wParam || 'A' == wParam ) )		
	{
		m_pImpl->SetFocusOnGraph();		
	}
	return TRUE;
}
///End SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT

void 	XYAxesInfoDlg::OnAfterInfoSelectionChange(Control cntrl, int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel)
{
	m_pInfo->OnAfterSelectionChange(nOldRowSel, nOldColSel, nNewRowSel, nNewColSel);	
}

void	XYAxesInfoDlg::OnMouseMoveOnInfo(Control cntrl, short nButton, short nShift, float X, float Y)
{
	m_pInfo->OnMouseMove(nButton, nShift, X, Y);	
}
/*------------------------------------------------------------------------------*
* XYAxesInfoDlg	End																*
*------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* PolarAxesInfoDlg																*
//*------------------------------------------------------------------------------*/
 BOOL	PolarAxesInfoDlg::Create(HWND hWndParent, bool bVisible)
 {
 	InitMsgMap();		
	BOOL	bReturn = Dialog::Create(hWndParent, 0);	
	Visible = bVisible;
	return TRUE;	
 }
 
//virtual 
BOOL PolarAxesInfoDlg::OnInitDialog()
{		
	return TRUE;
}
/*------------------------------------------------------------------------------*
* PolarAxesInfoDlg End															*
*------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* TernaryVariablesList															*
//*------------------------------------------------------------------------------*/
#define STR_TERNARY_VARIABLES_HEADER		_L("Name|A|B|C|Image Pixel")
enum
{
	TERNARY_VARIABLE_COL_NAME = 0,
	TERNARY_VARIABLE_COL_A,
	TERNARY_VARIABLE_COL_B,
	TERNARY_VARIABLE_COL_C,
	TERNARY_VARIABLE_COL_IMAGE_PIXEL,
	
	TERNARY_VARIABLE_COL_LAST_ITEM
};

void TernaryVariablesList::Init(int nID, Dialog& dlg)
{
	GridListControl::Init(nID, dlg);
	
	SetExtendLastCol(false);
	SetEditable(flexEDNone);
	
	SetupRowsCols();	
	SetColHeader(STR_TERNARY_VARIABLES_HEADER);
	SetColAlignment(-1, flexAlignCenterCenter);
	
	SetRows(3);
	vector<string> vsTable = {	"P1", "0", "0", "1", "" // row 1
								,"P2", "1", "0", "0", "" // row 2
								,"P3", "0", "1", "0", "" // row 3
							 };
	SetTableValue(vsTable, true);
	ResizeCols();
	
	SetReady(true);
}

bool TernaryVariablesList::Update()
{
	if( !IsReady() )
		return false;
	
	// update Image Pixel col
	vector vx, vy;
	vector<string> vsPixel;
	int nNum = m_pImpl->GetVertexs(vx, vy);
	if( nNum > 0 )
	{
		for(int index = 0; index < nNum; ++index)
		{
			string str;
			str.Format("(%d, %d)", (int)vx[index], (int)vy[index]);			
			vsPixel.Add(str);
		}
		SetColValues(TERNARY_VARIABLE_COL_IMAGE_PIXEL, vsPixel);
	}
	
	return true;
}
/*------------------------------------------------------------------------------*
* TernaryVariablesList End														*
//*------------------------------------------------------------------------------*/

bool DigitizerTernaryVertexsPoints::AddOneVertex(double x, double y)
{	
	GraphObject vertexs = m_pObjsHolder->GetDigitizeVertex();
	
	if( !vertexs )
	{
		GraphLayer gl = m_pObjsHolder->GetDigitizeLayer();
		if( gl )
		{
			vertexs = gl.CreateGraphObject(GROBJ_TN_MARKER, STR_VERTEXS_DATA_PLOT_NAME);//GROT_POLYLINE					
			
			vertexs.Attach = ATTACH_TO_SCALE;			
			vertexs.SetSelectEffect(FALSE);
			vertexs.SetReverseVideo(FALSE);
						
			set_LT_script(vertexs, OBJ_INTERNAL_LABTALK_SCRIPT, GRCT_ANY_EVENT, 1);
			m_pObjsHolder->SetupUndoEvent(vertexs);
			m_pObjsHolder->SetupDeleteUndoable(vertexs, FALSE);							
		}
	}
	
	if( vertexs )
	{
		vector vx, vy;
		vx = m_pData->PtsVertexX;
		vy = m_pData->PtsVertexY;	
		ASSERT(vx.GetSize() <= NUM_VERTEXS && vx.GetSize() == vy.GetSize());
		
		Tree tr;
		tr.Root.Data.X.dVals = vx;
		tr.Root.Data.Y.dVals = vy;
		tr.Root.Width.dVal = 0;
		return 0 == vertexs.UpdateThemeIDs(tr.Root) && vertexs.ApplyFormat(tr, true, true);
	}	
	return false;
}

bool DigitizerTernaryVertexsPoints::UpdateVertexs()
{
	GraphObject vertexs = m_pObjsHolder->GetDigitizeVertex();
	if( vertexs )
	{
		Tree tr;
		tr = vertexs.GetFormat(FPB_DATA, FOB_ALL, true, true);
		if( tr.Root.Data.X && tr.Root.Data.Y )
		{
			m_pData->PtsVertexX = tr.Root.Data.X.dVals;
			m_pData->PtsVertexY = tr.Root.Data.Y.dVals;
			return true;
		}	
	}
	return false;
}
		
/*------------------------------------------------------------------------------*
* TernaryAxesInfoDlg															*
//*------------------------------------------------------------------------------*/
BOOL	TernaryAxesInfoDlg::Create(HWND hWndParent, bool bVisible)
{
 	InitMsgMap();		
	BOOL	bReturn = Dialog::Create(hWndParent, 0);	
	Visible = bVisible;
	return TRUE;	
}

//virtual
BOOL TernaryAxesInfoDlg::OnBeforeTabChange(int nOldType)
{
	m_pImpl->ShowVertexs(false);
	return TRUE;
}

//virtual
BOOL TernaryAxesInfoDlg::OnAfterTabChange()
{
	// if axes is editing status, then pick the three vertexs
	bool bIsAxesEditing = m_pImpl->IsAxesEditing();
	bool bIsVertexsReady = m_pImpl->IsVertexsReady();
	
	if( !bIsVertexsReady )
	{
		if( bIsAxesEditing )
		{
			LocatePoints pt;
			vector vx, vy;
			pt.GetVertexs(vx, vy);
		}
	}
	else
	{
		m_pImpl->ShowVertexs(true);
	}
	return TRUE;
}

//virtual 
BOOL TernaryAxesInfoDlg::OnInitDialog()
{	
	m_pVarList->Init(IDC_VERTEXS_INFO, *this);
	
	CheckRadioButton(IDC_RADIO_CCW, IDC_RADIO_CW, IDC_RADIO_CCW);
	CheckRadioButton(IDC_RADIO_RANGE_1, IDC_RADIO_RANGE_100, IDC_RADIO_RANGE_1);
	
	return TRUE;
}

BOOL TernaryAxesInfoDlg::OnVertexUpdated(WPARAM wParam, LPARAM lParam)
{
	return m_pVarList->Update();
}
/*------------------------------------------------------------------------------*
* TernaryAxesInfoDlg End														*
*------------------------------------------------------------------------------*/
	
/*------------------------------------------------------------------------------*
* DataInfoDlg 																	*
*------------------------------------------------------------------------------*/
 BOOL	DataInfoDlg::OnInitDialog()
 {
 	/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	Control ctrlMagnifier = GetItem(IDC_MAGNIFIER);
	m_picControl.CreateControl(ctrlMagnifier.GetSafeHwnd());		
	m_picControl.SetBorderColor(SYSCOLOR_GRAY);
	m_picControl.DrawMode = PCDM_STRETCH_KEEP_ASPECT_RATIO;
	m_sld = GetItem(IDC_SLIDER1);
	m_sld.RangeMin = 1;
	m_sld.RangeMax = 10;
	m_sld.SetTicFreq(1);
	m_sld.Position = 3;
	///End DIGITIZER_SUPPORT_MAGNIFIER	
	
	m_pLineList->Init(IDC_DIGITIZER_LINE_INFO, *this);
	return TRUE;
 }
 
 bool 	DataInfoDlg::OnDlgResize(int nType, int cx, int cy)
 {
 	const int nGap = 4;
	// Data tab	
	RECT rrStaticLabel;
	Control ccLabel = GetItem(IDC_STATIC_MAGNIFIER_LABEL);		
	ccLabel.GetClientRect(&rrStaticLabel);
	int nLabelWidth = RECT_WIDTH(rrStaticLabel);
	int nLabelHeight = RECT_HEIGHT(rrStaticLabel);
	
	int nMainControlHeight = cy - nLabelHeight - 2 * nGap;
	int nGridHeight = nMainControlHeight / 3;
	
	RECT rrLineGrid;
	rrLineGrid.left = nGap;
	rrLineGrid.top = nGap;
	rrLineGrid.right = cx - nGap;
	rrLineGrid.bottom = rrLineGrid.top + nGridHeight;
	Control ccLineGrid = GetItem(IDC_DIGITIZER_LINE_INFO);	
	ccLineGrid.MoveWindow(&rrLineGrid);
		
	rrStaticLabel.left = nGap;	
	rrStaticLabel.right = rrStaticLabel.left + nLabelWidth;
	rrStaticLabel.top = rrLineGrid.bottom + nGap;
	rrStaticLabel.bottom = rrStaticLabel.top + nLabelHeight;	
	ccLabel.MoveWindow(&rrStaticLabel);
			
	RECT 	rrSlder;	
	m_sld.GetClientRect(&rrSlder);
	int nSlderWidth = RECT_WIDTH(rrSlder);
	rrSlder.right 	= cx;
	rrSlder.left 	= rrSlder.right - nSlderWidth;
	rrSlder.top 	= rrStaticLabel.bottom + nGap;
	rrSlder.bottom 	= cy;
	m_sld.MoveWindow(&rrSlder);

	RECT rrMagnifier;
	rrMagnifier.left = nGap;
	rrMagnifier.right = rrSlder.left - nGap;
	rrMagnifier.top 	= rrStaticLabel.bottom + nGap;
	rrMagnifier.bottom 	= cy;
	Control ccMagnifier = GetItem(IDC_MAGNIFIER);	
	ccMagnifier.MoveWindow(&rrMagnifier);
	
	return true;
 }
 
 BOOL	DataInfoDlg::Create(HWND hWndParent)
 {
	InitMsgMap();		
	BOOL	bReturn = Dialog::Create(hWndParent, 0);	
	return TRUE;		
 }
 
 /// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
void	DataInfoDlg::OnLineInfoGridAfterEdit(Control ctrl, int nRow, int nCol)
{
	if( LINEINFO_COL_SHOW == nCol )
	{
		string str = m_pLineList->GetCell(nRow, nCol);
		int nLineIndex = nRow - m_pLineList->GetRowOffset();		
		m_pImpl->ShowDataPlot(nLineIndex, (bool)atoi(str));		
	}
}

void 	DataInfoDlg::OnLineInfoGridBeforeEdit(Control cntrl, int nRow, int nCol, BOOL* pCancel)
{
	m_pLineList->OnBeforeEdit(nRow, nCol, pCancel);	
}
///End IMPROVE_MULTIPLE_CURVES

void 	DataInfoDlg::OnLineInfoGridSelRowChange(Control ctrl)
{
	if( m_pLineList->IsReady() )
	{
		int nIndex = m_pLineList->GetSelectedRow() - m_pLineList->GetRowOffset();
		ERR_MSG("data index=" + (string)nIndex); 		
		
		if( nIndex >=0 )
		{
			m_pImpl->SetActiveData(nIndex);
			m_pImpl->ActivatePlot();
		}
	}
}

 bool	DataInfoDlg::UpdateMagnifier(pBITMAPHANDLE pBitmap)
 {
 	if( m_picControl )
		return m_picControl.SetLeadBitmap(pBitmap, false);
 	return false;
 }
 
 int	DataInfoDlg::GetMagnifierFactor()
 {
 	return m_sld.Position * 10; // return 10 ~ 100, the percent of image
 }
 
 void	DataInfoDlg::UpdateGrid(int nLine, bool bAllowRowSelEvent)
 {
 	m_pLineList->UpdateRows(nLine, bAllowRowSelEvent);
 }
 
 void	DataInfoDlg::SelData(int nDataIndex)
 {
	int nRow = nDataIndex + m_pLineList->GetRowOffset();	
	m_pLineList->SetReady(false); // Iris: to avoid enter grid select row event
	m_pLineList->SelRow(nRow);		
	m_pLineList->SetReady(true);	
 } 
 /*------------------------------------------------------------------------------*
* DataInfoDlg End																	*
*------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
* Digitizer 																	*
*------------------------------------------------------------------------------*/
enum {
	DIGITIZER_OPTION_EDIT_LABEL				= 0x0001,
};

enum
{
	GRID_X = 0,
	GRID_Y
};

BOOL 	Digitizer::OnInitDialog()
{
	ResizeDialog::OnInitDialog(0, STR_DLG_NAME);	
	m_tab = GetItem(IDC_DIGITIZER_TAB);	
	
	HMENU hmn = GetMenu(GetSafeHwnd());
	if( hmn )
		m_menu.Load(hmn);	
	
	InitRadioBitmapButtons();
	
	initControlPosition();		
	
	m_Impl.SetHwnd(GetSafeHwnd());
		
	CheckUpdateOnDlgShow(TRUE);
	
	//m_pInfo->Init(IDC_DIGITIZER_INFO, *this);
	//m_pLineList->Init(IDC_DIGITIZER_LINE_INFO, *this);	/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER			
	if( m_tab )
	{
		m_pXYAxesInfoDlg = new XYAxesInfoDlg(&m_Impl);
		if( NULL != m_pXYAxesInfoDlg )
		{
			m_pXYAxesInfoDlg->Create(m_tab.GetSafeHwnd(), true);		
			m_tab.AddTab(m_pXYAxesInfoDlg->GetSafeHwnd(), STR_TAB_TITLE_AXES);
		}
		
		m_pPolarAxesInfoDlg = new PolarAxesInfoDlg(&m_Impl);
		if( NULL != m_pPolarAxesInfoDlg )
		{
			m_pPolarAxesInfoDlg->Create(m_tab.GetSafeHwnd(), false);		
			m_tab.AddTab(m_pPolarAxesInfoDlg->GetSafeHwnd(), STR_TAB_TITLE_AXES);
		}	
		
		m_pTernaryAxesInfoDlg = new TernaryAxesInfoDlg(&m_Impl);
		if( NULL != m_pTernaryAxesInfoDlg )
		{
			m_pTernaryAxesInfoDlg->Create(m_tab.GetSafeHwnd(), false);		
			m_tab.AddTab(m_pTernaryAxesInfoDlg->GetSafeHwnd(), STR_TAB_TITLE_AXES);
		}		
		
		m_pDataInfoDlg = new DataInfoDlg(&m_Impl);
		if( NULL != m_pDataInfoDlg )
		{
			m_pDataInfoDlg->Create(m_tab.GetSafeHwnd());	
			m_tab.AddTab(m_pDataInfoDlg->GetSafeHwnd(), STR_TAB_TITLE_DATA);
		}
	}
	OnTabChange(m_tab);
	onMenuCoordinatesTypeCmd(m_Impl.GetCoordinatesType(), true);
	
	PostMessage(ID_DIGITIZER_MSG_CHECK_SET_ACTIVE_PLOT); /// Iris 12/29/2011 ORG-4685-P2 FIX_REOPEN_DLG_DATA_PLOT_SELECTION_PROBLEM
	return UpdateStates();
}

BOOL 	Digitizer::OnDestroy()
{
	m_Impl.UpdateROIGirdStatus(true);
	m_Impl.DestroyTempMatrix();			///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
	
	/// Iris 10/25/2011 FIX_NO_OPENDLG_BUTTON_SHOW_AFTER_DIALOG_CLOSE
	ResizeDialog::OnDestroy();
	CheckUpdateOnDlgShow(FALSE);
	
	NICE_SAFE_REMOVAL(g_pDigitizer);
	///End FIX_NO_OPENDLG_BUTTON_SHOW_AFTER_DIALOG_CLOSE
	return TRUE;
}

BOOL	Digitizer::OnCancel()
{
	if( m_Impl.IsImageDigitizing() )
		return FALSE;
	return TRUE;
}

BOOL 	Digitizer::OnDlgResize(int nType, int cx, int cy)
{
	MoveControlsHelper _tmp(this);
		
	RECT	rrTab;
	GetControlClientRect(IDC_DIGITIZER_TAB, rrTab);
	rrTab.bottom = cy;
	rrTab.right = cx;
	MoveControl(m_tab, rrTab);	
	m_tab.AdjustRect(FALSE, &rrTab);
	
	// Axes tab
	/*
	Control ccGrid = GetItem(IDC_DIGITIZER_INFO);
	MoveControl(ccGrid, rrTab);
	
	// Data tab	
	RECT rrStaticLabel;
	Control ccLabel;
	GetControlClientRect(IDC_STATIC_MAGNIFIER_LABEL, rrStaticLabel, &ccLabel);	
	int nLabelWidth = RECT_WIDTH(rrStaticLabel);
	int nLabelHeight = RECT_HEIGHT(rrStaticLabel);
	
	int nMainControlHeight = RECT_HEIGHT(rrTab) - nLabelHeight - 2 * GetControlGap();
	int nGridHeight = nMainControlHeight / 3;
	
	RECT rrLineGrid;
	rrLineGrid = rrTab;
	rrLineGrid.bottom = rrLineGrid.top + nGridHeight;
	Control ccLineGrid = GetItem(IDC_DIGITIZER_LINE_INFO);
	MoveControl(ccLineGrid, rrLineGrid);	
		
	rrStaticLabel.left = rrTab.left;	
	rrStaticLabel.right = rrStaticLabel.left + nLabelWidth;
	rrStaticLabel.top = rrLineGrid.bottom + GetControlGap();
	rrStaticLabel.bottom = rrStaticLabel.top + nLabelHeight;
	MoveControl(ccLabel, rrStaticLabel);	
			
	RECT 	rrSlder;
	GetControlClientRect(IDC_SLIDER1, rrSlder);
	int nSlderWidth = RECT_WIDTH(rrSlder);
	rrSlder.right 	= rrTab.right;
	rrSlder.left 	= rrSlder.right - nSlderWidth;
	rrSlder.top 	= rrStaticLabel.bottom + GetControlGap();
	rrSlder.bottom 	= rrTab.bottom;
	MoveControl(m_sld, rrSlder);

	RECT rrMagnifier;
	rrMagnifier.left = rrTab.left;
	rrMagnifier.right = rrSlder.left - GetControlGap();
	rrMagnifier.top 	= rrStaticLabel.bottom + GetControlGap();
	rrMagnifier.bottom 	= rrTab.bottom;
	Control ccMagnifier = GetItem(IDC_MAGNIFIER);
	MoveControl(ccMagnifier, rrMagnifier);	
	*/
	// to do, iris

	return TRUE;
}
	
BOOL 	Digitizer::OnTabChange(Control ctrl)
{	
	//TabControl tab = GetItem(IDC_DIGITIZER_TAB);
	//bool bShowAxisTab = (m_tab.GetCurSel() == DIGITIZER_AXIS_TAB);
	bool bShowDataTab = (m_tab.GetCurSel() == DIGITIZER_DATA_TAB);
	/*
	GetItem(IDC_DIGITIZER_INFO).Visible = bShowAxisTab;
	
	GetItem(IDC_STATIC_MAGNIFIER_LABEL).Visible =  /// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	GetItem(IDC_DIGITIZER_LINE_INFO).Visible= 
	GetItem(IDC_MAGNIFIER).Visible 			=
	m_sld.Visible 							= bShowDataTab;
	*/
	LT_set_var(LT_VAR_PAGE_MOUSE_MOVE, bShowDataTab); /// Iris 12/27/2011 ORG-4685-S3 NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE
	
	return TRUE;
}

BOOL	Digitizer::OnChangePage()
{
	updateDigitizeGridStatus(); /// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	return UpdateStates();
}

BOOL	Digitizer::OnImportImage(Control ctrl)
{
	return m_Impl.ImportImage() && UpdateStates();
}

///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
BOOL	Digitizer::OnImportImageFromClipboard(Control ctrl)
{
	if(is_image_availble_in_clipboard())
		return m_Impl.ImportImageFromClipboard() && UpdateStates();
	else
	{
		warning_msg_box(_L("No image in the clipboard."), TRUE);
		return false;
	}
}
///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER

BOOL	Digitizer::OnMenuImportImage()
{
	Control ctrl = GetItem(IDC_DIGITIZER_IMPORT);
	return OnImportImage(ctrl);
}

#define		ON_BUTTON_PRESSED(_bPressedDown) \
				BitmapRadioButton	btn = ctrl; \
				bool				_bPressedDown = btn.PressedDown; \
				if( !_bPressedDown ) \
					turnOffPressedButton(); \
				btn.PressedDown = !_bPressedDown; \					
				_bPressedDown = !_bPressedDown;

BOOL	Digitizer::OnToggleAxesEdit(Control ctrl)
{
	ON_BUTTON_PRESSED(bPressedDown);
	//CheckMenuItem(IDC_DIGITIZER_MENU_EDIT_AXES, !bPressedDown);	//move CheckMenuItem to OnUiUpdateMenu
	m_Impl.SetAxesEditing(bPressedDown);
	return UpdateInfoSelectable(TRUE);
}

BOOL	Digitizer::OnMenuToggleXRefLineShow() //old name: OnShowXRefLine 
{
	bool bShow = m_Impl.IsXRefLineShow();
	//CheckMenuItem(IDC_DIGITIZER_MENU_SHOW_XREF, !bShow);	//move CheckMenuItem to OnUiUpdateMenu
	m_Impl.ShowXRefLine(!bShow);
	return UpdateInfo();
}

BOOL	Digitizer::OnMenuToggleYRefLineShow() //old name: OnShowYRefLine 
{
	bool bShow = m_Impl.IsYRefLineShow();
	//CheckMenuItem(IDC_DIGITIZER_MENU_SHOW_YREF, !bShow);	//move CheckMenuItem to OnUiUpdateMenu
	m_Impl.ShowYRefLine(!bShow);
	return UpdateInfo();
}

///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
BOOL	Digitizer::OnMenuToggleLabelEdit()
{
	O_TOGGLE_BIT(m_dwOptions, DIGITIZER_OPTION_EDIT_LABEL);
	
	bool bCheck = O_QUERY_BOOL(m_dwOptions, DIGITIZER_OPTION_EDIT_LABEL);
	return m_Impl.SetLabelEditing(bCheck) && UpdateStates();
}
///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

BOOL	Digitizer::OnMenuRotate()
{
	ImageRotateGetNDlg();
	EnableUndoButton(); /// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
	return true;
}

BOOL	Digitizer::OnMenuGoToData()
{
	m_Impl.GotoData();
	return true;
}

BOOL	Digitizer::OnMenuGoToImage()
{
	if ( m_glImage )
		return m_glImage.CheckShowActivate();
	return true;
}

BOOL	Digitizer::OnMenuGoToGraph()
{
	m_Impl.GotoGraph();
	return true;
}

BOOL	Digitizer::OnMenuDelWksGraph()
{
	return m_Impl.DelWksGraph() && UpdateStates();
}
	
/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
BOOL 	Digitizer::OnUIUpdateMenuEnable(CmdUI cmd)
{		
	//ERR_MSG("Digitizer::OnUIUpdateMenuEnable");
	cmd.Enable( !m_Impl.IsImageDigitizing() );
	
	if( !m_Impl.IsImageDigitizing() )
		OnUiUpdateMenu(cmd);
	
	return true;
}
///End DIGITIZER_SUPPORT_MAGNIFIER

BOOL	Digitizer::OnUiUpdateMenu(CmdUI cmdUI)
{
	/// Iris 2/13/2012 ORG-5009-P1 IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
	//bool bEnable = true;
	bool bEnable = m_Impl.HasValidDigitizeImage();
	///End IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
	bool bCheck = false;
	
	CmdUIInfo cmdInfo;
	cmdUI.GetMenuInfo(cmdInfo);
	
	switch(cmdInfo.m_nID)
	{
	case IDC_DIGITIZER_MENU_GO:
	case IDC_DIGITIZER_MENU_TRACE_LINE:
		/// Iris 2/13/2012 ORG-5009-P1 IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
		//bEnable = m_Impl.HasValidDigitizeImage() && m_Impl.IsReadyToDigitize() && IsButtonsEnable();
		bEnable = bEnable && m_Impl.IsReadyToDigitize() && IsButtonsEnable();
		///End IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
		break;
		
	case IDC_DIGITIZER_MENU_DELETE_POINT:
	case IDC_DIGITIZER_MENU_REORDER_POINT:		
	case IDC_DIGITIZER_MENU_SET_LABEL:
		
		
		/// Iris 2/13/2012 ORG-5009-P1 IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
		//bEnable	= m_Impl.HasValidDigitizeImage() && !m_Impl.IsRotationMode() && m_Impl.HasDataPoint();
		/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
		//bEnable	= bEnable && !m_Impl.IsRotationMode() && m_Impl.HasDataPoint();
		bEnable	= m_Impl.HasValidDigitizeImage() && m_Impl.HasDataPoint();
		///End FIX_ROTATE_GETN_DLG_ISSUE
		///End IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS		
			
		if(IDC_DIGITIZER_MENU_SET_LABEL == cmdInfo.m_nID)
			bCheck 	= m_Impl.IsLabelEditing();
		
		break;
	
	case IDC_DIGITIZER_MENU_ROTATE:
		/// Iris 2/13/2012 ORG-5009-P1 IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
		//bEnable = m_Impl.HasValidDigitizeImage() && !m_Impl.IsLabelEditing();
		bEnable = bEnable && !m_Impl.IsLabelEditing();
		///End IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
		break;
		
	case IDC_DIGITIZER_MENU_GO_TO_IMAGE:
		bEnable = m_glImage && !m_Impl.HasValidDigitizeImage();
		break;

	case IDC_DIGITIZER_MENU_GO_TO_DATA:
	case IDC_DIGITIZER_MENU_GO_TO_GRAPH:
	case IDC_DIGITIZER_MENU_REMOVE_WKS_GRAPH:
		/// Iris 2/13/2012 ORG-5009-P1 IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
		//bEnable = !m_Impl.GetDataName().IsEmpty() && IsButtonsEnable();
		bEnable = bEnable && !m_Impl.GetDataName().IsEmpty() && IsButtonsEnable();
		///End IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
		break;
	
	case IDC_DIGITIZER_MENU_SHOW_XREF:
		bCheck = !m_Impl.IsX1FromYAxis();
		break;
		
	case IDC_DIGITIZER_MENU_SHOW_YREF:
		bCheck = !m_Impl.IsY1FromXAxis();
		break;
		
	case IDC_DIGITIZER_MENU_EDIT_AXES:
		bCheck = m_Impl.IsAxesEditing();
		break;
	
	/// Iris 12/29/2011 ORG-4685-S5 SUPPORT_DELETE_LINE
	case IDC_DIGITIZER_MENU_DELETE_LINE: 
		/// Iris 2/13/2012 ORG-5009-P1 IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
		//bEnable =  m_Impl.IsDeleteLineEnable();
		bEnable =  bEnable && m_Impl.IsDeleteLineEnable();
		///End IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
		break;
	///End SUPPORT_DELETE_LINE
		
	/// Iris 2/13/2012 ORG-5009-P1 IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
	case IDC_DIGITIZER_MENU_IMPORT:
	case IDC_DIGITIZER_MENU_CLOSE:
		bEnable = true;
	///End IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
	
	default:
		/// Iris 2/13/2012 ORG-5009-P1 IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
		//return TRUE;		
		break;
		///End IMPROVE_MENU_DISABLE_AND_ENABLE_STATUS
	}
	
	EnableMenuItem(cmdInfo.m_nID, bEnable, bCheck);	
	return TRUE;
}

void 	Digitizer::EnableMenuItem(int nMenuItemID, bool bEnable/* = true*/, bool bCheck/* = false*/)
{
	DWORD dwFlags = MF_BYCOMMAND;
	string strLabel;
	HWND	hWnd = GetSafeHwnd();
	HMENU	hMenu = GetMenu(hWnd);
	Menu	mn(hMenu);
	mn.GetMenuString(nMenuItemID, strLabel, dwFlags);
	dwFlags |= bEnable ? 0 : MF_DISABLED | MF_GRAYED;
	dwFlags |= bCheck ? MF_CHECKED : 0;
	mn.ModifyMenu(nMenuItemID, dwFlags, nMenuItemID, strLabel);
}

BOOL 	Digitizer::OnNewLine(Control ctrl)
{	
	int nLineIndex = m_Impl.NewData();
	if( nLineIndex < 0 )
		return FALSE;
	
	//m_pLineList->UpdateRows(nLineIndex);
	m_pDataInfoDlg->UpdateGrid(nLineIndex);
	
	/// Iris 12/26/2011 ORG-4685-S4 CLICKED_NEW_LINE_NEED_START_PICK_POINTS
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	// remove the codes since user might want to do digitize area after new line
	//bool bRet = doDigitize();
	//ASSERT(bRet);
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	///End CLICKED_NEW_LINE_NEED_START_PICK_POINTS
	
	return TRUE;
}

BOOL	Digitizer::OnRemoveGridLines(Control ctrl)
{	
	if( m_Impl.RemoveGridLine() )
	{
		EnableUndoButton(); /// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
		return TRUE;
	}
	return FALSE;
}

BOOL 	Digitizer::OnTraceLine(Control ctrl)
{
	//Profiler junk;
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	/*
	if ( m_Impl.IsAxesEditing() )
	{
		m_Impl.SetAxesEditing(FALSE);
		UpdateAxesEditing();
	}
	return m_Impl.TraceLine() && CheckEnableDigitize();// && UpdateHint();
	*/
	turnOffPressedButton();
	beforeDigitize();
	bool bRet = m_Impl.TraceLine();
	if( bRet )
	{
		afterDigitize();
	}
	return bRet;
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
}

void	Digitizer::turnOffPressedButton()
{
	vector<uint> vnIDs = {IDC_DIGITIZER_AREA, IDC_DIGITIZER_DELETE_POINT};
	for(int index=0; index < vnIDs.GetSize(); ++index)
	{
		Control ctrl = GetItem(vnIDs[index]);
		BitmapRadioButton btn(ctrl);
		if( btn && btn.PressedDown )
		{
			btn.PressedDown = false;
			
			switch(vnIDs[index])
			{
			case IDC_DIGITIZER_AREA:
				/// Iris 2/02/2012 ORG-4797-S5 TO_ADD_DIGITIZE_SETTINGS_MENU
				//m_Impl.SaveDigitizingAreaStatus(false);
				bool bOn = false;
				m_Impl.SaveDigitizingAreaStatus(&bOn);
				///End TO_ADD_DIGITIZE_SETTINGS_MENU
				break;
				
			case IDC_DIGITIZER_DELETE_POINT:
				m_Impl.SaveDeletePointsStatus(false);
				break;				
			}
			return;
		}
	}
}

/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
AxesInfoDlg* Digitizer::getAxesInfoDlgPointer()
{	
	int nType = m_Impl.GetCoordinatesType();
	
	switch(nType)
	{		
	case COORDINATES_TYPE_NORMAL_XY:
		if( NULL == m_pXYAxesInfoDlg )
		{
			m_pXYAxesInfoDlg = new XYAxesInfoDlg(&m_Impl);	
		}		
		if( m_pXYAxesInfoDlg && NULL == m_pXYAxesInfoDlg->GetWindow() )
		{		
			m_pXYAxesInfoDlg->Create(m_tab.GetSafeHwnd());			
		}				
		return m_pXYAxesInfoDlg;
		break;		
		
	case COORDINATES_TYPE_TERNARY:		
		if( NULL == m_pTernaryAxesInfoDlg )
		{
			m_pTernaryAxesInfoDlg = new TernaryAxesInfoDlg(&m_Impl);	
		}
		if( m_pTernaryAxesInfoDlg && NULL == m_pTernaryAxesInfoDlg->GetWindow() )
		{
			m_pTernaryAxesInfoDlg->Create(m_tab.GetSafeHwnd());
		}		
		return m_pTernaryAxesInfoDlg;
		break;
		
	default:
		ASSERT(false);		
		break;
	}	
	return NULL;	
}

int		Digitizer::getCoordinatesType()
{
	return m_Impl.GetCoordinatesType();
}
///End SUPPORT_TERNARY_IN_DIGITIZER

BOOL 	Digitizer::OnDigitizeArea(Control ctrl)
{
	ON_BUTTON_PRESSED(bPressedDown); /// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
	
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	//Profiler junk;
	//return m_Impl.DigitizeArea();	
	beforeDigitize();
	//bool bRet = m_Impl.DigitizeArea();
	/// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
	/*
	bool bRet = LT_execute("addtool_digitize_area -d");	
	if( bRet )
	{
		afterDigitize();
	}
	return bRet;
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	*/
	DigiROIGridInfo stROIGridInfo;
	m_Impl.GetDigitizeROIGridInfo(stROIGridInfo);
	/// Iris 2/02/2012 ORG-4797-S5 TO_ADD_DIGITIZE_SETTINGS_MENU
	//if( bPressedDown )
	//{		
		//GETN_TREE(tr)
		//GETN_BEGIN_BRANCH(Grids, _L("Grids")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)		
        //GETN_RADIO_INDEX(Ori, 0, _L("X Grids|Y Grids"))
            //GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)
		//GETN_END_BRANCH(Grids)		
		//GETN_STR(dx, "dx (Pixel) = ", "")		
		//
		//tr.Grids.Ori.nVal = stROIGridInfo.bVertical ? GRID_X : GRID_Y;
		//tr.dx.strVal = (string)stROIGridInfo.nStep;
		//
		//if( GetNBox(tr, _L("Digitize Area")) )
		//{
			//stROIGridInfo.bVertical = GRID_X == tr.Grids.Ori.nVal;
			//stROIGridInfo.nStep = atoi(tr.dx.strVal);							
		//}
		//else // if clicked Cancel button on GetN dialog, should keep button as Pressed UP
		//{
			//btn.PressedDown = false;			
		//}
	//}	
	///End TO_ADD_DIGITIZE_SETTINGS_MENU
	stROIGridInfo.bGrid = true; // Digitize area must have grid in rect
	/// Iris 2/02/2012 ORG-4797-S5 TO_ADD_DIGITIZE_SETTINGS_MENU
	//m_Impl.SaveDigitizingAreaStatus(bPressedDown, &stROIGridInfo);
	m_Impl.SaveDigitizingAreaStatus(&bPressedDown, &stROIGridInfo);
	///End TO_ADD_DIGITIZE_SETTINGS_MENU
	m_Impl.UpdateROIGirdStatus();	
	return TRUE;
	///End MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE	
}

BOOL	Digitizer::OnDigitize(Control ctrl)
{
	/// Iris 12/26/2011 ORG-4685-S4 CLICKED_NEW_LINE_NEED_START_PICK_POINTS
	/*
	if ( m_Impl.IsAxesEditing() )
	{
		m_Impl.SetAxesEditing(FALSE);
		UpdateAxesEditing();
	}
	/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	//return m_Impl.Digitize() && CheckEnableDigitize();// && UpdateHint();			
	TabControl tab = GetItem(IDC_DIGITIZER_TAB);
	if( tab.GetCurSel() != DIGITIZER_DATA_TAB )
	{
		// before do digitize, switch to Data tab to show Magnifier if currect not Data tab
		tab.SetCurSel(DIGITIZER_DATA_TAB);
		OnTabChange(tab);
	}	
	
	vector<int> vnIDs;
	getToolbarButtonIDs(vnIDs);
	DisableToolbarButtonTemp _tmp(*this, vnIDs);
	
	bool bRet = m_Impl.Digitize();	
	if( bRet )
	{
		CheckEnableDigitize();
		m_pLineList->UpdateRows();
	}	
	return bRet;
	///End DIGITIZER_SUPPORT_MAGNIFIER
	*/
	turnOffPressedButton();
	return doDigitize();
	///End CLICKED_NEW_LINE_NEED_START_PICK_POINTS
}

void	Digitizer::beforeDigitize()
{
	if ( m_Impl.IsAxesEditing() )
	{
		m_Impl.SetAxesEditing(FALSE);
		UpdateAxesEditing();
	}	
	
	/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	//return m_Impl.Digitize() && CheckEnableDigitize();// && UpdateHint();			
	//TabControl tab = GetItem(IDC_DIGITIZER_TAB);
	if( m_tab.GetCurSel() != DIGITIZER_DATA_TAB )
	{
		// before do digitize, switch to Data tab to show Magnifier if currect not Data tab
		m_tab.SetCurSel(DIGITIZER_DATA_TAB);
		OnTabChange(m_tab);
	}		
	
	vector<int> vnIDs;
	getToolbarButtonIDs(vnIDs);
	DisableToolbarButtonTemp _tmp(*this, vnIDs);	
}

void	Digitizer::afterDigitize()
{
	CheckEnableDigitize();

	//m_pLineList->UpdateRows(m_Impl.GetActiveData(), true);
	m_pDataInfoDlg->UpdateGrid(m_Impl.GetActiveData(), true);
}

/// Iris 12/26/2011 ORG-4685-S4 CLICKED_NEW_LINE_NEED_START_PICK_POINTS
BOOL	Digitizer::doDigitize()
{
	/*
	if ( m_Impl.IsAxesEditing() )
	{
		m_Impl.SetAxesEditing(FALSE);
		UpdateAxesEditing();
	}	
	/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	//return m_Impl.Digitize() && CheckEnableDigitize();// && UpdateHint();			
	TabControl tab = GetItem(IDC_DIGITIZER_TAB);
	if( tab.GetCurSel() != DIGITIZER_DATA_TAB )
	{
		// before do digitize, switch to Data tab to show Magnifier if currect not Data tab
		tab.SetCurSel(DIGITIZER_DATA_TAB);
		OnTabChange(tab);
	}	
	
	vector<int> vnIDs;
	getToolbarButtonIDs(vnIDs);
	DisableToolbarButtonTemp _tmp(*this, vnIDs);
	*/
	
	bool bRet = m_Impl.Digitize();	
	if( bRet )
	{
		/*
		CheckEnableDigitize();
		m_pLineList->UpdateRows(m_Impl.GetActiveData(), true);
		*/
		afterDigitize();
	}	
	return bRet;
	///End DIGITIZER_SUPPORT_MAGNIFIER	
}
///End CLICKED_NEW_LINE_NEED_START_PICK_POINTS
	
BOOL	Digitizer::OnDeletePoint(Control ctrl)
{
	/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
	/*
	m_Impl.DeletePoint();
	m_pLineList->UpdateRows();	
	*/
	ON_BUTTON_PRESSED(bPressedDown); 		
	m_Impl.SaveDeletePointsStatus(bPressedDown);		
	m_Impl.UpdateROIGirdStatus();
	///End IMPROVE_DELETE_POINTS
	return TRUE;
}

BOOL	Digitizer::OnReorderPoints(Control ctrl)
{
	m_Impl.ReorderPoints();
	return TRUE;
}

/// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
BOOL 	Digitizer::OnUndo(Control ctrl)
{
	if( m_Impl.Undo() )
	{
		EnableUndoButton(false); /// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
		return TRUE;
	}
	return FALSE;
}
///End SUPPORT_UNDO_FOR_IMAGE_PROCESS

/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
BOOL	Digitizer::OnMagnifierSliderClick(Control ctrl, UINT nCode, UINT nPos)
{
	UpdateMagnifier();
	return TRUE;
}
///End DIGITIZER_SUPPORT_MAGNIFIER

BOOL 	Digitizer::OnMenuClose()
{
	PostMessage(WM_CLOSE); 
	return TRUE;
}

BOOL	Digitizer::OnRotate(Control ctrl)
{
	/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	/*
	ASSERT(0);
	ON_BUTTON_PRESSED(bPressedDown);
	return m_Impl.SetRotationMode(!bPressedDown) && UpdateStates();
	*/
	if( OnMenuRotate() )
	{
		EnableUndoButton(); /// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
		return TRUE; 
	}
	return FALSE;
	///End DIGITIZER_SUPPORT_MAGNIFIER
}

BOOL	Digitizer::OnMenuReplaceColor()
{
	ASSERT(0);
	return TRUE;
}

BOOL	Digitizer::OnMenuEraser()
{
	ASSERT(0);
	return TRUE;
}

BOOL	Digitizer::OnMenuClearBackground()
{	
	if( m_Impl.ClearBackground() )
	{
		EnableUndoButton(); /// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
		return TRUE;
	}
	return FALSE;
}

BOOL	Digitizer::OnMenuEditAxes()
{ 		
	Control ctrl = GetItem(IDC_DIGITIZER_EDIT);
	return OnToggleAxesEdit(ctrl);
}

void    Digitizer::setMenuCheckStatus(int nMenuItemID, bool bCheck)
{
	string str;
	m_menu.GetMenuString(nMenuItemID, str, MF_BYCOMMAND);
	
	UINT uFlags = MF_BYCOMMAND | MF_STRING;		
	uFlags |= bCheck ? MF_CHECKED : MF_UNCHECKED;
	m_menu.ModifyMenu(nMenuItemID, uFlags, nMenuItemID, str);		
}

BOOL    Digitizer::setMenuCoordinatesType(int nType, bool bInit)
{
	vector<uint> vnMenuIDs = {IDC_DIGITIZER_MENU_RECTANGULAR_COORDINATE, IDC_DIGITIZER_MENU_POLAR_COORDINATE, IDC_DIGITIZER_MENU_TERNARY_COORDINATE};
	vector<uint> vnTypes = {COORDINATES_TYPE_NORMAL_XY, COORDINATES_TYPE_POLAR, COORDINATES_TYPE_TERNARY};		
		
	vector<uint> vn;	
	if( vnTypes.Find(MATREPL_TEST_EQUAL, nType, vn) <= 0 )
		return FALSE; // err	
	
	bool bUpdated = false;
	if( bInit || nType != m_Impl.GetCoordinatesType() )		
	{
		m_Impl.SetCoordinatesType(nType);
		bUpdated = true;
	}
	
	if( bUpdated )
	{
		int nSelMenuID = vnMenuIDs[vn[0]];
		setMenuCheckStatus(nSelMenuID, true);	
		
		for(int index = 0; index < vnMenuIDs.GetSize(); ++index)
		{		
			if( nSelMenuID != vnMenuIDs[index] )
			{		
				setMenuCheckStatus(vnMenuIDs[index], false);
			}			
		}	
	}
	return bUpdated;
}

BOOL	Digitizer::onMenuCoordinatesTypeCmd(int nType, bool bInit)
{
	// not do this when dialog init time, just when switch coordinates types
	int nOldType = bInit ? -1 : m_Impl.GetCoordinatesType();		
	getAxesInfoDlgPointer()->OnBeforeTabChange(nOldType);	
	
	if( setMenuCoordinatesType(nType, bInit) )
	{
		// to show the selected coordinates tab and hide other coordinates tabs.
		for(int nCoordinatesTab = DIGITIZER_XY_AXIS_TAB; nCoordinatesTab <= DIGITIZER_TERNARY_AXIS_TAB; ++nCoordinatesTab)
		{
			int nCoordinatesType = nCoordinatesTab;			
			m_tab.ShowTab(nCoordinatesTab, nCoordinatesType == nType);
			if( nCoordinatesType == nType )
				m_tab.SetCurSel(nCoordinatesTab);
		}
		
		// when switch coordinates type
		if( !bInit ) 
		{
			getAxesInfoDlgPointer()->OnAfterTabChange();
		}
		
		return TRUE;
	}
	return FALSE;
}

BOOL	Digitizer::OnMenuRectangularCoordinates()
{
	return onMenuCoordinatesTypeCmd(COORDINATES_TYPE_NORMAL_XY, false);	
}

BOOL	Digitizer::OnMenuPolarCoordinates()
{
	return onMenuCoordinatesTypeCmd(COORDINATES_TYPE_POLAR, false);	
}

BOOL	Digitizer::OnMenuTernaryCoordinates()
{
	return onMenuCoordinatesTypeCmd(COORDINATES_TYPE_TERNARY, false);
}

BOOL	Digitizer::OnMenuNewLine()
{
	Control ctrl = GetItem(IDC_DIGITIZER_NEW_LINE);
	return OnNewLine(ctrl);
}

/// Iris 12/29/2011 ORG-4685-S5 SUPPORT_DELETE_LINE
BOOL	Digitizer::OnMenuDeleteLine()
{
	m_Impl.RemoveActiveData();
	//m_pLineList->UpdateRows();
	m_pDataInfoDlg->UpdateGrid();
	return TRUE;
}
///End SUPPORT_DELETE_LINE

BOOL	Digitizer::OnMenuRemoveGridline()
{
	Control ctrl = GetItem(IDC_DIGITIZER_REMOVE_GRIDLINE);
	return OnRemoveGridLines(ctrl);
}

BOOL	Digitizer::OnMenuTraceLine()
{
	Control ctrl = GetItem(IDC_DIGITIZER_TRACE_LINE);
	return OnTraceLine(ctrl);
}

BOOL	Digitizer::OnMenuArea()
{
	Control ctrl = GetItem(IDC_DIGITIZER_AREA);
	return OnDigitizeArea(ctrl);
}

/// Iris 2/02/2012 ORG-4797-S5 TO_ADD_DIGITIZE_SETTINGS_MENU
BOOL	Digitizer::OnMenuDigitizeSettings()
{
	DigiROIGridInfo stROIGridInfo;
	m_Impl.GetDigitizeROIGridInfo(stROIGridInfo);
	
	GETN_TREE(tr)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	GETN_BEGIN_BRANCH(Grids, _L("Grids")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)		
	GETN_RADIO_INDEX(Ori, 0, _L("X Grids|Y Grids"))
		GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)
	GETN_END_BRANCH(Grids)		
	GETN_STR(dx, "dx (Pixel) = ", "")		
	
	tr.Grids.Ori.nVal = stROIGridInfo.bVertical ? GRID_X : GRID_Y;
	tr.dx.strVal = (string)stROIGridInfo.nStep;
	
	if( GetNBox(tr, _L("Digitize Area")) )
	{
		stROIGridInfo.bVertical = GRID_X == tr.Grids.Ori.nVal;
		stROIGridInfo.nStep = atoi(tr.dx.strVal);							
		m_Impl.SaveDigitizingAreaStatus(NULL, &stROIGridInfo);
		m_Impl.UpdateROIGirdStatus();
		return true;
	}
	return false; // click Cancel button on GetN dlg	
}
//End TO_ADD_DIGITIZE_SETTINGS_MENU

BOOL	Digitizer::OnMenuGo()
{
	Control ctrl = GetItem(IDC_DIGITIZER_GO);
	return OnDigitize(ctrl);
}

BOOL	Digitizer::OnMenuDeletePoint()
{
	Control ctrl = GetItem(IDC_DIGITIZER_DELETE_POINT);
	return OnDeletePoint(ctrl);
}

BOOL	Digitizer::OnMenuReorderPoint()
{
	Control ctrl = GetItem(IDC_DIGITIZER_REORDER_POINT);
	return OnReorderPoints(ctrl);
}

BOOL	Digitizer::OnMenuOndo()
{
	Control ctrl = GetItem(IDC_DIGITIZER_UNDO);
	return OnUndo(ctrl);
}

BOOL	Digitizer::OnUpdateInfo(WPARAM wParam, LPARAM lParam)
{
	return UpdateInfo();
}

BOOL	Digitizer::OnUpdateInfoSelection(WPARAM wParam, LPARAM lParam)
{
	return UpdateInfo(INFOLISTUPDATE_SELECTION_ONLY);
}

/// Iris 12/20/2011 ORG-1614-S3 SUPPORT_PLOT_SELECTION_BY_OBJ_AND_ROW_IN_DATA_GRID
BOOL	Digitizer::OnUpdatePlotSelection(WPARAM wParam, LPARAM lParam)
{	
	ERR_MSG("Digitizer::OnUpdatePlotSelection");
	
	int nRow = -1; // no selection
	int nActivePlot;
	if( m_Impl.CheckGetActivePlot(nActivePlot) ) // has active plot
	{
		m_Impl.SetActiveData(nActivePlot);
		
		//nRow = nActivePlot + m_pLineList->GetRowOffset();	
		//m_pLineList->SetReady(false); // Iris: to avoid enter grid select row event
		//m_pLineList->SelRow(nRow);		
		//m_pLineList->SetReady(true);
		m_pDataInfoDlg->SelData(nActivePlot);
		return TRUE;
	}
	return FALSE;
}
///End SUPPORT_PLOT_SELECTION_BY_OBJ_AND_ROW_IN_DATA_GRID

/// Iris 12/23/2011 ORG-4685-P1 FIX_AFTER_CLOSE_DLG_SOME_DIGIPLOT_OBJS_STILL_CAN_BE_SELECTED
BOOL	Digitizer::OnUpdateFromPlot(WPARAM wParam, LPARAM lParam)
{
	/// Iris 9/7/2012 ORG-5112-P14 FIX_DEL_POINTS_NOT_UPDATE_DATA_TAB_GRID
	//return m_Impl.UpdateFromPlot(wParam);
	//return m_Impl.UpdateFromPlot(wParam) && m_pLineList->UpdateRows();
	return m_Impl.UpdateFromPlot(wParam) && m_pDataInfoDlg->UpdateGrid();
	///End FIX_DEL_POINTS_NOT_UPDATE_DATA_TAB_GRID
}

BOOL	Digitizer::OnCheckEnableDigitize(WPARAM wParam, LPARAM lParam)
{
	return CheckEnableDigitize();
}
///End FIX_AFTER_CLOSE_DLG_SOME_DIGIPLOT_OBJS_STILL_CAN_BE_SELECTED

/// Iris 12/29/2011 ORG-4685-P2 FIX_REOPEN_DLG_DATA_PLOT_SELECTION_PROBLEM
BOOL	Digitizer::OnCheckSetActivePlot(WPARAM wParam, LPARAM lParam)
{
	return m_Impl.ActivatePlot();
}
///End FIX_REOPEN_DLG_DATA_PLOT_SELECTION_PROBLEM

/// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
BOOL	Digitizer::OnDoDigitizeAreaCalc(WPARAM wParam, LPARAM lParam)
{	
	/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
	/*
	double x = min(m_stMouseDownPos.x, m_stMouseUpPos.x);
	double y = min(m_stMouseDownPos.y, m_stMouseUpPos.y);
	double width = abs(m_stMouseDownPos.x - m_stMouseUpPos.x);
	double height = abs(m_stMouseDownPos.y - m_stMouseUpPos.y);		
	*/
	double x, y, width, height;
	if( !getMouseDragRect(x, y, width, height) )
		return error_report("Fail to get selection from mouse down & up");
	///End IMPROVE_DELETE_POINTS
	
	DigiROIGridInfo stROIGridInfo;
	m_Impl.GetDigitizeROIGridInfo(stROIGridInfo);
	if( !stROIGridInfo.bVertical )
		x =  x + width; // for vertical grid (x, y) is the top-left point; else (x, y) is the top-right point.
	int angle = stROIGridInfo.bVertical ? 0 : 90;
	m_Impl.DigitizeAreaAndAddPoints(x, y, width, height, angle, stROIGridInfo.nStep); // 10, hard code for angle temp
	
	afterDigitize();
	return TRUE;
}
///End MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA

/// Iris 2/29/2012 ORG-4794-S3 IMPROVE_DELETE_POINTS
bool	Digitizer::getMouseDragRect(double& x, double& y, double& width, double& height)
{
	if( isBitmapButtonDown(IDC_DIGITIZER_AREA) || isBitmapButtonDown(IDC_DIGITIZER_DELETE_POINT) )
	{
		x = min(m_stMouseDownPos.x, m_stMouseUpPos.x);
		y = min(m_stMouseDownPos.y, m_stMouseUpPos.y);
		width = abs(m_stMouseDownPos.x - m_stMouseUpPos.x);
		height = abs(m_stMouseDownPos.y - m_stMouseUpPos.y);			
		return true;
	}
	return false;
}

BOOL	Digitizer::OnDoDeletePoints(WPARAM wParam, LPARAM lParam)
{	
	double x, y, width, height;
	if( !getMouseDragRect(x, y, width, height) )
	{
		return error_report("Fail to get selection from mouse down & up");
	}
	else
	{
		string str;
		str.Format("Del Rect, x = %g, y = %g, width = %g, height = %g", x, y, width, height);
		ERR_MSG(str);
	}
	
	if( m_Impl.DeletePoints(x, y, width, height) )
		//m_pLineList->UpdateRows();
		m_pDataInfoDlg->UpdateGrid();
	return TRUE;
}
///End IMPROVE_DELETE_POINTS

///// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
//BOOL	Digitizer::OnVertexUpdated(WPARAM wParam, LPARAM lParam)
//{
	//return m_pTernaryAxesInfoDlg->OnVertexUpdated(wParam, lParam);
//}
/////End SUPPORT_TERNARY_IN_DIGITIZER

///// Iris 12/14/2011 ORG-1614-S1 IMPROVE_MULTIPLE_CURVES
//void	Digitizer::OnLineInfoGridAfterEdit(Control ctrl, int nRow, int nCol)
//{
	//if( LINEINFO_COL_SHOW == nCol )
	//{
		////string str = m_pLineList->GetCell(nRow, nCol);
		////int nLineIndex = nRow - m_pLineList->GetRowOffset();		
		////m_Impl.ShowDataPlot(nLineIndex, (bool)atoi(str));
		//int nLineIndex;
		//bool bShow = m_pDataInfoDlg->GetLineShowStatus(nRow, &nLineIndex);
		//m_Impl.ShowDataPlot(nLineIndex, bShow);
	//}
//}
//
//void 	Digitizer::OnLineInfoGridBeforeEdit(Control cntrl, int nRow, int nCol, BOOL* pCancel)
//{
	////m_pLineList->OnBeforeEdit(nRow, nCol, pCancel);
	//m_pDataInfoDlg->OnGridBeforeEdit(nRow, nCol, pCancel);
//}
/////End IMPROVE_MULTIPLE_CURVES
//
///// Iris 12/20/2011 ORG-1614-S3 SUPPORT_PLOT_SELECTION_BY_OBJ_AND_ROW_IN_DATA_GRID
//void 	Digitizer::OnLineInfoGridSelRowChange(Control ctrl)
//{
	////if( m_pLineList->IsReady() )
	////{
		////int nIndex = m_pLineList->GetSelectedRow() - m_pLineList->GetRowOffset();
		////ERR_MSG("data index=" + (string)nIndex); 
		//
		//int nIndex = m_pDataInfoDlg->GetActiveData();
		//if( nIndex >=0 )
		//{
			//m_Impl.SetActiveData(nIndex);
			//m_Impl.ActivatePlot();
		//}
	////}
//}
/////End SUPPORT_PLOT_SELECTION_BY_OBJ_AND_ROW_IN_DATA_GRID

//------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
BOOL	Digitizer::OnDataPlotEdit(GraphObject go, int nIndex)
{
	return m_Impl.DataPlotEdit(nIndex);
}
///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH

/// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
enum 
{
	DIGI_AREA_PREVIEW_READY, // when click Digitize Area button, but not click mouse down
	DIGI_AREA_PREVIEW_START, // mouse down
	DIGI_AREA_PREVIEW_DOING, // move mouse
	DIGI_AREA_PREVIEW_DOWN,  // mouse up
};

static bool _set_LT_var(LPCSTR lpcszVar, int nVal)
{
	string str;
	str.Format("%s=%d;", lpcszVar, nVal);
	return LT_execute(str);
}

bool	Digitizer::isBitmapButtonDown(int nID)
{	
	BitmapRadioButton	btn = GetItem(nID);
	if( btn )
		return btn.PressedDown;
	return false;
}
///End MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA

/// Iris 12/27/2011 ORG-4685-S3 NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE
BOOL 	Digitizer::OnPageMouseMove(Page pg, LPVOID lpst)
{	
	GraphPage gp = m_Impl.GetDigitizePage();
	if( NULL == lpst || !pg || !gp || 0 != gp.GetName().Compare(pg.GetName()) )
		return FALSE;				
	
	PageMouseEventMsgPtr pst = (PageMouseEventMsgPtr)lpst;
	double x = pst->x;
	double y = pst->y;	
	
	/// Iris 9/03/2012 ORG-5112-P5 TO_FIND_GOOD_START_POINT_FOR_AUTO_TRACE_LINE
	double dTraceX = x, dTraceY = y;
	m_Impl.BeforeAutoTraceLine(dTraceX, dTraceY);
	///End TO_FIND_GOOD_START_POINT_FOR_AUTO_TRACE_LINE
	
	//string str;
	//str.Format("Page = %s, X=%g, Y= %g", pg.GetName(), x, y);
	//out_str(str);
	//return TRUE;	
		
	return UpdateMagnifier(&x, &y);	
}
///End NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE

/// Iris 01/19/2012 ORG-4794-S1 MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA
BOOL	Digitizer::OnPageMouseLButtonDown(Page pg, LPVOID lpst)
{	
	GraphPage gp = m_Impl.GetDigitizePage();
	if( NULL == lpst || !pg || !gp || 0 != gp.GetName().Compare(pg.GetName()) )
		return FALSE;	
	
	bool bDigitizingArea = isBitmapButtonDown(IDC_DIGITIZER_AREA);
	bool bDeletingPoints = isBitmapButtonDown(IDC_DIGITIZER_DELETE_POINT);
	if( bDigitizingArea || bDeletingPoints )
	{	
		PageMouseEventMsgPtr pst = (PageMouseEventMsgPtr)lpst;				
		m_stMouseDownPos = *pst;			
		return TRUE;
	}
	
	return FALSE;		
}

BOOL	Digitizer::OnPageMouseLButtonUp(Page pg, LPVOID lpst)
{	
	GraphPage gp = m_Impl.GetDigitizePage();
	if( NULL == lpst || !pg || !gp || 0 != gp.GetName().Compare(pg.GetName()) )
		return FALSE;	

	bool bDigitizingArea = isBitmapButtonDown(IDC_DIGITIZER_AREA);
	bool bDeletingPoints = isBitmapButtonDown(IDC_DIGITIZER_DELETE_POINT);
	
	if( bDigitizingArea || bDeletingPoints )
	{			
		PageMouseEventMsgPtr pst = (PageMouseEventMsgPtr)lpst;
		m_stMouseUpPos = *pst;
		
		if( bDigitizingArea )
		{
			PostMessage(ID_DIGITIZER_MSG_DO_DIGITIZE_AREA_CALA); // to wait graph redraw done and then do digitize area
			return TRUE;
		}
		
		if( bDeletingPoints )
		{
			PostMessage(ID_DIGITIZER_MSG_DO_DELETE_POINTS); // to wait graph redraw done and then do digitize area
			return TRUE;
		}
	}
	return FALSE;	
}
///End MOUSE_DOW_AND_UP_TO_SELECT_DIGI_AREA

/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
//int		Digitizer::getMagnifierFactor()
//{	
	//return m_sld.Position * 10; // return 10 ~ 100, the percent of image
//}

BOOL	Digitizer::UpdateMagnifier(double* px, double* py)
{
	if( px != NULL )
		m_dPreviewPointX = *px;
	if( py != NULL )
		m_dPreviewPointY = *py;	
	
	if( m_dPreviewPointX < 0 || m_dPreviewPointY < 0 ) // this moment not pick any point yet		
		return false;
	
	//TabControl tab = GetItem(IDC_DIGITIZER_TAB);
	if( m_tab.GetCurSel() != DIGITIZER_DATA_TAB )		
		return false;
		
	//int nROIPercent = getMagnifierFactor();
	int nROIPercent = m_pDataInfoDlg->GetMagnifierFactor();
	
	bool bRet = m_Impl.GetImageROI(m_pLBROI, m_dPreviewPointX, m_dPreviewPointY, nROIPercent);
	
	if( bRet && m_pLBROI )
	{
		//m_picControl.SetLeadBitmap(m_pLBROI, false);	
		m_pDataInfoDlg->UpdateMagnifier(m_pLBROI);
		return true;
	}
	return false;
}

BOOL	Digitizer::NotifyAxesPanel(int nMsg, bool bPost/* = FALSE*/, UINT wParam/* = 0*/, UINT lParam/* = 0*/)
{
	if( bPost )
	{
		return getAxesInfoDlgPointer()->PostMessage(nMsg, wParam, lParam);
	}
	else
	{
		return getAxesInfoDlgPointer()->SendMessage(nMsg, wParam, lParam);
	}
}

int		Digitizer::getToolbarButtonIDs(vector<int>& vnBtnIDs)
{
	const vector<int>	vnIDs = {IDC_DIGITIZER_IMPORT, 
							///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
							IDC_DIGITIZER_IMPORT_FROM_CLIPBOARD,
							///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
						    IDC_DIGITIZER_EDIT,
						    
						    IDC_DIGITIZER_NEW_LINE,
						    IDC_DIGITIZER_REMOVE_GRIDLINE,
						    IDC_DIGITIZER_TRACE_LINE,
						    IDC_DIGITIZER_AREA,
						    IDC_DIGITIZER_GO,
						    IDC_DIGITIZER_DELETE_POINT,
						    
						    IDC_DIGITIZER_REORDER_POINT,
						    IDC_DIGITIZER_UNDO
							};
							
	vnBtnIDs = vnIDs;
	return vnBtnIDs.GetSize();	
}
///End DIGITIZER_SUPPORT_MAGNIFIER

BOOL	Digitizer::InitRadioBitmapButtons()
{
	/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	/*
	vector<int>	vnBtnIDs = {IDC_DIGITIZER_IMPORT, 
						    IDC_DIGITIZER_EDIT,
						    
						    IDC_DIGITIZER_LINE,
						    IDC_DIGITIZER_REMOVE_LINE,
						    IDC_DIGITIZER_TRACE_LINE,
						    IDC_DIGITIZER_AREA,
						    IDC_DIGITIZER_GO,
						    IDC_DIGITIZER_DELETE_POINT,
						    
						    IDC_DIGITIZER_REORDER_POINT,
						    IDC_DIGITIZER_UNDO
							};
	int	nSize = vnBtnIDs.GetSize();
	*/
	vector<int>	vnBtnIDs;
	int nSize = getToolbarButtonIDs(vnBtnIDs);
	///End DIGITIZER_SUPPORT_MAGNIFIER
	
	vector<int> vnBmpIDs = {  IDB_IMPORT_IMAGE
							///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
							, IDB_IMPORT_IMAGE_FROM_CLIPBOARD
							///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
							, IDB_AXES_EDIT
							
							/// Iris 2/20/2012 ORG-3841-S2 IMPROVED_TOOLBAR_BUTTON
							//, IDB_IPROFILE_SEPARATE_GRAPH
							//, IDB_DEL_WKS_GRAPH
							//, IDB_GOTO_GRAPH
							, IDB_RESET_POINTS
							, IDB_REMOVE_GRIDLINE
							, IDB_AUTO_TRACE
							///End IMPROVED_TOOLBAR_BUTTON
							, IDB_DITIGIZE_AREA
							, IDB_DIGITIZE
							/// Iris 2/20/2012 ORG-3841-S2 IMPROVED_TOOLBAR_BUTTON
							//, IDB_DEL_WKS_GRAPH
							, IDB_REMOVE_POINTS
							//End IMPROVED_TOOLBAR_BUTTON
							
							, IDB_REORDER_PEAKS
							, IDB_UNDO
							};
	O_A(nSize == vnBmpIDs.GetSize());

	vector<string> vsTips(nSize);
	int ii = 0;
	vsTips[ii++] = _L("Open");
	///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	vsTips[ii++] = _L("Import from Clipboard");
	///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	vsTips[ii++] = _L("Edit Axes");
	
	/// Iris 2/20/2012 ORG-3841-S2 IMPROVED_TOOLBAR_BUTTON
	//vsTips[ii++] = _L("Add Line");
	vsTips[ii++] = _L("New Line");
	///End IMPROVED_TOOLBAR_BUTTON
	vsTips[ii++] = _L("Remove Gridlines");
	vsTips[ii++] = _L("Auto Trace Line");
	vsTips[ii++] = _L("Digitize Area");	
	vsTips[ii++] = _L("Pick Point");
	/// Iris 2/20/2012 ORG-3841-S2 IMPROVED_TOOLBAR_BUTTON
	//vsTips[ii++] = _L("Delete Point");
	vsTips[ii++] = _L("Delete Points");
	///End IMPROVED_TOOLBAR_BUTTON
	
	vsTips[ii++] = _L("Reorder Points");
	vsTips[ii++] = _L("Undo");
	O_A(nSize == ii);
	
	for ( ii=0; ii<nSize; ++ii )
	{
		vector<string>	vs;
		vs.Add(vsTips[ii]);
		InitRadioBitmapButton(vnBtnIDs[ii], vnBmpIDs[ii], 1, &vs);
	}
	return TRUE;
}

void	Digitizer::initControlPosition()
{
	int nGap = GetControlGap();
	vector<uint> vnBtns = {IDC_DIGITIZER_IMPORT, IDC_DIGITIZER_IMPORT_FROM_CLIPBOARD, IDC_DIGITIZER_EDIT, 0};
	ArrangeControlsLeftRight(vnBtns, nGap, nGap, 0);
	
	RECT rrRight;
	GetClientRect(GetItem(IDC_DIGITIZER_EDIT), rrRight);
	vector<uint> vnBtns2 = {IDC_DIGITIZER_NEW_LINE,
						    IDC_DIGITIZER_REMOVE_LINE,
						    IDC_DIGITIZER_TRACE_LINE,
						    IDC_DIGITIZER_AREA,
						    IDC_DIGITIZER_GO,
						    IDC_DIGITIZER_DELETE_POINT,
						    0};
	ArrangeControlsLeftRight(vnBtns2, rrRight.right+2*GetControlGap(), nGap, 0);
	
	GetClientRect(GetItem(IDC_DIGITIZER_DELETE_POINT), rrRight);					    
	vector<uint> vnBtns3 = {IDC_DIGITIZER_REORDER_POINT,
						    IDC_DIGITIZER_UNDO,
							0};
	int nBottom = ArrangeControlsLeftRight(vnBtns3, rrRight.right+2*GetControlGap(), nGap, 0);
	
	//Control cMainItem = GetItem(IDC_DIGITIZER_TAB);
	//if(cMainItem)
	if(m_tab)
	{
		RECT rrMain;
		rrMain.left = nGap;
		rrMain.top = nBottom + GetControlGap();
		MoveControl(m_tab, rrMain);
	}
	
	RECT rDlg;
	m_wndDlg.GetClientRect(&rDlg);
	OnDlgResize(0, RECT_WIDTH(rDlg), RECT_HEIGHT(rDlg));
}

BOOL	Digitizer::UpdateAxesEditing()
{
	BitmapRadioButton	btn = GetItem(IDC_DIGITIZER_EDIT);
	btn.PressedDown = m_Impl.IsAxesEditing();
	//CheckMenuItem(IDC_DIGITIZER_MENU_EDIT_AXES, btn.PressedDown);	//move CheckMenuItem to OnUiUpdateMenu
	return UpdateInfoSelectable();
}

/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
void	Digitizer::updateDigitizeGridStatus()
{
	m_Impl.UpdateROIGirdStatus();
	
	BitmapRadioButton	btn = GetItem(IDC_DIGITIZER_AREA);
	btn.PressedDown = m_Impl.IsDigitizingArea();	
	btn = GetItem(IDC_DIGITIZER_DELETE_POINT);
	btn.PressedDown = m_Impl.IsDeletingPoints();	
}
///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE

BOOL	Digitizer::UpdateShowXYRefLine()
{
	//move CheckMenuItem to OnUiUpdateMenu
	//CheckMenuItem(IDC_DIGITIZER_MENU_SHOW_XREF, !m_Impl.IsX1FromYAxis());
	//CheckMenuItem(IDC_DIGITIZER_MENU_SHOW_YREF, !m_Impl.IsY1FromXAxis());
	
	return TRUE;
}

///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
BOOL	Digitizer::UpdateLabelEditing()
{
	//CheckMenuItem(IDC_DIGITIZER_MENU_SET_LABEL, m_Impl.IsLabelEditing());		//move CheckMenuItem to OnUiUpdateMenu
	return TRUE;
}

BOOL	Digitizer::CheckEnableRotation()
{
	//move EnableMenuItem to OnUiUpdateMenu
	return TRUE;
}
///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

BOOL	Digitizer::CheckEnableGotoImage()
{
	//move EnableMenuItem to OnUiUpdateMenu
	return TRUE;
}

BOOL	Digitizer::CheckEnableGotoData()
{
	//move EnableMenuItem to OnUiUpdateMenu
	return TRUE;
}

BOOL	Digitizer::CheckUpdateOnDlgShow(BOOL bShow)
{
	return m_Impl.CheckUpdateOnDlgShow(bShow);
}
BOOL	Digitizer::UpdateStates()
{
	BOOL	bValid = m_Impl.HasValidDigitizeImage();
	if ( bValid )
	{
		m_Impl.Update(TRUE);
		
		UpdateAxesEditing();		
		UpdateShowXYRefLine();
		UpdateLabelEditing();
		
		m_glImage = m_Impl.GetDigitizeLayer();
	}

	UpdateInfo(INFOLISTUPDATE_RESET_ROWS);
	//m_pLineList->UpdateRows(); /// Iris 01/18/2012 ORG-4894-P1 FIX_MAGNIFIER_NOT_WORK_WHEN_IMPORT_IMAGE_BY_OPEN_BUTTON
	//m_pDataInfoDlg->UpdateGrid();

	vector<int>		vnCntrlIDs = { IDC_DIGITIZER_ADJUST_SCALE
	, IDC_DIGITIZER_EDIT
		, IDC_DIGITIZER_SHOW_XREF
		, IDC_DIGITIZER_SHOW_YREF
	};
	BOOL	bEnable = IsButtonsEnable();
	for ( int ii=0; ii<vnCntrlIDs.GetSize(); ++ii )
	{
		Control ctrl = GetItem(vnCntrlIDs[ii]);
		if(!ctrl)
			continue;
		ctrl.Enable = bEnable;
	}

	return UpdateDlgTitle()
		&& CheckEnableDigitize()
		//&& CheckEnableGotoImage()
		///------ Folger 12/30/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
		&& CheckEnableRotation()
		///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
		//&& CheckEnableGotoData()
		;
}

BOOL	Digitizer::UpdateInfo(DWORD dwCntrls/* = 0*/)
{
	//return m_pInfo->Update(dwCntrls);
	return getAxesInfoDlgPointer()->Update(dwCntrls);
}

BOOL	Digitizer::UpdateDlgTitle()
{
	Text = m_Impl.HasValidDigitizeImage() ? m_Impl.GetTitle() : STR_DLG_NAME_L;
	return TRUE;
}

BOOL	Digitizer::UpdateInfoSelectable(BOOL bResetRowSelection/* = FALSE*/)
{
	//return m_pInfo->UpdateSelectable(bResetRowSelection);
	return getAxesInfoDlgPointer()->UpdateGridSelectable(bResetRowSelection);
}

BOOL	Digitizer::CheckEnableDigitize()
{
	BOOL	bReadyToDigitize = m_Impl.HasValidDigitizeImage() && m_Impl.IsReadyToDigitize() && IsButtonsEnable();
	GetItem(IDC_DIGITIZER_GO).Enable = bReadyToDigitize;
	
	//GetItem(IDC_DIGITIZER_RESET).Enable = bReadyToDigitize && m_Impl.HasDataPoint();
	
	/////------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	//GetItem(IDC_DIGITIZER_SET_LABEL).Enable = m_Impl.HasValidDigitizeImage() && !m_Impl.IsRotationMode() && m_Impl.HasDataPoint();
	/////------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	
	/// Iris 01/06/2012 ORG-4794-S1 IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	GetItem(IDC_DIGITIZER_AREA).Enable = 
	GetItem(IDC_DIGITIZER_NEW_LINE).Enable = 
	GetItem(IDC_DIGITIZER_REMOVE_LINE).Enable =
	//GetItem(IDC_DIGITIZER_UNDO).Enable = /// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
	bReadyToDigitize;
	///End IMRPOVE_DIGITIZER_AREA_AND_AUTO_TRACE_LINE
	
	/// Iris 2/03/2012 ORG-4977-S1 SUPPORT_UNDO_FOR_IMAGE_PROCESS
	GetItem(IDC_DIGITIZER_UNDO).Enable = bReadyToDigitize && m_Impl.IsUndoEnable();
	///End SUPPORT_UNDO_FOR_IMAGE_PROCESS
	
	///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE 
	GetItem(IDC_DIGITIZER_TRACE_LINE).Enable = bReadyToDigitize;		
	GetItem(IDC_DIGITIZER_DELETE_POINT).Enable	= 
	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	//GetItem(IDC_DIGITIZER_REORDER_POINT).Enable	= m_Impl.HasValidDigitizeImage() && !m_Impl.IsRotationMode() && m_Impl.HasDataPoint();
	GetItem(IDC_DIGITIZER_REORDER_POINT).Enable	= m_Impl.HasValidDigitizeImage() && m_Impl.HasDataPoint();
	///End FIX_ROTATE_GETN_DLG_ISSUE
	///End DIGITIZER_AUTO_TRACE_LINE
	return TRUE;
}
	
///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
BOOL		Digitizer::IsButtonsEnable()
{
	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	//return m_Impl.HasValidDigitizeImage() && !m_Impl.IsRotationMode() && !m_Impl.IsLabelEditing();
	return m_Impl.HasValidDigitizeImage() && !m_Impl.IsLabelEditing();
	///End FIX_ROTATE_GETN_DLG_ISSUE
}
///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

/*------------------------------------------------------------------------------*
 * Digitizer End		 														*
 *------------------------------------------------------------------------------*/
 

/*------------------------------------------------------------------------------*
 * Image Rotate GetN Dialog			 											*
 *------------------------------------------------------------------------------*/
enum
{
	DEGREE_OPTION_180,
	DEGREE_OPTION_90_CW,
	DEGREE_OPTION_90_CCW,
	DEGREE_OPTION_ARBITRARY
};

enum
{
	ORIENTATION_CW,
	ORIENTATION_CCW
};

static void ImageRotateGetNDlg()
{
	/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
	s_bImageRotated = false;
	DigitizerImpl	digitizerImpl;
	digitizerImpl.BackupImage();
	///End FIX_ROTATE_GETN_DLG_ISSUE
	
	GETN_TREE(tr)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG

    GETN_RADIO_INDEX(degreeChoice, 0, "180 Degree|90 Degree CW|90 Degree CCW|Arbitrary")
        GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)
        GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
        GETN_OPTION_EVENT_EX(_degree_choice)
	
    GETN_LIST(Orientation, _L("Direction"), 0, _L("CW|CCW"))
    GETN_STR(Angle, _L("Angle (Degree)"), _L("45.5"))					GETN_OPTION_EVENT_EX(_rotate_image)
    GETN_BUTTON_GROUP(Direction, _L("Angle Tuning"), 0, _L("<<|>>"))	GETN_OPTION_EVENT_EX(_rotate_image)		GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_HORZ)
    GETN_STR(Inc, _L("Tuning Increment (Degree)"), _L("0.5"))           GETN_OPTION_EVENT_EX(_rotate_image) 	
	
    if( GetNBox(tr, _L("Image Rotate")) )
    {    	
		double dAngle = 0;
    	int nOption = tr.degreeChoice.nVal;
		switch(nOption)
		{
		case DEGREE_OPTION_180:
			dAngle = 180;
			break;
			
		case DEGREE_OPTION_90_CW:
			dAngle = 90;
			break;
			
		case DEGREE_OPTION_90_CCW:
			dAngle = -90;
			break;
			
		case DEGREE_OPTION_ARBITRARY:
			dAngle = tr.Angle.dVal;
			if( ORIENTATION_CCW == tr.Orientation.nVal ) 
			{
				dAngle = 0 - dAngle;
			}
			break;
			
		default:
			ASSERT(false);
			break;
		}
		
		/// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
		//DigitizerImpl	digitizerImpl;
		//digitizerImpl.RotateImage(&dAngle);
		digitizerImpl.RotateImage(&dAngle, NULL, true);
		///End FIX_ROTATE_GETN_DLG_ISSUE
    }  
    /// Iris 2/16/2012 ORG-4977-P1 FIX_ROTATE_GETN_DLG_ISSUE
    else // if user clicked Cancel button 
    {
    	digitizerImpl.ResetImage();
    }
    ///End FIX_ROTATE_GETN_DLG_ISSUE
}

static bool _degree_choice(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	if( !trNode || trNode.IsEmpty() )
		return false;
	
	int nRadioOption = trNode.nVal;
	bool bShowCtrls = DEGREE_OPTION_ARBITRARY == nRadioOption;
	
	myTree.Orientation.Show =
	myTree.Angle.Show =
	myTree.Direction.Show =
	myTree.Inc.Show =
	bShowCtrls;
	return true;
}
/*------------------------------------------------------------------------------*
 * Image Rotate GetN Dialog End													*
 *------------------------------------------------------------------------------*/
 
/*------------------------------------------------------------------------------*
 * Image Eraser GetN Dialog			 											*
 *------------------------------------------------------------------------------*/
 
/*------------------------------------------------------------------------------*
 * Image Eraser GetN Dialog End													*
 *------------------------------------------------------------------------------*/
 
/*------------------------------------------------------------------------------*
 * utilities function	 														*
 *------------------------------------------------------------------------------*/
 
///Rex 2/1/2012 ORG-4794-S4 IMPROVE_DIGITIZER_CURVE_DETECT
int digitizer_convert_to_gray(const MatrixObject& moSrcImg, MatrixObject& moDstImg)
{
	if(!moSrcImg)
		return -1;

	int stype = moSrcImg.GetInternalData();
	if(stype != FSI_BYTE && stype != FSI_ULONG)
		return -1;

	int nRows = moSrcImg.GetNumRows(), nCols = moSrcImg.GetNumCols();
	_SET_MAT_SIZE(moDstImg, nRows, nCols)
	_SET_MAT_DATA_TYPE(moDstImg, FSI_BYTE)
	
	bool bRGB = stype == FSI_BYTE ? false : true; 	
	CvMat matSrc, matGray;
	matSrc = cvMat(nRows, nCols, bRGB ? CV_8UC4 : CV_8UC1, moSrcImg.GetDataObject());
	matGray = cvMat(nRows, nCols, CV_8UC1, moDstImg.GetDataObject());
	if(bRGB)
		cvCvtColor(&matSrc, &matGray, CV_RGBA2GRAY);
	else
		cvCopy(&matSrc, &matGray);
	
	return 0;
}
///End IMPROVE_DIGITIZER_CURVE_DETECT


///Rex 10/18/2011 RSRCH-72 DIGITIZER_AUTO_TRACE_LINE_FUNCTIONS 
//enum {OCV_CURVE_BACKGD = 0, OCV_CURVE_SALIENT = 1, OCV_CURVE_LOCALMAX = 100, OCV_CURVE_TRACED = 255};
///Rex 2/1/2012 ORG-4794-S4 IMPROVE_DIGITIZER_CURVE_DETECT
//int digitizer_curve_detect(const MatrixObject& moImage, MatrixObject& moSalient, MatrixObject& moAngle, MatrixObject& moMask, double dSigma /*= 2.0*/)
//{
//	if(!moImage || (moImage.GetInternalData() != FSI_BYTE && moImage.GetInternalData() != FSI_ULONG) )
//		return -1;
//	
//	if(dSigma < 0)
//		dSigma = 2.0;	
//	
//	int nRows, nCols, nRet;
//	matrix<byte> mGrayImg;	
//	CvMat matSrcImg, matGrayImg, matSalient, matAngle, matMask;
//	double dThreshold = ocvCurveSalientThreshold(dSigma);
//	
//	nRows = moImage.GetNumRows();
//	nCols = moImage.GetNumCols();	
//	if(moImage.GetInternalData() != FSI_ULONG)
//	if(is_image_grayscale(moImage))
//	{
//		matGrayImg = cvMat(nRows, nCols, CV_8UC1, moImage.GetDataObject());
//	}
//	else
//	{	
//		/// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED
//		//mGrayImg.SetSize(nRows, nCols);
//		_SET_MAT_SIZE(mGrayImg, nRows, nCols)
//		///End IMPROVE_DIGITIZER_AREA_SPEED
//		
//		matSrcImg = cvMat(nRows, nCols, CV_8UC4, moImage.GetDataObject());
//		matGrayImg = cvMat(nRows, nCols, CV_8UC1, &mGrayImg[0][0]);
//		cvCvtColor(&matSrcImg, &matGrayImg, CV_RGBA2GRAY);
//	}
//	
//	/// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED	
//	/*
//	moSalient.SetSize(nRows, nCols);	
//	moSalient.SetInternalData(FSI_REAL);		
//	moAngle.SetSize(nRows, nCols);		
//	moAngle.SetInternalData(FSI_REAL);	
//	moMask.SetSize(nRows, nCols);	
//	moMask.SetInternalData(FSI_BYTE);
//	*/
//	_SET_MAT_SIZE(moSalient, nRows, nCols)
//	_SET_MAT_DATA_TYPE(moSalient, FSI_REAL)
//	_SET_MAT_SIZE(moAngle, nRows, nCols)
//	_SET_MAT_DATA_TYPE(moAngle, FSI_REAL)
//	_SET_MAT_SIZE(moMask, nRows, nCols)
//	_SET_MAT_DATA_TYPE(moMask, FSI_BYTE)
//	///End IMPROVE_DIGITIZER_AREA_SPEED
//	
//	matSalient = cvMat(nRows, nCols, CV_32FC1, moSalient.GetDataObject());
//	matAngle = cvMat(nRows, nCols, CV_32FC1, moAngle.GetDataObject());
//	matMask = cvMat(nRows, nCols, CV_8UC1, moMask.GetDataObject());
//	
//	nRet = ocvCurveSalientsAndOrients(&matGrayImg, &matSalient, &matAngle, dSigma);
//	if(nRet < 0) return nRet;
//	
//	nRet = ocvFindCurveCenter(&matSalient, &matAngle, &matMask, dThreshold);
//	if(nRet < 0) return nRet;
//	
//	return 0;
//}
int digitizer_curve_detect(const MatrixObject& moImage, const MatrixObject& moMask, 
						   MatrixObject& moSalient, MatrixObject& moAngle, MatrixObject& moCurveMask, 
						   double dSigma/*=2.0*/)
{
	if(!moImage)
		return -1;
	
	int	nRows = moImage.GetNumRows(), nCols = moImage.GetNumCols();	
	int stype =  moImage.GetInternalData();
	if(stype != FSI_BYTE && stype != FSI_ULONG)
		return -1;
	
	if(moMask && (moMask.GetNumRows() != nRows || moMask.GetNumCols() != nCols ||
	   moMask.GetInternalData() != FSI_BYTE))
		return -1;
	
	if(dSigma < 0)
		dSigma = 2.0;	
	
	int nRet = 0;
	double dThreshold = ocvCurveSalientThreshold(dSigma);
	CvMat matGray, matSalient, matAngle, matCurveMask;
	if(stype == FSI_BYTE)
	{
		matGray = cvMat(nRows, nCols, CV_8UC1, moImage.GetDataObject());
		_SET_MAT_SIZE(moMask, nRows, nCols)
		_SET_MAT_DATA_TYPE(moMask, FSI_BYTE)
	}
	else
	{	
		nRet = digitizer_convert_to_gray(moImage, moCurveMask);
		if(nRet < 0)
			return nRet;
		matGray = cvMat(nRows, nCols, CV_8UC1, moCurveMask.GetDataObject());	
	}
	
	_SET_MAT_SIZE(moSalient, nRows, nCols)
	_SET_MAT_DATA_TYPE(moSalient, FSI_REAL)
	_SET_MAT_SIZE(moAngle, nRows, nCols)
	_SET_MAT_DATA_TYPE(moAngle, FSI_REAL)
	
	matSalient = cvMat(nRows, nCols, CV_32FC1, moSalient.GetDataObject());
	matAngle = cvMat(nRows, nCols, CV_32FC1, moAngle.GetDataObject());
	matCurveMask = cvMat(nRows, nCols, CV_8UC1, moCurveMask.GetDataObject());
	
	nRet = ocvCurveSalientsAndOrients(&matGray, &matSalient, &matAngle, dSigma);
	if(nRet < 0) return nRet;
	
	nRet = ocvFindCurveCenter(&matSalient, &matAngle, &matCurveMask, dThreshold);
	if(nRet < 0) return nRet;
	
	if(moMask)
	{
		CvMat matMask;
		matMask = cvMat(nRows, nCols, CV_8UC1, moMask.GetDataObject());		
		cvAnd(&matMask, &matCurveMask, &matCurveMask);
		CvScalar scalar;
		scalar = cvScalar(OCV_CURVE_LOCALMAX);
		cvSet(&matCurveMask, scalar, &matCurveMask);
	}
	
	return 0;
}
///End IMPROVE_DIGITIZER_CURVE_DETECT

///Rex 2012/7/11 ORG-5112-P5 FIND_BETTER_TRACE_START_POINT_IN_NEIGHBORHOOD
int digitizer_find_trace_start(const MatrixObject& moMask, int& x, int& y, int radius)
{	
	if (!moMask || moMask.GetInternalData() != FSI_BYTE)
		return -1;
	
	int nRows = moMask.GetNumRows(), nCols = moMask.GetNumCols();
	if (x < 0 || x > nCols-1 || y < 0 || y > nRows)
		return -1;
	
	CvMat matMask;
	CvPoint ptStart;
	matMask = cvMat(nRows, nCols, CV_8UC1, moMask.GetDataObject());
	matMask.type = CV_8UC1;
	ptStart = cvPoint(x, y);
	
	int nRet = ocvFindTraceStart(&matMask, &ptStart, radius);
	if (nRet > 0)
	{
		x = ptStart.x; 
		y = ptStart.y;
	}
	
	return nRet;		
}
///End FIND_BETTER_TRACE_START_POINT_IN_NEIGHBORHOOD

int digitizer_curve_trace(const MatrixObject& moSalient, MatrixObject& moAngle, MatrixObject& moMask, int x0, int y0, vector<int>& vX, vector<int>& vY)
{
	if( !moSalient || moSalient.GetInternalData() != FSI_REAL ||
		!moAngle || moAngle.GetInternalData() != FSI_REAL ||
		!moMask || moMask.GetInternalData() != FSI_BYTE)
		return -1;
	
	int nRows = moSalient.GetNumRows(), nCols = moSalient.GetNumCols();
	if( nRows != moAngle.GetNumRows() || nCols != moAngle.GetNumCols() ||
		nRows != moMask.GetNumRows() || nCols != moMask.GetNumCols())
		return -1;
		
	CvMat matSalient, matAngle, matMask;
	matSalient = cvMat(nRows, nCols, CV_32FC1, moSalient.GetDataObject());
	matAngle = cvMat(nRows, nCols, CV_32FC1, moAngle.GetDataObject());
	matMask = cvMat(nRows, nCols, CV_8UC1, moMask.GetDataObject());
	
	CvMat* pCurvePts = NULL;
	int nRet = ocvTraceCurve(&matSalient, &matAngle, &matMask, x0, y0, &pCurvePts);	
	if(nRet < 0 || pCurvePts == NULL) 
		return -1;
	
	int ii, nNum = pCurvePts->cols;
	vX.SetSize(nNum);
	vY.SetSize(nNum);
	
	int* pData = (int*)(pCurvePts->data.ptr);
	for(ii = 0; ii < nNum; ++ii)
	{
		vX[ii] = pData[ii*2];
		vY[ii] = pData[ii*2+1];
	}
	
	cvReleaseMat(&pCurvePts);
	
	return 0;
}


int digitizer_get_symbol_rect(const MatrixObject& moSrcImg, RECT& rect, int x0, int y0, 
							  int nSymSize /*= 20*/, double dLowDiff /*= 20*/, double dUpDiff /*= 20*/)
{ 
	if( !moSrcImg || moSrcImg.GetInternalData() != FSI_BYTE)
		return -1;
	
	int nRows = moSrcImg.GetNumRows(), nCols = moSrcImg.GetNumCols();
	if( x0 < 0 || y0 < 0 || x0 > nCols-1 || y0 > nRows-1)
		return -1; 
			
	matrix<byte> mSrcImg = moSrcImg.GetDataObject();
	CvMat matSrc; matSrc = cvMat(nRows, nCols, CV_8UC1, &mSrcImg[0][0]);
	
	//floodfill an area
	CvPoint seed;
	CvScalar newVal, lowDiff, upDiff;
	CvRect rect0;
	CvConnectedComp ccomp;		
	int flags;
	
	seed = cvPoint(x0, y0);
	newVal = cvScalar(1);
	lowDiff = cvScalar(dLowDiff);
	upDiff = cvScalar(dUpDiff);	
	flags = CV_FLOODFILL_MASK_ONLY + 4;//+ CV_FLOODFILL_FIXED_RANGE+4;	
	
	ocvFloodFill(&matSrc, &seed, &newVal, &lowDiff, &upDiff, &ccomp, flags);
	rect0 = ccomp.rect;
	if(ccomp.area < 1 || rect0.width > nSymSize || rect0.height > nSymSize)
		return -2;	
	
	rect.left = rect0.x > 0 ? rect0.x-1 : rect0.x;
	rect.top = rect0.y > 0 ? rect0.y-1 : rect0.y;
	rect.right = rect0.x+rect0.width < nCols-1 ?
				rect0.x+rect0.width+1 : rect0.x+rect0.width;
	rect.bottom = rect0.y+rect0.height < nRows-1 ?
				rect0.y+rect0.height+1 : rect0.y+rect0.height;

	return 0;	
}

///Rex 2/1/2012 ORG-4794-S4 IMPROVE_DIGITIZER_CURVE_DETECT
//int digitizer_clean_background(const MatrixObject& moSrcImg, MatrixObject& moDstImg, MatrixObject& moMaskImg)
//{	
//	if(!moSrcImg)
//	return -1;
//	
//	int stype = moSrcImg.GetInternalData();
//	if(stype != FSI_BYTE && stype != FSI_ULONG)
//		return -1;
//
//	int nRows = moSrcImg.GetNumRows(), nCols = moSrcImg.GetNumCols();
//	/// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED
//	/*
//	moMaskImg.SetInternalData(FSI_BYTE);
//	moMaskImg.SetSize(nRows, nCols);
//	
//	if( stype != moDstImg.GetInternalData() )
//	{
//		moDstImg.SetInternalData(stype);
//	}
//	if( nRows != moDstImg.GetNumRows() || nCols != moDstImg.GetNumCols() )
//	{
//		moDstImg.SetSize(nRows, nCols);
//	}
//	*/
//	_SET_MAT_SIZE(moMaskImg, nRows, nCols)
//	_SET_MAT_DATA_TYPE(moMaskImg, FSI_BYTE)
//	_SET_MAT_SIZE(moDstImg, nRows, nCols)
//	_SET_MAT_DATA_TYPE(moDstImg, stype)	
//	///End IMPROVE_DIGITIZER_AREA_SPEED
//	
//	CvMat matSrc, matDst, matMask, matGray;
//	int ctype = stype == FSI_BYTE ? CV_8UC1 : CV_8UC4;
//	matSrc = cvMat(nRows, nCols, ctype, moSrcImg.GetDataObject());
//	matDst = cvMat(nRows, nCols, ctype, moDstImg.GetDataObject());
//	matMask = cvMat(nRows, nCols, CV_8UC1, moMaskImg.GetDataObject());
//	
//	if( stype == FSI_ULONG)
//	{
//		matrix<byte> mGray(nRows, nCols);
//		matGray = cvMat(nRows, nCols, CV_8UC1, &mGray[0][0]);
//		cvCvtColor(&matSrc, &matGray, CV_RGBA2GRAY);
//		cvThreshold(&matGray, &matMask, 0, 255, CV_THRESH_BINARY | CV_THRESH_OTSU);
//	}	
//	else
//	{
//		cvThreshold(&matSrc, &matMask, 0, 255, CV_THRESH_BINARY | CV_THRESH_OTSU);
//	}
//	
//	CvScalar val;
//	val = cvScalarAll(255);
//	
//	ocvSet(&matDst, &val, &matMask);
//	cvNot(&matMask, &matMask);
//	cvCopy(&matSrc, &matDst, &matMask);
//
//	return 0;
//}

int digitizer_clean_background(MatrixObject& moImage, const MatrixObject& moMaskImg, int bkValue/*=255*/)
{	
	if(!moImage || !moMaskImg)
		return -1;
	
	int stype = moImage.GetInternalData();
	if(stype != FSI_BYTE && stype != FSI_ULONG || moMaskImg.GetInternalData() != FSI_BYTE)
		return -1;	

	/// Iris 2/02/2012 ORG-4794-S4 FIX_CLEAN_BACKGROUND_STRANGE_BUG
	/*
	CvScalar val;
	val = cvScalarAll(bkValue);
	CvMat matImg, matMask;
	int nRows = moImage.GetNumRows(), nCols = moImage.GetNumCols();
	matrix<byte> mMask(nRows, nCols);
	mMask = moMaskImg.GetDataObject();
	matImg = cvMat(nRows, nCols, stype = FSI_BYTE ? CV_8UC1 : CV_8UC4, moImage.GetDataObject());
	matMask = cvMat(nRows, nCols, CV_8UC1, &mMask[0][0]);
	cvNot(&matMask, &matMask);
	cvSet(&matImg, val, &matMask);
	*/
	CvMat matMask;
	int nRows = moImage.GetNumRows(), nCols = moImage.GetNumCols();
	matrix<byte> mMask(nRows, nCols);
	mMask = moMaskImg.GetDataObject();		
	matMask = cvMat(nRows, nCols, CV_8UC1, &mMask[0][0]);
	cvNot(&matMask, &matMask);	

	CvScalar val;
	val = cvScalarAll(bkValue);	
	CvMat matImg;	
	matImg = cvMat(nRows, nCols, stype == FSI_BYTE ? CV_8UC1 : CV_8UC4, moImage.GetDataObject());	
	cvSet(&matImg, val, &matMask);	
	///End FIX_CLEAN_BACKGROUND_STRANGE_BUG
	return 0;
}


int digitizer_auto_threshold(const MatrixObject& moImage, MatrixObject& moMaskImg)
{
	if(!moImage || moImage.GetInternalData() != FSI_BYTE)
		return -1;
	
	CvMat matSrc, matMask;
	int nRows = moImage.GetNumRows(), nCols = moImage.GetNumCols();	
	_SET_MAT_SIZE(moMaskImg, nRows, nCols)
	_SET_MAT_DATA_TYPE(moMaskImg, FSI_BYTE)	
	
	matSrc = cvMat(nRows, nCols, CV_8UC1, moImage.GetDataObject());
	matMask = cvMat(nRows, nCols, CV_8UC1, moMaskImg.GetDataObject());
	
	cvThreshold(&matSrc, &matMask, 0, 255, CV_THRESH_BINARY_INV|CV_THRESH_OTSU);

	return 0;
}
///End IMPROVE_DIGITIZER_CURVE_DETECT


int digitizer_remove_gridlines(const MatrixObject& moSrcImg, const MatrixObject& moSrcMask,
							   MatrixObject& moDstImg, MatrixObject& moDstMask,
							   double threshold, double minLen, double maxGap, double angleTol)
{
	if( !moSrcImg || !moSrcMask)
		return -1;
	
	int stype = moSrcImg.GetInternalData();
	if( stype != FSI_BYTE && stype != FSI_ULONG || moSrcMask.GetInternalData() != FSI_BYTE)
		return -1;
	
	int nRows = moSrcImg.GetNumRows(), nCols = moSrcImg.GetNumCols();
	/// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED
	/*
	moDstImg.SetInternalData(stype);
	moDstImg.SetSize(nRows, nCols);
	moDstMask.SetInternalData(FSI_BYTE);
	moDstMask.SetSize(nRows, nCols);
	*/
	_SET_MAT_SIZE(moDstImg, nRows, nCols)
	_SET_MAT_DATA_TYPE(moDstImg, stype)
	_SET_MAT_SIZE(moDstMask, nRows, nCols)
	_SET_MAT_DATA_TYPE(moDstMask, FSI_BYTE)	
	///End IMPROVE_DIGITIZER_AREA_SPEED
	
	CvMat matSrc, matDst, matSrcMask, matDstMask;
	matSrcMask = cvMat(nRows, nCols, CV_8UC1, moSrcMask.GetDataObject());
	matDstMask = cvMat(nRows, nCols, CV_8UC1, moDstMask.GetDataObject());	
	int nRet = ocvRemoveGridlines(&matSrcMask, &matDstMask, NULL, threshold, minLen, maxGap, angleTol);		
	if( nRet < 0)
		return nRet;
	
	CvScalar value;	
	int dtype = stype == FSI_BYTE ? CV_8UC1 : CV_8UC4;
	matSrc = cvMat(nRows, nCols, dtype, moSrcImg.GetDataObject());	
	matDst = cvMat(nRows, nCols, dtype, moDstImg.GetDataObject());	
	value = cvScalarAll(255);
	cvNot(&matDstMask, &matDstMask);	
	ocvSet(&matDst, &value, &matDstMask);
	cvNot(&matDstMask, &matDstMask);
	cvCopy(&matSrc, &matDst, &matDstMask);
	
	return 0;
}


int digitizer_match_template(const MatrixObject& moSrcImg, const MatrixObject& moTmplImg, MatrixObject& moDstImg, 
							 double threshold /*= 0.8*/)
{
	if( !moSrcImg || !moTmplImg)
		return -1;
	
	int stype = moSrcImg.GetInternalData();
	if( (stype != FSI_BYTE && stype != FSI_ULONG) ||
		stype != moTmplImg.GetInternalData())
		return -1;
	
	int nRows, nCols, nRows0, nCols0;
	nRows = moSrcImg.GetNumRows();
	nCols = moSrcImg.GetNumCols();
	nRows0 = moTmplImg.GetNumRows();
	nCols0 = moTmplImg.GetNumCols();
	/// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED
	/*
	moDstImg.SetInternalData(FSI_REAL);
	moDstImg.SetSize(nRows, nCols);
	*/
	_SET_MAT_SIZE(moDstImg, nRows, nCols)
	_SET_MAT_DATA_TYPE(moDstImg, FSI_REAL)
	///End IMPROVE_DIGITIZER_AREA_SPEED
	
	int ctype = (stype == FSI_BYTE) ? CV_8UC1 : CV_8UC4;
	CvMat matSrc, matTmpl, matDst, matRes;
	matSrc = cvMat(nRows, nCols, ctype, moSrcImg.GetDataObject());
	matDst = cvMat(nRows, nCols, CV_32FC1, moDstImg.GetDataObject());
	matTmpl = cvMat(nRows0, nCols0, ctype, moTmplImg.GetDataObject());
	
	CvRect rect; 
	rect = cvRect(min(nCols0, nCols)/2, min(nRows0, nRows)/2, abs(nCols-nCols0)+1, abs(nRows-nRows0)+1);
	ocvGetSubRect(&matDst, &matRes, &rect);
	
	cvSetZero(&matDst);
	cvMatchTemplate(&matSrc, &matTmpl, &matRes, CV_TM_CCORR_NORMED);
	
	cvNormalize(&matRes, &matRes, 0, 1, CV_MINMAX);
	cvThreshold(&matRes, &matRes, threshold, 1, CV_THRESH_TOZERO);
	
	return 0;
}

int digitizer_symbol_finding(const MatrixObject& moSrcImg, const MatrixObject& moSymImg, const MatrixObject& moMaskImg,
							 MatrixObject& moDstImg, MatrixObject& moResImg, vector<int>& vX, vector<int>& vY, vector<float>& vS,
							 double threshold)
{
	if( !moSrcImg || !moSymImg)
		return -1;
	if( moSrcImg.GetInternalData() != moSymImg.GetInternalData())
		return -1;
		
	int nRet = digitizer_match_template(moSrcImg, moSymImg, moResImg, threshold);
	if( nRet < 0)
		return nRet;
	
	CvMat matMask, matDst, matSym, matRes, matTmp, *pMaximaPts = NULL;
	int nRows = moSrcImg.GetNumRows(), nCols = moSrcImg.GetNumCols();	
	/// Iris 01/18/2012 ORG-4794-S1 IMPROVE_DIGITIZER_AREA_SPEED
	/*
	moDstImg.SetInternalData(FSI_BYTE);
	moDstImg.SetSize(nRows, nCols);
	*/
	_SET_MAT_SIZE(moDstImg, nRows, nCols)
	_SET_MAT_DATA_TYPE(moDstImg, FSI_BYTE)
	///End IMPROVE_DIGITIZER_AREA_SPEED
	
	IplConvKernel* pStel = NULL;
	int nRows0 = moSymImg.GetNumRows(), nCols0 = moSymImg.GetNumCols();		
	pStel = cvCreateStructuringElementEx(nCols0, nRows0, nCols0/2, nRows0/2, CV_SHAPE_RECT);
	matDst = cvMat(nRows, nCols, CV_8UC1, moDstImg.GetDataObject());
	matMask = cvMat(nRows, nCols, CV_8UC1, moMaskImg.GetDataObject());	
	cvDilate(&matMask, &matDst, pStel, 1);
	cvErode(&matDst, &matDst, pStel, 1);
	cvReleaseStructuringElement(&pStel);

	matrix<byte> mSym(nRows0, nCols0);
	matSym = cvMat(nRows0, nCols0, CV_8UC1, &mSym[0][0]);
	if(moSymImg.GetInternalData() == FSI_ULONG)
	{
		matTmp = cvMat(nRows0, nCols0, CV_8UC4, moSymImg.GetDataObject());		
		cvCvtColor(&matTmp, &matSym, CV_RGBA2GRAY);		
	}
	else
	{
		matTmp = cvMat(nRows0, nCols0, CV_8UC1, moSymImg.GetDataObject());
		cvCopy(&matTmp, &matSym);
	}
		
	matrix<int> mSel(nRows0, nCols0);
	CvMoments moments;	
	cvMoments(&matSym, &moments, 0);
	int x0 = moments.m00 > 0 ? moments.m10/moments.m00 : nCols0/2;
	int y0 = moments.m00 > 0 ? moments.m01/moments.m00 : nRows0/2;
	mSel = 1;
	mSel[y0][x0] = 0;		
	pStel = cvCreateStructuringElementEx(nCols0, nRows0, x0, y0, CV_SHAPE_CUSTOM, &mSel[0][0]);	
	
	matRes = cvMat(nRows, nCols, CV_32FC1, moResImg.GetDataObject());
	nRet = ocvFindLocalMaxima(&matRes, &matDst, &pMaximaPts, &matDst, pStel);
	cvReleaseStructuringElement(&pStel);
	if( nRet < 0 || pMaximaPts == NULL)
		return -1;
	
	int ii, nNum = pMaximaPts->cols;
	vX.SetSize(nNum);
	vY.SetSize(nNum);
	vS.SetSize(nNum);	
	float* pData = (float*)(pMaximaPts->data.ptr);
	for(ii = 0; ii < nNum; ++ii)
	{
		vX[ii] = (int)pData[ii*3];
		vY[ii] = (int)pData[ii*3+1];
		vS[ii] = pData[ii*3+2]
	}
	cvReleaseMat(&pMaximaPts);
	
	vector<uint> vIdx;
	vS.Sort(SORT_DESCENDING, TRUE, vIdx);
	vX.Reorder(vIdx);
	vY.Reorder(vIdx);
		
	return nRet;	
}

int digitizer_digitize_area(const MatrixObject& moBwImg, const DigitizeAreaSettings& dasSettings, vector<int>& vX, vector<int>& vY)
{
	if( !moBwImg || moBwImg.GetInternalData() != FSI_BYTE)
		return -1;
	
	int nRows = moBwImg.GetNumRows(), nCols = moBwImg.GetNumCols();
	CvMat matBw, *pmatPts;
	matBw = cvMat(nRows, nCols, CV_8UC1, moBwImg.GetDataObject());
	int nRet = ocvDigitizeArea(&matBw, &pmatPts, 
									dasSettings.x, 
									dasSettings.y, 
									dasSettings.width,
									dasSettings.height,
									dasSettings.step,
									dasSettings.theta, 
									dasSettings.minlen, 
									dasSettings.maxgap);
	if( nRet < 0 || pmatPts == NULL)
		return -1;
	
	int ii, nNum = pmatPts->cols;
	vX.SetSize(nNum);
	vY.SetSize(nNum);
	int* pData = (int*)(pmatPts->data.ptr);
	for(ii = 0; ii < nNum; ++ii)
	{
		vX[ii] = (int)pData[ii*2];
		vY[ii] = (int)pData[ii*2 +1];
	}
	cvReleaseMat(&pmatPts);
	return 0;
}
///End DIGITIZER_AUTO_TRACE_LINE_FUNCTIONS

///Rex 2012/4/13 ORG-5112 FIX_UPDATE_IMAGE_TO_GRAPHOBJECT
HDIB digitizer_convert2DIB(const MatrixObject& mo)
{
	int nRows = mo.GetNumRows(), nCols = mo.GetNumCols();
	int nType = mo.GetInternalData(), ii;
	if (nType != FSI_BYTE && nType != FSI_ULONG)
		return NULL;
	
	bool isColor = nType == FSI_ULONG;
	int nBitCount = isColor ? 32 : 8;
	int nNumColor = isColor ? 0 : 256;		
	int nPaletteSize = nNumColor * sizeof(RGBQUAD);
	int nBytesPerLine = (((nBitCount * nCols) + 31) / 32 * 4);
	int nDIBSize = sizeof(BITMAPINFOHEADER) + nPaletteSize + nBytesPerLine*nRows;	
	
	BITMAPINFOHEADER bi;
	bi.biSize 			= sizeof(BITMAPINFOHEADER);
	bi.biWidth 			= nCols;
	bi.biHeight 		= nRows;
	bi.biPlanes 		= 1;
	bi.biBitCount 		= nBitCount;
	bi.biCompression 	= 0;//BI_RGB;  
	bi.biSizeImage 		= 0;
	bi.biXPelsPerMeter 	= 0;
	bi.biYPelsPerMeter 	= 0;
	bi.biClrUsed 		= 0;
	bi.biClrImportant 	= 0;
	
	HDIB hDIB = GlobalAlloc(GHND, nDIBSize);
	if (!hDIB)
		return NULL;
	
	LPBITMAPINFOHEADER lpbi = (LPBITMAPINFOHEADER)GlobalLock(hDIB);
	*lpbi = bi;
	
	RGBQUAD* pRGB = (RGBQUAD*)(void*)((char*)lpbi + sizeof(BITMAPINFOHEADER));
	for (ii = 0; ii < nNumColor; ++ii)
	{
		pRGB[ii].rgbBlue = pRGB[ii].rgbGreen = pRGB[ii].rgbRed = ii;
		pRGB[ii].rgbReserved = 0;
	}
	
	unsigned char* pDst = (unsigned char*)((char*)pRGB + nPaletteSize + nBytesPerLine * (nRows-1));
	unsigned char* pSrc = (unsigned char*)(void*)mo.GetDataObject(); 
	for (ii = 0; ii < nRows; ++ii)
	{
		memcpy(pDst, pSrc, nBitCount*nCols/8);
		pSrc += nBitCount*nCols/8;		
		pDst -= nBytesPerLine;	
	}	
	
	return hDIB;
}
///End FIX_UPDATE_IMAGE_TO_GRAPHOBJECT

///Rex 2012/4/9 ORG-5112-P2 ROTATE_IMAGE_WITH_OPENCV 
int digitizer_rotate(const MatrixObject& moSrcImg, MatrixObject& moDstImg, double angle, int flags, COLORREF fillColor)
{
	if (!moSrcImg)
		return -1;
	
	int nRows = moSrcImg.GetNumRows();
	int nCols = moSrcImg.GetNumCols();
	int nType = moSrcImg.GetInternalData();
	if (nType != FSI_BYTE && nType != FSI_ULONG)
		return -1;
	
	_SET_MAT_SIZE(moDstImg, nRows, nCols);
	_SET_MAT_DATA_TYPE(moDstImg, nType);
	
	double map[6];	
	CvMat matSrc, matDst, matAffine;
	CvScalar fillValue;
	CvPoint2D32f center;
	matSrc = cvMat(nRows, nCols, nType == FSI_ULONG ? CV_8UC4:CV_8UC1, moSrcImg.GetDataObject());
	matDst = cvMat(nRows, nCols, nType == FSI_ULONG ? CV_8UC4:CV_8UC1, moDstImg.GetDataObject());
	matAffine = cvMat(2, 3, CV_32FC1, map);
	fillValue = cvScalar(GetRValue(fillColor), GetGValue(fillColor), GetBValue(fillColor));
	center = cvPoint2D32f(nCols*0.5, nRows*0.5);
	
	cv2DRotationMatrix(center, angle, 1.0, &matAffine);
	cvWarpAffine(&matSrc, &matDst, &matAffine, flags, fillValue);
	
	return 0;
}
///End ROTATE_IMAGE_WITH_OPENCV 

BOOL	OpenDigitizer()
{
	if ( g_pDigitizer )
	{
		Window winDlg = g_pDigitizer->GetWindow();
		if(winDlg)
		{
			winDlg.Visible = TRUE;
		return TRUE;
		}		
	}
	
	g_pDigitizer = new Digitizer();	
	return g_pDigitizer->Create(GetWindow());
}

BOOL	import_image_and_open_digitizer90()
{
	DigitizerImpl	digitizerImpl;
	return digitizerImpl.ImportImage() && OpenDigitizer();
}

void	digitizer_events(int nEvent, string strName)
{	
	DigitizerImpl	digitizerImpl;
	digitizerImpl.UpdateFromEvents(nEvent, strName);
}
///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
//BOOL	digitizer_calculate_one_point(double x, double y, string* pstr = NULL)
BOOL	digitizer_calculate_one_point(double& x, double& y, string* pstr/* = NULL*/)
///End OPTIMIZE_PICKED_POINT
{
	if ( NULL == pstr )
		return FALSE;
	
	DigitizerImpl	digitizerImpl;
	/// Iris 12/27/2011 ORG-4685-S3 NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE
	/*
	/// Iris 11/01/2011 DIGITIZER_SUPPORT_MAGNIFIER
	//return digitizerImpl.GetOnePoint(*pstr, x, y);
	bool bRet = digitizerImpl.GetOnePoint(*pstr, x, y);
	if( bRet && g_pDigitizer )
	{
		g_pDigitizer->UpdateMagnifier(&x, &y);
	}
	return bRet;
	///End DIGITIZER_SUPPORT_MAGNIFIER
	*/
	return digitizerImpl.GetOnePoint(*pstr, x, y);
	///End NEED_START_MAGNIFIER_ONCE_MOUSE_MOVING_ON_IMAGE
}
///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
//BOOL	digitizer_add_one_point(double x, double y, string* pstr = NULL)
BOOL	digitizer_add_one_point(double& x, double& y, string* pstr/* = NULL*/)
///End OPTIMIZE_PICKED_POINT
{
	DigitizerImpl	digitizerImpl;
	return digitizerImpl.AddOnePoint(x, y);	
}

/// Iris 9/12/2012 ORG-6737 SUPPORT_TERNARY_IN_DIGITIZER
BOOL	digitizer_add_one_vertex(double& x, double& y, string* pstr/* = NULL*/)
{
	static int nTime = 0;
	DigitizerImpl	digitizerImpl;
	bool bRet = digitizerImpl.AddOneVertex(x, y);	
	if( bRet && NULL != pstr )
	{
		nTime++;
		out_int("time = ", nTime);
		pstr->Format("x=%d, y = %d", x, y);
	}
	return bRet;
}

BOOL	digitizer_display_one_point(double& x, double& y, string* pstr/* = NULL*/)
{	
	if( NULL != pstr )
	{
		int xx = x, yy = y;
		pstr->Format("X = %d, Y = %d", xx, yy);
		return true;
	}
	return false;
}
///End SUPPORT_TERNARY_IN_DIGITIZER

///Jasmine 10/21/2011 ORG-3841-S1 DIGITIZER_AUTO_TRACE_LINE
BOOL	digitizer_trace_line(double& x, double& y, string* pstr/* = NULL*/)
{
	DigitizerImpl	digitizerImpl;
	return digitizerImpl.TraceLineAndAddPoints(x, y);
}
///End DIGITIZER_AUTO_TRACE_LINE

BOOL	digitizer_check_update_on_dlg_show()
{	
	DigitizerImpl	digitizerImpl;
	return digitizerImpl.CheckUpdateOnDlgShow(g_pDigitizer ? TRUE : FALSE);
}
///Jasmine 03/11/11 ORG-2286 KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP
BOOL	digitizer_clean_page_relative_data(string strAttachPage)
{
	//out_str("strActivePage="+strAttachPage);
	DigitizerImpl	digitizerImpl;
	digitizerImpl.CleanRelativeData(strAttachPage);	
	return TRUE;
}
///End KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP

/*------------------------------------------------------------------------------*
 * utilities function end 														*
 *------------------------------------------------------------------------------*/
