/*------------------------------------------------------------------------------*
 * File Name: XYZ2MATControl.h													*
 * Creation: Sim 02-27-2009														*
 * Purpose: OriginC Header H file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 09-16-2009 IMPROVE_GRIDDING_ERROR_REPORT								*
 *	Kyle 08/10/2010 ORG-172-S1 OC_DISABLE_ZOOM_FOR_PREVIEW						*
 *	Jasmine 08/13/2010 ORG-172-S2 CENTRALIZE_NOCLICK_BIT_FOR_PREVIEW_IN_OC_TOOL	*
 *	Sophy 3/31/2012 ORG-5414-P1 TEMP_MATRIX_PREVIEW_SHOULD_NOT_APPEAR_IN_MATRIX_BROWSER
 *------------------------------------------------------------------------------*/
 
#ifndef XYZ2MATCTRL_H
#define XYZ2MATCTRL_H

#include <..\OriginLab\GraphPageControl.h>
#include "XYZ2Mat.h"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
enum 
{ 
	COL_DATAPLOT_X, 
	COL_DATAPLOT_Y, 
	COL_DATAPLOT_Z, 
	COL_GRID_VERT_X, 
	COL_GRID_VERT_Y, 
	COL_GRID_HORI_X, 
	COL_GRID_HORI_Y, 
	
	COL_GRID_TOTAL_COLS
};

enum
{
	UPDATE_PREVIEW_DATA_CHANGED					= 0x0001,
	UPDATE_PREVIEW_SEL_DATA_CHANGED				= 0x0002,
	
	// only effect for Data Selection Graph
	UPDATE_PREVIEW_SEL_RANGE_USE				= 0x0010,
	UPDATE_PREVIEW_SEL_RANGE_CHANGED			= 0x0020,
	UPDATE_PREVIEW_GRID_CHANGED					= 0x0040,
	
	// only effect for Preview Result Graph
	UPDATE_PREVIEW_PLOT_TYPE_CHANGED			= 0x0100,
	UPDATE_PREVIEW_RESULT_CHANGED				= 0x0200,
	
	UPDATE_PREVIEW_ALL							= 0xFFFF, // ALL
};
	
///Kyle 08/10/2010 ORG-172-S1 OC_DISABLE_ZOOM_FOR_PREVIEW
//#define 	PREVIEW_GRAPH_NO_CLICKS		NOCLICK_DATA_PLOT | NOCLICK_TICKLABEL | NOCLICK_LAYER | NOCLICK_LAYERICON | NOCLICK_AXES
///Jasmine 08/13/2010 ORG-172-S2 CENTRALIZE_NOCLICK_BIT_FOR_PREVIEW_IN_OC_TOOL
//#define 	PREVIEW_GRAPH_NO_CLICKS		NOCLICK_DATA_PLOT | NOCLICK_TICKLABEL | NOCLICK_LAYER | NOCLICK_LAYERICON | NOCLICK_AXES | NOCLICK_ZOOMPAN	
#define 	PREVIEW_GRAPH_NO_CLICKS		OC_PREVIEW_NOCLICK_NOZOOMPAN
///End CENTRALIZE_NOCLICK_BIT_FOR_PREVIEW_IN_OC_TOOL
///End OC_DISABLE_ZOOM_FOR_PREVIEW
class XYZ2MatGraphControl : public GraphPageControl
{
public:	
	virtual void Create(GraphControl &ctrl, LPCSTR lpcstrSharedWksName = NULL)
	{	
		/// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
		//GraphPageControl::Create(ctrl, PREVIEW_GRAPH_NO_CLICKS, "XYZ2Mat", "XYZXYXY", NULL, NULL, lpcstrSharedWksName);
		GraphPageControl::Create(ctrl, PREVIEW_GRAPH_NO_CLICKS, GetGraphTemplate(), "XYZXYXY", NULL, NULL, lpcstrSharedWksName);
		///End TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
	}
	
	virtual bool UpdateGraph(DWORD dwControls = UPDATE_PREVIEW_ALL, LPCSTR lpcszLabel = NULL);	
	virtual bool CheckChangeGraphTemplate(); /// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
	
	bool UpdateData(vector *pvx, vector *pvy, vector *pvz = NULL);
	
protected:
	virtual bool MakePlot();
	virtual string GetGraphTemplate() { return "XYZ2Mat"; } /// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW

private:
	virtual	void updateLabel(LPCSTR lpcszLabel) {}

};

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class DataSelectionGraphControl : public XYZ2MatGraphControl
{
public:
	virtual void Create(GraphControl &ctrl, LPCSTR lpcstrSharedWksName = NULL)
	{
		/// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
		//GraphPageControl::Create(ctrl, PREVIEW_GRAPH_NO_CLICKS, "XYZ2Mat", "XYZXYXY", NULL, NULL, lpcstrSharedWksName);
		GraphPageControl::Create(ctrl, PREVIEW_GRAPH_NO_CLICKS, GetGraphTemplate(), "XYZXYXY", NULL, NULL, lpcstrSharedWksName);
		///End TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
		
		m_gbLineLeft = GetRectObject("Left", true);
		m_gbLineRight = GetRectObject("Right", true);
		m_gbLineTop = GetRectObject("Top", true);
		m_gbLineBottom = GetRectObject("Bottom", true);
	}

	virtual bool UpdateGraph(DWORD dwControls = UPDATE_PREVIEW_ALL, LPCSTR lpcszLabel = NULL);		
	
	// grid relative
	bool UpdateDataSel(const XYZGriddingRangeRestrictionSettings* pRangeRestriction, const XYZGrdiddingDataInfo* pDataInfo);
	bool UpdateGrid(const vector &vVertX, const vector &vVertY, const vector &vHoriX, const vector &vHoriY);

	bool GetDataSel(XYZGriddingRangeRestrictionSettings* pRangeRestriction);
	
protected:
	virtual bool MakePlot();	
	
private:
	// data selction tools
	void getSelectedDataRange(double& dleft, double& dright, double& dtop, double& dbottom);
	void setDataSelectToolRange(double dleft, double dright, double dtop, double dbottom);
	void showTools(bool bShow = true);
	bool isShowTools();

	void clearGrid();
	
	virtual void updateLabel(LPCSTR lpcszLabel);

private:
	GraphObject				m_gbLineLeft;
	GraphObject				m_gbLineRight;
	GraphObject				m_gbLineTop;
	GraphObject				m_gbLineBottom;
	
	XYZGriddingRangeRestrictionSettings		m_settingRangeRestriction;
};



//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class XYHistogramGraphControl : public XYZ2MatGraphControl
{
public:
	//virtual 
	void Create(GraphControl &ctrl, LPCSTR lpcstrSharedWksName = NULL)
	{
		/// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
		//GraphPageControl::Create(ctrl, PREVIEW_GRAPH_NO_CLICKS, "XYZ2MATXY", NULL, NULL, NULL, lpcstrSharedWksName);
		GraphPageControl::Create(ctrl, PREVIEW_GRAPH_NO_CLICKS, GetGraphTemplate(), NULL, NULL, NULL, lpcstrSharedWksName);
		///End TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
	}	
	
protected:
	virtual bool MakePlot();	
	
private:
	virtual void updateLabel(LPCSTR lpcszLabel);
};



//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
enum { 
	PREVIEW_PLOT_TYPE_UNDEFINED = -1, 
	PREVIEW_PLOT_TYPE_COLORMAP, 
	PREVIEW_PLOT_TYPE_COLORFILL, 
	PREVIEW_PLOT_TYPE_WIREFRAME 
};

class PreviewResultGraphControl : public XYZ2MatGraphControl
{
public :
	PreviewResultGraphControl(int nPlotType)
	{
		m_nPlotType = nPlotType;		
	}
	~PreviewResultGraphControl()
	{
		if(m_matPage.IsValid())
			m_matPage.Destroy();
	}
	
	virtual void Create(GraphControl &ctrl, LPCSTR lpcstrSharedWksName = NULL)
	{
		/// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
		//string strTemplate = m_nPlotType == PREVIEW_PLOT_TYPE_COLORFILL? "XYZ2MatContour" : "XYZ2Mat3D";
		string strTemplate = GetGraphTemplate();		
		///End TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
		
		GraphPageControl::Create(ctrl, PREVIEW_GRAPH_NO_CLICKS, strTemplate, "XYZ", NULL, NULL, lpcstrSharedWksName);

		if( !m_matPage.IsValid() )
		{
			///Sophy 3/31/2012 ORG-5414-P1 TEMP_MATRIX_PREVIEW_SHOULD_NOT_APPEAR_IN_MATRIX_BROWSER
			//m_matPage.Create("origin", CREATE_HIDDEN);
			m_matPage.Create("origin", CREATE_HIDDEN | CREATE_SET_MISSING_IN_MANAGER);
			///end TEMP_MATRIX_PREVIEW_SHOULD_NOT_APPEAR_IN_MATRIX_BROWSER
		}
		MatrixLayer ml = m_matPage.Layers(0);
		m_moSurface = ml.MatrixObjects(0);
		ASSERT(m_moSurface);

		Worksheet& wks = GetWks();
		ASSERT(wks);
	}

	//bool UpdateData(const matrix &mat, double dXMin, double dXMax, double dYMin, double dYMax);
	bool UpdateData(const matrix &mat, const XYZGrdiddingDataInfo* pDataInfo);

	void SetPlotType(int nPlotType) { m_nPlotType =  nPlotType; }

	MatrixPage& GetMatrixPage();
	void SetMatrixPage(MatrixPage& mp);	
	
protected:
	virtual bool MakePlot();
	/// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
	//virtual
	string GetGraphTemplate(); 
	///End TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
	
private:
	MatrixPage				m_matPage;
	MatrixObject			m_moSurface;
	int						m_nPlotType;
};

class NonePreviewGraphControl : public XYZ2MatGraphControl
{
public :
	virtual void Create(GraphControl &ctrl, LPCSTR lpcstrSharedWksName = NULL)
	{
		/// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
		//GraphPageControl::Create(ctrl, PREVIEW_GRAPH_NO_CLICKS, STR_NONE_PREVIEW_TEMPLATE, "XYZ", NULL, NULL, lpcstrSharedWksName);
		GraphPageControl::Create(ctrl, PREVIEW_GRAPH_NO_CLICKS, GetGraphTemplate(), "XYZ", NULL, NULL, lpcstrSharedWksName);
		///End TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
	}
	
protected:
	/// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
	//virtual
	string GetGraphTemplate() { return STR_NONE_PREVIEW_TEMPLATE; }
	///End TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
	
private:
	virtual void updateLabel(LPCSTR lpcszLabel);
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
enum { 	
	XYZ_GRAPH_INDEX_XY_RANGE = 0,
	
	XYZ_GRAPH_INDEX_X_HISTOGRAM,
	XYZ_GRAPH_INDEX_Y_HISTOGRAM,
	
	XYZ_GRAPH_INDEX_XYZ_WIREFRAME,
	XYZ_GRAPH_INDEX_XYZ_CONTOUR,
	XYZ_GRAPH_INDEX_XYZ_NONE_PREVIEW,

	XYZ_GRAPH_TOTAL_GRAPHS,
};

enum
{
	XYZ_TAB_INDEX_XY_RANGE = XYZ_GRAPH_INDEX_XY_RANGE,	
	
	XYZ_TAB_INDEX_X_HISTOGRAM,
	XYZ_TAB_INDEX_Y_HISTOGRAM,
	
	XYZ_TAB_INDEX_PREVIEW_RESULT,
	
	XYZ_TAB_TOTAL_TABS
};



class XYZ2MatGraphControlManager
{
public:
	XYZ2MatGraphControlManager();	
	~XYZ2MatGraphControlManager();
	
public:	
	bool 	InitControls(TabControl& tab, Button& chkPreview, bool bBottomShow);
	bool 	InitGraphControls(Array<Control&>& arrCtrls);
	
	void	OnChange(int nType = XYZ_CHANGE_INIT);
	void	PreChangeTab(int nType, const XYZGriddingSettings* pSetting, const XYZGrdiddingDataInfo* pDataInfo);
	
	bool	IsDirty(DWORD *pdwUpdateBits = NULL);	
	
	bool	UpdateData(const vector& vX, const vector& vY, const vector& vZ, bool bOriginal = true);
	///---Sim 09-16-2009 IMPROVE_GRIDDING_ERROR_REPORT
	//bool	UpdateResult(const matrix& mat, const XYZGrdiddingDataInfo* pDataInfo);
	bool	UpdateResult(const matrix& mat, const XYZGrdiddingDataInfo* pDataInfo, int nErrorCode = OE_NOERROR);
	///---END IMPROVE_GRIDDING_ERROR_REPORT
	bool	UpdateGrid(const XYZGrdiddingDataInfo* pDataInfo);
	bool	UpdateDataSel(const XYZGriddingRangeRestrictionSettings* pRangeRestriction, const XYZGrdiddingDataInfo* pDataInfo);
	bool	UpdatePlotType(const XYZGriddingPreviewSettings* pPreviewSetting);

	
	bool 	UpdatePreview();
	
	
	bool	GetDataSel(XYZGriddingRangeRestrictionSettings* pRangeRestriction);
	
	///////////// Moved from Dlg class /////////////////////////
	BOOL	OnAfterDlgResize(RECT& rTab);
	BOOL 	OnShowBottomPane(Control ctrl, bool bBottomPaneShown, RECT& rTab);
	BOOL 	OnChangePreviewMode(Control ctrl);
	BOOL 	OnTabChange(Control ctrl);
	///////////// End /////////////////////////

protected:
	int 	GetShowTab();
	void	SwitchTab(bool bHideAll = false);

private:	
	//bool	updateGraph(int nGraph, DWORD dwBits = UPDATE_PREVIEW_INIT);
	
	///////////// Moved from Dlg class /////////////////////////
	void 	updateBottomTabSize(RECT& rTab);
	void	updateGraphShown(int nGraph);
	void	updateQuickPreviewCtrlShow();
	bool    isBottomPaneShown() { return m_bBottomPaneShow; }
	///////////// End /////////////////////////

	int		graphIndexToTabIndex(int nGraph);
	int 	tabIndexToGraphIndex(int nTab, int nPlotType, bool bPreview);
	
	bool 	isWorksheetShared(int nGraph); 
	int 	getSharedMatrixPage(int nGraph); // for last tab

protected:
	TabControl			m_tab;
	Button				m_chkPreview;
	
	bool							m_bBottomPaneShow;
	
	int								m_nCurGraph;
	Array<XYZ2MatGraphControl&> 	m_arrGraphs;
	Array<Control&>					m_arrGraphControls;
	vector<DWORD>					m_vdwUpdateBits;
	
	int								m_nPreviewPlotType;
	bool							m_bPreview;
	bool							m_bLargeDataSet;
	int								m_nErrorCode; ///---Sim 09-16-2009 IMPROVE_GRIDDING_ERROR_REPORT
};


#endif //XYZ2MATCTRL_H
