/*------------------------------------------------------------------------------*
 * File Name: XYZ2MATControl.c													*
 * Creation: Sim 02-27-2009														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 08-14-2009 QA81-14124 FIX_GUI_CHANGE_CAUSE_PREVIEW_RECURSIVELY_REFRESH	*
 *	Sim 09-16-2009 IMPROVE_GRIDDING_ERROR_REPORT								*
 *	Sim 09-27-2009 QA81-14137 HIDE_COUNTS_OF_STEP_ZERO_WHICH_IS_NO_NEED			*
 *	Sim 02-09-2010 QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG	*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <Array.h>
#include <control.h>
#include <..\OriginLab\grobj_utils.h>
#include "XYZ2MatControl.h"

#define IS_INT_AUTO(_int)	( 1 == _int )

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
//virtual
bool XYZ2MatGraphControl::MakePlot()
{
	//ASSERT(FALSE);
	return false;
}

bool XYZ2MatGraphControl::UpdateData(vector *pvx, vector *pvy, vector *pvz/* = NULL*/)
{
	if( NULL == pvx || NULL == pvy )
		return false;
	
	SetData(*pvx, COL_DATAPLOT_X);
	SetData(*pvy, COL_DATAPLOT_Y);
	
	if(NULL != pvz)
		SetData(*pvz, COL_DATAPLOT_Z);
	return true;
}

/// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
bool XYZ2MatGraphControl::CheckChangeGraphTemplate()
{	
	// to update graph template
	GraphPage gp = GetPage();
	if( gp )
	{		
		string strTemplate = GetGraphTemplate();
		string strCurrectTemplate = GetFileName(page_get_template_name(gp, false));
		if( gp && 0 != strTemplate.CompareNoCase(strCurrectTemplate) )
		{			 
			 return UpdateGraphTemplate(strTemplate);			 
		}	
	}
	return false;
}
///End TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW

//virtual 
bool XYZ2MatGraphControl::UpdateGraph(DWORD dwControls, LPCSTR lpcszLabel) // = UPDATE_PREVIEW_INIT, NULL
{	
	if ( dwControls & UPDATE_PREVIEW_PLOT_TYPE_CHANGED )
	{
		CheckChangeGraphTemplate(); /// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
		MakePlot();	
	}

	if (	dwControls & UPDATE_PREVIEW_DATA_CHANGED 
		||	dwControls & UPDATE_PREVIEW_SEL_DATA_CHANGED 
		||	dwControls & UPDATE_PREVIEW_GRID_CHANGED 
		||	dwControls & UPDATE_PREVIEW_PLOT_TYPE_CHANGED 
		||	dwControls & UPDATE_PREVIEW_RESULT_CHANGED	)
		PlotRescale();

	if( NULL != lpcszLabel )
	{
		updateLabel(lpcszLabel);
		Refresh();
	};
	
	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//virtual 
bool DataSelectionGraphControl::UpdateGraph(DWORD dwControls, LPCSTR lpcszLabel) // = UPDATE_PREVIEW_INIT, NULL
{	
	if( !XYZ2MatGraphControl::UpdateGraph(dwControls) )
		return false;
	
	// set data selection tool show or hide
	if ( UPDATE_PREVIEW_SEL_RANGE_USE & dwControls )
	{
		bool bShow = m_settingRangeRestriction.bUse;
		showTools(bShow);
	}
	
	// set data selection range
	if( UPDATE_PREVIEW_SEL_RANGE_CHANGED & dwControls )
	{		
		double dXMin = m_settingRangeRestriction.dXMin;
		double dXMax = m_settingRangeRestriction.dXMax;
		double dYMin = m_settingRangeRestriction.dYMin;
		double dYMax = m_settingRangeRestriction.dYMax;
		setDataSelectToolRange(dXMin, dXMax, dYMin, dYMax);
	}
	
	return true;
}

//virtual
bool DataSelectionGraphControl::MakePlot()
{
	//I want to plot the data plot in the end to make the data in front of grid, but this cause rescale fail, so I add it first
	int nActivePlot = AddPlot(COL_DATAPLOT_X, COL_DATAPLOT_Y, IDM_PLOT_SCATTER);
	AddPlot(COL_GRID_VERT_X, COL_GRID_VERT_Y, IDM_PLOT_LINE);
	AddPlot(COL_GRID_HORI_X, COL_GRID_HORI_Y, IDM_PLOT_LINE);

	//if plot the dataplot first, then the rescal problem don't exist
	//want to make the rescale work well, but fail,
	//SetPlotActive(nActivePlot);
	return true;
}

bool DataSelectionGraphControl::UpdateDataSel(const XYZGriddingRangeRestrictionSettings* pRangeRestriction, const XYZGrdiddingDataInfo* pDataInfo)
{
	if ( NULL == pRangeRestriction )
		return false;
	
	m_settingRangeRestriction = *pRangeRestriction;
	
	if ( NULL == pDataInfo )
		return false;
	
	Dataset dsX(GetWks(), COL_DATAPLOT_X);
	Dataset dsY(GetWks(), COL_DATAPLOT_Y);
	
	if ( !dsX || !dsY )
		return false;
	
	// clear mask
	Project.SetDatasetMasks(dsX.GetName());
	Project.SetDatasetMasks(dsY.GetName());
	
	vector vX, vY;
	// Dataset contain masked data info, and deal with missing value. Can't be used!!!
	//vX = dsX;
	//vY = dsY;
	vX = GetWks().Columns(COL_DATAPLOT_X).GetDataObject();
	vY = GetWks().Columns(COL_DATAPLOT_Y).GetDataObject();
	
	int nSize = vX.GetSize();
	if ( nSize <= 0 )
		return true; // need do nothing
	
	vector<uint> vnIndices;
	vector<int> vnVals;
	
	//first, mask all data
	vnIndices.Data(0, nSize-1);
	vnVals.SetSize(nSize);
	vnVals = 1; // set all mask to 1
	
	Project.SetDatasetMasks(dsX.GetName(), vnIndices, vnVals);
	Project.SetDatasetMasks(dsY.GetName(), vnIndices, vnVals);
	
	//second, unmask the selected data
	double dXMin = pDataInfo->dXMin;
	double dXMax = pDataInfo->dXMax;
	double dYMin = pDataInfo->dYMin;
	double dYMax = pDataInfo->dYMax;
	vnIndices.SetSize(nSize); // enlarge enough size
	int nSelSize = XYZGRIDDING_MATH(FindXYInRect(nSize, vX, vY, vnIndices, dXMin, dYMin, dXMax, dYMax));
	if ( nSelSize <= 0 )
		return true; // need do nothing
	vnIndices.SetSize(nSelSize);
	vnVals.SetSize(nSelSize);
	vnVals = 0; //set unmask
	
	Project.SetDatasetMasks(dsX.GetName(), vnIndices, vnVals);
	Project.SetDatasetMasks(dsY.GetName(), vnIndices, vnVals);
	
	return true;
}

bool DataSelectionGraphControl::UpdateGrid(const vector &vVertX, const vector &vVertY, const vector &vHoriX, const vector &vHoriY)
{
	SetData(vVertX, COL_GRID_VERT_X);
	SetData(vVertY, COL_GRID_VERT_Y);
	SetData(vHoriX, COL_GRID_HORI_X);
	SetData(vHoriY, COL_GRID_HORI_Y);

	return true;
}

void DataSelectionGraphControl::clearGrid()
{
	vector vEmpty;
	SetData(vEmpty, COL_GRID_VERT_X);
	SetData(vEmpty, COL_GRID_VERT_Y);
	SetData(vEmpty, COL_GRID_HORI_X);
	SetData(vEmpty, COL_GRID_HORI_Y);
}

bool DataSelectionGraphControl::GetDataSel(XYZGriddingRangeRestrictionSettings* pRangeRestriction)
{
	if ( NULL == pRangeRestriction )
		return false;
	
	if ( !isShowTools() )
		return false;
	
	double dLeft, dRight, dTop, dBottom;
	getSelectedDataRange(dLeft, dRight, dTop, dBottom);
	
	pRangeRestriction->dXMin = dLeft;
	pRangeRestriction->dXMax = dRight;
	pRangeRestriction->dYMin = dTop;
	pRangeRestriction->dYMax = dBottom;
	
	return true;
}

void DataSelectionGraphControl::getSelectedDataRange(double& dleft, double& dright, double& dtop, double& dbottom)
{
	dleft	= m_gbLineLeft.X;
	dright	= m_gbLineRight.X;
	dtop	= m_gbLineTop.Y;
	dbottom	= m_gbLineBottom.Y;
}

static void _set_line_selectable(GraphObject& go, bool bSelectable)
{
	if(!go)
		return;
	Tree tr;
	tr = go.GetFormat(FPB_OTHER, FOB_ALL, true, true);
	int nStates = tr.Root && tr.Root.States ? tr.Root.States.nVal : 0;
	if(bSelectable)
		nStates &= ~GOC_NO_SELECT;
	else
		nStates |= GOC_NO_SELECT;
	
	tr.Root.States.nVal = nStates;
	go.UpdateThemeIDs(tr.Root);

	go.ApplyFormat(tr, true, true);
}
void DataSelectionGraphControl::setDataSelectToolRange(double dleft, double dright, double dtop, double dbottom)
{
	///---Sim 08-14-2009 QA81-14124 FIX_GUI_CHANGE_CAUSE_PREVIEW_RECURSIVELY_REFRESH
	set_LT_script(m_gbLineLeft, NULL, GRCT_NONE);
	set_LT_script(m_gbLineRight, NULL, GRCT_NONE);
	set_LT_script(m_gbLineTop, NULL, GRCT_NONE);
	set_LT_script(m_gbLineBottom, NULL, GRCT_NONE);
	///---END QA81-14124 FIX_GUI_CHANGE_CAUSE_PREVIEW_RECURSIVELY_REFRESH
	
	//disable_go_move(m_gbLineLeft, true, true, true, true);
	//disable_go_move(m_gbLineRight, true, true, true, true);
	//disable_go_move(m_gbLineTop, true, true, true, true);
	//disable_go_move(m_gbLineBottom, true, true, true, true);
	
	m_gbLineLeft.X		= dleft;
	m_gbLineRight.X		= dright;
	m_gbLineTop.Y		= dtop;
	m_gbLineBottom.Y	= dbottom;
	
	//if ( IS_INT_AUTO(m_settingRangeRestriction.nAutoXMin) )
		//disable_go_move(m_gbLineLeft);
	//if ( IS_INT_AUTO(m_settingRangeRestriction.nAutoXMax) )
		//disable_go_move(m_gbLineRight);
	//if ( IS_INT_AUTO(m_settingRangeRestriction.nAutoYMin) )
		//disable_go_move(m_gbLineTop);
	//if ( IS_INT_AUTO(m_settingRangeRestriction.nAutoYMax) )
		//disable_go_move(m_gbLineBottom);	
	_set_line_selectable(m_gbLineLeft, !IS_INT_AUTO(m_settingRangeRestriction.nAutoXMin));
	_set_line_selectable(m_gbLineRight, !IS_INT_AUTO(m_settingRangeRestriction.nAutoXMax));
	_set_line_selectable(m_gbLineTop, !IS_INT_AUTO(m_settingRangeRestriction.nAutoYMin));
	_set_line_selectable(m_gbLineBottom, !IS_INT_AUTO(m_settingRangeRestriction.nAutoYMax));
	
	///---Sim 08-14-2009 QA81-14124 FIX_GUI_CHANGE_CAUSE_PREVIEW_RECURSIVELY_REFRESH
	set_LT_script(m_gbLineLeft, NULL, GRCT_MOVE);
	set_LT_script(m_gbLineRight, NULL, GRCT_MOVE);
	set_LT_script(m_gbLineTop, NULL, GRCT_MOVE);
	set_LT_script(m_gbLineBottom, NULL, GRCT_MOVE);
	///---END QA81-14124 FIX_GUI_CHANGE_CAUSE_PREVIEW_RECURSIVELY_REFRESH
}
void DataSelectionGraphControl::showTools(bool bShow)// = true
{
	m_gbLineLeft.Show = bShow;
	m_gbLineRight.Show = bShow;
	m_gbLineTop.Show = bShow;
	m_gbLineBottom.Show = bShow;
}
bool DataSelectionGraphControl::isShowTools()
{
	if (	m_gbLineLeft.Show
		&&	m_gbLineRight.Show
		&&	m_gbLineTop.Show
		&&	m_gbLineBottom.Show
		)
	{
		return true;
	}
	
	return false;
}

void DataSelectionGraphControl::updateLabel(LPCSTR lpcszLabel)
{
	if( strlen(lpcszLabel) > 0 )
		UpdateLabel("Info", lpcszLabel, 20, 0);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//virtual
bool XYHistogramGraphControl::MakePlot()
{
	AddPlot(COL_DATAPLOT_X, COL_DATAPLOT_Y, IDM_PLOT_UNKNOWN);
	return true;
}

void XYHistogramGraphControl::updateLabel(LPCSTR lpcszLabel)
{
	if( strlen(lpcszLabel) > 0 )
		UpdateLabel("Info", lpcszLabel, 90, 0);
	
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
string PreviewResultGraphControl::GetGraphTemplate()
{	
	string strTemplate;
	bool bIsOGL = is_OGL();
	switch(m_nPlotType)
	{
	case PREVIEW_PLOT_TYPE_COLORMAP:
		strTemplate = bIsOGL ? "glXYZ2MatCMAP" : "XYZ2Mat3D";
		break;
		
	case PREVIEW_PLOT_TYPE_COLORFILL:
		strTemplate = "XYZ2MatContour";
		break;
		
	case PREVIEW_PLOT_TYPE_WIREFRAME:
		strTemplate = bIsOGL ? "glXYZ2MatWireFRM" : "XYZ2Mat3D";
		break;
		
	default:
		ASSERT(false);
		break;
	}	
	return strTemplate;
}
///End TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW

//bool PreviewResultGraphControl::UpdateData(const matrix &mat, double dXMin, double dXMax, double dYMin, double dYMax)
bool PreviewResultGraphControl::UpdateData(const matrix &mat, const XYZGrdiddingDataInfo* pDataInfo)
{
	if(!m_moSurface)
		return false;
	
	Matrix& Mat = m_moSurface.GetDataObject();
	Mat = mat;
	
	//matObj.SetXMin(dXMin);
	//matObj.SetXMax(dXMax);
	//matObj.SetYMin(dYMin);
	//matObj.SetYMax(dYMax);
	if ( pDataInfo )
	{
		if ( !XYZGRIDDING_MATH(SetMatrixXYInfo(Mat, pDataInfo)) )
			return false;
	}
	
	return true;
}

//virtual
bool PreviewResultGraphControl::MakePlot()
{
	/// Iris 5/08/2008 QA80-11497-P2 GRAPH_NOT_UPDATED_IF_CHANGE_PLOT_TYPE_FROM_COLORMAP_TO_WIREFRAME
	GraphPage gp = GetPage();
	GraphLayer gl = gp.Layers(0);
	while(gl.RemovePlot(0));
	///end GRAPH_NOT_UPDATED_IF_CHANGE_PLOT_TYPE_FROM_COLORMAP_TO_WIREFRAME
	
	int nMatrixPlotType = -1;
	int nWksPlotType = -1;
	bool bIsOGL = is_OGL(); /// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
	switch(m_nPlotType)
	{
	case PREVIEW_PLOT_TYPE_UNDEFINED:
	case PREVIEW_PLOT_TYPE_COLORMAP:
		/// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
		//nMatrixPlotType = IDM_PLOT_SURFACE_COLORMAP;
		nMatrixPlotType = bIsOGL ? IDM_PLOT_3D_SURFACE_NEW : IDM_PLOT_SURFACE_COLORMAP;
		///End TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
		nWksPlotType = ID_3D_GRAPH_SCATTER;
		break;

	case PREVIEW_PLOT_TYPE_COLORFILL:
		nMatrixPlotType = IDM_PLOT_CONTOUR;
		nWksPlotType = IDM_PLOT_SCATTER;
		break;

	case PREVIEW_PLOT_TYPE_WIREFRAME:
		/// Iris 7/11/2012 ORG-6173-P1 TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
		//nMatrixPlotType = IDM_PLOT_SURFACE_WIREFRAME;
		nMatrixPlotType = bIsOGL ? IDM_PLOT_3D_SURFACE_NEW : IDM_PLOT_SURFACE_WIREFRAME;
		///End TO_SUPPORT_OGL_3D_GRAPH_IN_XYZGRIDING_PREVIEW
		nWksPlotType = ID_3D_GRAPH_SCATTER;
		break;

	default:
		return error_report("Plot type don't exist");
	}

	int nPlotContour = AddPlot(m_moSurface, nMatrixPlotType);
	if( nPlotContour < 0  )
		return error_report("Fail to plot Surface in MakePlot");
	
	DataRange dr;
	dr.Add("X", GetWks(), 0, COL_DATAPLOT_X, -1, COL_DATAPLOT_X);
	dr.Add("Y", GetWks(), 0, COL_DATAPLOT_Y, -1, COL_DATAPLOT_Y);
	dr.Add("Z", GetWks(), 0, COL_DATAPLOT_Z, -1, COL_DATAPLOT_Z);
	int nPlotScatter = AddPlot(dr, nWksPlotType);
	if( nPlotScatter < 0 )
		return error_report("Fail to plot Scatter in MakePlot");
	
	if( PREVIEW_PLOT_TYPE_COLORFILL == m_nPlotType )
	{
		SetScatterColorMap(nPlotScatter, COL_DATAPLOT_Y, COL_DATAPLOT_Z);
	
		GraphPage gp = GetPage();
		GraphLayer gl = gp.Layers(0);

		DataPlot dp = gl.DataPlots(nPlotContour);
		TreeNode tr;
		dp.GetColormap(tr);

		dp = gl.DataPlots(nPlotScatter);
		dp.SetColormap(tr);	
	}
	
	return true;
}

MatrixPage& PreviewResultGraphControl::GetMatrixPage()
{
	return m_matPage;
}

void PreviewResultGraphControl::SetMatrixPage(MatrixPage& mp)
{
	if(m_matPage.IsValid() && mp.IsValid())
		m_matPage.Destroy();

	m_matPage = mp;
	MatrixLayer ml = m_matPage.Layers(0);
	m_moSurface = ml.MatrixObjects(0);
}

#define CHAR_SEP_NONE_PREVIEW_HINT '|'

//virtual
void NonePreviewGraphControl::updateLabel(LPCSTR lpcszLabel)
{
	if ( lpcszLabel )
	{
		string strLabels = lpcszLabel;
		StringArray saLabels;
		strLabels.GetTokens(saLabels, CHAR_SEP_NONE_PREVIEW_HINT);
		if ( saLabels.GetSize() >= 2 )
		{
			int nContentID = atoi(saLabels[0]);
			int nHintsID = atoi(saLabels[1]);
			load_text_for_nonepreview_graphpage(GetPage(), nContentID, nHintsID);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////
////////////////////////XYZ2MatGraphControlManager//////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

XYZ2MatGraphControlManager::XYZ2MatGraphControlManager()
{
}

XYZ2MatGraphControlManager::~XYZ2MatGraphControlManager()
{
}

bool XYZ2MatGraphControlManager::InitControls(TabControl& tab, Button& chkPreview, bool bBottomShow)
{	
	m_bBottomPaneShow = bBottomShow;
	
	m_tab = tab;
	RECT rr;
	m_tab.GetItemRect(0,&rr);rr.bottom += 10;	
	m_tab.MoveWindow(&rr);// no need to worry about width, it will be resized later
	
	m_chkPreview = chkPreview;
	m_chkPreview.Check = true; //default check quick preview
	updateQuickPreviewCtrlShow();
	
	m_bPreview = true;
	m_bLargeDataSet = false;
	m_nErrorCode = OE_NOERROR; ///---Sim 09-16-2009 IMPROVE_GRIDDING_ERROR_REPORT
	
	// set index XY (first tab) show and hide other graphs
	//updateGraphShown(XYZ_GRAPH_INDEX_XY_RANGE);
	SwitchTab();
	return true;
}

bool XYZ2MatGraphControlManager::InitGraphControls(Array<Control&>& arrCtrls)
{	
	m_arrGraphs.SetSize(0);
	m_arrGraphs.SetAsOwner(true);
	
	m_arrGraphControls.SetSize(0);
	m_arrGraphControls.SetAsOwner(true);
	
	m_vdwUpdateBits.SetSize(0);

	WorksheetPage wpShared;
	MatrixPage mpShared;
	int nSize = arrCtrls.GetSize();
	for (int nIndexCtrl = 0; nIndexCtrl < nSize; nIndexCtrl++ )
	{
		Control &ctrl = arrCtrls.GetAt(nIndexCtrl);
		if ( !ctrl )
		{
			ASSERT(FALSE);
			return false;
		}
		
		GraphControl* pgcNew = new GraphControl;
		if ( !pgcNew || !pgcNew->CreateControl(ctrl.GetSafeHwnd()) )
		{
			ASSERT(FALSE);
			delete pgcNew;
			return false;
		}
				
		XYZ2MatGraphControl*	pGraphCtrl;
		switch (nIndexCtrl)
		{
		case XYZ_GRAPH_INDEX_XY_RANGE:
			pGraphCtrl = new DataSelectionGraphControl;
			break;
		case XYZ_GRAPH_INDEX_X_HISTOGRAM:
		case XYZ_GRAPH_INDEX_Y_HISTOGRAM:
			pGraphCtrl = new XYHistogramGraphControl;
			break;
		case XYZ_GRAPH_INDEX_XYZ_WIREFRAME:
			pGraphCtrl = new PreviewResultGraphControl(PREVIEW_PLOT_TYPE_WIREFRAME);
			break;
		case XYZ_GRAPH_INDEX_XYZ_CONTOUR:
			pGraphCtrl = new PreviewResultGraphControl(PREVIEW_PLOT_TYPE_COLORFILL);
			break;
		case XYZ_GRAPH_INDEX_XYZ_NONE_PREVIEW:
			pGraphCtrl = new NonePreviewGraphControl;
			break;
		default:
			pGraphCtrl = new XYZ2MatGraphControl;			
			error_report("index of graph control out of limited number");
			break;
		}
		if ( !pGraphCtrl )
		{
			ASSERT(FALSE);
			return false;
		}
		
		//Sim, need to rewrite
		bool bShareWks = isWorksheetShared(nIndexCtrl);
		string strSharedWks = bShareWks && wpShared? wpShared.GetName() : "";
		pGraphCtrl->Create(*pgcNew, strSharedWks);
		
		//to save time and memory, we share worksheet XYZ data for Data Selection Tab and Preview Result Tab
		if(bShareWks)
		{			
			if(!wpShared)
				wpShared = pGraphCtrl->GetWks().GetPage();
		}		
			
		//to save time and memory, we share matrix data for Preview Result Tab
		int nSharedTab = getSharedMatrixPage(nIndexCtrl);
		if( nSharedTab >=0 )
		{
			PreviewResultGraphControl* pPreviewGraphCtrl = (PreviewResultGraphControl*)pGraphCtrl;
			if ( pPreviewGraphCtrl && nSharedTab < m_arrGraphs.GetSize() )
			{
				PreviewResultGraphControl& gc = (PreviewResultGraphControl&)m_arrGraphs.GetAt(nSharedTab);
				if( gc && gc.GetMatrixPage().IsValid() )
					pPreviewGraphCtrl->SetMatrixPage( gc.GetMatrixPage() );
			}
		}
		
		m_arrGraphControls.Add(*pgcNew);
		m_arrGraphs.Add(*pGraphCtrl);
	}
	
	///---Sim 02-09-2010 QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
	//// init update bits	
	//vector<int> vnGraphIndeces = {
					//XYZ_GRAPH_INDEX_XY_RANGE,
					//XYZ_GRAPH_INDEX_X_HISTOGRAM,
					//XYZ_GRAPH_INDEX_Y_HISTOGRAM,
					//XYZ_GRAPH_INDEX_XYZ_WIREFRAME,
					//XYZ_GRAPH_INDEX_XYZ_CONTOUR,
					//XYZ_GRAPH_INDEX_XYZ_NONE_PREVIEW
					//};
	//vector<DWORD> vdwUpdateBits = {
					//UPDATE_PREVIEW_PLOT_TYPE_CHANGED | UPDATE_PREVIEW_DATA_CHANGED | UPDATE_PREVIEW_SEL_RANGE_USE | UPDATE_PREVIEW_SEL_RANGE_CHANGED | UPDATE_PREVIEW_GRID_CHANGED,
					//UPDATE_PREVIEW_PLOT_TYPE_CHANGED | UPDATE_PREVIEW_SEL_DATA_CHANGED,
					//UPDATE_PREVIEW_PLOT_TYPE_CHANGED | UPDATE_PREVIEW_SEL_DATA_CHANGED,
					//UPDATE_PREVIEW_PLOT_TYPE_CHANGED | UPDATE_PREVIEW_DATA_CHANGED | UPDATE_PREVIEW_RESULT_CHANGED,					
					//UPDATE_PREVIEW_PLOT_TYPE_CHANGED | UPDATE_PREVIEW_DATA_CHANGED | UPDATE_PREVIEW_RESULT_CHANGED,
					//0 //UPDATE_RREVIEW_SKIP_LARGE_DATA_SET
					//};
	//ASSERT( vnGraphIndeces.GetSize() == vdwUpdateBits.GetSize() );
	///---END QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
	int nSizeGraphs = m_arrGraphs.GetSize();
	m_vdwUpdateBits.SetSize(nSizeGraphs);
	///---Sim 02-09-2010 QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
	//m_vdwUpdateBits = UPDATE_PREVIEW_INIT;
	//for ( int ii = 0; ii < vnGraphIndeces.GetSize(); ii++ )
	//{
		//if ( vnGraphIndeces[ii] < nSizeGraphs )
			//m_vdwUpdateBits[vnGraphIndeces[ii]] = vdwUpdateBits[ii];
	//}
	m_vdwUpdateBits = 0;
	///---END QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
	
	return true;
}


bool XYZ2MatGraphControlManager::UpdateData(const vector& vX, const vector& vY, const vector& vZ, bool bOriginal)// = true
{
	bool bNoNeedUpdate = false;
	switch (m_nCurGraph)
	{
	case XYZ_GRAPH_INDEX_XY_RANGE:
	case XYZ_GRAPH_INDEX_XYZ_WIREFRAME:
	case XYZ_GRAPH_INDEX_XYZ_CONTOUR:
		if ( !bOriginal )
			bNoNeedUpdate = true;
		break;
	case XYZ_GRAPH_INDEX_XYZ_NONE_PREVIEW:
		bNoNeedUpdate = true;
		break;
	case XYZ_GRAPH_INDEX_X_HISTOGRAM:
	case XYZ_GRAPH_INDEX_Y_HISTOGRAM:
		break;
	}
	
	if ( bNoNeedUpdate )
		return true;
	
	vector<double> vXActual, vYActual, vZActual;
	vXActual = vX;
	vYActual = vY;
	vZActual = vZ;
	
	if ( XYZ_GRAPH_INDEX_X_HISTOGRAM == m_nCurGraph || XYZ_GRAPH_INDEX_Y_HISTOGRAM == m_nCurGraph )
	{
		bool bXHistogram = (XYZ_GRAPH_INDEX_X_HISTOGRAM == m_nCurGraph);
		///---Sim 09-27-2009 QA81-14137 HIDE_COUNTS_OF_STEP_ZERO_WHICH_IS_NO_NEED
		//XYZGRIDDING_MATH(CreateStepsStat(vXActual, vYActual, bXHistogram ? vX : vY));
		XYZGRIDDING_MATH(CreateStepsStat(vXActual, vYActual, bXHistogram ? vX : vY, true));
		///---END QA81-14137 HIDE_COUNTS_OF_STEP_ZERO_WHICH_IS_NO_NEED
	}		
	
	XYZ2MatGraphControl& ctrl = m_arrGraphs.GetAt(m_nCurGraph);		
	return ctrl.UpdateData(&vXActual, &vYActual, &vZActual);
}
///---Sim 09-16-2009 IMPROVE_GRIDDING_ERROR_REPORT
//bool XYZ2MatGraphControlManager::UpdateResult(const matrix& mat, const XYZGrdiddingDataInfo* pDataInfo)
bool XYZ2MatGraphControlManager::UpdateResult(const matrix& mat, const XYZGrdiddingDataInfo* pDataInfo, int nErrorCode) // = OE_NOERROR
///---END IMPROVE_GRIDDING_ERROR_REPORT
{
	///---Sim 09-16-2009 IMPROVE_GRIDDING_ERROR_REPORT
	//if ( !pDataInfo )
		//return false;
	///---END IMPROVE_GRIDDING_ERROR_REPORT
	
	switch (m_nCurGraph)
	{
	case XYZ_GRAPH_INDEX_XYZ_WIREFRAME:
	case XYZ_GRAPH_INDEX_XYZ_CONTOUR:
		///---Sim 09-16-2009 IMPROVE_GRIDDING_ERROR_REPORT
		if ( OE_NOERROR != nErrorCode )
		{
			m_nErrorCode = nErrorCode;
			SwitchTab();
			return true;
		}

		if ( !pDataInfo )
			return false;
		///---END IMPROVE_GRIDDING_ERROR_REPORT
		PreviewResultGraphControl& ctrlPreview = (PreviewResultGraphControl&)(m_arrGraphs.GetAt(m_nCurGraph));
		//return ctrlPreview.UpdateData(mat, pDataInfo->dXMin, pDataInfo->dXMax, pDataInfo->dYMin, pDataInfo->dYMax);
		return ctrlPreview.UpdateData(mat, pDataInfo);
	}
	
	return true;
}
bool XYZ2MatGraphControlManager::UpdateGrid(const XYZGrdiddingDataInfo* pDataInfo)
{
	if ( !pDataInfo )
		return false;
	
	switch (m_nCurGraph)
	{
	case XYZ_GRAPH_INDEX_XY_RANGE:
		DataSelectionGraphControl& ctrlRange = (DataSelectionGraphControl&)(m_arrGraphs.GetAt(m_nCurGraph));			
		
		vector vVertX, vVertY, vHoriX, vHoriY;
		XYZGRIDDING_MATH(CreateGridLine(vVertX, vVertY, pDataInfo->dXMin, pDataInfo->dXMax, pDataInfo->dYMin, pDataInfo->dYMax, pDataInfo->dXStep, true));
		XYZGRIDDING_MATH(CreateGridLine(vHoriX, vHoriY, pDataInfo->dXMin, pDataInfo->dXMax, pDataInfo->dYMin, pDataInfo->dYMax, pDataInfo->dYStep, false));
		
		return ctrlRange.UpdateGrid(vVertX, vVertY, vHoriX, vHoriY);
	}
	
	return true;
}
bool XYZ2MatGraphControlManager::UpdateDataSel(const XYZGriddingRangeRestrictionSettings* pRangeRestriction, const XYZGrdiddingDataInfo* pDataInfo)
{
	if ( !pRangeRestriction )
		return false;
	
	switch (m_nCurGraph)
	{
	case XYZ_GRAPH_INDEX_XY_RANGE:
		DataSelectionGraphControl& ctrlRange = (DataSelectionGraphControl&)(m_arrGraphs.GetAt(m_nCurGraph));			
		return ctrlRange.UpdateDataSel(pRangeRestriction, pDataInfo);
	}
	
	return true;
}
bool XYZ2MatGraphControlManager::UpdatePlotType(const XYZGriddingPreviewSettings* pPreviewSetting)
{
	if ( !pPreviewSetting )
		return false;
	
	switch (m_nCurGraph)
	{
	case XYZ_GRAPH_INDEX_XYZ_WIREFRAME:
	case XYZ_GRAPH_INDEX_XYZ_CONTOUR:
		PreviewResultGraphControl& ctrlPreview = (PreviewResultGraphControl&)(m_arrGraphs.GetAt(m_nCurGraph));
		ctrlPreview.SetPlotType(pPreviewSetting->nPreviewPlotType);
		break;
	}
	
	return true;
}	

bool XYZ2MatGraphControlManager::GetDataSel(XYZGriddingRangeRestrictionSettings* pRangeRestriction)
{
	if ( !pRangeRestriction )
		return false;
	
	switch (m_nCurGraph)
	{
	case XYZ_GRAPH_INDEX_XY_RANGE:
		DataSelectionGraphControl& ctrlRange = (DataSelectionGraphControl&)(m_arrGraphs.GetAt(m_nCurGraph));			
		return ctrlRange.GetDataSel(pRangeRestriction);
	}
	
	return true;
}
/////////////moved from Dlg class/////////////////////////
BOOL XYZ2MatGraphControlManager::OnAfterDlgResize(RECT& rTab)
{
	updateBottomTabSize(rTab);
	
	if(!isBottomPaneShown())
		updateGraphShown(-1); //hide all bottom pane control
	return true;	
}

BOOL 	XYZ2MatGraphControlManager::OnShowBottomPane(Control ctrl, bool bBottomPaneShown, RECT& rTab)
{
	m_bBottomPaneShow = bBottomPaneShown;
	if(bBottomPaneShown)
	{
		SwitchTab();
		updateBottomTabSize(rTab);
	}
	else
	{
		SwitchTab(true); //hide all graph controls
	}
	return TRUE;
}

BOOL 	XYZ2MatGraphControlManager::OnChangePreviewMode(Control ctrl)
{
	m_bPreview = m_chkPreview.Check;
	SwitchTab();
	return TRUE;
}

BOOL XYZ2MatGraphControlManager::OnTabChange(Control ctrl)
{
	SwitchTab();
	return TRUE;	
}
/////////////end of moved from Dlg class/////////////////////////

void XYZ2MatGraphControlManager::SwitchTab(bool bHideAll)// = false
{
	///---Sim 09-16-2009 IMPROVE_GRIDDING_ERROR_REPORT
	//int nGraph = bHideAll ? -1 : tabIndexToGraphIndex(GetShowTab(), m_nPreviewPlotType, (m_bPreview && !m_bLargeDataSet));
	int nGraph = bHideAll ? -1 : tabIndexToGraphIndex(GetShowTab(), m_nPreviewPlotType, (m_bPreview && !m_bLargeDataSet && (OE_NOERROR == m_nErrorCode)));
	///---END IMPROVE_GRIDDING_ERROR_REPORT
	
	updateGraphShown(nGraph);
	updateQuickPreviewCtrlShow();
}

class PreviewUpdateMatch
{
public:
	PreviewUpdateMatch()
	{
		constructMatchList();
	}
	~PreviewUpdateMatch()
	{
	}

	void GetMatchBits(int nType, vector<DWORD> &vdwUpdateBits)
	{
		ASSERT( m_vnTypes.GetSize() == m_vnGraphs.GetSize() && m_vnTypes.GetSize() == m_vdwbits.GetSize() );
		ASSERT( XYZ_GRAPH_TOTAL_GRAPHS == vdwUpdateBits.GetSize() );
		
		for ( int ii = 0; ii < m_vnTypes.GetSize(); ii++ )
			if ( m_vnTypes[ii] == nType )
			{
				int nGraph = m_vnGraphs[ii];
				if ( nGraph < 0 )
				{
					continue;
				}
				else				
				if ( nGraph < XYZ_GRAPH_TOTAL_GRAPHS )
				{
					///---Sim 02-09-2010 QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
					//vdwUpdateBits[nGraph] |= m_vdwbits[ii];
					vdwUpdateBits[nGraph] |= ( m_vdwbits[ii] & getBitsMask(nGraph) );
					///---END QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
				}
				else
				{
					for ( nGraph = 0; nGraph < XYZ_GRAPH_TOTAL_GRAPHS; nGraph++ )
						///---Sim 02-09-2010 QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
						//vdwUpdateBits[nGraph] |= m_vdwbits[ii];
						vdwUpdateBits[nGraph] |= ( m_vdwbits[ii] & getBitsMask(nGraph) );
						///---END QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
				}
			}
	}
	
private:
	void	constructMatchList()
	{
		///---Sim 02-09-2010 QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
		// init update bits	
		vector<int> vnMaskGraphIndeces = {
						XYZ_GRAPH_INDEX_XY_RANGE,
						XYZ_GRAPH_INDEX_X_HISTOGRAM,
						XYZ_GRAPH_INDEX_Y_HISTOGRAM,
						XYZ_GRAPH_INDEX_XYZ_WIREFRAME,
						XYZ_GRAPH_INDEX_XYZ_CONTOUR,
						XYZ_GRAPH_INDEX_XYZ_NONE_PREVIEW
						};
		vector<DWORD> vdwMaskBits = {
						UPDATE_PREVIEW_PLOT_TYPE_CHANGED | UPDATE_PREVIEW_DATA_CHANGED | UPDATE_PREVIEW_SEL_RANGE_USE | UPDATE_PREVIEW_SEL_RANGE_CHANGED | UPDATE_PREVIEW_GRID_CHANGED,
						UPDATE_PREVIEW_PLOT_TYPE_CHANGED | UPDATE_PREVIEW_SEL_DATA_CHANGED,
						UPDATE_PREVIEW_PLOT_TYPE_CHANGED | UPDATE_PREVIEW_SEL_DATA_CHANGED,
						UPDATE_PREVIEW_PLOT_TYPE_CHANGED | UPDATE_PREVIEW_DATA_CHANGED | UPDATE_PREVIEW_RESULT_CHANGED,					
						UPDATE_PREVIEW_PLOT_TYPE_CHANGED | UPDATE_PREVIEW_DATA_CHANGED | UPDATE_PREVIEW_RESULT_CHANGED,
						0 //UPDATE_RREVIEW_SKIP_LARGE_DATA_SET
						};					
		ASSERT( vnMaskGraphIndeces.GetSize() == vdwMaskBits.GetSize() );
		m_vnMaskGraphIndeces = vnMaskGraphIndeces;
		m_vdwMaskBits = vdwMaskBits;
		///---END QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
		
		//XYZ_CHANGE_INIT,
		m_vnTypes.	Add(XYZ_CHANGE_INIT);
		m_vnGraphs.	Add(XYZ_GRAPH_TOTAL_GRAPHS);
		m_vdwbits.	Add(UPDATE_PREVIEW_ALL);
		
		//XYZ_CHANGE_DATA,
		m_vnTypes.	Add(XYZ_CHANGE_DATA);
		m_vnGraphs.	Add(XYZ_GRAPH_TOTAL_GRAPHS);
		m_vdwbits.	Add(UPDATE_PREVIEW_DATA_CHANGED | UPDATE_PREVIEW_SEL_DATA_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_DATA);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XY_RANGE);
		m_vdwbits.	Add(UPDATE_PREVIEW_SEL_RANGE_CHANGED | UPDATE_PREVIEW_GRID_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_DATA);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_WIREFRAME);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_DATA);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_CONTOUR);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
		
		//XYZ_CHANGE_EXAM,
		m_vnTypes.	Add(XYZ_CHANGE_EXAM);
		m_vnGraphs.	Add(XYZ_GRAPH_TOTAL_GRAPHS);
		m_vdwbits.	Add(UPDATE_PREVIEW_DATA_CHANGED | UPDATE_PREVIEW_SEL_DATA_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_EXAM);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XY_RANGE);
		m_vdwbits.	Add(UPDATE_PREVIEW_SEL_RANGE_CHANGED | UPDATE_PREVIEW_GRID_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_EXAM);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_WIREFRAME);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_EXAM);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_CONTOUR);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
		
		//XYZ_CHANGE_COLUMN_AND_ROW,
		m_vnTypes.	Add(XYZ_CHANGE_COLUMN_AND_ROW);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XY_RANGE);
		m_vdwbits.	Add(UPDATE_PREVIEW_GRID_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_COLUMN_AND_ROW);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_WIREFRAME);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_COLUMN_AND_ROW);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_CONTOUR);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
	
		//XYZ_CHANGE_SEL_RANGE_USE,
		m_vnTypes.	Add(XYZ_CHANGE_SEL_RANGE_USE);
		m_vnGraphs.	Add(XYZ_GRAPH_TOTAL_GRAPHS);
		m_vdwbits.	Add(UPDATE_PREVIEW_SEL_DATA_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_SEL_RANGE_USE);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XY_RANGE);
		m_vdwbits.	Add(UPDATE_PREVIEW_SEL_RANGE_USE | UPDATE_PREVIEW_GRID_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_SEL_RANGE_USE);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_WIREFRAME);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_SEL_RANGE_USE);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_CONTOUR);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
	
		//XYZ_CHANGE_SEL_RANGE,
		m_vnTypes.	Add(XYZ_CHANGE_SEL_RANGE);
		m_vnGraphs.	Add(XYZ_GRAPH_TOTAL_GRAPHS);
		m_vdwbits.	Add(UPDATE_PREVIEW_SEL_DATA_CHANGED);
	
		m_vnTypes.	Add(XYZ_CHANGE_SEL_RANGE);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XY_RANGE);
		m_vdwbits.	Add(UPDATE_PREVIEW_SEL_RANGE_CHANGED | UPDATE_PREVIEW_GRID_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_SEL_RANGE);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_WIREFRAME);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_SEL_RANGE);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_CONTOUR);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
	
		//XYZ_CHANGE_METHOD,
		m_vnTypes.	Add(XYZ_CHANGE_METHOD);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XY_RANGE);
		m_vdwbits.	Add(UPDATE_PREVIEW_GRID_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_METHOD);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_WIREFRAME);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_METHOD);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_CONTOUR);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
	
		//XYZ_CHANGE_METHOD_PARAMS,
		m_vnTypes.	Add(XYZ_CHANGE_METHOD_PARAMS);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_WIREFRAME);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_METHOD_PARAMS);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_CONTOUR);
		m_vdwbits.	Add(UPDATE_PREVIEW_RESULT_CHANGED);
	
		//XYZ_CHANGE_PREVIEW_PLOT_TYPE,	
		m_vnTypes.	Add(XYZ_CHANGE_PREVIEW_PLOT_TYPE);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_WIREFRAME);
		m_vdwbits.	Add(UPDATE_PREVIEW_PLOT_TYPE_CHANGED);
		
		m_vnTypes.	Add(XYZ_CHANGE_PREVIEW_PLOT_TYPE);
		m_vnGraphs.	Add(XYZ_GRAPH_INDEX_XYZ_CONTOUR);
		m_vdwbits.	Add(UPDATE_PREVIEW_PLOT_TYPE_CHANGED);
	
		// add more here		
	}	
	///---Sim 02-09-2010 QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
	DWORD getBitsMask(int nGraph)
	{
		for ( int ii = 0; ii < m_vnMaskGraphIndeces.GetSize(); ii++ )
		{
			if ( nGraph == m_vnMaskGraphIndeces[ii] )
				return m_vdwMaskBits[ii];
		}
		
		return UPDATE_PREVIEW_ALL;
	}
	///---END QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
	
private:
	vector<int> 		m_vnTypes;
	vector<int> 		m_vnGraphs;
	vector<DWORD> 		m_vdwbits;
	
	///---Sim 02-09-2010 QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
	vector<int>			m_vnMaskGraphIndeces;
	vector<DWORD>		m_vdwMaskBits;
	///---END QA81-12191 FIX_NO_NEED_GRIDDING_FIRST_WHEN_OPEN_XYZ2MAT_DLG
};

void XYZ2MatGraphControlManager::OnChange(int nType)// = XYZ_CHANGE_INIT
{
	PreviewUpdateMatch updateMatch;
	updateMatch.GetMatchBits(nType, m_vdwUpdateBits);
}

void XYZ2MatGraphControlManager::PreChangeTab(int nType, const XYZGriddingSettings* pSetting, const XYZGrdiddingDataInfo* pDataInfo)
{
	if ( XYZ_CHANGE_INIT == nType 
		|| XYZ_CHANGE_PREVIEW_PLOT_TYPE == nType )
	{
		if ( pSetting )
		{
			m_nPreviewPlotType = pSetting->settingPreview.nPreviewPlotType;
			SwitchTab();
		}
	}
	
	if ( XYZ_CHANGE_INIT == nType 
		|| XYZ_CHANGE_DATA == nType || XYZ_CHANGE_EXAM == nType || XYZ_CHANGE_METHOD == nType )
	{
		if ( pDataInfo )
		{
			m_nErrorCode = OE_NOERROR; ///---Sim 09-16-2009 IMPROVE_GRIDDING_ERROR_REPORT
			m_bLargeDataSet = XYZGRIDDING_MATH(IsLargeDataSet(pSetting, pDataInfo));
			SwitchTab();
		}
	}
}
	
bool XYZ2MatGraphControlManager::IsDirty(DWORD *pdwUpdateBits)// = NULL
{
	if ( pdwUpdateBits )
		*pdwUpdateBits = m_vdwUpdateBits[m_nCurGraph];
	return ( m_vdwUpdateBits[m_nCurGraph] != 0 );
}

bool XYZ2MatGraphControlManager::UpdatePreview()
{
	XYZ2MatGraphControl& gc = m_arrGraphs.GetAt(m_nCurGraph);
	
	string strLabel;
	if ( XYZ_GRAPH_INDEX_XYZ_NONE_PREVIEW == m_nCurGraph )
	{
		///---Sim 09-16-2009 IMPROVE_GRIDDING_ERROR_REPORT
		if ( OE_NOERROR != m_nErrorCode )
		{
			// to do
			strLabel = TEMPLATE_NONE_PREVIEW_CONTENT;
			strLabel += CHAR_SEP_NONE_PREVIEW_HINT;
			strLabel += TEMPLATE_NONE_PREVIEW_XYZ2MAT_GRIDDING_FAILED_HINTS;
		}
		///---END IMPROVE_GRIDDING_ERROR_REPORT
		
		if ( m_bLargeDataSet )
		{
			// to do
			strLabel = TEMPLATE_NONE_PREVIEW_CONTENT;
			strLabel += CHAR_SEP_NONE_PREVIEW_HINT;
			strLabel += TEMPLATE_NONE_PREVIEW_XYZ2MAT_DATA_SET_TOO_LARGE_HINTS;
		}
		
		if ( !m_bPreview )
		{
			strLabel = TEMPLATE_NONE_PREVIEW_CONTENT;
			strLabel += CHAR_SEP_NONE_PREVIEW_HINT;
			strLabel += TEMPLATE_NONE_PREVIEW_XYZ2MAT_HINTS;
		}
	}
	
	bool bRet = gc.UpdateGraph(m_vdwUpdateBits[m_nCurGraph], strLabel);
	
	if ( bRet )
		m_vdwUpdateBits[m_nCurGraph] = 0;
	
	return bRet;
}

int 	XYZ2MatGraphControlManager::GetShowTab()
{
	return m_tab.GetCurSel();	
}

void 	XYZ2MatGraphControlManager::updateBottomTabSize(RECT& rTab)
{
	m_tab.AdjustRect(FALSE, &rTab);

	for(int ii=0; ii < XYZ_GRAPH_TOTAL_GRAPHS; ii++)
	{
		Control cntrl = m_arrGraphControls.GetAt(ii);
		if(cntrl)
			cntrl.MoveWindow(&rTab);
	}
}
void 	XYZ2MatGraphControlManager::updateGraphShown(int nGraph)
{
	m_nCurGraph = nGraph;
	
	for( int ii = 0; ii < XYZ_GRAPH_TOTAL_GRAPHS; ii++ )
	{
		Control& ctrl = m_arrGraphControls.GetAt(ii);
		if(ctrl)
		{
			ctrl.Visible = (ii == nGraph) ? true : false; //show this graph and hide others
		}
	}	
}
void XYZ2MatGraphControlManager::updateQuickPreviewCtrlShow()
{
	bool bShow = XYZ_TAB_INDEX_PREVIEW_RESULT == GetShowTab() && isBottomPaneShown();
	ASSERT(m_chkPreview);
	m_chkPreview.Visible = bShow;
}

int		XYZ2MatGraphControlManager::graphIndexToTabIndex(int nGraph)
{
	if( nGraph < 0 || nGraph >= XYZ_GRAPH_TOTAL_GRAPHS )
		return -1;	
	
	if( nGraph == XYZ_GRAPH_INDEX_XYZ_WIREFRAME || nGraph == XYZ_GRAPH_INDEX_XYZ_CONTOUR )
		return XYZ_TAB_INDEX_PREVIEW_RESULT;
	
	return nGraph;
}

int 	XYZ2MatGraphControlManager::tabIndexToGraphIndex(int nTab, int nPlotType, bool bPreview)
{
	if( nTab < XYZ_TAB_INDEX_XY_RANGE || nTab >= XYZ_TAB_TOTAL_TABS )
		return -1;
	
	if( nTab < XYZ_TAB_INDEX_PREVIEW_RESULT )
		return nTab;
	
	if( nTab == XYZ_TAB_INDEX_PREVIEW_RESULT )
	{
		if ( !bPreview )
			return XYZ_GRAPH_INDEX_XYZ_NONE_PREVIEW;
		
		if( nPlotType == PREVIEW_PLOT_TYPE_COLORMAP || nPlotType == PREVIEW_PLOT_TYPE_WIREFRAME )
			return XYZ_GRAPH_INDEX_XYZ_WIREFRAME;
		else if( nPlotType == PREVIEW_PLOT_TYPE_COLORFILL )
			return XYZ_GRAPH_INDEX_XYZ_CONTOUR;
	}
	return -1;
}
	
bool 	XYZ2MatGraphControlManager::isWorksheetShared(int nGraph)
{
	return XYZ_GRAPH_INDEX_X_HISTOGRAM != nGraph && XYZ_GRAPH_INDEX_Y_HISTOGRAM != nGraph;	
}

int 	XYZ2MatGraphControlManager::getSharedMatrixPage(int nGraph)
{
	switch(nGraph)
	{
	case XYZ_GRAPH_INDEX_XYZ_WIREFRAME:
		return XYZ_GRAPH_INDEX_XYZ_CONTOUR;
	case XYZ_GRAPH_INDEX_XYZ_CONTOUR:
		return XYZ_GRAPH_INDEX_XYZ_WIREFRAME;
	default:
		return -1;
	}
	return -1;
}
