/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Frank 4/14/05  USER_INPUT_GET_WRONG_PAGE									*
 *	ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC								*
 *  Iris 8/24/05 GET_VAR_NUM_FROM_ATTRIB_NOT_NODE_NUM							*
 *	Jasmine 02/24/06 MOVE_FROM_XFUNCTIONWIZ										*
 *	Bill 10/14/2011 ORG-3947-P1 COULD_NOT_EDIT_DATA_FOR_INT_AND_DOUBLE_IN_XF_CREATE_BY_XFUNCTIONWIZ
 *------------------------------------------------------------------------------*/

#ifndef _XFW_H
#define _XFW_H

//#include <Origin.h>
//#include <Dialog.h>
//#include "XFunctionWizRes.h"
//#define STR_XF_TYPE						"internal"
#define	STR_NUM_VAR_ATTRIB				"count"
#define STR_VAR_NODE_PREFIX				"v"
#define STR_INPUT_VAR_NODE				"input"
#define STR_OUTPUT_VAR_NODE				"output"
#define STR_VARNAME_NODE				"name"
/// ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC
//#define STR_VARTYPE_NODE				"type"
/// end XFUNCTION_TREE_MANIPULATION_IN_VC
#define	STR_CODE_NODE					"code"
//#define STR_DATA_NODE					"data"
#define STR_DATA_NODE					"valdata"

#define ERR_STR_NAME_INVALID(_STR)		"\""+_STR+"\" is not a valid name"
#define ERR_STR_NAMR_REPEAT(_STR)		"Variable name \""+_STR+"\" has been used"

#define ERR_PROMPTS_NAME_INVALID(_STR)	-1 == MessageBox(GetSafeHwnd(), ERR_STR_NAME_INVALID(_STR));
#define ERR_PROMPTS_NAME_REPEAT(_STR)	-1 == MessageBox(GetSafeHwnd(), ERR_STR_NAMR_REPEAT(_STR));

#define ENUM_STR(_STR, _II, _NUM)	((_NUM > 1)? ((string)_STR + (string)(_II + 1)) : _STR)

/// Bill 10/14/2011 ORG-3947-P1 COULD_NOT_EDIT_DATA_FOR_INT_AND_DOUBLE_IN_XF_CREATE_BY_XFUNCTIONWIZ
// refer XFDialog.h DECL_XF, to synchronise ID's with type
#define XF_WIZ_DECL_XF(_XF, _TREE)				XFunction _XF(_TREE, false);
/// End COULD_NOT_EDIT_DATA_FOR_INT_AND_DOUBLE_IN_XF_CREATE_BY_XFUNCTIONWIZ

/*
class XFWXFType : public PropertyPage
{
public:
	XFWXFType(int nID) : PropertyPage(nID) {}
	void Init(TreeNode &tr) { m_trXF = tr; }
	
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
	EVENTS_END

	BOOL OnInitPage()
	{
		out_str("OnInitPage");
		treeTodialg();
		return TRUE;		
	}

	BOOL OnActivatePage()
	{
		out_str("OnInitPage");
		treeTodialg();
		return TRUE;		
	}
	BOOL OnKillActiviePage()
	{
		TreeNode trXFtype = tree_check_get_node(m_trXF, STR_XF_TYPE);
		int nn = GetCheckedRadioButton(IDC_XFW_XF_TYPE_INTERNAL, IDC_XFW_XF_TYPE_EXTERNAL);
		trXFtype.nVal = nn == IDC_XFW_XF_TYPE_INTERNAL? 1:0;
		return TRUE;		
	}
private :
	void		treeTodialg()
	{
		TreeNode trXFtype = tree_check_get_node(m_trXF, STR_XF_TYPE);
		int nn = trXFtype.nVal == 0? IDC_XFW_XF_TYPE_EXTERNAL : IDC_XFW_XF_TYPE_INTERNAL;
		CheckRadioButton(IDC_XFW_XF_TYPE_INTERNAL, IDC_XFW_XF_TYPE_EXTERNAL, nn);
	}
	TreeNode 	m_trXF;
};
*/
class XFWInputVarNum : public PropertyPage
{
public:
	// Constructor for XFWInputVarNum page
	XFWInputVarNum(int nID) : PropertyPage(nID) {}
	void Init(TreeNode &trFunction) { m_trInputVar=tree_check_get_node(trFunction, STR_INPUT_VAR_NODE); }
	
	// Event handlers for XFWInputVarNum page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
	EVENTS_END

	BOOL OnInitPage()
	{
		m_comboInputNum = GetItem(IDC_XFW_INPUT_NUM_ED);
		m_comboInputNum.SetCurSel(0);
		return TRUE;		
	}

	BOOL OnActivatePage()
	{
		return TRUE;		
	}
	BOOL OnKillActiviePage()
	{
		string str;
		m_comboInputNum.GetLBText(m_comboInputNum.GetCurSel(), str);
		m_trInputVar.SetAttribute(STR_NUM_VAR_ATTRIB, atoi(str));
		return TRUE;		
	}
private :
	ComboBox	m_comboInputNum;
	TreeNode 	m_trInputVar;
};

class XFWInputVarType : public PropertyPage
{
public:
	// Constructor for XFWInputVarType page
	XFWInputVarType(int nID) : PropertyPage(nID) {}
	void Init(TreeNode &trFunction) { m_trInputVar=tree_check_get_node(trFunction, STR_INPUT_VAR_NODE); }
	
	// Event handlers for XFWInputVarType page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_NEXT(OnNext)
	EVENTS_END

	BOOL OnInitPage()
	{
		//consider static text later
		vnIDInputVars.Add(IDC_XFW_INPUT_CBLIST_VAR1);
		vnIDInputVars.Add(IDC_XFW_INPUT_CBLIST_VAR2);
		vnIDInputVars.Add(IDC_XFW_INPUT_CBLIST_VAR3);
		vnIDInputVars.Add(IDC_XFW_INPUT_CBLIST_VAR4);
		vnIDInputVars.Add(IDC_XFW_INPUT_CBLIST_VAR5);
		
		vnIDInputVarsName.Add(IDC_XFW_INPUT_NAME_VAR1);
		vnIDInputVarsName.Add(IDC_XFW_INPUT_NAME_VAR2);
		vnIDInputVarsName.Add(IDC_XFW_INPUT_NAME_VAR3);
		vnIDInputVarsName.Add(IDC_XFW_INPUT_NAME_VAR4);
		vnIDInputVarsName.Add(IDC_XFW_INPUT_NAME_VAR5);
		
		ComboBox cb;
		vector<string> vsVarTypes; 
		okutil_xft_get_X_Function_variable_types(&vsVarTypes);
		for(int ii=0; ii<vnIDInputVars.GetSize(); ii++)
		{
			cb=GetItem(vnIDInputVars[ii]);
			for(int jj=0; jj<vsVarTypes.GetSize(); jj++)
			{
				cb.AddString(vsVarTypes[jj]);
			}
			cb.SetCurSel(XVT_VECTOR);
		}
		m_bInitControl=true;
		return TRUE;
	}

	BOOL OnActivatePage()
	{
		int nNumVar;
		if(m_trInputVar.GetAttribute(STR_NUM_VAR_ATTRIB, nNumVar) && nNumVar != m_nNumVar)
		{
			m_nNumVar=nNumVar;
			m_bInitControl=true;
		}
		if(!m_bInitControl)
			return true;
		for(int ii=0; ii<m_nNumVar; ii++)
		{
			GetItem(vnIDInputVars[ii]).Visible=true;
			Edit ed=GetItem(vnIDInputVarsName[ii]);
			ed.Visible=true;
			if(m_bInitControl)
				ed.Text = ENUM_STR("x", ii, m_nNumVar);
		}
		for(ii=m_nNumVar; ii<vnIDInputVars.GetSize(); ii++)
		{
			GetItem(vnIDInputVars[ii]).Visible=false;
			GetItem(vnIDInputVarsName[ii]).Visible=false;
		}
		m_bInitControl=false;
		return TRUE;		
	}
	
	BOOL OnNext()
	{
		if(!checkName())
			return false;	//return false should go back to this page
		for(int ii=0; ii<m_nNumVar; ii++)
		{
			Edit		ed=GetItem(vnIDInputVarsName[ii]);
			ComboBox 	cb=GetItem(vnIDInputVars[ii]);
			
			TreeNode trVar=tree_check_get_node(m_trInputVar, STR_VAR_NODE_PREFIX+(string)(ii+1));
			TreeNode trName=tree_check_get_node(trVar, STR_VARNAME_NODE);
			TreeNode trType=tree_check_get_node(trVar, STR_VARTYPE_NODE);
			
			trName.strVal=ed.Text;
			string strType;
			cb.GetLBText(cb.GetCurSel(), strType);
			trType.strVal=strType;
		}
		///Iris 8/24/05 GET_VAR_NUM_FROM_ATTRIB_NOT_NODE_NUM
		for(ii=m_nNumVar; ii<vnIDInputVars.GetSize(); ii++)
		{
			TreeNode trVar=tree_check_get_node(m_trInputVar, STR_VAR_NODE_PREFIX+(string)(ii+1));
			if(trVar)
				trVar.Remove();		
		}
		///End GET_VAR_NUM_FROM_ATTRIB_NOT_NODE_NUM
		return true;
	}
private:
	bool checkName()
	{
		vector<string> vsVarNames;
		string strErrorName=checkgetInputNames(vsVarNames);
		if(!strErrorName.IsEmpty())
		{
			return ERR_PROMPTS_NAME_INVALID(strErrorName);
		}
		getOutputVarNames(vsVarNames);
		for(int ii=0; ii<vsVarNames.GetSize(); ii++)
		{
			if(-1 != vsVarNames.Find(vsVarNames[ii], ii+1))
			{
				return ERR_PROMPTS_NAME_REPEAT(vsVarNames[ii]);
			}
		}
		return true;
	}
	string checkgetInputNames(vector<string> &vsInputNames)
	{
		string strName;
		for(int ii=0; ii<m_nNumVar; ii++)
		{
			strName=GetItem(vnIDInputVarsName[ii]).Text;
			string strTemp=strName;
			strTemp.MakeValidCName();
			if(strTemp != strName)
				break;
			vsInputNames.Add(strName);
			strName.Empty();
		}
		return strName;
	}
	void getOutputVarNames(vector<string> &vsNames)
	{
		TreeNode trOutputVar=m_trInputVar.Parent().GetNode(STR_OUTPUT_VAR_NODE);
		foreach(TreeNode trVar in trOutputVar.Children)
		{
			vsNames.Add(trVar.GetNode(STR_VARNAME_NODE).strVal);
		}
	}
private :
	int				m_nNumVar;
	vector<int>		vnIDInputVarsName;
	vector<int>		vnIDInputVars;
	TreeNode 		m_trInputVar;
	
	bool			m_bInitControl;
};

class XFWOutputVarNum : public PropertyPage
{
public:
	// Constructor for XFWOutputVarNum page
	XFWOutputVarNum(int nID) : PropertyPage(nID) {}
	void Init(TreeNode &trFunction) { m_trOutputVar=tree_check_get_node(trFunction, STR_OUTPUT_VAR_NODE); }

	// Event handlers for XFWOutputVarNum page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
		PAGE_ON_NEXT(OnNext)
	EVENTS_END

	BOOL OnInitPage()
	{
		m_comboOutputNum = GetItem(IDC_XFW_OUTPUT_NUM_ED);
		// CPY we need to support 0 as num of output var
		m_comboOutputNum.ResetContent();
		for(int ii = 0; ii < 5; ii++)
		{
			string str = ii;
			m_comboOutputNum.AddString(str);
		}
		m_comboOutputNum.SetCurSel(1);
		return TRUE;		
	}

	BOOL OnActivatePage()
	{
		return TRUE;		
	}
	BOOL OnKillActiviePage()
	{
		//out_str("XFWOutputVarNum::OnKillActiviePage");
		return true;
	}
	BOOL OnNext()
	{
		string str;
		int nSel = m_comboOutputNum.GetCurSel();
		///---Frank 4/14/05  USER_INPUT_GET_WRONG_PAGE
		//m_comboOutputNum.GetLBText(m_comboOutputNum.GetCurSel(), str);
		//if(nSel < 0 )
		str = m_comboOutputNum.Text;
		///---End  USER_INPUT_GET_WRONG_PAGE
		
		int nNumVars = atoi(str);
		m_trOutputVar.SetAttribute(STR_NUM_VAR_ATTRIB, nNumVars);
		//out_int("XFWOutputVarNum::OnNext num output vars = ", nNumVars);
		return TRUE;		
	}

private :
	//Edit		m_edOutputNum;
	ComboBox	m_comboOutputNum;
	TreeNode	m_trOutputVar;
};

class XFWOutputVarType : public PropertyPage
{
public:
	// Constructor for XFWOutputVarType page
	XFWOutputVarType(int nID) : PropertyPage(nID) {}
	void Init(TreeNode &trFunction) { m_trOutputVar=tree_check_get_node(trFunction, STR_OUTPUT_VAR_NODE); }

	// Event handlers for XFWOutputVarType page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_NEXT(OnNext)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
	EVENTS_END

	BOOL OnInitPage()
	{
		//consider static text later
		vnIDOutputVars.Add(IDC_XFW_OUTPUT_CBLIST_VAR1);
		vnIDOutputVars.Add(IDC_XFW_OUTPUT_CBLIST_VAR2);
		vnIDOutputVars.Add(IDC_XFW_OUTPUT_CBLIST_VAR3);
		vnIDOutputVars.Add(IDC_XFW_OUTPUT_CBLIST_VAR4);
		vnIDOutputVars.Add(IDC_XFW_OUTPUT_CBLIST_VAR5);
		
		vnIDOutputVarsName.Add(IDC_XFW_OUTPUT_NAME_VAR1);
		vnIDOutputVarsName.Add(IDC_XFW_OUTPUT_NAME_VAR2);
		vnIDOutputVarsName.Add(IDC_XFW_OUTPUT_NAME_VAR3);
		vnIDOutputVarsName.Add(IDC_XFW_OUTPUT_NAME_VAR4);
		vnIDOutputVarsName.Add(IDC_XFW_OUTPUT_NAME_VAR5);
		
		ComboBox cb;
		vector<string> vsVarTypes; 
		okutil_xft_get_X_Function_variable_types(&vsVarTypes);
		for(int ii=0; ii<vnIDOutputVars.GetSize(); ii++)
		{
			cb=GetItem(vnIDOutputVars[ii]);
			for(int jj=0; jj<vsVarTypes.GetSize(); jj++)
				cb.AddString(vsVarTypes[jj]);
			
			cb.SetCurSel(XVT_VECTOR);
		}
		m_bInitControl=true;
		return TRUE;		
	}
	DWORD	OnShowStatus(DWORD dwInternal)
	{
		int nNumVar;
		if(m_trOutputVar.GetAttribute(STR_NUM_VAR_ATTRIB, nNumVar) && nNumVar != m_nNumVar)
		{
			m_nNumVar=nNumVar;
			m_bInitControl=true;
		}
		//out_int("XFWOutputVarType::OnShowStatus, num output var =", m_nNumVar);
		if(0==m_nNumVar)
			return PSS_Hide;
		
		return PSS_Show;//dwInternal; 
	}
	BOOL OnActivatePage()
	{
		//out_int("XFWOutputVarType::OnActivatePage, num output var =", m_nNumVar);
		//int nNumVar, nNumInputVar;
		//m_trOutputVar.Parent().GetNode(STR_INPUT_VAR_NODE).GetAttribute(STR_NUM_VAR_ATTRIB, nNumInputVar);
		
		if(!m_bInitControl)
			return true;
		for(int ii=0; ii<m_nNumVar; ii++)
		{
			GetItem(vnIDOutputVars[ii]).Visible=true;
			Edit ed=GetItem(vnIDOutputVarsName[ii]);
			ed.Visible=true;
			if(m_bInitControl)
				ed.Text = ENUM_STR("y", ii, m_nNumVar);
		}
		for(ii=m_nNumVar; ii<vnIDOutputVars.GetSize(); ii++)
		{
			GetItem(vnIDOutputVars[ii]).Visible=false;
			GetItem(vnIDOutputVarsName[ii]).Visible=false;
		}
		m_bInitControl=false;
		return TRUE;		
	}
	BOOL OnNext()
	{
		//out_int("XFWOutputVarType::OnNext, num output var =", m_nNumVar);
		if(!checkName())
			return false;	//return false should go back to this page
		for(int ii=0; ii<m_nNumVar; ii++)
		{
			Edit		ed=GetItem(vnIDOutputVarsName[ii]);
			ComboBox 	cb=GetItem(vnIDOutputVars[ii]);
			
			TreeNode trVar=tree_check_get_node(m_trOutputVar, STR_VAR_NODE_PREFIX+(string)(ii+1));
			TreeNode trName=tree_check_get_node(trVar, STR_VARNAME_NODE);
			TreeNode trType=tree_check_get_node(trVar, STR_VARTYPE_NODE);
			
			trName.strVal=ed.Text;
			string strType;
			cb.GetLBText(cb.GetCurSel(), strType);
			trType.strVal=strType;
		}
		///Iris 8/24/05 GET_VAR_NUM_FROM_ATTRIB_NOT_NODE_NUM
		for(ii=m_nNumVar; ii<vnIDOutputVars.GetSize(); ii++)
		{
			TreeNode trVar=tree_check_get_node(m_trOutputVar, STR_VAR_NODE_PREFIX+(string)(ii+1));
			if(trVar)
				trVar.Remove();		
		}
		///End GET_VAR_NUM_FROM_ATTRIB_NOT_NODE_NUM
		return true;
	}
	BOOL OnKillActiviePage()
	{
		//out_int("XFWOutputVarType::OnKillActiviePage, num output var =", m_nNumVar);
		return true;
	}
private:
	bool checkName()
	{
		vector<string> vsVarNames;
		string strErrorName=checkgetInputNames(vsVarNames);
		if(!strErrorName.IsEmpty())
		{
			return ERR_PROMPTS_NAME_INVALID(strErrorName);
		}
		getInputVarNames(vsVarNames);
		for(int ii=0; ii<vsVarNames.GetSize(); ii++)
		{
			if(-1 != vsVarNames.Find(vsVarNames[ii], ii+1))
			{
				return ERR_PROMPTS_NAME_REPEAT(vsVarNames[ii]);
			}
		}
		return true;
	}
	string checkgetInputNames(vector<string> &vsOutputNames)
	{
		string strName;
		for(int ii=0; ii<m_nNumVar; ii++)
		{
			strName=GetItem(vnIDOutputVarsName[ii]).Text;
			string strTemp=strName;
			strTemp.MakeValidCName();
			if(strTemp != strName)
				break;
			vsOutputNames.Add(strName);
			strName.Empty();
		}
		return strName;
	}
	void getInputVarNames(vector<string> &vsNames)
	{
		TreeNode trInputVar=m_trOutputVar.Parent().GetNode(STR_INPUT_VAR_NODE);
		foreach(TreeNode trVar in trInputVar.Children)
		{
			vsNames.Add(trVar.GetNode(STR_VARNAME_NODE).strVal);
		}
	}

private :
	int				m_nNumVar;
	vector<int>		vnIDOutputVarsName;
	vector<int>		vnIDOutputVars;
	TreeNode 		m_trOutputVar;
	
	bool			m_bInitControl;
};

#define STR_VAR_SEPARATOR ", "
class XFWFunctionBody : public PropertyPage
{
public:
	// Constructor for XFWFunctionBody page
	XFWFunctionBody(int nID) : PropertyPage(nID) {}
	void Init(TreeNode &trFunction) { m_trSetting=trFunction; }
	
	// Event handlers for XFWFunctionBody page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
	EVENTS_END

	BOOL OnInitPage()
	{
		m_rchED=GetItem(IDC_XFW_FUNCTION_RED);
		m_staticVars = GetItem(IDD_XFW_FUNCTION_VARS);
		return TRUE;		
	}

	BOOL OnActivatePage()
	{
		TreeNode trCode=tree_check_get_node(m_trSetting, STR_CODE_NODE);
		m_rchED.Text=trCode.strVal;
		TreeNode trInputVar= tree_check_get_node(m_trSetting, STR_INPUT_VAR_NODE);
		string strVars;
		if(trInputVar)
			strVars = maek_vars_list(trInputVar);
		TreeNode trOutputVar= tree_check_get_node(m_trSetting, STR_OUTPUT_VAR_NODE);
		if(trOutputVar)
		{
			string str = maek_vars_list(trOutputVar);
			if(!str.IsEmpty())
			{
				strVars += STR_VAR_SEPARATOR;
				strVars += str;
			}
		}
		m_staticVars.Text = strVars;
		return TRUE;		
	}
	
	BOOL OnKillActiviePage()
	{
		m_trSetting.GetNode(STR_CODE_NODE).strVal=m_rchED.Text;
		return true;
	}
private :
	string			maek_vars_list(TreeNode& tr)
	{
		int nNumVars = 1;
		tr.GetAttribute(STR_NUM_VAR_ATTRIB, nNumVars);
		string str;
		for(int ii=0; ii < nNumVars; ii++)
		{
			TreeNode trVar = tree_check_get_node(tr, STR_VAR_NODE_PREFIX+(string)(ii+1));
			TreeNode trName= tree_check_get_node(trVar, STR_VARNAME_NODE);
			if(ii > 0)
				str += STR_VAR_SEPARATOR;
			str += trName.strVal;
		}
		return str;
	}
	Control			m_staticVars;
	RichEdit		m_rchED;
	TreeNode 		m_trSetting;
};

class XFWAssignVarData : public PropertyPage
{
public:
	// Constructor for XFWAssignVarData page
	XFWAssignVarData(int nID) : PropertyPage(nID) {}
	void Init(TreeNode &trFunction) {
		m_trSetting=trFunction; 
		m_trInputVar=tree_check_get_node(trFunction, STR_INPUT_VAR_NODE);
		m_trOutputVar=tree_check_get_node(trFunction, STR_OUTPUT_VAR_NODE);
	}

	// Event handlers for XFWAssignVarData page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_NEXT(OnNext)
	EVENTS_END

	BOOL OnInitPage()
	{
		for(int ii = IDC_XFW_DEFAULT_LABEL_VAR1; ii <= IDC_XFW_DEFAULT_LABEL_VAR7; ii++)
			m_vnIDVarsLabels.Add(ii);
		for(ii = IDC_XFW_DEFAULT_VAR1; ii <= IDC_XFW_DEFAULT_VAR7; ii++)
			m_vnIDVarsDefaults.Add(ii);
		
		return TRUE;		
	}

	BOOL OnActivatePage()
	{
		//out_str("XFWAssignVarData::OnActivatePage");
		/// YuI 03/21/05
		//int nCol = 1;
		//fillTreeWithColNotation(m_trInputVar, nCol);
		//fillTreeWithColNotation(m_trOutputVar, nCol);
		fillTreeWithDefaults(m_trInputVar);
		fillTreeWithDefaults(m_trOutputVar);
		/// end YuI
		int nn = show_vars_label_defaults(m_trInputVar, 0);
		nn = show_vars_label_defaults(m_trOutputVar, nn);
		for(int ii = nn; ii < m_vnIDVarsLabels.GetSize(); ii++)
		{
			Control cl = GetItem(m_vnIDVarsLabels[ii]);
			Edit	ed = GetItem(m_vnIDVarsDefaults[ii]);
			cl.Visible = false;
			ed.Visible = false;
		}
		return TRUE;		
	}
	
	BOOL OnNext() // last page, no OnKillActive, so use OnNext
	{
		//out_str("XFWAssignVarData::OnNext");
		int nNumInputs = m_trInputVar.GetNodeCount();
		for(int ii = 0; ii < m_vnIDVarsLabels.GetSize(); ii++)
		{
			Control cl = GetItem(m_vnIDVarsLabels[ii]);
			Edit	ed = GetItem(m_vnIDVarsDefaults[ii]);
			if(!ed.Visible)
				break;
			if(ii < nNumInputs)
				set_var_default(m_trInputVar, ii, ed.Text);
			else
				set_var_default(m_trOutputVar, ii - nNumInputs, ed.Text);
		}
		return true;
	}
private:
	bool set_var_default(TreeNode& trVars, int nn, string strVal)
	{
		TreeNode trVar = getVarNode(trVars, nn+1);
		if(trVar)
		{
			trVar.valdata.strVal = strVal;
			return true;
		}
		return false;
	}		
	int show_vars_label_defaults(TreeNode& tr, int nOffset)
	{
		int nn;
		foreach(TreeNode trVar in tr.Children)
		{
			TreeNode trData = tree_check_get_node(trVar, STR_DATA_NODE);
			TreeNode trName=tree_check_get_node(trVar, STR_VARNAME_NODE);
			string strValLabel = trName.strVal;// need to add type and other info later
			nn = nOffset++;
			Control cl = GetItem(m_vnIDVarsLabels[nn]);
			Edit	ed = GetItem(m_vnIDVarsDefaults[nn]);
			cl.Text = strValLabel;cl.Visible = true;
			ed.Text = trData.strVal;ed.Visible = true;
		}
		return nOffset;
	}
	
	
	/// YuI 03/21/05
	//	void fillTreeWithColNotation(TreeNode& tr, int& nCol)
	void fillTreeWithDefaults(TreeNode& tr)
	{
		int nNumVars = 1;
		tr.GetAttribute(STR_NUM_VAR_ATTRIB, nNumVars);
		for(int ii=0; ii < nNumVars; ii++)
		{
			TreeNode trVar = getVarNode(tr, ii+1, true);
			TreeNode trData = tree_check_get_node(trVar, STR_DATA_NODE);
			TreeNode trType = tree_check_get_node(trVar, STR_VARTYPE_NODE);
			string str = trData.strVal;
			/*
			if(str.IsEmpty() && trType.strVal == "vector")
				trData.strVal = (string) "Col(" + (nCol++) + ")";
			*/
			if( str.IsEmpty() )
			{
				switch( get_xvar_type_from_type_name(trType.strVal) )
				{
				case XVT_VECTOR:
					trData.strVal = "Col(1)";
					break;
					
				case XVT_XYDATARANGE:
					trData.strVal = "XYRange(1, 2)";
					break;
					
				case XVT_XYZDATARANGE:
					trData.strVal = "XYZRange(1, 2, 3)";
					break;
				}
			}
		}
	}
	TreeNode getVarNode(const TreeNode& trVars, int ii, bool bCreate = false)
	{
		TreeNode tr;
		if(trVars)
		{
			if(bCreate)
				return check_add_enumerated_node(trVars, STR_VAR_NODE_PREFIX, ii);
			else
				return get_enumerated_node(trVars, STR_VAR_NODE_PREFIX, ii);
		}
		return tr;
	}
private :
	vector<int>	m_vnIDVarsLabels;
	vector<int>	m_vnIDVarsDefaults;
	TreeNode 	m_trSetting;
	TreeNode	m_trOutputVar;
	TreeNode 	m_trInputVar;
};



class XFunctionWizPlaceHolder : public WizardSheet
{
public:
	void SetTree(const TreeNode& trDefault)
	{
		/*
		if(trDefault.internal)
		{
			TreeNode trXFtype = tree_check_get_node(m_trSetting, STR_XF_TYPE);
			trXFtype.nVal = trDefault.internal.nVal;
		}
		*/
	}
	XFunctionWizPlaceHolder()
	{
		//m_XFWXFType.SetID(IDD_XFW_XF_TYPE);
		//AddPage(m_XFWXFType);
		m_XFWInputVarNum.SetID(IDD_XFW_INPUT_VAR_NUM);
		AddPage(m_XFWInputVarNum);
		m_XFWInputVarType.SetID(IDD_XFW_INPUT_VAR_TYPE);
		AddPage(m_XFWInputVarType);
		m_XFWOutputVarNum.SetID(IDD_XFW_OUTPUT_VAR_NUM);
		AddPage(m_XFWOutputVarNum);
		m_XFWOutputVarType.SetID(IDD_XFW_OUTPUT_VAR_TYPE);
		AddPage(m_XFWOutputVarType);
		m_XFWFunctionBody.SetID(IDD_XFW_FUNCTION_BODY);
		AddPage(m_XFWFunctionBody);
		m_XFWAssignVarData.SetID(IDD_XFW_ASSIGN_VAR_DATA);
		AddPage(m_XFWAssignVarData);
		//AddPathControl(45); // Add Wizard Map on left, 45% of the width of the main dialog
		
		//m_XFWXFType.Init(m_trSetting);
		m_XFWInputVarNum.Init(m_trSetting);
		m_XFWInputVarType.Init(m_trSetting);
		m_XFWOutputVarNum.Init(m_trSetting);
		m_XFWOutputVarType.Init(m_trSetting);
		m_XFWFunctionBody.Init(m_trSetting);
		m_XFWAssignVarData.Init(m_trSetting);
	}

	void InitMaps()
	{
		//m_XFWXFType.InitMsgMap();
		m_XFWInputVarNum.InitMsgMap();
		m_XFWInputVarType.InitMsgMap();
		m_XFWOutputVarNum.InitMsgMap();
		m_XFWOutputVarType.InitMsgMap();
		m_XFWFunctionBody.InitMsgMap();
		m_XFWAssignVarData.InitMsgMap();
	}

	TreeNode GetTree()
	{
		return m_trSetting;
	}
private :
	//XFWXFType		m_XFWXFType;
	XFWInputVarNum m_XFWInputVarNum;
	XFWInputVarType m_XFWInputVarType;
	XFWOutputVarNum m_XFWOutputVarNum;
	XFWOutputVarType m_XFWOutputVarType;
	XFWFunctionBody m_XFWFunctionBody;
	XFWAssignVarData m_XFWAssignVarData;
	
	Tree			m_trSetting;
};


class XFunctionWiz : public Dialog
{
public:
	XFunctionWiz() : Dialog(IDD_XFW_DLG, "Odlg8")
	{
		m_nXFTypeDefault = IDC_XFW_XF_TYPE_EXTERNAL;
	}
	
	int DoModalEx(HWND hParent, const TreeNode& trOld)
	{
		m_trFunction = trOld;
		InitMsgMap();// will be called from internal later
		///Joseph 03/11/07 NEED_SHOW_PAGE_NAME_ON_TITLE
		//by Zarch's suggestion
		//int nRet = Dialog::DoModal(hParent);
		int nRet = Dialog::DoModal(hParent, DLG_TITLE_TO_HAVE_PAGE_NAME);
		///End NEED_SHOW_PAGE_NAME_ON_TITLE
		return nRet;
	}

	void GetFunction(TreeNode &trFunction)
	{
		trFunction=m_trFunction;
	}
protected:
///----------------- Message Map ----------------
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitDialog)
		PAGE_ON_FINISH(OnFinish)
		PAGE_ON_CANCEL(OnCancel)
	EVENTS_END
///----------------------------------------------
	
	BOOL OnInitDialog()
	{
		m_PlaceHolder.SetTree(m_trFunction);
		m_PlaceHolder.Create(IDC_PAGE_PLACEHOLDER, *this);
		m_PlaceHolder.InitMaps();
		return TRUE;
	}

	BOOL OnFinish()
	{
		m_trFunction.Reset();
		TreeNode trSetting=m_PlaceHolder.GetTree();
		int nNumInputVar, nNumOutputVar;
		/// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
		/*
		trSetting.GetNode(STR_INPUT_VAR_NODE).GetAttribute(STR_NUM_VAR_ATTRIB, nNumInputVar);
		trSetting.GetNode(STR_OUTPUT_VAR_NODE).GetAttribute(STR_NUM_VAR_ATTRIB, nNumOutputVar);
		m_XFO.ConstructXFunction(m_trFunction, "", nNumInputVar+nNumOutputVar);
		*/
		TreeNode trInput = trSetting.GetNode(STR_INPUT_VAR_NODE);
		TreeNode trOutput = trSetting.GetNode(STR_OUTPUT_VAR_NODE);
		StringArray sarrVarTypes;
		foreach( TreeNode trVar in trInput.Children )
		{
			sarrVarTypes.Add(trVar.type.strVal);
		}
		
		foreach( trVar in trOutput.Children )
		{
			sarrVarTypes.Add(trVar.type.strVal);
		}
		///---------- DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION		
		//m_XFO.ConstructXFunction(m_trFunction, "", sarrVarTypes);
		xf_construct_xfunction(m_trFunction, "", sarrVarTypes);
		//-----------
		/// end XYDATARANGE_PROPERTY_IMPLEMENTATION		
		
		///---------- DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION		
		//updateVarNode(m_XFO.GetVarsNode(m_trFunction), trSetting);
		TreeNode trVars;
		okutil_xft_GetVarsNode(&trVars, &m_trFunction, NULL);
		//updateVarNode(trVars, trSetting);	///Jasmine 02/24/06 MOVE_FROM_XFUNCTIONWIZ
		xf_update_var_node(trVars, trSetting);
		//-----------

		/// Bill 10/14/2011 ORG-3947-P1 COULD_NOT_EDIT_DATA_FOR_INT_AND_DOUBLE_IN_XF_CREATE_BY_XFUNCTIONWIZ
		{
			XF_WIZ_DECL_XF(xf, m_trFunction);
		}
		/// End COULD_NOT_EDIT_DATA_FOR_INT_AND_DOUBLE_IN_XF_CREATE_BY_XFUNCTIONWIZ
		
		m_trFunction.codes.code.strVal=trSetting.GetNode(STR_CODE_NODE).strVal;
		//m_trFunction.internal.nVal = trSetting.GetNode(STR_XF_TYPE).nVal;
		return TRUE;
	}
	
	BOOL OnCancel()
	{
		return TRUE;
	}
	
private:
	///Jasmine 02/24/06 MOVE_FROM_XFUNCTIONWIZ, move into XFunction.c to share with SetColValXiz
	/*
	void updateVarNode(TreeNode &trVars, const TreeNode &trSettingVar)
	{
		TreeNode trInputVar=trSettingVar.GetNode(STR_INPUT_VAR_NODE);
		TreeNode trOutputVar=trSettingVar.GetNode(STR_OUTPUT_VAR_NODE);
		TreeNode trVar=trVars.FirstNode;
		setVarNode(trVar, trInputVar, true);
		setVarNode(trVar, trOutputVar, false);
	}
	void setVarNode(TreeNode &trVar, const TreeNode &trSettingVar, bool bInput)
	{
		string strType;
		foreach(TreeNode trVarNode in trSettingVar.Children)
		{
			trVar.name.strVal=trVarNode.GetNode(STR_VARNAME_NODE).strVal;
			trVar.io.nVal=bInput ? 0 : 1;
			trVar.type.strVal=trVarNode.GetNode(STR_VARTYPE_NODE).strVal;
			//trVar.valdata.strVal = trVarNode.GetNode(STR_DATA_NODE).strVal;
#ifndef 	 _XF_LT_CALL_IN_VC
			XVariableHelper xv(trVar);
			XVariableBase* pVar = xv.Var();
			if( !pVar )
			{
				error_report("Failed to construct XVariable");
				return;
			}
			pVar->SetValue(trVarNode.GetNode(STR_DATA_NODE).strVal);
#endif
			trVar=trVar.NextNode;
		}
	}
	*/
	///End MOVE_FROM_XFUNCTIONWIZ
private:
	XFunctionWizPlaceHolder 	m_PlaceHolder;
//	XFunctionOrganizer			m_XFO;
	Tree						m_trFunction;
	int							m_nXFTypeDefault;
};

#endif //_XFW_H
