/*------------------------------------------------------------------------------*
 * File Name: XFWizNavigation.c													*
 * Creation: Sim 03-20-2007														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 08-26-2008 QA80-12093 REUSE_REPORT_DATA_IN_XFWIZ_WHEN_RECALCULATE		*
 *	Sim 01-14-2009 FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS			*
 *	Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
 *	Folger 05/13/09 PA_FAILS_TO_GENERATE_REPORT_WHNE_GOALS_ARE_DYNAMICALLY_CHANGED
 *	Hong 08/24/11 ORG-1864 FIX_PA_FAIL_APPLY_X_RANGE							*
 *	Sim 2011-08-25 ORG-1864 FIX_PA_FAIL_APPLY_X_RANGE							*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
//#include <Array.h>
#include <GetNbox.h>

#include <..\OriginLab\XFWizNavigation.h>
#include <..\OriginLab\XFWizard_utils.h>

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
XFWizNavigation::XFWizNavigation(XFCore *pXFCore)
{
	ASSERT(pXFCore);
	m_pXFCore = pXFCore;
	m_pXFCore->SetXFWizNavigation((ODWP)this);
	m_nStep = -1;	
	///---Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
	//m_bFinish = false;
	///---END FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
}
XFWizNavigation::~XFWizNavigation()
{
}

bool XFWizNavigation::InitWizard(XFWizRunModelBase *pXFWizRM, XFWizTheme* pXFWizTheme, XFWizInputOutputRange* pXFWizIO) // = NULL, NULL
{
	ASSERT(m_nStep < 0);
	if ( m_nStep >= 0 )
		return false;		
	
	m_pXFWizRM = pXFWizRM;
	m_pXFWizTheme = pXFWizTheme;
	m_pXFWizIO = pXFWizIO;
	
	if ( !LoadSteps() )
		return false;

	//if ( !pXFWizRM->UpdateSteps(m_saXFNames) )
		//return false;
	
	return true;
}

bool XFWizNavigation::LoadSteps()
{
	StringArray saXFNames;
	if ( m_pXFWizTheme )
	{
		m_pXFWizTheme->GetXFList(saXFNames);
	}
	///---Sim 01-14-2009 FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
	else
		ASSERT(FALSE); // default steps are all in XFWizTheme
	//if ( saXFNames.GetSize() <= 0 )
	//{
		///*
		//if ( m_pXFCore )
		//{
			//m_pXFCore->GetDefaultSteps(saXFNames);
		//}
		//*/
		//saXFNames = m_saDefaultXFNames;
	//}
	///---END FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
	
	if ( saXFNames.GetSize() <= 0 )
		return false;
	
	return (SUCCESS_UPDATE_STEPS == SetSteps(saXFNames) );
}

int XFWizNavigation::SetSteps(const StringArray& saXFNames)
{
	if ( m_nStep > saXFNames.GetSize() - 1 )
		return FAILED_CURRENT_STEP_OUT_OF_TARGET_RANGE_OF_XFNAME;
	for (int ii = 0; ii <= m_nStep; ii++)
	{
		if ( saXFNames[ii] != m_saXFNames[ii] )
			return FAILED_PASTED_STEPS_ARE_NOT_CONSISTENT;
	}

	m_saXFNames = saXFNames;
	
	//if ( !OnAfterSetSteps() )
		//return FAILED_UPDATE_STEPS;
	StringArray saXFLables;
	if ( !GetStepLabels(m_saXFNames, saXFLables) )
		return FAILED_UPDATE_STEP_LABELS;
	if ( !m_pXFWizRM->UpdateSteps(saXFLables) )
		return FAILED_UPDATE_STEP_LABELS;

	return SUCCESS_UPDATE_STEPS;
}

int XFWizNavigation::GetStep()
{
	return m_nStep;
}
int XFWizNavigation::GetNumSteps()
{
	return m_saXFNames.GetSize();
}
string XFWizNavigation::GetXFName(int nStep)
{
	if ( 0 <= nStep && nStep < m_saXFNames.GetSize() )
		return m_saXFNames[nStep];
	return "";
}

//bool XFWizNavigation::OnStart()
//{
	//m_nStep = -1;
	//return true;
//}


bool XFWizNavigation::GoToStep(int nStep)
{
	m_pXFWizRM->SetPageEventLink(false);
	
	string strXFName = GetXFName(nStep);
	if ( !LoadXF(strXFName) )
		return false;
	
	int nStepBackup = m_nStep;
	m_nStep = nStep;

	bool bRet = true;
	
	if ( bRet && !UpdateGetN(true) )
		bRet = false;
	
	if ( bRet && !AfterLoadXF() )
		bRet = false;

	if ( !bRet )
		m_nStep = nStepBackup;

	if ( bRet )
		m_pXFWizRM->SetPageEventLink(true);
	
	return bRet;
}

XFCore* XFWizNavigation::GetXFCore()
{
	return m_pXFCore;
}
XFWizInputOutputRange* XFWizNavigation::GetXFWizInputOutputRange()
{
	return m_pXFWizIO;
}

bool XFWizNavigation::UpdateGetN(bool bToGetN)
{
	TreeNode trGetN;
	if ( m_pXFCore->GetGetN(trGetN) )
	{
		if ( bToGetN )
		{
			if ( m_pXFWizTheme )
			{
				if ( FAILED_APPLY_THEME == m_pXFWizTheme->Update(trGetN, m_saXFNames[m_nStep], true) )
					return false;
			}
			if ( m_pXFWizIO )
			{
				if ( !m_pXFWizIO->Apply(trGetN, m_saXFNames[m_nStep]) )
					return false;
				///---Sim 08-26-2008 QA80-12093 REUSE_REPORT_DATA_IN_XFWIZ_WHEN_RECALCULATE
				vector<int> vOutputUIDs;
				if ( m_pXFWizIO->GetUIDs(vOutputUIDs, m_saXFNames[m_nStep], false) )
				{
					if ( !(m_pXFCore->UpdateOutputUIDs(vOutputUIDs)) )
						return false;
				}
				///---END QA80-12093 REUSE_REPORT_DATA_IN_XFWIZ_WHEN_RECALCULATE
			}
			///---Sim 2011-08-25 ORG-1864 FIX_PA_FAIL_APPLY_X_RANGE
			if ( m_pXFWizTheme )
			{
				if ( FAILED_APPLY_THEME == m_pXFWizTheme->UpdateRange(trGetN, m_saXFNames[m_nStep]) )
					return false;
			}
			///---END ORG-1864 FIX_PA_FAIL_APPLY_X_RANGE
			
			//SetThemeClassOption(trGetN, m_pXFCore->GetClassName());
			
			set_xf_core_handler(trGetN, m_pXFCore);
		}
		else
		{
			if ( m_pXFWizIO )
			{
				Array<DataRange&> *parrdrInputs = m_pXFCore->GetInputs();
				Array<DataRange&> *parrdrOutputs = m_pXFCore->GetOutputs();
				
				m_pXFWizIO->Add(parrdrInputs, m_saXFNames[m_nStep], true);
				m_pXFWizIO->Add(parrdrOutputs, m_saXFNames[m_nStep], false);
			}
			
			if ( m_pXFWizTheme )
			{
				m_pXFWizTheme->Update(trGetN, m_saXFNames[m_nStep], false);
			}
		}
		return true;
	}
	return false;
}

bool XFWizNavigation::LoadXF(LPCSTR lpcszXFName)
{
	if ( !m_pXFCore->Load(lpcszXFName) )
		return false;

	//TreeNode trGetN;
	//if ( m_pXFCore->GetGetN(trGetN) )
	//{
		//if ( m_pXFWizTheme )
		//{
			//if ( FAILED_APPLY_THEME == m_pXFWizTheme->Update(trGetN, lpcszXFName, true) )
				//return false;
		//}
		//if ( m_pXFWizIO )
		//{
			//if ( !m_pXFWizIO->Apply(trGetN, lpcszXFName) )
				//return false;
		//}
		//
		//SetThemeClassOption(trGetN, m_pXFCore->GetClassName());
		//
		//set_xf_core_handler(trGetN, m_pXFCore);
	//}
	
	return true;
}
bool XFWizNavigation::ApplyCurXF()
{
	///---Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
	if ( m_pXFWizRM->IsNoCall() )
		return true;
	///---END QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
	
	if ( !m_pXFCore->Apply() )
		return false;
	
	/*
	if ( m_pXFWizIO )
	{
		Array<DataRange&> *parrdrInputs = m_pXFCore->GetInputs();
		Array<DataRange&> *parrdrOutputs = m_pXFCore->GetOutputs();
		
		m_pXFWizIO->Add(parrdrInputs, m_saXFNames[m_nStep], true);
		m_pXFWizIO->Add(parrdrOutputs, m_saXFNames[m_nStep], false);
	}
	
	TreeNode trGetN;
	if ( m_pXFCore->GetGetN(trGetN) )
	{
		if ( m_pXFWizTheme )
		{
			if ( FAILED_APPLY_THEME == m_pXFWizTheme->UpdateFromGetN(trGetN, m_saXFNames[m_nStep]) )
				return false;
		}
	}
	*/
	//UpdateRumtimeValue();
	if ( !UpdateGetN(false) )
		return false;
		
	return true;
}
//bool  XFWizNavigation::UndoCurXF()
//{
	//if ( !m_pXFCore->Undo() )
		//return false;
	//
	//return true;
//}

//void XFWizNavigation::UpdateRumtimeValue()
//{
	//if ( m_pXFWizIO )
	//{
		//Array<DataRange&> *parrdrInputs = m_pXFCore->GetInputs();
		//Array<DataRange&> *parrdrOutputs = m_pXFCore->GetOutputs();
		//
		//m_pXFWizIO->Add(parrdrInputs, m_saXFNames[m_nStep], true);
		//m_pXFWizIO->Add(parrdrOutputs, m_saXFNames[m_nStep], false);
	//}
	//
	//TreeNode trGetN;
	//if ( m_pXFCore->GetGetN(trGetN) )
	//{
		//if ( m_pXFWizTheme )
		//{
			//m_pXFWizTheme->Update(trGetN, m_saXFNames[m_nStep], false);
		//}
	//}
//}

//bool XFWizNavigation::SetWizardInputOutput(XFWizInputOutputRange* pXFWizIO)
//{
	//if ( m_nStep >= 0 )
		//return false;
	//
	//m_pXFWizIO = pXFWizIO;
	//return true;
//}


//bool XFWizNavigation::SetThemeClassOption(TreeNode& trGetN, LPCSTR lpcszClassOption)
//{
	//return trGetN.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, lpcszClassOption);
//}
//bool XFWizNavigation::SaveLastUsedTheme()
//{
	//if ( m_pXFWizTheme )
		//return m_pXFWizTheme->Save(THEME_FILENAME_LAST_USED);
	//return false;
//}

/*
//virtual
bool XFWizNavigation::OnAfterSetSteps()
{
	return true;
}

//virtual
bool XFWizNavigation::OnAfterChangeStep()
{
	return true;
}
*/

//virtual
bool XFWizNavigation::AfterLoadXF()
{
	//return ( 0 == m_pXFCore->OnBeforeExecute(XF_GETN_NONE) );
	///---Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
	if ( !m_pXFWizRM->IsNoCall() )
	///---END QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
		if ( 0 != m_pXFCore->OnBeforeExecute(m_pXFWizRM->m_stXFMode.nXFType) )
			return false;
	
	return m_pXFWizRM->OnAfterLoadXF();
}
////virtual
//bool XFWizNavigation::OnBeforeApplyXF()
//{
	//return true;
//}

///---Sim 01-14-2009 FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
//void XFWizNavigation::SetDefaultSteps(const StringArray& saDefaultXFNames)
//{
	//m_saDefaultXFNames = saDefaultXFNames;
//}
///---END FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS

bool XFWizNavigation::OnChangeStep(int nStep)
{
	int nArrivedStep = ChangeStep(nStep);
	if ( nArrivedStep != nStep )
	{
		//if ( nArrivedStep != nIndexDeactivate )
		bool bRet = m_pXFWizRM->ActiveStep(nArrivedStep);
		ASSERT(bRet);
			
		return false;			
	}
	
	return true;
}


//************************************************************************************************************************************************
//XFWizDlgNavigation::XFWizDlgNavigation(XFCore *pXFCore)
//:XFWizNavigation(pXFCore)
//{
	//m_bFinish = false;
//}
//XFWizDlgNavigation::~XFWizDlgNavigation()
//{
//}

//void XFWizDlgNavigation::InitWizard(HWND hParent, XFWizTheme* pXFWizTheme, XFWizInputOutputRange* pXFWizIO) // = NULL, NULL
//{
	//m_hParent = hParent;
	//XFWizNavigation::InitWizard(pXFWizTheme, pXFWizIO);
	//UpdateWizardControl();
	//
	//WizardControl *pXFWizCtrl = GetXFWizControl();
	//ASSERT(pXFWizCtrl);
	//pXFWizCtrl->SetEventHandler(this);
//}
//void XFWizDlgNavigation::UpdateWizardControl()
//{
	//WizardControl *pXFWizCtrl = GetXFWizControl();
	//ASSERT(pXFWizCtrl);
	//
	//if ( m_saXFNames.GetSize() != m_saLables.GetSize() ) 
	//{
		//m_saLables = m_saXFNames;
	//}
	//
	////pXFWizCtrl->UpdateWizardControl(m_saXFNames);
	//int ii;
	//int nSizeSteps = m_saLables.GetSize();
	//int nSizeStepsInCtrl = pXFWizCtrl->GetNumSteps();
	//
	//if ( nSizeStepsInCtrl > nSizeSteps )
	//{
		//// skip the redundant steps
		//for ( ii = nSizeSteps; ii < nSizeStepsInCtrl; ii++ )
			//pXFWizCtrl->ShowStep(ii, FALSE);
		//nSizeStepsInCtrl = nSizeSteps;
	//}
	//
	//for ( ii = 0; ii < nSizeStepsInCtrl; ii++ )
	//{
		//pXFWizCtrl->UpdateStep(ii, m_saLables[ii]);
		//pXFWizCtrl->ShowStep(ii, TRUE);
	//}
	//
	//for ( ii = nSizeStepsInCtrl; ii < nSizeSteps; ii++ )
	//{
		//pXFWizCtrl->AddStep(m_saLables[ii]);
		//// control bug
		//if ( 0 == ii )
			//pXFWizCtrl->UpdateStep(ii, m_saLables[ii]);
	//}
//}

//virtual
//int XFWizDlgNavigation::SetSteps(const StringArray& saXFNames)
//{
	//int nRet = XFWizNavigation::SetSteps(saXFNames);
	//if ( SUCCESS_UPDATE_STEPS == nRet )
	//{
		//if ( !m_pXFCore->GetStepLabels(m_saXFNames, m_saLables) )
			//return FAILED_UPDATE_STEPS;
	//}
	//
	//return nRet;
//}

//bool XFWizNavigation::OnBegin()
//{
	//if ( m_saXFNames.GetSize() > 0 )
	//{
		//return GoToStep(0);
	//}
	//return error_report("XFunction path wasn't initialized!");
//}

bool XFWizNavigation::OnFinish()
{
	if ( !GoFinish() )
	{
		m_pXFWizRM->ActiveStep(m_nStep);
		return false;
	}
		
	///---Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
	//m_bFinish = true;
	///---END FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
	return true;
}
bool XFWizNavigation::OnCancel()
{
	if ( !GoCancel() )
	{
		m_pXFWizRM->ActiveStep(m_nStep);
		return false;
	}
		
	///---Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
	//m_bFinish = false;
	///---END FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
	return true;
}
bool XFWizNavigation::OnNext()
{
	if ( GoNext() )
	{
		if ( m_pXFWizRM->ActiveStep(m_nStep) )
			return true;
	}
	
	return false;
}
bool XFWizNavigation::OnPrev()
{
	if ( GoPrev() )
	{
		if ( m_pXFWizRM->ActiveStep(m_nStep) )
			return true;
	}
	
	return false;
}

//void XFWizDlgNavigation::OnDestroy()
//{
	//if ( m_pXFCore )
	//{
		//m_pXFCore->Destroy();
	//}
//}
///---Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
//bool XFWizNavigation::IsFinish()
//{
	//return m_bFinish;
//}
///---END FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN

//BOOL XFWizDlgNavigation::OnWizardStepActivate(int nIndexActivate, int nIndexDeactivate)
//{
	//WizardControl *pXFWizCtrl = GetXFWizControl();
	//ASSERT(pXFWizCtrl);
	//
	//if ( nIndexActivate >= pXFWizCtrl->GetNumSteps() )
	//{
		////return OnFinish();
		//Window wnd(m_hParent);
		//if ( wnd )
			//return wnd.SendMessage(WM_USER_WIZ_DLG_FINISH);
	//}
	//
	//int nArrivedStep = ChangeStep(nIndexActivate, nIndexDeactivate);
	//if ( nArrivedStep != nIndexActivate )
	//{
		//if ( nArrivedStep != nIndexDeactivate )
			//SetActiveStep(nArrivedStep);
			//
		//return false;			
	//}
	//
	//return true;
//}


//
//DWORD XFWizDlgNavigation::SendDlgMsg(DWORD msg, DWORD wParam, DWORD lParam) // = 0, 0
//{
	//Window wnd(m_hParent);
	//if ( wnd )
		//return wnd.SendMessage(msg, wParam, lParam);
	//return 0;
//}

//WizardControl* XFWizDlgNavigation::GetXFWizControl()
//{
	////Window wnd(m_hParent);
	////if ( wnd )
		////return (WizardControl *)wnd.SendMessage(WM_USER_WIZ_DLG_GET_STEPS_CTRL);
	//
	////return NULL;
	//return (WizardControl*)SendDlgMsg(WM_USER_WIZ_DLG_GET_STEPS_CTRL);
//}

bool XFWizNavigation::GoFinish()
{
	/*
	if ( m_nStep >= 0 )
	{
		if ( !ApplyCurXF() )
			return false;
	}

	while ( m_nStep < m_saXFNames.GetSize() - 1 )
	{
		if ( !GoToStep(m_nStep+1) )
			return false;
		if ( !ApplyCurXF() )
			return false;
	}
	*/
	if ( m_saXFNames.GetSize() <= 0 )
	{
		return true;
	}
	
	///------ Folger 05/13/09 PA_FAILS_TO_GENERATE_REPORT_WHNE_GOALS_ARE_DYNAMICALLY_CHANGED
	//int nStepTo = m_saXFNames.GetSize() - 1;
	//if ( ChangeStep(nStepTo) != nStepTo )
		//return false;
	int		nStepTo = -1;
	do
	{
		nStepTo = m_saXFNames.GetSize() - 1;
		if ( ChangeStep(nStepTo) != nStepTo )
			return false;
	} while ( nStepTo < m_saXFNames.GetSize() - 1 );	/// since size of m_saXFNames may be dynamically changed when go to each step
	///------ End PA_FAILS_TO_GENERATE_REPORT_WHNE_GOALS_ARE_DYNAMICALLY_CHANGED

	if ( !ApplyCurXF() )
		return false;
	
	//m_pXFWizTheme->SetXFList(m_saXFNames);
	//
	//if ( !m_pXFWizTheme->IsHookOperation() ) // when change parameter mode, no save last used theme
		//SaveLastUsedTheme();
		
	///---Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
	if ( !m_pXFCore->Done(true) )
		return false;
	///---END FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN

	return true;
}

bool XFWizNavigation::GoCancel()
{
	/*
	if ( m_nStep >= 0 )
	{
		if ( !UndoCurXF() )
			return false;
	}

	while ( m_nStep > 0 )
	{
		if ( !GoToStep(m_nStep-1) )
			return false;
		if ( !UndoCurXF() )
			return false;
	}
	*/
	if ( m_nStep < 0 )
	{
		return true;
	}
	
	int nStepTo = 0;
	if ( ChangeStep(nStepTo) != nStepTo )
		return false;

	if ( !UndoCurXF() )
		return false;
	
	///---Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
	if ( !m_pXFCore->Done(false) )
		return false;
	///---END FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
	
	return true;
}
bool XFWizNavigation::GoNext()
{
	if ( m_nStep < m_saXFNames.GetSize() - 1 )
	{
		if ( m_nStep >= 0 )
		{
			if ( !ApplyCurXF() )
				return false;
		}
		if ( !GoToStep(m_nStep+1) )
			return false;
		
		return true;
	}
	return error_report("Has been at the end of XFunction path!");
}
bool XFWizNavigation::GoPrev()
{
	if ( m_nStep > 0 )
	{
		if ( m_nStep >= 0 )
		{
			if ( !UndoCurXF() )
				return false;
		}
		if ( !GoToStep(m_nStep-1) )
			return false;
		
		return true;
	}
	return error_report("Has been at the beginning of XFunction path!");
}
//int XFWizNavigation::ChangeStep(int nStepTo, int nStepFrom)
int XFWizNavigation::ChangeStep(int nStep)
{
	//if ( m_nStep != nStepFrom )
	//{
		//ASSERT(FALSE);
		//return nStepFrom;
	//}
	
	//bool bGoForce = ( nStepTo >= nStepFrom );
	bool bGoForce = ( nStep >= m_nStep );
	
	//while ( m_nStep != nStepTo )
	while ( m_nStep != nStep )
	{
		if ( bGoForce )
		{
			if ( !GoNext() )
				break;
		}
		else
		{
			if ( !GoPrev() )
				break;
		}
	}
	
	return m_nStep;
}

//virtual
//bool XFWizDlgNavigation::GoToStep(int nStep)
//{
	////SendDlgMsg(WM_USER_WIZ_DLG_PAGE_EVENT_LINK, FALSE); // turn off page event
	//m_pXFWizRM->SetPageEventLink(false);
	//
	//if ( XFWizNavigation::GoToStep(nStep) )
	//{
		////SendDlgMsg(WM_USER_WIZ_DLG_PAGE_EVENT_LINK, TRUE); // turn on page event
		//m_pXFWizRM->SetPageEventLink(true);
		//return true;
	//}
	//
	//return false;
//}

//bool XFWizDlgNavigation::SetActiveStep(int nStep)
//{
	//WizardControl *pXFWizCtrl = GetXFWizControl();
	//ASSERT(pXFWizCtrl);
	//
	//bool bRet;
	////pXFWizCtrl->SetEventHandler(NULL);
	//ClassObject objEventHandlerJunk;
	//pXFWizCtrl->SetEventHandler(objEventHandlerJunk);
	//bRet = ( pXFWizCtrl->SetActiveStep(nStep) == nStep );
	//pXFWizCtrl->SetEventHandler(this);
	//
	//return bRet;
//}

/*
//virtual
bool XFWizDlgNavigation::OnAfterSetSteps()
{
	UpdateWizardControl();
	return true;
}

//virtual
bool XFWizDlgNavigation::OnAfterChangeStep()
{
	WizardControl *pXFWizCtrl = GetXFWizControl();
	ASSERT(pXFWizCtrl);

	return ( pXFWizCtrl->SetActiveStep(m_nStep) == m_nStep );
}
*/

//virtual
//bool XFWizDlgNavigation::OnAfterLoadXF()
//{
	//if ( 0 != m_pXFCore->OnBeforeExecute(XF_GETN_SIMPLE) )
		//return false;
	//
	////Window wnd(m_hParent);
	////if ( wnd )
		////return wnd.SendMessage(WM_USER_WIZ_DLG_AFTER_LOAD_XF);
	////
	////return true;
	//return SendDlgMsg(WM_USER_WIZ_DLG_AFTER_LOAD_XF);
//}
//virtual
//bool XFWizDlgNavigation::OnBeforeApplyXF()
//{
//}

////virtual
//bool XFWizDlgNavigation::ApplyCurXF()
//{
	//return XFWizNavigation::ApplyCurXF();
//}
//virtual
bool XFWizNavigation::UndoCurXF()
{
	///---Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
	if ( m_pXFWizRM->IsNoCall() )
		return true;
	///---END QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
	
	//if ( !XFWizNavigation::UndoCurXF() )
		//return false;
	
	//Window wnd(m_hParent);
	//if ( wnd )
	//{
		//if ( !wnd.SendMessage(WM_USER_WIZ_DLG_UNDO_XF) )
			//return false;
	//}
	//if ( !SendDlgMsg(WM_USER_WIZ_DLG_UNDO_XF) )
	if ( !m_pXFWizRM->OnUndoXF() )
		return false;
	
	//UpdateRumtimeValue();
	if ( !UpdateGetN(false) )
		return false;
	
	return true;
}

/*
bool XFWizDlgNavigation::OnSaveTheme(LPCSTR lpcszThemeName)
{
	if ( !UpdateGetN(false) )
		return false;
	
	if ( !m_pXFWizTheme->SetXFList(m_saXFNames) )
		return false;
	
	if ( !m_pXFWizTheme || !m_pXFWizTheme->Save(lpcszThemeName) )
	///Sophy 10/28/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
	//	return false;
	{
		if( m_pXFWizTheme )
			popup_errmsg_save_readonly_file( m_pXFWizTheme->GetThemeFileName( lpcszThemeName ), m_hParent );
		return false;
	}
	///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
	
	return true;
}

bool XFWizDlgNavigation::OnLoadTheme(LPCSTR lpcszThemeName)
{
	if ( !m_pXFWizTheme || !m_pXFWizTheme->Load(lpcszThemeName) )
		return false;
	
	if ( !LoadSteps() )
		return false;
	UpdateWizardControl();
	
	m_pXFCore->SetDefautlValue();
	if ( !UpdateGetN(true) )
		return false;
	
	return true;
}
*/
bool XFWizNavigation::UpdateThemeSetting(bool bToTheme) // = true
{
	if ( bToTheme )
	{
		if ( !UpdateGetN(false) )
			return false;
		
		if ( !m_pXFWizTheme || !m_pXFWizTheme->SetXFList(m_saXFNames) )
			return false;
	}
	else
	{
		if ( !LoadSteps() )
			return false;
		//UpdateWizardControl();
		
		m_pXFCore->SetDefautlValue();
		if ( !UpdateGetN(true) )
			return false;
		
		return true;
	}	
}

void XFWizNavigation::SetMapStepLabels(const StringArray& saMapXFNames, const StringArray& saMapXFLabels)
{
	m_saMapXFNames = saMapXFNames;
	m_saMapXFLabels = saMapXFLabels;
}
bool XFWizNavigation::GetStepLabels(const StringArray& saXFNames, StringArray& saXFLables)
{
	saXFLables = saXFNames;
	for ( int ii = 0; ii < saXFNames.GetSize(); ii++ )
	{
		int nIndex = m_saMapXFNames.Find(saXFNames[ii]);
		if ( nIndex >= 0 )
		{
			if ( nIndex > m_saMapXFNames.GetSize() - 1 || nIndex > m_saMapXFLabels.GetSize() - 1)
				return false;
		
			saXFLables[ii] = m_saMapXFLabels[nIndex];
		}
	}
	
	return true;
}
