/*------------------------------------------------------------------------------*
 * File Name: XFWizManager.c													*
 * Creation: Sim 11-28-2008														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 12/10/08 v8.0984d REMOVE_ANALYSIS_MARKER_WHEN_CLICK_CANCEL_IN_WIZARD	*
 *	Folger 12/18/08 v8.0988 ORIGIN_CRASH_WHEN_CANCEL_FROM_CHANGE_PARAM_OPENED_BY_ANALYSIS_MARKER
 *	Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE								*
 *	Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE				*
 *	Sim 01-14-2009 FIX_XFWIZ_OP_DISPLAY_THEME_NAME								*
 *	Sim 01-14-2009 FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS			*
 *	Folger 01/19/09 QA80-12969 PA_FITTING_SUPPORT_ANALYSIS_TEMPLATE				*
 *	Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL										*
 *	Folger 11/03/09 BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE				*
 *	Folger 12/18/09 QA81-14860 REUID_PA_OUTPUTS_FOR_AUTO_UPDATE					*
 *	Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION				*
 *	Kyle 12/20/2010 ORG-1648-P1 AUTO_ADJUST_COLUMN_WIDTH_IN_WORKSHEET_CREATED_AFTER_INTEGRATING_PEAKS
 *	Folger 12/21/2011 ORG-4653-P1 AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <..\OriginLab\theme_utils.h>///---Sim 01-14-2009 FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
#include <..\OriginLab\WizOperation.h>

#include "XFWizManager.h"

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
//XFWizManager::XFWizManager(const TreeNode& trThemes, const TreeNode& trInputsOutputs, DWORD dwUIDOp) // = NULL, NULL, 0
XFWizManager::XFWizManager(LPCSTR lpcszThemeName, const XFWizTheme *pXFWizTheme, const XFWizInputOutputRange *pXFWizIO, DWORD dwUIDOp) // = NULL, NULL, NULL, 0
///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
{
	//m_pXFCore = NULL;
	//m_pXFWizTheme = NULL;
	//m_pXFWizIO = NULL;
	//m_pXFWizNavg = NULL;
	
	m_pXFCore = CreateXFCore();
	ASSERT(m_pXFCore);
	m_pXFCore->SetClassName(GetClassName());
	
	m_pXFWizTheme = CreateXFWizTheme();
	ASSERT(m_pXFWizTheme);
	m_pXFWizTheme->SetClassName(GetClassName());
	m_pXFWizTheme->SetVersion(GetVersion());
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	//if ( 0 == dwUIDOp )
	//{
		//string strThemeName;
		//if ( trThemes )
			//tree_get_theme_file_name(trThemes, strThemeName);
		//// ASSUME!!!, that name get from theme tree isn't full file name, just theme name
		//// for detail, to see all places that construct this class object, like PA.oxf
		//m_pXFWizTheme->Load(strThemeName);
	//}
	//else
	//{
		//if ( trThemes && !trThemes.IsEmpty() )
			//m_pXFWizTheme->SetTree(trThemes);
	//}
	if ( lpcszThemeName )
	{
		m_pXFWizTheme->Load(lpcszThemeName);
	}
	else if ( pXFWizTheme )
	{
		Tree trThemes;
		if ( pXFWizTheme->GetTree(trThemes) )
			m_pXFWizTheme->SetTree(trThemes);		
	}
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	
	m_pXFWizIO = CreateXFWizInputOutputRange();
	ASSERT(m_pXFWizIO);
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	//if ( trInputsOutputs && !trInputsOutputs.IsEmpty() )
		//m_pXFWizIO->SetTree(trInputsOutputs);
	if ( pXFWizIO )
	{
		Tree trInputsOutputs;
		if ( pXFWizIO->GetTree(trInputsOutputs) )
			m_pXFWizIO->SetTree(trInputsOutputs);
	}
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	// default active page is target page
	Page pgTarget;
	if ( !m_pXFWizIO->GetTargetPage(pgTarget) )
	{
		pgTarget = Project.Pages();
		m_pXFWizIO->SetTargetPage(pgTarget);
	}
	
	m_pXFWizNavg = new XFWizNavigation(m_pXFCore);
	ASSERT(m_pXFWizNavg);
	
	m_dwUIDOp = dwUIDOp;
	
	m_pXFCore->SetXFWizOp(dwUIDOp);		///------ Folger 01/19/09 QA80-12969 PA_FITTING_SUPPORT_ANALYSIS_TEMPLATE
}
XFWizManager::~XFWizManager()
{
	delete m_pXFCore;
	delete m_pXFWizTheme;
	delete m_pXFWizIO;
	delete m_pXFWizNavg;
}
//virtual
void XFWizManager::Destroy()
{
	m_pXFCore->Destroy();
	
	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	////------ Folger 11/13/08 QA80-12488 v8.970 PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
	//DestroyWizardOperationExecuteHelper(m_dwUIDOp);
	////------
	///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
}

//bool XFWizManager::Create(XFWizRunModelBase *pXFWizRM)
//{
	//
//}
//
//XFWizDlgNavigation* XFWizManager::GetWizDlgNavg(XFWizNavigation *pXFWizNavg)
//{
	//if ( XFWIZ_RUN_MODE_DLG == m_stXFWizRM.nMode || XFWIZ_RUN_MODE_CHANGE_PARAM == m_stXFWizRM.nMode )
	//{
		//try
		//{
			//XFWizDlgNavigation *pXFWizDlgNavg = (XFWizDlgNavigation *)pXFWizNavg;
			//return pXFWizDlgNavg;
		//}
		//catch( int nErr )
		//{
		//}
	//}
	//return NULL;
//}
//void XFWizManager::InitSteps(XFWizNavigation *pXFWizNavg)
//{
	//pXFWizNavg->SetMapStepLabels(m_saMapXFNames, m_saMapXFLabels);
//}

bool XFWizManager::InitWizard(XFWizRunModelBase *pXFWizRM)
{
	m_pXFWizRM = pXFWizRM;
	ASSERT(m_pXFWizRM);
	
	//Page pgTarget;
	//if ( !m_pXFWizIO->GetTargetPage(pgTarget) )
		//pgTarget = Project.Pages();
	//m_pXFCore->SetTargetPage(pgTarget);
	
	m_pXFCore->SetXFMode(m_pXFWizRM->m_stXFMode.dwXFMode);
	m_pXFCore->SetExecute(m_pXFWizRM->m_stXFMode.dwExecute);
	m_pXFCore->SetRecalculate(m_pXFWizRM->m_stXFMode.nAddRecalculate);
	m_pXFCore->SetResultsLogOutput(m_pXFWizRM->m_stXFMode.nAddResultsLogOutput);
	
	m_pXFWizNavg->SetMapStepLabels(m_saMapXFNames, m_saMapXFLabels);
	///---Sim 01-14-2009 FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
	//m_pXFWizNavg->SetDefaultSteps(m_saDefaultXFNames);
	m_pXFWizTheme->SetDefaultSteps(m_saDefaultXFNames);
	///---END FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
	return m_pXFWizNavg->InitWizard(m_pXFWizRM, m_pXFWizTheme, m_pXFWizIO);
}

/*
bool XFWizManager::GetMapXFName(StringArray &saMapXFNames,	StringArray &saMapXFLabels)
{
	int nSizeNames = m_saMapXFNames.GetSize();
	int nSizeLables = m_saMapXFLabels.GetSize();
	if ( nSizeNames > 0 && nSizeLables > 0 && nSizeNames == nSizeLables )
	{
		saMapXFNames = m_saMapXFNames;
		saMapXFLabels = m_saMapXFLabels;
		return true;
	}
	
	return false;
}
*/

string XFWizManager::GetCurXFName(string& strXFDescription)// = NULL
{
	string strXFName;
	
	strXFName = m_pXFCore->GetXFName(strXFDescription);
	
	if ( strXFName.IsEmpty() )
		strXFName = m_pXFWizNavg->GetXFName(m_pXFWizNavg->GetStep());
		
	return strXFName;
}
TreeNode XFWizManager::GetCurXFTree()
{
	TreeNode tr;
	m_pXFCore->GetGetN(tr);
	return tr;
}
///---Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
string XFWizManager::GetCurXFLabel()
{
	StringArray saXFNames, saXFLables;
	saXFNames.Add(GetCurXFName());
	if ( m_pXFWizNavg->GetStepLabels(saXFNames, saXFLables) )
	{
		return saXFLables[0];
	}
	
	ASSERT(FALSE);
	return "";
}
///---END QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION

//void XFWizManager::SetTargetPage(const Page& pg)
//{
	//m_pXFWizIO->SetTargetPage(pg);
	////m_pXFCore->SetTargetPage(pg);
//}
//bool XFWizManager::GetTargetPage(Page& pg)
//{
	//return m_pXFWizIO->GetTargetPage(pg);
//}
//bool XFWizManager::IsFromFile(string& strFileName)
//{
	//return m_pXFWizTheme->IsFromFile(strFileName);
//}

//Function XFWizManager::GetEventHandler()
//{
	//return m_pXFCore->GetEventHandler();
//}
	
int XFWizManager::UpdateOperation(DWORD dwUIDOp)
{
	string strFile, strFunc;
	///---Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL
	//if ( GetOPEntry(strFile, strFunc) )
	string strOPClass;
	if ( GetOPEntry(strFile, strFunc, strOPClass) )
	///---END FIX_WIZ_OPERATION_LABEL
	{
		m_pXFWizTheme->ClearRuntimeInfo();
		///------ Folger 11/03/09 BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
		//m_pXFWizTheme->SetHookOperation();
		///------ End BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
		m_pXFWizTheme->ClearThemeName(); ///---Sim 01-14-2009 FIX_XFWIZ_OP_DISPLAY_THEME_NAME
		///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
		//Tree trTheme;
		//m_pXFWizTheme->GetTree(trTheme);
		//
		//Tree trIOs;
		//m_pXFWizIO->GetTree(trIOs);
		//
		//return DoWizardOperation(dwUIDOp, trTheme, trIOs, strFile, strFunc);
		///---Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL
		//return DoWizardOperation(m_pXFWizTheme, m_pXFWizIO, strFile, strFunc, dwUIDOp);
		///------ Folger 12/18/09 QA81-14860 REUID_PA_OUTPUTS_FOR_AUTO_UPDATE
		//return DoWizardOperation(m_pXFWizTheme, m_pXFWizIO, strFile, strFunc, strOPClass, dwUIDOp);
		int	nRet = DoWizardOperation(m_pXFWizTheme, m_pXFWizIO, strFile, strFunc, strOPClass, dwUIDOp);
		///Kyle 12/20/2010 ORG-1648-P1 AUTO_ADJUST_COLUMN_WIDTH_IN_WORKSHEET_CREATED_AFTER_INTEGRATING_PEAKS
		m_pXFCore->OnConnectOperation();
		///End AUTO_ADJUST_COLUMN_WIDTH_IN_WORKSHEET_CREATED_AFTER_INTEGRATING_PEAKS
		if ( nRet > 0 )
			m_pXFCore->CheckUpdateOperationTree(nRet);
		return nRet;
		///------ End REUID_PA_OUTPUTS_FOR_AUTO_UPDATE
		///---END FIX_WIZ_OPERATION_LABEL
		///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	}
	return 0;
}

bool XFWizManager::SaveTheme(LPCSTR lpcszThemeName)
{
	if ( !m_pXFWizNavg || m_pXFWizNavg->UpdateThemeSetting(true) )
		return false;
	
	if ( !m_pXFWizTheme || !m_pXFWizTheme->Save(lpcszThemeName) )
		return false;
	
	return true;
}
bool XFWizManager::LoadTheme(LPCSTR lpcszThemeName)
{
	if ( !m_pXFWizTheme || !m_pXFWizTheme->Load(lpcszThemeName) )
		return false;
	
	if ( !m_pXFWizNavg || !m_pXFWizNavg->UpdateThemeSetting(false) )
		return false;
	
	return true;
}

bool XFWizManager::SaveLastUsedTheme()
{
	if ( m_pXFWizTheme )
		return m_pXFWizTheme->Save(THEME_FILENAME_LAST_USED);
	return false;
}

//bool XFWizManager::IsHookOperation()
//{
	//if ( m_pXFWizTheme )
		//return m_pXFWizTheme->IsHookOperation();
	//return false;
//}

BOOL XFWizManager::OnFinish()
{
	///------ Folger 12/21/2011 ORG-4653-P1 AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
	if ( m_pXFCore->IsRecalculate() && m_pXFCore->IsNoInputData() )
		return TRUE;
	///------ End AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF

	if ( !m_pXFWizNavg->OnFinish() )
		return false;
	
	if ( !m_pXFWizNavg || m_pXFWizNavg->UpdateThemeSetting(true) )
		return false;
	
	///------ Folger 11/03/09 BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
	//if ( !m_pXFWizTheme->IsHookOperation() ) // when change parameter mode, no save last used theme
	if ( !IsHookOperation() )
	///------ End BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
		SaveLastUsedTheme();
	
	UpdateOperation(m_dwUIDOp);
	
	m_pXFWizRM->Close(IDOK);
	
	return true;
}

//------ Folger 12/10/08 v8.0984d REMOVE_ANALYSIS_MARKER_WHEN_CLICK_CANCEL_IN_WIZARD
BOOL XFWizManager::OnCancel()
{
	///------ Folger 12/18/08 v8.0988 ORIGIN_CRASH_WHEN_CANCEL_FROM_CHANGE_PARAM_OPENED_BY_ANALYSIS_MARKER
	///------ Folger 11/03/09 BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
	//if ( m_dwUIDOp == 0 )
	if ( !IsHookOperation() )
	///------ End BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
	///------ End ORIGIN_CRASH_WHEN_CANCEL_FROM_CHANGE_PARAM_OPENED_BY_ANALYSIS_MARKER
		m_pXFWizIO->RemoveAllRangesAnalysisMarkers();
	return m_pXFWizNavg->OnCancel();
}
//------ End REMOVE_ANALYSIS_MARKER_WHEN_CLICK_CANCEL_IN_WIZARD

//BOOL XFWizManager::OnNext()
//{
	//return m_pXFWizNavg->OnNext();
//}
//BOOL XFWizManager::OnPrev()
//{
	//return m_pXFWizNavg->OnPrev();
//}

BOOL XFWizManager::OnChangeStep(int nStep)
{
	if ( nStep >= m_pXFWizNavg->GetNumSteps() )
	{
		return OnFinish();
	}
	return m_pXFWizNavg->OnChangeStep(nStep);
}

//int XFWizManager::GetNumSteps()
//{
	//return m_pXFWizNavg->GetNumSteps();
//}
//int XFWizManager::GetStep()
//{
	//return m_pXFWizNavg->GetStep();
//}

///---Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE
bool XFWizManager::CompareTheme(LPCSTR lpcszThemeName, TreeNode& trDiff)
{
	if ( !m_pXFWizNavg || m_pXFWizNavg->UpdateThemeSetting(true) )
		return false;
	
	XFWizTheme *pXFWizTheme = CreateXFWizTheme();
	ASSERT(pXFWizTheme);
	pXFWizTheme->SetClassName(GetClassName());
	pXFWizTheme->SetVersion(GetVersion());
	if ( !pXFWizTheme->Load(lpcszThemeName) )
		return false;
	///---Sim 01-14-2009 FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
	pXFWizTheme->SetDefaultSteps(m_saDefaultXFNames);
	// temp fix for auto update mode, other shared values maybe still with bug, like trAnchor, snap
	if ( theme_is_factory_default(lpcszThemeName) )
		pXFWizTheme->SetAutoUpdateMode(AU_ON_COMMAND); // default AutoUpdateMode, hard code here!!! how to know which is default from centralized place?
	///---END FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
	
	//Tree trDestTheme, trRefTheme;
	//m_pXFWizTheme->GetTree(trDestTheme);
	//pXFWizTheme->GetTree(trRefTheme);
	
	bool bRet =  m_pXFWizTheme->CompareTheme(pXFWizTheme, trDiff);
	delete pXFWizTheme;
	return bRet;
}
///---END QA80-12798 XF_WIZ_THEME_COMPARE
