/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
#include <origin.h>

static bool add_node(LPCTSTR lpcszXFName, LPCTSTR lpcszGroupName, TreeNode &trParent, LPCTSTR lpcszDefaultExt = "")
{
	TreeNode trAdded;
	trAdded = trParent.AddNode(lpcszXFName); 
	trAdded.SetAttribute(STR_XF_EXT_GROUP_NAME_ATTRI, lpcszGroupName);
	trAdded.SetAttribute(STR_XF_EXT_DEFAULT_EXT_ATTRI, lpcszDefaultExt);
	return true;
}

static bool save_tree(Tree &trXFExt, bool bExePath)
{
	string strAppPath = GetAppPath(bExePath);
	strAppPath += STR_XF_EXT_FILE;

	if ( trXFExt.Save(strAppPath) )
	{
		out_str("Build Success!!");
		return true;
	}

	out_str("Build Failed!!");
	return false;
}

bool build_xf_ext_file()
{
	Tree trXFExt;   
	TreeNode trImport = trXFExt.AddNode(STR_XF_EXT_IMPORT_NODE_TAG_NAME);
		add_node("impASC", "ASCII", trImport);
		add_node("impBin2d", "Bin2d", trImport);
		add_node("impBinFile", "BinF", trImport);
		add_node("impCDF", "CDF", trImport);
		add_node("impCSV", "CSV", trImport);
		add_node("impDT", "DCFFiles", trImport);
		add_node("impEDF", "EDF", trImport);
		add_node("impEP", "EarthProbe", trImport);
		add_node("impExcel", "Excel", trImport);
		add_node("impFamos", "FAMOS", trImport);
		add_node("impFile", "", trImport, "*.oif");
		add_node("impHDF5", "HDF5", trImport);
		add_node("impHEKA", "HEKA", trImport);
		add_node("impIAEASPE", "IAEASPE", trImport);
		add_node("impIgorPro", "IGOR", trImport);
		add_node("impImage", "ImageImp", trImport);
		add_node("impinfo", "", trImport);
		add_node("impJCAMP", "JCAMP", trImport);
		add_node("impJNB", "SigmaPlot", trImport);
		add_node("impKG", "Kaleidagraph", trImport);
		add_node("impMatlab", "MatlabFiles", trImport);
		add_node("impMDF", "MDFFiles", trImport);
		add_node("impMNTB", "MiniTab", trImport);
		add_node("impMZXML", "MZXML", trImport);
		add_node("impNetCDF", "NetCDF", trImport);
		add_node("impNetCDFEx", "NetCDF", trImport);
		add_node("impNIDIAdem", "DIADEMFiles", trImport);
		add_node("impNITDM", "TDMFiles", trImport);
		add_node("impODQ", "", trImport);
		add_node("imppClamp", "pClamp", trImport);
		add_node("impPrism", "Prism", trImport);
		add_node("impSIE", "SIE", trImport);
		add_node("impSPC", "ThermoGalactic", trImport);
		add_node("impSPE", "PrincetonInstruments", trImport);
		add_node("impWAV", "Sound", trImport);
		add_node("impWiz", "", trImport, "*.*");


	return save_tree(trXFExt, true);
}