/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE					*
 *	Folger 01/31/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN		*
 *------------------------------------------------------------------------------*/
 
#define _SUPPORT_DRAG_TO_MOVE_ROW_FOR_WKS_ARRANGE_  //CPY 10/13/2011 ORG-3616-P11 WKS_NAVIGATE_DRAG_TO_REORDER_CRASHING

#define STR_WKS_DLG_NAME			_L("Navigate Worksheets")
#define STR_WKS_LIST_HEADER			_L("Index|Creation Index|Name|Columns|Size(KB)|Comments|Type|Source")

#define STR_MAT_DLG_NAME			_L("Navigate Matrix sheets")
#define STR_MAT_LIST_HEADER			_L("Index|Creation Index|Name|Objects|Size(KB)|Comments")

#define MAX_SHEETS_NUMBER			500
#define IDR_MOVE_BEFORE_TO_END		IDR_MOVE_BEFORE_TO_BEGIN + MAX_SHEETS_NUMBER

enum
{
#ifdef _SUPPORT_DRAG_TO_MOVE_ROW_FOR_WKS_ARRANGE_
	COL_FIXED = 0, /// Iris 9/26/2011 ORG-3616-S3 SUPPORT_ROW_MOVING
#endif //_SUPPORT_DRAG_TO_MOVE_ROW_FOR_WKS_ARRANGE_
	COL_INDEX,
	COL_CREATION_INDEX,
	COL_NAME,
	COL_COLS,
	COL_SIZE,
	COL_COMMENTS,
	COL_TYPE,
	COL_SOURCE,
	
	COL_COUNT
};

class SheetListView;
class SheetListHeaderMenu : public MenuBase
{
public:
	SheetListHeaderMenu(SheetListView* pList)
	{
		if( NULL == pList )
			return;
		string strItems = pList->GetHeaders();
		vector<string> vs;
		strItems.GetTokens(vs, '|'); 
		
		for(int ii = 0; ii < vs.GetSize(); ii++)
		{
			UINT nFlags = MF_STRING;
			/// Iris 9/26/2011 ORG-3616-S3 SUPPORT_ROW_MOVING
			//if( !pList->GetIsColHidden(ii) )
			if( !pList->GetIsColHidden( ii + pList->GetColOffset()) )
			///End SUPPORT_ROW_MOVING
				nFlags |= MF_CHECKED;
			
			Add(vs[ii], OnMenuItem, nFlags);
		}
	}
};

/// Iris 9/26/2011 ORG-3616-S3 ADD_GRID_CONTEXT_MENU
class SheetListContextSubMenu : public MenuBase
{
public:
	int GetCommandID()
	{
		int nChoice;
		if( GetCommand(nChoice) )
		{
			return IDR_MOVE_BEFORE_TO_BEGIN + nChoice + 1;
		}
		return -1;
	}
};

class SheetListContextMenu : public MenuBase
{
public:
	SheetListContextMenu(const vector<string>& vsMenuText, const vector<int>& vnCmdIDs, const vector<bool>& vbEnables)
	{
		bool bPopup = false;
		string strPopupMainMenuText;
		
		for(int ii = 0; ii < vsMenuText.GetSize(); ii++)
		{
			string strText = vsMenuText[ii];
			if( strText.IsEmpty() )
			{
				Add(NULL, OnMenuItem, MF_SEPARATOR);
			}
			else if( strText.GetAt(0) == '+' || bPopup )
			{
				if( !bPopup )
				{
					bPopup = true;
					strPopupMainMenuText = vsMenuText[ii];
					strPopupMainMenuText.Delete(0); // remove '+'
				}
				else
				{
					if( strText.GetAt(0) == '-' ) // the last item in popup menu
					{
						strText.Delete(0);
						bPopup = false;
					}
					UINT uFlags = MF_STRING;
					if( !vbEnables[ii] )
						uFlags |= MF_DISABLED | MF_GRAYED;
					m_PopupMenu.Add(strText, /*SheetListContextSubMenu::*/OnMenuItem, uFlags, vnCmdIDs[ii]);
					
					if( !bPopup )
					{
						AddPopup(strPopupMainMenuText, m_PopupMenu);
					}
				}				
			}
			else
			{
				UINT uFlags = MF_STRING;
				if( !vbEnables[ii] )
					uFlags |= MF_DISABLED | MF_GRAYED;

				Add(strText, OnMenuItem, uFlags, vnCmdIDs[ii]);
			}
		}		
	}

	int GetCommandID()
	{
		int nCmd;
		if(GetCommand(nCmd))
		{			
			return GetMenuItemID(nCmd);
		}
		else
		{
			return m_PopupMenu.GetCommandID();
		}
		return -1;
	}
	
private:
	SheetListContextSubMenu 	m_PopupMenu;
	
};
///End ADD_GRID_CONTEXT_MENU

class SheetListView : public GridListControl
{
public:
	SheetListView() {}
	~SheetListView();
	
	void Init(UINT uID, WndContainer &Dlg);	
	bool HasSelection(bool *pbOnlyOneSelection = NULL);
	int  GetSheets(vector<string>& vsSheetName, vector<int>& vnIndex, vector<bool>& vbSelected);
	
	void OnAfterSortCol();
	
	void ActivateSheet();
	bool ClearAllData();
	bool DeleteSheet();
	bool MoveSelectedTo(int nToWksBefore); // -1 means end
	bool MoveToNewBook(bool bKeepSource);
	void SetSheetOrderAsCurrent();
	void DuplicateSheets(bool bWithData);
	/// Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE
	bool OnCellBeforeEdit( int nRow, int nCol, BOOL* pCancel );
	bool OnCellAfterEdit(int nRow, int nCol);
	///End SET_COMMENTS_COLUMN_AS_EDITABLE
	///------ Folger 01/31/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	//void OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, bool* pCancel, bool* pMenuNeedUpdate = NULL);
	void ShowMenu(int nx, int ny, bool* pMenuNeedUpdate = NULL);
	///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	void OnAfterRowReorder();
	
	virtual string GetDlgName() { ASSERT(false); return ""; }	
	virtual string GetHeaders() { ASSERT(false); return ""; }
	virtual int GetHelpID() { ASSERT(false); return 0; }
	
	void SetContextMenu(vector<string>& vsMenuText, vector<int>& vnCmdIDs, vector<bool>& vbEnables) { m_vsContextMenuText = vsMenuText; m_vnContextMenuCmdIDs = vnCmdIDs; m_vbEnables = vbEnables; } /// Iris 9/26/2011 ORG-3616-S3 ADD_GRID_CONTEXT_MENU
	bool IsMenuItemEnable(int nCmdID);
	
	bool IsSheetsReordered(); /// Iris 9/29/2011 ORG-3616 ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID
	bool ApplyChange(); /// Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE
	
protected:
	// virtual
	string GetClassName() { ASSERT(false); return ""; }	
	virtual int GetNumObjects(Datasheet& datasheet) { ASSERT(false); return 0; }
	
private:	
	void update(bool bInit);
	int  getSelectedSheet(vector<uint>* pvnSel = NULL);
	bool getSheetInfo(Datasheet& datasheet, vector<string>& vsInfo);
	int	 findRow(int nLayIndex);
	void appendOneSheetInfo(Datasheet& datasheet);
	void adjustLayerIndexAfterMoving(vector<uint>& vnLays, int nMoveTo, int index);
	
private:
	Page			m_pg;
	int				m_nBoldRow;	
	/// Iris 9/26/2011 ORG-3616-S3 ADD_GRID_CONTEXT_MENU
	vector<string>  m_vsContextMenuText; 
	vector<int>		m_vnContextMenuCmdIDs;
	vector<bool>	m_vbEnables;
	///End ADD_GRID_CONTEXT_MENU
	bool			m_bIsCommentsEdit; /// Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE
};

class WorkSheetListView : public SheetListView
{
public:
	// virtual
	string GetDlgName() { return STR_WKS_DLG_NAME; }	
	// virtual 
	string GetHeaders() { return STR_WKS_LIST_HEADER; }
	// vitrual
	int GetHelpID() { return IDD_WKS_NAVIGATE_DLG; }
	
protected:
	// virtual
	string GetClassName() { return "WorkSheetListView"; }
	// virtual
	int GetNumObjects(Datasheet& datasheet);
};

class MatrixSheetListView : public SheetListView
{
public:
	// virtual
	string GetDlgName() { return STR_MAT_DLG_NAME; }	
	// virtual 
	string GetHeaders() { return STR_MAT_LIST_HEADER; }
	// vitrual
	int GetHelpID() { return IDD_MAT_NAVIGATE_DLG; }
	
protected:
	// virtual
	string GetClassName() { return "MatrixSheetListView"; }
	// virtual
	int GetNumObjects(Datasheet& datasheet);
};


class WksMoveDlg : public ResizeDialog
{
public:
	WksMoveDlg() : ResizeDialog(IDD_WKS_MOVE_DLG, "ODlg8") {}
	~WksMoveDlg() {}
	
	int DoModalEx(HWND hWndParent = NULL)
	{		
		InitMsgMap();
		int nRet = ResizeDialog::DoModal(hWndParent);		
		return nRet;
	}	
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)
	ON_SIZE(OnDlgResize)
	ON_HELPINFO(OnHelp)
	ON_DESTROY(OnDestroy)
	ON_OK(OnOK) /// Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE
	ON_BN_CLICKED(IDC_BTN_APPLY_REORDER, OnApplyReorderButtonClick) /// Iris 9/29/2011 ORG-3616 ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID
	
	ON_MENU_CMD(IDR_ACTIVATE, OnActivate)
	ON_MENU_CMD(IDR_DUPLICATE, OnDuplicate)
	ON_MENU_CMD(IDR_DUPLICATE_WITHOUT_DATA, OnDuplicateWithoutData)
	ON_MENU_CMD(IDR_CLEAR_DATA, OnClearAllData)
	ON_MENU_CMD(IDR_DELETE, OnDelete)
	ON_MENU_CMD_RANGE(IDR_MOVE_BEFORE_TO_BEGIN, IDR_MOVE_BEFORE_TO_END, OnMoveBefore)
	ON_MENU_CMD(IDR_MOVE_TO_BEGIN, OnMoveToBegin)
	ON_MENU_CMD(IDR_MOVE_TO_END, OnMoveToEnd)
	ON_MENU_CMD(IDR_SET_CURRENT_ORDER_AS_SHEET_ORDER, OnSetSheetOrderAsCurrent)
	ON_MENU_CMD(IDR_MOVE_TO_NEW_BOOK, OnMoveToNewBook)
	ON_MENU_CMD(IDR_DUPLICATE_TO_NEW_BOOK, OnDuplicateToNewBook)
	
	ON_GRID_DBLCLICK(IDC_LIST, OnGridDBClick)
	ON_GRID_AFTER_SEL_CHANGE(IDC_LIST, OnGridAfterSelChange)
	ON_GRID_AFTER_SORT(IDC_LIST, OnGridAfterSort)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_LIST, OnGridBeforeMouseDown)
	ON_CONTEXTMENU(OnContextMenu)	///------ Folger 01/31/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	ON_GRID_AFTER_MOVE_ROWS(IDC_LIST, OnGridAfterMoveRows)
	/// Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE
	ON_GRID_BEFORE_EDIT(IDC_LIST, OnGridBeforeEdit) 
	ON_GRID_AFTER_EDIT(IDC_LIST, OnGridAfterEdit) 
	///End SET_COMMENTS_COLUMN_AS_EDITABLE
	
EVENTS_END

	BOOL OnInitDialog();
	BOOL OnReady();
	BOOL OnDlgResize(int nType, int cx, int cy);
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus); /// Iris 09/09/2011 ORG-3616 ADD_WKS_NAVIGATE_DLG_HELP_ID	
	BOOL OnDestroy();
	BOOL OnOK(); /// Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE
	BOOL OnApplyReorderButtonClick(Control ctrl); /// Iris 9/29/2011 ORG-3616 ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID
	
	BOOL OnActivate();
	BOOL OnDuplicate();
	BOOL OnDuplicateWithoutData();
	BOOL OnClearAllData();
	BOOL OnDelete();
	BOOL OnMoveBefore(int nCmdID);
	BOOL OnMoveToBegin();
	BOOL OnMoveToEnd();	
	BOOL OnSetSheetOrderAsCurrent();
	BOOL OnMoveToNewBook();
	BOOL OnDuplicateToNewBook();	
	
	void OnGridDBClick(Control ctrl);
	void OnGridAfterSelChange(Control cntrl, int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel);
	BOOL OnGridAfterSort(Control ctrl, long lCol, short* pSort);
	void OnGridBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, bool* pCancel);
	BOOL OnContextMenu(UINT nResIDCtrl, int nx, int ny);		///------ Folger 01/31/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	void OnGridAfterMoveRows(Control ctrl, long nRow, long *pnPosition);
	/// Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE	
	void OnGridBeforeEdit( Control ctrl, int nRow, int nCol, BOOL* pCancel ); 
	void OnGridAfterEdit(Control ctrl, int nRow, int nCol);
	///End SET_COMMENTS_COLUMN_AS_EDITABLE
	
private:	
	void updateSubMenuEnableStatus();
	void adjustLayerIndexAfterMoving(vector<uint>& vnLays, int nMoveTo, int index);
	void enableMenuItem(int nMenuID, bool bEnable);
	void updateSheetsPopupMenu(bool bInit = false);
	
	/// Iris 9/26/2011 ORG-3616-S3 ADD_GRID_CONTEXT_MENU
	void updateContextMenu();
	bool getMenuText(vector<string>& vsMenu, vector<int>& vnCmdIDs, vector<bool>& vbEnables); 
	int  getSheetListSubMenus(vector<string>& vsMenu, vector<uint>& vnFlags);
	void updateMenuItemOnAfterGridChange();
	///End ADD_GRID_CONTEXT_MENU		
	
	void doReorderSheet(); /// Bill 10/21/2011 ORG-3616-P15 RECONSTRUCT_MENU_AFTER_REORDER_SHEET
	
	void enableApplyReorderButton(bool bEnable = true); /// Iris 9/29/2011 ORG-3616 ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID

private:
	SheetListView*	m_plist;	
	Menu 			m_menu;	
};
	
