/*------------------------------------------------------------------------------*
 * File Name: WksColLabels.h													*
 * Creation: 																	*
 * Purpose: OriginC Source H file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Folger 06/14/07 MOVE_FUNCTION_BODY_FORM_H_TO_C								*
 * Kenny 03/12/2009 ADD_FUNC_GET_BUILTIN_LABEL_NAME								*
 *	Folger 03/25/09 CLEAN_UP_CODES_ABOUT_GET_ALL_SHWON_PARAMETER_NAMES_AND_VALUES
 *	Kenny 08/27/2009 QA81-14182 NEW_XF_PLOTTING_GROUPS_OF_COLUMNS				*
 *	Folger 09/04/09 GET_WKS_SHOWN_LABELS_SUPPORT_SKIP_SPECIFIC_TYPES			*
 *	Folger 09/02/09 BATCH_PROCESS_APPEND_LABEL_ROWS_SKIP_EMPTY					*
 *	Kenny 09/27/2009 QA81-14241 INSERT_PARAM_NEED_CORRECT_INDICES_AND_CENTRALIZE_CODES*
 *	Folger 11/06/09 QA81-14609 XF_SUPPORT_LABEL_INDENTIFIER_FROM_LT				*
 *	Folger 11/06/09 QA81-14603 PAMULTIY_SUPPORT_INSERT_DATA_INDENTIFIER_IN_SUMMARY_SHEET
 *	Folger 12/11/09 QA81-14733 PA_MULTIY_SUPPORT_APPEND_FIT_STATS_RESULTS		*
 *	Folger 05/05/10 ORG-88 BATCH_PROCESS_SUPPORT_DATASET_IDENTIFIER				*
 *	Folger 12/29/2010 ORG-1881-S1 DIGITIZER_BETTER_SHOW_SCALE_TYPE_IN_UDL		*
 *	Folger 02/28/2011 ORG-88-S1 SUPPORT_DATA_IDENTIFIER_FOR_IMPORT_FILE_MODE_IN_BATCH_PROCESS
 *	Sophy 4/2/2011 ORG-2571 CHECK_USER_DEFINED_LABEL_NAME_SHOULD_NOT_DO_PARTIAL_MATCH
 *	Folger 04/06/2011 ORG-2580-S1 BETTER_LABEL_INDENTIFIER_IN_WKS_STACK_COL		*
 *	Folger 04/07/2011 ORG-2601-P1 SIMPLE_CHAR_TO_SPECIFY_LABEL_ROW_IN_LT		*
 *	Folger 04/07/2011 ORG-2581-S1 UNSTACK_COLUMN_SUPPORT_PUT_GROUP_INFO_INTO_CUSTOM_LABELS
 *	Kyle 08/11/2011 ORG-2574-S5 ADD_UTILS_TO_GET_INDEX_OF_COLUMN_LABEL_IN_WORKSHEET
 *	Folger 05/03/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS			*
 *	Folger 05/17/2012 ORG-5592-P2 PROPER_UDPATE_DATA_IDENTIFIER_ON_REPORT_CONTEXT_MENU
 *	Folger 05/29/2012 ORG-5592-S1 SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET			*
 *	Zech 09/04/2012 ORG-6697-S1 PIVOT_TABLE_SUPPORT_SPECIFIED_COLUMN_IDENTIFIER	*
 *------------------------------------------------------------------------------*/
 
#ifndef _WKSCOLLABELS_H_
#define _WKSCOLLABELS_H_

#define BUILD_IN 15

///Folger 06/14/07 MOVE_FUNCTION_BODY_FORM_H_TO_C
int find_builtin_label(string strName);
///Sophy 4/2/2011 ORG-2571 CHECK_USER_DEFINED_LABEL_NAME_SHOULD_NOT_DO_PARTIAL_MATCH
//int find_UDL_label(const vector<string> &vsUDLs, string strName);
int find_UDL_label(const vector<string> &vsUDLs, string strName, bool bAllowPartialMatch = true);
///end CHECK_USER_DEFINED_LABEL_NAME_SHOULD_NOT_DO_PARTIAL_MATCH
///End MOVE_FUNCTION_BODY_FORM_H_TO_C

bool get_wks_UDL_showtype(const Worksheet &wks, vector<int> &vnTypes = NULL, vector<string> &vsUDLs = NULL);
bool set_wks_UDL_showtype(Worksheet &wks, const vector<int> &vnTypes = NULL, const vector<string> &vsUDLs = NULL);

/// Kenny 08/27/2009 QA81-14182 NEW_XF_PLOTTING_GROUPS_OF_COLUMNS

int get_label_type_by_name(const Worksheet& wks, LPCTSTR lpcszLabelName);

///------ Folger 11/06/09 QA81-14609 XF_SUPPORT_LABEL_INDENTIFIER_FROM_LT
int	get_label_type_by_name_or_indentifier(const Worksheet& wks, LPCTSTR lpcszLabel);
int	get_wks_shown_col_label_info_skip_specials(const Worksheet& wks, vector<string>& vsNames, vector<int>& vnTypes);
///------ End XF_SUPPORT_LABEL_INDENTIFIER_FROM_LT

///------ Folger 09/04/09 GET_WKS_SHOWN_LABELS_SUPPORT_SKIP_SPECIFIC_TYPES
//bool get_wks_shown_col_label_info(const Worksheet& wks, vector<string>& vsNames, vector<int>& vnTypes);
bool get_wks_shown_col_label_info( const Worksheet& wks, vector<string>& vsNames, vector<int>& vnTypes, vector<int>* pvnTypesToSkip = NULL );
///------ End GET_WKS_SHOWN_LABELS_SUPPORT_SKIP_SPECIFIC_TYPES

/// Kenny 09/27/2009 QA81-14241 INSERT_PARAM_NEED_CORRECT_INDICES_AND_CENTRALIZE_CODES

string get_label_name_by_type(const int nType, const Worksheet& wks = NULL);

class WksColLabelHelper
{
public:
	WksColLabelHelper(const Worksheet& wks = NULL);
public:
	BOOL	Attach(const Worksheet& wks);
	int		UpdateUDLInfo();
	int		GetTypeByName(LPCTSTR lpcszLabelName);
	string	GetNameByType(int nType);
protected:
	vector<string>	m_vsUDLNames;
private:
	Worksheet		m_wks;
};
/// End QA81-14241 INSERT_PARAM_NEED_CORRECT_INDICES_AND_CENTRALIZE_CODES

enum
{
	GET_COMMON_LABEL_OK,
	GET_COMMON_LABEL_ERROR,
	GET_COMMON_LABEL_NO_COMMON,
};

///------ Folger 11/06/09 QA81-14603 PAMULTIY_SUPPORT_INSERT_DATA_INDENTIFIER_IN_SUMMARY_SHEET
//int get_wks_common_col_label_info(const Worksheet& wks, vector<string>& vsNames, vector<int>& vnTypes, bool bIsFirstWks = true);
int get_wks_common_col_label_info(const Worksheet& wks, vector<string>& vsNames, vector<int>& vnTypes, bool bIsFirstWks = true, BOOL bSkipSpecials = TRUE);
///------ End PAMULTIY_SUPPORT_INSERT_DATA_INDENTIFIER_IN_SUMMARY_SHEET

///Kyle 08/11/2011 ORG-2574-S5 ADD_UTILS_TO_GET_INDEX_OF_COLUMN_LABEL_IN_WORKSHEET
int get_wks_column_label_index(const Worksheet& wks, int nType, int* pnLabelRows = NULL, const Grid& grid = NULL);
///End ADD_UTILS_TO_GET_INDEX_OF_COLUMN_LABEL_IN_WORKSHEET

class WksCommonColLabelHelper
{
public:
	///------ Folger 11/06/09 QA81-14603 PAMULTIY_SUPPORT_INSERT_DATA_INDENTIFIER_IN_SUMMARY_SHEET
	//int		UpdateCommonColLabelInfo(const Worksheet& wks);
	int		UpdateCommonColLabelInfo(const Worksheet& wks, BOOL bSkipSpecials = TRUE);
	///------ End PAMULTIY_SUPPORT_INSERT_DATA_INDENTIFIER_IN_SUMMARY_SHEET
	void	Reset();
	const vector<string>&	GetLabelNames() {return m_vsLabelNames;}
	const vector<int>&		GetLabelTypes() {return m_vnLabelTypes;}
	void	GetLabelNames(vector<string>& vsLabelNames)	{vsLabelNames = m_vsLabelNames;}
	void	GetLabelTypes(vector<int>& vsLabelTypes)	{vsLabelTypes = m_vnLabelTypes;}
protected:
	vector<string>	m_vsLabelNames;
	vector<int>		m_vnLabelTypes;
private:
	vector<UINT>	m_vnWksUID;
};
/// End QA81-14182 NEW_XF_PLOTTING_GROUPS_OF_COLUMNS

///------ Folger 11/06/09 QA81-14603 PAMULTIY_SUPPORT_INSERT_DATA_INDENTIFIER_IN_SUMMARY_SHEET
class MultipleRangesWksCommonLabelHelperBase
{
public:
	const	vector<string>*		GetLabelNames()
	{
		if ( m_vsLabelNames.GetSize() == 0 )
			return m_clHelper.GetLabelNames();
		
		return &m_vsLabelNames;
	}
	const	vector<int>*		GetLabelTypes()
	{
		if ( m_vnLabelTypes.GetSize() == 0 )
			return m_clHelper.GetLabelTypes();
		
		return &m_vnLabelTypes;
	}

	void Update(Datasheet& ds)
	{
		if ( !ds )
			return;

		Worksheet wks(ds);
		if ( wks )
		{
			switch ( m_clHelper.UpdateCommonColLabelInfo(wks) )
			{
			case GET_COMMON_LABEL_OK:
				break;

			case GET_COMMON_LABEL_ERROR:
				ASSERT(0);
			case GET_COMMON_LABEL_NO_COMMON:
				return;

			default:
				ASSERT(0);
				break;
			}
		}
		else
		{
			MatrixLayer ml(ds);
			ASSERT(ml.IsValid());
			if ( m_vsLabelNames.GetSize() == 0 )
			{
				m_vsLabelNames.Add(GetLocalized(E_STR_LONGNAME));
				m_vnLabelTypes.Add(RCLT_LONG_NAME);

				m_vsLabelNames.Add(GetLocalized(E_STR_UNITS));
				m_vnLabelTypes.Add(RCLT_UNIT);

				m_vsLabelNames.Add(GetLocalized(E_STR_COMMENTS));
				m_vnLabelTypes.Add(RCLT_COMMENT);
			}
		}
	}

protected:
	WksCommonColLabelHelper		m_clHelper;
	vector<string>				m_vsLabelNames;
	vector<int>					m_vnLabelTypes;
};

class MultipleXYRangesWksCommonLabelHelper : public MultipleRangesWksCommonLabelHelperBase
{
public:
	MultipleXYRangesWksCommonLabelHelper(XYRange& xy)
	{
		if ( !xy )
			return;

		DWORD		dwDataRules = DRR_GET_DEPENDENT | DRR_NO_FACTORS;
		int			nNumData = xy.GetNumData(dwDataRules);
		for ( int ii=0; ii<nNumData; ++ii )
		{
			DataRange	xySub;
			xy.GetSubRange(xySub, dwDataRules, ii);
			if ( xySub )
			{
				Datasheet		ds;
				int				c1, c2;
				xySub.GetRange(ds, c1, c2);
				Update(ds)
			}
		}
	}
};

///------ Folger 05/08/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
class MultipleRegularRangesWksCommonLabelHelper : public MultipleRangesWksCommonLabelHelperBase
{
public:
	MultipleRegularRangesWksCommonLabelHelper(DataRange& dr)
	{
		if ( !dr )
			return;

		int nNumRanges = dr.GetNumRanges();
		for ( int ii=0; ii<nNumRanges; ++ii )
		{
			Datasheet ds;
			int c1, c2;
			dr.GetRange(ds, c1, c2, ii);
			Update(ds);
		}
	}
};

class MultipleXYZRangesWksCommonLabelHelper : public MultipleRangesWksCommonLabelHelperBase
{
public:
	MultipleXYZRangesWksCommonLabelHelper(XYZRange& xy)
	{
		if ( !xy )
			return;

		DWORD		dwDataRules = DRR_GET_Z_DEPENDENT | DRR_NO_FACTORS;
		int			nNumData = xy.GetNumData(dwDataRules);
		for ( int ii=0; ii<nNumData; ++ii )
		{
			DataRange	xySub;
			xy.GetSubRange(xySub, dwDataRules, ii);
			if ( xySub )
			{
				Datasheet		ds;
				int				c1, c2;
				xySub.GetRange(ds, c1, c2);
				Update(ds)
			}
		}
	}
};
///------ End ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS

#define		GET_LABEL_NAMES(_MultipleXYRangesWksCommonLabelHelper)		*(_MultipleXYRangesWksCommonLabelHelper).GetLabelNames()
#define		GET_LABEL_TYPES(_MultipleXYRangesWksCommonLabelHelper)		*(_MultipleXYRangesWksCommonLabelHelper).GetLabelTypes()
///------ End PAMULTIY_SUPPORT_INSERT_DATA_INDENTIFIER_IN_SUMMARY_SHEET

string get_builtin_label_name(int nType);	///Kenny 03/12/2009 ADD_FUNC_GET_BUILTIN_LABEL_NAME
/*
int wks_add_column_label(Worksheet &wks, const vector<string> &vsNames)
{
	vector<string> vsUDLs;
	vector<int> vnTypes;
	
	if (!get_wks_UDL_showtype(wks, vsUDLs, vnTypes))
	{
		return -1;
	}
	int nSize = vsNames.GetSize();
	int nUDLSize = vsUDLs.GetSize();
	int nAdd;
	
	for (int ii=0; ii<nSize; ii++)
	{
		if (vsUDLs.Find(vsNames[ii]) != -1 || find_builtin_label(vsNames[ii]) != -1) continue;
		vsUDLs.Add(vsNames[ii]);
		vnTypes.Add(RCLT_UDL + nUDLSize + (nAdd++));
	}
	
	if (!set_wks_UDL_showtype(wks, vsUDLs, vnTypes))
	{
		return -1;
	}
	
	return nAdd;
}

int wks_remove_column_label(Worksheet &wks, const vector<string> &vsNames)
{
	vector<string> vsUDLs;
	vector<int> vnTypes;
	
	if (!get_wks_UDL_showtype(wks, vsUDLs, vnTypes))
	{
		return -1;
	}
	int nSize = vsNames.GetSize();
		
	for (int ii=0; ii<nSize; ii++)
	{
		int nIndex = vsUDLs.Find(vsNames[ii]);
		if (nIndex != -1)
		{
			vsUDLs.RemoveAt(nIndex);
			vector<uint> vnIndex;
			if (vnTypes.Find(vnIndex, RCLT_UDL + nIndex) != 0)
			{
				vnTypes.RemoveAt(vnIndex[0]);
			}
			int nTmpSize = vnTypes.GetSize();
			for (int jj=0; jj<nTmpSize; jj++)
			{
				if (vnTypes[jj] > RCLT_UDL + nIndex)
				{
					vnTypes[jj]--;
				}
			}
		}
	}
	
	if (!set_wks_UDL_showtype(wks, vsUDLs, vnTypes))
	{
		return -1;
	}
	
	return 0;
}

int wks_remove_all_column_label(Worksheet &wks)
{
	vector<string> vsUDLs;
	vector<int> vnTypes;
	
	if (!get_wks_UDL_showtype(wks, vsUDLs, vnTypes))
	{
		return -1;
	}
	
	for (int ii=0; ii<vnTypes.GetSize(); ii++)
	{
		if (vnTypes[ii] >= RCLT_UDL)
		{
			vnTypes.RemoveAt(ii);
			ii--;
		}
	}
	vsUDLs.SetSize(0);
	
	if (!set_wks_UDL_showtype(wks, vsUDLs, vnTypes))
	{
		return -1;
	}
	
	return 0;
}

int wks_column_label_set_show(Worksheet &wks, const vector<int> &vsLabels, bool bShow = true)
{
	return -1;
}

int wks_column_label_set_height(Worksheet &wks, const vector<int> &vsLabels, double height)
{
	
	return -1;
}

int wks_column_label_set_height(Worksheet &wks, const vector<string> &vsNames, double height)
{
	vector<string> vsUDLs;
	vector<int> vnTypes;
	
	if (!get_wks_UDL_showtype(wks, vsUDLs, vnTypes))
	{
		return -1;
	}
	
	vector<int> vnLabels;
	int nSize = vsNames.GetSize();
	for (int ii=0; ii<nSize; ii++)
	{
		int nIndex;
		if ((nIndex = find_builtin_label(vsNames[ii])) != -1)
		{
			nIndex %= BUILT_IN;
			vnLabels.Add(RCLT_LONG_NAME + nIndex);
		}
		else if ((nIndex = find_UDL_label(vsUDLs, vsNames[ii])) != -1)
		{
			vnLabels.Add(RCLT_UDL + nIndex);
		}
	}
	nSize = vnLabels.GetSize();
	if (height == 0)
	{
		vector<int> vnTypes;
		Grid grid;
		grid.Attach(wks);
		grid.GetShowLabels(vnTypes);
		for (int ii=0; ii<nSize; ii++)
		{
			vector<uint> vnIndex;
			if (vnTypes.Find(vnIndex, vnLabels[ii]) != 0)
			{
				vnTypes.RemoveAt(vnIndex[0]);
			}
		}
		grid.SetShowLabels(vnTypes);
		wks.GetPage().Refresh();
	}
	else
	{
		for (int ii=0; ii<nSize; ii++)
		{
			wks_set_col_label_heights(wks, vnLabels[ii], height*100);
		}
	}
	return -1;
}
*/

///------ Folger 03/25/09 CLEAN_UP_CODES_ABOUT_GET_ALL_SHWON_PARAMETER_NAMES_AND_VALUES
int	get_all_shown_parameters_names_and_values(Column& col, vector<string>* pvsNames, vector<string>* pvsValues, vector<int>* pvnTypes = NULL);
///------ End CLEAN_UP_CODES_ABOUT_GET_ALL_SHWON_PARAMETER_NAMES_AND_VALUES

///------ Folger 09/02/09 BATCH_PROCESS_APPEND_LABEL_ROWS_SKIP_EMPTY
///------ Folger 12/11/09 QA81-14733 PA_MULTIY_SUPPORT_APPEND_FIT_STATS_RESULTS
//void	append_label_rows(Worksheet& wksSummary, Worksheet& wksSrc, int nColOffset = 0);
void	append_label_rows(Worksheet& wksSummary, Worksheet& wksSrc, int nColOffset = 0, int nRowStart = -1);
///------ End PA_MULTIY_SUPPORT_APPEND_FIT_STATS_RESULTS
///------ End BATCH_PROCESS_APPEND_LABEL_ROWS_SKIP_EMPTY

///------ Folger 05/05/10 ORG-88 BATCH_PROCESS_SUPPORT_DATASET_IDENTIFIER
int		batch_get_label_type_by_name(Datasheet& ds, LPCSTR lpcszLabel);
void	batch_update_data_indentifiers(TreeNode& trGetN, LPCSTR lpcszTag, DWORD dwCntrl = 0);
///------ Folger 05/03/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
void	batch_update_data_indentifiers_ex(TreeNode& trDataId, TreeNode& trRange, DWORD dwCntrl = 0, LPCSTR lpcszDefault = NULL, int nRangeOption = DRTREE_DEFAULT);
///------ End ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
///------ Folger 05/17/2012 ORG-5592-P2 PROPER_UDPATE_DATA_IDENTIFIER_ON_REPORT_CONTEXT_MENU
bool batch_get_data_identifiers(vector<string>& vsIDs, DataRange& rng, DWORD dwCntrl = 0);
///------ End PROPER_UDPATE_DATA_IDENTIFIER_ON_REPORT_CONTEXT_MENU
string	batch_get_data_identifier_string(XYRange& xy, int nLabelType);
BOOL	batch_check_append_col_results(Worksheet& wks, int nCol, int nSize, LPCSTR lpcsz, int nRowStart);
///------ End BATCH_PROCESS_SUPPORT_DATASET_IDENTIFIER
///------ Folger 05/29/2012 ORG-5592-S1 SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET
void check_show_data_identifier_label_row(Worksheet& wks, bool bShow);
///------ End SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET
///------ Folger 02/28/2011 ORG-88-S1 SUPPORT_DATA_IDENTIFIER_FOR_IMPORT_FILE_MODE_IN_BATCH_PROCESS
BOOL	batch_is_none_identifier(LPCSTR lpcszIdentifier);
///------ End SUPPORT_DATA_IDENTIFIER_FOR_IMPORT_FILE_MODE_IN_BATCH_PROCESS

///------ Folger 12/29/2010 ORG-1881-S1 DIGITIZER_BETTER_SHOW_SCALE_TYPE_IN_UDL
int		check_get_user_defined_label(Worksheet& wks, LPCSTR lpcszLabel);
///------ End DIGITIZER_BETTER_SHOW_SCALE_TYPE_IN_UDL

///------ Folger 04/06/2011 ORG-2580-S1 BETTER_LABEL_INDENTIFIER_IN_WKS_STACK_COL
BOOL	convert_label_name_identifier(string& strLabel, Worksheet& wks, BOOL bToName);
BOOL	convert_label_name_identifier_ex(StringArray& arrLabels, Worksheet& wks, BOOL bToName);
///------ End BETTER_LABEL_INDENTIFIER_IN_WKS_STACK_COL

///------ Folger 04/07/2011 ORG-2601-P1 SIMPLE_CHAR_TO_SPECIFY_LABEL_ROW_IN_LT
BOOL	check_init_getn_label_combo(TreeNode& trLabel, const vector<string>& vsLablels, Worksheet& wks, BOOL bDefaultFirst = TRUE);
///------ End SIMPLE_CHAR_TO_SPECIFY_LABEL_ROW_IN_LT

///------ Folger 04/07/2011 ORG-2581-S1 UNSTACK_COLUMN_SUPPORT_PUT_GROUP_INFO_INTO_CUSTOM_LABELS
#define	STR_ALLOWED_LABEL_SHORTCUT			"G L U C P D"
#define	STR_ALLOWED_LABEL_SHORTCUT_NO_SN	"L U C P D"
///------ End UNSTACK_COLUMN_SUPPORT_PUT_GROUP_INFO_INTO_CUSTOM_LABELS

/// Zech 09/04/2012 ORG-6697-S1 PIVOT_TABLE_SUPPORT_SPECIFIED_COLUMN_IDENTIFIER
void	update_combo_control_to_list_labels_from_range(TreeNode& trRng, TreeNode& trLabelCombo);

enum
{
	IWCLE_ERR_INVALID_COLUMN,
	IWCLE_ERR_LABEL_NOT_EXIST,
	IWCLE_ERR_LABEL_IS_EMPTY,
};
bool	is_wanted_column_label_empty(Worksheet& wksGroup, uint* parrColIndices, int nColIndicesSize, LPCSTR lpcszLabel, int* pnErrCode);
/// END PIVOT_TABLE_SUPPORT_SPECIFIED_COLUMN_IDENTIFIER

#endif //_WKSCOLLABELS_H_