/*------------------------------------------------------------------------------*
 * File Name: Wks2Vm.h															*
 * Creation: Bill 01/10/2010													*
 * Purpose: OriginC Header H file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef WKS2VM_H
#define WKS2VM_H

enum{
	FORMAT_YACROSS,
	FORMAT_XACROSS,
};

enum{
	ROWPOS_NONE,
	ROWPOS_SELROW1,
	ROWPOS_WKSROW1,
	ROWPOS_LABEL,
	ROWPOS_CUSTOM,
};

enum{
	COLPOS_NONE,
	COLPOS_SELCOL1,
	COLPOS_WKSCOL1,
	COLPOS_XCOL,
	COLPOS_CUSTOM,
};

#define	STR_INPUT_TITLE_XYZ	_L("Input Data")
#define	STR_INPUT_TITLE_Z	_L("Z Data")
#define	STR_X_VALUES_IN		_L("X Values in")
#define	STR_Y_VALUES_IN		_L("Y Values in")
#define	STR_X_VALUES		_L("X Range")
#define	STR_Y_VALUES		_L("Y Range")

// construct helper

class VirtualMatrixConstructor
{
public:
	VirtualMatrixConstructor(){ m_nFormat = -1; m_nRowMode = -1; m_nColMode = -1; }
	~VirtualMatrixConstructor(){}

	BOOL	MakeVirtualMatrixRange(const TreeNode& trGetN, DataRange& drVM);
	///Sophy 8/27/2010 ORG-923-P1 LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH
	BOOL	MakeVirtualMatrixRange(const TreeNode& trGetN, Range& irng, Range& rowrng, Range& colrng, DataRange& drVM);	
	/// End LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH
	int		UpdateGUI(TreeNode& trGetN, bool bAllowAuto);
	int		CheckInput(TreeNode& trGetN);

protected:
	enum {
		VM_NORMAL_RANGE		= -3,
		VM_NO_ROW_RANGE		= -2,
		VM_NO_COL_RANGE		= -1, // use minus value to distinguish from XF error code
	};
	
	int		Init(const TreeNode& trGetN);
	///Sophy 8/27/2010 ORG-923-P1 LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH
	int		Init(const TreeNode& trGetN, Range& irng, Range& rowrng, Range& colrng);	
	int		InitSettings(const TreeNode& trGetN);
	BOOL	AddRanges(DataRange& drVM);
	///end LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH
	int		InitRowRange();
	int		InitColRange();
	BOOL	AddX(DataRange& drVM);
	BOOL	AddY(DataRange& drVM);
	BOOL	AddZ(DataRange& drVM);
	BOOL	AddRow(DataRange& drVM, LPCSTR lpcszName);
	BOOL	AddCol(DataRange& drVM, LPCSTR lpcszName);

private:
	int	m_nFormat;
	int	m_nRowMode;
	int	m_nColMode;
	int m_nR1, m_nC1, m_nR2, m_nC2;
	int	m_nRr1, m_nRc1, m_nRr2, m_nRc2;	//row range
	int	m_nCr1, m_nCc1, m_nCr2, m_nCc2;	//column range
	int	m_nZr1, m_nZc1, m_nZr2, m_nZc2; //z range
	int	m_nColLabelIndex;	///Sophy 8/31/2010 ORG-923-P2 LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
	Range	m_irng, m_rowrng, m_colrng;
	Worksheet	m_wks;
};

// util functions
bool construct_virtual_range(TreeNode& trGetN, DataRange& drVM);

///Sophy 8/27/2010 ORG-923-P1 LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH
bool construct_virtual_range(TreeNode&trGetN, Range& irng, Range& rowrng, Range& colrng, DataRange& drVM);
///end LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH

// event handlers

static int check_input(const TreeNode& trGetN);
static void load_err_msg(int nErr, const TreeNode& trGetN, string& strErrMsg);
static void update_gui_on_format_change(TreeNode& trGetN, bool bAllowAuto);

enum {
	SEL_INVALID		= 0,
	SEL_ONE_ROW		= 0x0001,
	SEL_ONE_COL		= 0x0002,	
	SEL_WHOLE_ROW	= 0x0004,
	SEL_WHOLE_COL	= 0x0008,
	SEL_SINGLE_ROW	= 0x0010,
	SEL_SINGLE_COL	= 0x0020,
};

#define	IS_WHOLE_SHEET(_SelMode)	((_SelMode & SEL_WHOLE_ROW) && (_SelMode & SEL_WHOLE_COL))

static	int	get_range_mode(Range& irng);
static int update_xyz_titles(TreeNode& trGetN);

static bool init_column_label(TreeNode& trGetN, const Worksheet& wks, bool bInit);
static bool init_dlg(TreeNode &trGetN, const Worksheet &wks);

static bool get_longname_units_format_string(Column& col, string& strLNUnits);
static bool init_xyz_titles(TreeNode& trGetN);

int wks_to_vm_event1_event_handler(TreeNode& trGetN, int nRow, int nEventID, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& DynaCntrlContainer, string& strAux, string& strErrMsg, bool & bOKEnable);

void wks_to_vm_before_execute_event_handler(TreeNode& trGetN, int nGetNDialog, int& nRet, int dwCntrl);

// other

static void update_input_range(int& r1, int& c1, int& r2, int& c2, const Datasheet& ds);

/// return 1 if success, return -1 if has empty or text data
static int is_subrng_valid_xy_array(const Datasheet &ds, int r1, int c1, int r2, int c2, bool bColumn);

#endif // WKS2VM_H
