/*------------------------------------------------------------------------------*
 * File Name: WCellGraph.h														*
 * Creation: Bill 04/02/2011													*
 * Purpose: OriginC Header H file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Bill 04/02/2011 ORG-2531 WANT_XF_TO_MODIFY_EMBED_GRAPH_PROPERTIES			*
 * Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH			*
 * Bill 10/21/2011 ORG-2531-S2 ADD_APPLY_BUTTON									*
 * Folger 11/07/2011 OPEN_XF_HELP_FOR_WCELLGRAPH								*
 *------------------------------------------------------------------------------*/

#ifndef WCELLGRAPH_H
#define WCELLGRAPH_H

#include <..\Originlab\DialogEx.h>
#define BASE_WINDOW ResizeDialog
#include <..\Originlab\DynaDlg.h>

class WCellGraphDlg : public DynaDlg
{
public:
	WCellGraphDlg();

	int DoModalEx(TreeNode& trGetN, HWND hParent = NULL);
	void UpdateEditTreeNode(TreeNode& trGetN);

protected:
	///----------------- Message Map ----------------
	EVENTS_BEGIN
		ON_GETNDLG_MSGS(IDC_TREE)
		
		ON_INIT(OnInitDialog)
		ON_READY(OnReady)
		ON_DESTROY(OnDestroy)
		ON_SIZE(OnDlgResize)

		ON_BN_CLICKED(IDC_APPLY, OnApply) /// Bill 10/21/2011 ORG-2531-S2 ADD_APPLY_BUTTON

		/// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
		ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
		ON_USER_MSG(WM_USER_MSG_ON_DLG, OnDynamicMsg)
		/// End ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
		
		///------ Folger 11/07/2011 OPEN_XF_HELP_FOR_WCELLGRAPH
		ON_HELPINFO(OnHelp)
		///------ End OPEN_XF_HELP_FOR_WCELLGRAPH
	EVENTS_END

	///------ Folger 11/07/2011 OPEN_XF_HELP_FOR_WCELLGRAPH
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus);
	///------ End OPEN_XF_HELP_FOR_WCELLGRAPH
	///----------------- Message Handler-------------
	BOOL OnInitDialog();
	BOOL OnReady();
	BOOL OnDestroy();
	BOOL OnDlgResize(int nType, int cx, int cy);
	void OnAfterValueChange(int nRow, int nCol);
	BOOL OnApply(Control ctrl); /// Bill 10/21/2011 ORG-2531-S2 ADD_APPLY_BUTTON
	
	/// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
	virtual void InvokeGlobalEventOnInitDialog();

	virtual void ResizeDlgControls()
	{
		OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
	}
	
	void CheckRange();
	/// End ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
};

class CellGraphSetting
{
public:
	void UpdateGUI(TreeNode & trGUI);
	void ConstructCntrl(TreeNode & trGUI, DWORD & dwSetCntrl, DWORD & dwClearCntrl);
	void ConstructSettings(TreeNode & trSettings); /// Bill 10/27/2011 ORG-2531-P10 SUPPORT_SCRIPT_CELL

private:
	void construct_gui_tree(TreeNode & trGUI);
	void set_control_default_value(TreeNode & trGUI, bool bUndefine, DWORD dwCntrl);
	bool is_control_value_undefine(DataRange & irng, DWORD dwCntrl);
	
	void set_gui_tree_value(DataRange & dr, TreeNode & trSetting, DWORD dwCntrl, DWORD dwBit, bool bOneCell, bool bNeg = false);
	void set_display_tree_value(DataRange & dr, TreeNode & trSetting, DWORD dwCntrl, bool bOneCell);
};

void xf_wcellgraph_body(const Range& irng, const TreeNode& settings);

/// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
int xf_wcellgraph_event1(TreeNode& trGetN, int nRow, int nEventID, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& DynaCntrlContainer, string& strAux, string& strErrMsg);
/// End ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH

void xf_wcellgraph_before_execute(TreeNode& trGetN, int nGetNDialog, int& nRet, int dwCntrl);

bool WCellGraphBox(TreeNode& trGetN, HWND hWndParent, PEVENT_GETN pfnGetN);

#endif // WCELLGRAPH_H
