/*------------------------------------------------------------------------------*
 * File Name: WCellGraph.cpp													*
 * Creation: Bill 04/02/2011													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Bill 04/02/2011 ORG-2531 WANT_XF_TO_MODIFY_EMBED_GRAPH_PROPERTIES			*
 * Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH			*
 * Bill 04/29/2011 ORG-2531-P1 DO_NOT_SHOULD_THEME_RELATE_CONTROL				*
 * Bill 08/22/2011 ORG-2531-S2 DELETE_RECALCULATE_CONTROLS						*
 * EJP 2011-10-21 ORG-3815 LOCALIZATION_FOR_86									*
 * Folger 11/07/2011 OPEN_XF_HELP_FOR_WCELLGRAPH								*
 *------------------------------------------------------------------------------*/

////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>

#include "WCellGraph.h"

enum {
	display_emf,
	display_bmp,
};

static string s_strErr; /// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH

static void _get_range_row_col(const Range & irng, int nRange, Worksheet & wks, int & r1, int & r2, int & c1, int & c2)
{
	irng.GetRange(nRange, r1, c1, r2, c2, wks);
		
	if(!wks)
		XF_THROW(XFERR_INVALID_RANGE);
}

int xf_wcellgraph_event1(TreeNode& trGetN, int nRow, int nEventID, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& DynaCntrlContainer, string& strAux, string& strErrMsg); /// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH

WCellGraphDlg::WCellGraphDlg() : DynaDlg(IDD_WCELL_GRAPH, NULL, "Odlg8", true)
{
	m_pEventNew = xf_wcellgraph_event1; /// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
}

int WCellGraphDlg::DoModalEx(TreeNode& trGetN, HWND hParent) // = NULL
{
	TreeNode tr = InitTree();
	tr.Replace(trGetN.Clone());
	
	InitMsgMap();

	return DynaDlg::DoModal(hParent);
}

void WCellGraphDlg::UpdateEditTreeNode(TreeNode& trGetN)
{
	trGetN.Replace(GetTree().Clone());
}

BOOL WCellGraphDlg::OnInitDialog()
{
	/// Bill 10/20/2011 ORG-2531-S4 CHANGE_DIALOG_TITLE
	// Text = "WCellGraph";
	Text = _L("Update Embedded Graphs"); /// EJP 2011-10-21 ORG-3815 LOCALIZATION_FOR_86, added _L()
	/// End CHANGE_DIALOG_TITLE

	DynaDlg::OnInitDialog(IDC_TREE);

	InitDynaControl(IDC_TREE);
	
	/// Bill 04/29/2011 ORG-2531-P1 DO_NOT_SHOULD_THEME_RELATE_CONTROL
	//InitThemeControls(this, GetTree(), IDC_THEME_COMB, IDC_THEME_TEXT, IDC_SAVE_BTN, IDC_SAVE_AS_BTN, IDC_PARAMS_DESCRIPTION, IDC_PARAMS_DESCRIPTION_LABEL);	
	/// End DO_NOT_SHOULD_THEME_RELATE_CONTROL
	
	GetItem(IDC_APPLY).Enable = FALSE;
			
	return TRUE;
}

BOOL WCellGraphDlg::OnReady()
{
	CheckRange(); /// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH

	UpdateDynaControl(true, GETNEVENT_ON_INIT);

	SetInitReady();
	
	return TRUE;
}

BOOL WCellGraphDlg::OnDestroy()
{
	DynaDlg::OnDestroy();
	return TRUE;
}

BOOL WCellGraphDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return TRUE;
	
	MoveControlsHelper _temp(this);
	
	DynaControl ctrl = GetItem(IDC_TREE);
	RECT rr;
	SIZE sze;
	
	/// Bill 11/03/2011 ORG-4290-P1 REFERENCE_DATA_BLANK_IS_TOO_NARROW_IN_GOS
	ctrl.GetOptimalSize(sze);	
	RECT rrDlg;
	m_wndDlg.GetWindowRect(&rrDlg);
	int nxDiff = GetControlGap() * 2 + sze.cx - RECT_WIDTH(rrDlg);
	if (nxDiff > 0)
	{		
		rrDlg.right += nxDiff;
		m_wndDlg.MoveWindow(&rrDlg);
	}
	/// End REFERENCE_DATA_BLANK_IS_TOO_NARROW_IN_GOS
	
	GetClientRect(ctrl, rr);
	
	int nEdge = GetControlGap(), nx = nEdge, ny = nEdge;
	cx = rr.right;
	cy = rr.bottom;

	/// Bill 04/29/2011 ORG-2531-P1 DO_NOT_SHOULD_THEME_RELATE_CONTROL
	//vector<uint> vnThemeSaveGroup = {IDC_THEME_TEXT, IDC_THEME_COMB, IDC_SAVE_BTN, IDC_SAVE_AS_BTN, 0};
	//ArrangeControlsLeftRight(vnThemeSaveGroup, nx, ny, cx, IDC_THEME_COMB);
	/// End DO_NOT_SHOULD_THEME_RELATE_CONTROL
	
	vector<uint> nBtns = {IDC_APPLY, IDCANCEL, IDOK, 0};
	ArrangeMainItemAndControls(nBtns, IDC_TREE, NULL, false);

	/// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
	GetClientRect(ctrl, rr);
	
	int nErrMessageHeight = GetDlgStatusMsgBoxHeight(cx - 2*nEdge);
	RECT rBtn;
	rBtn.left = rr.left;
	rBtn.right = rr.right;
	if(nErrMessageHeight)
	{
		rBtn.bottom = rr.bottom;
		rBtn.top = rBtn.bottom - nErrMessageHeight;
		rr.bottom = rBtn.top - nEdge;
		MoveControl(m_btnErrMessage, rBtn);
		m_btnErrMessage.Visible = true;
		MoveControl(ctrl, rr);
	}
	else
		m_btnErrMessage.Visible = false;
	/// End ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
	
	return TRUE;
}

/// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
void WCellGraphDlg::OnAfterValueChange(int nRow, int nCol)
{
	/// Bill 10/20/2011 ORG-2531-P3 CHECK_BOX_NOT_CHANGE
	if (nRow == 0)
	{
	/// End CHECK_BOX_NOT_CHANGE
		CheckRange();
		
		TreeNode trGetN = GetTree();
		CellGraphSetting setting;
		setting.UpdateGUI(trGetN);
		
		invokeBasicGlobalEvent(GETNE_ON_VALUE_CHANGE);
		
		UpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI);
	} /// Bill 10/20/2011 ORG-2531-P3 CHECK_BOX_NOT_CHANGE
	else
	{
		GetItem(IDC_APPLY).Enable = TRUE;
	}	
}

///------ Folger 11/07/2011 OPEN_XF_HELP_FOR_WCELLGRAPH
BOOL WCellGraphDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	LT_execute("help wcellgraph");
	return false;
}
///------ End OPEN_XF_HELP_FOR_WCELLGRAPH

void WCellGraphDlg::InvokeGlobalEventOnInitDialog()
{
	CheckRange();
	invokeBasicGlobalEvent(GETNE_ON_INIT);
}

void WCellGraphDlg::CheckRange()
{
	DataRange irng;
	TreeNode trGetN = GetTree();
	
	TreeNode trRange = trGetN.irng;
	okxf_resolve_tree_construct_range(&trRange, &irng);
	
	if (irng.GetNumRanges() == 0)
	{
		s_strErr = XFERR_SELECT_NO_CELL;		
	}
	else
	{
		s_strErr.Empty();
	}
}
/// End ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH

/// Bill 10/21/2011 ORG-2531-S2 ADD_APPLY_BUTTON
BOOL WCellGraphDlg::OnApply(Control ctrl)
{
	TreeNode trGetN = GetTree();

	Range irng;
	TreeNode trRange = trGetN.irng;
	okxf_resolve_tree_construct_range(&trRange, &irng);

	xf_wcellgraph_body(irng, trGetN.settings);

	GetItem(IDC_APPLY).Enable = false; /// Bill 10/26/2011 ORG-2531-P9 APPLY_BUTTON_SHOULD_GRAY_OUT_AFTER_CLICKED

	return true;
}
/// End ADD_APPLY_BUTTON

////////////////////////////////////////////////////////////////////////////////

void CellGraphSetting::set_gui_tree_value(DataRange & dr, TreeNode & trSetting, DWORD dwCntrl, DWORD dwBit, bool bOneCell, bool bNeg)
{
	if (octree_get_auto_support(&trSetting) == -1)
		return;
	
	bool bUndefine = is_control_value_undefine(dr, dwBit);
	
	if (!bOneCell && bUndefine)
	{
		trSetting.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, true);
	}
	else
	{
		if (!bOneCell)
			trSetting.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, false); /// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
		
		if (bNeg)
			trSetting.nVal = (dwCntrl & dwBit) ? false : true;
		else
			trSetting.nVal = (dwCntrl & dwBit) ? true : false;
	}
}

void CellGraphSetting::set_display_tree_value(DataRange & dr, TreeNode & trSetting, DWORD dwCntrl, bool bOneCell)
{
	if (octree_get_auto_support(&trSetting) == -1)
		return;
	
	bool bUndefine = is_control_value_undefine(dr, EMBEDGRAPH_USE_BITMAP_CACHE);
	
	if (!bOneCell && bUndefine)
		trSetting.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, true);
	else
	{
		if (!bOneCell)
			trSetting.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, false); /// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
		
		if (dwCntrl & EMBEDGRAPH_USE_BITMAP_CACHE)
			trSetting.nVal = display_bmp;
		else
			trSetting.nVal = display_emf;
	}
}

void CellGraphSetting::UpdateGUI(TreeNode & trGUI)
{
	if (trGUI)
	{
		/// Bill 08/22/2011 ORG-2531-S2 DELETE_RECALCULATE_CONTROLS
		TreeNode trAuto = trGUI.GetNode("AutoUpdate");	
		if (trAuto)
			trAuto.Remove();
		
		TreeNode trSep = trGUI.GetNode("Separator");
		if (trSep)
			trSep.Remove();
		/// End DELETE_RECALCULATE_CONTROLS
		
		construct_gui_tree(trGUI.settings);

		TreeNode trSettings = trGUI.settings;
		
		DataRange dr;
		TreeNode trRange = trGUI.irng;
		okxf_resolve_tree_construct_range(&trRange, &dr);
		
		if (!dr || dr.GetNumRanges() == 0)
		{
			/// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
			trSettings.display.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, true);
			trSettings.cache.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, true);
			trSettings.resizecell.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, true);
			trSettings.keepAspect.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, true);
			trSettings.axes.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, true);
			trSettings.label.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, true);
			/// End ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
			
			return;
		}
		
		/// Bill 12/31/2011 ORG-2531-P15 NON_CONTINUOUS_RANGE_SUPPORT
		//bool bOneCell = true;
		bool bOneCell = dr.GetNumRanges() == 1;
		/// End NON_CONTINUOUS_RANGE_SUPPORT
		for (int nRange = 0 ; nRange < dr.GetNumRanges() ; ++nRange)
		{
			Worksheet wks;
			int r1, r2, c1, c2;
			
			_get_range_row_col(dr, nRange, wks, r1, r2, c1, c2);
			
			if (r1 != r2 || c1 != c2)
			{
				bOneCell = false;
				break;
			}			
		}
		
		// control word of the first cell
		int r1, r2, c1, c2;		
		Worksheet wks;
		dr.GetRange(0, r1, c1, r2, c2, wks);
		DWORD dwCntrl = get_cell_embedding_or_linking_cntrl(wks, r1, c1);
		
		set_display_tree_value(dr, trSettings.display, dwCntrl, bOneCell);
		
		set_gui_tree_value(dr, trSettings.cache, dwCntrl, EMBEDGRAPH_CACHE_IN_PAGE, bOneCell);
		
		set_gui_tree_value(dr, trSettings.resizecell, dwCntrl, EMBEDGRAPH_NO_RESIZE_CELL, bOneCell, true);
		
		set_gui_tree_value(dr, trSettings.keepAspect, dwCntrl, EMBEDGRAPH_KEEP_ASPECT_RATIO, bOneCell);
		
		set_gui_tree_value(dr, trSettings.axes, dwCntrl, EMBEDGRAPH_HIDE_AXES | EMBEDGRAPH_HIDE_LEGENDS | EMBEDGRAPH_HIDE_SPECTRUMS, bOneCell);
		
		set_gui_tree_value(dr, trSettings.label, dwCntrl, EMBEDGRAPH_HIDE_TEXT_OBJS, bOneCell);
	}
}

static void _construct_bool_cntrl(TreeNode & trSetting, DWORD dwCntrl, DWORD & dwSetCntrl, DWORD & dwClearCntrl, bool bNeg = false)
{
	if (!trSetting)
		return;
	
	int nUndefine = 0;
	trSetting.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, nUndefine);
	
	if (!nUndefine)
	{
		if (bNeg)
		{
			if (trSetting.nVal)
				dwClearCntrl |= dwCntrl;
			else
				dwSetCntrl |= dwCntrl;
		}
		else
		{
			if (trSetting.nVal)
				dwSetCntrl |= dwCntrl;
			else
				dwClearCntrl |= dwCntrl;
		}
	}
}

static void _construct_display_cntrl(TreeNode & trSetting, DWORD & dwSetCntrl, DWORD & dwClearCntrl)
{
	if (!trSetting)
		return;
	
	int nUndefine = 0;
	trSetting.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, nUndefine);
	
	if (!nUndefine)
	{
		switch (trSetting.nVal)
		{
		case display_bmp:
			dwSetCntrl |= EMBEDGRAPH_USE_BITMAP_CACHE;
			break;
			
		case display_emf:
			dwClearCntrl |= EMBEDGRAPH_USE_BITMAP_CACHE;
			break;
		}
	}
}

void CellGraphSetting::ConstructCntrl(TreeNode & trSettings, DWORD & dwSetCntrl, DWORD & dwClearCntrl)
{		
	_construct_display_cntrl(trSettings.display, dwSetCntrl, dwClearCntrl);
	
	_construct_bool_cntrl(trSettings.cache, EMBEDGRAPH_CACHE_IN_PAGE, dwSetCntrl, dwClearCntrl);
	
	_construct_bool_cntrl(trSettings.resizecell, EMBEDGRAPH_NO_RESIZE_CELL, dwSetCntrl, dwClearCntrl, true);
	
	_construct_bool_cntrl(trSettings.keepAspect, EMBEDGRAPH_KEEP_ASPECT_RATIO, dwSetCntrl, dwClearCntrl);
	
	_construct_bool_cntrl(trSettings.axes, EMBEDGRAPH_HIDE_AXES | EMBEDGRAPH_HIDE_LEGENDS | EMBEDGRAPH_HIDE_SPECTRUMS, dwSetCntrl, dwClearCntrl);
	
	_construct_bool_cntrl(trSettings.label, EMBEDGRAPH_HIDE_TEXT_OBJS, dwSetCntrl, dwClearCntrl);
}

void CellGraphSetting::ConstructSettings(TreeNode & trSettings)
{
	construct_gui_tree(trSettings);
}

void CellGraphSetting::construct_gui_tree(TreeNode & trGUI)
{
	GETN_USE(trGUI); SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)
	
	/// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
	if (trGUI.GetNodeCount() > 0)
		return;
	/// End ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
	
	/// EJP 2011-10-21 ORG-3815 LOCALIZATION_FOR_86, added _L()
	GETN_LIST(display, _L("Display Caching"), 0, "Enhanced Metafile|Bitmap");

	GETN_CHECK(cache, _L("Cache In Page"), 0);

	GETN_CHECK(resizecell, _L("Resize Cell"), 0);

	GETN_CHECK(keepAspect, _L("Keep Aspect Ratio"), 0);

	GETN_CHECK(axes, _L("Hide Axes and Legend"), 0);

	GETN_CHECK(label, _L("Hide Text Labels"), 0);
	/// end LOCALIZATION_FOR_86, added _L()
}

bool CellGraphSetting::is_control_value_undefine(DataRange & irng, DWORD dwCheckCntrl)
{
	bool bFirstCellState;
	
	for (int nRange = 0 ; nRange < irng.GetNumRanges() ; ++nRange)
	{
		Worksheet wks;
		int r1, r2, c1, c2;
		
		_get_range_row_col(irng, nRange, wks, r1, r2, c1, c2);
		
		if (irng.GetNumRanges() == 1 && r1 == r2 && c1 == c2)
			break;
		
		if (nRange == 0)
		{	
			DWORD dwCntrl = get_cell_embedding_or_linking_cntrl(wks, r1, c1);
			if (dwCntrl == -1)
				return true;
			
			bFirstCellState = dwCntrl & dwCheckCntrl;
		}
		
		for (int nRow = r1 ; nRow <= r2 ; ++nRow)
		{
			for (int nCol = c1 ; nCol <= c2 ; ++nCol)
			{
				DWORD dwCntrl = get_cell_embedding_or_linking_cntrl(wks, nRow, nCol);
				bool bState = dwCntrl & dwCheckCntrl;
				if (bState != bFirstCellState)
					return true;
			}
		}
	}
	
	return false;
}

////////////////////////////////////////////////////////////////////////////////

bool WCellGraphBox(TreeNode& trGetN, HWND hWndParent, PEVENT_GETN pfnGetN)
{
	WCellGraphDlg dlg;

	int nRet = dlg.DoModalEx(trGetN, hWndParent);
	if(IDOK == nRet)
	{
		dlg.UpdateEditTreeNode(trGetN);
		return true;
	}
	
	return false;
}

void xf_wcellgraph_body(const Range& irng, const TreeNode& settings)
{
	CellGraphSetting cellSetting;
	DWORD dwSetCntrl = EMBEDGRAPH_DO_UNDO;
	DWORD dwClearCntrl = 0;
	
	cellSetting.ConstructCntrl(settings, dwSetCntrl, dwClearCntrl);

	for (int nRange = 0 ; nRange < irng.GetNumRanges() ; ++nRange)
	{
		Worksheet wks;
		int r1, r2, c1, c2;
		_get_range_row_col(irng, nRange, wks, r1, r2, c1, c2);
		
		for (int nRow = r1 ; nRow <= r2 ; ++nRow)
		{
			for (int nCol = c1 ; nCol <= c2 ; ++nCol)
			{
				if (get_cell_embedding_or_linking_cntrl(wks, nRow, nCol) == -1)
				{
					printf(_L("The cell at %d,%d does not contain embedded params.\n"), nRow + 1, nCol + 1);
				}
				else
				{
					set_cell_embedding_or_linking_cntrl(wks, nRow, nCol, dwSetCntrl, dwClearCntrl);
				}
			}
		}
	}	
}

/// Bill 04/28/2011 ORG-2531-P2 ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH
int xf_wcellgraph_event1(TreeNode& trGetN, int nRow, int nEventID, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& DynaCntrlContainer, string& strAux, string& strErrMsg)
{
	DECLARE_BUTTON_ENABLES   //support more buttons enable/disable
	
	strErrMsg = s_strErr;
	
	return true;
}
/// End ADD_ERROR_MESSAGE_BOX_FOR_XF_WCELLGRAPH

void DumpEmbedParams(Worksheet & wks, int r, int c)
{
	if( wks )
	{
		DWORD dwEmbedParams = get_cell_embedding_or_linking_cntrl(wks, r, c);
		if( dwEmbedParams != -1)
		{
			printf(_L("Cell %d %d EmbedParams == 0x%X:\n"), r + 1, c + 1, dwEmbedParams);
			/*
			if( dwEmbedParams & EMBEDGRAPH_KEEP_ASPECT_RATIO )
				out_str("EMBEDGRAPH_KEEP_ASPECT_RATIO");
			if( dwEmbedParams & EMBEDGRAPH_IN_LABELS )
				out_str("EMBEDGRAPH_IN_LABELS");
			if( dwEmbedParams & EMBEDGRAPH_HIDE_AXES )
				out_str("EMBEDGRAPH_HIDE_AXES");
			if( dwEmbedParams & EMBEDGRAPH_HIDE_LEGENDS )
				out_str("EMBEDGRAPH_HIDE_LEGENDS");
			if( dwEmbedParams & EMBEDGRAPH_HIDE_SPECTRUMS )
				out_str("EMBEDGRAPH_HIDE_SPECTRUMS");
			if( dwEmbedParams & EMBEDGRAPH_HIDE_TEXT_OBJS )
				out_str("EMBEDGRAPH_HIDE_TEXT_OBJS");
			if( dwEmbedParams & EMBEDGRAPH_CACHE_IN_PAGE )
				out_str("EMBEDGRAPH_CACHE_IN_PAGE");
			if( dwEmbedParams & EMBEDGRAPH_SPARKLINE_LARGE )
				out_str("EMBEDGRAPH_SPARKLINE_LARGE");
			if( dwEmbedParams & EMBEDGRAPH_USE_BITMAP_CACHE )
				out_str("EMBEDGRAPH_USE_BITMAP_CACHE");
			if( dwEmbedParams & EMBEDGRAPH_SPARKLINE_CLIPBOARD )
				out_str("EMBEDGRAPH_SPARKLINE_CLIPBOARD");
			if( dwEmbedParams & EMBEDGRAPH_NO_RESIZE_CELL )
				out_str("EMBEDGRAPH_NO_RESIZE_CELL");
			if( dwEmbedParams & EMBEDGRAPH_MOVE_IF_ALREADY_EMBEDDED )
				out_str("EMBEDGRAPH_MOVE_IF_ALREADY_EMBEDDED");
			if( dwEmbedParams & EMBEDGRAPH_NO_PASTE_FROM_CLIPBOARD )
				out_str("EMBEDGRAPH_NO_PASTE_FROM_CLIPBOARD");
			if( dwEmbedParams & EMBEDGRAPH_DO_UNDO )
				out_str("EMBEDGRAPH_DO_UNDO");
			*/
		}
		else
			printf(_L("The cell at %d,%d does not contain embedded params.\n"), r + 1, c + 1);
	}
	else
		out_str(_L("Active Layer is not a worksheet.")); /// EJP 2011-10-21 ORG-3815 LOCALIZATION_FOR_86, added _L()
	
	printf("\n");
}

void xf_wcellgraph_before_execute(TreeNode& trGetN, int nGetNDialog, int& nRet, int dwCntrl)
{
	if (nGetNDialog >= 0)
	{
		CellGraphSetting setting;
		setting.UpdateGUI(trGetN);
		
		/*
		DataRange irng;
		okxf_init_range_from_string(&irng, trGetN.irng.strVal);
		
		for (int nRange = 0 ; nRange < irng.GetNumRanges() ; ++nRange)
		{
			Worksheet wks;
			int r1, r2, c1, c2;
			
			_get_range_row_col(irng, nRange, wks, r1, r2, c1, c2);
			
			for (int nRow = r1 ; nRow <= r2 ; ++nRow)
			{
				for (int nCol = c1 ; nCol <= c2 ; ++nCol)
				{
					DumpEmbedParams(wks, nRow, nCol);
				}
			}
		}
		*/
	}
}

void test_wcellgraph_dlg()
{
	Tree trGUI;
	CellGraphSetting setting;

	setting.UpdateGUI(trGUI);

	WCellGraphDlg dlg;
	dlg.DoModalEx(trGUI);
}
