/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 2012-07-30 ORG-6156-S1 PROMPT_FOR_FILENAME_ON_START_OF_VIDEOBUILDER		*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include <..\OriginLab\DialogEx.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
//#define IDD_VIDEO_RECORDER              520

#include "VideoRecorder.h"

static VideoRecorderDlg* s_pVideoRecorderDlg = NULL;

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

void CloseVideoRecorderDlg()
{
	if( s_pVideoRecorderDlg )
	{
		Window wnd = s_pVideoRecorderDlg->GetWindow();
		if( wnd )
			wnd.SendMessage(WM_CLOSE);
		delete s_pVideoRecorderDlg;
		s_pVideoRecorderDlg = NULL;
	}
}

void OpenVideoRecorderDlg()
{
	CloseVideoRecorderDlg();
	s_pVideoRecorderDlg = new VideoRecorderDlg();
	if( s_pVideoRecorderDlg )
	{
		/// EJP 2012-07-30 ORG-6156-S1 PROMPT_FOR_FILENAME_ON_START_OF_VIDEOBUILDER
		if( !s_pVideoRecorderDlg->DoSaveVideoAsDialog() )
			CloseVideoRecorderDlg();
		else
		/// end PROMPT_FOR_FILENAME_ON_START_OF_VIDEOBUILDER
		s_pVideoRecorderDlg->Create(GetWindow(OGW_MDICLIENT));
	}
}
