 /*-------------------------------------------------------------------------------------*
 * File Name: VerticalCursorManager.h													*
 * Creation: Kenny 05/08/2009															*
 * Purpose: OriginC Source file															*
 * Copyright (c) OriginLab Corp. 2009													*
 * All Rights Reserved																	*
 *																						*
 * Modification Log:																	*
 * Iris 6/16/2009 CHANGE_SAVE_SOURCE_COLUMN_UID_IN_STORAGE_REPLACE_PLOT_UID				*
 * Kenny 06/16/2009 ALLOW_DELETING_TAG_AND_TAG_LABEL_AFTER_DLG_IS_CLOSED				*
 * Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE							*
 * Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER											*
 *	Folger 01/20/10 VERTICAL_CURSOR_WKS_OUTPUT_SUPPORT_RANGE_NOTATION					*
 *	Folger 01/20/10 SUPPORT_SAVING_VERTICAL_CURSOR_SETTINGS_IN_PAGE						*
 * Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT												* 
 * Jasmine 01/20/10 SHOW_NEAREST_POINT													*
 *	Folger 01/21/09 VERTICAL_CURSOR_CRASH_ORIGIN_IF_ACCESS_ARRAY_MEMBER_OF_MANAGER_OBJECT_DIRECTLY
 * Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS											*
 *	Folger 01/22/09 ORIGIN_CRASH_WHEN_EXIT_IF_GRAPH_PAGE_HAS_VERTICAL_CURSOR_IS_NOT_ACTIVE
 * Jasmine 01/22/10 OUTPUT_WKS_XCOL_LNAME_USE_AXIS_TITLE								*
 *	Folger 01/22/10 CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE					*
 * Jasmine 01/23/10 USE_RELATED_DS_IS_MORE_RELIABLE										*
 * Jasmine 01/23/10 FIRST_EMPTY_COL_IS_NOT_DELETED_OR_USED								*
 * Jasmine 01/26/10 COLUMNS_IN_ONE_WKS_HAVE_SAME_LONNG_NAME_NEED_SHORT_NAME_TO_DISDINGUISH
 *	Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT											*
 * Jasmine 01/26/10 UPDATE_CURSOR_POSITION_ON_SCALE_CHANGE								*
 * Jasmine 01/26/10 OUTPUT_X_COLUMN_NEED_MORE_INFO										*
 *	Folger 01/27/10 VERTICAL_CURSOR_SNAP_TO_NEAREST_X_DATA								*
 * Jasmine 01/27/10 MATCH_EXIST_COL_TO_CONSOLIDATE										*
 * Jasmine 01/27/10 EASWAR_SAY_X_BOOK_SHEET_MEANINGLESS									*
 * Jasmine 01/28/10 RESTRICT_X_EDIT_TEXT												*
 *	Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG								*
 * Jasmine 02/08/10 HOLDER_INVALID_WHEN_ACTIVE_PAGE_NOT_GRAPH							*
 * Jasmine07/08/2011 ORG-3106-P4 HIDDEN_PLOT_SHOULD_NOT_IN_LIST							*
 * Jasmine 07/11/2011 ORG-3106-S1 WRONG_LOGIC_CODE_MAKE_MISTAKE							*
 * Jasmine 07/18/2011 ORG-3106-S3-4 KEEP_COL_ORDER_IN_PAGE								*
 * Jasmine 07/20/2011 ORG-3106-S4-1 FIX_DIGIT_SETTING_NOT_APPLY_TO_LABEL				*
 * Jasmine 07/21/2011 ORG-3106-S8 DUMP_LABEL_AND_LINE_ON_GRAPH							*
 * Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG							*
 * Jasmine 08/01/2011 ORG-3106-P6 FIX_REUSE_SAME_COL_BUG								*
 * Sophy 9/20/2011 ORG-3843-P1 PROPER_LOAD_SETTINGS_WHEN_OPEN_OGG 						*
 * Sophy 9/22/2011 ORG-3843-P2 RUNTIME_ERROR_WHEN_SHOW_HIDDEN_PLOT_FROM_PLOTDETAILS_DLG	*
 * Sophy 9/27/2011 ORG-3106-S16 PROPER_FILTER_LAYER_FOR_VERTICAL_INTERSECT_CALC			*
 *	Kenny 12/06/2011 ORG-4042-P6 VERTICAL_CURSOR_GRAPH_REFRESH_BUG_WHEN_BMP_CACHE_ENABLED*
 * Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR								*
 * Jasmine 03/15/2012 ORG-4971 LINK_CURRENT_GADGET_TO_OTHER_GRAPHS						*
 * Jasmine 03/16/2012 ORG-4971 RETRIEVE_CURSOR_VALUE_FROM_LINKED_GRAPHS					*
 * Jasmine 03/22/2012 ORG-4971 DUMP_TAG_AND_LABEL_TO_LINKED_GRAPHS						*
 * Jasmine 05/03/2012 ORG-4971-P1 LINK_GRAPHS_SHOULD_HAVE_ITS_OWN_LAYER_FILTER			*
 * Jasmine 05/14/2012 ORG-4971-P4 SHOULD_NOT_USE_PARENT_GRAPH_PAGE_COORD				*
 * Jasmine 05/2202012 ORG-4917-P2 UPDATE_LINK_GRAPH_LABEL_FONT_SIZE						*
 * Jasmine 05/30/2012 ORG-4971-P2 UPDATE_PAGE_ALL_LABELS_FONT_SIZE_TO_SPEED_UP			*
 *	Zech 03/31/2012 ORG-4284-P3 DO_NOT_SHOW_SPARKLINE_IN_GRAPH_BROWSER					*
 * Jasmine 06/21/2012 ORG-4971-P7 LINK_GRAPH_LABELS_ARE_MIXED							*
 *	Folger 07/30/2012 ORG-6340-P1 ORIGIN_CRASH_WHEN_ADD_VERTICAL_CURSOR_TO_LINKED_GRAPH	*
 *	Folger 08/03/2012 ORG-6409-S1 VERTICAL_CURSOR_USAGE_IMPROVEMENT						*
 * Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT				*
 * Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT							*
 *	Folger 08/10/2012 ORG-6381-S3 VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM			*
 *	Folger 08/14/2012 ORG-6381-S1 DATAPLOT_GETDATAPOINT_SUPPORT_NO_Y_OFFSET				*
 *	Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS		*
 *	Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT								*
 *	 Folger 08/21/2012 ORG-4971-S7 VERTICAL_CURSOR_SHOULD_LINKED_GRAPHS_NUM_ON_TITLE	*
 *	Folger 08/21/2012 ORG-4971-S6 LINK_TAGS_ON_LINKED_GRAPHS							*
 *	Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS				*
 *	Folger 08/20/2012 ORG-4971-P8 INCORRECT_SIGNIFICANT_DIGITS_SHOWN_AFTER_APPLY_OPTIONS_IN_VERTICAL_CURSOR
 *	Folger 08/24/2012 ORG-6633-P1 REMOE_PAGE_FROM_VERTICAL_CURSOR_WHEN_PAGE_DESTROY_BUT_NOT_WINDOW_DESTROY
 *	Jasmine 08/30/2012 ORG-6634-P1 PLOTS_ORDER_SHOULD_NOT_SAVE_INI_FOR_OTHER_GRAPHS_TO_LOAD
 *	Folger 08/31/2012 ORG-6681-P1 GLOBAL_GADGET_MANAGER_SERIALIZATION					*
 *	Jasmine 09/03/2012 ORG-4971-P3 KEEP_PLOT_STATUS_AFTER_LINK_GRAPH					*
 *	Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER						*
 *	Folger 09/10/2012 ORG-6763-S1 VECTICAL_CURSOR_SPAN_ALL_LAYERS_SUPPORT				*
 *	Folger 09/20/2012 ORG-6761-S1 HIDE_LINE_WHEN_IT_OUTSIDE_OF_PAGE						*
 *	Folger 09/29/2012 ORG-6857-P1 BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR			*
 *--------------------------------------------------------------------------------------*/

#ifndef __VERTICAL_CURSOR_MANAGER_H__
#define __VERTICAL_CURSOR_MANAGER_H__

#include "VGraphObj.h"
#include "INIFileEx.h"
#include <xfutils.h>								///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT
#include <..\Originlab\GraphFilter.h> 				///Jasmine 03/15/2012 ORG-4971 LINK_CURRENT_GADGET_TO_OTHER_GRAPHS
///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
#include <..\Originlab\WksColLabels.h>
#define	E_STR_SHORT_NAME			"Short Name"
#define E_STR_PLOT_NAME				"Plot Name"
#define E_STR_DATASET				"Dataset"
///End MORE_CONFIGURATION_FOR_INFO_TABLE

/*----------------------------------------------------------------------------*/
/* Class Diagram
/*----------------------------------------------------------------------------*/

/*
  +----------------------+
  |GraphVerticalCursorDlg|
  +-----------#----------+
              |
              |
              |
 +------------#-------------+
 |GraphVerticalCursorManager|
 +--------------------------+
 |      AddTags()           |        +---------------------------+
 |    ClearAllTags()        *........* GraphVerticalCursorHolder |
 |   ShowTextLabels()       |        +--------------+------------+
 |   SetLinePosition()      |                       |
 |         ...              |                       |
 +--------------------------+                       |
                                     +--------------+---------------+
                                     |              |               |
                                +----+----+   +-----+----+    +-----+----+
                                | VTagUnit|   |VTextLabel|    |VGraphLine|
                                +----+----+   +----------+    +----------+
                                     |
                               +-----+--------+
                               |              |
                             +-+--+      +----+----+
                             |VTag|      |VTagLabel|
                             +----+      +---------+
*/

#define THE_VCURSOR_MANAGER								get_graph_vertical_cursor_manager()

/// Iris Origin default template is enough
//#define STR_OUTPUT_WKS_TEMPL							"VerticalCursorOutput"
#define STR_OUTPUT_WKS_TEMPL							"Origin"
///End
///------ Folger 01/20/10 VERTICAL_CURSOR_WKS_OUTPUT_SUPPORT_RANGE_NOTATION
//#define STR_DEFAULT_OUTPUT_WKS_NAME						"Cursor"
///Sophy 8/8/2011 ORG-3106-S6 ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
//#define STR_DEFAULT_OUTPUT_WKS_NAME						"[Cursor]Result"
#define STR_DEFAULT_OUTPUT_WKS_NAME						"[Cursor]%H"
///end ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
///------ End VERTICAL_CURSOR_WKS_OUTPUT_SUPPORT_RANGE_NOTATION

/*----------------------------------------------------------------------------*/

#define STR_OBJ_TAG_NAME_VMANAGER						"VManager"

#define STR_OBJ_TAG_NAME_VHOLDERS						"VHolders"
#define STR_OBJ_TAG_NAME_VHOLDER_PREFIX					"VHolder"

#define STR_OBJ_TAG_NAME_VHOLDER_SETTINGS				"VHolderSettings"

#define STR_OBJ_TAG_NAME_VLINE							STR_VERTICAL_CURSOR_OBJ_NAME

#define STR_OBJ_TAG_NAME_VTEXT_LABELS					"VTextLabels"
#define STR_OBJ_TAG_NAME_VTEXT_LABEL_PREFIX				"VTextLabel"

#define STR_OBJ_TAG_NAME_VTAG_UNITS						"VTagUnits"
#define STR_OBJ_TAG_NAME_VTAG_UNIT_PREFIX				"VTagUnit"

#define STR_OBJ_TAG_NAME_VTAG							"VTag"
#define STR_OBJ_TAG_NAME_VTAG_LABEL						"VTagLabel"

#define STR_OBJ_DELIMITER								"_"

#define STR_OBJ_EVENT_LT_SCRIPT_FORMAT					"run.section(graph_controls, VertCursor, %%1 %d);"

///Jasmine 01/27/10 MATCH_EXIST_COL_TO_CONSOLIDATE
#define	LABEL_NAME								_L("Name")	///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
#define LABEL_SHORT_NAME						_L("Short Name")
#define LABEL_SHEET_NAME						_L("Sheet")
#define LABEL_BOOK_NAME							_L("Book")
#define LABEL_GRAPH_NAME						_L("Graph")	///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
///End MATCH_EXIST_COL_TO_CONSOLIDATE
///Jasmine 01/18/10 SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME
struct PlotInfo
{
	string book;
	string sheet;
	string colname;
	string collongname;
	string graph;			///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
};
///End SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME
///Jasmine 01/26/10 OUTPUT_X_COLUMN_NEED_MORE_INFO
struct XInfo
{
	PlotInfo	plotinfo;
	uint		plotuid;
	///Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT
	string 		custom;
	int 		format;	
	int 		display;
	///End SHOW_XVALUE_WITH_FORMAT	
};
///End OUTPUT_X_COLUMN_NEED_MORE_INFO
class VIntersectPoint
{
public:
	FPOINT		fpPoint;
	FPOINT		fpNearPoint;///Jasmine 01/20/10 SHOW_NEAREST_POINT
	PlotInfo 	plotinfo;	///Jasmine 01/18/10 SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME
	XInfo		xinfo;		///Jasmine 01/26/10 OUTPUT_X_COLUMN_NEED_MORE_INFO
	int			layerYPos;	///Jasmine 01/15/10 REORDER_CURSOR_VALUE_BY_LAYER_POS
	int 		layer;
	int 		plot;
	int 		index;		///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE	
	uint		plotuid;
	///------ Folger 08/03/2012 ORG-6409-S1 VERTICAL_CURSOR_USAGE_IMPROVEMENT
	bool		bActive;
	///------ End VERTICAL_CURSOR_USAGE_IMPROVEMENT

	///------ Folger 09/29/2012 ORG-6857-P1 BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR
	BOOL		IsXDateTime() { return IsXDate() || IsXTime(); }
	BOOL		IsXDate() { return xinfo.format == OULABEL_DATE && IsValidDateTimeX(); }
	BOOL		IsXTime() { return xinfo.format == OULABEL_TIME && IsValidDateTimeX(); }

private:
	BOOL IsValidDateTimeX()
	{
		SYSTEMTIME stTime;
		return JulianDateToSystemTime(&fpPoint.x, &stTime);
	}
	///------ End BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR
};

static int _check_add_dataset_indentifier_label(Worksheet& wks, LPCSTR lpcszLabel, bool bAdd)
{
	if(!wks)
		return -1;
	Grid grid;   
	if( !grid.Attach(wks) )
		return -2;
	
	vector<string> vsLabelNames;
	grid.GetUserDefinedLabelNames(vsLabelNames);
	
	int nSize 	= vsLabelNames.GetSize();	
	int nIndex = -1;
	bool bExist = false;
	
	if(nSize > 0)
	{
		nIndex = vsLabelNames.Find(lpcszLabel);
		bExist = (nIndex >= 0);
	}
	
	if(!bExist)
	{
		if(!bAdd)
			return -1;
		
		nIndex = nSize;
		vsLabelNames.Add(lpcszLabel);
		if( !grid.SetUserDefinedLabelNames(vsLabelNames) )
			return -1;
	}
	
	nIndex += RCLT_UDL;
	if( !wks.IsLabelTypeShown(nIndex) )
		wks.CheckAddLabelByType(nIndex);
	
	return nIndex;
}

///Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT
string _convert_double_to_date_time_str(const XInfo& xinfo, double dd)
{
	string strFormat, strOut;
	
	switch(xinfo.format)
	{
	///------ Folger 09/29/2012 ORG-6857-P1 BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR
	//case OULABEL_TIME://OKCOLTYPE_TIME:	///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
		//strFormat.Format("T%d", xinfo.display);
		//break;
	//case OULABEL_DATE://OKCOLTYPE_DATE:	///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
		//if(xinfo.display == LDF_OBJ_CUSTOM)
		//{
			//char szDateOut[MAXLINE];
			//if( date_to_str_custom(dd, xinfo.custom, szDateOut) )
				//strOut = szDateOut;
			//
    	//}
    	//else
    		//strFormat.Format("D%d", xinfo.display);
    case OULABEL_TIME:
    case OULABEL_DATE:
		strOut.Format("$(%f, x)", dd);
		okutil_arg_copy(strOut);
	///------ End BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR
		break;
	}
	
	if( !strFormat.IsEmpty() )
		strOut = ftoa(dd, strFormat);
	
	return strOut;
}

double _convert_date_time_str_to_double(const XInfo& xinfo, LPCSTR lpcsz)
{
	double dd = NANUM;

	///------ Folger 09/29/2012 ORG-6857-P1 BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR
	GraphLayer gl = Project.ActiveLayer();
	if ( gl )
	{
		string strFormat;
		int nn = gl.GetDateTimeHigherPrecisionDisplayFormat(strFormat, "X");
		switch ( nn )
		{
		case OULABEL_TIME:
			str_to_time_custom(lpcsz, strFormat, &dd);
			break;

		case OULABEL_DATE:
			str_to_date_custom(lpcsz, strFormat, &dd);
			break;

		default:
			ASSERT(FALSE);
			break;
		}
	}
	else
	///------ End BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR
	{
		switch(xinfo.format)
		{
		case OULABEL_TIME://OKCOLTYPE_TIME:	///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
			dd = str_to_time(lpcsz);
			break;
		case OULABEL_DATE://OKCOLTYPE_DATE:	///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
			if(xinfo.display == LDF_OBJ_CUSTOM)
				str_to_date_custom(lpcsz, xinfo.custom, &dd);
			else
				dd = str_to_date(lpcsz, xinfo.display);
			break;
		}
	}
	
	return dd;
}

bool _set_col_format(const XInfo& xinfo, Column& col)
{
	if(!col)
		return false;
	///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
	switch(xinfo.format)
	{
	case OULABEL_TIME://OKCOLTYPE_TIME:
	case OULABEL_DATE://OKCOLTYPE_DATE:
	case OULABEL_MONTH://OKCOLTYPE_MONTH:
	case OULABEL_DAYOFWEEK://OKCOLTYPE_WEEKDAY:
		break;
	default:
		return false;
	}
	
	//if( OKCOLTYPE_DATE == xinfo.format && LDF_OBJ_CUSTOM == xinfo.display && !xinfo.custom.IsEmpty() )
	if( OULABEL_DATE == xinfo.format && LDF_OBJ_CUSTOM == xinfo.display && !xinfo.custom.IsEmpty() )
		col.SetCustomDisplay(xinfo.custom);
	///End LABEL_FOLLOW_AXIS_FORMAT
	col.SetFormat(xinfo.format, xinfo.display);
	
	return true;
}
///End SHOW_XVALUE_WITH_FORMAT

///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
//"x" - "<auto>"
string _cvt_auto_format_display_str(LPCSTR lpczDisp, bool bToGUI, bool bX)
{
	string str(lpczDisp);
	if(bToGUI)
	{
		if(str.CompareNoCase("x") == 0 || str.CompareNoCase("y") == 0)
			str = STR_AUTO;
	}
	else
	{
		if(str.Compare(STR_AUTO) == 0)
			str = bX? "x" : "y";
	}
	
	return str;
}

string _cvt_double_to_str_with_display_setting(double dd, LPCSTR lplczDisp, LPCSTR lpczLayerRange)
{
	string strRet;
	strRet.Format("$(%s, %s)", ftoa(dd), lplczDisp);
	if(lstrlen(lpczLayerRange) > 0)
		int nRet = okutil_arg_copy(&strRet, lpczLayerRange);
	else
		strRet =  ftoa(dd);
	return strRet;
}
///End SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS

/*----------------------------------------------------------------------------*/
/* DumpDataHelper
/*----------------------------------------------------------------------------*/
#define OUTPUT_WKS_X_COL_IND		0

///Jasmine 01/23/10 USE_RELATED_DS_IS_MORE_RELIABLE
#define STR_DP_OUTPUT_Y_RELATED_DATASET				"YValue"
#define STR_DP_OUTPUT_NEAREST_X_RELATED_DATASET		"NearestXValue"
#define STR_DP_OUTPUT_NEAREST_Y_RELATED_DATASET		"NearestYValue"
///End USE_RELATED_DS_IS_MORE_RELIABLE

struct VCursorShow;	///Jasmine 01/18/10 SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME 

class DumpDataHelper
{
public:
	DumpDataHelper(string& strWksName)
	{
		InitOutputWorksheet(strWksName);
	}
	
public:
	BOOL Dump(const vector& vXScale, const vector& vYScale, const vector<UINT>& vuPlotUID, 
	//const vector& vNearestX = NULL, const vector& vNearestY = NULL,		///Jasmine 01/25/10 SHOW_NEAREST_POINT_IN_DLG_BUT_NOT_OUTPUT
	const VCursorShow& cursorshow = NULL,									///Jasmine 01/18/10 SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME  
	const XInfo& xinfo = NULL) 												///Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT
	{
		if(!m_wks)
			return error_report("no worksheet");
		
		bool bRet = dump(vXScale, vYScale, vuPlotUID, 
						//vNearestX, vNearestY, 	///Jasmine 01/25/10 SHOW_NEAREST_POINT_IN_DLG_BUT_NOT_OUTPUT
						cursorshow,
						xinfo);		
		
		return bRet;
	}	
	///Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS	
	BOOL ActivateOutputWks()
	{
		if(m_wks)
			return set_active_layer(m_wks);
		return FALSE;
	}
	///End BTN_TO_ACTIVATE_OUTPUT_WKS
protected:
	///Sophy 8/8/2011 ORG-3106-S6 ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
	//BOOL InitOutputWorksheet(string& strWksName)
	BOOL InitOutputWorksheet(string strWksName)
	///end ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
	{
		ASSERT( !strWksName.IsEmpty() );
		if (strWksName.IsEmpty())
			strWksName = STR_DEFAULT_OUTPUT_WKS_NAME;

		///------ Folger 01/20/10 VERTICAL_CURSOR_WKS_OUTPUT_SUPPORT_RANGE_NOTATION
		//Worksheet wksOutput(strWksName);
		//if( !wksOutput )
		//{
			//BOOL bCreated = wksOutput.Create(STR_OUTPUT_WKS_TEMPL);
			//ASSERT(bCreated);
			
			//wksOutput.GetPage().Rename(strWksName);
			//strWksName = wksOutput.GetPage().GetName(); // page name will be auto changed when rename
			//wksOutput.SetSize(-1, 0);
		//}
		///Sophy 8/8/2011 ORG-3106-S6 ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
		okutil_arg_copy(&strWksName);
		///end ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
		Worksheet wksOutput;
		if ( !attach_or_create_sheet(wksOutput, strWksName, CREATE_HIDDEN | CREATE_LOAD_1ST_LAYER_ONLY) )
			return FALSE;
		///------ End VERTICAL_CURSOR_WKS_OUTPUT_SUPPORT_RANGE_NOTATION

		if(!wksOutput)
			return error_report("no worksheet");

		m_strOutWksName = strWksName;
		m_wks = wksOutput;
		
		return TRUE;
	}
private:
	BOOL	dump(const vector& vXScale, const vector& vYScale, const vector<UINT>& vuPlotUID, 
				//const vector& vNearestX = NULL, const vector& vNearestY = NULL,	///Jasmine 01/25/10 SHOW_NEAREST_POINT_IN_DLG_BUT_NOT_OUTPUT
				const VCursorShow& cursorshow = NULL,								///Jasmine 01/18/10 SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME  
				const XInfo& xinfo = NULL) 											///Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT
	{
		if( vXScale.GetSize() != vYScale.GetSize() || vXScale.GetSize() != vuPlotUID.GetSize() )
			return false;	
		
		//1. prepare labels
		///Jasmine 01/18/10 SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME
		int nBookLabel 	= cursorshow.BookName? 	_check_add_dataset_indentifier_label(m_wks, LABEL_BOOK_NAME, 	true) : -1;
		int nSheetLabel = cursorshow.SheetName? _check_add_dataset_indentifier_label(m_wks, LABEL_SHEET_NAME, 	true) : -1;
		///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
		//int nShortNameLabel = cursorshow.ShortName? _check_add_dataset_indentifier_label(m_wks, LABEL_SHORT_NAME, true) : -1;
		int nNameLabel	= cursorshow.Name? 		_check_add_dataset_indentifier_label(m_wks, LABEL_NAME, 		true) : -1;
		///end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
		int nLongName 	= -1;
		///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
		//if(cursorshow.LongName)
		if ( cursorshow.Name )
		///end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
		{
			nLongName 	= RCLT_LONG_NAME;
			if( !m_wks.IsLabelTypeShown(nLongName) )
				m_wks.CheckAddLabelByType(nLongName);
		}
		
		int nGraphLabel	= cursorshow.GraphName? _check_add_dataset_indentifier_label(m_wks, LABEL_GRAPH_NAME, 	true) : -1;		///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
		
		///End SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME
		
		///Jasmine 01/25/10 SHOW_NEAREST_POINT_IN_DLG_BUT_NOT_OUTPUT
		//if( (vNearestX && vNearestX.GetSize() > 0) || (vNearestY && vNearestY.GetSize() > 0) )
		//{
			//nLongName = RCLT_COMMENT;
			//if( !m_wks.IsLabelTypeShown(nLongName) )
				//m_wks.CheckAddLabelByType(nLongName);
		//}
		///End SHOW_NEAREST_POINT_IN_DLG_BUT_NOT_OUTPUT
			
		//2. prepare X column
		Column colX;		
		if( !getXColumn(colX) )
			return error_report("Dump help: fail to get X column");	
		if(true)
		{
			vector<int>		vnLabelTypes;
			vector<string> 	vsLabels;
			if( getColumnLabelsFromDataPlot(xinfo.plotuid, vnLabelTypes, vsLabels, true) )
			{
				for(int nn = 0; nn < vsLabels.GetSize(); nn++)
				{
					if(RCLT_LONG_NAME == vnLabelTypes[nn])	///Jasmine 01/18/10 CONFIGURE_SHOW_HIDE_SETTING
						continue;
					colX.SetExtendedLabel(vsLabels[nn], vnLabelTypes[nn]);
				}
			}
		}
		///Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT				
		if(xinfo)
		{
			_set_col_format(xinfo, colX);
		///End SHOW_XVALUE_WITH_FORMAT
			///Jasmine 01/26/10 OUTPUT_X_COLUMN_NEED_MORE_INFO
			///Jasmine 01/27/10 EASWAR_SAY_X_BOOK_SHEET_MEANINGLESS
			//if(nBookLabel > -1)
				//colX.SetExtendedLabel(xinfo.plotinfo.book, nBookLabel);
			//if(nSheetLabel > -1)
				//colX.SetExtendedLabel(xinfo.plotinfo.sheet, nSheetLabel);
			///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
			//if(nShortNameLabel > -1)
			///	colX.SetExtendedLabel(xinfo.plotinfo.colname, nShortNameLabel);
			//if(nLongName > -1)
			//	colX.SetExtendedLabel(xinfo.plotinfo.collongname, nLongName);
			if ( nNameLabel > -1 )
			{
				string strName = xinfo.plotinfo.collongname;
				if ( strName.IsEmpty() )
					strName = xinfo.plotinfo.colname;
				colX.SetExtendedLabel(strName, nNameLabel);
			}
			///end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
			if( m_wks.IsLabelTypeShown(RCLT_COMMENT) || m_wks.CheckAddLabelByType(RCLT_COMMENT) != -1)
				colX.SetExtendedLabel(_L("Cursor Location"), RCLT_COMMENT);
			///End EASWAR_SAY_X_BOOK_SHEET_MEANINGLESS
			///End OUTPUT_X_COLUMN_NEED_MORE_INFO
		}
	
		
		//3. fill data
		// get the index of last row to append now rows
		int 	iR1, iR2;
		m_wks.GetBounds(iR1, 0, iR2, -1);
		int 	nRow = iR2 + 1;
		
		int nBegin = 0, nEnd = -1;
		while( findNextGroup(vXScale, nBegin, nEnd) ) // append one row of xyyyy
		{			
			setColData(colX, vXScale[nBegin], nRow);
			
			for(int ii = nBegin; ii <= nEnd; ii++)
			{
				Column 	colY;								
				bool bRet = checkGetColumn(colY, vuPlotUID[ii], STR_DP_OUTPUT_Y_RELATED_DATASET, NULL,
												true,
												nBookLabel, nSheetLabel, nNameLabel, nLongName,		///Jasmine 01/18/10 SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME
												nGraphLabel);										///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
				if(!bRet)
					error_report("Dump help: fail to get Y column");	
				bRet = setColData(colY, vYScale[ii], nRow); 
				ASSERT( bRet );
				
				///Jasmine 01/25/10 SHOW_NEAREST_POINT_IN_DLG_BUT_NOT_OUTPUT
				//if(vNearestX)
				//{
					//Column colNearestX;
					//if( !checkGetColumn(colNearestX, vuPlotUID[ii], STR_DP_OUTPUT_NEAREST_X_RELATED_DATASET) )
						//error_report("Dump help: fail to get NearestX column");					
					//bRet = setColData(colNearestX, vNearestX[ii], nRow); 
					//ASSERT(bRet);
					//colNearestX.SetExtendedLabel("Nearest X", RCLT_COMMENT);
				//}
				//if(vNearestY)
				//{
					//Column colNearestY;
					//if( !checkGetColumn(colNearestY, vuPlotUID[ii], STR_DP_OUTPUT_NEAREST_Y_RELATED_DATASET) )
						//error_report("Dump help: fail to get NearestY column");					
					//bRet = setColData(colNearestY, vNearestY[ii], nRow); 
					//ASSERT(bRet);
					//colNearestY.SetExtendedLabel("Nearest Y", RCLT_COMMENT);
				//}
				///End SHOW_NEAREST_POINT_IN_DLG_BUT_NOT_OUTPUT
			}
			nRow++;
			nBegin = nEnd + 1;
		}
		
		if(	nBookLabel > -1 || nSheetLabel > -1 || nNameLabel > -1 || nLongName > -1
			|| nGraphLabel > -1)	///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
		{
			autosize_rowcol(m_wks, 1.5, 25, -1, -1, AS_NOHEIGHT|AS_INVALIDATE, 
						0, 0, 0, 0, 0, NULL, false, true);
		}
		
		return TRUE;
	}	
	
	BOOL	findNextGroup(const vector& vXScale, int& nBegin, int& nEnd)
	{
		if( nBegin >= vXScale.GetSize() )
			return FALSE;
		
		vector<string> 	vs;
		convert_double_vector_to_string_vector(vXScale, vs, vXScale.GetSize());
		
		vector<int> 	vnMapIndices;
		vector<uint> 	vnR1s;
		vs.FindDuplicates(vnMapIndices, vnR1s);
		
		for(int ii=nBegin+1; ii< vnMapIndices.GetSize(); ii++)
		{
			if( vnMapIndices[nBegin] == -1 || vnMapIndices[ii] == -1 )// -1 means no duplication 
				break;
			
			if( vnMapIndices[nBegin] != vnMapIndices[ii] )
				break;
		}		
		nEnd = ii-1;
		return TRUE;
	}
	
	BOOL	setColData(Column& col, double& dData, int nRow)
	{
		if( !col )
			return FALSE;
		
		return m_wks.SetCell(nRow, col.GetIndex(), dData);		
	}
	
	BOOL	getXColumn(Column& colX)
	{
		if( m_wks.GetNumCols() == 0 )
		{
			int nn = m_wks.AddCol();
			if(nn < OUTPUT_WKS_X_COL_IND)
				return false;
			m_wks.Columns(nn).SetType(OKDATAOBJ_DESIGNATION_X);
		}
		
		const int nXCol = OUTPUT_WKS_X_COL_IND;
		colX = m_wks.Columns(nXCol);
		return colX.IsValid();
	}
	
	///Jasmine 01/23/10 USE_RELATED_DS_IS_MORE_RELIABLE	
	string _make_related_dataset_name(LPCSTR lpcszPrefix, int nn)
	{
		string strRelatedName(lpcszPrefix);
		if(nn > 0)
			strRelatedName += (string)nn;
		return strRelatedName;
	}
	///End USE_RELATED_DS_IS_MORE_RELIABLE

	///Jasmine 01/20/10 SHOW_NEAREST_POINT
	// get Y column with PlotUID, if not found will create a new column
	//BOOL	checkGetYColumn(Column& colY, UINT uPlotUID, bool* pNewCreated = NULL)
	BOOL	checkGetColumn(	Column& colY, UINT uPlotUID, LPCSTR lpcszDataset, bool* pNewCreated = NULL,
							bool bCopySrcColLabel = false, 
							int nBookLabel = -1, int nSheetLabel = -1, int nShortNameLabel = -1, int nLongName = -1, ///Jasmine 01/18/10 SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME
							int nGraphLabel = -1)		///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
	///End SHOW_NEAREST_POINT
	{
		colY.Detach();
		
		bool bNewCreated = false;
		///Jasmine 01/23/10 USE_RELATED_DS_IS_MORE_RELIABLE
		DataPlot dp;
		dp = (DataPlot)Project.GetObject(uPlotUID);
		if(!dp)
			return FALSE;
		
		int nDsCount;
		vector<string> vsDatasets;
		if(dp.GetRelatedDatasetNames(vsDatasets) > 0)
			nDsCount = get_list_enum_number(vsDatasets, lpcszDataset);
			
		if(nDsCount > 0)
		{
			for(int ii = 0; ii < nDsCount; ii++)
			{
				string strRelatedName = _make_related_dataset_name(lpcszDataset, ii);
				DatasetObject dsYValue;
				if( dp.GetRelatedDataset(strRelatedName, dsYValue) && dsYValue )
				{
					string strRange;
					dsYValue.GetRangeString(strRange, NTYPE_FOR_RANGE);///Jasmine 01/26/10 COLUMNS_IN_ONE_WKS_HAVE_SAME_LONNG_NAME_NEED_SHORT_NAME_TO_DISDINGUISH
					
					DataRange drYValue;
					drYValue.Add("Range1", strRange);
					
					Worksheet wks;
					int c1,c2;
					drYValue.GetRange(wks, c1, c2);
					if( is_same_layer(wks, m_wks) )
					{
						ASSERT(c1==c2); // only one column		
						Column col = m_wks.Columns(c1);
						colY = col;
						break;
					}
				}
			}
		}
		///End USE_RELATED_DS_IS_MORE_RELIABLE
		
		string strBook, strSheet, strCol, strLongname;
		string strGraph;					///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
		_get_notaion_by_type(	dp, false, strBook, strSheet, strCol, strLongname,
								strGraph);	///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
		
		if( !colY )
		{
			checkAddColumn(	m_wks, colY, strBook, strSheet, strCol, strLongname, 
							uPlotUID);	///Jasmine 08/01/2011 ORG-3106-P6 FIX_REUSE_SAME_COL_BUG
			if( colY )
			{
				bNewCreated = true;
				///Jasmine 01/23/10 USE_RELATED_DS_IS_MORE_RELIABLE
				string strRelatedName = _make_related_dataset_name(lpcszDataset, nDsCount);
				DatasetObject dsYValueNew(colY);
				dp.SetRelatedDataset(strRelatedName, dsYValueNew);
				///End USE_RELATED_DS_IS_MORE_RELIABLE				
			}
		}
		
		if( NULL != pNewCreated )
			*pNewCreated = bNewCreated;
		
		if(!colY)
			return false;
		
		if(bCopySrcColLabel)
		{
			vector<int>		vnLabelTypes;
			vector<string> 	vsLabels;
			if( getColumnLabelsFromDataPlot(uPlotUID, vnLabelTypes, vsLabels, false) )
			{
				for(int nn = 0; nn < vsLabels.GetSize(); nn++)
				{
					if(RCLT_LONG_NAME == vnLabelTypes[nn])///Jasmine 01/18/10 CONFIGURE_SHOW_HIDE_SETTING
						continue;
					colY.SetExtendedLabel(vsLabels[nn], vnLabelTypes[nn]);
				}
			}
		}
		///Jasmine 01/18/10 SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME 
		if(nBookLabel > -1)
			colY.SetExtendedLabel(strBook, nBookLabel);
		if(nSheetLabel > -1)
			colY.SetExtendedLabel(strSheet, nSheetLabel);
		///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
		//if(nShortNameLabel > -1)
		//	colY.SetExtendedLabel(strCol, nShortNameLabel);
		//if(nLongName > -1)
			//colY.SetExtendedLabel(strLongname, nLongName);
		if ( nShortNameLabel > -1 )
		{
			string strName = strLongname.IsEmpty() ? strCol : strLongname;
			colY.SetExtendedLabel(strName, nShortNameLabel);
		}
		///end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
		
		///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
		if(nGraphLabel > -1)
			colY.SetExtendedLabel(strGraph, nGraphLabel);
		///End SUPPORT_MULTI_WINS_CURSOR
		
		///End SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME
		return true;
	}
	///Jasmine 01/27/10 MATCH_EXIST_COL_TO_CONSOLIDATE	
	bool	isColLabelMatch(const Column& col, int nLabelType, LPCSTR lpcszLabel)
	{
		if(lpcszLabel == NULL)//NULL means not care
			return true;
		
		string strLabel;
		if( col.GetExtendedLabel(strLabel, nLabelType) && !strLabel.IsEmpty() )
		{
			if(strLabel.Compare(lpcszLabel) != 0)
				return false;;
		}

		return true;
	}
	BOOL	checkAddColumn(	Worksheet& wks, Column& col, LPCSTR lpcszBook, LPCSTR lpcszSheet, LPCSTR lpcszCol, LPCSTR lpcszLongname, 
							int nDataplotID)	 ///Jasmine 08/01/2011 ORG-3106-P6 FIX_REUSE_SAME_COL_BUG
	{
		int nShortNameLabel = _check_add_dataset_indentifier_label(wks, LABEL_SHORT_NAME, false);
		int	nBookLabel 		= _check_add_dataset_indentifier_label(wks, LABEL_BOOK_NAME, false);
		int	nSheetLabel 	= _check_add_dataset_indentifier_label(wks, LABEL_SHEET_NAME, false);
		int nLongName 		= RCLT_LONG_NAME;
		
		col.Detach();
		
		foreach(Column cc in wks.Columns)
		{
			if(col)
				continue;
			
			///Jasmine 08/01/2011 ORG-3106-P6 FIX_REUSE_SAME_COL_BUG
			if( !isColUseable(cc, nDataplotID) )
				continue;
			//End FIX_REUSE_SAME_COL_BUG
			
			if( OUTPUT_WKS_X_COL_IND == cc.GetIndex() )
				continue;
			
			if( nShortNameLabel > -1 && !isColLabelMatch(cc, nShortNameLabel, lpcszCol) )
				continue;
			
			if( nBookLabel > -1 && !isColLabelMatch(cc, nBookLabel, lpcszBook) )
				continue;
			
			if( nSheetLabel > -1 && !isColLabelMatch(cc, nSheetLabel, lpcszSheet) )
				continue;
			
			if( nLongName > -1 && !isColLabelMatch(cc, nLongName, lpcszLongname) )
				continue;
			
			col = cc;
		}
		
		if(!col)
		{
			int nNewCol = wks.AddCol();
			if(nNewCol > -1)
				col = wks.Columns(nNewCol);
		}
		
	 	markColInUse(col, nDataplotID);	///Jasmine 08/01/2011 ORG-3106-P6 FIX_REUSE_SAME_COL_BUG
	 	
		return col.IsValid();
	}	
	///End MATCH_EXIST_COL_TO_CONSOLIDATE
	
	///Jasmine 08/01/2011 ORG-3106-P6 FIX_REUSE_SAME_COL_BUG
#define STR_STORAGE_USE					"ColInUse"
	bool isColUseable(const Column& cc, int nDataplotID)
	{
		Tree trTemp;
		if(	cc && cc.GetBinaryStorage(STR_STORAGE_USE, trTemp) && 
			trTemp.GetNode(STR_STORAGE_USE) )
		{
			return trTemp.GetNode(STR_STORAGE_USE).nVal == nDataplotID;
		}
		else
			return true;
	}
	void markColInUse(Column& cc, int nDataplotID)
	{
		if(!cc)
		{
			ASSERT(0);
			return;
		}
		
		Tree trTemp;
		TreeNode trNode = trTemp.AddNode(STR_STORAGE_USE);
		trNode.nVal = nDataplotID;
		
		cc.PutBinaryStorage(STR_STORAGE_USE, trTemp);
	}
	///End FIX_REUSE_SAME_COL_BUG
	
	BOOL	getColumnFromDataPlot(UINT nPlotUID, Column& col, bool bGetX)
	{
		DataPlot dp;
		dp = (DataPlot)Project.GetObject(nPlotUID);
		if( !dp )
		{
			return error_report("Fail invalid plotUID");
		}

		Column colX, colY;
		get_plot_columns(dp, colX, colY);
		col = bGetX? colX : colY;
		return col.IsValid();
	}
	
	BOOL	getColumnLabelsFromDataPlot(UINT nPlotUID, vector<int>& vnLabelTypes, vector<string>& vsLabels, bool bGetX)
	{
		Column 	col;
		if( !getColumnFromDataPlot(nPlotUID, col, bGetX) )
		{
			return error_report("Fail to get column object from data plot");
		}
		
		vnLabelTypes.RemoveAll();
		vsLabels.RemoveAll();
		for(int nType = RCLT_LONG_NAME; nType <= RCLT_MAX_TYPE; nType++)
		{
			string strLabel;
			if( col.GetExtendedLabel(strLabel, nType) && !strLabel.IsEmpty() )
			{
				vnLabelTypes.Add(nType);
				vsLabels.Add(strLabel);
			}
		}
		return (0 != vsLabels.GetSize());
	}
	
private:
	string					m_strOutWksName;
	Worksheet				m_wks;
};

/*----------------------------------------------------------------------------*/
/* VTagUnit, composition of VTag and VTagLabel
/*----------------------------------------------------------------------------*/

class VTagUnit
{
public:
	VTagUnit(const DataPlot& dp)
	{
		m_bIsSelected = FALSE;
		
		m_arrTagLabels.SetAsOwner(TRUE);///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
	}
	~VTagUnit()
	{
		;
	}
public:
	BOOL Create(const GraphLayer& gl, double dXScaleMark, LPCSTR lpcszLabelTextFormat = NULL)
	{
		if ( !m_vTag.GetValidObj().Create(gl, dXScaleMark, 0) )
		{
			ASSERT(FALSE);
			return FALSE;
		}

		if ( !Init(lpcszLabelTextFormat) )
		{
			m_vTag.GetValidObj().Destroy();
			ASSERT(FALSE);
		}

		return TRUE;
	}

	BOOL Init(LPCSTR lpcszLabelTextFormat = NULL)
	{
		string strLTScript;

		strLTScript.Format(STR_OBJ_EVENT_LT_SCRIPT_FORMAT, VCOT_TAG);
		BOOL bSetTagLTScriptOK = m_vTag.GetValidObj().SetLabTalkScriptEvent(strLTScript);

		return bSetTagLTScriptOK;
	}

	///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
	BOOL AddTagLabel(const GraphLayer& gl, const DataPlot& dp, double dXScaleMark, double dYScaleMark, LPCSTR lpcszLabelTextFormat = NULL)
	{
		VTagLabel* pvNewTagLabel = new VTagLabel;
		
		if (pvNewTagLabel)
		{
			if ( !pvNewTagLabel->GetValidObj().Create(gl, dXScaleMark, dYScaleMark) || m_arrTagLabels.Add(*pvNewTagLabel) < 0 )
			{
				ASSERT(FALSE);
				pvNewTagLabel->GetValidObj().Destroy();
				delete pvNewTagLabel;
				return FALSE;
			}
		}		
		
		string strLTScript;
		strLTScript.Format(STR_OBJ_EVENT_LT_SCRIPT_FORMAT, VCOT_TAG_LABEL);
		BOOL bSetTagLabelLTScriptOK = pvNewTagLabel->GetValidObj().SetLabTalkScriptEvent(strLTScript);
		
		BOOL bSetTextFormatOK = TRUE;
		if (NULL != lpcszLabelTextFormat)
			bSetTextFormatOK = pvNewTagLabel->GetValidObj().SetTextFormat(lpcszLabelTextFormat);
		
		BOOL bRet = pvNewTagLabel->AttachToPlot(dp);
		return bRet && bSetTagLabelLTScriptOK && bSetTextFormatOK;
	}
	///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
	
	BOOL Destroy( DWORD dwCntrl = OCD_DEL_LINKED_OBJS | OCD_DEL_PARENT_IF_LAST )
	{
		BOOL bRet = TRUE;
		if (m_vTag)
			bRet &= m_vTag.GetValidObj().Destroy(dwCntrl);
		///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
		//if (m_vTagLabel)
			//bRet &= m_vTagLabel.GetValidObj().Destroy(dwCntrl);
		for(int ii = m_arrTagLabels.GetSize() - 1; ii >= 0; ii--)
		{
			if( m_arrTagLabels.GetAt(ii).Destroy() )
				bRet &= m_arrTagLabels.RemoveAt(ii);
			else
				bRet &= false;
		}
		///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
		return bRet;
	}

	BOOL GetProperties(TreeNode& tnProperties)
	{
		if ( tnProperties.IsValid() )
		{
			///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
			/*VLABEL_PROPERTIES vpLabelProperties;
			m_vTagLabel.GetProperties(vpLabelProperties);

			tnProperties += vpLabelProperties;
			tnProperties += m_Properties;*/
			ASSERT(0);//doing
			///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE

			TreeNode tnTag		= tree_check_get_node(tnProperties, STR_OBJ_TAG_NAME_VTAG);
			TreeNode tnTagLabel	= tree_check_get_node(tnProperties, STR_OBJ_TAG_NAME_VTAG_LABEL);

			BOOL bRet1 = m_vTag.GetProperties(tnTag);
			///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
			//BOOL bRet2 = m_vTagLabel.GetProperties(tnTagLabel);
			BOOL bRet2 = FALSE;
			ASSERT(0);//doing
			///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
			return bRet1 && bRet2;
		}
		return FALSE;
	}
	BOOL SetProperties(const TreeNode& tnProperties)
	{
		if (tnProperties.IsValid())
		{
			///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
			/*
			m_Properties = tnProperties;
			TreeNode tnTag		= tnProperties.GetNode(STR_OBJ_TAG_NAME_VTAG);
			TreeNode tnTagLabel	= tnProperties.GetNode(STR_OBJ_TAG_NAME_VTAG_LABEL);
			BOOL bRet1 = m_vTag.SetProperties(tnTag);
			
			BOOL bRet2 = m_vTagLabel.SetProperties(tnTagLabel);

			VLABEL_PROPERTIES vpLabelProperties;
			vpLabelProperties = tnProperties;
			m_vTagLabel.SetProperties(vpLabelProperties);
			return bRet1 && bRet2;*/
			ASSERT(0);
			///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
		}
		return FALSE;
	}
	BOOL CleanupEventHandlerScript()
	{
		BOOL bRet = TRUE;
		///Kenny 06/16/2009 ALLOW_DELETING_TAG_AND_TAG_LABEL_AFTER_DLG_IS_CLOSED
		if (m_vTag)
		{
			bRet &= m_vTag.GetValidObj().SetLabTalkScriptEvent("", GRCT_NONE, 0);
			bRet &= update_go_states(m_vTag, 0, GOC_NO_STATE|GOC_NO_IN_PLACE_EDIT);
		}
		///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
		for(int ii = 0; ii < m_arrTagLabels.GetSize(); ii++)
		{
			VTagLabel& vTagLabel = m_arrTagLabels.GetAt(ii);
			bRet &= vTagLabel.GetValidObj().SetLabTalkScriptEvent("", GRCT_NONE, 0);
			bRet &= update_go_states(vTagLabel, 0, GOC_NO_STATE|GOC_NO_SELECT);
		}
		///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
		///End ALLOW_DELETING_TAG_AND_TAG_LABEL_AFTER_DLG_IS_CLOSED
		return bRet;
	}
	BOOL IsAllObjectValid(GraphPage& gpSupposedParent)
	{
		///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
		BOOL bRet = m_vTag.IsValid(gpSupposedParent);
		if (bRet)
		{
			for(int ii = 0; ii < m_arrTagLabels.GetSize(); ii++)
			{
				VTagLabel& vTagLabel = m_arrTagLabels.GetAt(ii);
				vTagLabel.IsValid(gpSupposedParent);
				VDataPlot vdp;
				vdp.AttachTo(vTagLabel.GetAttachedPlotUID());
				bRet &= is_object_valid_child_of_page(vdp, gpSupposedParent);
			}
		}
		return bRet;
		///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
	}
public:
	VTag					m_vTag;
	Array<VTagLabel&>		m_arrTagLabels;//VTagLabel				m_vTagLabel;	///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE	
	
	BOOL					m_bIsSelected;

};

/*----------------------------------------------------------------------------*/
/* GraphVerticalCursorHolder
/*----------------------------------------------------------------------------*/

struct VHOLDER_SETTINGS 
{
	BOOL	bShowTextLabels;
	///Sophy 9/27/2011 ORG-3106-S16 PROPER_FILTER_LAYER_FOR_VERTICAL_INTERSECT_CALC
	vector<int>	vnLayerIndex;
	///end PROPER_FILTER_LAYER_FOR_VERTICAL_INTERSECT_CALC
};

///Jasmine 03/22/2012 ORG-4971 DUMP_TAG_AND_LABEL_TO_LINKED_GRAPHS
#define		FOR_GRAPH_EACH_TEXT_LABEL_BEGIN(_gp, _label)										\
			foreach ( GraphLayer _gl in _gp.Layers )											\
			{																					\
				VGraphLayer _vgl(_gl);															\
				Array<VTextLabel&>&		arrTextLabels = _vgl.AccessTextLabels();				\
				for ( int ii=0; ii<arrTextLabels.GetSize(); ++ii )								\
				{																				\
					VTextLabel& _label= arrTextLabels.GetAt(ii);
///End DUMP_TAG_AND_LABEL_TO_LINKED_GRAPHS
	
#define		FOR_EACH_TEXT_LABEL_BEGIN(_gvcHolder, _label)										\
			GraphPage	_gp = _gvcHolder.GetPage();												\
			foreach ( GraphLayer _gl in _gp.Layers )											\
			{																					\
				VGraphLayer _vgl(_gl);															\
				Array<VTextLabel&>&		arrTextLabels = _vgl.AccessTextLabels();				\
				for ( int ii=0; ii<arrTextLabels.GetSize(); ++ii )								\
				{																				\
					VTextLabel& _label= arrTextLabels.GetAt(ii);
						
#define		FOR_EACH_TEXT_LABEL_END		\
				}						\
			}

#define GET_TAG_UNIT_ELEMENT_INDEX_BY_UID(uID, element)	\
	{\
		const int nArrSize = m_arrTagUnits.GetSize();\
		for (int ii = 0; ii < nArrSize; ++ii)\
		{\
			VTagUnit& vTagUnit = m_arrTagUnits.GetAt(ii);\
			if (vTagUnit.element.GetValidObj().IsValid() && uID == vTagUnit.element.GetUID() )\
				return ii;\
		}\
		return -1;\
	}

///Jasmine 06/21/2012 ORG-4971-P7 LINK_GRAPH_LABELS_ARE_MIXED
//#define ACCESS_PAGE_HOLDER_BINARAY_STORAGE(action)	\
	//{\
		//GraphPage gpParent = GetPage();\
///End LINK_GRAPH_LABELS_ARE_MIXED
#define ACCESS_PAGE_HOLDER_BINARAY_STORAGE(action, gp)	\
	{\
		GraphPage gpParent = gp;\
		if( !gpParent)\
			gpParent = GetPage();\
		if (gpParent)\
		{\
			BOOL bRet = gpParent.action(STR_VERTICAL_CURSOR_BINARY_STORAGE_NAME, tnProperties);\
			return bRet;\
		}\
		return FALSE;\
	}

class GraphVerticalCursorHolder
{
public:
	GraphVerticalCursorHolder(UINT uPageUID = 0)
	{
		m_nSelectedTagsCount = 0;
		m_uPageUID = uPageUID;
		m_arrTagUnits.SetAsOwner(TRUE);

		m_bIsAllTextLabelsInitValid = TRUE;
		
		//m_vsPointIDs.SetSize(0);	///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER	///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
	}
	~GraphVerticalCursorHolder()
	{
		m_line.ReattachAllObjects();
		
		if (m_bIsAllTextLabelsInitValid)
			removeAllTextLabels();
	}
public:
	int GetTagIndexByUID(const UINT uID)		GET_TAG_UNIT_ELEMENT_INDEX_BY_UID(uID, m_vTag)
	///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
	//int GetTagLabelIndexByUID(const UINT uID)	GET_TAG_UNIT_ELEMENT_INDEX_BY_UID(uID, m_vTagLabel)
	int GetTagLabelIndexByUID(const UINT uID){ASSERT(0); return -1;}
	///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE

	///------ Folger 01/22/10 CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE
	double	GetSnapToX()
	{
		return m_line.GetSnapToX();
	}
	///------ End CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE

	///------ Folger 08/31/2012 ORG-6681-P1 GLOBAL_GADGET_MANAGER_SERIALIZATION
	BOOL	IsSnapToXDataValid()
	{
		return !is_missing_value(GetSnapToX())
	}
	///------ End GLOBAL_GADGET_MANAGER_SERIALIZATION

	GraphPage GetPage()
	{
		GraphPage gp;
		gp = (GraphPage)Project.GetObject(m_uPageUID);
		return gp;
	}

	VTagUnit* AddTagUnit(GraphLayer& gl, double dXScaleMark, LPCSTR lpcszLabelTextFormat = NULL)
	{
		VTagUnit* pvNewTagUnit = new VTagUnit;
		if (pvNewTagUnit)
		{
			if ( !pvNewTagUnit->Create(gl, dXScaleMark, lpcszLabelTextFormat) || m_arrTagUnits.Add(*pvNewTagUnit) < 0 )
			{
				ASSERT(FALSE);
				delete pvNewTagUnit;
				return NULL;
			}
		}
		return pvNewTagUnit;
	}

	BOOL InitPropertiesFromPage()
	{
		m_bIsAllTextLabelsInitValid = FALSE;
		Tree trProperties;
		if ( !GetPropertiesFromPage(trProperties) )
			return FALSE;

		BOOL bRet = SetProperties(trProperties);
		return bRet;
	}

	BOOL SaveHolderSettingsToPage()
	{
		Tree trProperties;
		BOOL bRet = GetPropertiesFromPage(trProperties);
		TreeNode tnHolder = tree_check_get_node(trProperties, STR_OBJ_TAG_NAME_VHOLDER_SETTINGS);
		tnHolder += m_Settings;
		bRet = PutPropertiesToPage(trProperties);
		ASSERT(bRet);
		return bRet;
	}

	// We don't provide a way to separately delete this properties because once we really need to delete it, the whole tree should be deleted.
	BOOL SaveLinePropertiesToPage()
	{
		Tree trProperties;
		BOOL bRet = GetPropertiesFromPage(trProperties);
		TreeNode tnLine = tree_check_get_node(trProperties, STR_OBJ_TAG_NAME_VLINE);
		bRet = m_line.GetProperties(tnLine);
		if (bRet)
			bRet = PutPropertiesToPage(trProperties);
		ASSERT(bRet);
		return bRet;
	}

	// Note: we have to call this function to remove the corresponding TreeNode in page before deleting/destroying TagUnit
	BOOL SaveTagUnitPropertiesToPage(const VTagUnit& vTagUnit, BOOL bDelete = FALSE)
	{
		Tree trProperties;
		BOOL bRet = GetPropertiesFromPage(trProperties);
		const UINT uTagUID = vTagUnit.m_vTag.GetUID();
		TreeNode tnTagUnits = tree_check_get_node(trProperties, STR_OBJ_TAG_NAME_VTAG_UNITS);
		TreeNode tnTagUnit = tnTagUnits.FindNodeByAttribute(TREE_UID, uTagUID, FALSE);

		if (bDelete)
		{
			if (tnTagUnit.IsValid())
				bRet = tnTagUnit.Remove();
		}
		else
		{
			if (!tnTagUnit.IsValid())
			{
				tnTagUnit = tnTagUnits.AddNode(STR_OBJ_TAG_NAME_VTAG_UNIT_PREFIX);
				if (tnTagUnit.IsValid())
					tnTagUnit.SetAttribute(TREE_UID, uTagUID);
			}
			bRet = vTagUnit.GetProperties(tnTagUnit);
		}

		if (bRet)
			bRet = PutPropertiesToPage(trProperties);
		ASSERT(bRet);
		return bRet;
	}

	// Note: we have to call this function to remove the corresponding TreeNode in page before deleting/destroying TextLabel
	///Jasmine 06/21/2012 ORG-4971-P7 LINK_GRAPH_LABELS_ARE_MIXED
	//BOOL SaveTextLabelPropertiesToPage(const VTextLabel& vTextLabel, BOOL bDelete = FALSE)
	BOOL SaveTextLabelPropertiesToPage(const VTextLabel& vTextLabel, BOOL bDelete = FALSE, GraphPage& gp = NULL)
	///End LINK_GRAPH_LABELS_ARE_MIXED
	{
		Tree trProperties;
		///Jasmine 06/21/2012 ORG-4971-P7 LINK_GRAPH_LABELS_ARE_MIXED
		//BOOL bRet = GetPropertiesFromPage(trProperties);
		BOOL bRet = GetPropertiesFromPage(trProperties, gp);
		///End LINK_GRAPH_LABELS_ARE_MIXED
		const UINT uTextLabelUID = vTextLabel.GetUID();
		TreeNode tnTextLabels = tree_check_get_node(trProperties, STR_OBJ_TAG_NAME_VTEXT_LABELS);
		TreeNode tnTextLabel = tnTextLabels.FindNodeByAttribute(TREE_UID, uTextLabelUID, FALSE);

		if (bDelete)
		{
			if (tnTextLabel.IsValid())
				bRet = tnTextLabel.Remove();
		}
		else
		{
			if (!tnTextLabel.IsValid())
			{
				tnTextLabel = tnTextLabels.AddNode(STR_OBJ_TAG_NAME_VTEXT_LABEL_PREFIX);
				if (tnTextLabel.IsValid())
					tnTextLabel.SetAttribute(TREE_UID, uTextLabelUID);
			}
			bRet = vTextLabel.GetProperties(tnTextLabel);
		}

		if (bRet)
			///Jasmine 06/21/2012 ORG-4971-P7 LINK_GRAPH_LABELS_ARE_MIXED
			//bRet = PutPropertiesToPage(trProperties);
			bRet = PutPropertiesToPage(trProperties, gp);
			///End LINK_GRAPH_LABELS_ARE_MIXED
		ASSERT(bRet);
		return bRet;
	}

#ifdef _DEBUG
	BOOL GetProperties(TreeNode& tnProperties)
	{
		if ( tnProperties.IsValid() )
		{
			// Properties of holder
			tnProperties += m_Settings;

			// Properties of line
			TreeNode tnLine = tree_check_get_node(tnProperties, STR_OBJ_TAG_NAME_VLINE);
			BOOL bRet = m_line.GetProperties(tnLine);

			// Properties of TagUnit
			TreeNode tnTagUnits = tree_check_get_node(tnProperties, STR_OBJ_TAG_NAME_VTAG_UNITS);

			const int nTagUnitSize = m_arrTagUnits.GetSize();
			for (int ii = 0; ii < nTagUnitSize; ++ii)
			{
				VTagUnit& vTagUnit = m_arrTagUnits.GetAt(ii);
				const UINT uTagUID = vTagUnit.m_vTag.GetUID();
				TreeNode tnTagUnit = tnTagUnits.FindNodeByAttribute(TREE_UID, uTagUID, FALSE);
				if (!tnTagUnit.IsValid())
				{
					tnTagUnit = tnTagUnits.AddNode(STR_OBJ_TAG_NAME_VTAG_UNIT_PREFIX);
					if (tnTagUnit.IsValid())
						tnTagUnit.SetAttribute(TREE_UID, uTagUID);
				}
				bRet = vTagUnit.GetProperties(tnTagUnit);
				ASSERT(bRet);
			}

			// Properties of TextLabel
			TreeNode tnTextLabels = tree_check_get_node(tnProperties, STR_OBJ_TAG_NAME_VTEXT_LABELS);

			const GraphVerticalCursorHolder& gvcHolder = *this;

			FOR_EACH_TEXT_LABEL_BEGIN(gvcHolder, textLabel)
				const UINT uTextLabelUID = textLabel.GetUID();
				TreeNode tnTextLabel = tnTextLabels.FindNodeByAttribute(TREE_UID, uTextLabelUID, FALSE);
				if (!tnTextLabel.IsValid())
				{
					tnTextLabel = tnTextLabels.AddNode(STR_OBJ_TAG_NAME_VTEXT_LABEL_PREFIX);
					if (tnTextLabel.IsValid())
						tnTextLabel.SetAttribute(TREE_UID, uTextLabelUID);
				}
				bRet = textLabel.GetProperties(tnTextLabel);
				ASSERT(bRet);
			FOR_EACH_TEXT_LABEL_END
			return bRet;
		}
		return FALSE;
	}
#endif // _DEBUG

	///------ Folger 08/21/2012 ORG-4971-S7 VERTICAL_CURSOR_SHOULD_LINKED_GRAPHS_NUM_ON_TITLE
	int GetLinkedGraphs(vector<OUID>* pvnUIDs = NULL)
	{
		vector<OUID> vnLoc;
		if ( NULL == pvnUIDs )
		{
			pvnUIDs = &vnLoc;
		}

		if ( Project.Gadgets.GetLinkedGraphs(m_line, *pvnUIDs) )
			return pvnUIDs->GetSize();

		return 0;
	}

	BOOL HasGlobalGadget()
	{
		return Project.Gadgets.Has(m_line);
	}
	///------ End VERTICAL_CURSOR_SHOULD_LINKED_GRAPHS_NUM_ON_TITLE

	///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
	void GetXBasedLayer(GraphLayer& glXBased)
	{
		if(!m_glXBased)
			m_line.GetParent(m_glXBased);
		
		glXBased = m_glXBased;
	}
	void SetXBasedLayer(GraphLayer& glXBased)
	{
		m_glXBased = glXBased;
	}
	///End BTN_TO_CAHNGE_X_REFERECE_LAYER
protected:
	BOOL IsAllObjectValid(const TreeNode& tnProperties)
	{
		if ( !tnProperties.IsValid() )
			return FALSE;

		GraphPage gpParent = GetPage();
		if (!gpParent.IsValid())
		{
			MY_DBG_OUTPUT("GraphPage is invalid!");
			return FALSE;
		}

		BOOL bRet = FALSE;
		// Properties of line
		TreeNode tnLine = tnProperties.GetNode(STR_OBJ_TAG_NAME_VLINE);
		VGraphLine tmpLine(FALSE);
		bRet = tmpLine.SetProperties(tnLine);
		if ( !bRet || !tmpLine.IsValid(gpParent) )
		{
			MY_DBG_OUTPUT("Line is invalid!");
			return FALSE;
		}

		// Properties of tagunit
		TreeNode tnTagUnits = tnProperties.GetNode(STR_OBJ_TAG_NAME_VTAG_UNITS);
		if (tnTagUnits.IsValid())
		{
			foreach(TreeNode tnTagUnit in tnTagUnits.Children)
			{
				VTagUnit tagUnit;
				bRet = tagUnit.SetProperties(tnTagUnit);
				if ( !bRet || !tagUnit.IsAllObjectValid(gpParent) )
				{
					MY_DBG_OUTPUT("TagUnit is invalid!");
					return FALSE;
				}
			}
		}

		// Properties of TextLabel
		TreeNode tnTextLabels = tnProperties.GetNode(STR_OBJ_TAG_NAME_VTEXT_LABELS);
		if (tnTextLabels.IsValid())
		{
			foreach(TreeNode tnTextLabel in tnTextLabels.Children)
			{
				VTextLabel vTextLabel(FALSE);
				bRet = vTextLabel.SetProperties(tnTextLabel);
				if ( !bRet || !vTextLabel.IsValid(gpParent) || !vTextLabel.IsAttachedPlotValid(gpParent) )
				{
					MY_DBG_OUTPUT("TextLabel is invalid!");
					return FALSE;
				}
			}
		}
		m_bIsAllTextLabelsInitValid = TRUE;
		return TRUE;
	}

	BOOL SetProperties(const TreeNode& tnProperties)
	{
		if ( !IsAllObjectValid(tnProperties) )
		{
			return FALSE;
		}

		if (m_arrTagUnits.GetSize() > 0)
		{
			ASSERT(FALSE);
			return FALSE;
		}
		GraphPage gpParent = GetPage();
		if (!gpParent.IsValid())
		{
			MY_DBG_OUTPUT("GraphPage is invalid!");
			return FALSE;
		}

		BOOL bRet = FALSE;

		// Properties of holder
		TreeNode tnHolder = tnProperties.GetNode(STR_OBJ_TAG_NAME_VHOLDER_SETTINGS);
		if ( !tnHolder.IsValid() )
		{
			MY_DBG_OUTPUT("Holder settings is invalid!");
			// It's not that necessary to return FALSE here, we can still manage to init the holder by assigning some proper values.
			//return FALSE;
		#ifdef REMOVE_LABEL_FEATURE
			m_Settings.bShowTextLabels = FALSE;
		#else
			m_Settings.bShowTextLabels = TRUE;
		#endif
		}
		else
		{
			m_Settings = tnHolder;
		}

		// Properties of line
		TreeNode tnLine = tnProperties.GetNode(STR_OBJ_TAG_NAME_VLINE);
		bRet = m_line.SetProperties(tnLine);
		if ( !bRet || !m_line.IsValid(gpParent) )
		{
			MY_DBG_OUTPUT("Line is invalid!");
			return FALSE;
		}

		// Properties of TagUnits
		TreeNode tnTagUnits = tnProperties.GetNode(STR_OBJ_TAG_NAME_VTAG_UNITS);
		if (tnTagUnits.IsValid())
		{
			foreach(TreeNode tnTagUnit in tnTagUnits.Children)
			{
				VTagUnit* pvNewTagUnit = new VTagUnit;
				if (pvNewTagUnit)
				{
					bRet = pvNewTagUnit->SetProperties(tnTagUnit);
					if ( !bRet || !pvNewTagUnit->IsAllObjectValid(gpParent) || m_arrTagUnits.Add(*pvNewTagUnit) < 0 )
					{
						delete pvNewTagUnit;
						ASSERT(FALSE);
					}
				}
			}
		}

		// Properties of TextLabel
		vector<UINT> vnInitialzedLayerUIDs;
		TreeNode tnTextLabels = tnProperties.GetNode(STR_OBJ_TAG_NAME_VTEXT_LABELS);
		if (tnTextLabels.IsValid())
		{
			foreach(TreeNode tnTextLabel in tnTextLabels.Children)
			{
				VTextLabel* pvNewTextLabel = new VTextLabel;
				if (pvNewTextLabel)
				{
					bRet = pvNewTextLabel->SetProperties(tnTextLabel);
					bRet = bRet && pvNewTextLabel->IsValid(gpParent);
					if (bRet)
					{
						GraphLayer glParent;
						pvNewTextLabel->GetParent(glParent);
						bRet = glParent.IsValid();
						if (bRet)
						{
							vector<UINT> vnIndices;
							const UINT nLayerUID = glParent.GetUID(TRUE);
							const int nFindRet = vnInitialzedLayerUIDs.Find(MATREPL_TEST_EQUAL, nLayerUID, vnIndices);
							const bool bUninitialized = nFindRet <= 0;
							if (bUninitialized)
								vnInitialzedLayerUIDs.Add(nLayerUID);
							VGraphLayer vgl(glParent);
							Array<VTextLabel&>& arrTextLabels = vgl.AccessTextLabels(false, bUninitialized);
							bRet = arrTextLabels.Add(*pvNewTextLabel) >= 0;
						}
					}
					if (!bRet)
					{
						ASSERT(FALSE);
						delete pvNewTextLabel;
					}
				}
			}
		}
		return bRet;
	}

	///Jasmine 06/21/2012 ORG-4971-P7 LINK_GRAPH_LABELS_ARE_MIXED
	//BOOL GetPropertiesFromPage(TreeNode& tnProperties)	ACCESS_PAGE_HOLDER_BINARAY_STORAGE(GetBinaryStorage)
	//BOOL PutPropertiesToPage(const TreeNode& tnProperties)	ACCESS_PAGE_HOLDER_BINARAY_STORAGE(PutBinaryStorage)
	BOOL GetPropertiesFromPage(TreeNode& tnProperties, GraphPage& gp = NULL)	ACCESS_PAGE_HOLDER_BINARAY_STORAGE(GetBinaryStorage, gp)
	BOOL PutPropertiesToPage(const TreeNode& tnProperties, GraphPage& gp = NULL)	ACCESS_PAGE_HOLDER_BINARAY_STORAGE(PutBinaryStorage, gp)
	///End LINK_GRAPH_LABELS_ARE_MIXED
private:
	void removeAllTextLabels()
	{
		GraphPage gp = GetPage();
		if (!gp)
		{
			ASSERT(FALSE);
			return;
		}
		foreach ( GraphLayer gl in gp.Layers )
		{
			VGraphLayer vgl(gl);
			vgl.RemoveTextLabels();
		}
	}
public:
	VGraphLine			m_line;
	Array<VTagUnit&>	m_arrTagUnits;

	VHOLDER_SETTINGS	m_Settings;

	UINT				m_uPageUID;

	// Flags/Others
	UINT				m_nSelectedTagsCount;
	
	//vector<string>		m_vsPointIDs;	///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER	///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
	
private:
	BOOL				m_bIsAllTextLabelsInitValid;
	GraphLayer			m_glXBased;			///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
};

/*----------------------------------------------------------------------------*/
/* VLabelSetting
/*----------------------------------------------------------------------------*/

#define STR_LABEL_TYPE_Y_VALUE								"$(Y)"
#define STR_LABEL_TYPE_X_Y_VALS								"($(X),$(Y))"
#define	STR_TAG_TYPE_X_VALUE								"$(X)"
enum LabelTextType
{
	LTT_Y_VALUE					= 0,
	LTT_X_Y_VALUES				= 1,
	LTT_CUSTOM					= 2,
	LTT_NONE, ///------ Folger 08/10/2012 ORG-6381-S3 VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
};

enum TagTextType {
	TTT_X_VALUE	= 0,
	TTT_CUSTOM,
	TTT_NONE, ///------ Folger 08/10/2012 ORG-6381-S3 VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
};

enum TagLocation {
	TL_TOP = 0,
	TL_BOTTOM,
};
#define SIGNIFICANT_DIGITS_FREE							0

///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
enum LineLength
{
	LL_SPAN_LAYERS = 0,
	LL_FULL_PAGE,
};
///------ End VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERSS

struct VLabelSetting 
{
	int				nTextType;				/// Kenny, LabelTextType, but I prefer to name it nTextFormatType
	string			strLTCustomTextType;	/// Kenny, Custom text type, but I prefer to name it strLTCustomTextFormat.
	int				nSignificantDigits;
	string 			strNotation;			///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
};

///Sophy 8/18/2011 ORG-3106-S10 NEW_OPTIONS_DIALOG
struct VTagSetting
{
	int				nXFormat;
	int				nYFormat;
	int				nTextType;
	string			strLTCustomTextType;
	int				nLocation;
};
///end NEW_OPTIONS_DIALOG

#define STR_INI_SECTION_NAME_VERTICAL_CURSOR				"VerticalCursor"
#define STR_INI_KEY_NAME_LABEL_SETTING_TEXT_TYPE			"TextType"
#define STR_INI_KEY_NAME_LABEL_SETTING_CUSTOM_TEXT_TYPE		"CustomTextType"
#define STR_INI_KEY_NAME_LABEL_SETTING_SD					"SignificantDigits"
#define STR_INI_KEY_NAME_LABEL_SETTING_NOTATION_TYPE		"NotationType"			///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
#define STR_INI_KEY_NAME_SNAP_LINE_TO_DATA					"SnapLineToData"
#define STR_INI_KEY_NAME_DUMP_WKS_NAME						"DumpWksName"
#define STR_INI_KEY_NAME_CURSOR_SHOWS						"CursorShows"
#define STR_INI_KEY_NAME_COLUMN_ORDER						"ColumnOrder"			///Jasmine 07/18/2011 ORG-3106-S3-4 KEEP_COL_ORDER_IN_PAGE
///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
#define STR_INI_KEY_NAME_PLOT_IDS							"PlotIDs"
#define STR_INI_KEY_NAME_PLOT_SHOW							"PlotShow"
#define STR_INI_KEY_NAME_GRID_HIDE_PLOT						"GridHidePlot"			///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
///End MENU_TO_HIDE_PLOT_FROM_DLG

///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
#define	STR_INI_KEY_NAME_XDISPN								"XDispN"
#define	STR_INI_KEY_NAME_YDISPN								"YDispN"
#define	STR_INI_KEY_NAME_XDISPD								"XDispD"
#define	STR_INI_KEY_NAME_YDISPD								"YDispD"
#define	STR_INI_KEY_NAME_XDISPT								"XDispT"
#define	STR_INI_KEY_NAME_YDISPT								"YDispT"
///Jasmine 08/23/2012 ORG-6419-P2 DEFAULT_AUTO_FOR_OTHER_FORMAT_TYPE_OF_AXIS_LABEL
#define	STR_INI_KEY_NAME_XDISPOTHER							"XDispOther"
#define	STR_INI_KEY_NAME_YDISPOTHER							"YDispOther"
///End DEFAULT_AUTO_FOR_OTHER_FORMAT_TYPE_OF_AXIS_LABEL
#define	STR_INI_KEY_NAME_TAG_SETTING_TEXT_TYPE				"TagTextType"
#define	STR_INI_KEY_NAME_TAG_SETTING_CUSTOM_TEXT_TYPE		"TagCustomTextType"
#define	STR_INI_KEY_NAME_TAG_LOCATION						"TagLocation"
///end NEW_OPTIONS_DIALOG

///Jasmine 01/18/10 CONFIGURE_SHOW_HIDE_SETTING
//should not change these items value after release, since they're used in register
enum{
	VCURSOR_SHOW_INDEX = 0,
	VCURSOR_SHOW_CURSORX,
	VCURSOR_SHOW_CURSORY,
	VCURSOR_SHOW_NEAREST_X,
	VCURSOR_SHOW_NEAREST_Y,
	///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
	//VCURSOR_SHOW_SHORTNAME,
	//VCURSOR_SHOW_LONGNAME,
	VCURSOR_SHOW_NAME,
	///end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
	VCURSOR_SHOW_SHEETNAME,
	VCURSOR_SHOW_BOOKNAME,
	
	VCURSOR_SHOW_GRAPHNAME,		///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
	VCURSOR_SHOW_STATUS,		///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	
	VCURSOR_SHOW_TOTAL
};

struct VCursorShow
{
	int BookName;
	int SheetName;
	///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
	//int ShortName;
	//int LongName;
	int Name;
	///end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
	int CursorX;
	int CursorY;
	int CursorNearX;///Jasmine 01/20/10 SHOW_NEAREST_POINT 		
	int CursorNearY;
	int Index;
	int GraphName;	///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
	int Status;		///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	
	vector<int> 	vnColMap;///Jasmine 07/18/2011 ORG-3106-S3-4 KEEP_COL_ORDER_IN_PAGE
	///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
	vector<string>	vsPlotIDs;
	vector<int>		vnPlotShow;	
	///End MENU_TO_HIDE_PLOT_FROM_DLG
	vector<int>		vnPlotHideFromGrid;					///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
	string	strXDisp;	//X display format;
	string	strYDisp;	//Y display format;
	///end NEW_OPTIONS_DIALOG
	///Sophy 10/10/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
	bool	bModifiedOutside; //this is temporarily internal used 
	///end GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
};
///End CONFIGURE_SHOW_HIDE_SETTING

struct VManagerSetting 
{
	VTagSetting		m_tagSetting;	///Sophy 8/18/2011 ORG-3106-S10 NEW_OPTIONS_DIALOG
	VLabelSetting	m_labelSetting;
	VCursorShow		m_cursorshow;
	
	///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT
	//bool			m_bSnapLineToData;
	string			m_strSnappedPlot;
	///End SNAP_CURSOR_TO_DATA_PLOT
	///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	BOOL			m_bSnapToNearestX;
	///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	string			m_strThemeFileName;	///Sophy 9/6/2011 ORG-3106-S13 VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT
	string			m_strDumpWksName;
	int				m_nLineLength; ///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
public:
	BOOL SaveToIni()
	{	
		INIFileEx ini(STR_ORIGIN_INI_FILE_NAME);
		BOOL bRet = FALSE;

		bRet = ini.WriteInt(	STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_LABEL_SETTING_TEXT_TYPE, 			m_labelSetting.nTextType);
		bRet = ini.WriteString(	STR_INI_SECTION_NAME_VERTICAL_CURSOR,	STR_INI_KEY_NAME_LABEL_SETTING_CUSTOM_TEXT_TYPE,	m_labelSetting.strLTCustomTextType);
		bRet = ini.WriteInt(	STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_LABEL_SETTING_SD, 					m_labelSetting.nSignificantDigits);
		
		///Sophy 8/18/2011 ORG-3106-S10 NEW_OPTIONS_DIALOG
		bRet = ini.WriteInt(	STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_TAG_SETTING_TEXT_TYPE, 			m_tagSetting.nTextType);
		bRet = ini.WriteString(	STR_INI_SECTION_NAME_VERTICAL_CURSOR,	STR_INI_KEY_NAME_TAG_SETTING_CUSTOM_TEXT_TYPE,		m_tagSetting.strLTCustomTextType);
		bRet = ini.WriteInt(	STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_TAG_LOCATION, 						m_tagSetting.nLocation);
		///end NEW_OPTIONS_DIALOG
		///Jasmine 01/18/10 CONFIGURE_SHOW_HIDE_SETTING
		BitsHex 		bh;
		string			strShows;
		vector<byte> 	vbShows;
		///Jasmine 07/18/2011 ORG-3106-S3-4 KEEP_COL_ORDER_IN_PAGE
		//getVCursorShowStateasVector(vbShows);
		vector<string> 	vsColMap; 
		
		///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
		//getVCursorShowStateasVector(vbShows, vsColMap);
		vector<string>	vsPlotShow, vsPlotHideFromGrid;	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT;
		getVCursorShowStateasVector(vbShows, vsColMap, vsPlotShow, vsPlotHideFromGrid);
		
		///Jasmine 08/30/2012 ORG-6634-P1 PLOTS_ORDER_SHOULD_NOT_SAVE_INI_FOR_OTHER_GRAPHS_TO_LOAD
		//string strPlotIDs;
		//strPlotIDs.SetTokens(	m_cursorshow.vsPlotIDs,	'|');
		//bRet = ini.WriteString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_PLOT_IDS,		strPlotIDs);
		///End PLOTS_ORDER_SHOULD_NOT_SAVE_INI_FOR_OTHER_GRAPHS_TO_LOAD
		
		string strPlotShow;
		strPlotShow.SetTokens(	vsPlotShow, 			'|');
		bRet = ini.WriteString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_PLOT_SHOW, 	strPlotShow);
		
		///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		string strPlotHideFromGrid;
		strPlotHideFromGrid.SetTokens(vsPlotHideFromGrid, '|');
		bRet = ini.WriteString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_GRID_HIDE_PLOT, strPlotHideFromGrid);
		///End NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		///End MENU_TO_HIDE_PLOT_FROM_DLG
		
		string strOrder;
		strOrder.SetTokens(		vsColMap, 				'|');
		bRet = ini.WriteString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_COLUMN_ORDER,	strShows);
		///End KEEP_COL_ORDER_IN_PAGE
		
		if( bh.BitsToHexStr(vbShows, strShows) )
			bRet = ini.WriteString(STR_INI_SECTION_NAME_VERTICAL_CURSOR,STR_INI_KEY_NAME_CURSOR_SHOWS,	strShows);
		///End CONFIGURE_SHOW_HIDE_SETTING
		
		///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT, can not save this
		//bRet = ini.WriteInt(STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_SNAP_LINE_TO_DATA,	m_bSnapLineToData);
		///End SNAP_CURSOR_TO_DATA_PLOT
		bRet = ini.WriteString(STR_INI_SECTION_NAME_VERTICAL_CURSOR,	STR_INI_KEY_NAME_DUMP_WKS_NAME,	m_strDumpWksName);
		
		///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
		string strKeyNameX = STR_INI_KEY_NAME_XDISPN;
		string strKeyNameY = STR_INI_KEY_NAME_YDISPN;
		///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
		int nX = OULABEL_NUMERIC, nY = OULABEL_NUMERIC;//OKCOLTYPE_TEXT_NUMERIC
		getActivePlotFormat(nX, nY);
		if 		( nX == OULABEL_DATE )//OKCOLTYPE_DATE
		{
			strKeyNameX = STR_INI_KEY_NAME_XDISPD;
		}
		else if ( nX == OULABEL_TIME )//OKCOLTYPE_TIME
		{
			strKeyNameX = STR_INI_KEY_NAME_XDISPT;
		}
		if 		( nY == OULABEL_DATE )//OKCOLTYPE_DATE
		{
			strKeyNameY = STR_INI_KEY_NAME_YDISPD;
		}
		else if ( nY == OULABEL_TIME )//OKCOLTYPE_TIME
		{
			strKeyNameY = STR_INI_KEY_NAME_YDISPT;
		}
		///End LABEL_FOLLOW_AXIS_FORMAT
		///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		//bRet = ini.WriteString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, strKeyNameX, m_cursorshow.strXDisp);
		//bRet = ini.WriteString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, strKeyNameY, m_cursorshow.strYDisp);
		bRet = ini.WriteString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, strKeyNameX, _cvt_auto_format_display_str(m_cursorshow.strXDisp, true, true));
		bRet = ini.WriteString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, strKeyNameY, _cvt_auto_format_display_str(m_cursorshow.strYDisp, true, false));
		///End SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		///end NEW_OPTIONS_DIALOG
		
		return bRet;
	}
	BOOL LoadFromIni()
	{
		INIFileEx ini(STR_ORIGIN_INI_FILE_NAME);
		BOOL bRet = FALSE;

		m_labelSetting.nTextType 			= ini.ReadInt(STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_LABEL_SETTING_TEXT_TYPE, 			LTT_Y_VALUE);
		m_labelSetting.strLTCustomTextType 	= ini.ReadString(STR_INI_SECTION_NAME_VERTICAL_CURSOR,	STR_INI_KEY_NAME_LABEL_SETTING_CUSTOM_TEXT_TYPE,	STR_LABEL_TYPE_Y_VALUE);
		m_labelSetting.nSignificantDigits 	= ini.ReadInt(STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_LABEL_SETTING_SD, 					SIGNIFICANT_DIGITS_FREE);
		
		///Jasmine 01/18/10 CONFIGURE_SHOW_HIDE_SETTING
		string strShows	= 	ini.ReadString(STR_INI_SECTION_NAME_VERTICAL_CURSOR,	STR_INI_KEY_NAME_CURSOR_SHOWS);
		BitsHex bh;
		vector<byte> vbShows;
		if( !strShows.IsEmpty() )
			bh.HexStrToBits(strShows, vbShows);
		
		///Jasmine 07/18/2011 ORG-3106-S3-4 KEEP_COL_ORDER_IN_PAGE
		//setVCursorShowStatebyVector(vbShows);
		string strOrder		= ini.ReadString(STR_INI_SECTION_NAME_VERTICAL_CURSOR,	STR_INI_KEY_NAME_COLUMN_ORDER);		
		vector<string> vsColMap; 
		strOrder.GetTokens(vsColMap, '|');

		///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
		//setVCursorShowStatebyVector(vbShows, vsColMap);
		///Jasmine 08/30/2012 ORG-6634-P1 PLOTS_ORDER_SHOULD_NOT_SAVE_INI_FOR_OTHER_GRAPHS_TO_LOAD
		//string strPlotIDs	= ini.ReadString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_PLOT_IDS);
		//strPlotIDs.GetTokens(m_cursorshow.vsPlotIDs, '|');
		///End PLOTS_ORDER_SHOULD_NOT_SAVE_INI_FOR_OTHER_GRAPHS_TO_LOAD
		
		string strPlotShow	= ini.ReadString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, STR_INI_KEY_NAME_PLOT_SHOW);
		vector<string> vsPlotShow;
		strPlotShow.GetTokens(vsPlotShow, '|');
		
		///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		string strPlotHideFromGrid = ini.ReadString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, STR_INI_KEY_NAME_GRID_HIDE_PLOT);
		vector<string> vsPlotHideFromGrid;
		strPlotHideFromGrid.GetTokens(vsPlotHideFromGrid, '|');
		///End NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		
		setVCursorShowStatebyVector(vbShows, vsColMap, vsPlotShow, vsPlotHideFromGrid);	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		///End MENU_TO_HIDE_PLOT_FROM_DLG
		
		///End KEEP_COL_ORDER_IN_PAGE
		///End CONFIGURE_SHOW_HIDE_SETTING
		
		if (m_labelSetting.nTextType < LTT_Y_VALUE || m_labelSetting.nTextType > LTT_CUSTOM)
			m_labelSetting.nTextType 			= LTT_Y_VALUE;
		if (LTT_CUSTOM == m_labelSetting.nTextType && m_labelSetting.strLTCustomTextType.IsEmpty())
			m_labelSetting.strLTCustomTextType 	= STR_LABEL_TYPE_Y_VALUE;
		if (m_labelSetting.nSignificantDigits < MIN_SIGNIFICANT_DIGITS || m_labelSetting.nSignificantDigits > MAX_SIGNIFICANT_DIGITS)
			m_labelSetting.nSignificantDigits 	= SIGNIFICANT_DIGITS_FREE;

		///Sophy 8/18/2011 ORG-3106-S10 NEW_OPTIONS_DIALOG
		m_tagSetting.nTextType 			= ini.ReadInt(		STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_TAG_SETTING_TEXT_TYPE, 		TTT_X_VALUE);
		m_tagSetting.strLTCustomTextType= ini.ReadString(	STR_INI_SECTION_NAME_VERTICAL_CURSOR,	STR_INI_KEY_NAME_TAG_SETTING_CUSTOM_TEXT_TYPE,	STR_TAG_TYPE_X_VALUE);
		m_tagSetting.nLocation			= ini.ReadInt(		STR_INI_SECTION_NAME_VERTICAL_CURSOR, 	STR_INI_KEY_NAME_TAG_LOCATION, 					TL_TOP);
		///end NEW_OPTIONS_DIALOG
		///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT
		//m_bSnapLineToData = ini.ReadInt(STR_INI_SECTION_NAME_VERTICAL_CURSOR, STR_INI_KEY_NAME_SNAP_LINE_TO_DATA, 0);
		m_strSnappedPlot.Empty();
		///End SNAP_CURSOR_TO_DATA_PLOT
		
		///Sophy 9/23/2011 ORG-3106-S4 TURNON_SNAP_TO_NEAREST_X_BY_DEFAULT
		//m_bSnapToNearestX = false;///Jasmine 02/08/10 REMEMBER_SNAP_OPTION
		m_bSnapToNearestX = TRUE;
		///end TURNON_SNAP_TO_NEAREST_X_BY_DEFAULT
		
		m_nLineLength = LL_SPAN_LAYERS; ///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
		
		m_strDumpWksName = ini.ReadString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, STR_INI_KEY_NAME_DUMP_WKS_NAME, STR_DEFAULT_OUTPUT_WKS_NAME);

		if (m_strDumpWksName.IsEmpty())
			m_strDumpWksName = STR_DEFAULT_OUTPUT_WKS_NAME;
		///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
		string 	strKeyNameX = STR_INI_KEY_NAME_XDISPN, 	strKeyNameValX 	= "*";
		string 	strKeyNameY = STR_INI_KEY_NAME_YDISPN, 	strKeyNameValY 	= "*";
		///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
		int 	nX = OULABEL_NUMERIC, nY = OULABEL_NUMERIC;//OKCOLTYPE_TEXT_NUMERIC
		getActivePlotFormat(nX, nY);
		if 		( nX == OULABEL_DATE )//OKCOLTYPE_DATE
		{
			strKeyNameX 	= STR_INI_KEY_NAME_XDISPD;
			strKeyNameValX 	= STR_AUTO;//D1		///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		}
		else if ( nX == OULABEL_TIME )//OKCOLTYPE_TIME
		{
			strKeyNameX 	= STR_INI_KEY_NAME_XDISPT;
			strKeyNameValX 	= STR_AUTO;//T1		///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		}
		///Jasmine 08/23/2012 ORG-6419-P2 DEFAULT_AUTO_FOR_OTHER_FORMAT_TYPE_OF_AXIS_LABEL
		else if(nX != OULABEL_NUMERIC)
		{
			strKeyNameX 	= STR_INI_KEY_NAME_XDISPOTHER;
			strKeyNameValX 	= STR_AUTO;
		}
		///End DEFAULT_AUTO_FOR_OTHER_FORMAT_TYPE_OF_AXIS_LABEL
		
		if 		( nY == OULABEL_DATE )//OKCOLTYPE_DATE
		{
			strKeyNameY 	= STR_INI_KEY_NAME_YDISPD;
			strKeyNameValY 	= STR_AUTO;//D1		///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		}
		else if ( nY == OULABEL_TIME )//OKCOLTYPE_TIME
		{
			strKeyNameY 	= STR_INI_KEY_NAME_YDISPT;
			strKeyNameValY 	= STR_AUTO;//T1		///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		}
		///Jasmine 08/23/2012 ORG-6419-P2 DEFAULT_AUTO_FOR_OTHER_FORMAT_TYPE_OF_AXIS_LABEL
		else if(nY != OULABEL_NUMERIC)
		{
			strKeyNameY 	= STR_INI_KEY_NAME_YDISPOTHER;
			strKeyNameValY 	= STR_AUTO;
		}
		///End DEFAULT_AUTO_FOR_OTHER_FORMAT_TYPE_OF_AXIS_LABEL
		///End LABEL_FOLLOW_AXIS_FORMAT
		m_tagSetting.nXFormat = nX;
		m_tagSetting.nYFormat = nY;
		m_cursorshow.strXDisp = ini.ReadString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, strKeyNameX, strKeyNameValX);
		m_cursorshow.strYDisp = ini.ReadString(STR_INI_SECTION_NAME_VERTICAL_CURSOR, strKeyNameY, strKeyNameValY);		
		///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		m_cursorshow.strXDisp = _cvt_auto_format_display_str(m_cursorshow.strXDisp, false, true);
		m_cursorshow.strYDisp = _cvt_auto_format_display_str(m_cursorshow.strYDisp, false, false);
		///End SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		///end NEW_OPTIONS_DIALOG

		return bRet;
	}
	
	///------ Folger 01/20/10 SUPPORT_SAVING_VERTICAL_CURSOR_SETTINGS_IN_PAGE
	#define			STR_VERTICAL_CURSOR_SETTINGS		"VerticalCursorSettings"
	BOOL	SaveToGraph(GraphPage& gp)
	{
		Tree	tr;
		tr.VLabelSetting 		= m_labelSetting;
		tr.VCursorShow 			= m_cursorshow;
		tr.VTagSetting 			= m_tagSetting;			///Jasmine 09/11/2012 ORG-6419-P2 AXIS_TYPE_SHOULD_SAVE_IN_GRAPH
		
		///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT
		//tr.SnapLineToData.nVal= m_bSnapLineToData;
		tr.SnapLineToData.strVal= m_strSnappedPlot;
		///End SNAP_CURSOR_TO_DATA_PLOT
		tr.SnapToNearestX.nVal 	= m_bSnapToNearestX;///Jasmine 02/08/10 REMEMBER_SNAP_OPTION
		
		tr.DumpWksName.strVal 	= m_strDumpWksName;

		tr.LineLength.nVal = m_nLineLength; ///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS

		return gp.PutBinaryStorage(STR_VERTICAL_CURSOR_SETTINGS, tr);
	}

	BOOL	LoadFromGraph(GraphPage& gp)
	{
		Tree	tr;
		if ( !gp.GetBinaryStorage(STR_VERTICAL_CURSOR_SETTINGS, tr) )
		{
			LoadFromIni();		///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT, page changed, reset to default
			///Sophy 10/13/2011 ORG-3106-S17 SHOW_ALL_MEET_PLOTS_WHEN_CREATE
			m_cursorshow.vnPlotShow = 1;
			///end SHOW_ALL_MEET_PLOTS_WHEN_CREATE
			m_cursorshow.vsPlotIDs.SetSize(0);	///Jasmine 08/30/2012 ORG-6634-P1 PLOTS_ORDER_SHOULD_NOT_SAVE_INI_FOR_OTHER_GRAPHS_TO_LOAD
			m_cursorshow.vnPlotHideFromGrid = 0;///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
			return FALSE;
		}

		///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
		return LoadFromGraphTree(tr);
	}
	BOOL	LoadFromGraphTree(const TreeNode& tr)
	{
		///End PASS_MORE_INFO_TO_LINKED_GRAPH
		m_labelSetting = tr.VLabelSetting;
		m_cursorshow = tr.VCursorShow;
		m_tagSetting = tr.VTagSetting;			///Jasmine 09/11/2012 ORG-6419-P2 AXIS_TYPE_SHOULD_SAVE_IN_GRAPH
		
		///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT
		//m_bSnapLineToData = tr.SnapLineToData.nVal;
		m_strSnappedPlot = tr.SnapLineToData.strVal;
		///End SNAP_CURSOR_TO_DATA_PLOT
		m_bSnapToNearestX = tr.SnapToNearestX.nVal;///Jasmine 02/08/10 REMEMBER_SNAP_OPTION
		
		m_strDumpWksName = tr.DumpWksName.strVal;

		m_nLineLength = tr.LineLength.nVal; ///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS

		return TRUE;
	}
	///------ End SUPPORT_SAVING_VERTICAL_CURSOR_SETTINGS_IN_PAGE
	
	///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
	BOOL IsLineLengthSpanLayers()
	{
		return LL_SPAN_LAYERS == m_nLineLength;
	}
	///------End VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
	
private:
	
	bool	getActivePlotFormat(int& nX, int& nY)
	{
		GraphLayer gl = Project.ActiveLayer();
		if ( gl )
		{
			///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
			//DataPlot dp = gl.DataPlots(-1);
			//if ( dp )
			//{
				//XYRange xyRange;
				//Column colX, colY;
				//if ( dp.GetDataRange(xyRange) && xyRange.GetXColumn(colX) && xyRange.GetYColumn(colY) )
				//{
					//nX = colX.GetFormat();
					//nY = colY.GetFormat();
					//return true;
				//}
			//}
			nX = nY = OULABEL_NUMERIC;
			AxisObject aoXLabel = gl.XAxis.AxisObjects(AXISOBJPOS_LABEL_FIRST);
			if(aoXLabel.IsValid())
			{
				int 	nType, nFormat;
				string	str;
				nX = aoXLabel.GetTypeFormatEtc(nType, &str, &nFormat) == 0? nType : OULABEL_NUMERIC;	
			}
			AxisObject aoYLabel = gl.YAxis.AxisObjects(AXISOBJPOS_LABEL_FIRST);
			if(aoYLabel.IsValid())
			{
				int 	nType, nFormat;
				string	str;
				nY = aoYLabel.GetTypeFormatEtc(nType, &str, &nFormat) == 0? nType : OULABEL_NUMERIC;	
			}
			///End LABEL_FOLLOW_AXIS_FORMAT
		}
		return false;
	}
	///Jasmine 01/18/10 CONFIGURE_SHOW_HIDE_SETTING
	///Jasmine 07/18/2011 ORG-3106-S3-4 KEEP_COL_ORDER_IN_PAGE
	//void getVCursorShowStateasVector(vector<byte>& vbShows)
	///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
	//void getVCursorShowStateasVector(vector<byte>& vbShows, vector<string>& vsColMap)
	void getVCursorShowStateasVector(vector<byte>& vbShows, vector<string>& vsColMap, vector<string>& vsPlotShow,
										 vector<string>& vsPlotHideFromGrid)	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
	{	
		convert_int_vector_to_string_vector(m_cursorshow.vnPlotShow, 		vsPlotShow);
		convert_int_vector_to_string_vector(m_cursorshow.vnPlotHideFromGrid, vsPlotHideFromGrid);	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		///End MENU_TO_HIDE_PLOT_FROM_DLG
		convert_int_vector_to_string_vector(m_cursorshow.vnColMap, 			vsColMap);
		///End KEEP_COL_ORDER_IN_PAGE
		
		vbShows.SetSize(VCURSOR_SHOW_TOTAL);
		vbShows[VCURSOR_SHOW_BOOKNAME] 	= m_cursorshow.BookName;
		vbShows[VCURSOR_SHOW_SHEETNAME] = m_cursorshow.SheetName;
		///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
		//vbShows[VCURSOR_SHOW_SHORTNAME]= m_cursorshow.ShortName;
		//vbShows[VCURSOR_SHOW_LONGNAME]= m_cursorshow.LongName;
		vbShows[VCURSOR_SHOW_NAME] 		= m_cursorshow.Name;
		///end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
		vbShows[VCURSOR_SHOW_CURSORX] 	= m_cursorshow.CursorX;
		vbShows[VCURSOR_SHOW_CURSORY] 	= m_cursorshow.CursorY;
		///Jasmine 01/20/10 SHOW_NEAREST_POINT 		
		vbShows[VCURSOR_SHOW_NEAREST_X]	= m_cursorshow.CursorNearX;
		vbShows[VCURSOR_SHOW_NEAREST_Y]	= m_cursorshow.CursorNearY;
		///End SHOW_NEAREST_POINT
		vbShows[VCURSOR_SHOW_INDEX] 	= m_cursorshow.Index;
		vbShows[VCURSOR_SHOW_GRAPHNAME] = m_cursorshow.GraphName;		///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
		vbShows[VCURSOR_SHOW_STATUS] 	= m_cursorshow.Status;			///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	}
	///Jasmine 07/18/2011 ORG-3106-S3-4 KEEP_COL_ORDER_IN_PAGE
	//void setVCursorShowStatebyVector(const vector<byte>& vbShows)
	///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
	//void setVCursorShowStatebyVector(const vector<byte>& vbShows, const vector<string>& vsColMap)
	void setVCursorShowStatebyVector(const vector<byte>& vbShows, const vector<string>& vsColMap, const vector<string>& vsPlotShow, 
										const vector<string>& vsPlotHideFromGrid)	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
	{
		convert_string_vector_to_int_vector(vsPlotShow, 		m_cursorshow.vnPlotShow);
		convert_string_vector_to_int_vector(vsPlotHideFromGrid, m_cursorshow.vnPlotHideFromGrid);	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		///End MENU_TO_HIDE_PLOT_FROM_DLG
		convert_string_vector_to_int_vector(vsColMap, 			m_cursorshow.vnColMap);
		///End KEEP_COL_ORDER_IN_PAGE
		
		int nSize = vbShows.GetSize();//vbShows is from HexStrToBits, its size may not equal to VCURSOR_SHOW_TOTAL
		{	
			m_cursorshow.BookName 	= nSize > VCURSOR_SHOW_BOOKNAME?	vbShows[VCURSOR_SHOW_BOOKNAME]	: 0;
			m_cursorshow.SheetName 	= nSize > VCURSOR_SHOW_SHEETNAME?	vbShows[VCURSOR_SHOW_SHEETNAME]	: 0;
			///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
			//m_cursorshow.ShortName= nSize > VCURSOR_SHOW_SHORTNAME?	vbShows[VCURSOR_SHOW_SHORTNAME]	: 1;
			//m_cursorshow.LongName = nSize > VCURSOR_SHOW_LONGNAME? 	vbShows[VCURSOR_SHOW_LONGNAME]	: 0;
			m_cursorshow.Name 		= nSize > VCURSOR_SHOW_NAME? 		vbShows[VCURSOR_SHOW_NAME]		: 1;
			///end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
			
			//m_cursorshow.CursorX 	= nSize > VCURSOR_SHOW_CURSORX? 	vbShows[VCURSOR_SHOW_CURSORX]	: 1;
			//m_cursorshow.CursorY 	= nSize > VCURSOR_SHOW_CURSORY? 	vbShows[VCURSOR_SHOW_CURSORY] 	: 1;
			m_cursorshow.CursorX 	= 1;	///Jasmine 01/19/10 VCURSOR_ALWAYS_SHOW_XY_VALUE
			m_cursorshow.CursorY 	= 1;
			
			///Jasmine 01/20/10 SHOW_NEAREST_POINT 		
			m_cursorshow.CursorNearX= nSize > VCURSOR_SHOW_NEAREST_X? 	vbShows[VCURSOR_SHOW_NEAREST_X] : 0;
			m_cursorshow.CursorNearY= nSize > VCURSOR_SHOW_NEAREST_Y? 	vbShows[VCURSOR_SHOW_NEAREST_Y] : 0;
			///End SHOW_NEAREST_POINT
			
			m_cursorshow.Index 		= nSize > VCURSOR_SHOW_INDEX? 		vbShows[VCURSOR_SHOW_INDEX] 	: 0;
			
			m_cursorshow.GraphName	= nSize > VCURSOR_SHOW_GRAPHNAME? 	vbShows[VCURSOR_SHOW_GRAPHNAME]	: 1;//0;		///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR	///Jasmine 06/08/2012 ORG-4971-S4-2 SHOW_GRAPH_COLUMN_BY_DEFAULT
			m_cursorshow.Status		= nSize > VCURSOR_SHOW_STATUS? 		vbShows[VCURSOR_SHOW_STATUS]	: 1;			///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
		}
	}
	///End CONFIGURE_SHOW_HIDE_SETTING
};

/*----------------------------------------------------------------------------*/
/* GraphVerticalCursorManager
/*----------------------------------------------------------------------------*/

enum { CURSOR_MOVED, CURSOR_MOVING };

enum
{
	WM_USER_CURSOR_DELETED							= (WM_USER + 1100),
	WM_USER_UPDATE_CURSOR_POSITION,
	WM_USER_UPDATE_TEXT_LABELS_SHOW_STATE,
	WM_USER_TAG_ADDED,
	WM_USER_TAG_DELETED,
	WM_USER_UPDATE_TAG_SELECT_STATE,

	WM_USER_UPDATE_CURSOR_INTERSECT_POINT_BEGIN,
	WM_USER_NEW_CURSOR_INTERSECT_POINT,

	///------ Folger 01/22/10 CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE
	WM_USER_QUERY_POSITION_CHANGE_BY_EDITING,
	///------ End CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE
	
	WM_USER_MOVE_LINE, 	///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
};

enum VerticalCursorObjType
{
	VCOT_LINE			= 0,
	VCOT_TEXT_LABEL		= 1,
	VCOT_TAG			= 2,
	VCOT_TAG_LABEL		= 3,
};

BOOL on_vertical_cursor_object_event(int nEvent, LPCSTR lpcszObjectName, VerticalCursorObjType objType)
{
	// If we select the line and then duplicate the graph, then we may failed to load the duplicated graph's cursor info
	// since the GetUID will make origin skip the reuid codes
	if (VCOT_LINE == objType && OE_UNSELECT == nEvent)
		return FALSE;

	///Sophy 9/22/2011 ORG-3843-P2 RUNTIME_ERROR_WHEN_SHOW_HIDDEN_PLOT_FROM_PLOTDETAILS_DLG
	//const UINT uPageUID = Project.ActiveLayer().GetPage().GetUID(TRUE);
	GraphLayer gl = Project.ActiveLayer();
	if ( !gl )
		return FALSE;
	const UINT uPageUID = gl.GetPage().GetUID(TRUE);
	///end RUNTIME_ERROR_WHEN_SHOW_HIDDEN_PLOT_FROM_PLOTDETAILS_DLG
	if (VCOT_LINE == objType)
	{
		THE_VCURSOR_MANAGER.OnGraphLineEvent(nEvent, uPageUID);
		return TRUE;
	}
	else
	{
		GraphObject go = Project.ActiveLayer().GraphObjects(lpcszObjectName);
		if (go.IsValid())
		{
			const UINT uObjUID = go.GetUID(TRUE);
			switch (objType)
			{
			case VCOT_TEXT_LABEL:
				THE_VCURSOR_MANAGER.OnTextLabelEvent(nEvent, uPageUID, uObjUID);
				break;
#ifndef REMOVE_TAG_FEATURE
			case VCOT_TAG:
				THE_VCURSOR_MANAGER.OnTagEvent(nEvent, uPageUID, uObjUID);
				break;
			case VCOT_TAG_LABEL:
				THE_VCURSOR_MANAGER.OnTagLabelEvent(nEvent, uPageUID, uObjUID);
				break;
#endif//REMOVE_TAG_FEATURE
			}
			return TRUE;
		}
	}
	return FALSE;
}

#define CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN	\
	const bool bIsCurrentIndexValid = ( m_nCurrentTargetHolderIndex >= 0 && m_nCurrentTargetHolderIndex < m_arrGraphVerticalCursorHolders.GetSize() );\
	if ( bIsCurrentIndexValid )\
	{\
		GraphVerticalCursorHolder& gvcCurrentHolder = m_arrGraphVerticalCursorHolders.GetAt(m_nCurrentTargetHolderIndex);

#define CHECK_GET_CURRENT_CURSOR_HOLDER_END		\
	}

enum LoadCursorResult
{
	LOAD_CURSOR_INFO_FAILED			= -1,	// The tree is not exist in the page or failed to load

	LOAD_CURSOR_INFO_OK				= 0,
	CURSOR_INFO_EXIST_IN_MANAGER	= 1,
};

class GraphVerticalCursorManager
{
public:
	// Kenny:  Related tracker #4991
	//	By designed, user can only call the other public methods by GetInstance(), and there's only
	// one single instance of this class exist in the memory all the time (Singleton).
	// We have several reasons for doing this:
	//	1. This helps preventing creating the member data over and over when constructs the instances of this class
	//	2. To make the global event handler and the dialog access the same manager object.
	// but this is not supported by OC currently, so we have to use get_graph_vertical_cursor_manager() instead.

	//static GraphVerticalCursorManager& GetInstance()
	//{
		//static GraphVerticalCursorManager s_Manager;
		//return s_Manager;
	//}

	// The constructor and destructor are private to prevent creating this object instance by user
private:
	GraphVerticalCursorManager()
	{
		m_arrGraphVerticalCursorHolders.SetAsOwner(TRUE);
		m_pParentWnd = NULL;
		m_nCurrentTargetHolderIndex = -1;
		
		m_bBusy = false;	///Sophy 9/20/2011 ORG-3843-P1 PROPER_LOAD_SETTINGS_WHEN_OPEN_OGG
		
		m_Setting.LoadFromIni();
		
		m_arrPoints.SetAsOwner(TRUE);///Jasmine 01/15/10 REORDER_CURSOR_VALUE_BY_LAYER_POS

		///------ Folger 07/30/2012 ORG-6340-P1 ORIGIN_CRASH_WHEN_ADD_VERTICAL_CURSOR_TO_LINKED_GRAPH
		m_bCursorStarting = FALSE;
		///------ End ORIGIN_CRASH_WHEN_ADD_VERTICAL_CURSOR_TO_LINKED_GRAPH
		///Sophy 9/13/2012 ORG-6504-P1 GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
		m_bLastMovedByKey = false;
		///end GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
	}
	~GraphVerticalCursorManager()
	{
	}
public:
	// Controlling tool
	BOOL	CanStartVerticalCursor();
	BOOL	StartVerticalCursor(Window* pParentWnd = NULL, UINT uPageUID = 0);
	BOOL	RemoveVerticalCursor(UINT uPageUID = 0);
	///------ Folger 01/22/09 ORIGIN_CRASH_WHEN_EXIT_IF_GRAPH_PAGE_HAS_VERTICAL_CURSOR_IS_NOT_ACTIVE
	void	ResetParentWnd();
	///------ End ORIGIN_CRASH_WHEN_EXIT_IF_GRAPH_PAGE_HAS_VERTICAL_CURSOR_IS_NOT_ACTIVE

	BOOL	HasCursorHolderForPage(UINT uPageUID = 0) { return ( getCursorHolderIndex( getActualPageUID(uPageUID) ) >= 0 ); }

	int		LoadCursorInfoFromPage(UINT uPageUID = 0, int* pnHolderIndex = NULL );	// return LoadCursorResult

	BOOL	IsPageCurrentTarget(UINT uPageUID = 0);

	BOOL	RetrieveCursorInfo(UINT uPageUID = 0);

	///------ Folger 07/30/2012 ORG-6340-P1 ORIGIN_CRASH_WHEN_ADD_VERTICAL_CURSOR_TO_LINKED_GRAPH
	BOOL	IsCursorStarting() { return m_bCursorStarting; }
	///------ End ORIGIN_CRASH_WHEN_ADD_VERTICAL_CURSOR_TO_LINKED_GRAPH
	///Sophy 9/13/2012 ORG-6504-P1 GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
	void	SetLastMovedByKey(bool bByKey){ m_bLastMovedByKey = bByKey; }
	///end GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
	// Accessing holder data
	const GraphVerticalCursorHolder* GetCursorHolderPointer(UINT uPageUID = 0, int* pnHolderIndex = NULL);

// Note: The following public methods use the m_nCurrentTargetHolderIndex for speed up accessing target.

	// Accessing line
	BOOL 	IsOutOfView( double dXScale );	///Jasmine 01/28/10 RESTRICT_X_EDIT_TEXT
	BOOL	SetLinePosition(double dXScale);
	BOOL	GetLinePosition(double& rdPos, bool bIsMoving = false);

	///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT
	//BOOL	IsLineSnappedToData() { return m_Setting.m_bSnapLineToData; }
	//void	SnapLineToData(BOOL bSnapToData = TRUE);
	BOOL	IsLineSnappedToData(DataPlot* pdpSnapped = NULL);
	void	SnapLineToData(LPCSTR lpcszSnappedPlot);
	///End SNAP_CURSOR_TO_DATA_PLOT

	// Accessing TextLabels
	BOOL	ShowTextLabels(bool bShow = true);
	BOOL	IsTextLabelsShown();
	BOOL	DumpTextLabels();					///Jasmine 07/21/2011 ORG-3106-S8 DUMP_LABEL_AND_LINE_ON_GRAPH
	///------ Folger 08/21/2012 ORG-4971-S6 LINK_TAGS_ON_LINKED_GRAPHS
	//BOOL 	DumpTextLabelsToGraph(GraphLayer& gl, double dX0, double dX1);		///Jasmine 03/22/2012 ORG-4971 DUMP_TAG_AND_LABEL_TO_LINKED_GRAPHS
	BOOL 	DumpTextLabelsToGraph(GraphLayer& gl, double dX0, double dX1, GraphObject* pTagLine = NULL);
	///------ End LINK_TAGS_ON_LINKED_GRAPHS
	
	// Accessing Tags
	BOOL	AddTags();
	BOOL	RemoveTag(const vector<UINT>& vnTagUID);
	BOOL	RemoveSelectedTagsGroups();
	BOOL	ClearAllTags();
	int 	GetNumTags();

	BOOL	SelectTagsGroup(BOOL bNextGroup = TRUE);

	UINT	GetSelectedTagsCount();

	// TagLabel & TextLabel
	BOOL	UpdateLabelsFontSize(bool bIncrease = true);
	BOOL	SetLabelsSignificantDigits(int nSignificantDigits);
	int		GetLabelsSignificantDigits() { return m_Setting.m_labelSetting.nSignificantDigits; }

	// Misc.
	/// Iris 
	BOOL  	GetSetting(VManagerSetting& stSetting);
	BOOL  	SetSetting(const VManagerSetting& stSetting);
	BOOL	DumpTagValues();//DumpData();
	BOOL	DumpCursorValues();
	BOOL 	ActivateOutputWks();	///Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS	
	
	void 	GetCursorDisplayOrder(vector<int>& vnIndeces, UINT uPageUID);	///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER
	
	BOOL	SetLabelsText(int nSignificantDigits, int nTextType, LPCSTR lpcszCustomText = NULL);
	
	///------ Folger 01/22/10 CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE
	BOOL	WorldToView(GraphLayer& glParent, double& rView, double rWorld);//BOOL	WorldToView(double& rView, double rWorld);	///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
	///------ End CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE
	
#ifdef _DEBUG
	void	ClearAllCursorHolders()
	{
		const int nHolderSize = m_arrGraphVerticalCursorHolders.GetSize();
		for (int ii = nHolderSize-1; ii >= 0; --ii)
		{
			removeCursorHolder(ii);
		}
	}
	void	ShowPropertiesTree()
	{
		CStopWatch watch("ShowPropertiesTree()");
		Tree trProperties;
		BOOL bRet = GetProperties(trProperties);
		out_tree(trProperties);
	}
#endif // _DEBUG

	///------ Folger 01/21/09 VERTICAL_CURSOR_CRASH_ORIGIN_IF_ACCESS_ARRAY_MEMBER_OF_MANAGER_OBJECT_DIRECTLY
	/// This kind of Array member accessing is not safe in Origin :
	/// 
	///			Array<VIntersectPoint&>& arrPoints = THE_VCURSOR_MANAGER.m_arrPoints;
	///			VIntersectPoint& pti = arrPoints.GetPoint( 0 );
	/// 
	/// When arrPoints is destroyed, it may crash Origin. Here just walk around it before more general fix.
	VIntersectPoint*	GetPoint(int nIndex)
	{
		if ( nIndex < 0 || nIndex >= GetPointsCount() )
			return NULL;

		VIntersectPoint&	pt = m_arrPoints.GetAt(nIndex);
		return &pt;
	}

	int					GetPointsCount()
	{
		return m_arrPoints.GetSize();
	}
	///------ End VERTICAL_CURSOR_CRASH_ORIGIN_IF_ACCESS_ARRAY_MEMBER_OF_MANAGER_OBJECT_DIRECTLY

public:
	void	OnGraphLineEvent(int nEvent, UINT uPageUID);
	void	OnTagEvent(int nEvent, UINT uPageUID, UINT uTagUID);
	void	OnTagLabelEvent(int nEvent, UINT uPageUID, UINT uTagLabelUID);
	void	OnTextLabelEvent(int nEvent, UINT uPageUID, UINT uTextLabelUID);
	
	///Jasmine 03/15/2012 ORG-4971 LINK_CURRENT_GADGET_TO_OTHER_GRAPHS
	bool	CanLinkGraph();
	bool	HasLinkedGraphs();
	bool 	LinkGraphs(LPCSTR lpczGraphs);
	bool 	UnlinkGraphs(LPCSTR lpczGraphs);
	///End LINK_CURRENT_GADGET_TO_OTHER_GRAPHS
	
	///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	void	GraphRefresh();
	///End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	///Sophy 8/11/2011 ORG-3106-S5 PROPER_SHOWHIDE_LABEL_OBJ_BY_UID
	//bool 	ShowTextLabel(UINT uPageUID, UINT uTextLabelUID, bool bShow);///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
	bool 	ShowPlotTextLabel(UINT uPageUID, UINT uAttachedPlotUID, bool bShow);///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
	///end PROPER_SHOWHIDE_LABEL_OBJ_BY_UID
	
	///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
	void	ToggleLineLength(BOOL bVertical);
	///------ End VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
	
protected:
	void	OnLineDeleted(UINT uPageUID);
	void	OnPageWndClosed(UINT uPageUID);
	void	OnUpdateLinePosition(UINT uPageUID, bool bIsMoving);

	void	OnUpdateTextLabelsShowState(UINT uPageUID);

	void	OnTagSelected(UINT uPageUID, UINT uTagUID);
	void	OnTagUnselected(UINT uPageUID, UINT uTagUID);
	void	OnTagDeleted(UINT uPageUID, UINT uTagUID);

	void	OnTagLabelDeleted(UINT uPageUID, UINT uTagLabelUID);

	void	OnTextLabelMoved(UINT uPageUID, UINT uTextLabelUID);
	void	OnTextLabelDeleted(UINT uPageUID, UINT uTextLabelUID);
	
#ifdef _DEBUG
	BOOL	GetProperties(TreeNode& tnProperties);
	BOOL	SetProperties(const TreeNode& tnProperties);
#endif // _DEBUG
private:
	///Sophy 10/19/2011 ORG-3848-P1 ADD_TAG_AND_LABEL_SHOULD_FOLLOW_CURRENT_FONT_SETTING
	//BOOL	createTag(GraphLayer& glParent, GraphObject& goLine, GraphObject& goLabel);
	BOOL	createTag(GraphLayer& glParent, GraphObject& goLine, GraphObject& goLabel, int nFontSize = 16);
	///end ADD_TAG_AND_LABEL_SHOULD_FOLLOW_CURRENT_FONT_SETTING
	UINT	getActualPageUID(UINT uPageUID = 0);
	int		getCursorHolderIndex(UINT uPageUID);

	void	onUpdateTagSelectState(UINT uPageUID, UINT uTagUID, BOOL bSelected);

	BOOL	removeCursorHolder(UINT uHolderIndex);

	BOOL	cleanupTagsEventHandlerScript(GraphVerticalCursorHolder& gvcHolder);

	VTagUnit* addTag(GraphVerticalCursorHolder& gvcHolder, const GraphLayer& gl, double dXScaleMark);
	int 	addTagDone(GraphVerticalCursorHolder& gvcHolder, const VTagUnit& vTagUnit);
	int		removeTag(GraphVerticalCursorHolder& gvcHolder, UINT uTagIndex);
	//int		getAllTagsPosAndPlotInfo( const GraphVerticalCursorHolder& gvcHolder, vector<int>& vnXCenter, vector<int>& vnYCenter = NULL, vector<UINT>& vnTagPlotUIDMap = NULL );
	int		getAllTagsPosAndPlotInfo( const GraphVerticalCursorHolder& gvcHolder, vector<int>& vnXCenter);
	int		getTagsInSamePageX( const GraphVerticalCursorHolder& gvcHolder, int nPageX, vector<UINT>& vnTagIndices );

	bool	retrieveHolderCursorInfo(GraphVerticalCursorHolder& gvcHolder, bool bUpdateTextLabels = true,  bool bUpdateNotation = true);
	bool 	retrieveOneGraphVIntersectPoint(GraphVerticalCursorHolder& gvcHolder, GraphPage& gp, double rLinePageCoord, bool bUpdateTextLabels, bool bUpdateNotation,				///Jasmine 03/16/2012 ORG-4971 RETRIEVE_CURSOR_VALUE_FROM_LINKED_GRAPHS
											vector<int>& vnLayerIndex = NULL,			///Jasmine 05/03/2012 ORG-4971-P1 LINK_GRAPHS_SHOULD_HAVE_ITS_OWN_LAYER_FILTER
											bool bHideTextLabels = false, 				///Jasmine 03/22/2012 ORG-4971 DUMP_TAG_AND_LABEL_TO_LINKED_GRAPHS
											int* pnLabelFontSize = NULL);				///Jasmine 05/2202012 ORG-4917-P2 UPDATE_LINK_GRAPH_LABEL_FONT_SIZE
	///Sophy 10/13/2011 ORG-3106-S16 UPDATE_GRAPH_FILTER_ON_EACH_MOVEMENT
	bool	updateGraphFilter(GraphVerticalCursorHolder& gvcHolder);
	bool	updateGraphFilter(double dPagePos, const GraphPage& gp, vector<int>& vnLayerIndex);		///Jasmine 05/03/2012 ORG-4971-P1 LINK_GRAPHS_SHOULD_HAVE_ITS_OWN_LAYER_FILTER
	bool	hideAttachedLabels(GraphLayer& gl);
	///end UPDATE_GRAPH_FILTER_ON_EACH_MOVEMENT
	///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	void	ForceUpdate(GraphVerticalCursorHolder& Holder);
	///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	
	string 	makeCustomText(int nSignificantDigits, int nTextType, LPCSTR lpcszCustomText, int nXFormat = OULABEL_NUMERIC, int nYFormat = OULABEL_NUMERIC, LPCSTR lpcszXDateTime = NULL, LPCSTR lpcszYDateTime = NULL, int nCheckXFormat = OULABEL_NUMERIC, int nCheckYFormat = OULABEL_NUMERIC);//OKCOLTYPE_NUMERIC	///Jasmine 07/20/2011 ORG-3106-S4-1 FIX_DIGIT_SETTING_NOT_APPLY_TO_LABEL
	string	makeTagText(int nFormat = OULABEL_NUMERIC, LPCSTR lpcszXFormat = NULL, int nCheckFormat = OULABEL_NUMERIC);//OKCOLTYPE_NUMERIC	///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT

	BOOL	ErrorReport(LPCSTR lpcszMsg);

private:
	Array<GraphVerticalCursorHolder&>	m_arrGraphVerticalCursorHolders;

	// Kenny: I use the index of holder ( in the array ) instead of using a pointer to holder for the following reasons:
	// 1. Get rid of the dangling pointer (a pointer that points to an invalid object) issue.
	// 2. We can directly remove the holder from the array by using the index.
	// 3. Moreover, using a pointer does not speed up the accessing ( tested comparing with using index ).
	int									m_nCurrentTargetHolderIndex;

	Window*								m_pParentWnd;

	VManagerSetting						m_Setting;
	
	Array<VIntersectPoint&>				m_arrPoints;///Jasmine 01/15/10 REORDER_CURSOR_VALUE_BY_LAYER_POS
	
	bool								m_bBusy;	///Sophy 9/20/2011 ORG-3843-P1 PROPER_LOAD_SETTINGS_WHEN_OPEN_OGG

	///------ Folger 07/30/2012 ORG-6340-P1 ORIGIN_CRASH_WHEN_ADD_VERTICAL_CURSOR_TO_LINKED_GRAPH
	BOOL m_bCursorStarting;
	///------ End ORIGIN_CRASH_WHEN_ADD_VERTICAL_CURSOR_TO_LINKED_GRAPH
	///Sophy 9/13/2012 ORG-6504-P1 GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
	bool								m_bLastMovedByKey;
	///end GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
};

BOOL GraphVerticalCursorManager::CanStartVerticalCursor()
{
	GraphLayer glActive = Project.ActiveLayer();
	if( !glActive )
		return FALSE;
	GraphPage gp = glActive.GetPage();
	if (gp)
	{
		bool bExistDataPlot = false;
		bool bExist3DGraph = false;
		foreach(GraphLayer gl in gp.Layers)
		{
			if ( is_3D_graph(gl) )
			{
				bExist3DGraph = true;
				break;
			}
			if ( !bExistDataPlot && gl.DataPlots.Count() > 0 )
			{
				bExistDataPlot = true;
			}
		}
		if (bExist3DGraph)
			return ErrorReport(_L("This tool is NOT available for 3D Graph!"));
		if (!bExistDataPlot)
			return ErrorReport(_L("This tool can ONLY be used in a GraphPage that has at lease one dataplot in it!"));
		return TRUE;
	}
	return FALSE;
}

BOOL	GraphVerticalCursorManager::ErrorReport(LPCSTR lpcszMsg)
{
	warning_msg_box(lpcszMsg, true, 'E');
	return FALSE;
}

BOOL GraphVerticalCursorManager::StartVerticalCursor( Window* pParentWnd /*= NULL*/, UINT uPageUID /*= 0*/ )
{
	if ( !CanStartVerticalCursor() )
		return FALSE;

	GraphVerticalCursorHolder* pHolder = NULL;
	bool bCreatedNewOne = false;

	int nHolderIndex = -1;
	LoadCursorInfoFromPage(uPageUID, &nHolderIndex);

	if (nHolderIndex < 0)
	{
		///------ Folger 07/30/2012 ORG-6340-P1 ORIGIN_CRASH_WHEN_ADD_VERTICAL_CURSOR_TO_LINKED_GRAPH
		OCVarTempChangeBOOL tmpchangeStarting(m_bCursorStarting, TRUE);
		///------ End ORIGIN_CRASH_WHEN_ADD_VERTICAL_CURSOR_TO_LINKED_GRAPH

		pHolder = new GraphVerticalCursorHolder( uPageUID = getActualPageUID(uPageUID) );
		if (NULL == pHolder)
		{
			ASSERT(FALSE);
			return FALSE;
		}
		///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
		//bCreatedNewOne = pHolder->m_line.GetValidObj().Create(TRUE);
		bCreatedNewOne = pHolder->m_line.GetValidObj().Create(LineCreate_Vertical | (m_Setting.IsLineLengthSpanLayers() ? LineCreate_Span_Layers : 0));
		///------ End VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
		if ( bCreatedNewOne )
		{

			string strLTScript;
			strLTScript.Format(STR_OBJ_EVENT_LT_SCRIPT_FORMAT, VCOT_LINE);
			bCreatedNewOne = pHolder->m_line.GetValidObj().SetLabTalkScriptEvent(strLTScript);
		}
		if (!bCreatedNewOne)
		{
			delete pHolder;
			ASSERT(FALSE);
			return FALSE;
		}
		
	#ifdef REMOVE_LABEL_FEATURE
		pHolder->m_Settings.bShowTextLabels = FALSE;
	#else
		pHolder->m_Settings.bShowTextLabels = TRUE;
	#endif
		nHolderIndex = m_arrGraphVerticalCursorHolders.Add(*pHolder);

		pHolder->SaveHolderSettingsToPage();
		pHolder->SaveLinePropertiesToPage();

		MY_DBG_OUTPUT1("A new GVCHolder is created! Total = %u", m_arrGraphVerticalCursorHolders.GetSize() );
	}
	else
	{
		const GraphVerticalCursorHolder& gvcHolder = m_arrGraphVerticalCursorHolders.GetAt(nHolderIndex);
		pHolder = &gvcHolder;
		MY_DBG_OUTPUT2("Switched to the %dth GVC, Total = %u", (nHolderIndex+1), m_arrGraphVerticalCursorHolders.GetSize() );
	}

	m_pParentWnd = pParentWnd;
	m_nCurrentTargetHolderIndex	= nHolderIndex;

	///------ Folger 01/20/10 SUPPORT_SAVING_VERTICAL_CURSOR_SETTINGS_IN_PAGE
	const GraphVerticalCursorHolder* pgvcHolder = GetCursorHolderPointer();
	if(pgvcHolder)
		m_Setting.LoadFromGraph( pgvcHolder->GetPage() );
	///------ End SUPPORT_SAVING_VERTICAL_CURSOR_SETTINGS_IN_PAGE

	if (bCreatedNewOne)
	{
		m_bBusy = true;
		//OnUpdateLinePosition(uPageUID, false);	// We have to call this function to create/update the TextLabels
		// The above codes may cause twice time running OnUpdateLinePosition, so we have to trigger the OnUpdateLinePosition in this way.
		ForceUpdate(*pHolder);
		
		///Sophy 10/13/2011 ORG-3106-S18 PLACE_VERTICAL_LINE_AT_MIDDLE_OF_ACTIVE_LAYER
		m_bBusy = false;
		GraphLayer glActive = Project.ActiveLayer();
		if ( glActive )
		{
			///Sophy 10/19/2011 ORG-3848-P1 BETTER_INIT_POSITION_WHEN_X_NOT_LINEAR_SCALE
			//SetLinePosition((glActive.X.From + glActive.X.To) / 2);
			double dFrom = glActive.X.From;
			double dTo = glActive.X.To;
			int nScaleType = glActive.X.Type;
			if ( SCALE_TYPE_LINEAR != nScaleType )
			{
				dFrom = real_space(dFrom, nScaleType);
				dTo = real_space(dTo, nScaleType);
			}
			double dMiddle = (dFrom + dTo) / 2;
			if ( SCALE_TYPE_LINEAR != nScaleType )
			{
				dMiddle = real_inv_space(dMiddle, nScaleType);
			}
			///end BETTER_INIT_POSITION_WHEN_X_NOT_LINEAR_SCALE
			SetLinePosition(dMiddle);
		}
		///end PLACE_VERTICAL_LINE_AT_MIDDLE_OF_ACTIVE_LAYER
		
		///Sophy 9/27/2011 ORG-3106-S16 PROPER_FILTER_LAYER_FOR_VERTICAL_INTERSECT_CALC
		///Sophy 10/13/2011 ORG-3106-S16 UPDATE_GRAPH_FILTER_ON_EACH_MOVEMENT
		//double dPagePos = pHolder->m_line.GetPagePosition();
		//GraphLayer glParent;
		//pHolder->m_line.GetParent(glParent);
		//pHolder->m_Settings.vnLayerIndex.SetSize(0);
		//pHolder->m_Settings.vnLayerIndex.Add(glParent.GetIndex());
		//GraphPage gp = glParent.GetPage();
		//foreach(GraphLayer gl in gp.Layers)
		//{
			//if ( gl.GetIndex() == glParent.GetIndex() )
				//continue; //already added.
			//
			//double dDim[DIM_ELEM_COUNT];
			//gl.GetPosition(dDim);
			//gl.UnitsConvert(M_PIXEL, dDim);
			//double dLeft = dDim[LEFT_POS];
			//double dRight = dDim[DIM_WIDTH] + dLeft;
			//if ( dPagePos > dLeft && dPagePos < dRight )
			//{
				//pHolder->m_Settings.vnLayerIndex.Add(gl.GetIndex());
			//}
		//}
		updateGraphFilter(*pHolder);
		///end UPDATE_GRAPH_FILTER_ON_EACH_MOVEMENT
		///end PROPER_FILTER_LAYER_FOR_VERTICAL_INTERSECT_CALC

	}
	return pHolder;
}

BOOL GraphVerticalCursorManager::RemoveVerticalCursor(UINT uPageUID /*= 0*/)
{
	int nHolderIndex = getCursorHolderIndex( uPageUID = getActualPageUID(uPageUID) );
	if (nHolderIndex >= 0)
		return removeCursorHolder(nHolderIndex);
	return TRUE;	// True or false means nothing if the holder does not exist, so return TRUE to hint "success"
}

///------ Folger 01/22/09 ORIGIN_CRASH_WHEN_EXIT_IF_GRAPH_PAGE_HAS_VERTICAL_CURSOR_IS_NOT_ACTIVE
void	GraphVerticalCursorManager::ResetParentWnd()
{
	m_pParentWnd = NULL;
}
///------ End ORIGIN_CRASH_WHEN_EXIT_IF_GRAPH_PAGE_HAS_VERTICAL_CURSOR_IS_NOT_ACTIVE

int GraphVerticalCursorManager::LoadCursorInfoFromPage( UINT uPageUID /*= 0*/, int* pnHolderIndex /*= NULL */ )
{
	int nRetValue = CURSOR_INFO_EXIST_IN_MANAGER;
	int nHolderIndex = getCursorHolderIndex( uPageUID = getActualPageUID(uPageUID) );
	if (nHolderIndex < 0)
	{
		BOOL bRet = FALSE;
		// This may probably cause allocating/deallocating the holder frequently, 
		// but we have no choice since only the holder "knows" how to initialize itself from page storage
		GraphVerticalCursorHolder* pHolder = new GraphVerticalCursorHolder(uPageUID);
		if (pHolder)
		{
			bRet = pHolder->InitPropertiesFromPage();
			if (bRet)
			{
				nHolderIndex = m_arrGraphVerticalCursorHolders.Add(*pHolder);
				bRet = nHolderIndex >= 0;
			}
			if ( !bRet )
			{
				nHolderIndex = -1;
				delete pHolder;
				//ASSERT(FALSE);
			}

			if ( pHolder )
				ForceUpdate(*pHolder);
		}
		nRetValue = (bRet ? LOAD_CURSOR_INFO_OK : LOAD_CURSOR_INFO_FAILED);
	}
	if (pnHolderIndex)
		*pnHolderIndex = nHolderIndex;
	return nRetValue;
}

BOOL GraphVerticalCursorManager::IsPageCurrentTarget( UINT uPageUID /*= 0*/ )
{
	uPageUID = getActualPageUID(uPageUID);
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		const BOOL bIsPageCurrentTarget = gvcCurrentHolder.m_uPageUID == uPageUID;
		return bIsPageCurrentTarget;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return FALSE;
}

BOOL GraphVerticalCursorManager::RetrieveCursorInfo( UINT uPageUID /*= 0*/ )
{
	///Sophy 9/20/2011 ORG-3843-P1 PROPER_LOAD_SETTINGS_WHEN_OPEN_OGG 
	if ( m_bBusy )
		return false;
	VerticalCursorBusyHelper _busy(&m_bBusy);
	///end PROPER_LOAD_SETTINGS_WHEN_OPEN_OGG
	
	uPageUID = getActualPageUID(uPageUID);
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		return retrieveHolderCursorInfo(gvcCurrentHolder);//return retrieveHolderCursorInfo(gvcCurrentHolder, false);///Jasmine 07-11-2011 ORG-3106-S2 BRING_BACK_LABEL_FEATURE
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return FALSE;
}

const GraphVerticalCursorHolder* GraphVerticalCursorManager::GetCursorHolderPointer( UINT uPageUID /*= 0*/, int* pnHolderIndex /*= NULL*/ )
{
	GraphVerticalCursorHolder* pHolder = NULL;
	const int nHolderIndex = getCursorHolderIndex( uPageUID = getActualPageUID(uPageUID) );
	if (nHolderIndex >= 0)
	{
		const GraphVerticalCursorHolder& gvcHolder = m_arrGraphVerticalCursorHolders.GetAt(nHolderIndex);
		pHolder = &gvcHolder;
	}
	if (pnHolderIndex)
		*pnHolderIndex = nHolderIndex;
	return pHolder;
}
///Jasmine 01/28/10 RESTRICT_X_EDIT_TEXT
BOOL GraphVerticalCursorManager::IsOutOfView( double dXScale )
{
	if( is_missing_value(dXScale) )
		return TRUE;
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		GraphLayer glParent;
		gvcCurrentHolder.GetXBasedLayer(glParent);//gvcCurrentHolder.m_line.GetParent(glParent);	///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
		
		Scale scale = glParent.X;		
		double dFrom= scale.From*1.5-scale.To*0.5;
		double dTo 	= scale.To*1.5-scale.From*0.5;
		return dXScale < min(dFrom, dTo) || dXScale > max(dFrom, dTo);
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return TRUE;
}
///End RESTRICT_X_EDIT_TEXT
BOOL GraphVerticalCursorManager::SetLinePosition( double dXScale )
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		if( is_equal(gvcCurrentHolder.m_line.GetValidObj().GetPosition(), dXScale) )
			return FALSE;
		// Kenny: These following codes helps erasing the extra "ghost line" when the line is selected by user.
		// This is a temporary solution, please see related Tracker #13620
		Selection mySelection;
		mySelection.Remove(gvcCurrentHolder.m_line);
		GraphPage gp = gvcCurrentHolder.GetPage();
		if (gp)
			gp.Refresh(TRUE);
		gvcCurrentHolder.m_line.GetValidObj().SetPosition(dXScale);
		return TRUE;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return FALSE;
}

BOOL GraphVerticalCursorManager::GetLinePosition( double& rdPos, bool bIsMoving /*= false*/ )
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		rdPos = gvcCurrentHolder.m_line.GetValidObj().GetPosition(bIsMoving);
		return TRUE;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return FALSE;
}

///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT
//void GraphVerticalCursorManager::SnapLineToData( BOOL bSnapToData /*= TRUE*/ )
//{
	//m_Setting.m_bSnapLineToData = bSnapToData;
	//if (bSnapToData)
	//{
		//CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
		//{
			//gvcCurrentHolder.m_line.GetValidObj().SnapToData(TRUE);
		//}
		//CHECK_GET_CURRENT_CURSOR_HOLDER_END
	//}
//}

///------ Folger 01/27/10 VERTICAL_CURSOR_SNAP_TO_NEAREST_X_DATA
#define		STR_PLOT_NEAREST_X		"NearestX"
///------ End VERTICAL_CURSOR_SNAP_TO_NEAREST_X_DATA
BOOL	GraphVerticalCursorManager::IsLineSnappedToData(DataPlot* pdpSnapped)
{
	///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	if ( m_Setting.m_bSnapToNearestX )
		return TRUE;
	///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	
	if( !m_Setting.m_strSnappedPlot.IsEmpty() )
	{
		///------ Folger 01/27/10 VERTICAL_CURSOR_SNAP_TO_NEAREST_X_DATA
		if ( m_Setting.m_strSnappedPlot.Compare(STR_PLOT_NEAREST_X) == 0 )
			return TRUE;
		///------ End VERTICAL_CURSOR_SNAP_TO_NEAREST_X_DATA

		DataPlot dp;
		XYRange rng;
		if( okxf_init_range_from_string(&rng, m_Setting.m_strSnappedPlot) && rng.IsValid() )
			rng.GetPlot(dp);

		if( dp.IsValid() )
		{
			if( pdpSnapped )
				*pdpSnapped = dp;
			return true;
		}
		else
		{
			m_Setting.m_strSnappedPlot.Empty();
		}
	}
	return false;
}

void GraphVerticalCursorManager::SnapLineToData(LPCSTR lpcszSnappedPlot)
{
	m_Setting.m_strSnappedPlot = lpcszSnappedPlot;
	DataPlot dpSnapped;
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		if( IsLineSnappedToData(&dpSnapped) )
		{
			gvcCurrentHolder.m_line.GetValidObj().SnapToPlot(dpSnapped);
			///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
			m_Setting.m_strSnappedPlot = gvcCurrentHolder.m_line.GetValidObj().GetLastSnapToPlotDescription();
			///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
		}
		else
		{
			gvcCurrentHolder.m_line.GetValidObj().SnapToNone();
		}
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
}
///End SNAP_CURSOR_TO_DATA_PLOT

BOOL GraphVerticalCursorManager::ShowTextLabels( bool bShow /*= true*/ )
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		FOR_EACH_TEXT_LABEL_BEGIN(gvcCurrentHolder, label)
		{
			///Sophy 9/19/2011 ORG-3106-P9 LABEL_AND_TAG_VALUE_NOT_UPDATE_WHEN_HIDDEN
			//label.GetValidObj().Show = bShow;
			bool bPlotShow = bShow;
			int nPlotIndex = m_Setting.m_cursorshow.vsPlotIDs.Find((string)label.GetAttachedPlotUID());
			if ( nPlotIndex >= 0 )
			{
				bPlotShow = m_Setting.m_cursorshow.vnPlotShow[nPlotIndex] != 0;
			}
			label.GetValidObj().Show = bShow && bPlotShow;
			///end LABEL_AND_TAG_VALUE_NOT_UPDATE_WHEN_HIDDEN
		}
		FOR_EACH_TEXT_LABEL_END

		gvcCurrentHolder.m_Settings.bShowTextLabels = bShow;
		gvcCurrentHolder.SaveHolderSettingsToPage();

		if (bShow)
			retrieveHolderCursorInfo(gvcCurrentHolder);
		OnUpdateTextLabelsShowState( gvcCurrentHolder.m_uPageUID );
		return TRUE;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return FALSE;
}

BOOL GraphVerticalCursorManager::IsTextLabelsShown()
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		return gvcCurrentHolder.m_Settings.bShowTextLabels;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return FALSE;
}

///Jasmine 07/21/2011 ORG-3106-S8 DUMP_LABEL_AND_LINE_ON_GRAPH
#ifdef REMOVE_TAG_FEATURE
BOOL GraphVerticalCursorManager::DumpTextLabels()
{	
	int nUpdateLabelCount = 0;
	bool bNeedAddTag = true;
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		GraphLayer 	gl;
		gvcCurrentHolder.GetXBasedLayer(gl);//gvcCurrentHolder.m_line.GetParent(gl);	///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
		
		GraphObject	goLine = gvcCurrentHolder.m_line.GetValidObj();
		Tree trFmt;
		trFmt = goLine.GetFormat(FPB_DATA, FOB_ALL, true, true);
		
		string strPath = "Root.Data";
		TreeNode trX = trFmt.GetNodeFromPath(strPath+".X");
		TreeNode trY = trFmt.GetNodeFromPath(strPath+".Y");
		vector vx, vy;
		if(trX) vx = trX.dVals;
		if(trY) vy = trY.dVals;		
		double dX0 = 0, dX1 = 0;
		double dY0 = 0, dY1 = 1;
		if( vx.GetSize() >1 )
		{
			dX0 = vx[0];
			dX1 = vx[1];
		}
		
		///Jasmine 03/22/2012 ORG-4971 DUMP_TAG_AND_LABEL_TO_LINKED_GRAPHS
		///------ Folger 08/21/2012 ORG-4971-S6 LINK_TAGS_ON_LINKED_GRAPHS
		//DumpTextLabelsToGraph(gl, dX0, dX1);	
		GraphObject goMainTagLine;
		DumpTextLabelsToGraph(gl, dX0, dX1, &goMainTagLine);
		///------ End LINK_TAGS_ON_LINKED_GRAPHS
		
		///Jasmine 05/14/2012 ORG-4971-P4 SHOULD_NOT_USE_PARENT_GRAPH_PAGE_COORD
		double dScale;
		VGraphLayer vglActive(gl);
		vglActive.PageUnitToScale(dX0*100, dScale, M_PERCENT);
		///End SHOULD_NOT_USE_PARENT_GRAPH_PAGE_COORD
		
		vector<OUID> vnGraphUIDs;
		int nSize = gvcCurrentHolder.GetLinkedGraphs(&vnGraphUIDs);
		for(int ii = 0; ii < nSize; ii++)
		{
			GraphPage gpLinked;
			gpLinked = (GraphPage)Project.GetObject( vnGraphUIDs[ii] );
			if(gpLinked)
			{
			///Jasmine 05/14/2012 ORG-4971-P4 SHOULD_NOT_USE_PARENT_GRAPH_PAGE_COORD
				//DumpTextLabelsToGraph(gpLinked.Layers(), dX0, dX1);	
#ifdef CALC_LINKED_GRAPH_X_VALUE_BASE_ON_PERCENT_OF_PAGE
				DumpTextLabelsToGraph(gpLinked.Layers(), dX0, dX1);	
#else //base on x scale of spcified layer	
				VGraphLayer vglSpecified( gpLinked.Layers(0) );		//use first layer, same as glToGetXInfo = gp.Layers(0) in retrieveOneGraphVIntersectPoint
				double dPagePercent;
				vglSpecified.ScaleToPageUnit(dScale, dPagePercent, M_PERCENT);
				///------ Folger 08/21/2012 ORG-4971-S6 LINK_TAGS_ON_LINKED_GRAPHS
				//DumpTextLabelsToGraph(gpLinked.Layers(0), dPagePercent*0.01, dPagePercent);	
				GraphObject goTagLine;
				DumpTextLabelsToGraph(gpLinked.Layers(0), dPagePercent*0.01, dPagePercent, &goTagLine);
				if ( goMainTagLine && goTagLine )
				{
					goTagLine.ConnectTo(goMainTagLine, -1, -1, false);
				}
				///------ End LINK_TAGS_ON_LINKED_GRAPHS
#endif //CALC_LINKED_GRAPH_X_VALUE_BASE_ON_PERCENT_OF_PAGE
			///End SHOULD_NOT_USE_PARENT_GRAPH_PAGE_COORD
			}
			else
				ASSERT(0);
		}
		///End DUMP_TAG_AND_LABEL_TO_LINKED_GRAPHS
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return FALSE;
}

///Jasmine 03/22/2012 ORG-4971 DUMP_TAG_AND_LABEL_TO_LINKED_GRAPHS
///------ Folger 08/21/2012 ORG-4971-S6 LINK_TAGS_ON_LINKED_GRAPHS
//BOOL GraphVerticalCursorManager::DumpTextLabelsToGraph(GraphLayer& gl, double dX0, double dX1)
BOOL 	GraphVerticalCursorManager::DumpTextLabelsToGraph(GraphLayer& gl, double dX0, double dX1, GraphObject* pTagLine/* = NULL*/)
///------ End LINK_TAGS_ON_LINKED_GRAPHS
{	
	int nUpdateLabelCount = 0;
	bool bNeedAddTag = true;
	
	{
		double dY0 = 0, dY1 = 1;
		///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
		if ( m_Setting.IsLineLengthSpanLayers() )
		{
			CalcLineY1Y2AcrossAllLayers(dY0, dY1);
		}
		///------ End VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
		
		GraphObject	goNewline;		
		///------ Folger 09/10/2012 ORG-6763-S1 VECTICAL_CURSOR_SPAN_ALL_LAYERS_SUPPORT
		//if( add_line(gl, goNewline, dX0, dY0, ATTACH_TO_PAGE, /*nDirection = */LN_VERTICAL, /*bSpan = */false, /*bPercent = */false, dX1, dY1, SYSCOLOR_BLUE) )
		if( add_line(gl, goNewline, dX0, dY0, ATTACH_TO_PAGE, /*nDirection = */LN_VERTICAL, /*nSpan = */m_Setting.IsLineLengthSpanLayers() ? GROBJSTRETCH_ALL_LAYERS : GROBJSTRETCH_WHOLE_PAGE, /*bPercent = */false, dX1, dY1, SYSCOLOR_BLUE) )
		///------ End VECTICAL_CURSOR_SPAN_ALL_LAYERS_SUPPORT
		{
			update_go_states(goNewline, GOC_NO_MOVE|GOC_NO_RESIZE|GOC_NO_ROTATE|GOC_NO_SKEW|GOC_NO_EDIT
				///------ Folger 09/20/2012 ORG-6761-S1 HIDE_LINE_WHEN_IT_OUTSIDE_OF_PAGE
				| GOC_SHOW_INSIDE
				///------ End HIDE_LINE_WHEN_IT_OUTSIDE_OF_PAGE
				);
			goNewline.MoveObject(MO_BOTTOM);
			goNewline.Attach = ATTACH_TO_SCALE;
			
			int nPlotShowCount = m_Setting.m_cursorshow.vnPlotShow.GetSize();
			
			GraphPage gpage = gl.GetPage();
			FOR_GRAPH_EACH_TEXT_LABEL_BEGIN(gpage, label)
			{
				GraphObject	goLabel = label.GetValidObj();
				GraphObject	goNewLabel;
				GraphLayer 	glParent;
				label.GetParent(glParent);
				///Sophy 10/19/2011 ORG-3848-P1 ADD_TAG_AND_LABEL_SHOULD_FOLLOW_CURRENT_FONT_SETTING
				//if(glParent && create_simple_label(glParent, goNewLabel))
				Tree trFormat;
				trFormat = goLabel.GetFormat(FPB_ALL, FOB_ALL, true, true);
				int nFontSize = trFormat.Root.Font.Size.nVal;
				///------ Folger 08/10/2012 ORG-6381-S3 VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
				//if ( glParent && create_simple_label(glParent, goNewLabel, nFontSize) )
				DataPlot dp;
				dp = (DataPlot)Project.GetObject(label.GetAttachedPlotUID());
				int nXFormat = OULABEL_NUMERIC, nYFormat = OULABEL_NUMERIC, nDisp;//OKCOLTYPE_NUMERIC	///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
				string strCustom;
				///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
				_get_axis_label_format(dp, nXFormat, nDisp, strCustom, true);//_get_src_col_format
				_get_axis_label_format(dp, nYFormat, nDisp, strCustom, false);//_get_src_col_format
				///End LABEL_FOLLOW_AXIS_FORMAT
				string strFormat = makeCustomText(m_Setting.m_labelSetting.nSignificantDigits, m_Setting.m_labelSetting.nTextType, m_Setting.m_labelSetting.strLTCustomTextType, nXFormat, nYFormat, m_Setting.m_cursorshow.strXDisp, m_Setting.m_cursorshow.strYDisp, m_Setting.m_tagSetting.nXFormat, m_Setting.m_tagSetting.nYFormat);
				if ( !strFormat.IsEmpty() && glParent && create_simple_label(glParent, goNewLabel, nFontSize) )
				///------ End VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
				///end ADD_TAG_AND_LABEL_SHOULD_FOLLOW_CURRENT_FONT_SETTING
				{
					StringArray	saStorageNames;
					vector		vdStorageValues;
					goLabel.GetStorageNumericVars(&saStorageNames, &vdStorageValues);
					goNewLabel.SetStorageNumericVars(&saStorageNames, &vdStorageValues);		
					///Sophy 8/18/2011 ORG-3106-S10 NEW_OPTIONS_DIALOG
					//set_text_format(goNewLabel, goLabel.Text);
					///------ Folger 08/10/2012 ORG-6381-S3 VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
					//DataPlot dp;
					//dp = (DataPlot)Project.GetObject(label.GetAttachedPlotUID());
					//int nXFormat = OKCOLTYPE_NUMERIC, nYFormat = OKCOLTYPE_NUMERIC, nDisp;
					//string strCustom;
					//_get_src_col_format(dp, nXFormat, nDisp, strCustom, true);
					//_get_src_col_format(dp, nYFormat, nDisp, strCustom, false);
					//set_text_format(goNewLabel,  makeCustomText(m_Setting.m_labelSetting.nSignificantDigits, m_Setting.m_labelSetting.nTextType, m_Setting.m_labelSetting.strLTCustomTextType, nXFormat, nYFormat, m_Setting.m_cursorshow.strXDisp, m_Setting.m_cursorshow.strYDisp, m_Setting.m_tagSetting.nXFormat, m_Setting.m_tagSetting.nYFormat));
					set_text_format(goNewLabel, strFormat);
					///------ End VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
					goNewLabel.X = goLabel.X;
					goNewLabel.Y = goLabel.Y;
					update_go_states(goNewLabel, GOC_NO_MOVE|GOC_NO_RESIZE|GOC_NO_ROTATE|GOC_NO_SKEW|GOC_NO_EDIT);
					///end NEW_OPTIONS_DIALOG
					goNewLabel.ConnectTo(goNewline, -1, -1, false);
					goNewLabel.MoveObject(MO_BOTTOM);
					///Sophy 9/19/2011 ORG-3106-P9 LABEL_AND_TAG_VALUE_NOT_UPDATE_WHEN_HIDDEN
					//goNewLabel.Show = gvcCurrentHolder.m_Settings.bShowTextLabels && !(nUpdateLabelCount <  m_Setting.m_cursorshow.vnPlotShow.GetSize() && m_Setting.m_cursorshow.vnPlotShow[nUpdateLabelCount] == 0);
					///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
					//goNewLabel.Show = !(nUpdateLabelCount <  m_Setting.m_cursorshow.vnPlotShow.GetSize() && m_Setting.m_cursorshow.vnPlotShow[nUpdateLabelCount] == 0);
					bool bShow = true;
					if(nUpdateLabelCount < nPlotShowCount)
					{
						int nFind = m_Setting.m_cursorshow.vsPlotIDs.Find( (string)label.GetAttachedPlotUID() );
						if(-1 < nFind && nFind < nPlotShowCount)
							bShow = m_Setting.m_cursorshow.vnPlotShow[nFind];
					}
					goNewLabel.Show = bShow;
					///End ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
					///end LABEL_AND_TAG_VALUE_NOT_UPDATE_WHEN_HIDDEN
					int nColor;
					if( get_go_color(goLabel, nColor) )
						set_go_color(goNewLabel, nColor);
					update_go_states(goNewLabel, GOC_SHOW_INSIDE); ///------ Folger 09/20/2012 ORG-6761-S1 HIDE_LINE_WHEN_IT_OUTSIDE_OF_PAGE
					nUpdateLabelCount++;
				}
				///Sophy 8/12/2011 ORG-3106-P8 NEW_OPTIONS_DIALOG
				///Sophy 11/23/2011 ORG-4435-P1 TAG_LABEL_NOT_ATTACH_TO_THE_BASED_LAYER
				//if ( bNeedAddTag )
				if ( bNeedAddTag && is_same_layer(gl, glParent) ) //make sure the tag value is from the label on the based layer.
				///end TAG_LABEL_NOT_ATTACH_TO_THE_BASED_LAYER
				{
					///Sophy 10/19/2011 ORG-3848-P1 ADD_TAG_AND_LABEL_SHOULD_FOLLOW_CURRENT_FONT_SETTING
					//if ( createTag(gl, goNewline, goLabel) )
					if ( createTag(gl, goNewline, goLabel, nFontSize) )
					///end ADD_TAG_AND_LABEL_SHOULD_FOLLOW_CURRENT_FONT_SETTING
					{
						bNeedAddTag = false;
					}
				}
				///end NEW_OPTIONS_DIALOG
			}
			FOR_EACH_TEXT_LABEL_END
			///------ Folger 08/21/2012 ORG-4971-S6 LINK_TAGS_ON_LINKED_GRAPHS
			if ( pTagLine )
				*pTagLine = goNewline;
			///------ End LINK_TAGS_ON_LINKED_GRAPHS
		}
	}
	
	return FALSE;
}
///End DUMP_TAG_AND_LABEL_TO_LINKED_GRAPHS
///End DUMP_LABEL_AND_LINE_ON_GRAPH

BOOL GraphVerticalCursorManager::AddTags()
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		CStopWatch watch("AddTags()");
		GraphPage gp = gvcCurrentHolder.GetPage();
		if (!gp)
		{
			ASSERT(FALSE);
			return FALSE;
		}

		int nPageX = gvcCurrentHolder.m_line.GetValidObj().GetPagePosition();
		
		/*vector<int>		vnTagXCenter, vnTagYCenter;
		vector<UINT>	vnTagPlotUIDMap;
		getAllTagsPosAndPlotInfo(gvcCurrentHolder, vnTagXCenter, vnTagYCenter, vnTagPlotUIDMap);
		
		vector<UINT>	vnIndices;
		vnTagXCenter.Sort(SORT_ASCENDING, TRUE, vnIndices);
		vnTagYCenter.Reorder(vnIndices);
		vnTagPlotUIDMap.Reorder(vnIndices);*/
		vector<int>		vnTagXCenter;
		getAllTagsPosAndPlotInfo(gvcCurrentHolder, vnTagXCenter);
		vnTagXCenter.Sort();
		bool	bOKToAdd = true;
		for ( int nn=0; nn<vnTagXCenter.GetSize(); ++nn )
		{			
			if ( vnTagXCenter[nn] == nPageX )
			{
				bOKToAdd = false;
				break;
			}
			else if ( vnTagXCenter[nn] > nPageX )
			{
				break;
			}
		}
		if ( !bOKToAdd )
			return FALSE;

		Selection mySelection;

		/*for (int kk = 0; kk < vnTagXCenter.GetSize(); ++kk)
		{
			if (vnTagXCenter[kk] != nPageX)
			{
				const VTagUnit& vTagUnit = gvcCurrentHolder.m_arrTagUnits.GetAt( vnIndices[kk] );
				if (vTagUnit.m_bIsSelected)
					mySelection.Remove(vTagUnit.m_vTag);
			}
		}*/
		for (int kk = 0; kk < gvcCurrentHolder.m_arrTagUnits.GetSize(); ++kk)
		{
			const VTagUnit& vTagUnit = gvcCurrentHolder.m_arrTagUnits.GetAt(kk);
			if (vTagUnit.m_bIsSelected)
				mySelection.Remove(vTagUnit.m_vTag);
		}
		
		bool bRet = true;
		VTagUnit* pvNewTagUnit = NULL;
		foreach(GraphLayer gl in gp.Layers)
		{
			if(!bRet)
				continue;
			
			VGraphLayer vgl(gl);
			
			double dXScale;
			vgl.PageToScaleCoordinate(nPageX, dXScale);
			
			double rdPageCoord;
			vgl.ScaleToPageUnit(dXScale, rdPageCoord, M_PERCENT);
			
			///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE	
			if(gl.GetIndex() == 0)
				pvNewTagUnit = addTag(gvcCurrentHolder, gl, rdPageCoord);
			if(pvNewTagUnit == NULL)
			{
				bRet = false;		
				continue;
			}

			foreach (DataPlot dp in gl.DataPlots)
			{
				vector vYScale;
				VDataPlot vdp(dp);
				vector<BOOL> vbIsInterpolated;
				vdp.GetYValues(dXScale, vYScale, vbIsInterpolated);

				const int nYValSize = vYScale.GetSize();

				for (int ii = 0; ii < nYValSize; ++ii)
				{
					/*int nPageY;
					vgl.ScaleToPageCoordinate(vYScale[ii], nPageY, false);
					bool	bOKToAdd = true;
					for ( int nn=0; nn<vnTagXCenter.GetSize(); ++nn )
					{
						if ( vnTagPlotUIDMap[nn] != dp.GetUID() )
							continue;
						
						if ( vnTagXCenter[nn] == nPageX && abs(vnTagYCenter[nn] - nPageY) <= 1 )
						{
							bOKToAdd = false;
							break;
						}
						else if ( vnTagXCenter[nn] > nPageX )
						{
							break;
						}
					}
					if ( !bOKToAdd )
						continue;
					*/
					pvNewTagUnit->AddTagLabel(gl, dp, dXScale, vYScale[ii], m_Setting.m_labelSetting.strLTCustomTextType);
				}
			}
			
			addTagDone(gvcCurrentHolder, *pvNewTagUnit);
			mySelection.Add(pvNewTagUnit->m_vTag);					
		}
		
		string strTempvar = "_temppagewidth";
		gp.LT_execute(strTempvar+"=page.width");
		double width;
		LT_get_var(strTempvar, &width);
		LT_execute("del -v "+strTempvar);
		int nOffsetPageX = nPageX+width*0.02;
		gvcCurrentHolder.m_line.GetValidObj().SetPosition(nOffsetPageX);
		
		return TRUE;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return FALSE;
}


BOOL GraphVerticalCursorManager::RemoveTag( const vector<UINT>& vnTagUID )
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
		const int nTagUnitSize = gvcCurrentHolder.m_arrTagUnits.GetSize();

		vector<UINT> vnRemoveTagIndices;
		for (int ii = 0; ii < nTagUnitSize; ++ii)
		{
			const VTagUnit& vTagUnit = gvcCurrentHolder.m_arrTagUnits.GetAt(ii);

			vector<UINT> vnIndices;
			const int nMatchedNum = vnTagUID.Find( MATREPL_TEST_EQUAL, vTagUnit.m_vTag.GetValidObj().GetUID(), vnIndices );
			if ( nMatchedNum > 0 && vnIndices.GetSize() > 0)
			{
				ASSERT(1 == nMatchedNum && 1 == vnIndices.GetSize());
				vnRemoveTagIndices.Add( ii );
			}
		}
		vnRemoveTagIndices.Sort(SORT_DESCENDING);
		for (int jj = 0; jj < vnRemoveTagIndices.GetSize(); ++jj)
		{
			removeTag(gvcCurrentHolder, vnRemoveTagIndices[jj]);
		}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return TRUE;
}

BOOL GraphVerticalCursorManager::RemoveSelectedTagsGroups()
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		CStopWatch watch("RemoveSelectedTagsGroups()");

		vector<int> vnSelectedTagsPageX;
		const int nTagUnitSize = gvcCurrentHolder.m_arrTagUnits.GetSize();

		for (int ii = 0; ii < nTagUnitSize; ++ii)
		{
			const VTagUnit& vTagUnit = gvcCurrentHolder.m_arrTagUnits.GetAt(ii);
			if (vTagUnit.m_bIsSelected)
				vnSelectedTagsPageX.Add(vTagUnit.m_vTag.GetValidObj().GetCenterPageX());
		}

		vnSelectedTagsPageX.Sort(SORT_ASCENDING);
		for (int jj = vnSelectedTagsPageX.GetSize()-2; jj >= 0; --jj)
		{
			if (vnSelectedTagsPageX[jj] == vnSelectedTagsPageX[jj+1])
				vnSelectedTagsPageX.RemoveAt(jj+1);
		}

		for (int kk = 0; kk < vnSelectedTagsPageX.GetSize(); ++kk)
		{
			vector<UINT> vnTagIndices;
			const int nRet = getTagsInSamePageX(gvcCurrentHolder, vnSelectedTagsPageX[kk], vnTagIndices);
			vnTagIndices.Sort(SORT_DESCENDING);
			for (int ii = 0; ii < vnTagIndices.GetSize(); ++ii)
			{
				removeTag(gvcCurrentHolder, vnTagIndices[ii]);
			}
		}
		return TRUE;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return FALSE;
}

BOOL GraphVerticalCursorManager::ClearAllTags()
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		const int nTagCount = gvcCurrentHolder.m_arrTagUnits.GetSize();
		for (int ii = nTagCount-1; ii >= 0; --ii)
		{
			removeTag(gvcCurrentHolder, ii);
		}
		return TRUE;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return FALSE;
}

int GraphVerticalCursorManager::GetNumTags()
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		return gvcCurrentHolder.m_arrTagUnits.GetSize();
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return -1;
}

BOOL GraphVerticalCursorManager::SelectTagsGroup(BOOL bNextGroup /*= TRUE*/)
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		CStopWatch watch("SelectNextTagsGroup()");
		const int nTagUnitSize = gvcCurrentHolder.m_arrTagUnits.GetSize();
		if (0 == nTagUnitSize)
			return FALSE;

		// 1. Get all the selected tags' page position/coordinate
		vector<int> vnSelectedTagsPageX;

		for (int ii = 0; ii < nTagUnitSize; ++ii)
		{
			const VTagUnit& vTagUnit = gvcCurrentHolder.m_arrTagUnits.GetAt(ii);
			if (vTagUnit.m_bIsSelected)
				vnSelectedTagsPageX.Add(vTagUnit.m_vTag.GetValidObj().GetCenterPageX());
		}

		// 2. Get all the tags' info ( including those selected)
		vector<int>	vnTagXCenter;
		getAllTagsPosAndPlotInfo(gvcCurrentHolder, vnTagXCenter);

		// 3. Sort the vector first for finding target tags to be selected
		vector<UINT> vnTagIndices;
		vnTagXCenter.Sort(bNextGroup ? SORT_ASCENDING : SORT_DESCENDING, TRUE, vnTagIndices);

		ASSERT(vnTagXCenter.GetSize() > 0);
		int nToBeSelectedTagsPageX = vnTagXCenter[0];	// By default, select the leftmost tag if bNextGroup, otherwise the rightmost one

		// 4. Find the next/previous nearest tags
		if (vnSelectedTagsPageX.GetSize() > 0)
		{
			vnSelectedTagsPageX.Sort(bNextGroup ? SORT_DESCENDING : SORT_ASCENDING);
			for (int ii = 0; ii < vnTagXCenter.GetSize(); ++ii)
			{
				if (	bNextGroup && vnTagXCenter[ii] > vnSelectedTagsPageX[0]
					||	!bNextGroup && vnTagXCenter[ii] < vnSelectedTagsPageX[0] )
				{
					nToBeSelectedTagsPageX = vnTagXCenter[ii];
					break;
				}
			}
		}

		Selection newSelection;

		// 5. Unselect the previous selected tags that are not locate at target position
		for (int kk = 0; kk < vnTagXCenter.GetSize(); ++kk)
		{
			if (vnTagXCenter[kk] != nToBeSelectedTagsPageX)
			{
				const VTagUnit& vTagUnit = gvcCurrentHolder.m_arrTagUnits.GetAt( vnTagIndices[kk] );
				if (vTagUnit.m_bIsSelected)
					newSelection.Remove(vTagUnit.m_vTag);
			}
		}

		// 6. Select the tags that locate at target position
		vector<UINT> vnTagIndicesInSamePageX;
		const int nRet = getTagsInSamePageX(gvcCurrentHolder, nToBeSelectedTagsPageX, vnTagIndicesInSamePageX);
		for (int jj = 0; jj < vnTagIndicesInSamePageX.GetSize(); ++jj)
		{
			const VTagUnit& vTagUnit = gvcCurrentHolder.m_arrTagUnits.GetAt(vnTagIndicesInSamePageX[jj]);
			newSelection.Add(vTagUnit.m_vTag);
		}
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return FALSE;
}

UINT GraphVerticalCursorManager::GetSelectedTagsCount()
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		return gvcCurrentHolder.m_nSelectedTagsCount;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return 0;
}


///Jasmine 05/30/2012 ORG-4971-P2 UPDATE_PAGE_ALL_LABELS_FONT_SIZE_TO_SPEED_UP
static BOOL	UpdateLabelFontSize(GraphPage& gp, bool bIncrease = true)
{
	Tree trFormat;
	const BOOL bGetTagNames	= TRUE;
	const BOOL bRelative	= TRUE;
	const BOOL bRepaint		= TRUE;
	trFormat = gp.GetFormat(FPB_ALL, FOB_LABELS/*FOB_ALL*/, bGetTagNames, bRelative);

	bool	bChange = false;
	string 	strLTScript;
	strLTScript.Format(STR_OBJ_EVENT_LT_SCRIPT_FORMAT, VCOT_TEXT_LABEL);	

	TreeNode trLayers = trFormat.Root.Layers;
	foreach(TreeNode trLayer in trLayers.Children)
	{
		TreeNode trLabels = trLayer.Labels;
		if(!trLabels)
			continue;
		foreach(TreeNode trLabel in trLabels.Children)
		{
			if(trLabel.Script.strVal.Compare(strLTScript) != 0)
				continue;
			
			const int iOriginSize = trLabel.Font.Size.nVal;
			const double dNewFontSizePercent = bIncrease ? INCREASE_UPDATE_FONT_SIZE_PERCENT : DECREASE_UPDATE_FONT_SIZE_PERCENT;
			int iNewSize = nint(iOriginSize * dNewFontSizePercent);
			if (iNewSize == iOriginSize)
				iNewSize += bIncrease ? 1 : -1;
			if (iNewSize > 0)
			{
				trLabel.Font.Size.nVal = iNewSize;
				bChange = true;
			}
		}
	}
	
	if(bChange)
	{
		int nErr = gp.UpdateThemeIDs(trFormat.Root);
		if(0 == nErr)
			return gp.ApplyFormat(trFormat, bRepaint, bRelative);
	}
	
	return FALSE;
}
///End UPDATE_PAGE_ALL_LABELS_FONT_SIZE_TO_SPEED_UP

BOOL GraphVerticalCursorManager::UpdateLabelsFontSize( bool bIncrease /*= true*/ )
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		const int nTagLabelSize = gvcCurrentHolder.m_arrTagUnits.GetSize();
		for (int ii = 0; ii < nTagLabelSize; ++ii)
		{
			const VTagUnit& vTagUnit = gvcCurrentHolder.m_arrTagUnits.GetAt(ii);
			///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
			//vTagUnit.m_vTagLabel.GetValidObj().UpdateFontSize(bIncrease);
			for(int ii = 0; ii < vTagUnit.m_arrTagLabels.GetSize(); ii++)
			{
				VTagLabel& vTagLabel = vTagUnit.m_arrTagLabels.GetAt(ii);
				vTagLabel.GetValidObj().UpdateFontSize(bIncrease);
			}
			///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
		}
		
		///Jasmine 05/2202012 ORG-4917-P2 UPDATE_LINK_GRAPH_LABEL_FONT_SIZE
		//FOR_EACH_TEXT_LABEL_BEGIN(gvcCurrentHolder, text_label)
			//text_label.GetValidObj().UpdateFontSize(bIncrease);
		//FOR_EACH_TEXT_LABEL_END
		///Jasmine 05/30/2012 ORG-4971-P2 UPDATE_PAGE_ALL_LABELS_FONT_SIZE_TO_SPEED_UP
		//FOR_GRAPH_EACH_TEXT_LABEL_BEGIN(gvcCurrentHolder.GetPage(), text_label)
			//text_label.GetValidObj().UpdateFontSize(bIncrease);
		//FOR_EACH_TEXT_LABEL_END
		UpdateLabelFontSize(gvcCurrentHolder.GetPage(), bIncrease);
		///End UPDATE_PAGE_ALL_LABELS_FONT_SIZE_TO_SPEED_UP
		
		vector<OUID> vnGraphUIDs;
		int nSize = gvcCurrentHolder.GetLinkedGraphs(&vnGraphUIDs);
		for(ii = 0; ii < nSize; ii++)
		{
			GraphPage gpLinked;
			gpLinked = (GraphPage)Project.GetObject( vnGraphUIDs[ii] );
			if(!gpLinked)
				continue;
		
			///Jasmine 05/30/2012 ORG-4971-P2 UPDATE_PAGE_ALL_LABELS_FONT_SIZE_TO_SPEED_UP
			//FOR_GRAPH_EACH_TEXT_LABEL_BEGIN(gpLinked, text_label)
				//text_label.GetValidObj().UpdateFontSize(bIncrease);
			//FOR_EACH_TEXT_LABEL_END
			UpdateLabelFontSize(gpLinked, bIncrease);
			///End UPDATE_PAGE_ALL_LABELS_FONT_SIZE_TO_SPEED_UP
		}
		///End UPDATE_LINK_GRAPH_LABEL_FONT_SIZE
		
		return TRUE;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return FALSE;
}

BOOL GraphVerticalCursorManager::SetLabelsSignificantDigits( int nSignificantDigits )
{
	m_Setting.m_labelSetting.nSignificantDigits = nSignificantDigits;
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		const int nTagLabelSize = gvcCurrentHolder.m_arrTagUnits.GetSize();
		for (int ii = 0; ii < nTagLabelSize; ++ii)
		{
			const VTagUnit& vTagUnit = gvcCurrentHolder.m_arrTagUnits.GetAt(ii);
			///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
			//vTagUnit.m_vTagLabel.GetValidObj().SetSignificantDigits(nSignificantDigits);
			for(int ii = 0; ii < vTagUnit.m_arrTagLabels.GetSize(); ii++)
			{
				VTagLabel& vTagLabel = vTagUnit.m_arrTagLabels.GetAt(ii);
				vTagLabel.GetValidObj().SetSignificantDigits(nSignificantDigits);
			}
			///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
		}
		FOR_EACH_TEXT_LABEL_BEGIN(gvcCurrentHolder, text_label)
			text_label.GetValidObj().SetSignificantDigits(nSignificantDigits);
		FOR_EACH_TEXT_LABEL_END
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return TRUE;
}

void _insert_after(string& strParent, LPCSTR lpcszSub, char cc)
{
	string strFind(cc);
	
	strFind.MakeUpper();	
	int nPos = strParent.Find(strFind);
	if(nPos >= 0)
	{
		strParent.Insert(nPos + 1, lpcszSub);
		return;
	}
	
	strFind.MakeLower();	
	nPos = strParent.Find(strFind);
	if(nPos >= 0)
	{
		strParent.Insert(nPos + 1, lpcszSub);
		return;
	}
	
	return;
}

///Jasmine 07/20/2011 ORG-3106-S4-1 FIX_DIGIT_SETTING_NOT_APPLY_TO_LABEL
string GraphVerticalCursorManager::makeCustomText(int nSignificantDigits, int nTextType, LPCSTR lpcszCustomText, int nFormatX, int nFormatY, LPCSTR lpcszXFormat, LPCSTR lpcszYFormat, int nCheckXFormat, int nCheckYFormat)
{
	string strText;
	///------ Folger 08/10/2012 ORG-6381-S3 VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
	if ( LTT_NONE == nTextType )
	{
	}
	else
	///------ End VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
	if (LTT_CUSTOM == nTextType)
	{
		strText = lpcszCustomText;
	}
	else
	{
		strText = LTT_Y_VALUE == nTextType? STR_LABEL_TYPE_Y_VALUE : STR_LABEL_TYPE_X_Y_VALS;
		
		string strSignificantDigitFmtX = ",*";
		string strSignificantDigitFmtY = ",*";

		///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
		//if ( (nFormatX == OKCOLTYPE_DATE || nFormatX == OKCOLTYPE_TIME) && nFormatX == nCheckXFormat )
		if ( (nFormatX == OULABEL_DATE || nFormatX == OULABEL_TIME) && nFormatX == nCheckXFormat )
		///End LABEL_FOLLOW_AXIS_FORMAT
		{
			if ( NULL != lpcszXFormat )
				strSignificantDigitFmtX.Format(", %s", lpcszXFormat);
			else if ( nFormatX == OULABEL_DATE )//OKCOLTYPE_DATE	///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
				strSignificantDigitFmtX = ", D0";//D1
			else
				strSignificantDigitFmtX = ", T0";//T1
		}
		else 
		{
			///Sophy 8/12/2011 ORG-3106-P8 NEW_OPTIONS_DIALOG
			//if (MIN_SIGNIFICANT_DIGITS <= nSignificantDigits && nSignificantDigits <= MAX_SIGNIFICANT_DIGITS)
			//	strSignificantDigitFmtX.Format(",*%d*", nSignificantDigits);
			strSignificantDigitFmtX = ", " + m_Setting.m_cursorshow.strXDisp;
			///end NEW_OPTIONS_DIALOG
		}
		
		///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
		//if ( (nFormatY == OKCOLTYPE_DATE || nFormatY == OKCOLTYPE_TIME) && nFormatY == nCheckYFormat )
		if ( (nFormatY == OULABEL_DATE || nFormatY == OULABEL_TIME) && nFormatY == nCheckYFormat )
		///End LABEL_FOLLOW_AXIS_FORMAT
		{
			if ( NULL != lpcszYFormat )
				strSignificantDigitFmtY.Format(", %s", lpcszYFormat);
			else if ( nFormatY == OULABEL_DATE )//OKCOLTYPE_DATE	///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
				strSignificantDigitFmtY = ", D0";//D1
			else
				strSignificantDigitFmtY = ", T0";//T0
						
		}
		else
		{
			///Sophy 8/12/2011 ORG-3106-P8 NEW_OPTIONS_DIALOG
			//if (MIN_SIGNIFICANT_DIGITS <= nSignificantDigits && nSignificantDigits <= MAX_SIGNIFICANT_DIGITS)
			//	strSignificantDigitFmtY.Format(",*%d*", nSignificantDigits);
			strSignificantDigitFmtY = ", " + m_Setting.m_cursorshow.strYDisp;
			///end NEW_OPTIONS_DIALOG
		}
		//"($(X),$(Y))"
		_insert_after(strText, strSignificantDigitFmtX, 'x');
		_insert_after(strText, strSignificantDigitFmtY, 'y');
	}
	
	return strText;
}
///End FIX_DIGIT_SETTING_NOT_APPLY_TO_LABEL
///Sophy 8/18/2011 ORG-3106-S10 NEW_OPTIONS_DIALOG
string	GraphVerticalCursorManager::makeTagText(int nFormat, LPCSTR lpcszXFormat, int nCheckXFormat)
{
	string strText;
	///------ Folger 08/10/2012 ORG-6381-S3 VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
	if ( TTT_NONE == m_Setting.m_tagSetting.nTextType )
	{
	}
	else
	///------ End VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
	if ( m_Setting.m_tagSetting.nTextType == TTT_CUSTOM )
	{
		strText = m_Setting.m_tagSetting.strLTCustomTextType;
	}
	else
	{
		///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
		//if ( (nFormat == OKCOLTYPE_DATE || nFormat ==  OKCOLTYPE_TIME) && nFormat == nCheckXFormat )
		if ( (nFormat == OULABEL_DATE || nFormat ==  OULABEL_TIME) && nFormat == nCheckXFormat )
		///End LABEL_FOLLOW_AXIS_FORMAT
		{
			if ( NULL != lpcszXFormat )
				strText.Format("$(X, %s)", lpcszXFormat);
			else if ( nFormat == OULABEL_DATE )//OKCOLTYPE_DATE	///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
				strText = "$(X, D0)";//D1
			else
				strText = "$(X, T0)";//T1
		}
		else
		{
			///Sophy 8/12/2011 ORG-3106-P8 NEW_OPTIONS_DIALOG
			//strText = "$(X,*)";
			strText.Format("$(X, %s)", m_Setting.m_cursorshow.strXDisp);
			///end NEW_OPTIONS_DIALOG
		}
	}
	return strText;
}


///end NEW_OPTIONS_DIALOG

BOOL GraphVerticalCursorManager::SetLabelsText(int nSignificantDigits, int nTextType, LPCSTR lpcszCustomText /*= NULL*/ )
{
	if (nTextType > LTT_CUSTOM)
		return FALSE;

	m_Setting.m_labelSetting.nTextType = nTextType;
	///Jasmine 07/20/2011 ORG-3106-S4-1 FIX_DIGIT_SETTING_NOT_APPLY_TO_LABEL
	/*if (LTT_CUSTOM == nTextType)
	{
		const string strText = lpcszCustomText;
		m_Setting.m_labelSetting.strLTCustomTextType = strText;
	}
	else
	{
		string strText = LTT_Y_VALUE == nTextType? STR_LABEL_TYPE_Y_VALUE : STR_LABEL_TYPE_X_Y_VALS;
		
		if (MIN_SIGNIFICANT_DIGITS <= nSignificantDigits && nSignificantDigits <= MAX_SIGNIFICANT_DIGITS)
		{
			string strSignificantDigitFmt;
			strSignificantDigitFmt.Format(",*%d*", nSignificantDigits);
			//"($(X),$(Y))"
			_insert_after(strText, strSignificantDigitFmt, 'x');
			_insert_after(strText, strSignificantDigitFmt, 'y');
		}
		
		m_Setting.m_labelSetting.strLTCustomTextType = strText;
	}*/
	m_Setting.m_labelSetting.strLTCustomTextType = makeCustomText(nSignificantDigits, nTextType, lpcszCustomText);	
	///End FIX_DIGIT_SETTING_NOT_APPLY_TO_LABEL
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		const int nTagLabelSize = gvcCurrentHolder.m_arrTagUnits.GetSize();
		for (int ii = 0; ii < nTagLabelSize; ++ii)
		{
			const VTagUnit& vTagUnit = gvcCurrentHolder.m_arrTagUnits.GetAt(ii);
			///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
			//vTagUnit.m_vTagLabel.GetValidObj().SetTextFormat(m_Setting.m_labelSetting.strLTCustomTextType);
			for(int ii = 0; ii < vTagUnit.m_arrTagLabels.GetSize(); ii++)
			{
				VTagLabel& vTagLabel = vTagUnit.m_arrTagLabels.GetAt(ii);
				vTagLabel.GetValidObj().SetTextFormat(m_Setting.m_labelSetting.strLTCustomTextType);
			}
			///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
		}
		FOR_EACH_TEXT_LABEL_BEGIN(gvcCurrentHolder, text_label)
			text_label.GetValidObj().SetTextFormat(m_Setting.m_labelSetting.strLTCustomTextType);
		FOR_EACH_TEXT_LABEL_END
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return TRUE;
}

///------ Folger 01/22/10 CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE
///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
//BOOL	GraphVerticalCursorManager::WorldToView(double& rView, double rWorld)
BOOL	GraphVerticalCursorManager::WorldToView(GraphLayer& glParent, double& rView, double rWorld)
///End BTN_TO_CAHNGE_X_REFERECE_LAYER
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
		//VGraphLayer	vgl;
		//gvcCurrentHolder.m_line.GetParent(vgl);	
		VGraphLayer	vgl(glParent);
		///End BTN_TO_CAHNGE_X_REFERECE_LAYER
		return vgl.ScaleToPageCoordinate(rWorld, rView, true);
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END

	return FALSE;
}
///------ End CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE

BOOL GraphVerticalCursorManager::GetSetting(VManagerSetting& stSetting)
{
	stSetting = m_Setting;
	return TRUE;
}

BOOL GraphVerticalCursorManager::SetSetting(const VManagerSetting& stSetting)
{
	Tree trOld;
	trOld += m_Setting;	
	Tree trNew;
	trNew += stSetting;	
	Tree trDiff;
	trDiff.CreateDiff(trOld, trNew);
	if(!trDiff.FirstNode)
		return TRUE;	
	
		
	m_Setting = stSetting;
	///------ Folger 01/20/10 SUPPORT_SAVING_VERTICAL_CURSOR_SETTINGS_IN_PAGE
	///Jasmine 02/08/10 HOLDER_INVALID_WHEN_ACTIVE_PAGE_NOT_GRAPH
	//change Report Sheet string and then activate a book so that GetCursorHolderPointer will fail
	//BOOL bSaveOK = m_Setting.SaveToIni() && m_Setting.SaveToGraph(GetCursorHolderPointer()->GetPage());
	BOOL bSaveOK = m_Setting.SaveToIni();
	ASSERT(bSaveOK);
	
	GraphPage gp;
	const GraphVerticalCursorHolder* pgvcHolder = GetCursorHolderPointer();
	if(pgvcHolder)
		gp = pgvcHolder->GetPage();
	else
	{
		CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
			gp = gvcCurrentHolder.GetPage();
		CHECK_GET_CURRENT_CURSOR_HOLDER_END
	}
	bSaveOK = m_Setting.SaveToGraph(gp);
	ASSERT(bSaveOK);
	///End HOLDER_INVALID_WHEN_ACTIVE_PAGE_NOT_GRAPH
	///------ End SUPPORT_SAVING_VERTICAL_CURSOR_SETTINGS_IN_PAGE	
	
	bool bChange = false;	///Jasmine 07/20/2011 ORG-3106-S4-1 FIX_DIGIT_SETTING_NOT_APPLY_TO_LABEL					
	if(trDiff.m_labelSetting)
	{
		///------ Folger 08/20/2012 ORG-4971-P8 INCORRECT_SIGNIFICANT_DIGITS_SHOWN_AFTER_APPLY_OPTIONS_IN_VERTICAL_CURSOR
		//SetLabelsSignificantDigits(m_Setting.m_labelSetting.nSignificantDigits);
		///------ End INCORRECT_SIGNIFICANT_DIGITS_SHOWN_AFTER_APPLY_OPTIONS_IN_VERTICAL_CURSOR
		SetLabelsText(m_Setting.m_labelSetting.nSignificantDigits, m_Setting.m_labelSetting.nTextType, m_Setting.m_labelSetting.strLTCustomTextType);
		bChange = true;		///Jasmine 07/20/2011 ORG-3106-S4-1 FIX_DIGIT_SETTING_NOT_APPLY_TO_LABEL					
	}
	if(trDiff.m_strSnappedPlot || trDiff.m_bSnapToNearestX)
	{
		///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT
		//SnapLineToData(m_Setting.m_bSnapLineToData);
		SnapLineToData(m_Setting.m_strSnappedPlot);
		///End SNAP_CURSOR_TO_DATA_PLOT
		///Jasmine 07/20/2011 ORG-3106-S4-1 FIX_DIGIT_SETTING_NOT_APPLY_TO_LABEL	
		/////------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
		//GraphRefresh();
		/////------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
		bChange = true;						
	}
	
	if(bChange)
	///End FIX_DIGIT_SETTING_NOT_APPLY_TO_LABEL
	{
		///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
		GraphRefresh();
		///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	}	
	
	return TRUE;
}

///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
void	GraphVerticalCursorManager::GraphRefresh()
{
	const GraphVerticalCursorHolder* pgvcHolder = GetCursorHolderPointer();
	if ( pgvcHolder )
	{
		GraphPage gp = pgvcHolder->GetPage();
		if( gp )
			gp.Refresh();
	}
}

void	GraphVerticalCursorManager::ForceUpdate(GraphVerticalCursorHolder& Holder)
{
	Holder.m_line.GetValidObj().SetPositionView(Holder.m_line.GetValidObj().GetPagePosition());
}
///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG

// Dump Tag information from current graph to worksheet
BOOL GraphVerticalCursorManager::DumpTagValues()//DumpData()
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN 
	{	
		DumpDataHelper dumpDataHelper(m_Setting.m_strDumpWksName);
		
		const int nNumTags = GetNumTags();
		vector 			vXScale, vYScale;
		vector<uint> 	vuPlotUID;
		for(int ii = 0; ii < nNumTags; ii++)
		{			
			VTagUnit&	tagUnit = gvcCurrentHolder.m_arrTagUnits.GetAt(ii);
			///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
			for(int jj = 0; jj < tagUnit.m_arrTagLabels.GetSize(); jj++)
			{
				VTagLabel& vTagLabel = tagUnit.m_arrTagLabels.GetAt(jj);
				vXScale.Add( vTagLabel.GetMarkedPointXScale() );			
				vYScale.Add( vTagLabel.GetMarkedPointYScale() );
				vuPlotUID.Add( vTagLabel.GetAttachedPlotUID() );
			}
			///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
		}
		
		// sort vector by X scale
		vector<uint> vnIndeces;
		vXScale.Sort(SORT_ASCENDING, true, vnIndeces);
		vYScale.Reorder(vnIndeces);
		vuPlotUID.Reorder(vnIndeces);
		
		bool bRet = dumpDataHelper.Dump(vXScale, vYScale, vuPlotUID);
		
		return TRUE;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
}

BOOL GraphVerticalCursorManager::DumpCursorValues()
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN 
	{		
		///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER
		int nSize = m_arrPoints.GetSize();
		if(nSize <= 0)
			return FALSE;
	
		vector<int> vnIndeces;
		GetCursorDisplayOrder(vnIndeces, 0);//vnIndeces will be used when the first time output to a new sheet
		///End UPDATE_LIST_WITH_SORT_ORDER
		
		vector 			vXScale, vYScale;
		vector 			vNearestX, vNearestY;	///Jasmine 01/20/10 SHOW_NEAREST_POINT
		vector<uint> 	vuPlotUID;

		vector<int> vnShow;
		vnShow = m_Setting.m_cursorshow.vnPlotShow;
		
		for(int ii = 0; ii < nSize; ii++)
		{
			if ( ii < vnShow.GetSize() && vnShow[ii] == 0 )
				continue;
			VIntersectPoint& pti = m_arrPoints.GetAt( vnIndeces[ii] );
			vXScale.Add(pti.fpPoint.x);
			vYScale.Add(pti.fpPoint.y);
			vuPlotUID.Add(pti.plotuid);
			
			///Jasmine 01/25/10 SHOW_NEAREST_POINT_IN_DLG_BUT_NOT_OUTPUT
			//if(m_Setting.m_cursorshow.CursorNearX)
				//vNearestX.Add(pti.fpNearPoint.x);
			//if(m_Setting.m_cursorshow.CursorNearY)
				//vNearestY.Add(pti.fpNearPoint.y);
			///End SHOW_NEAREST_POINT_IN_DLG_BUT_NOT_OUTPUT
		}
		
		VIntersectPoint& pti = m_arrPoints.GetAt( 0 );
		DumpDataHelper dumpDataHelper(m_Setting.m_strDumpWksName);
		bool bRet = dumpDataHelper.Dump(vXScale, vYScale, vuPlotUID, 
										//vNearestX, vNearestY, ///Jasmine 01/25/10 SHOW_NEAREST_POINT_IN_DLG_BUT_NOT_OUTPUT
										m_Setting.m_cursorshow,	///Jasmine 01/18/10 SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME 
										pti.xinfo);
		
		return TRUE;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	return FALSE;
}
///Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS	
BOOL GraphVerticalCursorManager::ActivateOutputWks()
{
	DumpDataHelper dumpDataHelper(m_Setting.m_strDumpWksName);
	return dumpDataHelper.ActivateOutputWks();
}
///End BTN_TO_ACTIVATE_OUTPUT_WKS

///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER
///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
//void GraphVerticalCursorManager::GetCursorDisplayOrder(vector<uint>& vnIndeces, UINT uPageUID)
//{
	//vnIndeces.SetSize(0);
	//
	//vector<string> vsPointIDs;
	//const GraphVerticalCursorHolder* pgvcHolder = GetCursorHolderPointer(uPageUID);
	//if(pgvcHolder)
		//vsPointIDs = pgvcHolder->m_vsPointIDs;
	//
	//int nSize = m_arrPoints.GetSize();
	//bool bReorderBySort = (vsPointIDs.GetSize() > 0);
	//if(bReorderBySort)
		//ASSERT(vsPointIDs.GetSize() == nSize);
	//
	//vnIndeces.SetSize(nSize);///Jasmine 07/11/2011 ORG-3106-S1 WRONG_LOGIC_CODE_MAKE_MISTAKE
	//
	//vector vLayerYPos;
	//for(int ii = 0; ii < nSize; ii++)
	//{
		//VIntersectPoint& pti = m_arrPoints.GetAt(ii);
		/////------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
		////int id = 10 * pti.layer + pti.plot;
		//int	id = pti.plotuid;
		/////------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
		//
		//if(bReorderBySort)
		//{
			//int nFind = vsPointIDs.Find((string)id);
			//if(nFind < 0)
				//bReorderBySort = false;
			//else
			//{
				/////Jasmine 07/11/2011 ORG-3106-S1 WRONG_LOGIC_CODE_MAKE_MISTAKE
				////vnIndeces.Add(nFind);
				//vnIndeces[nFind] = ii;
				/////End WRONG_LOGIC_CODE_MAKE_MISTAKE
			//}
		//}
		////else	///always
		//{
			//vLayerYPos.Add( pti.layerYPos);
		//}
	//}
//
	//if(!bReorderBySort )
		//vLayerYPos.Sort( SORT_ASCENDING, FALSE, vnIndeces);
	//
	//ASSERT(vnIndeces.GetSize() == nSize);
//}
void GraphVerticalCursorManager::GetCursorDisplayOrder(vector<int>& vnIndeces, UINT uPageUID)
{	
	vector<string> vsPointIDs, vsPointIDCopy;
	vsPointIDs = m_Setting.m_cursorshow.vsPlotIDs;
	int nCount = vsPointIDs.GetSize();
	vsPointIDCopy.SetSize(nCount);
	vnIndeces.SetSize(nCount);
	double dMark = -1;
	vnIndeces = dMark;
	///Jasmine 09/03/2012 ORG-4971-P3 KEEP_PLOT_STATUS_AFTER_LINK_GRAPH
	vector<int> vnShow(nCount), vnPlotHideFromGrid(nCount);
	vnShow = 1;
	vnPlotHideFromGrid = 0;
	///End KEEP_PLOT_STATUS_AFTER_LINK_GRAPH
	
	vector<string> vsNewIDs;
	vector<int> vnNewIndex, vnNewShow, vnNewHideFromGrid;
	
	int nSize = m_arrPoints.GetSize();	
	for(int ii = 0; ii < nSize; ii++)
	{
		VIntersectPoint& pti = m_arrPoints.GetAt(ii);
		string strID;
		strID = (string)(pti.plotuid);
		
		int nFind = vsPointIDs.Find(strID);	
		if(nFind < 0)
		{
			vsNewIDs.Add(strID);
			vnNewIndex.Add(ii);
			vnNewShow.Add(1);
			vnNewHideFromGrid.Add(0);
		}
		else
		{
			vsPointIDCopy[nFind] = strID;
			vnIndeces[nFind] = ii;
			///Jasmine 09/03/2012 ORG-4971-P3 KEEP_PLOT_STATUS_AFTER_LINK_GRAPH
			vnShow[nFind] = m_Setting.m_cursorshow.vnPlotShow[nFind];
			vnPlotHideFromGrid[nFind] = m_Setting.m_cursorshow.vnPlotHideFromGrid[nFind];
			///End KEEP_PLOT_STATUS_AFTER_LINK_GRAPH
		}
	}
	
	vector<uint> vecIndex;
	int nRet = vnIndeces.Find(vecIndex, dMark);
	if(nRet > 0)
	{
		vector<int> vnRemove;
		vnRemove = vecIndex;
		vsPointIDCopy.RemoveAt(vnRemove);
		vnIndeces.RemoveAt(vnRemove);
		///Jasmine 09/03/2012 ORG-4971-P3 KEEP_PLOT_STATUS_AFTER_LINK_GRAPH
		vnShow.RemoveAt(vnRemove);			
		vnPlotHideFromGrid.RemoveAt(vnRemove);			
		///End KEEP_PLOT_STATUS_AFTER_LINK_GRAPH
	}	
	vsPointIDCopy.Append(vsNewIDs);
	vnIndeces.Append(vnNewIndex);
	///Jasmine 09/03/2012 ORG-4971-P3 KEEP_PLOT_STATUS_AFTER_LINK_GRAPH
	vnShow.Append(vnNewShow);		
	vnPlotHideFromGrid.Append(vnNewHideFromGrid);
	///End KEEP_PLOT_STATUS_AFTER_LINK_GRAPH

	if(vnIndeces.GetSize() != nSize)
	{	
		vsPointIDCopy.SetSize(0);
		
		vnIndeces.SetSize(0);
		vnIndeces.Data(0, nSize-1);
		///Jasmine 09/03/2012 ORG-4971-P3 KEEP_PLOT_STATUS_AFTER_LINK_GRAPH
		vnShow.SetSize(0);		
		vnPlotHideFromGrid.SetSize(0);
		///End KEEP_PLOT_STATUS_AFTER_LINK_GRAPH
	}	
	
	m_Setting.m_cursorshow.vsPlotIDs = vsPointIDCopy;
	///Jasmine 09/03/2012 ORG-4971-P3 KEEP_PLOT_STATUS_AFTER_LINK_GRAPH
	/////Sophy 8/9/2011 ORG-3106-S5 MORE_WORK_ON_MENU_TO_HIDE_PLOT_FROM_DLG
	//if ( m_Setting.m_cursorshow.vnPlotShow.GetSize() != vsPointIDCopy.GetSize() ) //need init
	//{
		//m_Setting.m_cursorshow.vnPlotShow.SetSize(vsPointIDCopy.GetSize());
		//m_Setting.m_cursorshow.vnPlotShow = 1; //on initial, all are visible.
	//}
	/////end MORE_WORK_ON_MENU_TO_HIDE_PLOT_FROM_DLG
	/////Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
	//if ( m_Setting.m_cursorshow.vnPlotHideFromGrid.GetSize() != vsPointIDCopy.GetSize() ) //need init
	//{
		//m_Setting.m_cursorshow.vnPlotHideFromGrid.SetSize(vsPointIDCopy.GetSize());
		//m_Setting.m_cursorshow.vnPlotHideFromGrid = 0; //on initial, all are visible.
	//}
	/////End NEW_MENU_TO_EXCLUDE_HIDE_PLOT
	m_Setting.m_cursorshow.vnPlotShow = vnShow;	
	m_Setting.m_cursorshow.vnPlotHideFromGrid = vnPlotHideFromGrid;	
	///End KEEP_PLOT_STATUS_AFTER_LINK_GRAPH
}
///End MENU_TO_HIDE_PLOT_FROM_DLG
///End UPDATE_LIST_WITH_SORT_ORDER
void GraphVerticalCursorManager::OnGraphLineEvent( int nEvent, UINT uPageUID )
{
	if ( m_bBusy )
		return;
	VerticalCursorBusyHelper _busy(&m_bBusy); ///Sophy 11/18/2011 ORG-3929-P1 VERTICALCURSOR_DIALOG_TOO_SLOW
	
	switch (nEvent)
	{
	case OE_RESIZE:
	case OE_MOVE:
	case OE_MOVING:
		{
			const bool bIsMoving = OE_MOVING == nEvent;
			OnUpdateLinePosition(uPageUID, bIsMoving);
		}
		break;
	///Jasmine 01/26/10 UPDATE_CURSOR_POSITION_ON_SCALE_CHANGE
	case OE_SCALE_CHANGE:	
		if (m_pParentWnd)
			m_pParentWnd->SendMessage(WM_USER_UPDATE_CURSOR_POSITION, uPageUID, CURSOR_MOVING);
		OnUpdateLinePosition(uPageUID, false);
		break;
	///End UPDATE_CURSOR_POSITION_ON_SCALE_CHANGE
	case OE_DELETE:
		OnLineDeleted(uPageUID);
		break;
	case OE_WIN_CLOSE:
		OnPageWndClosed(uPageUID);
		break;
	}
}

///Jasmine 03/15/2012 ORG-4971 LINK_CURRENT_GADGET_TO_OTHER_GRAPHS
int filter_unlink_graphs(int nMsg, Page& pg = NULL) 
{ 
    switch(nMsg) 
    { 
    case GBFM_IS_USE_PAGE: // return 1 for true. 
        if(!pg) 
            return -1; 
        
        const GraphVerticalCursorHolder* pgvcHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer();
		if (pgvcHolder)
		{
			if( pgvcHolder->GetLinkedGraphs() > 0 )
			{
				return 1;
			}
			else
				return 0;
		}
        break;
        
    default:
    	break;   
    } 
    
    return -1; // error 
}

int filter_unavailable_link_graphs(int nMsg, Page& pg = NULL) 
{ 
    switch(nMsg) 
    { 
    case GBFM_IS_USE_PAGE: // return 1 for true. 
        if(!pg) 
            return -1; 
        
        UINT uidPage = pg.GetUID();
		if(0 == uidPage)
			return 1;
		
		/// Zech 03/31/2012 ORG-4284-P3 DO_NOT_SHOW_SPARKLINE_IN_GRAPH_BROWSER
		if (!is_page_not_sparkline(pg))
			return 0;
		/// END DO_NOT_SHOW_SPARKLINE_IN_GRAPH_BROWSER
		
		//filter parent graph
		const GraphVerticalCursorHolder* pHolderFromPage = THE_VCURSOR_MANAGER.GetCursorHolderPointer(uidPage);
		if(pHolderFromPage)
		{
			bool bGlobalGadget = pHolderFromPage->HasGlobalGadget() > 0;
			if(bGlobalGadget)
				return 0;
		}
		
        const GraphVerticalCursorHolder* pCurrentHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer();
		if (pCurrentHolder)
		{			
			//filter already linked graphs
			//vector<OUID> 	vnUIDs;
			//vector<uint>	vnIndex;
			//if( Project.Gadgets.GetLinkedGraphs(pCurrentHolder->m_line, vnUIDs)
				//&& vnUIDs.Find(vnIndex, uidPage) > 0 )
			//{
				//return 0;
			//}
			
			//filter current page
			if(uidPage == pCurrentHolder->m_uPageUID)
				return 0;
			
			///Jasmine 08/31/2012 ORG-6701-P1 GRAPH_ALREADY_LINKED_IS_NOT_ALLOWED_LINK_AGAIN
			GraphPage graph(pg);
			if(!graph)
				return 0;
			
			vector<OUID> vnUIDs;
			BOOL bRet =	Project.Gadgets.GetLinkedGadgets(graph, vnUIDs);
			if(vnUIDs.GetSize() > 0)
			{
				vector<uint> vnIndex;
				if(vnUIDs.Find(vnIndex, pCurrentHolder->m_line.GetValidObj().GetUID()) > 0)
					return 1;
				else
					return 0;
			}
			///End GRAPH_ALREADY_LINKED_IS_NOT_ALLOWED_LINK_AGAIN
			return 1;
		}
        break;
        
    default:
    	break;   
    } 
    
    return -1; // error 
}

bool GraphVerticalCursorManager::CanLinkGraph()
{
	bool bRet = false;
	
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		vector<OUID> vnUIDs;
		bool bb = Project.Gadgets.GetLinkedGadgets(gvcCurrentHolder.GetPage(), vnUIDs);
		bRet = vnUIDs.GetSize() < 1;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	
	return bRet;
}

bool GraphVerticalCursorManager::HasLinkedGraphs()
{
	bool bRet = false;
	
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		bRet = gvcCurrentHolder.GetLinkedGraphs() > 0;
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	
	return bRet;
}

bool GraphVerticalCursorManager::LinkGraphs(LPCSTR lpczGraphs)
{
	int nRet = 0;
	
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		bool 			bGlobalGadget =	 false;
		
		vector<string> 	vsGraphs;
		int 			nSize 			= okutil_get_tokens(lpczGraphs, &vsGraphs, STR_PAGE_LIST_SEPARATOR, NULL);
		for(int ii = 0; ii < nSize; ii++)
		{
			GraphPage gp( vsGraphs[ii] );
			if(!gp)
				continue;
			
			if(!bGlobalGadget)
			{
				vector<OUID> 	vnUIDs;
				bGlobalGadget = Project.Gadgets.GetLinkedGraphs(gvcCurrentHolder.m_line, vnUIDs);				
				if(!bGlobalGadget)
					bGlobalGadget = Project.Gadgets.Add(gvcCurrentHolder.m_line);
			}
			
			if(!bGlobalGadget)
			{
				nRet = false;
				ASSERT(nRet);
				break;
			}
			
			//bool bRet = is gp available for link? ///Jasmine 03/19/2012 to do: check strGraph is valid for vertical cursor				
			//if(bRet)
			{
				nRet += Project.Gadgets.AddLinkedGraph(gvcCurrentHolder.m_line, gp);
				
			}
		}
		
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	
	return nRet > 0;
}

bool GraphVerticalCursorManager::UnlinkGraphs(LPCSTR lpczGraphs)
{
	int nRet = 0;
	
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		bool 			bGlobalGadget =	 false;
		
		vector<string> 	vsGraphs;
		int 			nSize 			= okutil_get_tokens(lpczGraphs, &vsGraphs, STR_PAGE_LIST_SEPARATOR, NULL);
		for(int ii = 0; ii < nSize; ii++)
		{
			GraphPage gp( vsGraphs[ii] );
			if(!gp)
				continue;
			
			if(!bGlobalGadget)
			{
				bGlobalGadget = gvcCurrentHolder.HasGlobalGadget();
				if(!bGlobalGadget)
				{
					nRet = 1;
					break;
				}
			}
			
			nRet += Project.Gadgets.RemoveLinkedGraph(gvcCurrentHolder.m_line, gp);
		}
		
		if(bGlobalGadget)
		{
			if( gvcCurrentHolder.GetLinkedGraphs() == 0 )
				Project.Gadgets.Remove(gvcCurrentHolder.m_line);
		}
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
	
	return nRet > 0;
}
///End LINK_CURRENT_GADGET_TO_OTHER_GRAPHS

void GraphVerticalCursorManager::OnTagEvent( int nEvent, UINT uPageUID, UINT uTagUID )
{
	switch (nEvent)
	{
	case OE_SELECT:
		OnTagSelected(uPageUID, uTagUID);
		break;
	case OE_UNSELECT:
		OnTagUnselected(uPageUID, uTagUID);
		break;
	case OE_DELETE:
		OnTagDeleted(uPageUID, uTagUID);
		break;
	}
}

void GraphVerticalCursorManager::OnTagLabelEvent( int nEvent, UINT uPageUID, UINT uTagLabelUID )
{
	switch (nEvent)
	{
	case OE_DELETE:
		OnTagLabelDeleted(uPageUID, uTagLabelUID);
		break;
	}
}

void GraphVerticalCursorManager::OnTextLabelEvent( int nEvent, UINT uPageUID, UINT uTextLabelUID )
{
	///Sophy 9/20/2011 ORG-3843-P1 PROPER_LOAD_SETTINGS_WHEN_OPEN_OGG 
	if ( m_bBusy )
		return;
	VerticalCursorBusyHelper _busy(&m_bBusy);
	///end PROPER_LOAD_SETTINGS_WHEN_OPEN_OGG
	
	switch (nEvent)
	{
	case OE_MOVE:
		OnTextLabelMoved(uPageUID, uTextLabelUID);
		break;
	case OE_DELETE:
		OnTextLabelDeleted(uPageUID, uTextLabelUID);
		break;
	}
}

///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
///Sophy 8/11/2011 ORG-3106-S5 PROPER_SHOWHIDE_LABEL_OBJ_BY_UID
//bool GraphVerticalCursorManager::ShowTextLabel(UINT uPageUID, UINT uTextLabelUID, bool bShow)
bool GraphVerticalCursorManager::ShowPlotTextLabel(UINT uPageUID, UINT uAttachedPlotUID, bool bShow)
///end PROPER_SHOWHIDE_LABEL_OBJ_BY_UID
{
	///Sophy 8/9/2011 ORG-3106-S5 MORE_WORK_ON_MENU_TO_HIDE_PLOT_FROM_DLG
	//int nHolderIndex = getCursorHolderIndex(uPageUID);
	int nHolderIndex = getCursorHolderIndex(getActualPageUID(uPageUID));
	///end MORE_WORK_ON_MENU_TO_HIDE_PLOT_FROM_DLG
	if (nHolderIndex < 0)
	{
		ASSERT(FALSE);
		return false;
	}
	GraphVerticalCursorHolder& gvcHolder = m_arrGraphVerticalCursorHolders.GetAt(nHolderIndex);
	///Sophy 8/11/2011 ORG-3106-S5 PROPER_SHOWHIDE_LABEL_OBJ_BY_UID
	/*
	GraphPage gp = gvcHolder.GetPage();

	bool bExit = false;
	foreach ( GraphLayer gl in gp.Layers )
	{
		if(bExit)
			continue;
		
		VGraphLayer vgl(gl);
		Array<VTextLabel&>& arrTextLabels = vgl.AccessTextLabels();
		for ( int ii = 0; ii < arrTextLabels.GetSize(); ++ii )
		{
			// We can NOT reference to the TextLabel here, for more detail, please see #13677
			 VGraphObject& vgo = arrTextLabels.GetAt(ii).GetValidObj();
			if ( vgo.IsValid() && uTextLabelUID == vgo.GetUID() )
			{
				vgo.Show = bShow;
				bExit = true;
			}
		}		
	}
	*/
	bool bVisibleTextType = LTT_NONE != m_Setting.m_labelSetting.nTextType;	///Jasmine 08/13/2012 ORG-6381-S3 LABEL_DISPLAY_IS_CONTROL_BY_ITS_FORMAT_AND_PLOT_STATUS
	FOR_EACH_TEXT_LABEL_BEGIN(gvcHolder, label)
		if ( label.GetAttachedPlotUID() == uAttachedPlotUID )
		{
			label.GetValidObj().Show = bShow && bVisibleTextType;
			return true;
		}
	FOR_EACH_TEXT_LABEL_END
	///end PROPER_SHOWHIDE_LABEL_OBJ_BY_UID
	return true;
}
///End MENU_TO_HIDE_PLOT_FROM_DLG

void GraphVerticalCursorManager::OnLineDeleted(UINT uPageUID)
{
	RemoveVerticalCursor(uPageUID);
}

void GraphVerticalCursorManager::OnPageWndClosed( UINT uPageUID )
{
	///------ Folger 08/24/2012 ORG-6633-P1 REMOE_PAGE_FROM_VERTICAL_CURSOR_WHEN_PAGE_DESTROY_BUT_NOT_WINDOW_DESTROY
	//RemoveVerticalCursor(uPageUID);
	///------ End REMOE_PAGE_FROM_VERTICAL_CURSOR_WHEN_PAGE_DESTROY_BUT_NOT_WINDOW_DESTROY
}

void GraphVerticalCursorManager::OnUpdateLinePosition( UINT uPageUID, bool bIsMoving )
{
	int nHolderIndex = getCursorHolderIndex(uPageUID);
	if (nHolderIndex < 0)
	{
		ASSERT(FALSE);
		return;
	}

	// Kenny: When the line is moving, if we try to update the labels, some strange refresh problem will happen.
	// This is a temporary solution, please see related Tracker #13620
	if (bIsMoving)
	{
		if (m_pParentWnd)
			m_pParentWnd->SendMessage(WM_USER_UPDATE_CURSOR_POSITION, uPageUID, CURSOR_MOVING);
		return;
	}

	GraphVerticalCursorHolder& gvcHolder = m_arrGraphVerticalCursorHolders.GetAt(nHolderIndex);

	CStopWatch watch("OnUpdateLinePosition()");

	///Sophy 9/13/2012 ORG-6504-P1 GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
	gvcHolder.m_line.GetValidObj().SetIsMovedByKey(m_bLastMovedByKey);
	///end GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
	///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT
	//if (m_Setting.m_bSnapLineToData)
	if( IsLineSnappedToData() )
	///End SNAP_CURSOR_TO_DATA_PLOT
	{
		gvcHolder.m_line.GetValidObj().SnapToData();
		///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
		m_Setting.m_strSnappedPlot = gvcHolder.m_line.GetValidObj().GetLastSnapToPlotDescription();
		///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
		/// Kenny 12/06/2011 ORG-4042-P6 VERTICAL_CURSOR_GRAPH_REFRESH_BUG_WHEN_BMP_CACHE_ENABLED
		//LT_execute("doc -uwfp;"); ///Sophy 10/19/2011 ORG-3848-P3 REFRESH_ISSUE_WHEN_CHECK_SNAPTO_NEAREST_X
		/// End VERTICAL_CURSOR_GRAPH_REFRESH_BUG_WHEN_BMP_CACHE_ENABLED
	}
	///Sophy 10/13/2011 ORG-3106-S16 UPDATE_GRAPH_FILTER_ON_EACH_MOVEMENT
	updateGraphFilter(gvcHolder);
	///end UPDATE_GRAPH_FILTER_ON_EACH_MOVEMENT
	///Sophy 9/19/2011 ORG-3106-P9 LABEL_AND_TAG_VALUE_NOT_UPDATE_WHEN_HIDDEN
	//const bool bRet = retrieveHolderCursorInfo(gvcHolder, gvcHolder.m_Settings.bShowTextLabels);
	const bool bRet = retrieveHolderCursorInfo(gvcHolder);
	///end LABEL_AND_TAG_VALUE_NOT_UPDATE_WHEN_HIDDEN

	if (m_pParentWnd)
		m_pParentWnd->SendMessage(WM_USER_UPDATE_CURSOR_POSITION, uPageUID, bIsMoving ? CURSOR_MOVING : CURSOR_MOVED);
}

void GraphVerticalCursorManager::OnUpdateTextLabelsShowState(UINT uPageUID)
{
	if (m_pParentWnd)
		m_pParentWnd->SendMessage(WM_USER_UPDATE_TEXT_LABELS_SHOW_STATE, uPageUID);
}

void GraphVerticalCursorManager::onUpdateTagSelectState( UINT uPageUID, UINT uTagUID, BOOL bSelected )
{
	int nHolderIndex = getCursorHolderIndex(uPageUID);
	if (nHolderIndex < 0)
	{
		ASSERT(FALSE);
		return;
	}

	GraphVerticalCursorHolder& gvcHolder = m_arrGraphVerticalCursorHolders.GetAt(nHolderIndex);

	const int nTagIndex = gvcHolder.GetTagIndexByUID(uTagUID);
	if ( nTagIndex < 0 )
		return;

	VTagUnit& vTagUnit = gvcHolder.m_arrTagUnits.GetAt(nTagIndex);
	vTagUnit.m_bIsSelected = bSelected;

	if (bSelected)
	{
		if ( gvcHolder.m_nSelectedTagsCount <= 0)
			gvcHolder.m_nSelectedTagsCount = 1;
		else
			++gvcHolder.m_nSelectedTagsCount;
	}
	else
	{
		--gvcHolder.m_nSelectedTagsCount;
	}

	//MY_DBG_OUTPUT1("After: Selected tags count = %d", gvcHolder.m_nSelectedTagsCount);

	///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
	//vTagUnit.m_vTagLabel.GetValidObj().Show = bSelected;
	for(int ii = 0; ii < vTagUnit.m_arrTagLabels.GetSize(); ii++)
	{
		VTagLabel& vTagLabel = vTagUnit.m_arrTagLabels.GetAt(ii);
		vTagLabel.GetValidObj().Show = bSelected;
	}
	///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE

	if (m_pParentWnd)
		m_pParentWnd->SendMessage(WM_USER_UPDATE_TAG_SELECT_STATE, uPageUID, nTagIndex);
}

BOOL GraphVerticalCursorManager::removeCursorHolder( UINT uHolderIndex )
{
	UINT uPageUID = 0;
	GraphPage gp;
	BOOL bCleanupOK;
	{
		// We have to put these codes here, for more detail, please refer to #13677
		GraphVerticalCursorHolder& gvcHolder = m_arrGraphVerticalCursorHolders.GetAt(uHolderIndex);
		uPageUID = gvcHolder.m_uPageUID;
		gp = gvcHolder.GetPage();
		bCleanupOK = cleanupTagsEventHandlerScript( gvcHolder );
	}

	BOOL bRemoveOK = m_arrGraphVerticalCursorHolders.RemoveAt(uHolderIndex);
	ASSERT(bCleanupOK && bRemoveOK);
	if (bRemoveOK)
	{
		if (m_nCurrentTargetHolderIndex == uHolderIndex)
			m_nCurrentTargetHolderIndex = -1;
		else if (m_nCurrentTargetHolderIndex > uHolderIndex)
			--m_nCurrentTargetHolderIndex;

		if (gp.IsValid())
		{
			BOOL bRemovePageBinarayStorage = gp.SetMemory(STR_VERTICAL_CURSOR_BINARY_STORAGE_NAME, NULL);
			ASSERT(bRemovePageBinarayStorage);
		}

		MY_DBG_OUTPUT2("The %dth GVC is removed! Total = %u", (uHolderIndex+1), m_arrGraphVerticalCursorHolders.GetSize() );
		if (m_pParentWnd)
			m_pParentWnd->SendMessage(WM_USER_CURSOR_DELETED, uPageUID);
	}
	return bRemoveOK;
}

BOOL GraphVerticalCursorManager::cleanupTagsEventHandlerScript( GraphVerticalCursorHolder& gvcHolder )
{
	const int nTagLabelSize = gvcHolder.m_arrTagUnits.GetSize();
	for (int ii = 0; ii < nTagLabelSize; ++ii)
	{
		const VTagUnit& vTagUnit = gvcHolder.m_arrTagUnits.GetAt(ii);
		vTagUnit.CleanupEventHandlerScript();
	#ifdef REMOVE_LABEL_FEATURE
		///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
		//vTagUnit.m_vTagLabel.GetValidObj().Show = TRUE;
		for(int jj = 0; jj < vTagUnit.m_arrTagLabels.GetSize(); jj++)
		{
			VTagLabel& vTagLabel = vTagUnit.m_arrTagLabels.GetAt(jj);
			vTagLabel.GetValidObj().Show = TRUE;
		}
		///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
	#endif//REMOVE_LABEL_FEATURE
	}
	return TRUE;
}

void GraphVerticalCursorManager::OnTagSelected(UINT uPageUID, UINT uTagUID)
{
	onUpdateTagSelectState(uPageUID, uTagUID, TRUE);
}

void GraphVerticalCursorManager::OnTagUnselected(UINT uPageUID, UINT uTagUID)
{
	onUpdateTagSelectState(uPageUID, uTagUID, FALSE);
}

void GraphVerticalCursorManager::OnTagDeleted(UINT uPageUID, UINT uTagUID)
{
	int nHolderIndex = getCursorHolderIndex(uPageUID);
	if (nHolderIndex < 0)
	{
		ASSERT(FALSE);
		return;
	}
	GraphVerticalCursorHolder& gvcHolder = m_arrGraphVerticalCursorHolders.GetAt(nHolderIndex);
	const int nTagIndex = gvcHolder.GetTagIndexByUID(uTagUID);

	if ( nTagIndex >= 0 )
		removeTag(gvcHolder, nTagIndex);
}

void GraphVerticalCursorManager::OnTagLabelDeleted( UINT uPageUID, UINT uTagLabelUID )
{
	int nHolderIndex = getCursorHolderIndex(uPageUID);
	if (nHolderIndex < 0)
	{
		ASSERT(FALSE);
		return;
	}
	GraphVerticalCursorHolder& gvcHolder = m_arrGraphVerticalCursorHolders.GetAt(nHolderIndex);
	const int nTagIndex = gvcHolder.GetTagLabelIndexByUID(uTagLabelUID);

	if ( nTagIndex >= 0 )
		removeTag(gvcHolder, nTagIndex);
}

void GraphVerticalCursorManager::OnTextLabelMoved( UINT uPageUID, UINT uTextLabelUID )
{
	int nHolderIndex = getCursorHolderIndex(uPageUID);
	if (nHolderIndex < 0)
	{
		ASSERT(FALSE);
		return;
	}
	GraphVerticalCursorHolder& gvcHolder = m_arrGraphVerticalCursorHolders.GetAt(nHolderIndex);
	GraphPage gp = gvcHolder.GetPage();

	foreach ( GraphLayer gl in gp.Layers )
	{
		VGraphLayer vgl(gl);
		Array<VTextLabel&>& arrTextLabels = vgl.AccessTextLabels();
		for ( int ii = 0; ii < arrTextLabels.GetSize(); ++ii )
		{
			// We can NOT reference to the TextLabel here, for more detail, please see #13677
			if (arrTextLabels.GetAt(ii).GetValidObj().IsValid() && uTextLabelUID == arrTextLabels.GetAt(ii).GetValidObj().GetUID() )
			{
				arrTextLabels.GetAt(ii).GetValidObj().LogOffsetToMarkedPos();
				gvcHolder.SaveTextLabelPropertiesToPage(arrTextLabels.GetAt(ii).GetValidObj());
				break;
			}
		}
	}
}

void GraphVerticalCursorManager::OnTextLabelDeleted( UINT uPageUID, UINT uTextLabelUID )
{
	int nHolderIndex = getCursorHolderIndex(uPageUID);
	if (nHolderIndex < 0)
	{
		ASSERT(FALSE);
		return;
	}
	GraphVerticalCursorHolder& gvcHolder = m_arrGraphVerticalCursorHolders.GetAt(nHolderIndex);

	GraphPage gp = gvcHolder.GetPage();
	GraphLayer	glClearArray;
	
	foreach ( GraphLayer gl in gp.Layers )
	{
		VGraphLayer vgl(gl);
		int		nIndex = -1;
		Array<VTextLabel&>&		arrTextLabels = vgl.AccessTextLabels();
		for ( int ii = 0; ii < arrTextLabels.GetSize(); ++ii )
		{
			// Folger: Referencing to an object within an array may cause run-time error.
			if (arrTextLabels.GetAt(ii).GetValidObj().IsValid() && uTextLabelUID == arrTextLabels.GetAt(ii).GetValidObj().GetUID() )
			{
				nIndex = ii;
				break;
			}
		}
		
		if ( nIndex >= 0 )
		{
			gvcHolder.SaveTextLabelPropertiesToPage(arrTextLabels.GetAt(nIndex).GetValidObj(), TRUE);
			arrTextLabels.RemoveAt(nIndex);
			if ( 0 == arrTextLabels.GetSize() )
				glClearArray = gl;
			break;
		}
	}
	
	if ( glClearArray )
	{
		VGraphLayer vgl(glClearArray);
		vgl.RemoveTextLabels();
	}
}

#ifdef _DEBUG
BOOL GraphVerticalCursorManager::GetProperties( TreeNode& tnProperties )
{
	if (tnProperties.IsValid())
	{
		tnProperties += m_Setting;
	
		TreeNode tnHolders = tree_check_get_node(tnProperties, STR_OBJ_TAG_NAME_VHOLDERS);
	
		const int nHolderSize = m_arrGraphVerticalCursorHolders.GetSize();
		for (int ii = 0; ii < nHolderSize; ++ii)
		{
			GraphVerticalCursorHolder& holder = m_arrGraphVerticalCursorHolders.GetAt(ii);
			const string strNodeName = STR_OBJ_TAG_NAME_VHOLDER_PREFIX + STR_OBJ_DELIMITER + (ii+1);
			TreeNode tnHolder = tree_check_get_node(tnHolders, strNodeName);
			BOOL bRet = holder.GetProperties(tnHolder);
			ASSERT(bRet);
		}
		return TRUE;
	}
	return FALSE;
}
#endif // _DEBUG
///Sophy 10/19/2011 ORG-3848-P1 ADD_TAG_AND_LABEL_SHOULD_FOLLOW_CURRENT_FONT_SETTING
//BOOL	GraphVerticalCursorManager::createTag(GraphLayer& glParent, GraphObject& goLine, GraphObject& goLabel)
BOOL	GraphVerticalCursorManager::createTag(GraphLayer& glParent, GraphObject& goLine, GraphObject& goLabel, int nFontSize)
///end ADD_TAG_AND_LABEL_SHOULD_FOLLOW_CURRENT_FONT_SETTING
{
	///------ Folger 08/10/2012 ORG-6381-S3 VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
	string strFormat = makeTagText(m_Setting.m_tagSetting.nXFormat, m_Setting.m_cursorshow.strXDisp, m_Setting.m_tagSetting.nXFormat);
	if ( strFormat.IsEmpty() )
		return TRUE;
	///------ End VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM

	GraphObject goTag;
	if ( create_simple_label(glParent, goTag, nFontSize) )
	{
		///Sophy 9/15/2011 ORG-3106-P1 PROPER_DISPLAY_TAG_VALUE_FOR_INTERSECT_POINT
		StringArray	saStorageNames;
		vector		vdStorageValues;
		goLabel.GetStorageNumericVars(&saStorageNames, &vdStorageValues);
		goTag.SetStorageNumericVars(&saStorageNames, &vdStorageValues);		
		///end PROPER_DISPLAY_TAG_VALUE_FOR_INTERSECT_POINT
		goTag.Attach = ATTACH_TO_PAGE;
		///------ Folger 08/10/2012 ORG-6381-S3 VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
		//set_text_format(goTag, makeTagText(m_Setting.m_tagSetting.nXFormat, m_Setting.m_cursorshow.strXDisp, m_Setting.m_tagSetting.nXFormat));
		set_text_format(goTag, strFormat);
		///------ End VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
		///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
		// double dYTop = goLine.Y + goLine.DY/2.0 - goTag.DY;
		// double dYBottom = goLine.Y - goLine.DY/2.0 + goTag.DY;
		// goTag.X = goLine.X + goTag.DX/2;
		BOOL bIsLineLengthSpanLayers = m_Setting.IsLineLengthSpanLayers();
		double dYTop = goLine.Y + goLine.DY/2.0 + (bIsLineLengthSpanLayers ? goTag.DY : -goTag.DY);
		double dYBottom = goLine.Y - goLine.DY/2.0 + (bIsLineLengthSpanLayers ? -goTag.DY : goTag.DY);
		goTag.X = goLine.X + (bIsLineLengthSpanLayers ? 0 : goTag.DX/2);
		///------ End VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS		
		goTag.Y = m_Setting.m_tagSetting.nLocation == TL_TOP ? dYTop : dYBottom;
		goTag.ConnectTo(goLine, CTP_TOP, -1, false);
		goTag.MoveObject(MO_BOTTOM);
		update_go_states(goTag, GOC_SHOW_INSIDE); ///------ Folger 09/20/2012 ORG-6761-S1 HIDE_LINE_WHEN_IT_OUTSIDE_OF_PAGE
		return TRUE;
	}

	return FALSE;;
}


UINT GraphVerticalCursorManager::getActualPageUID( UINT uPageUID /*= 0*/ )
{
	if (0 == uPageUID)
	{
		GraphLayer glActive = Project.ActiveLayer();
		if (glActive)
		{
			GraphPage gp = glActive.GetPage();
			if (gp)
			{
				uPageUID = gp.GetUID(TRUE);
				ASSERT(uPageUID > 0);
			}
		}
	}
	return uPageUID;
}

int GraphVerticalCursorManager::getCursorHolderIndex( UINT uPageUID )
{
	const int nHolderSize = m_arrGraphVerticalCursorHolders.GetSize();
	for (int ii = 0; ii < nHolderSize; ++ii)
	{
		const GraphVerticalCursorHolder& gvcHolder = m_arrGraphVerticalCursorHolders.GetAt(ii);
		if (uPageUID == gvcHolder.m_uPageUID)
			return ii;
	}
	return -1;
}
///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE	
VTagUnit* GraphVerticalCursorManager::addTag( GraphVerticalCursorHolder& gvcHolder, const GraphLayer& gl, double dXScaleMark)
{
	VTagUnit* pvTagUnit = gvcHolder.AddTagUnit(gl, dXScaleMark, m_Setting.m_labelSetting.strLTCustomTextType);
	if ( !pvTagUnit )
	{
		ASSERT(FALSE);
		return NULL;
	}

	MY_DBG_OUTPUT2("Adding tag %s  (%g, 0)", pvTagUnit->m_vTag.GetValidObj().GetRangeString(), dXScaleMark);
	return pvTagUnit;
}

int GraphVerticalCursorManager::addTagDone(GraphVerticalCursorHolder& gvcHolder, const VTagUnit& vTagUnit)
{
	gvcHolder.SaveTagUnitPropertiesToPage(vTagUnit);
///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
	const int nTagIndex = gvcHolder.m_arrTagUnits.GetSize()-1;

	if (m_pParentWnd)
		m_pParentWnd->SendMessage(WM_USER_TAG_ADDED, gvcHolder.m_uPageUID, nTagIndex);

	return nTagIndex;
}

int GraphVerticalCursorManager::removeTag( GraphVerticalCursorHolder& gvcHolder, UINT uTagIndex )
{
	if (uTagIndex >= gvcHolder.m_arrTagUnits.GetSize())
	{
		ASSERT(FALSE);
		return -1;
	}

	gvcHolder.SaveTagUnitPropertiesToPage( gvcHolder.m_arrTagUnits.GetAt(uTagIndex), TRUE );

	// Kenny: we can't declare an reference to TagUnit here unless we use it in a different scope to RemoveAt statement.
	// For more detail, please see #13677

	UINT uTagUID;
	{
		VTag& vTag = gvcHolder.m_arrTagUnits.GetAt(uTagIndex).m_vTag;
		uTagUID = vTag.GetValidObj().GetUID();
	}

	// Kenny: I have no idea why the following statement will lead to crash, temporary solution
	//if ( gvcHolder.m_arrTagUnits.GetAt(uTagIndex).Destroy() && gvcHolder.m_arrTagUnits.RemoveAt(uTagIndex) )

	bool bDestroy = gvcHolder.m_arrTagUnits.GetAt(uTagIndex).Destroy();
	if ( bDestroy && gvcHolder.m_arrTagUnits.RemoveAt(uTagIndex) )
	{
		if (m_pParentWnd)
		{
			m_pParentWnd->SendMessage(WM_USER_TAG_DELETED, gvcHolder.m_uPageUID, uTagUID);
		}
		return 0;
	}
	ASSERT(FALSE);
	return -2;
}

//int GraphVerticalCursorManager::getAllTagsPosAndPlotInfo( const GraphVerticalCursorHolder& gvcHolder, vector<int>& vnXCenter, vector<int>& vnYCenter /*= NULL*/, vector<UINT>& vnTagPlotUIDMap /*= NULL */ )
int GraphVerticalCursorManager::getAllTagsPosAndPlotInfo( const GraphVerticalCursorHolder& gvcHolder, vector<int>& vnXCenter)
{
	const int nTagSize = gvcHolder.m_arrTagUnits.GetSize();
	vnXCenter.SetSize(nTagSize);
	///Jasmine 12/11/09 QA81-8980 CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE
	/*
	if (vnYCenter)
		vnYCenter.SetSize(nTagSize);
	if (vnTagPlotUIDMap)
		vnTagPlotUIDMap.SetSize(nTagSize);
	for (int ii = 0; ii < nTagSize; ++ii)
	{
		const VTagUnit& vTagUnit = gvcHolder.m_arrTagUnits.GetAt(ii);
		vnXCenter[ii]		= vTagUnit.m_vTag.GetValidObj().GetCenterPageX();
		if (vnYCenter)
			vnYCenter[ii]	= vTagUnit.m_vTag.GetValidObj().GetCenterPageY();
		if (vnTagPlotUIDMap)
			vnTagPlotUIDMap[ii]	= vTagUnit.m_vTagLabel.GetAttachedPlotUID();
	}*/
	for (int ii = 0; ii < nTagSize; ++ii)
	{
		const VTagUnit& vTagUnit = gvcHolder.m_arrTagUnits.GetAt(ii);
		vnXCenter[ii]		= vTagUnit.m_vTag.GetValidObj().GetCenterPageX();
	}
	///End CHANGE_TAG_LINE_TO_ACROSS_WHOLE_PAGE

	return nTagSize;
}

int GraphVerticalCursorManager::getTagsInSamePageX( const GraphVerticalCursorHolder& gvcHolder, int nPageX, vector<UINT>& vnTagIndices )
{
	vector<int>		vnTagXCenter;

	getAllTagsPosAndPlotInfo(gvcHolder, vnTagXCenter);
	int nRet = vnTagXCenter.Find(MATREPL_TEST_EQUAL, nPageX, vnTagIndices);
	return nRet;
}

///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
static bool _get_notaion_by_type(	const DataPlot& dp, bool bGetX, string& strBook, string& strSheet, string& strCol, string& strLongname, 
									string& strGraph)	///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
{	
	///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
	GraphLayer gl;
	dp.GetParent(gl);
	strGraph = gl.GetPage().GetName();
	///End SUPPORT_MULTI_WINS_CURSOR
	
	Datasheet		ds;
	OriginObject 	obj;
	XYRange 		xy;
	if( !dp.GetDataRange(xy) )
		return false;
	
	string strXData;
	xy.GetDatasetNames(strCol, strXData);//in case loose dataset
	///Jasmine 01/26/10 OUTPUT_X_COLUMN_NEED_MORE_INFO
	if(bGetX)
	{
		strCol = strXData;
		Column xcol;
		if( !xy.GetXColumn(xcol) )
			return false;
		xcol.GetParent(ds);
		obj = xcol;
	}
	///End OUTPUT_X_COLUMN_NEED_MORE_INFO
	else if( !get_main_dataobj_from_datarange(xy, ds, obj) )
		return false;
	
	strSheet = ds.GetName();
	
	Page pg = ds.GetPage();
	int nType = pg.GetType();
	strBook = pg.GetName();
	
	switch(nType)
	{
	case EXIST_WKS:
		Column col;
		col = obj;
		if(col)
		{
			strCol = col.GetName();
			strLongname = col.GetLongName();
		}
		break;
	case EXIST_MATRIX:
		MatrixObject mo;
		mo = obj;
		if(mo)
		{
			strCol = mo.GetName();
			strLongname = mo.GetLongName();
		}
		break;
	default:
		ASSERT(0);
		break;
	}
	
	return true;
}
///End MORE_CONFIGURATION_FOR_INFO_TABLE

///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
///Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT
/*static bool _get_src_col_format(const DataPlot& dp, int& nFormat, int& nDisplay, string& strCustom, bool bXCol = true)
{
	nFormat = nDisplay = -1;
	strCustom = "";
	string strFormat;
	
	Column colObj;
	XYRange xy;
	if( !dp.GetDataRange(xy) || (bXCol && !xy.GetXColumn(colObj)) || (!bXCol && !xy.GetYColumn(colObj)) )
		return false;
	
	Tree trColFmt;
	trColFmt = colObj.GetFormat(FPB_ALL, FOB_ALL, true, true);
	if(trColFmt.Root.Format)
	{
		nFormat = trColFmt.Root.Format.nVal;
		switch(nFormat)
		{
		case OKCOLTYPE_TIME:
		case OKCOLTYPE_DATE:
		case OKCOLTYPE_MONTH:
		case OKCOLTYPE_WEEKDAY:
			nDisplay = trColFmt.Root.Display.nVal;
			
			strFormat.Format("%d|%d", nFormat, nDisplay);
			
			if(OKCOLTYPE_DATE == nFormat && LDF_OBJ_CUSTOM == nDisplay)
				strCustom = trColFmt.Root.CustomFormat.strVal;
			break;
		}
	}
	
	return !strFormat.IsEmpty();
}*/
static bool _get_axis_label_format(const DataPlot& dp, int& nFormat, int& nDisplay, string& strCustom, bool bXAxis = true)
{
	nFormat 	= nDisplay = -1;
	strCustom 	= "";
	string 	strFormat;
	bool	bRet = false;
	GraphLayer gl;
	dp.GetParent(gl);
	AxisObject aoLabel;
	if(bXAxis)
		aoLabel = gl.XAxis.AxisObjects(AXISOBJPOS_LABEL_FIRST);
	else
		aoLabel = gl.YAxis.AxisObjects(AXISOBJPOS_LABEL_FIRST);
	if(aoLabel.IsValid())
	{
		int 	nDisp;
		string 	str;
		aoLabel.GetTypeFormatEtc(nFormat, &str, &nDisp);
		switch(nFormat)
		{
		case OULABEL_TIME:
		case OULABEL_DATE:
		case OULABEL_MONTH:
		case OULABEL_DAYOFWEEK:
			nDisplay = nDisp;
			bRet = true;
			
			if(OULABEL_DATE == nFormat && LDF_OBJ_CUSTOM == nDisplay)
			{
				Tree trFmt;
				trFmt = aoLabel.GetFormat(FPB_ALL, FOB_ALL, true, true);
				if(trFmt.Root.DateCustomDisplay)
					strCustom = trFmt.Root.DateCustomDisplay.strVal;
			}
		}
	}
	
	return bRet;
}
///End SHOW_XVALUE_WITH_FORMAT
///End LABEL_FOLLOW_AXIS_FORMAT

///Jasmine 01/22/10 OUTPUT_WKS_XCOL_LNAME_USE_AXIS_TITLE
string _get_layer_xaxis_title(const GraphLayer& gl)
{
	string strTitle;
	
	GraphObject go;
	AxisObject ao = gl.XAxis.AxisObjects(AXISOBJPOS_AXIS_FIRST);
	if(ao)
		go = ao.GetTitleObject();
	
	if(!go)
		return strTitle;
	
	string strVar = "_tempTitle";
	gl.LT_execute(strVar+"$="+go.Text);
	
	char	szBuffer[MAXLINE];
	LT_get_str(strVar, szBuffer, MAXLINE);
	strTitle = szBuffer;
	
	LT_execute("del -vs "+strVar);
	
	return strTitle;
}
///End OUTPUT_WKS_XCOL_LNAME_USE_AXIS_TITLE

///Sophy 9/20/2011 ORG-3843-P1 PROPER_LOAD_SETTINGS_WHEN_OPEN_OGG
class VerticalCursorBusyHelper
{
public:
	VerticalCursorBusyHelper(bool* pBusy)
	{
		m_pBusy = pBusy;
		if ( m_pBusy != NULL )
			*m_pBusy = true;
	}
	~VerticalCursorBusyHelper()
	{
		if ( m_pBusy != NULL )
			*m_pBusy = false;		
	}
private:
	bool*	m_pBusy;
};
///end PROPER_LOAD_SETTINGS_WHEN_OPEN_OGG 
bool GraphVerticalCursorManager::retrieveHolderCursorInfo( GraphVerticalCursorHolder& gvcHolder, bool bUpdateTextLabels /*= true*/, bool bUpdateNotation/* = true*/ )
{
	CStopWatch watch("retrieveHolderCursorInfo()");

	///------ Folger 01/22/10 CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE
	//const int nLinePageCoord = gvcHolder.m_line.GetValidObj().GetPagePosition();
	double rLinePageCoord = NANUM;
	double rLineScale = NANUM;
	///------ Folger 08/31/2012 ORG-6681-P1 GLOBAL_GADGET_MANAGER_SERIALIZATION
	//if ( IsLineSnappedToData() )
	if ( IsLineSnappedToData() && gvcHolder.IsSnapToXDataValid() )
	///------ End GLOBAL_GADGET_MANAGER_SERIALIZATION
	{
		///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
		//WorldToView(rLinePageCoord, gvcHolder.GetSnapToX());
		GraphLayer glLine;
		gvcHolder.m_line.GetParent(glLine);	
		WorldToView(glLine, rLinePageCoord, gvcHolder.GetSnapToX());
		///End BTN_TO_CAHNGE_X_REFERECE_LAYER
	}
	else if ( m_pParentWnd && m_pParentWnd->SendMessage(WM_USER_QUERY_POSITION_CHANGE_BY_EDITING, (DWORD)(void*)&rLineScale) )
	{
		///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
		//WorldToView(rLinePageCoord, rLineScale);
		GraphLayer glXBased;
		gvcHolder.GetXBasedLayer(glXBased);
		WorldToView(glXBased, rLinePageCoord, rLineScale);
		///End BTN_TO_CAHNGE_X_REFERECE_LAYER
	}
	else
	{
		rLinePageCoord = gvcHolder.m_line.GetValidObj().GetPagePosition();
	}
	///------ End CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE
	GraphPage gp = gvcHolder.GetPage();
	if (!gp)
	{
		ASSERT(FALSE);
		return false;
	}

	if (m_pParentWnd)
		m_pParentWnd->SendMessage(WM_USER_UPDATE_CURSOR_INTERSECT_POINT_BEGIN, gvcHolder.m_uPageUID);
	///Jasmine 01/15/10 REORDER_CURSOR_VALUE_BY_LAYER_POS	
	for(int ii = m_arrPoints.GetSize()-1; ii >= 0; ii--)
		m_arrPoints.RemoveAt(ii);
	///End REORDER_CURSOR_VALUE_BY_LAYER_POS

	///Jasmine 03/16/2012 ORG-4971 RETRIEVE_CURSOR_VALUE_FROM_LINKED_GRAPHS
	retrieveOneGraphVIntersectPoint(gvcHolder, gp, rLinePageCoord, bUpdateTextLabels, bUpdateNotation);
	///Jasmine 05/2202012 ORG-4917-P2 UPDATE_LINK_GRAPH_LABEL_FONT_SIZE
	int nLabelFontSize = 0;
	FOR_EACH_TEXT_LABEL_BEGIN(gvcHolder, textLabel)
	{
		if(nLabelFontSize > 0)
			break;
		nLabelFontSize = textLabel.GetFontSize();
	}
	FOR_EACH_TEXT_LABEL_END
	///End UPDATE_LINK_GRAPH_LABEL_FONT_SIZE
	
	///Jasmine 05/14/2012 ORG-4971-P4 SHOULD_NOT_USE_PARENT_GRAPH_PAGE_COORD
#ifdef CALC_LINKED_GRAPH_X_VALUE_BASE_ON_PERCENT_OF_PAGE
	GraphObject	goLine = gvcHolder.m_line.GetValidObj();
	Tree 		trFmt;
	trFmt 		= goLine.GetFormat(FPB_DATA, FOB_ALL, true, true);
	string 		strPath = "Root.Data";
	TreeNode 	trX = trFmt.GetNodeFromPath(strPath+".X");
	vector		vx;
	vx 			= trX.dVals;
#else //base on x scale of spcified layer	
	GraphLayer glActive;
	gvcHolder.GetXBasedLayer(glActive);//gvcHolder.m_line.GetParent(glActive);	///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
	VGraphLayer	vglActive(glActive);
	double		dXScale;
	vglActive.PageToScaleCoordinate(rLinePageCoord, dXScale);
#endif //CALC_LINKED_GRAPH_X_VALUE_BASE_ON_PERCENT_OF_PAGE
	///End SHOULD_NOT_USE_PARENT_GRAPH_PAGE_COORD
	
	vector<OUID> vnGraphUIDs;
	int nSize = gvcHolder.GetLinkedGraphs(&vnGraphUIDs);
	for(ii = 0; ii < nSize; ii++)
	{
		GraphPage 	gpLinked;
		gpLinked 	= (GraphPage)Project.GetObject( vnGraphUIDs[ii] );
		///Jasmine 05/03/2012 ORG-4971-P1 LINK_GRAPHS_SHOULD_HAVE_ITS_OWN_LAYER_FILTER
		//if(gpLinked)
		//	retrieveOneGraphVIntersectPoint(gvcHolder, gpLinked, rLinePageCoord, bUpdateTextLabels, bUpdateNotation, true);		
		vector<int>	vnLayerIndex;
		///Jasmine 05/14/2012 ORG-4971-P4 SHOULD_NOT_USE_PARENT_GRAPH_PAGE_COORD
		//if( gpLinked && updateGraphFilter(rLinePageCoord, gpLinked, vnLayerIndex) )
			//retrieveOneGraphVIntersectPoint(gvcHolder, gpLinked, rLinePageCoord, bUpdateTextLabels, bUpdateNotation, vnLayerIndex, true);
#ifdef CALC_LINKED_GRAPH_X_VALUE_BASE_ON_PERCENT_OF_PAGE
		double 		dPosVal[TOTAL_POS] = {0};
		dPosVal[LEFT_POS] = vx[0] * 100;
		double 		rMyPageCoord = gpLinked.Layers(0).UnitsConvert(M_PIXEL, dPosVal, M_PERCENT)? dPosVal[LEFT_POS] : rLinePageCoord;		
#else //base on x scale of spcified layer	
		double 		rMyPageCoord;
		VGraphLayer	vglSpecified( gpLinked.Layers(0) );
		vglSpecified.ScaleToPageCoordinate(dXScale, rMyPageCoord);
#endif //CALC_LINKED_GRAPH_X_VALUE_BASE_ON_PERCENT_OF_PAGE
		if( gpLinked && updateGraphFilter(rMyPageCoord, gpLinked, vnLayerIndex) )
			retrieveOneGraphVIntersectPoint(gvcHolder, gpLinked, rMyPageCoord, bUpdateTextLabels, bUpdateNotation, vnLayerIndex, true, 
											&nLabelFontSize);		///Jasmine 05/2202012 ORG-4917-P2 UPDATE_LINK_GRAPH_LABEL_FONT_SIZE
		///End SHOULD_NOT_USE_PARENT_GRAPH_PAGE_COORD
		///End LINK_GRAPHS_SHOULD_HAVE_ITS_OWN_LAYER_FILTER
		else
			ASSERT(0);
	}
	///End RETRIEVE_CURSOR_VALUE_FROM_LINKED_GRAPHS
	
	if (m_pParentWnd)
		m_pParentWnd->SendMessage(WM_USER_NEW_CURSOR_INTERSECT_POINT, gvcHolder.m_uPageUID, 0);
			
	return true;
}

///Jasmine 03/16/2012 ORG-4971 RETRIEVE_CURSOR_VALUE_FROM_LINKED_GRAPHS
bool GraphVerticalCursorManager::retrieveOneGraphVIntersectPoint(GraphVerticalCursorHolder& gvcHolder, GraphPage& gp, double rLinePageCoord, bool bUpdateTextLabels, bool bUpdateNotation,
																	vector<int>& vnLayerIndex/* = NULL*/,		///Jasmine 05/03/2012 ORG-4971-P1 LINK_GRAPHS_SHOULD_HAVE_ITS_OWN_LAYER_FILTER
																	bool bHideTextLabels/* = false*/,			///Jasmine 03/22/2012 ORG-4971 DUMP_TAG_AND_LABEL_TO_LINKED_GRAPHS
																	int* pnLabelFontSize/* = NULL*/)			///Jasmine 05/2202012 ORG-4917-P2 UPDATE_LINK_GRAPH_LABEL_FONT_SIZE
{
	///Jasmine 01/26/10 OUTPUT_X_COLUMN_NEED_MORE_INFO
	//since there's one X column in output sheet, we can only get info from one dataplot
	GraphLayer 	glToGetXInfo;
	DataPlot 	dpToGetXInfo;
	if( IsLineSnappedToData(&dpToGetXInfo) && dpToGetXInfo )
		dpToGetXInfo.GetParent(glToGetXInfo);
	else
	{
		glToGetXInfo = gp.Layers(0);
		dpToGetXInfo = glToGetXInfo.DataPlots(0);
	}
	
	if ( !dpToGetXInfo )
		return true;

	//string strXInfo = _get_layer_xaxis_title(glToGetXInfo);	///Jasmine 01/22/10 OUTPUT_WKS_XCOL_LNAME_USE_AXIS_TITLE
	string	strXBook, strXSheet, strXCol, strXLongname;
	string	strXGraph;					///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
	_get_notaion_by_type(	dpToGetXInfo, true, strXBook, strXSheet, strXCol, strXLongname, 
							strXGraph);	///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
	uint 	uidplotx = dpToGetXInfo.GetUID(TRUE);
	///Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT
	int 	nFormat, nDisplay;
	string	strCustom;
	_get_axis_label_format(dpToGetXInfo, nFormat, nDisplay, strCustom);//_get_src_col_format	///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
	///End SHOW_XVALUE_WITH_FORMAT
	///End OUTPUT_X_COLUMN_NEED_MORE_INFO
	
	
	int nUpdateLabelCount = 0, nPlotShowCount = m_Setting.m_cursorshow.vnPlotShow.GetSize(), nPlotIDCount = m_Setting.m_cursorshow.vsPlotIDs.GetSize();
	foreach(GraphLayer gl in gp.Layers)
	{
		///Sophy 9/27/2011 ORG-3106-S16 PROPER_FILTER_LAYER_FOR_VERTICAL_INTERSECT_CALC
		///Jasmine 05/03/2012 ORG-4971-P1 LINK_GRAPHS_SHOULD_HAVE_ITS_OWN_LAYER_FILTER
		//if ( find_in_list(gl.GetIndex(), gvcHolder.m_Settings.vnLayerIndex, false) < 0 )
		if ( find_in_list(gl.GetIndex(), vnLayerIndex == NULL? gvcHolder.m_Settings.vnLayerIndex : vnLayerIndex, false) < 0 )
		///End LINK_GRAPHS_SHOULD_HAVE_ITS_OWN_LAYER_FILTER
		{
			hideAttachedLabels(gl);
			continue;
		}
		///end PROPER_FILTER_LAYER_FOR_VERTICAL_INTERSECT_CALC
		VGraphLayer	vgl(gl);
		double		dXScale;
		vgl.PageToScaleCoordinate(rLinePageCoord, dXScale);

		Array<VTextLabel&>&		arrTextLabels	= vgl.AccessTextLabels();
		const int 				nLabelSize		= arrTextLabels.GetSize();

		int		nUpdateLabelCountPerLayer = 0;

		///------ Folger 08/03/2012 ORG-6409-S1 VERTICAL_CURSOR_USAGE_IMPROVEMENT
		BOOL bActiveLayer = is_same_layer(gl, Project.ActiveLayer());
		int nActivePlot = gl.DataPlots().IsValid()? gl.DataPlots().GetIndex() : -1;
		///------ End VERTICAL_CURSOR_USAGE_IMPROVEMENT

		foreach (DataPlot dp in gl.DataPlots)
		{
			///Jasmine07/08/2011 ORG-3106-P4 HIDDEN_PLOT_SHOULD_NOT_IN_LIST
			if(!dp.Show)
				continue;
			///End HIDDEN_PLOT_SHOULD_NOT_IN_LIST
			
			///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
			string strBook, strSheet, strCol, strLongname;
			string strGraph;	///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
			if(bUpdateNotation)
			{
				_get_notaion_by_type(	dp, false, strBook, strSheet, strCol, strLongname, 
										strGraph);		///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
			}
			///End MORE_CONFIGURATION_FOR_INFO_TABLE
			///Jasmine 01/15/10 REORDER_CURSOR_VALUE_BY_LAYER_POS
			int layPosX, layPosY;			
			if( !dp.GetAveragePageCoordinates(&layPosY, &layPosX) )
				layPosX = layPosY = -1;
			///End REORDER_CURSOR_VALUE_BY_LAYER_POS

			vector vY;
			VDataPlot vdp(dp);
			vector<BOOL> vbIsInterpolated;
			vector<int> vnIndex;	///Jasmine 01/20/10 SHOW_NEAREST_POINT
			///------ Folger 08/14/2012 ORG-6381-S1 DATAPLOT_GETDATAPOINT_SUPPORT_NO_Y_OFFSET
			//vdp.GetYValues(dXScale, vY, vbIsInterpolated, vnIndex);
			vector vYWithOffset;
			vdp.GetYValues(dXScale, vY, vbIsInterpolated, vnIndex, vYWithOffset);
			///------ End DATAPLOT_GETDATAPOINT_SUPPORT_NO_Y_OFFSET

			const int nYValSize = vY.GetSize();

			for (int ii = 0; ii < nYValSize; ++ii)
			{
				if ( bUpdateTextLabels )
				{
					if ( nUpdateLabelCountPerLayer >= nLabelSize )
					{
						VTextLabel* pVTextLabel = new VTextLabel;
						if ( !pVTextLabel )
						{
							ASSERT(FALSE);
							continue;
						}
						///Jasmine 05/2202012 ORG-4917-P2 UPDATE_LINK_GRAPH_LABEL_FONT_SIZE
						//if ( !pVTextLabel->Create(gl, dXScale, vY[ii]) )
						if ( !pVTextLabel->Create(gl, dXScale, vY[ii], pnLabelFontSize == NULL? 0 : *pnLabelFontSize) )
						///End UPDATE_LINK_GRAPH_LABEL_FONT_SIZE
						{
							delete pVTextLabel;
							ASSERT(FALSE);
							continue;
						}

						string strLTScript;
						strLTScript.Format(STR_OBJ_EVENT_LT_SCRIPT_FORMAT, VCOT_TEXT_LABEL);
						pVTextLabel->SetLabTalkScriptEvent(strLTScript);
						///Sophy 11/18/2011 ORG-3929-P1 VERTICALCURSOR_DIALOG_TOO_SLOW
						//pVTextLabel->AttachToPlot(dp);
						pVTextLabel->AttachToPlot(dp, TRUE);
						///end VERTICALCURSOR_DIALOG_TOO_SLOW
						
					#ifdef REMOVE_LABEL_FEATURE
						pVTextLabel->Show = FALSE;
					#else
						///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
						//pVTextLabel->Show = gvcHolder.m_Settings.bShowTextLabels && !(nUpdateLabelCount <  m_Setting.m_cursorshow.vnPlotShow.GetSize() && m_Setting.m_cursorshow.vnPlotShow[nUpdateLabelCount] == 0);
						bool bShow = false;
						if(gvcHolder.m_Settings.bShowTextLabels)
						{
							if(nUpdateLabelCount >= nPlotShowCount)
								bShow = true;
							///Jasmine 08/30/2012 ORG-6634-P1 PLOTS_ORDER_SHOULD_NOT_SAVE_INI_FOR_OTHER_GRAPHS_TO_LOAD
							else if(nPlotIDCount <= 0)
								bShow = true;
							///End PLOTS_ORDER_SHOULD_NOT_SAVE_INI_FOR_OTHER_GRAPHS_TO_LOAD
							else
							{
								int nFind = m_Setting.m_cursorshow.vsPlotIDs.Find( (string)pVTextLabel->GetAttachedPlotUID() );
								if(-1 < nFind && nFind < nPlotShowCount)
									bShow = m_Setting.m_cursorshow.vnPlotShow[nFind];
							}
						}
						pVTextLabel->Show = bShow;
						///End ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
					#endif

						arrTextLabels.Add(*pVTextLabel);

						gvcHolder.SaveTextLabelPropertiesToPage(*pVTextLabel, FALSE, gp);//gvcHolder.SaveTextLabelPropertiesToPage(*pVTextLabel);	///Jasmine 06/21/2012 ORG-4971-P7 LINK_GRAPH_LABELS_ARE_MIXED

						//MY_DBG_OUTPUT3("Updating TextLabel %s  (%g, %g)", pVTextLabel->GetRangeString(), dXScale, vY[ii]);
					}
					else
					{
						VTextLabel& vTextLabel = arrTextLabels.GetAt(nUpdateLabelCountPerLayer);
						vTextLabel.GetValidObj().AttachToPlot(dp);
					#ifdef REMOVE_LABEL_FEATURE
						vTextLabel.GetValidObj().Show = FALSE;
					#else
						///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
						//vTextLabel.GetValidObj().Show = gvcHolder.m_Settings.bShowTextLabels && !(nUpdateLabelCount <  m_Setting.m_cursorshow.vnPlotShow.GetSize() && m_Setting.m_cursorshow.vnPlotShow[nUpdateLabelCount] == 0);
						bool bShow = false;
						if(gvcHolder.m_Settings.bShowTextLabels)
						{
							if(nUpdateLabelCount >= nPlotShowCount)
								bShow = true;
							///Jasmine 08/30/2012 ORG-6634-P1 PLOTS_ORDER_SHOULD_NOT_SAVE_INI_FOR_OTHER_GRAPHS_TO_LOAD
							else if(nPlotIDCount <= 0)
								bShow = true;
							///End PLOTS_ORDER_SHOULD_NOT_SAVE_INI_FOR_OTHER_GRAPHS_TO_LOAD
							else
							{								
								int nFind = m_Setting.m_cursorshow.vsPlotIDs.Find( (string)vTextLabel.GetAttachedPlotUID() );
								if(-1 < nFind && nFind < nPlotShowCount)
									bShow = m_Setting.m_cursorshow.vnPlotShow[nFind];
							}
						}
						vTextLabel.Show = bShow;
						///End ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
					#endif					
						///------ Folger 08/14/2012 ORG-6381-S1 DATAPLOT_GETDATAPOINT_SUPPORT_NO_Y_OFFSET
						//vTextLabel.GetValidObj().MarkTo(dXScale, vY[ii]);
						vTextLabel.GetValidObj().MarkTo(dXScale, vYWithOffset[ii], &vY[ii]);
						///------ End DATAPLOT_GETDATAPOINT_SUPPORT_NO_Y_OFFSET
						
						gvcHolder.SaveTextLabelPropertiesToPage(vTextLabel, FALSE, gp);//gvcHolder.SaveTextLabelPropertiesToPage(vTextLabel);	///Jasmine 06/21/2012 ORG-4971-P7 LINK_GRAPH_LABELS_ARE_MIXED

						//MY_DBG_OUTPUT3("Updating TextLabel %s  (%g, %g)", vTextLabel.GetValidObj().GetRangeString(), dXScale, vY[ii]);
					}
					int nYFormat, nXFormat, nYDisp;
					string strYCustom;
					///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
					_get_axis_label_format(dp, nYFormat, nYDisp, strYCustom, false);//_get_src_col_format
					_get_axis_label_format(dp, nXFormat, nYDisp, strYCustom, true);//_get_src_col_format
					///End LABEL_FOLLOW_AXIS_FORMAT
					VTextLabel& vTextLabel = arrTextLabels.GetAt(nUpdateLabelCountPerLayer);
					///Jasmine 07/20/2011 ORG-3106-S4-1 FIX_DIGIT_SETTING_NOT_APPLY_TO_LABEL					
					//pVTextLabel->GetValidObj().SetTextFormat(m_Setting.m_labelSetting.strLTCustomTextType);
					string strText = makeCustomText(m_Setting.m_labelSetting.nSignificantDigits, m_Setting.m_labelSetting.nTextType, m_Setting.m_labelSetting.strLTCustomTextType, nXFormat, nYFormat, m_Setting.m_cursorshow.strXDisp, m_Setting.m_cursorshow.strYDisp, m_Setting.m_tagSetting.nXFormat, m_Setting.m_tagSetting.nYFormat);
					m_Setting.m_labelSetting.strLTCustomTextType = strText;
					///------ Folger 08/10/2012 ORG-6381-S3 VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
					if( LTT_NONE == m_Setting.m_labelSetting.nTextType )
						vTextLabel.Show = false;
					///------ End VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
					vTextLabel.GetValidObj().SetTextFormat(strText);
					///End FIX_DIGIT_SETTING_NOT_APPLY_TO_LABEL
					
					if(bHideTextLabels) vTextLabel.GetValidObj().Show = FALSE;				///Jasmine 03/22/2012 ORG-4971 DUMP_TAG_AND_LABEL_TO_LINKED_GRAPHS

					++nUpdateLabelCount;
					++nUpdateLabelCountPerLayer;
				}

				{///Jasmine 01/15/10 REORDER_CURSOR_VALUE_BY_LAYER_POS	
					VIntersectPoint* pti = new VIntersectPoint;
					
					pti->fpPoint.x = dXScale;
					pti->fpPoint.y = vY[ii];
					///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE	
					
					///Jasmine 01/20/10 SHOW_NEAREST_POINT
					int nIndex = vnIndex[ii];
					double xx = pti->fpPoint.x, yy = pti->fpPoint.y;
					if(nIndex == -1)
						xx = yy = NANUM;
					else if( vbIsInterpolated[ii] )
						///------ Folger 08/14/2012 ORG-6381-S1 DATAPLOT_GETDATAPOINT_SUPPORT_NO_Y_OFFSET
						//dp.GetDataPoint(nIndex, &xx, &yy);
						dp.GetDataPoint(nIndex, &xx, &yy, NULL, NULL, GETDATAPTS_NO_OFFSET);
						///------ End DATAPLOT_GETDATAPOINT_SUPPORT_NO_Y_OFFSET
					pti->fpNearPoint.x = xx;
					pti->fpNearPoint.y = yy;
							
					nIndex++;//offset
					pti->index = nIndex;
					///End SHOW_NEAREST_POINT
					pti->plotuid = dp.GetUID(TRUE);
					///End MORE_CONFIGURATION_FOR_INFO_TABLE
					
					///Jasmine 01/15/10 REORDER_CURSOR_VALUE_BY_LAYER_POS
					pti->layerYPos = layPosY;	
					pti->layer = gl.GetIndex();
					pti->plot = dp.GetIndex();
					///End REORDER_CURSOR_VALUE_BY_LAYER_POS
					
					pti->xinfo.plotuid = uidplotx;///Jasmine 01/26/10 OUTPUT_X_COLUMN_NEED_MORE_INFO
					///Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT
					pti->xinfo.format = nFormat;	
					pti->xinfo.display = nDisplay;	
					pti->xinfo.custom = strCustom;	
					///End SHOW_XVALUE_WITH_FORMAT
										
					//pti.strPlotName = dp.GetName();
					if(bUpdateNotation)
					{
						///Jasmine 01/18/10 SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME
						pti->plotinfo.book 			= strBook;
						pti->plotinfo.sheet 		= strSheet;
						pti->plotinfo.colname 		= strCol;
						pti->plotinfo.collongname 	= strLongname;
						pti->plotinfo.graph 		= strGraph;				///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
						///End SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME
						
						///Jasmine 01/26/10 OUTPUT_X_COLUMN_NEED_MORE_INFO
						pti->xinfo.plotinfo.book 		= strXBook;
						pti->xinfo.plotinfo.sheet 		= strXSheet;
						pti->xinfo.plotinfo.colname 	= strXCol;
						pti->xinfo.plotinfo.collongname	= strXLongname;
						pti->xinfo.plotinfo.graph 		= strXGraph;				///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
						///End OUTPUT_X_COLUMN_NEED_MORE_INFO
					}

					///------ Folger 08/03/2012 ORG-6409-S1 VERTICAL_CURSOR_USAGE_IMPROVEMENT
					pti->bActive = bActiveLayer && pti->plot == nActivePlot;
					///------ End VERTICAL_CURSOR_USAGE_IMPROVEMENT
					
					m_arrPoints.Add(*pti);					
				}///End REORDER_CURSOR_VALUE_BY_LAYER_POS
			}
		}

		if ( bUpdateTextLabels )
		{
			// We just simply hide the extra VTextLabels here to avoid frequently creating and/or destroying them.
			for ( int nn = nUpdateLabelCountPerLayer; nn<arrTextLabels.GetSize(); ++nn )
			{
				///Sophy 9/20/2011 ORG-3843-P2 PROPER_CHECK_LABEL_INDEX_WHEN_SHOWHIDE
				//VTextLabel& vTextLabel = arrTextLabels.GetAt(nUpdateLabelCount);
				//vTextLabel.GetValidObj().Show = FALSE;
				VTextLabel& vTextLabel = arrTextLabels.GetAt(nn);
				if ( vTextLabel.IsValid() )
					vTextLabel.GetValidObj().Show = FALSE;
				///end PROPER_CHECK_LABEL_INDEX_WHEN_SHOWHIDE
			}
		}
	}
	
	return true;
}
///End RETRIEVE_CURSOR_VALUE_FROM_LINKED_GRAPHS

///Sophy 10/13/2011 ORG-3106-S16 UPDATE_GRAPH_FILTER_ON_EACH_MOVEMENT
bool	GraphVerticalCursorManager::updateGraphFilter(GraphVerticalCursorHolder& gvcHolder)
{
	double dPagePos = gvcHolder.m_line.GetPagePosition();
	GraphLayer glParent;
	gvcHolder.GetXBasedLayer(glParent);//gvcHolder.m_line.GetParent(glParent);	///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
	gvcHolder.m_Settings.vnLayerIndex.SetSize(0);
	gvcHolder.m_Settings.vnLayerIndex.Add(glParent.GetIndex());
	GraphPage gp = glParent.GetPage();
	foreach(GraphLayer gl in gp.Layers)
	{
		if ( gl.GetIndex() == glParent.GetIndex() )
			continue; //already added.
		
		double dDim[DIM_ELEM_COUNT];
		gl.GetPosition(dDim);
		gl.UnitsConvert(M_PIXEL, dDim);
		double dLeft = dDim[LEFT_POS];
		double dRight = dDim[DIM_WIDTH] + dLeft;
		if ( dPagePos > dLeft && dPagePos < dRight )
		{
			gvcHolder.m_Settings.vnLayerIndex.Add(gl.GetIndex());
		}
	}
	///------ Folger 08/31/2012 ORG-6681-P1 GLOBAL_GADGET_MANAGER_SERIALIZATION
	gvcHolder.SaveHolderSettingsToPage();
	///------ End GLOBAL_GADGET_MANAGER_SERIALIZATION
	return true;
}

///Jasmine 05/03/2012 ORG-4971-P1 LINK_GRAPHS_SHOULD_HAVE_ITS_OWN_LAYER_FILTER
bool	GraphVerticalCursorManager::updateGraphFilter(double dPagePos, const GraphPage& gp, vector<int>& vnLayerIndex)
{
	vnLayerIndex.SetSize(0);
	foreach(GraphLayer gl in gp.Layers)
	{
		double dDim[DIM_ELEM_COUNT];
		gl.GetPosition(dDim);
		gl.UnitsConvert(M_PIXEL, dDim);
		double dLeft = dDim[LEFT_POS];
		double dRight = dDim[DIM_WIDTH] + dLeft;
		if ( dPagePos > dLeft && dPagePos < dRight )
		{
			vnLayerIndex.Add(gl.GetIndex());
		}
	}
	return vnLayerIndex.GetSize() > 0;
}
///End LINK_GRAPHS_SHOULD_HAVE_ITS_OWN_LAYER_FILTER

bool	GraphVerticalCursorManager::hideAttachedLabels(GraphLayer& gl)
{
	if ( !gl )
		return false;
	
	VGraphLayer	vgl(gl);
	Array<VTextLabel&>&		arrTextLabels	= vgl.AccessTextLabels();
	vector<int>	vnLabelPlotUIDs(arrTextLabels.GetSize());
	for ( int ii = 0; ii < vnLabelPlotUIDs.GetSize(); ii++ )
	{
		VTextLabel& label = arrTextLabels.GetAt(ii);
		vnLabelPlotUIDs[ii] = label.GetAttachedPlotUID();
	}
	foreach (DataPlot dp in gl.DataPlots)
	{
		int nPlotID = dp.GetUID(true);
		int nIndex = find_in_list(nPlotID, vnLabelPlotUIDs, false);
		if ( nIndex >= 0 )
		{
			VTextLabel& label = arrTextLabels.GetAt(nIndex);
			label.Show = FALSE;
		}
	}

	return true;
}
///end UPDATE_GRAPH_FILTER_ON_EACH_MOVEMENT

///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
void	GraphVerticalCursorManager::ToggleLineLength(BOOL bVertical)
{
	CHECK_GET_CURRENT_CURSOR_HOLDER_BEGIN
	{
		Tree trFmt;
		trFmt = gvcCurrentHolder.m_line.GetFormat(FPB_DATA, FOB_ALL, true, true);
		
		vector vx, vy;
		vx = trFmt.Root.Data.X.dVals;
		vy = trFmt.Root.Data.Y.dVals;

		if ( bVertical )
		{
			double y1, y2;
			
			if ( m_Setting.IsLineLengthSpanLayers() )
			{
				gvcCurrentHolder.m_line.GetFullPageLinePosition(vy[0], vy[1]);
			}
			else
			{
				CalcLineY1Y2AcrossAllLayers(vy[0], vy[1]);
			}

			trFmt.Root.Data.Y.dVals = vy;
		}
		else
		{
			/// to do
			if ( m_Setting.IsLineLengthSpanLayers() )
			{

			}
			else
			{
				
			}
		}

		///------ Folger 09/10/2012 ORG-6763-S1 VECTICAL_CURSOR_SPAN_ALL_LAYERS_SUPPORT
		trFmt.Root.Span.nVal = m_Setting.IsLineLengthSpanLayers() ? GROBJSTRETCH_NONE : GROBJSTRETCH_ALL_LAYERS;
		gvcCurrentHolder.m_line.UpdateThemeIDs(trFmt.Root);
		///------ End VECTICAL_CURSOR_SPAN_ALL_LAYERS_SUPPORT
		gvcCurrentHolder.m_line.ApplyFormat(trFmt, TRUE, TRUE);
		gvcCurrentHolder.m_line.RepositionHandles(bVertical, vx[0], vx[1], vy[0], vy[1]);
	}
	CHECK_GET_CURRENT_CURSOR_HOLDER_END
}
///------ End VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS

/*----------------------------------------------------------------------------*/
/* Interface to get instance of GraphVerticalCursorManager
/*----------------------------------------------------------------------------*/

GraphVerticalCursorManager& get_graph_vertical_cursor_manager()
{
	static GraphVerticalCursorManager s_Manager;
	return s_Manager;
}

#endif // __VERTICAL_CURSOR_MANAGER_H__
