/*------------------------------------------------------------------------------*
 * File Name: TreeEditEvents.h													*
 * Creation: CPY 5/2/2004														*
 * Purpose: Common intermeidate class for GetN based dialog						*
 * Copyright (c) OriginLab Corp.	2004										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	YuI 7/23/04 v7.5103 QA70-6582 GETN_MULTILINE_TEXT_IMPLEMENTATION			*
 *	AW 03/17/05 v8.0206 CLEANING_CODES_IN_FO									*
 *  DG 3/25/05 v8.0211 INIT_ONE_TIME											*
 *  DG 3/30/05 v8.0211 VALIDATE_KILL_FOCUS										*
 *  Frank 3/30/05	TREE_EDIT_SUPPORT_MOVE_ROWS									*
 *	Hong 16/09/10 ORG-35 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID			*
 *------------------------------------------------------------------------------*/
#ifndef _TREE_EDIT_EVENTS_H
#define _TREE_EDIT_EVENTS_H
// This file provide a common class between a user class and a base dialog or splitter class
// BASE_WINDOW can be any class that is derived from one of the following and must be defined before including this header file
// 1. Splitter
// 2. Dialog
// 3. PropertyPage
//
// Please note that the derived class can support only one TreeEditControl 
class TreeEditDlg : public BASE_WINDOW
{
public:
	TreeEditDlg(UINT nDlgID, LPCSTR lpcszDLL) :  BASE_WINDOW(nDlgID, lpcszDLL)
	{
	}

protected:
///////////////////////////////////////////
	BOOL OnSetFocus(Control cntrl)
	{
		return m_treeEditCntrl.OnSetFocus();
	}
	void OnBeforeEdit(Control cntrl, long nRow, long nCol, BOOL* pCancel)
	{		
		m_treeEditCntrl.OnBeforeEdit(nRow, nCol, pCancel);
	}
	void OnValidateEdit(Control cntrl, int nRow, int nCol, BOOL* pCancel)
	{
		m_treeEditCntrl.OnValidateEdit(nRow, nCol, pCancel);
	}
	void OnAfterEdit(Control flxControl, int nRow, int nCol)
	{
		m_treeEditCntrl.OnAfterEdit(nRow, nCol);
	}
	void OnButtonClick(Control cntrl, int nRow, int nCol)
	{
		m_treeEditCntrl.OnButtonClick(nRow, nCol);
	}
	void OnRowColChange(Control cntrl)
	{
		m_treeEditCntrl.OnRowColChange();
	}	
	void OnDrawCell(Control cntrl, OUIP hDC, int nRow, int nCol, int nLeft, int nTop, int nRight, int nBottom, BOOL* pDone)
	{
		m_treeEditCntrl.OnDrawCell(hDC, nRow, nCol, nLeft, nTop, nRight, nBottom, pDone);
	}
	void OnCellChange(Control cntrl, int nRow, int nCol)
	{
		;
	}
	void OnChangeEdit(Control cntrl)
	{
		;
	}
	void OnComboCloseUp(Control cntrl, int nRow, int nCol, BOOL* pFinishEdit)
	{
		m_treeEditCntrl.OnComboCloseUp(nRow, nCol, pFinishEdit);
		/// YuI 7/23/04 v7.5103 QA70-6582 GETN_MULTILINE_TEXT_IMPLEMENTATION
		// combo closeup should destroy combo
		/// Hong 16/09/10 ORG-35 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
#ifdef		__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
		TreeGridControl		gridCntrl(cntrl);
		ASSERT(gridCntrl);
		wxGirdInterface objGrid;
		objGrid = gridCntrl.GetGridCtrlInterface();
#else		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
		/// end REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
		Object objGrid = cntrl.GetActiveXControl();
#endif		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__ /// Hong 16/09/10 ORG-35 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
		objGrid.FinishEditing(FALSE);
		/// end GETN_MULTILINE_TEXT_IMPLEMENTATION
	}
	void OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
	{
		m_treeEditCntrl.OnBeforeMouseDown(nButton, nShift, X, Y, pCancel);
	}
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{
		return m_treeEditCntrl.OnShowMenu(nResIDCtrl, nx, ny);
	}
	BOOL OnEditorKillFocus(uint wParam, uint lParam)
	{
		//return m_treeEditCntrl.OnEditorKillFocus(wParam, lParam);	///DG VALIDATE_KILL_FOCUS
		return m_treeEditCntrl.OnKillFocus(wParam, lParam);
	}
	BOOL OnReconstructGrid(uint wParam, uint lParam)
	{
		if(m_treeEditCntrl.OnReconstructGrid(wParam, lParam))
			ResizeDlgToFit();

		return TRUE;
	}
///////////////////////////////////////////
	virtual BOOL OnDestroy(void)
	{
		m_treeEditCntrl.OnDestroy();
		BASE_WINDOW::OnDestroy();
		return true;
	}
	virtual void ResizeDlgToFit() {}
	
	/// AW 03/17/05 v8.0206 CLEANING_CODES_IN_FO 
	virtual int GetTreeEditPaneID() { ASSERT(FALSE); return -1; } // must overload in derived class
	virtual void ConstructWithoutTree()
	{
		GETN_TREE(trTemp)
		GETN_STR(empty, "", "") GETN_READ_ONLY
		m_paramTree=trTemp;
		//m_treeEditCntrl.Init(GetTreeEditPaneID(), false, true, NULL, *this);	///DG INIT_ONE_TIME
		m_treeEditCntrl.Update(m_paramTree, true, true);
	}
	virtual bool IsCurrentEmptyTree()
	{
		TreeNode tr = m_treeEditCntrl.GetTreeNode(0);
		if(tr.IsValid() && tr.tagName == "empty" && tr.Enable != true && tr.GetNodeCount() == 0)
			return true;
		return false;
	}
	/// END CLEANING_CODES_IN_FO
	
	///Frank 3/30/05	TREE_EDIT_SUPPORT_MOVE_ROWS
	void OnAfterMoveRows(Control ctrl, long nRow, long *nPosition)
	{
		m_treeEditCntrl.OnAfterMoveRows(nRow, nPosition);
	}
	void OnBeforeMoveRows(Control ctrl, long nRow, long *nPosition)
	{
		m_treeEditCntrl.OnBeforeMoveRows(nRow,nPosition );
	}	
	///End	TREE_EDIT_SUPPORT_MOVE_ROWS

protected:
	Tree				m_paramTree;
	TreeEditControl		m_treeEditCntrl;
};

#ifndef ON_GETNDLG_MSGS

// must add this to your dialog class's message map, 
#define ON_GETNDLG_MSGS(_ID) \
	ON_GRID_BEFORE_EDIT(_ID, OnBeforeEdit)	\
	ON_GRID_VALIDATE_EDIT(_ID, OnValidateEdit)	\
	ON_GRID_AFTER_EDIT(_ID, OnAfterEdit)	\
	ON_GRID_ROW_COL_CHANGE(_ID, OnRowColChange)	\
	ON_GRID_COMBO_CLOSEUP(_ID, OnComboCloseUp)	\
	ON_GRID_BEFORE_MOUSE_DOWN(_ID, OnBeforeMouseDown)	\
	ON_GRID_BUTTON_CLICK(_ID, OnButtonClick) \
	ON_GRID_DRAW_CELL(_ID, OnDrawCell) \
	ON_GRID_CELL_CHANGE(_ID, OnCellChange) \
	ON_GRID_CHANGE_EDIT(_ID, OnChangeEdit) \
	ON_EVENT(EN_SETFOCUS, _ID, OnSetFocus) \
	ON_USER_MSG(WM_USER_ON_CHILD_KILL_FOCUS, OnEditorKillFocus) \
	ON_USER_MSG(WM_USER_RECONSTRUCT, OnReconstructGrid) \
	
	ON_GRID_BEFORE_MOVE_ROWS(_ID, OnBeforeMoveRows)	\
	ON_GRID_AFTER_MOVE_ROWS(_ID, OnAfterMoveRows)	\
	
	ON_CONTEXTMENU(OnShowMenu) 
#endif //ON_GETNDLG_MSGS


////////////////////////////////////////////////////////////////////////////////////
BOOL	DoDataRangeDlg(TreeEditControl& trEditControl, Window* pOwner, BOOL bModalParent = TRUE);
///END GETNBOX_SAME_AS_GETNVIEWBOX

#endif //_TREE_EDIT_EVENTS_H

