/*------------------------------------------------------------------------------*
 * File Name: FilePublish.c	 													*
 * Creation: Bill 11/08/2011													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX	*
 *	Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT			*
 *	Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES							*
 *	Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON					*
 *	Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER		*
 *	Tony 08/01/2012 ORG-2840-S5 HIDE_NOT_NEWER_STATUS_FILES_ROWS				*
 *	Tony 08/01/2012 ORG-6330-S5 GRAY_FIELS_AFTER_TANSFER						*
 *	Tony 08/02/2012 ORG-6330-S3 ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT			*
 *	Tony 08/07/2012 ORG-6325-P1 UPDATE_ISPUBLISHED_VERSION_OF_UPDATEINI_FILE	*
 *	Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION	*
 *	Tony 08/20/2012 ORG-6330-S3 EXPORT_FILES_SHOULD_NOT_INCLUDE_PREVIEW_FILES	*
 *	Tony 08/22/2012 ORG-6325-S1 PANEL_SHOULD_SHOW_GROUP_FOLDER_HINT			*
 *	Tony 08/23/2012 ORG-6330-S9 CHANGE_TEXT_CONTROL_TO_EDIT_CONTROL_SUPPORT_TOOLTIP	*
 *	Tony 09/18/2012 ORG-6862-P1 SUPPORT_PATCH_EXE_TRANSFER						*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "DialogEx.h"
#include "GridTableControl.h"

enum TransferFileType
{
	CHECK_PROJECT	= 0x0001,
	CHECK_THEME		= 0x0002,
	CHECK_CODE		= 0x0004,
	CHECK_SETTINGS	= 0x0008,
	CHECK_FITTING	= 0x0010,
	CHECK_OTHER		= 0x0020,
	CHECK_TYPE_MASK	= 0x00FF,
	CHECK_ALLOW_EXPORT_OPX		= 0x0100,
	CHECK_SHOW_UFF_FILES		= 0x0200,
	CHECK_HIDE_TRANSFERRED_FILES	= 0x0400,		///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES	
	CHECK_SHOW_NEWER_FILES_ONLY	= 0x0800,		///------ Tony 08/01/2012 ORG-2840-S5 HIDE_NOT_NEWER_STATUS_FILES_ROWS
	CHECK_PATCH		= 0x1000,						///------ Tony 09/18/2012 ORG-6862-P1 SUPPORT_PATCH_EXE_TRANSFER
};

struct FilePublishMapItem
{
	string strRegKey;
	FilePublishBase * pFilePublish;
};

class TransferHelper
{
public:
	TransferHelper();
	~TransferHelper();
	
	
	bool GetFileInfo(DWORD dwFileType, LPCSTR lpcszRegKey, LPCSTR lpcszSpecPath, vector<string> & vsFiles, vector<string> & vsInfo, bool bSource = true);
	///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	//void GetCurrentFileStatus(vector<string> & vsRegKey, LPCSTR lpcszSpecPath, vector<string> & vsFilesPath, vector<int> & vnStatus);
	void GetCurrentFileStatus(vector<string> & vsRegKey, LPCSTR lpcszSpecPath, vector<string> & vsSourceFilesPath, vector<string> & vsCurrentFilesPath, vector<int> & vnStatus);
	///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	void GetDestPath(string &strDestPath);
	
	///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
	//int TransferFiles(vector<string> & vsRegKey, LPCSTR lpcszSpecPath, vector<string> & vsFiles);
	int TransferFiles(vector<string> & vsRegKey, LPCSTR lpcszSpecPath, vector<string> & vsFiles, bool bSource = true, vector<string> & vsTransferredFiles = NULL, vector<string> & vsvsTransferredRegKey = NULL);
	///------ End SHOW_TRANSFERRED_FILES
	int ExportFiles(vector<string> & vsRegKey, LPCSTR lpcszSpecPath, vector<string> & vsFilePath, LPCSTR lpcszOpxFileName);
	void GetFileFullPath(string& strFile1, string& strFile2, LPCSTR lpcszKey, LPCSTR lpcszSpecPath);
	void SetGroupManager(bool bIsGroupManager){ m_bGroupManager = bIsGroupManager; }
	void SetRecursive(int nIsRecursive){ m_nRecursive = nIsRecursive; }			///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
private:
	void convertFileType(DWORD dwFileType, vector<int> & vnFileType);
	
	///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	//FilePublishBase * getFilePublish(LPCSTR lpcszRegKey, LPCSTR lpcszSpecPath);
	FilePublishBase * getFilePublish(LPCSTR lpcszRegKey, LPCSTR lpcszSpecPath, int nRecursive = 0);
	///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION

	Array<FilePublishMapItem&> m_FilePublishMap;
	FilePublishBase * m_pSpecFliePublish;
	string	m_strSpecPath;
	bool	m_bGroupManager;
	int		m_nRecursive;		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
};

class SourceListControl : public GridTableControl
{
public:
	void Init(int nID, WndContainer &dlg);
	void ShowMenu(int nx, int ny);
	void GetFilePathList(vector<string> & vsSourcePathList, vector<string> & vsCurrentPathList, bool bIncludePreviewRows = true);		///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
	void DeleteSelectedFiles();		///------ Tony 08/02/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	void SetTransferHelper(TransferHelper* pTransferHelper, LPCSTR lpcszKey, LPCSTR lpcszSpec)
	{
		m_pTransferHelper = pTransferHelper;
		m_strKey = lpcszKey;
		m_strSpecPath = lpcszSpec;
	}
private:
	TransferHelper*	m_pTransferHelper;
	string			m_strKey;
	string			m_strSpecPath;
};

class SelectedListControl : public GridTableControl
{
public:
	///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	//void Init(int nID, WndContainer &dlg);
	void Init(int nID, WndContainer &dlg, bool bGroupManager = false);
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	
	void GetFileList(vector<string> & vsFiles);
	void GetCategoryList(vector<string> & vsCategory);
	///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	//void ShowMenu(int nx, int ny);
	void GetFilePathList(vector<string> & vsPathList, bool bIncludePreviewRows = true);
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	void GetRegKey(vector<string> & vsRegKey, bool bIncludePreviewRows = true);
	void GetFileStatus(vector<int> & vnStatus);
	void ShowMenu(int nx, int ny, bool bGroupManager = false);
	void DeleteSelectedFiles();
	void SetTransferHelper(TransferHelper* pTransferHelper, LPCSTR lpcszKey, LPCSTR lpcszSpecPath)
	{
		m_pTransferHelper = pTransferHelper;
		m_strKey = lpcszKey;
		m_strSpecPath = lpcszSpecPath;
	}
	
private:
	TransferHelper*	m_pTransferHelper;
	string			m_strKey;
	string			m_strSpecPath;
};

class TransferFilesDlg : public ResizeDialog
{
public:
	
	TransferFilesDlg(bool bGroupMgr = false);

	~TransferFilesDlg();

	int DoModalEx(HWND hWndParent = NULL);
	
private:
	EVENTS_BEGIN
		ON_INIT(OnInitDialog) 
		ON_SIZE(OnDlgResize)
		ON_DESTROY(OnDestroy)
		
		ON_BN_CLICKED(IDC_CHECK_PROJECT, OnViewCheckChange)
		ON_BN_CLICKED(IDC_CHECK_THEME, OnViewCheckChange)
		ON_BN_CLICKED(IDC_CHECK_CODE, OnViewCheckChange)
		ON_BN_CLICKED(IDC_CHECK_SETTINGS, OnViewCheckChange)
		ON_BN_CLICKED(IDC_CHECK_FITTING, OnViewCheckChange)
		ON_BN_CLICKED(IDC_CHECK_PATCH, OnViewCheckChange)		///------ Tony 09/18/2012 ORG-6862-P1 SUPPORT_PATCH_EXE_TRANSFER
		ON_BN_CLICKED(IDC_CHECK_OTHER, OnViewCheckChange)		///----- Tony 08/01/2012	 When Other check box is checked, active OnViewCheckChange
		ON_BN_CLICKED(IDC_CHECK_RECURSIVE_SPECIFIED_FOLDER, OnRecursiveCheckChange)		///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
		ON_BN_CLICKED(IDC_CHECK_SHOW_NEWER_FILES_ONLY, OnRecursiveCheckChange)			///------ Tony 08/01/2012 ORG-2840-S5 HIDE_NOT_NEWER_STATUS_FILES_ROWS
		
		ON_CBN_SELCHANGE(IDC_COMBO_LOCALTION, OnLocationChange)
		ON_GRID_SEL_CHANGE(IDC_SELECTED_FILE_LIST, OnSelectedListSelectionChange)		///------ Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON
		ON_GRID_SEL_CHANGE(IDC_SOURCE_LIST, OnSourceListSelectionChange)		///------ Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON
		
		ON_BN_CLICKED(IDC_BROWSER, OnBrowser)
		///Sophy 3/8/2012 ORG-2840-P1 NEW_TRANSFER_USER_FILES_DLG_GUI
		ON_BN_CLICKED(IDC_CHECK_ALLOW_EXPORT_OPX, OnAllowExportOPX)
		ON_BN_CLICKED(IDC_CHECK_HIDE_TRANSFERRED_FILES, OnHideTransferredFiles)		///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
		ON_BN_CLICKED(IDC_CHECK_SHOW_USER_FILES, OnShowFilesInUFF)
		ON_BN_CLICKED(IDC_REMOVE, OnRemove);		///------ Tony 08/02/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
		ON_BN_CLICKED(IDC_DELETE, OnDelete);
		///end NEW_TRANSFER_USER_FILES_DLG_GUI
		ON_BN_CLICKED(IDC_TRANSFER, OnTransfer);
		ON_BN_CLICKED(IDC_EXPORT, OnExport);
		
		ON_BN_CLICKED(IDC_RIGHT, OnAddFileToSelectedList);
		ON_BN_CLICKED(IDC_LEFT, OnRemoveFileToSelectedList);
		
		ON_GRID_DBLCLICK(IDC_SOURCE_LIST, OnAddFileToSelectedList);
		
		ON_GRID_DBLCLICK(IDC_SELECTED_FILE_LIST, OnRemoveFileToSelectedList);
		
		ON_CONTEXTMENU(OnContextMenu);
		ON_HELPINFO(OnHelp);
		
		ON_GETMINMAXINFO(OnMinMaxInfo)		///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
	EVENTS_END
	
	BOOL OnInitDialog();
	BOOL OnDlgResize(int nType, int cx, int cy);
	BOOL OnDestroy();
	
	BOOL OnLocationChange(Control ctrl);
	BOOL OnViewCheckChange(Control ctrl);
	BOOL OnRecursiveCheckChange(Control ctrl);			///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	BOOL OnSelectedListSelectionChange(Control ctrl);		///------ Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON
	BOOL OnSourceListSelectionChange(Control ctrl);
	
	BOOL OnBrowser(Control ctrl);
	
	BOOL OnTransfer(Control ctrl);
	BOOL OnExport(Control ctrl);
	///Sophy 3/8/2012 ORG-2840-P1 NEW_TRANSFER_USER_FILES_DLG_GUI
	BOOL OnRemove(Control ctrl);		///------ Tony 08/02/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	BOOL OnDelete(Control ctrl);
	BOOL OnAllowExportOPX(Control ctrl);
	BOOL OnHideTransferredFiles(Control ctrl);		///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
	BOOL OnShowFilesInUFF(Control ctrl);
	//end NEW_TRANSFER_USER_FILES_DLG_GUI
	BOOL OnAddFileToSelectedList(Control ctrl);
	BOOL OnRemoveFileToSelectedList(Control ctrl);
	BOOL OnContextMenu(UINT nResIDCtrl, int nx, int ny);
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus);

	void OnMinMaxInfo(MINMAXINFO* lpMMI);		///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
private:	
	void initLocationList();
	void enableLocation();			///------ Tony 07/30/2012 ORG-6383-P1 DISABLE_DROPDOWNLIST_WHEN_CLICK_TRANSFER
	///------ Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	//void enableBrowserButton();
	///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
	//void enableBrowserButton(int nCurSel);
	void enableBrowserHideRecursive(int nCurSel);
	///------ End ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
	//void enableBrowserButton();
	///------ End FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	void disableDeleteButton();		///------ Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON
	void disableLeftRightButton(bool bSourceList);			///------ Tony 08/06/2012
	void initAddRemoveButton();
	
	///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
	void initHintCtrl();
	void initColorHint();
	void setHintColor(uint uResourceID, uint uColor, LPCTSTR lpcszHint);
	void initListColor();	
	///------ End ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT

	void initTransferredList();		///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
	
	void initCustomButton();			///------ Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON
	
	void initGroupFolderPath();		///------ Tony 08/22/2012 ORG-6325-S1 PANEL_SHOULD_SHOW_GROUP_FOLDER_HINT

	DWORD getFileType();
	void setFileTypeCheckBox(DWORD dwFileType);
	
	bool getEllipsisText(int nWidth, string &strText);		///------ Tony 08/23/2012 ORG-6330-S9 CHANGE_TEXT_CONTROL_TO_EDIT_CONTROL_SUPPORT_TOOLTIP
	
	int getCurrentSel();		///------ Tony 08/23/2012 ORG-6330-S9 CHANGE_TEXT_CONTROL_TO_EDIT_CONTROL_SUPPORT_TOOLTIP
	
	void updateRecursive();		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	
	void updateSourceFileList();
	void updateSpecifiedListStatus(GridTableControl &gtControlList, bool bGroupFolderList = false);			///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
	void updateListStatus();
	void updateGroupFolderList();		///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
	void updateStatusColor(GridTableControl &gtControl, int nRow, int nOffset, int nStatus, bool bGroupFolderList = false);
	///------ End ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
	void clearSelectedFileList();		///------ Tony 08/20/2012 ORG-6330-S3 EXPORT_FILES_SHOULD_NOT_INCLUDE_PREVIEW_FILES
	void updateINIFile();		///------ Tony 08/07/2012 ORG-6325-P1 UPDATE_ISPUBLISHED_VERSION_OF_UPDATEINI_FILE
	bool CopyClientUpdateEXE();		///------ Tony 08/07/2012 ORG-6325-P1 UPDATE_ISPUBLISHED_VERSION_OF_UPDATEINI_FILE
	
	void showNewerFilesOnly(GridTableControl &gtControl, vector<int> vnStatus);		///------ Tony 08/01/2012 ORG-2840-S5 HIDE_NOT_NEWER_STATUS_FILES_ROWS
	
	void hideTransferredFiles(LPCSTR lpcszRegKey, vector<string> & vsFiles);		///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
	
	void addFileToList();
	void removeFileFromList();
	void transferFileToList(bool bGroupFolder);		///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG

	void doTransferFiles();
	bool checkOlderFile(vector<string> & vsRegKey, vector<string> & vsFiles);
	bool checkRemoveOlder(vector<string>& vsFilesPath, vector<string>& RegKey, vector<int>& vnStatus);		///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG

	void exportFiles();
	bool checkExportOPX();		///------ Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	///Sophy 3/8/2012 ORG-2840-P1 NEW_TRANSFER_USER_FILES_DLG_GUI
	void allowExportUpdate();
	void updateOpxExportHint();		///------ Tony 08/02/2012 ORG-6330-S3 ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT
	void showUserFilesUpdate();
	///end NEW_TRANSFER_USER_FILES_DLG_GUI
	void saveSetting();
	void loadSetting();
private:
	vector<string> m_vsSourceKeys;
	TransferHelper m_helper;

	string m_strLastLocationKey;
	string m_strSpecifiedFolder;

private:
	SourceListControl m_SourceList;
	SelectedListControl m_SelectedList;
	
	ComboBox m_Location;
	
	BitmapRadioButton m_bnLeft;
	BitmapRadioButton m_bnRight;
	///Sophy 3/8/2012 ORG-2840-P1 NEW_TRANSFER_USER_FILES_DLG_GUI
	vector<string> m_vsSourceUFFPath;
	int		m_nCurrentLocationIndex;
	string	m_strDlgName;
	bool	m_bGroupManager;
	///end NEW_TRANSFER_USER_FILES_DLG_GUI		
	///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
	vector<string> m_vsTransferredFiles;
	vector<string> m_vsTransferredRegKey;
	///------ End SHOW_TRANSFERRED_FILES
};
	
