/*------------------------------------------------------------------------------*
 * File Name: ThemeGalleryListCtrl.h											*
 * Creation: Kit 10/18/2011														*
 * Purpose: Origin C support for a Theme Gallery List Control					*
 * Copyright (c) OriginLab Corp. 2011											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log																*
 *	Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY		*
 *------------------------------------------------------------------------------*/

#ifndef _THEMEGALLERYLISTCTRL_H
#define _THEMEGALLERYLISTCTRL_H

#include "DialogEx.h"
#include "GridControl.h"

///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
//enum {
//	GRID_COL_IS_SYSTEM,
//	GRID_COL_NAME,
//	//--- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
//	//GRID_COL_EDIT,
//	GRID_COL_SIZE,
//	//---
//	GRID_COL_PATH_TYPE,
//	GRID_COL_DATE,	//CPY 4/25/03 ADD_FILE_DATE
//	GRID_COL_TOTAL
//};
//
/////Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
//enum {
//	ANALYSIS_GRID_COL_IS_SYSTEM,
//	ANALYSIS_GRID_COL_MENU,
//	ANALYSIS_GRID_COL_NAME,
//	ANALYSIS_GRID_COL_FUNCTION,
//	ANALYSIS_GRID_COL_CATEGORY,
//	ANALYSIS_GRID_COL_SCOPE,
//	ANALYSIS_GRID_COL_SIZE,
//	ANALYSIS_GRID_COL_PATH_TYPE,
//	ANALYSIS_GRID_COL_DATE,
//	ANALYSIS_GRID_COL_TOTAL
//};
enum ThemeListColHeader
{
	LIST_COL_IS_SYSTEM = 0,
	LIST_COL_MENU,
	LIST_COL_NAME,
	LIST_COL_FUNCTION,
	LIST_COL_CATEGORY,
	LIST_COL_SCOPE,
	LIST_COL_SIZE,
	LIST_COL_PATH_TYPE,
	LIST_COL_DATE,
	LIST_COL_FILE_EXT,
	LIST_COL_TOTAL,
};
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

//enum {THEME_GRAPH_TAB, THEME_WORKSHEET_TAB};///Jasmine 02/15/06 ADD_TYPE_TAB 
enum ThemeTabType
{
	THEME_GRAPH_TAB = 0, 
	THEME_WORKSHEET_TAB, 
	THEME_DIALOG_TAB,
	THEME_FUNCTION_TAB,			///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
	
	THEME_TAB_TOTAL
};

enum PopupMenuSetting
{
	PMS_ShowToolTips		= 0x000000001,
	PMS_HasSystemTheme		= 0x000000002,
	PMS_InsideGrid			= 0x000000004,
	PMS_SystemTheme			= 0x000000008,
	PMS_MultiSel			= 0x000000010,
	PMS_CanBeSystemTheme	= 0x000000020,
};

enum ThemeGWListMenuCmd
{
	THEME_ADD, 
	THEME_SEPARATOR, 
	THEME_EDIT, THEME_DELETE, 
	THEME_SEPARATOR1,
	THEME_DUPLICATE, THEME_COMBINE, 
	THEME_SEPARATOR2, 
	THEME_SET_SYSTEM, THEME_CLEAR_SYSTEM,
	THEME_SEPARATOR3, 
	THEME_SHOW_TOOLTIPS,
	
	THEME_MENU_TOTAL,
};

enum ThemeDialogListCmd
{
	//ANALYSIS_THEME_EDIT, 
	ANALYSIS_THEME_DELETE, 
	ANALYSIS_THEME_SEPARATOR1,
	ANALYSIS_THEME_DUPLICATE,
	//ANALYSIS_THEME_COMBINE,
	ANALYSIS_THEME_SEPARATOR2,
	ANALYSIS_THEME_SHOW_TOOLTIPS,

	ANALYSIS_THEME_MENU_TOTAL,
};

enum MenuCmdMsg
{
	MCM_ERROR		= -1,
	MCM_ADD			= 0,
	MCM_EDIT,
	MCM_DELETE,
	MCM_DUPLICATE,
	MCM_COMBINE,
	MCM_SET_SYSTEM,
	MCM_CLEAR_SYSTEM,
	MCM_SHOW_TOOLTIPS,
};

/************************************************************************/
/*  ThemeListControlMenuBase
/************************************************************************/
class ThemeListControlMenuBase : public Menu
{
public:
	void OnMenuItem(UINT nPos){ m_nChoice = nPos; }
	virtual bool GetCommand(int& nChoice){ASSERT(false); return false;}

protected:
	int	m_nChoice;	
};

/************************************************************************/
/* ThemeGWListControlMenu
/************************************************************************/
class ThemeGWListControlMenu : public ThemeListControlMenuBase
{
public:
	ThemeGWListControlMenu(DWORD dwMenuBits);
	// virtual
	bool GetCommand(int& nChoice);
};

/************************************************************************/
/* ThemeAnalysisListControlMenu
/************************************************************************/
class ThemeDialogListControlMenu : public ThemeListControlMenuBase
{
public:
	ThemeDialogListControlMenu(DWORD dwMenuBits);
	bool GetCommand(int& nChoice);
};

/************************************************************************/
/* ThemeListControlBase
/************************************************************************/
///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
class ThemeListCtrlBase : public GridListControl
{
public:
	void			Init(int nID, Dialog& dlg);
	int				AddTheme(const string& str, int nType, bool bIsIncrementList);

	void			Reset();
	bool			OnAfterEdit(LPCTSTR lpcszOldNameBeforeEdit, int nRow, int nCol);

	bool			GetSelThemeFile(string &strSelFile);
	bool			GetSelThemeFiles(vector<string> &vsSelFiles);
	MenuCmdMsg		OnShowMenu(bool bShowTooltips, bool bHasSystemTheme, HWND hWndDlg, int nx, int ny);
	
	//bool			CheckSystemTheme(int nRowToCheck, string &strSysTheme);
public:
	//virtual int		GetThemeType(){ASSERT(false); return THTYPE_UNDEF;}
	virtual int		GetThemeTabType() { ASSERT(false); return -1; }
	virtual int		GetPageType() { return EXIST_NONE; }

	virtual int		GetHideCols(vector<bool> &vbHideCols){ ASSERT(false); return 0;}

	virtual string	GetThemeFileName(int nRow){ASSERT(false); return "";}

	virtual MenuCmdMsg PopupMenu(DWORD dwMenuBits, HWND hWndDlg, int nx, int ny){ASSERT(false); return false; }

	virtual string  GetColHeadingTooltips(int nCol){ ASSERT(false); return false; }
	virtual bool	GetTabShowPostion(bool &bShowRight, bool &bShowBottom){ ASSERT(false); return false; }
	virtual bool	GetCopyOfThemeFileName(LPCTSTR lpcszOldFileName, string &strCopyFileName){ ASSERT(false); return false; }
	
	virtual int		GetThemeFileType(LPCTSTR lpcszThemeFileWithExt){ ASSERT(false); return false; }
	virtual string  GetChangeDescription(){ ASSERT(false); return ""; }
	virtual bool	FindAllThemeFiles(TreeNode &trTheme){ ASSERT(false); return false; }
	///-----Kit 10/19/2011 : For speed, I sperate OnDelTheme() function to 3 function. 
	//						Because Dialog Theme delete files need to check every file extension to determine what theme type it is.
	virtual bool	OnDelTheme(const vector<string> &vsThemeFiles, vector<string> &vsClassOption){ASSERT(false); return false; }

protected:
	virtual bool	OnAfterEditRename(LPCTSTR lpcszOldNameBeforeEdit, LPCTSTR lpcszNewNameAfterEdit, int nPathType){ASSERT(false); return false; }
	virtual void	CopyThemeFileToDeleteFolder(LPCTSTR lpcszPath, LPCTSTR lpcszFullFileName){ ASSERT(false); }
protected:
	void			ConvColOrRowtoIndex(string& strTool);
	bool			IsInsideGrid(int nx, int ny, int &nRow, int &nCol);
	bool			IsIncrementListRow(int nRow);
	int				PopupMenu(const ThemeListControlMenuBase &menu, HWND hWndDlg, int nx, int ny);
	bool			DelThemeFiles(LPCTSTR lpcszPath, const vector<string> &vsThemeFiles, vector<string> &vsClassOption);
private:
	void			hideListCols();
	void			hidecolAndsetFormat();
	void			setAddCellFormat(int nRow, int nType, bool bIsIncrementList);
};

/************************************************************************/
/* ThemeGWListControl
/************************************************************************/
class ThemeGWListCtrl : public ThemeListCtrlBase //Graph and WorkSheet ListControl
{
public:
	//virtual 
	int				GetHideCols(vector<bool> &vbHideCols);
	//virtual 
	string			GetThemeFileName(int nRow);

	//virtual 
	bool			GetCopyOfThemeFileName(LPCTSTR lpcszOldFileName, string &strCopyFileName);
	//virtual 
	int				GetThemeFileType(LPCTSTR lpcszThemeFileWithExt);
	//virtual 
	bool			FindAllThemeFiles(TreeNode &trTheme);
	//virtual 
	bool			OnDelTheme(const vector<string> &vsThemeFiles, vector<string> &vsClassOption);
protected:
	//virtual 
	bool			OnAfterEditRename(LPCTSTR lpcszOldNameBeforeEdit, LPCTSTR lpcszNewNameAfterEdit, int nPathType);
	//virtual 
	MenuCmdMsg		PopupMenu(DWORD dwMenuBits, HWND hWndDlg, int nx, int ny);
	//virtual 
	void			CopyThemeFileToDeleteFolder(LPCTSTR lpcszPath, LPCTSTR lpcszFullFileName);

	//virtual 
	string			GetColHeadingTooltips(int nCol);
public:
	virtual int		GetApplyOffset(bool bCurrentPage){ ASSERT(false); return false; }
	virtual bool	GetApplyListToCombox(int nPageType, bool bCurrentPage, ComboBox &combo) { ASSERT(false); return false; }
	virtual int		GetThemeType(){ ASSERT(false); return false; }


	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
//private:
	//// virtual
	//void			hidecolAndsetFormat();
	//// virtual
	//void			setAddCellFormat(int nRow, int nType, bool bIsIncrementList);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
};

/************************************************************************/
/*    ThemeGraphListControl
/************************************************************************/
class ThemeGraphListCtrl : public ThemeGWListCtrl
{
public:
	//virtual 
	int				GetThemeTabType()	{ return THEME_GRAPH_TAB; }
	//virtual 
	int				GetPageType()		{ return EXIST_PLOT; }
	//virtual 
	int				GetThemeType()		{ return THTYPE_GRAPH; }
	//virtual 
	int				GetApplyOffset(bool bCurrentPage);
	//virtual
	bool			GetApplyListToCombox(int nPageType, bool bCurrentPage, ComboBox &combo);
	//virtual 
	bool			GetTabShowPostion(bool &bShowRight, bool &bShowBottom);
	//virtual 
	string			GetChangeDescription();
};

/************************************************************************/
/*    ThemeWorksheetListCtrl                                            */
/************************************************************************/
class ThemeWorksheetListCtrl : public ThemeGWListCtrl
{
public:
	//virtual 
	int				GetThemeTabType()	{ return THEME_WORKSHEET_TAB; }
	//virtual 
	int				GetPageType()		{ return EXIST_WKS; }
	//virtual 
	int				GetThemeType()		{ return THTYPE_WORKSHEET; }
	//virtual 
	int				GetApplyOffset(bool bCurrentPage);
	//virtual
	bool			GetApplyListToCombox(int nPageType, bool bCurrentPage, ComboBox &combo);
	//virtual 
	bool			GetTabShowPostion(bool &bShowRight, bool &bShowBottom);
	//virtual 
	string			GetChangeDescription();
};

/************************************************************************/
/*   ThemeDialogListControl
/************************************************************************/
class ThemeDialogListCtrl : public ThemeListCtrlBase
{
public:
	//virtual 
	int				GetHideCols(vector<bool> &vbHideCols);

	//virtual 
	int				GetThemeTabType() { return THEME_DIALOG_TAB; }

	//virtual 
	string			GetThemeFileName(int nRow);
	//virtual
	bool			GetTabShowPostion(bool &bShowRight, bool &bShowBottom);
	//virtual 
	bool			GetCopyOfThemeFileName(LPCTSTR lpcszOldFileName, string &strCopyFileName);
	//virtual 
	int				GetThemeFileType(LPCTSTR lpcszThemeFileWithExt);
	//virtual 
	string			GetChangeDescription();
	//virtual 
	bool			FindAllThemeFiles(TreeNode &trTheme);
	//virtual
	bool			OnDelTheme(const vector<string> &vsThemeFiles, vector<string> &vsClassOption);
protected:
	//virtual 
	bool			OnAfterEditRename(LPCTSTR lpcszOldNameBeforeEdit, LPCTSTR lpcszNewNameAfterEdit, int nPathType);

	//virtual 
	MenuCmdMsg		PopupMenu(DWORD dwMenuBits, HWND hWndDlg, int nx, int ny);
	//virtual 
	string			GetColHeadingTooltips(int nCol);
	//virtual 
	void			CopyThemeFileToDeleteFolder(LPCTSTR lpcszPath, LPCTSTR lpcszFullFileName);
private:
	int				getSelThemeFileType(LPCTSTR lpcszFileNameWithExt);
	int				getSelRowThemeType(int nSelRow);

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//// virtual
	//void			hidecolAndsetFormat();
	// virtual
	//void			setAddCellFormat(int nRow, int nType, bool bIsIncrementList);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
};

///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
/************************************************************************/
/*   ThemeFuncListCtrl
/************************************************************************/
class ThemeFuncListCtrl : public ThemeDialogListCtrl
{
public:
	//virtual 
	int				GetThemeTabType() { return THEME_FUNCTION_TAB; }
	//virtual 
	int				GetThemeType(){ return THTYPE_FUNCTION; }
	//virtual 
	int				GetThemeFileType(LPCTSTR lpcszThemeFileWithExt);
	//virtual
	string 			GetThemeFileName(int nRow);
	//virtual 
	string			GetChangeDescription();
	//virtual 
	bool			FindAllThemeFiles(TreeNode &trTheme);
	
protected:
	//virtual 
	bool			OnAfterEditRename(LPCTSTR lpcszOldNameBeforeEdit, LPCTSTR lpcszNewNameAfterEdit, int nPathType);
	//virtual 
	void			CopyThemeFileToDeleteFolder(LPCTSTR lpcszPath, LPCTSTR lpcszFullFileName);
};
///End NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY

ThemeListCtrlBase* create_theme_list_ctrl(int nSelTab);

#endif	//_THEMEGALLERYLISTCTRL_H