/*------------------------------------------------------------------------------*
 * File Name: ThemeGallery.hs													*
 * Creation: Kit 10/18/2011														*
 * Purpose: Origin C support for a Theme Gallery Dialog							*
 * Copyright (c) OriginLab Corp. 2011											*
 * All Rights Reserved															*
 * 																				*
 *------------------------------------------------------------------------------*/

#ifndef _THEMEGALLERY_H
#define _THEMEGALLERY_H

/************************************************************************/
/*  ThemeGalleryDlg
/************************************************************************/
#include "DialogEx.h"
#include "ThemeGalleryListCtrl.h"
class ThemeGalleryDlg : public ResizeDialog 
{	
public:
	ThemeGalleryDlg();
	~ThemeGalleryDlg();	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	int		DoModalEx(HWND hWndParent = NULL);
	int		ShowTab(int nPageType);

protected:
	EVENTS_BEGIN
		ON_INIT(OnInitDialog); 
		ON_DESTROY(OnDestroy);
		ON_SIZE(OnDlgResize);

		ON_CONTEXTMENU(OnShowMenu);

		ON_CBN_SELCHANGE(IDC_THEME_APPLY_TO, OnApplyToComboChange);

		//ON_SIZE(OnResize)
		ON_GRID_BEFORE_EDIT(IDC_THEME_GRID, OnBeforeEdit);
		ON_GRID_AFTER_EDIT(IDC_THEME_GRID, OnAfterEdit);
		//ON_GRID_AFTER_SEL_CHANGE(IDC_THEME_GRID, OnAfterSelChange)
		ON_GRID_SEL_CHANGE(IDC_THEME_GRID, OnSelChange);
		ON_GRID_MOUSE_MOVE(IDC_THEME_GRID, OnMouseMove);	//CPY 4/25/03 ADD_FILE_DATE and ADD_TOOLTIPS
		ON_GRID_BEFORE_MOUSE_DOWN(IDC_THEME_GRID, OnBeforeMouseDown);
		ON_GRID_DBLCLICK(IDC_THEME_GRID, OnDblClick);
		//--- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
		//ON_GRID_BUTTON_CLICK(IDC_THEME_GRID, OnEditTheme)
		//---
		ON_BN_CLICKED(IDC_THEME_SHOW_GRAPH_ONLY, OnShowThemeTypes);
		ON_BN_CLICKED(IDC_THEME_APPLY, OnApplyButton);
		ON_BN_CLICKED(IDC_THEME_UNDO, OnUndoApplyButton); //CPY 4/30/03 ADD_UNDO_APPLY

		ON_TAB_SEL_CHANGE(IDC_THEME_TAB, OnTabChange);

	EVENTS_END
	/////////////////////////////////////////////////
	// Event handling ///////////////////////////////
	/////////////////////////////////////////////////
	BOOL	OnInitDialog();
	BOOL	OnDestroy();
	BOOL	OnDlgResize(int nType, int cx, int cy);
	BOOL	OnShowThemeTypes(Control cntrl);
	//////////////////////////
	// Add New Theme
	//////////////////////////
	BOOL	OnAdd(Control cntrl);
	BOOL	OnDuplicate(Control cntrl);
	BOOL	OnCombine(Control cntrl);
	BOOL	OnApplyToComboChange(Control cntrl);		
	BOOL	OnApplyButton(Control cntrl);

	//---- CPY 4/30/03 ADD_UNDO_APPLY
	BOOL	OnUndoApplyButton(Control cntrl);
	//---- end

	///Jasmine 02/15/06 ADD_TYPE_TAB 
	BOOL	OnTabChange(Control cntrl);
	///End ADD_TYPE_TAB

	//////////////////////////
	// Delete Theme
	// move file into folder called "Deleted"
	//////////////////////////
	BOOL	OnDelTheme(Control cntrl);
	///////////////////////////////////////////////////////////////////////////////
	BOOL	OnShowMenu(UINT nResIDCtrl, int nx, int ny);
	//------------ vcFlex Grid Event Handlers ------------
	/////////////////////////////////////////
	//
	void	OnBeforeMouseDown(Control flxControl, short nButton, short nShift, float X, float Y, BOOL* pCancel);
	void	OnDblClick(Control flxControl);

	void	OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel);

	void	OnAfterEdit(Control flxControl, int nRow, int nCol);
	void	OnSelChange(Control flxControl);
	BOOL	OnEditTheme(Control cntrl);
	//---------- CPY 4/25/03 ADD_FILE_DATE and ADD_TOOLTIPS
	void	OnMouseMove(Control flxControl, short nButton, short nShift, float X, float Y);
	//---------- end ADD_TOOLTIPS

private:
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	bool	initThemeListCtrl();
	ThemeGWListCtrl *getGWListCtrl();
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE


	///Jasmine 09/20/07 NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
	bool	isAllowEdit(int nRow);
	///End NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
	///Jasmine 09/07/07 NOT_APPLY_THEME_TO_REPORT_SHEET
	bool	isCurrentLayerAvailable(int nTabType);
	///End NOT_APPLY_THEME_TO_REPORT_SHEET
	///Joseph 10/25/06 HIDE_RIGHTCONTROL_ON_ANALYSIS_TAB
	void	onTabShowRightBottom();
	///End HIDE_RIGHTCONTROL_ON_ANALYSIS_TAB

	
	bool	hasSystemTheme();
	void	setSystemTheme(int nRow);
	void	clearSystemTheme();
	bool	getNextThemeFileName(string& strFilename);
	bool	getCopyOfThemeFileName(string& strFilename, const string& strThemeFilename);
	bool	getCombineThemeFileName(string& strFilename, const string& strThemeFilename);
	bool	getSelThemeFile(string& strThemeFilename);
	bool	getSelThemeFiles(StringArray& vstrThemeFilenames);
	string	getThemeFileName(int nRow);
	string	getThemeTooltips(int nRow);
	// there seems to be no tooltip support for this version of vsFlex, so
	// just use dialog title for now
	void	showTooltipText(string& str);
	int		getThemeApply();
	void	enableButtons();
	///Jasmine 02/15/06 ADD_TYPE_TAB 
	void	showButtons(bool bShow = true);
	void	setApplyToList();
	///End ADD_TYPE_TAB

	// if bUpdateButton, then
	// nInc = 0 --> init
	// inc > 0 or < 0, inc/decrement count
	bool	undoEnabled(bool bUpdateButton = false, int nInc = 0);
	void	checkSystemTheme(int nRowToCheck = -1);
	int		addThemes(TreeNode& trNode);

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//bool	isIncrementListRow(int nRow);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	// I found that bRemoveOld and bSelLast is always true, false, so I think it's no need to pass them
	//void	loadThemesToGrid(bool bRemoveOld = true, bool bSelLast = true);
	// we did not use this function at all!!
	//void	addThemeToGrid(const string& strThemeFilename, bool bUser = true, bool bSelIt = true);
	void	loadThemesToGrid();
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	void	resizeThemeCols();
	void	loadOptions();
	void	saveOptions();
	
	/// Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//void	afterEditUsed(ThemeListCtrlBase &ThemeList, int nCol, int nRow, int nColName, int nColLocation);

	//void	popupAnalysisMenu(ThemeListControlMenuBase& myMenu, int nx, int ny);

	//void	popupGWListMenu(ThemeListControlMenuBase& myMenu, int nRow, int nx, int ny);	
	// move to ThemeListCtrlBase
	//void	convColOrRowtoIndex(string& strTool);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	///Jasmine QA81-14829 SELECT_CORRESPONDING_THEME
	void	refreshGridList(LPCSTR lpcszThemeName = NULL);
	///End SELECT_CORRESPONDING_THEME
	///End ADD_ANALYSIS_THEME_TO_TAB
	///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
	void	onChangeDescription();
	///End CLEAN_THEME_ORGANIZER
	
private:
	TabControl 					m_tabPage;///Jasmine 02/15/06 ADD_TYPE_TAB

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	//ThemeGWListCtrl			m_themeGWList;			//Graph && Worksheet ThemeList;
	//ThemeDialogListCtrl		m_themeDialogList;
	///End  ADD_ANALYSIS_THEME_TO_TAB
	ThemeListCtrlBase			*m_pThemeList;
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	ComboBox					m_cmbApplyTo;
	string						m_strWksName;
	string						m_strThemeFilename;
	bool						m_bExcludeIncremenTypes;
	int							m_nUndoStackCount;
	string						m_strOldStr;
	bool						m_bPreviewGraphReady;
	Control						m_cntrlSystemTheme;
	bool						m_bCurrentPage;			///Jasmine 02/15/06 ADD_TYPE_TAB
	int 						m_nPageType;

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//int							m_nThemeType;
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	bool						m_bExcludeLastUsed;		//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME

	string						m_strOptionsSecName;
	string						m_strOptionsValName;
	bool						m_bShowTooltips;
};

#endif	//_THEMEGALLERY_H