/*--------------------------------------------------------------------------------------*
 * File Name: SystemVariableDlg.c														*
 * Creation: 																			*
 * Purpose: OriginC Source C file														*
 * Copyright (c) OriginLab Corp. 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011	*
 * All Rights Reserved																	*
 * 																						*
 * Modification Log:																	*
 *	Jasmine 08/24/2011 ORG-2768-S2 RUN_OGS_FILE_ON_ORG_STARTUP_TO_SET_SYSVAR			*
 *	Jasmine 09/19/2011 ORG-2768-P2 SHOW_DEFAULT_VALUE_AFTER_ENTER_NAME					*
 *	Jasmine 09/19/2011 ORG-2768-P3 SOME_SYS_VAR_HAS_NO_VALUE_AND_SHOULD_BE_CONSIDERED_AS_UNCHANGE
 *	Jasmine 09/19/2011 ORG-2768-P4 NO_EDIT_READ_ONLY_SYS_VAR							*
 *	Jasmine 09/21/2011 ORG-2768-P2 V_VALUE_CHANGE_IN_EACH_BUILD							*
 *	Jasmine 09/23/2011 ORG-2768-P2 IF_NO_DEFAULT_VALUE_THEN_GET_FROM_CURRNT_PROJECT		*
 *	Jasminie 09/07/2012 ORG-6636-S1 OPENGL_CRASH_INFO_DLG								*
 *	Philip 09/11/2012 ORG-6786-P1 LOADLASTUSED_BTN_OF_GRAPHBROWSER_NOT_HIDDEN_IN_SYSVARDLG
 *--------------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"
#include "GridControl.h"

#include <okocUtils.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////

#define STR_SYSVAR_TREE_INTERNAL_ATTRIB 	"InternalUse"	
#define STR_SYSVAR_TREE_TYPE_ATTRIB 		"Type"
#define STR_SYSVAR_TREE_ACCESS_ATTRIB 		"Access"
#define STR_SYSVAR_TREE_SUPPORTED_ATTRIB 	"Supported"
#define STR_SYSVAR_TREE_DESCRIPT_ATTRIB 	"Description"

#define STR_SYS_VAR_OGS		"SystemVariables.ogs"
#define	STR_MAIN_SECTION	"Main"
/*------------------------------------------------------------------------------*
 * util function		 														*
 *------------------------------------------------------------------------------*/
///Jasminie 09/07/2012 ORG-6636-S1 OPENGL_CRASH_INFO_DLG
void change_system_variables_in_start_up(const vector<string>& vsVarNames, const vector<string>& vsVarVals, const vector<string>& vsComment)
{
	char szUserName[MAX_PATH];
	DWORD dwSize = MAX_PATH;
	if( GetUserName(szUserName, &dwSize) )
	{
		SYSTEMTIME st;
		get_current_time(st, true);
		double dDate;
		SystemTimeToJulianDate(&dDate, &st);
		string strTime = get_date_str(dDate, LDF_OBJ_CUSTOM, "yyyy'-'MM'-'dd hh':'mm tt");
			
		string strHead;
		strHead.Format("//System Variable Customization\r\n//Generated from Origin by %s on %s", szUserName, strTime);
		
		stdioFile filTemp(GetAppPath()+STR_SYS_VAR_OGS, file::modeCreate | file::modeWrite | file::shareExclusive | file::typeText );
		filTemp.WriteString(strHead);
		filTemp.Close();
	}
	
	int nRet = okutil_write_file_section_keys(GetAppPath()+STR_SYS_VAR_OGS, STR_MAIN_SECTION, &vsVarNames, &vsVarVals, &vsComment);
	
	if(nRet >= 0)
	{
		string strLT;
		strLT.Format("run.section(%s, main);", STR_SYS_VAR_OGS);
		LT_execute(strLT);
	}

	string	strKey("sysvar");
	INIFile	iniFile("Origin.ini");
	string 	strValue = iniFile.ReadString(STR_ORIGIN_STARTUP_SECTION, strKey);
	if(strValue.CompareNoCase(STR_SYS_VAR_OGS) != 0)
	{
		iniFile.WriteString(STR_ORIGIN_STARTUP_SECTION, strKey, STR_SYS_VAR_OGS);
	}
}
///End OPENGL_CRASH_INFO_DLG

///Jasmine 09/23/2011 ORG-2768-P2 IF_NO_DEFAULT_VALUE_THEN_GET_FROM_CURRNT_PROJECT
/////Jasmine 09/21/2011 ORG-2768-P2 V_VALUE_CHANGE_IN_EACH_BUILD
//static void _special_treat_for_v(LPCSTR lpczName, string& strDefaultValue)
//{
	//if( !strDefaultValue.IsEmpty() )
		//return;
	//
	////vector<string> vsSpecialVariables = {"V", "VRS"};
	////int nSize = vsSpecialVariables.GetSize();
	////for(int ii = 0; ii < nSize; ii++)
	////{
		////int nRet = lstrcmpi(vsSpecialVariables[ii], lpczName);
		////if(nRet != 0)
			////continue;
		//
		//string strName(lpczName);
		//strName = "@" + strName;
		//double dValue;
		//LT_get_var(strName, &dValue);
		//strDefaultValue = ftoa(dValue);
	////}
//}
/////End V_VALUE_CHANGE_IN_EACH_BUILD
static void _special_treat_for_no_value_var(const vector<string>& vsVar, vector<string>& vsValue)
{
	int nSize = vsVar.GetSize();
	for(int ii = 0; ii < nSize; ii++)
	{
		string strValue( vsValue[ii] );
		
		if( is_numeric(strValue) || strValue.Match("RGB(*)") )
			continue;

		string strName = "@" + vsVar[ii];
		double dValue;
		LT_get_var(strName, &dValue);
		vsValue[ii] = ftoa(dValue);
	}
}
///End IF_NO_DEFAULT_VALUE_THEN_GET_FROM_CURRNT_PROJECT
/*------------------------------------------------------------------------------*
 * util function end	 														*
 *------------------------------------------------------------------------------*/
 
/*------------------------------------------------------------------------------*
 * SysVarGrid 			 														*
 *------------------------------------------------------------------------------*/
enum{
	SYSVARDLG_VAR_NAME_COL 			= 0,
	SYSVARDLG_VALUE_COL,
	SYSVARDLG_COMMENT_COL,
	
	SYSVARDLG_COL_TOTAL
};

enum{
	SYSVAR_NOT_EXIST 	= 1,
	SYSVAR_INTERNAL_USE,
	SYSVAR_READ_ONLY,
	SYSVAR_VALUE_CHANGE,
	SYSVAR_VALUE_UNCHANGE,
};

class SysVarGrid : public GridListControl
{
public:	
	void 	Init(int nID, Dialog& dlg);
	
	BOOL	ShowMenu(int nx, int ny, HWND hWnd);

	void	ReadVarFromFile();
	int		WriteVarToFile(bool bExecute = false);
	
	void	OnBeforeEdit(int nRow, int nCol, BOOL* pCancel);
	void	OnAfterEdit(int nRow, int nCol);
	void 	OnMouseMove(short nButton, short nShift, float X, float Y);
	
private:
	int		initSysVarInfoVectors();
	int		recognizeSystemVariable(LPCSTR lpczName, string* pstrValue = NULL, int* pnFind = NULL);
	void 	markSysVarRowWithColor(int nRow, int nFlag); //void 	markSysVarRowWithColor(int nRow);	///Jasmine 09/19/2011 ORG-2768-P2 SHOW_DEFAULT_VALUE_AFTER_ENTER_NAME
	
private:
	string				m_strTemp;
	
	vector<string>		m_vsNames;
	vector<string>		m_vsInternalUse;
	vector<string>		m_vsTypes;
	vector<string>		m_vsAccess;
	vector<string>		m_vsDefault;
	vector<string>		m_vsSupportd;
	vector<string>		m_vsDescription;
};

void 	SysVarGrid::Init(int nID, Dialog& dlg)
{
	GridListControl::Init(nID, dlg);
	
	SetCols(SYSVARDLG_COL_TOTAL);
	SetEditable(flexEDKbdMouse);
	SetSelection(flexSelectionFree);
	
	SetColHeading(SYSVARDLG_VAR_NAME_COL,		_L("Variable"));
	SetColHeading(SYSVARDLG_VALUE_COL, 			_L("Value"));
	SetColHeading(SYSVARDLG_COMMENT_COL,		_L("Comment"));

	SetColAlignment(SYSVARDLG_VAR_NAME_COL, flexAlignCenterCenter);
	SetColAlignment(SYSVARDLG_VALUE_COL, 	flexAlignCenterCenter);
	SetColAlignment(SYSVARDLG_COMMENT_COL, 	flexAlignLeftCenter);
	
	SetColDataType(SYSVARDLG_VAR_NAME_COL,		flexDTString);
	SetColDataType(SYSVARDLG_VALUE_COL,			flexDTDouble);
	SetColDataType(SYSVARDLG_COMMENT_COL, 		flexDTString);
	
	initSysVarInfoVectors();
}

#define			ID_PRESCRIPT_MENU_NEW_ROW			0x0001
#define			ID_PRESCRIPT_MENU_DELETE_ROW		0x0002	
BOOL	SysVarGrid::ShowMenu(int nx, int ny, HWND hWnd)
{
	int		nRow, nCol;
	GetMouseCell(nRow, nCol);
	int		nRowOffset = GetRowOffset();	
	if ( nRow < 0 )
		return FALSE;
	
	Menu	myMenu;
	myMenu.Add(_L("New"), ID_PRESCRIPT_MENU_NEW_ROW);
	myMenu.Add(_L("Delete"), ID_PRESCRIPT_MENU_DELETE_ROW, GetRows() == nRowOffset + 1 ? MF_GRAYED : MF_STRING);
	
	int		nCmd = 0;
	myMenu.TrackPopupMenu(0, nx, ny, hWnd, &nCmd);
	switch ( nCmd )
	{
	case ID_PRESCRIPT_MENU_NEW_ROW:
		AddOneRow();
		break;

	case ID_PRESCRIPT_MENU_DELETE_ROW:
		DeleteRow(nRow);
		break;
		
	default:
		break;
	}
	
	return TRUE;
}

#define STR_VAR_PREFIX			"@"
static void _remove_prefix(vector<string>& vsInput, bool bVar)
{
	int nCount = vsInput.GetSize();
	for(int ii = 0; ii < nCount; ii++)
	{
		string strTemp = vsInput[ii];
		if(bVar)
		{
			if(strTemp.Left(1).Compare(STR_VAR_PREFIX) == 0)
				strTemp.Delete(0);
		}
		else
		{
			if(strTemp.Left(1).Compare(";") == 0)
				strTemp.Delete(0);
			if(strTemp.Left(2).Compare("//") == 0)
				strTemp.Delete(0, 2);
		}
		strTemp.TrimLeft();
		strTemp.TrimRight();
		vsInput[ii] = strTemp;
	}
}

static void _trim_space(vector<string>& vsInput)
{
	int nCount = vsInput.GetSize();
	for(int ii = 0; ii < nCount; ii++)
	{
		string strTemp = vsInput[ii];
		strTemp.TrimLeft();
		strTemp.TrimRight();
		vsInput[ii] = strTemp;
	}
}

void	SysVarGrid::ReadVarFromFile()
{
	ClearAll();
	
	int nRowOffset = GetRowOffset();
	
	vector<string> vsVarNames, vsVarVals, vsComment;		
	int nRet = okutil_read_file_section_keys(GetAppPath()+STR_SYS_VAR_OGS, STR_MAIN_SECTION, &vsVarNames, &vsVarVals, &vsComment);	
	
	//remove repeat items
	vector<int> 	vnMapIndices;
	vector<uint> 	vnR1s, vecIndex;
	if(vsVarNames.FindDuplicates(vnMapIndices, vnR1s) > 0)
	{
		vecIndex.SetSize(0);
		if(vnMapIndices.Find(vecIndex, -1) > 0)
		{
			vecIndex.Append(vnR1s);
			vecIndex.Sort();
			ASSERT(0);
			vector<string> vsTemp;
			
			vsVarNames.GetSubVector(vsTemp, vecIndex);	vsVarNames = vsTemp;
			
			vsVarVals.GetSubVector(vsTemp, vecIndex);	vsVarVals = vsTemp;
			
			vsComment.GetSubVector(vsTemp, vecIndex);	vsComment = vsTemp;
		}
	}
	
	
	_remove_prefix(vsVarNames, true);
	_remove_prefix(vsComment, false);
	_trim_space(vsVarVals);

	int nCount = vsVarNames.GetSize();
	for(int ii = nCount - 1; ii >= 0; ii--)
	{
		string strValue = vsVarVals[ii];
		if( !is_numeric(strValue) 
			&& !strValue.Match("RGB(*)") )
			vsVarVals[ii] = "0";
	}
	
	vector<string> vsAll;
	vsAll.Append(vsVarNames);
	vsAll.Append(vsVarVals);
	vsAll.Append(vsComment);
	
	nCount = vsVarNames.GetSize();
	SetRows(nCount, true);
	m_flx.SetTableValue(&vsAll, nCount, SYSVARDLG_COL_TOTAL, nRowOffset, GetColOffset(), false);
	
	for(ii = 0; ii < nCount; ii++)
	{	
		///Jasmine 09/19/2011 ORG-2768-P2 SHOW_DEFAULT_VALUE_AFTER_ENTER_NAME
		//markSysVarRowWithColor(ii+nRowOffset);
		int nRow = ii+nRowOffset;
		string strName 	= GetCell(nRow, SYSVARDLG_VAR_NAME_COL);
		string strValue	= GetCell(nRow, SYSVARDLG_VALUE_COL);
		int nFlag = recognizeSystemVariable(strName, &strValue);
		markSysVarRowWithColor(nRow, nFlag);				
		///End SHOW_DEFAULT_VALUE_AFTER_ENTER_NAME
	}
	
	AddOneRow();
	
	ResizeCols();
}

int		SysVarGrid::WriteVarToFile(bool bExecute/* = false*/)
{
	char szUserName[MAX_PATH];
	DWORD dwSize = MAX_PATH;
	if( GetUserName(szUserName, &dwSize) )
	{
		SYSTEMTIME st;
		get_current_time(st, true);
		double dDate;
		SystemTimeToJulianDate(&dDate, &st);
		string strTime = get_date_str(dDate, LDF_OBJ_CUSTOM, "yyyy'-'MM'-'dd hh':'mm tt");
			
		string strHead;
		strHead.Format("//System Variable Customization\r\n//Generated from Origin by %s on %s", szUserName, strTime);
		
		stdioFile filTemp(GetAppPath()+STR_SYS_VAR_OGS, file::modeCreate | file::modeWrite | file::shareExclusive | file::typeText );
		filTemp.WriteString(strHead);
		filTemp.Close();
	}
	
	vector<string> vsVarNames, vsVarVals, vsComment;
	GetColValues( SYSVARDLG_VAR_NAME_COL,	vsVarNames,	GetRowOffset() );
	GetColValues( SYSVARDLG_VALUE_COL, 		vsVarVals, 	GetRowOffset() );
	GetColValues( SYSVARDLG_COMMENT_COL,	vsComment,	GetRowOffset() );
		
	int nCount = vsVarNames.GetSize();
	ASSERT( nCount == vsVarVals.GetSize() && nCount == vsComment.GetSize() );
	for(int ii = nCount - 1; ii >= 0; ii--)
	{
		string 	strWarning;
		string 	strTemp = vsVarNames[ii];
		string 	strValue= vsVarVals[ii];
		int 	nFlag 	= recognizeSystemVariable(strTemp);
				
		if(strTemp.Left(1).Compare(STR_VAR_PREFIX) != 0)
		{
			vsVarNames[ii] = STR_VAR_PREFIX + strTemp;
		}
		
		
		if(	strTemp.IsEmpty() 
			|| ( is_missing_value(atof(strValue)) && !strValue.Match("RGB(*)") )
			|| SYSVAR_READ_ONLY == nFlag)
		{			
			if(SYSVAR_READ_ONLY == nFlag)
			{
				strWarning.Format(_L("%s: read only system variable, skipped"), vsVarNames[ii]);
				okoc_out_msg(strWarning, 'W');
			}
			
			vsVarNames.RemoveAt(ii);
			vsVarVals.RemoveAt(ii);
			vsComment.RemoveAt(ii);
			continue;
		}
		
		if(SYSVAR_INTERNAL_USE == nFlag)
		{
			strWarning.Format(_L("%s: internal system variable, use as is but not recommended"), vsVarNames[ii]);
			okoc_out_msg(strWarning, 'W');
		}
		else if(SYSVAR_NOT_EXIST == nFlag)
		{
			strWarning.Format(_L("%s: unknown system variable, use as is"), vsVarNames[ii]);
			okoc_out_msg(strWarning, 'W');
		}
		
		vsComment[ii] = ";//" + vsComment[ii];
	}
	
	int nRet = okutil_write_file_section_keys(GetAppPath()+STR_SYS_VAR_OGS, STR_MAIN_SECTION, &vsVarNames, &vsVarVals, &vsComment);
	
	if(bExecute && nRet >= 0)
	{
		string strLT;
		strLT.Format("run.section(%s, main);", STR_SYS_VAR_OGS);
		LT_execute(strLT);
	}
	
	return nRet;
}

void	SysVarGrid::OnBeforeEdit(int nRow, int nCol, BOOL* pCancel)
{
	switch ( nCol )
	{
	case SYSVARDLG_VAR_NAME_COL:
	case SYSVARDLG_VALUE_COL:
		m_strTemp = GetCell(nRow, nCol);
		
	case SYSVARDLG_COMMENT_COL:
		///Jasmine 09/19/2011 ORG-2768-P4 NO_EDIT_READ_ONLY_SYS_VAR
		if(SYSVARDLG_VALUE_COL == nCol || SYSVARDLG_COMMENT_COL == nCol)
		{
			string strName 	= GetCell(nRow, SYSVARDLG_VAR_NAME_COL);
			int nFlag = recognizeSystemVariable(strName);
			if(SYSVAR_READ_ONLY == nFlag)
			{
				*pCancel = true;
			}
		}		
		///End NO_EDIT_READ_ONLY_SYS_VAR
		break;

	default:
		O_A_FAIL;
		break;
	}
		
	return;
}
void	SysVarGrid::OnAfterEdit(int nRow, int nCol)
{
	string	strNew = GetCell(nRow, nCol);
	strNew.TrimLeft();
	strNew.TrimRight();
	SetCell(nRow, nCol, strNew);
	
	BOOL	bEnterDown = ENTER_DOWN;
	switch ( nCol )
	{		
	case SYSVARDLG_VALUE_COL:
		if( !is_numeric(strNew) 
			&& !strNew.Match("RGB(*)") )
		{
			SetCell(nRow, nCol, m_strTemp);			
			return;
		}
		///Jasmine 09/19/2011 ORG-2768-P2 SHOW_DEFAULT_VALUE_AFTER_ENTER_NAME
		//markSysVarRowWithColor(nRow);				
		string strName 	= GetCell(nRow, SYSVARDLG_VAR_NAME_COL);
		string strValue	= GetCell(nRow, SYSVARDLG_VALUE_COL);
		int nFlag = recognizeSystemVariable(strName, &strValue);
		markSysVarRowWithColor(nRow, nFlag);				
		///End SHOW_DEFAULT_VALUE_AFTER_ENTER_NAME
		break;
		
	case SYSVARDLG_VAR_NAME_COL:
		int nFindRow = FindRow(strNew, SYSVARDLG_VAR_NAME_COL, false, true, GetRowOffset());
		if(nFindRow == nRow)
			nFindRow = FindRow(strNew, SYSVARDLG_VAR_NAME_COL, false, true, nRow+1);
		if(nFindRow != -1)
		{
			SetCell(nRow, nCol, m_strTemp);			
			return;
		}
		
		///Jasmine 09/19/2011 ORG-2768-P2 SHOW_DEFAULT_VALUE_AFTER_ENTER_NAME
		//markSysVarRowWithColor(nRow);				
		string strName 	= GetCell(nRow, SYSVARDLG_VAR_NAME_COL);
		string strValue	= GetCell(nRow, SYSVARDLG_VALUE_COL);
		int nFind = -1;
		int nFlag = recognizeSystemVariable(strName, &strValue, &nFind);
		markSysVarRowWithColor(nRow, nFlag);				
		
		if(	strValue.IsEmpty() && nFlag != SYSVAR_NOT_EXIST && 
			nFind >=0 && m_vsDefault.GetSize() > nFind)
		{
			string strDefaultValue = m_vsDefault[nFind]; 
			strDefaultValue.TrimLeft(); strDefaultValue.TrimRight();
			///Jasmine 09/23/2011 ORG-2768-P2 IF_NO_DEFAULT_VALUE_THEN_GET_FROM_CURRNT_PROJECT			
			//_special_treat_for_v(strName, strDefaultValue);					///Jasmine 09/21/2011 ORG-2768-P2 V_VALUE_CHANGE_IN_EACH_BUILD
			///End IF_NO_DEFAULT_VALUE_THEN_GET_FROM_CURRNT_PROJECT
			SetCell(nRow, SYSVARDLG_VALUE_COL, strDefaultValue);
		}

		///End SHOW_DEFAULT_VALUE_AFTER_ENTER_NAME
		break;
		
	case SYSVARDLG_COMMENT_COL:
		break;
		
	default:
		O_A_FAIL;
		break;
	}
	
	
	if ( bEnterDown )
	{
		if(nCol+1 >= GetCols())
		{
			if ( nRow == GetRows() - 1 )
				AddOneRow();
			SelCell(nRow + 1, GetColOffset());
		}
		else
		{
			SelCell(nRow, nCol+1);
		}
	}

	return;
}

void 	SysVarGrid::OnMouseMove(short nButton, short nShift, float X, float Y)
{
	int nRow, nCol;
	if ( !GetMouseCell(nRow, nCol) || nRow < 0 || nCol < 0 )
		return;

	string strTips;
	if( nRow >= GetRowOffset() )
	{
		string strName 	= GetCell(nRow, SYSVARDLG_VAR_NAME_COL);
		int nFind = -1;
		int	nFlag = recognizeSystemVariable(strName, NULL, &nFind);
		if(nFlag != SYSVAR_NOT_EXIST)
		{
			if(m_vsDefault.GetSize() > nFind && nFind >= 0)
			{
				string strValue = m_vsDefault[nFind]; 
				strValue.TrimLeft(); strValue.TrimRight();
				if( !strValue.IsEmpty() )
				{
					string strTemp;
					strTemp.Format(_L("Default Value = %s"), strValue);
					strTips += strTemp;
				}
			}
			
			if(m_vsSupportd.GetSize() > nFind)
			{
				string strValue = m_vsSupportd[nFind]; 
				strValue.TrimLeft(); strValue.TrimRight();
				if( !strValue.IsEmpty() )
				{
					string strTemp;
					strTemp.Format(_L("Supported Value = %s"), strValue);
					if( !strTips.IsEmpty() )
						strTips += "; ";
					strTips += strTemp;
				}
			}
		}
	}
	SetToolTipsText(strTips);
}

#define STR_SYSVAR_XML			"SystemVariables.xml"
int		SysVarGrid::initSysVarInfoVectors()
{
	Tree trSysVars;
	if( !trSysVars.Load(GetAppPath(TRUE) + STR_SYSVAR_XML) )
		return 0;
	
	tree_get_node_names(trSysVars, m_vsNames, true);

	tree_get_attributes(trSysVars, m_vsInternalUse, STR_SYSVAR_TREE_INTERNAL_ATTRIB, true);	 
	
	tree_get_attributes(trSysVars, m_vsTypes, STR_SYSVAR_TREE_TYPE_ATTRIB, true);	 
	
	tree_get_attributes(trSysVars, m_vsAccess, STR_SYSVAR_TREE_ACCESS_ATTRIB, true);	 

	int nRet = okutil_get_subnode_values_to_vectorstring(&trSysVars, &m_vsDefault);
	///Jasmine 09/23/2011 ORG-2768-P2 IF_NO_DEFAULT_VALUE_THEN_GET_FROM_CURRNT_PROJECT
	_special_treat_for_no_value_var(m_vsNames, m_vsDefault);
	///End IF_NO_DEFAULT_VALUE_THEN_GET_FROM_CURRNT_PROJECT
	
	tree_get_attributes(trSysVars, m_vsSupportd, STR_SYSVAR_TREE_SUPPORTED_ATTRIB, true);	 
	
	tree_get_attributes(trSysVars, m_vsDescription, STR_SYSVAR_TREE_DESCRIPT_ATTRIB, true);	  
	
	return m_vsNames.GetSize();
}

int	SysVarGrid::recognizeSystemVariable(LPCSTR lpczName, string* pstrValue/* = NULL*/, int* pnFind/* = NULL*/)
{
	string strFind(lpczName);
	if( strFind.IsEmpty() )
		return SYSVAR_NOT_EXIST;
	strFind.MakeUpper();
	
	int nFind = m_vsNames.Find(strFind);
	if(nFind < 0)
		return SYSVAR_NOT_EXIST;
	if(pnFind != NULL)
		*pnFind = nFind;
	
	if(m_vsInternalUse.GetSize() > nFind && lstrcmpi(m_vsInternalUse[nFind], "Y") == 0)
		return SYSVAR_INTERNAL_USE;
		
	if(m_vsAccess.GetSize() > nFind && lstrcmpi(m_vsAccess[nFind], "R") == 0)
		return SYSVAR_READ_ONLY;	
	
	///Jasmine 09/19/2011 ORG-2768-P3 SOME_SYS_VAR_HAS_NO_VALUE_AND_SHOULD_BE_CONSIDERED_AS_UNCHANGE
	//if( pstrValue != NULL && m_vsDefault.GetSize() > nFind && !is_equal(atof(m_vsDefault[nFind]), atof(*pstrValue)) )
	if( pstrValue != NULL 
		&& strlen(*pstrValue) >= 1 
		&& m_vsDefault.GetSize() > nFind 
	///Jasmine 09/23/2011 ORG-2768-P2 IF_NO_DEFAULT_VALUE_THEN_GET_FROM_CURRNT_PROJECT
		//&& !is_equal(atof(m_vsDefault[nFind]), atof(*pstrValue)) )
		)
	{
		if(	lstrcmpi(m_vsDefault[nFind], *pstrValue) != 0
			&& !is_equal(atof(m_vsDefault[nFind]), atof(*pstrValue)) )
			return SYSVAR_VALUE_CHANGE;
	}
	///End IF_NO_DEFAULT_VALUE_THEN_GET_FROM_CURRNT_PROJECT
	///End SOME_SYS_VAR_HAS_NO_VALUE_AND_SHOULD_BE_CONSIDERED_AS_UNCHANGE
	
	return SYSVAR_VALUE_UNCHANGE;
}

///Jasmine 09/19/2011 ORG-2768-P2 SHOW_DEFAULT_VALUE_AFTER_ENTER_NAME
//void SysVarGrid::markSysVarRowWithColor(int nRow)
//{
	//string strName 	= GetCell(nRow, SYSVARDLG_VAR_NAME_COL);
	//string strValue	= GetCell(nRow, SYSVARDLG_VALUE_COL);
	//switch( recognizeSystemVariable(strName, &strValue) )
void SysVarGrid::markSysVarRowWithColor(int nRow, int nFlag)
{
	switch(nFlag)
///End SHOW_DEFAULT_VALUE_AFTER_ENTER_NAME
	{
	case SYSVAR_NOT_EXIST:
		SetCellColor(nRow, SYSVARDLG_VAR_NAME_COL, COLOR_RED);
		break;
		
	case SYSVAR_INTERNAL_USE:
		SetCellColor(nRow, SYSVARDLG_VAR_NAME_COL, RGB(200, 200, 200));
		break;
		
	case SYSVAR_READ_ONLY:
		SetCellColor(nRow, SYSVARDLG_VAR_NAME_COL, COLOR_BLUE);
		break;
		
	case SYSVAR_VALUE_CHANGE:
		SetCellColor(nRow, SYSVARDLG_VAR_NAME_COL, COLOR_GREEN);
		break;
		
	case SYSVAR_VALUE_UNCHANGE:
		SetCellColor(nRow, SYSVARDLG_VAR_NAME_COL, COLOR_BLACK);
		break;;
	}
}

/*------------------------------------------------------------------------------*
 * SysVarGrid End		 														*
 *------------------------------------------------------------------------------*/
 
/*------------------------------------------------------------------------------*
 * SysVarDlg			 														*
 *------------------------------------------------------------------------------*/

#define STR_DLG_NAME			"SystemVariableDlg"

class SysVarDlg : public ResizeDialog
{
public:
	SysVarDlg() : ResizeDialog(IDD_PG_DLG, "ODlg8")
	{
	}
	
	int	DoModalEx(HWND hParent)
	{
		InitMsgMap();
		return DoModal(hParent);
	}

protected:	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)	
	ON_RESTORESIZE(OnRestoreSize)
	ON_READY(OnReady)
	ON_SYSCOMMAND(OnSystemCommand)
	
	ON_OK(OnClickOK)
	
	ON_CONTEXTMENU(OnShowMenu)	
	
	ON_GRID_BEFORE_EDIT(IDC_MG_GRPAH_LIST, OnBeforeEdit)
	ON_GRID_AFTER_EDIT(IDC_MG_GRPAH_LIST, OnAfterEdit)
	ON_GRID_MOUSE_MOVE(IDC_MG_GRPAH_LIST, OnMouseMove)

	ON_HELPINFO(OnHelp)
	
EVENTS_END

	BOOL OnInitDialog();
	BOOL OnDestroy();
	BOOL OnDlgResize(int nType, int cx, int cy);
	BOOL OnRestoreSize(ODWP dwSizeInfo);
	BOOL OnReady();
	
	BOOL OnClickOK();
	
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny);
	
	void OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	void OnAfterEdit(Control flxControl, int nRow, int nCol);
	void OnMouseMove(Control cntrl, short nButton, short nShift, float X, float Y);

	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus);
	
private:
	SysVarGrid		m_grid;	
	DhtmlControl  	m_dhtml; /// Iris 9/06/2011 ORG-2753 TEST_SHOW_HINTS
};

#include <Profiler.h>

BOOL SysVarDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	nHelpID = IDD_XF_SYSTEM_VARIABLES;
	return TRUE;
}

BOOL SysVarDlg::OnInitDialog()
{
	//Profiler junk;
	ResizeDialog::OnInitDialog(0, STR_DLG_NAME);		
	
	Text = _L("Set System Variables");

	/// Iris 9/06/2011 ORG-2753 TEST_SHOW_HINTS
	//vector<uint> vnShow = {IDOK, IDCANCEL, IDC_MG_GRPAH_LIST};
	vector<uint> vnShow = {IDOK, IDCANCEL, IDC_MG_GRPAH_LIST, IDC_HITS};
	///End TEST_SHOW_HINTS
	for(int ii = 0; ii < vnShow.GetSize(); ii++)
	{
		Control ctrl = GetItem( vnShow[ii] );
		if(ctrl)
			ctrl.Visible = true;
	}
	vector<uint> vnHide = {IDC_FOLDER_TREE, IDC_MG_PREVIEW, IDC_MG_ADD, IDC_MG_REMOVE, IDC_CHECK_LIST_VIEW, IDC_SHOW_EMBEDDED, IDC_PG_SHORTCUT_CHECK, IDC_PM_UP_DOWN};
	vnHide.Add(IDC_LOAD_LAST_USED); ///Philip 09/11/2012 ORG-6786-P1 LOADLASTUSED_BTN_OF_GRAPHBROWSER_NOT_HIDDEN_IN_SYSVARDLG
	for(ii = 0; ii < vnHide.GetSize(); ii++)
	{
		Control ctrl = GetItem( vnHide[ii] );
		if(ctrl)
			ctrl.Visible = false;
	}
	
	m_grid.Init(IDC_MG_GRPAH_LIST, *this);
	m_grid.ReadVarFromFile();
	
	RECT r1;
	m_grid.GetWindowRect(r1);
	ScreenToClient(&r1);
	r1.top = r1.left = GetControlGap();
	m_grid.MoveWindow(r1);
	
	/// Iris 9/06/2011 ORG-2753 TEST_SHOW_HINTS
	Control ctrl = GetItem(IDC_HITS);
	HWND hWnd = ctrl.GetSafeHwnd();
	
	m_dhtml.CreateControl(hWnd);
	
	string strClickLinkToHelp;
	string strLink = "http://wiki.originlab.com/~originla/wiki/index.php?title=Origin_System_Variables";
	strClickLinkToHelp.Format("<font color=black size=2 ><b><a ID=LinkOL target=_blank href='%s'>%s</a></b></font>", strLink, _L("System Variables List"));
	
	m_dhtml.SetHtmlText(strClickLinkToHelp + 
	"<br>	<font color=black	size=2 >" + _L("Black : value not changed;") + "</font>\
	&nbsp;	<font color=green 	size=2 >" + _L("Green : value changed;") + "</font>"
	"<br>	<font color=red		size=2 >" + _L("Red : not exist;") + "</font>\
	&nbsp;	<font color=blue	size=2 >" + _L("Blue : read only;") + "</font>"
	"<br>	<font color=gray 	size=2 >" + _L("Gray : internal use;") + "</font>");
	///End TEST_SHOW_HINTS

	return TRUE;
}

BOOL SysVarDlg::OnDestroy(void)
{
	return ResizeDialog::OnDestroy();
}

BOOL SysVarDlg::OnDlgResize(int nType, int cx, int cy)
{	
	if(!IsInitReady())
		return TRUE;
	
	MoveControlsHelper	_temp(this);	
	
	uint nButtonIDs[] = {IDCANCEL, IDOK, 0};
	ArrangeMainItemAndControls(nButtonIDs, IDC_MG_GRPAH_LIST, NULL, false);
	
	/// Iris 9/06/2011 ORG-2753 TEST_SHOW_HINTS
	RECT rrList;
	GetControlClientRect(IDC_MG_GRPAH_LIST, rrList);
	rrList.bottom = rrList.bottom - 100;
	Control ctrlList = GetItem(IDC_MG_GRPAH_LIST);
	MoveControl(ctrlList, rrList);
	
	RECT rrOK, rrHits;
	GetControlClientRect(IDCANCEL, rrOK);
	rrHits.left = rrList.left;
	rrHits.right = rrList.right;
	rrHits.top = rrList.bottom + GetControlGap();
	rrHits.bottom = rrOK.top - GetControlGap();
	Control ctrlHits = GetItem(IDC_HITS);
	MoveControl(ctrlHits, rrHits);
	///EndT TEST_SHOW_HINTS
	
	return TRUE;
}

BOOL SysVarDlg::OnRestoreSize(ODWP dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);
	
	pSz->top 	= -1;
	pSz->left 	= -1;
	pSz->width 	= 450;
	pSz->height	= 250;
	
	return TRUE;
}

BOOL SysVarDlg::OnReady()
{
	SetInitReady();
	return TRUE;
}

BOOL SysVarDlg::OnClickOK()
{
	m_grid.WriteVarToFile(true);
	
	///Jasmine 08/24/2011 ORG-2768-S2 RUN_OGS_FILE_ON_ORG_STARTUP_TO_SET_SYSVAR
	string	strKey("sysvar");
	INIFile	iniFile("Origin.ini");
	string 	strValue = iniFile.ReadString(STR_ORIGIN_STARTUP_SECTION, strKey);
	if(strValue.CompareNoCase(STR_SYS_VAR_OGS) != 0)
	{
		iniFile.WriteString(STR_ORIGIN_STARTUP_SECTION, strKey, STR_SYS_VAR_OGS);
	}
	///End RUN_OGS_FILE_ON_ORG_STARTUP_TO_SET_SYSVAR

	return TRUE;
}

BOOL SysVarDlg::OnShowMenu(UINT nResIDCtrl, int nx, int ny)
{
	return m_grid.ShowMenu(nx, ny, GetSafeHwnd());
}

void SysVarDlg::OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel)
{
	m_grid.OnBeforeEdit(nRow, nCol, pCancel);
	
}
void SysVarDlg::OnAfterEdit(Control flxControl, int nRow, int nCol)
{
	m_grid.OnAfterEdit(nRow, nCol);
}

void SysVarDlg::OnMouseMove(Control cntrl, short nButton, short nShift, float X, float Y)
{
	m_grid.OnMouseMove(nButton, nShift, X, Y);
}

/*------------------------------------------------------------------------------*
 * SysVarDlg End		 														*
 *------------------------------------------------------------------------------*/

 
BOOL SystemVariableDlg(int nMsg, ODWP dwCntrl = 0, LPVOID lpData = NULL)
{
	HWND	hParent = (HWND)lpData;
	Window	winParent(hParent);
	HWND	hWnd = winParent ? hParent : GetWindow();
	
	SysVarDlg	myDlg;		 
	return myDlg.DoModalEx( hWnd ) != IDCANCEL;
}
	