/*----------------------------------------------------------------------------------------------*
 * File Name: StartLaunchTipsDlg.h																*
 * Creation: 																					*
 * Purpose: OriginC Source C file																*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012		*
 * All Rights Reserved																			*
 * 																								*
 * Modification Log:																			*
 *	Jasminie 09/07/2012 ORG-6636-S1 OPENGL_CRASH_INFO_DLG										*
 *----------------------------------------------------------------------------------------------*/


#ifndef _START_LAUNCH_REMINDER_DLG_H
#define _START_LAUNCH_REMINDER_DLG_H

class StartLaunchTipsReminderDlg: public ResizeDialog
{
public:
	StartLaunchTipsReminderDlg(DWORD dwOptions, bool bIsProduct) : ResizeDialog( IDD_ORG_POP_DLG, "ODlg8" )
	{
		m_dwOptions = dwOptions;
		m_bIsProduct = bIsProduct;
		m_dwItemSel = 0;	///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	}

	int DoModalEx(HWND hParent);	
	
	bool IsOpenSamplesFolder();
	
	bool IsTransferUserFile();
	
	bool IsOpenCheckForUpdateDlg(); /// Iris 3/09/2011 ORG-2196-S7 ADD_CHECK_FOR_UPDATE_NOW_BUTTON

	bool IsInitToolBars();			///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	
	string GetSelectedSampleProjectFile();  /// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
	
protected:	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	ON_GETMINMAXINFO(OnMinMaxInfo)
	ON_DESTROY(OnDestroy)
	//ON_RESTORESIZE(OnRestoreSize) 
	//ON_SIZE(OnDlgResize)	
	
	ON_BN_CLICKED(IDC_TRANSFER_UF_NOW, OnClickTransferUserFilesButton)
	ON_BN_CLICKED(IDC_OPEN_SAMPLES_OPJ, OnClickOpenSamplesProjectButton)
	ON_BN_CLICKED(IDC_CHECK_FOR_UPDATE_NOW, OnClickCheckForUpdateButton) /// Iris 3/09/2011 ORG-2196-S7 ADD_CHECK_FOR_UPDATE_NOW_BUTTON
	ON_BN_CLICKED(IDB_CLOSE, OnClose);

	ON_BN_CLICKED(IDC_CHECK_INIT_TOOLBAR_BTN, OnReInitToolBars)		///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	
EVENTS_END

	BOOL OnInitDialog();	
	BOOL OnReady();
	BOOL OnDestroy(void);	
	//BOOL OnRestoreSize(ODWP dwSizeInfo);
	//BOOL OnDlgResize(int nType, int cx, int cy);
	
	//int  GetTotalHeight(bool bGetMin = false);
	//int  GetTotalWidth(bool bGetMin = false);
	
	BOOL OnClickTransferUserFilesButton(Control ctrl);
	BOOL OnClickOpenSamplesProjectButton(Control ctrl);
	BOOL OnClickCheckForUpdateButton(Control ctrl);
	BOOL OnReInitToolBars(Control ctrl);	///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	BOOL OnClose(Control ctrl);
	
private:
	void showControls();
	void resizeControls();
	
private:
	DWORD 			m_dwOptions;	
	bool			m_bIsProduct;
	Button			m_ckDlgNeverShow;
	
	///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	/*
	bool			m_bTransferUserFile;
	bool			m_bOpenSamples;
	bool			m_bCheckForUpdate;
	*/
	enum StartUpItem
	{
		SUI_OpenTransferUserFile	= 0x00000001,
		SUI_OpenSamples				= 0x00000002,
		SUI_CheckForUpdate			= 0x00000004,
		SUI_InitToolBars			= 0x00000008,
	};
	DWORD			m_dwItemSel;
	///-----End ADD_INIT_TOOLBAR_TAB

	
	vector<uint>	m_vnGroupIDs;
	vector<uint> 	m_vuTipsControlIDs;
	vector<uint>	m_vuButtonIDs;
	/// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
	vector<uint>	m_vnComboIDs; 
	vector<string>  m_vsSampleProjectFiles; 
	ComboBox		m_cmbSampleProjects;
	string			m_strOPJ;
	///End ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
};


//Sophy 8/27/2012 ORG-6636-S1 USE_INI_TO_TRACE_OPENGL_DRAWING_CRASH
class COriginErrorInfoDlg : public ResizeDialog
{
public:
	///Jasminie 09/07/2012 ORG-6636-S1 OPENGL_CRASH_INFO_DLG
	//COriginErrorInfoDlg(int nErrCode, DWORD dwCtrl) : ResizeDialog(IDD_ERROR_INFO, "ODlg8" )
	COriginErrorInfoDlg(int nDlgID, int nErrCode, DWORD dwCtrl) : ResizeDialog(nDlgID, "ODlg8" )
	///End OPENGL_CRASH_INFO_DLG
	{
		m_nErrorCode = nErrCode;
		m_dwCtrl = dwCtrl;
	}
	~COriginErrorInfoDlg(){}
	int DoModalEx(HWND hParent);
protected:	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
EVENTS_END

	virtual BOOL	OnInitDialog();
	virtual BOOL	InitDisplayText();
protected:
	
	int				m_nErrorCode;
	DWORD			m_dwCtrl;
	DhtmlControl	m_errInfo;
};
///end USE_INI_TO_TRACE_OPENGL_DRAWING_CRASH

///Jasminie 09/07/2012 ORG-6636-S1 OPENGL_CRASH_INFO_DLG
class OpenGLCrashInfoDlg : public COriginErrorInfoDlg
{
public:
	OpenGLCrashInfoDlg(int nErrCode, DWORD dwCtrl) : COriginErrorInfoDlg(IDD_ERROR_INFO, nErrCode, dwCtrl)
	{
	}
	~OpenGLCrashInfoDlg(){}
	int		DoModalEx(HWND hParent)
	{
		InitMsgMap();
		return DoModal(hParent);
	}

protected:	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_OK(OnOK)	
EVENTS_END
	
	//virtual 
	BOOL	OnInitDialog();
	BOOL	OnOK();
	
	//virtual 
	BOOL	InitDisplayText();
	
private:
	void 	disableOpenGLSysVar(LPCSTR lpczVar, int nn, vector<string>& vsNames, vector<string>& vsValues);
	
};
///End OPENGL_CRASH_INFO_DLG
#endif //_START_LAUNCH_REMINDER_DLG_H