/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"
#include "XFunctionEx.h"
#include "ResizeGetNWiz.h"

enum
{
	ID_COLVAL_FIRST_PAGE	= ID_FIRST_PAGE,
	ID_COLVAL_VAR_PAGE,	//ID_COLVAL_IN_VAR_NUM_PAGE,
	//ID_COLVAL_IN_VAR_NAME_TYPE_PAGE,
	//ID_COLVAL_OUT_VAR_NAME_TYPE_PAGE,
	ID_COLVAL_FUNC_BODY_PAGE,
	//ID_COLVAL_IN_VAR_DEFAULT_PAGE,	///Jasmine 02/22/06 INSERT_IN_VAR_DEFAULT_PAGE
	//ID_COLVAL_SEL_EX_FILE_PATH_PAGE,
	//ID_COLVAL_SEL_EX_FILE_CATEGORY_PAGE,
	ID_COLVAL_SEL_EX_FILE_PAGE,
	ID_COLVAL_SEL_IN_PROJECT_PAGE,	//ID_COLVAL_SEL_IN_FILE_PAGE,
	
	ID_COLVAL_LAST_ITEM
};

enum
{
	SEL_FIRST_PAGE_NEW_XF,
	SEL_FIRST_PAGE_LOAD_FROM_FILE,
	SEL_FIRST_PAGE_LOAD_FROM_PROJECT
};

///Jasmine 02/21/06 REMOVE_POUND
//#define GETN_LIST_EX(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR)  _tmpSubNode = _tmpNode.AddNumericNode((int)_DEFAULT_VAL, #_NODE_NAME, TRGP_ENUM_LIST); TREE_ADD_LABEL(_NODE_LABEL);_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);
#define GETN_LIST_EX(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR)  _tmpSubNode = _tmpNode.AddNumericNode((int)_DEFAULT_VAL, _NODE_NAME, TRGP_ENUM_LIST); TREE_ADD_LABEL(_NODE_LABEL);_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);

#define GETN_STR_EX(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL)	_tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, _NODE_NAME, TRGP_STR);TREE_ADD_LABEL(_NODE_LABEL);

#define STR_VARIABLE_TYPE_LIST		"double|string|int|vector"	//double|string|int|vector|Range|XYRange|XYZRange|matrix|ButtonInfo|LineInfo|TextInfo|EventInfo|MarkerInfo|OriginObject|MatrixObject|Column|Worksheet|DataPlot|TreeNode|FileLink|ReportTree|ReportData"

#define STR_INPUT_VAR_NODE				"input"
#define STR_OUTPUT_VAR_NODE				"output"
#define	STR_CODE_NODE					"code"
#define STR_VAR_NODE					"Variable"
#define STR_VARNAME_NODE				"Name"
#define STR_VARTYPE_NODE				"Type"
#define STR_VARDATA_NODE				"Data"

class SetColValWizard : public ResizeGetNWiz
{
public :
	SetColValWizard(bool bIsMulti = false, bool bShowList = false) : ResizeGetNWiz(bIsMulti, bShowList)
	{
	}	
	~SetColValWizard()
	{
	}	

	
protected:	
EVENTS_BEGIN	
	ON_OK(OnFinish) //Finish button
	ON_CANCEL(OnCancel)		
EVENTS_END
	//virtual 
	void OnAfterValueChange(int nRow, DWORD lParam);
	
	
protected: 	//virtual 
	BOOL OnFinish(Control cntrl);
	void	ContructTree();
	int		GetPrevPageID();
	int		GetNextPageID();
	void 	OnBeforeUpdatePage();

	bool	IsValidID(int nID)
	{
		if(nID < ID_COLVAL_FIRST_PAGE || nID >= ID_COLVAL_LAST_ITEM)
			return false;		
		return true;
	}
public:
	//virtual
	string GetDlgName()
	{
		return "Set Column Values Wizard";
	}
private:
	int		getXFList(vector<string>& vsList, LPCSTR lpcszCate = NULL, int nPathType = ORIGIN_PATH_SYSTEM);
	void 	createInputTree(TreeNode &trPage, int nNum = 1);//createInNameTypeTree(TreeNode &trPage, int nNum = 1);
	void prepareXFParamTree(TreeNode& trXF);
	string	getXFPath();
};

void SetColValWizard::OnAfterValueChange(int nRow, DWORD lParam)
{
	TreeNode trNode = m_ctrlPage.GetTreeNode(nRow);
	if(!trNode)
		ASSERT(0);
	switch(m_nCurrentID)
	{
	case ID_COLVAL_VAR_PAGE:
		TreeNode trInput = tree_get_node_by_id(m_trMain, ID_COLVAL_VAR_PAGE).Input;
		if(1 == nRow)//Number of Input Variables
			createInputTree(trInput, trNode.nVal);
		break;
	case ID_COLVAL_SEL_EX_FILE_PAGE: 
		TreeNode trSelEx = tree_get_node_by_id(m_trMain, ID_COLVAL_SEL_EX_FILE_PAGE);
		if(0 == nRow)//system or user radio
		{//refresh category list
			vector<string> vsCate;
			string strCateList;
			int nPathType = trNode.nVal? ORIGIN_PATH_USER : ORIGIN_PATH_SYSTEM;
			int nNum = getXFList(vsCate, NULL, nPathType);
			strCateList = link_list(vsCate);
			if(strCateList.IsEmpty())
				strCateList = "Unavailable";
			trSelEx.CategoryList.nVal = 0;
			trSelEx.CategoryList.SetAttribute(STR_COMBO_ATTRIB, strCateList);
		}
		if(1 >= nRow)
		{
			vector<string> vsXF;
			string strXFList, strSelCate;
			int nPathType = trSelEx.Load.nVal? ORIGIN_PATH_USER : ORIGIN_PATH_SYSTEM;
			trSelEx.CategoryList.GetAttribute(STR_COMBO_ATTRIB, strSelCate);
			strSelCate = strSelCate.GetToken(trSelEx.CategoryList.nVal,'|');
			int nNum = getXFList(vsXF, strSelCate, nPathType);
			strXFList = link_list(vsXF);
			if(strXFList.IsEmpty())
				strXFList = "Unavailable";
			trSelEx.FileList.nVal = 0;
			trSelEx.FileList.SetAttribute(STR_COMBO_ATTRIB, strXFList);
			break;//refresh XF list
		}
	default:
		return;
	}
	UpdatePage();
}

BOOL SetColValWizard::OnFinish(Control cntrl)
{
	int nOption = tree_get_node_by_id(m_trMain, ID_COLVAL_FIRST_PAGE).radio.nVal;
	switch(nOption)
	{
	case 0://Define new X-Function
		Tree trXFParam;
		prepareXFParamTree(trXFParam);
		break;
	case 1:
	case 2:
		string strPath = getXFPath();		
		break;
	}
	
	return ResizeGetNWiz::OnFinish(cntrl);
}
	
void SetColValWizard::ContructTree()
{	
	GETN_USE(m_trMain)
	
	GETN_BEGIN_BRANCH(Page1, "Page 1") GETN_ID(ID_COLVAL_FIRST_PAGE)
		GETN_RADIO_INDEX(radio, 0, "Define new X-Function|Load XFunction from Files|Use existing X-Functions in Project") GETN_ID(46)		
	GETN_END_BRANCH(Page1)

	GETN_BEGIN_BRANCH(Page2, "Page 2") GETN_ID(ID_COLVAL_VAR_PAGE)//ID_COLVAL_IN_VAR_NUM_PAGE)
	/*
		GETN_COMBO(InputNum, "Number of Input Variables", 1, "1|2|3|4|5")	
	GETN_END_BRANCH(Page2)

	GETN_BEGIN_BRANCH(Page3, "Page 3") GETN_ID(ID_COLVAL_IN_VAR_NAME_TYPE_PAGE)
		createInNameTypeTree(m_trMain.Page3);
	GETN_END_BRANCH(Page3)
	
	GETN_BEGIN_BRANCH(Page4, "Page 4") GETN_ID(ID_COLVAL_OUT_VAR_NAME_TYPE_PAGE)
		GETN_STR(Name, STR_VARNAME_NODE, "y")//"Variable Name", "")		///Jasmine 02/23/06
		GETN_LIST(Type, STR_VARTYPE_NODE, 3, STR_VARIABLE_TYPE_LIST)//GETN_LIST_EX(Type, "Variable Type", 3, STR_VARIABLE_TYPE_LIST) 	///Jasmine 02/21/06 REMOVE_POUND
	GETN_END_BRANCH(Page4)
	
	///Jasmine 02/22/06 INSERT_IN_VAR_DEFAULT_PAGE
	GETN_BEGIN_BRANCH(Page9, "Page 9") GETN_ID(ID_COLVAL_IN_VAR_DEFAULT_PAGE)
		createInVarDefaultTree(m_trMain.Page9);		
	GETN_END_BRANCH(Page9)
	///End INSERT_IN_VAR_DEFAULT_PAGE
	*/
		GETN_BEGIN_BRANCH(input, STR_INPUT_VAR_NODE)
			GETN_COMBO(InputNum, "Number of Input Variables", 1, "1|2|3|4|5")	
			createInputTree(m_trMain.Page2.input, 1);
		GETN_END_BRANCH(input)
		GETN_BEGIN_BRANCH(output, STR_OUTPUT_VAR_NODE)
			GETN_BEGIN_BRANCH(Variable, STR_VAR_NODE + "0")
				GETN_STR(Name, STR_VARNAME_NODE, "y")
				GETN_LIST(Type, STR_VARTYPE_NODE, 3, STR_VARIABLE_TYPE_LIST) GETN_READ_ONLY//output variable must be a vector at present
				GETN_STR(Value, STR_VARDATA_NODE, "Output to the selected column") GETN_READ_ONLY//temp
			GETN_END_BRANCH(Variable)
		GETN_END_BRANCH(output)
	GETN_END_BRANCH(Page2)
	
	GETN_BEGIN_BRANCH(Page3, "Page 3") GETN_ID(ID_COLVAL_FUNC_BODY_PAGE)
		GETN_MULTILINE_TEXT(Func, "Function Body", "")//GETN_STR(Func, "Function Body", "")		///Jasmine 02/23/06
	GETN_END_BRANCH(Page3)
	
	GETN_BEGIN_BRANCH(Page4, "Page 4") GETN_ID(ID_COLVAL_SEL_EX_FILE_PAGE)	//ID_COLVAL_SEL_EX_FILE_PATH_PAGE)
		GETN_RADIO_INDEX(Load, 0, "Load System Files|Load User Files")		
	/*
	GETN_END_BRANCH(Page6)
	
	GETN_BEGIN_BRANCH(Page7, "Page 7") GETN_ID(ID_COLVAL_SEL_EX_FILE_CATEGORY_PAGE) 
		vector<string> vsXFCate;
		list_x_functions("", "rs", "", ORIGIN_PATH_SYSTEM, LXF_NO_LT_CHECK, NULL, &vsXFCate );
		int nNum = vsXFCate.GetSize();
		string strCateList;
		if(nNum > 0)
		{
			strCateList = vsXFCate[0];
			for(int ii = 1; ii < nNum; ii++)
			strCateList = strCateList +"|"+ vsXFCate[ii];
		}
		GETN_LIST(CategoryList, "Category", 0, strCateList)	//GETN_LIST_EX(List, "List all Files", 0, "")	///Jasmine 02/21/06 REMOVE_POUND	
	GETN_END_BRANCH(Page7)
	
	GETN_BEGIN_BRANCH(Page10, "Page 10") GETN_ID(ID_COLVAL_SEL_EX_FILE_PAGE)
		vector<string> vsXF;
		string strXFList;
		if(nNum > 0)
		{
			list_x_functions("*", "", vsXFCate[0], ORIGIN_PATH_SYSTEM, LXF_NO_LT_CHECK, NULL, &vsXF);
			nNum = vsXF.GetSize();
			if(nNum > 0)
			{
				strXFList = vsXF[0];
				for(int ii = 1; ii < nNum; ii++)
					strXFList = strXFList +"|"+ vsXF[ii];	
			}
		}
		GETN_LIST(FileList, "X-Function", 0, strXFList) 		
	GETN_END_BRANCH(Page10)
	*/
		vector<string> vsCate, vsXF;
		string strCateList, strXFList;
		int nNum = getXFList(vsCate, NULL, ORIGIN_PATH_SYSTEM);
		strCateList = link_list(vsCate);
		if(strCateList.IsEmpty())
			strCateList = "Unavailable";
		GETN_LIST(CategoryList, "Category", 0, strCateList)
		if(nNum)
		{
			nNum = getXFList(vsXF, vsCate[0], ORIGIN_PATH_SYSTEM);
			strXFList = link_list(vsXF);
		}
		if(strXFList.IsEmpty())
			strXFList = "Unavailable";
		GETN_LIST(FileList, "X-Function", 0, strXFList)
	GETN_END_BRANCH(Page4)
	
	GETN_BEGIN_BRANCH(Page5, "Page 5") GETN_ID(ID_COLVAL_SEL_IN_PROJECT_PAGE)	//ID_COLVAL_SEL_IN_FILE_PAGE)
		vector<string> vsProjectXF;
		string strProjectXF;
		nNum = getXFList(vsProjectXF, NULL, ORIGIN_PATH_PROJECT);
		strProjectXF = link_list(vsProjectXF);
		if(strProjectXF.IsEmpty())
				strProjectXF = "Unavailable";
		GETN_LIST(List, "List all Files in Project", 0, strProjectXF)	//GETN_LIST_EX(List, "List all Files in Project", 0, "")	///Jasmine 02/21/06 REMOVE_POUND		
	GETN_END_BRANCH(Page5)

}

int  SetColValWizard::GetPrevPageID()
{
	switch(m_nCurrentID)
	{
	case ID_COLVAL_FIRST_PAGE:
		return -1;
		
	case ID_COLVAL_VAR_PAGE:	//ID_COLVAL_IN_VAR_NUM_PAGE:
	case ID_COLVAL_SEL_EX_FILE_PAGE:	//ID_COLVAL_SEL_EX_FILE_PATH_PAGE:
	case ID_COLVAL_SEL_IN_PROJECT_PAGE:	//ID_COLVAL_SEL_IN_FILE_PAGE:
		return ID_COLVAL_FIRST_PAGE;
	/*	
	case ID_COLVAL_IN_VAR_NAME_TYPE_PAGE:
		return ID_COLVAL_IN_VAR_NUM_PAGE;
		
	case ID_COLVAL_OUT_VAR_NAME_TYPE_PAGE:
		return ID_COLVAL_IN_VAR_NAME_TYPE_PAGE;
	*/	
	case ID_COLVAL_FUNC_BODY_PAGE:
		return ID_COLVAL_VAR_PAGE;	//ID_COLVAL_OUT_VAR_NAME_TYPE_PAGE;
	/*	
	case ID_COLVAL_IN_VAR_DEFAULT_PAGE:	///Jasmine 02/22/06 INSERT_IN_VAR_DEFAULT_PAGE 
		return ID_COLVAL_FUNC_BODY_PAGE;
		
	case ID_COLVAL_SEL_EX_FILE_CATEGORY_PAGE:
		return ID_COLVAL_SEL_EX_FILE_PATH_PAGE;
		
	case ID_COLVAL_SEL_EX_FILE_PAGE:
		return ID_COLVAL_SEL_EX_FILE_CATEGORY_PAGE;
	*/
	}
	
	return -1;
}

int  SetColValWizard::GetNextPageID()
{	
	if( ID_COLVAL_FIRST_PAGE == m_nCurrentID)
	{
		TreeNode trFirstPage = tree_get_node_by_id(m_trMain, m_nCurrentID);
		int nSel = trFirstPage.radio.nVal; 
		switch(nSel)
		{
		case SEL_FIRST_PAGE_NEW_XF:
			return ID_COLVAL_VAR_PAGE;	//ID_COLVAL_IN_VAR_NUM_PAGE;
		case SEL_FIRST_PAGE_LOAD_FROM_FILE:
			return ID_COLVAL_SEL_EX_FILE_PAGE;	//ID_COLVAL_SEL_EX_FILE_PATH_PAGE;
		case SEL_FIRST_PAGE_LOAD_FROM_PROJECT:
			return ID_COLVAL_SEL_IN_PROJECT_PAGE;	//ID_COLVAL_SEL_IN_FILE_PAGE;
		default:
			return -1;
		}
	}
	
	switch(m_nCurrentID)
	{
	/*
	case ID_COLVAL_IN_VAR_NUM_PAGE:
		return ID_COLVAL_IN_VAR_NAME_TYPE_PAGE;
		
	case ID_COLVAL_IN_VAR_NAME_TYPE_PAGE:
		return ID_COLVAL_OUT_VAR_NAME_TYPE_PAGE;
	*/	
	case ID_COLVAL_VAR_PAGE:	//ID_COLVAL_OUT_VAR_NAME_TYPE_PAGE:
		return ID_COLVAL_FUNC_BODY_PAGE;		
	/*
	case ID_COLVAL_SEL_EX_FILE_PATH_PAGE:
		return ID_COLVAL_SEL_EX_FILE_CATEGORY_PAGE;
	
	case ID_COLVAL_SEL_EX_FILE_CATEGORY_PAGE:
		return ID_COLVAL_SEL_EX_FILE_PAGE;
	
	///Jasmine 02/22/06 INSERT_IN_VAR_DEFAULT_PAGE 
	case ID_COLVAL_FUNC_BODY_PAGE:	
		return ID_COLVAL_IN_VAR_DEFAULT_PAGE;
	*/
	//the last page
	case ID_COLVAL_FUNC_BODY_PAGE:	//ID_COLVAL_IN_VAR_DEFAULT_PAGE:
	///End INSERT_IN_VAR_DEFAULT_PAGE
	case ID_COLVAL_SEL_EX_FILE_PAGE:
	case ID_COLVAL_SEL_IN_PROJECT_PAGE:	//ID_COLVAL_SEL_IN_FILE_PAGE:
		return -1;
	}		
	
	return -1; 
}

void    SetColValWizard::OnBeforeUpdatePage()
{
	/*
	TreeNode trPage = tree_get_node_by_id(m_trMain, m_nCurrentID);	
	switch(m_nCurrentID)
	{
	case ID_COLVAL_IN_VAR_NAME_TYPE_PAGE:
		TreeNode trInVarNumPage = tree_get_node_by_id(m_trMain, ID_COLVAL_VAR_PAGE);	//ID_COLVAL_IN_VAR_NUM_PAGE);
		createInNameTypeTree(trPage, trInVarNumPage.FirstNode.nVal); //Input variable number page only has one node
		break;
	///Jasmine 02/22/06 INSERT_IN_VAR_DEFAULT_PAGE
	case ID_COLVAL_IN_VAR_DEFAULT_PAGE:
		createInVarDefaultTree(trPage);
		break;
	///End INSERT_IN_VAR_DEFAULT_PAGE
	case ID_COLVAL_SEL_EX_FILE_CATEGORY_PAGE:
		onRadioChange(trPage);
		break;
	case ID_COLVAL_SEL_EX_FILE_PAGE:
		onCateListChange(trPage);
		break;
	}
	*/
}

//void 	SetColValWizard::createInNameTypeTree(TreeNode &trPage, int nNum)
void 	SetColValWizard::createInputTree(TreeNode &trPage, int nNum)
{
	/*
	//string strNamePre = "Name";
	//string strTypePre = "Type";
	*/
	TreeNodeCollection trColl(trPage, STR_VAR_NODE);//strNamePre);
	int nCount = trColl.Count();
	
	if(nCount == nNum)
		return;
	else if(nCount > nNum)
	{
		for(int ii=nNum; ii<nCount; ii++)
		{	
			//trPage.RemoveChild(strNamePre+ii);
			//trPage.RemoveChild(strTypePre+ii);
			trPage.RemoveChild(STR_VAR_NODE+ii);
		}
	}
	else
	{
		for(int ii=nCount; ii<nNum; ii++)
		{
			TreeNode trVar = tree_check_get_node(trPage, STR_VAR_NODE+ii);
			trVar.SetAttribute(STR_LABEL_ATTRIB, STR_VAR_NODE+ii);
			//TreeNode trName = trPage.AddTextNode("", strNamePre+ii, TRGP_STR);
			//trName.SetAttribute(STR_LABEL_ATTRIB,"Variable Name");
			TreeNode trName = trVar.AddTextNode("x"+ii, STR_VARNAME_NODE, TRGP_STR);
			trName.SetAttribute(STR_LABEL_ATTRIB, STR_VARNAME_NODE);
			
			//TreeNode trType = trPage.AddNumericNode(3, strTypePre+ii, TRGP_ENUM_LIST);
			//trType.SetAttribute(STR_LABEL_ATTRIB,"Variable Type");			
			TreeNode trType = trVar.AddNumericNode(3, STR_VARTYPE_NODE, TRGP_ENUM_LIST);
			trType.SetAttribute(STR_LABEL_ATTRIB, STR_VARTYPE_NODE);
			trType.SetAttribute(STR_COMBO_ATTRIB, STR_VARIABLE_TYPE_LIST);	
			
			TreeNode trData = trVar.AddTextNode("Col(1)", STR_VARDATA_NODE, TRGP_STR);//temp
			trData.SetAttribute(STR_LABEL_ATTRIB, STR_VARDATA_NODE);
		}
	}
}

void SetColValWizard::prepareXFParamTree(TreeNode& trXF)
{
	//trSetting	
	Tree trSetting;
	TreeNode trVarSetting = tree_get_node_by_id(m_trMain, ID_COLVAL_VAR_PAGE);
	string strCombo = STR_VARIABLE_TYPE_LIST;
	//input
	TreeNode trInput = tree_check_get_node(trSetting, STR_INPUT_VAR_NODE);
	TreeNode trInputVars = tree_check_get_node(trVarSetting, STR_INPUT_VAR_NODE);
    int nCount = trInputVars.InputNum.nVal;
    for(int ii = 0; ii < nCount; ii++)
    {
    	TreeNode trVal = tree_check_get_node(trInput, "v"+ii);
    	//name
    	trVal.name.strVal = trInputVars.GetNode(STR_VAR_NODE+ii).name.strVal;
    	//type,     	
    	int nSel = trInputVars.GetNode(STR_VAR_NODE+ii).type.nVal;
    	trVal.type.strVal = strCombo.GetToken(nSel,'|');
    	//valdata
		trVal.valdata.strVal = trInputVars.GetNode(STR_VAR_NODE+ii).data.strVal;
    }
	//output
	TreeNode trOutput = tree_check_get_node(trSetting, STR_OUTPUT_VAR_NODE);
	TreeNode trVal = tree_check_get_node(trOutput, "v0");
	TreeNode trOutputVars = tree_check_get_node(trVarSetting, STR_INPUT_VAR_NODE);
	trVal.name.strVal = trOutputVars.GetNode(STR_VAR_NODE+ + "0").name.strVal;
	trVal.type.strVal = strCombo.GetToken(trOutputVars.GetNode(STR_VAR_NODE+ + "0").type.nVal, '|');
	trVal.valdata.strVal = "Col(1)";// = ActivePage.SelectedCol //temp
	//code
	trSetting.code.strVal = tree_get_node_by_id(m_trMain, ID_COLVAL_FUNC_BODY_PAGE).Func.strVal;
	
	//trXF, m_paramTree in XFDialog.c
	//Tree trXF;
	trXF.Reset();
	StringArray sarrVarTypes;
	foreach( TreeNode trVar in trSetting.Input.Children )
		sarrVarTypes.Add(trVar.type.strVal);	
	foreach( trVar in trSetting.Output.Children )
		sarrVarTypes.Add(trVar.type.strVal);
	xf_construct_xfunction(trXF, "", sarrVarTypes);
	TreeNode trVars;
	okutil_xft_GetVarsNode(&trVars, &trXF, NULL);
	xf_update_var_node(trVars, trSetting);
	trXF.codes.code.strVal=trSetting.code.strVal;
	
}

string SetColValWizard::getXFPath()
{
	int nPathType;
	string strList, strXF, strCategory, strPath;
	TreeNode trList;
	if(2 == tree_get_node_by_id(m_trMain, ID_COLVAL_FIRST_PAGE).radio.nVal)//xf in project
	{
		nPathType = ORIGIN_PATH_PROJECT;
		trList = tree_get_node_by_id(m_trMain, ID_COLVAL_SEL_IN_PROJECT_PAGE).List; 
		trList.GetAttribute(STR_COMBO_ATTRIB, strList);
		strXF = strList.GetToken(trList.nVal, '|');
	}
	else
	{
		bool bUser = tree_get_node_by_id(m_trMain, ID_COLVAL_SEL_EX_FILE_PAGE).Load.nVal;
		nPathType = bUser? ORIGIN_PATH_USER : ORIGIN_PATH_SYSTEM;
		
		trList = tree_get_node_by_id(m_trMain, ID_COLVAL_SEL_EX_FILE_PAGE).CategoryList;
		trList.GetAttribute(STR_COMBO_ATTRIB, strList);
		strCategory = strList.GetToken(trList.nVal,'|');
		
		trList = tree_get_node_by_id(m_trMain, ID_COLVAL_SEL_EX_FILE_PAGE).Filelist;
		trList.GetAttribute(STR_COMBO_ATTRIB, strList);
		strXF = strList.GetToken(trList.nVal,'|');//get selected item
		//strXF = strXF.GetToken(0,'.');//remove ext
	}	
	okutil_find_file_from_map(&strPath, SUPPORTFILE_XF, nPathType, strXF, &strCategory);
	return strPath;
}

int SetColValWizard::getXFList(vector<string>& vsList, LPCSTR lpcszCate, int nPathType)// = NULL, = ORIGIN_PATH_SYSTEM
{
	/*doing ...
	vsList.SetSize(0);
	if(ORIGIN_PATH_PROJECT == nPathType)	
		return;	//doing
	string strCate = lpcszCate;
	if(strCate.IsEmpty())//find category
	{
		TreeNode trXFCateList = tree_get_node_by_id(m_trXFList, nPathType);
		if(!trXFList.IsValid)//construct now
		{
			GETN_USE(m_trXFList)
			string strBranch = "System";
			if(ORIGIN_PATH_USER == nPathType)
				strBranch = User;
			trXFCateList = tree_check_get_node(m_trXFList, strBranch, nPathType);
			vector<string> vsCategory;
			list_x_functions("", "rs", "", nPathType, 0, NULL, &vsCategory);
			int nNum = vsCategory.GetSize();
			for(int ii = 0; ii < nNum; ii++)
				tree_check_get_node(trXFCateList, vsCategory[ii], ii, STR_LABEL_ATTRIB, vsCategory[ii]);			
		}
		for(TreeNode cNode = trXFList.FirstNode; cNode.IsValid(); cNode = cNode.NextNode)
		{
			string strCategory;
			cNode.GetAttribute(STR_LABEL_ATTRIB, strCategory);
			vsList.Add(strCategory);
		}
		return vsList.GetSize();		
	}
	//find XF of one category. assume the category is in m_trXFList
	TreeNode trCate = m_trXFList.GetNode(strCate);
	if(trCate.IsValid())
	*/	
	//temp
	vsList.SetSize(0);
	get_xf_list(vsList, lpcszCate, nPathType);
	return vsList.GetSize();
}

string link_list(vector<string>& vsItem, string strSeparator = "|")
{
	int nSize = vsItem.GetSize();
	if(!nSize)
		return "";
	string strList = vsItem[0];
	for(int ii = 1; ii < nSize; ii++)
		strList = strList + strSeparator + vsItem[ii];
	return strList;
}
//temp
int get_xf_list(vector<string>& vsResult, LPCSTR lpcszCate = NULL, int nPathType = ORIGIN_PATH_UNDEF)
{
	NOTIFY_XF_FILE_CHANGE
	vector<string> vsName;
	vsResult.SetSize(0);
	DWORD nXFUsage = IDXF_USGCTXT_LABTALK;
	int nNumFiles;
	if(ORIGIN_PATH_PROJECT == nPathType)//get xf in project
	{
		nNumFiles = okutil_find_files_from_map(&vsName, NULL, SUPPORTFILE_XF, FF_USE_C_NAMES, &nXFUsage, 1, NULL,  NULL, nPathType, XF_VARS_SET_COL_VALUES);
		vsResult = vsName;
		return vsResult.GetSize();
	}
	
	nNumFiles = okutil_find_files_from_map(&vsName, NULL, SUPPORTFILE_XF, FF_CATEGORY_LIST, &nXFUsage, 1, NULL,  NULL, nPathType, XF_VARS_SET_COL_VALUES);
	string strCategory = lpcszCate;
	if(strCategory.IsEmpty())//get category list
	{
		for(int ii = 0; ii < nNumFiles; ii++)
		{
			string strCate = vsName[ii].GetToken(0, ':');
			int nPost = strCate.Find(")");
			if(nPost > -1)//don't know why strCate.GetToken(1, ')') doesn't work...
				strCate = strCate.Right(strCate.GetLength() - nPost - 1);
			strCate.TrimLeft(); 
			strCate.TrimRight();
			if(-1==vsResult.Find(strCate))
				vsResult.Add(strCate);
		}
		return vsResult.GetSize();
	}
	//get Ex xf list
	for(int ii = 0; ii < nNumFiles; ii++)
	{
		string strCate = vsName[ii].GetToken(0, ':');
		int nPost = strCate.Find(")");
		if(nPost > -1)//don't know why strCate.GetToken(1, ')') doesn't work...
			strCate = strCate.Right(strCate.GetLength() - nPost - 1);
		strCate.TrimLeft(); 
		strCate.TrimRight();
		if(strCategory.CompareNoCase(strCate))
			continue;
		string strXF = vsName[ii].GetToken(1, ':');
		strXF.TrimLeft(); 
		strXF.TrimRight();
		if(-1==vsResult.Find(strXF))
			vsResult.Add(strXF);
	}
	return vsResult.GetSize();	
}


void open_getn_wiz(bool bMultiPanel = false, bool bShowList = false)
{
	SetColValWizard dlg(bMultiPanel, bShowList);
	out_int("", dlg.DoModalEx(GetWindow()));
}

	
//-----------------------------------------------------------------
// interface to Origin internal, better same as filename
int SetColValWiz(int nMsg, DWORD dwCntrl = 0, LPVOID lpData = NULL)
{
	SetColValWizard dlg;
	return dlg.DoModalEx(GetWindow(OGW_MDICLIENT));
}
//-----------------------------------------------------------------

