/*------------------------------------------------------------------------------*
 * File Name: ScriptWindow.h													*
 * Creation: CPY 7/30/05														*
 * Purpose: Script Window for LT commands				 						*
 * Copyright (c) OriginLab Corp.	2005										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 8/3/05 KEY_UP_DOWN_BUFFER												*
 *	CPY 8/4/05 PROPER_MULTIPLE_CMDS												*
 *  Iris 8/05/05 ADD_CONTEXT_MENU												*
 *  Iris 8/08/05 SUPPORT_SELECTION_EXECUTE										*
 *	CPY 8-1-05 QA70-7956 DBCLK_HISTORY_PANE										*
 *	CPY 8/10/05 CMD_BUFFER_MOVED_TO_CMD_CONTROL									*
 *	CPY 8/10/05 HISTROY_WIN_REPLACED_BY_CODE_EDIT								*
 *	CPY 8/17/05 AUTO_COMPLETE_HOOK												*
 *	ML 9/14/2005 CANNOT_COMPILE													*
 *  Jasmine 9/16/05 START_BY_RIGHT_ARROW										*
 *	Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU									*
 *	CPY QA70-8243 10/31/05 CNTRL_ENTER_NOT_TO_ADD_SEMI							*
 *  Iris 11/9/05 QA70-8278-P3 SIGNAL_CLICK_TO_SELECT_HISTORY_CMD				*
 *	CPY 3/25/06 SPLITTER_INIT_SIZE_NOT_CALL                                     *	
 *  Joe  4/17/06   SHOW_CURRENT_TIME                                            *
 *  Joe  4/24/06  SET_NORMAL_TIME_PATH_PROMPT                                   *
 *  Jasmine 04/28/06 SEPARATE_TWO_POPUP_MENU					                *
 *  Joe  5/19/06  AUTOCOMPLETE_CONTROL_CLASS                                    *
 *  Joe  5/23/06  SPLITTER_HORIZONTALLY_VERTICALLY                              *
 *  Joe  6/14/06    QA70-8601 P6 ON_PASTE_PROMPT_HIDE                           *
 *  Joe  6/20/06    QA70-8601-P2 SAVE_ALL_OGS                                   * 
 *  Joe  7/11/06  	AUTOCOMPLETE_GLOBALFUNCTION_USED                            *
 *  Joe  7/18/06  	UP_DOWN_KEY_SHOW                                            *         
 *  Joe  7/19/06    QA70-8601 P4 BREAK_OFF_ADD_HISTORY_CMD						*
 *  Iris 8/04/06	LET_ONE_LINE_MUL_CMDS_WORK									*
 *  Joe  8/18/06	ADD_CMD_TO_HISTORY_PANE_ON_CMD_ERROR 	                    *	        
 *  Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU								*	
 *  Joe  8/29/06	ROLLBACK_AND_MODIFY_UPDOWN_KEY								*
 *	Joseph 01/05/07 CHANGE_NODE_NAME											*
 *	Folger 11/13/07 LOCALIZE_COMMAND_WINDOW_PREFERENCE							*
 *	Folger 12/11/09 QA81-14831-P1 LT_USE_OC_GETN_SUPPRESS_ERROR_WHEN_USER_CANCEL*
 *	Sophy 2/26/2010 QA81-12697-P4 OC_OUTPUT_TO_CMD_WND_SHOULD_BELOW_LAST_CMD	*
 *------------------------------------------------------------------------------*/
#include "CmdControl.h"
//#include "ACBase.h"              ///Joe  5/19/06  AUTOCOMPLETE_CONTROL_CLASS   ///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED
#define WM_USER_HISTORY_ADD_CMD  		(WM_USER +1030)
#define WM_USER_HISTORY_EXECUTE			(WM_USER +1031)
#define WM_USER_CMD_UP_KEY      		(WM_USER +1040)
#define WM_USER_CMD_DOWN_KEY    		(WM_USER +1041)
//#define IDC_AUTO_COMPLETE_MENU_BEGIN 	3000	///Jasmine 04/28/06 SEPARATE_TWO_POPUP_MENU
#define IDC_PROMPT_MENU_BEGIN 			(OC_MENURANGE_BEGIN + 1000)
#define IDC_SPLITTER_MENU_BEGIN         (IDC_PROMPT_MENU_BEGIN + 1000) ///Joe  5/23/06  SPLITTER_HORIZONTALLY_VERTICALLY
#define STR_HISTORY_FILENAME	GetAppPath(0) + "LTHistory.txt"
#define COLOR_COMMENT	RGB(0,128,0)
//--- CPY 8/4/05 PROPER_MULTIPLE_CMDS
#define KEY_MULTI_CMDS	(CNTRL_DOWN || SHIFT_DOWN) // support both Origin and Matlab
//----
///Joe  8/29/06	ROLLBACK_AND_MODIFY_UPDOWN_KEY
//------ Folger 11/13/07 LOCALIZE_COMMAND_WINDOW_PREFERENCE
//#define STR_PROMPT_STATE  "Prompt"
#define STR_PROMPT_STATE  _LE("Prompt")
//------ End LOCALIZE_COMMAND_WINDOW_PREFERENCE
#define STR_CMDWIN_PREFENCE	"CmdWindow Preference"
#define STR_FAILCMD_SHOW "ShowErrCmd"
#define STR_DUPLCMD_SHOW "ShowDuplicate"
#define STR_AUTOCOMPLETE_STATE "AutoComplete"
//the history panel time format "//--2006-12-4" then length of the time tag ("//--") is 4.

///Joseph 12/02/06	UPDOWN_KEY_LOAD_HISTORY
#define	TIME_TAG_LENGTH	4  
#define HISTORY_TIME_TAG 	"//--"
///End UPDOWN_KEY_LOAD_HISTORY

#define NUM_REGISTER_MIN_VAL -2
///End ROLLBACK_AND_MODIFY_UPDOWN_KEY
//---- CPY 5/25/06 HIST_PANE_POSITION_RESTART_WHEN_CLOSE_FROM_CMD_BAR_X
static BOOL s_bUserChangedHistoryPanePositionState = false; // when user click the x to close cmd window, it is merely hidden
//-----

#define  STR_DLG_NAME		_L("Command Window") /// Hong 11/07/07 v8.0742 MORE_LOCALIZED

///Joe  5/19/06  AUTOCOMPLETE_CONTROL_CLASS
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////                                ////////////////////////
/////////////////////////the Class AutoCompleteControl   ////////////////////////
/////////////////////////                                ////////////////////////
/////////////////////////////////////////////////////////////////////////////////
void vs_delelte_token(vector<string>& vsTemp,LPCSTR lcpszSep)
{
	int nVsSize = vsTemp.GetSize();
	for(int ii=0; ii<nVsSize; ii++)
		vsTemp[ii].Replace(lcpszSep, "");
}

class AutoCompleteCmdControl : public CmdControl
{
public:
	
	AutoCompleteCmdControl()
	{
		m_nAutoCompleteStart = -1;
		//m_pACobj = NULL;      ///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED
		m_bAutoCompleteBackSpace = false;
	}
	
    bool IsInAutoCompleteMode() { return m_nAutoCompleteStart >=0? true:false;}
    
    void OnAutoCompleteClose(Window& wndToNotify, int nStart, int nEnd);
	
	bool OnAutoCompleteDoneReplaceSel(int nStart, int nEnd);
	
	bool OnAutoCompleteGetHelpInfo(int nIconID, LPCSTR lpcszSrc, string& strDisplay);

	void OnAutoComplete(int nStart= -1 , int nCurrent = -1, UINT nCharCmd = 0);

    void ResetAutoComplete();
    
    bool OnNotCmdKey(UINT msg, UINT wParam, UINT lParam, int nStart, int nEnd, int nSel);
    
    void OnBackSpaceCmd(int nEnd);
    
    bool  OnLeftRightCmd(int nStart, int nEnd, UINT wParam);

	//bool IsCharStartAutoComplete(UINT nCharCmd); ///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED

	int		GetAutoCompleteState(){ return m_nAutoCompleteState;}

    void	SetAutoCompleteState(int nState){m_nAutoCompleteState = nState;}
///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED
	//string		GetCurrentACObjectName()
	//{
		//string str = "NULL";
//
       	//str = ac_get_classname();
		//return str;
	//}
//
	//ACBase*		GetACObject() {return m_pACobj;}

	//bool	SetACObject(ACBase* pACobj);
//
	//void	ClearAllACObjects()
	//{
		//if(m_pACobj)
			//delete m_pACobj;
		//
		//m_pACobj = NULL;
	//}
///End AUTOCOMPLETE_GLOBALFUNCTION_USED
	virtual bool CheckStartAutoComplete(UINT nCharCmd, int nStart, int nEnd);

   	void CloseAutoComplete()
	{
		DebugMsg("CloseAutoComplete");
		vector<string> vsNames;
		AutoComplete(-1, vsNames);	// to close autocomplete window
	}
	
private:
	int		m_nAutoCompleteStart;
	bool	m_bAutoCompleteBackSpace;
	
	int		m_nAutoCompleteState;
	//ACBase*	m_pACobj;  ///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED
};
///End  AUTOCOMPLETE_CONTROL_CLASS
///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////

///Joe  5/19/06  AUTOCOMPLETE_CONTROL_CLASS
//class LTCmdControl : public CmdControl
class LTCmdControl : public AutoCompleteCmdControl
///End  AUTOCOMPLETE_CONTROL_CLASS
{
public:
	LTCmdControl()
	{
    ///Joe  4/24/06  SET_NORMAL_TIME_PATH_PROMPT   add a new Prompt type to show the current path
    //  m_bPromptUseTime = false;//true; //--CPY 8/17/05 TIME_PROMPT
    ///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
		//SetPromptState(SHOW_NORMAL); 
	///End ADD_PREFERENCE_ON_CONTEXT_MENU
	///End SET_NORMAL_TIME_PATH_PROMPT
	}
	void OnSetFocus()
	{
	}
	///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
	void SetErrCmdOnHisPane(bool bCheck = true)
	{
		b_showErrCmdHisPane = bCheck;
	}
	///End ADD_PREFERENCE_ON_CONTEXT_MENU
	///Joe  7/19/06    QA70-8601 P4 BREAK_OFF_ADD_HISTORY_CMD		 
private:
	void cmdSepTrim(string& str, const string strSep, string& strSec)
	{
			int nLineIndex = str.Find(strSep);
			if(nLineIndex < 0)
				strSec = str;
			else
				strSec = str.Mid(0,nLineIndex);
			str.TrimLeft(strSec);
			str.TrimLeft(strSep);
	}
	
	void executeCmdSec(string& strCmdLine, bool& bErrorFlag)
	{
		while(strCmdLine.GetLength() > 0)
		{
			string strTempCmdSec;
			string strSep = ";";
			cmdSepTrim(strCmdLine, strSep, strTempCmdSec);
			if(Execute(strTempCmdSec))
			{
				Window Wnd = GetParent();
				if(Wnd)
					Wnd.SendMessage(WM_USER_HISTORY_ADD_CMD);
			}
			else
			{
				bErrorFlag = false;
			}
		}
	}
	///End BREAK_OFF_ADD_HISTORY_CMD
protected:
	//virtual 
	void OnCmd(const string& strCmd, bool bAddNewLine = true)
	{ 	
		if(bAddNewLine)
			WriteLine();
		/// Iris 8/04/06 LET_ONE_LINE_MUL_CMDS_WORK
		/////Joe  7/19/06    QA70-8601 P4 BREAK_OFF_ADD_HISTORY_CMD
		////if(Execute(strCmd))
		////{
			////Window Wnd = GetParent();
			////if(Wnd)
				////Wnd.PostMessage(WM_USER_HISTORY_ADD_CMD);
		////}
		//bool bErrorFlag = true;
		//string strCmdTemp = strCmd;
		//string strSep;
		//for(;strCmdTemp.GetLength()>0;)
		//{
			//strSep = "\r\n";
			//string strCmdLine;
			//
			//cmdSepTrim(strCmdTemp, strSep, strCmdLine);
			//executeCmdSec(strCmdLine,bErrorFlag);
			//
			//if(! bErrorFlag)
				//break;
		//}
		/////End BREAK_OFF_ADD_HISTORY_CMD
		///Joe 8/18/06	ADD_CMD_TO_HISTORY_PANE_ON_CMD_ERROR
		//if(Execute(strCmd))
		//{
		///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
		if(Execute(strCmd) || b_showErrCmdHisPane)
		{
		///End ADD_PREFERENCE_ON_CONTEXT_MENU
			Window Wnd = GetParent();
			if(Wnd)
				Wnd.PostMessage(WM_USER_HISTORY_ADD_CMD);
		} ///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
		///End ADD_CMD_TO_HISTORY_PANE_ON_CMD_ERROR
		///end LET_ONE_LINE_MUL_CMDS_WORK
		ShowPrompt();	
	}
	//virtual 
	string 	GetPrompt()
	{
		string strPromptPrefix = ">";
		///Joe  4/24/06  SET_NORMAL_TIME_PATH_PROMPT   add time and pathrompt
		//if(m_bPromptUseTime)
		//{
			//SYSTEMTIME st;
			//get_current_time(st);
			//strPromptPrefix.Format("%.2u:%.2u", st.wHour,st.wMinute);
		//}
		int iPromptState = GetPromptState();
		if(iPromptState == SHOW_TIME)
		{
			SYSTEMTIME st;
			get_current_time(st);
			strPromptPrefix.Format("%.2u:%.2u", st.wHour,st.wMinute);
		}
		else if(iPromptState == SHOW_PATH)
		{
			/// Iris 6/05/06 SET_WORK_DIR_AS_HISTORY_SAVE_PATH
			//INIFile ini("origin.ini");
			//strPromptPrefix = ini.ReadString("Config","CurrentWorkingDirectory");
			strPromptPrefix = get_current_working_directory();
			///End SET_WORK_DIR_AS_HISTORY_SAVE_PATH
		}
		else if(iPromptState != SHOW_NORMAL)
		{
			return strPromptPrefix;
		}
		///End SET_NORMAL_TIME_PATH_PROMPT
		return strPromptPrefix + ">"; 
	}

	//virtual 
	bool	GetPromptColor(COLORREF& cr, bool& bBold, bool& bUnderline, bool& bStrikeOut)
	{
		///Joseph	12/01/06	QA70-8278	CHANGE_PROMPT_COLOR
		//cr = RGB(255,0,255);
		cr = RGB(0, 128, 255);
		//bBold = false;
		bBold = true;
		///End CHANGE_PROMPT_COLOR
		bUnderline = false;
		bStrikeOut = false;
		return true;
	}
	

	//--- Iris 8/04/05 SUPPORT_MULTI_LINE, overload this function since ctrl+enter will not return and show prompt in Matlab console
	virtual bool OnEnterKey(int nStart, int nEnd)
	{
		char cLastBeforeTrim = 0;//-------- CPY 8/16/05 MULTI_LINE_EXECUTE_SHOULD_NOT_NEED_SEL
		//bool bSelected = !IsSelEmpty();  //---Iris 8/08/05 SUPPORT_SELECTION_EXECUTE  ///Iris 8/24/05 INCORRECT_CHANGE_BEFORE
		//--- CPY 8/4/05 PROPER_MULTIPLE_CMDS
		char cLastChar = GetLastChar(true, &cLastBeforeTrim);
		
		///Iris 8/24/05 INCORRECT_CHANGE_BEFORE
		//---Iris 8/08/05 SUPPORT_SELECTION_EXECUTE
		//if(KEY_MULTI_CMDS && cLastChar != ';')
		//if(KEY_MULTI_CMDS && cLastChar != ';' || bSelected && cLastChar != ';')
		bool bMultiCmds = false;  ///Iris 9/14/05 QA70-8101 ADD_CONTROL_OUTPUT_RESULT_TREE_OR_NOT
		/// Iris 11/08/05 QA70-8243-P1 NO_NEED_CHECK_LAST_CHAR_FOR_MULTI_CMD
		//if(KEY_MULTI_CMDS && cLastChar != ';')
		if(KEY_MULTI_CMDS)
		{
			//------- CPY QA70-8243 10/31/05 CNTRL_ENTER_NOT_TO_ADD_SEMI
			//Write(";");
			//cLastBeforeTrim = ';';
			/// Iris 11/08/05 QA70-8243-P1 NO_NEED_CHECK_LAST_CHAR_FOR_MULTI_CMD
			//if(SHIFT_DOWN)
			if(SHIFT_DOWN && cLastChar != ';')
			{
				Write(";");
				cLastBeforeTrim = ';';
			}
			//-------
			
			bMultiCmds = true;
		}
		//----	
		WriteLine(); 
		
		//if(cLastChar != ';')  // if press ctrl+enter or already terminated with ';', not execute commond, only return and show prompt
		//-------- CPY 8/16/05 MULTI_LINE_EXECUTE_SHOULD_NOT_NEED_SEL
		// for multiple lines, we should allow user to type multiple lines and hit enter to execute, or they can type multiple lines and sel all and execute
		//if(cLastChar != ';' ||  bSelected) //---Iris 8/08/05 SUPPORT_SELECTION_EXECUTE, if select one or multi line and press enter, then should execute even if there is ';' at the end of the block
		///Iris 9/14/05 QA70-8101 ADD_CONTROL_OUTPUT_RESULT_TREE_OR_NOT
		//if(cLastBeforeTrim != ';')
		if( !bMultiCmds )
		//End ADD_CONTROL_OUTPUT_RESULT_TREE_OR_NOT
		//--------
		{	
			string strCmd = GetCmdLine();
			OnCmd(strCmd, false);
			AddCmdBuffer(strCmd);//----- CPY 8/10/05 CMD_BUFFER_MOVED_TO_CMD_CONTROL 
			//ShowPrompt();
		}
		return TRUE;
	}
///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
public:
	bool GetPreference(TreeNode& trNode ,int nPromptVal = 1, int nAutoCompleteVal = 0 ,bool bShowDuplicate = true ,bool bErrCmdOnHisPane = true)
	{
		bool bResult = false;
		GETN_TREE(tr)
		GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
		//------ Folger 11/13/07 LOCALIZE_COMMAND_WINDOW_PREFERENCE
		//GETN_BEGIN_BRANCH( AutoComplete, "Auto Complete" )
		GETN_BEGIN_BRANCH( AutoComplete, _L("Auto Complete") )
		//------ End LOCALIZE_COMMAND_WINDOW_PREFERENCE
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)   ///Joseph	12/01/06	OPEN_THE_PREFERNCE_BRANCH
			//------ Folger 11/13/07 LOCALIZE_COMMAND_WINDOW_PREFERENCE
			//GETN_RADIO_INDEX(ac, nAutoCompleteVal, "Start by Arrow Key|Off|Start Automatically" ) 
			GETN_RADIO_INDEX(ac, nAutoCompleteVal, _L("Start by Arrow Key|Off|Start Automatically") ) 
			//------ End LOCALIZE_COMMAND_WINDOW_PREFERENCE
			GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)
		GETN_END_BRANCH( AutoComplete )
		
		//------ Folger 11/13/07 LOCALIZE_COMMAND_WINDOW_PREFERENCE
		//GETN_BEGIN_BRANCH( Prompt, STR_PROMPT_STATE )
		GETN_BEGIN_BRANCH( Prompt, GetLocalized(STR_PROMPT_STATE) )
		//------ End LOCALIZE_COMMAND_WINDOW_PREFERENCE
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Joseph	12/01/06	OPEN_THE_PREFERNCE_BRANCH
			GETN_RADIO_INDEX(pmpt, nPromptVal, " >>| Time>| cd Path>" ) 
			GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)
		GETN_END_BRANCH( Prompt )
		
		///Joseph 01/05/07 CHANGE_NODE_NAME
		//GETN_BEGIN_BRANCH( AddHisCmd, "Add to Command History" ) 
		//------ Folger 11/13/07 LOCALIZE_COMMAND_WINDOW_PREFERENCE
		//GETN_BEGIN_BRANCH( AddHisCmd, "Command History" ) 
		GETN_BEGIN_BRANCH( AddHisCmd, _L("Command History") ) 
		//------ End LOCALIZE_COMMAND_WINDOW_PREFERENCE
		///End CHANGE_NODE_NAME
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Joseph	12/01/06	OPEN_THE_PREFERNCE_BRANCH
			///Joseph 01/05/07 CHANGE_NODE_NAME
			//GETN_CHECK(AddDupCmdOnHisPane,"Add Duplicate Commands to History", bShowDuplicate);
			//GETN_CHECK(AddErrCmdOnHisPane,"Add Failed Commands to History", bErrCmdOnHisPane);
			//------ Folger 11/13/07 LOCALIZE_COMMAND_WINDOW_PREFERENCE
			//GETN_CHECK(AddDupCmdOnHisPane,"Save consecutive duplicate commands", bShowDuplicate);
			//GETN_CHECK(AddErrCmdOnHisPane,"Save failed commands", bErrCmdOnHisPane);
			GETN_CHECK(AddDupCmdOnHisPane,_L("Save consecutive duplicate commands"), bShowDuplicate);
			GETN_CHECK(AddErrCmdOnHisPane,_L("Save failed commands"), bErrCmdOnHisPane);
			//------ End LOCALIZE_COMMAND_WINDOW_PREFERENCE
			///End CHANGE_NODE_NAME
			GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)
		GETN_END_BRANCH( AddHisCmd )

		//------ Folger 11/13/07 LOCALIZE_COMMAND_WINDOW_PREFERENCE
	   	//if(GetNBox(tr, "Preference", "Preference Setting", NULL, NULL))
	   	if(GetNBox(tr, _L("Preference"), _L("Preference Setting"), NULL, NULL))
	   	//------ End LOCALIZE_COMMAND_WINDOW_PREFERENCE
	   	{
	   		trNode = tr.Clone();
	   		bResult = true;
	   	}	   	
	   	return bResult;
	}
///End ADD_PREFERENCE_ON_CONTEXT_MENU	
protected:
	//-------- CPY 8/10/05 CMD_BUFFER_MOVED_TO_CMD_CONTROL
	//virtual
	void TrimCmdSeparator(string& strCmd)
	{
		int nPos;
		if(str_end_char(strCmd, &nPos) == ';') // this should always be true
			strCmd = strCmd.Left(nPos);
	}
	//virtual
	void CheckAddCmdSeparator(string& strCmd)
	{
		if(str_end_char(strCmd) != ';')
			strCmd += ';';
	}
	//-------- end CPY 8/10/05
	
	//	virtual 
	void OnShowPrompt()//---- CPY 9/9/05 AUTO_COMPLETE_OBJ
	{
		///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED/
		//ACBase* pACobj = new ACUnknown;
		ac_init(); 
		///End AUTOCOMPLETE_GLOBALFUNCTION_USED
	}
public:


	bool Execute(LPCSTR lpcszCmd)
	{
		string strCmdCopy = lpcszCmd;
		TrimCmd(strCmdCopy);
		if(strCmdCopy.IsEmpty())
			return false;
		bool bRet = false;
		HWND hWndOutputOld = set_LT_script_window(GetSafeHwnd());
		
		///Iris 9/15/05 QA70-8101 ADD_CONTROL_OUTPUT_RESULT_TREE_OR_NOT
		//if command end with ';' will not print calcution result, else print, just like Matlab
		//if(!LT_execute(strCmdCopy))
		int nCtrl = (str_end_char(strCmdCopy)==';') ? 0: LTXF_DUMP_OUTPUT_TREE;		
		///------ Folger 12/11/09 QA81-14831-P1 LT_USE_OC_GETN_SUPPRESS_ERROR_WHEN_USER_CANCEL
		//if(!LT_execute(strCmdCopy, nCtrl))
		/////ADD_CONTROL_OUTPUT_RESULT_TREE_OR_NOT
		//{
			//int index = WriteLine("#Command Error!");
		int		nErr = LTEXECUTE_ERROR_NONE;
		if ( !LT_execute(strCmdCopy, nCtrl, &nErr) )
		{
			string		strErr;
			switch ( nErr )
			{
			case LTEXECUTE_ERROR_USER_ABORT:
				strErr = "#User Abort!";
				break;

			default:
				strErr = "#Command Error!";
				break;
			}
			int		index = WriteLine(strErr);
		///------ End LT_USE_OC_GETN_SUPPRESS_ERROR_WHEN_USER_CANCEL
			SetLineColor(index, COLOR_RED);
			//-------- CPY 8/10/05 CMD_BUFFER_MOVED_TO_CMD_CONTROL
			//strCmd = (string) "#" + strCmd;//--- CPY 8/4/05 ERR_CMD_ALSO_ALLOW_ROLL_BACK
			//--------
		}
		else
		{
			CheckAddCmdSeparator(strCmdCopy);
			//-------- CPY 8/10/05 CMD_BUFFER_MOVED_TO_CMD_CONTROL, put to history only if not err
			bRet = true;
			SetCmd(strCmdCopy); // was for both, moved here so only if success execution
			//--------
		}		
		set_LT_script_window(hWndOutputOld);
		SetFocus(GetSafeHwnd());  /// Joe 4/12/06  set the focus on command window after execute the comand.
		return bRet;
	}
	bool ExecuteExternalCmd()
	{
		bool bClearTemp = ClearSaveTempCmd(); //clear and save the command after prompt
		
		//get and check command
		string strCmd = GetCmd();
		TrimCmd(strCmd);
		if(strCmd.IsEmpty())
			return false;	
		
		//show the current command after prompt
		CheckAddCmdSeparator(strCmd);   //if the command is not end with ; then add it
		ReplaceAfterPrompt(strCmd);		
		//------- CPY 8/13/05 EXECUTE_HISTORY_NEEDED_TO_ADD_TO_HISTORY
		//WriteLine();
		//Execute(strCmd);
		//ShowPrompt();
		OnCmd(strCmd);
		//------
		if(bClearTemp) //If clear the original command, the restore it after execution
			RestoreTempCmd();
		
		SetFocus(GetSafeHwnd());//------- CPY 8/13/05 EXECUTE_HISTORY_NEEDED_TO_ADD_TO_HISTORY
		return true;
	}
	bool ClearSaveTempCmd()
	{
		m_strTempCmd = GetCmdAfterPrompt();
		if(m_strTempCmd.IsEmpty())
			return false;
		
		ReplaceAfterPrompt(_L(""));
		return true;
	}
	void RestoreTempCmd()
	{
		ReplaceAfterPrompt(m_strTempCmd);
	}
	//---- CPY 8/17/05 AUTO_COMPLETE_HOOK
	//virtual 
	// nStart<0 to clear
	// nCurrent < 0 assume already up and just to update
private:
	//int addXFvarList(const string& strCmd, vector<string>& vsNames, vector<int>& vnTypes);
	//int addXFList(const string& strCmd, vector<string>& vsNames, vector<int>& vnTypes);
	//----
	
private:
	string 	m_strTempCmd; //---Iris 8/10/05, the cmd on command window, but not be executed.
	//bool	m_bPromptUseTime; //--CPY 8/17/05 TIME_PROMPT   ///Joe  4/24/06  SET_NORMAL_TIME_PATH_PROMPT add a new type prompt,path;
	bool	b_showErrCmdHisPane;  ///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
};   




#define STR_HISTORY_CMD_PRE					"  "
#define STR_LT_COMMENT_PREFIX				"//"

class HistoryControl : public CodeEdit //CmdControl  CPY 8/10/05 HISTROY_WIN_REPLACED_BY_CODE_EDIT
{

public:
	///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
	HistoryControl()
	{
		m_showDupCmdOnHisPane = true;
	}
	///End ADD_PREFERENCE_ON_CONTEXT_MENU
	void AddCmd(const string& strCmd)
	{
		string strCmdLine = strCmd;
		///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
		//int index = WriteLine(strCmdLine);
		string strTempCmd(strCmd);
		if(! strTempCmd.Compare("\r\n"))
			return;
		if(! m_showDupCmdOnHisPane )
		{
			int nLastLineIndex;
			vector<string> vsCmd;
			str_separate(strTempCmd, "\r\n", vsCmd);			
			string strLastHisCmd = findLastHisCmd();
			int nLastCmdLength = strLastHisCmd.GetLength();
			if( nLastCmdLength > 0)
				vsCmd.InsertAt(0, strLastHisCmd);
			vector<string> vsTemp;
			vsTemp = vsCmd;
			vs_delelte_token(vsTemp ,";");
			int nVsCmdSize = vsCmd.GetSize();
			
			for(int ii = 0; ii < nVsCmdSize - 1; ii++)
			{
				if(! vsTemp[ii].CompareNoCase(vsTemp[ii+1]))
				{
					vsCmd.RemoveAt(ii+1);
					vsTemp.RemoveAt(ii+1);
					ii--;
				}
				nVsCmdSize = vsCmd.GetSize();
			}
			if(nLastCmdLength > 0)
				vsCmd.RemoveAt(0);
			strCmdLine = str_combine(vsCmd, "\r\n");
		}
		if(! strCmdLine.IsEmpty())
			WriteLine(strCmdLine);
		///End ADD_PREFERENCE_ON_CONTEXT_MENU
	}	
	//virtual
	void OnInit();
	bool Save()   
	{
		return Save(STR_HISTORY_FILENAME);
	}
public:
	// following codes duplicated, need to be moved to base class in VC level later
	bool IsSelEmpty()
	{
		int nBegin, nEnd;
		GetSel(nBegin, nEnd);
		if(nBegin == nEnd)
			return true;
		
		return false;
	}
	
	bool OnClear()
	{
		if(IsSelEmpty()) ///Iris 8/15/05, if not selection, then clear all, else clear selected text
		{
			if(IDOK == MessageBox(GetSafeHwnd(), _L("Are you sure?"), _L("History Log"), MB_OK|MB_OKCANCEL|MB_ICONQUESTION)) 
			{  
				Reset();
				showCurrentTime(); ///Joe  4/17/06  QA70-8061-P3 after clearing the history window,show the current time
				//GetCmdVecBuffer();	///Joe  7/18/06  UP_DOWN_KEY_SHOW  ///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
				return true;
			}
		}
		else
		{
			ReplaceSel("");
			//GetCmdVecBuffer();	///Joe  7/18/06  UP_DOWN_KEY_SHOW ///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
			return true;
		}
		return false;
	}	
	///Joe  6/20/06    QA70-8601-P2 SAVE_ALL_OGS
	///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
	void ShowDupCmdOnHisPane(bool bShowDuplicate)
	{		
		if(bShowDuplicate)
			m_showDupCmdOnHisPane = true;
		else
			m_showDupCmdOnHisPane = false;
	}
	///End ADD_PREFERENCE_ON_CONTEXT_MENU
private:
	bool saveAsOgs(LPCSTR lpHisCmd)
	{
		string strCmd(lpHisCmd);
		string strPath;
		StringArray saFiletypes;
		saFiletypes.SetSize( 1 );
		saFiletypes[0] = "[Origin LabTalk Script File (*.ogs)] *.ogs";
		/// Iris 6/05/06 SET_WORK_DIR_AS_HISTORY_SAVE_PATH
		//strPath = GetSaveAsBox( saFiletypes, GetAppPath() );
		strPath = GetSaveAsBox( saFiletypes, get_current_working_directory() );
		///End SET_WORK_DIR_AS_HISTORY_SAVE_PATH
		//--- CPY 4/10/06 CMD_WINDOW_HISTORY_LOG_SAVING
		//return Save(strPath);
		//string strCmd = GetSelText();
		int nSize = strCmd.GetLength();
		if(nSize > 1)
		{
			file ff;
			if(ff.Open(strPath, file::modeWrite | file::shareExclusive | file::modeCreate))
			{
				char* 	pText = strCmd.GetBuffer(nSize+1);
				ff.Write(pText, nSize);
				strCmd.ReleaseBuffer();
				ff.Flush();
				ff.Close();
				return true;
			}
		}
		return false;
		//---
	}
	///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
	string findLastHisCmd()
	{
		int nLineCount = GetLineCount();
		for(int ii = nLineCount - 1; ii >= 0; ii--)
		{
			string strLastCommand = GetLine(ii);
			strLastCommand.TrimRight();
			strLastCommand.TrimRight("\r\n");
			int nLineLength = strLastCommand.GetLength();
			if(nLineLength > 0)
			{
				return strLastCommand;
			}
		}
		return "";
	}
	///End ADD_PREFERENCE_ON_CONTEXT_MENU
				
public:
	bool OnSaveAs()
	{
		string strCmd = GetSelText();
		return saveAsOgs(strCmd);
	}
	
	bool OnSaveAll()
	{
		string strCmd = Text;
		return saveAsOgs(strCmd);
	}
	///End SAVE_ALL_OGS
	//-------- end CPY 8/10/05 HISTROY_WIN_REPLACED_BY_CODE_EDIT
	
	void OnExecute()
	{
		Window Wnd = GetParent();
		if(Wnd)
			Wnd.PostMessage(WM_USER_HISTORY_EXECUTE);
	}

private:	
	string getCurrentTime()
	{
		SYSTEMTIME st;
		get_current_time(st);  		// gets current time, 
		double dDate;
		SystemTimeToJulianDate(&dDate, &st);
		
		return get_date_str(dDate, LDF_SHORT_AND_HHMM_SEPARCOLON);
	}
	
	///Joe  4/17/06   SHOW_CURRENT_TIME
	void showCurrentTime()
	{
		WriteLine();	
		string 	strDate = STR_LT_COMMENT_PREFIX + "--" + getCurrentTime();
		int 	index = WriteLine(strDate);
		//---- CPY 8/10/05 HISTROY_WIN_REPLACED_BY_CODE_EDIT
		/*
		index = GetLineCount()-2; ///Iris 8/10/05 WriteLine always return true now
		SetLineColor(index, COLOR_COMMENT);
		*/
		WriteLine();	//CPY 8/3/05 make date line with empty space before commands
	}
	///End    SHOW_CURRENT_TIME
	
private:
	string 	m_strCmd;
	bool 	m_showDupCmdOnHisPane;  ///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
	//int		m_nHistoryIndex;	//--- CPY 8/3/05 KEY_UP_DOWN_BUFFER
};

	
	
enum {
	//CMDWND_MENU_OPEN, /// Iris 6/05/06 REMOVE_CMD_OPEN_MENU
	//CMDWND_MENU_SAVE, /// Iris 6/05/06 REMOVE_CMD_SAVE_MENU
	CMDWND_MENU_SAVEAS, 
		CMDWND_MENU_SEPARATOR_1,
	CMDWND_MENU_CUT, 
	CMDWND_MENU_COPY, 
	CMDWND_MENU_PASTE, 
	CMDWND_MENU_CLEAR,
		CMDWND_MENU_SEPARATOR_2,
    //CMDWND_MENU_AUTO_COMPLETE,//---- CPY 8/17/05 AUTO_COMPLETE_HOOK
	////CMDWND_MENU_STARTBY_RIGHTARROW,///Jasmine 9/16/05 START_BY_RIGHT_ARROW	///Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU
	  //CMDWND_MENU_SEPARATOR_3,//---- CPY 8/17/05 AUTO_COMPLETE_HOOK
	CMDWND_MENU_PRINT,
	///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
		CMDWND_MENU_SEPARATOR_3,
	CMDWND_MENU_PREFERENCE,
	///End ADD_PREFERENCE_ON_CONTEXT_MENU
	CMDWND_MENU_LAST_ITEM = 10000
};

#define XF_MENU_CAT_BEGIN	100
#define XF_MENU_CAT_END		5000


class CmdWndMenu : public Menu
{
public:	
	//CmdWndMenu(bool bIsSel, bool bAutoComplete)
	//CmdWndMenu(bool bIsSel, bool bEditable, bool bAutoComplete) /// Iris 8/26/05 DISABLE_CUT_CLEAR_MENU_IF_NOT_EDITABLE
	//CmdWndMenu(bool bIsSel, bool bEditable, bool bAutoComplete, int nOnRightArrow)///Jasmine 9/16/05 START_BY_RIGHT_ARROW
	CmdWndMenu(bool bIsSel, bool bEditable)///Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU
	{
		m_nChoice = -1;		
		/// Iris 8/26/05 DISABLE_CUT_CLEAR_MENU_IF_NOT_EDITABLE
		//UINT nFlags = bIsSel? MF_ENABLED : MF_DISABLED | MF_GRAYED;
		UINT nSelFlags = bIsSel? MF_ENABLED : MF_DISABLED | MF_GRAYED;  
		UINT nEditableFlags = bEditable ? MF_ENABLED : MF_DISABLED | MF_GRAYED;
		UINT nSelEditableFlags = bIsSel&&bEditable ? MF_ENABLED : MF_DISABLED | MF_GRAYED;
		///End DISABLE_CUT_CLEAR_MENU_IF_NOT_EDITABLE
		
		//Add(_L("Open..."), OnMenuItem);  /// Iris 6/05/06 REMOVE_CMD_OPEN_MENU
		//Add(_L("Save"), OnMenuItem);     /// Iris 6/05/06 REMOVE_CMD_SAVE_MENU
		Add(_L("SaveAs..."), OnMenuItem);	
		Add(NULL, EmptySepFunc, MF_SEPARATOR);		
		
		Add(_L("Cut"), OnMenuItem, nSelEditableFlags);		
		Add(_L("Copy"), OnMenuItem, nSelFlags);
		Add(_L("Paste"), OnMenuItem, nEditableFlags);
		Add(_L("Clear"), OnMenuItem);
		/*	Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU
		//---- CPY 8/17/05 AUTO_COMPLETE_HOOK
		int nFlags = bAutoComplete? MF_CHECKED : MF_UNCHECKED;
		Add(_L("Auto Complete"), OnMenuItem, nFlags);
		///Jasmine 9/16/05 START_BY_RIGHT_ARROW
		nFlags = nOnRightArrow? MF_CHECKED : MF_UNCHECKED;
		Add(_L("Auto Complete Stared By Right Arrow"), OnMenuItem, nFlags);
		///End
		*/
		///End
		Add(NULL, EmptySepFunc, MF_SEPARATOR);
		//----
		Add(_L("Print..."), OnMenuItem);	
		Add(NULL, EmptySepFunc, MF_SEPARATOR);///Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU
		Add(_L("Preference..."), OnMenuItem); ///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	
	bool GetCommand(int& nChoice)
	{
		//if(m_nChoice >= CMDWND_MENU_OPEN && m_nChoice < CMDWND_MENU_LAST_ITEM) /// Iris 6/05/06 REMOVE_CMD_OPEN_MENU
		//if(m_nChoice >= CMDWND_MENU_SAVE && m_nChoice < CMDWND_MENU_LAST_ITEM) /// Iris 6/05/06 REMOVE_CMD_SAVE_MENU
		if(m_nChoice >= CMDWND_MENU_SAVEAS && m_nChoice < CMDWND_MENU_LAST_ITEM)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
	void EmptySepFunc(uint nCmd)
	{
	}


private:
	int	m_nChoice;
};

///Iris 8/05/05 ADD_CONTEXT_MENU
enum {
	HISTORYWND_MENU_SAVE_AS_OGS,
	HISTORYWND_MENU_SAVE_ALL,   ///Joe  6/20/06    QA70-8601-P2 SAVE_ALL_OGS 
	HISTORYWND_MENU_SEPARATOR_1,
	HISTORYWND_MENU_EXECUTE,
	HISTORYWND_MENU_SEPARATOR_2,
	HISTORYWND_MENU_COPY, 
	HISTORYWND_MENU_COPY_TO, ///Jospeh	12/01/06	QA70-8278 ADD_ITEM_COPY_TO_CMD_PANEL
	HISTORYWND_MENU_CLEAR,
	HISTORYWND_MENU_SEPARATOR_3,
	HISTORYWND_MENU_PRINT,
	
	HISTORYWND_MENU_LAST_ITEM
};


class HistroyWndMenu : public Menu
{
public:
	HistroyWndMenu(bool bIsSel)
	{
		m_nChoice = -1;
		
		UINT nFlags = bIsSel? MF_ENABLED : MF_DISABLED | MF_GRAYED;

		Add(_L("Save As LabTalk Script (ogs) ..."), OnMenuItem, nFlags);
		
		///Joe  6/20/06    QA70-8601-P2 SAVE_ALL_OGS
		Add(_L("Save All ..."), OnMenuItem);
		///End SAVE_ALL_OGS
		
		Add(NULL, EmptySepFunc, MF_SEPARATOR);	
		///Jospeh	12/01/06	QA70-8278 MODIFY_THE_MENU_NAME
		//Add(_L("Execute"), OnMenuItem, nFlags);
		Add(_L("Execute Selection"), OnMenuItem, nFlags);
		///End	MODIFY_THE_MENU_NAME
		Add(NULL, EmptySepFunc, MF_SEPARATOR);		
		Add(_L("Copy"), OnMenuItem, nFlags);
		Add(_L("Copy to Command Window"), OnMenuItem, nFlags);  ///Jospeh	12/01/06	QA70-8278 ADD_ITEM_COPY_TO_CMD_PANEL 
		Add(_L("Clear"), OnMenuItem);		
		Add(NULL, EmptySepFunc, MF_SEPARATOR);		
		Add(_L("Print..."), OnMenuItem);
	}
	
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= HISTORYWND_MENU_SAVE_AS_OGS && m_nChoice < HISTORYWND_MENU_LAST_ITEM)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
	void	EmptySepFunc(uint nCmd)
	{
	}
private:
	int	m_nChoice;
};
///end ADD_CONTEXT_MENU

enum {
	MESSAGE_MENU_CLEAR,
	MESSAGE_MENU_SEP,
	MESSAGE_MENU_PRINT,
	
	MESSAGE_MENU_LAST_ENTRY
};

class MessageWndMenu : public Menu
{
public:
	MessageWndMenu()
	{
		m_nChoice = -1;
		
		Add(_L("Clear"), OnMenuItem);
		Add(NULL, EmptySepFunc, MF_SEPARATOR);		
		Add(_L("Print..."), OnMenuItem);		
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= MESSAGE_MENU_CLEAR && m_nChoice < MESSAGE_MENU_LAST_ENTRY)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
	void	EmptySepFunc(uint nCmd)
	{
	}
private:
	int	m_nChoice;
};

///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
///Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU
//enum {
	//AUTOCOMPLETE_MENU_BY_RIGHTARROW = -1,
	//AUTOCOMPLETE_MENU_OFF, 
	//AUTOCOMPLETE_MENU_AUTO, 
		//
	//AUTOCOMPLETE_MENU_LAST_ITEM = 10000
//};

//class AutoCompleteMenu : public Menu
//{
//public:	
	//AutoCompleteMenu(int nACState)
	//{
		//m_nChoice = -1;		
		//
		//int nFlags = (nACState == AUTOCOMPLETE_OFF)? MF_CHECKED : MF_UNCHECKED;
		//Add(_L("Off"), OnMenuItem, nFlags);
		//nFlags = (nACState == AUTOCOMPLETE_ON)? MF_CHECKED : MF_UNCHECKED;
		//Add(_L("Start Automatically"), OnMenuItem, nFlags);
		//nFlags = (nACState == AUTOCOMPLETE_BY_CMD)? MF_CHECKED : MF_UNCHECKED;
		//Add(_L("Start by Right Arrow Key"), OnMenuItem, nFlags);	
	//}
	//void OnMenuItem(UINT nPos)
	//{
		//m_nChoice = nPos;
	//}	
	//bool GetCommand(int& nChoice)
	//{
		//if(m_nChoice >= AUTOCOMPLETE_MENU_OFF && m_nChoice < AUTOCOMPLETE_MENU_LAST_ITEM)
		//{
			//nChoice = m_nChoice;
			//return true;
		//}
		//return false;
	//}
	//void EmptySepFunc(uint nCmd)
	//{
	//}
//private:
	//int	m_nChoice;
//};
///End AUTO_COMPLETE_POP_UP_MENU

//enum {
	//PROMPT_MENU_SHOW_NORMAL = 0, 
	//PROMPT_MENU_SHOW_TIME, 
	//PROMPT_MENU_SHOW_PATH,
	//
	//PROMPT_MENU_LAST_ITEM
//};
//
//
//class PromptMenu : public Menu
//{
//public:	
	//PromptMenu(int nACState)
	//{
		////---- CPY 4/28/06 PROMPT_MENU_SEPARATE_ID
////		m_nChoice = -1;
		//// as a second popup menu, we need to use a different id range then the default
		//int nCmd = IDC_PROMPT_MENU_BEGIN;
		////----
		//int nFlags = (nACState == PROMPT_MENU_SHOW_NORMAL)? MF_CHECKED : MF_UNCHECKED;
		//Add(">>", EmptySepFunc, nFlags, nCmd++);
		//nFlags = (nACState == PROMPT_MENU_SHOW_TIME)? MF_CHECKED : MF_UNCHECKED;
		//Add(_L("Time>"), EmptySepFunc, nFlags, nCmd++);
		//nFlags = (nACState == PROMPT_MENU_SHOW_PATH)? MF_CHECKED : MF_UNCHECKED;
		//Add(_L("cd Path>"), EmptySepFunc, nFlags, nCmd++);	
	//}
	//void EmptySepFunc(uint nCmd)
	//{
	//}
	////---- CPY 4/28/06 PROMPT_MENU_SEPARATE_ID
	///*
	//void OnMenuItem(UINT nPos)
	//{
		//m_nChoice = nPos;
	//}
	//bool GetCommand(int& nChoice)
	//{
		//if(m_nChoice >= PROMPT_MENU_SHOW_NORMAL && m_nChoice <= PROMPT_MENU_LAST_ITEM)
		//{
			//nChoice = m_nChoice;
			//return true;
		//}
		//return false;
	//}
//private:
	//int	m_nChoice;
	//*/
	//bool GetCommand(int& nChoice, int nSelCmd)
	//{
		//int nCmd = nSelCmd - IDC_PROMPT_MENU_BEGIN;
		//if(nCmd >= PROMPT_MENU_SHOW_NORMAL && nCmd < PROMPT_MENU_LAST_ITEM)
		//{
			//nChoice = nCmd;
			//return true;
		//}
		//
		//return false;
	//}
	////----
//};
///End ADD_PREFERENCE_ON_CONTEXT_MENU
///Joe  5/23/06  SPLITTER_HORIZONTALLY_VERTICALLY  add the new class SplitterMenu;
enum {
	HISTORY_MENU_LEFT = 0, 
	HISTORY_MENU_RIGHT,
	HISTORY_MENU_TOP,
	HISTORY_MENU_BOTTOM, 
	//HISTORY_MENU_NONE,		///Joseph	12/01/06	QA70-8278	HIDE_THE_HISTORY_PANEL
	
	HISTORY_MENU_LAST_ITEM
};

class SplitterMenu : public Menu
{
public:	
	SplitterMenu(int nACState)
	{
		int nCmd = IDC_SPLITTER_MENU_BEGIN;
		
		int nFlags = (nACState == HISTORY_MENU_LEFT)? MF_CHECKED : MF_UNCHECKED;
		Add(_L("Left"), EmptySepFunc, nFlags, nCmd++);
		
		nFlags = (nACState == HISTORY_MENU_RIGHT)? MF_CHECKED : MF_UNCHECKED;
		Add(_L("Right"), EmptySepFunc, nFlags, nCmd++);
		
		nFlags = (nACState == HISTORY_MENU_TOP)? MF_CHECKED : MF_UNCHECKED;
		Add(_L("Top"), EmptySepFunc, nFlags, nCmd++);
		
		nFlags = (nACState == HISTORY_MENU_BOTTOM)? MF_CHECKED : MF_UNCHECKED;
		Add(_L("Bottom"), EmptySepFunc, nFlags, nCmd++);
		///Joseph	12/01/06	QA70-8278	HIDE_THE_HISTORY_PANEL
		//nFlags = (nACState == HISTORY_MENU_NONE)? MF_CHECKED : MF_UNCHECKED;
		//Add(_L("Hide"), EmptySepFunc, nFlags, nCmd++);
		///End HIDE_THE_HISTORY_PANEL
	}
	void EmptySepFunc(uint nCmd)
	{
	}

	bool GetCommand(int& nChoice, int nSelCmd)
	{
		int nCmd = nSelCmd - IDC_SPLITTER_MENU_BEGIN;
		if(nCmd >= HISTORY_MENU_LEFT && nCmd < HISTORY_MENU_LAST_ITEM)
		{
			nChoice = nCmd;
			return true;
		}		
		return false;
	}
};
///End SPLITTER_HORIZONTALLY_VERTICALLY
class LTSWSplitter : public SplitterControl
{
private:
///Joe  5/23/06  SPLITTER_HORIZONTALLY_VERTICALLY  	
	int	getSplitterState(int& nRowSize = 1,int& nColSize = 2,int& nHisRow = 0, int& nHisCol = 1, int& nCmdRow = 0, int& nCmdCol = 0)
	{
		DWORD dwDefault;
		int nState;
		//nState = LoadSetting("SPLITTER_STATE",dwDefault,"Command Window");
		nState = LoadSetting("SPLITTER_STATE", dwDefault, STR_DLG_NAME); /// Hong 11/07/07 v8.0742 MORE_LOCALIZED
		switch( nState )
		{
	 	case  HISTORY_PANE_LEFT:
	 		nHisRow = 0;
			nHisCol = 0;
	 		nCmdRow = 0;
	 		nCmdCol = 1;
	 		nRowSize = 1;
	 		nColSize = 2;
	 		break;
		case HISTORY_PANE_BOTTOM:
			nHisRow = 1;
			nHisCol = 0;
	 		nCmdRow = 0;
	 		nCmdCol = 0;
	 		nRowSize = 2;
	 		nColSize = 1;
	 		break;
		case HISTORY_PANE_RIGHT:
            nHisRow = 0;
			nHisCol = 1;
	 		nCmdRow = 0;
	 		nCmdCol = 0;
	 		nRowSize = 1;
	 		nColSize = 2;
	 		break;
		case HISTORY_PANE_TOP:
	 	    nHisRow = 0;
			nHisCol = 0;
	 		nCmdRow = 1;
	 		nCmdCol = 0;
	 		nRowSize = 2;
	 		nColSize = 1;
	 		break;
	 	///Joseph	12/01/06	QA70-8278	HIDE_THE_HISTORY_PANEL
		//case HISTORY_PANE_NONE:
			//nHisRow = 0;
			//nHisCol = 0;
			//nCmdRow = 0;
			//nCmdCol = 0;
			//nRowSize = 1;
	 		//nColSize = 1;
	 		//break;
	 	///End HIDE_THE_HISTORY_PANEL
		default:
			break;
		}
		return nState;
	}

	bool	setSplitterState(int nState = HISTORY_PANE_LEFT)
	{
		///Joseph	12/01/06	QA70-8278	HIDE_THE_HISTORY_PANEL
		if(nState > HISTORY_PANE_BOTTOM || nState  < HISTORY_PANE_LEFT)
		//if(nState > HISTORY_PANE_NONE || nState  < HISTORY_PANE_LEFT)
		///End HIDE_THE_HISTORY_PANEL
			return false;
		//SaveSetting("SPLITTER_STATE", nState, "Command Window");
		SaveSetting("SPLITTER_STATE", nState, STR_DLG_NAME); /// Hong 11/07/07 v8.0742 MORE_LOCALIZED
			return true;
	}
///End  SPLITTER_HORIZONTALLY_VERTICALLY
public:
	LTSWSplitter()
	{		
		m_bReady = false;
		// control ID for panes
		// Must init these IDs before calls to InitMsgMap
		///Joe  5/23/06  SPLITTER_HORIZONTALLY_VERTICALLY  
		//SetGridSize(1,2);
		//m_cmdHistoryID = GetDlgCtrlID();
		//m_cmdWinID = GetDlgCtrlID(0,1);
		int nRowSize;
		int nColSize;
	   	int nHisRow;
	   	int nHisCol;
	    int nCmdRow;
		int nCmdCol;
	   	getSplitterState(nRowSize, nColSize, nHisRow, nHisCol, nCmdRow, nCmdCol);
		SetGridSize(nRowSize,nColSize);
		
		m_cmdHistoryID = GetDlgCtrlID(nHisRow,nHisCol);
		m_cmdWinID = GetDlgCtrlID(nCmdRow, nCmdCol);
		///End SPLITTER_HORIZONTALLY_VERTICALLY
		//printf("Cmd = %d, History = %d\n", m_cmdWinID, m_cmdHistoryID);
		
		// --- Iris 8/08/05 SHOW_MB_BEFORE_CLEAR
		//m_reCmdHistory.SetDlgName(STR_DLG_NAME);//---- CPY 8/10/05 HISTROY_WIN_REPLACED_BY_CODE_EDIT
		m_reCmd.SetDlgName(STR_DLG_NAME);
		// ---
		///Joe  4/24/06  SET_NORMAL_TIME_PATH_PROMPT  load prompt state; 
		DWORD dwDefault = -10000;
		///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
		//int iPrompt;
		//iPrompt = LoadSetting("SHOW_PROMPT",dwDefault,"Command Window");
		//m_reCmd.SetPromptState(iPrompt);
		int nPrompt,nAutoComplete;
		int nShowErrCmd,nShowDuplicate;
		if((nPrompt = LoadSetting(STR_PROMPT_STATE, dwDefault,STR_CMDWIN_PREFENCE)) < NUM_REGISTER_MIN_VAL)
		{
			SaveSetting(STR_PROMPT_STATE, SHOW_NORMAL,STR_CMDWIN_PREFENCE);
			nPrompt = SHOW_NORMAL;
		}
		m_reCmd.SetPromptState(nPrompt);
		
		if((nShowErrCmd = LoadSetting(STR_FAILCMD_SHOW, dwDefault,STR_CMDWIN_PREFENCE)) < NUM_REGISTER_MIN_VAL)
		{
			SaveSetting(STR_FAILCMD_SHOW, false,STR_CMDWIN_PREFENCE);
			nShowErrCmd = false;
		}
		m_reCmd.SetErrCmdOnHisPane(nShowErrCmd);
		
		if((nShowDuplicate = LoadSetting(STR_DUPLCMD_SHOW, dwDefault,STR_CMDWIN_PREFENCE)) < NUM_REGISTER_MIN_VAL)		
		{
			SaveSetting(STR_DUPLCMD_SHOW, true,STR_CMDWIN_PREFENCE);
			nShowDuplicate = true;
		}
		m_reCmdHistory.ShowDupCmdOnHisPane(nShowDuplicate);
		
		if((nAutoComplete = LoadSetting(STR_AUTOCOMPLETE_STATE, dwDefault,STR_CMDWIN_PREFENCE)) < NUM_REGISTER_MIN_VAL)
		{
			SaveSetting(STR_AUTOCOMPLETE_STATE, AUTOCOMPLETE_ON ,STR_CMDWIN_PREFENCE);
			nAutoComplete = AUTOCOMPLETE_ON;
		}
		OnAutoCompleteMenu(nAutoComplete);
		///End ADD_PREFERENCE_ON_CONTEXT_MENU
		///End SET_NORMAL_TIME_PATH_PROMPT
		InitMsgMap();
	}
	void Init(int nCntrlID, WndContainer& wndParent, LPCSTR lpcszDlgName)
	{
		SplitterControl::Init(nCntrlID, wndParent, 0, lpcszDlgName);
		Visible = true;
	}
	void SetShow(bool bShow = true)
	{
		Visible = bShow;
		if(bShow)
			SetFocus(m_reCmd.GetSafeHwnd());
	}
	///Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU
	///Jasmine 9/21/05 START_BY_RIGHT_ARROW
	void SetAutoCompleteState(int nState = AUTOCOMPLETE_ON)
	{
		/*	
		if((AUTOCOMPLETE_ON == nState) != m_reCmd.IsAutoCompleteOn())
			m_reCmd.ToggleAutoComplete();			
		if((AUTOCOMPLETE_BY_CMD == nState) != m_reCmd.IsStartByRightArrow())
			m_reCmd.ToggleStartBy();
		*/
		m_reCmd.SetAutoCompleteState(nState);
	}
	///Joe  4/24/06  SET_NORMAL_TIME_PATH_PROMPT  set the promptstate in this class
	void SetPromptState(int nState = 0)
	{
		m_reCmd.SetPromptState(nState);
	}
	///End SET_NORMAL_TIME_PATH_PROMPT 
	int GetAutoCompleteState()
	{
		/*
		if(m_reCmd.IsAutoCompleteOn())
			return AUTOCOMPLETE_ON;
		if(m_reCmd.IsStartByRightArrow())
			return AUTOCOMPLETE_BY_CMD;
		return AUTOCOMPLETE_OFF;
		*/
		return m_reCmd.GetAutoCompleteState();
	}
	///End AUTO_COMPLETE_POP_UP_MENU
	
	///Joe  4/24/06  SET_NORMAL_TIME_PATH_PROMPT  get the Prompt State in this class
	int GetPromptState()
	{
		return m_reCmd.GetPromptState();
	}
	///End SET_NORMAL_TIME_PATH_PROMPT
	
	BOOL OnIdle()//CPY 9/24/05 DEBUG_SHOW_AC_CLASS_ON_CMD_WND_TITLE
	{
#ifdef _SHOW_DEBUG_INFO
		//----- this is only during debugging, will need to remove later
		string str = m_reCmd.GetCurrentACObjectName();
		str += " key=" + m_reCmd.GetDebugInfo();
		Window wnd = GetParent();		
		wnd.Text = "Command Window: " + str;
		//-----
#endif
		return true;
	}

protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_KEY(m_cmdWinID, OnKeyLTCmdPane)
	ON_EVENT(EN_SETFOCUS, m_cmdWinID, OnSetFocusLTCmdPane)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnCtrlResize)
	
	ON_USER_MSG(WM_USER_RESIZE_CONTROLS, OnInitPaneSizs)	//----- CPY 3/25/06 SPLITTER_INIT_SIZE_NOT_CALL

	ON_USER_MSG(WM_USER_HISTORY_ADD_CMD, OnHistoryAddCmd)
//	ON_USER_MSG(WM_USER_CMD_UP_KEY, OnCmdKeyUp)
//	ON_USER_MSG(WM_USER_CMD_DOWN_KEY, OnCmdKeyDown)
	ON_USER_MSG(WM_USER_HISTORY_EXECUTE, OnHistoryExecute)
	ON_CONTEXTMENU(OnShowMenu) // ---Iris 8/05/05 ADD_CONTEXT_MENU
	ON_MOUSEMSG(WM_LBUTTONDBLCLK, m_cmdHistoryID, OnHistoryDoubleClick) //CPY 8-1-05 QA70-7956 DBCLK_HISTORY_PANE
	ON_KEY(m_cmdHistoryID, OnKeyHistoryCmdPane) /// Iris 8/15/05 QA70-7892 HISTORY_WND_ENTER_TO_EXECUTE_CMD
	ON_USER_MSG(WM_USER_AUTOCOMPLETE_DONE,	OnAutoCompleteClose)
	ON_USER_MSG(WM_USER_AUTOCOMPLETE_GET_DISPLAY_STRING,	OnGetAutocompleteDisplay)
	ON_USER_MSG(WM_USER_AUTOCOMPLETE_ON_REPLACE_SEL,	OnAutoCompleteDoneReplaceSel) //CPY 9/10/05 AUTO_COMPLETE_ALLOW_IMMEDIATE_OPEN
	
EVENTS_END

	BOOL OnHistoryAddCmd(uint wParam, uint lParam)
	{
		string str = m_reCmd.GetCmd();
		m_reCmdHistory.AddCmd(str);	
		return true;
	}
	
	//TD 8-19-05
	BOOL OnAutoCompleteClose(UINT wParam, UINT lParam)
	{
		//m_reCmd.OnAutoComplete(-1, 0); // CPY 2nd arg = 0 to indicate called from VC level
		Window wndParent = GetParent();
		m_reCmd.OnAutoCompleteClose(wndParent, wParam, lParam);
		return TRUE;
	}
private:
//	bool getXFHelpInfo(LPCSTR lpcszXF, string& strDisplay);
//	bool getXFVarHelpInfo(int nID, LPCSTR lpcszSrc, string& strDisplay);
	bool getHelpInfo(int nID, LPCSTR lpcszSrc, string& strDisplay)
	{
		//--------	CPY 9/9/05 AUTO_COMPLETE_OBJ
		/*
		if(AUTOCOMPLETE_XFUNCTION == nID)
			return getXFHelpInfo(lpcszSrc, strDisplay);
		else if(nID >= AUTOCOMPLETE_XF_VAR_IN && nID <= AUTOCOMPLETE_XF_VAR_IN_OUT)
			return getXFVarHelpInfo(nID, lpcszSrc, strDisplay);
		*/
		if(m_reCmd.OnAutoCompleteGetHelpInfo(nID, lpcszSrc, strDisplay))
		{
			if(strDisplay.IsEmpty())
				return false;
			return true;
		}
		
		strDisplay.Format("icon ID = %d\nitem name = %s", nID, lpcszSrc);
		return true;
	}
	
protected:
	//---- CPY 9/10/05 AUTO_COMPLETE_ALLOW_IMMEDIATE_OPEN
	DWORD OnAutoCompleteDoneReplaceSel(UINT wParam, UINT lParam)
	{
		int nStart = wParam;
		int nEnd = lParam; // begin and end position of the replaced text		
		m_reCmd.OnAutoCompleteDoneReplaceSel(nStart, nEnd);
		return 0;
	}
	//----
	LRESULT OnGetAutocompleteDisplay(WPARAM wParam, LPARAM lParam)
	{
		if(lParam)
		{
			LPCSTR lpcszItem = (LPCSTR)lParam;
			/*
			static string s_str;
			s_str.Format("icon ID = %d\nitem name = %s", wParam, lpcszItem);
			LPCSTR lpsz = (LPCSTR)s_str;			
			void *pp = lpsz;
			*/
			string str;
			if(getHelpInfo(wParam, lpcszItem, str))
			{
				static char s_szTemp[10*MAXLINE];
				lstrcpyn(s_szTemp, str, 10*MAXLINE);
				void *pp = s_szTemp;
				return (LRESULT)pp;
			}
		}
		return 0;//Null ptr
	}
	

	BOOL OnHistoryExecute(uint wParam, uint lParam)
	{
		return m_reCmd.ExecuteExternalCmd();		
	}
	
	BOOL OnHistoryDoubleClick(Control ctrl, uint nMsg, int nx, int ny) // CPY 8-1-05 QA70-7956 DBCLK_HISTORY_PANE
	{
		printf("double-click at x = %d, y = %d\n", nx, ny);
	
		return true;
	}	
	
	BOOL OnInitDialog()
	{
		DWORD dwStyle = WS_CHILD | WS_VISIBLE  | ES_MULTILINE| ES_AUTOVSCROLL | ES_AUTOHSCROLL | WS_VSCROLL | WS_HSCROLL | WS_EX_WINDOWEDGE | ES_WANTRETURN;
		///Joe  5/23/06  SPLITTER_HORIZONTALLY_VERTICALLY
		//CreatePane(m_reCmd, 0, 1, -1, -1, dwStyle);
		//dwStyle |= ES_READONLY;
		//CreatePane(m_reCmdHistory, 0, 0, -1, -1, dwStyle);
		int nRowSize;
		int nColSize;
	   	int nHisRow;
	   	int nHisCol;
	   	int nCmdRow;
	   	int nCmdCol;
	   	getSplitterState(nRowSize, nColSize, nHisRow, nHisCol, nCmdRow, nCmdCol);
		CreatePane(m_reCmd, nCmdRow, nCmdCol, -1, -1, dwStyle);
		dwStyle |= ES_READONLY;
		CreatePane(m_reCmdHistory, nHisRow, nHisCol, -1, -1, dwStyle);
		///End   SPLITTER_HORIZONTALLY_VERTICALLY
		//m_reCmd.SetFont(ANSI_FIXED_FONT);
		//m_reCmdHistory.SetFont(ANSI_FIXED_FONT);
		m_reCmd.OnInit();
		m_reCmdHistory.OnInit(); 
		
		m_reCmd.LoadFileToCmdBuffer(); ///Joseph 12/02/06	UPDOWN_KEY_LOAD_HISTORY
		///Joe  8/29/06  ROLLBACK_AND_MODIFY_UPDOWN_KEY
		//sVsCmdBuffer.SetSize(0); ///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
		///End ROLLBACK_AND_MODIFY_UPDOWN_KEY
		SetReady();
		m_bReady = true;
		return TRUE;
	}
	BOOL OnCtrlResize(int nType, int cx, int cy)
	{
		SplitterControl::OnResize(nType, cx, cy);
		return TRUE;
	}
	BOOL OnKeyLTCmdPane(Control oCntrl, UINT msg, UINT wParam, UINT lParam)
	{		
		return m_reCmd.OnKeyCmd(msg, wParam, lParam);
	}
	BOOL OnSetFocusLTCmdPane(Control oCntrl)
	{
		m_reCmd.OnSetFocus();
		return true;
	}
public:
	//--- CPY 3/25/06 CMD_WIN_CANNOT_CLOSE_FROM_MAIN_TOOLBAR
	// I have to make this public as somehow destructor not being called when in dockbar
	BOOL OnDestroy(void)
	{
		m_reCmdHistory.Save();
		m_reCmd.SaveBuffertoFile();///Joseph 12/02/06	UPDOWN_KEY_LOAD_HISTORY
		//SaveSetting("SHOW_PROMPT",GetPromptState(),"Command Window"); ///Joe  4/24/06  SET_NORMAL_TIME_PATH_PROMPT  save the prompt type to registry  ///Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
		return SplitterControl::OnDestroy();
	}
	//---
protected:	
	/// Iris 8/05/05 ADD_CONTEXT_MENU
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)

	{
		if(m_cmdWinID == nResIDCtrl)
			return OnCmdWndMenu(nx, ny);
		
		if(m_cmdHistoryID == nResIDCtrl)
			return OnHistoryWndMenu(nx, ny);
		return FALSE;
	}
	
	BOOL OnCmdWndMenu(int nx, int ny)
	{
		int			nCmd; 
		//CmdWndMenu		myMenu(!m_reCmd.IsSelEmpty(), m_reCmd.IsAutoCompleteOn());
		//CmdWndMenu		myMenu(!m_reCmd.IsSelEmpty(), m_reCmd.IsEditable(), m_reCmd.IsAutoCompleteOn());  /// Iris 8/26/05 DISABLE_CUT_CLEAR_MENU_IF_NOT_EDITABLE
		
		///Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU
		//CmdWndMenu	myMenu(!m_reCmd.IsSelEmpty(), m_reCmd.IsEditable(), m_reCmd.IsAutoCompleteOn(), m_reCmd.IsStartByRightArrow());///Jasmine 9/16/05 START_BY_RIGHT_ARROW
		CmdWndMenu	myMenu(!m_reCmd.IsSelEmpty(), m_reCmd.IsEditable());
		
		///Joe  4/24/06  SET_NORMAL_TIME_PATH_PROMPT  chang the name;
		//AutoCompleteMenu popupMenu(GetAutoCompleteState());
		///Joe  8/24/06  ADD_PREFERENCE_ON_CONTEXT_MENU
		//AutoCompleteMenu popupMenuAC(GetAutoCompleteState());
		///End ADD_PREFERENCE_ON_CONTEXT_MENU
		///End SET_NORMAL_TIME_PATH_PROMPT
		///Jasmine 04/28/06 SEPARATE_TWO_POPUP_MENU
		//myMenu.InsertPopup(0, _L("Auto Complete"), popupMenuAC, OC_MENURANGE_BEGIN);
		///Joe  8/24/06  ADD_PREFERENCE_ON_CONTEXT_MENU
		//myMenu.AddPopup(_L("Auto Complete"), popupMenuAC);
		///End ADD_PREFERENCE_ON_CONTEXT_MENU
		///End AUTO_COMPLETE_POP_UP_MENU
		
		///Joe  4/24/06  SET_NORMAL_TIME_PATH_PROMPT 
		///Joe  8/24/06  ADD_PREFERENCE_ON_CONTEXT_MENU
		//PromptMenu popupMenuP(GetPromptState());
		//myMenu.AddPopup(_L("Prompt"),popupMenuP);
		///End ADD_PREFERENCE_ON_CONTEXT_MENU
		
		int nSelCmd;
		///Joe  8/24/06  ADD_PREFERENCE_ON_CONTEXT_MENU
		Tree trNode;
		bool bPrefrence;
		int nPromptVal, nAutoCompleteVal;
		bool bShowDuplicate, bErrCmdOnHisPane;
		///End  ADD_PREFERENCE_ON_CONTEXT_MENU
		myMenu.TrackPopupMenu(0,  nx, ny, GetSafeHwnd(), &nSelCmd);
		///CPY 4/28/06 PROMPT_MENU_SEPARATE_ID, moved code from after popupMenuAC, was Joe  4/24/06  SET_NORMAL_TIME_PATH_PROMPT  run the command when press the PromptMenu
		//if(popupMenuP.GetCommand(nCmd, nSelCmd))
		//{
			//OnPromptMenu(nCmd);
			//m_reCmd.ShowPrompt();	
			//return TRUE;
		//}
		///End  SET_NORMAL_TIME_PATH_PROMPT

		///End SEPARATE_TWO_POPUP_MENU
		///SET_NORMAL_TIME_PATH_PROMPT
		
		
		if(myMenu.GetCommand(nCmd))
		{
			switch(nCmd)
			{	
			/// Iris 6/05/06 REMOVE_CMD_OPEN_MENU
			//case CMDWND_MENU_OPEN:
				//m_reCmd.OnOpen();
				//return TRUE;
				//break;
			///End REMOVE_CMD_OPEN_MENU
			
			/// Iris 6/05/06 REMOVE_CMD_SAVE_MENU
			//case CMDWND_MENU_SAVE:
				//m_reCmd.OnSave();
				//return TRUE;
				//break;
			///End REMOVE_CMD_SAVE_MENU
				
			case CMDWND_MENU_SAVEAS:
				m_reCmd.OnSaveAs();
				return TRUE;
				break;
			case CMDWND_MENU_CUT: 
				m_reCmd.OnCut();
				return TRUE;
				break;
				
			case CMDWND_MENU_COPY:
				m_reCmd.Copy();
				return TRUE;
				break;
				
			case CMDWND_MENU_PASTE:
				///Joe  6/14/06    QA70-8601 P6 ON_PASTE_PROMPT_HIDE
				//m_reCmd.Paste();
				m_reCmd.OnPaste();
				///End ON_PASTE_PROMPT_HIDE
				return TRUE;
				break;
				
			case CMDWND_MENU_CLEAR:
				m_reCmd.OnClear();
				return TRUE;
				break;
			/*	Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU
			//---- CPY 8/17/05 AUTO_COMPLETE_HOOK
			case CMDWND_MENU_AUTO_COMPLETE:
				m_reCmd.ToggleAutoComplete();
				///Jasmine 9/16/05 START_BY_RIGHT_ARROW
				if(m_reCmd.IsStartByRightArrow())
					m_reCmd.ToggleStartBy();
				//End
				return TRUE;
			//----	
			///Jasmine 9/16/05 START_BY_RIGHT_ARROW
			case CMDWND_MENU_STARTBY_RIGHTARROW:
				m_reCmd.ToggleStartBy();
				if(m_reCmd.IsAutoCompleteOn())
					m_reCmd.ToggleAutoComplete();
				return TRUE;
			///End
			*/			
			///End AUTO_COMPLETE_POP_UP_MENU
			case CMDWND_MENU_PRINT:
				m_reCmd.Print(true, "Command Output");
				return TRUE;
				break;	
			///Joe  8/24/06  ADD_PREFERENCE_ON_CONTEXT_MENU
			case CMDWND_MENU_PREFERENCE:
				OnDonePrefenceBefore(nPromptVal, nAutoCompleteVal, bShowDuplicate, bErrCmdOnHisPane);
				bPrefrence = m_reCmd.GetPreference(trNode, nPromptVal, nAutoCompleteVal,bShowDuplicate, bErrCmdOnHisPane);
				OnDonePrefence(trNode, bPrefrence);
				return TRUE;
				break;
			///End ADD_PREFERENCE_ON_CONTEXT_MENU
			}
		}
		///Joe  8/24/06  ADD_PREFERENCE_ON_CONTEXT_MENU
		///Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU		
		//if(popupMenuAC.GetCommand(nCmd))
		//{
			//OnAutoCompleteMenu(nCmd);
			//return TRUE;
		//}///End AUTO_COMPLETE_POP_UP_MENU 
		///End ADD_PREFERENCE_ON_CONTEXT_MENU
		
		return FALSE;
	}	
	///Joe  8/24/06  ADD_PREFERENCE_ON_CONTEXT_MENU
	void OnDonePrefenceBefore(int& nPromptVal, int& nAutoCompleteVal, bool& bShowDuplicate, bool& bErrCmdOnHisPane)
	{
		DWORD dwDefault = 0;
		nPromptVal = LoadSetting(STR_PROMPT_STATE, dwDefault,STR_CMDWIN_PREFENCE);
		nAutoCompleteVal = LoadSetting(STR_AUTOCOMPLETE_STATE, dwDefault,STR_CMDWIN_PREFENCE);
		bShowDuplicate = LoadSetting(STR_DUPLCMD_SHOW, dwDefault, STR_CMDWIN_PREFENCE);
		bErrCmdOnHisPane = LoadSetting(STR_FAILCMD_SHOW,dwDefault, STR_CMDWIN_PREFENCE);
	}
	bool OnDonePrefence(TreeNode trNode, bool bOnOK = false)
	{
		if(!bOnOK)
			return true;
		int nPromptVal = trNode.Prompt.pmpt.nVal;
		int nAutoCompleteVal = trNode.AutoComplete.ac.nVal ;
		bool bShowDuplicate =  trNode.AddHisCmd.AddDupCmdOnHisPane.nVal;
		bool bShowErrCmd = trNode.AddHisCmd.AddErrCmdOnHisPane.nVal;
		////Joe  8/24/06    ADD_PREFERENCE_ON_CONTEXT_MENU
		//OnAutoCompleteMenu(nAutoCompleteVal - 1);
		OnAutoCompleteMenu(nAutoCompleteVal);
		///End ADD_PREFERENCE_ON_CONTEXT_MENU
		if(OnPromptMenu(nPromptVal))
			m_reCmd.ShowPrompt();
		OnShowDupCmdOnHisPane(  bShowDuplicate);
		OnShowErrCmdOnHisPane(  bShowErrCmd );
		SaveSetting(STR_PROMPT_STATE, nPromptVal,STR_CMDWIN_PREFENCE);
		SaveSetting(STR_AUTOCOMPLETE_STATE, nAutoCompleteVal,STR_CMDWIN_PREFENCE);
		SaveSetting(STR_DUPLCMD_SHOW, bShowDuplicate, STR_CMDWIN_PREFENCE);
		SaveSetting(STR_FAILCMD_SHOW, bShowErrCmd, STR_CMDWIN_PREFENCE);
		return true;
	}
	void OnShowDupCmdOnHisPane(bool bShowDuplicate = true)
	{
		m_reCmdHistory.ShowDupCmdOnHisPane(bShowDuplicate);
	}
	
	void OnShowErrCmdOnHisPane(bool bShowErrCmd = true)
	{ 
		m_reCmd.SetErrCmdOnHisPane( bShowErrCmd );
	}
	///End  ADD_PREFERENCE_ON_CONTEXT_MENU
	BOOL OnHistoryWndMenu(int nx, int ny)
	{			
		int				nCmd;
		HistroyWndMenu	myMenu(!m_reCmdHistory.IsSelEmpty());
		///Joe  5/23/06  SPLITTER_HORIZONTALLY_VERTICALLY
		SplitterMenu popupMenuSplitter(getSplitterState());
		myMenu.AddPopup(_L("Position"),popupMenuSplitter);
		///End SPLITTER_HORIZONTALLY_VERTICALLY
		
	
		int st;
		myMenu.TrackPopupMenu(0,  nx, ny, GetSafeHwnd(),&st);
		
		///Joe  5/23/06  SPLITTER_HORIZONTALLY_VERTICALLY
		if(popupMenuSplitter.GetCommand(nCmd,st))
		{
			if(IDOK == MessageBox(GetSafeHwnd(), _L("The new arrangement will be used when the command window is open again.  \n Are you sure you want to make this change?"), _L("Splitter State"), MB_OK|MB_OKCANCEL|MB_ICONQUESTION)) 
			{  
				setSplitterState(nCmd);
				s_bUserChangedHistoryPanePositionState = true;//CPY 5/25/06 HIST_PANE_POSITION_RESTART_WHEN_CLOSE_FROM_CMD_BAR_X
			}
			return TRUE;
		}
		///End SPLITTER_HORIZONTALLY_VERTICALLY
		if(myMenu.GetCommand(nCmd))
		{			
			switch(nCmd)
			{				
			case HISTORYWND_MENU_SAVE_AS_OGS:
				m_reCmdHistory.OnSaveAs();
				return TRUE;
			///Joe  6/20/06    QA70-8601-P2 SAVE_ALL_OGS
			case HISTORYWND_MENU_SAVE_ALL:
				m_reCmdHistory.OnSaveAll();
				return TRUE;
			///End SAVE_ALL_OGS	
			case HISTORYWND_MENU_EXECUTE:
				/// Iris 11/9/05 QA70-8278-P3 SIGNAL_CLICK_TO_SELECT_HISTORY_CMD
				//string strText = m_reCmdHistory.GetSelText();
				//m_reCmd.SetCmd(strText);
				//m_reCmdHistory.OnExecute();	
				executeHistorySelectedCmd();
				///End SIGNAL_CLICK_TO_SELECT_HISTORY_CMD
				return TRUE;
			case HISTORYWND_MENU_COPY:
				m_reCmdHistory.Copy();
				return TRUE;
			///Jospeh	12/01/06	QA70-8278 ADD_ITEM_COPY_TO_CMD_PANEL
			case HISTORYWND_MENU_COPY_TO:
				m_reCmdHistory.Copy();
				m_reCmd.Paste();
				return TRUE;
			///End ADD_ITEM_COPY_TO_CMD_PANEL
			//case HISTORYWND_MENU_PASTE:
				//m_reCmdHistory.OnPaste();
				//return TRUE;
				//break;
				//
			//case HISTORYWND_MENU_OPEN:
				//m_reCmdHistory.OnOpen();
				//return TRUE;
				//break;				
				//
			//case HISTORYWND_MENU_SAVE:
				//m_reCmdHistory.OnSave();
				//return TRUE;
				//break;	
				//
			//case HISTORYWND_MENU_SAVEAS:
				//m_reCmdHistory.OnSaveAs();
				//return TRUE;
				//break;				
				
			case HISTORYWND_MENU_CLEAR:
				m_reCmdHistory.OnClear();
				return TRUE;
			case HISTORYWND_MENU_PRINT:
				m_reCmdHistory.Print(true, "Command History");
				break;				
			}
		}	
		return FALSE;
	}	
	///end ADD_CONTEXT_MENU	
	
	BOOL OnKeyHistoryCmdPane(Control oCntrl, UINT msg, UINT wParam, UINT lParam)
	{
		if(wParam == VK_RETURN)
		{
			/// Iris 11/9/05 QA70-8278-P3 SIGNAL_CLICK_TO_SELECT_HISTORY_CMD
			//string strText = m_reCmdHistory.GetSelText();
			//m_reCmd.SetCmd(strText);
			//m_reCmdHistory.OnExecute();
			executeHistorySelectedCmd();
			///End SIGNAL_CLICK_TO_SELECT_HISTORY_CMD
			return TRUE;
		}
		
		return FALSE;
	}
	///Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU
	void OnAutoCompleteMenu(int nCmd)///doing
	{
		///Joe  8/24/06  ADD_PREFERENCE_ON_CONTEXT_MENU
		//if(nCmd != GetAutoCompleteState())
			//SetAutoCompleteState(nCmd);
		//else
			//SetAutoCompleteState(nCmd == AUTOCOMPLETE_MENU_OFF);
		SetAutoCompleteState(nCmd);	
		///End ADD_PREFERENCE_ON_CONTEXT_MENU
				
	}///End AUTO_COMPLETE_POP_UP_MENU
	
	///Joe  4/24/06  SET_NORMAL_TIME_PATH_PROMPT press the PromptMenu,Set the PromptState;
	///Joe  8/24/06  ADD_PREFERENCE_ON_CONTEXT_MENU
	bool OnPromptMenu(int nCmd)
	///End ADD_PREFERENCE_ON_CONTEXT_MENU
	{	
		//if(nCmd != GetPromptState())
			//SetPromptState(nCmd);
		//else
			//SetPromptState(nCmd == SHOW_NORMAL);
		int nPromptState = GetPromptState();
		SetPromptState(nCmd);
		if(nCmd != nPromptState)
			return true;	
		else
			return false;	
	}
	///End SET_NORMAL_TIME_PATH_PROMPT
private:
	void executeHistorySelectedCmd()
	{
		string strText = m_reCmdHistory.GetSelText();
		m_reCmd.TrimCmd(strText);
		if(strText.IsEmpty())
		{
			//get the index of the selected line
			int 	nStartChar, nEndChar;		
			m_reCmdHistory.GetSel(nStartChar, nEndChar);		
			int 	nLine = m_reCmdHistory.LineFromChar(nStartChar);
			
			strText = m_reCmdHistory.GetLine(nLine);
			strText.TrimRight(';');
		}
		m_reCmd.SetCmd(strText);
		m_reCmdHistory.OnExecute();	
		m_reCmd.m_vsCmdBuffer.Add(strText);  ///Joseph 12/02/06	UPDOWN_KEY_LOAD_HISTORY
	}
	//----CPY CPY 11/1/2007 QA70-10638 CMD_WND_OUTPUT_ERR_BY_DEFAULT
public:
	void Write(LPCSTR lpcsz, BOOL bAddCRLF, BOOL bHistoryPane=false)
	{
		if(bHistoryPane)
		{
			if(bAddCRLF)
				m_reCmdHistory.WriteLine(lpcsz);
			else
				m_reCmdHistory.Write(lpcsz);
			return;
		}
		string strTemp = lpcsz;
		if(bAddCRLF)
			strTemp += "\r\n";
		///Sophy 2/26/2010 QA81-12697-P4 OC_OUTPUT_TO_CMD_WND_SHOULD_BELOW_LAST_CMD
		//m_reCmd.ReplaceBeforePrompt(strTemp);
		string	strTempCmd = m_reCmd.GetCmdAfterPrompt();
		if ( !strTempCmd.IsEmpty() )
		{
			m_reCmd.Write(strTemp); //this case happens when run OC function that contains printf() from Command Window, will output string before create a new Prompt, so should not insert before last Prompt.
		}
		else
			m_reCmd.ReplaceBeforePrompt(strTemp);
		///end OC_OUTPUT_TO_CMD_WND_SHOULD_BELOW_LAST_CMD
	}
	//----end CMD_WND_OUTPUT_ERR_BY_DEFAULT
			
public:
	LTCmdControl	m_reCmd;
	HistoryControl  m_reCmdHistory;
	
private:
	bool		m_bReady;
	int			m_cmdWinID;
	int			m_cmdHistoryID;	
	string		m_strHelpText;
	//int			m_nHistoryIndex;
};