/*------------------------------------------------------------------------------*
 * File Name: ScriptPanel.c				 										*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 12/27/06 INSERT_SEMICOLON_TO_DELAY_EXECUTE							*
 * Jasmine 01/30/07 SAME_BEHAVIOR_WITH_SCRIPT_WINDOW 							*
 * Jasmine 07/31/07 #10135 PAGE_SPLITTER_CANNOT_RECEIVE_ON_OK_CANCEL_EVENT		*
 * Fisher 11/14/07 ADD_MAP_ID_TO_CHM											*
 *	Folger 07/15/08 QA80-11230 SUPPORT_SHORTCUT_MENU_IN_SCRIPT_PANEL			*
 *	Sophy 1/14/2011 ORG-2018-S1 SQL_EDITOR_NEED_BETTER_SYNTAX_FOR_SQL_STYLE		*
 *	Zech 11/07/2011 ORG-4221-P1 SHOW_CONTEXT_MENU_EVEN_IF_ACTIVE_LAYER_IS_HIDDEN*
 *	Folger 01/17/2012 ORG-4837-P1 CORRECTLY_INSERT_SEMICOLON_IN_WKS_SCRIPT_PANEL*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "DialogEx.h"
#include "SplitterControl.h"
#include "CmdControl.h"
#include <o8dlg.h>

#define PAGE_SPLITTER_CANNOT_RECEIVE_ON_OK_CANCEL_EVENT

#define KEY_MULTI_CMDS			(CNTRL_DOWN || SHIFT_DOWN) 
#define STR_SCRIPT_BIN_STORE	"Script"
#define STR_LT_COMMENT_PREFIX	"//"
#define WM_USER_SAVE_SCRIPT		(WM_USER + 1006)
#define WM_USER_ADD_CMD_HISTORY (WM_USER + 1007)

enum {
	HISTORY_PANEL_MENU_CLEAR,
	
	HISTORY_PANEL_MENU_LAST_ITEM
};
class HistroyPanelMenu : public Menu
{
public:
	HistroyPanelMenu()
	{
		m_nChoice = -1;
		Add(_L("Clear"), OnMenuItem);
	}	
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= HISTORY_PANEL_MENU_CLEAR && m_nChoice < HISTORY_PANEL_MENU_LAST_ITEM)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
private:
	int	m_nChoice;
};
///Jasmine 01/30/07 SAME_BEHAVIOR_WITH_SCRIPT_WINDOW
//add context menu in Script Panel for Script Execution
enum {
	//------ Folger 07/15/08 QA80-11230 SUPPORT_SHORTCUT_MENU_IN_SCRIPT_PANEL
	SCRIPT_PANEL_MENU_CUT,
	SCRIPT_PANEL_MENU_COPY,
	SCRIPT_PANEL_MENU_PASTE,
	SCRIPT_PANEL_MENU_DELETE,
	SCRIPT_PANEL_MENU_SEPARATOR1,
	SCRIPT_PANEL_MENU_SELECT_ALL,
	SCRIPT_PANEL_MENU_SEPARATOR2,
	//------ End SUPPORT_SHORTCUT_MENU_IN_SCRIPT_PANEL
	
	SCRIPT_PANEL_MENU_EXECUTION,
	
	SCRIPT_PANEL_MENU_LAST_ITEM
};

class ScriptPanelMenu : public Menu
{
public:
	//------ Folger 07/15/08 QA80-11230 SUPPORT_SHORTCUT_MENU_IN_SCRIPT_PANEL
	//ScriptPanelMenu(bool bExe)
	ScriptPanelMenu(bool bExe, bool bTextSel)
	//------
	{
		m_nChoice = -1;
		//------ Folger 07/15/08 QA80-11230 SUPPORT_SHORTCUT_MENU_IN_SCRIPT_PANEL
		Add(_L("Cut"), OnMenuItem,  MF_STRING | (bTextSel ? MF_ENABLED : MF_GRAYED));
		Add(_L("Copy"), OnMenuItem,  MF_STRING | (bTextSel ? MF_ENABLED : MF_GRAYED));
		Add(_L("Paste"), OnMenuItem,  MF_STRING);
		Add(_L("Delete"), OnMenuItem,  MF_STRING | (bTextSel ? MF_ENABLED : MF_GRAYED));
		Add(NULL, OnMenuItem, MF_SEPARATOR);
		Add(_L("Select All"), OnMenuItem,  MF_STRING);
		Add(NULL, OnMenuItem, MF_SEPARATOR);
		//------ End SUPPORT_SHORTCUT_MENU_IN_SCRIPT_PANEL
		Add(_L("Script Execution"), OnMenuItem,  MF_STRING | (bExe ? MF_CHECKED: MF_UNCHECKED));
	}	
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		//------ Folger 07/15/08 QA80-11230 SUPPORT_SHORTCUT_MENU_IN_SCRIPT_PANEL
		//if(m_nChoice >= SCRIPT_PANEL_MENU_EXECUTION && m_nChoice < SCRIPT_PANEL_MENU_LAST_ITEM)
		if(m_nChoice >= SCRIPT_PANEL_MENU_CUT && m_nChoice < SCRIPT_PANEL_MENU_LAST_ITEM)
		//------
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
private:
	int	m_nChoice;
};
///End SAME_BEHAVIOR_WITH_SCRIPT_WINDOW
class SimpleHistoryControl : public CodeEdit
{
public:
	SimpleHistoryControl()
	{
	}
	void OnInit()
	{  
		///Sophy 1/14/2011 ORG-2018-S1 SQL_EDITOR_NEED_BETTER_SYNTAX_FOR_SQL_STYLE
		//ColorOptions(CODEEDIT_PARSE_NO_C_COMMENT|CODEEDIT_PARSE_NO_KEY_WORDS);// TD 8-11-05 Disable some colors //|PARSE_NO_OPERATORS|PARSE_NO_QUOTED_STRINGS|PARSE_NO_CHARS
		ColorOptions(CODEEDIT_PARSE_NO_C_COMMENT|CODEEDIT_PARSE_NO_BUILTIN_KEY_WORDS);// TD 8-11-05 Disable some colors //|PARSE_NO_OPERATORS|PARSE_NO_QUOTED_STRINGS|PARSE_NO_CHARS
		///end SQL_EDITOR_NEED_BETTER_SYNTAX_FOR_SQL_STYLE
		ShowCurrentTime();
		int nLines = GetLineCount();
	    LineScroll(-nLines, 0); 
		if(nLines > 30)
	    	LineScroll(nLines - 20, 0);
	}
	void AddCmd(const string& strCmd)
	{
		string strCmdLine = strCmd;
		if(!strCmdLine.Compare("\r\n"))
			return;
		
		if(!strCmdLine.IsEmpty())
			WriteLine(strCmdLine);
	}
	void SetCurrentLayer(LPCSTR lpcszLayer)
	{
		m_strLayer = lpcszLayer;
	}
	void ShowCurrentTime()
	{
		WriteLine();	
		string 	strDate = STR_LT_COMMENT_PREFIX + "--" + m_strLayer + " " + getCurrentTime();
		int 	index = WriteLine(strDate);
		WriteLine();	//CPY 8/3/05 make date line with empty space before commands
	}
	bool OnClear()
	{
		if(IDOK == MessageBox(GetSafeHwnd(), _L("Are you sure?"), _L("History Log"), MB_OK|MB_OKCANCEL|MB_ICONQUESTION)) 
		{  
			Reset();
			ShowCurrentTime(); 
			return true;
		}
		return false;
	}	
private:	
	string getCurrentTime()
	{
		SYSTEMTIME st;
		get_current_time(st);  		// gets current time, 
		double dDate;
		SystemTimeToJulianDate(&dDate, &st);		
		return get_date_str(dDate, LDF_SHORT_AND_HHMM_SEPARCOLON);
	}
private:
	string 	m_strLayer;
};

class SimpleCmdControl : public CmdControl
{
public:
	///Jasmine 01/30/07 SAME_BEHAVIOR_WITH_SCRIPT_WINDOW
	SimpleCmdControl()
	{
		m_bExe = true;
	}
protected:
	virtual bool OnEnterKey(int nStart, int nEnd)
	{
		if(!m_bExe)
			return FALSE;
		char cLastBeforeTrim = 0;
		char cLastChar = GetLastChar(true, &cLastBeforeTrim);
		bool bMultiCmds = false; 
		int nLine = LineFromChar(nStart);
		string strCmd;
		if(KEY_MULTI_CMDS)
		{
			strCmd = GetLine(nLine);
			strCmd.TrimRight('\n');
			strCmd.TrimRight('\r');
			///Jasmine 01/30/07 SAME_BEHAVIOR_WITH_SCRIPT_WINDOW, add ";" if bExe = true and Shift key down
			if(m_bExe && lstrlen(strCmd) && SHIFT_DOWN && ";" != GetText(nEnd-1, nEnd))//cLastChar != ';')
			{
				string str = Text;
				str.Insert(nEnd ,";");
				Text = str;
				SetSel(nEnd+1, nEnd + 1);
			}			
			bMultiCmds = true;
			return FALSE;
		}
		if( !bMultiCmds )
		{	
			/*	//for debug
			string strGetCmdLine = "GetCmdLine:"+GetCmdLine();
			OUT(strGetCmdLine);
			string strGetSelText = "GetSelText:"+GetSelText();
			OUT(strGetSelText);
			string strGetLine = "GetLine:"+GetLine(nLine);		
			OUT(strGetLine);
			*/
			bool bNewLine = true;
			strCmd = GetSelText();		
			if(!lstrlen(strCmd))
			{
				strCmd = GetLine(nLine);
				int nLen = lstrlen(strCmd);	
				strCmd.TrimRight('\n');
				int nLen2 = lstrlen(strCmd);
				int nFirst  = LineIndex(nLine);
				if(nFirst + nLen - 1 == nEnd || nFirst + nLen2 - 1 == nEnd)//at the end of a row
				{//hit enter at the end of a line
					strCmd.TrimRight('\r');
					if(!lstrlen(strCmd) || ";" == GetText(nEnd-1, nEnd))//if with ";" at the end, act like ctrl + enter 
						return FALSE;
					//add ";" and execute
					string str = Text;
					///------ Folger 01/17/2012 ORG-4837-P1 CORRECTLY_INSERT_SEMICOLON_IN_WKS_SCRIPT_PANEL
					//str.Insert(nEnd++ ,";");
					int		nPos = str.Find(strCmd);
					str.Insert(nPos + strCmd.GetLength(), ";");
					///------ End CORRECTLY_INSERT_SEMICOLON_IN_WKS_SCRIPT_PANEL
					Text = str;
					if(m_bExe)
						OnCmd(strCmd, false);
					return FALSE;
				}
				bNewLine = false;//just move to end
			}
			if(m_bExe)
				OnCmd(strCmd, false);
			MoveToEnd(true);
			strCmd = GetLine();
			strCmd.TrimRight('\n');
			strCmd.TrimRight('\r');
			ShowPrompt(bNewLine && lstrlen(strCmd));//after executing Text selected, move to end and write line if last line not empty
		}
		return TRUE;
	}
	///End SAME_BEHAVIOR_WITH_SCRIPT_WINDOW
public:
	void OnCmd(const string& strCmd, bool bAddNewLine = true)
	{ 	
		if(bAddNewLine)
			WriteLine();
		if(Execute(strCmd))
		{
			Window Wnd = GetParent();
			if(Wnd)
				Wnd.PostMessage(WM_USER_ADD_CMD_HISTORY);
		}	
		MoveToEnd(true);
	}
	void OnInit()
	{
		SetFont(GetFont());
		LimitText(200 * 1024);
	}
	void ShowPrompt(bool bAddNewLine = true)
	{
		if(bAddNewLine)
			WriteLine();
		int nStart;
		GetSel(nStart, m_nPromptPosition);
		MoveToEnd(true);
	}
	bool OnKeyCmd(UINT msg, UINT wParam, UINT lParam)
	{
		int nStart, nEnd;
		int nSel = GetSelCheckPos(nStart, nEnd);
		if( !IsCmdKey(wParam) )
			return false;
		if(msg == WM_CHAR)
			return false; // indicate default processing		
		if(msg != WM_KEYDOWN)
			return true;// we need to eat all other message related to Enter key
		switch(wParam)
		{
		case VK_RETURN:
			if(nSel == REPOS_UNEDITABLE) // Support selection execution
			{
				string strAddText = GetSelText();
				if(!lstrlen(strAddText))
				{
					int nLine = LineFromChar(nStart);
					string strCmd = GetLine(nLine);
					strCmd.Replace(GetPrompt(),"");
					//strCmd.Replace("\r\n","");
				}
			}
			return OnEnterKey(nStart, nEnd);
			break;
		case VK_LEFT: case VK_RIGHT: case VK_BACK: case VK_DELETE: case VK_UP: case VK_DOWN: case VK_HOME: case VK_END:	
			return false;
			break;	
		}
		return true; // no more default processing	
	}
	bool Execute(LPCSTR lpcszCmd)
	{
		string strCmdCopy = lpcszCmd;
		strCmdCopy.Replace(GetPrompt(),"");
		TrimCmd(strCmdCopy);
		if(strCmdCopy.IsEmpty())
			return false;
		bool bRet = false;
		strCmdCopy = ";" + strCmdCopy;///Jasmine 12/27/06 INSERT_SEMICOLON_TO_DELAY_EXECUTE
		//HWND hWndOutputOld = set_LT_script_window(GetSafeHwnd());
		//int nCtrl = (str_end_char(strCmdCopy)==';') ? 0: LTXF_DUMP_OUTPUT_TREE;		
		if(!LT_execute(strCmdCopy))//, nCtrl))
		{
			string strDebug = "#Command Error!";
			OUT(strDebug);
		}
		else
		{
			bRet = true;
			SetCmd(strCmdCopy); // was for both, moved here so only if success execution
		}		
		//set_LT_script_window(hWndOutputOld);
		SetFocus(GetSafeHwnd());
		return bRet;
	}
	///Jasmine 01/30/07 SAME_BEHAVIOR_WITH_SCRIPT_WINDOW
	bool GetExeState(){ return m_bExe;	}
	void ToggleExeState(){m_bExe = !m_bExe;	}

	//------ Folger 07/15/08 QA80-11230 SUPPORT_SHORTCUT_MENU_IN_SCRIPT_PANEL
	void OnDelete()
	{
		ReplaceSel("");
	}

	void OnCut()
	{
		Copy();
		OnDelete();
	}

	void OnSelectAll()
	{
		SetSel(0, -1);
	}
	//------ End SUPPORT_SHORTCUT_MENU_IN_SCRIPT_PANEL
	
private:
	bool m_bExe;//Script Execution
	///End SAME_BEHAVIOR_WITH_SCRIPT_WINDOW
};

class ScriptPanelSplitter : public SplitterControl
{
public:	
	ScriptPanelSplitter()
	{
		SetGridSize(2, 1);		
		m_IDHistoryPanel = GetDlgCtrlID();
		m_IDScriptPanel = GetDlgCtrlID(1, 0);
		InitMsgMap();
	}
	void Init(int nCntrlID, WndContainer& wndParent, LPCSTR lpcszDlgName, LPCSTR lpcszLayer)
	{
		m_reHistory.SetCurrentLayer(lpcszLayer);
		SplitterControl::Init(nCntrlID, wndParent, 0, lpcszDlgName);
	}
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)	
	ON_SIZE(OnCtrlResize)
	ON_USER_MSG(WM_USER_RESIZE_CONTROLS, OnInitPaneSizs)	///Jasmine 04/07/06 SPLITTER_INIT_SIZE_NOT_CALL
	ON_DESTROY(OnDestroy)
	ON_KEY(m_IDScriptPanel, OnKeyScriptPanel)
	ON_CONTEXTMENU(OnShowMenu)
	ON_USER_MSG(WM_USER_ADD_CMD_HISTORY, OnHistoryAddCmd)
	ON_EN_KILLFOCUS(m_IDScriptPanel, OnKillFocus)
	ON_EN_KILLFOCUS(m_IDHistoryPanel, OnKillFocus)
EVENTS_END
	BOOL OnInitDialog()
	{
		DWORD dwStyle = WS_CHILD | WS_VISIBLE  | ES_MULTILINE| ES_AUTOVSCROLL | ES_AUTOHSCROLL | WS_VSCROLL | WS_HSCROLL | WS_EX_WINDOWEDGE | ES_WANTRETURN;
		CreatePane(m_reScript, 1, 0, -1, -1, dwStyle);
		dwStyle |= ES_READONLY;
		CreatePane(m_reHistory, 0, 0, -1, -1, dwStyle);
		m_reScript.OnInit();
		m_reHistory.OnInit(); 
		SetReady();
		return TRUE;
	}
	BOOL OnCtrlResize(int nType, int cx, int cy)
	{
		SplitterControl::OnResize(nType, cx, cy);
		return TRUE;
	}
	BOOL OnKeyScriptPanel(Control oCntrl, UINT msg, UINT wParam, UINT lParam)
	{
		bool bRet = m_reScript.OnKeyCmd(msg, wParam, lParam);
		return bRet;
	}
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{ 
		if(m_IDHistoryPanel == nResIDCtrl)
			return ShowHistoryPanelMenu(nx, ny);
		if(m_IDScriptPanel == nResIDCtrl)///Jasmine 01/30/07 SAME_BEHAVIOR_WITH_SCRIPT_WINDOW
			return ShowScriptPanelMenu(nx, ny);
		return FALSE;
	}
	bool ShowHistoryPanelMenu(int nx, int ny)
	{
		int nCmd;
		HistroyPanelMenu myMenu();
		myMenu.TrackPopupMenu(0,  nx, ny, GetWindow());
		if(myMenu.GetCommand(nCmd))
		{			
			switch(nCmd)
			{	
			case HISTORY_PANEL_MENU_CLEAR:
				m_reHistory.OnClear();
				return TRUE;
			default:
				break;
			}
		}	
		return FALSE;
	}
	///Jasmine 01/30/07 SAME_BEHAVIOR_WITH_SCRIPT_WINDOW
	bool ShowScriptPanelMenu(int nx, int ny)
	{
		int nCmd;
		//------ Folger 07/15/08 QA80-11230 SUPPORT_SHORTCUT_MENU_IN_SCRIPT_PANEL
		//ScriptPanelMenu myMenu(m_reScript.GetExeState());
		ScriptPanelMenu myMenu(m_reScript.GetExeState(), !m_reScript.IsSelEmpty());
		//------
		myMenu.TrackPopupMenu(0,  nx, ny, GetWindow());
		if(myMenu.GetCommand(nCmd))
		{			
			switch(nCmd)
			{
			//------ Folger 07/15/08 QA80-11230 SUPPORT_SHORTCUT_MENU_IN_SCRIPT_PANEL
			case SCRIPT_PANEL_MENU_CUT:
				m_reScript.OnCut();
				return TRUE;
				
			case SCRIPT_PANEL_MENU_COPY:
				m_reScript.Copy();
				return TRUE;
				
			case SCRIPT_PANEL_MENU_PASTE:
				m_reScript.Paste();
				return TRUE;
				
			case SCRIPT_PANEL_MENU_DELETE:
				m_reScript.OnDelete();
				return TRUE;
				
			case SCRIPT_PANEL_MENU_SELECT_ALL:
				m_reScript.OnSelectAll();
				return TRUE;
			//------ End SUPPORT_SHORTCUT_MENU_IN_SCRIPT_PANEL
				
			case SCRIPT_PANEL_MENU_EXECUTION:
				m_reScript.ToggleExeState();
				return TRUE;
			default:
				break;
			}
		}	
		return FALSE;
	}
	///End SAME_BEHAVIOR_WITH_SCRIPT_WINDOW
	BOOL OnHistoryAddCmd(uint wParam, uint lParam)
	{
		string str = m_reScript.GetCmd();
		m_reHistory.AddCmd(str);	
		return true;
	}
	BOOL OnKillFocus(Control ctrl)
	{
		Window Wnd = GetParent();
		if(Wnd)
			Wnd.SendMessage(WM_USER_SAVE_SCRIPT);
		return TRUE;
	}
public:
	void OnReady()
	{
		SplitterControl::OnReady();	
		SetReady();	
	}
	BOOL OnDestroy()
	{
		return SplitterControl::OnDestroy();
	}
	string GetScript(bool bScript = true)
	{
		if(bScript)
			return m_reScript.Text;
		return m_reHistory.Text;
	}
	bool SetScript(LPCSTR lpcszScript, LPCSTR lpcszHistory = NULL)
	{
		string strScript(lpcszScript);
		m_reScript.Text = strScript;
		if(lstrlen(lpcszHistory))
		{
			string strHistory(lpcszHistory);
			m_reHistory.Text = strHistory;
		}
		return true;
	}
	bool ExecuteAllScript()
	{
		m_reScript.OnCmd(m_reScript.Text, false);
		return true;
	}
	void SetCurrentLayer(LPCSTR lpcszLayer)
	{
		m_reHistory.SetCurrentLayer(lpcszLayer);
		m_reHistory.ShowCurrentTime();
	}
private:
	SimpleCmdControl		m_reScript;
	SimpleHistoryControl	m_reHistory;
	int						m_IDScriptPanel;
	int						m_IDHistoryPanel;
};

class OC_REGISTERED ScriptPanel : public ResizeDialog
{
public:
	ScriptPanel() : ResizeDialog(IDD_WK_SCRIPT_PANEL, "ODlg8")
	{
		/// Zech 11/07/2011 ORG-4221-P1 SHOW_CONTEXT_MENU_EVEN_IF_ACTIVE_LAYER_IS_HIDDEN
		//m_pg = Project.ActiveLayer().GetPage();
		m_pg = Project.Pages();
		/// END SHOW_CONTEXT_MENU_EVEN_IF_ACTIVE_LAYER_IS_HIDDEN
	}
	~ScriptPanel()
	{
	}	
	BOOL CreateWindow(int nID, HWND hWnd)
	{
		InitMsgMap();
		int nRet = Dialog::Create(hWnd, DLG_AS_CHILD);
		HWND hWndThis = GetSafeHwnd();
		SetWindowLong(hWndThis, GWL_ID, nID);
		return nRet;
	}
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)
	ON_DESTROY(OnDestroy)
	ON_HELPINFO(OnHelp)
#ifdef PAGE_SPLITTER_CANNOT_RECEIVE_ON_OK_CANCEL_EVENT
	ON_BN_CLICKED(IDCANCEL, OnCancel)
#else
	ON_CANCEL(OnClickCancel)
#endif//PAGE_SPLITTER_CANNOT_RECEIVE_ON_OK_CANCEL_EVENT
	ON_SIZE(OnDlgResize)
	ON_CHANGE_LAYER(OnChangeLayer)
	ON_BN_CLICKED(IDC_EXECUTE_BTN, OnExecuteAll)
	ON_USER_MSG(WM_USER_SAVE_SCRIPT, OnSaveScript)
EVENTS_END

	//------ fisher 11/14/07 ADD_MAP_ID_TO_CHM
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		nHelpID = IDD_SCRIPT_PANEL;
		return true;
	}
	
	BOOL OnInitDialog()
	{
		ResizeDialog::OnInitDialog(IDC_WKSCRIPT_BOX);
		m_splitter.Init(IDC_WKSCRIPT_BOX, *this, "ScriptPanel", m_pg.Layers().GetName());
		string strHistory;
		string strScript = GetScript(&strHistory);
		m_splitter.SetScript(strScript, strHistory);
		return TRUE;
	}
	BOOL OnReady()
	{			
		SetInitReady();
		m_splitter.OnReady();		
		return true;
	}
	BOOL OnDestroy()
	{
		SetScript(m_splitter.GetScript(), m_splitter.GetScript(false));
		ResizeDialog::OnDestroy();
		m_splitter.OnDestroy();
		return TRUE;
	}
#ifdef PAGE_SPLITTER_CANNOT_RECEIVE_ON_OK_CANCEL_EVENT
	BOOL OnCancel(Control ctrl)
	{		
		LT_execute(";page -sps");
		return TRUE;
	}
#else
	BOOL OnClickCancel()
	{
		LT_execute(";page -sps");
		return TRUE;
	}
#endif//PAGE_SPLITTER_CANNOT_RECEIVE_ON_OK_CANCEL_EVENT
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		vector<uint> nBtns = { IDC_EXECUTE_BTN, IDCANCEL, 0};
		ArrangeControlsCenterBottom(nBtns, cx, cy, GetControlGap(), false);
		RECT rr, rBtn;
		GetControlClientRect(IDC_EXECUTE_BTN, rBtn);
		PositionControl(IDC_WKSCRIPT_BOX,0,0);
		SizeControl(IDC_WKSCRIPT_BOX, cx, rBtn.top-GetControlGap());
		m_splitter.OnDlgResize(nType, cx, rBtn.top-GetControlGap());
		return TRUE;
	}
	BOOL OnChangeLayer()
	{
		Page pg = Project.Pages();
		if ( pg.IsValid() )	///Sophy 6/12/2010 ORG-251 FIX_RUNTIME_ERROR_WHEN_OPEN_OPJ_WITH_NOTES_ACTIVE
		{
			string strName = pg.GetName();
			if(!strName.CompareNoCase(m_pg.GetName()))
				m_splitter.SetCurrentLayer(m_pg.Layers().GetName());
			return TRUE;
		}
		return FALSE;
	}
	BOOL OnExecuteAll(Control ctrl)
	{
		return m_splitter.ExecuteAllScript();
	}
	#define PAGE_NAME    "PageName"
	BOOL GetSettings(TreeNode &nodeSettings, Page &page)
	{
		if(nodeSettings)
		{
			SetScript(m_splitter.GetScript(), m_splitter.GetScript(false));
			TreeNode tn = nodeSettings.AddNode(PAGE_NAME);
			tn.strVal = m_pg.GetName();
		}
    	return TRUE;
	}	 
	BOOL SetSettings(TreeNode &nodeSettings, Page &page)
	{
		if(nodeSettings)
		{
	  		if(page)// open project will have invalif page
	  		{
	  			m_pg = page; 
	  		}
		}
		return TRUE;
	}
public:
	BOOL OnSaveScript(uint wParam, uint lParam)
	{
		SetScript(m_splitter.GetScript(), m_splitter.GetScript(false));
		return TRUE;
	}
	string GetScript(string* pstrHistory = NULL)
	{
		string strScript;
		Tree trScript;
		if(m_pg.IsValid())
			m_pg.GetBinaryStorage(STR_SCRIPT_BIN_STORE, trScript);
		if(trScript.Script.IsValid())
			strScript = trScript.Script.strVal;
		if(trScript.History.IsValid() && pstrHistory)
			*pstrHistory = trScript.History.strVal;
		return strScript;
	}
	bool SetScript(LPCSTR lpcszScript, LPCSTR lpcszHistory = NULL)
	{
		string strScript(lpcszScript), strHistory(lpcszHistory);
		Tree trScript;
		trScript.Script.strVal = strScript;		
		trScript.History.strVal = strHistory;	
		if(!m_pg.IsValid())
			return false;
		m_pg.PutBinaryStorage(STR_SCRIPT_BIN_STORE, trScript);
		return true;
	}
private:
	ScriptPanelSplitter		m_splitter;
	Page					m_pg;
};
