/*------------------------------------------------------------------------------*
 * File Name:ResizeControl.h													*
 * Creation: TD 9/5/2003														*
 * Purpose: OriginC Header file for Panel control base class					*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 1/20/04 CHANGE_GRID_CONTROL_TO_WORK_WITH_PROPERTY_PAGE					*
 *  DG 4/27/05 QA70-7581 v8.0227 TREE_CTRL_IN_PROPERTYPAGE_NEED_MSG				*
 *	Folger 07/02/10 ORG-436-S1 TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST	*
 *	Folger 07/05/10 ORG-436 BETTER_USE_OC_DEVICE_CONTEXT						*
 *	Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS		*
 *------------------------------------------------------------------------------*/
#ifndef _RESIZE_CONTROL_H_
#define _RESIZE_CONTROL_H_

#define STR_INCREASE_HEIGHT	_L("Enlarge Panel")
#define STR_DECREASE_HEIGHT	_L("Shrink Panel")

// base class for a control that can serve as the main control in a control group
// that we call a Panel
class ResizeControl
{
public:
	ResizeControl()
	{
		/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		m_pWndDlg = NULL;
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}
	~ResizeControl()
	{
	}
	//---- CPY 1/20/04 CHANGE_GRID_CONTROL_TO_WORK_WITH_PROPERTY_PAGE
	//void InitControl(int nID, Dialog& dlg)
	//void InitControl(int nID, WndContainer& dlg)	///DG TREE_CTRL_IN_PROPERTYPAGE_NEED_MSG
	void InitControl(int nID, WndContainer& dlg, WndContainer* pParentDlg = NULL)
	//----
	{
		m_cntrl 	= dlg.GetDlgItem(nID);
		
		///DG TREE_CTRL_IN_PROPERTYPAGE_NEED_MSG
		if(NULL != pParentDlg)
		{
			/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
			//Window wTemp(pParentDlg->GetSafeHwnd());
			//m_wndDlg = wTemp;
			m_pWndDlg = pParentDlg;
			/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
			return;
		}
		///end TREE_CTRL_IN_PROPERTYPAGE_NEED_MSG
		
		//---- CPY 1/20/04 CHANGE_GRID_CONTROL_TO_WORK_WITH_PROPERTY_PAGE
		// following code does not work, so Tarak suggested a dirty temp solution
		//m_wndDlg.Attach(dlg);
		/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//Window wTemp(dlg.GetSafeHwnd());
		//m_wndDlg = wTemp;
		m_pWndDlg = &dlg;
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//---- end 
	}
	void GetRect(RECT& rect)
	{
		m_cntrl.GetWindowRect(&rect);
		/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//m_wndDlg.ScreenToClient(&rect);
		m_pWndDlg->ScreenToClient(&rect);
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}
	void ClientToScreen(RECT& rect)
	{
		/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//m_wndDlg.ClientToScreen(&rect);
		m_pWndDlg->ClientToScreen(&rect);
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}
	void ScreenToClient(RECT& rect)
	{
		/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//m_wndDlg.ScreenToClient(&rect);
		m_pWndDlg->ScreenToClient(&rect);
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}
	void GetWindowRect(RECT& rect)
	{
		m_cntrl.GetWindowRect(&rect);
	}
	/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//string FontName() {return m_wndDlg.FontName;}
	//int	FontSize() {return m_wndDlg.FontSize;}
	string FontName() {return m_pWndDlg->FontName;}
	int	FontSize() {return m_pWndDlg->FontSize;}
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	void PostDlgMessage(uint msg, DWORD wParam = 0, DWORD lParam = 0)
	{
		/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//m_wndDlg.PostMessage(msg, wParam, lParam);
		m_pWndDlg->PostMessage(msg, wParam, lParam);
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}
	///----Frank 11/16/05 QA70-8293 RETURN_FALSE_IF_NOT_HANDLE_IN_ROW_AND_RC
	void SentDlgMessage(uint msg, DWORD wParam = 0, DWORD lParam = 0)
	{
		/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//m_wndDlg.SendMessage( msg, wParam, lParam);
		m_pWndDlg->SendMessage(msg, wParam, lParam);
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}
	///----End RETURN_FALSE_IF_NOT_HANDLE_IN_ROW_AND_RC
	HWND	GetDlgSafeHwnd()
	{
		/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//return m_wndDlg.GetSafeHwnd();
		return m_pWndDlg->GetSafeHwnd();
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}

	///------ Folger 07/02/10 ORG-436-S1 TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST
	HWND	GetCtrnlSafeHwnd()
	{
		return *GetControl() ? GetControl()->GetSafeHwnd() : NULL;
	}
	///------ End TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST

	virtual bool SetVisible(bool bSet = true)
	{
		bool bOldVal = IsVisible();
		if(m_cntrl)
			m_cntrl.Visible = bSet;
		return bOldVal;
	}
	virtual bool IsVisible()
	{
		if(m_cntrl)
		{
			if(m_cntrl.Visible)
				return true;
		}
		return false;
	}
	void SetToolTipsText(const string& str, bool bCheckSame = true)
	{
		if(bCheckSame && m_strLastTooltips.CompareNoCase(str) == 0)
			return;
		
		m_cntrl.SetToolTip(str);
		m_strLastTooltips = str;
	}
	void MoveWindow(RECT& rect)
	{
		m_cntrl.MoveWindow(&rect);
	}
	int PixelsToTwips(int pixels, bool bX=true)
	{
		///------ Folger 07/05/10 ORG-436 BETTER_USE_OC_DEVICE_CONTEXT
		//DeviceContext dc = m_cntrl.GetDC();
		DeviceContext dc(m_cntrl);
		///------ End BETTER_USE_OC_DEVICE_CONTEXT
		double vv = 0.5 + pixels * 1440.0 / dc.GetDeviceCaps(bX? LOGPIXELSX : LOGPIXELSY);
		return vv;
	}
	int TwipsToPixels(int twips, bool bX=true)
	{
		///------ Folger 07/05/10 ORG-436 BETTER_USE_OC_DEVICE_CONTEXT
		//DeviceContext dc = m_cntrl.GetDC();
		DeviceContext dc(m_cntrl);
		///------ End BETTER_USE_OC_DEVICE_CONTEXT
		
		double vv = 0.5 + dc.GetDeviceCaps(bX? LOGPIXELSX : LOGPIXELSY) * (double)twips / 1440.0;
		return vv;
	}
public:
	virtual bool IsResize(bool bOnExpand = true) { return IsVisible();}
	/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//virtual int	GetPanelHeight(bool bGetMin = false) {return 0;}
	//virtual int GetPanelWidth(bool bGetMin = false) {return 0;}
	//
	//virtual int GetMinHeight(bool bKeepFunctional = false) {return 24;}
	//virtual int GetMaxHeight(bool bKeepFunctional = false)	{return GetSystemMetrics(SM_CYSCREEN)/2;}
	virtual int GetCtrlMinWidth()								{return 0;}
	virtual int GetCtrlMinHeight()								{return 24;}
	// minus/zero integer means no limitation on vertical direction
	virtual int GetCtrlMaxHeight(bool bKeepFunctional = false)	{return -1;}

	// Normally we have more controls around this main panel control, here I assume only the main panel can be resized.

	// If this panel has some additional control above this main control, then we need them for calculating size
	virtual int GetExtraHeightAbove()							{return 0;}

	// If this panel has some additional control above this main control, then we need them for calculating size
	virtual int GetExtraHeightBelow()							{return 0;}

	int GetAdditionalHeight()									{return GetExtraHeightAbove() + GetExtraHeightBelow();}

	virtual int GetMinWidth()									{return GetCtrlMinWidth();}
	virtual int GetMinHeight()									{return GetCtrlMinHeight() + GetAdditionalHeight();}
	virtual int GetMaxHeight(bool bKeepFunctional = false)
	{
		int nCtrlMaxHeight = GetCtrlMaxHeight(bKeepFunctional);
		if ( nCtrlMaxHeight > 0 )
		{
			nCtrlMaxHeight += GetAdditionalHeight();
		}
		return nCtrlMaxHeight;
	}
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	virtual string GetRuntimeClass()
	{
		return "ResizeControl";
	}
	// when using this control as the Main control of a Panel (group)
	virtual int GetHeight(bool bDefault = false)
	{		
		RECT r1;
		GetRect(r1);//GetWindowRect(r1);	///Jasmine 04/16/07 BE_SAME_WITH_SET+HEIGHT
		/// Kenny 12/13/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//return RECT_HEIGHT(r1);
		return RECT_HEIGHT(r1) + GetAdditionalHeight();
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}
	// must return actual height, control might have minimum height
	virtual int SetHeight(int nHeight)
	{
		RECT r1;
		if(nHeight < GetMinHeight())
			return GetHeight();
		/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//if(nHeight > GetMaxHeight())
		//	nHeight = GetMaxHeight();
		int nMaxHeight = GetMaxHeight();
		// If max height is minus integer then no limitation on vertical direction
		if ( nMaxHeight > 0 && nHeight > nMaxHeight )
			nHeight = nMaxHeight;
		nHeight -= GetAdditionalHeight();
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		GetRect(r1);
		r1.bottom = r1.top + nHeight;
		MoveWindow(r1);
		return GetHeight();
	}
protected:
	Control*	GetControl() 
	{
		if(m_cntrl)
			return &m_cntrl;
		return NULL;
	}
	
	Window*		GetDialogWindow()
	{
		/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//if( m_wndDlg )
		//	return &m_wndDlg;
		//
		//return NULL;
		return m_pWndDlg;
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}
private:
	Control 	m_cntrl;
	/// Kenny 12/12/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//Window		m_wndDlg;
	WndContainer*	m_pWndDlg;
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	string		m_strLastTooltips;
};

#endif //_RESIZE_CONTROL_H_

