/*------------------------------------------------------------------------------*
 * File Name: RangeBrowser.c 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 07/17/07 IMPLEMENT_DIALOG_FUNCTION									*
 *	Jasmine 09/28/07 QA70-10305 FILTER_OUT_NON_IMAGE_MATRIX						*
 *	Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS			*
 *	Sophy 9/17/2009 SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE			*
 *	Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES						*
 *	Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT						*
 *	Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <ocu.h>
#include "DialogEx.h"
#include "PBListBase.h"
#include "PBRangeList.h"		//-------Folger 07/17/07 IMPLEMENT_DIALOG_FUNCTION
#include "RangeBrowser.h"

///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX
//BOOL RangeBrowser(vector<string>& vsResult, HWND hParent, int nPageType, bool bXYRange = false, bool bMultipleSelect = true, bool bResultSheet = false, LPCSTR lpcszDlg = NULL)
/// Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
//BOOL RangeBrowser(vector<string>& vsResult, HWND hParent, int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL)
///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
//BOOL RangeBrowser(vector<string>& vsResult, HWND hParent, int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL, UINT nSelectedColUID = 0)
///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
//BOOL RangeBrowser(vector<string>& vsResult, HWND hParent, int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL, UINT nSelectedObjUID = 0)
///------ Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
//BOOL RangeBrowser(vector<string>& vsResult, HWND hParent, int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL, UINT nSelectedObjUID = 0, LPCSTR lpcszBookSheetSpecified = NULL)
BOOL RangeBrowser(vector<string>& vsResult, HWND hParent, int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL, UINT nSelectedObjUID = 0, void* pOpenColumnBrowserMore = NULL)
///------ End BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
{
	/// Kenny 09/15/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	//RangeListDlg myDlg(nPageType, bXYRange, bMultipleSelect, dwFilter, lpcszDlg
	///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
	//bool bIsObjRangeBrowser = EXIST_WKS == nPageType && !bXYRange && nSelectedColUID > 0;
	bool bIsObjRangeBrowser = !bXYRange && nSelectedObjUID > 0;
	///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
	DWORD dwCtrls = bIsObjRangeBrowser ? RNGBROWSER_ENABLE_INSERT_MODE : 0;
	///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
	//RangeListDlg myDlg(nPageType, bXYRange, bMultipleSelect, dwFilter, lpcszDlg, dwCtrls);
	///------ Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
	//RangeListDlg myDlg(nPageType, bXYRange, bMultipleSelect, dwFilter, lpcszDlg, dwCtrls, lpcszBookSheetSpecified);
	RangeListDlg myDlg(nPageType, bXYRange, bMultipleSelect, dwFilter, lpcszDlg, dwCtrls, (OpenColumnBrowserMore*)pOpenColumnBrowserMore);
	///------ End BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
	///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
	/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
///End FILTER_OUT_NON_IMAGE_MATRIX
	myDlg.SetSelectedItems(vsResult);
	
	int nRet = myDlg.DoModalEx(hParent);
	//----- CPY
	if(nRet != IDOK)
		return FALSE;
	//-----
	if( 0 ==myDlg.GetSelectedItems(vsResult))
		return FALSE;

	/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	if ( bIsObjRangeBrowser )
	{
		PFN_GET_WORKSHEET_OBJ_BY_COL_UID pfn_get_worksheet_obj_by_col_uid = Project.FindFunction("get_worksheet_obj_by_col_uid", "Originlab\\event_utils.c", true);
		PFN_SMART_UPDATE_OBJ_RANGE pfn_smart_update_obj_range = Project.FindFunction("smart_update_obj_range", "Originlab\\event_utils.c", true);
		if ( pfn_get_worksheet_obj_by_col_uid && pfn_smart_update_obj_range )
		{
			int nInsertMode = myDlg.GetInsertMode();
			ObjNameInfo info;
			///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
			//info.nSelectedColUID = nSelectedColUID;
			info.nSelectedObjUID = nSelectedObjUID;
			///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
			info.nInsertMode = nInsertMode;
			info.nObjLevel = PTL_OBJ;
			info.bFullRange = false;
			info.dwSmartCtrl = SMART_RANGE_VAR | SMART_TRIM_CLN;	///Sophy 9/17/2009 SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE ///Sophy 9/18/2009 SMART_PAGE_FAIL_TO_SOLVE_RANGE_WHEN_SHEETNAME_HAS_WHITE_SPACE_AND_COLUMN_HAS_LONGNAME
			for (int ii = 0; ii < vsResult.GetSize(); ++ii)
			{
				///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
				//Column col;
				//if ( okxf_resolve_string_get_origin_object(vsResult[ii], &col) && col )
				int nObjUID = 0;
				if( nPageType == EXIST_WKS )
				{
					Column col;
					if ( okxf_resolve_string_get_origin_object(vsResult[ii], &col) && col )
						nObjUID = col.GetUID(true);
				}
				else if( nPageType == EXIST_MATRIX )
				{
					MatrixObject obj;
					if ( okxf_resolve_string_get_origin_object(vsResult[ii], &obj) && obj )
						nObjUID = obj.GetUID(true);
				}
				if ( nObjUID != 0 )
				///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
				{
					///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
					//bool bRet = pfn_get_worksheet_obj_by_col_uid(col.GetUID(TRUE), info.wkp, info.wks, info.col);
					Datasheet ds;
					bool bRet = pfn_get_worksheet_obj_by_col_uid(nObjUID, info.pg, ds, info.obj);
					info.layer = ds;
					///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
					ASSERT(bRet);
					bRet = pfn_smart_update_obj_range(vsResult[ii], info);
					ASSERT(bRet);
				}
			}
		}
		else
		{
			ASSERT(0);
		}
	}
	/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	return TRUE;
}
/*test
void _op()
{
	vector<string> vsResult;
	RangeBrowser(vsResult, NULL, EXIST_MATRIX, false);
}
*/