/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// you can include just this typical header file for most Origin built-in functions and classes
// and it takes a reasonable amount of time to compile, 
#include <origin.h>
// this file include most of the other header files except the NAG header, which takes longer to compile
// NAG routines
//#include <OC_nag.h> // this contains all the NAG headers, 

////////////////////////////////////////////////////////////////////////////////////
///DSC 1/11/07 REMOVE_LOCAL_H #include "$local.h"
//-------------------------------------------------------------------------------
BOOL CheckConvertMatrixData(MatrixLayer SrcMatrix)
{
	BOOL bReturn = FALSE;
	if( !SrcMatrix.HasData() )
	{
		string strMatrixName;
		SrcMatrix.GetPage().GetName(strMatrixName);
		
		string strMessage;
		strMessage.Format(ROI_CREATE_CROP_ON_NON_CONVERTED_MATRIX, strMatrixName, strMatrixName);
		
		if( IDYES == MessageBox(GetWindow(), strMessage, "", MB_YESNO MB_ICONQUESTION) )
		{
			bReturn = SrcMatrix.SetViewImage(FALSE);
			bReturn = (bReturn && SrcMatrix.SetViewImage(TRUE));//this will do the conversion and return to image view
		}
	}
	else
		bReturn = TRUE;
	
	return bReturn;
}

void Copy(string strObjectName = "ROI", string strMatrixName = "Matrix1")
{
	MatrixLayer MatrixToCopy(strMatrixName);
	GraphObject grObject;
	grObject = MatrixToCopy.GraphObjects(strObjectName);
	string strObjectType = grObject.GetObjectType();
	if( strObjectType.Compare("Rectangle") == 0 )
		LT_execute("matrix -ib ROI.x1 ROI.y1 ROI.x3 ROI.y3");//old copy for now
	else
		MessageBox(GetWindow(),ROI_COPY_NON_RECT);
}

//-------------------------------------------------------------------------------
BOOL Crop(string strObjectName = "ROI", string strMatrixName = "Matrix1")
{
	MatrixLayer MatrixToCrop(strMatrixName);
	GraphObject grObject;
	grObject = MatrixToCrop.GraphObjects(strObjectName);
	BOOL bReturn = FALSE;
	
	string strObjectType = grObject.GetObjectType();
	if( strObjectType.Compare("Rectangle") == 0 && !MatrixToCrop.HasData() )
	{
		int Left 	= (int) (grObject.X - grObject.DX / 2);
		int Right 	= (int) (grObject.X + grObject.DX / 2);
		int Top 	= (int) (grObject.Y - grObject.DY / 2);
		int Bottom 	= (int) (grObject.Y + grObject.DY / 2);
		
		bReturn = MatrixToCrop.CopyImage(MatrixToCrop, Left, Top, Right, Bottom);
	}
	else if( CheckConvertMatrixData(MatrixToCrop) )
	{
		bReturn = MatrixToCrop.CopyImage(MatrixToCrop, grObject);
	}
		
	if( bReturn )
		LT_execute("label - r " + strObjectName);
		
	return bReturn;
}

//-------------------------------------------------------------------------------
BOOL CreateNew(string strObjectName = "ROI", string strMatrixName = "Matrix1")
{
	MatrixLayer SrcMatrix(strMatrixName);
	
	GraphObject grObject;
	grObject = SrcMatrix.GraphObjects(strObjectName);
	
	MatrixLayer DestMatrix;
	BOOL bReturn = FALSE;
	
	string strObjectType = grObject.GetObjectType();
	if( strObjectType.Compare("Rectangle") == 0 && !SrcMatrix.HasData())
	{
		int Left 	= (int) (grObject.X - grObject.DX / 2);
		int Right 	= (int) (grObject.X + grObject.DX / 2);
		int Top 	= (int) (grObject.Y - grObject.DY / 2);
		int Bottom 	= (int) (grObject.Y + grObject.DY / 2);

		DestMatrix.Create();
		DestMatrix.SetInternalData(SrcMatrix.GetInternalData(), FALSE, FALSE);
		
		bReturn = DestMatrix.CopyImage(SrcMatrix, Left, Top, Right, Bottom, FALSE);
	}
	else if( CheckConvertMatrixData(SrcMatrix) )
	{
		DestMatrix.Create();
		DestMatrix.SetInternalData(SrcMatrix.GetInternalData(), FALSE, FALSE);
		bReturn = DestMatrix.CopyImage(SrcMatrix, grObject, FALSE);
	}
	
	if( !bReturn )
		DestMatrix.Destroy();
	
	return bReturn;
}
////////////////////////////////////////////////////////////////////////////////////
// start your functions here

