/*------------------------------------------------------------------------------*
 * File Name:	Cluster.c	 													*
 * Creation: 	Sophy 3/9/2010													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) OriginLab Corp.2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sophy 12/14/2010 ORG-1704-S8 OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
 *	Sophy 12/15/2010 ORG-1755-S1 SUPPORT_SEL_DATA_IN_GADGET_DLG					*
 *	Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
 *	Folger 04/15/2011 ORG-2589-P4 GO_TO_REPORT_FAILED_TO_ENABLE_FATER_OUPUT		*
 *	Hong 11/18/11 ORG-3527 PLOT_SUPPORT_SKIP_HIDDEN_ROW_IN_WKS					*
 *	Folger 03/01/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER							*
 *	Sophy 7/2/2012 ORG-6119-P1 PROPER_MAKE_DIALOG_INVISIBLE_WHEN_CLOSE_CLUSTER_GADGET
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <..\Originlab\grobj_utils.h>
#include <GetNBox.h>
#include <..\Originlab\GraphObjTools.h>
#include <..\Originlab\GraphObjToolDlg.h>
#include <..\Originlab\QuickStats.h>
#include <Array.h>
////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

#define	STR_POSITION_TAG_NAME	"ROIPosition"


///Sophy 12/16/2010 ORG-1755-S2 TURN_OFF_REALTIME_CALC_MODE_ON_CREATE_REGION_STATS_TOOL
class	RegionStatsTool;
class	ReionStstsActionHelper
{
public:
	ReionStstsActionHelper(RegionStatsTool* pTool, TreeNode& trGUI)
	{
		m_pTool = pTool;
		m_nRealTimeCalcMode = trGUI.quantities.realtime.nVal;
		trGUI.quantities.realtime.nVal = 0; //temperary turn off.
	}
	~ReionStstsActionHelper()
	{
		if ( m_nRealTimeCalcMode && NULL != m_pTool )
		{
			ROIToolOptionAccessHelper helper(ROI_OPTION_IGNORE_EVENT);
			m_pTool->ResetTopLabel();
			m_pTool->RealtimeModeControl(ROI_OP_SET);
		}
	}
protected:
	int					m_nRealTimeCalcMode;
	RegionStatsTool*	m_pTool;
};
///end TURN_OFF_REALTIME_CALC_MODE_ON_CREATE_REGION_STATS_TOOL
int	AddtoolRegionStats(const TreeNode& trGUI)
{
	GraphLayer gl = Project.ActiveLayer();
	if ( !gl )
		return -1;
	
	string strMainObjName;
	if ( get_ROI_main_obj_name(gl, XFNAME, strMainObjName) ) //attach to existing tool
	{
		RegionStatsTool stool(strMainObjName);
		stool.Init(strMainObjName);
		Tree tr;
		stool.GetTree(tr);

		tr.GUI.Replace(trGUI.Clone(), true, true, true); //need to keep version attribute for checking.
		stool.UpdateAttribsInGUITree(tr.GUI);
		stool.SetTree(tr);
		stool.ApplySettings();
		graphobjtool_events(stool, strMainObjName, OE_MOVE);
		stats_gadget_message(MSG_START_GADGET);
	}
	else //create new one
	{
		RegionStatsTool stool;
		{
			ReionStstsActionHelper helper(&stool, trGUI);///Sophy 12/16/2010 ORG-1755-S2 TURN_OFF_REALTIME_CALC_MODE_ON_CREATE_REGION_STATS_TOOL
			int nErr = stool.Create(XFNAME, GCTC_FREE_FORM_RECT, trGUI, trGUI.roi.shape.nVal);
			if(nErr < 0)
			{
				return nErr;
			}
		}
		stool.UpdateROIStates();
		stool.AttachesModeControl(ROI_OP_UPDATE);
		stats_gadget_message(MSG_CREATE);
	}
	return 0;
}

//commands for context menu
enum {
	CMD_CHANGE_SHAPE = GOT_CMD_CUSTOM + 0x0001,
};

//report worksheet state
enum {
	REPORT_NONE = -1,	///Sophy 2/17/2011 ORG-1955-P2 PROPER_INIT_REPORT_BUTTON_STATE_WHEN_NOT_OUTPUT_TO_WORKSHEET
	REPORT_DISABLE = 0,
	REPORT_ENABLE = 1,
	REPORT_CREATED = 2,
};

static	int*	_get_xf_event_handler_state()
{
	static	int	_state = 0;
	return &_state;
}

///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
#define	STR_PLOTINDEX_ATTRIB	"PlotIndex"
///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE

class RegionStatsTool : public GraphObjCurveTool
{
public:
	RegionStatsTool(LPCSTR lpcszMainObjName = NULL) : GraphObjCurveTool(lpcszMainObjName)
	{
	}
	
	bool	GetResults(TreeNode& trResults)
	{
		if ( !trResults )
			return false;

		return GetResultsTree(trResults);
	}
	
	void	UpdateROIStates()
	{
		if ( m_go )
		{
			///Sophy 1/14/2011 ORG-1841-S5 CLUSTER_GADGET_SHOULD_ALWAYS_ALLOW_STRETCH_ROTATE
			//int nTypeID;
			//m_go.GetObjectType(&nTypeID);
			//if ( GROT_RECT == nTypeID )
				//update_go_states(m_go, 0, GOC_NO_ROTATE|GOC_NO_SKEW);
			//else
				//update_go_states(m_go, GOC_NO_ROTATE|GOC_NO_SKEW);
			update_go_states(m_go, 0, GOC_NO_ROTATE|GOC_NO_SKEW)
			///end CLUSTER_GADGET_SHOULD_ALWAYS_ALLOW_STRETCH_ROTATE
		}
	}
	//virtual
	BOOL	OnCopyData()
	{
		DWORD dwState;
		UpdateROIState(dwState, false); //get
		BOOL bInner = O_QUERY_BOOL(dwState, GADGET_EDIT_INNER_POINTS);
		vector<int> vnPlots;
		if ( GetSelectedPlots(vnPlots) )
		{
			//vector<string> vsPlots(0);
			Array<vector&> arrPoints;
			vector<double>* pvX = NULL, *pvY = NULL;
			vector vInnerX, vInnerY, vOuterX, vOuterY;
			vector<int> vnInner;
			int nCount = 0;
			int nMaxSize = 0;
			for ( int iPlot = 0; iPlot < vnPlots.GetSize(); iPlot++ )
			{
				DataPlot dp = m_gl.DataPlots(vnPlots[iPlot]);
				if ( dp )
				{
					pvX = new vector<double>;
					pvY = new vector<double>;
					/// Hong 11/18/11 ORG-3527 PLOT_SUPPORT_SKIP_HIDDEN_ROW_IN_WKS
					//dp.GetDataPoints(m_go, vInnerX, vInnerY, &vnInner, GDPS_AFTER_MASK);
					dp.GetDataPoints(m_go, vInnerX, vInnerY, &vnInner, GDPS_AFTER_MASK | GDPS_AFTER_WKS_HIDDEN_ROW);
					/// end PLOT_SUPPORT_SKIP_HIDDEN_ROW_IN_WKS
					string strRngStr;
					dp.GetRangeString(strRngStr);
					//vsPlots.Add("X of " + strRngStr);
					//vsPlots.Add("Y of " + strRngStr);
					if ( bInner )
					{
						*pvX = vInnerX;
						*pvY = vInnerY;
					}
					else
					{
						dp.GetDataPoints(0, -1, vOuterX, vOuterY);
						vOuterX.RemoveAt(vnInner);
						vOuterY.RemoveAt(vnInner);
						*pvX = vOuterX;
						*pvY = vOuterY;
					}
					///Sophy 1/24/2011 ORG-1957-S2 COPYDATA_SHOULD_SMART_SKIP_EMPTY_COLUMNS
					if ( pvX->GetSize() == 0 )
						continue;
					///end COPYDATA_SHOULD_SMART_SKIP_EMPTY_COLUMNS
					arrPoints.SetAtGrow(nCount++, *pvX);
					arrPoints.SetAtGrow(nCount++, *pvY);
					if ( pvX->GetSize() > nMaxSize )
						nMaxSize = pvX->GetSize();
				}
			}
			okutil_copy_data_points(&arrPoints, NULL, nMaxSize);
			arrPoints.SetSize(0); //force free.
		}
		return TRUE;
	}
	//virtual
	BOOL	GetSourceWorksheet(Worksheet& wksSrc)
	{
		vector<int> vnPlots;
		if ( GetSelectedPlots(vnPlots) )
		{
			XYRange xySrc;
			DataPlot dp = m_gl.DataPlots(vnPlots[0]);
			if ( dp && dp.GetDataRange(xySrc) )
			{
				int nC1, nC2;
				xySrc.GetRange(wksSrc, nC1, nC2);
			}
			return wksSrc.IsValid();
		}	
		return FALSE;
	}
	//virtual
	BOOL	OnActivateSource()
	{
		Worksheet wksSrc;
		if ( GetSourceWorksheet(wksSrc) )
		{
			return wksSrc.CheckShowActivate();
		}
		return FALSE;
	}
	//virtual
	BOOL	ChangeShape()
	{
		return OnCmdCustom(CMD_CHANGE_SHAPE);
	}
	///Sophy 12/15/2010 ORG-1755-S1 SUPPORT_SEL_DATA_IN_GADGET_DLG
	bool	ResetTopLabel()
	{
		return UpdateTopLabel("No Data Selected", false);
	}
	bool	GetCurrentData(int& nPlotIndex, string& strPlotName)
	{
		vector<int> vnPlots;
		GetSelectedPlots(vnPlots);
		if ( vnPlots.GetSize() == 0 )
		{
			nPlotIndex = -2;
			strPlotName = _L("No Plot Selected");
			UpdateTopLabel("No Data Selected", true);
			return true;
		}
		if ( GetMultiPlotsState() )
		{
			nPlotIndex = -1; //means multiple selected data mode
			strPlotName = _L("All Plots");
			return true;
		}
		///Sophy 2/14/2011 ORG-2225-P1 CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS
		else if ( vnPlots.GetSize() > 1 )
		{
			nPlotIndex = vnPlots[0];
			strPlotName = _L("Multiple Plots");
			return true;
		}
		///end CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS
		else
		{
			DataPlot dp;
			dp = m_gl.DataPlots(vnPlots[0]);
			dp.GetLegend(strPlotName);
			return true;
		}
		return true;
	}
	///end SUPPORT_SEL_DATA_IN_GADGET_DLG
	
	string	GetReportWorksheet()
	{
		string strName = "";
		Tree trGUI;
		if ( !GetGUITree(trGUI) )
			return strName;
		strName = trGUI.output.wksName.strVal;
		return strName;
	}
	
	//virtual
	BOOL	DoToolControl(int nType, int nOpt)
	{
		switch(nType)
		{
		case TOOL_CTRL_TYPE_ATTACHESMODE:
			return AttachesModeControl(nOpt);
			break;
		case TOOL_CTRL_TYPE_REALTIME:
			return RealtimeModeControl(nOpt);
			break;
		}
		return FALSE;
	}

	///Sophy 6/25/2010 ORG-25-P5 UPDATE_REPORT_SHEET_NAME_FROM_GADGETTOOL_DLG
	//virtual
	BOOL	SetReportWorksheet(LPCSTR lpcszWorksheetName)
	{
		string strName(lpcszWorksheetName);
		if ( !check_update_worksheet_name(strName) )
		{
			return FALSE;
		}
		Tree trGUI;
		if ( !GetGUITree(trGUI) )
			return FALSE;
		trGUI.output.wksName.strVal = strName;
		return SetGUITree(trGUI);
	}
	///end UPDATE_REPORT_SHEET_NAME_FROM_GADGETTOOL_DLG
	int		GetReportState()
	{
		Tree trGUI;
		if ( !GetGUITree(trGUI) || trGUI.output.appendwks.nVal != 1 )
		{
			///Sophy 2/17/2011 ORG-1955-P2 PROPER_INIT_REPORT_BUTTON_STATE_WHEN_NOT_OUTPUT_TO_WORKSHEET
			if ( trGUI.output.script.nVal == 0 && trGUI.output.reslog.nVal == 0 )
				return REPORT_NONE;
			///end PROPER_INIT_REPORT_BUTTON_STATE_WHEN_NOT_OUTPUT_TO_WORKSHEET
			return REPORT_DISABLE;
		}		
		string strWorksheet = trGUI.output.wksName.strVal;
		Worksheet wksReport(strWorksheet);
		return (wksReport.IsValid() ? REPORT_CREATED : REPORT_ENABLE);
	}
	bool	ApplySettings()
	{
		return UpdateROIGUI();
	}

	
	bool	DoEditDataPoints(HWND hWndParent = NULL)
	{
		DoEditData(hWndParent);
		return OnMove(); //update result.
	}
	
	bool	DoOutputResult()
	{
		return DoOutput(false);
	}
	
	///Sophy 12/14/2010 ORG-1704-S8 OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
	BOOL	AttachesModeControl(int nOpt)
	{
		Tree trGUI;
		if ( GetGUITree(trGUI))
		{
			int nShowMode = trGUI.roi.showAttachs.nVal;
			switch(nOpt)
			{
			case ROI_OP_GET:
				return (nShowMode == 1);
			case ROI_OP_SET:
				nShowMode = 1;
				break;
			case ROI_OP_REMOVE:
			case ROI_OP_RESET:
				nShowMode = 0;
				break;
			case ROI_OP_TOGGLE:
				nShowMode = (nShowMode == 0) ? 1 : 0;
				break;
			case ROI_OP_UPDATE:
				int nVisible = AttachesModeControl(ROI_OP_GET) ? 1 : 0;
				m_goClose.Show = nVisible;
				m_goContext.Show = nVisible;
				return TRUE;
				break;
			}
			trGUI.roi.showAttachs.nVal = nShowMode;
			return SetGUITree(trGUI) && AttachesModeControl(ROI_OP_UPDATE);
		}
		return FALSE;
	}
	BOOL	RealtimeModeControl(int nOpt)
	{
		Tree trGUI;
		if ( GetGUITree(trGUI) )
		{
			int nRealTime = trGUI.quantities.realtime.nVal;
			switch(nOpt)
			{
			case ROI_OP_GET:
				return (nRealTime == 1);
			case ROI_OP_SET:
				nRealTime = 1;
				break;
			case ROI_OP_REMOVE:
			case ROI_OP_RESET:
				nRealTime = 0;
				break;
			case ROI_OP_TOGGLE:
				nRealTime = (nRealTime == 0) ? 1 : 0;
				break;
			case ROI_OP_UPDATE:
				OnEvent(OE_MOVE, 0);
				return TRUE;
				break;
			}
			trGUI.quantities.realtime.nVal = nRealTime;
			return SetGUITree(trGUI) && RealtimeModeControl(ROI_OP_UPDATE);
		}
		return FALSE;
	}
	///end OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
	///Sophy 2/14/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	//virtual
	BOOL	GetPlotsForStats(vector<int>& vnPlots)
	{
		Tree trInfo;
		if ( tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO) && trInfo.StatsPlots )
		{
			vnPlots = trInfo.StatsPlots.nVals;
			return vnPlots.GetSize() > 0;
		}
		return FALSE;
	}
	//virtual
	BOOL	SetPlotsForStats(const vector<int>& vnPlots)
	{
		Tree trInfo;
		if ( tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO) )
		{
			trInfo.StatsPlots.nVals = vnPlots;
			tree_put_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO);
		}
		return TRUE;
	}
	///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	//virtual
	BOOL	UpdateTableMenu(Menu& menu)
	{
		string strLabel;
		vector<int>		vnPlots;
		GetPlotsForStats(vnPlots);
		int nCount = 0;
		foreach(DataPlot dp in m_gl.DataPlots)
		{
			if ( IsPlotForROI(dp) )
			{
				nCount++;
				string strName;
				dp.GetLegend(strName);
				string	strFormat = _L("Show Plot(%d)");
				strFormat += "\t%s";
				strLabel.Format(strFormat, dp.GetIndex() + 1, strName);
				DWORD dwFlag = MF_STRING;
				if ( find_in_list(dp.GetIndex(), vnPlots, false) >= 0 )
					dwFlag |= MF_CHECKED;
				menu.Add(strLabel, MENU_CMD_DATAPLOT_BEGIN + dp.GetIndex(), dwFlag);
			}
		}
		if ( nCount > 0 )
			menu.Add(NULL, 0, MF_SEPARATOR);
		DWORD dwState;
		UpdateROIState(dwState, false);
		menu.Add(_L("Show All Plots"), MENU_CMD_DATAPLOT_ALL, MF_STRING | (O_QUERY_BOOL(dwState, GADGET_DATA_STATS_ALL_PLOTS) ? MF_CHECKED : 0));
		return TRUE;
	}
	//virtual
	BOOL	OnStatsPlotsChange(int nCmdID)
	{
		vector<int> vnPlots;
		GetPlotsForStats(vnPlots);
		DWORD dwState;
		UpdateROIState(dwState, false); //get state
		if ( MENU_CMD_DATAPLOT_ALL == nCmdID )
		{
			O_TOGGLE_BIT(dwState, GADGET_DATA_STATS_ALL_PLOTS);
			UpdateROIState(dwState | GADGET_DATA_ALLOW_LOCKED, true); //temporary allow locked plots
			vnPlots.RemoveAll();
			if ( O_QUERY_BOOL(dwState, GADGET_DATA_STATS_ALL_PLOTS) )
			{
				foreach(DataPlot dp in m_gl.DataPlots)
				{
					if ( IsPlotForROI(dp) )
					{
						vnPlots.Add(dp.GetIndex());
					}
				}
			}
			UpdateROIState(dwState, true);
		}
		else
		{
			int nPlotIndex = nCmdID - MENU_CMD_DATAPLOT_BEGIN;
			int nPos = find_in_list(nPlotIndex, vnPlots, false);
			if ( nPos >= 0 )
			{
				vnPlots.RemoveAt(nPos);
				O_SET_BIT(dwState, GADGET_DATA_STATS_ALL_PLOTS, false); //remove bit.
				UpdateROIState(dwState, true);
			}
			else
				vnPlots.Add(nPlotIndex);
		}
		SetPlotsForStats(vnPlots);
		OnMove();
		return OnPlotChanged();
	}
	///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
protected:
	
	///Sophy 1/7/2011 ORG-1934-P4 STATS_DOES_NEED_SHOW_LOCKED_PLOTS_CONTROL_MENU
	//virtual
	BOOL	IsShowLockedPlotsMenu() { return TRUE; }
	///end STATS_DOES_NEED_SHOW_LOCKED_PLOTS_CONTROL_MENU

	//virtual
	int*	GetXFEventHandlersState() { return _get_xf_event_handler_state(); }
	
	///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	//virtual
	BOOL	IsAllowLockedROI() { return FALSE; }
	///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	//virtual
	BOOL	IsAllowFullWidth() { return TRUE; }
	//virtual
	BOOL	IsAllowFullHeight() { return TRUE; }

	//virtual
	void	UpdateGUIOnThemeChange(TreeNode& trGUI) { stats_gadget_message(MSG_THEME_CHANGED); }

	//virtual
	BOOL	OnPlotChanged(){ stats_gadget_message(MSG_PLOT_CHANGED); return TRUE; }
	//virtual
	string	GetSignature(){ return "xf_addtool_cluster"; }
	//virtual
	string	GetXFName(){ return XFNAME; }
	//virtual
	string	GetPreferenceTitle(){ return TOOL_PREFERENCES_TITLE; }	
	//virtual
	TreeNode GetToolNameNode(const TreeNode& trGUI)
	{
		TreeNode trToolName;
		if ( trGUI )
			trToolName = trGUI.roi.toolname;
		ASSERT(trToolName);
		return trToolName;
	}
	//virtual
	TreeNode GetFillColorNode(const TreeNode& trGUI)
	{
		TreeNode trFillColor;
		if ( trGUI )
			trFillColor = trGUI.roi.rectcolor;
		ASSERT(trFillColor);
		return trFillColor;
	}
	
	//virtual
	BOOL	GetReportWorksheet(Worksheet& wksReport)
	{
		Tree trGUI;
		if ( !GetGUITree(trGUI) || trGUI.output.appendwks.nVal != 1 )
			return FALSE;
		string strWorksheet = trGUI.output.wksName.strVal;
		wksReport.Attach(strWorksheet);
		return wksReport.IsValid();
	}	
	
	///Sophy 12/14/2010 ORG-1704-S8 OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
	//virtual
	bool	OnActivate()
	{
		if ( GraphObjCurveTool::OnActivate() )
		{
			///Sophy 4/7/2011 ORG-2592-P2 MORE_WORK_GROBJTOOLS_EVENTS_HANDLING_WHEN_PAGE_DEACTIVATE
			//stats_gadget_message(MSG_CHECK_CREATE, 0); //maybe when open saved project, need to bring back the dialog
			GraphPage gp = Project.Pages();
			DWORD dwParam = (!gp.IsValid() || gp.GetUID() != m_gp.GetUID()) ? GADGETDLG_CTRL_MAKE_INVISIBLE : 0;
			stats_gadget_message(MSG_CHECK_CREATE, dwParam); //maybe when open saved project, need to bring back the dialog
			///end MORE_WORK_GROBJTOOLS_EVENTS_HANDLING_WHEN_PAGE_DEACTIVATE
			return true;
		}
		return false;
	}
	///end OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
	
	///Sophy 4/6/2011 ORG-2592-P1 GROBJTOOLS_EVENTS_HANDLING_WHEN_PAGE_DEACTIVATE
	//virtual
	bool	OnDeactivate()
	{
		if ( GraphObjCurveTool::OnDeactivate() )
		{
			stats_gadget_message(MSG_PAGE_DEACTIVATE, 0);
			return true;
		}
		return false;
	}
	///end GROBJTOOLS_EVENTS_HANDLING_WHEN_PAGE_DEACTIVATE
	
	//virtual
	bool	UpdateXScaleSettings()
	{
		Tree trGUI;
		if ( GetGUITree(trGUI) )
		{
			double dLeft, dRight, dTop, dBottom;
			GetRectCoordinate(dLeft, dRight, dTop, dBottom);
			TreeNode trShapeProp = trGUI.roi.shapeProp;
			///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
			//trShapeProp.xCenter.dVal = (dRight + dLeft) / 2;
			//trShapeProp.yCenter.dVal = (dTop + dBottom) / 2;
			//trShapeProp.width.dVal = fabs(dRight - dLeft);
			//trShapeProp.height.dVal = fabs(dTop - dBottom);
			double dXFrom, dXTo, dYFrom, dYTo;
			dXFrom = min(dLeft, dRight);
			dXTo = max(dLeft, dRight);
			dYFrom = min(dTop, dBottom);
			dYTo = max(dTop, dBottom);
			if ( !m_dp && !GetSelectedPlot(m_dp) )
				m_dp = m_gl.DataPlots(-1);
			///Sophy 12/23/2011 ORG-4611-P1 PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
			//trShapeProp.xFrom.strVal = get_value_by_format(m_dp, dXFrom, 0, true);
			//trShapeProp.xTo.strVal = get_value_by_format(m_dp, dXTo, 0, true);
			//trShapeProp.yFrom.strVal = get_value_by_format(m_dp, dYFrom, 0, false);
			//trShapeProp.yTo.strVal = get_value_by_format(m_dp, dYTo, 0, false);
			///Sophy 4/9/2012 ORG-4611-P1 GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
			//double dOffsetX = m_gl.X.From;
			//double dOffsetY = m_gl.Y.From;
			//trShapeProp.xFrom.strVal = get_value_by_format(m_dp, dXFrom, 0, true, &dOffsetX);
			//trShapeProp.xTo.strVal = get_value_by_format(m_dp, dXTo, 0, true, &dOffsetX);
			//trShapeProp.yFrom.strVal = get_value_by_format(m_dp, dYFrom, 0, false, &dOffsetY);
			//trShapeProp.yTo.strVal = get_value_by_format(m_dp, dYTo, 0, false, &dOffsetY);
			trShapeProp.xFrom.dVal = dXFrom;
			trShapeProp.xTo.dVal = dXTo;
			trShapeProp.yFrom.dVal = dYFrom;
			trShapeProp.yTo.dVal = dYTo;
			///end GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
			///end PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
			///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
			SetGUITree(trGUI);
			return true;
		}

		return false;
	}
	//virtual
	BOOL	OnMove()
	{
		if ( !OnPreMove() )
			return FALSE;
		
		if ( calculate() )
		{
			updateResultText();
		}
		stats_gadget_message(MSG_UPDATE_DATA);
		
		GraphObjCurveTool::OnMove();
		stats_gadget_message(MSG_UNDO_CHANGED);
		m_gp.Refresh();
		return TRUE;
	}

	//virtual
	/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	//bool	DoOutput(bool bUpdateLastOutput)
	bool	DoOutput(bool bUpdateLastOutput, bool bMarkerOnly = false)
	/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	{
		Tree trGUI;
		if ( !GetGUITree(trGUI) )
			return false;
		///Sophy 12/14/2010 ORG-1704-S8 OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
		Tree trResults;
		if ( !RealtimeModeControl(ROI_OP_GET) || GetResultsTree(trResults) && trResults.Children.Count() == 0 ) //not realtime mode, need to do calculation and update result tree.
			calculate(false); //ignore realtime mode settings.
		///end OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
		bool bOutToScriptWindow = trGUI.output.script.nVal == 1;
		bool bOutToResultLog = trGUI.output.reslog.nVal == 1;
		bool bOutToWks = trGUI.output.appendwks.nVal == 1;
		string strWksName = trGUI.output.wksName.strVal;
		DWORD dwCtrl = TREE2STR_CHECK_USER_LABEL;
		OutputResultTree(bOutToScriptWindow, bOutToResultLog, false, "", dwCtrl);
		if ( bOutToWks ) //region stats is a special report tree and need special handling
		{
			if ( GetResultsTree(trResults) )
			{
				return reportResultTree(trResults, strWksName);
			}
		}
		return true;
	}
	
	//virtual
	bool	UpdateROIGUI()
	{
		if ( checkUpdateShape() )
		{
			GraphObjCurveTool::UpdateROIGUI();
		}
		DoToolControl(TOOL_CTRL_TYPE_ATTACHESMODE, ROI_OP_UPDATE);
		stats_gadget_message(MSG_START_GADGET); //need to change main object name or settings

		return true;
	}

	//virtual
	bool	CheckGetMainObjectPositionFromGUITree(const TreeNode& trGUI, double& x0, double& x1, bool& bFixWidth, double& y0, double& y1)
	{
		TreeNode trShapeProp = trGUI.roi.ShapeProp;
		if ( trShapeProp )
		{
			///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
			//double dWidth = trShapeProp.width.dVal;
			//double dHeight = trShapeProp.height.dVal;
			//x0 = trShapeProp.xCenter.dVal - dWidth/2;
			//x1 = x0 + dWidth;
			//y0 = trShapeProp.yCenter.dVal - dHeight/2;
			//y1 = y0 + dHeight;
			if ( !m_dp && !GetSelectedPlot(m_dp) )
				m_dp = m_gl.DataPlots(-1);
			///Sophy 12/23/2011 ORG-4611-P1 PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
			//x0 = get_value_by_format(m_dp, trShapeProp.xFrom.strVal, true);
			//x1 = get_value_by_format(m_dp, trShapeProp.xTo.strVal, true);
			//y0 = get_value_by_format(m_dp, trShapeProp.yFrom.strVal, false);
			//y1 = get_value_by_format(m_dp, trShapeProp.yTo.strVal, false);
			///Sophy 4/9/2012 ORG-4611-P1 GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
			//double dOffsetX = m_gl.X.From;
			//double dOffsetY = m_gl.Y.From;
			//x0 = get_value_by_format(m_dp, trShapeProp.xFrom.strVal, true, &dOffsetX);
			//x1 = get_value_by_format(m_dp, trShapeProp.xTo.strVal, true, &dOffsetX);
			//y0 = get_value_by_format(m_dp, trShapeProp.yFrom.strVal, false, &dOffsetY);
			//y1 = get_value_by_format(m_dp, trShapeProp.yTo.strVal, false, &dOffsetY);
			x0 = trShapeProp.xFrom.dVal;
			x1 = trShapeProp.xTo.dVal;
			y0 = trShapeProp.yFrom.dVal;
			y1 = trShapeProp.yTo.dVal;
			///end GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
			///end PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
			///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
		}
		return true;
	}

	//virtual
	bool	IsSupportMultiPlots(){ return true; }
	//virtual
	bool	IsSupportEditData(){ return true; }
	//virutal
	bool	IsPlotForROI(const DataPlot& dp)
	{
		DWORD dwState;
		UpdateROIState(dwState, false); //get dialog control states.
		if ( !dp )
			return false;
		XYRange xySrc;
		Column colY;
		BOOL bAllowLocked = O_QUERY_BOOL(dwState, GADGET_DATA_ALLOW_LOCKED);
		if (!bAllowLocked && dp.GetDataRange(xySrc) && xySrc.GetYColumn(colY) && is_dataobj_tagged(colY, STR_DATASETOBJ_FITCURVE) )
			return false;
		if( !okutil_is_good_plot_type_for_analysis(dp.GetPlotType()) )
			return false;
		vector<uint> vnUIDs;
		if ( !bAllowLocked && colY.IsValid() && colY.IsDataProtected() )
			return false;
		return true;
	}

	//virtual
	BOOL	OnDestroy()
	{
		if ( GraphObjCurveTool::OnDestroy() )
		{
			stats_gadget_message(MSG_DESTROY);
		}
		return TRUE;
	}
	
	///Sophy 2/14/2011 ORG-2225-P1 CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS
	//virtual
	bool	UpdatePlotsMenu(Menu& pm, uint& nPosition)
	{
		if ( GraphObjCurveTool::UpdatePlotsMenu(pm, nPosition) )
		{
			DWORD dwFlags = MF_STRING;
			DWORD dwState;
			UpdateROIState(dwState, false);
			BOOL bInner = O_QUERY_BOOL(dwState, GADGET_EDIT_INNER_POINTS);
			pm.Add(NULL, 0, MF_SEPARATOR); nPosition++;
			pm.Add(_L("&Inner Points"), GOT_DATAPLOT_INNER, dwFlags | (bInner ? MF_CHECKED : 0)); nPosition++;
			pm.Add(_L("&Outer Points"), GOT_DATAPLOT_OUTER, dwFlags | (bInner ? 0 : MF_CHECKED)); nPosition++;
			return true;
		}
		return false;
	}

	///end CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS

	//virtual
	bool	UpdateContextMenu(Menu& pm, uint& nPosition)
	{
		Tree trGUI;
		GetGUITree(trGUI);
		int nShape = trGUI.roi.shape.nVal;
		DWORD dwFlags = MF_STRING | ((nShape == SHAPE_CIRCLE) ? MF_CHECKED : 0);
		pm.Add(_L("Use Circular ROI Box"), CMD_CHANGE_SHAPE, dwFlags), nPosition++;
		
		//modify New Output label
		pm.ModifyMenu(GOT_BTN_OUTPUT, MF_BYCOMMAND, GOT_BTN_OUTPUT, _L("New Statistics Output"));
		return true;
	}
	
	//virtual
	bool	OnCmdCustom(int nCmdID)
	{
		switch(nCmdID)
		{
		case CMD_CHANGE_SHAPE:
			OnSwitchShape();
			break;
			
		default:
			ASSERT(false);
			return false;
		}
		return true;
	}
	
	bool	OnSwitchShape()
	{
		Tree trGUI;
		GetGUITree(trGUI);
		int nShape = trGUI.roi.shape.nVal;
		trGUI.roi.shape.nVal = ((nShape == SHAPE_RECT) ? SHAPE_CIRCLE : SHAPE_RECT);
		SetGUITree(trGUI);
		return UpdateROIGUI();
	}
	
	///Sophy 4/8/2010 EXPAND_FULL_RANGE_SUPPORT_MULTIPLE_DATAPLOTS
	//virtual
	///Sophy 12/27/2010 ORG-1845-P1 CENTRALIZE_CODE_FOR_EXPAND_ROI_WITH_MULTI_PLOTS_SUPPORT
	/*
	void	DoExpand(DataPlot& dp)
	{
		if ( !dp )
			GetSelectedPlot(dp);
		
		double dMinX, dMaxX, dMinY, dMaxY;
		BeforeExpandRect(dp, dMinX, dMaxX, dMinY, dMaxY);
		
		if ( GetMultiPlotsState() )
		{
			double dMinX2, dMaxX2, dMinY2, dMaxY2;
			foreach(DataPlot dpMore in m_gl.DataPlots)
			{
				if ( dp.GetIndex() != dpMore.GetIndex() && IsPlotForROI(dpMore) )
				{
					BeforeExpandRect(dpMore, dMinX2, dMaxX2, dMinY2, dMaxY2);
					if ( dMinX2 < dMinX )
						dMinX = dMinX2;
					if ( dMaxX2 > dMaxX )
						dMaxX = dMaxX2;
					if ( dMinY2 < dMinY )
						dMinY = dMinY2;
					if ( dMaxY2 > dMaxY )
						dMaxY = dMaxY2;
				}
			}
		}
		ExpandROI(dMinX, dMaxX, dMinY, dMaxY);
	}
	*/
	///end CENTRALIZE_CODE_FOR_EXPAND_ROI_WITH_MULTI_PLOTS_SUPPORT
	///end EXPAND_FULL_RANGE_SUPPORT_MULTIPLE_DATAPLOTS

private:
	
	//virtual
	void	getBoundingBoxInfo(string& str)
	{
		///Sophy 12/17/2010 ORG-1784-S1 SHOW_ROI_POSITION_ON_DATA_DISPLAY_WINDOW
		//str.Empty(); //empty the string to force Data Display window NOT visible, the ROI range can be seen from Status bar
		double dLeft, dRight, dTop, dBottom;
		GetRectCoordinate(dLeft, dRight, dTop, dBottom);
		str.Format("X1 = %g, Y1 = %g, X2 = %g, Y2 = %g", dLeft, dTop, dRight, dBottom);
		///end SHOW_ROI_POSITION_ON_DATA_DISPLAY_WINDOW
		
	}

	///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
	void	prepareOneCol(Worksheet& wksDetails, TreeNode& trNode, Column& colObj)
	{
		int nIndex = wks_find_empty_column(wksDetails, 0);
		if ( nIndex < 0 )
			nIndex = wksDetails.AddCol();
		colObj.Attach(wksDetails, nIndex);
		colObj.SetName(trNode.tagName, OCD_ENUM_NEXT);
		string strLabel;
		trNode.GetAttribute(STR_LABEL_ATTRIB, strLabel);
		colObj.SetLongName(strLabel);
		int nFormat = OKCOLTYPE_NUMERIC;
		trNode.GetAttribute(STR_COL_FORMAT_ATTRIB, nFormat);
		colObj.SetFormat(nFormat);
		int nSubFormat = -1;
		trNode.GetAttribute(STR_COL_SUBFORMAT_ATTRIB, nSubFormat);
		colObj.SetSubFormat(nSubFormat);
		string strCustomDisplay = "";
		trNode.GetAttribute(STR_COL_CUSTOM_DISPLAY_ATTRIB, strCustomDisplay);
		colObj.SetCustomDisplay(strCustomDisplay);
		int nType = OKDATAOBJ_DESIGNATION_Y;
		trNode.GetAttribute(STR_COL_DESIGNATION_ATTRIB, nType);
		colObj.SetType(nType);	\

	}
	///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
	
	bool	reportResultTree(TreeNode& trStatsResult, LPCSTR lpcszWksName)
	{
		foreach(TreeNode trOneResultSet in trStatsResult.Children)
		{
			foreach(TreeNode trInnerOuter in trOneResultSet.Children)
			{
				string strRootLabel, strName, strDataName;
				if ( !trInnerOuter.GetAttribute(STR_LABEL_ATTRIB, strRootLabel) )
					strRootLabel = trInnerOuter.tagName;
				
				TreeNode trName = trInnerOuter.name;
				///Sophy 4/14/2010 BETTER_OUTPUT_ARRANGEMENT_IN_REPORT
				TreeNode trInOut = trInnerOuter.InsertNode(trName, "region");
				if ( trInOut )
				{
					trInOut.SetAttribute(STR_LABEL_ATTRIB, "Region");
					trInOut.strVal = strRootLabel;
					trInOut.TypeID = TNVAL_TYPE_CSTRING;
				}
				///end BETTER_OUTPUT_ARRANGEMENT_IN_REPORT
				if ( trName )
				{
					strDataName = trName.strVal;
					trName.SetAttribute(STR_LABEL_ATTRIB, _L("Data"));
					trName.strVal = strDataName;
					trName.TypeID = TNVAL_TYPE_CSTRING;
				}
				TreeNode trIndices = trInnerOuter.dpIndices;
				if ( trIndices )
				{
					trIndices.Remove();
					if ( !trIndices.GetAttribute(STR_LABEL_ATTRIB, strName) )
						strName = trIndices.tagName;
					strName.Format("%s %s of \"%s\"", strRootLabel, strName, strDataName);
					trIndices.SetAttribute(STR_LABEL_ATTRIB, strName);
				}
				TreeNode trXValues = trInnerOuter.dpXValues;
				TreeNode trYValues = trInnerOuter.dpYValues;
				if ( trXValues )
				{
					ASSERT(trYValues);
					trXValues.Remove();
					trYValues.Remove();
					if ( !trXValues.GetAttribute(STR_LABEL_ATTRIB, strName) )
						strName = trXValues.tagName;
					strName.Format("%s %s of \"%s\"", strRootLabel, strName, strDataName);
					trXValues.SetAttribute(STR_LABEL_ATTRIB, strName);
					
					if ( !trYValues.GetAttribute(STR_LABEL_ATTRIB, strName) )
						strName = trYValues.tagName;
					strName.Format("%s %s of \"%s\"", strRootLabel, strName, strDataName);
					trYValues.SetAttribute(STR_LABEL_ATTRIB, strName);
				}

				out_tree_to_wks(trInnerOuter, lpcszWksName, CREATE_HIDDEN | CREATE_LOAD_1ST_LAYER_ONLY);
				
				Worksheet wksReport;
				if ( (trIndices || trXValues && trYValues ) && wksReport.Attach(lpcszWksName) )
				{
#define		STR_WKS_NAME_DETAILS	"Data Points Info"
					WorksheetPage wp = wksReport.GetPage();
					Layer layer = wp.Layers(STR_WKS_NAME_DETAILS);
					Worksheet wksDetails(layer);
					int nIndex = 0;
					if ( !wksDetails )
					{
						nIndex = wp.AddLayer(STR_WKS_NAME_DETAILS);
						if ( nIndex < 0 )
							return false;
						wksDetails = wp.Layers(nIndex);
					}
			
					Column colReport;

					if ( trIndices )
					{
						prepareOneCol(wksDetails, trIndices, colReport);
						vectorbase& vbI = colReport.GetDataObject();
						vbI = trIndices.nVals;
					}

					if ( trXValues )
					{
						prepareOneCol(wksDetails, trXValues, colReport);
						vectorbase& vbX = colReport.GetDataObject();
						vbX = trXValues.dVals;
					}

					if ( trYValues )
					{
						prepareOneCol(wksDetails, trYValues, colReport);
						vectorbase& vbY = colReport.GetDataObject();
						vbY = trYValues.dVals;
					}
				}
					
			}
		}
		return true;
	}
	
	///Sophy 12/10/2010 ORG-1717-P1 SPEED_UP_CALCULATION_FOR_BASIC_STATISTICS
	bool	isNeedCalcMedian()
	{
		Tree trGUI;
		if ( GetGUITree(trGUI) )
		{
			int nCheck = trGUI.quantities.median.nVal;
			return (1 == nCheck);
		}
		return false;
	}
	bool	curveStats(const vector& vX, const vector& vY, TreeNode& trResult)
	{
		trResult.Data.TypeID = TNVAL_TYPE_CSTRING;
		trResult.SetAttribute(STR_LABEL_ATTRIB, _L("Descriptive Statistics"));
		tree_set_add_col_info(trResult.Data, OKDATAOBJ_DESIGNATION_X, 24);
		double dMinX, dMaxX;
		vX.GetMinMax(dMinX, dMaxX);
		trResult.x1.dVal = dMinX;
		trResult.x2.dVal = dMaxX;
		
		double dSum, dMean, dSD;
		int N;
		ocmath_basic_summary_stats(vY.GetSize(), vY, &N, &dMean, &dSD, NULL, NULL, &dSum);
		trResult.N.nVal = N;
		trResult.sum.dVal = dSum;
		trResult.mean.dVal = dMean; tree_set_add_col_info(trResult.mean, OKDATAOBJ_DESIGNATION_Y, 9);
		trResult.sd.dVal = dSD; tree_set_add_col_info(trResult.sd, OKDATAOBJ_DESIGNATION_ERROR, 9);
		
		double dPer = 50; //is median
		double dMedian = NANUM;
		if ( isNeedCalcMedian() )
		{
			int nInterpolate = Project.Settings.GetPercentileInterpolateMethod();
			int nErr = ocmath_percentiles(vY, vY.GetSize(), &dPer, 1, &dMedian, nInterpolate);
		}
		trResult.median.dVal = dMedian;
		
		
		double dMinY, dMaxY;
		int nMinYIndex, nMaxYIndex;
		vY.GetMinMax(dMinY, dMaxY, &nMinYIndex, &nMaxYIndex);
		trResult.min.dVal = dMinY;
		trResult.max.dVal = dMaxY;
		trResult.xmin.dVal = nMinYIndex < 0 ? NANUM : vX[nMinYIndex];
		trResult.xmax.dVal = nMaxYIndex < 0 ? NANUM : vX[nMaxYIndex];
		trResult.dx.dVal = dMaxX - dMinX;
		return true;
	}
	///end SPEED_UP_CALCULATION_FOR_BASIC_STATISTICS
	
	bool	calculate(bool bCheckRealtimeMode = true)
	{
		Tree trGUI;
		if ( !GetGUITree(trGUI) )
			return false;

		Tree trAllResults;
		///Sophy 12/14/2010 ORG-1704-S8 OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
		if ( bCheckRealtimeMode && !RealtimeModeControl(ROI_OP_GET) )
		{
			UpdateTopLabel(_L("Real-time Calculation is off"));
			SetResultsTree(trAllResults);
			return false;
		}
		///end OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
		vector vAllXInner, vAllYInner, vAllXOuter, vAllYOuter;
		vector vXInner, vYInner, vXOuter, vYOuter;
		vector<int> vnPointIndicesInner, vnPointIndicesOuter, vnAllPointsInner, vnAllPointsOuter;
		
		vector<int> vnPlots;
		///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
		//GetSelectedPlots(vnPlots);
		GetPlotsForStats(vnPlots);
		///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
		
		TreeNode trCalcOuter = trGUI.quantities.outer;
		int nCalcOuter = trCalcOuter.nVal;
		for ( int iPlot = 0; iPlot < vnPlots.GetSize(); iPlot++ )
		{
			DataPlot dp = m_gl.DataPlots(vnPlots[iPlot]);
			//inner points
			/// Hong 11/18/11 ORG-3527 PLOT_SUPPORT_SKIP_HIDDEN_ROW_IN_WKS
			//dp.GetDataPoints(m_go, vXInner, vYInner, &vnPointIndicesInner, GDPS_AFTER_MASK);
			dp.GetDataPoints(m_go, vXInner, vYInner, &vnPointIndicesInner, GDPS_AFTER_MASK | GDPS_AFTER_WKS_HIDDEN_ROW);
			/// end PLOT_SUPPORT_SKIP_HIDDEN_ROW_IN_WKS
			//outer points
			dp.GetDataPoints(0, -1, vXOuter, vYOuter);
			vnPointIndicesOuter.Data(0, vYOuter.GetSize() - 1, 1);
			if ( nCalcOuter && vnPointIndicesInner.GetSize() > 0 )
			{
				vXOuter.RemoveAt(vnPointIndicesInner);
				vYOuter.RemoveAt(vnPointIndicesInner);
				vnPointIndicesOuter.RemoveAt(vnPointIndicesInner);
			}
			
			vAllXInner.Append(vXInner);
			vAllYInner.Append(vYInner);
			///Sophy 12/22/2011 ORG-4677-P1 PREPARE_DATA_FOR_CALC_OUTER_POINTS_FOR_ALL_PLOTS
			//if ( nCalcOuter && GetMultiPlotsState() && vnPlots.GetSize() > 1 )
			DWORD dwState;
			UpdateROIState(dwState, false);
			if ( nCalcOuter && O_QUERY_BOOL(dwState, GADGET_DATA_STATS_ALL_PLOTS) && vnPlots.GetSize() > 1 )
			///end PREPARE_DATA_FOR_CALC_OUTER_POINTS_FOR_ALL_PLOTS
			{
				vAllXOuter.Append(vXOuter);
				vAllYOuter.Append(vYOuter);
				vnAllPointsInner.Append(vnPointIndicesInner);
				vnAllPointsOuter.Append(vnPointIndicesOuter);
			}
			
			string strDataName;
			dp.GetLegend(strDataName);
			//stats inner/outer points
			TreeNode trOneResult = trAllResults.AddNode("Result");
			trOneResult.SetAttribute(STR_LABEL_ATTRIB, "Result_" + strDataName);
			///Sophy 2/15/2011 ORG-1955-S4 TABLE_ROW_COLOR_DISTINGUISH_EDITING_PLOTS
			trOneResult.SetAttribute(STR_PLOTINDEX_ATTRIB, dp.GetIndex());
			///end TABLE_ROW_COLOR_DISTINGUISH_EDITING_PLOTS
			TreeNode trResultInner = getOneResult(vXInner, vYInner, vnPointIndicesInner, dp);
			TreeNode trInnerResults = trOneResult.AddNode("Inner");
			trInnerResults.Replace(trResultInner, true, true, true);
			trInnerResults.SetAttribute(STR_LABEL_ATTRIB, STR_INNER_POINTS);
			if ( nCalcOuter )
			{
				TreeNode trResultOutter = getOneResult(vXOuter, vYOuter, vnPointIndicesOuter, dp);
				TreeNode trOuterResults = trOneResult.AddNode("Outer");
				trOuterResults.Replace(trResultOutter, true, true, true);
				trOuterResults.SetAttribute(STR_LABEL_ATTRIB, STR_OUTER_POINTS);
			}


		}
		///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
		//if ( GetMultiPlotsState() && vnPlots.GetSize() > 0 ) //multiple plots combined stats
		DWORD dwState;
		UpdateROIState(dwState, false);
		if ( O_QUERY_BOOL(dwState, GADGET_DATA_STATS_ALL_PLOTS) && vnPlots.GetSize() > 0)
		///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
		{
			TreeNode trAllResult = trAllResults.AddNode("AllResult");
			trAllResult.SetAttribute(STR_LABEL_ATTRIB, _L("Result_") + _L("All Points"));
			
			TreeNode trTemp;
			if ( vnPlots.GetSize() == 1 ) //not need to calculate again, just clone the result.
			{
				trTemp = trAllResults.FirstNode;
				trAllResult.Replace(trTemp, true, true, true);
				trAllResult.Inner.name.strVal = _L("All Plots");
				trAllResult.Inner.name.TypeID = TNVAL_TYPE_CSTRING;
				trAllResult.Outer.name.strVal = _L("All Plots");
				trAllResult.Outer.name.TypeID = TNVAL_TYPE_CSTRING;
				if ( !nCalcOuter )
					trAllResult.Outer.Remove();
			}
			else
			{
				TreeNode trAllInner = getOneResult(vAllXInner, vAllYInner, vnAllPointsInner);
				trTemp = trAllResult.AddNode("Inner");
				trTemp.Replace(trAllInner, true, true, true);
				trTemp.SetAttribute(STR_LABEL_ATTRIB, STR_INNER_POINTS);
	
				if ( nCalcOuter )
				{
					TreeNode trAllOuter = getOneResult(vAllXOuter, vAllYOuter, vnAllPointsOuter);
					trTemp = trAllResult.AddNode("Outer");
					trTemp.Replace(trAllOuter, true, true, true);
					trTemp.SetAttribute(STR_LABEL_ATTRIB, STR_OUTER_POINTS);
				}
			}
		}
		SetResultsTree(trAllResults);
		return true;	
	}
	///Sophy 12/14/2010 ORG-1704-S8 OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
	void		cloneResult(TreeNode& trResult, TreeNode& trGUI)
	{
		TreeNode trQuantities = trGUI.quantities;
		if ( !trQuantities )
		{
			ASSERT(false);
			return;
		}
		vector<string> vsFilters = {"realtime", "outer"};
		foreach(TreeNode trSub in trQuantities.Children)
		{
			if ( trSub.nVal )
			{
				string strTagName = trSub.tagName;
				if ( vsFilters.Find(strTagName) >= 0 )
					continue;
				trResult.AddNode(trSub);
			}
		}
	}
	///end OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
	///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
	void		updateResultTree(TreeNode& trNode, const DataPlot& dp = NULL, bool bByXCol = true)
	{
		if ( !trNode || !dp )
			return;
		XYRange xySrc;
		Column colObj;
		if ( dp && dp.GetDataRange(xySrc) && (bByXCol && xySrc.GetXColumn(colObj) || !bByXCol && xySrc.GetYColumn(colObj)) )
		{
			int nFormat = colObj.GetFormat();
			int nSubFormat = colObj.GetSubFormat();
			string strCustomFormat = colObj.GetCustomDisplay();
			trNode.SetAttribute(STR_COL_FORMAT_ATTRIB, nFormat);
			trNode.SetAttribute(STR_COL_SUBFORMAT_ATTRIB, nSubFormat);
			trNode.SetAttribute(STR_COL_CUSTOM_DISPLAY_ATTRIB, strCustomFormat);
		}

	}
	///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
	TreeNode	getOneResult(vector vX, vector vY, const vector<int>&vnPointIndices, const DataPlot& dp = NULL)
	{
		Tree tr; //curve stats result tree
		Tree trGUI;
		Tree trResults;
		if ( !GetGUITree(trGUI) )
			return trResults;
		
		///Sophy 12/10/2010 ORG-1717-P1 SPEED_UP_CALCULATION_FOR_BASIC_STATISTICS
		//curve_stats(vX, vY, tr);
		curveStats(vX, vY, tr);
		///end SPEED_UP_CALCULATION_FOR_BASIC_STATISTICS
		
		///Sophy 12/14/2010 ORG-1704-S8 OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
		//trResults = trGUI.quantities.Clone();
		cloneResult(trResults, trGUI);
		///end OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
		string str;
		if ( dp )
			dp.GetLegend(str);
		else
			str = _L("All Plots");
		if ( trResults.name )
		{
			trResults.name.strVal = str;
			trResults.name.TypeID = TNVAL_TYPE_CSTRING;
		}
		///Sophy 12/20/2010 ORG-1785 OUTPUT_ROI_POSITION_INFO_WHEN_OUTPUT_ROI_SHAPE_INFO
		TreeNode trShape = trResults.shape;
		///end OUTPUT_ROI_POSITION_INFO_WHEN_OUTPUT_ROI_SHAPE_INFO
		if (trShape && trShape.nVal == 1 )
		{
			trShape.strVal = trGUI.roi.shape.nVal == SHAPE_RECT ? _L("Rectangle") : _L("Circle");
			trShape.TypeID = TNVAL_TYPE_CSTRING;
		}
		else
			trShape.Remove();
#define	COPY_NVAL(_SubNode)				if ( trResults._SubNode) trResults._SubNode.nVal = tr._SubNode.nVal
#define	COPY_DVAL(_SubNode)				if ( trResults._SubNode) trResults._SubNode.dVal = tr._SubNode.dVal
#define	TYPE(_SubNode, _Type)			if ( trResults.SubNode) trResults._SubNode.SetAttribute(STR_COL_DESIGNATION_ATTRIB, _Type)
		COPY_NVAL(N);		TYPE(N, OKDATAOBJ_DESIGNATION_Y);
		COPY_DVAL(sum);		TYPE(sum, OKDATAOBJ_DESIGNATION_Y);
		COPY_DVAL(mean);	TYPE(mean, OKDATAOBJ_DESIGNATION_Y);
		COPY_DVAL(median);	TYPE(median, OKDATAOBJ_DESIGNATION_Y);
		COPY_DVAL(sd);		TYPE(sd, OKDATAOBJ_DESIGNATION_ERROR);
		COPY_DVAL(min);		TYPE(min, OKDATAOBJ_DESIGNATION_Y);
		COPY_DVAL(max);		TYPE(max, OKDATAOBJ_DESIGNATION_Y);
		
		//move node to last
		TreeNode trTemp;
		int nChecked;
		
		trTemp = trResults.dpIndices;
		if ( trTemp )
		{
			nChecked = trTemp.nVal;
			trTemp.Remove();
			if ( nChecked )
			{
				trTemp = trResults.AddNode("dpIndices");
				trTemp.nVals = vnPointIndices;
				trTemp.SetAttribute(STR_LABEL_ATTRIB, _L("Indices"));
				TYPE(dpIndices, OKDATAOBJ_DESIGNATION_X);
			}
		}
		trTemp = trResults.dpValues;
		if ( trTemp )
		{
			nChecked = trTemp.nVal;
			trTemp.Remove();
			if ( nChecked )
			{
				trTemp = trResults.AddNode("dpXValues");
				trTemp.dVals = vX;
				trTemp.SetAttribute(STR_LABEL_ATTRIB, _L("X Values"));
				TYPE(dpXValues, OKDATAOBJ_DESIGNATION_X);
				///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
				updateResultTree(trResults.dpXValues, dp, true);
				///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
				trTemp = trResults.AddNode("dpYValues");
				trTemp.dVals = vY;
				trTemp.SetAttribute(STR_LABEL_ATTRIB, _L("Y Values"));
				TYPE(dpYValues, OKDATAOBJ_DESIGNATION_Y);
				///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
				updateResultTree(trResults.dpYValues, dp, false);
				///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
			}
		}
		tree_copy_values_to_attributes(trGUI.quantities, trResults, STR_LABEL_ATTRIB);
		///Sophy 12/20/2010 ORG-1785 OUTPUT_ROI_POSITION_INFO_WHEN_OUTPUT_ROI_SHAPE_INFO
		if ( trShape )
		{
			TreeNode trPosition;
			if (  trShape.NextNode )
				trPosition = trResults.InsertNode(trShape.NextNode, STR_POSITION_TAG_NAME);
			else
				trPosition = trResults.AddNode(STR_POSITION_TAG_NAME);
			string strVal;
			getBoundingBoxInfo(strVal);
			trPosition.SetAttribute(STR_LABEL_ATTRIB, _L("Shape Position"));
			trPosition.strVal = strVal;
			trPosition.TypeID = TNVAL_TYPE_CSTRING;
		}
		///end OUTPUT_ROI_POSITION_INFO_WHEN_OUTPUT_ROI_SHAPE_INFO
		return trResults.Clone();
	}

	bool	checkUpdateShape()
	{
		Tree	tr, trGUI;
		bool bUpdateROIGUI = true;
		if ( GetTree(tr) )
		{
			TreeNode trShape = tr.GUI.roi.shape;
			if ( trShape )
			{
				int nShape = trShape.nVal;
				int nTypeID = 0;
				m_go.GetObjectType(&nTypeID);
				if ( (SHAPE_RECT == nShape && GROT_ELLIPSE == nTypeID) || (SHAPE_CIRCLE == nShape && GROT_RECT == nTypeID) )
				{
					DataPlot dp;
					GetSelectedPlot(dp);
					bool bMultiPlots = GetMultiPlotsState();
					vector<int> vnUndoBlocks;
					GetUndoStack(vnUndoBlocks);
					{
						ROIToolOptionAccessHelper helper(ROI_OPTION_IGNORE_EVENT);
						string strCmd;
						strCmd.Format("label -rc %s", m_go.GetName());
						LT_execute(strCmd);
					}
					init_shape_position(tr.GUI);
					Create(GetXFName(), GCTC_FREE_FORM_RECT, tr.GUI, nShape);
					///Sophy 1/14/2011 ORG-1841-S5 CLUSTER_GADGET_SHOULD_ALWAYS_ALLOW_STRETCH_ROTATE
					//if ( SHAPE_RECT == nShape )
						//update_go_states(m_go, 0, GOC_NO_ROTATE|GOC_NO_SKEW);
					//else
						//update_go_states(m_go, GOC_NO_ROTATE|GOC_NO_SKEW);
					UpdateROIStates();
					///end CLUSTER_GADGET_SHOULD_ALWAYS_ALLOW_STRETCH_ROTATE
					m_gp.Refresh();
					if ( dp.IsValid() )
						SetPlot(dp.GetIndex());
					
					AttachesModeControl(ROI_OP_UPDATE);
					bUpdateROIGUI = false; //if newly create, not need to run base class UpdateROIGUI.
					SetUndoStack(vnUndoBlocks);
					SetMultiPlotsState(bMultiPlots);
					stats_gadget_message(MSG_UNDO_CHANGED);
				}
				else
				{
					//adjust main object position, in case position changed.
					TreeNode trShapeProp = tr.GUI.roi.shapeProp;
					if ( !trShapeProp )
						return false;
					///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
					//double dxCenter = trShapeProp.xCenter.dVal;
					//double dyCenter = trShapeProp.yCenter.dVal;
					//double dWidth = trShapeProp.Width.dVal;
					//double dHeight = trShapeProp.Height.dVal;
					
					//double dLeft = dxCenter - dWidth/2;
					//double dRight = dLeft + dWidth;
					//double dBottom = dyCenter - dHeight/2;
					//double dTop = dBottom + dHeight;
					if ( !m_dp && !GetSelectedPlot(m_dp) )
						m_dp = m_gl.DataPlots(-1);
					///Sophy 12/23/2011 ORG-4611-P1 PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
					//double dLeft = get_value_by_format(m_dp, trShapeProp.xFrom.strVal, true);
					//double dRight = get_value_by_format(m_dp, trShapeProp.xTo.strVal, true);
					//double dBottom = get_value_by_format(m_dp, trShapeProp.yFrom.strVal, false);
					//double dTop = get_value_by_format(m_dp, trShapeProp.yTo.strVal, false);
					///Sophy 4/9/2012 ORG-4611-P1 GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
					//double dOffsetX = m_gl.X.From;
					//double dOffsetY = m_gl.Y.From;
					//double dLeft = get_value_by_format(m_dp, trShapeProp.xFrom.strVal, true, &dOffsetX);
					//double dRight = get_value_by_format(m_dp, trShapeProp.xTo.strVal, true, &dOffsetX);
					//double dBottom = get_value_by_format(m_dp, trShapeProp.yFrom.strVal, false, &dOffsetY);
					//double dTop = get_value_by_format(m_dp, trShapeProp.yTo.strVal, false, &dOffsetY);
					double dLeft = trShapeProp.xFrom.dVal;
					double dRight = trShapeProp.xTo.dVal;
					double dBottom = trShapeProp.yFrom.dVal;
					double dTop = trShapeProp.yTo.dVal;
					///end GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
					///end PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
					///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
					update_roi_position(m_go, dLeft, dTop, dRight, dBottom);
					m_gp.Refresh();
				}
			}
		}
		return bUpdateROIGUI;
	}
	
	bool	updateResultText()
	{
		UpdateTopLabel(NULL, false);
		return true;
	}
};

void addtool_cluster_events(string strGrName, int nEvent, int nMsg = 0)
{
	RegionStatsTool sTool;
	graphobjtool_events(sTool, strGrName, nEvent, nMsg);
}

///Sophy 12/5/2011 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
int	addtool_cluster_msg(LPVOID lpMsgInfo)
{
	RegionStatsTool itool;
	return graphobjtool_msg(itool, lpMsgInfo);
}
///end LT_OBJ_TO_CONTROL_GADGET_TOOLS

///------ Folger 03/01/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER
int	GlobalGadget_addtool_cluster(int nMsg, WPARAM wParam, LPARAM lParam)
{
	RegionStatsTool itool;
	return GlobalGadget_graphobjtool(itool, nMsg, wParam, lParam);
}
///------ End GLOBAL_GADGET_MANAGER

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////StatsGadgetDlg////////////////////////////////////////////////////////

class StatsGadgetDlg : public GadgetDlg
{
public:
	StatsGadgetDlg(){}
	~StatsGadgetDlg(){}
	//virtual
	BOOL	StartGadget();
	BOOL	UpdateDlgData();
	BOOL	UpdateSettings();
	///Sophy 12/15/2010 ORG-1755-S1 SUPPORT_SEL_DATA_IN_GADGET_DLG
	void	UpdateDlgTitle();
	///end SUPPORT_SEL_DATA_IN_GADGET_DLG
	
protected:
	
	BOOL	OnDestroy();
	BOOL	InitTables(const TreeNode& trResults);
	//virtual
	BOOL	OnEditData(Control ctrl);
	BOOL	OnOutputResult(Control ctrl);
	string	GetToolType(){ return XFNAME; }
	BOOL	InitButtons();
	BOOL	ArrangeControls();
	BOOL	ResetData(const TreeNode& trResults);

protected:
	
	//Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	virtual	PFN_GADGET_MSG_HANDLER	GetMsgHandler() { return stats_gadget_message; }
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL

	//virtual
	BOOL	UpdateReportSheetName(LPCSTR lpcszSheetName);	///Sophy 6/25/2010 ORG-25-P5 UPDATE_REPORT_SHEET_NAME_FROM_GADGETTOOL_DLG
	
	///Sophy 12/20/2010 ORG-1785 OUTPUT_ROI_POSITION_INFO_WHEN_OUTPUT_ROI_SHAPE_INFO
	BOOL	IsColOnTable(TreeNode& trCol);
	///end OUTPUT_ROI_POSITION_INFO_WHEN_OUTPUT_ROI_SHAPE_INFO
	
private:
	BOOL	updateTable(GridTableControl& table, const TreeNode& trStatsResult, int nRow, bool bShowOnly = false);
	virtual	int		GetHelpID()			{ return IDD_STATS_GADGET; }

	///------ Folger 04/15/2011 ORG-2589-P4 GO_TO_REPORT_FAILED_TO_ENABLE_FATER_OUPUT
	void	CheckEnableButtons();
	///------ End GO_TO_REPORT_FAILED_TO_ENABLE_FATER_OUPUT
private:
	RegionStatsTool	m_Tool;
};
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////Implementation////////////////////////////////////////////////////
BOOL	StatsGadgetDlg::StartGadget()
{
	if ( !CheckInitTool() )
		return FALSE;
	
	if (  !m_Tool.Init(m_strMainObjName) )
		return FALSE;
	
	m_pTool = &m_Tool;
	UpdateROIState(false); //get ROI state
	
	///------ Folger 04/15/2011 ORG-2589-P4 GO_TO_REPORT_FAILED_TO_ENABLE_FATER_OUPUT
	/*
	int nReportState = m_Tool.GetReportState();
	//init control value
	///Sophy 12/10/2010 ORG-1704-S5 REMOVE_REPORT_SHEET_EDIT_BOX_FROM_GADGET_TOOL_DIALOG
	//Control ctrl = GetItem(IDC_EDIT_REPORT_SHEET);
	//if ( ctrl )
	//{
		//ctrl.Text = m_Tool.GetReportWorksheet();
		//ctrl.Enable = (nReportState != REPORT_DISABLE)
	//}
	Control ctrl;
	///end REMOVE_REPORT_SHEET_EDIT_BOX_FROM_GADGET_TOOL_DIALOG
	ctrl = GetItem(IDC_OUTPUT_RESULT);
	if ( ctrl )
	{
		///Sophy 2/17/2011 ORG-1955-P2 PROPER_INIT_REPORT_BUTTON_STATE_WHEN_NOT_OUTPUT_TO_WORKSHEET
		//ctrl.Enable = (nReportState != REPORT_DISABLE);
		ctrl.Enable = (nReportState != REPORT_NONE);
		///end PROPER_INIT_REPORT_BUTTON_STATE_WHEN_NOT_OUTPUT_TO_WORKSHEET
	}
	
	ctrl = GetItem(IDC_BTN_ACTIVATE_REPORT);
	if ( ctrl )
		ctrl.Enable = (nReportState == REPORT_CREATED);
	
	Worksheet wksSrc;
	ctrl = GetItem(IDC_GOTO_SRC_WORKSHEET);
	if ( ctrl )
		ctrl.Enable = m_Tool.GetSourceWorksheet(wksSrc);
	*/
	/// The reason why it works before is that StartGadget() will be called from GadgetDlg::OnActiveLayerChange(), after this change :
	/// ///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
	/// GadgetDlg::OnActiveLayerChange() just simply return TRUE, that caused this bug.
	/// I don't think enable buttons should rely on dialog events or graph object events, just call CheckEnableButtons(); whenever is needed.
	CheckEnableButtons();
	///------ End GO_TO_REPORT_FAILED_TO_ENABLE_FATER_OUPUT
	
	UpdateDlgTitle();	///Sophy 12/15/2010 ORG-1755-S1 SUPPORT_SEL_DATA_IN_GADGET_DLG

	///Sophy 12/23/2010 ORG-1841 NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET
	InitMenu();
	///end NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET
	//get results in object storage.
	Tree trResults;
	if ( !m_Tool.GetResults(trResults) )
		return FALSE;
	
	InitTables(trResults);
	return ResetData(trResults);
}

BOOL	StatsGadgetDlg::UpdateDlgData()
{
	///Sophy 7/19/2010 ORG-25-P7 FAIL_TO_UPDATE_WHEN_CHANGE_SETTINGS_IN_PLT_DETAILS_DLG
	//if ( !m_Tool.IsValidLayer() || !m_Tool.IsValidGrObj() ) //tool not init
	//	return FALSE;
	if ( !m_Tool.IsValidGrObj() ) //after close Plot Details dialog, all GraphObjects all reconstruct, need to reconnect.
	{
		if ( !CheckInitTool() || !m_Tool.Init(m_strMainObjName) )
			return FALSE;
	}
	///end FAIL_TO_UPDATE_WHEN_CHANGE_SETTINGS_IN_PLT_DETAILS_DLG
	UpdateDlgTitle();	///Sophy 12/15/2010 ORG-1755-S1 SUPPORT_SEL_DATA_IN_GADGET_DLG
	
	Tree trResults;
	if ( !m_Tool.GetResults(trResults) )
		return FALSE;
	//need init table headers in case preference changed.
	InitTables(trResults);
	return ResetData(trResults);
}

BOOL	StatsGadgetDlg::ResetData(const TreeNode& trResults)
{
	m_TableOne.ClearAll();
	m_TableTwo.ClearAll();
	int nRow = 0;
	foreach(TreeNode trOneResult in trResults.Children)
	{
		///Sophy 2/15/2011 ORG-1955-S4 TABLE_ROW_COLOR_DISTINGUISH_EDITING_PLOTS
		bool bShowOnly = true;
		vector<int> vnEditingPlots;
		if ( m_Tool.GetSelectedPlots(vnEditingPlots) )
		{
			int nShowPlotIndex = -1;
			if ( trOneResult.GetAttribute(STR_PLOTINDEX_ATTRIB, nShowPlotIndex) && find_in_list(nShowPlotIndex, vnEditingPlots, false) >= 0 )
				bShowOnly = false;
		}
		///end TABLE_ROW_COLOR_DISTINGUISH_EDITING_PLOTS
		updateTable(m_TableOne, trOneResult.Inner, nRow, bShowOnly);
		updateTable(m_TableTwo, trOneResult.Outer, nRow, bShowOnly);
		nRow++;
	}
	///Sophy 12/17/2010 ORG-1755-S4 ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL
	int nPlotIndex = -1;
	string strCurData;
	if ( m_Tool.GetCurrentData(nPlotIndex, strCurData) && -1 == nPlotIndex ) //all curves state.
	{
		m_TableOne.SetRowFixed(nRow - 1);
		m_TableTwo.SetRowFixed(nRow - 1);
	}
	else
	{
		m_TableOne.SetRowFixed(-1);
		m_TableTwo.SetRowFixed(-1);
	}
	///end ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL
	m_TableOne.ResizeCols();
	m_TableTwo.ResizeCols();
	return TRUE;
}


BOOL	StatsGadgetDlg::updateTable(GridTableControl& table, const TreeNode& trStatsResult, int nRow, bool bShowOnly)
{
	if ( !trStatsResult )
		return FALSE;
	
	vector<string>	vsRowValues;
	string strVal;
	int nTypeID;
	foreach(TreeNode trNode in trStatsResult.Children)
	{
		if ( IsColOnTable(trNode) )
		{
			nTypeID = trNode.TypeID;
			string strVal;
			if ( TNVAL_TYPE_CSTRING == nTypeID )
				strVal = trNode.strVal;
			else if ( (TNVAL_TYPE_BIT_VECTOR | TNVAL_TYPE_INT) == nTypeID )
			{
				vector<int> vnVals;
				vector<string> vs;
				vnVals = trNode.nVals;
				convert_int_vector_to_string_vector(vnVals, vs);
				strVal = get_display_string(vs, 5);
			}
			else if ( (TNVAL_TYPE_BIT_VECTOR | TNVAL_TYPE_DOUBLE) == nTypeID )
			{
				vector<double> vdVals;
				vector<string> vs;
				vdVals = trNode.dVals;
				convert_double_vector_to_string_vector(vdVals, vs, vdVals.GetSize());
				strVal = get_display_string(vs, 5);
			}
			else if ( TNVAL_TYPE_INT == nTypeID )
			{
				strVal = trNode.nVal;
			}
			else	//if ( TNVAL_TYPE_DOUBLE == nTypeID )
			{
				strVal = ftoa(trNode.dVal, "*");
			}
			vsRowValues.Add(strVal);
		}
	}
	///Sophy 2/15/2011 ORG-1955-S4 TABLE_ROW_COLOR_DISTINGUISH_EDITING_PLOTS
	if ( bShowOnly )
		table.SetRowColor(nRow + 1, 0, 0x00e8e8e8, false);
	///end TABLE_ROW_COLOR_DISTINGUISH_EDITING_PLOTS
	return table.SetCells(vsRowValues, nRow, false);
}

BOOL	StatsGadgetDlg::InitTables(const TreeNode& trResults)
{
	if ( !trResults || !trResults.FirstNode )
		return FALSE;
	TreeNode trInner = trResults.FirstNode.Inner;
	if ( !trInner )
		return FALSE;
	
	string	strLabel;
	vector<string>	vsColNames;
	vector<int>		vnColTypes;
	foreach(TreeNode trCol in trInner.Children)
	{
		if ( IsColOnTable(trCol) )
		{
			if ( !trCol.GetAttribute(STR_LABEL_ATTRIB, strLabel) )
				strLabel = trCol.tagName;
			vsColNames.Add(strLabel);
			
			int nTypeID = trCol.TypeID;
			if ( TNVAL_TYPE_CSTRING & nTypeID || TNVAL_TYPE_BIT_VECTOR & nTypeID )
				vnColTypes.Add(flexDTString);
			else if ( TNVAL_TYPE_INT & nTypeID )
				vnColTypes.Add(TNVAL_TYPE_INT);
			else
				vnColTypes.Add(flexDTDouble)
		}
	}
	strLabel.SetTokens(vsColNames, '|');
	m_TableOne.SetCols(vsColNames.GetSize());
	m_TableTwo.SetCols(vsColNames.GetSize());
	m_TableOne.SetColHeaderString(strLabel);
	m_TableTwo.SetColHeaderString(strLabel);

	for ( int iCol = 0; iCol < vsColNames.GetSize(); iCol++ )
	{
		m_TableOne.SetColDataType(iCol, vnColTypes[iCol]);
		m_TableTwo.SetColDataType(iCol, vnColTypes[iCol]);
	}
	m_TableOne.SetExplorerBar(flexExSort);
	m_TableTwo.SetExplorerBar(flexExSort);
	return TRUE;
}


BOOL	StatsGadgetDlg::OnEditData(Control ctrl)
{
	m_Tool.DoEditDataPoints(GetSafeHwnd());
	return TRUE;
}

BOOL	StatsGadgetDlg::OnOutputResult(Control ctrl)
{
	m_Tool.DoOutputResult();
	///------ Folger 04/15/2011 ORG-2589-P4 GO_TO_REPORT_FAILED_TO_ENABLE_FATER_OUPUT
	CheckEnableButtons();
	///------ End GO_TO_REPORT_FAILED_TO_ENABLE_FATER_OUPUT
	return TRUE;
}

BOOL	StatsGadgetDlg::InitButtons()
{
	vector<uint> vnBtnsToHide = {
		IDC_BTN_ACTIVATE_REPORT,
		IDC_BUTTON1,
		IDC_BUTTON2,
		IDC_BUTTON3, 
		IDC_BUTTON4, 
		IDC_BUTTON5, 
		IDC_BUTTON6, 
		IDC_BUTTON7, 
		IDC_BUTTON8,
		IDC_BUTTON9,
		IDC_BUTTON10,
		IDC_BUTTON11	///Sophy 2/18/2011 ORG-2225-P1 ADD_EDIT_INNER_OUTER_SWITCH_BUTTON
	}
	for ( int iBtn = 0; iBtn < vnBtnsToHide.GetSize(); iBtn++ )
	{
		Button btn = GetItem(vnBtnsToHide[iBtn]);
		if ( btn )
			btn.Visible = false;
	}
	
	vector<uint> vnBtns = {
		IDC_BTN_ACTIVATE_REPORT,
		IDC_OUTPUT_RESULT,
		IDC_DELETE_ROW,
		IDC_MASK,
		IDC_UNMASK,
		IDC_CLEAR_DATA,
		IDC_SET_DATA,
		IDC_UNDO,
		IDC_GOTO_SRC_WORKSHEET,
		IDC_COPY_DATA
	};
	
	vector<string> vsBtnTips(vnBtns.GetSize());
	
	vsBtnTips[0] = _L("Go to Report Worksheet");
	vsBtnTips[1] = _L("Output Statistics Report");
	vsBtnTips[2] = _L("Delete Worksheet Rows");
	vsBtnTips[3] = _L("Mask Data Points");
	vsBtnTips[4] = _L("Unmask Data Points");
	vsBtnTips[5] = _L("Clear Data");
	vsBtnTips[6] = _L("Set Value");
	vsBtnTips[7] = _L("Undo Last Change");
	vsBtnTips[8] = _L("Go to Source Worksheet");
	vsBtnTips[9] = _L("Copy Data");
	vector<int> vnBitmaps = {
		IDB_GOTO_DATA,
		IDB_DUMP_DATA_INTO_WKS,
		IDB_DELETE_ROWS,
		IDB_MASK,
		IDB_UNMASK,
		IDB_CLEAR_DATA,
		IDB_SET_VALUE,
		IDB_UNDO,
		IDB_GOTO_WORKSHEET,
		IDB_COPY_DATA
	};
	for ( iBtn = 0; iBtn < vnBtns.GetSize(); iBtn++ )
	{
		Button btnCtrl = GetItem(vnBtns[iBtn]);
		if ( btnCtrl )
			btnCtrl.Visible = true;
		BitmapRadioButton btn = GetItem(vnBtns[iBtn]);
		vector<string> vsTips(1);
		vsTips[0] = vsBtnTips[iBtn];
		if ( btn )
		{
			btn.Init(1, vnBitmaps[iBtn], 16, vsTips);
		}
	}
	///Sophy 2/18/2011 ORG-2225-P1 ADD_EDIT_INNER_OUTER_SWITCH_BUTTON
	const int nStates = 2;
	vector<string> vsTips(nStates);
	vsTips[0] = _L("Switch Inner/Outer Points");
	vsTips[1] = _L("Switch Inner/Outer Points");
	BitmapRadioButton btnInnerOuter = GetItem(IDC_EDIT_INNER_OUTER);
	btnInnerOuter.Visible = true;
	btnInnerOuter.Init(nStates, IDB_INNER_OUTER_SWITCH, 16, vsTips, 0);
	btnInnerOuter.Check = 0;
	///end ADD_EDIT_INNER_OUTER_SWITCH_BUTTON
	Control ctrl = GetDlgItem(IDC_UNDO);
	if ( ctrl )
		ctrl.Enable = false; //undoable when add gadget.

	return TRUE;
}

#define	DEFAULT_GAP	3
BOOL	StatsGadgetDlg::ArrangeControls()
{
	SetControlGap(DEFAULT_GAP);
	vector<uint> vnGroupBtnIDs = {
		IDC_OUTPUT_RESULT,
		IDC_BTN_ACTIVATE_REPORT,
		IDC_GOTO_SRC_WORKSHEET
	};
	///Sophy 12/10/2010 ORG-1704-S5 REMOVE_REPORT_SHEET_EDIT_BOX_FROM_GADGET_TOOL_DIALOG
	vector<uint> vnHiddenCtrlIDs = {
		IDC_REPORT_LABEL,
		IDC_EDIT_REPORT_SHEET
	};
	for ( int iCtrl = 0; iCtrl < vnHiddenCtrlIDs.GetSize(); iCtrl++ )
	{
		Control ctrl = GetDlgItem(vnHiddenCtrlIDs[iCtrl]);
		if ( ctrl )
			ctrl.Visible = false;
	}
	///end REMOVE_REPORT_SHEET_EDIT_BOX_FROM_GADGET_TOOL_DIALOG
	const int nControlGap = GetControlGap();
	int nBottom = ArrangeControlsLeftRight(vnGroupBtnIDs, nControlGap, nControlGap, nControlGap);
	Button btnPref;
	RECT rPrefBtn;
	GetControlClientRect(vnGroupBtnIDs[0], rPrefBtn, &btnPref);
	
	Control cFrame = GetItem(IDC_FRAME);
	MoveControl(cFrame, rPrefBtn);
	cFrame.Visible = false;
	
	GetControlClientRect(vnGroupBtnIDs[vnGroupBtnIDs.GetSize() - 1], rPrefBtn, &btnPref);
	int	nOperaBtnsX = rPrefBtn.right + nControlGap * 4;
	int nOperaBtnsY = nControlGap;
	vector<uint> vnOperateBtnIDs = {
		IDC_EDIT_INNER_OUTER,	///Sophy 2/18/2011 ORG-2225-P1 ADD_EDIT_INNER_OUTER_SWITCH_BUTTON
		IDC_UNDO,
		IDC_COPY_DATA,
		IDC_CLEAR_DATA,
		IDC_DELETE_ROW,
		IDC_MASK,
		IDC_UNMASK,
		IDC_SET_DATA,
		IDC_NEW_VALUE,
		0
	};
	///Sophy 3/4/2011 ORG-1782-P5 OC_EDIT_CONTROL_NEED_TO_PROVIDE_SIMPLE_CONTEXT_MENU
	//Control ctrl = GetDlgItem(IDC_NEW_VALUE);
	//if ( ctrl )
		//ctrl.Visible = true;
	m_edtNewValue.SetSimpleContextMenu();
	m_edtNewValue = GetDlgItem(IDC_NEW_VALUE);
	m_edtNewValue.Visible = TRUE;
	///end OC_EDIT_CONTROL_NEED_TO_PROVIDE_SIMPLE_CONTEXT_MENU
	nBottom = ArrangeControlsLeftRight(vnOperateBtnIDs, nOperaBtnsX, nOperaBtnsY, nControlGap);
	
	Control tab;
	RECT rTab;
	GetControlClientRect(IDC_BOTTOM_TAB, rTab, &tab);
	rTab.top = nBottom + nControlGap;
	rTab.left = nControlGap;
	MoveControl(tab, rTab);
	return TRUE;
}
///Sophy 6/25/2010 ORG-25-P5 UPDATE_REPORT_SHEET_NAME_FROM_GADGETTOOL_DLG
//virtual
BOOL	StatsGadgetDlg::UpdateReportSheetName(LPCSTR lpcszSheetName)
{
	return m_Tool.SetReportWorksheet(lpcszSheetName); 
}
///end UPDATE_REPORT_SHEET_NAME_FROM_GADGETTOOL_DLG

///Sophy 12/15/2010 ORG-1755-S1 SUPPORT_SEL_DATA_IN_GADGET_DLG
void	StatsGadgetDlg::UpdateDlgTitle()
{
	int nIndex;
	string strData;
	if ( m_Tool.GetCurrentData(nIndex, strData) )
	{
		string strDlgTitle;
		///Sophy 2/14/2011 ORG-2225-P1 CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS
		//strDlgTitle.Format(_L("Cluster Manipulation - %s"), strData);
		string strRegion = O_QUERY_BOOL(m_dwState, GADGET_EDIT_INNER_POINTS) ? _L("Editing Inner Points") : _L("Editing Outer Points");
		strDlgTitle.Format(_L("Cluster Gadget: %s - %s"), strRegion, strData);
		///end CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS
		Text = strDlgTitle;
	}
	
}
///end SUPPORT_SEL_DATA_IN_GADGET_DLG

///Sophy 12/20/2010 ORG-1785 OUTPUT_ROI_POSITION_INFO_WHEN_OUTPUT_ROI_SHAPE_INFO
BOOL	StatsGadgetDlg::IsColOnTable(TreeNode& trCol)
{
	if ( trCol )
	{
		string strTagName = trCol.tagName;
		if ( strTagName.CompareNoCase(STR_POSITION_TAG_NAME) == 0 )
			return FALSE;
		return TRUE;
	}
	return FALSE;
}
///end OUTPUT_ROI_POSITION_INFO_WHEN_OUTPUT_ROI_SHAPE_INFO

///------ Folger 04/15/2011 ORG-2589-P4 GO_TO_REPORT_FAILED_TO_ENABLE_FATER_OUPUT
void	StatsGadgetDlg::CheckEnableButtons()
{
	int nReportState = m_Tool.GetReportState();
	Control ctrl;
	ctrl = GetItem(IDC_OUTPUT_RESULT);
	if ( ctrl )
	{
		ctrl.Enable = (nReportState != REPORT_NONE);
	}
	
	ctrl = GetItem(IDC_BTN_ACTIVATE_REPORT);
	if ( ctrl )
		ctrl.Enable = (nReportState == REPORT_CREATED);
	
	Worksheet wksSrc;
	ctrl = GetItem(IDC_GOTO_SRC_WORKSHEET);
	if ( ctrl )
		ctrl.Enable = m_Tool.GetSourceWorksheet(wksSrc);
}
///------ End GO_TO_REPORT_FAILED_TO_ENABLE_FATER_OUPUT

int		stats_gadget_message(int nMsg, DWORD dwParam/* = 0*/)
{
	static	StatsGadgetDlg*	_pStatsDlg = NULL;
	static	int				_nReferCount = 0;
	switch(nMsg)
	{
	case MSG_CREATE:
	case MSG_CHECK_CREATE:
		if ( NULL == _pStatsDlg )
		{
			ASSERT(0 == _nReferCount);
			_pStatsDlg = new StatsGadgetDlg;
			///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
			//_pStatsDlg->Create(GetWindow());
			_pStatsDlg->Create(GetWindow(), FALSE);
			///end PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
			nMsg = MSG_CREATE; //if create create and need create
		}
		if ( MSG_CREATE == nMsg )
			_nReferCount++;
		stats_gadget_message(MSG_START_GADGET); //update data
		///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
		int nOpt = O_QUERY_BOOL(dwParam, GADGETDLG_CTRL_MAKE_INVISIBLE) ? ROI_OP_SET : ROI_OP_REMOVE;	///Sophy 4/7/2011 ORG-2592-P2 MORE_WORK_GROBJTOOLS_EVENTS_HANDLING_WHEN_PAGE_DEACTIVATE
		_pStatsDlg->UpdateDlgCtrl(GADGETDLG_CTRL_MAKE_INVISIBLE, nOpt);
		///end PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
		break;
		
		
	case MSG_DESTROY:
		_nReferCount--;
		if ( 0 == _nReferCount && NULL != _pStatsDlg )
		{
			_pStatsDlg->SendMessage(WM_CLOSE); //destroy resources
			delete _pStatsDlg;
			_pStatsDlg = NULL;
		}
		else if ( NULL != _pStatsDlg )
		{
			///Sophy 7/2/2012 ORG-6119-P1 PROPER_MAKE_DIALOG_INVISIBLE_WHEN_CLOSE_CLUSTER_GADGET
			//_pStatsDlg->Visible = false;
			_pStatsDlg->UpdateDlgCtrl(GADGETDLG_CTRL_MAKE_INVISIBLE, ROI_OP_SET);
			///end PROPER_MAKE_DIALOG_INVISIBLE_WHEN_CLOSE_CLUSTER_GADGET
		}
			
		break;
		
	case MSG_START_GADGET:
		if ( NULL != _pStatsDlg )
		{
			///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
			//_pStatsDlg->Visible = _pStatsDlg->StartGadget();
			_pStatsDlg->StartGadget();
			///end PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
		}
		break;
		
	case MSG_UPDATE_DATA:
		if ( NULL != _pStatsDlg )
		{
			_pStatsDlg->UpdateDlgData();
		}
		break;
	case MSG_PLOT_CHANGED:
		if ( NULL != _pStatsDlg )
		{
			_pStatsDlg->ChangeData();
			_pStatsDlg->UpdateDlgTitle();
		}	
		break;
	case MSG_THEME_CHANGED:
		if ( NULL != _pStatsDlg )
		{
			_pStatsDlg->ChangeTheme();
		}
		break;
	case MSG_UNDO_CHANGED:
		if ( NULL != _pStatsDlg )
		{
			_pStatsDlg->UndoChange();
		}
		break;
	///Sophy 4/6/2011 ORG-2592-P1 GROBJTOOLS_EVENTS_HANDLING_WHEN_PAGE_DEACTIVATE
	case MSG_PAGE_DEACTIVATE:
		if ( NULL != _pStatsDlg )
		{
			_pStatsDlg->OnPageDeactivate();
		}
		break;
	///end GROBJTOOLS_EVENTS_HANDLING_WHEN_PAGE_DEACTIVATE
	default:
		ASSERT(FALSE);
		return -1;
	}
	return 0;
}
