/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Iris 07/16/2007 FIX_FAILURE_WHEN_CONTAINS_JAP_TEXT_IN_KEYWORDS_SECTION		*
 * Iris 07/16/2007 CLEANUP_CODES												*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
#include "BaseDocument.h"

//#define wdGoToPercent 12
#define WORD_FONT_TYPE_ARIAL	"Arial"
#define WORD_FONE_TYPE_TIMES_NEW_ROMAN "Times New Roman"
#define STR_CATEGORY_ATTRIB			_L("Category")

///Iris 07/16/2007 CLEANUP_CODES
//enum{
	//LEVEL_NONE,
	////LEVEL_1,
	//LEVEL_CATEGORY,
	//LEVEL_3,
	//LEVEL_4  //body text
//};

enum{
	LEVEL_NONE,
	LEVEL_CATEGORY,
	LEVEL_QUESTION,
	LEVEL_KEYWORDS
};
///end CLEANUP_CODES

class QuickHelp: public WordDocument
{
public:
	QuickHelp(bool bVisible);
	~QuickHelp();
	
	//virtual
	bool OpenDoc(LPCSTR lpcszFile=NULL);	//NULL to open an empty one
	
	string GetCurrentFont();	///Joseph 01/19/07 MAKE_QUICK_HELP_TXT
	int GetTextType();
	void MoveNextLine();
};

QuickHelp::QuickHelp(bool bVisible) : WordDocument(bVisible)
{
}
QuickHelp::~QuickHelp()
{
	//~WordDocument();
}
bool QuickHelp::OpenDoc(LPCSTR lpcszFile)	//NULL to open an empty one
{
	string strFile(lpcszFile);
	try
	{
		if(strFile.IsEmpty())
			m_oActiveDoc = m_oWord.Documents.Add();	// Add a blank document
		else
			m_oActiveDoc = m_oWord.Documents.Open(FileName := strFile, ReadOnly := true);	//set as read only, to ignore the open dialog when this file already open
	}
	catch(int nError)
	{
		return false;
	}
	return true;
}

///Joseph 01/19/07 MAKE_QUICK_HELP_TXT
string QuickHelp::GetCurrentFont()
{	
	m_oWord.Selection.HomeKey(Unit:=wdLine);
	m_oWord.Selection.SelectCurrentFont();
	/// Iris 07/16/2007 FIX_FAILURE_WHEN_CONTAINS_JAP_TEXT_IN_KEYWORDS_SECTION
	// If contains Japanese text or picture in one section, Selection object will stop at English Text since the font is different
	// in J text and E text. The same reason for fail to get whole text when the section include picutre.
	m_oWord.Selection.EndOf(Unit:=wdParagraph, Extend:=wdExtend);
	///end FIX_FAILURE_WHEN_CONTAINS_JAP_TEXT_IN_KEYWORDS_SECTION
	return m_oWord.Selection.Text;
}


void QuickHelp::MoveNextLine()
{
	m_oWord.Selection.MoveRight(Unit:=wdCharacter, Count:=1);
}

int QuickHelp::GetTextType()
{
	int 	nSize = m_oWord.Selection.Font.Size;
	string 	strSelFontType = m_oWord.Selection.Font.NameAscii;
	
	//if(nSize == 16)
		//return LEVEL_1;
		
	if(nSize == 12 && !(strSelFontType.Compare(WORD_FONT_TYPE_ARIAL)))
		return LEVEL_CATEGORY;
	
	if(nSize == 11)
		return LEVEL_QUESTION;
	
	if(nSize == 10 && !(strSelFontType.Compare(WORD_FONE_TYPE_TIMES_NEW_ROMAN)))
		return LEVEL_KEYWORDS; 
		
	return LEVEL_NONE;
}
//the QuickHelp Class End

bool quickhelp_from_doc_to_txt(const string& strRes, const string& strDest)
{
	QuickHelp oWord(false);
	string strDestTxt;
	if(strDest.IsEmpty())
		strDestTxt = GetFilenameWithoutExt(strRes) + ".txt";
	else
		strDestTxt = strDest;
	stdioFile stdFile(strDestTxt, file::modeCreate | file::modeWrite);
	if(!oWord.IsValid())
		return false;

	oWord.SetFileName(strRes);
	if(!oWord.OpenDoc(strRes))
		return false;
	
	quickhelp_write_head(stdFile);  
	Tree trResult;
	string strLast;
	int nCount = 0;  //if nCount >=2, then we consider that we have reach end of the file.
	while(true)
	{
		string strGet;
		strGet = oWord.GetCurrentFont();

		switch(oWord.GetTextType())
		{
		case LEVEL_CATEGORY:
			string strCategory = quickhelp_get_valide_category(strGet);
			if(strCategory.GetLength() > 0)
				strGet = strCategory;
			TreeNode trCategory = trResult.AddNode(_L("Category"));
			trCategory.SetAttribute(STR_CATEGORY_ATTRIB, strGet);
			break;
			
		case LEVEL_QUESTION:
			TreeNode tr = trResult.LastNode;
			if(tr)
			{
				quickhelp_add_question_node(tr, strGet);
			}
			break;
			
		case LEVEL_KEYWORDS:
			string strKeyWords = quickhelp_get_keywords(strGet);
			TreeNode tr = trResult.LastNode;
			if(tr && strKeyWords.GetLength() > 0)
			{
				TreeNode trKeyWords = tr.AddNode(_L("KeyWords"));
				trKeyWords.strVal = strKeyWords;
			}			
			break;		
			
		default:
			break;
		}		
			
		if(!strLast.Compare(strGet))
		{
			if(nCount > 2)
				break;
			else
			{
				oWord.MoveNextLine();
				nCount++;	
				continue;
			}
		}
		strLast = strGet;
		oWord.MoveNextLine();
		nCount = 0;
	}
	
	quickhelp_tree_to_file(trResult, stdFile);
	oWord.CloseDoc();
	stdFile.Close();
	return true;
}
	

void quickhelp_write_head(stdioFile& stdFile)
{
	string strCategory;
	string strKeyword;
	string strQuestion;
	strCategory ="\"" + _L("Category\"") + ",";
	strKeyword = "\"" + _L("Key words\"") + ",";
	strQuestion = "\"" + _L("Question\"") + ",";
	string str = strCategory + strQuestion + strKeyword + "\r\n";
	stdFile.WriteString(str);
}

string quickhelp_get_valide_category(LPCSTR lpcszCategory)
{
	vector<string> vsCategory;
	string strCategory(lpcszCategory);
	strCategory.TrimRight();
	str_separate(strCategory, "\r", vsCategory);
	int nSize = vsCategory.GetSize();
	if(nSize > 0)
	{
		string strTemp = vsCategory[nSize - 1];
		return strTemp;
	}
	return "";
}

//write string from tree to file
bool quickhelp_tree_to_file(const TreeNode trResult, stdioFile& stdFile)
{
	foreach(TreeNode trChild in trResult.Children)
	{
		string strVal;
		int nCount = trChild.GetNodeCount();
		if(nCount < 1)
			continue;

		bool bAllQuestion = false;
		for(int ii = 0; ii< nCount; ii = ii + 1)
		{
			string strCategory;
			trChild.GetAttribute(STR_CATEGORY_ATTRIB, strCategory);
			quickhelp_format_string(strCategory);
			TreeNode trQuestion= tree_get_node(trChild, ii);
			string strQuestVal;
			if(trQuestion)
				strQuestVal = trQuestion.strVal;
			for(int jj = 1; jj < nCount -ii; jj++)
			{
				TreeNode trLast = tree_get_node(trChild, ii + jj -1);
				TreeNode trTemp = tree_get_node(trChild, ii + jj);
				string strTagName = trTemp.tagName;
				if(! strTagName.Compare(_L("KeyWords")))
					break;
				if(jj > 0)
					strQuestVal = trLast.strVal;
				quickhelp_format_string(strQuestVal);
				strVal = strCategory + "," + strQuestVal + "," + "\"\"" + ",";
				stdFile.WriteString(strVal);
				if(ii + jj == nCount-1)
				{
					strQuestVal = trTemp.strVal;
					quickhelp_format_string(strQuestVal);
					strVal = strCategory + "," + strQuestVal + "," + "\"\"" + ",";
					stdFile.WriteString(strVal);
					bAllQuestion = true;
				}
			}
			if(bAllQuestion)
				break;
			string strKeyWordVal;
			if(nCount > 1)
			{
				TreeNode trKeyWords = tree_get_node(trChild, ii + jj);
				trQuestion = tree_get_node(trChild, ii + jj -1);
				if(trKeyWords && trQuestion)
				{
					strQuestVal = trQuestion.strVal;
					strKeyWordVal = trKeyWords.strVal;
					strKeyWordVal.TrimLeft(_L("Keywords:"));
					ii = ii + jj;
				}
			}

			quickhelp_format_string(strKeyWordVal);
			quickhelp_format_string(strQuestVal);
			strVal = strCategory + "," + strQuestVal + "," + strKeyWordVal;
			stdFile.WriteString(strVal);
		}
		//}
		//else
			//return false;
	}
	return true;
}
//format the string
void quickhelp_format_string(string& str)
{
	str.TrimLeft();
	str.TrimRight("\r\n");
	str = "\"" + str + "\"";
}

string quickhelp_get_keywords(LPCSTR lpcszGet)
{
	string strGet(lpcszGet);
	int nKeywordIndex = strGet.Find(_L("Keywords:"));
	if(nKeywordIndex < 0)
		return "";
	else
	{
		strGet.Delete(0, nKeywordIndex);
		return strGet;
	}
}

void quickhelp_add_question_node(TreeNode& tr, LPCSTR lpcszGet)
{
	vector<string> vsQuestion;
	str_separate(lpcszGet, "\r", vsQuestion);
	int nSize = vsQuestion.GetSize();
	for(int ii = 0; ii < nSize - 1; ii++)
	{
		TreeNode trTemp = tr.AddNode(_L("Question"));
		trTemp.strVal = vsQuestion[ii];
	}
}

