/*******************************************************************************
 *                                WINHEAD.TXT										
 *																					
 *                          $Date: 9/18/02 10:14a $									
 *																					
 *              Header Structure For WinView/WinSpec (WINX) Files					
 *																					
 * The current data file used for WINX files consists of a 4100 (1004 Hex)			
 * byte header followed by the data.												
 *																					
 * Beginning with Version 2.5, many more items were added to the header to				
 * make it a complete as possible record of the data collection.  This includes		
 * spectrograph and pulser information.  Much of these additions were accomplished	
 * by recycling old information which had not been used in many versions.			
 * All data files created under previous 2.x versions of WinView/WinSpec CAN		
 * still be read correctly.  HOWEVER, files created under the new versions			
 * (2.5 and higher) CANNOT be read by previous versions of WinView/WinSpec			
 * OR by the CSMA software package.													
 *
 *             ***************************************************
 *																					
 ******************************************************************************/

/*******************************************************************************
                                    Decimal Byte
                                       Offset
                                    -----------
  SHORT   ControllerVersion              0  Hardware Version
  SHORT   LogicOutput                    2  Definition of Output BNC
  WORD    AmpHiCapLowNoise               4  Amp Switching Mode
  WORD    xDimDet                        6  Detector x dimension of chip.
  SHORT   mode                           8  timing mode
  float   exp_sec                       10  alternitive exposure, in sec.
  SHORT   VChipXdim                     14  Virtual Chip X dim
  SHORT   VChipYdim                     16  Virtual Chip Y dim
  WORD    yDimDet                       18  y dimension of CCD or detector.
  char    date[DATEMAX]                 20  date
  SHORT   VirtualChipFlag               30  On/Off
  char    Spare_1[2]                    32
  SHORT   noscan                        34  Old number of scans - should always be -1
  float   DetTemperature                36  Detector Temperature Set
  SHORT   DetType                       40  CCD/DiodeArray type
  WORD    xdim                          42  actual # of pixels on x axis
  SHORT   stdiode                       44  trigger diode
  float   DelayTime                     46  Used with Async Mode
  WORD    ShutterControl                50  Normal, Disabled Open, Disabled Closed
  SHORT   AbsorbLive                    52  On/Off
  WORD    AbsorbMode                    54  Reference Strip or File
  SHORT   CanDoVirtualChipFlag          56  T/F Cont/Chip able to do Virtual Chip
  SHORT   ThresholdMinLive              58  On/Off
  float   ThresholdMinVal               60  Threshold Minimum Value
  SHORT   ThresholdMaxLive              64  On/Off
  float   ThresholdMaxVal               66  Threshold Maximum Value
  SHORT   SpecAutoSpectroMode           70  T/F Spectrograph Used
  float   SpecCenterWlNm                72  Center Wavelength in Nm
  SHORT   SpecGlueFlag                  76  T/F File is Glued
  float   SpecGlueStartWlNm             78  Starting Wavelength in Nm
  float   SpecGlueEndWlNm               82  Starting Wavelength in Nm
  float   SpecGlueMinOvrlpNm            86  Minimum Overlap in Nm
  float   SpecGlueFinalResNm            90  Final Resolution in Nm
  SHORT   PulserType                    94  0=None, PG200=1, PTG=2, DG535=3
  SHORT   CustomChipFlag                96  T/F Custom Chip Used
  SHORT   XPrePixels                    98  Pre Pixels in X direction
  SHORT   XPostPixels                  100  Post Pixels in X direction
  SHORT   YPrePixels                   102  Pre Pixels in Y direction 
  SHORT   YPostPixels                  104  Post Pixels in Y direction
  SHORT   asynen                       106  asynchron enable flag  0 = off
  SHORT   datatype                     108  experiment datatype
                                             0 =   FLOATING POINT
                                             1 =   LONG INTEGER
                                             2 =   INTEGER
                                             3 =   UNSIGNED INTEGER //---- SY 03-22-2004 ???? should be UINT16 or WORD or SHORT ????
  SHORT   PulserMode                   110  Repetitive/Sequential
  USHORT  PulserOnChipAccums           112  Num PTG On-Chip Accums
  DWORD   PulserRepeatExp              114  Num Exp Repeats (Pulser SW Accum)
  float   PulseRepWidth                118  Width Value for Repetitive pulse (usec)
  float   PulseRepDelay                122  Width Value for Repetitive pulse (usec)
  float   PulseSeqStartWidth           126  Start Width for Sequential pulse (usec)
  float   PulseSeqEndWidth             130  End Width for Sequential pulse (usec)
  float   PulseSeqStartDelay           134  Start Delay for Sequential pulse (usec)
  float   PulseSeqEndDelay             138  End Delay for Sequential pulse (usec)
  SHORT   PulseSeqIncMode              142  Increments: 1=Fixed, 2=Exponential
  SHORT   PImaxUsed                    144  PI-Max type controller flag
  SHORT   PImaxMode                    146  PI-Max mode
  SHORT   PImaxGain                    148  PI-Max Gain
  SHORT   BackGrndApplied              150  1 if background subtraction done
  SHORT   PImax2nsBrdUsed              152  T/F PI-Max 2ns Board Used
  WORD    minblk                       154  min. # of strips per skips
  WORD    numminblk                    156  # of min-blocks before geo skps
  SHORT   SpecMirrorLocation[2]        158  Spectro Mirror Location, 0=Not Present
  SHORT   SpecSlitLocation[4]          162  Spectro Slit Location, 0=Not Present
  SHORT   CustomTimingFlag             170  T/F Custom Timing Used
  char    ExperimentTimeLocal[TIMEMAX] 172  Experiment Local Time as hhmmss\0
  char    ExperimentTimeUTC[TIMEMAX]   179  Experiment UTC Time as hhmmss\0
  SHORT   ExposUnits                   186  User Units for Exposure
  WORD    ADCoffset                    188  ADC offset
  WORD    ADCrate                      190  ADC rate
  WORD    ADCtype                      192  ADC type
  WORD    ADCresolution                194  ADC resolution
  WORD    ADCbitAdjust                 196  ADC bit adjust
  WORD    gain                         198  gain
  char    Comments[5][COMMENTMAX]      200  File Comments
  WORD    geometric                    600  geometric ops: rotate 0x01,
                                             reverse 0x02, flip 0x04
  char    xlabel[LABELMAX]             602  intensity display string
  WORD    cleans                       618  cleans
  WORD    NumSkpPerCln                 620  number of skips per clean.
  SHORT   SpecMirrorPos[2]             622  Spectrograph Mirror Positions
  float   SpecSlitPos[4]               626  Spectrograph Slit Positions
  SHORT   AutoCleansActive             642  T/F
  SHORT   UseContCleansInst            644  T/F
  SHORT   AbsorbStripNum               646  Absorbance Strip Number
  SHORT   SpecSlitPosUnits             648  Spectrograph Slit Position Units
  float   SpecGrooves                  650  Spectrograph Grating Grooves
  SHORT   srccmp                       654  number of source comp. diodes
  WORD    ydim                         656  y dimension of raw data.
  SHORT   scramble                     658  0=scrambled,1=unscrambled
  SHORT   ContinuousCleansFlag         660  T/F Continuous Cleans Timing Option
  SHORT   ExternalTriggerFlag          662  T/F External Trigger Timing Option
  long    lnoscan                      664  Number of scans (Early WinX)
  long    lavgexp                      668  Number of Accumulations
  float   ReadoutTime                  672  Experiment readout time
  SHORT   TriggeredModeFlag            676  T/F Triggered Timing Option
  char    Spare_2[10]                  678  
  char    sw_version[FILEVERMAX]       688  Version of SW creating this file
  SHORT   type                         704   1 = new120 (Type II)             
                                             2 = old120 (Type I )           
                                             3 = ST130                      
                                             4 = ST121                      
                                             5 = ST138                      
                                             6 = DC131 (PentaMax)           
                                             7 = ST133 (MicroMax/SpectroMax)
                                             8 = ST135 (GPIB)               
                                             9 = VICCD                      
                                            10 = ST116 (GPIB)               
                                            11 = OMA3 (GPIB)                
                                            12 = OMA4                       
  SHORT   flatFieldApplied             706  1 if flat field was applied.
  char    Spare_3[16]                  708  
  SHORT   kin_trig_mode                724  Kinetics Trigger Mode
  char    dlabel[LABELMAX]             726  Data label.
  char    Spare_4[436]                 742
  char    PulseFileName[HDRNAMEMAX]   1178  Name of Pulser File with
                                             Pulse Widths/Delays (for Z-Slice)
  char    AbsorbFileName[HDRNAMEMAX]  1298 Name of Absorbance File (if File Mode)
  DWORD   NumExpRepeats               1418  Number of Times experiment repeated
  DWORD   NumExpAccums                1422  Number of Time experiment accumulated
  SHORT   YT_Flag                     1426  Set to 1 if this file contains YT data
  float   clkspd_us                   1428  Vert Clock Speed in micro-sec
  SHORT   HWaccumFlag                 1432  set to 1 if accum done by Hardware.
  SHORT   StoreSync                   1434  set to 1 if store sync used
  SHORT   BlemishApplied              1436  set to 1 if blemish removal applied
  SHORT   CosmicApplied               1438  set to 1 if cosmic ray removal applied
  SHORT   CosmicType                  1440  if cosmic ray applied, this is type
  float   CosmicThreshold             1442  Threshold of cosmic ray removal.  
  long    NumFrames                   1446  number of frames in file.         
  float   MaxIntensity                1450  max intensity of data (future)    
  float   MinIntensity                1454  min intensity of data (future)    
  char    ylabel[LABELMAX]            1458  y axis label.                     
  WORD    ShutterType                 1474  shutter type.                     
  float   shutterComp                 1476  shutter compensation time.        
  WORD    readoutMode                 1480  readout mode, full,kinetics, etc  
  WORD    WindowSize                  1482  window size for kinetics only.    
  WORD    clkspd                      1484  clock speed for kinetics & frame transfer
  WORD    interface_type              1486  computer interface                
                                             (isa-taxi, pci, eisa, etc.)             
  SHORT   NumROIsInExperiment         1488  May be more than the 10 allowed in
                                             this header (if 0, assume 1)            
  char    Spare_5[16]                 1490                                    
  WORD    controllerNum               1506  if multiple controller system will
                                             have controller number data came from.  
                                             this is a future item.                  
  WORD    SWmade                      1508  Which software package created this file 
  SHORT   NumROI                      1510  number of ROIs used. if 0 assume 1.      
                                      1512 - 1630  ROI information      
  struct ROIinfo { //---- SY 03-22-2004 ???? should be WORD or SHORT ????                                                   
   unsigned int startx                left x start value.               
   unsigned int endx                  right x value.                    
   unsigned int groupx                amount x is binned/grouped in hw. 
   unsigned int starty                top y start value.                
   unsigned int endy                  bottom y value.                   
   unsigned int groupy                amount y is binned/grouped in hw. 
  } ROIinfoblk[ROIMAX]                   ROI Starting Offsets:          
                                                  ROI  1 = 1512         
                                                  ROI  2 = 1524         
                                                  ROI  3 = 1536         
                                                  ROI  4 = 1548         
                                                  ROI  5 = 1560         
                                                  ROI  6 = 1572         
                                                  ROI  7 = 1584         
                                                  ROI  8 = 1596         
                                                  ROI  9 = 1608         
                                                  ROI 10 = 1620         
  char    FlatField[HDRNAMEMAX]       1632  Flat field file name.       
  char    background[HDRNAMEMAX]      1752  background sub. file name.  
  char    blemish[HDRNAMEMAX]         1872  blemish file name.          
  float   file_header_ver             1992  version of this file header 
  char    YT_Info[1000]               1996-2996  Reserved for YT information
  LONG    WinView_id                  2996  == 0x01234567L if file created by WinX

-------------------------------------------------------------------------------

                        START OF X CALIBRATION STRUCTURE

  double        offset                3000  offset for absolute data scaling
  double        factor                3008  factor for absolute data scaling
  char          current_unit          3016  selected scaling unit           
  char          reserved1             3017  reserved                        
  char          string[40]            3018  special string for scaling      
  char          reserved2[40]         3058  reserved                        
  char          calib_valid           3098  flag if calibration is valid    
  char          input_unit            3099  current input units for         
                                            "calib_value"                  
  char          polynom_unit          3100  linear UNIT and used            
                                            in the "polynom_coeff"         
  char          polynom_order         3101  ORDER of calibration POLYNOM    
  char          calib_count           3102  valid calibration data pairs    
  double        pixel_position[10]    3103  pixel pos. of calibration data  
  double        calib_value[10]       3183  calibration VALUE at above pos  
  double        polynom_coeff[6]      3263  polynom COEFFICIENTS            
  double        laser_position        3311  laser wavenumber for relativ WN 
  char          reserved3             3319  reserved                        
  unsigned char new_calib_flag        3320  If set to 200, valid label below
  char          calib_label[81]       3321  Calibration label (NULL term'd) 
  char          expansion[87]         3402  Calibration Expansion area      

-------------------------------------------------------------------------------

                        START OF Y CALIBRATION STRUCTURE

  double        offset                3489  offset for absolute data scaling
  double        factor                3497  factor for absolute data scaling
  char          current_unit          3505  selected scaling unit           
  char          reserved1             3506  reserved                        
  char          string[40]            3507  special string for scaling      
  char          reserved2[40]         3547  reserved                        
  char          calib_valid           3587  flag if calibration is valid    
  char          input_unit            3588  current input units for         
                                            "calib_value"                   
  char          polynom_unit          3589  linear UNIT and used            
                                            in the "polynom_coeff"          
  char          polynom_order         3590  ORDER of calibration POLYNOM    
  char          calib_count           3591  valid calibration data pairs    
  double        pixel_position[10]    3592  pixel pos. of calibration data  
  double        calib_value[10]       3672  calibration VALUE at above pos  
  double        polynom_coeff[6]      3752  polynom COEFFICIENTS            
  double        laser_position        3800  laser wavenumber for relativ WN 
  char          reserved3             3808  reserved                        
  unsigned char new_calib_flag        3809  If set to 200, valid label below
  char          calib_label[81]       3810  Calibration label (NULL term'd) 
  char          expansion[87]         3891  Calibration Expansion area      

                         END OF CALIBRATION STRUCTURES

    ---------------------------------------------------------------------

  char    Istring[40]                 3978  special intensity scaling string
  char    Spare_6[76]                 4018
  SHORT   AvGainUsed                  4094  avalanche gain was used
  SHORT   AvGain                      4096  avalanche gain value
  SHORT   lastvalue                   4098  Always the LAST value in the header
 ******************************************************************************/
                        /* 4100 Start of Data */
 
/******************************************************************************
 *	Definitions of array sizes:
 *	    HDRNAMEMAX  = 120     Max char str length for file name
 *	    USERINFOMAX = 1000    User information space
 *	    COMMENTMAX  = 80      User comment string max length (5 comments)
 *	    LABELMAX    = 16      Label string max length
 *	    FILEVERMAX  = 16      File version string max length
 *	    DATEMAX     = 10      String length of file creation date string as ddmmmyyyy\0
 *	    ROIMAX      = 10      Max size of roi array of structures
 *	    TIMEMAX     = 7       Max time store as hhmmss\0
 *	
 ******************************************************************************/
#define	HDRNAMEMAX	120		//Max char str length for file name
#define	USERINFOMAX	1000	//User information space
#define	COMMENTMAX	80		//User comment string max length (5 comments)
#define	LABELMAX	16		//Label string max length
#define	FILEVERMAX	16		//File version string max length
#define	DATEMAX		10		//String length of file creation date string as ddmmmyyyy\0
#define	ROIMAX		10		//Max size of roi array of structures
#define	TIMEMAX		7		//Max time store as hhmmss\0

// WinView/WinSpec(WINX) files experiment datatype
enum {
	SPE_DATATYPE_FLOAT,		//0 =   FLOATING POINT
	SPE_DATATYPE_LONG,		//1 =   LONG INTEGER
	SPE_DATATYPE_INT,		//2 =   INTEGER
	SPE_DATATYPE_UINT		//3 =   UNSIGNED INTEGER (UINT16)
};

#pragma pack(push,1)

// unsigned int is size 4, according byte offset in WINHEAD.txt, should change to WORD
typedef struct { //---- SY 03-22-2004 ???? should be WORD or SHORT ????                                                   
	WORD startx;//unsigned int startx;  //	left x start value.               
	WORD endx; 	//unsigned int endx;    //	right x value.                    
	WORD groupx;//unsigned int groupx;  //	amount x is binned/grouped in hw. 
	WORD starty;//unsigned int starty;  //	top y start value.                
	WORD endy;	//unsigned int endy;    //	bottom y value.                   
	WORD groupy;//unsigned int groupy;  //	amount y is binned/grouped in hw. 
} ROIinfo; 			                   	//	ROI Starting Offsets:          
                                        //	      ROI  1 = 1512         
                                        //	      ROI  2 = 1524         
                                        //	      ROI  3 = 1536         
                                        //	      ROI  4 = 1548         
                                        //	      ROI  5 = 1560         
                                        //	      ROI  6 = 1572         
                                        //	      ROI  7 = 1584         
                                        //	      ROI  8 = 1596         
                                        //	      ROI  9 = 1608         
                                        //	      ROI 10 = 1620         

                                        
typedef struct {
	double        offset;                	//	offset for absolute data scaling
	double        factor;                	//	factor for absolute data scaling
	char          current_unit;          	//	selected scaling unit           
	char          reserved1;             	//	reserved                        
	char          str[40];            		//	special string for scaling      
	char          reserved2[40];         	//	reserved                        
	char          calib_valid;           	//	flag if calibration is valid    
	char          input_unit;            	//	current input units for "calib_value"      
	char          polynom_unit;          	//	linear UNIT and used in the "polynom_coeff"           
	char          polynom_order;         	//	ORDER of calibration POLYNOM    
	char          calib_count;           	//	valid calibration data pairs
//#ifdef STRUCT2TREE
//	double        pixel_position[10];    	//	pixel pos. of calibration data  
//	double        calib_value[10];       	//	calibration VALUE at above pos  
//	double        polynom_coeff[6];      	//	polynom COEFFICIENTS            
//#else // !STRUCT2TREE
//	double        pixel_position[10];    	//	pixel pos. of calibration data
	double        pixel_position0;  
	double        pixel_position1;  
	double        pixel_position2;  
	double        pixel_position3;  
	double        pixel_position4;  
	double        pixel_position5;  
	double        pixel_position6;  
	double        pixel_position7;  
	double        pixel_position8;  
	double        pixel_position9;  
//	double        calib_value[10];       	//	calibration VALUE at above pos
	double        calib_value0;  
	double        calib_value1;  
	double        calib_value2;  
	double        calib_value3;  
	double        calib_value4;  
	double        calib_value5;  
	double        calib_value6;  
	double        calib_value7;  
	double        calib_value8;  
	double        calib_value9;  
//	double        polynom_coeff[6];      	//	polynom COEFFICIENTS
	double        polynom_coeff0;            
	double        polynom_coeff1;            
	double        polynom_coeff2;            
	double        polynom_coeff3;            
	double        polynom_coeff4;            
	double        polynom_coeff5;            
//#endif // STRUCT2TREE
	double        laser_position;        	//	laser wavenumber for relativ WN 
	char          reserved3;             	//	reserved                        
	unsigned char new_calib_flag;        	//	If set to 200, valid label below
	char          calib_label[81];       	//	Calibration label (NULL term'd) 
	char          expansion[87];         	//	Calibration Expansion area      
} SPECalib;

#ifndef SHORT
typedef short SHORT; /* signed           16 bit int */
#endif
	
typedef struct
	{ 
	SHORT   ControllerVersion;        		//    0  Hardware Version
	SHORT   LogicOutput;               		//    2  Definition of Output BNC
	WORD    AmpHiCapLowNoise;          		//    4  Amp Switching Mode
	WORD    xDimDet;                   		//    6  Detector x dimension of chip.
	SHORT   mode;                       	//    8  timing mode
	float   exp_sec;                    	//   10  alternitive exposure, in sec.
	SHORT   VChipXdim;                  	//   14  Virtual Chip X dim
	SHORT   VChipYdim;                  	//   16  Virtual Chip Y dim
	WORD    yDimDet;                    	//   18  y dimension of CCD or detector.
	char    date[DATEMAX];              	//   20  date
	SHORT   VirtualChipFlag;            	//   30  On/Off
	char    Spare_1[2];                 	//   32
	SHORT   noscan;                     	//   34  Old number of scans - should always be -1
	float   DetTemperature;             	//   36  Detector Temperature Set
	SHORT   DetType;                    	//   40  CCD/DiodeArray type
	WORD    xdim;                       	//   42  actual # of pixels on x axis
	SHORT   stdiode;                    	//   44  trigger diode
	float   DelayTime;                  	//   46  Used with Async Mode
	WORD    ShutterControl;             	//   50  Normal, Disabled Open, Disabled Closed
	SHORT   AbsorbLive;                 	//   52  On/Off
	WORD    AbsorbMode;                 	//   54  Reference Strip or File
	SHORT   CanDoVirtualChipFlag;       	//   56  T/F Cont/Chip able to do Virtual Chip
	SHORT   ThresholdMinLive;           	//   58  On/Off
	float   ThresholdMinVal;            	//   60  Threshold Minimum Value
	SHORT   ThresholdMaxLive;           	//   64  On/Off
	float   ThresholdMaxVal;            	//   66  Threshold Maximum Value
	SHORT   SpecAutoSpectroMode;        	//   70  T/F Spectrograph Used
	float   SpecCenterWlNm;             	//   72  Center Wavelength in Nm
	SHORT   SpecGlueFlag;               	//   76  T/F File is Glued
	float   SpecGlueStartWlNm;          	//   78  Starting Wavelength in Nm
	float   SpecGlueEndWlNm;            	//   82  Starting Wavelength in Nm
	float   SpecGlueMinOvrlpNm;         	//   86  Minimum Overlap in Nm
	float   SpecGlueFinalResNm;         	//   90  Final Resolution in Nm
	SHORT   PulserType;                 	//   94  0=None, PG200=1, PTG=2, DG535=3
	SHORT   CustomChipFlag;             	//   96  T/F Custom Chip Used
	SHORT   XPrePixels;                 	//   98  Pre Pixels in X direction
	SHORT   XPostPixels;                	//  100  Post Pixels in X direction
	SHORT   YPrePixels;                 	//  102  Pre Pixels in Y direction 
	SHORT   YPostPixels;                	//  104  Post Pixels in Y direction
	SHORT   asynen;                     	//  106  asynchron enable flag  0 = off
	SHORT   datatype;                   	//  108  experiment datatype
	                                    	//     0 =   FLOATING POINT
	                                    	//     1 =   LONG INTEGER
	                                    	//     2 =   INTEGER
	                                    	//     3 =   UNSIGNED INTEGER
	SHORT   PulserMode;                 	//  110  Repetitive/Sequential
	USHORT  PulserOnChipAccums;         	//  112  Num PTG On-Chip Accums
	DWORD   PulserRepeatExp;            	//  114  Num Exp Repeats (Pulser SW Accum)
	float   PulseRepWidth;              	//  118  Width Value for Repetitive pulse (usec)
	float   PulseRepDelay;              	//  122  Width Value for Repetitive pulse (usec)
	float   PulseSeqStartWidth;         	//  126  Start Width for Sequential pulse (usec)
	float   PulseSeqEndWidth;           	//  130  End Width for Sequential pulse (usec)
	float   PulseSeqStartDelay;         	//  134  Start Delay for Sequential pulse (usec)
	float   PulseSeqEndDelay;           	//  138  End Delay for Sequential pulse (usec)
	SHORT   PulseSeqIncMode;            	//  142  Increments: 1=Fixed, 2=Exponential
	SHORT   PImaxUsed;                  	//  144  PI-Max type controller flag
	SHORT   PImaxMode;                  	//  146  PI-Max mode
	SHORT   PImaxGain;                  	//  148  PI-Max Gain
	SHORT   BackGrndApplied;           	 	//  150  1 if background subtraction done
	SHORT   PImax2nsBrdUsed;            	//  152  T/F PI-Max 2ns Board Used
	WORD    minblk;                     	//  154  min. # of strips per skips
	WORD    numminblk;                  	//  156  # of min-blocks before geo skps
//#ifdef STRUCT2TREE
//	SHORT   SpecMirrorLocation[2];			//  158  Spectro Mirror Location, 0=Not Present
//	SHORT   SpecSlitLocation[4];			//  162  Spectro Slit Location, 0=Not Present
//#else // !STRUCT2TREE	
//	SHORT   SpecMirrorLocation[2];      	//  158  Spectro Mirror Location, 0=Not Present
	SHORT	SpecMirrorLocation0;
	SHORT	SpecMirrorLocation1;
//	SHORT   SpecSlitLocation[4];        	//  162  Spectro Slit Location, 0=Not Present
	SHORT   SpecSlitLocation0;
	SHORT   SpecSlitLocation1;
	SHORT   SpecSlitLocation2;
	SHORT   SpecSlitLocation3;
//#endif // STRUCT2TREE
	SHORT   CustomTimingFlag;           	//  170  T/F Custom Timing Used
	char    ExperimentTimeLocal[TIMEMAX]; 	//	172  Experiment Local Time as hhmmss\0
	char    ExperimentTimeUTC[TIMEMAX];   	//	179  Experiment UTC Time as hhmmss\0
	SHORT   ExposUnits;                   	//	186  User Units for Exposure
	WORD    ADCoffset;                    	//	188  ADC offset
	WORD    ADCrate;                      	//	190  ADC rate
	WORD    ADCtype;                      	//	192  ADC type
	WORD    ADCresolution;                	//	194  ADC resolution
	WORD    ADCbitAdjust;                 	//	196  ADC bit adjust
	WORD    gain;                         	//	198  gain
//	char    Comments[5][COMMENTMAX];      	//	200  File Comments
	char    Comments0[COMMENTMAX];      	//	200  File Comments
	char    Comments1[COMMENTMAX];      	//	200  File Comments
	char    Comments2[COMMENTMAX];      	//	200  File Comments
	char    Comments3[COMMENTMAX];      	//	200  File Comments
	char    Comments4[COMMENTMAX];      	//	200  File Comments
	
	WORD    geometric;                    	//	600  geometric ops: rotate 0x01,
	                                        //	 	reverse 0x02, flip 0x04
	char    xlabel[LABELMAX];             	//	602  intensity display string
	WORD    cleans;                       	//	618  cleans
	WORD    NumSkpPerCln;                 	//	620  number of skips per clean.
//#ifdef STRUCT2TREE
//	SHORT   SpecMirrorPos[2];             	//	622  Spectrograph Mirror Positions
//	float   SpecSlitPos[4];               	//	626  Spectrograph Slit Positions
//#else // !STRUCT2TREE	
//	SHORT   SpecMirrorPos[2];             	//	622  Spectrograph Mirror Positions
	SHORT 	SpecMirrorPos0;
	SHORT 	SpecMirrorPos1;
//	float   SpecSlitPos[4];               	//	626  Spectrograph Slit Positions
	float   SpecSlitPos0;
	float   SpecSlitPos1;
	float   SpecSlitPos2;
	float   SpecSlitPos3;
//#endif // STRUCT2TREE
	SHORT   AutoCleansActive;             	//	642  T/F
	SHORT   UseContCleansInst;            	//	644  T/F
	SHORT   AbsorbStripNum;               	//	646  Absorbance Strip Number
	SHORT   SpecSlitPosUnits;             	//	648  Spectrograph Slit Position Units
	float   SpecGrooves;                  	//	650  Spectrograph Grating Grooves
	SHORT   srccmp;                       	//	654  number of source comp. diodes
	WORD    ydim;                         	//	656  y dimension of raw data.
	SHORT   scramble;                     	//	658  0=scrambled,1=unscrambled
	SHORT   ContinuousCleansFlag;         	//	660  T/F Continuous Cleans Timing Option
	SHORT   ExternalTriggerFlag;          	//	662  T/F External Trigger Timing Option
	long    lnoscan;                      	//	664  Number of scans (Early WinX)
	long    lavgexp;                      	//	668  Number of Accumulations
	float   ReadoutTime;                  	//	672  Experiment readout time
	SHORT   TriggeredModeFlag;            	//	676  T/F Triggered Timing Option
	char    Spare_2[10];                  	//	678  
	char    sw_version[FILEVERMAX];       	//	688  Version of SW creating this file
	SHORT   type;                         	//	704   	1 = new120 (Type II)             
	                                        //	 		2 = old120 (Type I )           
	                                        //	 		3 = ST130                      
	                                        //	 		4 = ST121                      
	                                        //	 		5 = ST138                      
	                                        //	 		6 = DC131 (PentaMax)           
	                                        //	 		7 = ST133 (MicroMax/SpectroMax)
	                                        //	 		8 = ST135 (GPIB)               
	                                        //	 		9 = VICCD                      
	                                        //			10 = ST116 (GPIB)               
	                                        //			11 = OMA3 (GPIB)                
	                                        //			12 = OMA4                       
	SHORT   flatFieldApplied;            	//	706  1 if flat field was applied.
	char    Spare_3[16];                  	//	708  
	SHORT   kin_trig_mode;                	//	724  Kinetics Trigger Mode
	char    dlabel[LABELMAX];             	//	726  Data label.
	char    Spare_4[436];                 	//	742
	char    PulseFileName[HDRNAMEMAX];   	//	1178  Name of Pulser File with
	                                        //	 	  Pulse Widths/Delays (for Z-Slice)
	char    AbsorbFileName[HDRNAMEMAX];  	//	1298 Name of Absorbance File (if File Mode)

	DWORD   NumExpRepeats;               	//	1418  Number of Times experiment repeated
	DWORD   NumExpAccums;                	//	1422  Number of Time experiment accumulated
	SHORT   YT_Flag;                     	//	1426  Set to 1 if this file contains YT data
	float   clkspd_us;                   	//	1428  Vert Clock Speed in micro-sec
	SHORT   HWaccumFlag;                 	//	1432  set to 1 if accum done by Hardware.
	SHORT   StoreSync;                   	//	1434  set to 1 if store sync used
	SHORT   BlemishApplied;              	//	1436  set to 1 if blemish removal applied
	SHORT   CosmicApplied;               	//	1438  set to 1 if cosmic ray removal applied
	SHORT   CosmicType;                  	//	1440  if cosmic ray applied, this is type
	float   CosmicThreshold;             	//	1442  Threshold of cosmic ray removal.  
	long    NumFrames;                   	//	1446  number of frames in file.         
	float   MaxIntensity;               	//	1450  max intensity of data (future)    
	float   MinIntensity;               	//	1454  min intensity of data (future)    
	char    ylabel[LABELMAX];           	//	1458  y axis label.                     
	WORD    ShutterType;                 	//	1474  shutter type.                     
	float   shutterComp;                 	//	1476  shutter compensation time.        
	WORD    readoutMode;                 	//	1480  readout mode, full,kinetics, etc  
	WORD    WindowSize;                  	//	1482  window size for kinetics only.    
	WORD    clkspd;                      	//	1484  clock speed for kinetics & frame transfer
	WORD    interface_type;              	//	1486  computer interface                
	                                        //	 	  (isa-taxi, pci, eisa, etc.)             
	SHORT   NumROIsInExperiment;         	//	1488  May be more than the 10 allowed in
	                                        //	      this header (if 0, assume 1)            
	char    Spare_5[16];                 	//	1490                                    
	WORD    controllerNum;               	//	1506  if multiple controller system will
	                                        //	      have controller number data came from.  
	                                        //	      this is a future item.                  
	WORD    SWmade;                      	//	1508  Which software package created this file 
	SHORT   NumROI;                      	//	1510  number of ROIs used. if 0 assume 1.      
	                                  		//	1512 - 1630  ROI information      
//#ifdef STRUCT2TREE
//	ROIinfo ROIinfoblk[ROIMAX];
//#else // !STRUCT2TREE
	WORD	ROIinfoblk0startx;
	WORD	ROIinfoblk0endx;
	WORD	ROIinfoblk0groupx;
	WORD	ROIinfoblk0starty;
	WORD	ROIinfoblk0endy;
	WORD	ROIinfoblk0groupy;
	
	WORD	ROIinfoblk1startx;
	WORD	ROIinfoblk1endx;
	WORD	ROIinfoblk1groupx;
	WORD	ROIinfoblk1starty;
	WORD	ROIinfoblk1endy;
	WORD	ROIinfoblk1groupy;
	
	WORD	ROIinfoblk2startx;
	WORD	ROIinfoblk2endx;
	WORD	ROIinfoblk2groupx;
	WORD	ROIinfoblk2starty;
	WORD	ROIinfoblk2endy;
	WORD	ROIinfoblk2groupy;
	
	WORD	ROIinfoblk3startx;
	WORD	ROIinfoblk3endx;
	WORD	ROIinfoblk3groupx;
	WORD	ROIinfoblk3starty;
	WORD	ROIinfoblk3endy;
	WORD	ROIinfoblk3groupy;
	
	WORD	ROIinfoblk4startx;
	WORD	ROIinfoblk4endx;
	WORD	ROIinfoblk4groupx;
	WORD	ROIinfoblk4starty;
	WORD	ROIinfoblk4endy;
	WORD	ROIinfoblk4groupy;
	
	WORD	ROIinfoblk5startx;
	WORD	ROIinfoblk5endx;
	WORD	ROIinfoblk5groupx;
	WORD	ROIinfoblk5starty;
	WORD	ROIinfoblk5endy;
	WORD	ROIinfoblk5groupy;
	
	WORD	ROIinfoblk6startx;
	WORD	ROIinfoblk6endx;
	WORD	ROIinfoblk6groupx;
	WORD	ROIinfoblk6starty;
	WORD	ROIinfoblk6endy;
	WORD	ROIinfoblk6groupy;
	
	WORD	ROIinfoblk7startx;
	WORD	ROIinfoblk7endx;
	WORD	ROIinfoblk7groupx;
	WORD	ROIinfoblk7starty;
	WORD	ROIinfoblk7endy;
	WORD	ROIinfoblk7groupy;
	
	WORD	ROIinfoblk8startx;
	WORD	ROIinfoblk8endx;
	WORD	ROIinfoblk8groupx;
	WORD	ROIinfoblk8starty;
	WORD	ROIinfoblk8endy;
	WORD	ROIinfoblk8groupy;
	
	WORD	ROIinfoblk9startx;
	WORD	ROIinfoblk9endx;
	WORD	ROIinfoblk9groupx;
	WORD	ROIinfoblk9starty;
	WORD	ROIinfoblk9endy;
	WORD	ROIinfoblk9groupy;
//#endif // STRUCT2TREE
	char    FlatField[HDRNAMEMAX];       	//	1632  Flat field file name.       
	char    background[HDRNAMEMAX];      	//	1752  background sub. file name.  
	char    blemish[HDRNAMEMAX];         	//	1872  blemish file name.          
	float   file_header_ver;             	//	1992  version of this file header 
	char    YT_Info[1000];               	//	1996-2996  Reserved for YT information
	LONG    WinView_id;                  	//	2996  == 0x01234567L if file created by WinX
	//-------------------------------------------------------------------------------
	
	//                    START OF X CALIBRATION STRUCTURE
//#ifdef STRUCT2TREE
//	SPECalib calib_x;
		
	//                    START OF Y CALIBRATION STRUCTURE
//	SPECalib calib_y;
//#else // !STRUCT2TREE
	//                    START OF X CALIBRATION STRUCTURE
	double        calib_xoffset;                	//	offset for absolute data scaling
	double        calib_xfactor;                	//	factor for absolute data scaling
	char          calib_xcurrent_unit;          	//	selected scaling unit           
	char          calib_xreserved1;             	//	reserved                        
	char          calib_xstr[40];            		//	special string for scaling      
	char          calib_xreserved2[40];         	//	reserved                        
	char          calib_xcalib_valid;           	//	flag if calibration is valid    
	char          calib_xinput_unit;            	//	current input units for "calib_value"      
	char          calib_xpolynom_unit;          	//	linear UNIT and used in the "polynom_coeff"           
	char          calib_xpolynom_order;         	//	ORDER of calibration POLYNOM    
	char          calib_xcalib_count;           	//	valid calibration data pairs
	double        calib_xpixel_position0;  
	double        calib_xpixel_position1;  
	double        calib_xpixel_position2;  
	double        calib_xpixel_position3;  
	double        calib_xpixel_position4;  
	double        calib_xpixel_position5;  
	double        calib_xpixel_position6;  
	double        calib_xpixel_position7;  
	double        calib_xpixel_position8;  
	double        calib_xpixel_position9;  
	double        calib_xcalib_value0;  
	double        calib_xcalib_value1;  
	double        calib_xcalib_value2;  
	double        calib_xcalib_value3;  
	double        calib_xcalib_value4;  
	double        calib_xcalib_value5;  
	double        calib_xcalib_value6;  
	double        calib_xcalib_value7;  
	double        calib_xcalib_value8;  
	double        calib_xcalib_value9;  
	double        calib_xpolynom_coeff0;            
	double        calib_xpolynom_coeff1;            
	double        calib_xpolynom_coeff2;            
	double        calib_xpolynom_coeff3;            
	double        calib_xpolynom_coeff4;            
	double        calib_xpolynom_coeff5;            
	double        calib_xlaser_position;        	//	laser wavenumber for relativ WN 
	char          calib_xreserved3;             	//	reserved                        
	unsigned char calib_xnew_calib_flag;        	//	If set to 200, valid label below
	char          calib_xcalib_label[81];       	//	Calibration label (NULL term'd) 
	char          calib_xexpansion[87];         	//	Calibration Expansion area      
	
	/////////////////////////////////////////////////////////////////////////
	//                    START OF Y CALIBRATION STRUCTURE
	double        calib_yoffset;                	//	offset for absolute data scaling
	double        calib_yfactor;                	//	factor for absolute data scaling
	char          calib_ycurrent_unit;          	//	selected scaling unit           
	char          calib_yreserved1;             	//	reserved                        
	char          calib_ystr[40];            		//	special string for scaling      
	char          calib_yreserved2[40];         	//	reserved                        
	char          calib_ycalib_valid;           	//	flag if calibration is valid    
	char          calib_yinput_unit;            	//	current input units for "calib_value"      
	char          calib_ypolynom_unit;          	//	linear UNIT and used in the "polynom_coeff"           
	char          calib_ypolynom_order;         	//	ORDER of calibration POLYNOM    
	char          calib_ycalib_count;           	//	valid calibration data pairs
	double        calib_ypixel_position0;  
	double        calib_ypixel_position1;  
	double        calib_ypixel_position2;  
	double        calib_ypixel_position3;  
	double        calib_ypixel_position4;  
	double        calib_ypixel_position5;  
	double        calib_ypixel_position6;  
	double        calib_ypixel_position7;  
	double        calib_ypixel_position8;  
	double        calib_ypixel_position9;  
	double        calib_ycalib_value0;  
	double        calib_ycalib_value1;  
	double        calib_ycalib_value2;  
	double        calib_ycalib_value3;  
	double        calib_ycalib_value4;  
	double        calib_ycalib_value5;  
	double        calib_ycalib_value6;  
	double        calib_ycalib_value7;  
	double        calib_ycalib_value8;  
	double        calib_ycalib_value9;  
	double        calib_ypolynom_coeff0;            
	double        calib_ypolynom_coeff1;            
	double        calib_ypolynom_coeff2;            
	double        calib_ypolynom_coeff3;            
	double        calib_ypolynom_coeff4;            
	double        calib_ypolynom_coeff5;            
	double        calib_ylaser_position;        	//	laser wavenumber for relativ WN 
	char          calib_yreserved3;             	//	reserved                        
	unsigned char calib_ynew_calib_flag;        	//	If set to 200, valid label below
	char          calib_ycalib_label[81];       	//	Calibration label (NULL term'd) 
	char          calib_yexpansion[87];         	//	Calibration Expansion area      
//#endif // STRUCT2TREE
	//                     END OF CALIBRATION STRUCTURES
	
	//---------------------------------------------------------------------
	
	char    Istring[40];                 	//	3978  special intensity scaling string
	char    Spare_6[76];                 	//	4018
	SHORT   AvGainUsed;                  	//	4094  avalanche gain was used
	SHORT   AvGain;                      	//	4096  avalanche gain value
	SHORT   lastvalue;                   	//	4098  Always the LAST value in the header
	                    /* 4100 Start of Data */
	} SPEHEADER; 	

#pragma pack(pop)

/******************************************************************************
 *	
 *	                      READING STRIPS AND FRAMES OF DATA
 *	                     -----------------------------------
 *	
 *	    The data follows the header beginning at offset 4100.
 *	
 *	    Data is still stored as sequential points.  The X, Y and Frame dimensions
 *	    are determined by the header.
 *	    The X dimension of the stored data is in "xdim" ( Offset 42  ).
 *	    The Y dimension of the stored data is in "ydim" ( Offset 656 ).
 *	    The number of frames of data stored is in "NumFrames" ( Offset 1446 ).
 *	
 *	    Thus (modifying the example above):
 *	
 *	        char header[4100];
 *	        unsigned int X_dimension;
 *	        unsigned int Y_dimension;
 * 	        long         Num_frames;
 *	
 *	    Now there is Direct Access of data dimensions
 *
 *	        X_dimension = (unsigned int)header[42];
 *	        Y_dimension = (unsigned int)header[664];
 *	        Num_frames  = (long)header[1446];
 *
 ******************************************************************************/

 
#define SPE_ERR_NONE						0
#define SPE_ERR_FILE_OPEN					1
#define SPE_ERR_READ_HEADER					2
#define SPE_ERR_READ_DATA					3
#define SPE_ERR_DATA_TYPE					4
#define SPE_ERR_CREATE_TEMP_MATRIX			5
#define SPE_ERR_CREATE_TEMP_MATRIX_PAGE		6
#define SPE_ERR_CREATE_WKS_PAGE				7
#define SPE_ERR_CREATE_WKS					8
#define SPE_ERR_CREATE_MATRIX_PAGE			9
#define SPE_ERR_CREATE_MATRIX				10
#define SPE_ERR_CREATE_NOTE_PAGE			11
#define SPE_ERR_YDIM						12
#define SPE_ERR_FRAME_NUMBER				13
#define SPE_ERR_FILTER_TYPE					14
#define SPE_ERR_TREE2STR					15
#define SPE_ERR_SEEK_DATA					16