/*------------------------------------------------------------------------------*
 * File Name:Presentation Manager												*
 * Creation: CPY Feb 21 2004													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp., 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Danice 9/13/04 v8.0132 MOVE_UTILITY_FUNCTION_TO_TREE_UTILS					*
 * SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 * Jasmine 10/28/05 v8.0324 SPLITTER_INIT_SIZE_ON_READY							*
 * Jasmine 03/16/06 v8.0375 FORCE_TO_CALL_RESIZE								*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///	#include <Dialog.h>
#include "DialogEx.h"     // Dialog class
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H

#include <analysis_utils.h>

#include "GridControl.h"
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///	#include "ResizeDialog.h"
///	#include "HelpID.h"
///	#include "Odlg8.h"
///	#include "MultiPaneDlg.h"
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
#include "SplitterControl.h"
#include "PESplitter.h"
#include "PMSplitter.h"
#define STR_DLG_NAME "PrentationManager"


// a dialog to manage Presentations (Slide Shows) from Origin
// The presentations created are stored into the current OPJ in a single tree
// 
class PresentationManagerDlg : public MultiPaneDlg
{	
public:
	PresentationManagerDlg() : MultiPaneDlg(IDD_PRESENTATION_MANAGER, "ODlg8")
	{
	}	
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();// will be called from internal later
		
		DWORD dwDlgOptions = 0;
		//--- CPY 7/8/03 QA70-4796 v7.0620 GET_N_BOX_EVENT_FUNC_MOVE_WIN
		//if(hWndParent)
		//	dwDlgOptions |= DLG_NO_DEFAULT_REPOSITION;
		//---
		
		int nRet = DoModal(hWndParent, dwDlgOptions);
		if(nRet != IDCANCEL)
		{
			//m_input_tr.Replace(THE_TREE_NODE);
			//saveDefaultGUI();
		}
		return nRet;
	}
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)	///Jasmine 10/28/05 v8.0324 SPLITTER_INIT_SIZE_ON_READY
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	ON_BN_CLICKED(IDC_PM_SHOW_PE, OnShowPE)
EVENTS_END

//------------ Event Handlers ------------------------
	BOOL OnInitDialog()
	{
		waitCursor junk;
		//Profiler jj;
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.SetSize(2);
		vstrTipsUpDown[0] = _L("Show Preview");
		vstrTipsUpDown[1] = _L("Hide Preview");
		MultiPaneDlg::OnInitDialog(IDC_PM_PRESENTATIONS, IDC_PM_SHOW_PE, IDC_PM_PE_PAGES, vstrTipsUpDown, "PresentationManagerDlg");
		
		m_PM.Init(IDC_PM_PRESENTATIONS, *this, STR_DLG_NAME);
		m_PE.Init(IDC_PM_PE_PAGES, *this, STR_DLG_NAME, false);/// make invisible until open bottom pane
	///Jasmine 10/28/05 v8.0324 SPLITTER_INIT_SIZE_ON_READY	
		//UpdateDlgShow();
		//SetInitReady();
		//UpdateDlgSize();
		return true;
	}
	BOOL OnReady()
	{		
		m_PM.OnReady();
		m_PE.OnReady();		
		
		UpdateDlgShow();
		UpdateDlgSize();
		SetInitReady();
		return true;
	}
	///End SPLITTER_INIT_SIZE_ON_READY
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
			
		uint nButtonIDs[] = {IDOK, IDC_PM_NEW, IDC_PM_ADD, IDC_PM_REMOVE, 0};
		MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy);
		///Jasmine 03/16/06 FORCE_TO_CALL_RESIZE
		m_PM.OnDlgResize(nType, cx, cy);
		m_PE.OnDlgResize(nType, cx, cy);
		///End FORCE_TO_CALL_RESIZE
		return TRUE;
	}
	
	//----- CPY 10/11/03 QA70-5332 HELP_CUSTOMIZED
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		/*
		PEVENT_FUNC pfn = getEventHandler();
		if(pfn)
		{
			pfn(THE_TREE_NODE, -2, -1, *this); //CPY 5/30/03 QA70-4577 EVENT_HANDLER_NEED_DIALOG_AND_VALUE_UPDATE, added *this
		}
		*/
		return FALSE; // do no call default help
	}
	//----- end QA70-5332
	BOOL OnShowPE(Control cntrl)
	{
		MultiPaneDlg::OnShowBottomPane(cntrl);
		return TRUE;
	}
	
	//////////// local utilities/helper functions
private:
	PMSplitter	m_PM;
	PESplitter	m_PE;

};

bool PMopen()
{
	PresentationManagerDlg myDlg;
	
	int nRet = myDlg.DoModalEx(GetWindow());
	return false;
}


/// TD 3-23-04 QA70-6053 PICTURE_IN_OC

///Danice MOVE_UTILITY_FUNCTION_TO_TREE_UTILS
/*
//TD 3-30-04 MOVED FROM TREE_UTILS.h
///Danice 2/25/04 QA70-6032 PRESENTATION_MANAGER_NEED
#define ID_FOLDER 10 // later will need icon id
static int _get_page_ID(Page& pg)
{
	return 12; // later, will get actual icon id to use as page id based on page type
}
static bool _add_folder_pages(TreeNode& tr, Folder& fldParent, DWORD dwPageTypeFilter)
{
	int	iNode = 0;
	int iFolder = 1;
	string str;
	foreach(Folder fld in fldParent.Subfolders)
	{
		str = "Folder" + iFolder++;
		TreeNode	tn = tr.AddNode(str, ID_FOLDER);
		iNode++;
		tn.SetAttribute(STR_LABEL_ATTRIB, fld.GetName());
		tn.SetAttribute(STR_PATH_ATTRIB, fld.GetPath());
		tn.SetAttribute(STR_DISPLAY_ATTRIB, IDI_FOLDER_CLOSED);/// TD 3-23-04 QA70-6053 PICTURE_IN_OC
		
		_add_folder_pages(tn, fld, dwPageTypeFilter);
		
		int	iPage = 1;
		foreach(PageBase pg in fld.Pages)
		{
			//check filter later
			//if(pg.GetType() != nPageTypeToExclude)
			
			str = "Page" + iPage++;
			TreeNode tnp = tn.AddNode(str, _get_page_ID(pg));
			iNode++;
			tnp.SetAttribute(STR_NAME_ATTRIB, pg.GetName());// LT name, short name, tagName for pages
			tnp.SetAttribute(STR_LABEL_ATTRIB, pg.Label);
		}
	}
	return 0 == iNode ? false : true;
}

bool tree_get_project_folders_and_pages(TreeNode &tr, DWORD dwPageTypeFilter)// = 0)
{
	PageBase	pg;
		
	Folder	rtFolder = Project.RootFolder;

	tr.project.ID = 0;// we may need a diff ID for project root later.
	tr.project.SetAttribute(STR_LABEL_ATTRIB, rtFolder.GetName());
	
	return _add_folder_pages(tr.project, rtFolder, dwPageTypeFilter);
}
*/
///end MOVE_UTILITY_FUNCTION_TO_TREE_UTILS
///END PRESENTATION_MANAGER_NEED
/// end PICTURE_IN_OC
