/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: 																	*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW				*
 *	Sim 07-21-2009 QA81-4184 SUPPORT_POSIT_GRAPH_ON_SLIDE						*
 *	Sim 07-22-2009 QA81-4184 MORE_CHANGE_EXPORT_PPT								*
 *	Sim 08-28-2009 FIX_RUNTIME_ERROR_WHEN_PAGE_NAME_STARTS_WITH_NUMBER			*
 *	Kyle 03/16/2010 QA80-15208 SLIDESHOW_AND_PPTSLIDE_SUPPORT_EMBEDDED_GRAPHS	*
 *	Sophy 5/31/2011 ORG-2973-P1 SEND_GRAPHS_TO_PPT_SHOULD_NOT_APPLY_ANY_TRANSITION_EFFECT
 *	Sophy 7/11/2012 ORG-6188-S1 IMPROVE_ERROR_REPORT_WHEN_PASTESPECIAL_TO_PPT_FAIL
 *	Tony 08/27/2012 ORG-6644-S1 ADD_OPTION_TO_SHOW_PATH_BEFORE_OR_AFTER_EACH_EXPORTED_PPT	*
 *	Tony 08/30/2012 ORG-6644-S1 DIFFERENT_PAGES_ACTIVE_CORRESPONDING_PAGE_TO_ARG_COPY	*
 *	Tony 08/31/2012 ORG-6644-P2 SET_CUSTOM_STRING_WHEN_IS_EMPTY				*
 *	Tony 09/04/2012 ORG-6644-S2 ADD_PPT_TITLE_AFTER_ADD_GRAPH					*
 *------------------------------------------------------------------------------*/
#ifndef _POWERPOINT_EXPORT_H
#define _POWERPOINT_EXPORT_H

#define PPT_COM_OBJ_NAME   		"powerpoint.application"
#define POWERPOINT_ROOT_NODE 		"PPT_NAME"
#define NODE_SETTING				"SlideSetting"
#define PAGE_TYPE					"PageType"
#define PAGE_INFO					"PageInfo"

///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
enum
{
	POS_NONE = 0,
	POS_TOP,
	POS_BOTTOM,
};
///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
///---Sim 07-22-2009 QA81-4184 MORE_CHANGE_EXPORT_PPT
enum
{
	DATA_TYPE_PICTURE = 0,
	DATA_TYPE_EMBEDED_GRAPH,
	DATA_TYPE_LINK,
};
///---END QA81-4184 MORE_CHANGE_EXPORT_PPT

struct PPSlideTransitionInfo
{
	bool bOnClick;		//Transition the slide on click
	bool bOnTime;		//Transition the slide on time
	int nSlideStayTime;	//Transition the slide stay time
	int	nSlideTransition;//Transition the slide Speed
	int nEntryEffectpp ;//Transition the slide entry effect
	int nBackground;	//Background of the slide
	int nSlidTemplaet;	//Slid Templaet
	int nGradientType;	//Gradient type of background 1= one color, 2 =two color+
	string strSlideTitle;	//save the page name in it
	int nPosSlideTitle; ///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
	///---Sim 07-21-2009 QA81-4184 SUPPORT_POSIT_GRAPH_ON_SLIDE
	///---Sim 07-22-2009 QA81-4184 MORE_CHANGE_EXPORT_PPT
	//double dTop;
	//double dLeft;
	//double dRatio;
	double dMarginTop;
	double dMarginLeft;
	double dMarginBottom;
	double dMarginRight;
	///---END QA81-4184 MORE_CHANGE_EXPORT_PPT
	///---END QA81-4184 SUPPORT_POSIT_GRAPH_ON_SLIDE
	///---Sim 07-22-2009 QA81-4184 MORE_CHANGE_EXPORT_PPT
	int nDataType;
	///---END QA81-4184 MORE_CHANGE_EXPORT_PPT
};

enum  
{
	ppViewSlide = 1,
	ppViewSlideMaster = 2,
	ppViewNotesPage = 3,
	ppViewHandoutMaster = 4,
	ppViewNotesMaster = 5,
	ppViewOutline = 6,
	ppViewSlideSorter = 7,
	ppViewTitleMaster = 8,
	ppViewNormal = 9,
	ppViewPrintPreview = 10,
	ppViewThumbnails = 11,
	ppViewMasterThumbnails = 12,
	
};

enum //nEntryEffectpp
{
	ppEffectAppear = 3844,
	ppEffectBlindsHorizontal = 769,
	ppEffectBlindsVertical = 770,
	ppEffectBoxIn = 3074,
	ppEffectBoxOut = 3073,
	ppEffectCheckerboardAcross = 1025,
	ppEffectCircleOut = 3845,
	ppEffectCombHorizontal = 3847,
	ppEffectCoverLeft = 1281,
	ppEffectCoverUp = 1282,
	ppEffectCut = 257,
	ppEffectDissolve = 1537,
	///Sophy 5/31/2011 ORG-2973-P1 SEND_GRAPHS_TO_PPT_SHOULD_NOT_APPLY_ANY_TRANSITION_EFFECT
	ppEffectNone = 0,
	ppEffectZoomIn = 3345,
	ppEffectZoomInSlightly = 3346,
	ppEffectZoomOut = 3347,
	ppEffectZoomOutSlightly = 3348,
	ppEffectZoomCenter = 3349,
	ppEffectZoomBottom = 3350,
	ppEffectStretchAcross = 3351,
	ppEffectStretchLeft = 3352,
	ppEffectStretchUp = 3353,
	ppEffectStretchRight = 3354,
	ppEffectStretchDown = 3355,
	ppEffectSwivel = 3356,
	ppEffectSpiral = 3357,
	ppEffectSplitHorizontalOut = 3585,
	ppEffectSplitHorizontalIn = 3586,
	ppEffectSplitVerticalOut = 3587,
	ppEffectSplitVerticalIn = 3588,
	ppEffectFlashOnceFast = 3841,
	ppEffectFlashOnceMedium = 3842,
	ppEffectFlashOnceSlow = 3843,
	ppEffectPlusOut = 3851,
	ppEffectPushDown = 3852,
	ppEffectPushLeft = 3853,
	ppEffectPushRight = 3854,
	ppEffectPushUp = 3855,
	///end SEND_GRAPHS_TO_PPT_SHOULD_NOT_APPLY_ANY_TRANSITION_EFFECT
};
enum  //nSlideTransition
{
	ppTransitionSpeedFast = 3,
	ppTransitionSpeedMedium = 2,
	ppTransitionSpeedMixed = -2,
	ppTransitionSpeedSlow = 1,
};
enum	//nSlidTemplaet
{
	ppLayoutBlank = 12,
	ppLayoutClipartAndText = 10,
	ppLayoutClipArtAndVerticalText = 26,
	ppLayoutFourObjects = 24,
	ppLayoutLargeObject = 15,
	ppLayoutMediaClipAndText = 18,
	ppLayoutMixed = -2,
	ppLayoutObject = 16,
	ppLayoutObjectAndText = 14,
	ppLayoutObjectAndTwoObjects = 30,
};
enum //uShowMode  , exported powerpoint file save mode
{
	ppSaveAsPowerPoint7 = 2,
	ppSaveAsPresForReview = 22,	//Save as Slide review mode
	ppSaveAsPresentation = 1,	//Save as normal mode
	ppSaveAsShow = 7,			//Save as Slide Show mode
};
enum //Create powerpoint Window State
{
	ppWindowNormal = 1,
	ppWindowMinimized = 2,
	ppWindowMaximized = 3,
};
enum	//PpSlideShowType
{
	ppShowTypeSpeaker = 1,
	ppShowTypeWindow,
	ppShowTypeKiosk,
};
enum		//PpSlideShowAdvanceMode
{
	ppSlideShowManualAdvance ,
	ppSlideShowUseSlideTimings,
	ppSlideShowRehearseNewTimings,
};
///---Sim 07-22-2009 QA81-4184 MORE_CHANGE_EXPORT_PPT
enum		//PpPasteDataType
{
	ppPasteMetafilePicture = 3,
	ppPasteOLEObject = 10,
};

enum		//MsoTriState
{
	msoFalse = 0,
	msoTrue = -1,
};
///---END QA81-4184 MORE_CHANGE_EXPORT_PPT

///------ Tony 08/27/2012 ORG-6644-S1 ADD_OPTION_TO_SHOW_PATH_BEFORE_OR_AFTER_EACH_EXPORTED_PPT
void ppt_export_on_title(TreeNode & trGetN)
{
	if(trGetN.title.nVal == title_none)
	{
		trGetN.mode.Show = false;
		trGetN.custom.Show = false;
	}
	else
	{
		trGetN.mode.Show = true;
		trGetN.custom.Show = true;
		if(trGetN.mode.nVal == mode_custom)
			trGetN.custom.Enable = true;
		else
			trGetN.custom.Enable = false;
	}

}
///------ Tony 08/31/2012 ORG-6644-P2 SET_CUSTOM_STRING_WHEN_IS_EMPTY
//void ppt_export_on_mode(TreeNode & trGetN)
//{
	//switch(trGetN.mode.nVal)
	//{
	//case mode_custom:
		//trGetN.custom.Enable = true;
		//trGetN.custom.strVal = "";
		//break;
		//
	//case mode_sname:
		//trGetN.custom.Enable = false;
		//trGetN.custom.strVal = "%H";
		//break;
		//
	//case mode_lname:
		//trGetN.custom.Enable = false;
		//trGetN.custom.strVal = "%(%H, @PL)";
		//break;
		//
	//case mode_slname:
		//trGetN.custom.Enable = false;
		//trGetN.custom.strVal = "%H - %(%H, @PL)";
		//break;
	//case mode_path:
		//trGetN.custom.Enable = false;
		//trGetN.custom.strVal = "%(%H, @P)";
		//break;
	//}
//}
void ppt_export_on_mode(TreeNode & trGetN)
{
	if(trGetN.mode.nVal == mode_custom)
		trGetN.custom.Enable = true;
	else
		trGetN.custom.Enable = false;
	string strCustom = trGetN.custom.strVal;
	ppt_export_set_Slide_Title(trGetN.mode.nVal,strCustom);
	trGetN.custom.strVal = strCustom;
}
///------ End ADD_OPTION_TO_SHOW_PATH_BEFORE_OR_AFTER_EACH_EXPORTED_PPT
void ppt_export_set_Slide_Title(int nMode, string &strCustom)
{
	switch(nMode)
	{
	case mode_custom:
		//strCustom = "";		///------ Tony 08/31/2012 ORG-6644-P1 THEME_EVENT_ALSO_CALL_FUNCTION_PPT_EXPORT_ONCustom 
		break;
		
	case mode_sname:
		strCustom = "%H";
		break;
		
	case mode_lname:
		strCustom = "%(%H, @PL)";
		break;
		
	case mode_slname:
		strCustom = "%H - %(%H, @PL)";
		break;
	case mode_path:
		strCustom = "%(%H, @P)";
		break;
	}
}
///------ End SET_CUSTOM_STRING_WHEN_IS_EMPTY
///------ Tony 08/30/2012 ORG-6644-S1 DIFFERENT_PAGES_ACTIVE_CORRESPONDING_PAGE_TO_ARG_COPY
string ppt_export_get_Slide_Title(string custom, Page &pg)
{
	Layer ly =pg.Layers();
	string strLayerRange;
	ly.GetRangeString(strLayerRange);
	okutil_arg_copy(&custom, strLayerRange);
	return custom;
}
///------ End DIFFERENT_PAGES_ACTIVE_CORRESPONDING_PAGE_TO_ARG_COPY

class PowerPointExport
{	
public:
	/**
		Constructs a PowerPoint class.  
	**/
	PowerPointExport()
	{
		m_bHasOpenPPT = false;
		m_oppt = NULL;
	}

	///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
	~PowerPointExport()
	{
		///---Sim 07-22-2009 QA81-4184 MORE_CHANGE_EXPORT_PPT
		//ClosePowerPoint();
		///---END QA81-4184 MORE_CHANGE_EXPORT_PPT
	}
	///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW

	/**
		Remarks:
			This method Add the page info of the page in to tree, add Page type and other setting info into 

			and store to export to powerpoint file.
		Example:
			PPSlideTransitionInfo stuExportInfo;
			stuExportInfo.nSlideTransition=ppTransitionSpeedFast;
			stuExportInfo.bOnClick = true;
			stuExportInfo.bOnTime = true;
			stuExportInfo.nSlideStayTime = 2;
			stuExportInfo.nEntryEffectpp = ppEffectBlindsHorizontal;
			stuExportInfo.nGradientType = 2;
			stuExportInfo.strSlideTitle = "Slide Title";
			bool bRet = AddPageInfo("graph1",3,stuExportInfo);
		Parameters:
			lpcszPageName = page name;
			nPageType = page type you select to add;
			slideinfo = the slide transition infomation , real-only;
		Return:
			Returns TRUE on success
		
	**/
	///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
	//bool AddPageInfo(LPCSTR lpcszPageName, int nPageType,const PPSlideTransitionInfo slideinfo)
	bool AddPageInfo(LPCSTR lpcszPageName, const PPSlideTransitionInfo slideinfo)
	///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
	{	
		if(!lpcszPageName)	
		{
			return false;
		}
		///---Sim 08-28-2009 FIX_RUNTIME_ERROR_WHEN_PAGE_NAME_STARTS_WITH_NUMBER
		//TreeNode trNodePage= m_trPageInfo.AddNode(lpcszPageName);
		string strPageName(lpcszPageName);
		strPageName.MakeValidCName();
		TreeNode trNodePage= m_trPageInfo.AddNode(strPageName);
		///---END FIX_RUNTIME_ERROR_WHEN_PAGE_NAME_STARTS_WITH_NUMBER
		if(!trNodePage)	
		{
			return false;
		}		
		
		///---Sim 08-28-2009 FIX_RUNTIME_ERROR_WHEN_PAGE_NAME_STARTS_WITH_NUMBER
		trNodePage.SetAttribute(STR_LABEL_ATTRIB, lpcszPageName);
		///---END FIX_RUNTIME_ERROR_WHEN_PAGE_NAME_STARTS_WITH_NUMBER
		
		///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
		//trNodePage.AddNode(PAGE_TYPE).nVal = nPageType;
		///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
		
		TreeNode trNodeSetting = trNodePage.AddNode(NODE_SETTING);
		trNodeSetting = slideinfo;
		
		return true;
	}
	/**
		Remarks:
			This method Update the page info of the page in to tree, update Page type and other setting info into 

			and store to export to powerpoint file.
		Example:
			PPSlideTransitionInfo stuExportInfo;
			stuExportInfo.nSlideTransition=ppTransitionSpeedFast;
			stuExportInfo.bOnClick = true;
			stuExportInfo.bOnTime = true;
			stuExportInfo.nSlideStayTime = 2;
			stuExportInfo.nEntryEffectpp = ppEffectBlindsHorizontal;
			stuExportInfo.nGradientType = 2;
			stuExportInfo.strSlideTitle = "Slide Title";
			bool bRet = UpdatePageInfo("graph1",3,stuExportInfo);
		Parameters:
			lpcszPageName = page name;
			nPageType = page type you select to add;
			slideinfo = the slide transition infomation , real-only;
		Return:
			Returns TRUE on success
		
	**/	
	///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
	//bool UpdatePageInfo(LPCSTR lpcszPageName, int nPageType, const PPSlideTransitionInfo slideinfo)
	bool UpdatePageInfo(LPCSTR lpcszPageName, const PPSlideTransitionInfo slideinfo)
	///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
	{
		TreeNode trNodePage;
		TreeNode trNodeSetting;
		///---Sim 08-28-2009 FIX_RUNTIME_ERROR_WHEN_PAGE_NAME_STARTS_WITH_NUMBER
		//trNodePage = m_trPageInfo.GetNode(lpcszPageName);
		trNodePage = m_trPageInfo.FindNodeByAttribute(STR_LABEL_ATTRIB, lpcszPageName);
		///---END FIX_RUNTIME_ERROR_WHEN_PAGE_NAME_STARTS_WITH_NUMBER
		if(!trNodePage)
		{
			return false;
		}
		
		///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
		//if(nPageType != trNodePage.GetNode(PAGE_TYPE).nVal)
			//trNodePage.GetNode(PAGE_TYPE).nVal = nPageType; 
		///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
		
		trNodeSetting = trNodePage.GetNode(NODE_SETTING);
		trNodeSetting = slideinfo;
		
		return true;
		
	}
	/**
		Remarks:
			This method Get all select page setting of export to powerpoint file info from class menber m_trPageInfo,
		Example:
			PowerPointExport ppt;
			TreeNode trNode;
			bool ppt.GetTree(trNode);
			out_tree(trNode);
		Parameters:
			trPresentation = A treenode to store the setting;
		Return:
			Returns TRUE on success
		
	**/	
	bool GetTree(TreeNode& trPresentation)
	{
		if(!m_trPageInfo)
		{
			return false;
		}
		trPresentation = m_trPageInfo;
		return true;
	}
	/**
		Remarks:
			This method Set all select page setting of export to powerpoint file info to class menber m_trPageInfo,
		Example:
			PowerPointExport ppt;
			TreeNode trNode;
			bool ppt.SetTree(trNode);
		Parameters:
			trPresentation = A treenode stored the setting;
		Return:
			Returns TRUE on success
		
	**/	
	
	bool SetTree(TreeNode& trPresentation)
	{
		if(!trPresentation)
		{
			return false;
		}
		m_trPageInfo = trPresentation;
		return true;
	}
	///---Sim 07-22-2009 QA81-4184 MORE_CHANGE_EXPORT_PPT
	/**
		Remarks:
			This method export all select page to powerpoint.
		Example:
			int nRet = ExportPowerPoint();
			switch(nRet)
			{
			case(-1):
				out_str("Powerpoint application not valid");
				break;
			case(-2):
				out_str("Export fail!");
				break;
			default:
				break;
			}
		
		Parameters:
		Return:
			Returns 0 on success
	**/	
	int ExportPowerPoint()
	{
		if(!IsValid())
		{
			return -1;
		}
		if(!Export())
		{
			return -2;
		}
		return 0;	
	}
	///---END QA81-4184 MORE_CHANGE_EXPORT_PPT
	/**
		Remarks:
			This method export all select page to powerpoint file.
		Example:
			LPCSTR lpcszPPFilename = "c:\Powerpointfile.ppt"
			int nRet = ExportPowerPointFile(lpcszPPFilename);
			switch(nRet)
			{
			case(-1):
				out_str("Powerpoint application not valid");
				break;
			case(-2):
				out_str("Export fail!");
				break;
			case(-3):
				out_str("Save the powerpoint file fail!");
				break;
			default:
				break;
			}
		
		Parameters:
			lpcszPPFilename = File path to save the powerpoint file;
		Return:
			Returns 0 on success
		
	**/	
	int ExportPowerPointFile( LPCSTR lpcszPPFilename )
	{
		///---Sim 07-22-2009 QA81-4184 MORE_CHANGE_EXPORT_PPT
		//if(!IsValid())
		//{
			//return -1;
		//}
		//if(!Export())
		//{
			//return -2;
		//}
		int nRet = ExportPowerPoint();
		if ( 0 != nRet )
			return nRet;
		///---END QA81-4184 MORE_CHANGE_EXPORT_PPT
		
		if(!SavePPFile(lpcszPPFilename))
		{
			//the path is an empty path, can't save
			return  -3;
		}
		
		return 0;	
	}
	/**
		Remarks:
			This method preview the powrpoint file.
		Example:
		Parameters:
			nShowType = preview show;
		Return:
			Returns true on success
		
	**/	
	bool PreviewShow(int nShowType)
	{	
		if(!previewPresentation(nShowType))
		{
			//preview the presentation fail.
			return false;
		}

		return true; //return 0 if the function run the preview powerpoint file
	}
	/**
		Remarks:
			This method open powerpoint application.
		Example:
		Parameters:
		Return:
			Returns true on success
		
	**/	
	bool OpenPowerPoint()
	{
	//Open PowerPoint Application
		if(!openPowerPointApp())
		{
			return false;
		}
		if(!createNewPresentation())
		{
			//can't create a new presentation
			return false;
		}
		return true;
		
	}
	///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
	/**
		Remarks:
			This method close powerpoint application.
		Example:
		Parameters:
		Return:
			Returns true on success
		
	**/	
	bool ClosePowerPoint()
	{
		if ( !closePowerPointApp() )
		{
			return false;
		}
		return true;
	}
	///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
	/**
		Remarks:
			This method apply a template of the path point to.
		Example:
			string = c:\\hello.pot
		Parameters:
		Return:
			Returns true on success
		
	**/		
	bool ApplyTemplate(string TemplatePath )
	{
		if(!applyPresentationTemplate(TemplatePath))
		{
			return false;
		}
		return true;
	}
	
	bool IsValid()
	{
		return	isValid();
	}

protected :
	bool Export()
	{	
		if(!exportPagesToPP(m_trPageInfo))
		{
			//Can't export select page to powerpoint file with the page info
			return false;
		}
		return true;
	}

	bool SavePPFile(LPCSTR lpcszPPFilename)
	{
		UINT uShowMode;
		string strPath(lpcszPPFilename);
		if(strPath.IsEmpty())
		{
			//the path is an empty path, then save the file to user folder with name of "OriginPPFile.PPT"
			char	chPathUserFolder[200];
			LT_get_str("%Y", chPathUserFolder, 200);
			strPath = chPathUserFolder + "OriginPPFile.ppt";
			int i = 0;
			string strTemp = strPath;
			int nIndex = strPath.ReverseFind('.');
			strTemp.Delete(nIndex,4);
			while(strPath.IsFile())
			{
				strPath = strTemp + i +".ppt";
				i++;
			}
		}
		uShowMode = getSaveMode(strPath);
		if(!saveAsPresentation(strPath, uShowMode))
		{
			//can't save the PowerPoint file
			return false;
		}
		return true;		

	}

private:
	
	UINT getSaveMode(const string& strPath )
	{
		UINT uShowMode = 1;
		// Compare the strPath to get the save type
		string strSaveType;
		char* pstr = strSaveType.GetBufferSetLength(3);
		int nIndex = strPath.ReverseFind('.');
		char chSaveType(3);
		pstr[0] = strPath.GetAt(nIndex+1);
		pstr[1] = strPath.GetAt(nIndex+2);
		pstr[2] = strPath.GetAt(nIndex+3);
		if(strSaveType.Compare("pps")==0)
		{//if the postfix is 's ' than save as pps file
 			uShowMode = ppSaveAsShow;
		}
		else
			if(strSaveType.Compare("ppt")==0)
			{
				//Default save as ppt file
				uShowMode = ppSaveAsPresentation;
			}
			else
			{
				uShowMode = ppSaveAsPresentation;
			}
		
		return uShowMode;
	}
	bool exportPagesToPP(Tree& tr)
	{
		if( !isValid() )
		return false;
	
		if(!tr)
		{
			return false;
		}
		foreach( TreeNode trNode in tr.Children )
		{
			if(!exportPageToSlideWithTreeNode(trNode))
				{
					return false;
				}

		}
		return true;
	}
	
	bool exportPageToSlideWithTreeNode(const TreeNode & trNode,UINT nSlidTemplaet = ppLayoutBlank)
	{

		///---Sim 08-28-2009 FIX_RUNTIME_ERROR_WHEN_PAGE_NAME_STARTS_WITH_NUMBER
		//string PageName = trNode.tagName;
		string PageName;
		trNode.GetAttribute(STR_LABEL_ATTRIB, PageName);
		///---END FIX_RUNTIME_ERROR_WHEN_PAGE_NAME_STARTS_WITH_NUMBER
		///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
		//int PageType = trNode.GetNode(PAGE_TYPE).nVal;
		///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
		PPSlideTransitionInfo Import;
		Import = trNode.GetNode(NODE_SETTING);
		PageBase pb( PageName );
		
		///Kyle 03/16/2010 QA80-15208 SLIDESHOW_AND_PPTSLIDE_SUPPORT_EMBEDDED_GRAPHS
		Datasheet parentSheet;
		if(pb.GetEmbeddingInfo(parentSheet))		// not support to insert embedded graph as embedded object in PowerPoint
			Import.nDataType = DATA_TYPE_PICTURE;
		///End SLIDESHOW_AND_PPTSLIDE_SUPPORT_EMBEDDED_GRAPHS

		if(copyPageToClipboard(pb))
		{		
			Object oSlide = createNewSlide(Import, nSlidTemplaet);
			if(oSlide == NULL )
			{
				return false;
			}
			///---Sim 07-21-2009 QA81-4184 SUPPORT_POSIT_GRAPH_ON_SLIDE
			//pasteGraphToSlide(oSlide);
			pasteGraphToSlide(oSlide, Import);
			///---END QA81-4184 SUPPORT_POSIT_GRAPH_ON_SLIDE
			showTitle(oSlide, Import.strSlideTitle, Import.nPosSlideTitle);		///------ Tony 09/04/2012 ORG-6644-S2 ADD_PPT_TITLE_AFTER_ADD_GRAPH	
		}
		else
		{
			return false;
		}
		return true;
	}
	
 	Object createNewSlide(PPSlideTransitionInfo& Import,UINT nSlideLayoutType = ppLayoutBlank)
	{
		Object oSlide;
		oSlide = m_opptPresent.Slides.Add(m_opptPresent.Slides.Count+1,nSlideLayoutType);// index; 12: the slide has a blank layout

		if(!oSlide)
		{
			return NULL;
		}
		slideSetting(oSlide , Import );
		///------ Tony 09/04/2012 ORG-6644-S2 ADD_PPT_TITLE_AFTER_ADD_GRAPH
		/////---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
		////showTitle(oSlide,Import.strSlideTitle);
		//showTitle(oSlide, Import.strSlideTitle, Import.nPosSlideTitle);
		/////---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
		///------ End ADD_PPT_TITLE_AFTER_ADD_GRAPH
		return oSlide;
	}
	
	//Show the page name as title in the top center of the slide
	///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
	//bool showTitle(Object& oSlide, string pageName)
	bool showTitle(Object& oSlide, string pageName, int nPos)
	///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
	{
		if ( POS_NONE == nPos )
			return true;
		
		Object TextBox;
		try
		{
			///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
			//TextBox = oSlide.Shapes.AddTextbox(1,300,0,120,10);
			//I don't know how to detect text length and auto fit width, so I have to hard code set width
			int nTop = (POS_TOP == nPos)? 0 : 490;
			TextBox = oSlide.Shapes.AddTextbox(1,200,nTop,300,10);
			//TextBox.TextFrame.AutoSize = 1; // ppAutoSizeShapeToFitText
			///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
			TextBox.TextFrame.TextRange.Text = pageName;
		}
		catch(int nErr)
		{
			return false;
		}
		return true;
	}

	bool slideSetting(Object& oSlide, const PPSlideTransitionInfo& Import )
	{
		bool bRet ;
		int nBackground = Import.nBackground;
		int GradientType = Import.nGradientType;
		if(!slideShowTransition( oSlide, Import))
		{
			return bRet = false;
		}
		///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
		// NOT NEED set background, as keep same as origin graph page
		//if(!slideBackgroundSetting(oSlide,nBackground, GradientType))
		//{
			//return bRet = false;
		//}
		///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
		slideHeadersFooters(oSlide);

		return bRet = true;
	}
	
	bool slideBackgroundSetting(Object& oSlide,int nBackground, int GradientTyep  = 1)
	{		
		try
		{
			UINT bRet = oSlide.ColorScheme.Colors(1) ;
   			oSlide.Background.Fill.Visible = true;
   			oSlide.FollowMasterBackground = false; 
			oSlide.Background.Fill.ForeColor.RGB = RGB(0,0,255);
 			if(GradientTyep == 2)
 			{
 				oSlide.Background.Fill.BackColor.RGB = RGB(0,255,255); 
   				oSlide.Background.Fill.TwoColorGradient(1, 4); 
 			}
 			else
 			{
    			oSlide.Background.Fill.OneColorGradient(4,2,0); 
			
 			}
		}
 		catch(int nErr)
 		{
 			return false;
 		}
		
 		return true;
	}
	bool slideHeadersFooters(Object& oSlide,bool showFooters = true)
	{
		if(showFooters)
		{
			try
			{
				///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
				// NOT NEED set Day Time, as keep same as origin graph page
				////show day and time
				//oSlide.HeadersFooters.DateAndTime.Format = 1;
				//oSlide.HeadersFooters.DateAndTime.UseFormat = 1;
				//oSlide.HeadersFooters.DateAndTime.Visible = true;
				///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
				//show slide number
				oSlide.HeadersFooters.SlideNumber.Visible = true;
			}
			catch(int nErr)
			{
				return false;
			}
		}
		
		return true;
	}
	bool slideShowTransition( Object& oSlide ,PPSlideTransitionInfo& Import)//bool OnClick = true ,bool OnTime = true,int slideStayTime = 2,int entryEffectpp = ppEffectCheckerboardAcross,int nSlideTransition =ppTransitionSpeedSlow )
	{
		if(!oSlide)
		{
			return false;
		}
		try
		{
			oSlide.SlideShowTransition.AdvanceOnClick = Import.bOnClick;
			oSlide.SlideShowTransition.AdvanceOnTime  = Import.bOnTime;
			oSlide.SlideShowTransition.AdvanceTime = Import.nSlideStayTime;
			oSlide.SlideShowTransition.EntryEffect = Import.nEntryEffectpp;
			oSlide.SlideShowTransition.Speed = Import.nSlideTransition;
		}
		catch(int nErr)
		{
			return false;
		}
		return true;
	}
	
	bool createNewPresentation( )
	{	
		if( !openPowerPointApp() )
		return false;  //return -1 if can't open powerpoint application

		m_opptPresent = m_oppt.Presentations.Add(1);
		if(NULL == m_opptPresent)	
		{
			return false; //return -2 if can't create new presentation
		}
		return true;//return 0 mean ok.
	}
	bool applyPresentationTemplate(string strTemplateName = "")
	{
		try
		{
			m_opptPresent.ApplyTemplate(strTemplateName);
		}
		catch(int nErr)
		{
			return false;
		}
		return true;
	}

	///---Sim 07-21-2009 QA81-4184 SUPPORT_POSIT_GRAPH_ON_SLIDE
	//void pasteGraphToSlide(Object& slide)
	void pasteGraphToSlide(Object& slide, PPSlideTransitionInfo& Import)
	///---END QA81-4184 SUPPORT_POSIT_GRAPH_ON_SLIDE
	{
		Object shapes = slide.Shapes;
		///---Sim 07-22-2009 QA81-4184 MORE_CHANGE_EXPORT_PPT
		//Object shape = shapes.Paste();
		Object shape;
		// refer to: PasteSpecial(DataType, DisplayAsIcon, IconFileName, IconIndex, IconLabel, Link)
		switch ( Import.nDataType )
		{
		case DATA_TYPE_PICTURE:
			shape = shapes.PasteSpecial(ppPasteMetafilePicture);
			break;
		case DATA_TYPE_EMBEDED_GRAPH:
			///Sophy 7/11/2012 ORG-6188-S1 IMPROVE_ERROR_REPORT_WHEN_PASTESPECIAL_TO_PPT_FAIL
			//shape = shapes.PasteSpecial(ppPasteOLEObject, msoFalse, "", 0, "", msoFalse);
			try
			{
				shape = shapes.PasteSpecial(ppPasteOLEObject, msoFalse, "", 0, "", msoFalse);
			}
			catch(int nErr)
			{
				string strErr, strFmt;
				strFmt =  _L("PowerPoint has memory limitation. %s is too large to export to PowerPoint.");
				if ( IsOGLGraph(m_strPageName) )
					strFmt +=  " " + _L("You can modify system variable @oglssm to be smaller and try again.");
				strErr.Format(strFmt, m_strPageName);
				warning_msg_box(strErr, false, 'E');
				return;
			}
			///end IMPROVE_ERROR_REPORT_WHEN_PASTESPECIAL_TO_PPT_FAIL
			break;
		case DATA_TYPE_LINK:
			shape = shapes.PasteSpecial(ppPasteOLEObject, msoFalse, "", 0, "", msoTrue);
			break;
		};		
		///---END QA81-4184 MORE_CHANGE_EXPORT_PPT
		///---Sim 07-21-2009 QA81-4184 SUPPORT_POSIT_GRAPH_ON_SLIDE
		//shape.Top =10;
		//shape.Left = 20;
		//shape.Width = 700;
		//shape.Height  = 500;
		///---Sim 07-22-2009 QA81-4184 MORE_CHANGE_EXPORT_PPT
		//shape.Top = Import.dTop;
		//shape.Left = Import.dLeft;
		//shape.Width = 700 * (Import.dRatio / 100);
		//shape.Height  = 500 * (Import.dRatio / 100);
		shape.LockAspectRatio = msoFalse;
		double dTotalWidth = m_opptPresent.PageSetup.SlideWidth;
		double dTotalHeight = m_opptPresent.PageSetup.SlideHeight;
		shape.Top = dTotalHeight * ( Import.dMarginTop / 100 );
		shape.Left = dTotalWidth * ( Import.dMarginLeft / 100 );
		shape.Height = dTotalHeight * ( 1 - ( Import.dMarginTop + Import.dMarginBottom ) / 100 );
		shape.Width = dTotalWidth * ( 1 - ( Import.dMarginLeft + Import.dMarginRight ) / 100 );
		///---END QA81-4184 MORE_CHANGE_EXPORT_PPT
		///---END QA81-4184 SUPPORT_POSIT_GRAPH_ON_SLIDE
		//shape.ScaleWidth(2,1,0) ;
		//shape.ScaleHeight(2,1,0);
	}
		
	bool copyPageToClipboard(PageBase& pg)
	{		
		string strPageName = pg.GetName();
		
		if(strPageName.IsEmpty())
		{
			return false;
		}
		///Sophy 7/11/2012 ORG-6188-S1 IMPROVE_ERROR_REPORT_WHEN_PASTESPECIAL_TO_PPT_FAIL
		m_strPageName = strPageName;
		///end IMPROVE_ERROR_REPORT_WHEN_PASTESPECIAL_TO_PPT_FAIL
		bool bRet;	
		string strExec = "Clipboard " + strPageName;
		bRet = LT_execute(strExec);

		if( !bRet )
		{
			string str("****The pointer Page in the current Project not Graph or Layout page!****\n");
			str.Write(WRITE_COMPILER_OUTPUT);
			return false;
		}
		return true;	
	}
	
	bool insertPageToSlide(PPSlideTransitionInfo& Import, PageBase &pg )
	{
		if(copyPageToClipboard( pg ))
		{		
			Object oSlide = createNewSlide(Import);
			if(!(oSlide==NULL))
			///---Sim 07-21-2009 QA81-4184 SUPPORT_POSIT_GRAPH_ON_SLIDE
			//pasteGraphToSlide( oSlide );
			pasteGraphToSlide(oSlide, Import);
			///---END QA81-4184 SUPPORT_POSIT_GRAPH_ON_SLIDE
		}
		else
		{
			return false;
		}
		return true;
	}
//IF bTry = false, then check if the application valid	
	bool openPowerPointApp( )
	{
		if( !m_bHasOpenPPT )
		{
			try
			{
				m_oppt = CreateObject(PPT_COM_OBJ_NAME);
				///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
				//m_oppt.WindowState = ppWindowMinimized;
				///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
			}
			catch(int nErr)
			{
				m_bHasOpenPPT = false;
			}
			if( m_oppt == NULL )
			{
				string strError("Fail to instantiate Labview Application\n");
				strError.Write(WRITE_COMPILER_OUTPUT);
				return false;
			}

			m_bHasOpenPPT = true;
		}
		m_oppt.Visible = true;	
		///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
		///---Sim 07-22-2009 QA81-4184 MORE_CHANGE_EXPORT_PPT
		//m_oppt.WindowState = ppWindowMinimized;
		m_oppt.WindowState = ppWindowMaximized;
		///---END QA81-4184 MORE_CHANGE_EXPORT_PPT
		///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
		return true;
	}
	///---Sim 07-17-2009 QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
	bool closePowerPointApp( )
	{
		if( m_bHasOpenPPT )
		{
			try
			{
				m_oppt.Quit();
			}
			catch(int nError)
			{
				return false;
			}
			
			m_bHasOpenPPT = false;
			m_oppt = NULL;
		}
		
		return true;
	}	
	///---END QA81-4184 REDO_POWERPOINT_EXPORT_AS_SLIDE_SHOW
	
	bool isValid()
	{
		return m_bHasOpenPPT;
	}
	
	bool saveAsPresentation(LPCSTR lpcszPPFilename, UINT uShowMode = ppSaveAsShow)
	{

		try
		{
			m_opptPresent.SaveAs(lpcszPPFilename, uShowMode);
		}
		catch(int nError)
		{
			return false;
		}
		
		return true;
	}
	
	bool previewPresentation( int showType = ppShowTypeSpeaker )
	{
		bool bRet;
		
		try
		{
			m_oppt.WindowState = ppWindowMaximized;
			m_opptPresent.SlideShowSettings.AdvanceMode = ppSlideShowUseSlideTimings;
			m_opptPresent.SlideShowSettings.ShowType = showType;
			m_opptPresent.SlideShowSettings.Run();
		}
		catch(int nErr)
		{
			return false;
		}
		return bRet = true;
	}

private:	
	///Sophy 7/11/2012 ORG-6188-S1 IMPROVE_ERROR_REPORT_WHEN_PASTESPECIAL_TO_PPT_FAIL
	string		m_strPageName;
	///end IMPROVE_ERROR_REPORT_WHEN_PASTESPECIAL_TO_PPT_FAIL
	Tree		m_trPageInfo;
	bool 		m_bHasOpenPPT;
	Object		m_oppt;
	Object		m_opptPresent;
	Object 		m_oSlides;
};

#endif // _POWERPOINT_EXPORT_H
