/*------------------------------------------------------------------------------*
 * File Name:	PFParamDlg.c													*
 * Creation: 	Folger															*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 10/16/08 PA_FIT_CONTROL_DIALOG_NEED_TO_REMEBERE_AUTO_INIT_CHECKBOX_STATUS
 *	Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA					*
 *	Folger 11/01/08 QA80-12509 v8.0964 SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
 *	Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE							*
 *	Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
 *	Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP				*
 *	Hong 12/10/08 QA80-12744 IMPROVE_PARAM_GRID_BY_ROW_SEL_AND_BOLD_ACTVIE_CELL	*
 *	Folger 01/05/09 v8.0993d REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
 *	Folger 03/09/09 PROPER_HANDLE_OF_MAX_NUM_ITERATE_IN_FIT_PARAM_DIALOG		*
 *	Folger 03/16/09 PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
 *	Folger 07/14/09 NANOSIZER_FAILS_TO_UPDATE_PARAMETERS_HIDE_GUI_AFTER_CHANGE_FUNCTION
 *	Jasmine 12/21/10 ORG-793 MOVE_FIT_CONTROL_FROM_PA_FIT						*
 *------------------------------------------------------------------------------*/
#ifndef _PEAK_FIT_PARAMETER_DLG_H_
#define _PEAK_FIT_PARAMETER_DLG_H_

#include <ONLSF.h>
#include "curve_utils.h"
/// Iris 11/11/2008 v8.0968 MOVE_PA_ENUM_TO_NEW_HEADER_PA_UTILS
//#include "PFM_utils.h"
#include "pa_utils.h"
///end MOVE_PA_ENUM_TO_NEW_HEADER_PA_UTILS
#include "PeakFitHelperBase.h"
#include "PeakFitHelper.h"					///Jasmine 12/21/10 ORG-793 MOVE_FIT_CONTROL_FROM_PA_FIT

#include "DialogEx.h"
#include "GridTableControl.h"
#include "NLFitParaControl.h"
/// Iris 11/06/2008 v8.0966 CLEAN_FILE_ON_NEW_FIT_SESSION_FILE
//#include "MultiFuncFParaControl.h"
#include "MultiFuncFitParaControl.h"
///end CLEAN_FILE_ON_NEW_FIT_SESSION_FILE

#include "ParameterDlg.h"

 
enum{
	PFDLG_FIX_BASELINE_BUTTON,
	PFDLG_FIX_PEAK_CENTER_BUTTON,
	PFDLG_FIX_PEAK_WIDTH_BUTTON,
	
	PFDLG_FIX_BUTTON_TOTAL
};

#define STR_FIT_CONTROL_TAB				_L("Fit Control")		///Jasmine 12/10/10 ORG-793 MOVE_FIT_CONTROL_FROM_PA_FIT
	
class PFParamDlg : public FitParaDlg
{

public:	
	PFParamDlg(PeakFitHelperBase* pPeakFitHelper, bool bMulFunc = true);
	~PFParamDlg();	
	
protected:	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_DESTROY(OnDestroy)
	ON_READY(OnReady)
	ON_SIZE(OnDlgResize)
	ON_INIT_SIZE(OnInitSize)
	ON_RESTORESIZE(OnRestoreSize)
	
	ON_CHANGE_PAGE(OnActivePageChange)
	
	ON_BN_CLICKED(IDOK, OnClickOK)
	ON_BN_CLICKED(IDC_PF_AVANCED, OnAdvanced)
	ON_BN_CLICKED(IDC_PF_INIT, OnInitParamValue)
	ON_BN_CLICKED(IDC_PF_CHI_SQ, OnClickChiSQ)
	ON_BN_CLICKED(IDC_PF_FIT, OnClickFit)
	ON_BN_CLICKED(IDC_PF_ONE_LTER, OnClickOneIter)
	ON_BN_CLICKED(IDC_PF_HIDE, OnClickParamHide)	
	ON_BN_CLICKED(IDC_PF_QUICK_SET, OnQuickSetParam) 	///Jasmine 10/17/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL
	
	ON_BN_CLICKED(IDC_PF_AUTO_INIT_CHECK, OnCheckAutoInit) 
	ON_BN_CLICKED(IDC_PF_FIXED_BASELINE, OnToggleFixBaseline)
	ON_BN_CLICKED(IDC_PF_FIXED_CENTER, OnToggleFixPeakCenter)
	ON_BN_CLICKED(IDC_PF_FIXED_WIDTH, OnToggleFixPeakWidth)
	
	ON_BN_CLICKED(IDC_PF_SHARED_WIDTH, OnToggleSharePeakWidth)
	
	ON_BN_CLICKED(IDC_PF_SORT_PEAKS, OnSortPeaks)		//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA
	
	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	ON_BN_CLICKED(IDC_PF_REORDER_PEAKS, OnReorderPeaks)
	//------
	
	//------ Folger 11/01/08 QA80-12509 v8.0964 SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
	ON_BN_CLICKED(IDC_PF_SWITCH_PEAK_LABEL, OnSwitchPeakLabel)
	//------
	
	ON_TAB_SEL_CHANGE(IDC_PF_SETTING_TAB, OnTopTabChange)
	
	ON_BN_CLICKED(IDC_SHOW_BOTTOM, OnShowBottomPane)
	
	ON_GRID_BEFORE_EDIT(IDC_PF_PARA_GRID, OnBeforeEditParaControl)
	ON_GRID_AFTER_EDIT(IDC_PF_PARA_GRID, OnAfterEditParaControl)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_PF_PARA_GRID, OnBeforeMouseDownParaControl)
	ON_GRID_MOUSE_MOVE(IDC_PF_PARA_GRID, OnMouseMoveParaControl)
	ON_GRID_COMBO_CLOSEUP(IDC_PF_PARA_GRID, OnGridComboCloseUp)
	
	ON_CBN_SELCHANGE(IDC_PF_COMBO, OnComboChangeFunction)
	
	ON_HELPINFO(OnHelp)
	/// Hong 12/10/08 QA80-12744 IMPROVE_PARAM_GRID_BY_ROW_SEL_AND_BOLD_ACTVIE_CELL		
	ON_GRID_AFTER_SEL_CHANGE(IDC_PF_PARA_GRID, OnAfterSelChange)
	/// end IMPROVE_PARAM_GRID_BY_ROW_SEL_AND_BOLD_ACTVIE_CELL	
	
	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)///Jasmine 12/10/10 ORG-793 MOVE_FIT_CONTROL_FROM_PA_FIT
	
EVENTS_END
	///Jasmine 12/10/10 ORG-793 MOVE_FIT_CONTROL_FROM_PA_FIT
	//virtual 
	BOOL OnInitDialog();	
	
	//virtual
	void	OnAfterValueChange(int nRow, int nCol);
	///End MOVE_FIT_CONTROL_FROM_PA_FIT
	
	//------ Folger 10/16/08 PA_FIT_CONTROL_DIALOG_NEED_TO_REMEBERE_AUTO_INIT_CHECKBOX_STATUS
	/// virtual
	BOOL	OnReady();
	//------

	/// virtual
	BOOL	OnDestroy();
	
	//virtual
	BOOL 	OnTopTabChange(Control cntrl);	///Jasmine 12/21/10 ORG-793 MOVE_FIT_CONTROL_FROM_PA_FIT
	
	BOOL	OnComboChangeFunction(Control ctrl);
	BOOL	OnAdvanced(Control ctrl);
	BOOL	OnInitParamValue(Control ctrl);
	
	BOOL	OnCheckAutoInit(Control ctrl);
	BOOL	OnToggleFixBaseline(Control ctrl);
	BOOL	OnToggleFixPeakCenter(Control ctrl);
	BOOL	OnToggleFixPeakWidth(Control ctrl);
	
	/// virtual
	BOOL	OnSortPeaks(Control ctrl);				//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA
	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	/// virtual
	BOOL	OnReorderPeaks(Control ctrl);
	//------
	
	//------ Folger 11/01/08 QA80-12509 v8.0964 SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
	///virtual
	BOOL	OnSwitchPeakLabel(Control ctrl);
	//------
	
	/// virtual
	BOOL	OnToggleSharePeakWidth(Control ctrl);
	
	void	OnAfterEditParaControl(Control flxControl, int nRow, int nCol);
	bool	IsShowPeakTypeCol();	
	BOOL	OnHelp(int &nHelpID, int nIdCtrlFocus);
public:
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	//bool	GetFitSessionFropPage();
	//bool	SetParamValToPFMTree(const TreeNode&trPara);
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
	
	/// virtual
	bool	Update(bool bNewGrid = false);
	
	void	EnableFitButton(bool bEnable);	
	BOOL	OnClickParamHide(Control ctrl);
	
	/// Hong 12/10/08 QA80-12744 IMPROVE_PARAM_GRID_BY_ROW_SEL_AND_BOLD_ACTVIE_CELL	
	void 	OnAfterSelChange(Control cntrl, int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel);
	/// end IMPROVE_PARAM_GRID_BY_ROW_SEL_AND_BOLD_ACTVIE_CELL
	
	BOOL	UpdateParameterHide(bool bShowGetNDialog = true);		///------ Folger 03/16/09 PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED	
	
	///Jasmine 04/14/10 QA81-15304 ANNOUNCE_FITTING_FUNC_CHANGE
	//virtual 
	BOOL OnFittingFuncChange(uint wParam, uint lParam);
	///End ANNOUNCE_FITTING_FUNC_CHANGE
	
private:	
	/// virtual begin
	void updateOnParameterChange(int nUpdateParts );		/// Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE
	void	updateControlsVisibility();
	void	initButtons();
	int		getButtonIDs(vector<uint>& vnButtonIDs);
	void	initAfterUpdate();
	bool	initParaGrid(int nID, Dialog& dlg, LPCSTR lpcszDlgName);
	//bool	setParameterTreeToGrid(); /// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	int		getParameterGroups();
	bool	updateParameters(bool bNewGrid = false, int* pnSetting = NULL);
	//int		getMaxIterationNum();		///------ Folger 03/09/09 PROPER_HANDLE_OF_MAX_NUM_ITERATE_IN_FIT_PARAM_DIALOG
	bool	afterIterate(bool bEnable);	
	/// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	//bool	customParamRowsShow(bool bUpdateGird = true);
	bool	customParamRowsShow(bool bUpdateGird = true, int* pnGroupToShow = NULL);
	/// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	bool	updateHiddenParamsInfo();
	int		getToltalNumParams();
	///virtual end
	
	bool	updateParameterSettingsFromTree(const TreeNode& trParams);
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	//void	onChangePeakType(const vector<int>& vnPeakNOs, const vector<string>& vsPeakTypes);	///Jasmine 03/31/08 ALLOW_CHANGE_FUNCTION_IN_PARAM_DLG
	///END PA_PARAM_DLG_USE_NEW_FIT_CLASS
	BOOL	updateFixReleaseButton(int nBtnID);
	
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	void	updateButtonStatus();
	void	onAfterFunctionChanged();
	bool	checkedAutoInit();
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
	
	///------ Folger 01/05/09 v8.0993d REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
	/// virtual
	TreeNode	getParamHideTree(const vector<int>& vnParamsHide, const vector<string> & vsLabel, string* pstrNodePre = NULL, bool bAddGroupShowCombo = false);
	///------ End REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
	
	NLParametersManager*		getNLParamMngr()		{ return m_pParamManager; }

	///------ Folger 07/14/09 NANOSIZER_FAILS_TO_UPDATE_PARAMETERS_HIDE_GUI_AFTER_CHANGE_FUNCTION
	/// virtual
	void		ResetParamHideTree();
	///------ End NANOSIZER_FAILS_TO_UPDATE_PARAMETERS_HIDE_GUI_AFTER_CHANGE_FUNCTION
	
private:	
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	//Page				m_pg;
	//Tree				m_trPFM;
	PeakFitHelperBase*	m_pPeakFitHelper;	
	NLParametersManager*	m_pParamManager;
	string				m_strComboOldFunction; // need to compare new selectly function if same as old funciton, if so, no need do anything.
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS

	DynaControl			m_DynaCntrl;	///Jasmine 12/21/10 ORG-793 MOVE_FIT_CONTROL_FROM_PA_FIT
	
	bool				m_bMulFunc;	
	vector<bool>		m_vbFixButtons;
	
	//bool 				m_bDeleteOnDestroy;		///Kyle 10/07/08 CHECK_IF_NEED_TO_DELETE_THE_DIALOG_IN_ONDESTROY
};



#endif //_PEAK_FIT_PARAMETER_DLG_H_