 /*-----------------------------------------------------------------------------*
 * File Name: PagePreviewList.c		 											*
 * Creation: Frank	 7/25/05													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * 	Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER		*
 * 	Zech 12/12/2011 ORG-4284-P1 FIX_MULTIPLE_GRAPH_OPERATIONS					*
 * 	Zech 12/12/2011 ORG-4284-P2 ENABLE_SELECT_FOLDER_BY_DOUBLE_CLICK			*
 * 	Zech 12/12/2011 ORG-4284-S1 CHANGE_SPECIFIED_FOLDER_GUI_STYLE				*
 * 	Zech 12/14/2011 ORG-4284-S2 ENABLE_SHOW_GRAPHS_IN_FOLDER_VIEW				*
 *	Folger 02/08/2012 ORG-5010-P1 QUERY_RESULT_SUPPORT_FILTER_FUNCTION			*
 * 	Zech 03/31/2012 ORG-4284-P3 DO_NOT_SHOW_SPARKLINE_IN_GRAPH_BROWSER			*
 * 	Zech 04/01/2012 ORG-4284-P4 ADD_QUOTES_FOR_FOLDER_NAME_BEFORE_QUERY			*
 *	Zech 04/01/2012 ORG-4284-P5 FIX_PATH_TEXT_CONTROL_ALIGN_WHEN_PREVIEW_ON_RIGHT
 *	Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER	*
 *	Zech 04/01/2012 ORG-4284-S4 ENLARGE_GRAPH_BROWSER_DEFAULT_HEIGHT_AND_WIDTH	*
 *	Jasmine 05/11/2012 ORG-4971-S2 ALLOW_REMOVE_ALL_LINKED_GRAPHS				*
 *	Folger 05/18/2012 ORG-5738 ADVANCED_QUERY_RESULT_OC_FILTER_FUNCTION_SUPPORT	*
 *	Zech 07/03/2012 ORG-4284-S5 GRAPH_BROWSER_REMEMBER_LAST_USED_LOCATION		*
 *	EJP 2012-07-05 ORG-6138 INIT_FOLDER_COMBO_IN_GRAPH_BROWSER					*
 *	Tony 07/20/2012 ORG-6167-P1 AVOID_RESET_ROWS								*
 *	Philip 08/14/2012 ORG-6430-S2 ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS		*
 *	Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST		*
 *	Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW							*
 *	Philip 08/17/2012 ORG-4284-S8 FIX_TEXT_SHOWING_PROBLEMS						*
 *	Philip 08/27/2012 ORG-6619-P2 FIX_FAIL_TO_DRAG_ROW_UPDOWN_IN_SELLIST		*
 *	Philip 08/27/2012 ORG-6619-P3 FIX_COLUMN_MISSING_IN_LISTVIEW				*
 *	Philip 08/27/2012 ORG-6619-P4 FIX_PATHS_OUT_OF_ORDER						*
 *	Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS						*
 *	Philip 08/31/2012 ORG-6619-P5 IMPROVE_LISTVIEW_COLUMN_DISPLAY				*
 *	Tony 09/07/2012 ORG-5608-P1 REMOVE_ACTIVE_GRAPH_PAGE						*
 *	Philip 09/11/2012 ORG-6619-P6 SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
 *	Philip 09/14/2012 ORG-5608-P3 REMOVE_LONGNAME_FAIL_WHEN_REMOVE_ACTIVE_PAGE	*
 *------------------------------------------------------------------------------*/

#include <origin.h>
#include "DialogEx.h"
#include "../system/Page.h"
#include <ocGDI.h>
#include <..\Originlab\GraphFilter.h> 
#include "WksColLabels.h"			
#include "../system/Array.h"
#include <..\Originlab\LayoutHelper.h>

/////////////////////////////////////////////////////////////////////////////////

#define  	_DMSG_MG(_str)
#define 	STR_DLG_NAME 				"Graph Browser"
#define 	STR_DLG_NAME_S 				"Graphs Browser"
#define		STR_PAGE_LIST_SEPARATOR 	'\n'
#define		CHAR_FLD_SEPARATOR			'/'
#define		CHAR_FILENAME_SEPARATOR  	'"'

#define		COL_INDEX					1

#define STR_PICT_NO_PREVIEW		"No Preview available"

#define STR_DISPLAY_NAME_ATTRB		"DisplayName"///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW


enum{
	COL_NAME = 1,
	COL_PATH,
	///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
	COL_LAYERS,
	COL_PLOTS
	///end ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
};

enum{
		SEL_LIST_REMOVE,
		SEL_LIST_UP,
		SEL_LIST_DOWN,
		
		SEL_LIST_LAST_ITEM
};

///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
enum{
	PROJECT_TR_ADD_ALL,
	PROJECT_TR_ADD_ALL_RECURSIVE,
	PROJECT_TR_ADD_ALL_OPEN,
	PROJECT_TR_SEPARATOR,	
	PROJECT_TR_SHOW_LNAME,
	PROJECT_TR_SHOW_CELL,
	
	PROJECT_TR_ADD_LAST_ITEM
};
///end RECOVER_FOLDER_VIEW

#define		STR_DIALOG_NAME			"PagePreviewListDlg"
#define		STR_LIST_SETTINGS			"Ssettings"

#define		PG_DLG_GAP					3
#define 	PG_DLG_MIN_SIZE				200

#define STR_KEYWORD_RECURSIVE		"RECURSIVE"
#define STR_KEYWORD_SHORTCUT		"SHORTCUT"
#define STR_KEYWORD_EMBEDED			"EMBEDED"

/////////////////////////////////////////////////////////////////////////////////

//folder modes:
#define STR_FOLDER_CONTAINER_ALL_FOLDER				"All Folder"
#define STR_FOLDER_CONTAINER_ACTIVE_FOLDER			"Active Folder"
#define STR_FOLDER_CONTAINER_SPECIFIED_FOLDER		"Specified Folder"

/// Zech 07/03/2012 ORG-4284-S5 GRAPH_BROWSER_REMEMBER_LAST_USED_LOCATION
#define STR_SAVE_USING_FOLDER						"UsingFolder"
#define STR_SAVE_SPECIFIED_FOLDERS					"SpecifiedFolders"
#define CHAR_SAVE_TOKEN								'\r'
/// END GRAPH_BROWSER_REMEMBER_LAST_USED_LOCATION

///Philip 08/14/2012 ORG-6430-S2 ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
#define STR_SAVE_LAST_USED_GRAPHS					"LastUsedGraphs"
#define SNAME_PATH_DELIMITER						'@'
#define NULL_OBJ									NULL
#define STR_QUERY_EXIST_GRAPHS						"SELECT GRAPH FROM PROJECT RECURSIVE EMBEDED"
///end ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS

///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
#define IDC_CHECK_FOLDER_VIEW						IDC_CHECK_LIST_VIEW //reuse it for folder view

class PagePreviewListDlg;

class ProjectTreeMenu : public Menu
{
public:
	///Jasmine 11/17/06 SHOW_LNAME_AND_CELL		
	/// Kenny 09/08/2009 IMPROVE_SHOW_HIDE_CONTEXT_MENU
	//ProjectTreeMenu(bool bFolder, bool bMulti, bool bLName = false, bool bEmbed = false, bool bCell = false)
	ProjectTreeMenu(bool bFolder, bool bMulti, bool bLName = false, bool bEmbed = false, bool bCell = false, bool bAddingItems = true)
	/// End IMPROVE_SHOW_HIDE_CONTEXT_MENU
	{
		m_nChoice = -1;
		/// Kenny 09/08/2009 IMPROVE_SHOW_HIDE_CONTEXT_MENU
		m_nBaseIndex = bAddingItems ? PROJECT_TR_ADD_ALL : PROJECT_TR_SHOW_LNAME;
		if ( bAddingItems )
		/// End IMPROVE_SHOW_HIDE_CONTEXT_MENU
		{
			Add(_L("Add"), OnMenuItem);
			Add(_L("Add ALL( Recursive)"), OnMenuItem, (bFolder && !bMulti)? MF_ENABLED : MF_DISABLED | MF_GRAYED);
			Add(_L("Add ALL Open"), OnMenuItem, (bFolder && !bMulti)? MF_ENABLED : MF_DISABLED | MF_GRAYED);
			Add(NULL, EmptySepFunc, MF_SEPARATOR);
		}
		Add(_L("Show Long Name"), OnMenuItem,  MF_STRING | (bLName ? MF_CHECKED: MF_UNCHECKED));
		Add(_L("Show Cell Location"), OnMenuItem,  MF_STRING | (bCell ? MF_CHECKED: MF_UNCHECKED) | (bEmbed ? MF_ENABLED : MF_DISABLED | MF_GRAYED));
	///End SHOW_LNAME_AND_CELL
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= PROJECT_TR_ADD_ALL && m_nChoice <= PROJECT_TR_ADD_LAST_ITEM)
		{
			nChoice = m_nChoice;
			nChoice += m_nBaseIndex;	/// Kenny 09/08/2009 IMPROVE_SHOW_HIDE_CONTEXT_MENU
			return true;
		}
		return false;
	}
	void EmptySepFunc(uint nCmd)
	{
	}
private:
	int	m_nChoice;
	int m_nBaseIndex;	/// Kenny 09/08/2009 IMPROVE_SHOW_HIDE_CONTEXT_MENU
};
//end class ProjectTreeMenu
///end RECOVER_FOLDER_VIEW

enum FolderContainerType
{
	FOLDER_CONTAINER_ALL_FOLDER = 0,
	FOLDER_CONTAINER_ACTIVE_FOLDER	,
	FOLDER_CONTAINER_SPECIFIED_FOLDER
};

class FolderContainer: public ComboBox
{
public:
	FolderContainer(const ComboBox &combo) : ComboBox(combo)
	{
		combo.InsertString(FOLDER_CONTAINER_ALL_FOLDER, _L(STR_FOLDER_CONTAINER_ALL_FOLDER));
		combo.InsertString(FOLDER_CONTAINER_ACTIVE_FOLDER, _L(STR_FOLDER_CONTAINER_ACTIVE_FOLDER));
		combo.InsertString(FOLDER_CONTAINER_SPECIFIED_FOLDER, _L(STR_FOLDER_CONTAINER_SPECIFIED_FOLDER)); 
	}
	~FolderContainer() {}
};
//end class FolderContainer

/// Zech 12/12/2011 CLEAN_UP_QUERYRESULTEX
/*
/////////////////////////////// QueryResultEx //////////////////////////////////
enum QueryOptions
{
	QUERY_OPTION_RECURSIVE						= 0x00000001,
	QUERY_OPTION_SHORTCUT						= 0x00000002,
	QUERY_OPTION_EMBEDED						= 0x00000004,

	QUERY_OPTION_USE_LAST_QUERY_STRING			= 0x00010000,
};

class QueryResultEx : public QueryResult
{
public:
	int	Build(DWORD dwQueryOptions = 0, DWORD dwOptions = 0)
	{
		string strQuery;
		if (dwQueryOptions & QUERY_OPTION_USE_LAST_QUERY_STRING)
		{
			strQuery = m_str;
		}
		else
		{
			if ( !GetStr(strQuery) )
				return -1;
		}

		if (dwQueryOptions & QUERY_OPTION_RECURSIVE)
			strQuery += " " + STR_KEYWORD_RECURSIVE;
		if (dwQueryOptions & QUERY_OPTION_SHORTCUT)
			strQuery += " " + STR_KEYWORD_SHORTCUT;
		if (dwQueryOptions & QUERY_OPTION_EMBEDED)
			strQuery += " " + STR_KEYWORD_EMBEDED;

		return Build(strQuery, dwOptions);
	}	
private:
	virtual	BOOL	GetStr(string &str)	{return TRUE;}

protected:
	string		m_str;
};

class QueryResultSimple : public QueryResultEx
{
public:
	QueryResultSimple(LPCSTR lpcsz)
	{
		m_str = lpcsz;
	}
	
private:
	virtual		BOOL	GetStr(string &str)
	{
		str = m_str;
		return TRUE;
	}
};

typedef BOOL (*FUNC_GET_QUERY_STR)(string &str, LPVOID lp = NULL);

class QueryResultSpecific : public QueryResultEx
{
public:
	QueryResultSpecific(LPCSTR lpcszFunc, LPCSTR lpcszFile = NULL, LPVOID lp = NULL)
	{
		m_strFunc = lpcszFunc;
		m_strFile = lpcszFile;
		m_lp = lp;
	}
	
private:	
	virtual		BOOL	GetStr(string &str)
	{
		if ( !m_pfn )
			m_pfn = Project.FindFunction(m_strFunc, m_strFile, TRUE);

		if (m_pfn)
		{
			string strTemp;
			BOOL bRet = m_pfn(strTemp, m_lp);
			if (!bRet)
				return FALSE;
			m_str = str = strTemp;
			return TRUE;
		}
		
		ASSERT(FALSE);
		return FALSE;
	}
	
private:
	FUNC_GET_QUERY_STR		m_pfn;
	string					m_strFunc;
	string					m_strFile;
	LPVOID					m_lp;
};
*/
/// END CLEAN_UP_QUERYRESULTEX

/////////////////////////////// PageViewOptions /////////////////////////////////

struct PageViewOptions
{
	int 		nPageType;	
	bool		bMultiplePages;	//dialog support select multiple page as result	
	
	bool 		bShowFolders;
	string 		strStartPath;
	
	bool 		bLongNameShow;
	bool		bCellShow; 
	
	string		strFilterFuncName;	
	bool		bEmbedControlEnable;
	bool		bViewModeControlShow;
	
	int			nViewMode;///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	
	ProjectTreeOptions	stProjectTreeOptions;
};

///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
enum
{
	VIEW_MODE_LIST = 0,
	VIEW_MODE_FOLDER
};
///end RECOVER_FOLDER_VIEW
///////////////////////////// FolderBrowserStatus ///////////////////////////////

struct FolderBrowserStatus
{
	vector<string>		vsSelPaths;
	bool				bRecursive;
	bool				bShowGraphs;
	bool				bShowNumGraphs;/// Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
};

//////////////////////////// FolderBrowserView /////////////////////////////

class FolderBrowserView : public GridTreeControl
{
public:
	FolderBrowserView() {}
	~FolderBrowserView() {}
	/// Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
	//void updateFolderView(bool bShowGraphs)
	void updateFolderView(bool bShowGraphs, bool bShowNumGraphs)
	/// END ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
	{
		SetSelection(flexSelectionListBox);				
		SetAllowSelection(TRUE);
		
		/// Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		//updatePageView(bShowGraphs);
		updatePageView(bShowGraphs, bShowNumGraphs);	
		/// END ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		return;
	}
	
	/// Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
	//void updatePageView(bool bShowGraphs)
	void updatePageView(bool bShowGraphs, bool bShowNumGraphs)
	/// END ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
	{
		ClearAll();
		m_tree.Reset();
		
		Folder fld = Project.RootFolder;
		
		/// Zech 12/14/2011 ORG-4284-S2 ENABLE_SHOW_GRAPHS_IN_FOLDER_VIEW
		//get_project_tree(m_tree, PTL_FOLDER, 0, 0, fld.GetPath());
		/// Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		//get_project_tree(m_tree, bShowGraphs?PTL_PAGE:PTL_FOLDER, bShowGraphs?EXIST_GRAPH:0, 0, fld.GetPath());
		get_project_tree(m_tree, PTL_PAGE, EXIST_GRAPH, 0, fld.GetPath());
		/// END ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		/// END ENABLE_SHOW_GRAPHS_IN_FOLDER_VIEW
		
		/// Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		if (bShowNumGraphs)
			AddNumGraphsNextToFolderName(m_tree);
		
		if (!bShowGraphs)
			RemoveGraphsFromTree(m_tree);
		/// END ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		
		AddTreeNodes(m_tree, ATRN_LOOP_MARDED_NODE_ONLY, STR_DISPLAY_ATTRIB);
		UpdateFolderIcon();
	}
	
	void InitControl(WndContainer& dlg)
	{
		Init(IDC_FOLDER_VIEW, dlg);
		return;
	}
	
	void GetSelectedPaths(vector<string> &vsPath)
	{
		vsPath.RemoveAll();
		vector <uint> vnSelRows;
		GetSelRows(vnSelRows);
		int nRows = vnSelRows.GetSize();
		for (int nn = 0; nn < nRows; nn++)
		{
			TreeNode trSel = tree_get_node(m_tree, vnSelRows[nn]);
			string strPath;
			trSel.GetAttribute(STR_PATH_ATTRIB, strPath);
			vsPath.Add(strPath);
		}
	}

	void SetSelectedPaths(vector<string> &vsPath)
	{
		RemoveSelection();
		int nRows = GetNumRows();
		vector<int> vnToSelect;
		for (int nn = 0; nn < nRows; nn++)
		{
			TreeNode tr = tree_get_node(m_tree, nn);
			string strPath;
			tr.GetAttribute(STR_PATH_ATTRIB, strPath);
			if (-1 != vsPath.Find(strPath))
				vnToSelect.Add(nn);
		}
		SelRows(vnToSelect);
	}

	void UnselectNotFolderItems()
	{
		vector<uint> vnSelRows;
		GetSelRows(vnSelRows);
		int nRows = vnSelRows.GetSize();
		for (int nn = 0; nn < nRows; nn++)
		{
			if (!IsFolder(vnSelRows[nn]))
				SetIsSelected(vnSelRows[nn], false);
		}
	}

	bool IsFolder(int nRow)
	{
		int nGraphs, nBranches;
		nGraphs = tree_count_items(m_tree, &nBranches);
		if (nRow <0 || nRow >= nGraphs + nBranches)
			return false;

		TreeNode trSel = tree_get_node(m_tree, nRow);
		int nDisplay;
		return	trSel.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay) && 
				(IDI_FOLDER_OPEN == nDisplay || IDI_FOLDER_CLOSED == nDisplay);
	}

	void UpdateFolderIcon()
	{
		int nGraphs, nBranches, nItems;
		nGraphs = tree_count_items(m_tree, &nBranches);
		
		nItems = nGraphs + nBranches;
		
		for (int nn = 0; nn < nItems; nn++)
		{
			if (IsFolder(nn))
			{
				int nCurFolColl = GetCollapsed(nn);
				TreeNode trFolder = tree_get_node(m_tree, nn);
				trFolder.SetAttribute(STR_DISPLAY_ATTRIB, flexOutlineExpanded == nCurFolColl? IDI_FOLDER_OPEN : IDI_FOLDER_CLOSED);
				SetCellIcon(nn, 0, flexOutlineExpanded == nCurFolColl?IDI_FOLDER_OPEN:IDI_FOLDER_CLOSED, MODULE_ORIGIN);
			}
		}
	}
private:
/// Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
	void AddNumGraphsNextToFolderName(TreeNode &tr)
	{
		int nGraphs = 0, nDisplay;
		foreach(TreeNode trSub in tr.Children)
		{
			if (trSub.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay) &&
				(IDI_FOLDER_OPEN == nDisplay || IDI_FOLDER_CLOSED == nDisplay))
				AddNumGraphsNextToFolderName(trSub);
			else
				nGraphs++;
		}
		
		if (nGraphs > 0)
		{
			string strNum, strLabel;
			if (!tr.GetAttribute(STR_LABEL_ATTRIB, strLabel))
				return;
			
			strNum.Format("(%d)", nGraphs);
			strLabel += strNum;
			
			tr.SetAttribute(STR_LABEL_ATTRIB, strLabel);
		}
	}
	
	void RemoveGraphsFromTree(TreeNode &tr)
	{
		int nDisplay;
		string strAttribute = IDI_FOLDER_CLOSED;
		foreach(TreeNode trSub in tr.Children)
		{
			if (trSub.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay) &&
				(IDI_FOLDER_OPEN == nDisplay || IDI_FOLDER_CLOSED == nDisplay))
				RemoveGraphsFromTree(trSub);
			else
				trSub.Remove();
		}
	}
/// END ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER

private:
	Tree				m_tree;
};
//end class FolderBrowserView

///////////////////////// FolderBrowserDlg ///////////////////////////
//the specified-folder selection browser of graph browser

class FolderBrowserDlg : public ResizeDialog
{
public:
	FolderBrowserDlg() : ResizeDialog(IDD_SIMPLE_BROWSER, "ODlg8"){}

	FolderBrowserDlg(FolderBrowserStatus *stFB = NULL) : ResizeDialog(IDD_SIMPLE_BROWSER, "ODlg8")
	{
		if (NULL != stFB)
			m_stFB = *stFB;
	}
	
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap(); 
		return DoModal(hWndParent);	 	
	}
	
	void GetDlgStatus(FolderBrowserStatus &stFB)
	{
		stFB = m_stFB;
	}
	
	// the format of vsSuffix would be the "B C" in "SELECT A FROM B C"
	void GetQuerySuffix(vector <string> &vsSuffix)
	{
		if (m_stFB.bRecursive)
		{
			vector <string> vsTemp;
			vsTemp = m_stFB.vsSelPaths;
			_DEL_CHILDREN_PATHS(vsTemp);
			int nLen = vsTemp.GetSize();
			for (int nn = 0; nn < nLen; nn++)
				vsTemp[nn] += " " + STR_KEYWORD_RECURSIVE;
			vsSuffix = vsTemp;
		}
		else
			vsSuffix = m_stFB.vsSelPaths;
	}
	
protected:
	
	EVENTS_BEGIN
		ON_INIT(OnInitDialog) 
		ON_OK(OnOK)
		ON_CANCEL(OnCancel)
		//ON_GRID_SEL_CHANGE(IDC_FOLDER_VIEW, OnFolderView)	/// Zech 12/16/2011 TO_BE_CLEANED
		ON_GRID_DBLCLICK(IDC_FOLDER_VIEW, OnDoubleClickFolderView)	/// Zech 12/12/2011 ORG-4284-P2 ENABLE_SELECT_FOLDER_BY_DOUBLE_CLICK
		/// Zech 12/14/2011 ORG-4284-S2 ENABLE_SHOW_GRAPHS_IN_FOLDER_VIEW
		ON_BN_CLICKED(IDC_CHECK_SHOW_GRAPHS, OnClickShowGraphs)	
		ON_GRID_SEL_CHANGE(IDC_FOLDER_VIEW, OnFolderSelChange)
		ON_GRID_AFTER_COLLAPSE(IDC_FOLDER_VIEW, OnAfterCollapse)
		ON_GRID_BEFORE_MOUSE_DOWN(IDC_FOLDER_VIEW, OnBeforeMouseDownFolderView)
		/// END ENABLE_SHOW_GRAPHS_IN_FOLDER_VIEW
		/// Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		ON_BN_CLICKED(IDC_NUMBER_OF_GRAPHS, OnClickShowNumGraphs)	
		/// END ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
	EVENTS_END
		
	BOOL OnInitDialog()
	{
		Text = _L("Browse For Folder");
		m_FolderView.InitControl(*this);
		/// Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		//m_FolderView.updateFolderView(m_stFB.bShowGraphs);
		m_FolderView.updateFolderView(m_stFB.bShowGraphs, m_stFB.bShowNumGraphs);
		/// END ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		m_FolderView.SetSelectedPaths(m_stFB.vsSelPaths);
		//m_FolderView.SetFocusRect(flexFocusNone);
		
		Button bnCheckRecusive = GetItem(IDC_FOLDER_RECURSIVE);
		bnCheckRecusive.Check = m_stFB.bRecursive;

		Button bnCheckShowGraphs = GetItem(IDC_CHECK_SHOW_GRAPHS);
		bnCheckShowGraphs.Check = m_stFB.bShowGraphs;

		/// Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		Button bnCheckShowNumGraphs = GetItem(IDC_NUMBER_OF_GRAPHS);
		bnCheckShowNumGraphs.Check = m_stFB.bShowNumGraphs;
		/// END ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		
		m_bSelReady = true;

		return TRUE;
	}
	
	BOOL OnOK()
	{
		Button bnCheck = GetItem(IDC_FOLDER_RECURSIVE);
		m_stFB.bRecursive = bnCheck.Check;
		/// Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		Button bnCheckShowNumGraphs = GetItem(IDC_NUMBER_OF_GRAPHS);
		m_stFB.bShowNumGraphs = bnCheckShowNumGraphs.Check;
		/// END ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		m_FolderView.GetSelectedPaths(m_stFB.vsSelPaths);
		return TRUE;
	}
	
	BOOL OnCancel()
	{
		return TRUE;
	}

	/// Zech 12/16/2011 TO_BE_CLEANED
	/*
	/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
	BOOL OnFolderView(Control cntrl)
	{
		/// Disable OK button when no folder selected
		vector <uint> vnSelRows;
		m_FolderView.GetSelRows(vnSelRows);

		GetItem(IDOK).Enable = vnSelRows.GetSize()?true:false;	
		
		return TRUE;
	}
	/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
	*/

	/// Zech 12/12/2011 ORG-4284-P2 ENABLE_SELECT_FOLDER_BY_DOUBLE_CLICK
	bool OnDoubleClickFolderView(Control ctrl)
	{
		int nRow, nCol;
		m_FolderView.GetMouseCell(nRow, nCol);
		if (m_FolderView.IsFolder(nRow))
			PostMessage(WM_COMMAND, MAKELONG(IDOK, BN_CLICKED));
		return true;
	}
	/// END ENABLE_SELECT_FOLDER_BY_DOUBLE_CLICK

	/// Zech 12/14/2011 ORG-4284-S2 ENABLE_SHOW_GRAPHS_IN_FOLDER_VIEW
	BOOL OnClickShowGraphs(Control cntrl)
	{
		m_FolderView.SetReady(false);

		Button bnCheckShowGraphs = GetItem(IDC_CHECK_SHOW_GRAPHS);
		bool bShowGraphs = bnCheckShowGraphs.Check;
		m_stFB.bShowGraphs = bShowGraphs;

		// Refresh Folder View and keep selection
		m_FolderView.GetSelectedPaths(m_stFB.vsSelPaths);
		/// Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		//m_FolderView.updateFolderView(bShowGraphs);
		m_FolderView.updateFolderView(bShowGraphs, m_stFB.bShowNumGraphs);
		/// END ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
		m_FolderView.SetSelectedPaths(m_stFB.vsSelPaths);

		m_FolderView.SetReady(true);
		return TRUE;
	}
	
	/// Zech 04/01/2012 ORG-4284-S3 ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER
	BOOL OnClickShowNumGraphs(Control cntrl)
	{
		m_FolderView.SetReady(false);
		
		Button bnCheckShowNumGraphs = GetItem(IDC_NUMBER_OF_GRAPHS);
		bool bShowNumGraphs = bnCheckShowNumGraphs.Check;
		m_stFB.bShowNumGraphs = bShowNumGraphs;
		
		m_FolderView.GetSelectedPaths(m_stFB.vsSelPaths);
		m_FolderView.updateFolderView(m_stFB.bShowGraphs, bShowNumGraphs);
		m_FolderView.SetSelectedPaths(m_stFB.vsSelPaths);
		
		m_FolderView.SetReady(true);
		return TRUE;
	}
	/// END ADD_SHOW_NUMBER_OF_GRAPHS_FOR_FOLDER_BROWSER

	void OnFolderSelChange(Control ctrl)
	{
		// Graphs should not be selected
		if (m_bSelReady)
		{
			m_bSelReady = false;
			m_FolderView.UnselectNotFolderItems();
			m_bSelReady = true;
		}

		// Disable OK Button when no folder selected
		vector <uint> vnSelRows;
		m_FolderView.GetSelRows(vnSelRows);
		
		GetItem(IDOK).Enable = vnSelRows.GetSize()?true:false;	
	}

	void OnAfterCollapse(Control cntrl, int nRow, short nState)
	{
		m_FolderView.UpdateFolderIcon();
	}
	
	void OnBeforeMouseDownFolderView(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
	{
		int nRow, nCol;
		m_FolderView.GetMouseCell(nRow, nCol);
		if (!m_FolderView.IsFolder(nRow))
			*pCancel = true;
	}	
	/// END ENABLE_SHOW_GRAPHS_IN_FOLDER_VIEW
	
private:
	FolderBrowserView		m_FolderView;
	FolderBrowserStatus		m_stFB;
	bool					m_bSelReady;
};

///////////////////////////////// SelListMenu ///////////////////////////////////

class SelListMenu : public Menu
{
public:
	SelListMenu(bool bMulti, bool bFullPath = true)
	{
		m_nChoice = -1;
		Add(_L("Remove"), OnMenuItem);
		Add(_L("Up"), OnMenuItem, !bMulti? MF_ENABLED : MF_DISABLED | MF_GRAYED);
		Add(_L("Down"), OnMenuItem, !bMulti? MF_ENABLED : MF_DISABLED | MF_GRAYED);
		//Add(_L("Show Full Path"), OnMenuItem, bFullPath? MF_CHECKED : MF_UNCHECKED);
		
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= SEL_LIST_REMOVE && m_nChoice <= SEL_LIST_LAST_ITEM)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
private:
	int	m_nChoice;
};


/////////////////////////////////////////////////////////////////////////////////

typedef int (*FUNC_GRAPH_FILTER_FUNC)(int nMsg, Page& pg = NULL);

static FUNC_GRAPH_FILTER_FUNC _get_filter_func_pointer(LPCSTR lpcszFilterFuncName)
{
	FUNC_GRAPH_FILTER_FUNC pFunc = Project.FindCompiledFunction(lpcszFilterFuncName);
	if( NULL == pFunc )
		return NULL;	
	return pFunc;
}


static bool _get_page_view_options_by_filter_func(PageViewOptions& stViewOptions)
{
	FUNC_GRAPH_FILTER_FUNC pFunc = _get_filter_func_pointer(stViewOptions.strFilterFuncName);
	if( !pFunc )
		return false;
	
	int nRet = 0;
	
	// embedded checkbox show/hide control and embedded graphs show/hide control
	nRet = pFunc(GBFM_SHOW_EMBED_PAGE_CHKBOX);
	if( nRet >= 0 ) // < 0 means no this option in filter function
	{
		switch( nRet )
		{
		case EMBED_CHECKBOX_ENABLE:
			stViewOptions.bEmbedControlEnable = true;
			stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph = true; //default is checked
			break;
		case EMBED_CHECKBOX_DISABLE_EMBEDDING_PAGE_NEVER_ENABLE:
			stViewOptions.bEmbedControlEnable = false;
			stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph = false;
			break;
		case EMBED_CHECKBOX_DISABLE_EMBEDDING_PAGE_ALWAYS_ENABLE:
			stViewOptions.bEmbedControlEnable = false;
			stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph = true;
			break;	
		default:
			ASSERT(0); // other case need more code support...
			break;
		}
	}
	
	// view mode checkbox show/hide control and view mode control
	nRet = pFunc(GBFM_SHOW_SWITCH_MODE);
	if( nRet >= 0 ) // < 0 means no this option in filter function
	{
		switch( nRet )
		{
		case VIEW_MODE_TREE_ONLY:
			stViewOptions.bViewModeControlShow = false;
			stViewOptions.nViewMode = VIEW_MODE_FOLDER;///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
			break;
		case VIEW_MODE_LIST_ONLY:
			stViewOptions.bViewModeControlShow = false;
			stViewOptions.nViewMode = VIEW_MODE_LIST;///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
			break;
		case VIEW_MODE_BOTH_WITH_GLOBAL_DEFAULT:
			ASSERT(0); // to do 
			break;
		case VIEW_MODE_BOTH_WITH_LIST_DEFAULT:
			stViewOptions.bViewModeControlShow = true;	
			stViewOptions.nViewMode = VIEW_MODE_LIST;///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
			break;
		case VIEW_MODE_BOTH_WITH_TREE_DEFAULT:
			stViewOptions.bViewModeControlShow = true;
			stViewOptions.nViewMode = VIEW_MODE_FOLDER;///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
			break;
		default:
			ASSERT(0);  // other case need more code support...
			break;
		}		
	}
	
	nRet = pFunc(GBFM_SORT_PAGES);
	if( nRet >= 0 )
	{
		stViewOptions.stProjectTreeOptions.bSortPages = 1 == nRet? true : false;
	}
	
	return true;
}

static bool _filter_page_by_filter_func(LPCSTR lpcszFilterFuncName, const Page& pg)
{
	if( !pg )
		return true; // if page is invalid, filter it
	
	FUNC_GRAPH_FILTER_FUNC pFunc = _get_filter_func_pointer(lpcszFilterFuncName);
	if( !pFunc )
		return false; // fail to find function means no need filter
	
	if( pFunc(GBFM_IS_USE_PAGE, pg) > 0 )
		return false;	
	return true; // true mean filter this page
}

static string _get_embedded_graph_cell_location(LPCSTR lpcszPage)
{	
	Worksheet 	wks;
	int 		nRow, nCol;
	string 		strLocation;
	Page 		pg(lpcszPage);

	DWORD dwCntrl = 0;
	if( pg && pg.GetEmbeddingInfo(wks, &nRow, &nCol, &dwCntrl) )
	{
		++nCol;
		if( (dwCntrl & EMBEDGRAPH_IN_LABELS) && nRow >= 0 )
		{
			int nLabelType = nRow, nLabelRows;
			nRow = get_wks_column_label_index(wks, nLabelType, &nLabelRows);
			ASSERT( nRow >= 0 );
			nRow -= nLabelRows;
		}
		++nRow;

		strLocation.Format("[%s]%s!%d[%d:%d]", wks.GetPage().GetName(), wks.GetName(), nCol, nRow, nRow );		
	}	
	return strLocation;
}

void _DEL_CHILDREN_PATHS(vector <string> &vsPath)
{
	vsPath.Sort();
	int nLen = vsPath.GetSize();
	for (int nn = 0; nn + 1 < nLen;)
	{
		if (vsPath[nn+1].Find(vsPath[nn]) != -1)
		{
			vsPath.RemoveAt(nn+1);
			nLen--;
		}
		else
			nn++;
	}
}
///------ Tony 09/07/2012 ORG-5608-P1 REMOVE_ACTIVE_GRAPH_PAGE
///Philip 09/14/2012 ORG-5608-P3 REMOVE_LONGNAME_FAIL_WHEN_REMOVE_ACTIVE_PAGE
//static bool _remove_active_page(vector<string> &vsNames)
static bool _remove_active_page(vector<string> &vsNames, int* piRemoveAt = NULL)
///end REMOVE_LONGNAME_FAIL_WHEN_REMOVE_ACTIVE_PAGE
{
	GraphPage gp;
	gp = get_active_page();
	if(gp)
	{
		for(int ii = 0; ii < vsNames.GetSize(); ii++)
		{
			if(!vsNames[ii].CompareNoCase(gp.GetName()))
			{
				vsNames.RemoveAt(ii);
				///Philip 09/14/2012 ORG-5608-P3 REMOVE_LONGNAME_FAIL_WHEN_REMOVE_ACTIVE_PAGE
				if(piRemoveAt)
					*piRemoveAt = ii;
				///end REMOVE_LONGNAME_FAIL_WHEN_REMOVE_ACTIVE_PAGE
				return true;
			}
		}
	}
	return false;
}

static bool _remove_active_page(TreeNode &tr)
{
	GraphPage gp;
	gp = get_active_page();
	if(gp)
	{
		///Philip 09/11/2012 ORG-6619-P6 SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
		//TreeNode trActive = tr.FindNodeByAttribute("Name", gp.GetName());
		TreeNode trActive = tr.FindNodeByAttribute(STR_LABEL_ATTRIB, gp.GetName());
		///end SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
		trActive.Remove();
		return true;
	}
	return false;
}
///------ End REMOVE_ACTIVE_GRAPH_PAGE

///Philip 08/27/2012 ORG-6619-P4 FIX_PATHS_OUT_OF_ORDER
//---Move out "getFullPathFromPageName" and "getPageNameFromFullPath"
//   from class PagePreviewListDlg;
//---Rename and redefine them as static functions.
static string _get_full_path_from_page_name(string strPage)
{
	Page pg(strPage);
		
	Worksheet wks;
	if( pg.GetEmbeddingInfo(wks) )
	{
		pg = wks.GetPage();
	}
	
	if(pg)
	{
		Folder fld = pg.GetFolder();
		return fld.GetPath();
	}

	return "";
}

static string _get_page_name_from_full_path(string strFullPath)
{
	string 			strPage;
	vector<string> 	vsPage;
	if( strFullPath.GetTokens(vsPage, CHAR_FLD_SEPARATOR) <= 0 )
		return strPage;
	
	strPage = vsPage[vsPage.GetSize()-1];
	
	return strPage;
}
///end FIX_PATHS_OUT_OF_ORDER

//////////////////////////////// ListView ///////////////////////////////////

enum
{
	LIST_SHORT_NAME_COL,
	LIST_LONG_NAME_COL,
	LIST_PATH_COL,				/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
	LIST_CELL_LOCATION_COL,
	///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
	LIST_LAYERS_COL,
	LIST_PLOTS_COL,
	///end ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		
	LIST_COL_COUNT //keep it last one
};

class ListView : public TreeEditControl
{
public:
	ListView(bool bIsMultipleSelection = true) { m_bMultiplePages = bIsMultipleSelection; } ///Philip 09/11/2012 ORG-6619-P6 SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
	
	/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
	//void InitControl(WndContainer& dlg, const PageViewOptions& stViewOptions, LPCSTR lpcszPage = "")	
	void InitControl(WndContainer& dlg, const PageViewOptions& stViewOptions, LPCSTR lpcszPage = "", QueryResult *qQR = NULL)
	/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
	{		
		Init(IDC_FOLDER_TREE, dlg);
		
		SetReady(false);	
		
		/// Zech 12/12/2011 ORG-4284-P1 FIX_MULTIPLE_GRAPH_OPERATIONS
		//SetSelection(flexSelectionByRow);
		SetSelection(flexSelectionListBox);
		/// END FIX_MULTIPLE_GRAPH_OPERATIONS

		SetAllowSelection(stViewOptions.bMultiplePages);

		SetEditable();
		SetTreeView(false);
		
		setupColHeader(stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph);
		
		/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
		//updatePageView(stViewOptions, lpcszPage);								
		if (NULL != qQR)
			UpdatePageView(stViewOptions, qQR);
		/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
		
		vector<byte>		vbHideCols = {0, 0, 0, 0,
										  0, 0	///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		};
		
		vbHideCols[LIST_LONG_NAME_COL] = !stViewOptions.bLongNameShow;
		vbHideCols[LIST_CELL_LOCATION_COL] = !stViewOptions.bCellShow;
		SetHiddenCols(vbHideCols);
		
		SetReady(true);		
	}
	///------ Tony 07/20/2012 ORG-6167-P1 AVOID_RESET_ROWS
	//bool setupColHeader(bool bGetEmbeddedGraph)
	bool setupColHeader(bool bGetEmbeddedGraph, int nRows = 1)
	///------ End AVOID_RESET_ROWS
	{
		vector<string> 		vsColHeaders;
		vsColHeaders.Add( _L("Short Name") );
		vsColHeaders.Add( _L("Long Name") );
		vsColHeaders.Add( _L("Path") );
		///Philip 08/27/2012 ORG-6619-P3 FIX_COLUMN_MISSING_IN_LISTVIEW
		//if( bGetEmbeddedGraph )
		///end FIX_COLUMN_MISSING_IN_LISTVIEW
		vsColHeaders.Add( _L("Cell Location") );
		///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		vsColHeaders.Add( _L("Layers") );
		vsColHeaders.Add( _L("Plots") );
		///end ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		
		// set the size of rows and columns		
		///------ Tony 07/20/2012 ORG-6167-P1 AVOID_RESET_ROWS
		//SetupRowsCols(1, 0,  1, vsColHeaders.GetSize());
		SetupRowsCols(1, 0,  nRows, vsColHeaders.GetSize());
		///------ End AVOID_RESET_ROWS
		m_flx.ExplorerBar = flexExSortShow;
		
		// setup column header
		for( int ii = 0; ii < vsColHeaders.GetSize(); ii++ )
		{
			SetColHeading(ii, vsColHeaders[ii]);
		}
		
		return true;
	}
	
	/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER	
	//void UpdatePageView(const PageViewOptions& stViewOptions)
	void UpdatePageView(const PageViewOptions& stViewOptions, QueryResult *pQR)
	/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
	{
		//SetReady(false);
		///------ Tony 07/20/2012 ORG-6167-P1 AVOID_RESET_ROWS
		//	setupColHeader(stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph); // need remove Cell Location column if Show Embedded Graph is unchecked
		setupColHeader(stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph, pQR->Size() + 1);
		///------ End AVOID_RESET_ROWS
		/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
		//updatePageView(stViewOptions);
		updatePageView(stViewOptions, pQR);
		/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
		
		SetReady(true);
	}
	
	int GetSelectedPages(vector<string>& vsPages, bool bRecursive = false, vector<int>* pvDisplayID = NULL)
	{
		vsPages.RemoveAll();
		
		vector<uint> 	vuSelRows;
		GetSelRows(vuSelRows);		
		if(vuSelRows.GetSize() < 1)
			return 0;		

		for(int ii = 0; ii < vuSelRows.GetSize(); ii++)
		{
			vsPages.Add( GetCell(vuSelRows[ii], LIST_SHORT_NAME_COL) );
		}
		
		return vsPages.GetSize();
	}
	
	///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
	void ClearBold()
	{
		int nRows = GetRows();
		for(int ii = GetRowOffset(); ii < nRows; ii++)
			SetBold(ii, -1, false);
	}
	
	void SetBold(vector<string>& vsPages)
	{
		int nPages = vsPages.GetSize();
		int nRows = GetRows();
		for(int ii = 0; ii < nPages; ii++)
		{
			for(int ij = GetRowOffset(); ij < nRows; ij++)
			{
				string strSName = GetCell(ij, LIST_SHORT_NAME_COL);
				if(0 == strSName.Compare(vsPages[ii]))
					SetBold(ij, -1, true);
			}
		}
	}
	///end HIGHLIGHT_ADDED_GRAPHS

	BOOL	CheckShowContextMenu(int nx, int ny)
	{
		int		nRow, nCol;
		GetMouseCell(nRow, nCol);
		if ( 0 != nRow )
			return FALSE;

		vector<byte>	vbHide;
		GetHiddenCols(vbHide);
		
		vector<string>	vsColHeading;
		GetRowValues(0, vsColHeading);

		vector<bool>	vbDisabled(vbHide.GetSize());
		vbDisabled[0] = 1;
		
		CheckMenu		menu(!vbHide, vsColHeading, vbDisabled);
		int nCmd = menu.DoTrackPopup(nx, ny, GetDlgSafeHwnd());
		if ( nCmd < 0 )
			return FALSE;

		/// we assume that nCmd is exactly match column hedaers with 0 offset
		if ( nCmd >= vbHide.GetSize() )
		{
			ASSERT(false);
			return FALSE;
		}

		vbHide[nCmd] = !vbHide[nCmd];
		SetHiddenCols(vbHide);

		return TRUE;
	}

private:
	/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
	
	// The logic of: Set specified folder as root folder and filter pages by filter function are removed,\
	since they are not used up to now. The other logic is kept but run in the new code.
	
	/*
	void updatePageView(const PageViewOptions& stViewOptions, LPCSTR lpcszPage = "")
	{
		ClearAll();		

		// get the specified folder by options
		Folder fld = Project.RootFolder;		
		if( !stViewOptions.bShowFolders )											//?
		{		
			Folder fldStart(stViewOptions.strStartPath);
			if( fldStart )
				fld = fldStart;
		}
		
		// get graph pages from specified folder
		vector<string> vsGraphs;
		get_folder_pages_name(fld, vsGraphs, EXIST_PLOT, true);			
		
	 	// filter pages by filter function
		vector<string> vsNames, vsLongNames, vsCells, vsPath;
		for(int ii = 0; ii < vsGraphs.GetSize(); ii++)
		{
			Page pg( vsGraphs[ii] );
			if( !_filter_page_by_filter_func(stViewOptions.strFilterFuncName, pg) && stViewOptions.nPageType == pg.GetType() )
			{
				vsNames.Add( pg.GetName() );
				vsLongNames.Add( pg.GetLongName() );
				vsPath.Add( pg.GetFolder().GetPath() );			/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
				vsCells.Add( "" );
			}
		}
			
		// add graph pages that embedded in worksheet
		if( stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph )
		{
			vector<string> vsWks;
			get_folder_pages_name(fld, vsWks, EXIST_WKS, true);
			
			for(ii = 0; ii < vsWks.GetSize(); ii++)
			{
				WorksheetPage wksPage( vsWks[ii] );
				ASSERT( wksPage );
				
				if( wksPage )
				{
					foreach(Layer lay in wksPage.Layers)
					{
						Worksheet wks(lay);
						ASSERT(wks);						
						
						vector<string> vsEmbededs;
						wks.GetEmbeddedGraphs(vsEmbededs, GRAPH_IN_WKS_EXCLUDE_BITS);
						for( int nn = 0; nn < vsEmbededs.GetSize(); nn++ )
						{
							GraphPage gp(vsEmbededs[nn]);

							if( _filter_page_by_filter_func(stViewOptions.strFilterFuncName, gp) || stViewOptions.nPageType != gp.GetType())
								continue;
							
							vsNames.Add( gp.GetName() );
							vsLongNames.Add( gp.GetLongName() );
							vsPath.Add( gp.GetFolder().GetPath() );			/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
							vsCells.Add(  _get_embedded_graph_cell_location( gp.GetName() ) );
						}
						

					}
				}
			}
		}
		
		// sort pages if needed
		if( stViewOptions.stProjectTreeOptions.bSortPages )
		{
			vector<uint> 	vnIndeces;
			vsNames.Sort(SORT_ASCENDING, true, vnIndeces);
			
			vsLongNames.Reorder( vnIndeces );
			vsPath.Reorder( vnIndeces );	/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
			vsCells.Reorder( vnIndeces );
			
		}

		int nSelRow = GetSelectedRow();
		SetColValues(LIST_SHORT_NAME_COL, vsNames, 0, true);
		SetColValues(LIST_LONG_NAME_COL, vsLongNames, 0, true);	
		SetColValues(LIST_PATH_COL, vsPath, 0, true);		/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
		SetColValues(LIST_CELL_LOCATION_COL, vsCells, 0, true);
		if( -1 == nSelRow && lpcszPage && 0 != lstrlen(lpcszPage) )		
		{
			nSelRow = vsNames.Find(lpcszPage) + 1; // add 1 since the first row is column header			
		}
		SelRow(nSelRow);

		ResizeCols();
	}
	*/
	void updatePageView(const PageViewOptions& stViewOptions, QueryResult *pQR)
	{
		if (NULL == pQR)
			return;
		//ClearAll();		///------ Tony 07/20/2012 ORG-6167-P1 AVOID_RESET_ROWS
		//SetRows(pQR->Size());		///------ Tony 09/07/2012 ORG-5608-P1 REMOVE_ACTIVE_GRAPH_PAGE
		
		vector<string> vsSNames, vsLNames, vsFolders, vsCellLocations;
		
		pQR->GetNames(vsSNames, QUERYRESULTNAME_SNAME);
		pQR->GetNames(vsLNames, QUERYRESULTNAME_LNAME);
		
		///------ Tony 09/07/2012 ORG-5608-P1 REMOVE_ACTIVE_GRAPH_PAGE
		if(!m_bMultiplePages) ///Philip 09/11/2012 ORG-6619-P6 SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
		{
			///Philip 09/14/2012 ORG-5608-P3 REMOVE_LONGNAME_FAIL_WHEN_REMOVE_ACTIVE_PAGE
			//_remove_active_page(vsSNames);
			//_remove_active_page(vsLNames);
			int index = -1;
			_remove_active_page(vsSNames, &index);
			if(-1 != index)
				vsLNames.RemoveAt(index);
			///end REMOVE_LONGNAME_FAIL_WHEN_REMOVE_ACTIVE_PAGE
		}
		
		int nSize = vsSNames.GetSize();
		SetRows(nSize);
		///------ End REMOVE_ACTIVE_GRAPH_PAGE
		
		///Philip 08/27/2012 ORG-6619-P4 FIX_PATHS_OUT_OF_ORDER
		//pQR->GetNames(vsFolders, QUERYRESULTNAME_FOLDER);
		int ii;
		for(ii = 0; ii < nSize; ii++)
		{
			string strPath = _get_full_path_from_page_name(vsSNames[ii]);
			vsFolders.Add(strPath);
		}
		///end FIX_PATHS_OUT_OF_ORDER
		
		GetCellLocationFromGraphNames(vsSNames, vsCellLocations);
		
		///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		vector<int> vnLayerNum, vnPlotNum;
		if(!_get_layer_plot_num_vec(vsSNames, vnLayerNum, vnPlotNum))
			ASSERT(false); // bad SName
		///end ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		
		// sort pages if needed
		if( stViewOptions.stProjectTreeOptions.bSortPages )
		{
			vector<uint> 	vnIndeces;
			vsSNames.Sort(SORT_ASCENDING, true, vnIndeces);
			
			vsLNames.Reorder( vnIndeces );
			vsFolders.Reorder( vnIndeces );
			vsCellLocations.Reorder( vnIndeces );
			///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
			vnLayerNum.Reorder( vnIndeces );
			vnPlotNum.Reorder( vnIndeces );
			///end ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		}
		
		/*set all null cells to non-null so that the texts in their left-adjacent cells
		  cannot overlay them when rescale the column header*/
		for(ii = 0; ii < nSize; ii++)
		{
			if(vsLNames[ii].IsEmpty())
				vsLNames[ii] = " ";
			if(vsCellLocations[ii].IsEmpty())
				vsCellLocations[ii] = " ";
		}
		
		SetColValues(LIST_SHORT_NAME_COL, vsSNames, 0, true);
		SetColValues(LIST_LONG_NAME_COL, vsLNames, 0, true);	
		SetColValues(LIST_PATH_COL, vsFolders, 0, true);
		SetColValues(LIST_CELL_LOCATION_COL, vsCellLocations, 0, true);
		
		///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		vector<string> vsLayerNum, vsPlotNum;
		convert_int_vector_to_string_vector(vnLayerNum, vsLayerNum);
		convert_int_vector_to_string_vector(vnPlotNum, vsPlotNum);
		///Philip 08/27/2012 ORG-6619-P3 FIX_COLUMN_MISSING_IN_LISTVIEW
		//int nOffset = bGetEmbed ? 0 : -1;
		//SetColValues(LIST_LAYERS_COL + nOffset, vsLayerNum, 0, true);
		//SetColValues(LIST_PLOTS_COL + nOffset,  vsPlotNum,  0, true);
		SetColValues(LIST_LAYERS_COL, vsLayerNum, 0, true);
		SetColValues(LIST_PLOTS_COL,  vsPlotNum,  0, true);
		///end FIX_COLUMN_MISSING_IN_LISTVIEW
		///end ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		
		///Philip 08/27/2012 ORG-6619-P3 FIX_COLUMN_MISSING_IN_LISTVIEW
		vector<byte> vbHideCols;
		GetHiddenCols(vbHideCols);
		vbHideCols[LIST_LONG_NAME_COL] = !stViewOptions.bLongNameShow;
		vbHideCols[LIST_CELL_LOCATION_COL] = !stViewOptions.bCellShow;
		SetHiddenCols(vbHideCols);
		///end FIX_COLUMN_MISSING_IN_LISTVIEW
		
		ResizeCols();
	}
	/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER

	void GetCellLocationFromGraphNames(vector <string> &vsGraphName, vector <string> &vsCellLocations)
	{
		int nSize = vsGraphName.GetSize();
		for (int nn = 0; nn < nSize; nn++)
		{
			vsCellLocations.Add(_get_embedded_graph_cell_location(vsGraphName[nn]));
		}
	}
	
private:
	bool				m_bMultiplePages; ///Philip 09/11/2012 ORG-6619-P6 SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
};
//end class ListView

///=====================================================================================================================
///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
//recovered classes: FolderView(v86: PEView), PageViewManager

//class PEView
class FolderView : public GridTreeControl
{
public:
	FolderView(bool bIsMultipleSelection = true) { m_bMultiplePages = bIsMultipleSelection; } ///Philip 09/11/2012 ORG-6619-P6 SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
	
	void InitControl(WndContainer& dlg, const PageViewOptions& stViewOptions, LPCSTR lpcszPage = "")
	{
		Init(IDC_FOLDER_TREE, dlg);	

		SetSelection(flexSelectionListBox);
		SetAllowSelection(stViewOptions.bMultiplePages);
		
		updatePageView(stViewOptions, lpcszPage);
	}	
	
	string GetFullPathFromPageName(LPCSTR lpcszPage)
	{
		PageBase pg = Project.Pages(lpcszPage);
		if( !pg )
			return "";
		
		string 	strPath;
		TreeNode tr = m_tree.FindNodeByAttribute(STR_LABEL_ATTRIB, lpcszPage);		
		if(tr)
			tr.GetAttribute(STR_PATH_ATTRIB, strPath);

		return strPath;		
	}
	
	bool UpdatePageView(const PageViewOptions& stViewOptions)
	{
		return updatePageView(stViewOptions);
	}
	
	/// Iris 7/17/2009 QA80-13966-P2 NEED_DISABLE_OK_BUTTON_IF_SEL_FOLDER_IN_PEVIEW_OR_WORKBOOK
	// to check selected row, return true if is specified page type ( == stViewOptions.nPageType), else return false.
	bool IsSpecifiedPageTypeSelected(int nPageType)
	{
		if( IsFolderSelected() ) // if selected folder or workbook including embedded pages
			return false;		
		
		int nSel = GetSelectedRow(); 
		if( nSel < 0 ) // no selection
			return false;
		
		TreeNode tr = tree_get_node(m_tree, nSel);
		if(tr.IsValid())
		{
			int 	nDisplay = -1;
			if( tr.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay) && nDisplay == get_page_display_id(nPageType) )
				return true;				
		}
		
		return false;		
	}
	///end NEED_DISABLE_OK_BUTTON_IF_SEL_FOLDER_IN_PEVIEW_OR_WORKBOOK
	
	bool IsFolderSelected(bool* pbMulti = NULL)
	{
		bool bFolder = false, bMulti = false;
		vector<uint> vnSelRows;
		GetSelRows(vnSelRows);
	
		int nClickRow, nClickCol;
		GetMouseCell(nClickRow, nClickCol);
		if(0 <= nClickRow)
		{
			vector<uint> vecIndex;
			vnSelRows.Find(vecIndex, nClickRow);
			if(!vecIndex.GetSize())
			{
				SelRow(nClickRow);
				bMulti = false;
			}
			else
			{
				nClickRow = vnSelRows[0];
				/// Kenny 09/08/2009 IMPROVE_SHOW_HIDE_CONTEXT_MENU
				bMulti = vnSelRows.GetSize() > 1;
				/// End IMPROVE_SHOW_HIDE_CONTEXT_MENU
			}
		}
		
		TreeNode tr = tree_get_node(m_tree, nClickRow);
		if(tr.IsValid())
			bFolder = tr.GetNodeCount() > 0;
		
		if( pbMulti )
			*pbMulti = bMulti;
		return bFolder;
	}
	
	int GetSelectedPages(vector<string>& vsPages, bool bRecursive = false, vector<int>* pvDisplayID = NULL)
	{
		vsPages.RemoveAll();
		
		vector<uint> 	vnSelRows;
		GetSelRows(vnSelRows);
		if(vnSelRows.GetSize() < 1)
			return 0;
		
		vector<int> 	vnDisplayIDs;
		for(int ii = 0; ii < vnSelRows.GetSize(); ii++)
		{
			int 		nSelRow = vnSelRows[ii];
			TreeNode 	trSel = tree_get_node(m_tree, nSelRow);
			
			vector<string> 	vs;
			vector<int>		vn;
			getGraphsInProjectTree(trSel, vs, vn, bRecursive);
			for(int nn = 0; nn < vs.GetSize(); nn++)
			{
				if(vsPages.Find(vs[nn]) < 0) 				
				{
					vsPages.Add(vs[nn]);
					vnDisplayIDs.Add(vn[nn]);
				}
			}
		}
		if(NULL != pvDisplayID)
			*pvDisplayID = vnDisplayIDs;
		
		return vsPages.GetSize();
	}
	
	///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
	void ClearBold()
	{
		for(int ii = GetRowOffset(); ; ii++)
		{
			TreeNode trRow = tree_get_node(m_tree, ii);
			if(!trRow.IsValid())
				break;
			SetBold(ii, -1, false);
		}
	}
	
	void SetBold(vector<string>& vsPages)
	{
		int nPages = vsPages.GetSize();
		for(int ii = 0; ii < nPages; ii++)
		{
			for(int ij = 0; ; ij++)
			{
				TreeNode trRow = tree_get_node(m_tree, ij);
				if(!trRow.IsValid())
					break;
				
				string strSName;
				trRow.GetAttribute(STR_LABEL_ATTRIB, strSName);
				if(0 == strSName.Compare(vsPages[ii]))
					SetBold(ij, -1, true);
			}
		}
	}
	///end HIGHLIGHT_ADDED_GRAPHS
	
	void ShowMoreInfo(bool bLongName = false, bool bCell = false)
	{
		for(int nRow = 0; ; nRow++)
		{
			TreeNode trRow = tree_get_node(m_tree, nRow);
			if(!trRow.IsValid())
				break;
			
			int nDisplay, nLevel;
			trRow.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay);
			trRow.GetAttribute(STR_STOP_ATTRIB, nLevel);
			if(PTL_PAGE != nLevel)//LName is for page only
				continue;
			
			string strLabel, strSName, strLName, strCell;
			trRow.GetAttribute(STR_LABEL_ATTRIB, strSName);
			strLabel = strSName;
			
			if(bLongName)
			{
				trRow.GetAttribute(STR_NAME_ATTRIB, strLName);
				if( !strLName.IsEmpty() )
					strLabel += " - " + strLName;
			}
			
			if(bCell && nDisplay == IDR_GRAPHTYPE_V8)//bCell is for Embedded GraphPage only
			{
				strCell = _get_embedded_graph_cell_location(strSName);
				if( !strCell.IsEmpty() )
					strLabel += " - " + strCell;
			}
			
			trRow.SetAttribute(STR_DISPLAY_NAME_ATTRB, strLabel);
			SetCell(nRow, 0, strLabel);
		}
	}
	
	///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	void SpecifyPaths2BShown(const vector<string>& vsSpecPath)
	{
		m_vsSpecPaths.RemoveAll();
		m_vsSpecPaths = vsSpecPath;
	}
	
	void ClearSpecifiedPaths()
	{
		m_vsSpecPaths.RemoveAll();
	}
	///end RECOVER_FOLDER_VIEW
	
private:	
	bool updatePageView(const PageViewOptions& stViewOptions, LPCSTR lpcszPage = "")
	{
		ClearAll();
		m_tree.Reset();
		
		string 		strStartPathTemp = stViewOptions.bShowFolders ? "" : stViewOptions.strStartPath;
		/// Iris 5/04/2009 QA80-13552 SUPPORT_OPTION_TO_SORT_PAGE_LIST_AND_FILTER_3D_PAGE
		ProjectTreeOptions stTempOptions;
		stTempOptions = stViewOptions.stProjectTreeOptions;
		
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT			
		Folder fld = Project.RootFolder;
		if(!strStartPathTemp.IsEmpty())
		{
			Folder rtFolder(strStartPathTemp);
			if( rtFolder.IsValid() )
				fld.Attach(strStartPathTemp);
		}
		
		vector<string> 	vsGraphs;
		get_folder_pages_name(fld, vsGraphs, EXIST_PLOT, true);
		if(!m_bMultiplePages) ///Philip 09/11/2012 ORG-6619-P6 SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
			_remove_active_page(vsGraphs);		///------ Tony 09/07/2012 ORG-5608-P1 REMOVE_ACTIVE_GRAPH_PAGE
		
		if( stTempOptions.bGetEmbeddedGraph )
		{
			vector<string> vsEmbeddedGraphs;
			get_folder_embedded_graphs(fld, vsEmbeddedGraphs, true);
			vsGraphs.Append(vsEmbeddedGraphs);
		}		
				
		vector<string>	vsFilterPages;
		for(int nn = 0; nn < vsGraphs.GetSize(); nn++)
		{
			Page pg( vsGraphs[nn] );
			if( !pg || pg && _filter_page_by_filter_func(stViewOptions.strFilterFuncName, pg) )
				vsFilterPages.Add( vsGraphs[nn] );
		}		
		if( 0 != vsFilterPages.GetSize() )
			stTempOptions.vsExcludePages = vsFilterPages;
		///end FILTER_GRAPH_FUNCTION_SUPPORT
		
		bool flag = get_project_tree(m_tree, PTL_PAGE, stViewOptions.nPageType, 0, strStartPathTemp, stTempOptions);
		///end SUPPORT_OPTION_TO_SORT_PAGE_LIST_AND_FILTER_3D_PAGE		
		if(!m_bMultiplePages) ///Philip 09/11/2012 ORG-6619-P6 SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
			_remove_active_page(m_tree.project);		///------ Tony 09/07/2012 ORG-5608-P1 REMOVE_ACTIVE_GRAPH_PAGE
		
		///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		if(m_vsSpecPaths.GetSize() > 0)
		{//show specified paths only
			tree_set_attribute_to_all_nodes(m_tree, STR_SHOW_ATTRIB, "0");
			
			for(int ii = 0; ii < m_vsSpecPaths.GetSize(); ii++)
			{
				TreeNode tnCurr = m_tree.FindNodeByAttribute(STR_PATH_ATTRIB, m_vsSpecPaths[ii]);
				if(!tnCurr) continue;
				tnCurr.Show = TRUE;
				tree_set_attribute_to_all_nodes(tnCurr, STR_SHOW_ATTRIB, "1");
				
				TreeNode tnParent = tnCurr.Parent();
				while(tnParent)
				{
					tnParent.Show = TRUE;
					tnParent = tnParent.Parent();
				}
			}
			
			tree_remove_children_by_attrib(m_tree, STR_SHOW_ATTRIB, FALSE);
			m_vsSpecPaths.RemoveAll();
		}
		///end RECOVER_FOLDER_VIEW
		
		flag = AddTreeNodes(m_tree, ATRN_LOOP_MARDED_NODE_ONLY, STR_DISPLAY_ATTRIB);
		ShowMoreInfo(stViewOptions.bLongNameShow, stViewOptions.bCellShow);
		
		int nRow;
		if(stViewOptions.bShowFolders)
		{
			TreeNode tr = m_tree;
			string str;
			m_tree.GetAttribute(STR_PATH_ATTRIB, str);
			if(stViewOptions.strStartPath.CompareNoCase(str))
				tr = m_tree.FindNodeByAttribute(STR_PATH_ATTRIB, stViewOptions.strStartPath);
			
			///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
			//for( ; tr.FirstNode.IsValid(); tr = tr.FirstNode)
			for( ; tr.IsValid() && tr.FirstNode.IsValid(); tr = tr.FirstNode)
			///end RECOVER_FOLDER_VIEW
				;
			string strLabel;
			if(tr.IsValid())
				tr.GetAttribute(STR_DISPLAY_NAME_ATTRB, strLabel);
			nRow = FindRow(strLabel);
		}
		
		//select row by page name since switch Folder view with List view need to keep current page selection
		if( lpcszPage && 0 != lstrlen(lpcszPage) ) 
		{
			TreeNode 	tr = m_tree.FindNodeByAttribute(STR_LABEL_ATTRIB, lpcszPage);
			string 		strLabel;
			if(tr)
				tr.GetAttribute(STR_DISPLAY_NAME_ATTRB, strLabel);
			nRow = FindRow(strLabel);
		}
		
		SelRow(nRow);
		return true;///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	}

	bool getGraphsInProjectTree(TreeNode tr, vector<string>& vsPages, vector<int>& vnDisplayIDs, bool bRecursive = false)
	{
		if(!tr.IsValid())
			return false;
		
		int nLevel;
		if(tr.GetNodeCount() < 1 && tr.GetAttribute(STR_STOP_ATTRIB, nLevel) && PTL_FOLDER < nLevel)//leaf
		{
			string 	strName;
			tr.GetAttribute(STR_LABEL_ATTRIB, strName);			
			
			/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
			vsPages.Add(strName);
			int 	nDisplay = -1;
			tr.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay);
			vnDisplayIDs.Add(nDisplay);	
			/*
			Page pg(strName);
			if( pg && !_filter_page_by_filter_func(m_strFilterFuncName, pg) )
			{		
				vsPages.Add(strName);
				
				int 	nDisplay = -1;
				tr.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay);
				vnDisplayIDs.Add(nDisplay);	
			}
			*/
			///end FILTER_GRAPH_FUNCTION_SUPPORT
		}
		
		foreach(TreeNode cNode in tr.Children)
		{
			bool bRecusiveSubNode = bRecursive;
			
			int nDisplay;
			if(cNode.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay) && 
				( nDisplay == get_page_display_id(EXIST_WKS) ||
				nDisplay == get_layer_display_id(EXIST_WKS) )
				)//only check workbook
				bRecusiveSubNode = true;
			
			if(!cNode.IsValid() || (cNode.GetNodeCount() && !bRecusiveSubNode) )
				continue;
			
			getGraphsInProjectTree(cNode, vsPages, vnDisplayIDs, bRecusiveSubNode);
		}
		return true;
	}

	
private:
	Tree				m_tree;
	string				m_strFilterFuncName;
	vector<string>		m_vsSpecPaths;
	bool				m_bMultiplePages; ///Philip 09/11/2012 ORG-6619-P6 SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
};
//end class FolderView


class PageViewManager
{
public:
	PageViewManager()
	{
		m_nMode = -1;
		m_strSelectedPage = "";
		m_pFolderView = NULL;
		m_pListView = NULL;
	}
	
	///------ Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
	~PageViewManager()
	{
		if ( NULL != m_pFolderView )
			delete m_pFolderView;
		else if ( NULL != m_pListView )
			delete m_pListView;
	}
	///------ End PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
	
	void SetReady()
	{
		if( m_pFolderView )
			m_pFolderView->SetReady();
		if( m_pListView )
			m_pListView->SetReady();
	}
	
	void SetViewMode(int nMode)
	{
		if( m_pFolderView || m_pListView )
			m_strSelectedPage = GetSelectedPage(); // remeber the curremt page selection before mode change
		m_nMode = nMode;
	}
	
	int GetViewMode()
	{
		return m_nMode;
	}
	void SetEmbeddedShow(bool bShow = true)
	{
		m_stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph = bShow;
	}
	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	void SetIncludeShortcut(bool bShow = true)
	{
		DWORD dwTemp = m_stViewOptions.stProjectTreeOptions.dwCtrl | PT_CTRL_INCLUDE_SHORTCUT;
		if(!bShow)
			dwTemp &= ~PT_CTRL_INCLUDE_SHORTCUT;
		m_stViewOptions.stProjectTreeOptions.dwCtrl = dwTemp;
	}
	///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	bool UpdatePageView(PagePreviewListDlg& dlg)
	{
		if( VIEW_MODE_LIST == m_nMode )
		{
			ASSERT(m_pListView);
			///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
			//m_pListView->UpdatePageView(m_stViewOptions);
			return dlg.UpdateListView();
			///end RECOVER_FOLDER_VIEW
		}
		else
		{
			ASSERT(m_pFolderView);
			///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
			//m_pFolderView->UpdatePageView(m_stViewOptions);
			return dlg.UpdateFolderView();
			///end RECOVER_FOLDER_VIEW
		}
	}
	
	///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	void InitControl(PagePreviewListDlg& dlg, PageViewOptions& stViewOptions)
	{
		m_stViewOptions = stViewOptions;
		
		if( VIEW_MODE_FOLDER == m_nMode )
		{
			dlg.InitFolderView(stViewOptions);
		}
		
		if( VIEW_MODE_LIST == m_nMode )
		{
			dlg.InitListView(stViewOptions);
		}
	}
	///end RECOVER_FOLDER_VIEW
	
	string GetSelectedPage()
	{
		vector<string> vs;
		if( GetSelectedPages(vs) <= 0 )
			return "";
		return vs[0]; //return the first selected
	}
	
	int	GetSelectedPages(vector<string>& vsPages, bool bRecursive = false, vector<int>* pvDisplayID = NULL)
	{
		if( VIEW_MODE_LIST == m_nMode )
		{
			ASSERT(m_pListView);
			return m_pListView->GetSelectedPages(vsPages, bRecursive, pvDisplayID);
		}
		else
		{
			ASSERT(m_pFolderView);
			return m_pFolderView->GetSelectedPages(vsPages, bRecursive, pvDisplayID);
		}
	}
	
	///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
	void ClearBold()
	{
		if( VIEW_MODE_LIST == m_nMode )
		{
			ASSERT(m_pListView);
			m_pListView->ClearBold();
		}
		else
		{
			ASSERT(m_pFolderView);
			m_pFolderView->ClearBold();
		}
	}
	
	void SetBold(vector<string>& vsPages)
	{
		if(!vsPages)
			return;
		if( VIEW_MODE_LIST == m_nMode )
		{
			ASSERT(m_pListView);
			m_pListView->SetBold(vsPages);
		}
		else
		{
			ASSERT(m_pFolderView);
			m_pFolderView->SetBold(vsPages);
		}
	}
	///end HIGHLIGHT_ADDED_GRAPHS
	
	void CreateListView()
	{
		if(m_pListView)
			return;
		if(m_pFolderView)
		{
			delete m_pFolderView;
			m_pFolderView = NULL;
		}
		///Philip 09/11/2012 ORG-6619-P6 SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
		//m_pListView = new ListView();
		m_pListView = new ListView(m_stViewOptions.bMultiplePages);
		///end SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
	}
	
	void CreateFolderView()
	{
		if(m_pFolderView)
			return;
		if(m_pListView)
		{
			delete m_pListView;
			m_pListView = NULL;
		}
		///Philip 09/11/2012 ORG-6619-P6 SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
		//m_pFolderView = new FolderView();
		m_pFolderView = new FolderView(m_stViewOptions.bMultiplePages);
		///end SHOULD_SHOW_ACTIVE_GRAPH_IN_MULTISELECTION_MODE
	}
	
	FolderView* 	GetFolderViewPointer()
	{
		//ASSERT(m_pFolderView);
		return m_pFolderView;
	}
	
	ListView*	GetListViewPointer()
	{
		//ASSERT(m_pListView);
		return m_pListView;
	}
	
private:
	int				m_nMode;
	string			m_strSelectedPage;
	FolderView*		m_pFolderView;
	ListView*		m_pListView;
	PageViewOptions m_stViewOptions;
};
//end class PageViewManager
///end RECOVER_FOLDER_VIEW



///////////////////////////// PagePreviewListDlg ////////////////////////////////

enum
{
	LIST_SETTING_SHOW_LN			= 0,
	LIST_SETTING_SHOW_CELL_INFO,
		
	LIST_SETTING_TOTAL,
};

/// Zech 03/31/2012 ORG-4284-P3 DO_NOT_SHOW_SPARKLINE_IN_GRAPH_BROWSER
///------ Folger 05/18/2012 ORG-5738 ADVANCED_QUERY_RESULT_OC_FILTER_FUNCTION_SUPPORT
//BOOL IsGraphNotSparkline(OriginObject& obj)
BOOL IsGraphNotSparkline(OriginObject& obj, QUERYRESULTS_FILTER_ELEMENTTYPE nType)
///------ End ADVANCED_QUERY_RESULT_OC_FILTER_FUNCTION_SUPPORT
{
	///------ Folger 05/18/2012 ORG-5738 ADVANCED_QUERY_RESULT_OC_FILTER_FUNCTION_SUPPORT
	if ( QUERYRESULTS_FILTER_ELEMENTTYPE__PAGE != nType )
		return TRUE;
	///------ End ADVANCED_QUERY_RESULT_OC_FILTER_FUNCTION_SUPPORT
	
	GraphPage gp;
	gp = (GraphPage)obj;
	
	return is_page_not_sparkline(gp);
}
/// END DO_NOT_SHOW_SPARKLINE_IN_GRAPH_BROWSER

class PagePreviewListDlg : public MultiPaneDlg
{
public:	
	PagePreviewListDlg(const vector<int>& nPageTypes, LPCSTR lpcszPages = NULL, 
			LPCSTR  lpcszTitle = NULL, 
			LPCSTR  lpcszStartPath = NULL, //if bShowFolders is true, then activise this folder; false, then just show this folder
			DWORD dwCtrl = SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED,
			int nPageType = EXIST_GRAPH,	
			LPCSTR lpcszFilterFuncName = NULL 
			) : MultiPaneDlg(IDD_PG_DLG, "ODlg8", !(dwCtrl & SELECT_MULTIPLE_PAGES))
	{
		m_vnPageTypes = nPageTypes;		
		m_strFilterFuncName = lpcszFilterFuncName;
		string strPages(lpcszPages);

		if( !strPages.IsEmpty() )
		{
			strPages.GetTokens(m_vsPageList, STR_PAGE_LIST_SEPARATOR);
		}
#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		m_strDiff.SetTokens(m_vsPageList);
#endif		
		m_strDlgTitle = lpcszTitle;
		if(m_strDlgTitle.IsEmpty())
			m_strDlgTitle = _L(STR_DLG_NAME);
		
		m_strStartPath = lpcszStartPath;	
		m_bMultiplePages = dwCtrl & SELECT_MULTIPLE_PAGES;
		m_bShowFolders = dwCtrl & SHOW_FOLDERS;
		m_bEnableEmbed = dwCtrl & ENABLE_EMBEDED;

		m_bSortPages = dwCtrl & SORT_PAGE;
		m_bFilter3DGraph = dwCtrl & FILTER_3D_GRAPH;
		m_bAllowRemoveAll = dwCtrl & CAN_REMOVE_ALL;	///Jasmine 05/11/2012 ORG-4971-S2 ALLOW_REMOVE_ALL_LINKED_GRAPHS
			
		m_nPageType = nPageType;
		m_bIncludeShortcut = false;	
		
		PageViewOptions stPageOptions;
		getPageOptions(stPageOptions, true);
		SetPreviewOnRight(!m_bMultiplePages);
		
		m_strRegisterName = m_bMultiplePages ? STR_DLG_NAME_S : STR_DLG_NAME;
		
		m_vsColTypes.Add(QUERYRESULTNAME_SNAME);
		m_vsColTypes.Add(QUERYRESULTNAME_LNAME);
		m_vsColTypes.Add(QUERYRESULTNAME_FOLDER);

		/// Zech 12/12/2011 CLEAN_UP_QUERYRESULTEX
		/*
		m_arrQuery.SetAsOwner(true);
		QueryResultSimple *pQRSimple0 = new QueryResultSimple("SELECT GRAPH FROM PROJECT RECURSIVE");
		m_arrQuery.Add(*pQRSimple0);
		QueryResultSimple *pQRSimple1 =  new QueryResultSimple("SELECT GRAPH FROM ACTIVEFOLDER RECURSIVE");
		m_arrQuery.Add(*pQRSimple1);
		QueryResultSpecific *pQRSpecific = new QueryResultSpecific("GetQueryStringForSelFolder", "Originlab\\PagePreviewList.c", this);
		m_arrQuery.Add(*pQRSpecific);
		
		m_nLastComboSel = 0;
		*/
		/// END CLEAN_UP_QUERYRESULTEX
		
		m_pComboUsingFolder = NULL;
	}	
	
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		
		DWORD dwDlgOptions = 0;
		
		int nRet = DoModal(hWndParent, dwDlgOptions);
		///Jasmine 05/11/2012 ORG-4971-S2 ALLOW_REMOVE_ALL_LINKED_GRAPHS
		if(IDCANCEL == nRet && m_bCloseOnDBClick)
			nRet = IDOK;
		///End ALLOW_REMOVE_ALL_LINKED_GRAPHS
		
		m_vsPageList.RemoveAll();		
		
		if(nRet != IDCANCEL || m_bCloseOnDBClick)	
		{
			if(m_bMultiplePages)
				return getPages();	
			else
				m_vsPageList.Add(getSelectedPage());			
		}
		
		return nRet;
	}
	
	void getPageOptions(PageViewOptions& stPageOptions, bool bInit = false)
	{
		stPageOptions.nPageType = m_nPageType;
		stPageOptions.bMultiplePages = m_bMultiplePages;
		stPageOptions.bShowFolders = m_bShowFolders;
		stPageOptions.strStartPath = m_strStartPath;
		// if not filter function, the default view mode and show view mode checkbox
		stPageOptions.nViewMode = bInit ? VIEW_MODE_LIST : isFolderViewChecked(); ///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		stPageOptions.bViewModeControlShow = true;
		stPageOptions.strFilterFuncName = m_strFilterFuncName;
		stPageOptions.stProjectTreeOptions.bSortPages = m_bSortPages;
		stPageOptions.stProjectTreeOptions.bFilter3DGraph = m_bFilter3DGraph;
		
		stPageOptions.bLongNameShow = m_bLName;
		stPageOptions.bCellShow = m_bCell;
		stPageOptions.bEmbedControlEnable = m_bEnableEmbed;
		stPageOptions.stProjectTreeOptions.bGetEmbeddedGraph = m_bEmbed;///Philip 08/27/2012 ORG-6619-P3 FIX_COLUMN_MISSING_IN_LISTVIEW
		
		DWORD dwTemp = stPageOptions.stProjectTreeOptions.dwCtrl | PT_CTRL_INCLUDE_SHORTCUT;
		if(!m_bIncludeShortcut)
			dwTemp &= ~PT_CTRL_INCLUDE_SHORTCUT;
		stPageOptions.stProjectTreeOptions.dwCtrl = dwTemp;
		
		if( bInit && NULL != m_strFilterFuncName )
		{			
			bool bRet = _get_page_view_options_by_filter_func(stPageOptions);
			ASSERT( bRet );
			if( bRet )
			{
				m_nPageType = stPageOptions.nPageType;
				m_bMultiplePages = stPageOptions.bMultiplePages;
				m_bShowFolders = stPageOptions.bShowFolders;
				m_strStartPath = stPageOptions.strStartPath;
				m_bSortPages = stPageOptions.stProjectTreeOptions.bSortPages;
				m_bFilter3DGraph = stPageOptions.stProjectTreeOptions.bFilter3DGraph;
				
				m_bLName = stPageOptions.bLongNameShow;
				m_bCell = stPageOptions.bCellShow;
				m_bEnableEmbed = stPageOptions.bEmbedControlEnable;
				m_bEmbed = stPageOptions.stProjectTreeOptions.bGetEmbeddedGraph;
				
				m_bIncludeShortcut = (stPageOptions.stProjectTreeOptions.dwCtrl & PT_CTRL_INCLUDE_SHORTCUT);
			}
		}
	}
	
	///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	int GetFolderMode() // all, active, specified
	{
		if(m_pComboUsingFolder)
			return m_pComboUsingFolder->GetCurSel();
		else return -1;
	}
	
	void GetFolderBrowserStatus(FolderBrowserStatus& st)
	{
		st = m_stFB;
	}
	///end RECOVER_FOLDER_VIEW
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	ON_GETMINMAXINFO(OnMinMaxInfo) 
	
	ON_CONTEXTMENU(OnShowMenu)
	ON_BN_CLICKED(IDC_SHOW_EMBEDDED, OnShowEmbeddedGraph)

	/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
	ON_CBN_SELCHANGE( IDC_PG_AVAIL_DATA_COMBO_BOX, OnAvailDataComboChange )
	/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER

	/// Zech 12/12/2011 ORG-4284-S1 CHANGE_SPECIFIED_FOLDER_GUI_STYLE
	ON_BN_CLICKED(IDC_PG_SPECIFIED, OnSpecifiedFolder)
	/// Zech 12/12/2011 ORG-4284-S1 CHANGE_SPECIFIED_FOLDER_GUI_STYLE

	ON_BN_CLICKED(IDC_PG_SHORTCUT_CHECK, OnIncludeShortcut)
	ON_BN_CLICKED(IDC_PM_UP_DOWN, OnShowPreview)
	ON_BN_CLICKED(IDC_MG_ADD, OnAdd)

	ON_BN_CLICKED(IDC_MG_REMOVE, OnRemove)

	ON_BN_CLICKED(IDOK, OnOK)
	ON_BN_CLICKED(IDCANCEL, OnCancel)
	
	///Philip 08/14/2012 ORG-6430-S2 ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
	ON_BN_CLICKED(IDC_LOAD_LAST_USED, OnLoadLastUsed)
	///end ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
	
	///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	ON_BN_CLICKED(IDC_CHECK_FOLDER_VIEW, OnFolderViewClicked);
	///end RECOVER_FOLDER_VIEW
	
	ON_GRID_ROW_COL_CHANGE(IDC_MG_GRPAH_LIST, OnSelectionChange)
	
	ON_GRID_BEFORE_MOVE_ROWS(IDC_MG_GRPAH_LIST, OnBeforeMoveRows)
	ON_GRID_AFTER_MOVE_ROWS(IDC_MG_GRPAH_LIST, OnAfterMoveRows)

	ON_GRID_ROW_COL_CHANGE(IDC_FOLDER_TREE, OnSelectTreeNode)

	ON_GRID_CLICK(IDC_MG_GRPAH_LIST, OnSelectionChange)
	ON_GRID_CLICK(IDC_FOLDER_TREE, OnSelectTreeNode)

	ON_GRID_DBLCLICK(IDC_FOLDER_TREE, OnDblClickToSel)

	ON_INIT_SIZE(OnInitSize)
	ON_RESTORESIZE(OnRestoreSize)

	ON_HELPINFO(OnHelp)
	
EVENTS_END

//------------ Event Handlers ------------------------
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int	GetTotalHeight(bool bMin = false)
	int		GetMinClientTrackHeight()
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	{
		if( m_bMultiplePages && IsBottomPaneShown() )
		{
			RECT rSownBtn;
			GetClientRect(GetItem(IDC_PM_UP_DOWN), rSownBtn);
			return rSownBtn.bottom + PG_DLG_MIN_SIZE + 2*GetControlGap();
		}
		
		return PG_DLG_MIN_SIZE;
	}

	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int	GetTotalWidth(bool bMin = false)
	int		GetMinClientTrackWidth()
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	{
		int nCheckAndBtnsWidth, nCheckAndBtnsHeight;
		/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
		//uint nCheckAndBtns[]={IDC_SHOW_EMBEDDED, IDC_CHECK_LIST_VIEW, IDOK, IDCANCEL, IDC_PM_UP_DOWN, 0};
		uint nCheckAndBtns[]={IDC_SHOW_EMBEDDED, IDC_CHECK_FOLDER_VIEW/*Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW*/,
							  IDOK, IDCANCEL, IDC_PM_UP_DOWN, 0};
		/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
		GetGroupTotalSize(nCheckAndBtns, nCheckAndBtnsWidth, nCheckAndBtnsHeight, true, PG_DLG_GAP*2);//PG_DLG_GAP*2 for larger space
		
		int nTitleWidth;
		GetTextExtentSize(m_strDlgTitle, &nTitleWidth);
		
		int nMainPaneWidth = max(nCheckAndBtnsWidth, nTitleWidth);
		
		if(m_bMultiplePages)
		{
			return nMainPaneWidth + PG_DLG_MIN_SIZE;
		}
		else
		{
			if( IsBottomPaneShown() )
			{
				RECT rSownBtn;
				GetClientRect(GetItem(IDC_PM_UP_DOWN), rSownBtn);
				return rSownBtn.right + PG_DLG_MIN_SIZE + 2*GetControlGap();
			}
		
			return nMainPaneWidth;				
		}
	}

	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		nHelpID = IDD_GRAPH_BROWSER_DLG;
		return true;
	}

	BOOL OnInitDialog()
	{
		waitCursor 		junk;
		
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.SetSize(2);
		vstrTipsUpDown[0] = _L("Show Preview");
		vstrTipsUpDown[1] = _L("Hide Preview");

		MultiPaneDlg::OnInitDialog(IDC_FOLDER_TREE, IDC_PM_UP_DOWN, IDC_MG_PREVIEW, vstrTipsUpDown, m_strRegisterName);		
		
		Text = m_strDlgTitle;  //set dialog title	
		
		if(!lstrlen(m_strStartPath))
		{
			Folder fld = Project.ActiveFolder();
			m_strStartPath = fld.GetPath();
		}

		
		GetItem(IDOK).Enable = false;
		
		m_bLName = true;
		vector<byte>	vbSettings;
		if ( load_default_checkboxes(STR_DIALOG_NAME, vbSettings, STR_LIST_SETTINGS) )
		{
			m_bLName = vbSettings[LIST_SETTING_SHOW_LN];
			m_bCell = vbSettings[LIST_SETTING_SHOW_CELL_INFO];
		}

		///Philip 08/31/2012 ORG-6619-P5 IMPROVE_LISTVIEW_COLUMN_DISPLAY
		//PageViewOptions stPageOptions;
		//getPageOptions(stPageOptions, true);
		///end IMPROVE_LISTVIEW_COLUMN_DISPLAY
		
		Button chkShowEmbedded = GetItem(IDC_SHOW_EMBEDDED);
		chkShowEmbedded.Text = _L("Show Embedded Graph");			
		
		ResizeDialog::LoadCheckBoxSettings(STR_DLG_NAME, IDC_SHOW_EMBEDDED);

		if (!m_bEnableEmbed)
		{
			chkShowEmbedded.Check = false;
			chkShowEmbedded.Enable = false;
		}

		m_bEmbed = chkShowEmbedded.Check;
		///Philip 08/31/2012 ORG-6619-P5 IMPROVE_LISTVIEW_COLUMN_DISPLAY
		//stPageOptions.stProjectTreeOptions.bGetEmbeddedGraph = m_bEmbed; 
		///end IMPROVE_LISTVIEW_COLUMN_DISPLAY
		if (!m_bEmbed)
		{
			for (int ii=0; ii<m_vsPageList.GetSize(); ii++)
			{
				GraphPage gp(m_vsPageList[ii]);
				if (gp && gp.GetEmbeddingInfo())
				{
					m_bEmbed = chkShowEmbedded.Check = true;
					///Philip 08/31/2012 ORG-6619-P5 IMPROVE_LISTVIEW_COLUMN_DISPLAY
					//stPageOptions.stProjectTreeOptions.bGetEmbeddedGraph = m_bEmbed; 
					///end IMPROVE_LISTVIEW_COLUMN_DISPLAY
					break;
				}
			}
		}

		///Philip 08/31/2012 ORG-6619-P5 IMPROVE_LISTVIEW_COLUMN_DISPLAY
		PageViewOptions stPageOptions;
		getPageOptions(stPageOptions, true);
		///end IMPROVE_LISTVIEW_COLUMN_DISPLAY
		Button chkShortcut = GetItem(IDC_PG_SHORTCUT_CHECK);
		chkShortcut.Check = (stPageOptions.stProjectTreeOptions.dwCtrl & PT_CTRL_INCLUDE_SHORTCUT);
		
		///Philip 08/14/2012 ORG-6430-S2 ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
		Button btnLastUsed = GetItem(IDC_LOAD_LAST_USED);
		btnLastUsed.Visible = true;
		
		bool vis = btnLastUsed.Visible;
		
		m_vsLastUsedRecords.RemoveAll();
		string strValName;
		if(LoadSetting(STR_SAVE_LAST_USED_GRAPHS, strValName, STR_DLG_NAME))
			strValName.GetTokens(m_vsLastUsedRecords, CHAR_SAVE_TOKEN);
		
		m_bExistLURecord = (m_vsLastUsedRecords.GetSize() > 0);
		m_bOutdatedChecked = false;
		///end ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
		
		// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
		ComboBox ctrlCombo = GetItem(IDC_PG_AVAIL_DATA_COMBO_BOX);			
		m_pComboUsingFolder = new FolderContainer  (ctrlCombo);
		/// Zech 07/03/2012 ORG-4284-S5 GRAPH_BROWSER_REMEMBER_LAST_USED_LOCATION
		//ctrlCombo.SetCurSel(FOLDER_CONTAINER_ALL_FOLDER);
		/// EJP 2012-07-05 ORG-6138 INIT_FOLDER_COMBO_IN_GRAPH_BROWSER
		///	BOOL bSuccessLoad;
		///	int nCurSel = LoadSetting(STR_SAVE_USING_FOLDER, (DWORD)FOLDER_CONTAINER_ALL_FOLDER, STR_DLG_NAME, &bSuccessLoad);
		///	if (bSuccessLoad)
		///		ctrlCombo.SetCurSel(nCurSel);
		BOOL bSuccessLoad = FALSE;
		int nCurSel = LoadSetting(STR_SAVE_USING_FOLDER, (DWORD)FOLDER_CONTAINER_ALL_FOLDER, STR_DLG_NAME, &bSuccessLoad);
		if (!bSuccessLoad)
			nCurSel = FOLDER_CONTAINER_ALL_FOLDER;
		ctrlCombo.SetCurSel(nCurSel);
		/// end INIT_FOLDER_COMBO_IN_GRAPH_BROWSER

		string strSpecifiedFolders;
		if (LoadSetting(STR_SAVE_SPECIFIED_FOLDERS, strSpecifiedFolders, STR_DLG_NAME))
			strSpecifiedFolders.GetTokens(m_stFB.vsSelPaths, CHAR_SAVE_TOKEN);
		/// END GRAPH_BROWSER_REMEMBER_LAST_USED_LOCATION
		/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER

		// Make the combo visible, it is invisible by default		
		ctrlCombo.Visible = true;

		Control ctrlPre = GetItem(IDC_MG_PREVIEW);
	    m_pcPrev.CreateControl(ctrlPre.GetSafeHwnd());
	    
	    ///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		//InitListView(*this, stPageOptions);
		Button btnViewMode = GetItem(IDC_CHECK_FOLDER_VIEW);
		if( btnViewMode )
		{
			btnViewMode.Visible = stPageOptions.bViewModeControlShow;
			btnViewMode.Check = (VIEW_MODE_FOLDER == stPageOptions.nViewMode) ? TRUE : FALSE;
			btnViewMode.Text = _L("Folder View");			
		}
		
		m_PageView.SetViewMode(stPageOptions.nViewMode);
		m_PageView.InitControl(*this, stPageOptions);
		///end RECOVER_FOLDER_VIEW

		Tree tr;
		initGraphsList(tr); // init controls

		if(!m_bMultiplePages)
		{
			Button btAdd = GetItem(IDC_MG_ADD);
			Button btRemove = GetItem(IDC_MG_REMOVE);
			btAdd.Visible = false;
			btRemove.Visible = false;			
		}	
		
		m_bCloseOnDBClick = false;	

		/// Zech 12/12/2011 ORG-4284-S1 CHANGE_SPECIFIED_FOLDER_GUI_STYLE
		UpdatePathControls();
		/// END CHANGE_SPECIFIED_FOLDER_GUI_STYLE

		///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
		highlightAddedPages();
		///end HIGHLIGHT_ADDED_GRAPHS
		return true;
	}	
	
	
	BOOL	OnDestroy()
	{
		/// Zech 07/03/2012 ORG-4284-S5 GRAPH_BROWSER_REMEMBER_LAST_USED_LOCATION
		int nCurSel = m_pComboUsingFolder->GetCurSel();
		SaveSetting(STR_SAVE_USING_FOLDER, nCurSel, STR_DLG_NAME);
		string strSpecifiedFolders;
		strSpecifiedFolders.SetTokens(m_stFB.vsSelPaths, CHAR_SAVE_TOKEN);
		SaveSetting(STR_SAVE_SPECIFIED_FOLDERS, strSpecifiedFolders, STR_DLG_NAME);
		/// END GRAPH_BROWSER_REMEMBER_LAST_USED_LOCATION
		
		MultiPaneDlg::OnDestroy();
		
		checkUpdateListSettings();

		vector<byte>	vbSettings(LIST_SETTING_TOTAL);
		vbSettings[LIST_SETTING_SHOW_LN] = m_bLName;
		vbSettings[LIST_SETTING_SHOW_CELL_INFO] = m_bCell;
		save_default_checkboxes(STR_DIALOG_NAME, vbSettings, STR_LIST_SETTINGS);

		return TRUE;
	}
	
	BOOL OnReady()
	{
	    UpdateDlgShow();
		SetInitReady();				
		
		m_PageView.GetListViewPointer()->SetReady();///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		
		m_list.SetReady();	
		if(getPages() && m_bMultiplePages)
			m_list.SelRow(m_list.GetRowOffset());
		
		return TRUE;
	}
	
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
		MoveControlsHelper	_temp(this);		

		uint nButtonIDs[] = {IDCANCEL, IDOK, 0};
		
		MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false);
		
		if( !IsBottomPaneShown() )
		{
			Control ctrl = GetItem(IDC_MG_PREVIEW);
			ctrl.Visible = false;
		}		
		
		resizeControls(cx);
		return TRUE;
	}

	BOOL OnInitSize(int &left, int &top, int &right, int  &bottom)
	{
		return FALSE;
	}

	BOOL OnRestoreSize(ODWP dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
		
		lstrcpyn(pSz->szDialogName, m_strRegisterName, MAXLINE);
	
		pSz->top = -1;
		pSz->left = -1;
	
		/// Zech 04/01/2012 ORG-4284-S4 ENLARGE_GRAPH_BROWSER_DEFAULT_HEIGHT_AND_WIDTH
		//pSz->width = 680;  //hard code, will change later
		
		//pSz->height = 500;  //hard code, will change later
		pSz->width = 700;  //hard code, will change later
		
		pSz->height = 620;  //hard code, will change later
		/// END ENLARGE_GRAPH_BROWSER_DEFAULT_HEIGHT_AND_WIDTH
		return TRUE;
	}

	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{
		if(IDC_MG_GRPAH_LIST == nResIDCtrl)
			return showSelListMenu(nx, ny);
		
		///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		//if ( IDC_FOLDER_TREE == nResIDCtrl && NULL != m_PageView.GetListViewPointer() )
			//return  m_PageView.GetListViewPointer()->CheckShowContextMenu(nx, ny);
		if(IDC_FOLDER_TREE == nResIDCtrl)
		{
			if(m_PageView.GetViewMode() == VIEW_MODE_LIST && m_PageView.GetListViewPointer())
			{
				///Philip 08/31/2012 ORG-6619-P5 IMPROVE_LISTVIEW_COLUMN_DISPLAY
				//return  m_PageView.GetListViewPointer()->CheckShowContextMenu(nx, ny);
				ListView* pLV = m_PageView.GetListViewPointer();
				bool bRes = pLV->CheckShowContextMenu(nx, ny);	//show and wait for user click event...
				vector<byte> vbHide;
				pLV->GetHiddenCols(vbHide);
				m_bLName = !vbHide[LIST_LONG_NAME_COL];
				m_bCell = !vbHide[LIST_CELL_LOCATION_COL];
				///end IMPROVE_LISTVIEW_COLUMN_DISPLAY
			}
			
			if(m_PageView.GetViewMode() == VIEW_MODE_FOLDER)
				return showProjectTreeMenu(nx, ny);
		}
		///end RECOVER_FOLDER_VIEW
		return FALSE;
	}

protected:
	
	BOOL OnShowEmbeddedGraph(Control cntrl)
	{	
		Button chkShowEmbedded = GetItem(IDC_SHOW_EMBEDDED);
		m_bEmbed = chkShowEmbedded.Check;
		//m_bCell = m_bEmbed;///Philip 08/31/2012 ORG-6619-P5 IMPROVE_LISTVIEW_COLUMN_DISPLAY
		///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		//UpdateListView(true);
		m_PageView.SetEmbeddedShow(m_bEmbed);
		m_PageView.UpdatePageView(*this);
		///end RECOVER_FOLDER_VIEW
		///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
		highlightAddedPages();
		///end HIGHLIGHT_ADDED_GRAPHS
		return TRUE;
	}

	/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
	BOOL OnAvailDataComboChange(Control ctrl)
	{
		UpdatePathControls();
		///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		//return UpdateListView();
		///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
		//return m_PageView.UpdatePageView(*this);
		m_PageView.UpdatePageView(*this);
		highlightAddedPages();
		return TRUE;
		///end HIGHLIGHT_ADDED_GRAPHS
		///end RECOVER_FOLDER_VIEW		
	}
	/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER

	/// Zech 12/12/2011 ORG-4284-S1 CHANGE_SPECIFIED_FOLDER_GUI_STYLE
	BOOL OnSpecifiedFolder(Control ctrl)
	{
		FolderBrowserDlg dlg(&m_stFB);
				 
		int nRet = dlg.DoModalEx( GetSafeHwnd() ); //show folder browser dialog and wait...
		if (nRet == IDOK)
		{					
			dlg.GetDlgStatus(m_stFB);

			UpdatePathControls();
			///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
			//UpdateListView();
			m_PageView.UpdatePageView(*this);
			///end RECOVER_FOLDER_VIEW
			///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
			highlightAddedPages();
			///end HIGHLIGHT_ADDED_GRAPHS
			return true;
		}
		else
			return false;
	}
	/// END CHANGE_SPECIFIED_FOLDER_GUI_STYLE
	
	BOOL OnIncludeShortcut(Control cntrl)
	{
		Button chkIncludeShortcut = GetItem(IDC_PG_SHORTCUT_CHECK);
		m_bIncludeShortcut = chkIncludeShortcut.Check;
		///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		//UpdateListView(true);
		m_PageView.SetIncludeShortcut(m_bIncludeShortcut);
		m_PageView.UpdatePageView(*this);
		///end RECOVER_FOLDER_VIEW
		///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
		highlightAddedPages();
		///end HIGHLIGHT_ADDED_GRAPHS
		return TRUE;
	}
	
	///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	int isFolderViewChecked()
	{
		Button btnFolderView = GetItem(IDC_CHECK_FOLDER_VIEW);
		//ASSERT( btnFolderView );
		
		if( btnFolderView )
			return btnFolderView.Check ? VIEW_MODE_FOLDER : VIEW_MODE_LIST;		
		else
			return m_PageView.GetViewMode();
	}
	///end RECOVER_FOLDER_VIEW
	
	///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	//BOOL OnListViewClicked(Control cntrl)
	BOOL OnFolderViewClicked(Control cntrl)
	///end RECOVER_FOLDER_VIEW
	{
		checkUpdateListSettings();
		
		PageViewOptions stPageOptions;
		getPageOptions(stPageOptions);
		///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		//InitListView(*this, stPageOptions);
		m_PageView.SetViewMode(stPageOptions.nViewMode);
		m_PageView.InitControl(*this, stPageOptions);
		///end RECOVER_FOLDER_VIEW
		///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
		highlightAddedPages();
		///end HIGHLIGHT_ADDED_GRAPHS
		return TRUE;
	}
	
	BOOL OnShowPreview(Control cntrl)
	{
		MultiPaneDlg::OnShowBottomPane(cntrl);
		
		if(IsBottomPaneShown())
			loadGraphPageThumbnail(m_strSel);
		
		return TRUE;
	}
	
	BOOL OnAdd(Control cntrl)
	{
		BeforeUpdate();
		addSelected();
		selectRow(m_list.GetRows() - 1);
		AfterUpdate();
		///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
		highlightAddedPages();
		///end HIGHLIGHT_ADDED_GRAPHS
		return TRUE;
	}
	
	BOOL OnRemove(Control cntrl)
	{
		BeforeUpdate();
		removeSelectedPages();
		AfterUpdate();
		OnSelectionChange(cntrl);

#ifdef	__ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		updateOKBtnStatus();
#else
		GetItem(IDOK).Enable = (0 < m_list.GetRows() - m_list.GetRowOffset());	
#endif
		///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
		highlightAddedPages();
		///end HIGHLIGHT_ADDED_GRAPHS
		return TRUE;
	}

	BOOL OnUp(Control cntrl)
	{
		BeforeUpdate();
		moveRowUp();

#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		updateOKBtnStatus();
#else
		GetItem(IDOK).Enable = true;
#endif	
		AfterUpdate();
		return TRUE;
	}
	
	BOOL OnDown(Control cntrl)
	{
		BeforeUpdate();
		moveRowDown();

#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		updateOKBtnStatus();
#else
		GetItem(IDOK).Enable = true;
#endif	
		AfterUpdate();
		return TRUE;
	}

	BOOL OnOK(Control cntrl)
	{		
		ResizeDialog::SaveCheckBoxSettings();
		///Philip 08/14/2012 ORG-6430-S2 ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
		SaveSelListAsLastUsed();
		///end ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
		return TRUE;
	}
	
	BOOL OnCancel(Control cntrl)
	{
		return TRUE;
	}

	BOOL OnSelectionChange(Control cntrl)
	{
		if(!m_list.IsReady())
		{
			_DMSG_MG("list is not ready");			
			return false;
		}
		
		vector<string> 	vsItems;
		m_list.GetSelItems(COL_INDEX, vsItems);
		string 		strPage;
		if(vsItems.GetSize() > 0)
			strPage = vsItems[0];
		
		if(isFullPath(strPage))
			strPage = _get_page_name_from_full_path(strPage);
		m_strSel = strPage;
		if(!IsBottomPaneShown())
		{
			_DMSG_MG("preview should be hidden");			
			return false;
		}		
		
		return loadGraphPageThumbnail(m_strSel);
	}
	
	BOOL OnSelectTreeNode(Control cntrl)
	{		
		if(!m_bMultiplePages)
			GetItem(IDOK).Enable = false;	

		vector<string> 	vsPages;
		vector<int> 	vnDisplayIDs;
		///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		//ASSERT(m_pListView);
		//if( m_pListView->GetSelectedPages(vsPages, true, &vnDisplayIDs) <= 0 )
		if( m_PageView.GetSelectedPages(vsPages, true, &vnDisplayIDs) <= 0 )
		///end RECOVER_FOLDER_VIEW
			return false;
		
#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		if ( !m_bMultiplePages )
			updateOKBtnStatus();
#else
		if(!m_bMultiplePages && (vnDisplayIDs.GetSize() > 0 && vnDisplayIDs[0] == get_page_display_id(EXIST_PLOT) || 0 == vnDisplayIDs.GetSize() ) )
			GetItem(IDOK).Enable = true;
#endif

		m_strSel = vsPages[0];
		
		if(!IsBottomPaneShown())
		{
			_DMSG_MG("preview should be hidden");			
			return false;
		}		

		return loadGraphPageThumbnail(m_strSel);
	}
	
	bool OnDblClickToSel(Control ctrl)
	{		
		if(m_bMultiplePages)//add selected item to graph list
		{
			Control cntrl;
			return OnAdd(cntrl);
		}
		
		vector<string> vsPages;
		///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		//ASSERT(m_pListView);
		//if( 0 == m_pListView->GetSelectedPages(vsPages, false, NULL) )
		if( 0 == m_PageView.GetSelectedPages(vsPages, false, NULL) )
			return false;
		Page pg(vsPages[0]);
		if( !pg || EXIST_PLOT != pg.GetType() )
			return false;

		m_bCloseOnDBClick = true;
		PostMessage( WM_CLOSE );
		return true;
	}
	
	///Philip 08/14/2012 ORG-6430-S2 ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
	bool OnLoadLastUsed(Control ctrl)
	{
		if(!m_bExistLURecord)
			return true;
		
		if(!m_bOutdatedChecked)
		{
			if(!checkRemoveOutdated(m_vsLastUsedRecords, true))
				return false;
			m_bOutdatedChecked = true;
		}
		
		int nRecords = m_vsLastUsedRecords.GetSize();
		if(!nRecords)
		{
			m_bExistLURecord = false;
			return true;
		}
		
		vector<string> vsPages(nRecords), vsProperties;
		for(int ii = 0; ii < nRecords; ii++)
		{
			m_vsLastUsedRecords[ii].GetTokens(vsProperties, SNAME_PATH_DELIMITER);
			//vsProperties[0]: short name; vsProperties[1]: path
			vsPages[ii] = vsProperties[0];
		}
		
		BeforeUpdate();
		if(addPages(vsPages))
			GetItem(IDOK).Enable = true;
		selectRow(m_list.GetRows() - 1);
		AfterUpdate();
		
		///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
		highlightAddedPages();
		///end HIGHLIGHT_ADDED_GRAPHS
		
		return true;
	}
	///end ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
	
	void BeforeUpdate()
	{
		m_list.SetReady(false);
	}
	
	void AfterUpdate(bool bResizeCols = true)
	{
		if(bResizeCols)
			m_list.ResizeCols();
		m_list.SetReady(true);
	}

private:
	///Philip 08/14/2012 ORG-6430-S2 ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
	bool checkRemoveOutdated(vector<string>& vsGraphs, bool isLURecordFormat = false)
	{
		int nSize;
		if(!vsGraphs || !(nSize = vsGraphs.GetSize()))
			return false;
		if(m_PageView.GetListViewPointer() && m_PageView.GetViewMode() == VIEW_MODE_LIST)
			if(m_PageView.GetListViewPointer()->GetRows() <= 0)
				return false;
		
		vector<string> vsGraphExist;
		string strQuery = STR_QUERY_EXIST_GRAPHS;
		m_qr.Build(strQuery, 0, FilterFunc());
		m_qr.GetNames(vsGraphExist, QUERYRESULTNAME_SNAME);
		
		if(isLURecordFormat)
		{
			vector<string> vsSName(nSize), vsPath(nSize);
			vector<string> vsProperties;
			for(int i = 0; i < nSize; i++)
			{
				vsGraphs[i].GetTokens(vsProperties, SNAME_PATH_DELIMITER);
				vsSName[i] = vsProperties[0];
				vsPath[i] = vsProperties[1];
			}			
			for(int ii = 0; ii < vsGraphs.GetSize(); ii++)
			{
				int iPos = vsGraphExist.Find(vsSName[ii]);
				if(-1 == iPos)
				{
					vsGraphs.RemoveAt(ii);//remove outdated						
					vsSName.RemoveAt(ii);
					vsPath.RemoveAt(ii);
					ii--;
				}
				else
				{
					string strProj = vsPath[ii];
					strProj.Delete(0, 1);//remove leading '/'
					strProj.Delete(strProj.Find('/'), strProj.GetLength());//get project name from path
					if(0 == lstrcmpi(Project.GetName(), strProj))
					{
						//if paths are not the same...
						//warning_msg_box("",false);
					}
					else//graphs in different project
					{
						vsGraphs.RemoveAll();
						return true;
					}
				}
			}
		}
		else
			for(int ii = 0; ii < nSize; ii++)
				if(-1 == vsGraphExist.Find(vsGraphs[ii]))
				{
					vsGraphs.RemoveAt(ii);
					ii--;
				}
		
		return true;
	}
	
	bool SaveSelListAsLastUsed()
	{
		if(!getPages())
			return false;
		
		int nPages = m_vsPageList.GetSize();
		vector<string> vsRecords(nPages);
		for(int idx = 0; idx < nPages; idx++)
		{
			//construct a record:
			//record ---> SHORT_NAME SNAME_PATH_DELIMITER PATH
			vsRecords[idx] = m_vsPageList[idx] +
			                 SNAME_PATH_DELIMITER +
			                 _get_full_path_from_page_name(m_vsPageList[idx]);
		}
		
		string strValName;
		strValName.SetTokens(vsRecords, CHAR_SAVE_TOKEN);//REGVALUE ---> record { CHAR_SAVE_TOKEN record }
		SaveSetting(STR_SAVE_LAST_USED_GRAPHS, strValName, STR_DLG_NAME);
		
		return true;
	}
	///end ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
	
	///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
	void highlightAddedPages()
	{
		if(m_bMultiplePages)
		{
			m_PageView.ClearBold();
			if(getPages())
				m_PageView.SetBold(m_vsPageList);
		}
	}
	///end HIGHLIGHT_ADDED_GRAPHS
	
	string GetQueryStr()
	{
		int nComboSel = m_pComboUsingFolder->GetCurSel();
		string strRet = "SELECT GRAPH FROM ";

		switch(nComboSel)
		{
		case FOLDER_CONTAINER_ALL_FOLDER:
			strRet += "PROJECT RECURSIVE";
			break;
		case FOLDER_CONTAINER_ACTIVE_FOLDER:
			strRet += "ACTIVEFOLDER RECURSIVE";
			break;
		case FOLDER_CONTAINER_SPECIFIED_FOLDER:
			{
				vector<string> vsPaths;
				vsPaths = m_stFB.vsSelPaths;
				if (m_stFB.bRecursive)
					_DEL_CHILDREN_PATHS(vsPaths);
				
				/// Zech 04/01/2012 ORG-4284-P4 ADD_QUOTES_FOR_FOLDER_NAME_BEFORE_QUERY
				// if (0 != vsPaths.GetSize())
				int nSize = vsPaths.GetSize();
				for (int ii = 0; ii < nSize; ii++)
				{
					// strings in vector cannot use function okutil_check_add_quotes directly
					string strTemp;
					strTemp.Format("\"%s\"", vsPaths[ii]);
					vsPaths[ii] = strTemp;
				}
				
				if (0 != nSize)
				/// END ADD_QUOTES_FOR_FOLDER_NAME_BEFORE_QUERY
				{
					string strSuffix;
					strSuffix.SetTokens(vsPaths, ',');
					strRet += strSuffix;
					if (m_stFB.bRecursive)
						strRet += " " + STR_KEYWORD_RECURSIVE;
				}
				else
				{
					return "";
				}
			}
		}

		Button chkShowEmbedded = GetItem(IDC_SHOW_EMBEDDED);
		Button chkIncludeShortcut = GetItem(IDC_PG_SHORTCUT_CHECK);
		
		m_bEmbed = chkShowEmbedded.Check;
		m_bIncludeShortcut = chkIncludeShortcut.Check;

		if (m_bEmbed)
			strRet += " " + STR_KEYWORD_EMBEDED;

		if (m_bIncludeShortcut)
			strRet += " " + STR_KEYWORD_SHORTCUT;

		return strRet;
	}

	string FilterFunc()
	{
		return !m_strFilterFuncName.IsEmpty() ? m_strFilterFuncName : "IsGraphNotSparkline";
	}

	/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
public:///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	BOOL UpdateListView(bool bUseLastQuery = false)
	{
		/// Zech 12/12/2011 CLEAN_UP_QUERYRESULTEX
		/*
		// Do the query and get its pointer
		QueryResultEx* pQRE = GetBuiltQuery(bUseLastQuery);
		
		// If don't need to update, for example, clicked 'cancel' in specified folder dialog, stop updating.
		if (GetShowLastResult())
		{
			SetShowLastResult(false);
			m_pComboUsingFolder->SetCurSel(m_nLastComboSel);
			return FALSE;
		}
		*/
		/// END CLEAN_UP_QUERYRESULTEX
		string strQuery = GetQueryStr();
		///------ Folger 02/08/2012 ORG-5010-P1 QUERY_RESULT_SUPPORT_FILTER_FUNCTION
		//m_qr.Build(strQuery);
		/// Zech 03/31/2012 ORG-4284-P3 DO_NOT_SHOW_SPARKLINE_IN_GRAPH_BROWSER
		//m_qr.Build(strQuery, 0, m_strFilterFuncName);
		m_qr.Build(strQuery, 0, FilterFunc());
		/// END DO_NOT_SHOW_SPARKLINE_IN_GRAPH_BROWSER
		///------ End QUERY_RESULT_SUPPORT_FILTER_FUNCTION

		/// Zech 12/12/2011 CLEAN_UP_QUERYRESULTEX
		/*
		// If don't need to update, for example, clicked 'cancel' in specified folder dialog, stop updating.
		if ("" == strQuery)
		{
			m_pComboUsingFolder->SetCurSel(m_nLastComboSel);
			return FALSE;
		}
		*/
		/// END CLEAN_UP_QUERYRESULTEX

		// Update the query result to the listview
		PageViewOptions stOptions;
		getPageOptions(stOptions);
		m_PageView.GetListViewPointer()->UpdatePageView(stOptions, &m_qr);

		/// Zech 12/12/2011 CLEAN_UP_QUERYRESULTEX
		//m_nLastComboSel = m_pComboUsingFolder->GetCurSel();
		/// END CLEAN_UP_QUERYRESULTEX

		return TRUE;
	}
	
	///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	BOOL UpdateFolderView(bool bUseLastQuery = false)
	{	
		PageViewOptions stOptions;
		getPageOptions(stOptions);
		FolderView* pFV = m_PageView.GetFolderViewPointer();
		if(!pFV)
			return FALSE;
		applyCurrFolderMode2FView(pFV);
		return pFV->UpdatePageView(stOptions);
	}
	///end RECOVER_FOLDER_VIEW

	/// Zech 12/12/2011 CLEAN_UP_QUERYRESULTEX
	/*
	// Do query according the option in the dialog, and return its pointer
	QueryResultEx* GetBuiltQuery(bool bUseLastQuery = false)
	{
		int nComboSel = m_pComboUsingFolder->GetCurSel();
		
		Button chkShowEmbedded = GetItem(IDC_SHOW_EMBEDDED);
		Button chkIncludeShortcut = GetItem(IDC_PG_SHORTCUT_CHECK);
		
		QueryResultEx &qre = m_arrQuery.GetAt(nComboSel);
		m_bEmbed = chkShowEmbedded.Check;
		m_bIncludeShortcut = chkIncludeShortcut.Check;
		
		DWORD dwQueryOptions = 	(bUseLastQuery?QUERY_OPTION_USE_LAST_QUERY_STRING:0) |
			(chkShowEmbedded.Check?QUERY_OPTION_EMBEDED:0) | 
			(m_bIncludeShortcut?QUERY_OPTION_SHORTCUT:0);
		
		int nResult = qre.Build(dwQueryOptions, 0);
		
		SetShowLastResult(nResult < 0);
		return &qre;
	}
	*/
	/// END CLEAN_UP_QUERYRESULTEX
private:///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW	
	/// Zech 12/12/2011 ORG-4284-S1 CHANGE_SPECIFIED_FOLDER_GUI_STYLE
	void AlignPathControls(int nGap = PG_DLG_GAP)
	{
		CLayoutTool layoutTool(*this);
		layoutTool.m_nAlignOption = ALIGN_VERTI_CENTER;
		layoutTool.m_szGap.cx = nGap;
		vector<UINT> vnCtrlIDs = {IDC_PG_AVAIL_DATA_COMBO_BOX};
		if (m_bShowSpecifiedBtn)
			vnCtrlIDs.Add(IDC_PG_SPECIFIED);
		if (m_bShowPathText)
			vnCtrlIDs.Add(IDC_PG_PATH_TEXT);
		layoutTool.PerformLayout(vnCtrlIDs);
		
		Edit editPathText = GetItem(IDC_PG_PATH_TEXT);
		/// Zech 04/01/2012 ORG-4284-P5 FIX_PATH_TEXT_CONTROL_ALIGN_WHEN_PREVIEW_ON_RIGHT
		//RECT rrDlg, rrPathText;
		//GetClientRect(&rrDlg);
		//GetClientRect(editPathText, rrPathText);
		//rrPathText.right = rrDlg.right - nGap;
		//MoveControl(editPathText, rrPathText);
		RECT rrPathText, rrAlignTarget;
		GetClientRect(editPathText, rrPathText);
		if (GetPreviewOnRight())
		{
			GetClientRect(GetItem(IDC_FOLDER_TREE), rrAlignTarget);
			rrPathText.right = rrAlignTarget.right;
		}
		else
		{
			///Philip 08/14/2012 ORG-6430-S2 ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
			//GetClientRect(&rrAlignTarget);
			//rrPathText.right = rrAlignTarget.right - nGap;
			GetClientRect(GetItem(IDC_FOLDER_TREE), rrAlignTarget);
			rrPathText.right = rrAlignTarget.right;
			///end ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
		}
		
		MoveControl(editPathText, rrPathText);
		/// END FIX_PATH_TEXT_CONTROL_ALIGN_WHEN_PREVIEW_ON_RIGHT
		
		editPathText.Text = editPathText.Text;//do refresh ///Philip 08/17/2012 ORG-4284-S8 FIX_TEXT_SHOWING_PROBLEMS
	}
	void UpdatePathControls()
	{
		int nComboSel = m_pComboUsingFolder->GetCurSel();
		
		m_bShowSpecifiedBtn = nComboSel == FOLDER_CONTAINER_SPECIFIED_FOLDER;
		m_bShowPathText = nComboSel == FOLDER_CONTAINER_ACTIVE_FOLDER || nComboSel == FOLDER_CONTAINER_SPECIFIED_FOLDER;		

		Button btSpecified = GetItem(IDC_PG_SPECIFIED);
		Edit editPath = GetItem(IDC_PG_PATH_TEXT);

		btSpecified.Visible = m_bShowSpecifiedBtn;
		editPath.Visible = m_bShowPathText;
		AlignPathControls();

		/*
		RECT rrSpecified, rrPath, rrCombo;
		GetClientRect(btSpecified, rrSpecified);
		GetClientRect(editPath, rrPath);

		Control ctrlCombo = GetItem(IDC_PG_AVAIL_DATA_COMBO_BOX);
		GetClientRect(ctrlCombo, rrCombo);

		rrPath.left = (m_bShowSpecifiedBtn?rrSpecified.right :rrCombo.right) + PG_DLG_GAP;
		MoveControl(editPath, rrPath);
		*/

		if (FOLDER_CONTAINER_SPECIFIED_FOLDER == nComboSel)
		{
			int nSize = m_stFB.vsSelPaths.GetSize();
			if (0 == nSize)
				editPath.Text = _L("No folder selected");
			else if (1 == nSize)
				editPath.Text = m_stFB.vsSelPaths[0];
			else
				editPath.Text = _L("Multiple folders selected");
		}
		else if (FOLDER_CONTAINER_ACTIVE_FOLDER == nComboSel)
		{
			string strPath = Project.ActiveFolder().GetPath();
			editPath.Text = strPath;
		}
	}
	/// END CHANGE_SPECIFIED_FOLDER_GUI_STYLE
	
	/// Zech 12/12/2011 CLEAN_UP_QUERYRESULTEX
	/*
	void SetShowLastResult(bool bShow)
	{
		m_bShowLastResult = bShow;
	}

	bool GetShowLastResult()
	{
		return m_bShowLastResult;
	}
	*/
	/// END CLEAN_UP_QUERYRESULTEX
	
	/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
	
	void GetCellLocationFromGraphNames(vector <string> &vsGraphName, vector <string> &vsCellLocations)
	{
		int nSize = vsGraphName.GetSize();
		for (int nn = 0; nn < nSize; nn++)
		{
			vsCellLocations.Add(_get_embedded_graph_cell_location(vsGraphName[nn]));
		}
	}

	///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	BOOL showProjectTreeMenu(int nx, int ny)
	{
		bool bMulti;
		bool bFolder = m_PageView.GetFolderViewPointer()->IsFolderSelected(&bMulti);
		bool bAddingItems = m_list.IsVisible();
		ProjectTreeMenu	myMenu(bFolder, bMulti, m_bLName, m_bEmbed, m_bCell, bAddingItems);
		myMenu.TrackPopupMenu(0,  nx, ny, GetSafeHwnd());
		int nCmd;
		if(myMenu.GetCommand(nCmd))
		{
			BeforeUpdate();		
			switch(nCmd)
			{
			case PROJECT_TR_ADD_ALL:
				addSelected();
				break;
			case PROJECT_TR_ADD_ALL_RECURSIVE:
				addSelected(true);
				break
			case PROJECT_TR_ADD_ALL_OPEN:
				addSelected(false, true);
				break;
			case PROJECT_TR_SHOW_LNAME:
				m_bLName = !m_bLName;
				m_PageView.GetFolderViewPointer()->ShowMoreInfo(m_bLName, m_bCell);
				break;
			case PROJECT_TR_SHOW_CELL:
				m_bCell = !m_bCell;
				m_PageView.GetFolderViewPointer()->ShowMoreInfo(m_bLName, m_bCell);
				break;
			default:
				break;				
			}
			selectRow(m_list.GetRows() - 1);
			AfterUpdate();
			///Philip 08/27/2012 ORG-6619-S1 HIGHLIGHT_ADDED_GRAPHS
			switch(nCmd)
			{
			case PROJECT_TR_ADD_ALL:
			case PROJECT_TR_ADD_ALL_RECURSIVE:
			case PROJECT_TR_ADD_ALL_OPEN:
				highlightAddedPages();
			default:
				break;
			}
			///end HIGHLIGHT_ADDED_GRAPHS
			return TRUE;
		}
		return FALSE;
		
	}
	///end RECOVER_FOLDER_VIEW
	
	BOOL showSelListMenu(int nx, int ny)
	{		
		vector<uint> vnSelRows;
		m_list.GetSelRows(vnSelRows);
		bool bMulti = vnSelRows.GetSize() > 1;
		
		int nClickRow, nClickCol;
		m_list.GetMouseCell(nClickRow, nClickCol);
		
		if (nClickRow == 0) return FALSE;
		if(1 <= nClickRow)
		{
			vector<uint> vecIndex;
			vnSelRows.Find(vecIndex, nClickRow);
			if(!vecIndex.GetSize())
			{
				m_list.SelRow(nClickRow);
				bMulti = false;
			}
		}
		
		SelListMenu	myMenu(bMulti);
		myMenu.TrackPopupMenu(0,  nx, ny, GetSafeHwnd());
		int nCmd;
		if(myMenu.GetCommand(nCmd))
		{
			Control cntrl;
			switch(nCmd)
			{
			case SEL_LIST_REMOVE:
				OnRemove(cntrl);
				break;
			case SEL_LIST_UP:
				OnUp(cntrl);
				break;
			case SEL_LIST_DOWN:
				OnDown(cntrl);
				break;	
			default:
				break;
			}
			return TRUE;
		}
		return FALSE;
	}
	
	void	checkUpdateListSettings()
	{
		if ( NULL != m_PageView.GetListViewPointer() )///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		{
			vector<byte>	vbHide;
			m_PageView.GetListViewPointer()->GetHiddenCols(vbHide);///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
			m_bLName = !vbHide[LIST_LONG_NAME_COL];
			m_bCell = !vbHide[LIST_CELL_LOCATION_COL];
		}
	}

	void OnBeforeMoveRows(Control ctrl, long nRow, long *pnPosition)
	{
		getPages();
		m_strDiff.SetTokens(m_vsPageList);
	}
	
	void OnAfterMoveRows(Control ctrl, long nRow, long *pnPosition) 
	{
		getPages();

#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		updateOKBtnStatus(false);
#else
		string strTmp;
		strTmp.SetTokens(m_vsPageList);
		if (strTmp.CompareNoCase(m_strDiff) != 0)
		{
			GetItem(IDOK).Enable = true;
		}
#endif	
	}
	
	void initGraphsList(Tree& tr)	
	{
		m_list.Init(IDC_MG_GRPAH_LIST, false, true, NULL, *this);
	
		if(!m_bMultiplePages)
		{
			m_list.SetVisible(false);
			return;
		}
		
		m_list.SetReady(false);
		m_list.SetAllowSelection(true);
		m_list.SetSelection(flexSelectionListBox);
		m_list.SetEditable();
		m_list.SetupRowsCols
		///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		//(0, 0,  1, 2);
		  (0, 0,  1, 4);
		///end ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		m_list.SetTreeNodeMoveRowsAttrib(tr);
		m_list.SetReady(true);
		
		Tree trPages;
		bool bFlag = false;
		
		for (int ii=0; ii<m_vsPageList.GetSize(); ii++)
		{
			string strName = m_vsPageList[ii];

			GraphPageBase gpb(strName);
			if (gpb)
			{
				bFlag = true;
				TreeNode trnode = trPages.AddNode(strName);
				trnode.Name.strVal = strName;
				trnode.Path.strVal = _get_full_path_from_page_name(strName);
				
				///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
				int nLayers, nPlots;
				_get_layer_plot_num(strName, &nLayers, &nPlots);
				trnode.Layers.strVal = nLayers;
				trnode.Plots.strVal = nPlots;
				///end ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
			}
		}
		
		if (!bFlag)
		{
			TreeNode trnode = trPages.AddNode();
			trnode.Name.strVal = "";
			trnode.Path.strVal = "";
			///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
			trnode.Layers.strVal = "";
			trnode.Plots.strVal = "";
			///end ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		}

		TreeNode	trFirstPage = trPages.FirstNode;
		if ( trFirstPage )
		{
			trFirstPage.Name.SetAttribute(STR_LABEL_ATTRIB, _L("Name"));
			trFirstPage.Path.SetAttribute(STR_LABEL_ATTRIB, _L("Path"));
			///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
			trFirstPage.Layers.SetAttribute(STR_LABEL_ATTRIB, _L("Layers"));
			trFirstPage.Plots.SetAttribute(STR_LABEL_ATTRIB, _L("Plots"));
			///end ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		}
		
		BeforeUpdate();
		int nSelRow = m_list.GetSelectedRow();
		m_list.UpdateGrid(trPages);
		m_list.SelRow(nSelRow);
		m_list.SetRowHeaderValues();
		///Philip 08/27/2012 ORG-6619-P2 FIX_FAIL_TO_DRAG_ROW_UPDOWN_IN_SELLIST
		//m_list.SetExplorerBar(flexExSortShow);///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
		m_list.SetExplorerBar(flexExSortShow | flexExMoveRows);
		///end FIX_FAIL_TO_DRAG_ROW_UPDOWN_IN_SELLIST
		AfterUpdate();
		
		if (!bFlag)
		{
			m_list.DeleteRow(m_list.GetRowOffset());
		}
	}
	
public:///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	
	///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	//void InitListView(WndContainer& dlg, PageViewOptions& stViewOptions)
	void InitListView(PageViewOptions& stViewOptions)
	///end RECOVER_FOLDER_VIEW
	{	
		///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW 
		//if( m_PageView.GetListViewPointer() )
			//return;
			//........
		//if(m_PageView.GetListViewPointer())
		m_PageView.CreateListView();
		ListView* pLV = m_PageView.GetListViewPointer();
		if(pLV)
		///end RECOVER_FOLDER_VIEW
		{
			/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
			/// Zech 12/12/2011 CLEAN_UP_QUERYRESULTEX
			/*
			//m_PageView.GetListViewPointer()->InitControl(dlg, stViewOptions);
			QueryResultEx *pQRE = GetBuiltQuery();
			m_PageView.GetListViewPointer()->InitControl(dlg, stViewOptions, "", pQRE);
			*/
			/// END CLEAN_UP_QUERYRESULTEX
			///------ Folger 02/08/2012 ORG-5010-P1 QUERY_RESULT_SUPPORT_FILTER_FUNCTION
			//m_qr.Build(GetQueryStr());
			m_qr.Build(GetQueryStr(), 0, FilterFunc());
			///------ End QUERY_RESULT_SUPPORT_FILTER_FUNCTION
			///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
			//m_pListView->InitControl(dlg, stViewOptions, "", &m_qr);
			pLV->InitControl(*this, stViewOptions, "", &m_qr);
			///end RECOVER_FOLDER_VIEW
			/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
		}
	}
	
	///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW 
	void InitFolderView(PageViewOptions& stViewOptions)
	{
		m_PageView.CreateFolderView();
		FolderView* pFV = m_PageView.GetFolderViewPointer();
		if(!pFV)
			return;
		applyCurrFolderMode2FView(pFV);
		pFV->InitControl(*this, stViewOptions);
	}
	
private:
	
	//only used by Folder View; it is like the counterpart of the List View's GetQueryStr().
	void applyCurrFolderMode2FView(FolderView* pFV)
	{
		if(!pFV)
			return;
		
		switch(GetFolderMode())
		{
		case FOLDER_CONTAINER_ACTIVE_FOLDER:
			{
				vector<string> vsAct;
				Folder fd = Project.ActiveFolder();
				if(fd)
					vsAct.Add(fd.GetPath());
				pFV->SpecifyPaths2BShown(vsAct);
			}
			break;
		case FOLDER_CONTAINER_SPECIFIED_FOLDER:
			pFV->SpecifyPaths2BShown(m_stFB.vsSelPaths);
			break;
		case FOLDER_CONTAINER_ALL_FOLDER:
		default:
			//clear last(if exists) specifying paths
			pFV->ClearSpecifiedPaths();
		}
	}
	///end RECOVER_FOLDER_VIEW
	
	void resizeControls(int cx)
	{
		int nGap = PG_DLG_GAP;

		MoveControlsHelper	_temp(this);
		
		/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
		Control ctrlCombo = GetItem(IDC_PG_AVAIL_DATA_COMBO_BOX);
		RECT rrCombo;
		GetClientRect(ctrlCombo, rrCombo);
		int nComboHeight = RECT_HEIGHT(rrCombo);
		int nComboWidth = RECT_WIDTH(rrCombo);
		rrCombo.left = nGap;
		rrCombo.right = rrCombo.left + nComboWidth;
		rrCombo.top = nGap;
		rrCombo.bottom = rrCombo.top + nComboHeight;
		MoveControl(ctrlCombo, rrCombo);
		/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER

		Control ctrlTree = GetItem(IDC_FOLDER_TREE);
		RECT 	rrTree;
		GetClientRect(ctrlTree, rrTree);
		
		//shorten ctrlTree to place shortcut checkbox
		Control chkShortcut = GetItem(IDC_PG_SHORTCUT_CHECK);
		RECT 	rShortcut;
		GetClientRect(chkShortcut, rShortcut);
		int nChkWidth = RECT_WIDTH(rShortcut);
		int nChkHeight = RECT_HEIGHT(rShortcut);
		rShortcut.left 	= nGap;
		rShortcut.right = rShortcut.left + nChkWidth;
		rShortcut.bottom = rrTree.bottom;
		rShortcut.top	= rShortcut.bottom - nChkHeight;
		MoveControl(chkShortcut, rShortcut);
		
		/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
		rrTree.top = rrCombo.bottom + nGap;
		/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER

		rrTree.bottom = rShortcut.top - nGap;
		MoveControl(ctrlTree, rrTree);
		
		Control ctrlList = GetItem(IDC_MG_GRPAH_LIST);
		RECT 	rrList;
		GetClientRect(ctrlList, rrList);
		
		if(m_bMultiplePages)
		{
			Control btnAdd = GetItem(IDC_MG_ADD);
			RECT 	rrAdd;
			GetClientRect(btnAdd, rrAdd);
			int nBtnWidth = RECT_WIDTH(rrAdd);
			int	nBtnHeight = RECT_HEIGHT(rrAdd);
			// WeightDlg = Gap + TreeWid + Gap + ButtonWid + ListWid + Gap, the width of List is same as the width of Tree
			int nTreeAndListWidth = ( RECT_WIDTH(rrTree) - 3*nGap - nBtnWidth )/2;
			
			rrList.top = rrTree.top;
			rrList.bottom = rrTree.bottom;
			rrList.right = rrTree.right;
			rrList.left = rrList.right - nTreeAndListWidth;
			MoveControl(ctrlList, rrList);
			
			
			Control btnRemove = GetItem(IDC_MG_REMOVE);
			RECT 	rrRemove;
			GetClientRect(btnRemove, rrRemove);
		
			rrAdd.right = rrList.left - nGap;
			rrAdd.left = rrAdd.right - nBtnWidth;
			rrAdd.top = (RECT_HEIGHT( rrList )/2 + nGap) - (nBtnHeight + nGap/2);
			rrAdd.bottom = rrAdd.top + nBtnHeight;

			MoveControl(btnAdd, rrAdd);
			
			rrRemove.right = rrAdd.right;
			rrRemove.left = rrAdd.left;

			rrRemove.top = rrAdd.bottom + nGap;
			rrRemove.bottom = rrRemove.top + nBtnHeight;

			MoveControl(btnRemove, rrRemove);
			
			rrTree.right = rrAdd.left - nGap;

			MoveControl(ctrlTree, rrTree);
		}
		
		/// Zech 12/12/2011 ORG-4284-S1 CHANGE_SPECIFIED_FOLDER_GUI_STYLE
		AlignPathControls(nGap);
		/// END CHANGE_SPECIFIED_FOLDER_GUI_STYLE

		Control chkEmbed = GetItem(IDC_SHOW_EMBEDDED);
		RECT 	rrCheck, rrOK;
		GetClientRect(chkEmbed, rrCheck);
		int nWidth = RECT_WIDTH(rrCheck), nHeight = RECT_HEIGHT(rrCheck);
		GetClientRect(GetItem(IDOK), rrOK);
		rrCheck.left = rrTree.left;
		rrCheck.top = rrOK.top;
		rrCheck.right = rrCheck.left + nWidth;
		rrCheck.bottom = rrCheck.top + nHeight;
		MoveControl(chkEmbed, rrCheck);
		
		///Philip 08/14/2012 ORG-6430-S2 ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
		Button btnLoad = GetItem(IDC_LOAD_LAST_USED);
		if(m_bMultiplePages)
		{
			RECT 	rrLoad, rrSelList;
			GetClientRect(btnLoad, rrLoad);
			GetClientRect(GetItem(IDC_MG_GRPAH_LIST), rrSelList);
			int nLoadW = RECT_WIDTH(rrLoad), nLoadH = RECT_HEIGHT(rrLoad);
			rrLoad.top = rrCombo.top; // align with IDC_PG_AVAIL_DATA_COMBO_BOX
			rrLoad.bottom = rrLoad.top + nLoadH;
			rrLoad.left = rrSelList.left;
			rrLoad.right = rrLoad.left + nLoadW;
			MoveControl(btnLoad, rrLoad);
		}
		else
		{
			btnLoad.Visible = false;
			btnLoad.Enable = false;
		}
		///end ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
		
		///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		Control btnFolderView = GetItem(IDC_CHECK_FOLDER_VIEW);
		if( btnFolderView && btnFolderView.Visible )
		{
			RECT 	rrFolderView;
			GetClientRect(btnFolderView, rrFolderView);
			rrFolderView.left = rrCheck.right + nGap ;
			rrFolderView.top = rrCheck.top;
			rrFolderView.right = rrFolderView.left + 80;///Philip 08/17/2012 ORG-4284-S8 FIX_TEXT_SHOWING_PROBLEMS
			rrFolderView.bottom = rrCheck.bottom;
			MoveControl(btnFolderView, rrFolderView);
		}
		///end RECOVER_FOLDER_VIEW
	}
	
	//---setup page list
	int addPages(const vector<string>& vsAdded, bool bCheckOpen = false)
	{		
		getPages();
		
		int nAdded = 0;
		int nRowStart = m_list.GetRows();
		int nRowOffset = m_list.GetRowOffset();
		
		for(int ii = 0; ii < vsAdded.GetSize(); ii++)
		{
			//to check if the page have existed in the current list

			bool bAdd = true;
			string strName = vsAdded[ii];
			if( m_vsPageList.GetSize() > 0 )
			{
				if(-1 != m_vsPageList.Find(strName))
					bAdd = false;
			}			
			if(bAdd && bCheckOpen)//!bExist)
			{
				GraphPageBase gpb(strName);
				if(gpb.GetShow() ==PAGE_HIDDEN || gpb.GetShow() ==PAGE_MINIMIZED )
					bAdd = false;
			}
			// if not exist, add it
			if(bAdd)
			{
				m_list.SetRows(nRowStart + nAdded + 1 - nRowOffset);
				m_list.SetCell(nRowStart + nAdded, COL_NAME, strName);//COL_INDEX, vsAdded[ii]);
				
				string strPath = _get_full_path_from_page_name(strName);
				m_list.SetCell(nRowStart + nAdded, COL_PATH, strPath);
				
				///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
				int nLay, nPlt;
				_get_layer_plot_num(strName, &nLay, &nPlt);
				m_list.SetCell(nRowStart + nAdded, COL_LAYERS, nLay);
				m_list.SetCell(nRowStart + nAdded, COL_PLOTS,  nPlt);
				///end ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
				
				nAdded++;	
			}
		}
		return nAdded;
	}

	string getSelectedPage()
	{
		vector<string> 	vsGraphs;
		///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		//ASSERT(m_pListView);
		//if( 0 == m_pListView->GetSelectedPages(vsGraphs) )
		if( 0 == m_PageView.GetSelectedPages(vsGraphs) )
		///end RECOVER_FOLDER_VIEW
			return "";
		
		string 		strPage;
		if(vsGraphs.GetSize()!=0)
			strPage = vsGraphs[0];
		return strPage;
	}
	
	void addSelected(bool bRecursive = false, bool bCheckOpen = false)
	{
		vector<string> vsGraphs;
		///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
		//ASSERT(m_pListView);
		//m_pListView->GetSelectedPages(vsGraphs, bRecursive);
		m_PageView.GetSelectedPages(vsGraphs, bRecursive);
		///end RECOVER_FOLDER_VIEW
		
		// add to SelList
		if( addPages(vsGraphs, bCheckOpen) )

#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
			updateOKBtnStatus();
#else
			
			GetItem(IDOK).Enable = true;
#endif	
	}
	
	bool addPage(TreeNode tr, bool bRecursive = false, bool bCheckOpen = false)
	{
		if(tr.GetNodeCount() < 1)
		{
			string strName;

			tr.GetAttribute(STR_LABEL_ATTRIB, strName);

			addPage(strName, bCheckOpen);
		}

		foreach(TreeNode cNode in tr.Children)
		{
			if(!cNode.IsValid() || (cNode.GetNodeCount() && !bRecursive) )
				continue;
			addPage(cNode, bRecursive, bCheckOpen);
		}
		return true;
	}
	
	int addPage(string strName, bool bCheckOpen = false)
	{
		//check exist
		if( m_vsPageList.GetSize() > 0 && -1 < m_vsPageList.Find(strName)) 
			return 0;
		
		if(bCheckOpen)
		{
			GraphPageBase gpb(strName);
			if(gpb.GetShow() ==PAGE_HIDDEN || gpb.GetShow() ==PAGE_MINIMIZED )
				return -1;
		}
		string strPath = _get_full_path_from_page_name(strName);
		m_list.InsertRow();
		int nRow = m_list.GetRows();
		m_list.SetCell(nRow - 1, COL_NAME, strName);
		m_list.SetCell(nRow - 1, COL_PATH, strPath);
		m_vsPageList.Add(strName);
		
		return nRow;
	}
	
	//to check if have select one, if not, then select the first one
	void selectRow(int nRow = -1)
	{
		if( m_list.GetRows() <= 0 )
			return;
		
		while( nRow >= m_list.GetRows() )
			nRow--;
			
		if(nRow < 0)
			nRow = m_list.GetSelectedRow(); // get 1st if multiple selection, -1 if none selected
		if( nRow < 0 )
			nRow = 0;
		
		m_list.SelRow(nRow);		
	}
	
	void removeSelectedPages()
	{
		vector<uint> vnRows;
		if(!m_list.GetSelRows(vnRows))
			return;
		
		int nSelRow = m_list.GetSelectedRow();

		for(int index = vnRows.GetSize() - 1; index >= 0; index--) 
			m_list.DeleteRow(vnRows[index]);
		
		selectRow(nSelRow);
		getPages();
	}
	
	void removeAllPages()
	{
		m_list.SetRows(0);
	}
	
	// get all pages from sel-list and save into m_vsPageList
	bool getPages()
	{
		m_vsPageList.SetSize(0);
		
		int nRows = m_list.GetRows();
		if(nRows <= 0)
			return false;
		
		for(int nRow = m_list.GetRowOffset(); nRow < nRows; nRow++)
		{
			string str = m_list.GetCell(nRow, COL_NAME);//COL_INDEX);
			m_vsPageList.Add(str);			
		}
		
		return m_vsPageList.GetSize() > 0;
	}
	
	bool getSelPages(vector<string>& vsPages)
	{
		vector<uint> vuSelRows;
		if(!m_list.GetSelRows(vuSelRows))
			return false;
		
		for(int ii = 0; ii < vuSelRows.GetSize(); ii++)
		{
			string str = m_list.GetCell(vuSelRows[ii], COL_NAME);
			vsPages.Add(str);
		}
		
		return vsPages.GetSize() > 0;
	}
	
	// get all pages list and return a string
	string getPageList()
	{
		string 			strPageList;
		if(m_vsPageList.GetSize() == 0)
			return strPageList;
		
		if(isFullPath(m_vsPageList[0]))
			for(int ii=0; ii<m_vsPageList.GetSize(); ii++)
				m_vsPageList[ii] = _get_page_name_from_full_path(m_vsPageList[ii]);
			
		strPageList.SetTokens(m_vsPageList, STR_PAGE_LIST_SEPARATOR);
		
		return strPageList;
	}
	
	bool showPagesFullPath(bool bFullPath)
	{
		getPages(); //get the current page list to m_vsPageList
		
		vector<string> vsPages(m_vsPageList.GetSize());
		for(int index=0; index<m_vsPageList.GetSize(); index++)
		{
			if(bFullPath)
				vsPages[index] = _get_full_path_from_page_name(m_vsPageList[index]);				
			else
				vsPages[index] = _get_page_name_from_full_path(m_vsPageList[index]);
		}
		
		return true;
	}
	
	///Philip 08/27/2012 ORG-6619-P4 FIX_PATHS_OUT_OF_ORDER
	/*
	string getFullPathFromPageName(string strPage)
	{
		Page pg(strPage);
			
		Worksheet wks;
		if( pg.GetEmbeddingInfo(wks) )
		{
			pg = wks.GetPage();
		}
		
		if(pg)
		{
			Folder fld = pg.GetFolder();
			return fld.GetPath();
		}
	
		return "";
	}
	
	string getPageNameFromFullPath(string strFullPath)
	{
		string 			strPage;
		vector<string> 	vsPage;
		if( strFullPath.GetTokens(vsPage, CHAR_FLD_SEPARATOR) <= 0 )
			return strPage;
		
		strPage = vsPage[vsPage.GetSize()-1];
		
		return strPage;
	}
	*/
	///end FIX_PATHS_OUT_OF_ORDER
	
	void moveRowUp()
	{
		vector<uint> vnSels;
		if( !m_list.GetSelRows(vnSels))
			return;
		
		for(int index=0; index<vnSels.GetSize(); index++)
		{
			int nRow = vnSels[index];

			if(nRow<=1)
				return;
			
			string strTemp = m_list.GetCell(nRow-1, COL_NAME);
			m_list.SetCell(nRow-1, COL_NAME, m_list.GetCell(nRow, COL_NAME));
			m_list.SetCell(nRow, COL_NAME, strTemp);
			
			strTemp = m_list.GetCell(nRow-1, COL_PATH);
			m_list.SetCell(nRow-1, COL_PATH, m_list.GetCell(nRow, COL_PATH));
			m_list.SetCell(nRow, COL_PATH, strTemp);
			
			selectRow(nRow-1);
		}
	}
	
	void moveRowDown()
	{
		vector<uint> vnSels;
		if( !m_list.GetSelRows(vnSels))
			return;
		
		for(int index=0; index<vnSels.GetSize(); index++)
		{
			int nRow = vnSels[index];

			if(nRow<=0 || nRow>= m_list.GetRows()-1)
				return;
			
			string strTemp = m_list.GetCell(nRow+1, COL_NAME);
			m_list.SetCell(nRow+1, COL_NAME, m_list.GetCell(nRow, COL_NAME));
			m_list.SetCell(nRow, COL_NAME, strTemp);
			
			strTemp = m_list.GetCell(nRow+1, COL_PATH);
			m_list.SetCell(nRow+1, COL_PATH, m_list.GetCell(nRow, COL_PATH));
			m_list.SetCell(nRow, COL_PATH, strTemp);
			
			selectRow(nRow+1);	
		}
	}

	bool isFullPath(string strPageList)
	{
		if( -1 == strPageList.Find(CHAR_FLD_SEPARATOR))
			return false;
		return true;
	}
	
public:
	string GetPages(bool bIncludePath = false)
	{		
		return getPageList();		
	}
	
private:
	bool loadGraphPageThumbnail(string &strPageName)
	{
		GraphPageBase 		pgb = Project.Pages(strPageName);
		
		PictureHolder 		pictHolder;
		if (pgb.IsValid())
			page_get_picture(pgb, pictHolder, "EMF", 72, false);
		else
		{
			// Show "NONE Preview" if page is invalid	 
			string strPath = GetFullPath(STR_PICT_NO_PREVIEW ".emf", "Templates\\Previews", TRUE);
			
			if(strPath.IsFile())
	  		{
		   		m_pcPrev.DrawMode = PCDM_STRETCH_FILL;
		   		HENHMETAFILE henhmf1 = load_enhanced_metafile(strPath);
				return m_pcPrev.SetEnhMetaFile(henhmf1);
			}
		}
		
    	m_pcPrev.Visible = false;
    	if(pictHolder)
    	{
	    	m_pcPrev.SetPicture(pictHolder);
	    	m_pcPrev.KeepAspectRatio = true;
	    	m_pcPrev.Visible = true;
	    	return true;
    	}
    	return false;
	}	

#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
	void updateOKBtnStatus(bool bCheckRowCountOnly = true)
	{
		BOOL bShouldBeEnable = FALSE;

		if ( m_bMultiplePages )
		{
			int nListRows = m_list.GetRows() - m_list.GetRowOffset();

			bool bGraphChanged = true;
			if ( !bCheckRowCountOnly )
			{
				string strCurrent;
				strCurrent.SetTokens(m_vsPageList);
				bGraphChanged = m_strDiff.IsEmpty() || strCurrent.CompareNoCase(m_strDiff) != 0;
			}

			///Jasmine 05/11/2012 ORG-4971-S2 ALLOW_REMOVE_ALL_LINKED_GRAPHS
			//bShouldBeEnable = nListRows > 0 && bGraphChanged;
			bShouldBeEnable = (nListRows > 0 || (nListRows == 0 && m_bAllowRemoveAll)) && bGraphChanged;
			///End ALLOW_REMOVE_ALL_LINKED_GRAPHS
		}
		else
		{
			///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
			//vector <string> vsPages;
			//m_pListView->GetSelectedPages(vsPages);
			//bShouldBeEnable = vsPages.GetSize() != 0;
			if ( isFolderViewChecked() == VIEW_MODE_LIST )
			{
				bShouldBeEnable = !m_PageView.GetSelectedPage().IsEmpty();
			}
			else
			{
				FolderView* pFolderView = m_PageView.GetFolderViewPointer();
				ASSERT(NULL != pFolderView);
				bShouldBeEnable = ( pFolderView && pFolderView->IsSpecifiedPageTypeSelected(EXIST_GRAPH) );
			}
			///end RECOVER_FOLDER_VIEW
		}

		GetItem(IDOK).Enable = bShouldBeEnable;
	}
#endif // __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY

private:

	TreeEditControl 		m_list;
							
	///Philip 08/14/2012 ORG-4284-S8 RECOVER_FOLDER_VIEW
	//ListView*			m_pListView;
	PageViewManager			m_PageView;
	///end RECOVER_FOLDER_VIEW
	
	vector<QUERYRESULTNAME>	m_vsColTypes;
							
	Tree					m_tree;
	PictureControl 			m_pcPrev;
							
	vector<string>			m_vsPageList;
	bool					m_bCloseOnDBClick;
	string					m_strDlgTitle;
	string					m_strRegisterName;
	vector<int>				m_vnPageTypes;
	string					m_strStartPath;
	string					m_strSel;	
	bool					m_bShowFolders;
	bool					m_bMultiplePages;
	bool					m_bLName;
	bool					m_bEmbed;
	bool					m_bIncludeShortcut;
	bool					m_bCell;
	string					m_strDiff;
	bool					m_bEnableEmbed;
	int						m_nPageType;
							
	bool					m_bSortPages;
	bool					m_bFilter3DGraph;
	bool					m_bAllowRemoveAll;	///Jasmine 05/11/2012 ORG-4971-S2 ALLOW_REMOVE_ALL_LINKED_GRAPHS
							
	string					m_strFilterFuncName;
											
	FolderContainer			*m_pComboUsingFolder;
	/// Zech 12/12/2011 CLEAN_UP_QUERYRESULTEX
	//Array<QueryResultEx&>	m_arrQuery;
	/// END CLEAN_UP_QUERYRESULTEX
	FolderBrowserStatus		m_stFB;
	
	/// Zech 12/12/2011 CLEAN_UP_QUERYRESULTEX
	//int						m_nLastComboSel;
	/// END CLEAN_UP_QUERYRESULTEX

	/// Zech 12/12/2011 ORG-4284-S1 CHANGE_SPECIFIED_FOLDER_GUI_STYLE
	QueryResult				m_qr;
	bool					m_bShowPathText;
	bool					m_bShowSpecifiedBtn;
	/// END CHANGE_SPECIFIED_FOLDER_GUI_STYLE
	
	///Philip 08/14/2012 ORG-6430-S2 ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
	bool					m_bExistLURecord;
	bool					m_bOutdatedChecked;
	vector<string>			m_vsLastUsedRecords;
	///end ALLOW_SELLIST_TO_LOAD_LAST_USED_GRAPHS
};

////////////////////////////end class PagePreviewListView/////////////////////////////////

/// Zech 12/12/2011 CLEAN_UP_QUERYRESULTEX
/*
/// Zech 11/29/2011 ORG-4284 CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
BOOL GetQueryStringForSelFolder (string &str, LPVOID lp = NULL)
{	
	PagePreviewListDlg *pPreviewDlg = (PagePreviewListDlg*)lp;
	vector<string> vsPaths;
	bool bRecursive = false;
	if (NULL != pPreviewDlg)
	{
		pPreviewDlg->GetLastFolderSelectStatus(vsPaths, bRecursive);
	}
	FolderBrowserDlg dlg(vsPaths, bRecursive);
	int nRet = dlg.DoModalEx();
	if (nRet == IDOK)
	{
		vector<string> vsSelPaths;

		if (NULL != pPreviewDlg)
		{
			dlg.GetDlgStatus(vsSelPaths, bRecursive);
			pPreviewDlg->SetLastFolderSelectStatus(vsSelPaths, bRecursive);
			vsSelPaths.RemoveAll();
		}

		dlg.GetQuerySuffix(vsSelPaths);
		string strTemp;
		strTemp.SetTokens(vsSelPaths, ',');
		str = "SELECT GRAPH FROM " + strTemp;
		return true;
	}
	else
	{
		return false;
	}
}
/// END CLEAN_FOLDER_VIEW_AND_ADD_FOLDER_SEL_BROWSER
*/
/// END CLEAN_UP_QUERYRESULTEX

BOOL PagePreviewListGraph(HWND hWndParent, string& strGraphs, LPCSTR lpcszStartPath = NULL, DWORD dwCtrl = SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED, int nPageType = EXIST_GRAPH, LPCSTR lpcszFilterFuncName = NULL)
{
	vector<string>	vsPages;
	vector<int> 	vnPageTypes = {EXIST_GRAPH};	
	PagePreviewListDlg 	myDlg(vnPageTypes, strGraphs, NULL, lpcszStartPath, dwCtrl, nPageType, lpcszFilterFuncName);
	Window winExDlg = myDlg.GetWindow();
	if(winExDlg)
	{
		out_str("Dialog already open");
		return false;
	}
	Window winNewDlg(hWndParent);
	HWND hWnd = GetWindow();
	if(winNewDlg)
		hWnd = hWndParent;
	int nRet = myDlg.DoModalEx(hWnd);
	string strPages = myDlg.GetPages();
	if (strPages.IsEmpty())
	{
		///Jasmine 05/11/2012 ORG-4971-S2 ALLOW_REMOVE_ALL_LINKED_GRAPHS
		if( (IDCANCEL != nRet) && (dwCtrl & CAN_REMOVE_ALL) )
		{
			strGraphs = strPages;
			return TRUE;
		}
		//End ALLOW_REMOVE_ALL_LINKED_GRAPHS
		return FALSE;
	}
	strGraphs = strPages;
	return TRUE;
}

///Philip 08/14/2012 ORG-6430-S1 ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST
static bool _get_layer_plot_num(const string& strGraphPage, int* pnLayers, int* pnPlots)
{
	GraphPage gp(strGraphPage);
	if(!gp)
		return false;
	int nLay = 0;
	int nPlt = 0;
	foreach(GraphLayer gl in gp.Layers)
	{
		if(gl)
		{
			nLay++;
			foreach(DataPlot dp in gl.DataPlots)
			{
				if(dp)
					nPlt++;
			}
		}
	}
	if(pnLayers)
		*pnLayers = nLay;
	if(pnPlots)
		*pnPlots = nPlt;
	return true;
}

static bool _get_layer_plot_num_vec(const vector<string>& vsGraphPage, vector<int>& vnLayers, vector<int>& vnPlots)
{
	if(!vsGraphPage)
		return false;
	bool bRet = true;
	vector<int> vnLay, vnPlt;
	int nPages = vsGraphPage.GetSize();
	for(int ii = 0; ii < nPages; ii++)
	{
		int nLay, nPlt;
		bool bCurr = _get_layer_plot_num(vsGraphPage[ii], &nLay, &nPlt);
		bRet &= bCurr;
		if(!bCurr) // bad graph page
			nLay = nPlt = -1;
		vnLay.Add(nLay);
		vnPlt.Add(nPlt);
	}
	if(vnLayers)
	{
		vnLayers.RemoveAll();
		vnLayers = vnLay;
	}
	if(vnPlots)
	{
		vnPlots.RemoveAll();
		vnPlots = vnPlt;
	}
	return bRet;
}
///end ADD_MORE_COLUMNS_TO_LISTVIEW_AND_SELLIST

static int _get_layers_per_page(const vector<string>& vsPages, vector<string>& vsLayersOfPage = NULL_OBJ, vector<int>& vnLayerNum = NULL_OBJ, char* pcGetDelimiter = NULL, bool bUseRangeStr = false)
{	
	if(!vsPages)
		return 0;		
	int nSize;
	if(0 == (nSize = vsPages.GetSize()))
		return 0;
		
	if(vsLayersOfPage)
	{
		vsLayersOfPage.RemoveAll();
		vsLayersOfPage.SetSize(nSize);
	}
	if(vnLayerNum)
	{
		vnLayerNum.RemoveAll();
		vnLayerNum.SetSize(nSize);
	}
		
	vector<string> vsTokens;
	const char cDelimiter = '|';		
	for(int ii = 0; ii < nSize; ii++)
	{
		Page pg(vsPages[ii]);
		if(!pg)
			return -ii;
		
		foreach(Layer lyr in pg.Layers)
		{
			string strTok;
			if(!bUseRangeStr)
				strTok = lyr.GetName();
			else
				lyr.GetRangeString(strTok);
			vsTokens.Add(strTok);
		}				
		if(vsLayersOfPage)
			vsLayersOfPage[ii].SetTokens(vsTokens, cDelimiter);
		if(vnLayerNum)
			vnLayerNum[ii] = vsTokens.GetSize();
			
		vsTokens.RemoveAll();
	}
		
	if(pcGetDelimiter)
		*pcGetDelimiter = cDelimiter;
		
	return nSize;
}
	
static int _get_plots_per_layer(const GraphPage& GP, vector<string>& vsPlotsOfLayer = NULL_OBJ, vector<int>& vnPlotNum = NULL_OBJ, char* pcGetDelimiter = NULL, bool bUseRangeStr = false)
{
	if(!GP)
		return 0;
	
	if(vsPlotsOfLayer)
		vsPlotsOfLayer.RemoveAll();
	if(vnPlotNum)
		vnPlotNum.RemoveAll();
		
	int ii = 0;
	vector<string> vsTokens;
	const char cDelimiter = '|';		
	foreach(GraphLayer gl in GP.Layers)
	{
		foreach(DataPlot dp in gl.DataPlots)
		{
			string strTok;
			if(!bUseRangeStr)
				strTok = dp.GetName();
			else
				dp.GetRangeString(strTok);
			vsTokens.Add(strTok);
		}		
		string strPlots;
		strPlots.SetTokens(vsTokens, cDelimiter);
		if(vsPlotsOfLayer)
			vsPlotsOfLayer.Add(strPlots);
		if(vnPlotNum)
			vnPlotNum.Add(vsTokens.GetSize());
			
		vsTokens.RemoveAll();
		ii++;
	}
	
	if(pcGetDelimiter)
		*pcGetDelimiter = cDelimiter;
	
	return ii;
}
