/*------------------------------------------------------------------------------*
 * File Name: PBObjectList.c													*
 * Creation: 																	*
 * Purpose: A Control base class for showing a list of pages 					*
 * Copyright (c) Originlab Corp., 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Folger 05/08/07 MODIFY_SHOWN													*
 * Folger 05/14/07 ADD_COMMENTS_TO_COLUMN_BROWSER								*
 * Folger 06/18/07 ADD_GET_SELECTION_RANGE_STRING								*
 * Folger 06/20/07 CREATE_GET_INIT_RANGE_STRING									*
 * Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE								*
 * Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE				*
 * Folger 07/13/07 RESOLVE_COLUMN_AND_MATOBJ_RANGE_STRING_RESPECTIVELY			*
 * Folger 07/16/07 SET_PB_COLUMNS_SHOWN_STATE_IS_NEEDED_ACCORDING_TO_DIFFERENT_ORIGIN_OBJECTS
 * Folger 07/17/07 NEED_ADD_COLUMN_SHEET_NAME_FOR_GLOBAL_USE					*
 * Folger 07/17/07 ADD_DWORD_PARAMETER_IS_NEED									*
 * Jasmine 07/17/07 SUPPORT_XY_RANGE											*
 * Jasmine 07/18/07 ADD_MORE_COLUMN_INFO										*
 * Jasmine 07/18/07 SET_SHOW_COLUMN_WITH_VECTOR_UINT							*
 * Jasmine 07/18/07 COLUMN_LIST_MENU											*
 * Folger 07/19/07 CUSTOMERIZE_CONTEXT_MENU_FOR_MATOBJ							*
 * Jasmine 07/19/07 DONT_ADD_X_COLUMN_IF_XY_RANGE								*
 * Folger 07/23/07 MAKE_COLUMN_AND_MATOJB_RANGE_STRING_RESPECTIVELY				*
 * Jasmine 07/23/07 ADD_PLOT_LIST_CLASS											*
 *	CPY 7/24/2007 SHOULD_NOT_HARD_CODE_RANGE_CONSTRUCTION_IN_OC_LEVEL			*
 *	Folger 07/25/07 CLEAN_UP_ALL_RANGE_PROCEESING_CODE_IN_OC					*
 *	Folger 07/25/07 UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND			*
 *	Folger 07/26/07 SAVE_COLUMN_HIDDEN_INFO_INTO_REGISTRY						*
 *	Folger 07/31/07 ONLY_SHOW_Y_COLUMN_IN_XYRANGE_BROWSER						*
 *	Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE						*
 *	Folger 08/06/07 HIDE_COLUMNS_BY_USER_STORY									*
 *	Folger 08/13/07 HIDE_MORE_COLUMNS_WHICH_IS_NOT_NEEDED						*
 *	Jasmine 09/28/07 QA70-10305 FILTER_OUT_NON_IMAGE_MATRIX						*
 *	Folger 11/07/07 COLUMN_HEADING_LOCALIZE										*
 *  Kyle 07/15/08 QA80-11840 MOVE_SHOWMENU_TO_BASE_CLASS						*
 *  Kyle 07/15/08 QA80-11840 OVER_LOAD_FUNCTION_GETDEFAULTSHOW 					*
 *	Folger 11/28/09 QA81-13230-P8 COLUMN_BROWSER_FAILS_TO_INIT_NUMERIC_SHEET_NAME_WITH_QUOTES
 *	Folger 07/06/2011 CLEANUP_BAD_CODE_IN_RANGE_BROWSER							*
 *	Folger 12/15/2011 ORG-4601-P2 TRANSLATE_OP_ESCAPE_STR_FOR_COLUMN_BROWSER	*
 *	Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"
#include <okocutils.h>

#include "PBListBase.h"

//-------Folger 07/17/07 NEED_ADD_COLUMN_SHEET_NAME_FOR_GLOBAL_USE
//#define OBJECT_LIST_COL_HEADER		"Index|SName|LName|Comments|Designation|Format|Size|Type"		///Folger 05/14/07 ADD_COMMENTS_TO_COLUMN_BROWSER
//------ Folger 07/26/07 ADD_FIRSTVALUE_IN_OBJECT_LIST
//#define OBJECT_LIST_COL_HEADER		"Sheet|Index|SName|LName|Comments|Designation|Format|Size|Type|Parameters|User-Defined Parameter1"	///Jasmine 07/18/07 ADD_MORE_COLUMN_INFO
//------ Folger 11/07/07 COLUMN_HEADING_LOCALIZE
//#define OBJECT_LIST_COL_HEADER		_L("Sheet|Index|SName|LName|Comments|Designation|Format|Size|1st Value|Type|Parameters|User-Defined Parameter1")
#ifndef _CAT
#define _CAT "PEObject"
#endif
#define OBJECT_LIST_COL_HEADER		_LC("Sheet|Index|SName|LName|Comments|Designation|Format|Size|1st Value|Type|Parameters|User-Defined Parameter1", _CAT)
//------ End COLUMN_HEADING_LOCALIZE
//------ End ADD_FIRSTVALUE_IN_OBJECT_LIST
//-------End NEED_ADD_COLUMN_SHEET_NAME_FOR_GLOBAL_USE

//Jasmine 07/18/07 COLUMN_LIST_MENU
///Jasmine 07/23/07 ADD_PLOT_LIST_CLASS, support dataplot
//------Folger 07/25/07 UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
//class PBColumnListMenu : public PBListMenu
//{
//public:
	//PBColumnListMenu(vector<string> vsItems, vector<uint> vnDisplayItems, vector<byte> vbCols) : PBListMenu(vsItems, vnDisplayItems, vbCols)
	//{
	//}
	//virtual bool GetCommand(int& nChoice)
	//{
		//if(m_nChoice >= 0 && m_nChoice <= PEOBJECT_UDL + 2)//MF_SEPARATOR and "Show All"
		//{
			//nChoice = m_nChoice;
			//return true;
		//}
		//return false;
	//}
//};
//------End UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
///End ADD_PLOT_LIST_CLASS
///End COLUMN_LIST_MENU

class OC_REGISTERED PBObjectList : public PBListBase
{
public:
	PBObjectList()
	{
		//------ Folger 11/07/07 COLUMN_HEADING_LOCALIZE
		//GetFormatStrAsArray(OBJECT_LIST_COL_HEADER, m_vsColHeadings, "PEObject");
		GetFormatStrAsArray(OBJECT_LIST_COL_HEADER, m_vsColHeadings, _CAT);
		//------ End COLUMN_HEADING_LOCALIZE
	}
	~PBObjectList()
	{
		
	}
	//-----Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
	//void Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName )
	void Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName, int nShowItemType )
	//-----End ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
	{
		//-----Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
		//PBListBase::Init(nID, dlg, lpcszDlgName);
		PBListBase::Init(nID, dlg, lpcszDlgName, nShowItemType);
		
		m_PBBType = ITEM_IS_OBJECT;
		
		m_nShowItemType = nShowItemType;
		m_dwCtrl = 0;
		m_bXYRange = false;
		//--------Folger 07/16/07 SET_PB_COLUMNS_SHOWN_STATE_IS_NEEDED_ACCORDING_TO_DIFFERENT_ORIGIN_OBJECTS
		//if (nShowItemType == EXIST_MATRIX)
		//{
			//vector<byte> vbDefaultShowCols = {0, 0, 0, 1, 1, 0, 0, 0};		
			//LoadHideCols(lpcszDlgName, NULL, &vbDefaultShowCols);	//Load and update the column show state
		//}
		//SetShowColumns();
		//--------End SET_PB_COLUMNS_SHOWN_STATE_IS_NEEDED_ACCORDING_TO_DIFFERENT_ORIGIN_OBJECTS
		//-----End ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
	}
	virtual int GetPBListType()
	{
		return PB_BROWSER_OBJECT_LIST;
	}
	virtual int GetItemType(int nRow)
	{
		string strType;
		strType =GetCell(nRow,PEOBJECT_TYPE);
		if(strType.IsEmpty())
			return ITEM_IS_NULL;
		
		if(strType.CompareNoCase("Folder") == 0)
			return ITEM_IS_FOLDER;
			
		return ITEM_IS_OBJECT;
	}
	virtual void GetBrowserSupportTypeList(vector<int> &vnList)
	{
		vector<int> vnTypeLit = {EXIST_PLOT, EXIST_MATRIX}; 
		vnList = vnTypeLit;
	}
	
	///Kyle 07/15/08 QA80-11840 OVER_LOAD_FUNCTION_GETDEFAULTSHOW
	virtual int	GetDefaultShow( Layer& lay, GridTreeControl* pGridTree, LPCSTR lpcszDefaultShow = NULL )
	{
		int nRow =- 1;
		if( !lay )
			return -1;

		string strDefaultShow( lpcszDefaultShow );
		if( strDefaultShow.IsEmpty() )
		{
			lay.GetRangeString( strDefaultShow );
			strDefaultShow.TrimRight('!');
		}
		else
		{
			string	strBook, strSheet, strCol;
			okutil_parse_complete_range_string(strDefaultShow, strBook, strSheet, strCol);
			okutil_create_complete_range_string_obj(strDefaultShow, strBook, strSheet, NULL);
		}
		nRow = pGridTree->FindRow( strDefaultShow );

		return nRow;
	}
	///End OVER_LOAD_FUNCTION_GETDEFAULTSHOW
	
	///Sophy CLEAN_CODE_PBLIST_CONTROL
	/*
	virtual bool UpdateList(TreeNode trNode, int nShowItemType = 0)
	{
		if(!trNode.IsValid())
			return false;
		
		string strPath;
		trNode.GetAttribute(STR_PATH_ATTRIB, strPath);	
		
		Folder fldr(strPath);		
		//----- Iris 12/22/2006 CHOOSE_PAGE_IN_LEFT_SHOULD_SHOW_LAYER_IN_RIGHT_PANEL
			//return UpdateList(fldr , nShowItemType);
		if(fldr)
			///Folger 05/08/07 MODIFY_SHOWN
			//return UpdateList(fldr , nShowItemType);
			ClearAll();
			///End MODIFY_SHOWN
		//
		string 	strName;
		trNode.GetAttribute(STR_LABEL_ATTRIB, strName);
		Page	pg(strName);
		if(pg)
			///Folger 05/08/07 MODIFY_SHOWN
			//return UpdateList(pg, nShowItemType);
			ClearAll();
			///End MODIFY_SHOWN
		string strPage;
		okutil_get_book_sheet_names(strName, &strPage, &strName); 
		Page pgTemp(strPage);
		Layer lay = pgTemp.Layers(strName);
		if(lay)
			UpdateList(lay);
		
		return false;
		//-----
	}
	*/
	//virtual
	bool	GetItems( TreeNode& trNode, 
					vector<string>& vsItems, vector<int>& vnPageType, 
					vector<DWORD>& vdwStatus,//vector<bool>& vbHideGray, ///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
					int nShowItemType = 0,
					bool bIncludeShortcut = false)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	{
		if(!trNode.IsValid())
			return false;
		
		string strPath;
		trNode.GetAttribute(STR_PATH_ATTRIB, strPath);	
		
		Folder fldr(strPath);		
		//----- Iris 12/22/2006 CHOOSE_PAGE_IN_LEFT_SHOULD_SHOW_LAYER_IN_RIGHT_PANEL
			//return UpdateList(fldr , nShowItemType);
		if(fldr)
			///Folger 05/08/07 MODIFY_SHOWN
			//return UpdateList(fldr , nShowItemType);
			ClearAll();
			///End MODIFY_SHOWN

		string 	strName;
		trNode.GetAttribute(STR_LABEL_ATTRIB, strName);
		Page	pg(strName);
		if(pg)
			ClearAll();
		
		string strPage;
		okutil_get_book_sheet_names(strName, &strPage, &strName); 
		Page pgTemp(strPage);
		Layer lay = pgTemp.Layers(strName);
		if(lay)
			return GetItems( lay, vsItems, vnPageType, vdwStatus );
		
		return false;
	}
	///end Sophy CLEAN_CODE_PBLIST_CONTROL
	
	///Folger 06/18/07 ADD_GET_SELECTION_RANGE_STRING
	//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
	//virtual string GetSelectionRangeString()
	///Jasmine 07/17/07 SUPPORT_XY_RANGE
	virtual int GetSelectionRangeString(vector<string> &vsSelected)
	//--------end CLEAN_UP_GET_RANGE_STRING_CODE
	{
		//vector<string> vsSelected;		//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
		GetSelItems(vsSelected);
		///Jasmine 07/19/07 DONT_ADD_X_COLUMN_IF_XY_RANGE
		int nCount = vsSelected.GetSize();
		vector<string> vsSheet;
		vector<uint> vnIndeces, uBegins, uEnds;
		for(int ii = 0; ii < nCount; ii++)
		{
			vector<string> vsTemp;
			string strTemp = vsSelected[ii];
			if(m_dwCtrl && SHOW_LAYER_NAME)
			{
				if(!strTemp.GetTokens(vsTemp, '!'))
					continue;
				vsSheet.Add(vsTemp[0]);
				vnIndeces.Add(atoi(vsTemp[1]));
			}
			else
				vnIndeces.Add(atoi(strTemp));
		}
		//int nRet = find_contiguous_range(vnIndeces, uBegins, uEnds);
		//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
		//vector<string> vsResult;
		vsSelected.RemoveAll();
		//--------end CLEAN_UP_GET_RANGE_STRING_CODE
		if(m_dwCtrl && SHOW_LAYER_NAME)//different layer
		{
			int nSize = vnIndeces.GetSize();
			for(ii = 0; ii < nSize; ii++)
			{
				string strWks = vsSheet[ii];
		///End DONT_ADD_X_COLUMN_IF_XY_RANGE
				//----- CPY 7/24/2007 SHOULD_NOT_HARD_CODE_RANGE_CONSTRUCTION_IN_OC_LEVEL
				/*
				if(EXIST_MATRIX == m_nShowItemType)
				{
					//doing...
				}
				Worksheet wks;
				wks_from_book_sheet_name(wks, strWks);

				if(!wks)
					continue;
				int nYCol = vnIndeces[ii] - 1;
				string strTmp, dsXName;
				string dsYName = wks.Columns(nYCol).GetName();
				if(m_bXYRange)
				{
					Curve crv(wks, nYCol);
					if(crv.HasX(dsXName))
					{
						int nIndex = dsXName.Find('_');
						if(0 <= nIndex)
							dsXName = dsXName.Mid(nIndex + 1);
					}
					strTmp.Format(STR_RANGE_FORMAT, strWks + "!", dsXName, dsYName);
				}
				else
					strTmp = make_range_string(wks, dsYName, dsYName);
				if (strTmp != "")
				*/
				int nYCol = vnIndeces[ii] - 1; // LT to OC indexing
				string strTemp;
				int nErr;
				if((nErr = okoc_get_range_str(strWks, nYCol, &strTemp, m_bXYRange?DRR_GET_DEPENDENT:0)) == 0)
					vsSelected.Add(strTemp);
				else
					printf("err getting range at col(%d), err = %d\n", nYCol+1, nErr);
				//----- end SHOULD_NOT_HARD_CODE_RANGE_CONSTRUCTION_IN_OC_LEVEL
			}
		}
		else
		{
			//--------Folger 07/23/07 MAKE_COLUMN_AND_MATOJB_RANGE_STRING_RESPECTIVELY
			//--------Folger 07/13/07 RESOLVE_COLUMN_AND_MATOBJ_RANGE_STRING_RESPECTIVELY
			if (m_nShowItemType == EXIST_WKS)
			{
			//--------End RESOLVE_COLUMN_AND_MATOBJ_RANGE_STRING_RESPECTIVELY
				int nRet = find_contiguous_range(vnIndeces, uBegins, uEnds);
				Worksheet wks(m_wksMatLayer);
				for (ii=0; ii<nRet; ii++)
				{
					int c1 = uBegins[ii] - 1, c2 = uEnds[ii] - 1;
					string strTmp = make_range_string(wks, wks.Columns(c1).GetName(), wks.Columns(c2).GetName());
					if (strTmp != "")
					{
						//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
						//vsResult.Add(strTmp);
						vsSelected.Add(strTmp);
						//--------end CLEAN_UP_GET_RANGE_STRING_CODE
					}
				}
			//--------Folger 07/13/07 RESOLVE_COLUMN_AND_MATOBJ_RANGE_STRING_RESPECTIVELY	
			}
			else
			{
				int nSize = vnIndeces.GetSize();
				MatrixLayer matlay(m_wksMatLayer);
				for (ii=0; ii<nSize; ii++)
				{
					//int c1 = uBegins[ii] - 1, c2 = uEnds[ii] - 1;
					//string strTmp = make_range_string(matlay, matlay.MatrixObjects(c1).GetName(), matlay.MatrixObjects(c2).GetName());
					string strTmp = make_range_string(matlay, matlay.MatrixObjects(vnIndeces[ii] - 1).GetName());
					if (strTmp != "")
						vsSelected.Add(strTmp);
				}
			}
		}
			/*
			int nRet = find_contiguous_range(vnIndeces, uBegins, uEnds);
			Worksheet wks(m_wksMatLayer);
			MatrixLayer matlay(m_wksMatLayer);
			for (ii=0; ii<nRet; ii++)
			{
				int c1 = uBegins[ii] - 1, c2 = uEnds[ii] - 1;
				string strTmp, strName1, strName2;
				if(m_nShowItemType == EXIST_WKS)
				{
					strName1 = wks.Columns(c1).GetName();
					strName2 = wks.Columns(c2).GetName();
					strTmp = make_range_string(wks, strName1, strName2);
				}
				else
				{
					strName1 = matlay.MatrixObjects(c1).GetName();
					strName2 = matlay.MatrixObjects(c2).GetName();	
					strTmp = make_range_string(matlay, strName1, strName2);				
				}
				if (strTmp != "")
					vsSelected.Add(strTmp);
			}
		}
		*/
		//--------End MAKE_COLUMN_AND_MATOJB_RANGE_STRING_RESPECTIVELY
		//--------End RESOLVE_COLUMN_AND_MATOBJ_RANGE_STRING_RESPECTIVELY
		//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
		//string strRet;
		//strRet.SetTokens(vsResult);
		//return strRet;
		return vsSelected.GetSize();
		//--------end CLEAN_UP_GET_RANGE_STRING_CODE
	}
	///End ADD_GET_SELECTION_RANGE_STRING
	///Folger 06/20/07 CREATE_GET_INIT_RANGE_STRING
	//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
	//virtual bool GetInitRangeString(vector<string> &vsVals)
	virtual int GetInitRangeString(vector<string> &vsVals)
	//--------end CLEAN_UP_GET_RANGE_STRING_CODE
	{
		//--------Folger 07/13/07 RESOLVE_COLUMN_AND_MATOBJ_RANGE_STRING_RESPECTIVELY
		//string strWks;
		//Worksheet wks = Project.ActiveLayer();
		//if(wks)
			//wks.GetRangeString(strWks);
		string strLay;
		Layer lay = Project.ActiveLayer();
		lay.GetRangeString(strLay);
		//--------End RESOLVE_COLUMN_AND_MATOBJ_RANGE_STRING_RESPECTIVELY
		int nCount = vsVals.GetSize();
		for(int ii = 0; ii < nCount; ii++)
		{
			string str = vsVals[ii];
			str.TrimLeft(); str.TrimRight();
			if(m_bXYRange)
			{
				//vsVals[ii] = _get_xy_range(str);	//---------Folger 07/25/07 CLEAN_UP_ALL_RANGE_PROCEESING_CODE_IN_OC
				continue;
			}
			DataRange dr;
			dr.Create();
			dr.Add("", str);
			if(1 > dr.GetNumRanges())
			{
				//--------Folger 07/13/07 RESOLVE_COLUMN_AND_MATOBJ_RANGE_STRING_RESPECTIVELY
				//str = strWks + str;
				str = strLay + str;
				//--------End RESOLVE_COLUMN_AND_MATOBJ_RANGE_STRING_RESPECTIVELY
				dr.Add("", str);
			}
			///------ Folger 11/28/09 QA81-13230-P8 COLUMN_BROWSER_FAILS_TO_INIT_NUMERIC_SHEET_NAME_WITH_QUOTES
			//vsVals[ii] = dr.GetDescription(GETLC_PAGE_SHORT_NAME | GETLC_COL_SHORT_NAME|GETLC_COL_NO_FUNC);		///Folger 06/06/07 FIX_BUGS_IN_DEFAULT_SHOW
			vsVals[ii] = dr.GetDescription(GETLC_PAGE_SHORT_NAME | (EXIST_MATRIX == m_nShowItemType ? GETLC_COL_INDEX_NAME : GETLC_COL_SHORT_NAME ) | GETLC_COL_NO_FUNC);
			///------ End COLUMN_BROWSER_FAILS_TO_INIT_NUMERIC_SHEET_NAME_WITH_QUOTES
		}
		//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
		//return true;
		return vsVals.GetSize();
		//--------end CLEAN_UP_GET_RANGE_STRING_CODE
	}
	//---------Folger 07/25/07 CLEAN_UP_ALL_RANGE_PROCEESING_CODE_IN_OC
	//string _get_xy_range(LPCSTR lpcszRange)
	//{
		////----- CPY 7/24/2007 SHOULD_NOT_HARD_CODE_RANGE_CONSTRUCTION_IN_OC_LEVEL
		///*
		//Layer lay = Project.ActiveLayer();
		//string strRange, str = lpcszRange;
		//lay.GetRangeString(strRange);
		//if(is_numeric(str) && lay && EXIST_PLOT == lay.GetPage().GetType())
			//return strRange + str;
		//else if(0 == str.Left(1).CompareNoCase("(") && lay && EXIST_WKS == lay.GetPage().GetType())
		//{
			//str.TrimLeft("(");
			//str.TrimRight(")");
			//vector<string> vs;
			//if(2 != str.GetTokens(vs, ','))
				//return str;
			//int nYCol = -1;
			//string strYCol = vs[1], strXCol = vs[0], strXYRange;
			//Worksheet wks(lay);
			//Column col = wks.Columns(strYCol);
			//if(is_numeric(strYCol))
			//{
				//nYCol = atoi(strYCol) - 1;
				//col = wks.Columns(nYCol);
			//}
			//if(col)
				//nYCol = col.GetIndex();
			//if(strXCol.IsEmpty() && -1 < nYCol)
			//{
				//string dsXName;
				//Curve crv(wks, nYCol);
				//if(crv.HasX(dsXName))
				//{
					//int nIndex = dsXName.Find('_');
					//if(0 <= nIndex)
						//dsXName = dsXName.Mid(nIndex + 1);
					//strXCol = dsXName;
				//}
			//}
			//strXYRange.Format(STR_RANGE_FORMAT, strRange, strXCol, strYCol);
			//return strXYRange;
		//}
		//return str;
		//*/
		//DWORD dwCntrl = PRSC_NUMERIC_OBJECT_DESCRIPTOR_COL | PRS_SINGLEWORD_KEYWORD_OBJECT | PRS_SINGLEWORD_LOOSE_DATASET | PRSC_LEVEL_OBJECT;
		//string strRange;
		//int nErr = okutil_complete_range_string(&strRange, lpcszRange, dwCntrl);
		//return strRange;
		////----- end SHOULD_NOT_HARD_CODE_RANGE_CONSTRUCTION_IN_OC_LEVEL 
	//}
	///End CREATE_GET_INIT_RANGE_STRING
	//---------End CLEAN_UP_ALL_RANGE_PROCEESING_CODE_IN_OC
	//--------Folger 07/16/07 SET_PB_COLUMNS_SHOWN_STATE_IS_NEEDED_ACCORDING_TO_DIFFERENT_ORIGIN_OBJECTS
	//--------Folger 07/17/07 ADD_DWORD_PARAMETER_IS_NEED
	//virtual BOOL SetShowColumns()
	///Jasmine 07/18/07 SET_SHOW_COLUMN_WITH_VECTOR_UINT
	//virtual BOOL SetShowColumns(DWORD dwShowCols = 0)
	virtual BOOL SetShowColumns(const vector<uint>& vnShowColumns = NULL)
	//--------End ADD_DWORD_PARAMETER_IS_NEED
	{
		//--------Folger 07/17/07 ADD_DWORD_PARAMETER_IS_NEED
		//if (m_nShowItemType == EXIST_MATRIX)
		//{
			////-------Folger 07/17/07 NEED_ADD_COLUMN_SHEET_NAME_FOR_GLOBAL_USE
			////vector<byte> vbDefaultShowCols = {0, 0, 0, 1, 1, 0, 0, 0};
			//vector<byte> vbDefaultShowCols = {1, 0, 0, 0, 1, 1, 0, 0, 0};
			////-------End NEED_ADD_COLUMN_SHEET_NAME_FOR_GLOBAL_USE
			//LoadHideCols(NULL, NULL, &vbDefaultShowCols);	//Load and update the column show state
		//}
		////-------Folger 07/17/07 NEED_ADD_COLUMN_SHEET_NAME_FOR_GLOBAL_USE
		//else
		//{
			//vector<byte> vbDefaultShowCols = {1, 0, 0, 0, 0, 0, 0, 0, 0};
			//LoadHideCols(NULL, NULL, &vbDefaultShowCols);
		//}
		////-------End NEED_ADD_COLUMN_SHEET_NAME_FOR_GLOBAL_USE
		//--------Folger 07/17/07 ADD_DWORD_PARAMETER_IS_NEED
		vector<byte> vbShowCols;// = {0, 0, 0, 0, 0, 0, 0, 0};
		vbShowCols.SetSize(PEOBJECT_LAST_ITEM);
		vbShowCols = 1;
		//------Folger 07/19/07 CUSTOMERIZE_CONTEXT_MENU_FOR_MATOBJ
		//if (m_nShowItemType == EXIST_MATRIX)
			//vbShowCols[PEOBJECT_COMMENTS] = vbShowCols[PEOBJECT_DESIGNATION] = 1;
		//------End CUSTOMERIZE_CONTEXT_MENU_FOR_MATOBJ
		//vbShowCols.InsertAt(0, !(dwShowCols && SHOW_LAYER_NAME));
		m_vnShowColumns.Data(PEOBJECT_LAYER, PEOBJECT_UDL);
		if(vnShowColumns)
			m_vnShowColumns = vnShowColumns;	
		//------Folger 07/19/07 CUSTOMERIZE_CONTEXT_MENU_FOR_MATOBJ
		if (m_nShowItemType == EXIST_MATRIX)
		{
			//------ Folger 07/26/07 SAVE_COLUMN_HIDDEN_INFO_INTO_REGISTRY
			//m_vnShowColumns.RemoveAt(PEOBJECT_COMMENTS);
			//m_vnShowColumns.RemoveAt(PEOBJECT_DESIGNATION - 1);
			//------ Folger 08/13/07 HIDE_MORE_COLUMNS_WHICH_IS_NOT_NEEDED
			//vector<int> vnColHidden = {PEOBJECT_COMMENTS, PEOBJECT_DESIGNATION};
			vector<int> vnColHidden = {
				PEOBJECT_COMMENTS,
				PEOBJECT_DESIGNATION,
				PEOBJECT_FORMAT,
				PEOBJECT_PARAM,
				PEOBJECT_UDL
			};
			//------ End HIDE_MORE_COLUMNS_WHICH_IS_NOT_NEEDED
			vector<uint> vnIndecies;
			int nSize = vnColHidden.GetSize();
			for (int ii=0; ii<nSize; ii++)
			{
				if(m_vnShowColumns.Find(vnIndecies, vnColHidden[ii]) > 0)
					m_vnShowColumns.RemoveAt(vnIndecies[0]);
			}
			//------ End SAVE_COLUMN_HIDDEN_INFO_INTO_REGISTRY
		}
		//------End CUSTOMERIZE_CONTEXT_MENU_FOR_MATOBJ
		int nSize = m_vnShowColumns.GetSize();
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = m_vnShowColumns[ii];
			if(PEOBJECT_LAST_ITEM > nIndex)
				vbShowCols[nIndex] = 0;
		}
		//------ Folger 08/06/07 HIDE_COLUMNS_BY_USER_STORY
		vbShowCols[PEOBJECT_DESIGNATION] = vbShowCols[PEOBJECT_UDL] = 1;
		//------ End HIDE_COLUMNS_BY_USER_STORY
		//------ Folger 07/26/07 SAVE_COLUMN_HIDDEN_INFO_INTO_REGISTRY
		//SetHiddenCols(vbShowCols);
		LoadHideCols(m_strDlgName, "PBObjectList", &vbShowCols);
		//------ End SAVE_COLUMN_HIDDEN_INFO_INTO_REGISTRY
		vector<uint> vecIndex;
		if(0 < m_vnShowColumns.Find(vecIndex, PEOBJECT_LAYER))
			m_dwCtrl |= SHOW_LAYER_NAME;//dwShowCols;
		return true;
	}
	///End SET_SHOW_COLUMN_WITH_VECTOR_UINT
	//--------End SET_PB_COLUMNS_SHOWN_STATE_IS_NEEDED_ACCORDING_TO_DIFFERENT_ORIGIN_OBJECTS
	///Kyle 07/15/08 QA80-11840 MOVE_SHOWMENU_TO_BASE_CLASS
	/////Jasmine 07/18/07 COLUMN_LIST_MENU
	//virtual BOOL ShowMenu(int nx, int ny)
	//{
		//vector<byte> vbCheck;
		//GetHiddenCols(vbCheck);
		////------Folger 07/25/07 UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
		////PBColumnListMenu	myMenu(m_vsColHeadings, m_vnShowColumns, vbCheck);
		//PBListMenu	myMenu(m_vsColHeadings, m_vnShowColumns, vbCheck, 0, PEOBJECT_UDL + 2);
		////------End UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
		//myMenu.TrackPopupMenu(0,  nx, ny, GetWindow());
		//int nCmd;
		//if(myMenu.GetCommand(nCmd))
		//{
			//int nIndex;
			//int nSize = m_vnShowColumns.GetSize();
			//if(nCmd < nSize)
			//{
				//nIndex = m_vnShowColumns[nCmd];
				//if(vbCheck.GetSize() > nIndex)
					//HideCol(nIndex, !vbCheck[nIndex]);
				//return TRUE;
			//}
			////show all
			//for(int ii = 0; ii < nSize; ii++)
			//{				
				//nIndex = m_vnShowColumns[ii];
				//if(vbCheck.GetSize() > nIndex)
					//vbCheck[nIndex] = 0;
			//}
			//SetHiddenCols(vbCheck);
			//return TRUE;
		//}
		//return FALSE;
	//}
	/////End COLUMN_LIST_MENU
	///End MOVE_SHOWMENU_TO_BASE_CLASS
	///Jasmine 07/17/07 SUPPORT_XY_RANGE
	virtual void SetShowXYRange(bool bXYRange)
	{
		m_bXYRange = bXYRange;
	}
	///End SUPPORT_XY_RANGE
protected:
	virtual string GetRuntimeClass()
	{
		return "PBObjectList";
	}
	//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//virtual	bool AddItems(PageBase &pb)
	virtual bool AddItems(PageBase &pb, 
						vector<string> &vsRows, vector<int> &vnPageType, 
						vector<DWORD>& vdwStatus,//vector<bool> &vbHideGray)	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
						const Folder& fldParent = NULL)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	{
		if(!pb)
			return false;
		
		Page page = pb;
		///------ Folger 07/06/2011 CLEANUP_BAD_CODE_IN_RANGE_BROWSER
		/*
		int nLayers = numOfLayers(page);
		Page* ppb;
		switch(pb.GetType())
		{
		case EXIST_WKS:
			ppb = new WorksheetPage(pb);
			break;
		case EXIST_PLOT:
			ppb = new GraphPage(pb);
			break;
		case EXIST_MATRIX:
			ppb = new MatrixPage(pb);
			break;
		default:
			return true;
		}
		for(int ii = 0; ii < nLayers; ii++)
		{
			Layer lay = ppb->Layers(ii);
		*/
		if ( !page )
			return false;
		foreach ( Layer lay in page.Layers )
		{
		///------ End CLEANUP_BAD_CODE_IN_RANGE_BROWSER
			//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
			//AddItems(lay);
			vector<string> vsSubRows;
			vector<int> vnSubPageType;
			vector<DWORD> vdwSubStatus;
			AddItems(lay, vsSubRows, vnSubPageType, vdwSubStatus);
			vsRows.Append(vsSubRows);
			vnPageType.Append(vnSubPageType);
			vdwStatus.Append(vdwSubStatus);
			//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		}
		///------ Folger 07/06/2011 CLEANUP_BAD_CODE_IN_RANGE_BROWSER
		//delete ppb;
		///------ End CLEANUP_BAD_CODE_IN_RANGE_BROWSER
		return true;
	}
	//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//virtual	bool AddItems(Layer &lay)
	virtual	bool AddItems(Layer &lay, 
						vector<string> &vsRows, vector<int> &vnPageType, 
						vector<DWORD>& vdwStatus)//vector<bool> &vbHideGray)	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
	//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	{
		///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX
		if (!lay)
			return false;
		Page pg = lay.GetPage();
		int nPageType = pg.GetType();
		if(EXIST_WKS == nPageType && (m_dwFilter & SCD_NO_RESULT_SHEET))
		{
			Worksheet wks(lay);
		//if(wks && !m_bResultSheet && (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY))
			if(wks && (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY))
				return true;
		}
		///End FILTER_OUT_NON_IMAGE_MATRIX
		m_wksMatLayer = lay;		///Folger 06/18/07 ADD_GET_SELECTION_RANGE_STRING
		
		int nCount;
		//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		bool bHideGray = pg.GetShow() == PAGE_HIDDEN;
		//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		DWORD dwStatus = bHideGray? PAGE_STATUS_HIDDEN : 0;	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
		switch(nPageType)
		{
		case EXIST_WKS:
			Worksheet wks(lay);
			foreach(Column col in wks.Columns)
			{
				if (!m_bXYRange || col.GetType() == OKDATAOBJ_DESIGNATION_Y)		//------ Folger 07/31/07 ONLY_SHOW_Y_COLUMN_IN_XYRANGE_BROWSER
				//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
					//AddItems(col);
				{
					///------ Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
					if ( IsFilterByTag(col) )
						continue;
					///------ End BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER

					vsRows.Add(MakeRow(col));
					vnPageType.Add(-1);			//no need to show icon
					vdwStatus.Add(dwStatus);
				}
				//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
			}
			break;
		case EXIST_MATRIX:
			MatrixLayer ml(lay);
			foreach(MatrixObject matobj in ml.MatrixObjects)
			{
				///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX
				BOOL bIncludeGrayScale = FALSE;
				if((m_dwFilter & SCD_IMAGE_MATRIX_ONLY) && TRUE == matobj.HasData(bIncludeGrayScale))
					continue;
				///End FILTER_OUT_NON_IMAGE_MATRIX

				///------ Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
				if ( IsFilterByTag(matobj) )
					continue;
				///------ End BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER

				//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
					//AddItems(matobj);
				{
					vsRows.Add(MakeRow(matobj));
					vnPageType.Add(-1);			//no need to show icon
					vdwStatus.Add(dwStatus);
				}
				//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
			}
			break;
		default:
			break;
		}
		
		return true;
	}
	//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//virtual bool AddItems(DataObjectBase &dataobj)	///Jasmine 07/23/07 ADD_PLOT_LIST_CLASS	
	//{
		//string strItem = MakeRow(dataobj);
		//m_flx.AddItem(strItem);
		//ResizeCols();		///Folger 05/08/07 MODIFY_SHOWN
		//Layer ly;
		//dataobj.GetParent(ly);
		//Page pg = ly.GetPage();
////		SetCellIcon(m_flx.Rows - 1, 0, get_page_display_id(pg.GetType()), MODULE_ORIGIN);		///Folger 05/08/07 MODIFY_SHOWN
		//if(pg.GetShow() == PAGE_HIDDEN)
			//SetHideGray(m_flx.Rows-1, 0);
		//return true;
	//}
	//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	virtual string MakeCol(OriginObject &obj, int nColType)
	{
		DataObject dataobj;
		dataobj = obj;
		return getDataObjProperties(dataobj, nColType);
	}
	virtual string GetSeletedItemName(int nRow, bool bIncludeFolder = false)
	{
		string strSeletedName;
		if((GetItemType(nRow) != ITEM_IS_OBJECT && !bIncludeFolder) || nRow == 0)
			return "";	
		///Jasmine 07/19/07 DONT_ADD_X_COLUMN_IF_XY_RANGE
		if(m_bXYRange)
		{
			string strDesign = GetCell(flexcpText, nRow, PEOBJECT_DESIGNATION);
			if(0 == strDesign.CompareNoCase("X"))
				return "";
		}
		strSeletedName = GetCell(flexcpText, nRow, PEOBJECT_INDEX);
		if(m_dwCtrl && SHOW_LAYER_NAME)
			strSeletedName = GetCell(flexcpText, nRow, PEOBJECT_LAYER) + "!" + strSeletedName;
		///End DONT_ADD_X_COLUMN_IF_XY_RANGE
		return strSeletedName;
	}
	
	string GetLayerName(int nRow, bool bIncludeFolder = false)
	{
		string strSeletedName;
		if((GetItemType(nRow) != ITEM_IS_OBJECT && !bIncludeFolder) || nRow == 0)
			return "";		
		strSeletedName = GetCell(flexcpText, nRow, PEOBJECT_LAYER);
		return strSeletedName;
	}
private:
	///Return the num of the layers in the page.
	UINT numOfLayers(Page &pb)
	{
		if(!pb)
			return -1; //Change 0 to -1 mean not a valid page
		UINT nLayers;
		switch(pb.GetType())
		{
		case EXIST_NOTES:
		case EXIST_LAYOUT:
			return 0;	//Change 1 to 0 mean not just one layer, if use 1 will confuse with worksheetpage with one layer
		case EXIST_WKS:
		case EXIST_EXTERN_WKS:
			WorksheetPage wks(pb);
			nLayers = wks.Layers.Count();
			break;
		case EXIST_MATRIX:
			MatrixPage mat(pb);
			nLayers = mat.Layers.Count();
			break;
		case EXIST_GRAPH:
			GraphPage gp(pb);
			nLayers = gp.Layers.Count();
			break;
		default:
			break:
		};	
		return nLayers;
	}
	string getDataObjProperties(DataObject &dataobj, int nColType)
	{
		///------ Folger 12/15/2011 ORG-4601-P2 TRANSLATE_OP_ESCAPE_STR_FOR_COLUMN_BROWSER
		//Layer ly;
		Datasheet	ly;
		///------ End TRANSLATE_OP_ESCAPE_STR_FOR_COLUMN_BROWSER
		dataobj.GetParent(ly);
		string strShowName ;
		//-------Folger 07/17/07 NEED_ADD_COLUMN_SHEET_NAME_FOR_GLOBAL_USE
		if (nColType == PEOBJECT_LAYER)
		{
			ly.GetRangeString(strShowName);
			strShowName.TrimRight('!');
			return strShowName;
		}
		//-------End NEED_ADD_COLUMN_SHEET_NAME_FOR_GLOBAL_USE
		switch(ly.GetPage().GetType())
		{
		case EXIST_WKS:
			Column col(dataobj);
			switch (nColType)
			{
			case PEOBJECT_INDEX:
				///Folger 05/08/07 MODIFY_SHOWN
				//strShowName = make_book_sheet_name(ly.GetPage().GetName(), ly.GetName());
				//strShowName += "!" + (col.GetIndex() + 1);
				strShowName = "" + (col.GetIndex() + 1);
				///End MODIFY_SHOWN
				break;
			case PEOBJECT_SNAME:
				strShowName = col.GetName();
				break;
			case PEOBJECT_LNAME:
				strShowName = col.GetLongName();
				break;
			case PEOBJECT_DESIGNATION:
				strShowName = getDataObjDesignation(col.GetType());
				break;
			case PEOBJECT_FORMAT:
				strShowName = getDataObjFormat(col.GetFormat());
				break;
			case PEOBJECT_SIZE:
				//------ Folger 07/26/07 ADD_FIRSTVALUE_IN_OBJECT_LIST
				//strShowName = col.GetNumRows();
				strShowName = ftoa(col.GetUpperBound() - col.GetLowerBound() + 1);
				//------ End ADD_FIRSTVALUE_IN_OBJECT_LIST
				break;
			//------ Folger 07/26/07 ADD_FIRSTVALUE_IN_OBJECT_LIST
			case PEOBJECT_FIRSTVALUE:
				///------ Folger 12/15/2011 ORG-4601-P2 TRANSLATE_OP_ESCAPE_STR_FOR_COLUMN_BROWSER
				//Worksheet wks(ly);
				//wks.GetCell(col.GetLowerBound(), col.GetIndex(), strShowName);
				strShowName = ly.TCell(col.GetLowerBound(), col.GetIndex());
				///------ End TRANSLATE_OP_ESCAPE_STR_FOR_COLUMN_BROWSER
				break;
			//------ End ADD_FIRSTVALUE_IN_OBJECT_LIST
			case PEOBJECT_TYPE:
				strShowName = _L("Column");
				break;
			///Folger 05/14/07 ADD_COMMENTS_TO_COLUMN_BROWSER
			case PEOBJECT_COMMENTS:
				strShowName = col.GetComments();
				break;
			///End ADD_COMMENTS_TO_COLUMN_BROWSER
			///Jasmine 07/18/07 ADD_MORE_COLUMN_INFO
			case PEOBJECT_PARAM:
				col.GetParameter(strShowName);//get the first one
				break;
			case PEOBJECT_UDL:
				col.GetExtendedLabel(strShowName, RCLT_UDL);//get the first one
				break;
			///End ADD_MORE_COLUMN_INFO
			default:
				break;
			}
			break;
		case EXIST_MATRIX:
			MatrixObject mo(dataobj);
			switch (nColType)
			{
			case PEOBJECT_INDEX:
				///Folger 05/08/07 MODIFY_SHOWN
				//strShowName = make_book_sheet_name(ly.GetPage().GetName(), ly.GetName());
				//strShowName += "!" + (mo.GetIndex() + 1);
				strShowName = "" + (mo.GetIndex() + 1);
				///End MODIFY_SHOWN
				break;
			case PEOBJECT_SNAME:
				strShowName = mo.GetName();
				break;
			case PEOBJECT_LNAME:
				strShowName = mo.GetLongName();
				break;
			case PEOBJECT_DESIGNATION:
//				strShowName = getDataObjDesignation(mo.GetType());
				break;
			case PEOBJECT_FORMAT:
				strShowName = getDataObjFormat(mo.GetFormat());
				break;
			case PEOBJECT_SIZE:
				strShowName = "" + mo.GetNumRows() + "*" + mo.GetNumCols();
				break;
			//------ Folger 07/26/07 ADD_FIRSTVALUE_IN_OBJECT_LIST
			case PEOBJECT_FIRSTVALUE:
				break;
			//------ End ADD_FIRSTVALUE_IN_OBJECT_LIST
			case PEOBJECT_TYPE:
				strShowName = _L("Matrix");
				break;
			default:
				break;
			}
			break;
		default:
			break;
		}		
		return strShowName;
	}
	
	string getDataObjFormat(int nFormat)
	{
		switch(nFormat)
		{
		case OKCOLTYPE_NUMERIC:
			return _L("Numeric");
		case OKCOLTYPE_TEXT:
			return _L("Text");
		case OKCOLTYPE_TIME:
			return _L("Time");
		case OKCOLTYPE_DATE:
			return _L("Date");
		case OKCOLTYPE_MONTH:
			return _L("Month");
		case OKCOLTYPE_WEEKDAY:
			return _L("Day");
		case OKCOLTYPE_TEXT_NUMERIC:
			return "T&N"; //CPY 6/15/06, changed from Text & Numeric to make it shorter
		default:
			return "";
		}
		return "";
	}
	
	string getDataObjDesignation(int nDesignation)
	{
		switch(nDesignation)
		{
		case OKDATAOBJ_DESIGNATION_X:
			return "X";
		case OKDATAOBJ_DESIGNATION_Y:
			return "Y";
		case OKDATAOBJ_DESIGNATION_Z:
			return "Z";
		case OKDATAOBJ_DESIGNATION_X_ERROR:
			return "XErr";
		case OKDATAOBJ_DESIGNATION_ERROR:
			return "YErr";
		case OKDATAOBJ_DESIGNATION_L:
			return "L";
		default :	//OKDATAOBJ_DESIGNATION_NONE
			return " "; //CPY 6/15/06 changed from Disregard to make it shorter
		}
		return "";
	}
	
private:
	Datasheet 	m_wksMatLayer;
	DWORD		m_dwCtrl;
	int 		m_nShowItemType;			//-----Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
	bool		m_bXYRange;					///Jasmine 07/17/07 SUPPORT_XY_RANGE
};
