/*------------------------------------------------------------------------------*
 * File Name: BrowserBaseClass.h												*
 * Creation: 																	*
 * Purpose: A Control base class for showing a list of pages 					*
 * Copyright (c) Originlab Corp., 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 12/16/05 QA70-8352 v8.0347 UPDATELIST_BY_TREENODE					*
 * Iris 12/22/2006 CHOOSE_PAGE_IN_LEFT_SHOULD_SHOW_LAYER_IN_RIGHT_PANEL			*
 * Jasmine 12/25/06 SHOW_PAGE_OR_LAYER											*
 * Jasmine 04/04/07 MAKE_A_GOOD_COL_WIDTH										*
 * Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER				*
 * Folger 06/18/07 ADD_GET_SELECTION_RANGE_STRING								*
 * Folger 06/20/07 CREATE_GET_INIT_RANGE_STRING									*
 * Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE								*
 * Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE				*
 * Folger 07/16/07 SET_PB_COLUMNS_SHOWN_STATE_IS_NEEDED_ACCORDING_TO_DIFFERENT_ORIGIN_OBJECTS
 * Jasmine 07/17/07 ADD_UPDATE_WITH_GRAPH										*
 * Jasmine 07/17/07 OPTION_TO_SHOW_SUBFOLDER_CONTENT							*
 * Folger 07/17/07 ADD_DWORD_PARAMETER_IS_NEED									*
 * Jasmine 07/18/07 SET_SHOW_COLUMN_WITH_VECTOR_UINT							*
 * Jasmine 07/18/07 COLUMN_LIST_MENU											*
 * Folger 07/19/07 PB_LIST_BASE_DEFAULT_MEANU									*
 * Jasmine 07/20/07 MANUAL_EXCLUDE_COLUMN										*
 * Jasmine 07/23/07 ADD_PLOT_LIST_CLASS											*
 * Folger 07/25/07 UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND			*
 * Folger 07/26/07 ADD_FIRSTVALUE_IN_OBJECT_LIST								*
 * Folger 07/27/07 RECURSIVE_TO_ADD_ALL_ITEMS									*
 * Folger 08/01/07 SAVE_HIDE_COLS_WHEN_DATASET_TAB_CHANGE						*
 * Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE						*
 * Folger 11/19/07 FIX_BUGS_WHEN_EXCLUDE_ITEMS									*
 * Kyle 07/15/08 QA80-11840 CHANGE_THE_CONTEXT_MENU_TO_LIST_EACH_AVAILABLE_ITEM	*
 * Kyle 07/15/08 QA80-11840 SET_GETDEFAULTSHOW_AS_VIRTUAL_FUNCTION				*
 * Jasmine 04/27/10 QA81-15312 SHOW_SHORTCUT_ICON_IN_PROJECT_TREE				*
 * Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
 * Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION			*
 * Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
 * Philip 09/18/2012 ORG-5346-P1 AVOID_HIDE_ALL_COLUMNS_IN_BROWSERS				*
 *------------------------------------------------------------------------------*/
//#pragma PCH
#ifndef _PB_LIST_BASE_H
#define _PB_LIST_BASE_H
//#include <origin.h>
//#include "DialogEx.h"

#include "graph_utils.h"

#define  _DMSG_PB(_str)  //out_str(_str);
//#define  STR_RANGE_FORMAT	"%s(%s,%s)"

enum
{
	PB_BROWSER_PAGE_LIST =0 ,
	PB_BROWSER_LAYER_LIST,
	PB_BROWSER_OBJECT_LIST,	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER	
	PB_BROWSER_PLOT_LIST	///Jasmine 07/23/07 ADD_PLOT_LIST_CLASS	
};
enum
{
	SINGLE_SELECT =0,
	MULTIPLE_SELECT
};
enum
{
	ITEM_IS_PAGE = 0,
	ITEM_IS_LAYER,
	ITEM_IS_OBJECT,		///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER	
	ITEM_IS_FOLDER,
	ITEM_IS_NULL	
};
///Jasmine 07/18/07 SET_SHOW_COLUMN_WITH_VECTOR_UINT
enum 
{
	PEOBJECT_LAYER,				//-------Folger 07/17/07 NEED_ADD_COLUMN_SHEET_NAME_FOR_GLOBAL_USE
	PEOBJECT_INDEX,
	PEOBJECT_SNAME,
	PEOBJECT_LNAME,
	PEOBJECT_COMMENTS,			///Folger 05/14/07 ADD_COMMENTS_TO_COLUMN_BROWSER
	PEOBJECT_DESIGNATION,
	PEOBJECT_FORMAT,
	PEOBJECT_SIZE,
	PEOBJECT_FIRSTVALUE,		//------ Folger 07/26/07 ADD_FIRSTVALUE_IN_OBJECT_LIST
	PEOBJECT_TYPE,
	///Jasmine 07/18/07 ADD_MORE_COLUMN_INFO
	PEOBJECT_PARAM,
	PEOBJECT_UDL,	
	
	PEOBJECT_LAST_ITEM
	///End ADD_MORE_COLUMN_INFO
};
///Kyle 07/15/08 QA80-11840 CHANGE_THE_CONTEXT_MENU_TO_LIST_EACH_AVAILABLE_ITEM
enum
{
	PELAYER_NAME, 
	PELAYER_TYPE,PELAYER_SIZE, 
	PELAYER_VIEW, 
	PELAYER_FILENAME,
	PELAYER_TOTAL_COLS
};
///End CHANGE_THE_CONTEXT_MENU_TO_LIST_EACH_AVAILABLE_ITEM
///End SET_SHOW_COLUMN_WITH_VECTOR_UINT
//--------Folger 07/17/07 ADD_DWORD_PARAMETER_IS_NEED
enum
{
	SHOW_LAYER_NAME	= 0x00000001,
};
//--------End ADD_DWORD_PARAMETER_IS_NEED

typedef int (*FUNC_GET_DISPLY_ID)(int nItemID);

///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
#define PAGE_STATUS_HIDDEN			0x00000001
#define PAGE_STATUS_SHORTCUT		0x00000010
///End COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE

///Jasmine 07/23/07 ADD_PLOT_LIST_CLASS, support dataplot
class PBListMenu : public Menu
{
public:
	//------Folger 07/25/07 UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
	//PBListMenu(vector<string> vsItems, vector<uint> vnDisplayItems, vector<byte> vbCols)
	PBListMenu(vector<string> vsItems, vector<uint> vnDisplayItems, vector<byte> vbCols, int nLowerBound, int nUpperBound)
	//------End UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
	{
		m_nChoice = -1;	
		//------Folger 07/25/07 UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
		m_nLowerBound = nLowerBound;
		m_nUpperBound = nUpperBound;
		//------End UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
		int nSize = vnDisplayItems.GetSize();
		int nMax = vsItems.GetSize();
		int nCols = vbCols.GetSize();
		///Philip 09/18/2012 ORG-5346-P1 AVOID_HIDE_ALL_COLUMNS_IN_BROWSERS
		int nShow = 0;
		for(int ij = 0; ij < nCols && nShow <= 1; ij++)
		{
			if(!vbCols[ij])
				nShow++;
		}
		ASSERT(nShow);
		bool bOnly1ColShown = (nShow == 1);
		///end AVOID_HIDE_ALL_COLUMNS_IN_BROWSERS
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = vnDisplayItems[ii];
			if(nIndex < nMax)
			{
				bool bCheck = true;
				if(nIndex < nCols)
					bCheck = !vbCols[nIndex];
				//Add(_L(vsItems[nIndex]), OnMenuItem, bCheck? MF_CHECKED : MF_UNCHECKED);
				///Philip 09/18/2012 ORG-5346-P1 AVOID_HIDE_ALL_COLUMNS_IN_BROWSERS
				//Add(vsItems[nIndex], OnMenuItem, bCheck? MF_CHECKED : MF_UNCHECKED); /// Hong 11/07/07 v.8.0742 FIX_ERROR_LOCALIZED
				uint uFlags = bCheck ? MF_CHECKED : MF_UNCHECKED;
				if(bOnly1ColShown && bCheck)
					uFlags |= MF_DISABLED | MF_GRAYED;
				Add(vsItems[nIndex], OnMenuItem, uFlags);
				///end AVOID_HIDE_ALL_COLUMNS_IN_BROWSERS
			}
		}
		Add(NULL, EmptySepFunc, MF_SEPARATOR);
		Add(_L("Show All"), OnMenuItem, MF_ENABLED);
	}
	//------Folger 07/25/07 UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
	//virtual bool GetCommand(int& nChoice)
	//{
		//return false;
	//}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= m_nLowerBound && m_nChoice <= m_nUpperBound)//MF_SEPARATOR and "Show All"
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
	//------End UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
	void EmptySepFunc(uint nCmd)
	{
	}
//------Folger 07/25/07 UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
protected:
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
//------End UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
private:
	int	m_nChoice;
	int m_nLowerBound;
	int m_nUpperBound;
};
///End ADD_PLOT_LIST_CLASS	

enum {PAGELISTMENU_HIDE, PAGELISTMENU_SHOW_ALL};
//-------Folger 07/19/07 PB_LIST_BASE_DEFAULT_MEANU
class PBPageListMenu : public Menu
{
public:
	PBPageListMenu( bool bIsInGrid)
	{
		UINT nFlags = bIsInGrid? MF_ENABLED : MF_DISABLED | MF_GRAYED;
		m_nChoice = -1;
		Add(_L("Hide Column"), OnMenuItem, nFlags);
		Add(_L("Show all Columns"), OnMenuItem);
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= PAGELISTMENU_HIDE && m_nChoice <= PAGELISTMENU_SHOW_ALL)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
private:
	int	m_nChoice;
};
//-------End PB_LIST_BASE_DEFAULT_MEANU
class PBListBase : public GridListControl
{
	PBListBase()
	{
		//GetFormatStrAsArray(PAGE_LIST_COL_HEADER, m_vsColHeadings, "PEPages");
	}
	~PBListBase()
	{
		//OnDestroy(); removed by CPY 11/30/05
	}
	
public:
	//-----Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
	//virtual void Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName )
	virtual void Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName, int nShowItemType )
	//-----End ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
	{
		m_strDlgName = lpcszDlgName;
		GridListControl::Init(nID, dlg);

		m_flx.Cols = m_vsColHeadings.GetSize();
		m_flx.FormatString = makeColHeadings();
		m_flx.SelectionMode = flexSelectionListBox;
		m_flx.AllowSelection = true;	///If false, will just single seleted.
		m_flx.ExplorerBar = flexExSortShow;
		m_flx.Ellipsis = flexEllipsisPath;// if str too long, show ... in the middle
		//LoadHideCols(m_strDlgName, "PELayers", &vbDefaultShowCols);	//Load and update the column show state
		
		////vector<byte> vbDefaultShowCols = {0,0,0,0,0};		
		//vector<byte> vbDefaultShowCols;		
		//vbDefaultShowCols.SetSize(m_vsColHeadings.GetSize());
		//vbDefaultShowCols =0;
		//LoadHideCols(lpcszDlgName, "PELayers", &vbDefaultShowCols);	//Load and update the column show state
		
		m_flx.BackColorBkg= RGB(255, 255, 255);
		/// Bill 07/06/2011 NO_NEED_IN_NEW_WXGRID
		//m_flx.SheetBorder = RGB(255, 255, 255);
#ifndef __REPLACE_VSFLEX_WITH_64_MP_WXGRID__
		m_flx.SheetBorder = RGB(255, 255, 255);
#endif // __REPLACE_VSFLEX_WITH_64_MP_WXGRID__
		/// End NO_NEED_IN_NEW_WXGRID
		m_flx.GridColor = RGB(255, 255, 255);
		//m_flx.BackColorFrozen = RGB(247, 247, 247); /// Bill 07/06/2011 NO_NEED_SINCE_WE_HAVEN_SET_FROZEN_ROW_OR_COL

		m_flx.AllowUserResizing = flexResizeColumns;		//allow columns resizing
		//m_flx.ExplorerBar = flexExNone;					//do not sort columns by clicking on their headings
		
		m_flx.AutoSizeMode = flexAutoSizeColWidth;		//Adjust column widths to accommodate the widest entry in each column
		// prevent it from entering edit mode by trapping the BeforeEdit event and setting the Cancel parameter to True
	    //m_flx.AllowSelection = false;						//prevent users from extending the selection 
	    m_flx.HighLight = flexHighlightAlways;

	    m_bShowSubFolder = true;
		m_bShowHidden = true;
		m_bShowMin = true;
		m_PBBType = -1;
	}
	BOOL OnDestroy()
	{
		SaveHideCols();
		return TRUE;
	}
	void	SetSelectMode( int nSelectMode = SINGLE_SELECT )
	{
		if(nSelectMode == SINGLE_SELECT)
			m_flx.AllowSelection = false ;		///If false, will just single seleted.
	}
	///Jasmine 04/04/07 MAKE_A_GOOD_COL_WIDTH
	//this function can't auto size the col, 
	//and we can call GridControl::ResizeCols instead, so comment this
	/*
	void ResizeCols(int nMaxColSizeFactor = 0, int nExtraPixcels = 8)
	{
		//_DMSG_PB("On list contr resize begin");
		///if the width change, resize the grid, else do nothing.
		int nWidth = m_flx.ClientWidth;
		if(m_nWidth != nWidth && !m_bResizeGrid)
		{
			m_nWidth = nWidth;
			GridListControl::ResizeCols(nMaxColSizeFactor, nExtraPixcels);
		}
		else
			m_bResizeGrid = true;
		//_DMSG_PB("On list contr resize end");
	}
	*/
	///End MAKE_A_GOOD_COL_WIDTH
	bool GetFolderShow(){return m_bShowSubFolder;}
	void ResetFolderShowOption(bool bChanged= true)
	{
		m_bShowSubFolder = bChanged ? !m_bShowSubFolder : m_bShowSubFolder;
	}	
	void ResetBrowserShowOption(bool bResetHiddenPagesShow = true, bool bResetMinPagesShow = true)
	{
		m_bShowHidden = bResetHiddenPagesShow ? !m_bShowHidden : m_bShowHidden;
		m_bShowMin = bResetMinPagesShow ? !m_bShowMin : m_bShowMin;		
	}
	bool GetSelItems(vector<string>& vsSelItemNames, bool bIncludeFolder = false)
	{
		vector<uint> vnRows;
		vsSelItemNames.SetSize(0);
		string strShortName, strLongName;
		string strItemType;
		if(GetSelRows(vnRows))
		{
			for(int ii = 0; ii < vnRows.GetSize(); ii++)
			{
				vsSelItemNames.Add(GetSeletedItemName(vnRows[ii], bIncludeFolder));
			}
			return true;
		}
		return false;
	}
	bool DelItem(int nRow)///PageBase &pg)
	{
		return 	DeleteRow();
	}
	///Jasmine 07/20/07 MANUAL_EXCLUDE_COLUMN
	int RemoveSelectedRows(vector<string> &vsVals)
	{
		vector<uint> vnRows;
		int nRowOffset = GetRowOffset();
		GetSelRows(vnRows);
		int nSelRow = GetSelectedRow();		//------ Folger 11/19/07 FIX_BUGS_WHEN_EXCLUDE_ITEMS
		for(int index = vnRows.GetSize() - 1; index >= 0; index--)
			DeleteRow(vnRows[index]);
		selectRow(nSelRow);					//------ Folger 11/19/07 FIX_BUGS_WHEN_EXCLUDE_ITEMS
		int nRows = GetRows();
		vsVals.RemoveAll();
		for(index = nRowOffset; index < nRows; index++)
			vsVals.Add(GetSeletedItemName(index));
		return vsVals.GetSize();
	}
	///End MANUAL_EXCLUDE_COLUMN
	bool RenameItem(int nRow, LPCSTR lpcszNewName)//LPCSTR lpcszOldName
	{
		//return ChangeCellValue(nRow,0, lpcszNewName);
		return SetCell(nRow,0, lpcszNewName);
	}
	bool SetPageShow(int nRow,int nCol,  int nNewShow = PAGE_ACTIVATE)
	{
		string strNewShow = GetPageShowState(nNewShow);

		//Temp to gray the icon
		if(nNewShow == PAGE_HIDDEN)
			SetHideGray(nRow, nCol);
		
		//return ChangeCellValue(nRow,nCol, strNewShow);
		return SetCell(nRow,nCol, strNewShow);
	}

	virtual int GetItemType(int nRow)
	{
		return 0;
	}
	virtual int GetPBListType()
	{
		return 0;
	}
	///Jasmine 07/17/07 ADD_UPDATE_WITH_GRAPH
	//virtual bool UpdateListWithGraph(GraphPage gp, int nShowItemType = 0)
	//{
		//ClearAll();
		//if( !gp )
			//return false;
		//foreach(GraphLayer gl in gp.Layers)
		//{
			//foreach(DataPlot dp in gl.DataPlots)
			//{
				//DataRange drXY;
				//dp.GetDataRange(drXY);
				//if(!nShowItemType || EXIST_WKS == nShowItemType)
				//{
					//int r1, c1, r2, c2;
					//Worksheet wks;
					//if(drXY)
						//drXY.GetRange("Y", r1, c1, r2, c2, wks);
					//Column col;
					//if(wks)
						//col = wks.Columns(c1);
					//if(col)
						//AddItems(col);
				//}
			//}
		//}
		//return true;
	//}
	///End ADD_UPDATE_WITH_GRAPH
	
	///Sophy CLEAN_CODE_PBLIST_CONTROL
	/*
	///Jasmine 12/25/06 SHOW_PAGE_OR_LAYER
	//----- Iris 12/22/2006 CHOOSE_PAGE_IN_LEFT_SHOULD_SHOW_LAYER_IN_RIGHT_PANEL
	
	virtual bool UpdateList(PageBase& pg, int nShowItemType = 0)
	{
		ClearAll();
		if( !pg )
			return false;
		
		int nType = pg.GetType();
		if(nShowItemType && nType != nShowItemType)
			return false;

		//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		//AddItems(pg);
		vector<string> vsRows;
		vector<int> vnPageType;
		vector<bool> vbHideGray;
		AddItems(pg, vsRows, vnPageType, vbHideGray);
		//--- when VC functions comes, this will be clean up
		int nSize = vsRows.GetSize();
		int nRow = m_flx.Rows;
		for (int ii=0; ii<nSize; ii++)
		{
			m_flx.AddItem(vsRows[ii]);
			if (vnPageType[ii] >= 0)
				SetCellIcon(nRow + ii, 0, get_page_display_id(vnPageType[ii]), MODULE_ORIGIN);
			if (vbHideGray[ii])
				SetHideGray(nRow + ii, 0);
		}
		ResizeCols();
		//---
		//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		return true;
	}
	//-----
	///Jasmine2/25/06
	virtual bool UpdateList(Layer& lay)
	{
		ClearAll();
		if( !lay )
			return false;
		//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		//AddItems(lay);
		vector<string> vsRows;
		vector<int> vnPageType;
		vector<bool> vbHideGray;
		AddItems(lay, vsRows, vnPageType, vbHideGray);
		//--- when VC functions comes, this will be clean up
		int nSize = vsRows.GetSize();
		int nRow = m_flx.Rows;
		for (int ii=0; ii<nSize; ii++)
		{
			m_flx.AddItem(vsRows[ii]);
			if (vnPageType[ii] >= 0)
				SetCellIcon(nRow + ii, 0, get_page_display_id(vnPageType[ii]), MODULE_ORIGIN);
			if (vbHideGray[ii])
				SetHideGray(nRow + ii, 0);
		}
		ResizeCols();
		//---
		//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		return true;
	}
	///Jasmine 07/17/07 OPTION_TO_SHOW_SUBFOLDER_CONTENT
	virtual bool UpdateList(Folder& fldr , int nShowItemType = 0, bool bAddSubFolder = false)
	{
		ClearAll();
		if(!fldr.IsValid())
			return false;

		if(!bAddSubFolder && m_bShowSubFolder)
			AddSubFolders(fldr);
		//------ Folger 07/27/07 RECURSIVE_TO_ADD_ALL_ITEMS
		//AddAllItems(fldr, nShowItemType);
		//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		//AddAllItems(fldr, nShowItemType, bAddSubFolder);
		vector<string> vsRows;
		vector<int> vnPageType;
		vector<bool> vbHideGray;
		AddAllItems(fldr, vsRows, vnPageType, vbHideGray, nShowItemType, bAddSubFolder);
		//--- when VC functions comes, this will be clean up
		int nSize = vsRows.GetSize();
		int nRow = m_flx.Rows;
		for (int ii=0; ii<nSize; ii++)
		{
			m_flx.AddItem(vsRows[ii]);
			if (vnPageType[ii] >= 0)
				SetCellIcon(nRow + ii, 0, get_page_display_id(vnPageType[ii]), MODULE_ORIGIN);
			if (vbHideGray[ii])
				SetHideGray(nRow + ii, 0);
		}
		ResizeCols();
		//---		
		//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		
		//if(bAddSubFolder)
		//{
			//foreach(Folder subFldr in fldr.Subfolders)
				//AddAllItems(subFldr, nShowItemType);
		//}
		//------ End RECURSIVE_TO_ADD_ALL_ITEMS
		///End OPTION_TO_SHOW_SUBFOLDER_CONTENT
		//ResizeCols(3,1); //After update list , should resize column 
		return true;
	}
	///Jasmine 12/16/05 UPDATELIST_BY_TREENODE
	virtual bool UpdateList(TreeNode trNode, int nShowItemType = 0)
	{
		return true;
	}
	///End UPDATELIST_BY_TREENODE
	///End SHOW_PAGE_OR_LAYER
	*/
	virtual	bool	GetItems( Layer& ly, 
							vector<string>& vsItems, vector<int>& vnPageType, 
							vector<DWORD>& vdwStatus)//vector<bool>& vbHideGray, ///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
	{
		if( !ly )
			return false;
		
		AddItems( ly, vsItems, vnPageType, vdwStatus );
		
		return true;
	}
	virtual	bool	GetItems( PageBase& pb, 
							vector<string>& vsItems, vector<int>& vnPageType, 
							vector<DWORD>& vdwStatus,//vector<bool>& vbHideGray, ///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
							int nShowItemType = 0,
							const Folder& fldParent = NULL)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	{
		if( !pb )
			return false;
		if( nShowItemType && pb.GetType() != nShowItemType )
			return false;
		
		AddItems( pb, vsItems, vnPageType, vdwStatus, fldParent);
		
		return true;
	}
	virtual	bool	GetItems( Folder& fld, 
							vector<string>& vsItems, vector<int>& vnPageType, 
							vector<DWORD>& vdwStatus,//vector<bool>& vbHideGray, ///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
							int nShowItemType = 0, bool bAddSubFolder = false,
							bool bIncludeShortcut = false)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	{
		if( !fld.IsValid() )
			return false;
		
		///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		Collection<PageBase> cPages;
		if(bIncludeShortcut)
			cPages = fld.PagesAndShortcuts;
		else
			cPages = fld.Pages;	
			
		//foreach( PageBase page in fld.Pages )
		foreach( PageBase page in cPages )
		///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		{
			if( nShowItemType && page.GetType() != nShowItemType )
				continue;
			
			if( PageVisible( page ) )
			{
				vector<string>	vsSubItems;
				vector<int>		vnSubTypes;
				vector<DWORD>	vdwSubStatus;
				AddItems( page, vsSubItems, vnSubTypes, vdwSubStatus, fld );
				vsItems.Append( vsSubItems );
				vnPageType.Append( vnSubTypes );
				vdwStatus.Append( vdwSubStatus );
			}
		}
		
		if( bAddSubFolder )
		{
			foreach( Folder fdSub in fld.Subfolders )
			{
				GetItems( fdSub, 
						vsItems, vnPageType, vdwStatus, 
						nShowItemType, bAddSubFolder,
						bIncludeShortcut);	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
			}
		}
		
		return true;
	}
	virtual	bool	GetItems( TreeNode& trNode, 
							vector<string>& vsItems, vector<int>& vnPageType, 
							vector<DWORD>& vdwStatus,//vector<bool>& vbHideGray, ///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
							int nShowItemType = 0,
							bool bIncludeShortcut = false)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	{
		return false;
	}
	
	bool	UpdateList( const vector<string>& vsItems, const vector<int>& vnPageType, 
						const vector<DWORD>& vdwStatus )//vector<bool> &vbHideGray)	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
	{
		ClearAll();
		///Jasmine 01/06/10 QA81-14909 WKS_AND_MATRIX_HAVE_NEW_BOOK_AND_COL_ICONS
		string strFunc;
		switch(m_PBBType)
		{
		case ITEM_IS_LAYER:
			strFunc = "get_layer_display_id";
			break;
		case ITEM_IS_OBJECT:
			strFunc = "get_data_object_display_id";
			break;
		case ITEM_IS_PAGE:
		default:
			strFunc = "get_page_display_id";
			break;
		}
		FUNC_GET_DISPLY_ID pfn = Project.FindFunction(strFunc, "OriginLab\\page_utils.c");
		///End WKS_AND_MATRIX_HAVE_NEW_BOOK_AND_COL_ICONS
		int	nSize = vsItems.GetSize();
		int	nRows = m_flx.Rows;
		for( int ii = 0; ii < nSize; ii++ )
		{
			DWORD dwStatus = vdwStatus[ii]; ///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
			
			m_flx.AddItem(vsItems[ii]);
			if (vnPageType[ii] >= 0)
			{
				int nDisplay = pfn? pfn(vnPageType[ii]) : get_page_display_id(vnPageType[ii]);
				int nOverlayResId = (dwStatus & PAGE_STATUS_SHORTCUT)? IDR_SHORTCUT_OVERLAY : 0;///Jasmine 04/27/10 QA81-15312 SHOW_SHORTCUT_ICON_IN_PROJECT_TREE
				SetCellIcon(nRows + ii, 0, nDisplay, MODULE_ORIGIN, TRUE, nOverlayResId);
			}
			if (dwStatus & PAGE_STATUS_HIDDEN)///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
				SetHideGray(nRows + ii, 0);
		}
		
		ResizeCols();
		return true;
	}
	///Kyle 07/15/08 QA80-11840 SET_GETDEFAULTSHOW_AS_VIRTUAL_FUNCTION
	virtual int	GetDefaultShow( Layer& lay, GridTreeControl* pGridTree, LPCSTR lpcszDefaultShow = NULL )
	{
		return -1;
		//int nRow =- 1;
		//if( !lay )
			//return -1;
		//
		//string strDefaultShow( lpcszDefaultShow );
		//if( PB_BROWSER_OBJECT_LIST == nBrowserType )
		//{
			//if( strDefaultShow.IsEmpty() )
			//{
				//lay.GetRangeString( strDefaultShow );
				//strDefaultShow.TrimRight('!');
			//}
			//else
			//{
				//string	strBook, strSheet, strCol;
				//okutil_parse_complete_range_string(strDefaultShow, strBook, strSheet, strCol);
				//okutil_create_complete_range_string_obj(strDefaultShow, strBook, strSheet, NULL);
			//}
			//nRow = pGridTree->FindRow( strDefaultShow );
		//}
		//else if( PB_BROWSER_LAYER_LIST == nBrowserType )
		//{
			//if( strDefaultShow.IsEmpty() )
			//{
				//Page pg = lay.GetPage();
				//pg.GetRangeString( strDefaultShow );
			//}
			//string strBook, strSheet;
			//okutil_get_book_sheet_info(&strBook, &strSheet, strDefaultShow);
			//nRow = pGridTree->FindRow(strBook);
		//}
		//else
		//{
			//if( strDefaultShow.IsEmpty() )
			//{
				//Folder fld = Project.ActiveFolder();
				//strDefaultShow = fld.GetPath();
			//}
			//strDefaultShow.TrimLeft('/');
			//strDefaultShow.TrimRight('/');
			//vector<string> vs;
			//strDefaultShow.GetTokens(vs, '/');
			//for( int ii = 0; ii < vs.GetSize(); ii++)
			//{
				//int nLevel = -1;
				//while( nLevel != ii )
				//{
					//nRow = pGridTree->FindRow( vs[ii], 0, false, true, nRow+1 );
					//nLevel = ( (-1 == nRow)? ii : pGridTree->GetLevel( nRow ) );
				//}
			//}
		//}
		//return nRow;
	}
	///End SET_GETDEFAULTSHOW_AS_VIRTUAL_FUNCTION
	///end Sophy CLEAN_CODE_PBLIST_CONTROL
	virtual void SetAllItemSel(vector<int> &nRows)
	{
		nRows.RemoveAll();
		
		for(int ii = GetRowOffset(); ii < GetRows(); ii++)
		{
			//if(GetPBListType() != GetItemType(ii) || ii == 0)
			if(m_PBBType != GetItemType(ii) || ii == 0)
				continue;
			nRows.Add(ii);
		}
	}
	virtual void GetBrowserSupportTypeList(vector<int> &vnList)	{}
	//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
	///Folger 06/18/07 ADD_GET_SELECTION_RANGE_STRING
	//virtual string GetSelectionRangeString()
	//{
		//vector<string> vsSelected;
		//GetSelItems(vsSelected);
		//string strRet;
		//strRet.SetTokens(vsSelected);
		//return strRet;
	//}
	/////End ADD_GET_SELECTION_RANGE_STRING
	//
	/////Folger 06/20/07 CREATE_GET_INIT_RANGE_STRING
	//virtual bool GetInitRangeString(vector<string> &vsVals)
	//{
		//return true;
	//}
	virtual int GetSelectionRangeString(vector<string> &vsSelected)	
	{
		GetSelItems(vsSelected);
		return vsSelected.GetSize();
	}
		
	virtual int GetInitRangeString(vector<string> &vsVals)
	{
		return vsVals.GetSize();
	}
	//--------end CLEAN_UP_GET_RANGE_STRING_CODE
	//--------Folger 07/16/07 SET_PB_COLUMNS_SHOWN_STATE_IS_NEEDED_ACCORDING_TO_DIFFERENT_ORIGIN_OBJECTS
	//--------Folger 07/17/07 ADD_DWORD_PARAMETER_IS_NEED
	//virtual BOOL SetShowColumns()
	///Jasmine 07/18/07 SET_SHOW_COLUMN_WITH_VECTOR_UINT
	//virtual BOOL SetShowColumns(DWORD dwShowCols = 0)
	virtual BOOL SetShowColumns(const vector<uint>& vnShowColumns = NULL)
	//--------End ADD_DWORD_PARAMETER_IS_NEED
	{
		return FALSE;
	}
	//--------End SET_PB_COLUMNS_SHOWN_STATE_IS_NEEDED_ACCORDING_TO_DIFFERENT_ORIGIN_OBJECTS
	///Jasmine 07/18/07 COLUUMN_LIST_MENU
///Kyle 07/15/08 QA80-11840 CHANGE_THE_CONTEXT_MENU_TO_LIST_EACH_AVAILABLE_ITEM
	//virtual BOOL ShowMenu(int nx, int ny)
	//{
		////-------Folger 07/19/07 PB_LIST_BASE_DEFAULT_MEANU
		//int nRow, nCol;
		//GetMouseCell(nRow, nCol);
		//PBPageListMenu myMenu(IsInGrid(nRow, nCol));
		//myMenu.TrackPopupMenu(0,  nx, ny, GetWindow());
		//int nCmd;
		//if(myMenu.GetCommand(nCmd))
		//{
			//switch(nCmd)
			//{
			//case PAGELISTMENU_HIDE :
				//HideCol(nCol);
				//break;
			//case PAGELISTMENU_SHOW_ALL:
				//HideCol(-1, false);
				//SetShowColumns();
			//break;
			//}
		//}
		////-------End PB_LIST_BASE_DEFAULT_MEANU
		//return FALSE;
	//}
	/////End COLUUMN_LIST_MENU
	virtual BOOL ShowMenu(int nx, int ny)
	{
		vector<byte> vbCheck;
		GetHiddenCols(vbCheck);
		PBListMenu	myMenu(m_vsColHeadings, m_vnShowColumns, vbCheck, 0, m_vsColHeadings.GetSize() + 1); // ColHeadings and "Show All"
		myMenu.TrackPopupMenu(0,  nx, ny, GetWindow());
		int nCmd;
		if(myMenu.GetCommand(nCmd))
		{
			int nIndex;
			int nSize = m_vnShowColumns.GetSize();
			if(nCmd < nSize)
			{
				nIndex = m_vnShowColumns[nCmd];
				if(vbCheck.GetSize() > nIndex)
					HideCol(nIndex, !vbCheck[nIndex]);
				return TRUE;
			}
			//show all
			for(int ii = 0; ii < nSize; ii++)
			{				
				nIndex = m_vnShowColumns[ii];
				if(vbCheck.GetSize() > nIndex)
					vbCheck[nIndex] = 0;
			}
			SetHiddenCols(vbCheck);
			return TRUE;
		}
		return FALSE;
	}
///End CHANGE_THE_CONTEXT_MENU_TO_LIST_EACH_AVAILABLE_ITEM
	virtual void SetShowXYRange(bool bXYRange){;}
	void SetShowFilter(DWORD dwFilter){m_dwFilter = dwFilter;}//void SetShowResultSheet(bool bResultSheet){m_bResultSheet = bResultSheet;}///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX	
	//------ Folger 08/01/07 SAVE_HIDE_COLS_WHEN_DATASET_TAB_CHANGE
	void SaveHideCols()
	{
 		GridControl::SaveHideCols();
	}
	//------ End SAVE_HIDE_COLS_WHEN_DATASET_TAB_CHANGE

	///------ Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
	void SetFilterTags(LPCSTR lpcszFilterTags)
	{
		int nErr;
		okutil_get_tokens(lpcszFilterTags, &m_vsFilterTags, '|', &nErr);
	}
	///------ End BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER

protected:
	virtual string GetRuntimeClass()
	{
		return "PBListBase";
	}
	virtual string GetSeletedItemName(int nRow, bool bIncludeFolder = false)
	{
		return "";
	}	
	//------ Folger 07/27/07 RECURSIVE_TO_ADD_ALL_ITEMS
	//virtual void AddAllItems(Folder &fldr, int nPageType = 0)
	//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//virtual void AddAllItems(Folder &fldr, int nPageType = 0, bool bAddSubFolder = false)
	virtual void AddAllItems(Folder &fldr, 
							vector<string> &vsRows, vector<int> &vnPageType, 
							vector<DWORD>& vdwStatus,//vector<bool> &vbHideGray)	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
							int nPageType = 0, 
							bool bAddSubFolder = false)
	//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//------ End RECURSIVE_TO_ADD_ALL_ITEMS
	{
		foreach(PageBase page in fldr.Pages)
		{
			if(nPageType && page.GetType() != nPageType)
				continue;
			
			if(PageVisible(page))
			//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
				//AddItems(page);
			{
				vector<string> vsSubRows;
				vector<int> vnSubPageType;
				vector<DWORD> vdwSubStatus;
				AddItems(page, vsSubRows, vnSubPageType, vdwSubStatus, fldr);
				vsRows.Append(vsSubRows);
				vnPageType.Append(vnSubPageType);
				vdwStatus.Append(vdwSubStatus);
			}
			//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		}
		//------ Folger 07/27/07 RECURSIVE_TO_ADD_ALL_ITEMS
		if (bAddSubFolder)
		{
			foreach(Folder subFldr in fldr.Subfolders)
				//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
				//AddAllItems(subFldr, nPageType, bAddSubFolder);
				AddAllItems(subFldr, vsRows, vnPageType, vdwStatus, nPageType, bAddSubFolder);
				//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		}
		//------ End RECURSIVE_TO_ADD_ALL_ITEMS
	}
	//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//virtual	bool AddItems(PageBase &pb)
	virtual	bool AddItems(PageBase &pb, 
						vector<string>& vsRows, vector<int> &vnPageType, 
						vector<DWORD>& vdwStatus,//vector<bool> &vbHideGray)	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
						const Folder& fldParent = NULL)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	{
		return true;
	}
	///Jasmine 12/25/06 SHOW_PAGE_OR_LAYER
	//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//virtual	bool AddItems(Layer &lay)
	virtual	bool AddItems(Layer &lay, 
						vector<string> &vsRows, vector<int> &vnPageType, 
						vector<DWORD>& vdwStatus)//vector<bool> &vbHideGray)	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
	//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	{
		return true;
	}
	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER	
	//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//virtual bool AddItems(DataObjectBase &dataobj)	///Jasmine 07/23/07 ADD_PLOT_LIST_CLASS	, support dataplot
	virtual bool AddItems(DataObjectBase &dataobj, 
						vector<string> &vsRows, vector<int> &vnPageType, 
						vector<DWORD>& vdwStatus)//vector<bool> &vbHideGray)	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
	//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	{
		return true;
	}
	///End IMPROVE_PB_FOR_COLUMN_BROWSER
	///End SHOW_PAGE_OR_LAYER
	virtual string MakeFolderCol(Folder &fld, int nColType)
	{
		return "";
	}
	virtual string MakeCol(OriginObject &obj, int nColType)
	{
		return "";// return empty
	}
	void ClearAll()
	{
		m_flx.Rows = 1;	//delete all but headers
	}	
	bool AddSubFolders(Folder fldr)
	{
		if(!fldr.IsValid())
			return false;
		
		foreach(Folder subFldr in fldr.Subfolders)
		{
			//m_flx.AddItem(strFolderName + "\t" + "" +"\t"+ "Folder" + "\t");
			string strItem = makeFolderRow(subFldr);
			m_flx.AddItem(strItem);
			SetCellIcon(m_flx.Rows - 1, 0, IDI_FOLDER_CLOSED, MODULE_ORIGIN);
		}
		return true;
	}		
	/*
	int GetDisplayId(int nItemID)
	{
		switch(nItemID)
			{
			case EXIST_GRAPH:
				return IDR_GRAPHTYPE_V8;
			case EXIST_WKS:
				return IDR_WORKSHEETTYPE_V8;
			case EXIST_NOTES:
				return IDR_NOTESTYPE;
			case EXIST_EXTERN_WKS:
				return IDR_EXCELTYPE;
			case EXIST_MATRIX:
				return IDR_MATRIXTYPE_V8;
			case EXIST_LAYOUT:
				return IDR_LAYOUTTYPE;
			};
		return IDI_FOLDER_CLOSED;

	}
	*/
	bool PageVisible(PageBase &pb)
	{
		int nView = pb.GetShow();
		if(!m_bShowHidden && nView == PAGE_HIDDEN || !m_bShowMin && nView == PAGE_MINIMIZED)
			return false;
		return true;
	}
	string GetPageShowState(int nShowState = PAGE_NORMAL)
	{
		string strShow = _L("Normal");
		switch(nShowState)
		{
		case PAGE_NORMAL:
			strShow = _L("Normal");
			break;
		case PAGE_MINIMIZED:
			strShow = _L("Minimized");
			break;
		case PAGE_MAXIMIZED:
			strShow = _L("Maximized");
			break;
		case PAGE_HIDDEN:
			strShow = _L("Hidden");
			break;
		case PAGE_ACTIVATE:
			strShow = _L("Normal"); /// Need to check the active show state
			break;
		}
		return strShow;		
	}	
	string MakeRow(OriginObject &obItem)
	{
		string	str;
		int	nCols = m_vsColHeadings.GetSize();
		for(int ii = 0; ii < nCols; ii++)
		{
			str += MakeCol(obItem, ii);
			if(ii < nCols -1)
				str += "\t";
		}
		return str;
	}	
	///Temp ... Because I dont know how to make the icon brightness
	bool SetHideGray(int nRow, int nCol)
	{
		SetCell(RGB(128, 128, 128), flexcpForeColor, nRow,nCol);
		return true;
	}

	///------ Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
	BOOL IsFilterByTag(DataObject& dataObj)
	{
		if ( m_vsFilterTags.GetSize() == 0 )
			return FALSE;

		string strTag = get_dataobj_tag(dataObj);
		if ( strTag.IsEmpty() )
			return FALSE;

		return is_in_list(strTag, m_vsFilterTags, true);
	}
	///------ End BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER

private:
	string makeFolderRow(Folder &fld)
	{
		string	str;
		int	nCols = m_vsColHeadings.GetSize();
		for(int ii = 0; ii < nCols; ii++)
		{
			str += MakeFolderCol(fld, ii);
			if(ii < nCols -1)
				str += "\t";
		}
		return str;
	}	
	string makeColHeadings( )
	{
		string str;
		int	nCols = m_vsColHeadings.GetSize();
		for(int ii = 0; ii < nCols; ii++)
		{
			str += m_vsColHeadings[ii];
			if(ii < nCols -1)
				str += "|";
		}
		return str;
	}
	//------ Folger 11/19/07 FIX_BUGS_WHEN_EXCLUDE_ITEMS
	void selectRow(int nRow = -1)
	{
		if(GetRows() <= 0)
			return;
		
		while(nRow >= GetRows())
			nRow--;
			
		if(nRow < 0)
			nRow = GetSelectedRow(); // get 1st if multiple selection, -1 if none selected
		if( nRow < 0 )
			nRow = 0;
		
		if (nRow != 0) SelRow(nRow);	
	}
	//------ End FIX_BUGS_WHEN_EXCLUDE_ITEMS
protected:
	vector<string>	m_vsColHeadings;
	vector<uint> 	m_vnShowColumns;	///Jasmine 07/18/07 SET_SHOW_COLUMN_WITH_VECTOR_UINT
	string 			m_strDlgName; 	
	int 			m_PBBType;
	DWORD 			m_dwFilter;//bool			m_bResultSheet;///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX	
private:
	int				m_nWidth;
	bool			m_bResizeGrid;
	bool 			m_bShowSubFolder;
	bool			m_bShowHidden;
	bool			m_bShowMin;

	///------ Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
	vector<string> m_vsFilterTags;
	///------ End BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
};
#endif	//_PB_LIST_BASE_H
