/*------------------------------------------------------------------------------*
 * File Name: OriginEvents.h													*
 * Creation: 08-20-2004	CPY														*
 * Copyright (c) OriginLab Corp. 2004											*
 * All Rights Reserved															*
 * 																				*
 * Purpose:																		*
 *	Base classes for EventHandlers in Origin									*
 * Modification Log:															*
 *	CPY Creation 8/5/04 WKBOOK_CONTEXT_MENU_STANDARD_HANDLING					*
 *	YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT							*
 *	EJP 2005-04-06 v8.0218 QA70-7588 GRAPHOBJ_SUPPORT_XFUNC						*
 *	DSC 8/31/05 MORE_FILTERS_FOR_XF												*
 *	ML 8/10/2006 QA70-8901 SAMPLE_RATE_LABEL_TYPE								*
 *	ML 9/15/2006 QA70-8950 SPARKLINE_LABEL										*
 *  SY 2007-04-11 QA70-9592 8.0599 RESULT_SHEET_CONTEXT_MENU					*
 *	CPY 5/11/2007 QA70-9760 XFBAR_CONTEXT_MENU_ON_TITLE							*
 *	RVD 1/21/2008 qa70-10950 v8.0790 TRANSPOSE_WKS_TABLE						*
 *	RVD 2/22/2008 QA70-11158 v8.0811 DRAW_GRID_PAGE_BOUNDS						*
 *	Folger 06/17/2011 ORG-3005-S1 DATA_COLUMN_REPLICATES_SUPPORT				*
 *	Zech 03/01/2012 ORG-5193-P1 ADD_COLUMN_FILTER_OPTION_TO_CONTEXT_MENU		*
 *------------------------------------------------------------------------------*/

#ifndef _ORIGIN_EVENTS_H
#define _ORIGIN_EVENTS_H

#include <OC_Res.h>

class OriginEventsBase : public ObjectCmdTarget
{
public:
	/// YuI 10/20/04 QA70-7072 v7.5153 CORNER_OBJECT_FOR_NEW_WORKBOOK
	/*
	virtual bool DoContextMenu(int x, int y, HWND hWnd) 
	{
		out_str("calling base class OneColHeaderHandler, should never come here");
		return false;
	}
	*/
	//---- CPY 10/14/06 SEPARATE_OUT_OPERATION_BASE_INTO_SEPARATE_HEADER
	virtual bool	OnDataPlotUpdateStatsTree(string& strOperationUID_GUID, TreeNode& trStats, BOOL& bUpdated) {return false;}	
	virtual bool	OnGetTickLabel(string& strOperationUID_GUID, string& strLabel){return false;}
	//----
	
	/// TD 11-12-04 QA70-7027 EVENT_HANDLING_ETC_FOR_OK 
	//virtual bool OnContextMenu(int x, int y)
	virtual bool OnContextMenu(int x, int y, DWORD dwControl = 0)
	/// end EVENT_HANDLING_ETC_FOR_OK 
	{
		return FALSE;
	}
	
	virtual	bool SetObj(OriginObject &obj)
	{
		return FALSE;
	}
	//------ CPY 5/11/2007 QA70-9760 XFBAR_CONTEXT_MENU_ON_TITLE
protected:
	BOOL defaultMenu(Menu& menu, int nId, int nPos);
	BOOL defaultMenu(Menu& menu, int nSelectionType, int nx, int ny);
public:
	virtual bool ProcessMenu(Menu& menu, int nx, int ny, int& nCmd) {return false;}
	virtual OriginObject& GetObj() {return NULL;}
	//-------
	
	virtual bool OnObjectHotSpotClick(int nRow, int nCol)
	{
		return FALSE;
	}
	virtual bool OnFrameContext(int x, int y);
	virtual bool OnPropsDiaolog(int x, int y)
	{
		return FALSE;
	}
	/// TD 2-11-05 QA70-7393 ON_SEL_CHANGE_OC_GLOBAL
	virtual bool OnSelectionChange()
	{
		return FALSE;
	}
	/// end ON_SEL_CHANGE_OC_GLOBAL

	/// EJP 2005-04-06 v8.0218 QA70-7588 GRAPHOBJ_SUPPORT_XFUNC
	
	
	bool InsertXFuncMenu(Menu& menu, int nPos, LPCSTR lpcszMenuName, int nCmdIdStart, int nCmdIdEnd, int nEvent = -1);
	
	///DSC 8/24/05 MORE_FILTERS_FOR_XF
	bool InsertXFuncMenu(Menu& menu, int nPos, LPCSTR lpcszMenuName, int nCmdIdStart, int nCmdIdEnd, DWORD* pdw=NULL, int nNumTypes=0);
	bool InsertXFuncMenuFromNames(Menu& menu, int nPos, LPCSTR lpcszMenuName, int nCmdIdStart, int nCmdIdEnd, const StringArray& vsNames);
	///end MORE_FILTERS_FOR_XF
	
	bool GetXFuncMenuItemName(string& strName, int nCmdId, int nCmdIdStart, int nCmdIdEnd, int nEvent = -1);
	
	///DSC 9/31/05 MORE_FILTERS_FOR_XF
	bool GetXFuncMenuItemNameFromCmdID(string& strName, int nCmdId, int nCmdIdStart, int nCmdIdEnd, const StringArray& pvsNames);
	bool GetXFuncMenuItemName(string& strName, int nCmdId, int nCmdIdStart, int nCmdIdEnd, DWORD* pdw=NULL, int nNumTypes=0);
	///end MORE_FILTERS_FOR_XF
	
	bool DoXFuncMenuItem(int nCmdId, int nCmdIdStart, int nCmdIdEnd, int nEvent, LPCSTR lpcszOCFuncName);
	/// end GRAPHOBJ_SUPPORT_XFUNC
};




enum
{
	CMD_WKS_LONG_NAMES = OC_MENURANGE_BEGIN,
	CMD_WKS_UNITS,
	CMD_WKS_COMMENT,
	CMD_WKS_PARAMETERS,
	/// ML 8/10/2006 QA70-8901 SAMPLE_RATE_LABEL_TYPE
	CMD_WKS_SAMPLE_RATE,
	/// end SAMPLE_RATE_LABEL_TYPE
	/// ML 9/15/2006 QA70-8950 SPARKLINE_LABEL
	CMD_WKS_SPARKLINE,
	/// end0 SPARKLINE_LABEL
	CMD_WKS_LABEL_CATEGORY,
	CMD_WKS_DATA_ROW_NAMES,
	CMD_WKS_COL_HEADER,
	CMD_WKS_ROW_HEADER,
	CMD_WKS_COLUMN_GRIDS,
	CMD_WKS_ROW_GRIDS,
	CMD_WKS_TRANSPOSE,	/// RVD 1/21/2008 qa70-10950 v8.0790 TRANSPOSE_WKS_TABLE
	CMD_WKS_DRAW_PAGE_BOUNDS,	/// RVD 2/22/2008 QA70-11158 v8.0811 DRAW_GRID_PAGE_BOUNDS
	// If a property is added here and to the menu, increment MAX_WKS_PROPS!
	///------ Folger 06/17/2011 ORG-3005-S1 DATA_COLUMN_REPLICATES_SUPPORT
	CMD_WKS_REPLICATES,
	///------ End DATA_COLUMN_REPLICATES_SUPPORT
	/// Zech 03/01/2012 ORG-5193-P1 ADD_COLUMN_FILTER_OPTION_TO_CONTEXT_MENU
	CMD_WKS_FILTER,
	/// END ADD_COLUMN_FILTER_OPTION_TO_CONTEXT_MENU
};

/// RVD 1/21/2008 qa70-10950 v8.0790 TRANSPOSE_WKS_TABLE
//#define		MAX_WKS_PROPS	12 
///------ Folger 06/17/2011 ORG-3005-S1 DATA_COLUMN_REPLICATES_SUPPORT
//#define		MAX_WKS_PROPS	13
/// Zech 03/01/2012 ORG-5193-P1 ADD_COLUMN_FILTER_OPTION_TO_CONTEXT_MENU
//#define		MAX_WKS_PROPS	14
#define		MAX_WKS_PROPS	15
/// END ADD_COLUMN_FILTER_OPTION_TO_CONTEXT_MENU
///------ End DATA_COLUMN_REPLICATES_SUPPORT
/// end TRANSPOSE_WKS_TABLE


enum
{
	BRN_WKS_VIEW = 100,
	BRN_WKS_VIEW_COLUMN_LABELS = 101,
	BRN_WKS_VIEW_ROW_LABELS,
	BRN_WKS_VIEW_HEADINGS,
	BRN_WKS_VIEW_GRIDLINES,
	
BRN_LAST_ENTRY	
};

class WksAccess;
#define MAX_EVENTS  10


typedef void (WksAccess::*PROPFUNCGET)(string& strVal);
typedef void (WksAccess::*PROPFUNCSET)(LPCSTR lpszVal);
bool GetBool(LPCSTR lpcszVal);
void SetBool(bool bVal, const string& strVal);

class WksPropertyTable
{
public:
	WksPropertyTable()
	{
		Init(0, NULL, NULL);
	}
	WksPropertyTable(const WksPropertyTable &orig)
	{
		Init(orig.m_nProp,orig.m_pFnGet,orig.m_pFnSet);

	}
	
	WksPropertyTable(int nProp, PROPFUNCGET pFnGet, PROPFUNCSET pFnSet)
	{
		Init(nProp, pFnGet, pFnSet);
	}
	
	
	
public:
	
	void Init(int nProp, PROPFUNCGET pFnGet, PROPFUNCSET pFnSet)
	{
		m_nProp		= nProp;
		m_pFnGet	= pFnGet;
		m_pFnSet	= pFnSet;
	}
	
	int 			m_nProp;
	PROPFUNCGET		m_pFnGet;
	PROPFUNCSET		m_pFnSet;

};
class WksAccess : public Worksheet
{
public:
	WksAccess();
	WksAccess(Worksheet &wks):Worksheet(wks){m_bHandled=FALSE;InitializePropertyTable();}
	
public:
	/// SY 2007-04-11 QA70-9592 8.0599 RESULT_SHEET_CONTEXT_MENU
	///	void GetTree(TreeNode& trProperties, int nSubBranchID = 0);
	void GetTree(TreeNode& trProperties, int nSubBranchID = 0, BOOL bResultSheet = FALSE);
	/// end RESULT_SHEET_CONTEXT_MENU
	bool SetTree(TreeNode& trProperties); // update wks properties from tree
	
	bool ShowDialog(TreeNode &tn, LPCSTR LpcszTitle = NULL, LPCSTR  lpcszDescription = NULL, HWND hWndParent = NULL);
	BOOL IsHandled();	
	
	// Set property functions
	// use prototype as defined by "typedef void (WksAccess::*PROPFUNCSET)(LPCSTR lpszVal);"
	void ShowHideLabelNames(LPCSTR lpcszVal)
	{
		ShowLabelCategoryNames(GetBool(lpcszVal));
	}
	
	void ShowHideColHeaders(LPCSTR lpcszVal)
	{
		ShowHeaders(GetBool(lpcszVal), TRUE);
	}
	
	
	void ShowHideRowHeaders(LPCSTR lpcszVal)
	{
		ShowHeaders(GetBool(lpcszVal), FALSE);
	}
	
	void ShowHideColGrids(LPCSTR lpcszVal)
	{
		string strRowGrids;
		IsShownRowGrids(strRowGrids);
		ShowGridLines(GetBool(lpcszVal), GetBool(strRowGrids));
	}
	
	void ShowHideRowGrids(LPCSTR lpcszVal)
	{
		string strColGrids;
		IsShownColGrids(strColGrids);
		ShowGridLines(GetBool(strColGrids), GetBool(lpcszVal));
	}
	
	void ShowHideRowNames(LPCSTR lpcszVal)
	{
	}
			
	
	void ShowHideLongNames(LPCSTR lpcszVal)
	{
		ShowHideRCLT(lpcszVal, RCLT_LONG_NAME);
	}
	
	void ShowHideUnits(LPCSTR lpcszVal)
	{
		ShowHideRCLT(lpcszVal, RCLT_UNIT);
	}
	
	void ShowHideComments(LPCSTR lpcszVal)
	{
		ShowHideRCLT(lpcszVal, RCLT_COMMENT);
	}
	
	void ShowHideParameters(LPCSTR lpcszVal)
	{
		ShowHideRCLT(lpcszVal, RCLT_PARAM);
	}
	
	void ShowHideSampleRate(LPCSTR lpcszVal)
	{
		ShowHideRCLT(lpcszVal, RCLT_SAMPLE_RATE);
	}
	
	void ShowHideSparkline(LPCSTR lpcszVal)
	{
		ShowHideRCLT(lpcszVal, RCLT_SPARKLINE);
	}
	/// end SPARKLINE_LABEL

	///------ Folger 06/17/2011 ORG-3005-S1 DATA_COLUMN_REPLICATES_SUPPORT
	void ShowHideReplicates(LPCSTR lpcszVal)
	{
		ShowHideRCLT(lpcszVal, RCLT_REPLICATES);
	}
	///------ End DATA_COLUMN_REPLICATES_SUPPORT
	
	/// Zech 03/01/2012 ORG-5193-P1 ADD_COLUMN_FILTER_OPTION_TO_CONTEXT_MENU
	void ShowHideFilter(LPCSTR lpcszVal)
	{
		ShowHideRCLT(lpcszVal, RCLT_COL_FILTER);
	}
	/// END ADD_COLUMN_FILTER_OPTION_TO_CONTEXT_MENU
	
	/// RVD 2/22/2008 QA70-11158 v8.0811 DRAW_GRID_PAGE_BOUNDS
	void SetDrawPageBounds(LPCSTR lpcszVal)
	{
		Worksheet wks = *this;
		DWORD dw = wks.Print.Cntrl.nVal;
		
		if( GetBool(lpcszVal) )
			dw |= GPC_PAGE_BOUNDS;
		else
			dw &= ~GPC_PAGE_BOUNDS;
		
		wks.Print.Cntrl.nVal = dw;
		wks.GetPage().Refresh();
	}
	void IsDrawPageBounds(string& strVal)
	{
		Worksheet wks = *this;
		DWORD dw = wks.Print.Cntrl.nVal;

		bool bDraw = false;
		
		if( dw & GPC_PAGE_BOUNDS )
			bDraw = true;

		SetBool(bDraw, strVal);
	}
	/// end DRAW_GRID_PAGE_BOUNDS

	// Get property functions
	// use prototype as defined by "typedef void (WksAccess::*PROPFUNCGET)(string& strVal);"
	void IsShownLabelNames(string& strVal)
	{
		SetBool(IsLabelCategoryNamesShown(), strVal);
	}
	
	void IsShownColHeaders(string& strVal)
	{
		SetBool(IsHeaderShown(TRUE), strVal);
	}
	
	void IsShownRowHeaders(string& strVal)
	{
		SetBool(IsHeaderShown(FALSE), strVal);
	}
	
	void IsShownColGrids(string& strVal)
	{
		BOOL bVertGridLinesShown, bHorizGridLinesShown;
		IsGridLinesShown(bVertGridLinesShown, bHorizGridLinesShown);
		SetBool(bVertGridLinesShown, strVal);
	}
	
	void IsShownRowGrids(string& strVal)
	{
		BOOL bVertGridLinesShown, bHorizGridLinesShown;
		IsGridLinesShown(bVertGridLinesShown, bHorizGridLinesShown);
		SetBool(bHorizGridLinesShown, strVal);
	}
	
	void IsShownRowNames(string& strVal)
	{
		SetBool(true, strVal);
	}
	
	void IsShownLongNames(string& strVal)
	{
		IsShownRCLT(strVal, RCLT_LONG_NAME);
	}
	
	void IsShownUnits(string& strVal)
	{
		IsShownRCLT(strVal, RCLT_UNIT);
	}
	
	void IsShownComments(string& strVal)
	{
		IsShownRCLT(strVal, RCLT_COMMENT);
	}
	
	void IsShownParameters(string& strVal)
	{
		IsShownRCLT(strVal, RCLT_PARAM);
	}
	
	void IsShownSampleRate(string& strVal)
	{
		IsShownRCLT(strVal, RCLT_SAMPLE_RATE);
	}
	
	void IsShownSparkline(string& strVal)
	{
		IsShownRCLT(strVal, RCLT_SPARKLINE);
	}
	/// end SPARKLINE_LABEL

	///------ Folger 06/17/2011 ORG-3005-S1 DATA_COLUMN_REPLICATES_SUPPORT
	void IsShownReplicates(string& strVal)
	{
		IsShownRCLT(strVal, RCLT_REPLICATES);
	}
	///------ End DATA_COLUMN_REPLICATES_SUPPORT
	
	/// Zech 03/01/2012 ORG-5193-P1 ADD_COLUMN_FILTER_OPTION_TO_CONTEXT_MENU
	void IsShownFilter(string &strVal)
	{
		IsShownRCLT(strVal, RCLT_COL_FILTER);
	}
	/// END ADD_COLUMN_FILTER_OPTION_TO_CONTEXT_MENU
	
	bool TogglePropertyValue(int nProperty);
	
	
	bool GetProperty(int nProperty, string &strProperty);
	bool SetProperty(int nProperty, LPCSTR lpcszProperty);
	bool GetProperty(int nProperty);
	
protected:
	BOOL addProperty(int nProperty, PROPFUNCGET pFnGet, PROPFUNCSET pFnSet);
	int  findProperty(int nProperty);
	void InitializePropertyTable();
	/// ML 9/15/2006 QA70-8950 SPARKLINE_LABEL
	void	IsShownRCLT(string& strVal, UINT nRCLT)
	{
		SetBool(IsLabelTypeShown(nRCLT), strVal);
	}
	
	void ShowHideRCLT(LPCSTR lpcszVal, UINT nRCLT)
	{
		if(!GetBool(lpcszVal))
			HideLabelByType(nRCLT, TRUE);
		else
			CheckAddLabelByType(nRCLT, -1, TRUE);
	}
	/// end SPARKLINE_LABEL


protected:
	
	BOOL		m_bHandled;
	
	/// ML 9/18/2006 QA70-8950 SPARKLINE_LABEL
	//static	WksPropertyTable   l_table[MAX_EVENTS];
	static	WksPropertyTable   l_table[MAX_WKS_PROPS];
	/// end SPARKLINE_LABEL
	static  bool			l_bInit;
	static  int 			l_nCurrent;

};

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///Hong 7/24/06 SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE
class MatAccess;

//typedef void (MatAccess::*PROPFUNCGET)(string& strVal);
//typedef void (MatAccess::*PROPFUNCSET)(LPCSTR lpszVal);

class MatPropertyTable
{
public:
	MatPropertyTable()
	{
		Init(0, NULL, NULL);
	}
	MatPropertyTable(const MatPropertyTable &orig)
	{
		Init(orig.m_nProp,orig.m_pFnGet,orig.m_pFnSet);

	}
	
	MatPropertyTable(int nProp, PROPFUNCGET pFnGet, PROPFUNCSET pFnSet)
	{
		Init(nProp, pFnGet, pFnSet);
	}
	
	
	
public:
	
	void Init(int nProp, PROPFUNCGET pFnGet, PROPFUNCSET pFnSet)
	{
		m_nProp		= nProp;
		m_pFnGet	= pFnGet;
		m_pFnSet	= pFnSet;
	}
	
	int 			m_nProp;
	PROPFUNCGET		m_pFnGet;
	PROPFUNCSET		m_pFnSet;

};
class MatAccess : public MatrixLayer
{
public:
	MatAccess();
	MatAccess(MatrixLayer &ml):MatrixLayer(ml){m_bHandled=FALSE;InitializePropertyTable();}
	
public:	
	void GetTree(TreeNode& trProperties, int nSubBranchID = 0);
	bool SetTree(TreeNode& trProperties); // update wks properties from tree
	
	bool ShowDialog(TreeNode &tn, LPCSTR LpcszTitle = NULL, LPCSTR  lpcszDescription = NULL, HWND hWndParent = NULL);
	BOOL IsHandled();
protected:
//	BOOL addProperty(int nProperty, PROPFUNCGET pFnGet, PROPFUNCSET pFnSet);
	int  findProperty(int nProperty);
	void InitializePropertyTable();


protected:
	
	BOOL		m_bHandled;
	
static	MatPropertyTable   l_table[MAX_EVENTS];
static  bool			l_bInit;
static  int 			l_nCurrent;

};
///end SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
////
////   GridAccess
////
////
class GridAccess;


typedef void (GridAccess::*GAPROPFUNCGET)(string& strVal);
typedef void (GridAccess::*GAPROPFUNCSET)(LPCSTR lpszVal);

class GridPropertyTable
{
public:
	GridPropertyTable()
	{
		Init(0, NULL, NULL);
	}
	GridPropertyTable(const GridPropertyTable &orig)
	{
		Init(orig.m_nProp,orig.m_pFnGet,orig.m_pFnSet);

	}
	
	GridPropertyTable(int nProp, GAPROPFUNCGET pFnGet, GAPROPFUNCSET pFnSet)
	{
		Init(nProp, pFnGet, pFnSet);
	}
	
	
	
public:
	
	void Init(int nProp, GAPROPFUNCGET pFnGet, GAPROPFUNCSET pFnSet)
	{
		m_nProp		= nProp;
		m_pFnGet	= pFnGet;
		m_pFnSet	= pFnSet;
	}
	
	int 			m_nProp;
	GAPROPFUNCGET	m_pFnGet;
	GAPROPFUNCSET	m_pFnSet;

};




class GridAccess : public Grid
{
public:
	GridAccess()
	{
		m_bHandled = FALSE;
		InitializePropertyTable();
	}
	
	GridAccess(Grid &grid):Grid(grid)
	{
		m_bHandled = FALSE;
		InitializePropertyTable();
	}
	
public:
	void	GetTree(TreeNode& trProperties, int nSubBranchID = 0);
	bool	SetTree(TreeNode& trProperties);
	BOOL	IsHandled();	

	void ShowHideColHeaders(LPCSTR lpcszVal)
	{
		ShowHeaders(GetBool(lpcszVal), TRUE, true);
	}
	
	
	void ShowHideRowHeaders(LPCSTR lpcszVal)
	{
		ShowHeaders(GetBool(lpcszVal), TRUE, false);
	}
	
	void ShowHideColGrids(LPCSTR lpcszVal)
	{
		ShowGridLines(TRUE, GetBool(lpcszVal), TRUE);
	}
	
	void ShowHideRowGrids(LPCSTR lpcszVal)
	{
		ShowGridLines(FALSE, GetBool(lpcszVal), TRUE);
	}
	
	void IsShownColHeaders(string& strVal)
	{
		SetBool(IsHeadersShown(TRUE), strVal);
	}
	
	void IsShownRowHeaders(string& strVal)
	{
		SetBool(IsHeadersShown(FALSE), strVal);
	}
	
	void IsShownColGrids(string& strVal)
	{
		BOOL	bVertGridLinesShown;		
		IsGridLinesShown(&bVertGridLinesShown, NULL);
		SetBool(bVertGridLinesShown, strVal);
	}
	
	void IsShownRowGrids(string& strVal)
	{
		BOOL	bHorizGridLinesShown;
		IsGridLinesShown(NULL, &bHorizGridLinesShown);
		SetBool(bHorizGridLinesShown, strVal);
	}
	
	/// RVD 1/21/2008 qa70-10950 v8.0790 TRANSPOSE_WKS_TABLE
	void SetTranspose(LPCSTR lpcszVal)
	{
		SetTranspose(GetBool(lpcszVal));
	}
	void IsTransposed(string& strVal)
	{
		SetBool(IsTransposed(), strVal);
	}
	/// end TRANSPOSE_WKS_TABLE

	bool GetProperty(int nProperty, string &strProperty);
	bool SetProperty(int nProperty, LPCSTR lpcszProperty);
	bool GetProperty(int nProperty);

	bool	TogglePropertyValue(int nProperty);

	
protected:
	void	InitializePropertyTable();
	int		findProperty(int nProperty);
	BOOL	addProperty(int nProp, GAPROPFUNCGET pFnGet, GAPROPFUNCSET pFnSet);

	
	
	BOOL		m_bHandled;
	
static	GridPropertyTable   l_table[MAX_EVENTS];
static  bool				l_bInit;
static  int 				l_nCurrent;
};


/// TD 4-12-07 QA70-9603 OC_CONTROLLED_DIALOGBARS_AUTOLAUNCH_ON_ORIGIN_BEGIN
BOOL RegisterDlgBarState(LPCSTR lpcszBarFile, LPCSTR lpcszFn, BOOL bShow);
/// end OC_CONTROLLED_DIALOGBARS_AUTOLAUNCH_ON_ORIGIN_BEGIN

/// EJP 2005-04-11 v8.0220 QA70-7588 GRAPHOBJ_SUPPORT_XFUNC
#define IDM_CM_GROBJ_X_FUNCS_BEGIN				OC_MENURANGE_BEGIN
#define IDM_CM_GROBJ_X_FUNCS_END				(IDM_CM_GROBJ_X_FUNCS_BEGIN + 100)
/// end GRAPHOBJ_SUPPORT_XFUNC

#endif //_ORIGIN_EVENTS_H

