/*------------------------------------------------------------------------------*
 * File Name: OpenTemplateDlg														*
 * Creation : 																	*
 * Purpose: OriginC Source H file												*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 11/08/2011 DOUBLE._CLICK_TO_OPEN_SELECTED_TEMPLATE					*
 *------------------------------------------------------------------------------*/
 
#ifndef OPEN_TEMPLATE_DLG_H
#define OPEN_TEMPLATE_DLG_H

#include "MenuBase.h"
#include "GridControl.h"

/// Hong 09/29/11 LOCALIZATION_BUG
//#define STR_LIST_HEADER		"Name|Size(KB)|Date Modified|Description"
#define STR_LIST_HEADER		_L("Name|Size(KB)|Date Modified|Description")
/// end LOCALIZATION_BUG

struct TemplateInfo
{
	string 		strName;
	int 		nFileSize;
	string 		strDateModified;
	string 		strDescription;	
};

class TemplateGirdList;
class TemplateGridHeaderMenu : public MenuBase
{
public:
	TemplateGridHeaderMenu(TemplateGirdList* pList)
	{
		string strItems = STR_LIST_HEADER;
		vector<string> vs;
		strItems.GetTokens(vs, '|'); 
		
		for(int ii = 0; ii < vs.GetSize(); ii++)
		{
			UINT nFlags = MF_STRING;
			if( !pList->GetIsColHidden(ii) )
				nFlags |= MF_CHECKED;
			
			Add(vs[ii], OnMenuItem, nFlags);
		}

	}
};

class TemplateGirdList : public GridListControl
{
public:
	~TemplateGirdList();
	
	void Init(int nID, WndContainer& dlg);	
	
	void UpdateInfo(const Array<TemplateInfo&> &arrInfos, int nDefaultTemplate);
	
	string GetSelectedTemplate();
	
	void OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, bool* pCancel);
};


class OpenTemplateDlg : public ResizeDialog
{
public:
	OpenTemplateDlg() : ResizeDialog(IDD_OPEN_TEMPLATE_DLG, "ODlg8")
	{
	}
	~OpenTemplateDlg()
	{		
	}

	int DoModalEx(HWND hWndParent = NULL)
	{		
		InitMsgMap();
		int nRet = ResizeDialog::DoModal(hWndParent);		
		return nRet;
	}
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)
	ON_SIZE(OnDlgResize)	
	ON_DESTROY(OnDestroy)

	ON_BN_CLICKED(IDC_RADIO_WND_TYPE_WB, OnWndTypeChange)	
	ON_BN_CLICKED(IDC_RADIO_WND_TYPE_MB, OnWndTypeChange)
	ON_BN_CLICKED(IDC_RADIO_WND_TYPE_GRAPH, OnWndTypeChange)
	ON_BN_CLICKED(IDC_RADIO_TEMPLATE_SYS_FOLDER, OnTemplatePathRadioClick)
	ON_BN_CLICKED(IDC_RADIO_TEMPLATE_USER_FOLDER, OnTemplatePathRadioClick)
	ON_BN_CLICKED(IDC_RADIO_TEMPLATE_CUSTOM_FOLDER, OnTemplatePathRadioClick)
	ON_BN_CLICKED(IDC_TEMPLATE_PATH_BROWSER, OnTemplatePathBrowserClick)
	ON_BN_CLICKED(IDC_CHECK_TEMPLATE_WITHOUT_DATA, OnTemplateTypeCheckBoxChecked)
	ON_BN_CLICKED(IDC_CHECK_ANALYSIS_TEMPLATE, OnTemplateTypeCheckBoxChecked)
	ON_GRID_SEL_CHANGE(IDC_LIST_TEMPLATES, OnTemplateListSelChange)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_LIST_TEMPLATES, OnTemplateListBeforeMouseDown)
	ON_BN_CLICKED(IDC_BUTTON_SET_DEFAULT, OnSetDefaultButtonClick)
	ON_BN_CLICKED(IDOK, OnOK)

	///------ Folger 11/08/2011 DOUBLE._CLICK_TO_OPEN_SELECTED_TEMPLATE
	ON_GRID_DBLCLICK(IDC_LIST_TEMPLATES, OnDblClickToClose)
	///------ End DOUBLE._CLICK_TO_OPEN_SELECTED_TEMPLATE
	
EVENTS_END

	BOOL OnInitDialog();
	BOOL OnReady();
	BOOL OnDlgResize(int nType, int cx, int cy);
	bool OnDestroy();
	
	BOOL OnWndTypeChange(Control ctrl);
	BOOL OnTemplatePathRadioClick(Control ctrl);
	BOOL OnTemplatePathBrowserClick(Control ctrl);
	BOOL OnTemplateTypeCheckBoxChecked(Control ctrl);
	void OnTemplateListSelChange(Control cntrl);
	void OnTemplateListBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, bool* pCancel);
	
	BOOL OnSetDefaultButtonClick(Control cntrl);
	BOOL OnOK(Control cntrl);

	///------ Folger 11/08/2011 DOUBLE._CLICK_TO_OPEN_SELECTED_TEMPLATE
	BOOL OnDblClickToClose(Control ctrl);
	///------ End DOUBLE._CLICK_TO_OPEN_SELECTED_TEMPLATE
	
private:
	void 	initControls();
	void 	updateControlsOnWndTypeChange();

	int 	getTemplateWndType();
	string 	getTemplateExtension(int nWndType, int nTemplateType);
	string 	getDefaultTemplate();
	int 	getPageType();
	
	int 	getOneTemplateType(int nWndType, int nTemplateType, Array<TemplateInfo&> &arrInfos, LPCSTR lpcszPath, int *pnDefaultTemplate = NULL);
	void 	getTemplateDescription(LPCSTR lpcszTemplateName, string& strDesc);
	int 	getTemplateInfo(Array<TemplateInfo&> &arrInfos, int &nDefaultTemplate);
	void 	updateTemplateList();
	string 	getSelectedTemplate();
	bool 	isAnalysisTemplate(LPCSTR lpcszTemplate);
	
	void 	setListTemplateItemBold(int nNewDefaultIndex, int nOldDefaultIndex);
	
	void 	updateTemplatePath(int nFolderType);
	int		getPathType();
	string	getPath();

	string getLTDefaultTemplateVar(); /// Bill 08/24/2011 ORG-3463-P3 USE_SYSTEM_VARIABLE_TO_SET_DEFAULT_TEMPLATE
	
	// click OK button on dialog
	bool 	doLoadTemplate();
	
	bool 	getDefTemplateFullPath(string& strDefault);/// Sen 08/11/2011 ORG-2629-S8 DEFAULT_TEMPLATE_SHOULD_BE_BOLD
	
private:	
	Button			m_checkTemplateWithoutData;
	Button			m_checkAnalysisTemplate;
	TemplateGirdList	m_listTemplates;
	int 			m_nDefaultTemplates;
};

#endif //OPEN_TEMPLATE_DLG_H
