

#ifndef _OODBC_H
#define _OODBC_H

#ifdef	_OCODBC_API_IMPLEMENTATION_
#define ODBC_DLL_API	__declspec(dllexport)
#else
#define	ODBC_DLL_API
#pragma dll(OODBC);
/// TD ML 11-09-2010 NEW_TYPES
#ifndef ODWP
#define ODWP uint
#endif//ODWP
/// end NEW_TYPES
#endif

//ODBC UTILS BEGIN ----------------------------------------------------
//return code for odbc utils
enum {
	OODBC_OK = 0,
	OODBC_NOT_CONNECTED = -1,
	OODBC_NO_RESULT_SET = -2,
	OODBC_CURSOR_MOVE_ERR = -3,
	OODBC_NO_BUFFER = -4,
	OODBC_SQL_EXEC_ERR = -5,
};

/**
	This function connect to a datasource.
	Parameters:
		lpcszDataSource = [input] datasource name.
		lpcszUserID = [input] user's ID needed in authentication.
		lpcszPassword = [input]user password corresponding to use ID.
	
	Return: 
		return 0 if fail, else a pointer to an COCODBC object.
*/
ODBC_DLL_API ODWP	oodbc_connect(LPCSTR lpcszDataSource, LPCSTR lpcszUserID, LPCSTR lpcszPassword);	/// TD ML 11-09-2010 NEW_TYPES

///Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER

/**
	This function connect to a datasource using connecting string.
	Parameters:
		lpcszConn = [input] connecting string containing datasource name, user and password.
		hWnd = [input] parent window's handle.
		
	Return: 
		return 0 if fail, else a pointer to an COCODBC object
*/
ODBC_DLL_API ODWP	oodbc_connect_ex(LPCSTR lpcszConn, HWND hWnd = NULL);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function is used to check diagnose ODBC error.
	Parameters:
		dwODBC = [input] which is the pointer of an COCODBC object.
		pnErr = [output] if not NULL, contains minus value when dwODBC point to an invalid COCODBC object.

	Return : 
		a string containing the latest error message, return empty string if no error occurs.
*/
ODBC_DLL_API const char*	oodbc_get_last_error(ODWP dwODBC, int* pnErr = NULL);	/// TD ML 11-09-2010 NEW_TYPES
///end SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER

/**
	This function close a opened ODBC link.
	Parameters:
		dwODBC = [input] which is the pointer of an COCODBC object.
	Return:
		This function has no return value.

*/
ODBC_DLL_API void	oodbc_disconnect(ODWP dwODBC);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function execute a select statement in a datasource.
	Parameters:
		dwODBC = [input] which is the pointer of an COCODBC object.
		lpcszSelSQl = [input] the statement to execute.
	Return:
		return TRUE on success, else return FALSE.
*/
ODBC_DLL_API BOOL	oodbc_exec_select(ODWP dwODBC, LPCSTR lpcszSelSQL);	/// TD ML 11-09-2010 NEW_TYPES


/**
	This function get the number of fields in a result set.
	Parameters:
		dwODBC = [input] which is the pointer of a COCODBC object.
	Return:
		return the number of columns, return -1 if dwODBC is invalid or no statement executed.
*/
ODBC_DLL_API int	oodbc_get_columns_count(ODWP dwODBC);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function is use to query the number of rows in result set
	Parameters:
		dwODBC = [input] which is the pointer of a COCODBC object.
	Return:
		return the number of rows in result set, return -1 for unknown or error.

*/
ODBC_DLL_API int	oodbc_get_rows_count(ODWP dwODBC);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function move the cursor to the first row of a result set
	Parameters:
		dwODBC = [input] the pointer of a COCODBC object.
	Return:
		return OODBC_OK on success, else return minus error code.
*/
ODBC_DLL_API int	oodbc_move_first(ODWP dwODBC);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function move the cursor to next row.
	Parameters:
		dwODBC = [input] the pointer of a COCODBC object.
	Return:
		return OODBC_OK on success, else return minus error code.
*/
ODBC_DLL_API int	oodbc_move_next(ODWP dwODBC);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function move hte cursor to previous row.
	Parameters:
		dwODBC = [input] the pointer of a COCODBC object.
	Return:
		return OODBC_OK on success, else return minus error code.
*/
ODBC_DLL_API int	oodbc_move_previous(ODWP dwODBC);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function move hte cursor to last row.
	Parameters:
		dwODBC = [input] the pointer of a COCODBC object.
	Return:
		return OODBC_OK on success, else return minus error code.
*/
ODBC_DLL_API int	oodbc_move_last(ODWP dwODBC);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function move the cursor to specified row.
	Parameters:
		dwODBC = [input] the pointer of a COCODBC object.
		iRow = [input] the specified row number.
	Return:
		return OODBC_OK on success, else return minus error code.
*/
ODBC_DLL_API int	oodbc_move_to(ODWP dwODBC, int iRow);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function move the cursor to specified row, by skipping nRows from current row
	Parameters:
		dwODBC = [input] the pointer of a COCODBC object.
		nRows = [input] the number of rows to skip.
	Return:
		return OODBC_OK on success, else return minus error code.
*/
ODBC_DLL_API int	oodbc_skip_rows(ODWP dwODBC, int nRows);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function get one field's name in a result set.
	Parameters:
		dwODBC = [input] which is the pointer of a COCODBC object.
		nCol = [input] the index of the queried field.
		pnErr = [input] contains error code when fail.
	Return:
		return the corresponding field name, return NULL when fail.
*/
ODBC_DLL_API const char*	oodbc_get_column_name(ODWP dwODBC, int nCol, int* pnErr);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function get the field's data format information by index
	Parameters:
		dwODBC = [input] which is the pointer of a COCODBC object.
		nCol = [input] the index of the queried field.
		pnErr = [input] contains error code when fail.
	Return:
		return an integer indicating the SQL_C_* type, like SQL_C_LONG. etc, return SQL_TYPE_NULL when fail.
*/
ODBC_DLL_API int	oodbc_get_column_datatype(ODWP dwODBC, int nCol, int* pnErr);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function import a whole field's data input Origin worksheet column.
	Parameters:
		dwODBC = [input] which is the pointer of a COCODBC object.
		lpcszRange = [input] which specify into which column the data should be put.
		nCol = [input] the index of the wanted field.
	Return:
		return 0 on success, return -1 when fail.

*/
ODBC_DLL_API int	oodbc_get_column_data(ODWP dwODBC, LPCSTR lpcszRange, int nCol);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function check whether a field is NULL
	Parameters:
		dwODBC = [input] which is the pointer of a COCODBC object.
		iCol = [input] the field's index of current row
		pbIsNULL = [output] the value indicate whether the field is NULL
	Return:
		return OODBC_OK on success, else return minus error code.
*/
ODBC_DLL_API int	oodbc_is_field_null(ODWP dwODBC, int iCol, bool* pbIsNULL);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function is used to check the length of a value in specified field of current row.
	Parameters:
		dwODBC = [input] the pointer of a COCODBC object.
		iCol = [input] the field's index of current row.
		pnLength = [output] the number of bytes the field of current row occupies.
	Return:
		return OODBC_OK on success, else return minus error code.
*/
ODBC_DLL_API int	oodbc_get_field_length(ODWP dwODBC, int iCol, int* pnLength);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function get a field value as a Integer.
	Parameters:
		dwODBC = [input] the pointer of a COCODBC object.
		iCol = [input] the field's index of current row.
		pnVal = [output] the field's value as integer.
	Return:
		return OODBC_OK on success, else return minus error code.
*/
ODBC_DLL_API int	oodbc_get_field_int(ODWP dwODBC, int iCol, int* pnVal);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function get a field value as a Double.
	Parameters:
		dwODBC = [input] the pointer of a COCODBC object.
		iCol = [input] the field's index of current row.
		pdVal = [output] the field's value as double type.
	Return:
		return OODBC_OK on success, else return minus error code.
*/
ODBC_DLL_API int	oodbc_get_field_double(ODWP dwODBC, int iCol, double* pdVal);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function get a field value as a Text.
	Parameters:
		dwODBC = [input] the pointer of a COCODBC object.
		iCol = [input] the field's index of current row.
		ppStr = [output] the field's value as Text.
	Return:
		return OODBC_OK on success, else return minus error code.
*/
ODBC_DLL_API int	oodbc_get_field_text(ODWP dwODBC, int iCol, char** ppStr);	/// TD ML 11-09-2010 NEW_TYPES

/**
	This function get a field value' pointer.
	Parameters:
		dwODBC = [input] the pointer of a COCODBC object.
		iCol = [input] the field's index of current row.
		ppVal = [output] the field's value as void pointer.
	Return:
		return OODBC_OK on success, else return minus error code.
*/
ODBC_DLL_API int	oodbc_get_field_pointer(ODWP dwODBC, int iCol, void** ppVal);	/// TD ML 11-09-2010 NEW_TYPES


/** 
	This function export worksheet data into database table
	Parameters:
		dwODBC = [input] the pointer of a COCODBC object
		lpcszSQL = [input] the sql statement to be executed, should be like "insert into TableName values(?, ?, ?)", where ? stands for one parameter.
		lpcszWks = [input] the worksheet name
		pnC1 = [input] if not NULL, indicates the beginning of worksheet column range
		pnC2 = [input] if not NULL, indicates the end of worksheet column range
		pnR1 = [input] if not NULL, indicates the beginning of worksheet row range
		pnR2 = [input] if not NULL, indicates the end of worksheet row range
	Return:
		return OODBC_OK on success, else return minus error code.
*/
ODBC_DLL_API int	oodbc_export_wks_data(ODWP dwODBC, LPCSTR lpcszSQL, LPCSTR lpcszWks, int* pnC1 = NULL, int* pnC2 = NULL, int* pnR1 = NULL, int* pnR2 = NULL);	/// TD ML 11-09-2010 NEW_TYPES


/**
	This function execute a simple sql statement, can be update or delete or insert statement, etc.
	Parameters:
		dwODBC = [input] the pointer of a COCODBC object
		lpcszSQL = [input] the sql statement to be executed.
	Return:
		return the number of rows effected, or minus error code for failure.
*/
ODBC_DLL_API int	oodbc_execute_direct(ODWP dwODBC, LPCSTR lpcszSQL);	/// TD ML 11-09-2010 NEW_TYPES
//ODBC UTILS END ------------------------------------------------------


#endif //_OODBC_H



