/*------------------------------------------------------------------------------*
 * File Name: OMat.h															*
 * Creation: GJL 5/13/02														*
 * Purpose: Origin C header file for OMat.c										*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * SY 12/29/2004 v8.0181 OC_CLEANUP_REMOVING_wks_utils_dlg_utils_app_utils		*
 * Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING					*
 *------------------------------------------------------------------------------*/

#ifndef _OMAT_H
#define _OMAT_H

//////////////////////////////////////////////////////////////////////////////////
// Direct Matrix Conversion (DMC) constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define DMC_WKS_SEL_ERROR_MSG		"Invalid Selected Range. Select a contiguous range of worksheet/workbook data and click the Update Selected Range\nbutton or enter a valid range similar to Data1_A[1]:K[8] or [Book1]Sheet1!$A$1:$K$8."
#define DMC_INPUT_WKS_ERROR_MSG		"Unable to get the selected worksheet/workbook range."
#define DMC_OUTPUT_MAT_ERROR_MSG	"Unable to create an output matrix."
#define DMC_XMAP_WARNING_MSG		"X values not uniformly spaced - default X coordinates 1 to number of columns used.\nSelect the Matrix:Set Dimensions menu item to specify new X coordinates." 
#define DMC_YMAP_WARNING_MSG		"Y values not uniformly spaced - default Y coordinates 1 to number of rows used.\nSelect the Matrix:Set Dimensions menu item to specify new Y coordinates." 

/// Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING
//#define DMC_MATRIX_PAGE_LABEL		"From selected range "
#define DMC_MATRIX_PAGE_LABEL		"From selected range"
/// End REMOVE_SPACE_LOCATION_STRING

//////////////////////////////////////////////////////////////////////////////////
// Matrix Replace (MR) constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define MR_TITLE					"Matrix Replace"
#define MR_COND_VAL_NOT_OK_MSG		"The Condition value must be a single numeric value."
#define MR_REPL_VAL_NOT_OK_MSG		"The Replace with value must be a single numeric value."
#define MR_ABS_COND_ERROR_MSG		"Absolute value function not compatible with negative or missing Condition value.\nMatrix Replace not performed." 
#define MR_ACT_MAT_ERROR_MSG		"Unable to get active matrix. Matrix Replace not performed."
#define MR_UNDO_WARNING_MSG			"Undo for this Matrix Replace operation will not be available.\nDo you want to continue?"
#define MR_FAILED_UNDO_ERROR_MSG	"Matrix Replace failed. Original matrix values have been restored."
#define MR_FAILED_ERROR_MSG			"Matrix Replace failed."

#define MR_UNDO_FAILED_ERROR_MSG	"Unable to perform Undo Matrix Replace."
#define MR_UNDO_SUCCESS_MSG			"Undo Matrix Replace has been completed."

//////////////////////////////////////////////////////////////////////////////////
// Non-Localzed constants and literals used in Direct Matrix Conversion
//////////////////////////////////////////////////////////////////////////////////
//
#define DMC_ESCAPE						-1
#define DMC_NO_ERROR					0
#define DMC_XMAP_WARNING				1
#define DMC_YMAP_WARNING				2
#define DMC_WKS_SEL_ERROR				100
#define DMC_INPUT_WKS_PAGE_ERROR		101
#define DMC_INPUT_ORIGIN_WKSHT_ERROR	102
#define DMC_INPUT_EXCEL_WKSHT_ERROR		103
#define DMC_UPDATE_ORIGIN_ERROR			104
#define DMC_CPY_WKS_TO_MAT_ERROR		105
#define DMC_TRANSPOSE_MATRIX_ERROR		106
#define DMC_ATTACH_OUTPUT_MAT_ERROR		107
#define DMC_SUB_MAT_ERROR				108

#define DMC_UNIFORM_SPACING_TOL			0.05
#define DMC_X_VARIES_ACROSS_ROWS		1

//////////////////////////////////////////////////////////////////////////////////
// Non-Localzed constants and literals used in Matrix Replace
//////////////////////////////////////////////////////////////////////////////////
//
#define MR_NO_ERROR						0
#define MR_ABS_COND_ERROR				100
#define MR_ACT_MATRIX_ERROR				101
#define MR_NO_UNDO_QUIT_ERROR			102
#define MR_FAILED_ERROR					103
#define MR_UNDO_FAILED_ERROR			104

#define MR_UNDO_WKS_NAME				"MRUndo"

//////////////////////////////////////////////////////////////////////////////////
// Function Prototypes in OMat.c
//////////////////////////////////////////////////////////////////////////////////
//

/**
		HLOC function to directly convert an Origin worksheet or Excel workbook range
		selection to a matrix.
	Example:
		See the OnClickConvert function in OMatDlgDMC.c for a sample call.
	Parameters:
		trDMC=Input DirectMatConvert tree containing all dialog settings
	Return:
		Returns DMC_NO_ERROR on success and a DMC_ERROR code on failure.
*/
int ConvertWksToMatrixDirect(Tree& trDMC);

/**
		LLOC function to directly convert an Origin worksheet or Excel workbook range
		selection to a matrix according to a bitwise data format description code.
	Example:
		See the ConvertWksToMatrixDirect function in OMat.c for a sample call.
	Parameters:
		strWksSelection=Input worksheet/workbook range selection string like "Worksheet_A[1]:B[7]" or
			"[Book1]Sheet1!$A$1:$B$7"
		iDataFormat=Bitwise data format description: Bit 0=1 X varies across columns or Bit 0=0 Y varies
			across columns, Bit 1=1 First row contains X/Y values, Bit 2=1 First column contains X/Y values
		mpOut=Output matrix page
	Return:
		Returns DMC_NO_ERROR and a valid matrix page on success or a DMC_ERROR code on failure.
*/
int convert_wks_to_matrix_direct(string strWksSelection, int iDataFormat, MatrixPage& mpOut);

/**
		Create and initialize a DirectMatConvert tree.
	Return:
		Returns a newly created DirectMatConvert tree.
*/
Tree CreateDirectMatConvertTree();

/**
		Initialize a DirectMatConvert tree.
	Parameters:
		trDMC=DirectMatConvert tree to initialize
	Return:
		Returns an initialized DirectMatConvert tree by reference.
*/
BOOL InitDirectMatConvertTree(Tree& trDMC);

/**
		HLOC function to perfrom conditional replace on an internal Origin matrix.
	Example:
		See the OnClickReplace function in OMatDlgMR.c for a sample call.
	Parameters:
		trMR=Input MatrixReplace tree containing all dialog settings
	Return:
		Returns MR_NO_ERROR or a MR_ERROR code on failure.
*/
int MatrixReplace(Tree& trMR);

/**
		HLOC to undo matrix replace.
	Example:
		iRet = UndoMatrixReplace();
	Return:
		Returns MR_NO_ERROR on success or MR_UNDO_FAILED_ERROR on failure.
*/
int UndoMatrixReplace();

/**
		Create and initialize a MatrixReplace tree.
	Return:
		Returns a newly created MatrixReplace tree.
*/
Tree CreateMatrixReplaceTree();

/**
		Initialize a MatrixReplace tree.
	Parameters:
		trMR=MatrixReplace tree to initialize
	Return:
		Returns an initialized MatrixReplace tree by reference.
*/
BOOL InitMatrixReplaceTree(Tree& trMR);

///--------- SY 12/29/2004 v8.0181 OC_CLEANUP_REMOVING_wks_utils_dlg_utils_app_utils
/**
		Create new window using specified template, options, and enumerated base name.
	Example:
		// Create hidden matrix window with no GUI access allowed
		CreateWindow( "Origin.OTM", CREATE_HIDDEN | CREATE_NO_GUI_ACCESS );
	Parameters:
		strTemplateName=Input path and name of template to use, default is "Origin.OTW"
		iCreateOptions=Input create options as specified by bitwise CREATE_ constants in
			OC_const.h, default is CREATE_HIDDEN  
		strBaseWindowName=Input enumerated base name for created window, default "" automatically
			uses Origin default enumerated names like Data1, Data2, etc.
		bAlwaysEnumerate=Input flag specifying whether or not to enumerate strBaseWindowName
			if a window by that name does not already exist, default is TRUE 
	Return:
		Returns the name of the newly created window on success and returns "" on failure.  
*/
string CreateWindow( string strTemplateName = "Origin.OTW", int iCreateOptions = CREATE_HIDDEN,
	 string strBaseWindowName = "", BOOL bAlwaysEnumerate = TRUE );

/**
		Parse a worksheet/workbook selection string and return the worksheet/workbook name, workbook sheet
		name (if Excel workbook), and column and row selection indices (as integers).
	Example:
		
	Parameters:
		strWksSelection=Input worksheet/workbook selection string
		strWksName=Output worksheet/workbook name
		strSheetName=If Excel workbook output workbook sheet name else NULL
		iC1=Output index of first selected column (0 based)
		iC2=Output index of last selected column (0 based)
		iR1=Output index of first selected row (0 based)
		iR2=Output index of last selected row (0 based)
	Return:
		Returns TRUE, worksheet/workbook name, workbook sheet name (if Excel), and column and row selection
		indices (as integers) on success and FALSE on failure.
*/
BOOL ParseWksSelection( string strWksSelection, string& strWksName, string& strSheetName, int& iC1, int& iC2, int& iR1, int& iR2 );

#define GCWS_EXCEL_CONTIG_SEL			"[%s]%s!$%s$%d:$%s$%d"
#define GCWS_WKS_CONTIG_SEL				"%s_%s[%d]:%s[%d]"
#define GCWS_NO_ERROR					0
#define GCWS_NO_SEL_WARNING				1
#define GCWS_BAD_SEL_ERROR				100
#define GCWS_INVALID_TREENODE_ERROR		101
#define GCWS_NO_SINGLE_COL_ERROR		102
/**
		Gets the current selection from an Origin worksheet or Excel workbook in native
		Origin or Excel format. The selected range must be contiguous.
	Example:
		string strSelectedRange;
		int iRet;
		iRet = GetContiguousWksSelection( strSelectedRange );
	Parameters:
		strSelectedRange=Output selected range
		bSelectAll=Returns entire worksheet/workbook sheet as selection range, default is FALSE
	Return:
		If successful returns WKS_UTILS_NO_ERROR and a formatted string containing the
		current Origin worksheet or Excel workbook selection. If bSelectAll is TRUE then
		the entire worksheet is returned as the selection string. If there is a problem
		getting the selection or if the selected range is not contiguous then
		WKS_UTILS_BAD_SEL_ERROR and an empty string are returned. If there is no 
		selection then WKS_UTILS_NO_SEL_WARNING and an empty string are returned.
*/
int GetContiguousWksSelection( string& strSelectedRange, BOOL bSelectAll = FALSE );

/**
		Determine whether or not the specified elements of a vectorbase derived object are uniformly
		spaced.
	Example:
		See function omConvertWksToMatrixDirect in OMat.c for sample call.
	Parameters:
		dDelta=Output difference between elements if uniform spacing else 0.0
		vIn=Input vectorbase derived object
		dTol=Input relative tolerance between 0 and 1 (default is 0.05)
		i1=Input beginning 0 based index of vector to test (default is 0)
		i2=Input ending 0 based index of vector to test (default -1 tests to last element)
	Return:
		Returns TRUE and NANUM if only one element is tested, returns TRUE and the difference between the first
		two elements tested if the spacing is uniform, returns FALSE and the difference between the first two
		elements tested if the spacing is not uniform, or returns FALSE and NANUM if there is an error.
*/
BOOL VectorHasUniformSpacing( double& dDelta, vectorbase& vIn, double dTol = 0.05, int i1 = 0, int i2 = -1 );
///---------- end OC_CLEANUP_REMOVING_wks_utils_dlg_utils_app_utils

#endif //_OMAT_H