/*------------------------------------------------------------------------------*
 * File Name: OGLSettings.h														*
 * Creation : 																	*
 * Purpose: OriginC Source H file												*
  * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#ifndef OGL_SETTINGS_DLG_H
#define OGL_SETTINGS_DLG_H


#define STR_OGL_VAR_LIST_HEADER _L("Variable|Value|Comment")
class OGLVarList : public GridListControl
{
public:
	OGLVarList(){}
	~OGLVarList(){}
	
	void Init(int nID, WndContainer& dlg, WndContainer* pParentDlg = NULL);
	
private:
	void addVariables();
	string getVaraibleValue(LPCSTR lpcszVarName);
	int getOneVariableInfo(vector<string>& vsTable, LPCSTR lpcszVarName, LPCSTR lpcszVarComments);
};

class OGLInfoSubDlg : public Dialog
{
public:
	OGLInfoSubDlg() :  Dialog(IDD_OGL_INFO_DLG, "ODlg8")
	{
	}
	
	~OGLInfoSubDlg() {}	
};

class OGLVarSubDlg : public Dialog
{
public:
	OGLVarSubDlg() :  Dialog(IDD_OGL_VAR_DLG, "ODlg8") {}	
	~OGLVarSubDlg() {}	
	
	BOOL Create(HWND hWndParent = NULL);
	
protected:
EVENTS_BEGIN
	ON_SIZE(OnDlgResize)
EVENTS_END	

	bool OnDlgResize(int nType, int cx, int cy);
	
private:
	OGLVarList		m_VarList;
};


class OGLSettingsDlg : public ResizeDialog
{
public:	
	OGLSettingsDlg() : ResizeDialog(IDD_OGL_SETTINGS_DLG, "ODlg8") {}
	~OGLSettingsDlg() {}
	
	int	DoModalEx(HWND hWndParent = NULL);
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
EVENTS_END

	bool OnInitDialog();
	
private:
	TabCtrlEx		m_tab;
	OGLInfoSubDlg	m_InfoDlg;
	OGLVarSubDlg	m_VarDlg;
};

#endif // OGL_SETTINGS_DLG_H