/*------------------------------------------------------------------------------*
 *	File Name: 	OFTP.h							 								*
 *	Purpose:	Handle FTP from Origin C										*
 *  Creation:	2011-05-04														*
 *  Copyright OriginLab Corp. 2011												*
 *																				*
 *	Modification Log:															*
 *  Sen 09/16/2011 ORG-3816-P1 MAKE_FILE_TRANSFER_SUPPORT_PROGRESS_BOX			*
 *------------------------------------------------------------------------------*/

#ifndef _OFTP_H
#define _OFTP_H

#ifdef __AFX_H__
	#include "MOCASCRIPT.H"
	#include "oXMLWrapper.h" /// EJP 2008-07-07 v8.0897 QA80-11788 IMPROVE_CHECK_FOR_UPDATES
	#ifdef OCHTTP_UTILS_DLL
		#define OFTP_API __declspec(dllexport)
	#else
		#define OFTP_API __declspec(dllimport)
	#endif
	#define TreeNode		OCXmlWrapperBase
	#define string			CString
	#define StringArray		CScriptMocaObject

	extern "C" {
#else
	#define OFTP_API
	#pragma dll(ohttp)	// Associate all functions below to OCHTTP_Utils.dll which must be in the Origin EXE folder
#endif	//__AFX_H__


/// EJP 2008-10-27 v8.0962 QA80-6470 ADD_FTP_TO_OC
typedef struct {
	char szHost[MAXFULLPATH];	// FTP server/host name, example: ftp.domain.com
	int nPort;					// FTP port, 21 is the common FTP port
	char szLoginName[MAXLINE];	// Account user name
	char szPassword[MAXLINE];	// Account password
	char szAccount[MAXLINE];
	char szPath[MAXFULLPATH];	// Path to enter on server after a successful login
} OFTPLOGIN;

/**@ >Network */

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ftp_dir_(global_function)
*/
OFTP_API int ftp_dir(OFTPLOGIN* ftpLogin, StringArray* psaRemoteFiles);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ftp_del_(global_function)
*/
OFTP_API int ftp_del(OFTPLOGIN* ftpLogin, LPCSTR pcszRemoteFile);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ftp_del_multi_(global_function)
*/
OFTP_API int ftp_del_multi(OFTPLOGIN* ftpLogin, StringArray* psaRemoteFiles);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ftp_get_(global_function)
*/
/// Sen 09/16/2011 ORG-3816-P1 MAKE_FILE_TRANSFER_SUPPORT_PROGRESS_BOX
//OFTP_API int ftp_get(OFTPLOGIN* ftpLogin, LPCSTR pcszRemoteFile, LPCSTR pcszLocalFile, bool bBinary = true);
OFTP_API int ftp_get(OFTPLOGIN* ftpLogin, LPCSTR pcszRemoteFile, LPCSTR pcszLocalFile, bool bBinary = true, int nMinSizeToShowProgressBox = 0);
/// End MAKE_FILE_TRANSFER_SUPPORT_PROGRESS_BOX

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ftp_put_(global_function)
*/
/// Sen 09/16/2011 ORG-3816-P1 MAKE_FILE_TRANSFER_SUPPORT_PROGRESS_BOX
//OFTP_API int ftp_put(OFTPLOGIN* ftpLogin, LPCSTR pcszLocalFile, bool bBinary = true);
OFTP_API int ftp_put(OFTPLOGIN* ftpLogin, LPCSTR pcszLocalFile, bool bBinary = true,  int nMinSizeToShowProgressBox  = 0);
/// End MAKE_FILE_TRANSFER_SUPPORT_PROGRESS_BOX

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ftp_put_multi_(global_function)
*/
OFTP_API int ftp_put_multi(OFTPLOGIN* ftpLogin, StringArray* psaLocalFiles, bool bBinary = true);
/// end ADD_FTP_TO_OC


#ifdef __AFX_H__
	} // extern "C"
#endif	//__AFX_H__

#endif // _OFTP_H
